create table if not exists web_plugin_sign (
	id int(10) not null primary key AUTO_INCREMENT,
	uin varchar(11) not null,
	group_member_id int(10) not null,
	continuous_sign int(10) not null default 0,
	total_sign int(10) not null default 0,
	last_sign_time varchar(11) null,
	status varchar(32) null,
	createdate int(11) not null
) ENGINE = InnoDB DEFAULT CHARSET = utf8 COLLATE utf8_general_ci;

create table if not exists web_plugin_sign_record (
	id int(10) not null primary key AUTO_INCREMENT,
	sign_id int(10) not null,
	year int(4) not null,
	month int(2) not null,
	days varchar(100) not null
) ENGINE = InnoDB DEFAULT CHARSET = utf8 COLLATE utf8_general_ci;

create table if not exists web_plugin_sign_break (
	id int(10) not null primary key AUTO_INCREMENT,
	sign_id int(10) not null,
	before_time varchar(10) not null,
	after_time varchar(10) not null,
	continuous_sign int(10) not null,
	days varchar(100) not null,
	is_delete int(1) not null default 0
) ENGINE = InnoDB DEFAULT CHARSET = utf8 COLLATE utf8_general_ci;

alter table web_plugin_sign add constraint sign_unique UNIQUE(uin, group_member_id);
alter table web_plugin_sign_record add constraint sign_record_unique UNIQUE(sign_id, year, month);

/**
 * 连续签到封顶奖励（比如设置为7，则表示连续签到7天和7天以上的奖励一样）
 */
replace into web_system(mark, name, value) values('plugin_sign', 'max_continuous_sign', '7');
/**
 * 签到增加的基本经验
 */
replace into web_system(mark, name, value) values('plugin_sign', 'sign_experience', '50');
/**
 * 签到增加的基本金币
 */
replace into web_system(mark, name, value) values('plugin_sign', 'sign_gold', '100');
/**
 * 连续签到奖励的经验
 */
replace into web_system(mark, name, value) values('plugin_sign', 'con_sign_add_experience', '10');
/**
 * 连续签到奖励的金币
 */
replace into web_system(mark, name, value) values('plugin_sign', 'con_sign_add_gold', '20');
/**
 * 重复签到没收的经验
 */
replace into web_system(mark, name, value) values('plugin_sign', 'repeat_experience', '10');
/**
 * 重复签到没收的金币
 */
replace into web_system(mark, name, value) values('plugin_sign', 'repeat_gold', '20');
/**
 * 补签一天收取的金币
 */
replace into web_system(mark, name, value) values('plugin_sign', 'add_sign_gold', '500');

insert into web_plugin(plugin_name, class_name, author, author_url, description, instruction, instruction_type, plugin_type, version, is_able, is_monitor_all_msg) values ('群签到', 'WebsignHandler', '冬天的秘密', 'http://bbs.itpk.cn', '群成员签到，还可补签呦。', '签到|补签|签到记录|设置最大连签|设置签到金币|设置签到经验|设置连签金币|设置连签经验|设置重签金币|设置重签经验|设置补签金币', '1|1|1|1|1|1|1|1|1|1|1', '1', '1.0', 1, 0);