<?php if (!defined('ITPK')) exit('You can not directly access the file.');

/**
 * 茉莉机器人API插件
 * @author 冬天的秘密
 * @link http://bbs.itpk.cn
 * @version 1.0
 */

class WebreplyHandler extends AbstractpluginHandler {

	/**
	 * 插件入口方法，所有插件都必须有main方法和继承AbstractpluginHandler类
	 */
	public function main() {
		$plugin = $this->pluginPer->getMeByClassname("WebreplyHandler");
		if ($plugin) {
			$instruction = $plugin['instruction'];
			list($kai, $guan) = explode("|", $instruction);
			if (DataUtil::is_empty($kai) || DataUtil::is_empty($guan)) return ReplyUtil::getReply("指令设置出错，请更正");
			$msg = (DataUtil::is_empty($this->msg) || DataUtil::is_contain("[faceArrayend]", $this->msg)) ? "[img:no]" : $this->msg;
			if ($msg == $kai) {
				$this->groupmemberPer->updatePluginId($this->object['id'], 0);
				return ReplyUtil::getReply($this->object['nick_name'] . "您好，机器人对您的回复已经开启");
			} elseif ($msg == $guan) {
				return ReplyUtil::getReply($this->object['nick_name'] . "您好，机器人对您的回复已经关闭");
			}
			return ReplyUtil::noReply();
		} else {
			return ReplyUtil::getReply("插件数据不存在");
		}
	}
} 
?>