<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
 version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
 xmlns:rss="http://purl.org/rss/1.0/"
>

<xsl:output method="html" encoding="utf-8" />
<xsl:param name="paramTitle"/>

  <xsl:template match="/">

	<html>
	<head>
		<style type="text/css">
			html {border: 2px solid gray; }
			body {font-family:Verdana,Sans-serif; font-size:8pt; 
      margin:5px; padding:0; background:#fff; color:#333333}
			form {font-family:Verdana,Sans-serif; font-size:8pt;}
			#title {
				font-family:Verdana,Sans-serif; 
				font-size:10pt;
				background-color:#D6DFF7;
				padding:0.3em;
				border-color:#999999;
				border-bottom-width:1px;
				/* border-bottom-style:dotted; */
				border-bottom-width :1px;
			}
			#description{
      margin:3px;
				padding:0.2em;
				
			}
			img{
				vertical-align :middle;
			}
			span {margin:10px;}
			#row{
				font-family:Verdana,Sans-serif; font-size: 8pt; filter: 
        progid:DXImageTransform.Microsoft.Gradient(
        gradientType=0,startColorStr=#D6DFF7,endColorStr=#EEF5FC);
			}
			table{
				cellspacing:0px;
				cellpadding:0px;
				border:0px;	
			}
			
			a {color: #222255; text-decoration: none;font-weight: bold;}
			a:visited{color: #333333; text-decoration:none;}
			a:hover { color: #6B8ADE; text-decoration: underline;}

		#title {color:#ff ;text-decoration: none; padding-bottom:4px; padding-top:4px; font-style:bold;}

		</style>
		<title><xsl:value-of select="$paramTitle"/></title></head>
		<body>
			<div id="title" style="color:#222255; font-weight: bold;">				
					<xsl:text disable-output-escaping="yes">&#60;img src="$PATH$folder.gif" /&#62;</xsl:text>

      <xsl:element name="a">
        <xsl:attribute name="href">
          <xsl:value-of select="//rdf:RDF/rss:channel/rss:link"/>
        </xsl:attribute>
        <xsl:value-of select="//rdf:RDF/rss:channel/rss:title" />
      </xsl:element>

			</div>
			<table>
				<tr style="height:2px">
					<td></td>
				</tr>
			</table>
      <div style="font-family:Verdana,Sans-serif; font-size: 8pt; filter:
      progid:DXImageTransform.Microsoft.Gradient(
      gradientType=0,startColorStr=#D6DFF7,endColorStr=#EEF5FC);">
          <xsl:apply-templates select="//rdf:RDF/rss:item"/>
      </div>
		</body>
	</html>

  </xsl:template>


<xsl:template match="//rdf:RDF/rss:channel/rss:title">

	<xsl:value-of select="."/>

</xsl:template>

<xsl:template match="//rdf:RDF/rss:channel/rss:link">

	<xsl:value-of select="."/>

</xsl:template>


<xsl:template match="rdf:RDF/rss:item">
<xsl:if test="position() &gt; 1">
<tr>
	<td>
    <span style="margin:0px;padding:0px;font-size:11px;">
	  <xsl:text disable-output-escaping="yes">&#60;img </xsl:text>
      <xsl:choose>
        <xsl:when test="string-length(rss:IconPath) &gt; 0">
		src="<xsl:value-of select="rss:IconPath"/>" "width="16" height="16"
		</xsl:when>
        <xsl:otherwise>
		src="<xsl:value-of select="rss:image"/>"
        </xsl:otherwise>
      </xsl:choose>
      <xsl:text disable-output-escaping="yes"> /&#62;</xsl:text>

      <xsl:element name="a">
        <xsl:attribute name="href">
          <xsl:value-of select="rss:link"/>
        </xsl:attribute>
        <xsl:value-of select="rss:title" />
      </xsl:element>

    </span>

        	<xsl:element name="div">
		<xsl:attribute name="id">description</xsl:attribute>
        	<xsl:value-of disable-output-escaping="yes" select="rss:description" />
    		</xsl:element>

	<hr/>
	</td>
</tr>
</xsl:if>
</xsl:template>


</xsl:stylesheet>