<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
 version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
 xmlns:rss="http://purl.org/rss/1.0/"
>

<xsl:output method="html" encoding="utf-8" />
<xsl:param name="paramTitle"/>

  <xsl:template match="/">

	<html>
	<head>
		<style type="text/css">
			html { border: 6px solid gray; }
			body {font-family:Verdana,Sans-serif; font-size:10pt; margin:0; padding:0; background:#fff; color:#000}
			form {font-family:Verdana,Sans-serif; font-size:10pt;}
			#title {
				font-family:Verdana,Sans-serif; 
				font-size:13pt;
				font-style:bold;
				background-color:#CCCCCC;
				padding:0.3em;
				border-color:#999999;
				border-bottom-width:1px;
				border-bottom-style:dotted;
				border-bottom-width :1px;
			}
			#description{
				padding:0.2em;
				
			}
			span {margin:10px;}
			td{
				font-family:Verdana,Sans-serif; font-size: 10pt;
				/*filter: progid:DXImageTransform.Microsoft.Gradient(gradientType=0,startColorStr=#D6DFF7,endColorStr=#EEF5FC);*/

			}
			table{
				cellspacing:0.3em;
			}
			/*
			a { /*color: #0002CA;*/color: black; font-weight: bold ;text-decoration: none;}
			a:visited{color: #aaaaaa; text-decoration:none;font-weight: bold}
			a:hover { color: #6B8ADE; text-decoration: underline;}
			*/
a{color:#07a;font-weight: bold ;text-decoration: none;}
a:link {color:#07a;font-weight: bold ;text-decoration: none;}
a:visited {color:#93F0F8;font-weight: bold ;text-decoration: none;}
a:hover { text-decoration: underline; color: #0066FF }

#title a {color:#000;font-weight: bold ;text-decoration: none;}

		</style>
		<title><xsl:value-of select="$paramTitle"/></title></head>
		<body>
			<div id="title">
				<span>
					<xsl:element name="a">
						<xsl:attribute name="href">
							<xsl:apply-templates select="//rdf:RDF/rss:channel/rss:link"/>
						</xsl:attribute>
						<xsl:apply-templates select="//rdf:RDF/rss:channel/rss:title"/>
					</xsl:element>
				</span>
			</div><br />
			<table>
			

			<xsl:apply-templates select="//rdf:RDF/rss:item"/>

			
			</table>
		</body>
	</html>

  </xsl:template>


<xsl:template match="//rdf:RDF/rss:channel/rss:title">

	<xsl:value-of select="."/>

</xsl:template>

<xsl:template match="//rdf:RDF/rss:channel/rss:link">

	<xsl:value-of select="."/>

</xsl:template>


<xsl:template match="rdf:RDF/rss:item">
<tr>
<td style="width:10px" width="10" valign="top"></td>
<td style="background-color:6c6c6c; width:2px" width="2" valign="top"></td>
<td>
    <xsl:element name="a">
      <xsl:attribute name="href"><xsl:value-of select="rss:link"/></xsl:attribute>
	<xsl:attribute name="title"><xsl:value-of select="rss:description" /></xsl:attribute>
      <xsl:value-of select="rss:title" />
    </xsl:element>
    <xsl:element name="br"/>
    
    <xsl:element name="div">
	<xsl:attribute name="id">description</xsl:attribute>
        <xsl:value-of select="rss:description" />
    </xsl:element>
</td>
</tr>
</xsl:template>




</xsl:stylesheet>