<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet
 version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
 xmlns:rss="http://purl.org/rss/1.0/"
>

  <xsl:output method="html" encoding="utf-8" />
  <xsl:param name="paramTitle"/>

  <xsl:template match="/">

    <html>
      <head>
        <link rel="stylesheet" href="default.css" type="text/css" />
        <style type="text/css">
          body
          {
          margin: 0px;
          padding: 0px;
          background-color: #ffffff;
          overflow: auto;
          background-attachment: fixed;
          }

          #contents
          {
          padding: 5px;
          background-color: #ffffff;
          }

          #padding-of-bottom
          {
          padding: 0px;
          margin: 0px;
          }

          #item
          {
          margin: 0px;
          padding: 2px 4px 0px 4px;
          font-size: 13px;
          height: 20px;
          }

          #item div.item_image
          {
          margin: 0;
          padding: 3px 0px 1px 4px;
          float: left;
          clear: both;
          height: 30px;
          }

          #item div.link
          {
          margin: 0;
          padding: 0px 5px 1px 5px;
          }

          #item div.link_big
          {
          margin: 0px;
          padding: 0px 0px px 0px;
          font-size: 14px;
          font-weight: bold;
          }

          #item div.author_big
          {
          color: #999999;
          font-size: 10px;
          margin: 0px;
          padding: 0px 0px 5px 6px;
          }

          #item div.author
          {
          color: #999999;
          font-size: 8px;
          margin: 0px;
          padding: 0px 0px 2px 14px;
          }

          a img {
          border-style: none;
          }

          #item a:link,
          #item a:visited {
          color: #3b3b3b;
          text-decoration: none;
          }

          #item a:focus,
          #item a:hover {
          border-bottom: 1px dotted;
          color: #ff3333;
          }

          #button_close
          {
          margin: 2px 0px 0px 2px;
          padding: 0px;
          float: right;
          }


          #button
          {
          margin: 0px 0px 0px 0px;
          padding: 0px;
          float: right;
          }

          #button_setting
          {
          margin: 0px 0px 0px 0px;
          padding: 0px;
          float: right;
          }


        </style>
        <title>
          <xsl:value-of select="$paramTitle"/>
        </title>
      </head>
      <body>
        <div id="body">
          <div id="contents">
            <div id="button_close">
            <xsl:element name="a">
              <xsl:attribute name="href">command:config</xsl:attribute>
              <xsl:text disable-output-escaping="yes">&#60;img src="$PATH$button_setting.bmp" /&#62;</xsl:text>
            </xsl:element>
            <xsl:element name="a">
              <xsl:attribute name="href">command:close</xsl:attribute>
              <xsl:text disable-output-escaping="yes">&#60;img src="$PATH$button_close.bmp" /&#62;</xsl:text>
            </xsl:element>
          </div>          
          <xsl:apply-templates select="//rdf:RDF/rss:item"/>
          </div>
          <div id="padding-of-bottom" />
          <span id="bottom_of_body" />

        </div>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="//rdf:RDF/rss:channel/rss:title">
    <xsl:value-of select="."/>
  </xsl:template>

  <xsl:template match="//rdf:RDF/rss:channel/rss:link">
    <xsl:value-of select="."/>
  </xsl:template>

  <xsl:template match="rdf:RDF/rss:item">
    <div id="item">
      <xsl:choose>
        <xsl:when test="position()=1">
          <div>
            <div class="link_big">
              <xsl:element name="a">
                <xsl:attribute name="href">
                  <xsl:value-of select="rss:link"/>
                </xsl:attribute>
                <xsl:value-of select="concat(substring(rss:title, 0, 40), '')" />
                <xsl:if test="string-length(rss:title) &gt; 41">...</xsl:if>
              </xsl:element>
            </div>
            <div class="author_big">
              [<xsl:value-of select="rss:Author" />]
            </div>
          </div>
        </xsl:when>
        <xsl:otherwise>
          <div class="item_image">
            <xsl:text disable-output-escaping="yes">&#60;img src="$PATH$item.bmp" /&#62;</xsl:text>
          </div>
          <div>
            <div class="link">
              <xsl:element name="a">
                <xsl:attribute name="href">
                  <xsl:value-of select="rss:link"/>
                </xsl:attribute>
                <xsl:value-of select="concat(substring(rss:title, 0, 40), '')" />
                <xsl:if test="string-length(rss:title) &gt; 41">...</xsl:if>
              </xsl:element>
            </div>
            <!--<div class="author">
              [<xsl:value-of select="rss:Author" />]
            </div>-->
          </div>
        </xsl:otherwise>

      </xsl:choose>
    </div>

  </xsl:template>

</xsl:stylesheet>
