﻿<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
	xmlns:rss="http://purl.org/rss/1.0/">
  <xsl:output method="html" encoding="utf-8" />
  <xsl:template match="/">
    <html>
      <head>
        <style type="text/css">
          html {
          border: 0px;
          }
          body {
          font-family:Verdana,Sans-serif;
          font-size:8pt;
          margin:0;

          padding-bottom:10px;
          padding-right:10px;
          overflow-x : hidden;
          overflow-y : auto;
          background-color: black;
          }
          form {font-family:Verdana,Sans-serif; font-size:8pt;}
          img
          {
          vertical-align :top;
          }
          table
          {
          font-family:Verdana,Sans-serif; font-size: 8pt;
          cellspacing:0px;
          cellpadding:0px;
          border: 0px;
          height: 100%;
          }
          table.content
          {
          background-repeat: repeat-y;
          width:96%;
          height:96%;
          margin-top:10px;
          margin-left:10px;
          }
          table.summary
          {
          background-repeat: repeat-y;
          width:96%;
          }
          table.content td
          {

          }

          <!-- Topic Style -->
          td.title_left
          {
          vertical-align: top;
          background-image: url(../../resource/feedviewtemplate/default/title_left.bmp);
          width: 35px;
          height: 39px;
          }
          td.title_center
          {
          font-family:Verdana,Sans-serif;
          font-size:10pt;
          background-image: url(../../resource/feedviewtemplate/default/title_center.bmp);
          height: 39px;
          vertical-align: top;
          padding-top: 11px;
          padding-left: 15px;
          background-repeat: repeat-x;
          }
          td.title_right
          {
          background-image: url(../../resource/feedviewtemplate/default/title_right.bmp);
          width: 15px;
          height: 39px;
          }
          tr.topic
          {
          font-size:8pt;
          background-repeat: repeat-y;
          padding-top:10px;
          }

          tr.topic td.topic_center span.caption
          {
          font-size:10.5pt;
          background-repeat: repeat-y;
          margin-top:0px;
          margin-bottom:0px;
          padding:0px;
          }

          tr.topic td.topic_center span.reference
          {
          margin:0xp;
          padding-top:3px;
          padding-bottom:0px;
          color:#999999;
          text-align:right;
          width:100%;
          }

          tr.topic td.topic_center span.title-reference
          {
          padding-left : 10px;
          font-size : 10.5px;
          color:#8899aa;
          }

          td.topic_left
          {
          background-image: url(../../resource/feedviewtemplate/default/topic_left.bmp);
          width: 15px;
          padding: 0px;
          }
          td.topic_center
          {
          vertical-align: top;
          padding-left: 0px;
          padding-right: 0px;
          background-image: url(../../resource/feedviewtemplate/default/topic_center.png);
          background-repeat: repeat;
          }

          td.topic_center img
          {
          margin-bottom:10px;
          margin-right:10px;
          float:left;
          }

          td.topic_right
          {
          background-image: url(../../resource/feedviewtemplate/default/topic_right.bmp);
          width: 15px;
          }
          td.bottom_left
          {
          height: 19px;
          background-image: url(../../resource/feedviewtemplate/default/bottom_left.bmp);
          width: 35px;
          }
          td.bottom_center
          {
          height: 19px;
          background-image: url(../../resource/feedviewtemplate/default/bottom_center.bmp);
          background-repeat: repeat-x;
          }
          td.bottom_right
          {
          height: 19px;
          background-image: url(../../resource/feedviewtemplate/default/bottom_right.bmp);
          width: 15px;
          }
          <!-- Topic Style -->

          <!-- Summary Style -->
          td.summary_head_left
          {
          vertical-align: top;
          background-image: url(../../resource/feedviewtemplate/default/summary_head_left.bmp);
          width: 41px;
          height: 41px;
          }
          td.summary_head_center
          {
          font-family:Verdana,Sans-serif;
          font-size:8pt;
          background-image: url(../../resource/feedviewtemplate/default/summary_head_center.bmp);
          height: 41px;
          vertical-align: top;
          padding-top: 21px;
          padding-left: 15px;
          background-repeat: repeat-x;
          font-weight:bold;
          }
          td.summary_head_right
          {
          background-image: url(../../resource/feedviewtemplate/default/summary_head_right.bmp);
          width: 16px;
          height: 41px;
          }
          td.summary_body_left
          {
          background-image: url(../../resource/feedviewtemplate/default/summary_body_left.bmp);
          width: 41px;
          padding: 0px;
          height: 414px;
          background-repeat: repeat-y;
          }
          td.summary_body_center
          {
          height: 414px;
          vertical-align: top;
          padding-top: 5px;
          padding-left: 0px;
          padding-right: 5px;
          margin:0px;
          background-image: url(../../resource/feedviewtemplate/default/summary_body_center.bmp);
          background-repeat: repeat;
          }
          td.summary_body_center img
          {
          margin-bottom:10px;
          margin-right:10px;
          }
          td.summary_body_right
          {
          height: 414px;
          background-image: url(../../resource/feedviewtemplate/default/summary_body_right.bmp);
          width: 16px;
          background-repeat: repeat-y;
          }
          td.summary_foot_left
          {
          height: 15px;
          background-image: url(../../resource/feedviewtemplate/default/summary_foot_left.bmp);
          width: 41px;
          }
          td.summary_foot_center
          {
          height: 15px;
          background-image: url(../../resource/feedviewtemplate/default/summary_foot_center.bmp);
          background-repeat: repeat-x;
          }
          td.summary_foot_right
          {
          height: 15px;
          background-image: url(../../resource/feedviewtemplate/default/summary_foot_right.bmp);
          width: 16px;
          }

          <!-- Summary Style -->
          #topic_title a {
          color: #2277cc;
          font-weight: bold;
          background-image: url(../../resource/feedviewtemplate/default/topic_icon1.png);
          background-repeat: no-repeat;
          padding-left:20px;
          }
          #topic_title a:visited {
          color: #555555;
          font-weight: bold;
          background-image: url(../../resource/feedviewtemplate/default/topic_icon2.png);
          background-repeat: no-repeat;
          padding-left:20px;
          }
          a:visited{color: #555555; }
          a:hover { color: #6B8ADE; text-decoration: underline;}
          #title {color:#ff ;text-decoration: none; padding-bottom:4px; padding-top:4px; font-style:bold;}
          #detail_link {padding-bottom:4px; padding-top:4px;}
        </style>
        <title>
          <xsl:apply-templates select="opml/head/title" />
        </title>
        <meta http-equiv="Content-Script-Type" content="text/javascript" />
        <script type="text/javascript">
          function F1()
          {
          v='.pixelTop=';
          dS='';
          sD='.style';
          y='document.body.scrollTop';
          }
          function F2()
          {
          obj='obj1';
          yy=eval(y);
          eval(dS+obj+sD+v+yy);
          setTimeout('F2()',10);
          }

          function ChangeDetail(title, link, description)
          {
          document.getElementById("detail_title").innerHTML = title;
          document.getElementById("detail_link").href = link;
          document.getElementById("detail_description").innerHTML = description;
          }
        </script>
      </head>
      <body onload="F1();F2();">
        <div style="float:left; width=70%">
          <table width="100%" cellpadding="0" cellspacing="0" border="0">
            <xsl:apply-templates select="opml/body"/>
          </table>
        </div>
        <div id='obj1' style="float:left; width=30%; position:absolute;">
          <table width="100%" cellpadding="0" cellspacing="0" border="0">
            <tr width="70%">
              <td width="30%" style="word-break: break-all;">
                <table class="summary" cellpadding="0" cellspacing="0" border="0">
                  <tr>
                    <td class="summary_head_left"></td>
                    <td class="summary_head_center">Preview</td>
                    <td class="summary_head_right"></td>
                  </tr>
                  <tr class="topic">
                    <td class="summary_body_left"></td>
                    <td class="summary_body_center">
                      <B>
                        <div id="detail_title">...</div>
                      </B>

                      <hr/>
                      <div id="detail_description">
                      </div>
                      <div style="text-align:right">
                        <a target="_blank" id="detail_link">>> Read More</a>
                      </div>
                    </td>
                    <td class="summary_body_right"></td>
                  </tr>
                  <tr class="bottom">
                    <td class="summary_foot_left"></td>
                    <td class="summary_foot_center"></td>
                    <td class="summary_foot_right"></td>
                  </tr>
                </table>
              </td>
            </tr>
          </table>
        </div>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="body">
    <tr>
      <td width="70%" style="vertical-align:top; word-break:break-all;">

        <table class="content" cellpadding="0" cellspacing="0" border="0" >
          <tr>
            <td class="title_left"></td>
            <td class="title_center">
              <a target="_blank" style="color: #222255; font-weight: bold;font-weight: bold;">
                <xsl:value-of select="/opml/head/title" />

              </a>
              <!--p>
			          <xsl:text disable-output-escaping="yes">&#60;</xsl:text>img src="title_right.bmp"
			          <xsl:text disable-output-escaping="yes">&#62;</xsl:text>
		        </p-->
            </td>
            <td class="title_right"></td>
          </tr>
          <!--Sort topic upper-->
          <xsl:choose>
            <xsl:when test="outline!=''">
              <xsl:for-each select="outline/outline">
                <xsl:sort select="@date" order="descending"/>
                <tr class="topic">
                  <td class="topic_left"></td>
                  <td class="topic_center">
                    <span id="topic_title" class="caption">
                      <xsl:element name="a">
                        <xsl:attribute name="href">
                          <xsl:value-of select="@htmlUrl" />
                        </xsl:attribute>
                        <xsl:attribute name="target">_blank</xsl:attribute>
                        <xsl:attribute name="onmouseover">
                          ChangeDetail('<xsl:value-of select="@text" />', '<xsl:value-of select="@htmlUrl" />', '<xsl:value-of disable-output-escaping="yes" select="." />')
                        </xsl:attribute>
                        <xsl:attribute name="alt">
                          <xsl:value-of select="@description" />
                        </xsl:attribute>
                        <xsl:value-of select="concat(substring(@text, 0, 40), '')" />
                        <xsl:if test="string-length(@text) &gt; 40">
                          ...
                        </xsl:if>
                      </xsl:element>
                      <span class="title-reference">
                        - <xsl:value-of select="../@text" />
                      </span>
                    </span>
                    <!--View Detail Report-->
                    <P style="margin-top:15px;margin-bottom:15px;margin-right:30px;margin-left:20px;padding-top:0px;border:1px;">
                      <xsl:value-of disable-output-escaping="yes" select="substring(., 0, 300)" />
                      <xsl:choose>
                        <xsl:when test="contains(substring(., 0, 300), 'script')">
                          <xsl:value-of disable-output-escaping="yes" select="substring(., 301)" />
                        </xsl:when>
                        <xsl:when test="contains(substring(., 0, 300), 'table')">
                          <xsl:value-of disable-output-escaping="yes" select="substring(., 301)" />
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:if test="string-length(.) &gt; 300">
                            ...
                          </xsl:if>
                        </xsl:otherwise>
                      </xsl:choose>
                      <!--View Time-->
                      <BR>
                        <span class="reference">
                          [
                          <xsl:value-of select="@date"/>
                          ]
                        </span>
                      </BR>
                    </P>
                  </td>
                  <td class="topic_right"></td>
                </tr>
              </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
              <tr class="topic">
                <td class="topic_left"></td>
                <td class="topic_center">
                  <span class="caption">
                    <xsl:element name="a">
                      The article was not found.
                    </xsl:element>
                  </span>
                  <!--View Detail Report-->
                  <P style="margin-top:10px;margin-bottom:20px;padding:0px;">
                    Please select the category again after waiting for the reading completion of the article or register the article newly.
                  </P>
                </td>
                <td class="topic_right"></td>
              </tr>
            </xsl:otherwise>
          </xsl:choose>
          <tr>
            <td class="bottom_left"></td>
            <td class="bottom_center"></td>
            <td class="bottom_right"></td>
          </tr>
        </table>
      </td>
    </tr>

  </xsl:template>

</xsl:stylesheet>