#! /usr/bin/env python
# -*- coding: utf-8 -*-

### BEGIN LICENSE
#
# Author:     Kobe Lee <xiangli@ubuntukylin.com>
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import plistlib
import json
import os
import sys
import subprocess
import traceback
import tempfile
import shutil
import time
import ConfigParser
import re

# unzip -o test.zip -d /tmp/

#-------------------common-------------------
def app_is_running(app_name):
	assert(isinstance(app_name, str));
	try:
		ps = subprocess.Popen("ps -e",stdin = subprocess.PIPE,stdout = subprocess.PIPE,stderr = subprocess.PIPE,shell = True)
		pslist = ps.stdout.read()
		pslist = pslist.lower()
		
		app_name = app_name.lower()
		for line in pslist.splitlines():
			if line.find(app_name) != -1:
				line = line.strip()
				l = line.split(" ")
				if len(l) == 0:
					continue
				if l[len(l) - 1] == app_name :
					return True
	except Exception  as e:
		print(e)
	return False

def generate_tmp_path(name):
    assert(isinstance(name, str))
    #print name#360webshield@qihoo.com
    path = tempfile.gettempdir()
    if path[len(path) - 1] != "/":
        path = path + "/"
    tmp_num = 0
    while True:
        tmp_name = str(tmp_num) + name
        if os.path.exists(path + tmp_name):
            tmp_num = tmp_num + 1
        else:
            break
    #print path#/tmp/
    #print tmp_name#0360webshield@qihoo.com
    #print path + tmp_name#/tmp/0360webshield@qihoo.com
    return path + tmp_name

def current_is_root():
    try:
        current_id = subprocess.Popen("id -ur", stdin = subprocess.PIPE, stdout = subprocess.PIPE, stderr = subprocess.PIPE, shell = True)
        id_str = current_id.stdout.read()
        id_num = int(id_str.strip())
        return id_num == 0
    except Exception as e:
        print(e)
    return False

def dir_has_file_basename(d, n):
    assert(isinstance(d, str))
    assert(isinstance(n,str))
    try:
        for item in os.listdir(d):
            pair = str.split(item, ".")
            if pair == None:
                continue
            if pair[0] == n:
                return True
        return True
    except Exception as e:
        print(e)
    return False

def fixpathend(path):
    assert(isinstance(path, str))
    if len(path) == 0:
        return ""
    if path[len(path)-1] != "/":
        path = path + "/"
    return path

def analytical_profiles_file(homedir):
    count = 0
    tmp_pro_section = []
    flag_pro_section = ''
    finalpath = ''
    app_path = '%s/.mozilla/firefox' % homedir
    profiles_path = '%s/profiles.ini' % app_path
    if os.path.exists(profiles_path):
        cfg = ConfigParser.ConfigParser()
        cfg.read(profiles_path)
        complete_section = cfg.sections()
        for section in complete_section:
            if section.startswith('Profile'):
                tmp_pro_section.append(section)
                complete_option = cfg.options(section)
                try:
                    cfg.getint(section, 'Default') == 1
                except Exception, e:
                    pass
                else:
                    flag_pro_section = section
                count += 1
        if cfg.getint('General', 'StartWithLastProfile'):
            if count == 1:
                if cfg.getint(tmp_pro_section[0], 'IsRelative') == 0:
                    finalpath = cfg.get(tmp_pro_section[0], 'Path').split('/')[-1]
                else:
                    finalpath = cfg.get(tmp_pro_section[0], 'Path')
            elif count > 1 :
                if cfg.getint(flag_pro_section, 'IsRelative') == 0:
                    finalpath = cfg.get(flag_pro_section, 'Path').split('/')[-1]
                else:
                    finalpath = cfg.get(flag_pro_section, 'Path')
            else:
                pass
        else:
            pass
    return finalpath

def get_cache_list():
    cache = None
    apt_pkg.init_config()
    apt_pkg.init_system()
    cache = apt.Cache()
    return cache

#-------------------chrome,chromium-------------------
WS360_CHROME_ID         = "ppiihldkebfpadpocmmmjljhnffdmanh"
WS360_CHROME_PKGNAME    = "360WebShield"
WS360_CHROME_PKGEXT     = "crx"

def is_supported_chrome():
    return True

def chrome_extension_is_installed(chromeProfileDir):
    try:
        #print '00000'#/home/saucy/.config/google-chrome/Default
        #print chromeProfileDir
        l = len(chromeProfileDir)
        if chromeProfileDir[l-1] != "/":
            chromeProfileDir = chromeProfileDir + "/"
        pref_file = chromeProfileDir + "Preferences"
        #print pref_file#/home/saucy/.config/google-chrome/Default/Preferences
        ws360_extension_filedir = (chromeProfileDir + "Extensions/" + WS360_CHROME_ID)
        #print ws360_extension_filedir#/home/saucy/.config/google-chrome/Default/Extensions/ppiihldkebfpadpocmmmjljhnffdmanh
        if not os.path.exists(pref_file):
            return False
        if not os.path.exists(ws360_extension_filedir):
            return False
        f = open(pref_file,'r')
        preferences = json.load(f)
        f.close()
        if (('extensions' in preferences.keys()) and ('settings' in preferences['extensions'].keys()) and (WS360_CHROME_ID in preferences['extensions']['settings'].keys())):
            return True
        return False
    except Exception as e:
#        print 'error->'
        print(e)
    return False

def get_chrome_extension_version(chromeProfileDir):
    try:
        #print chromeProfileDir#/home/saucy/.config/google-chrome/Default
        l = len(chromeProfileDir)
        if chromeProfileDir[l-1] != "/":
            chromeProfileDir = chromeProfileDir + "/"
        #print chromeProfileDir#/home/saucy/.config/google-chrome/Default/
        pref_file = chromeProfileDir + "Preferences"
        #print pref_file#/home/saucy/.config/google-chrome/Default/Preferences
        ws360_extension_filedir = (chromeProfileDir + "Extensions/" + WS360_CHROME_ID)
#        print '444'
        #print ws360_extension_filedir#/home/saucy/.config/google-chrome/Default/Extensions/ppiihldkebfpadpocmmmjljhnffdmanh
        f = open(pref_file,'r')
        preferences = json.load(f)
        f.close()
        if (('extensions' in preferences.keys()) and ('settings' in preferences['extensions'].keys()) and (WS360_CHROME_ID in preferences['extensions']['settings'].keys())) and ("manifest" in preferences['extensions']['settings'][WS360_CHROME_ID].keys()) and ("version" in preferences['extensions']['settings'][WS360_CHROME_ID]["manifest"].keys()) :
            ver = preferences['extensions']['settings'][WS360_CHROME_ID]["manifest"]["version"]
            return ver
        else:
            return "0.0.0"
    except Exception as e:
        print(e)
    return "0.0.0"

def uninstall_chrome_extension(chromeProfileDir):
    try:
        #print chromeProfileDir#/home/saucy/.config/google-chrome/Default
        l = len(chromeProfileDir)
        if chromeProfileDir[l-1] != "/":
            chromeProfileDir = chromeProfileDir + "/"
        pref_file = chromeProfileDir + "Preferences"
        #print(pref_file)#/home/saucy/.config/google-chrome/Default/Preferences
        if not os.path.exists(pref_file):
            return True
        f = open(pref_file,'r')
        preferences = json.load(f)
        f.close()
        if (('extensions' in preferences.keys()) and ('settings' in preferences['extensions'].keys()) and (WS360_CHROME_ID in preferences['extensions']['settings'].keys())):
            #print(preferences['extensions']['settings'][WS360_CHROME_ID]);
            del preferences['extensions']['settings'][WS360_CHROME_ID];
            f = open(pref_file, 'w')
            json.dump(preferences, f, separators=(', ', ':'), indent=4)
            f.close()

        ws360_extension_filedir = chromeProfileDir + "Extensions/" + WS360_CHROME_ID
        #print(ws360_extension_filedir)#/home/saucy/.config/google-chrome/Default/Extensions/ppiihldkebfpadpocmmmjljhnffdmanh

        if os.path.exists(ws360_extension_filedir):
#            print("remove '%s'" % ws360_extension_filedir)
            shutil.rmtree(ws360_extension_filedir)
        return True
    except Exception as e:
#        print '555555'
        print(e)
    return False
    
def get_package_ver_from_manifest(unpacked_dir):
	assert(isinstance(unpacked_dir, str))
	try:
		if unpacked_dir[len(unpacked_dir)-1] != "/":
			unpacked_dir = unpacked_dir + "/"
		#print unpacked_dir#/tmp/0360WebShield.crx/360WebShield/
		manifest_file = unpacked_dir + "manifest.json"
		#print manifest_file#/tmp/0360WebShield.crx/360WebShield/manifest.json
		f = open(manifest_file,'r')
		manifest = json.load(f)
		f.close()
		#print(manifest)
		ver = manifest["version"]
		#print ver#1.2.6
		#print(type(ver))#<type 'unicode'>
		return str(ver)
	except Exception as e:
		print(e)
	return "0.0"
        
def install_chrome_extension(org_ext_path,chromeProfileDir):
    '''file: /home/saucy/.config/google-chrome/Default/Preferences
       folder: /home/saucy/.config/google-chrome/Default/Extensions/ppiihldkebfpadpocmmmjljhnffdmanh/1.2.6_0/
    '''
#    print org_ext_path#/var/lib/youker-assistant-daemon/plugins/Chrome
    org_ext_path = str(org_ext_path)
    #assert(isinstance(org_ext_path, str))
    if not is_supported_chrome():
        return False
    try:
        if org_ext_path[len(org_ext_path) - 1] != "/":
            org_ext_path = org_ext_path + "/"
        #print(org_ext_path)#/home/saucy/aaa/1/Chrome/
        package_name = WS360_CHROME_PKGNAME + "." + WS360_CHROME_PKGEXT
        package_file = org_ext_path + package_name
        #print(package_file)#/home/saucy/aaa/1/Chrome/360WebShield.crx
        if not os.path.exists(package_file):
#            print("'%s' Package not found" % package_file)
            return False
        if uninstall_chrome_extension(chromeProfileDir) != True:
#            print("uninstall chrome extension failed");
            return False
        l = len(chromeProfileDir)
#        print '22222'
#        print(chromeProfileDir)#/home/saucy/.config/google-chrome/Default/
        if chromeProfileDir[l-1] != "/":
            chromeProfileDir = chromeProfileDir + "/"
        pref_file = chromeProfileDir + "Preferences"
#        print '333333333'
        #print(pref_file)#/home/saucy/.config/google-chrome/Default/Preferences
        unziped_dir = generate_tmp_path(package_name);
        if unziped_dir[len(unziped_dir)-1] != "/":
            unziped_dir = unziped_dir + "/"
#        print '44444444444'
#        print(unziped_dir)#/tmp/0360WebShield.crx/
        subprocess.call(["unzip","-q",package_file, "-d", unziped_dir])
        if not os.path.exists(unziped_dir):
            print("unzip '%s' to '%s' failed" % (package_file , unziped_dir))
            return False

        # add by kobe
        unziped_dir = unziped_dir + WS360_CHROME_PKGNAME
#        print '555555555'
        #print unziped_dir#/tmp/0360WebShield.crx/360WebShield
        version = get_package_ver_from_manifest(unziped_dir)
#        print '666666666666'
        #print(version)#1.2.6
        if version == "0.0":
            return False

        ws360_extension_dir = chromeProfileDir + "Extensions/" + WS360_CHROME_ID
        ws360_extension_filedir =  ws360_extension_dir + "/" + version + "_0" + "/"
#        print '777777777777'
        #print(ws360_extension_filedir)#/home/saucy/.config/google-chrome/Default/Extensions/ppiihldkebfpadpocmmmjljhnffdmanh/1.2.6_0/
        manifest_file = ws360_extension_filedir + "manifest.json"
#        print '8888888888'
        #print(manifest_file)#/home/saucy/.config/google-chrome/Default/Extensions/ppiihldkebfpadpocmmmjljhnffdmanh/1.2.6_0/manifest.json
        shutil.copytree(unziped_dir, ws360_extension_filedir)
        shutil.rmtree(unziped_dir)
        subprocess.call(["chmod","-R","0755",ws360_extension_dir])

        f = open(manifest_file,'r')
        manifest = json.load(f)
        f.close()

        manifest['key']='MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDHGvOy/DxW00GZ9iWXfY292XBt7lVjEJoWShpDqozrzBxsJLUbx0dEMAE2bj0FutIvrkeh/tKIcfHFBzFGOrdLgTXJW9vPat36HHrvKPII/JmY2fo4pDIURCU9gpCqSTYfVx9IRZTLOSGfhcNMMw4ViTR3FVOynbUOLF+WHAJtCwIDAQAB'

        f = open(manifest_file, 'w')
        json.dump(manifest, f, separators=(', ', ':'), indent=4)
        f.close()
        preferences = {}
        if os.path.exists(pref_file):
            f = open(pref_file)
            preferences = json.load(f)
            #print '9999'
            #print preferences
            f.close()

        if 'extensions' not in preferences.keys():
            preferences['extensions'] = {}
        if 'settings' not in preferences['extensions'].keys():
            preferences['extensions']['settings'] = {}

        installTimeFloat = time.mktime(time.localtime())
        installTime=(str(installTimeFloat).split('.'))[0] + '0000000'

        preferences['extensions']['settings'][WS360_CHROME_ID] = {}
        preferences['extensions']['settings'][WS360_CHROME_ID]["active_permissions"] = {}
        preferences['extensions']['settings'][WS360_CHROME_ID]["active_permissions"]["api"] = ["tabs"]
        preferences['extensions']['settings'][WS360_CHROME_ID]["active_permissions"]["explicit_host"] = ["http://*/*"]

        preferences['extensions']['settings'][WS360_CHROME_ID]["events"] = ["runtime.onInstalled"]
        preferences['extensions']['settings'][WS360_CHROME_ID]["from_bookmark"] = False
        preferences['extensions']['settings'][WS360_CHROME_ID]["from_webstore"] = False

        preferences['extensions']['settings'][WS360_CHROME_ID]["granted_permissions"] = {}
        preferences['extensions']['settings'][WS360_CHROME_ID]["granted_permissions"]["api"] = ["tabs"]
        preferences['extensions']['settings'][WS360_CHROME_ID]["granted_permissions"]["explicit_host"] = ["http://*/*"]
        preferences['extensions']['settings'][WS360_CHROME_ID]['install_time'] = installTime
        preferences['extensions']['settings'][WS360_CHROME_ID]['location'] = 1
        preferences['extensions']['settings'][WS360_CHROME_ID]['state'] =  1
        preferences['extensions']['settings'][WS360_CHROME_ID]['manifest'] =  manifest
        preferences['extensions']['settings'][WS360_CHROME_ID]['path'] = ws360_extension_filedir

        f = open(pref_file, 'w')
        json.dump(preferences, f, separators=(', ', ':'), indent=4)
        f.close()
        return True
    except Exception as e:
        print(e)
#        print '10101010010'
        uninstall_chrome_extension(chromeProfileDir)
    return False


#-------------------firefox-------------------
WS360_FIREFOX_ID         = "360webshield@qihoo.com"
WS360_FIREFOX_PKGNAME    = "360webshield@qihoo.com"
WS360_FIREFOX_PKGEXT     = "xpi"
#{59c81df5-4b7a-477b-912d-4e0fdf64e5f2}
#ls:chrome  chrome.manifest  components  install.js  install.rdf
def is_supported_firefox():
    return True

#firefoxExtDir: /home/saucy/.mozilla/firefox/q7tlluh2.default/extensions/
#must have / at the tail
def firefox_extension_is_installed(firefoxExtDir):
    firefox_ext_path = firefoxExtDir + WS360_FIREFOX_PKGNAME + "." + WS360_FIREFOX_PKGEXT
    #print 'firefox_ext_path->' + firefox_ext_path
    #print 'real firefox_ext_path->' + firefox_ext_path#/home/saucy/.mozilla/firefox/q7tlluh2.default/extensions/360webshield@qihoo.com.xpi
    if os.path.exists(firefox_ext_path):
        return True
    else:
        return False

def get_firefox_extension_version(firefoxExtDir):
    if firefox_extension_is_installed(firefoxExtDir) == False:
        return "0.0.0"
    firefox_ext_path = firefoxExtDir + WS360_FIREFOX_PKGNAME + "." + WS360_FIREFOX_PKGEXT
    #print 'firefox_ext_path->' + firefox_ext_path#/home/saucy/.mozilla/firefox/q7tlluh2.default/extensions/360webshield@qihoo.com.xpi
    unziped_dir = generate_tmp_path(WS360_FIREFOX_PKGNAME)
    #print 'aaaaaaaaaaaa->' + unziped_dir#/tmp/0360webshield@qihoo.com
    unziped_dir = fixpathend(unziped_dir)
    #print 'bbbbbbbbbb->' + unziped_dir#/tmp/0360webshield@qihoo.com/
    subprocess.call(["unzip","-q", firefox_ext_path, "-d", unziped_dir])
#    print '000'

    # add by kobe
#    print unziped_dir
    #unziped_dir = unziped_dir + WS360_FIREFOX_PKGNAME + '/'
    #print unziped_dir

    #print firefox_ext_path#/home/saucy/.mozilla/firefox/q7tlluh2.default/extensions/360webshield@qihoo.com.xpi
    if not os.path.exists(unziped_dir):
        print("unzip '%s' to '%s' failed" % (firefox_ext_path , unziped_dir))
        return "0.0.0"
    #cmd = "xpath " + "'" + unziped_dir + "install.rdf" + "'" + " " + "'RDF/Description/em:version/text()'"
    #print unziped_dir#/tmp/0360webshield@qihoo.com/
    #print(cmd)#xpath '/tmp/0360webshield@qihoo.com/install.rdf' 'RDF/Description/em:version/text()'
    #xpath_result = subprocess.Popen(cmd, stdin = subprocess.PIPE, stdout = subprocess.PIPE, stderr = subprocess.PIPE, shell = True)
    #ver = xpath_result.stdout.read()#readlines()#read()
    #print xpath_result.communicate()

    ver = "0.0.0"
    tmp_file = os.path.join(unziped_dir, "install.rdf")
    fp = open(tmp_file)
    line = fp.readline()
    while line:
        if "<em:version>" in line and "</em:version>" in line:
            ver = line.split(">")[1].split("<")[0]
            break;
        line = fp.readline()
    fp.close()
    print ver
    return ver


def uninstall_firefox_extension(firefoxExtDir):
    firefox_ext_path = firefoxExtDir + WS360_FIREFOX_PKGNAME + "." + WS360_FIREFOX_PKGEXT
    #print firefox_ext_path#/home/saucy/.mozilla/firefox/q7tlluh2.default/extensions/360webshield@qihoo.com.xpi
    if firefox_extension_is_installed(firefoxExtDir) == False:
        return False
    if os.path.exists(firefox_ext_path):
        os.remove(firefox_ext_path)
        return True
    else:
        return False

def install_firefox_extension(org_ext_path,firefoxExtDir):
    if not is_supported_firefox():
        return False
    if org_ext_path[len(org_ext_path) - 1] != "/":
        org_ext_path = org_ext_path + "/"
#    print(org_ext_path)
    package_name = WS360_FIREFOX_PKGNAME + "." + WS360_FIREFOX_PKGEXT
    package_file = org_ext_path + package_name
#    print(package_file)
    if not os.path.exists(package_file):
        print("'%s' Package not found" % package_file)
        return False
	if uninstall_firefox_extension(firefoxExtDir) == False:
		return False

    dest_dir_path = firefoxExtDir
#    print("333")
#    print(dest_dir_path)
    if not os.path.exists(dest_dir_path):
        os.makedirs(dest_dir_path)

    dest_path = firefoxExtDir + WS360_FIREFOX_PKGNAME + "." + WS360_FIREFOX_PKGEXT
#    print(dest_path)
    shutil.copyfile(package_file, dest_path)
    return True


#-------------------test-------------------
def test(param1, param2):
    pass
    #aa = firefox_is_installed()
    #print aa
    #bb = firefox_extension_is_installed()
    #print bb
    #get_firefox_extension_version()
    #uninstall_firefox_extension()
    #install_firefox_extension("/home/amd/桌面/test/youker-assistant/backends/youker-assistant-daemon/data/plugins/Firefox")
    get_firefox_extension_version()


    #chrome_extension_is_installed()
    #uninstall_chrome_extension()
    #install_chrome_extension("/home/saucy/aaa/1/Chrome")
    #cc = chrome_extension_is_installed()
    #print cc
    #dd = get_chrome_extension_version()
    #print 'dd->'
    #print dd


#test(0,1)





