/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.ui.editor;

import org.ayound.js.debug.ui.editor.ColorManager;
import org.ayound.js.debug.ui.editor.HtmlJsScanner;
import org.ayound.js.debug.ui.editor.HtmlJsTagScanner;
import org.ayound.js.debug.ui.editor.IHtmlJsColorConstants;
import org.ayound.js.debug.ui.editor.NonRuleBasedDamagerRepairer;
import org.ayound.js.debug.ui.editor.assist.JsContentAssistProcessor;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class HtmlJsconfiguration
extends SourceViewerConfiguration {
    private HtmlJsTagScanner tagScanner;
    private HtmlJsScanner scanner;
    private ColorManager colorManager;

    public HtmlJsconfiguration(ColorManager colorManager) {
        this.colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__html_js_comment", "__html_js_tag"};
    }

    protected HtmlJsScanner getHtmlJsScanner() {
        if (this.scanner == null) {
            this.scanner = new HtmlJsScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IHtmlJsColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    protected HtmlJsTagScanner getXMLTagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new HtmlJsTagScanner(this.colorManager);
            this.tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IHtmlJsColorConstants.TAG))));
        }
        return this.tagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getXMLTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__html_js_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__html_js_tag");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getHtmlJsScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor(IHtmlJsColorConstants.COMMIT)));
        reconciler.setDamager((IPresentationDamager)ndr, "__html_js_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__html_js_comment");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        JsContentAssistProcessor tagContentAssistProcessor = new JsContentAssistProcessor();
        assistant.setContentAssistProcessor((IContentAssistProcessor)tagContentAssistProcessor, "__dftl_partition_content_type");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(21);
        assistant.setContextInformationPopupOrientation(21);
        return assistant;
    }
}

