/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.ui.editor;

import org.ayound.js.debug.ui.editor.ColorManager;
import org.ayound.js.debug.ui.editor.HtmlJsWhitespaceDetector;
import org.ayound.js.debug.ui.editor.IHtmlJsColorConstants;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class HtmlJsScanner
extends RuleBasedScanner {
    public static final String[] KEYWORDS = new String[]{"break", "delete", "function", "return", "typeof", "case", "do", "if", "switch", "var", "catch", "else", "in", "this", "void", "continue", "false", "instanceof", "throw", "while", "debugger", "finally", "new", "true", "with", "default", "for", "null", "try"};

    public HtmlJsScanner(ColorManager manager) {
        Token procInstr = new Token((Object)new TextAttribute(manager.getColor(IHtmlJsColorConstants.PROC_INSTR)));
        IRule[] rules = new IRule[6];
        rules[0] = new SingleLineRule("<?", "?>", (IToken)procInstr);
        rules[1] = new WhitespaceRule((IWhitespaceDetector)new HtmlJsWhitespaceDetector());
        Token keywordToken = new Token((Object)new TextAttribute(manager.getColor(IHtmlJsColorConstants.KEY_WORD), null, 1));
        WordRule keywordRule = new WordRule((IWordDetector)new JsWordDetector());
        String[] stringArray = KEYWORDS;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String keyword = stringArray[n];
            keywordRule.addWord(keyword, (IToken)keywordToken);
            ++n;
        }
        rules[2] = keywordRule;
        Token stringToken = new Token((Object)new TextAttribute(manager.getColor(IHtmlJsColorConstants.STRING)));
        rules[3] = new SingleLineRule("/", "/", (IToken)stringToken);
        rules[4] = new SingleLineRule("\"", "\"", (IToken)stringToken);
        rules[5] = new SingleLineRule("'", "'", (IToken)stringToken);
        this.setRules(rules);
    }

    class JsWordDetector
    implements IWordDetector {
        JsWordDetector() {
        }

        public boolean isWordPart(char c) {
            return Character.isLetter(c);
        }

        public boolean isWordStart(char c) {
            return Character.isLetter(c);
        }
    }
}

