/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.ui;

import org.ayound.js.debug.core.JsDebugCorePlugin;
import org.ayound.js.debug.ui.internal.DebugHtmlUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JsLaunchConfigurationMainTab
extends AbstractLaunchConfigurationTab {
    private Text urlText;
    private Text portText;
    private Text browserText;
    private static final String DEFAULT_URL = DebugHtmlUtil.getDefaultDebugPath();
    private static final String DEFAULT_BROWSER = "C:\\Program Files\\Internet Explorer\\IEXPLORE.EXE";
    private static final String DEFAULT_PORT = "8088";

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("url:");
        this.urlText = new Text(composite, 2052);
        GridData urlData = new GridData(768);
        this.urlText.setLayoutData((Object)urlData);
        Button urlButton = new Button(composite, 524288);
        urlButton.setText("Browser...");
        urlButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Shell shell = new Shell();
                FileDialog dialog = new FileDialog(shell);
                dialog.setFilterExtensions(new String[]{"*.*", "*.htm", "*.html"});
                dialog.setFileName(JsLaunchConfigurationMainTab.this.urlText.getText());
                String fileName = dialog.open();
                if (fileName != null) {
                    JsLaunchConfigurationMainTab.this.urlText.setText(fileName);
                    JsLaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        Label portLabel = new Label(composite, 0);
        portLabel.setText(DEFAULT_PORT);
        this.portText = new Text(composite, 2052);
        GridData portData = new GridData();
        portData.horizontalSpan = 2;
        portData.minimumWidth = 50;
        this.portText.setLayoutData((Object)portData);
        Label browserLabel = new Label(composite, 0);
        browserLabel.setText("browser:");
        this.browserText = new Text(composite, 2052);
        this.browserText.setLayoutData((Object)new GridData(768));
        Button browserButton = new Button(composite, 524288);
        browserButton.setText("Browser...");
        browserButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Shell shell = new Shell(Display.getCurrent());
                FileDialog dialog = new FileDialog(shell);
                dialog.setFilterExtensions(new String[]{"*.exe"});
                dialog.setFileName(JsLaunchConfigurationMainTab.this.browserText.getText());
                String fileName = dialog.open();
                if (fileName != null) {
                    JsLaunchConfigurationMainTab.this.browserText.setText(fileName);
                    JsLaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.setControl((Control)composite);
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JsLaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JsLaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.browserText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JsLaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public String getName() {
        return "Js Debug";
    }

    private int getDefaultPort() {
        int defaultPort = Integer.parseInt(DEFAULT_PORT);
        while (defaultPort < 65535) {
            if (!JsDebugCorePlugin.getDefault().hasPort(defaultPort)) {
                return defaultPort;
            }
            ++defaultPort;
        }
        return -1;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.urlText.setText(configuration.getAttribute("url", DEFAULT_URL));
            this.portText.setText(configuration.getAttribute("port", String.valueOf(this.getDefaultPort())));
            this.browserText.setText(configuration.getAttribute("browser", DEFAULT_BROWSER));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("url", this.urlText.getText());
        configuration.setAttribute("port", this.portText.getText());
        configuration.setAttribute("browser", this.browserText.getText());
        this.setDirty(false);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("url", DEFAULT_URL);
        configuration.setAttribute("port", String.valueOf(this.getDefaultPort()));
        configuration.setAttribute("browser", DEFAULT_BROWSER);
    }
}

