/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Map;
import org.ayound.js.debug.resource.JsResourceManager;
import org.ayound.js.debug.server.AbstractProcessor;
import org.ayound.js.debug.server.CharsetDetector;
import org.ayound.js.debug.server.IDebugServer;
import org.ayound.js.debug.server.JsDebugResponse;
import org.ayound.js.debug.server.ResponseInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.model.IThread;
import org.mozilla.javascript.EvaluatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptProcessor
extends AbstractProcessor {
    public ScriptProcessor(String requestUrl, String postData, JsDebugResponse response, IThread thread, IDebugServer server, Map<String, String> requestHeader, ResponseInfo info) {
        super(requestUrl, postData, response, thread, server, requestHeader, info);
    }

    @Override
    public void process() {
        try {
            try {
                URL url = this.computeRemoteURL();
                String resourcePath = url.getPath();
                JsResourceManager manager = this.getServer().getJsResourceManager();
                manager.createFile(resourcePath, this.getInfo().getInputStream(), true);
                IFile scriptFile = manager.getFileByResource(resourcePath);
                String encoding = this.getInfo().getEncoding();
                if (encoding == null) {
                    CharsetDetector detector = new CharsetDetector();
                    detector.detect(scriptFile);
                    encoding = detector.getCharset();
                }
                if (encoding == null) {
                    encoding = this.getServer().getDefaultEncoding();
                }
                scriptFile.setCharset(encoding, null);
                this.getResponse().writeJsHeader(encoding);
                BufferedReader scriptStream = new BufferedReader(new InputStreamReader(scriptFile.getContents(), encoding));
                String line = null;
                StringBuffer buffer = new StringBuffer();
                while ((line = scriptStream.readLine()) != null) {
                    buffer.append(line).append("\n");
                }
                String scriptContent = buffer.toString();
                String scriptPath = scriptFile.getFullPath().toString();
                this.getServer().addResource(scriptPath);
                try {
                    this.getServer().getJsEngine().compileJs(scriptPath, scriptContent);
                }
                catch (EvaluatorException e) {
                    e.printStackTrace();
                    this.getServer().compileError(e.getMessage(), scriptPath, e.lineNumber());
                }
                this.getResponse().write(this.getServer().getJsEngine().getCompiledString(scriptPath));
                scriptContent = null;
                buffer = null;
                try {
                    scriptStream.close();
                }
                catch (IOException iOException) {
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (ProtocolException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        finally {
            this.getResponse().close();
        }
    }
}

