/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.server;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Map;
import org.ayound.js.debug.server.AbstractProcessor;
import org.ayound.js.debug.server.CharsetDetector;
import org.ayound.js.debug.server.IDebugServer;
import org.ayound.js.debug.server.JsDebugResponse;
import org.ayound.js.debug.server.ResponseInfo;
import org.eclipse.debug.core.model.IThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceProcessor
extends AbstractProcessor {
    private String method;

    public ResourceProcessor(String requestUrl, String method, String postData, JsDebugResponse response, IThread thread, IDebugServer server, Map<String, String> requestHeader, ResponseInfo info) {
        super(requestUrl, postData, response, thread, server, requestHeader, info);
        this.method = method;
    }

    @Override
    public void process() {
        try {
            try {
                URL url = this.computeRemoteURL();
                DataInputStream isResult = new DataInputStream(this.getInfo().getInputStream());
                File file = File.createTempFile("temp", "tmp");
                FileOutputStream outputStream = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                int i = -1;
                while ((i = isResult.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, i);
                }
                outputStream.flush();
                outputStream.close();
                isResult.close();
                outputStream = null;
                String encoding = this.getInfo().getEncoding();
                if (encoding == null) {
                    CharsetDetector detector = new CharsetDetector();
                    detector.detect(file);
                    encoding = detector.getCharset();
                }
                FileInputStream inputStream = new FileInputStream(file);
                this.getResponse().writeOtherHeader(url.getFile(), encoding, this.getInfo().getResponseHeader(), inputStream.available());
                if (this.getInfo().getContentType() != null && this.getInfo().getContentType().startsWith("text/")) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, encoding));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        this.getResponse().writeln(line, encoding);
                    }
                    reader.close();
                } else {
                    byte[] bytes = new byte[inputStream.available()];
                    inputStream.read(bytes);
                    this.getResponse().getOutPutStream().write(bytes);
                }
                inputStream.close();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (ProtocolException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.getResponse().close();
        }
    }
}

