/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Map;
import org.ayound.js.debug.resource.JsResourceManager;
import org.ayound.js.debug.server.AbstractProcessor;
import org.ayound.js.debug.server.CharsetDetector;
import org.ayound.js.debug.server.IDebugServer;
import org.ayound.js.debug.server.JsDebugResponse;
import org.ayound.js.debug.server.ResponseInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IThread;
import org.mozilla.javascript.EvaluatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlPageProcessor
extends AbstractProcessor {
    public HtmlPageProcessor(String requestUrl, String postData, JsDebugResponse response, IThread thread, IDebugServer server, Map<String, String> requestHeader, ResponseInfo info) {
        super(requestUrl, postData, response, thread, server, requestHeader, info);
    }

    @Override
    public synchronized void process() {
        try {
            try {
                URL url = this.computeRemoteURL();
                String resourcePath = url.getPath();
                JsResourceManager manager = this.getServer().getJsResourceManager();
                this.getServer().setDefaultEncoding(this.getInfo().getEncoding());
                manager.createFile(resourcePath, this.getInfo().getInputStream(), true);
                IFile htmlFile = manager.getFileByResource(resourcePath);
                String encoding = this.getInfo().getEncoding();
                if (encoding == null) {
                    CharsetDetector detector = new CharsetDetector();
                    detector.detect(htmlFile);
                    encoding = detector.getCharset();
                }
                htmlFile.setCharset(encoding, null);
                this.getResponse().writeHTMLHeader(encoding, this.getInfo().getResponseHeader());
                this.getResponse().writeln("<script type=\"text/javascript\">", encoding);
                InputStream inputStream = HtmlPageProcessor.class.getResourceAsStream("debug.js");
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String line = null;
                int debugLine = 2;
                try {
                    try {
                        while ((line = reader.readLine()) != null) {
                            this.getResponse().writeln(line, encoding);
                            ++debugLine;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    inputStream.close();
                    reader.close();
                }
                this.getServer().setDebugLine(debugLine);
                this.getResponse().writeln("</script>", encoding);
                StringBuffer buffer = new StringBuffer();
                BufferedReader homeInputStream = new BufferedReader(new InputStreamReader(htmlFile.getContents(), htmlFile.getCharset()));
                line = null;
                while ((line = homeInputStream.readLine()) != null) {
                    buffer.append(line).append("\n");
                }
                String scriptContent = buffer.toString();
                String scriptPath = htmlFile.getFullPath().toString();
                this.getServer().addHtmlPage(scriptPath);
                this.getServer().addResource(scriptPath);
                try {
                    this.getServer().getJsEngine().compileHtml(scriptPath, scriptContent);
                }
                catch (EvaluatorException e) {
                    this.getServer().compileError(e.getMessage(), scriptPath, e.getLineNumber());
                }
                this.getResponse().write(this.getServer().getJsEngine().getCompiledString(scriptPath));
                scriptContent = null;
                buffer = null;
                try {
                    homeInputStream.close();
                }
                catch (IOException iOException) {
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (ProtocolException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.getResponse().close();
        }
    }
}

