/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.ayound.js.debug.server.IDebugServer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class JsResourceManager {
    private IDebugServer server;
    public static final String PROJECT_NAME = "jsdebug";
    public static final String FOLDER_NAME = "tempdir";
    private String port;

    public JsResourceManager(String port) {
        this.port = port;
    }

    public static void removeDebugProject() {
        try {
            JsResourceManager.getProject().delete(true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static IProject getProject() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        if (!project.exists()) {
            try {
                project.create(null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (!project.isOpen()) {
            try {
                project.open(null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return project;
    }

    public static IFolder getTempRoot() {
        IProject project = JsResourceManager.getProject();
        IFolder tempFolder = project.getFolder(FOLDER_NAME);
        if (!tempFolder.exists()) {
            JsResourceManager.createFolder(tempFolder);
        }
        return tempFolder;
    }

    public IFolder getTempDir() {
        IProject project = JsResourceManager.getProject();
        IFolder tempFolder = project.getFolder("tempdir/" + this.port);
        if (!tempFolder.exists()) {
            JsResourceManager.createFolder(tempFolder);
        }
        return tempFolder;
    }

    public void clear() {
        IFolder folder = this.getTempDir();
        try {
            folder.delete(true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public String getResourceByFile(IFile file) {
        return file.getFullPath().toString();
    }

    public IFile getFileByResource(String resource) {
        if (resource.endsWith("/")) {
            resource = String.valueOf(resource) + "_homePage";
        }
        if (this.server.getRemoteBaseUrl().getProtocol().toLowerCase().startsWith("file")) {
            try {
                URL url = new URL(this.server.getRemoteBaseUrl(), resource);
                IFile[] results = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(url.toURI());
                if (results != null && results.length > 0) {
                    return results[0];
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        IFolder folder = this.getTempDir();
        return folder.getFile(resource);
    }

    private static void createFolder(IFolder folder) {
        IContainer parent = folder.getParent();
        if (!parent.exists()) {
            if (parent instanceof IFolder) {
                JsResourceManager.createFolder((IFolder)parent);
            } else if (parent instanceof IProject) {
                try {
                    ((IProject)parent).create(null);
                    ((IProject)parent).open(null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            folder.create(1, true, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void createFile(String resourcePath, InputStream isResult, boolean forceUpdate) {
        IFile file;
        if (resourcePath.endsWith("/")) {
            resourcePath = String.valueOf(resourcePath) + "_homePage";
        }
        if (!(file = this.getFileByResource(resourcePath)).exists()) {
            IFolder parent = (IFolder)file.getParent();
            if (!parent.exists()) {
                JsResourceManager.createFolder(parent);
            }
            if (this.server.getRemoteBaseUrl().getProtocol().toLowerCase().startsWith("file")) {
                try {
                    URL fileURL = new URL(this.server.getRemoteBaseUrl(), resourcePath);
                    file.createLink(fileURL.toURI(), 16, null);
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    file.create(isResult, true, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        } else if (forceUpdate && this.server.getRemoteBaseUrl().getProtocol().startsWith("http")) {
            try {
                file.setContents(isResult, true, true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        try {
            isResult.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public IDebugServer getServer() {
        return this.server;
    }

    public void setServer(IDebugServer server) {
        this.server = server;
    }
}

