/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.ayound.js.debug.core.JsDebugCorePlugin;
import org.ayound.js.debug.model.ExpressionModel;
import org.ayound.js.debug.model.JsDebugElement;
import org.ayound.js.debug.model.JsDebugThread;
import org.ayound.js.debug.server.JsDebugResponse;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsDebugStackFrame
extends JsDebugElement
implements IStackFrame {
    private JsDebugResponse response;
    private IVariable[] variables;
    private boolean executed = false;
    private boolean terminated = false;
    private String resource;
    private int lineNum;
    private IThread thread;
    private int charStart = -1;
    private int charEnd = -1;
    private Stack<String> expressionStack = new Stack();
    private boolean isExpression = false;
    private List<ExpressionModel> expressionResult = new ArrayList<ExpressionModel>();

    public void setCharEnd(int charEnd) {
        this.charEnd = charEnd;
    }

    public void setCharStart(int charStart) {
        this.charStart = charStart;
    }

    public void setResponse(JsDebugResponse response) {
        this.response = response;
        if (!this.expressionStack.empty()) {
            this.runExpression();
        }
    }

    public JsDebugStackFrame(IThread thread, IDebugTarget target, ILaunch launch) {
        super(target, launch);
        this.thread = thread;
        this.expressionStack.addAll(((JsDebugThread)thread).getDebugExpressions());
    }

    public int getCharEnd() throws DebugException {
        return this.charEnd;
    }

    public int getCharStart() throws DebugException {
        return this.charStart;
    }

    public int getLineNumber() throws DebugException {
        return this.lineNum;
    }

    public String getName() throws DebugException {
        if (this.executed) {
            return "<executed>" + this.resource + "[" + this.lineNum + "]";
        }
        return String.valueOf(this.resource) + "[" + this.lineNum + "]";
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public IThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.variables;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean hasVariables() throws DebugException {
        return this.variables != null && this.variables.length > 0;
    }

    public boolean canStepInto() {
        return !this.executed && !this.terminated;
    }

    public boolean canStepOver() {
        return !this.executed && !this.terminated;
    }

    public boolean canStepReturn() {
        return !this.executed && !this.terminated;
    }

    public boolean isStepping() {
        return false;
    }

    public void stepInto() throws DebugException {
        this.executed = true;
        this.response.writeStepInTo();
        this.response.close();
    }

    public void stepOver() throws DebugException {
        this.executed = true;
        this.response.writeStepOver();
        this.response.close();
        this.fireResumeEvent(2);
    }

    public void stepReturn() throws DebugException {
        this.executed = true;
        this.response.writeStepReturn();
        this.response.close();
    }

    public boolean canResume() {
        return !this.executed && !this.terminated;
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean isSuspended() {
        return false;
    }

    public void resume() throws DebugException {
        this.executed = true;
        this.response.writeResume();
        this.response.close();
        this.fireResumeEvent(1);
    }

    public void suspend() throws DebugException {
    }

    public boolean canTerminate() {
        return !this.executed && !this.terminated;
    }

    public void terminate() throws DebugException {
        this.terminated = true;
        this.response.writeTerminate();
        this.response.close();
        this.getDebugTarget().terminate();
        this.getLaunch().terminate();
        this.fireTerminateEvent();
    }

    public void setExecuted(boolean b) {
        this.executed = b;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setLineNum(int lineNum) {
        this.lineNum = lineNum;
    }

    @Override
    public void setTerminated(boolean terminated) {
        this.terminated = terminated;
    }

    public void setVariables(IVariable[] variables) {
        this.variables = variables;
    }

    public void addExpression(String expression) {
        ((JsDebugThread)this.thread).addExpression(expression);
        if (this.executed || this.terminated || this.response.isClosed()) {
            return;
        }
        if (!this.expressionStack.contains(expression)) {
            this.expressionStack.add(expression);
        }
        if (!this.isExpression) {
            this.runExpression();
        }
    }

    public void removeExpression(ExpressionModel model) {
        this.expressionResult.remove(model);
        ((JsDebugThread)this.thread).removeExpression(model.getExpression());
        JsDebugCorePlugin.getDefault().updateEval(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runExpression() {
        JsDebugStackFrame jsDebugStackFrame = this;
        synchronized (jsDebugStackFrame) {
            if (this.expressionStack.empty()) {
                this.isExpression = false;
            } else {
                this.isExpression = true;
                this.response.writeExpression(this.expressionStack.pop());
                this.response.close();
            }
        }
    }

    public void finishExpression(String expression, String result, String error) {
        for (ExpressionModel model : this.expressionResult) {
            if (!expression.equals(model.getExpression())) continue;
            this.expressionResult.remove(model);
            break;
        }
        this.expressionResult.add(new ExpressionModel(expression, result, error));
        JsDebugCorePlugin.getDefault().updateEval(this);
        if (this.isExpression) {
            this.runExpression();
        }
    }

    public List<ExpressionModel> getExpressionResult() {
        return this.expressionResult;
    }

    public void writeValue(String value) {
        this.response.writeValue(value);
        this.response.close();
    }

    public boolean isExecuted() {
        return this.executed;
    }
}

