/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.model;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.LineBreakpoint;

public class JsBreakPoint
extends LineBreakpoint {
    public String getModelIdentifier() {
        return "org.ayound.js.debug.model";
    }

    public JsBreakPoint(final IResource resource, final int lineNumber) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker("org.ayound.js.debug.core.jsMarker");
                JsBreakPoint.this.setMarker(marker);
                marker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
                marker.setAttribute("lineNumber", lineNumber);
                marker.setAttribute("org.eclipse.debug.core.id", (Object)JsBreakPoint.this.getModelIdentifier());
                marker.setAttribute("message", (Object)("Js Breakpoint: " + resource.getName() + " [line: " + lineNumber + "]"));
            }
        };
        try {
            this.run(this.getMarkerRule(resource), runnable);
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
    }

    public String getText() {
        return this.getMarker().getAttribute("message", "");
    }

    public boolean equals(Object item) {
        if (item instanceof JsBreakPoint) {
            JsBreakPoint point = (JsBreakPoint)((Object)item);
            return this.getMarker().getResource().equals((Object)point.getMarker().getResource()) && this.getMarker().getAttribute("lineNumber", 0) == point.getMarker().getAttribute("lineNumber", 0);
        }
        return false;
    }
}

