/*
 * Decompiled with CFR 0.152.
 */
package org.ayound.js.debug.launch;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLDecoder;
import org.ayound.js.debug.core.JsDebugCorePlugin;
import org.ayound.js.debug.resource.JsResourceManager;
import org.ayound.js.debug.server.JsDebugServer;
import org.ayound.js.debug.server.SocketServerUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class JsLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        final String port = configuration.getAttribute("port", String.valueOf(8088));
        String url = null;
        try {
            url = URLDecoder.decode(configuration.getAttribute("url", ""), "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        final String browser = configuration.getAttribute("browser", "");
        URL remoteUrl = null;
        try {
            if (url.startsWith("http") || url.startsWith("file")) {
                remoteUrl = new URL(url.replace(":///", "://"));
            } else if (url.charAt(1) == ':') {
                remoteUrl = new URL("file://" + url);
            } else {
                final String errorUrl = url;
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)new Shell(), (String)"Java Script Debug Failed", (String)("invalid url :" + errorUrl));
                    }
                });
            }
            ServerSocket socketServer = SocketServerUtil.createSocketServer(Integer.parseInt(port));
            if (socketServer == null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)new Shell(), (String)"Java Script Debug Failed", (String)("Js Debug Server start failed, the port of " + port + " is used."));
                    }
                });
                return;
            }
            JsDebugServer server = new JsDebugServer(launch, socketServer, remoteUrl, new JsResourceManager(String.valueOf(socketServer.getLocalPort())));
            server.start();
            JsDebugCorePlugin.getDefault().usePort(server.getPort());
            final String startUrl = String.valueOf(server.getLocalBaseUrl()) + remoteUrl.getPath().replace(" ", "+");
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        Runtime.getRuntime().exec(String.valueOf(browser) + " " + startUrl);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }
}

