/*
 * Copyright (c) 2020 HiSilicon (Shanghai) Technologies CO., LIMITED.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/** @defgroup osa  OS APIs */
/** @defgroup drivers Driver APIs */
/** @defgroup system  System management APIs */
/** @defgroup hi_wifi  WIFI APIs */
/** @defgroup iot_secure  Secure C library APIs */

#ifndef __HI_MDM_H__
#define __HI_MDM_H__
#include <hi_types.h>
#include <hi_mdm_types.h>
#include <hi_ft_nv.h>
#include <hi_sal_nv.h>
#include <hi_cpu.h>
#include <hi_isr.h>
#include <hi_msg.h>
#include <hi_time.h>
#include <hi_timer.h>
#include <hi_event.h>
#include <hi_mem.h>
#include <hi_sem.h>
#include <hi_task.h>
#include <hi_nv.h>
#include <hi_io.h>
#include <hi_stdlib.h>
#include <hi_uart.h>
#include <hi_cipher.h>
#include <hi_efuse.h>
#include <hi_flash.h>
#include <hi_crc.h>
#include <hi_upg_api.h>

#endif /* __HI_MDM_H__ */

