/*
 * Copyright (c) 2020 Huawei Device Co., Ltd.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "input_event_distributer.h"
#include "graphic_log.h"

namespace OHOS {
void InputEventDistributer::Distribute(RawEvent* events, int32_t size)
{
    for (int32_t i = 0; i < size; i++) {
        for (auto listener : rawEventListeners_) {
            listener->OnRawEvent(events[i]);
        }
    }
}
} // namespace OHOS