/*
 * Copyright (c) 2020 Huawei Device Co., Ltd.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "bundle_callback_utils.h"

namespace OHOS {
std::string ObtainErrorMessage(uint8_t errorCode)
{
    switch (errorCode) {
        case ERR_APPEXECFWK_OBJECT_NULL:
            return "ERR_APPEXECFWK_OBJECT_NULL";
        // install errcode
        case ERR_APPEXECFWK_INSTALL_FAILED_INTERNAL_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_INTERNAL_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARAM_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARAM_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_FILE_PATH_INVALID:
            return "ERR_APPEXECFWK_INSTALL_FAILED_FILE_PATH_INVALID";
        case ERR_APPEXECFWK_INSTALL_FAILED_FILE_NOT_EXISTS:
            return "ERR_APPEXECFWK_INSTALL_FAILED_FILE_NOT_EXISTS";
        case ERR_APPEXECFWK_INSTALL_FAILED_INVALID_FILE_NAME:
            return "ERR_APPEXECFWK_INSTALL_FAILED_INVALID_FILE_NAME";
        case ERR_APPEXECFWK_INSTALL_FAILED_BAD_FILE:
            return "ERR_APPEXECFWK_INSTALL_FAILED_BAD_FILE";
        case ERR_APPEXECFWK_INSTALL_FAILED_CREATE_FILE_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_CREATE_FILE_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_CREATE_CODE_DIR_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_CREATE_CODE_DIR_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_REMOVE_CODE_DIR_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_REMOVE_CODE_DIR_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_CREATE_PERMISSIONS_DIR_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_CREATE_PERMISSIONS_DIR_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_RENAME_DIR_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_RENAME_DIR_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_RENAME_FILE_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_RENAME_FILE_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_REMOVE_DATA_DIR_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_REMOVE_DATA_DIR_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_CREATE_DATA_DIR_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_CREATE_DATA_DIR_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_RECORD_INFO_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_RECORD_INFO_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_UID_AND_GID_BACKUP_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_UID_AND_GID_BACKUP_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_CHOWN_DATA_DIR_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_CHOWN_DATA_DIR_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_VERSION_DOWNGRADE:
            return "ERR_APPEXECFWK_INSTALL_FAILED_VERSION_DOWNGRADE";
        case ERR_APPEXECFWK_INSTALL_FAILED_STORE_PERMISSIONS_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_STORE_PERMISSIONS_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_INCOMPATIBLE_SIGNATURE:
            return "ERR_APPEXECFWK_INSTALL_FAILED_INCOMPATIBLE_SIGNATURE";
        case ERR_APPEXECFWK_INSTALL_FAILED_INVALID_PROVISIONINFO:
            return "ERR_APPEXECFWK_INSTALL_FAILED_INVALID_PROVISIONINFO";
        case ERR_APPEXECFWK_INSTALL_FAILED_OPERATE_SIGNED_FILE_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_OPERATE_SIGNED_FILE_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_APP_SIGNATURE_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_APP_SIGNATURE_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_PROFILE_SIGNATURE_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_PROFILE_SIGNATURE_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_INTERNAL_SIGNATURE_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_INTERNAL_SIGNATURE_ERROR";
        // parse profile
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_PROFILE_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_PROFILE_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_BUNDLENAME_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_BUNDLENAME_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_INVALID_BUNDLENAME:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_INVALID_BUNDLENAME";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_VENDOR_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_VENDOR_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_VERSIONCODE_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_VERSIONCODE_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_VERSIONNAME_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_VERSIONNAME_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_PERMISSIONS_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_PERMISSIONS_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_DEVICE_CONFIG_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_DEVICE_CONFIG_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_KEEPALIVE_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_KEEPALIVE_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_MODULENAME_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_MODULENAME_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_INVALID_MODULENAME:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_INVALID_MODULENAME";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_MODULE_DESCRIPTION_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_MODULE_DESCRIPTION_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_DEVICETYPE_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_DEVICETYPE_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_DISTRO_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_DISTRO_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_DISTRO_MODULENAME_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_DISTRO_MODULENAME_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_DISTRO_MODULETYPE_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_DISTRO_MODULETYPE_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_DISTRO_DELIVERY_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_DISTRO_DELIVERY_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_METADATA_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_METADATA_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_ABILITIES_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_ABILITIES_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_ABILITY_NAME_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_ABILITY_NAME_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_ABILITY_TYPE_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_ABILITY_TYPE_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_ABILITY_ICONPATH_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_ABILITY_ICONPATH_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_ABILITY_LABEL_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_ABILITY_LABEL_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_ABILITY_DESCRIPTION_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_ABILITY_DESCRIPTION_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_ABILITY_LAUNCHTYPE_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_ABILITY_LAUNCHTYPE_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_ABILITY_VISIBLE_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_ABILITY_VISIBLE_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_INVALID_BUNDLENAME_LENGTH:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_INVALID_BUNDLENAME_LENGTH";
        case ERR_APPEXECFWK_INSTALL_FAILED_EXCEED_MAX_LABEL_LENGTH_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_EXCEED_MAX_LABEL_LENGTH_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_EXCEED_MAX_VERSIONNAME_LENGTH_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_EXCEED_MAX_VERSIONNAME_LENGTH_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_EXCEED_MAX_METADATA_NAME_LENGTH_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_EXCEED_MAX_METADATA_NAME_LENGTH_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_EXCEED_MAX_METADATA_VALUE_LENGTH_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_EXCEED_MAX_METADATA_VALUE_LENGTH_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_EXCEED_MAX_VENDOR_LENGTH_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_EXCEED_MAX_VENDOR_LENGTH_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_EXCEED_MAX_MODULENAME_LENGTH_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_EXCEED_MAX_MODULENAME_LENGTH_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_EXCEED_MAX_ABILITYNAME_LENGTH_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_EXCEED_MAX_ABILITYNAME_LENGTH_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_EXCEED_MAX_ABILITY_DESCRIPTION_LENGTH_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_EXCEED_MAX_ABILITY_DESCRIPTION_LENGTH_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_EXCEED_MAX_ABILITY_LABEL_LENGTH_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_EXCEED_MAX_ABILITY_LABEL_LENGTH_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_EXTRACTOR_NOT_INIT:
            return "ERR_APPEXECFWK_INSTALL_FAILED_EXTRACTOR_NOT_INIT";
        case ERR_APPEXECFWK_INSTALL_FAILED_EXTRACT_HAP_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_EXTRACT_HAP_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_RESOURCE_INDEX_NOT_EXISTS:
            return "ERR_APPEXECFWK_INSTALL_FAILED_RESOURCE_INDEX_NOT_EXISTS";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_LABEL_RES_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_LABEL_RES_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_ICON_RES_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_ICON_RES_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_DESCRIPTION_RES_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_DESCRIPTION_RES_ERROR";
        case ERR_APPEXECFWK_INSTALL_FAILED_PARSE_API_VERSION_ERROR:
            return "ERR_APPEXECFWK_INSTALL_FAILED_PARSE_API_VERSION_ERROR";
        // unistall result data
        case ERR_APPEXECFWK_UNINSTALL_FAILED_INTERNAL_ERROR:
            return "ERR_APPEXECFWK_UNINSTALL_FAILED_INTERNAL_ERROR";
        case ERR_APPEXECFWK_UNINSTALL_FAILED_BUNDLE_NOT_EXISTS:
            return "ERR_APPEXECFWK_UNINSTALL_FAILED_BUNDLE_NOT_EXISTS";
        case ERR_APPEXECFWK_UNINSTALL_FAILED_DELETE_DIRS_ERROR:
            return "ERR_APPEXECFWK_UNINSTALL_FAILED_DELETE_DIRS_ERROR";
        case ERR_APPEXECFWK_UNINSTALL_FAILED_DELETE_RECORD_INFO_ERROR:
            return "ERR_APPEXECFWK_UNINSTALL_FAILED_DELETE_RECORD_INFO_ERROR";
        case ERR_APPEXECFWK_UNINSTALL_FAILED_DELETE_PERMISSIONS_ERROR:
            return "ERR_APPEXECFWK_UNINSTALL_FAILED_DELETE_PERMISSIONS_ERROR";
        case ERR_APPEXECFWK_UNINSTALL_FAILED_BUNDLE_NOT_UNINSTALLABLE:
            return "ERR_APPEXECFWK_UNINSTALL_FAILED_BUNDLE_NOT_UNINSTALLABLE";
        case ERR_APPEXECFWK_UNINSTALL_FAILED_DELETE_UID_INFO_ERROR:
            return "ERR_APPEXECFWK_UNINSTALL_FAILED_DELETE_UID_INFO_ERROR";
        case ERR_APPEXECFWK_UNINSTALL_FAILED_SEND_REQUEST_ERROR:
            return "ERR_APPEXECFWK_UNINSTALL_FAILED_SEND_REQUEST_ERROR";
        // register and serialization errorcode
        case ERR_APPEXECFWK_CALLBACK_REGISTER_FAILED:
            return "ERR_APPEXECFWK_CALLBACK_REGISTER_FAILED";
        case ERR_APPEXECFWK_CALLBACK_UNREGISTER_FAILED:
            return "ERR_APPEXECFWK_CALLBACK_UNREGISTER_FAILED";
        case ERR_APPEXECFWK_CALLBACK_GENERATE_LOCAL_SERVICEID_FAILED:
            return "ERR_APPEXECFWK_CALLBACK_GENERATE_LOCAL_SERVICEID_FAILED";
        case ERR_APPEXECFWK_CALLBACK_SERVICEID_TRANSMITTED_FAILED:
            return "ERR_APPEXECFWK_CALLBACK_SERVICEID_TRANSMITTED_FAILED";
        case ERR_APPEXECFWK_CALLBACK_NEVER_REGISTERED:
            return "ERR_APPEXECFWK_CALLBACK_NEVER_REGISTERED";
        case ERR_APPEXECFWK_CALLBACK_OBTAIN_ALL_BUNDLE_FAILED:
            return "ERR_APPEXECFWK_CALLBACK_OBTAIN_ALL_BUNDLE_FAILED";
        case ERR_APPEXECFWK_CALLBACK_NULL_CORRESPONDING_CALLBACK:
            return "ERR_APPEXECFWK_CALLBACK_NULL_CORRESPONDING_CALLBACK";
        case ERR_APPEXECFWK_CALLBACK_GET_INSTALLTYPE_FAILED:
            return "ERR_APPEXECFWK_CALLBACK_GET_INSTALLTYPE_FAILED";
        case ERR_APPEXECFWK_CALLBACK_GET_ERROR_INSTALLTYPE:
            return "ERR_APPEXECFWK_CALLBACK_GET_ERROR_INSTALLTYPE";
        case ERR_APPEXECFWK_SERIALIZATION_FAILED:
            return "ERR_APPEXECFWK_SERIALIZATION_FAILED";
        case ERR_APPEXECFWK_DESERIALIZATION_FAILED:
            return "ERR_APPEXECFWK_DESERIALIZATION_FAILED";
        case ERR_APPEXECFWK_SYSTEM_INTERNAL_ERROR:
            return "ERR_APPEXECFWK_SYSTEM_INTERNAL_ERROR";
        default: {
            return "";
        }
    }
}
} // namespace