# 内存<a name="ZH-CN_TOPIC_0000001051452208"></a>

## 基本概念<a name="section1392116583424"></a>

内存管理是开发过程中必须要关注的重要过程，它包括内存的分配、使用和回收。

良好的内存管理对于提高软件性能和可靠性有着十分重要的意义。

## 使用场景<a name="section159581619194319"></a>

针对用户态开发，OpenHarmony内存提供了一套内存系统调用接口，支持内存的申请释放、重映射、内存属性的设置等，还有C库的标准内存操作函数。

## 功能<a name="section114001032104317"></a>

**表 1**  标准C库相关接口

<a name="table198502176175"></a>
<table><thead align="left"><tr id="row7850171781719"><th class="cellrowborder" valign="top" width="15.371537153715373%" id="mcps1.2.4.1.1"><p id="p23316052015"><a name="p23316052015"></a><a name="p23316052015"></a>头文件</p>
</th>
<th class="cellrowborder" valign="top" width="51.2951295129513%" id="mcps1.2.4.1.2"><p id="p03417010208"><a name="p03417010208"></a><a name="p03417010208"></a>接口</p>
</th>
<th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.2.4.1.3"><p id="p14347010207"><a name="p14347010207"></a><a name="p14347010207"></a>功能</p>
</th>
</tr>
</thead>
<tbody><tr id="row785091771710"><td class="cellrowborder" valign="top" width="15.371537153715373%" headers="mcps1.2.4.1.1 "><p id="p73450202019"><a name="p73450202019"></a><a name="p73450202019"></a>strings.h</p>
</td>
<td class="cellrowborder" valign="top" width="51.2951295129513%" headers="mcps1.2.4.1.2 "><p id="p934008201"><a name="p934008201"></a><a name="p934008201"></a>int bcmp(const void *s1, const void *s2, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p93412018209"><a name="p93412018209"></a><a name="p93412018209"></a>比较字节序列。</p>
</td>
</tr>
<tr id="row14791155651713"><td class="cellrowborder" valign="top" width="15.371537153715373%" headers="mcps1.2.4.1.1 "><p id="p934605204"><a name="p934605204"></a><a name="p934605204"></a>strings.h</p>
</td>
<td class="cellrowborder" valign="top" width="51.2951295129513%" headers="mcps1.2.4.1.2 "><p id="p113414018209"><a name="p113414018209"></a><a name="p113414018209"></a>void bcopy(const void *src, void *dest, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p1134180102016"><a name="p1134180102016"></a><a name="p1134180102016"></a>拷贝字节序列。</p>
</td>
</tr>
<tr id="row1734319481817"><td class="cellrowborder" valign="top" width="15.371537153715373%" headers="mcps1.2.4.1.1 "><p id="p1134900205"><a name="p1134900205"></a><a name="p1134900205"></a>strings.h</p>
</td>
<td class="cellrowborder" valign="top" width="51.2951295129513%" headers="mcps1.2.4.1.2 "><p id="p18344012207"><a name="p18344012207"></a><a name="p18344012207"></a>void bzero(void *s, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p23410042015"><a name="p23410042015"></a><a name="p23410042015"></a>写入零值字节。</p>
</td>
</tr>
<tr id="row79226010178"><td class="cellrowborder" valign="top" width="15.371537153715373%" headers="mcps1.2.4.1.1 "><p id="p435705201"><a name="p435705201"></a><a name="p435705201"></a>string.h</p>
</td>
<td class="cellrowborder" valign="top" width="51.2951295129513%" headers="mcps1.2.4.1.2 "><p id="p83520042019"><a name="p83520042019"></a><a name="p83520042019"></a>void *memccpy(void *dest, const void *src, int c, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p1720911419407"><a name="p1720911419407"></a><a name="p1720911419407"></a>拷贝src 所指的内存内容前n 个字节到dest 所指的地址上。复制时检查参数c 是否出现，若是则返回dest 中值为c 的下一个字节地址。</p>
</td>
</tr>
<tr id="row1992212019173"><td class="cellrowborder" valign="top" width="15.371537153715373%" headers="mcps1.2.4.1.1 "><p id="p8355012013"><a name="p8355012013"></a><a name="p8355012013"></a>string.h</p>
</td>
<td class="cellrowborder" valign="top" width="51.2951295129513%" headers="mcps1.2.4.1.2 "><p id="p1635180162014"><a name="p1635180162014"></a><a name="p1635180162014"></a>void *memchr(const void *s, int c, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p235306203"><a name="p235306203"></a><a name="p235306203"></a>在s所指内存的前n个字节中查找c。</p>
</td>
</tr>
<tr id="row19231001174"><td class="cellrowborder" valign="top" width="15.371537153715373%" headers="mcps1.2.4.1.1 "><p id="p23560172012"><a name="p23560172012"></a><a name="p23560172012"></a>string.h</p>
</td>
<td class="cellrowborder" valign="top" width="51.2951295129513%" headers="mcps1.2.4.1.2 "><p id="p1335404201"><a name="p1335404201"></a><a name="p1335404201"></a>int memcmp(const void *s1, const void *s2, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p183518092016"><a name="p183518092016"></a><a name="p183518092016"></a>内存比较。</p>
</td>
</tr>
<tr id="row189641849111717"><td class="cellrowborder" valign="top" width="15.371537153715373%" headers="mcps1.2.4.1.1 "><p id="p758113203203"><a name="p758113203203"></a><a name="p758113203203"></a>string.h</p>
</td>
<td class="cellrowborder" valign="top" width="51.2951295129513%" headers="mcps1.2.4.1.2 "><p id="p17581112013208"><a name="p17581112013208"></a><a name="p17581112013208"></a>void *memcpy(void *dest, const void *src, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p1958102014208"><a name="p1958102014208"></a><a name="p1958102014208"></a>内存拷贝。</p>
</td>
</tr>
<tr id="row2964114919178"><td class="cellrowborder" valign="top" width="15.371537153715373%" headers="mcps1.2.4.1.1 "><p id="p85811620182012"><a name="p85811620182012"></a><a name="p85811620182012"></a>string.h</p>
</td>
<td class="cellrowborder" valign="top" width="51.2951295129513%" headers="mcps1.2.4.1.2 "><p id="p3581112042013"><a name="p3581112042013"></a><a name="p3581112042013"></a>void *memmem(const void *haystack, size_t haystacklen, const void *needle, size_t needlelen)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p4581102032018"><a name="p4581102032018"></a><a name="p4581102032018"></a>找到一个子串。</p>
</td>
</tr>
<tr id="row3965049101716"><td class="cellrowborder" valign="top" width="15.371537153715373%" headers="mcps1.2.4.1.1 "><p id="p17581820192011"><a name="p17581820192011"></a><a name="p17581820192011"></a>string.h</p>
</td>
<td class="cellrowborder" valign="top" width="51.2951295129513%" headers="mcps1.2.4.1.2 "><p id="p1058119209207"><a name="p1058119209207"></a><a name="p1058119209207"></a>void *memmove(void *dest, const void *src, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p55811020162015"><a name="p55811020162015"></a><a name="p55811020162015"></a>内存移动。</p>
</td>
</tr>
<tr id="row12421329179"><td class="cellrowborder" valign="top" width="15.371537153715373%" headers="mcps1.2.4.1.1 "><p id="p358112042016"><a name="p358112042016"></a><a name="p358112042016"></a>string.h</p>
</td>
<td class="cellrowborder" valign="top" width="51.2951295129513%" headers="mcps1.2.4.1.2 "><p id="p18581720102016"><a name="p18581720102016"></a><a name="p18581720102016"></a>void *mempcpy(void *dest, const void *src, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p25811520132017"><a name="p25811520132017"></a><a name="p25811520132017"></a>拷贝内存区域。</p>
</td>
</tr>
<tr id="row343932141715"><td class="cellrowborder" valign="top" width="15.371537153715373%" headers="mcps1.2.4.1.1 "><p id="p358152062019"><a name="p358152062019"></a><a name="p358152062019"></a>string.h</p>
</td>
<td class="cellrowborder" valign="top" width="51.2951295129513%" headers="mcps1.2.4.1.2 "><p id="p20581720152017"><a name="p20581720152017"></a><a name="p20581720152017"></a>void *memset(void *s, int c, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p258102052019"><a name="p258102052019"></a><a name="p258102052019"></a>内存初始化。</p>
</td>
</tr>
<tr id="row19344649182"><td class="cellrowborder" valign="top" width="15.371537153715373%" headers="mcps1.2.4.1.1 "><p id="p93511010206"><a name="p93511010206"></a><a name="p93511010206"></a>stdlib.h</p>
</td>
<td class="cellrowborder" valign="top" width="51.2951295129513%" headers="mcps1.2.4.1.2 "><p id="p135180172016"><a name="p135180172016"></a><a name="p135180172016"></a>void *malloc(size_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p193580102017"><a name="p193580102017"></a><a name="p193580102017"></a>申请内存。</p>
</td>
</tr>
<tr id="row923218311911"><td class="cellrowborder" valign="top" width="15.371537153715373%" headers="mcps1.2.4.1.1 "><p id="p8347042018"><a name="p8347042018"></a><a name="p8347042018"></a>stdlib.h</p>
</td>
<td class="cellrowborder" valign="top" width="51.2951295129513%" headers="mcps1.2.4.1.2 "><p id="p133415072012"><a name="p133415072012"></a><a name="p133415072012"></a>void *calloc(size_t nmemb, size_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p2342062011"><a name="p2342062011"></a><a name="p2342062011"></a>申请内存并清零。</p>
</td>
</tr>
<tr id="row612852462210"><td class="cellrowborder" valign="top" width="15.371537153715373%" headers="mcps1.2.4.1.1 "><p id="p11582162062013"><a name="p11582162062013"></a><a name="p11582162062013"></a>stdlib.h</p>
</td>
<td class="cellrowborder" valign="top" width="51.2951295129513%" headers="mcps1.2.4.1.2 "><p id="p1558211209205"><a name="p1558211209205"></a><a name="p1558211209205"></a>void *realloc(void *ptr, size_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p7582172082018"><a name="p7582172082018"></a><a name="p7582172082018"></a>重分配内存。</p>
</td>
</tr>
<tr id="row32325321910"><td class="cellrowborder" valign="top" width="15.371537153715373%" headers="mcps1.2.4.1.1 "><p id="p15582192010204"><a name="p15582192010204"></a><a name="p15582192010204"></a>stdlib.h/malloc.</p>
</td>
<td class="cellrowborder" valign="top" width="51.2951295129513%" headers="mcps1.2.4.1.2 "><p id="p458211205205"><a name="p458211205205"></a><a name="p458211205205"></a>void *valloc(size_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p6582420192014"><a name="p6582420192014"></a><a name="p6582420192014"></a>分配以页对齐的内存。</p>
</td>
</tr>
<tr id="row450114218205"><td class="cellrowborder" valign="top" width="15.371537153715373%" headers="mcps1.2.4.1.1 "><p id="p93419062018"><a name="p93419062018"></a><a name="p93419062018"></a>stdlib.h</p>
</td>
<td class="cellrowborder" valign="top" width="51.2951295129513%" headers="mcps1.2.4.1.2 "><p id="p1535303201"><a name="p1535303201"></a><a name="p1535303201"></a>void free(void *ptr)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p173511072015"><a name="p173511072015"></a><a name="p173511072015"></a>释放内存。</p>
</td>
</tr>
<tr id="row96751881817"><td class="cellrowborder" valign="top" width="15.371537153715373%" headers="mcps1.2.4.1.1 "><p id="p14351408208"><a name="p14351408208"></a><a name="p14351408208"></a>malloc.h</p>
</td>
<td class="cellrowborder" valign="top" width="51.2951295129513%" headers="mcps1.2.4.1.2 "><p id="p1735120142011"><a name="p1735120142011"></a><a name="p1735120142011"></a>size_t malloc_usable_size(void *ptr)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p153513042014"><a name="p153513042014"></a><a name="p153513042014"></a>获取从堆分配的内存块的大小。</p>
</td>
</tr>
<tr id="row46759851816"><td class="cellrowborder" valign="top" width="15.371537153715373%" headers="mcps1.2.4.1.1 "><p id="p1235140172015"><a name="p1235140172015"></a><a name="p1235140172015"></a>unistd.h</p>
</td>
<td class="cellrowborder" valign="top" width="51.2951295129513%" headers="mcps1.2.4.1.2 "><p id="p4351906203"><a name="p4351906203"></a><a name="p4351906203"></a>int getpagesize(void)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p103513010204"><a name="p103513010204"></a><a name="p103513010204"></a>获取页面大小。</p>
</td>
</tr>
<tr id="row20901907199"><td class="cellrowborder" valign="top" width="15.371537153715373%" headers="mcps1.2.4.1.1 "><p id="p1558232032010"><a name="p1558232032010"></a><a name="p1558232032010"></a>unistd.h</p>
</td>
<td class="cellrowborder" valign="top" width="51.2951295129513%" headers="mcps1.2.4.1.2 "><p id="p158232012203"><a name="p158232012203"></a><a name="p158232012203"></a>void *sbrk(intptr_t increment)</p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.2.4.1.3 "><p id="p1558212014202"><a name="p1558212014202"></a><a name="p1558212014202"></a>更改数据段大小。</p>
</td>
</tr>
</tbody>
</table>

差异接口详细说明：

-   **mmap**

    **函数原型：**

    void \*mmap\(void \*addr, size\_t length, int prot, int flags, int fd, off\_t offset\)；

    **函数功能：**申请虚拟内存。

    **参数说明：**

    <a name="table104651722114218"></a>
    <table><thead align="left"><tr id="row1346572219429"><th class="cellrowborder" valign="top" width="11.92%" id="mcps1.1.3.1.1"><p id="p146632215425"><a name="p146632215425"></a><a name="p146632215425"></a>参数</p>
    </th>
    <th class="cellrowborder" valign="top" width="88.08%" id="mcps1.1.3.1.2"><p id="p1446620227424"><a name="p1446620227424"></a><a name="p1446620227424"></a>描述</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row1346652216429"><td class="cellrowborder" valign="top" width="11.92%" headers="mcps1.1.3.1.1 "><p id="p19466122104213"><a name="p19466122104213"></a><a name="p19466122104213"></a>addr</p>
    </td>
    <td class="cellrowborder" valign="top" width="88.08%" headers="mcps1.1.3.1.2 "><p id="p1046692215426"><a name="p1046692215426"></a><a name="p1046692215426"></a>用来请求使用某个特定的虚拟内存地址。如果取NULL，结果地址就将自动分配（这是推荐的做法），否则会降低程序的可移植性，因为不同系统的可用地址范围不一样。</p>
    </td>
    </tr>
    <tr id="row8466182274215"><td class="cellrowborder" valign="top" width="11.92%" headers="mcps1.1.3.1.1 "><p id="p5466162284220"><a name="p5466162284220"></a><a name="p5466162284220"></a>length</p>
    </td>
    <td class="cellrowborder" valign="top" width="88.08%" headers="mcps1.1.3.1.2 "><p id="p17466152214420"><a name="p17466152214420"></a><a name="p17466152214420"></a>内存段的大小。</p>
    </td>
    </tr>
    <tr id="row154671722134211"><td class="cellrowborder" valign="top" width="11.92%" headers="mcps1.1.3.1.1 "><p id="p0467142204215"><a name="p0467142204215"></a><a name="p0467142204215"></a>prot</p>
    </td>
    <td class="cellrowborder" valign="top" width="88.08%" headers="mcps1.1.3.1.2 "><p id="p6467162234215"><a name="p6467162234215"></a><a name="p6467162234215"></a>用于设置内存段的访问权限，有如下权限：</p>
    <a name="ul166872913431"></a><a name="ul166872913431"></a><ul id="ul166872913431"><li>PROT_READ：允许读该内存段。</li><li>PROT_WRITE：允许写该内存段。</li><li>PROT_EXEC：允许执行该内存段。</li><li>PROT_NONE：不能访问。</li></ul>
    </td>
    </tr>
    <tr id="row173845488436"><td class="cellrowborder" valign="top" width="11.92%" headers="mcps1.1.3.1.1 "><p id="p1538474818437"><a name="p1538474818437"></a><a name="p1538474818437"></a>flags</p>
    </td>
    <td class="cellrowborder" valign="top" width="88.08%" headers="mcps1.1.3.1.2 "><p id="p92503134411"><a name="p92503134411"></a><a name="p92503134411"></a>控制程序对内存段的改变所造成的影响，有如下属性：</p>
    <a name="ul1971648144411"></a><a name="ul1971648144411"></a><ul id="ul1971648144411"><li>MAP_PRIVATE：内存段私有，对它的修改值仅对本进程有效。</li><li>MAP_SHARED：把对该内存段的修改保存到磁盘文件中。</li></ul>
    </td>
    </tr>
    <tr id="row771075312437"><td class="cellrowborder" valign="top" width="11.92%" headers="mcps1.1.3.1.1 "><p id="p187105538438"><a name="p187105538438"></a><a name="p187105538438"></a>fd</p>
    </td>
    <td class="cellrowborder" valign="top" width="88.08%" headers="mcps1.1.3.1.2 "><p id="p1871005374312"><a name="p1871005374312"></a><a name="p1871005374312"></a>打开的文件描述符。</p>
    </td>
    </tr>
    <tr id="row1624023824419"><td class="cellrowborder" valign="top" width="11.92%" headers="mcps1.1.3.1.1 "><p id="p62406387445"><a name="p62406387445"></a><a name="p62406387445"></a>offset</p>
    </td>
    <td class="cellrowborder" valign="top" width="88.08%" headers="mcps1.1.3.1.2 "><p id="p92401382448"><a name="p92401382448"></a><a name="p92401382448"></a>用以改变经共享内存段访问的文件中数据的起始偏移值。</p>
    </td>
    </tr>
    </tbody>
    </table>

    >![](public_sys-resources/icon-note.gif) **说明：** 
    >mmap与Linux实现差异详见[与Linux标准库的差异](与Linux标准库的差异.md)章节。

    **返回值：**

    -   成功返回：虚拟内存地址，这地址是页对齐。
    -   失败返回：\(void \*\)-1。


-   **munmap接口**

    **函数原型：**

    int munmap\(void \*addr, size\_t length\);

    **函数功能：**释放虚拟内存。

    **参数说明：**

    <a name="table09071025134617"></a>
    <table><thead align="left"><tr id="row11908192513464"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p186351516144710"><a name="p186351516144710"></a><a name="p186351516144710"></a>参数</p>
    </th>
    <th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1163581610472"><a name="p1163581610472"></a><a name="p1163581610472"></a>描述</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row6908112512469"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p10908325194614"><a name="p10908325194614"></a><a name="p10908325194614"></a>addr</p>
    </td>
    <td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p209081825114610"><a name="p209081825114610"></a><a name="p209081825114610"></a>虚拟内存起始位置。</p>
    </td>
    </tr>
    <tr id="row2908725174617"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p29084251467"><a name="p29084251467"></a><a name="p29084251467"></a>length</p>
    </td>
    <td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p11908152510468"><a name="p11908152510468"></a><a name="p11908152510468"></a>内存段的大小。</p>
    </td>
    </tr>
    </tbody>
    </table>

    **返回值：**

    -   成功返回0。
    -   失败返回-1。


-   **mprotect接口**

    **函数原型：**

    int mprotect\(void \*addr, size\_t length, int prot\)；

    **函数功能：**修改内存段的访问权限。

    **参数说明：**

    <a name="table12636174834719"></a>
    <table><thead align="left"><tr id="row19636124813475"><th class="cellrowborder" valign="top" width="16.42%" id="mcps1.1.3.1.1"><p id="p26364483473"><a name="p26364483473"></a><a name="p26364483473"></a>参数</p>
    </th>
    <th class="cellrowborder" valign="top" width="83.58%" id="mcps1.1.3.1.2"><p id="p13636748124717"><a name="p13636748124717"></a><a name="p13636748124717"></a>描述</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row176369484473"><td class="cellrowborder" valign="top" width="16.42%" headers="mcps1.1.3.1.1 "><p id="p763615487477"><a name="p763615487477"></a><a name="p763615487477"></a>addr</p>
    </td>
    <td class="cellrowborder" valign="top" width="83.58%" headers="mcps1.1.3.1.2 "><p id="p1763654844715"><a name="p1763654844715"></a><a name="p1763654844715"></a>内存段起始地址，必须页对齐；访问权限异常，内核将直接抛异常，kill该进程，而不会产生SIGSEGV信号给当前进程。</p>
    </td>
    </tr>
    <tr id="row17636134824716"><td class="cellrowborder" valign="top" width="16.42%" headers="mcps1.1.3.1.1 "><p id="p1163694824714"><a name="p1163694824714"></a><a name="p1163694824714"></a>length</p>
    </td>
    <td class="cellrowborder" valign="top" width="83.58%" headers="mcps1.1.3.1.2 "><p id="p463613482472"><a name="p463613482472"></a><a name="p463613482472"></a>内存段的大小。</p>
    </td>
    </tr>
    <tr id="row196361148184716"><td class="cellrowborder" valign="top" width="16.42%" headers="mcps1.1.3.1.1 "><p id="p8636184810477"><a name="p8636184810477"></a><a name="p8636184810477"></a>prot</p>
    </td>
    <td class="cellrowborder" valign="top" width="83.58%" headers="mcps1.1.3.1.2 "><p id="p474391424815"><a name="p474391424815"></a><a name="p474391424815"></a>内存段的访问权限，有如下定义：</p>
    <a name="ul333217192481"></a><a name="ul333217192481"></a><ul id="ul333217192481"><li>PROT_READ：允许读该内存段。</li><li>PROT_WRITE：允许写该内存段。</li><li>PROT_EXEC：允许执行该内存段。</li><li>PROT_NONE：不能访问。</li></ul>
    </td>
    </tr>
    </tbody>
    </table>

    **返回值：**

    -   成功返回0。
    -   失败返回-1。


-   **mremap接口**

    **函数原型：**

    void \*mremap\(void \*old\_address, size\_t old\_size, size\_t new\_size, int flags, void new\_address\)；

    **函数功能：**重新映射虚拟内存地址。

    **参数说明：**

    <a name="table35441821104912"></a>
    <table><thead align="left"><tr id="row19544132134919"><th class="cellrowborder" valign="top" width="19.35%" id="mcps1.1.3.1.1"><p id="p205459214499"><a name="p205459214499"></a><a name="p205459214499"></a>参数</p>
    </th>
    <th class="cellrowborder" valign="top" width="80.65%" id="mcps1.1.3.1.2"><p id="p4545102104911"><a name="p4545102104911"></a><a name="p4545102104911"></a>描述</p>
    </th>
    </tr>
    </thead>
    <tbody><tr id="row75451321164918"><td class="cellrowborder" valign="top" width="19.35%" headers="mcps1.1.3.1.1 "><p id="p125451321144916"><a name="p125451321144916"></a><a name="p125451321144916"></a>old_address</p>
    </td>
    <td class="cellrowborder" valign="top" width="80.65%" headers="mcps1.1.3.1.2 "><p id="p1554522104914"><a name="p1554522104914"></a><a name="p1554522104914"></a>需要扩大（或缩小）的内存段的原始地址。注意old_address必须是页对齐。</p>
    </td>
    </tr>
    <tr id="row1545172118495"><td class="cellrowborder" valign="top" width="19.35%" headers="mcps1.1.3.1.1 "><p id="p205452215498"><a name="p205452215498"></a><a name="p205452215498"></a>old_size</p>
    </td>
    <td class="cellrowborder" valign="top" width="80.65%" headers="mcps1.1.3.1.2 "><p id="p954572164910"><a name="p954572164910"></a><a name="p954572164910"></a>内存段的原始大小。</p>
    </td>
    </tr>
    <tr id="row1754512144913"><td class="cellrowborder" valign="top" width="19.35%" headers="mcps1.1.3.1.1 "><p id="p1854532184916"><a name="p1854532184916"></a><a name="p1854532184916"></a>new_size</p>
    </td>
    <td class="cellrowborder" valign="top" width="80.65%" headers="mcps1.1.3.1.2 "><p id="p85451021164911"><a name="p85451021164911"></a><a name="p85451021164911"></a>新内存段的大小。</p>
    </td>
    </tr>
    <tr id="row1545152120497"><td class="cellrowborder" valign="top" width="19.35%" headers="mcps1.1.3.1.1 "><p id="p145451221204913"><a name="p145451221204913"></a><a name="p145451221204913"></a>flags</p>
    </td>
    <td class="cellrowborder" valign="top" width="80.65%" headers="mcps1.1.3.1.2 "><p id="p2692195864912"><a name="p2692195864912"></a><a name="p2692195864912"></a>如果没有足够的空间在当前位置展开映射，则返回失败</p>
    <a name="ul14935819135019"></a><a name="ul14935819135019"></a><ul id="ul14935819135019"><li>MREMAP_MAYMOVE：允许内核将映射重定位到新的虚拟地址。</li><li>MREMAP_FIXED：mremap()接受第五个参数，void *new_address，该参数指定映射地址必须页对齐；在new_address和new_size指定的地址范围内的所有先前映射都被解除映射。如果指定了MREMAP_FIXED，还必须指定MREMAP_MAYMOVE。</li></ul>
    </td>
    </tr>
    </tbody>
    </table>

    **返回值：**

    -   成功返回：重新映射后的虚拟内存地址。
    -   失败返回：\(\(void \*\)-1\)。


