# 开发首页<a name="ZH-CN_TOPIC_0000001054927705"></a>

应用首页主要展示当前城市的空气质量概况。首页总共有两屏，每屏显示一个城市的空气质量信息：主要包括AQI指数、城市名称等，并且AQI指数值能够以环形进度条动画的形式展示出来。

1.  实现城市空气质量信息的两屏左右滑动，需要使用“swiper”组件。

    在hml文件中添加一个根节点swiper，注意每个hml文件中有且只能有一个根节点，代码片段如下：

    ```
    <swiper class="container" style="left:253px;" index="{{swiperPage}}" duration="500" onchange="swiperChange">
    </swiper>
    ```

    -   class="container"表示组件使用的样式，container是index.css文件中的一个样式类，代码如下：

        ```
        .container{
            height: 454px;
            width: 454px;
        }
        ```

        这个样式类的作用是设置组件的高度和宽度。注意在应用开发中，必须显式指定组件的高度和宽度，否则组件可能无法显示。


    -   index="\{\{swiperPage\}\}" duration="500" onchange="swiperChange" 这些代码用来设置组件的属性和事件。其中，duration="500" 表示设置swiper的页面滑动的动画时长为500ms。
    -   index="\{\{swiperPage\}\}"设置了swiper子组件索引值，\{\{swiperPage\}\}这种写法表示index的值是和js代码中的swiperPage变量动态绑定的，index的值会随着swiperPage变动而改变。
    -   onchange="swiperChange" 设置了swiper组件的change事件和函数swiperChange绑定，对应的js代码如下：

        ```
        //引入router模块，用户页面跳转
        import router from'@system.router'
        export default {
            //定义参数
            data: {
              swiperPage:0 //默认是第一页
            },
            onInit () {
            },
            //swiper滑动回调事件，保存当前swiper的index值，每次滑动都会将index值保存在swiperPage变量中
            swiperChange (e) {
                this.swiperPage = e.index;
            }
        }
        ```


2.  设置每个城市信息为一屏，在每一屏内，要展示4种信息，分别要使用不同的控件进行展示。

    在swiper中添加两个子组件stack，每个stack组件内分别添加text、image、progress组件来显示对应的信息 ，hml文件如下：

    ```
    <!--根组件为swiper，只支持一个根组件-->
     <swiper class="container" style="left:253px;" index="{{swiperPage}}" duration="500" onchange="swiperChange">
        <!--第一屏-->
        <stack class="container">
            <text></text>------城市
            <text></text>------空气质量
            <progress></progress>-----进度条
            <image></image>-------云朵图片
            <text></text>--------AQI数值
            <text>AQI</text>------AQI
        </stack>
        <!--第二屏-->
        <stack class="container">
            <text></text>
            <text></text>
            <progress></progress>
            <image></image>
            <text></text>
            <text></text>
        </stack>
    </swiper>
    ```

3.  所有组件设置样式、动画效果和数据动态绑定，完整代码如下所示：

    -   **index.hml文件**

    ```
    <!--根组件为swiper，只支持一个根组件-->
     <swiper class="container" style="left:253px;" index="{{swiperPage}}" duration="500" onchange="swiperChange">
        <!--第一屏-->
        <stack class="container">
            <!--显示空气质量和当前城市-->
            <text class="airquality" style="color:{{textColor1}};">{{airData[0].airQuality}}</text>
            <text class="location-text">{{airData[0].location}}</text>
            <!--根据AQI的值，显示动画效果,通过在js中动态改变percent1的值来实现-->
            <progress class="circleProgress"style="color:{{textColor1}};background-Color:{{bgColor1}};"type="arc"onclick="openDetail"percent="{{percent1}}"></progress>
            <image class="image"src="{{src1}}"></image>
            <!--空气质量指数，动态获取绑定数据-->
            <text class="pm25-value">{{airData[0].detailData}}</text>
            <text class="pm25-name">AQI</text>
        </stack>
        <!--第二屏-->
        <stack class="container">
            <text class="airquality"style="color:{{textColor2}};">{{airData[1].airQuality}}</text>
            <text class="location-text">{{airData[1].location}}</text>
            <progress class="circleProgress"style="color: {{textColor2}};background-Color:{{bgColor2}};"type="arc"onclick="openDetail"percent="{{percent2}}"></progress>
            <image class="image"src="{{src2}}"></image>
            <text class="pm25-value">{{airData[1].detailData}}</text>
            <text class="pm25-name">AQI</text>
        </stack>
    </swiper>
    ```

    -   **index.css文件**

    css文件中定义了许多class，每个class用于定义组件的位置、大小、字体、颜色、背景色等信息。同时，每一个子组件都叠加在父组件中，也就是说父组件的样式会影响子组件的呈现。

    ```
    .pm25-value{
        text-align:center;
        font-size:38px;
        color:#f0ffff;
        width:454px;
        height:50px;
        top:275px;
    }
    .pm25-name{
        text-align:center;
        color:#a2c4a2;
        width:454px;
        height:50px;
        top:335px;
    }
    .location-text{
        text-align:center;
        color:#f0ffff;
        width:454px;
        height:50px;
        top:20px;
    }
    .container{
        height: 454px;
        width: 454px;;
    }
    .circleProgress{
        centerX:227px;
        centerY:250px;
        radius:180px;
        startAngle:198;
        totalAngle:320;
        strokeWidth:45;
        width:454px;
        height:454px;
    }
    .image{
        top:390px;
        left:217px;
        width:32px;
        height:32px;
    }
    .airquality{
        top:220px;
        text-align: center;
        width:454px;
        height:40px;
    }
    
    ```

    -   **index.js:**

    js文件主要用于实现App应用的逻辑交互。在本页面js文件中，需要实现如下功能：根据数值动态改变文字、进度条颜色；国际化功能；页面跳转；播放动画。

    ```
    //引入router模块，用户页面跳转
    import router from'@system.router'
    export default {
        //定义参数
        data: {
          textColor1:'#00ff00',//文字颜色
          textColor2:'#00ff00',
          bgColor1:'#669966',//背景颜色
          bgColor2:'#669966',
          swiperPage:0,
          percent1:0,//进度条进度
          percent2:0,
          src1:'common/cloud_green.png',
          src2:'common/cloud_green.png',
          airData: [{
            location: 'HangZhou',
            airQuality: 'Good',
            detailData: 10
          }, {
            location: 'ShangHai',
            airQuality: 'Unhealth',
            detailData:90
          }]
        },
        onInit () {
            //国际化处理，通过$t函数获取对应的国际化内容，国际化文件请自行添加配置
            this.airData[0].location = this.$t(this.airData[0].location);
            this.airData[1].location = this.$t(this.airData[1].location);
            this.airData[0].airQuality = this.$t(this.airData[0].airQuality);
            this.airData[1].airQuality = this.$t(this.airData[1].airQuality);
            if(this.airData[0].detailData > 100){  //根据指标值显示不同的颜色问题和图片
                this.src1 = "common/cloud_red.png";
                this.textColor1 = '#ff0000';//显示红色文字
                this.bgColor1 = '#9d7462';
            } else if(50 < this.airData[0].detailData &&  this.airData[0].detailData <= 100){
                this.src1 = "common/cloud_yellow.png";
                this.textColor1 = '#ecf19a';//显示黄色文字
                this.bgColor1 = '#9d9d62';
            }
            if(this.airData[1].detailData > 100){
                this.src2 = "common/cloud_red.png";
                this.textColor2 = '#ff0000';
                this.bgColor2 = '#9d7462';
           } else if(50 < this.airData[1].detailData && this.airData[1].detailData <= 100){
                this.src2 = "common/cloud_yellow.png";
                this.textColor2 = '#ecf19a';
                this.bgColor2 = '#9d9d62';
          }
          if(this.selectedCityIndex){
               this.swiperPage = this.selectedCityIndex;
          }
        },
        onShow () {  //页面显示的时候一些处理逻辑
            var self = this;
            var time = 1000/(self.airData[self.swiperPage].detailData);//1s播放完动画
            if(time == 0){
                time = 100;
            }
           //环形进度条动画效果，启动一个定时器，间隔一定的时间（时间根据AQI的值计算而来）改变一下进度条的进度，1s内完成动画的播放。
            var interval = setInterval(function () {
                if ((self.swiperPage==0?self.percent1:self.percent2) >= self.airData[self.swiperPage].detailData) {
                    clearInterval(interval);
                    return;
                }
                if(self.swiperPage == 0){
                    self.percent1++;
                }else{
                    self.percent2++
                }
            }, time)
        },
        //跳转到详情页
        openDetail () {
          router.replace({
            uri:'pages/detail/detail',
            params:{selectedCityIndex:this.swiperPage}//选中的城市
          });
        },
        //swiper滑动回调事件，保存当前swiper的index值，从详情页返回直接跳转到swiper的指定页
        swiperChange (e) {
            this.swiperPage = e.index;
            var self = this;
            var time = 1000/(self.airData[self.swiperPage].detailData);
            if(time == 0){
                time = 100;
            }
            //第一次滑动到页面，播放动画
            var interval = setInterval(function () {
                let percent = (self.swiperPage==0?self.percent1:self.percent2);
                if (percent >= self.airData[self.swiperPage].detailData) {
                   clearInterval(interval);
                   return;
                }
                if(self.swiperPage==0){
                    self.percent1++;
                }else{
                    self.percent2++;
                }   
            }, time)
        }
    }
    ```


