# 开发详情页<a name="ZH-CN_TOPIC_0000001054727679"></a>

详情页是空气质量指标（CO、NO2、PM10、PM2.5、SO2）详细数据的展示。因此，使用多个text组件来展示即可；另外为实现页面上下连续滑动效果，选择list组件；需要注意的是list子组件必须是list-item，并且可以有多个。该页面实现较为简单，主要是页面排版和样式的处理，详细代码如下：

## detail.hml<a name="section1039826103212"></a>

```
<list style="top:67px;left:320px;width:321px;height:350px;">
    <list-item style="width:321px;height:300px;">
        <div style="width: 321px;height:300px;background-color:#000000;flex-direction:column;align-items:flex-start;">
        <text style="width:321px;height:40px; color:#dcdcdc;">{{location}}</text>
        <div class="line-div"></div>
        <!-显示所有指标值-->
        <div class="info-div-width-height" style="margin-top:10px;">
            <text class="gas-name">CO</text>
            <text class="gas-value">{{airData[0]}}</text>
        </div>
        <div class="info-div-width-height" style="margin-top:10px;">
            <text class="gas-name">NO2</text>
            <text class="gas-value">{{airData[1]}}</text>
        </div>
        <div class="info-div-width-height" style="margin-top:10px;">
            <text class="gas-name">PM10</text>
            <text class="gas-value">{{airData[2]}}</text>
        </div>
        <div class="info-div-width-height" style="margin-top:10px;">
            <text class="gas-name">PM2.5</text>
            <text class="gas-value">{{airData[3]}}</text>
        </div>
        <div class="info-div-width-height" style="margin-top:10px;">
            <text class="gas-name">SO2</text>
            <text class="gas-value">{{airData[4]}}</text>
        </div>
        </div>
    </list-item>
    <list-item style="width:321px;height:220px;">
        <div style="width:321px;height:220px;background-color:#000000;flex-direction:column;align-items:flex-start;">
            <!-更新时间-->
            <text class="config-info">{{updated}}:{{updateStatus}}</text>
            <!-数据源-->
            <text class="config-info">{{dataSourceName}}:{{dataSource}}</text>
            <div class="line-div"></div>
            <!-页面跳转按钮-->
            <div style="width:321px; height:55px;align-items:center; margin-top:20px;">
                <input type="button"value="History" style="border-width: 3px;margin-left:10px; border-color: #90ee90;width:146px;height:50;"onclick="openHistory"/>
                <input type="button"value="Close" style="border-width: 3px;margin-left:5px; border-color:#ff0000;width:146px;height:50;"onclick="backMain"/>
            </div>
        </div>
    </list-item>
</list>
```

## detail.css<a name="section4931125119322"></a>

```
.line-div{
    background-color:#f5fffa;
    height:2px;
    width:454px;
}
.info-div-width-height{
    width:321px;
    height:60px;
    margin-top: 20px;
}
.gas-name{
    color:#f5fffa;
    width:160px;
    height:30px;
}
.gas-value{
    text-align:right;
    color:#00fa9a;
    width:160px;
    height:30px;
}
.config-info {
    height:40px;
    width:321px;
    color:#f5fffa;
}
```

## detail.js<a name="section1547613143337"></a>

```
import router from'@system.router'
export default {
    data:{  //初始化信息
        location:"HangZhou",
        udpateStatus:"1h ago",
        dataSource:"tianqi.com",
        updateTime:"15:13",
        updated:'Updated',
        dataSourceName:'Data Source',
        sampledOn:'Sampled on',
        cityIndex:0,
        airData:['100', '90', '120', '50', '150', '40', '25']
    },
    onInit(){
        //国际化信息处理
        this.location = this.$t(this.location);
        this.updated = this.$t("updated");
        this.dataSourceName = this.$t("dataSourceName");
        this.sampledOn = this.$t("sampledOn");
        this.monitoringStation = this.$t("monitoringStation");
        if(this.selectedCityIndex != null){  //保存主页传过来的城市信息
            this.cityIndex= this.selectedCityIndex;
        }
    },
    openHistroy(){  //跳转到历史页
        router.replace({
            uri:'pages/history/history'
        });
    },
    backMain(){  //返回主页，并将选择的城市信息带回
        router.replace({
            uri:'pages/index/index',
            params:{selectedCityIndex:this.cityIndex}
        });
    }
}
```

