# 开发历史页<a name="ZH-CN_TOPIC_0000001055687636"></a>

历史页以图表的形式展示一周内空气质量指标值。在本页面，考虑显示效果，使用多个div替代chart组件来实现图表功能，详细代码如下：

## history.hml<a name="section275215487291"></a>

```
<list style="width:321px;height:321px;top:67px;left:320px;">
    <list-item class="info-list-item">
        <div style="width:321px;height:80px;flex-direction:column;align-items:flex-start;">
             <text class="div-info-historical-data">{{historicalData}}</text>
        </div>
    </list-item>
    <!--使用for属性来动态生成listitem，datasets对应history.js中的datasets变量，根据变量数组中元素个数来创建组件-->
    <list-item style="width:321px;height:160px;"for="{{datasets}}">
       <div style="width:321px;height:160px;flex-direction:column;">
       <div style="width:321px;height:2px;background-color:#f5fffa;"></div>
       <!--$item是datasets中的子元素-->
       <text class="gas-name">{{$item}}</text>
       <div style="width:321px;height:100px;margin-top:4px;justify-content:flex-start;align-items:flex-end;">
          <!--示例中的颜色为固定值，实际开发中可以考虑动态绑定-->
          <div style="width:21px;margin-left:21px;height:10px;backgroundColor:#00ff00;"></div>
          <div style="width:21px;margin-left:21px;height:20px;;backgroundColor:#00ff00;"></div>
          <div style="width:21px;margin-left:21px;height:90px;backgroundColor:#ff0000;"></div>
          <div style="width:21px;margin-left:21px;height:80px;backgroundColor:#ff0000;"></div>
          <div style="width:21px;margin-left:21px;height:60px;backgroundColor:#999999;"></div>
          <div style="width:21px;margin-left:21px;height:50px;backgroundColor:#999999;"></div>
          <div style="width:21px;margin-left:21px;height:100px;backgroundColor:#ff0000;"></div>
      </div>
      <!--表格中的X轴下标采用图片-->
      <image style="width:321px;height:20px;"src="common/week.png"></image>
      </div>
   </list-item>
   <list-item class="info-list-item">
       <!--返回详情页按钮-->
       <input type="button"value="Back"style="border-width:2px;border-color:#90ee90;width:256px;height:60px;margin-left: 30px;"onclick="backDetail"/>
   </list-item>
</list>
```

## history.css<a name="section2589154215301"></a>

```
.div-info-location{
    color:#dcdcdc;
    width:321px;
    height:40px;
}
.div-info-historical-data{
    color:#f5fffa;
    width:321px;
    height:40px;
}
.gas-name{
    color:#f0ffff;
    text-align:right;
    width:321px;
    height:32px;
}
.info-list-item{
    width:321px;
    height:80px;
}
```

## history.js<a name="section163410883117"></a>

```
import router from'@system.router'
module.exports = {
    data: {
        historicalData:"historicalData",
        datasets:["CO","O3","NO2","NO","PM25","SO2"]
    },
    onInit(){
        //国际化信息处理
        this.historicalData = this.$t(this.historicalData);
    },
    backDetail(){
        router.replace({  //返回详情页
            uri:'pages/detail/detail'
        });
    }
}
```

