# UTILS<a name="EN-US_TOPIC_0000001055308029"></a>

## **Overview**<a name="section174281912084824"></a>

Provides functions and data structures related to system operations, such as string conversion and I/O, string operations, process operations and so on. 

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section294516801084824"></a>

## Files<a name="files"></a>

<a name="table811146797084824"></a>
<table><thead align="left"><tr id="row1553152604084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1029903824084824"><a name="p1029903824084824"></a><a name="p1029903824084824"></a>File Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1902313881084824"><a name="p1902313881084824"></a><a name="p1902313881084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row897378773084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1379967362084824"><a name="p1379967362084824"></a><a name="p1379967362084824"></a><a href="bitsperlong-h.md">bitsperlong.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1502679099084824"><a name="p1502679099084824"></a><a name="p1502679099084824"></a>Defines the number of bits of the long data type. </p>
</td>
</tr>
<tr id="row149826180084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1749292084824"><a name="p1749292084824"></a><a name="p1749292084824"></a><a href="errno-h.md">errno.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p809991645084824"><a name="p809991645084824"></a><a name="p809991645084824"></a>Defines error codes. </p>
</td>
</tr>
<tr id="row1425205404084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p866252777084824"><a name="p866252777084824"></a><a name="p866252777084824"></a><a href="crypt-h.md">crypt.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p33448104084824"><a name="p33448104084824"></a><a name="p33448104084824"></a>Encrypts data. </p>
</td>
</tr>
<tr id="row1867105809084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1182074580084824"><a name="p1182074580084824"></a><a name="p1182074580084824"></a><a href="ctype-h.md">ctype.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1350968947084824"><a name="p1350968947084824"></a><a name="p1350968947084824"></a>Provides functions used for parameter identification. </p>
</td>
</tr>
<tr id="row818529766084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p837823238084824"><a name="p837823238084824"></a><a name="p837823238084824"></a><a href="fmtmsg-h.md">fmtmsg.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p593336161084824"><a name="p593336161084824"></a><a name="p593336161084824"></a>Provides a function for printing formatted messages. </p>
</td>
</tr>
<tr id="row494913205084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1746520960084824"><a name="p1746520960084824"></a><a name="p1746520960084824"></a><a href="fnmatch-h.md">fnmatch.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p782611408084824"><a name="p782611408084824"></a><a name="p782611408084824"></a>Provides a function for checking whether a specified string matches a string that contains wildcards. </p>
</td>
</tr>
<tr id="row71944272084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1047183799084824"><a name="p1047183799084824"></a><a name="p1047183799084824"></a><a href="getopt-h.md">getopt.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1520600487084824"><a name="p1520600487084824"></a><a name="p1520600487084824"></a>Provides functions and data structures, such as command-line argument parsing. </p>
</td>
</tr>
<tr id="row451440258084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p179564170084824"><a name="p179564170084824"></a><a name="p179564170084824"></a><a href="inttypes-h.md">inttypes.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p779180216084824"><a name="p779180216084824"></a><a name="p779180216084824"></a>Provides functions and related data structures for conversion between character strings and plural. </p>
</td>
</tr>
<tr id="row1483038361084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1581483233084824"><a name="p1581483233084824"></a><a name="p1581483233084824"></a><a href="limits-h.md">limits.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1979405267084824"><a name="p1979405267084824"></a><a name="p1979405267084824"></a>Declares commonly used macro values. </p>
</td>
</tr>
<tr id="row535327521084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1783620772084824"><a name="p1783620772084824"></a><a name="p1783620772084824"></a><a href="monetary-h.md">monetary.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1702034287084824"><a name="p1702034287084824"></a><a name="p1702034287084824"></a>Provides functions for converting monetary values. </p>
</td>
</tr>
<tr id="row1366974272084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p971933904084824"><a name="p971933904084824"></a><a name="p971933904084824"></a><a href="search-h.md">search.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1518613431084824"><a name="p1518613431084824"></a><a name="p1518613431084824"></a>Provides functions and related data structures, such as creating, destroying, or searching for a hash table. </p>
</td>
</tr>
<tr id="row1192295990084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p654609390084824"><a name="p654609390084824"></a><a name="p654609390084824"></a><a href="stdarg-h.md">stdarg.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1471670957084824"><a name="p1471670957084824"></a><a name="p1471670957084824"></a>Provides functions and data structures, such as applying for and ending a variable-length argument list and obtaining an argument type. </p>
</td>
</tr>
<tr id="row442032525084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1553072695084824"><a name="p1553072695084824"></a><a name="p1553072695084824"></a><a href="stdlib-h.md">stdlib.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p757994681084824"><a name="p757994681084824"></a><a name="p757994681084824"></a>Declares common functions used for performing I/O operations. </p>
</td>
</tr>
<tr id="row1050140676084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p197145112084824"><a name="p197145112084824"></a><a name="p197145112084824"></a><a href="string-h.md">string.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p836375600084824"><a name="p836375600084824"></a><a name="p836375600084824"></a>Declares commonly used functions for string operations. </p>
</td>
</tr>
<tr id="row43947033084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1572278432084824"><a name="p1572278432084824"></a><a name="p1572278432084824"></a><a href="strings-h.md">strings.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1618974576084824"><a name="p1618974576084824"></a><a name="p1618974576084824"></a>Declares commonly used functions for byte sequence operations. </p>
</td>
</tr>
<tr id="row1437656429084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p162242810084824"><a name="p162242810084824"></a><a name="p162242810084824"></a><a href="unistd-h.md">unistd.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p700344324084824"><a name="p700344324084824"></a><a name="p700344324084824"></a>Provides functions and data structures related to process operations. </p>
</td>
</tr>
<tr id="row872137397084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p562620766084824"><a name="p562620766084824"></a><a name="p562620766084824"></a><a href="wchar-h.md">wchar.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1061799911084824"><a name="p1061799911084824"></a><a name="p1061799911084824"></a>Declares commonly used functions related to wide characters. </p>
</td>
</tr>
<tr id="row1311798093084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p249025035084824"><a name="p249025035084824"></a><a name="p249025035084824"></a><a href="wctype-h.md">wctype.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1437697111084824"><a name="p1437697111084824"></a><a name="p1437697111084824"></a>Provides functions to detect, translate, and map wide characters. </p>
</td>
</tr>
</tbody>
</table>

## Data Structures<a name="nested-classes"></a>

<a name="table1382938309084824"></a>
<table><thead align="left"><tr id="row633752632084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1982947923084824"><a name="p1982947923084824"></a><a name="p1982947923084824"></a>Data Structure Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p97869545084824"><a name="p97869545084824"></a><a name="p97869545084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1855116583084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1695487876084824"><a name="p1695487876084824"></a><a name="p1695487876084824"></a><a href="option.md">option</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1249303992084824"><a name="p1249303992084824"></a><a name="p1249303992084824"></a>Defines the command parsing option. </p>
</td>
</tr>
<tr id="row754220399084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1161919827084824"><a name="p1161919827084824"></a><a name="p1161919827084824"></a><a href="imaxdiv_t.md">imaxdiv_t</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1051823769084824"><a name="p1051823769084824"></a><a name="p1051823769084824"></a>Stores the division result. </p>
</td>
</tr>
<tr id="row831288514084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1426599552084824"><a name="p1426599552084824"></a><a name="p1426599552084824"></a><a href="entry.md">entry</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p476389913084824"><a name="p476389913084824"></a><a name="p476389913084824"></a>Defines a hash table entry. </p>
</td>
</tr>
<tr id="row205001890084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1511737034084824"><a name="p1511737034084824"></a><a name="p1511737034084824"></a><a href="qelem.md">qelem</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p941038405084824"><a name="p941038405084824"></a><a name="p941038405084824"></a>Creates a queue from the doubly linked list for <a href="utils.md#ga7dc680d5d6d07984f96737c220058d64">insque</a> and <a href="utils.md#ga1d2e353620a8dc3bb2702831607a3fc1">remque</a>. </p>
</td>
</tr>
<tr id="row1387483547084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1094306115084824"><a name="p1094306115084824"></a><a name="p1094306115084824"></a><a href="hsearch_data.md">hsearch_data</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p745087120084824"><a name="p745087120084824"></a><a name="p745087120084824"></a>Defines a hash table. </p>
</td>
</tr>
<tr id="row1500083119084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p860393244084824"><a name="p860393244084824"></a><a name="p860393244084824"></a><a href="div_t.md">div_t</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p427295121084824"><a name="p427295121084824"></a><a name="p427295121084824"></a>Defines the structures of the division operation result. </p>
</td>
</tr>
<tr id="row1022259001084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1911676265084824"><a name="p1911676265084824"></a><a name="p1911676265084824"></a><a href="ldiv_t.md">ldiv_t</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2036093787084824"><a name="p2036093787084824"></a><a name="p2036093787084824"></a>Defines the structures of the division operation result. </p>
</td>
</tr>
<tr id="row1997441189084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p608295499084824"><a name="p608295499084824"></a><a name="p608295499084824"></a><a href="lldiv_t.md">lldiv_t</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1358205610084824"><a name="p1358205610084824"></a><a name="p1358205610084824"></a>Defines the structures of the division operation result. </p>
</td>
</tr>
</tbody>
</table>

## Macros<a name="define-members"></a>

<a name="table641546587084824"></a>
<table><thead align="left"><tr id="row1792565168084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p543823709084824"><a name="p543823709084824"></a><a name="p543823709084824"></a>Macro Name and Value</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p861737466084824"><a name="p861737466084824"></a><a name="p861737466084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row77364801084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1963158152084824"><a name="p1963158152084824"></a><a name="p1963158152084824"></a><em id="ga0bf2a26a1f15f79f80319edbaa5cc9a5"><a name="ga0bf2a26a1f15f79f80319edbaa5cc9a5"></a><a name="ga0bf2a26a1f15f79f80319edbaa5cc9a5"></a></em>__BITS_PER_LONG    32</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1307968206084824"><a name="p1307968206084824"></a><a name="p1307968206084824"></a>Defines the number of bits of the long data type. </p>
</td>
</tr>
<tr id="row1646336553084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1207158602084824"><a name="p1207158602084824"></a><a name="p1207158602084824"></a><em id="gadd669d31505a077f769cff8e66c780b3"><a name="gadd669d31505a077f769cff8e66c780b3"></a><a name="gadd669d31505a077f769cff8e66c780b3"></a></em>EPERM    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2015161029084824"><a name="p2015161029084824"></a><a name="p2015161029084824"></a>Operation not permitted. </p>
</td>
</tr>
<tr id="row1202306847084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p473287360084824"><a name="p473287360084824"></a><a name="p473287360084824"></a><em id="ga03e689f378f643d16ea7537918528a48"><a name="ga03e689f378f643d16ea7537918528a48"></a><a name="ga03e689f378f643d16ea7537918528a48"></a></em>ENOENT    2</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2004981571084824"><a name="p2004981571084824"></a><a name="p2004981571084824"></a>No such file or path. </p>
</td>
</tr>
<tr id="row628392308084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p437740641084824"><a name="p437740641084824"></a><a name="p437740641084824"></a><em id="ga462e47a8af6288232a5df548221ada4c"><a name="ga462e47a8af6288232a5df548221ada4c"></a><a name="ga462e47a8af6288232a5df548221ada4c"></a></em>ESRCH    3</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1084027344084824"><a name="p1084027344084824"></a><a name="p1084027344084824"></a>No such process. </p>
</td>
</tr>
<tr id="row870070220084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p954413653084824"><a name="p954413653084824"></a><a name="p954413653084824"></a><em id="ga46b83d9f6c23b1b65a8cecfd775ddaed"><a name="ga46b83d9f6c23b1b65a8cecfd775ddaed"></a><a name="ga46b83d9f6c23b1b65a8cecfd775ddaed"></a></em>EINTR    4</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1425383796084824"><a name="p1425383796084824"></a><a name="p1425383796084824"></a>Interrupted function call. </p>
</td>
</tr>
<tr id="row129023211084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p560853334084824"><a name="p560853334084824"></a><a name="p560853334084824"></a><em id="ga70979f50f9c83e5aebab3d6a1bd4cf35"><a name="ga70979f50f9c83e5aebab3d6a1bd4cf35"></a><a name="ga70979f50f9c83e5aebab3d6a1bd4cf35"></a></em>EIO    5</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p958619765084824"><a name="p958619765084824"></a><a name="p958619765084824"></a>I/O error. </p>
</td>
</tr>
<tr id="row373038968084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p357690795084824"><a name="p357690795084824"></a><a name="p357690795084824"></a><em id="ga2b3884b11e4932bd372bb6d899d6fbfe"><a name="ga2b3884b11e4932bd372bb6d899d6fbfe"></a><a name="ga2b3884b11e4932bd372bb6d899d6fbfe"></a></em>ENXIO    6</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p364248840084824"><a name="p364248840084824"></a><a name="p364248840084824"></a>No such device or address. </p>
</td>
</tr>
<tr id="row1802058896084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1168516883084824"><a name="p1168516883084824"></a><a name="p1168516883084824"></a><em id="gaba8481985c201ff726f349d7f2d09895"><a name="gaba8481985c201ff726f349d7f2d09895"></a><a name="gaba8481985c201ff726f349d7f2d09895"></a></em>E2BIG    7</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1238887949084824"><a name="p1238887949084824"></a><a name="p1238887949084824"></a>Parameter list too long. </p>
</td>
</tr>
<tr id="row306485060084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p935012804084824"><a name="p935012804084824"></a><a name="p935012804084824"></a><em id="ga4d0b1b435ec441e7d50a430b83df5832"><a name="ga4d0b1b435ec441e7d50a430b83df5832"></a><a name="ga4d0b1b435ec441e7d50a430b83df5832"></a></em>ENOEXEC    8</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p105833911084824"><a name="p105833911084824"></a><a name="p105833911084824"></a>Exec format error. </p>
</td>
</tr>
<tr id="row1928501586084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1138122186084824"><a name="p1138122186084824"></a><a name="p1138122186084824"></a><em id="gac54507d66b43ad12f9356257323c0018"><a name="gac54507d66b43ad12f9356257323c0018"></a><a name="gac54507d66b43ad12f9356257323c0018"></a></em>EBADF    9</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1650267071084824"><a name="p1650267071084824"></a><a name="p1650267071084824"></a>Bad file descriptor. </p>
</td>
</tr>
<tr id="row1970990714084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1295422208084824"><a name="p1295422208084824"></a><a name="p1295422208084824"></a><em id="ga47b42c351e0e011a048058d224205c0f"><a name="ga47b42c351e0e011a048058d224205c0f"></a><a name="ga47b42c351e0e011a048058d224205c0f"></a></em>ECHILD    10</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p979157072084824"><a name="p979157072084824"></a><a name="p979157072084824"></a>No child processes. </p>
</td>
</tr>
<tr id="row1106601639084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p21837927084824"><a name="p21837927084824"></a><a name="p21837927084824"></a><em id="gaf0fac1cea1165b4debec7f686edf3313"><a name="gaf0fac1cea1165b4debec7f686edf3313"></a><a name="gaf0fac1cea1165b4debec7f686edf3313"></a></em>EAGAIN    11</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p179167683084824"><a name="p179167683084824"></a><a name="p179167683084824"></a>Retry. </p>
</td>
</tr>
<tr id="row878846612084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1758011621084824"><a name="p1758011621084824"></a><a name="p1758011621084824"></a><em id="ga6a05c923dad0c1208043e9c20a58c8e5"><a name="ga6a05c923dad0c1208043e9c20a58c8e5"></a><a name="ga6a05c923dad0c1208043e9c20a58c8e5"></a></em>ENOMEM    12</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p129731424084824"><a name="p129731424084824"></a><a name="p129731424084824"></a>Not enough memory space. </p>
</td>
</tr>
<tr id="row1032285425084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1646688447084824"><a name="p1646688447084824"></a><a name="p1646688447084824"></a><em id="gac2a2e9fa555401f94478f74e01868032"><a name="gac2a2e9fa555401f94478f74e01868032"></a><a name="gac2a2e9fa555401f94478f74e01868032"></a></em>EACCES    13</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p435219493084824"><a name="p435219493084824"></a><a name="p435219493084824"></a>Incorrect permission. </p>
</td>
</tr>
<tr id="row799005263084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1832804415084824"><a name="p1832804415084824"></a><a name="p1832804415084824"></a><em id="ga3f317946e043623f9d6b93dbf60e6316"><a name="ga3f317946e043623f9d6b93dbf60e6316"></a><a name="ga3f317946e043623f9d6b93dbf60e6316"></a></em>EFAULT    14</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1743950703084824"><a name="p1743950703084824"></a><a name="p1743950703084824"></a>Invalid address. </p>
</td>
</tr>
<tr id="row1375036429084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1115905357084824"><a name="p1115905357084824"></a><a name="p1115905357084824"></a><em id="gaa0a4b0e307e83f52be51099f01156936"><a name="gaa0a4b0e307e83f52be51099f01156936"></a><a name="gaa0a4b0e307e83f52be51099f01156936"></a></em>ENOTBLK    15</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p632616429084824"><a name="p632616429084824"></a><a name="p632616429084824"></a>Block device request. </p>
</td>
</tr>
<tr id="row556775441084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1934757462084824"><a name="p1934757462084824"></a><a name="p1934757462084824"></a><em id="ga8368025077a0385849d6817b2007c095"><a name="ga8368025077a0385849d6817b2007c095"></a><a name="ga8368025077a0385849d6817b2007c095"></a></em>EBUSY    16</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1357183377084824"><a name="p1357183377084824"></a><a name="p1357183377084824"></a>Device or resource busy. </p>
</td>
</tr>
<tr id="row305063061084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1842748133084824"><a name="p1842748133084824"></a><a name="p1842748133084824"></a><em id="ga0a3bef9e5c47e42917692b5dae3b5498"><a name="ga0a3bef9e5c47e42917692b5dae3b5498"></a><a name="ga0a3bef9e5c47e42917692b5dae3b5498"></a></em>EEXIST    17</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1009327219084824"><a name="p1009327219084824"></a><a name="p1009327219084824"></a>File exists. </p>
</td>
</tr>
<tr id="row599481975084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p522490749084824"><a name="p522490749084824"></a><a name="p522490749084824"></a><em id="ga3396cf9fb0ff5af3a18dd2a2bbdb21e1"><a name="ga3396cf9fb0ff5af3a18dd2a2bbdb21e1"></a><a name="ga3396cf9fb0ff5af3a18dd2a2bbdb21e1"></a></em>EXDEV    18</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p269803195084824"><a name="p269803195084824"></a><a name="p269803195084824"></a>Incorrect link. </p>
</td>
</tr>
<tr id="row1690981286084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2035853515084824"><a name="p2035853515084824"></a><a name="p2035853515084824"></a><em id="gab9b8cc17d1947160d13faaba7a18d6d1"><a name="gab9b8cc17d1947160d13faaba7a18d6d1"></a><a name="gab9b8cc17d1947160d13faaba7a18d6d1"></a></em>ENODEV    19</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1864749942084824"><a name="p1864749942084824"></a><a name="p1864749942084824"></a>No such device. </p>
</td>
</tr>
<tr id="row1343076511084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2066123170084824"><a name="p2066123170084824"></a><a name="p2066123170084824"></a><em id="ga9262fb92f7ef662d0bdd577912a5b101"><a name="ga9262fb92f7ef662d0bdd577912a5b101"></a><a name="ga9262fb92f7ef662d0bdd577912a5b101"></a></em>ENOTDIR    20</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1288410605084824"><a name="p1288410605084824"></a><a name="p1288410605084824"></a>Not a directory. </p>
</td>
</tr>
<tr id="row1428600314084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1039716075084824"><a name="p1039716075084824"></a><a name="p1039716075084824"></a><em id="gae22c3a1e0a38f3896de238cc30d0e19b"><a name="gae22c3a1e0a38f3896de238cc30d0e19b"></a><a name="gae22c3a1e0a38f3896de238cc30d0e19b"></a></em>EISDIR    21</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p80999455084824"><a name="p80999455084824"></a><a name="p80999455084824"></a>Is a directory. </p>
</td>
</tr>
<tr id="row723630605084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1891249348084824"><a name="p1891249348084824"></a><a name="p1891249348084824"></a><em id="ga2d1678d5a7cc8ce499643f3b8957def4"><a name="ga2d1678d5a7cc8ce499643f3b8957def4"></a><a name="ga2d1678d5a7cc8ce499643f3b8957def4"></a></em>EINVAL    22</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p291144317084824"><a name="p291144317084824"></a><a name="p291144317084824"></a>Invalid parameter. </p>
</td>
</tr>
<tr id="row249780541084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1097278742084824"><a name="p1097278742084824"></a><a name="p1097278742084824"></a><em id="ga5554094b3fb4bb6ebeb0157cb3f82a55"><a name="ga5554094b3fb4bb6ebeb0157cb3f82a55"></a><a name="ga5554094b3fb4bb6ebeb0157cb3f82a55"></a></em>ENFILE    23</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p838840751084824"><a name="p838840751084824"></a><a name="p838840751084824"></a>Too many opened files in system (the maximum number exceeded) </p>
</td>
</tr>
<tr id="row1367133423084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p395371548084824"><a name="p395371548084824"></a><a name="p395371548084824"></a><em id="ga64a75c174882ddbfa726c7fd040f87a1"><a name="ga64a75c174882ddbfa726c7fd040f87a1"></a><a name="ga64a75c174882ddbfa726c7fd040f87a1"></a></em>EMFILE    24</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p314201145084824"><a name="p314201145084824"></a><a name="p314201145084824"></a>Too many opened files in a process (the maximum number exceeded) </p>
</td>
</tr>
<tr id="row1076029551084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1437932785084824"><a name="p1437932785084824"></a><a name="p1437932785084824"></a><em id="gac3daf409082bb528032f4452a81e1034"><a name="gac3daf409082bb528032f4452a81e1034"></a><a name="gac3daf409082bb528032f4452a81e1034"></a></em>ENOTTY    25</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p661577810084824"><a name="p661577810084824"></a><a name="p661577810084824"></a>Inappropriate I/O control operation. </p>
</td>
</tr>
<tr id="row1205541685084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1142846018084824"><a name="p1142846018084824"></a><a name="p1142846018084824"></a><em id="gaaed12e82224923d599b6f1939c8e0971"><a name="gaaed12e82224923d599b6f1939c8e0971"></a><a name="gaaed12e82224923d599b6f1939c8e0971"></a></em>ETXTBSY    26</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1828595964084824"><a name="p1828595964084824"></a><a name="p1828595964084824"></a>Text file busy. </p>
</td>
</tr>
<tr id="row509507871084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1990706121084824"><a name="p1990706121084824"></a><a name="p1990706121084824"></a><em id="gaf5401a500939ed1812c04ca200b95eef"><a name="gaf5401a500939ed1812c04ca200b95eef"></a><a name="gaf5401a500939ed1812c04ca200b95eef"></a></em>EFBIG    27</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1681103882084824"><a name="p1681103882084824"></a><a name="p1681103882084824"></a>File too large. </p>
</td>
</tr>
<tr id="row1366698970084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p276300867084824"><a name="p276300867084824"></a><a name="p276300867084824"></a><em id="ga088abe8bad2df798edad3053d719b937"><a name="ga088abe8bad2df798edad3053d719b937"></a><a name="ga088abe8bad2df798edad3053d719b937"></a></em>ENOSPC    28</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1319995236084824"><a name="p1319995236084824"></a><a name="p1319995236084824"></a>No space left on device. </p>
</td>
</tr>
<tr id="row1750361082084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1794169966084824"><a name="p1794169966084824"></a><a name="p1794169966084824"></a><em id="ga0e42d4f9fecdcf5fcca2b333252173c3"><a name="ga0e42d4f9fecdcf5fcca2b333252173c3"></a><a name="ga0e42d4f9fecdcf5fcca2b333252173c3"></a></em>ESPIPE    29</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1372973407084824"><a name="p1372973407084824"></a><a name="p1372973407084824"></a>Invalid query. </p>
</td>
</tr>
<tr id="row490907279084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p208606993084824"><a name="p208606993084824"></a><a name="p208606993084824"></a><em id="gacb02bb67dddd7ca8cf82634a0781d58d"><a name="gacb02bb67dddd7ca8cf82634a0781d58d"></a><a name="gacb02bb67dddd7ca8cf82634a0781d58d"></a></em>EROFS    30</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p626803887084824"><a name="p626803887084824"></a><a name="p626803887084824"></a>Read-only file system. </p>
</td>
</tr>
<tr id="row1480730129084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p907726806084824"><a name="p907726806084824"></a><a name="p907726806084824"></a><em id="ga97f59fa1a5a2f61b792c1b9dfc218072"><a name="ga97f59fa1a5a2f61b792c1b9dfc218072"></a><a name="ga97f59fa1a5a2f61b792c1b9dfc218072"></a></em>EMLINK    31</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2117798267084824"><a name="p2117798267084824"></a><a name="p2117798267084824"></a>Too many links. </p>
</td>
</tr>
<tr id="row1768994793084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p704054437084824"><a name="p704054437084824"></a><a name="p704054437084824"></a><em id="ga5f8d33deb08fa27c04897b278ac7f965"><a name="ga5f8d33deb08fa27c04897b278ac7f965"></a><a name="ga5f8d33deb08fa27c04897b278ac7f965"></a></em>EPIPE    32</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p793277869084824"><a name="p793277869084824"></a><a name="p793277869084824"></a>The pipe file is incorrect or the read end of the pipe is closed during the write operation. </p>
</td>
</tr>
<tr id="row1515102804084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1414110948084824"><a name="p1414110948084824"></a><a name="p1414110948084824"></a><em id="ga5fe247e079b591a68e0fdbf7caec5b70"><a name="ga5fe247e079b591a68e0fdbf7caec5b70"></a><a name="ga5fe247e079b591a68e0fdbf7caec5b70"></a></em>EDOM    33</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p259291239084824"><a name="p259291239084824"></a><a name="p259291239084824"></a>Domain error. The value of at least one input parameter is out of the parameter range. </p>
</td>
</tr>
<tr id="row985879781084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p316175815084824"><a name="p316175815084824"></a><a name="p316175815084824"></a><em id="gaa1591a4f3a86360108de5b9ba34980ca"><a name="gaa1591a4f3a86360108de5b9ba34980ca"></a><a name="gaa1591a4f3a86360108de5b9ba34980ca"></a></em>ERANGE    34</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1119039703084824"><a name="p1119039703084824"></a><a name="p1119039703084824"></a>The actual return value exceeds the return value range. </p>
</td>
</tr>
<tr id="row1117942196084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p715323080084824"><a name="p715323080084824"></a><a name="p715323080084824"></a><em id="ga55cc70ce0ba661298f3c412095dfeeb6"><a name="ga55cc70ce0ba661298f3c412095dfeeb6"></a><a name="ga55cc70ce0ba661298f3c412095dfeeb6"></a></em>EDEADLK    35</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p166829336084824"><a name="p166829336084824"></a><a name="p166829336084824"></a>Resource deadlock. </p>
</td>
</tr>
<tr id="row791442662084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1607624739084824"><a name="p1607624739084824"></a><a name="p1607624739084824"></a><em id="ga41d5ab3a8a05f9c5eab536c9cfba305b"><a name="ga41d5ab3a8a05f9c5eab536c9cfba305b"></a><a name="ga41d5ab3a8a05f9c5eab536c9cfba305b"></a></em>ENAMETOOLONG    36</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2095575492084824"><a name="p2095575492084824"></a><a name="p2095575492084824"></a>File name too long. </p>
</td>
</tr>
<tr id="row242770144084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1027526268084824"><a name="p1027526268084824"></a><a name="p1027526268084824"></a><em id="ga65e1a7bda392be276a701988d0604e63"><a name="ga65e1a7bda392be276a701988d0604e63"></a><a name="ga65e1a7bda392be276a701988d0604e63"></a></em>ENOLCK    37</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p666426367084824"><a name="p666426367084824"></a><a name="p666426367084824"></a>No locks available. </p>
</td>
</tr>
<tr id="row2052585019084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p39834505084824"><a name="p39834505084824"></a><a name="p39834505084824"></a><em id="ga43785b9969e0bd1af532dbde06c5540b"><a name="ga43785b9969e0bd1af532dbde06c5540b"></a><a name="ga43785b9969e0bd1af532dbde06c5540b"></a></em>ENOSYS    38</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1043530188084824"><a name="p1043530188084824"></a><a name="p1043530188084824"></a>Function not implemented. </p>
</td>
</tr>
<tr id="row1696836163084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1670961996084824"><a name="p1670961996084824"></a><a name="p1670961996084824"></a><em id="gaa0f602f3fd369a6fede82190710b9c5c"><a name="gaa0f602f3fd369a6fede82190710b9c5c"></a><a name="gaa0f602f3fd369a6fede82190710b9c5c"></a></em>ENOTEMPTY    39</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p157889495084824"><a name="p157889495084824"></a><a name="p157889495084824"></a>Directory not empty. </p>
</td>
</tr>
<tr id="row1061438647084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p635078600084824"><a name="p635078600084824"></a><a name="p635078600084824"></a><em id="ga2f78c246352d2bf2f19dc5d43da2f0c9"><a name="ga2f78c246352d2bf2f19dc5d43da2f0c9"></a><a name="ga2f78c246352d2bf2f19dc5d43da2f0c9"></a></em>ELOOP    40</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2107787740084824"><a name="p2107787740084824"></a><a name="p2107787740084824"></a>Too many levels of symbolic links. </p>
</td>
</tr>
<tr id="row72778841084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1552939473084824"><a name="p1552939473084824"></a><a name="p1552939473084824"></a><em id="ga4a3a0b3605fd3b2336455062ee8e25f0"><a name="ga4a3a0b3605fd3b2336455062ee8e25f0"></a><a name="ga4a3a0b3605fd3b2336455062ee8e25f0"></a></em>EWOULDBLOCK    <a href="utils.md#gaf0fac1cea1165b4debec7f686edf3313">EAGAIN</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1318759659084824"><a name="p1318759659084824"></a><a name="p1318759659084824"></a>Operation would block (the same value as <a href="utils.md#gaf0fac1cea1165b4debec7f686edf3313">EAGAIN</a>) </p>
</td>
</tr>
<tr id="row1881895711084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1734783905084824"><a name="p1734783905084824"></a><a name="p1734783905084824"></a><em id="gae40596feaa3f66f5440b485bf7c1c2d1"><a name="gae40596feaa3f66f5440b485bf7c1c2d1"></a><a name="gae40596feaa3f66f5440b485bf7c1c2d1"></a></em>ENOMSG    42</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p101122504084824"><a name="p101122504084824"></a><a name="p101122504084824"></a>No message of the desired type. </p>
</td>
</tr>
<tr id="row1812536748084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1961678411084824"><a name="p1961678411084824"></a><a name="p1961678411084824"></a><em id="gad9913290fef890d46a6b7e8b4bfb1c29"><a name="gad9913290fef890d46a6b7e8b4bfb1c29"></a><a name="gad9913290fef890d46a6b7e8b4bfb1c29"></a></em>EIDRM    43</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1070722920084824"><a name="p1070722920084824"></a><a name="p1070722920084824"></a>Identifier removed. </p>
</td>
</tr>
<tr id="row534793091084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1811108241084824"><a name="p1811108241084824"></a><a name="p1811108241084824"></a><em id="ga15d68f826dc2f784d7d3627311e916c1"><a name="ga15d68f826dc2f784d7d3627311e916c1"></a><a name="ga15d68f826dc2f784d7d3627311e916c1"></a></em>ECHRNG    44</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p592093752084824"><a name="p592093752084824"></a><a name="p592093752084824"></a>Channel number out of range. </p>
</td>
</tr>
<tr id="row836348054084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p900949106084824"><a name="p900949106084824"></a><a name="p900949106084824"></a><em id="gacdf97ac22e88c3988c28c9c8f7d14c5e"><a name="gacdf97ac22e88c3988c28c9c8f7d14c5e"></a><a name="gacdf97ac22e88c3988c28c9c8f7d14c5e"></a></em>EL2NSYNC    45</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1749655344084824"><a name="p1749655344084824"></a><a name="p1749655344084824"></a>Level 2 not synchronized. </p>
</td>
</tr>
<tr id="row410988296084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1174323294084824"><a name="p1174323294084824"></a><a name="p1174323294084824"></a><em id="ga2e4efb348b873846645cd56144b0ea1e"><a name="ga2e4efb348b873846645cd56144b0ea1e"></a><a name="ga2e4efb348b873846645cd56144b0ea1e"></a></em>EL3HLT    46</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p232190961084824"><a name="p232190961084824"></a><a name="p232190961084824"></a>Level 3 halted. </p>
</td>
</tr>
<tr id="row1598836444084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p311648567084824"><a name="p311648567084824"></a><a name="p311648567084824"></a><em id="ga5117695086a9942c77befdbd650910cf"><a name="ga5117695086a9942c77befdbd650910cf"></a><a name="ga5117695086a9942c77befdbd650910cf"></a></em>EL3RST    47</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p194897077084824"><a name="p194897077084824"></a><a name="p194897077084824"></a>Level 3 reset. </p>
</td>
</tr>
<tr id="row179156746084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p430968054084824"><a name="p430968054084824"></a><a name="p430968054084824"></a><em id="ga059ed0ab5dab96dfe00ffca40b35155f"><a name="ga059ed0ab5dab96dfe00ffca40b35155f"></a><a name="ga059ed0ab5dab96dfe00ffca40b35155f"></a></em>ELNRNG    48</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1705378670084824"><a name="p1705378670084824"></a><a name="p1705378670084824"></a>Link ID out of range. </p>
</td>
</tr>
<tr id="row355613799084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2133856001084824"><a name="p2133856001084824"></a><a name="p2133856001084824"></a><em id="gac71878d33a396ae1a4e3fe16489f00a9"><a name="gac71878d33a396ae1a4e3fe16489f00a9"></a><a name="gac71878d33a396ae1a4e3fe16489f00a9"></a></em>EUNATCH    49</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p35473026084824"><a name="p35473026084824"></a><a name="p35473026084824"></a>Protocol driver not attached. </p>
</td>
</tr>
<tr id="row685539720084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1839951557084824"><a name="p1839951557084824"></a><a name="p1839951557084824"></a><em id="ga2f1893e03a904a500dcb95ff8e35889b"><a name="ga2f1893e03a904a500dcb95ff8e35889b"></a><a name="ga2f1893e03a904a500dcb95ff8e35889b"></a></em>ENOCSI    50</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p425606472084824"><a name="p425606472084824"></a><a name="p425606472084824"></a>No available CSI structure. </p>
</td>
</tr>
<tr id="row903006070084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1604385264084824"><a name="p1604385264084824"></a><a name="p1604385264084824"></a><em id="ga81a4a94e4d7d996ad5d2a9137539e392"><a name="ga81a4a94e4d7d996ad5d2a9137539e392"></a><a name="ga81a4a94e4d7d996ad5d2a9137539e392"></a></em>EL2HLT    51</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p501450422084824"><a name="p501450422084824"></a><a name="p501450422084824"></a>Level 2 halted. </p>
</td>
</tr>
<tr id="row1788747677084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p171492102084824"><a name="p171492102084824"></a><a name="p171492102084824"></a><em id="ga0c17130b2933edfec68b2c70a2cd0a7f"><a name="ga0c17130b2933edfec68b2c70a2cd0a7f"></a><a name="ga0c17130b2933edfec68b2c70a2cd0a7f"></a></em>EBADE    52</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p499605891084824"><a name="p499605891084824"></a><a name="p499605891084824"></a>Invalid exchange. </p>
</td>
</tr>
<tr id="row1140002753084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1778120132084824"><a name="p1778120132084824"></a><a name="p1778120132084824"></a><em id="gaca1e9da0ef95864e910f550467d475fa"><a name="gaca1e9da0ef95864e910f550467d475fa"></a><a name="gaca1e9da0ef95864e910f550467d475fa"></a></em>EBADR    53</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2057043451084824"><a name="p2057043451084824"></a><a name="p2057043451084824"></a>Invalid request descriptor. </p>
</td>
</tr>
<tr id="row354291359084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1058785682084824"><a name="p1058785682084824"></a><a name="p1058785682084824"></a><em id="ga69aa360ec60f24c128556361f7729e48"><a name="ga69aa360ec60f24c128556361f7729e48"></a><a name="ga69aa360ec60f24c128556361f7729e48"></a></em>EXFULL    54</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1337587226084824"><a name="p1337587226084824"></a><a name="p1337587226084824"></a>Exchange full. </p>
</td>
</tr>
<tr id="row1447661487084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p133574728084824"><a name="p133574728084824"></a><a name="p133574728084824"></a><em id="ga7eb46ddb59ec78bac0de2d45ce2a5053"><a name="ga7eb46ddb59ec78bac0de2d45ce2a5053"></a><a name="ga7eb46ddb59ec78bac0de2d45ce2a5053"></a></em>ENOANO    55</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1398880464084824"><a name="p1398880464084824"></a><a name="p1398880464084824"></a>No anode. </p>
</td>
</tr>
<tr id="row1069117150084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p429494193084824"><a name="p429494193084824"></a><a name="p429494193084824"></a><em id="gabe200466dc512a9e314b9cc7d081c1ac"><a name="gabe200466dc512a9e314b9cc7d081c1ac"></a><a name="gabe200466dc512a9e314b9cc7d081c1ac"></a></em>EBADRQC    56</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1283762042084824"><a name="p1283762042084824"></a><a name="p1283762042084824"></a>Invalid request code. </p>
</td>
</tr>
<tr id="row1653706162084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p956190261084824"><a name="p956190261084824"></a><a name="p956190261084824"></a><em id="ga45d8c9818d0bf75ad33ebab50631276a"><a name="ga45d8c9818d0bf75ad33ebab50631276a"></a><a name="ga45d8c9818d0bf75ad33ebab50631276a"></a></em>EBADSLT    57</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1355948570084824"><a name="p1355948570084824"></a><a name="p1355948570084824"></a>Invalid slot. </p>
</td>
</tr>
<tr id="row701859172084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1210442249084824"><a name="p1210442249084824"></a><a name="p1210442249084824"></a><em id="gacfea92d35e42dd807a7e9beb1e394e4c"><a name="gacfea92d35e42dd807a7e9beb1e394e4c"></a><a name="gacfea92d35e42dd807a7e9beb1e394e4c"></a></em>EDEADLOCK    <a href="utils.md#ga55cc70ce0ba661298f3c412095dfeeb6">EDEADLK</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1097979109084824"><a name="p1097979109084824"></a><a name="p1097979109084824"></a>Resource deadlock (the same value as <a href="utils.md#ga55cc70ce0ba661298f3c412095dfeeb6">EDEADLK</a>) </p>
</td>
</tr>
<tr id="row925685630084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p932049359084824"><a name="p932049359084824"></a><a name="p932049359084824"></a><em id="gae4d80808cd12a64d14a3da0d39cad443"><a name="gae4d80808cd12a64d14a3da0d39cad443"></a><a name="gae4d80808cd12a64d14a3da0d39cad443"></a></em>EBFONT    59</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p257172521084824"><a name="p257172521084824"></a><a name="p257172521084824"></a>Incorrect font format. </p>
</td>
</tr>
<tr id="row1800886330084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1871559525084824"><a name="p1871559525084824"></a><a name="p1871559525084824"></a><em id="ga7cea86ddbdacae0b391674e680f17bdb"><a name="ga7cea86ddbdacae0b391674e680f17bdb"></a><a name="ga7cea86ddbdacae0b391674e680f17bdb"></a></em>ENOSTR    60</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2035074191084824"><a name="p2035074191084824"></a><a name="p2035074191084824"></a>Not a stream device. </p>
</td>
</tr>
<tr id="row281609072084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p888010349084824"><a name="p888010349084824"></a><a name="p888010349084824"></a><em id="ga0030614bc864d1b24eaedd71585acc27"><a name="ga0030614bc864d1b24eaedd71585acc27"></a><a name="ga0030614bc864d1b24eaedd71585acc27"></a></em>ENODATA    61</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p479217522084824"><a name="p479217522084824"></a><a name="p479217522084824"></a>No message is available on the stream head read queue. </p>
</td>
</tr>
<tr id="row385493159084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1665806486084824"><a name="p1665806486084824"></a><a name="p1665806486084824"></a><em id="gab59cf3c65eaf836d5c647fa2a24ca649"><a name="gab59cf3c65eaf836d5c647fa2a24ca649"></a><a name="gab59cf3c65eaf836d5c647fa2a24ca649"></a></em>ETIME    62</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p310755679084824"><a name="p310755679084824"></a><a name="p310755679084824"></a>Timer expired. </p>
</td>
</tr>
<tr id="row283268838084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1084122596084824"><a name="p1084122596084824"></a><a name="p1084122596084824"></a><em id="gad88bc6ea94ec1a5e91d3651677d85c00"><a name="gad88bc6ea94ec1a5e91d3651677d85c00"></a><a name="gad88bc6ea94ec1a5e91d3651677d85c00"></a></em>ENOSR    63</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1800190943084824"><a name="p1800190943084824"></a><a name="p1800190943084824"></a>No stream resources. </p>
</td>
</tr>
<tr id="row1349832052084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1957627963084824"><a name="p1957627963084824"></a><a name="p1957627963084824"></a><em id="ga4a49ca5a72811f9950d2773806eaa641"><a name="ga4a49ca5a72811f9950d2773806eaa641"></a><a name="ga4a49ca5a72811f9950d2773806eaa641"></a></em>ENONET    64</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1788934716084824"><a name="p1788934716084824"></a><a name="p1788934716084824"></a>Machine is disconnected from the network. </p>
</td>
</tr>
<tr id="row1469091506084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1258215733084824"><a name="p1258215733084824"></a><a name="p1258215733084824"></a><em id="ga63fb0df2a890ace70f5093b26cbf7065"><a name="ga63fb0df2a890ace70f5093b26cbf7065"></a><a name="ga63fb0df2a890ace70f5093b26cbf7065"></a></em>ENOPKG    65</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1314978399084824"><a name="p1314978399084824"></a><a name="p1314978399084824"></a>Package not installed. </p>
</td>
</tr>
<tr id="row721173266084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1280439793084824"><a name="p1280439793084824"></a><a name="p1280439793084824"></a><em id="ga5e1edba49c18fc631dbf54ff53702d4a"><a name="ga5e1edba49c18fc631dbf54ff53702d4a"></a><a name="ga5e1edba49c18fc631dbf54ff53702d4a"></a></em>EREMOTE    66</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1773282608084824"><a name="p1773282608084824"></a><a name="p1773282608084824"></a>Object is remote. </p>
</td>
</tr>
<tr id="row1587635137084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1904544778084824"><a name="p1904544778084824"></a><a name="p1904544778084824"></a><em id="gadd4408349a756880be9d91efadb8aed0"><a name="gadd4408349a756880be9d91efadb8aed0"></a><a name="gadd4408349a756880be9d91efadb8aed0"></a></em>ENOLINK    67</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2073320841084824"><a name="p2073320841084824"></a><a name="p2073320841084824"></a>Link has been severed. </p>
</td>
</tr>
<tr id="row2023217352084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1149216215084824"><a name="p1149216215084824"></a><a name="p1149216215084824"></a><em id="ga7ef87d37bfaf88d1ad1de1b531330a42"><a name="ga7ef87d37bfaf88d1ad1de1b531330a42"></a><a name="ga7ef87d37bfaf88d1ad1de1b531330a42"></a></em>EADV    68</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1616043137084824"><a name="p1616043137084824"></a><a name="p1616043137084824"></a>Broadcast error. </p>
</td>
</tr>
<tr id="row411269983084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1672417840084824"><a name="p1672417840084824"></a><a name="p1672417840084824"></a><em id="gae7df13cc989ed4b6921455a6eff3c249"><a name="gae7df13cc989ed4b6921455a6eff3c249"></a><a name="gae7df13cc989ed4b6921455a6eff3c249"></a></em>ESRMNT    69</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1074177329084824"><a name="p1074177329084824"></a><a name="p1074177329084824"></a>srmount error </p>
</td>
</tr>
<tr id="row359252898084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p600098573084824"><a name="p600098573084824"></a><a name="p600098573084824"></a><em id="gad9e159536fe852a5679a99a0b8191d69"><a name="gad9e159536fe852a5679a99a0b8191d69"></a><a name="gad9e159536fe852a5679a99a0b8191d69"></a></em>ECOMM    70</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1662069634084824"><a name="p1662069634084824"></a><a name="p1662069634084824"></a>Communication error on send. </p>
</td>
</tr>
<tr id="row1161693868084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p183741273084824"><a name="p183741273084824"></a><a name="p183741273084824"></a><em id="ga5a92de56e8ebe19cbd8a2ce8c80ad03e"><a name="ga5a92de56e8ebe19cbd8a2ce8c80ad03e"></a><a name="ga5a92de56e8ebe19cbd8a2ce8c80ad03e"></a></em>EPROTO    71</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1366867168084824"><a name="p1366867168084824"></a><a name="p1366867168084824"></a>Protocol error. </p>
</td>
</tr>
<tr id="row349760929084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1972410425084824"><a name="p1972410425084824"></a><a name="p1972410425084824"></a><em id="ga4d7b69d7ce0dfa0a9b998403b4ffe226"><a name="ga4d7b69d7ce0dfa0a9b998403b4ffe226"></a><a name="ga4d7b69d7ce0dfa0a9b998403b4ffe226"></a></em>EMULTIHOP    72</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1875905521084824"><a name="p1875905521084824"></a><a name="p1875905521084824"></a>Multi-hop attempt. </p>
</td>
</tr>
<tr id="row237301043084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2145448298084824"><a name="p2145448298084824"></a><a name="p2145448298084824"></a><em id="ga66443788a7b1b20f15ac1a67b106f20d"><a name="ga66443788a7b1b20f15ac1a67b106f20d"></a><a name="ga66443788a7b1b20f15ac1a67b106f20d"></a></em>EDOTDOT    73</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p432616035084824"><a name="p432616035084824"></a><a name="p432616035084824"></a>RFS-specific error. </p>
</td>
</tr>
<tr id="row297271922084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2012935821084824"><a name="p2012935821084824"></a><a name="p2012935821084824"></a><em id="ga251e9b536ed96ccb16aa28ca2d5bd656"><a name="ga251e9b536ed96ccb16aa28ca2d5bd656"></a><a name="ga251e9b536ed96ccb16aa28ca2d5bd656"></a></em>EBADMSG    74</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p5462551084824"><a name="p5462551084824"></a><a name="p5462551084824"></a>Non-data message. </p>
</td>
</tr>
<tr id="row3440965084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1445765669084824"><a name="p1445765669084824"></a><a name="p1445765669084824"></a><em id="ga888552a5e3c78b5883904cf5d55244ab"><a name="ga888552a5e3c78b5883904cf5d55244ab"></a><a name="ga888552a5e3c78b5883904cf5d55244ab"></a></em>EOVERFLOW    75</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p301383784084824"><a name="p301383784084824"></a><a name="p301383784084824"></a>Value too large to be represented by the defined data type. </p>
</td>
</tr>
<tr id="row1632080361084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p655404938084824"><a name="p655404938084824"></a><a name="p655404938084824"></a><em id="gafb498fa12135b33c784f3dc4445ce30f"><a name="gafb498fa12135b33c784f3dc4445ce30f"></a><a name="gafb498fa12135b33c784f3dc4445ce30f"></a></em>ENOTUNIQ    76</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p661968478084824"><a name="p661968478084824"></a><a name="p661968478084824"></a>Name not unique on the network. </p>
</td>
</tr>
<tr id="row1389573531084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p72744114084824"><a name="p72744114084824"></a><a name="p72744114084824"></a><em id="gae9284c9860c0064da7dd8cba12c1f90f"><a name="gae9284c9860c0064da7dd8cba12c1f90f"></a><a name="gae9284c9860c0064da7dd8cba12c1f90f"></a></em>EBADFD    77</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1698077380084824"><a name="p1698077380084824"></a><a name="p1698077380084824"></a>File descriptor in the bad state. </p>
</td>
</tr>
<tr id="row175041052084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2133381140084824"><a name="p2133381140084824"></a><a name="p2133381140084824"></a><em id="gaa8fa21a58da5282010753ae1bed331af"><a name="gaa8fa21a58da5282010753ae1bed331af"></a><a name="gaa8fa21a58da5282010753ae1bed331af"></a></em>EREMCHG    78</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1070106723084824"><a name="p1070106723084824"></a><a name="p1070106723084824"></a>Remote address changed. </p>
</td>
</tr>
<tr id="row1532391981084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1823842080084824"><a name="p1823842080084824"></a><a name="p1823842080084824"></a><em id="ga438fa452772ae90a9ccef5d3711bd752"><a name="ga438fa452772ae90a9ccef5d3711bd752"></a><a name="ga438fa452772ae90a9ccef5d3711bd752"></a></em>ELIBACC    79</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1683006196084824"><a name="p1683006196084824"></a><a name="p1683006196084824"></a>Cannot access a needed shared library. </p>
</td>
</tr>
<tr id="row1928811037084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1424230568084824"><a name="p1424230568084824"></a><a name="p1424230568084824"></a><em id="ga6c0c4ad172a62cde82900773c875e259"><a name="ga6c0c4ad172a62cde82900773c875e259"></a><a name="ga6c0c4ad172a62cde82900773c875e259"></a></em>ELIBBAD    80</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p42207042084824"><a name="p42207042084824"></a><a name="p42207042084824"></a>Accessing a corrupted shared library. </p>
</td>
</tr>
<tr id="row879328534084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1876867374084824"><a name="p1876867374084824"></a><a name="p1876867374084824"></a><em id="gaf208def3c8b59e39e6fe3d3d97d71a86"><a name="gaf208def3c8b59e39e6fe3d3d97d71a86"></a><a name="gaf208def3c8b59e39e6fe3d3d97d71a86"></a></em>ELIBSCN    81</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p666424334084824"><a name="p666424334084824"></a><a name="p666424334084824"></a>lib section in a.out corrupted </p>
</td>
</tr>
<tr id="row716358912084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1577140521084824"><a name="p1577140521084824"></a><a name="p1577140521084824"></a><em id="gad2084b03b9e1c7467ab1b8bdbdfc2fe6"><a name="gad2084b03b9e1c7467ab1b8bdbdfc2fe6"></a><a name="gad2084b03b9e1c7467ab1b8bdbdfc2fe6"></a></em>ELIBMAX    82</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p373591654084824"><a name="p373591654084824"></a><a name="p373591654084824"></a>Attempting to link in too many shared libraries. </p>
</td>
</tr>
<tr id="row404013647084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p741823609084824"><a name="p741823609084824"></a><a name="p741823609084824"></a><em id="ga95774ff58533d1e67961890ed30f87b2"><a name="ga95774ff58533d1e67961890ed30f87b2"></a><a name="ga95774ff58533d1e67961890ed30f87b2"></a></em>ELIBEXEC    83</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2094154987084824"><a name="p2094154987084824"></a><a name="p2094154987084824"></a>Cannot execute a shared library directly. </p>
</td>
</tr>
<tr id="row128643686084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p16989602084824"><a name="p16989602084824"></a><a name="p16989602084824"></a><em id="gac6c071293826a4e66a717bb38db7794d"><a name="gac6c071293826a4e66a717bb38db7794d"></a><a name="gac6c071293826a4e66a717bb38db7794d"></a></em>EILSEQ    84</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p433358548084824"><a name="p433358548084824"></a><a name="p433358548084824"></a>Invalid byte sequence. </p>
</td>
</tr>
<tr id="row109557380084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p675431495084824"><a name="p675431495084824"></a><a name="p675431495084824"></a><em id="ga0e5993319c80d5a93ed10b6253878ae5"><a name="ga0e5993319c80d5a93ed10b6253878ae5"></a><a name="ga0e5993319c80d5a93ed10b6253878ae5"></a></em>ERESTART    85</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p349579743084824"><a name="p349579743084824"></a><a name="p349579743084824"></a>Interrupted system call should be restarted. </p>
</td>
</tr>
<tr id="row1784950837084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p10184174084824"><a name="p10184174084824"></a><a name="p10184174084824"></a><em id="ga07773d22c3eb7a4d4ea0696ee5f49841"><a name="ga07773d22c3eb7a4d4ea0696ee5f49841"></a><a name="ga07773d22c3eb7a4d4ea0696ee5f49841"></a></em>ESTRPIPE    86</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1564166415084824"><a name="p1564166415084824"></a><a name="p1564166415084824"></a>Stream pipe error. </p>
</td>
</tr>
<tr id="row1704543317084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1129914363084824"><a name="p1129914363084824"></a><a name="p1129914363084824"></a><em id="ga9b153104ed38c8579f009f81bc7b2dc9"><a name="ga9b153104ed38c8579f009f81bc7b2dc9"></a><a name="ga9b153104ed38c8579f009f81bc7b2dc9"></a></em>EUSERS    87</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1763369215084824"><a name="p1763369215084824"></a><a name="p1763369215084824"></a>Too many users. </p>
</td>
</tr>
<tr id="row1683863494084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p75224897084824"><a name="p75224897084824"></a><a name="p75224897084824"></a><em id="gae34fa7a550ac1c415daa2e114a1c0f38"><a name="gae34fa7a550ac1c415daa2e114a1c0f38"></a><a name="gae34fa7a550ac1c415daa2e114a1c0f38"></a></em>ENOTSOCK    88</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1067366742084824"><a name="p1067366742084824"></a><a name="p1067366742084824"></a>Not a socket. </p>
</td>
</tr>
<tr id="row1696360715084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1737787477084824"><a name="p1737787477084824"></a><a name="p1737787477084824"></a><em id="ga0e416d3478cf030e37e90c55d68ad97a"><a name="ga0e416d3478cf030e37e90c55d68ad97a"></a><a name="ga0e416d3478cf030e37e90c55d68ad97a"></a></em>EDESTADDRREQ    89</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p817951834084824"><a name="p817951834084824"></a><a name="p817951834084824"></a>Destination address required. </p>
</td>
</tr>
<tr id="row631265224084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1226381610084824"><a name="p1226381610084824"></a><a name="p1226381610084824"></a><em id="gae37becfaa095a9df5c5c788bce5aa06f"><a name="gae37becfaa095a9df5c5c788bce5aa06f"></a><a name="gae37becfaa095a9df5c5c788bce5aa06f"></a></em>EMSGSIZE    90</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1730128219084824"><a name="p1730128219084824"></a><a name="p1730128219084824"></a>Message too long. </p>
</td>
</tr>
<tr id="row140136711084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p95119903084824"><a name="p95119903084824"></a><a name="p95119903084824"></a><em id="gae6014faa948366b8321d755204acf755"><a name="gae6014faa948366b8321d755204acf755"></a><a name="gae6014faa948366b8321d755204acf755"></a></em>EPROTOTYPE    91</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p419935185084824"><a name="p419935185084824"></a><a name="p419935185084824"></a>Socket protocol error. </p>
</td>
</tr>
<tr id="row116067980084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1932526576084824"><a name="p1932526576084824"></a><a name="p1932526576084824"></a><em id="gacd570f8ab92198653b4459773dc3bca3"><a name="gacd570f8ab92198653b4459773dc3bca3"></a><a name="gacd570f8ab92198653b4459773dc3bca3"></a></em>ENOPROTOOPT    92</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1841526805084824"><a name="p1841526805084824"></a><a name="p1841526805084824"></a>Protocol not available. </p>
</td>
</tr>
<tr id="row1009126188084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p705763627084824"><a name="p705763627084824"></a><a name="p705763627084824"></a><em id="gad581c46fdd4dee9419f60eaff40415e7"><a name="gad581c46fdd4dee9419f60eaff40415e7"></a><a name="gad581c46fdd4dee9419f60eaff40415e7"></a></em>EPROTONOSUPPORT    93</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p632662649084824"><a name="p632662649084824"></a><a name="p632662649084824"></a>Protocol not supported. </p>
</td>
</tr>
<tr id="row830539691084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1195491324084824"><a name="p1195491324084824"></a><a name="p1195491324084824"></a><em id="ga891103a0628442461b41d4d85fb6d945"><a name="ga891103a0628442461b41d4d85fb6d945"></a><a name="ga891103a0628442461b41d4d85fb6d945"></a></em>ESOCKTNOSUPPORT    94</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p806378543084824"><a name="p806378543084824"></a><a name="p806378543084824"></a>Socket type not supported. </p>
</td>
</tr>
<tr id="row652808371084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1267174975084824"><a name="p1267174975084824"></a><a name="p1267174975084824"></a><em id="ga4b807895c74cea4d0302bf27725d4b9d"><a name="ga4b807895c74cea4d0302bf27725d4b9d"></a><a name="ga4b807895c74cea4d0302bf27725d4b9d"></a></em>EOPNOTSUPP    95</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p437847696084824"><a name="p437847696084824"></a><a name="p437847696084824"></a>Operation not supported on socket. </p>
</td>
</tr>
<tr id="row1662739584084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p412008970084824"><a name="p412008970084824"></a><a name="p412008970084824"></a><em id="ga91457bbf35f0f1085619a99423bb1f33"><a name="ga91457bbf35f0f1085619a99423bb1f33"></a><a name="ga91457bbf35f0f1085619a99423bb1f33"></a></em>ENOTSUP    <a href="utils.md#ga4b807895c74cea4d0302bf27725d4b9d">EOPNOTSUPP</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p68018586084824"><a name="p68018586084824"></a><a name="p68018586084824"></a>Operation not supported on socket. The value is the same as that of <a href="utils.md#ga4b807895c74cea4d0302bf27725d4b9d">EOPNOTSUPP</a>. </p>
</td>
</tr>
<tr id="row1816174287084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2003252475084824"><a name="p2003252475084824"></a><a name="p2003252475084824"></a><em id="ga871b9fabb281dbc2d3b81cb79c163c20"><a name="ga871b9fabb281dbc2d3b81cb79c163c20"></a><a name="ga871b9fabb281dbc2d3b81cb79c163c20"></a></em>EPFNOSUPPORT    96</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p188785084824"><a name="p188785084824"></a><a name="p188785084824"></a>Protocol family not supported. </p>
</td>
</tr>
<tr id="row436224876084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p622818239084824"><a name="p622818239084824"></a><a name="p622818239084824"></a><em id="ga4c3a793b4d51cb7dd020af92e536fe21"><a name="ga4c3a793b4d51cb7dd020af92e536fe21"></a><a name="ga4c3a793b4d51cb7dd020af92e536fe21"></a></em>EAFNOSUPPORT    97</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p132572768084824"><a name="p132572768084824"></a><a name="p132572768084824"></a>Address family not supported. </p>
</td>
</tr>
<tr id="row115194246084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p951058141084824"><a name="p951058141084824"></a><a name="p951058141084824"></a><em id="ga61676e39b42371c65c3b960a91887b03"><a name="ga61676e39b42371c65c3b960a91887b03"></a><a name="ga61676e39b42371c65c3b960a91887b03"></a></em>EADDRINUSE    98</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p318513315084824"><a name="p318513315084824"></a><a name="p318513315084824"></a>Address already in use. </p>
</td>
</tr>
<tr id="row765066286084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p404307061084824"><a name="p404307061084824"></a><a name="p404307061084824"></a><em id="ga556612e55358838192165684c971a44f"><a name="ga556612e55358838192165684c971a44f"></a><a name="ga556612e55358838192165684c971a44f"></a></em>EADDRNOTAVAIL    99</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1151064819084824"><a name="p1151064819084824"></a><a name="p1151064819084824"></a>Address not available. </p>
</td>
</tr>
<tr id="row1905410989084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2068958268084824"><a name="p2068958268084824"></a><a name="p2068958268084824"></a><em id="gaac51995026fa19cdd0ad84a272304af0"><a name="gaac51995026fa19cdd0ad84a272304af0"></a><a name="gaac51995026fa19cdd0ad84a272304af0"></a></em>ENETDOWN    100</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p287764242084824"><a name="p287764242084824"></a><a name="p287764242084824"></a>Network is down. </p>
</td>
</tr>
<tr id="row389073201084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1244428081084824"><a name="p1244428081084824"></a><a name="p1244428081084824"></a><em id="ga3f91f1ad503432783c7a5d1481b45419"><a name="ga3f91f1ad503432783c7a5d1481b45419"></a><a name="ga3f91f1ad503432783c7a5d1481b45419"></a></em>ENETUNREACH    101</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1479693359084824"><a name="p1479693359084824"></a><a name="p1479693359084824"></a>Network unreachable. </p>
</td>
</tr>
<tr id="row141020078084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1110887628084824"><a name="p1110887628084824"></a><a name="p1110887628084824"></a><em id="ga92750db73ff8e83591c977bbb3a5bea1"><a name="ga92750db73ff8e83591c977bbb3a5bea1"></a><a name="ga92750db73ff8e83591c977bbb3a5bea1"></a></em>ENETRESET    102</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p284752040084824"><a name="p284752040084824"></a><a name="p284752040084824"></a>Network disconnection caused by restart. </p>
</td>
</tr>
<tr id="row1116681794084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p293580178084824"><a name="p293580178084824"></a><a name="p293580178084824"></a><em id="ga45342991e001e28bbf87916d92b7e09a"><a name="ga45342991e001e28bbf87916d92b7e09a"></a><a name="ga45342991e001e28bbf87916d92b7e09a"></a></em>ECONNABORTED    103</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2100391614084824"><a name="p2100391614084824"></a><a name="p2100391614084824"></a>Network disconnection caused by software problems. </p>
</td>
</tr>
<tr id="row1990356408084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1663854149084824"><a name="p1663854149084824"></a><a name="p1663854149084824"></a><em id="gadd4258b08af02fbe4590fbaae7260037"><a name="gadd4258b08af02fbe4590fbaae7260037"></a><a name="gadd4258b08af02fbe4590fbaae7260037"></a></em>ECONNRESET    104</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p368854488084824"><a name="p368854488084824"></a><a name="p368854488084824"></a>Connection reset. </p>
</td>
</tr>
<tr id="row593519944084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1369015342084824"><a name="p1369015342084824"></a><a name="p1369015342084824"></a><em id="ga9e655f47bfd914a1174f281fc31cf63d"><a name="ga9e655f47bfd914a1174f281fc31cf63d"></a><a name="ga9e655f47bfd914a1174f281fc31cf63d"></a></em>ENOBUFS    105</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p187087747084824"><a name="p187087747084824"></a><a name="p187087747084824"></a>No buffer space available. </p>
</td>
</tr>
<tr id="row2024995745084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1339076865084824"><a name="p1339076865084824"></a><a name="p1339076865084824"></a><em id="ga164ca8549da7a385e2fe1cba823b9eaf"><a name="ga164ca8549da7a385e2fe1cba823b9eaf"></a><a name="ga164ca8549da7a385e2fe1cba823b9eaf"></a></em>EISCONN    106</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1440270295084824"><a name="p1440270295084824"></a><a name="p1440270295084824"></a>Socket is connected. </p>
</td>
</tr>
<tr id="row1056419783084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1663716537084824"><a name="p1663716537084824"></a><a name="p1663716537084824"></a><em id="gaf23e48762a0676f49d480db91cfd5e4b"><a name="gaf23e48762a0676f49d480db91cfd5e4b"></a><a name="gaf23e48762a0676f49d480db91cfd5e4b"></a></em>ENOTCONN    107</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1375826816084824"><a name="p1375826816084824"></a><a name="p1375826816084824"></a>Socket disconnected. </p>
</td>
</tr>
<tr id="row29662988084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1187454929084824"><a name="p1187454929084824"></a><a name="p1187454929084824"></a><em id="ga2a55c5dd8b54ff5aace6c274c6726d68"><a name="ga2a55c5dd8b54ff5aace6c274c6726d68"></a><a name="ga2a55c5dd8b54ff5aace6c274c6726d68"></a></em>ESHUTDOWN    108</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1220037312084824"><a name="p1220037312084824"></a><a name="p1220037312084824"></a>Cannot send after transport endpoint shutdown. </p>
</td>
</tr>
<tr id="row600205257084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1611046148084824"><a name="p1611046148084824"></a><a name="p1611046148084824"></a><em id="ga10426080250efba47f4aaf254036ff00"><a name="ga10426080250efba47f4aaf254036ff00"></a><a name="ga10426080250efba47f4aaf254036ff00"></a></em>ETOOMANYREFS    109</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p52382383084824"><a name="p52382383084824"></a><a name="p52382383084824"></a>Cannot splice due to too many references. </p>
</td>
</tr>
<tr id="row1436722298084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1406429822084824"><a name="p1406429822084824"></a><a name="p1406429822084824"></a><em id="ga597718e59a8fc9c4d4ab63f5a34e28b1"><a name="ga597718e59a8fc9c4d4ab63f5a34e28b1"></a><a name="ga597718e59a8fc9c4d4ab63f5a34e28b1"></a></em>ETIMEDOUT    110</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1709625940084824"><a name="p1709625940084824"></a><a name="p1709625940084824"></a>Connection timed out. </p>
</td>
</tr>
<tr id="row713521626084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1656932575084824"><a name="p1656932575084824"></a><a name="p1656932575084824"></a><em id="gaad88020b394ef1aa4af2f4ef9b4c8b39"><a name="gaad88020b394ef1aa4af2f4ef9b4c8b39"></a><a name="gaad88020b394ef1aa4af2f4ef9b4c8b39"></a></em>ECONNREFUSED    111</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1678863621084824"><a name="p1678863621084824"></a><a name="p1678863621084824"></a>Connection refused. </p>
</td>
</tr>
<tr id="row847402353084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1127497704084824"><a name="p1127497704084824"></a><a name="p1127497704084824"></a><em id="gaa92bcaf70544db6998f4c503026359c5"><a name="gaa92bcaf70544db6998f4c503026359c5"></a><a name="gaa92bcaf70544db6998f4c503026359c5"></a></em>EHOSTDOWN    112</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1621243127084824"><a name="p1621243127084824"></a><a name="p1621243127084824"></a>Host is down. </p>
</td>
</tr>
<tr id="row260028271084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p543143927084824"><a name="p543143927084824"></a><a name="p543143927084824"></a><em id="ga53e186028fc992c3341ccb0d4d239b24"><a name="ga53e186028fc992c3341ccb0d4d239b24"></a><a name="ga53e186028fc992c3341ccb0d4d239b24"></a></em>EHOSTUNREACH    113</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p694130869084824"><a name="p694130869084824"></a><a name="p694130869084824"></a>Host is unreachable. </p>
</td>
</tr>
<tr id="row1803072722084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1509707534084824"><a name="p1509707534084824"></a><a name="p1509707534084824"></a><em id="gaa4ccb54aa806de3e41a8515f06db85d4"><a name="gaa4ccb54aa806de3e41a8515f06db85d4"></a><a name="gaa4ccb54aa806de3e41a8515f06db85d4"></a></em>EALREADY    114</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1769132208084824"><a name="p1769132208084824"></a><a name="p1769132208084824"></a>Operation already in process. </p>
</td>
</tr>
<tr id="row1083438904084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p115455374084824"><a name="p115455374084824"></a><a name="p115455374084824"></a><em id="ga6c045d5be06e715cc335784a7320714e"><a name="ga6c045d5be06e715cc335784a7320714e"></a><a name="ga6c045d5be06e715cc335784a7320714e"></a></em>EINPROGRESS    115</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p910231614084824"><a name="p910231614084824"></a><a name="p910231614084824"></a>Operation in progress. </p>
</td>
</tr>
<tr id="row1106797331084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2122190232084824"><a name="p2122190232084824"></a><a name="p2122190232084824"></a><em id="ga09e189d2214d9fe2847d27bf270ca1d7"><a name="ga09e189d2214d9fe2847d27bf270ca1d7"></a><a name="ga09e189d2214d9fe2847d27bf270ca1d7"></a></em>ESTALE    116</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1058713844084824"><a name="p1058713844084824"></a><a name="p1058713844084824"></a>Stale file handle. </p>
</td>
</tr>
<tr id="row759276499084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1165886878084824"><a name="p1165886878084824"></a><a name="p1165886878084824"></a><em id="ga909dbec1577dd4de42e3de940449d991"><a name="ga909dbec1577dd4de42e3de940449d991"></a><a name="ga909dbec1577dd4de42e3de940449d991"></a></em>EUCLEAN    117</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p130087545084824"><a name="p130087545084824"></a><a name="p130087545084824"></a>Structure needs cleaning. </p>
</td>
</tr>
<tr id="row1546826232084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1414825744084824"><a name="p1414825744084824"></a><a name="p1414825744084824"></a><em id="ga604c754d9cff19a3f842f263939744ed"><a name="ga604c754d9cff19a3f842f263939744ed"></a><a name="ga604c754d9cff19a3f842f263939744ed"></a></em>ENOTNAM    118</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p114485357084824"><a name="p114485357084824"></a><a name="p114485357084824"></a>Not a XENIX named type file. </p>
</td>
</tr>
<tr id="row1778108639084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2061135808084824"><a name="p2061135808084824"></a><a name="p2061135808084824"></a><em id="ga4df8882de9228023855dc31287c1728c"><a name="ga4df8882de9228023855dc31287c1728c"></a><a name="ga4df8882de9228023855dc31287c1728c"></a></em>ENAVAIL    119</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1200994641084824"><a name="p1200994641084824"></a><a name="p1200994641084824"></a>No XENIX semaphores available. </p>
</td>
</tr>
<tr id="row611494478084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1661675325084824"><a name="p1661675325084824"></a><a name="p1661675325084824"></a><em id="gab43dd11ce0541c2bc2bdbd36cbcbd6b7"><a name="gab43dd11ce0541c2bc2bdbd36cbcbd6b7"></a><a name="gab43dd11ce0541c2bc2bdbd36cbcbd6b7"></a></em>EISNAM    120</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1738447803084824"><a name="p1738447803084824"></a><a name="p1738447803084824"></a>Duplicate file name. </p>
</td>
</tr>
<tr id="row1500647936084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p607503332084824"><a name="p607503332084824"></a><a name="p607503332084824"></a><em id="gaa206a5818e8b3666cd46274d71ab7c45"><a name="gaa206a5818e8b3666cd46274d71ab7c45"></a><a name="gaa206a5818e8b3666cd46274d71ab7c45"></a></em>EREMOTEIO    121</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p282776884084824"><a name="p282776884084824"></a><a name="p282776884084824"></a>Remote I/O error. </p>
</td>
</tr>
<tr id="row103634493084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p173225910084824"><a name="p173225910084824"></a><a name="p173225910084824"></a><em id="gaa5a48566b00cf9062d9deeeb0682cdaf"><a name="gaa5a48566b00cf9062d9deeeb0682cdaf"></a><a name="gaa5a48566b00cf9062d9deeeb0682cdaf"></a></em>EDQUOT    122</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p292520470084824"><a name="p292520470084824"></a><a name="p292520470084824"></a>Quota exceeded. </p>
</td>
</tr>
<tr id="row2088070540084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p79378597084824"><a name="p79378597084824"></a><a name="p79378597084824"></a><em id="ga434a80cd2a94a829078d50b61ebd277d"><a name="ga434a80cd2a94a829078d50b61ebd277d"></a><a name="ga434a80cd2a94a829078d50b61ebd277d"></a></em>ENOMEDIUM    123</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p333195817084824"><a name="p333195817084824"></a><a name="p333195817084824"></a>No medium found. </p>
</td>
</tr>
<tr id="row875200692084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1928608253084824"><a name="p1928608253084824"></a><a name="p1928608253084824"></a><em id="ga3431fd1c9d585b39b0089ebc0b97450f"><a name="ga3431fd1c9d585b39b0089ebc0b97450f"></a><a name="ga3431fd1c9d585b39b0089ebc0b97450f"></a></em>EMEDIUMTYPE    124</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p566667702084824"><a name="p566667702084824"></a><a name="p566667702084824"></a>Wrong medium type. </p>
</td>
</tr>
<tr id="row966883346084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p771629023084824"><a name="p771629023084824"></a><a name="p771629023084824"></a><em id="ga9532d840ef91fd8e1ecc5d7ca7cbf212"><a name="ga9532d840ef91fd8e1ecc5d7ca7cbf212"></a><a name="ga9532d840ef91fd8e1ecc5d7ca7cbf212"></a></em>ECANCELED    125</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p246027873084824"><a name="p246027873084824"></a><a name="p246027873084824"></a>Operation canceled. </p>
</td>
</tr>
<tr id="row550282717084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p315216590084824"><a name="p315216590084824"></a><a name="p315216590084824"></a><em id="ga21e1aad43086cf76131101b31ca391cc"><a name="ga21e1aad43086cf76131101b31ca391cc"></a><a name="ga21e1aad43086cf76131101b31ca391cc"></a></em>ENOKEY    126</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1497214413084824"><a name="p1497214413084824"></a><a name="p1497214413084824"></a>Required key not available. </p>
</td>
</tr>
<tr id="row560228322084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1649062389084824"><a name="p1649062389084824"></a><a name="p1649062389084824"></a><em id="gac1eb981061f0b7e10a3460b48490e1e2"><a name="gac1eb981061f0b7e10a3460b48490e1e2"></a><a name="gac1eb981061f0b7e10a3460b48490e1e2"></a></em>EKEYEXPIRED    127</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1923857292084824"><a name="p1923857292084824"></a><a name="p1923857292084824"></a>Key has expired. </p>
</td>
</tr>
<tr id="row958732564084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p416593130084824"><a name="p416593130084824"></a><a name="p416593130084824"></a><em id="ga4dc832fdf410d2f441ce364a7f6d768a"><a name="ga4dc832fdf410d2f441ce364a7f6d768a"></a><a name="ga4dc832fdf410d2f441ce364a7f6d768a"></a></em>EKEYREVOKED    128</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p489101902084824"><a name="p489101902084824"></a><a name="p489101902084824"></a>Key has been revoked. </p>
</td>
</tr>
<tr id="row1860943140084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p670330293084824"><a name="p670330293084824"></a><a name="p670330293084824"></a><em id="gaddb68626b2a7ebc047c14180b51a5d95"><a name="gaddb68626b2a7ebc047c14180b51a5d95"></a><a name="gaddb68626b2a7ebc047c14180b51a5d95"></a></em>EKEYREJECTED    129</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p198971722084824"><a name="p198971722084824"></a><a name="p198971722084824"></a>Key was rejected by service. </p>
</td>
</tr>
<tr id="row875983982084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1521064015084824"><a name="p1521064015084824"></a><a name="p1521064015084824"></a><em id="gaf3f021d87caf24b44761036578c7beae"><a name="gaf3f021d87caf24b44761036578c7beae"></a><a name="gaf3f021d87caf24b44761036578c7beae"></a></em>EOWNERDEAD    130</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1213817326084824"><a name="p1213817326084824"></a><a name="p1213817326084824"></a>Resource owner died. </p>
</td>
</tr>
<tr id="row1537184039084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p555431998084824"><a name="p555431998084824"></a><a name="p555431998084824"></a><em id="gac69acb8e9e296867cc3f9fdf4223d05d"><a name="gac69acb8e9e296867cc3f9fdf4223d05d"></a><a name="gac69acb8e9e296867cc3f9fdf4223d05d"></a></em>ENOTRECOVERABLE    131</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p373830500084824"><a name="p373830500084824"></a><a name="p373830500084824"></a>State not recoverable. </p>
</td>
</tr>
<tr id="row1018636555084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1417949713084824"><a name="p1417949713084824"></a><a name="p1417949713084824"></a><em id="ga1ef2e2afa19fd790ef00003c23fc90dd"><a name="ga1ef2e2afa19fd790ef00003c23fc90dd"></a><a name="ga1ef2e2afa19fd790ef00003c23fc90dd"></a></em>ERFKILL    132</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p21684194084824"><a name="p21684194084824"></a><a name="p21684194084824"></a>Operation not possible due to RF-kill. </p>
</td>
</tr>
<tr id="row1348974624084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p687836465084824"><a name="p687836465084824"></a><a name="p687836465084824"></a><em id="ga7ac6735b364cb147c6ce8b887506a281"><a name="ga7ac6735b364cb147c6ce8b887506a281"></a><a name="ga7ac6735b364cb147c6ce8b887506a281"></a></em>EHWPOISON    133</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p373063413084824"><a name="p373063413084824"></a><a name="p373063413084824"></a>Hardware errors on the memory page. </p>
</td>
</tr>
<tr id="row596199288084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1666190316084824"><a name="p1666190316084824"></a><a name="p1666190316084824"></a><a href="utils.md#ga803da2fa3d4650c493068eb474e5e874">_tolower</a>(a)   ((a)|0x20)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1410416295084824"><a name="p1410416295084824"></a><a name="p1410416295084824"></a>Converts an uppercase letter to its lowercase equivalent. </p>
</td>
</tr>
<tr id="row1949113532084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p204646544084824"><a name="p204646544084824"></a><a name="p204646544084824"></a><a href="utils.md#ga2a220adaae919f631f86e4ee91667ac2">_toupper</a>(a)   ((a)&amp;0x5f)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1868109227084824"><a name="p1868109227084824"></a><a name="p1868109227084824"></a>Converts a lowercase letter to its uppercase equivalent. </p>
</td>
</tr>
<tr id="row1943613289084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1605760661084824"><a name="p1605760661084824"></a><a name="p1605760661084824"></a><a href="utils.md#ga325ce1f1d55d5b154a914a37b1094cf2">isascii</a>(a)   (0 ? isascii(a) : (unsigned)(a) &lt; 128)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p150594223084824"><a name="p150594223084824"></a><a name="p150594223084824"></a>Checks whether a parameter is an ASCII character. </p>
</td>
</tr>
<tr id="row1555820365084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2018808240084824"><a name="p2018808240084824"></a><a name="p2018808240084824"></a><em id="ga7250644aab1a485bd6a24720d2867ad8"><a name="ga7250644aab1a485bd6a24720d2867ad8"></a><a name="ga7250644aab1a485bd6a24720d2867ad8"></a></em>MM_HARD    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1664942080084824"><a name="p1664942080084824"></a><a name="p1664942080084824"></a>A hardware error occurred. </p>
</td>
</tr>
<tr id="row1915017311084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p11093841084824"><a name="p11093841084824"></a><a name="p11093841084824"></a><em id="ga95d4386c5cab57599cf9fdad75dbd9ef"><a name="ga95d4386c5cab57599cf9fdad75dbd9ef"></a><a name="ga95d4386c5cab57599cf9fdad75dbd9ef"></a></em>MM_SOFT    2</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p554760793084824"><a name="p554760793084824"></a><a name="p554760793084824"></a>A software error occurred. </p>
</td>
</tr>
<tr id="row1662799751084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1674212575084824"><a name="p1674212575084824"></a><a name="p1674212575084824"></a><em id="gaad8873c0512aaad8e20a95d8d7867fa6"><a name="gaad8873c0512aaad8e20a95d8d7867fa6"></a><a name="gaad8873c0512aaad8e20a95d8d7867fa6"></a></em>MM_FIRM    4</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p562869372084824"><a name="p562869372084824"></a><a name="p562869372084824"></a>A firmware error occurred. </p>
</td>
</tr>
<tr id="row679123670084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2137189755084824"><a name="p2137189755084824"></a><a name="p2137189755084824"></a><em id="ga9c8b88fc46ddd4d418c05b4c5c685786"><a name="ga9c8b88fc46ddd4d418c05b4c5c685786"></a><a name="ga9c8b88fc46ddd4d418c05b4c5c685786"></a></em>MM_APPL    8</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p101216948084824"><a name="p101216948084824"></a><a name="p101216948084824"></a>An error is detected by an application. </p>
</td>
</tr>
<tr id="row2129842227084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p528355347084824"><a name="p528355347084824"></a><a name="p528355347084824"></a><em id="ga5b43fa612f8e72db32d32385192f5bd9"><a name="ga5b43fa612f8e72db32d32385192f5bd9"></a><a name="ga5b43fa612f8e72db32d32385192f5bd9"></a></em>MM_UTIL    16</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p814945158084824"><a name="p814945158084824"></a><a name="p814945158084824"></a>An error is detected by a utility. </p>
</td>
</tr>
<tr id="row29166075084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1705205682084824"><a name="p1705205682084824"></a><a name="p1705205682084824"></a><em id="ga3257723578ef85fb0cef91ac18a6a8e9"><a name="ga3257723578ef85fb0cef91ac18a6a8e9"></a><a name="ga3257723578ef85fb0cef91ac18a6a8e9"></a></em>MM_OPSYS    32</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1268536040084824"><a name="p1268536040084824"></a><a name="p1268536040084824"></a>An error is detected by the operating system. </p>
</td>
</tr>
<tr id="row2073891272084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p141579052084824"><a name="p141579052084824"></a><a name="p141579052084824"></a><em id="ga655710ff6f4600613aba693f2c933844"><a name="ga655710ff6f4600613aba693f2c933844"></a><a name="ga655710ff6f4600613aba693f2c933844"></a></em>MM_RECOVER    64</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1160998516084824"><a name="p1160998516084824"></a><a name="p1160998516084824"></a>The error is recoverable. </p>
</td>
</tr>
<tr id="row1423563223084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1085359895084824"><a name="p1085359895084824"></a><a name="p1085359895084824"></a><em id="gaac7ced5531ea5e8af060a12930bd930b"><a name="gaac7ced5531ea5e8af060a12930bd930b"></a><a name="gaac7ced5531ea5e8af060a12930bd930b"></a></em>MM_NRECOV    128</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p673044270084824"><a name="p673044270084824"></a><a name="p673044270084824"></a>The error is non-recoverable. </p>
</td>
</tr>
<tr id="row1498216103084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p143364226084824"><a name="p143364226084824"></a><a name="p143364226084824"></a><em id="ga28f8601bbd8dfa8c1a1133892dbaaeaf"><a name="ga28f8601bbd8dfa8c1a1133892dbaaeaf"></a><a name="ga28f8601bbd8dfa8c1a1133892dbaaeaf"></a></em>MM_PRINT    256</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p891696627084824"><a name="p891696627084824"></a><a name="p891696627084824"></a>Prints error messages on standard error (stderr). </p>
</td>
</tr>
<tr id="row838888561084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p986371263084824"><a name="p986371263084824"></a><a name="p986371263084824"></a><em id="ga28df3705304c876e17ee22267eaa01af"><a name="ga28df3705304c876e17ee22267eaa01af"></a><a name="ga28df3705304c876e17ee22267eaa01af"></a></em>MM_CONSOLE    512</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1402460842084824"><a name="p1402460842084824"></a><a name="p1402460842084824"></a>Prints error messages on the system console. </p>
</td>
</tr>
<tr id="row1993553407084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p8735277084824"><a name="p8735277084824"></a><a name="p8735277084824"></a><em id="ga0d1ed1880858b3eb76f4173619c58c40"><a name="ga0d1ed1880858b3eb76f4173619c58c40"></a><a name="ga0d1ed1880858b3eb76f4173619c58c40"></a></em>MM_NULLMC    0L</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p745363399084824"><a name="p745363399084824"></a><a name="p745363399084824"></a>Ignores the <strong id="b1582684727084824"><a name="b1582684727084824"></a><a name="b1582684727084824"></a>classification</strong> parameter. </p>
</td>
</tr>
<tr id="row2020997470084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1684308760084824"><a name="p1684308760084824"></a><a name="p1684308760084824"></a><em id="ga3d5f92b4ab4f31431e764e04cd74de61"><a name="ga3d5f92b4ab4f31431e764e04cd74de61"></a><a name="ga3d5f92b4ab4f31431e764e04cd74de61"></a></em>MM_HALT    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1955213413084824"><a name="p1955213413084824"></a><a name="p1955213413084824"></a>Fatal fault. </p>
</td>
</tr>
<tr id="row1713455335084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1198715764084824"><a name="p1198715764084824"></a><a name="p1198715764084824"></a><em id="ga691f4cd7904d1f6579e093fb40226b98"><a name="ga691f4cd7904d1f6579e093fb40226b98"></a><a name="ga691f4cd7904d1f6579e093fb40226b98"></a></em>MM_ERROR    2</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1510097907084824"><a name="p1510097907084824"></a><a name="p1510097907084824"></a>Error-level fault. </p>
</td>
</tr>
<tr id="row1685186675084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2030971677084824"><a name="p2030971677084824"></a><a name="p2030971677084824"></a><em id="ga277b9951914986b139db5750177091f3"><a name="ga277b9951914986b139db5750177091f3"></a><a name="ga277b9951914986b139db5750177091f3"></a></em>MM_WARNING    3</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p96928051084824"><a name="p96928051084824"></a><a name="p96928051084824"></a>Warning condition. </p>
</td>
</tr>
<tr id="row606551837084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1478895282084824"><a name="p1478895282084824"></a><a name="p1478895282084824"></a><em id="ga0c65f03a4d4009ddbc8b318c4cca2662"><a name="ga0c65f03a4d4009ddbc8b318c4cca2662"></a><a name="ga0c65f03a4d4009ddbc8b318c4cca2662"></a></em>MM_INFO    4</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1849857901084824"><a name="p1849857901084824"></a><a name="p1849857901084824"></a>Informative message. </p>
</td>
</tr>
<tr id="row1671404423084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1601596308084824"><a name="p1601596308084824"></a><a name="p1601596308084824"></a><em id="gaf4e60c7def20483a91f2c85b9a98420c"><a name="gaf4e60c7def20483a91f2c85b9a98420c"></a><a name="gaf4e60c7def20483a91f2c85b9a98420c"></a></em>MM_NOSEV    0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p467697022084824"><a name="p467697022084824"></a><a name="p467697022084824"></a>No severity level is set, equivalent to <a href="utils.md#gad65c53433554559cdc93e413786cc981">MM_NULLSEV</a>. </p>
</td>
</tr>
<tr id="row1248660339084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p292625679084824"><a name="p292625679084824"></a><a name="p292625679084824"></a><em id="ga2d55c51901766d6400ea645cfaa56ad7"><a name="ga2d55c51901766d6400ea645cfaa56ad7"></a><a name="ga2d55c51901766d6400ea645cfaa56ad7"></a></em>MM_OK    0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p788959991084824"><a name="p788959991084824"></a><a name="p788959991084824"></a>The function succeeded. </p>
</td>
</tr>
<tr id="row680335820084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p910616308084824"><a name="p910616308084824"></a><a name="p910616308084824"></a><em id="ga6c6fa7e4345318cb7b7a12a6492f414b"><a name="ga6c6fa7e4345318cb7b7a12a6492f414b"></a><a name="ga6c6fa7e4345318cb7b7a12a6492f414b"></a></em>MM_NOTOK    (-1)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p681302549084824"><a name="p681302549084824"></a><a name="p681302549084824"></a>The function failed. </p>
</td>
</tr>
<tr id="row1907498895084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1909899153084824"><a name="p1909899153084824"></a><a name="p1909899153084824"></a><em id="ga16ba492651e5414d28fbca6da09999e2"><a name="ga16ba492651e5414d28fbca6da09999e2"></a><a name="ga16ba492651e5414d28fbca6da09999e2"></a></em>MM_NOMSG    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p834309361084824"><a name="p834309361084824"></a><a name="p834309361084824"></a>Error writing to stderr. </p>
</td>
</tr>
<tr id="row688761276084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p500151916084824"><a name="p500151916084824"></a><a name="p500151916084824"></a><em id="ga47ee40d662d07179517362f5796fedc6"><a name="ga47ee40d662d07179517362f5796fedc6"></a><a name="ga47ee40d662d07179517362f5796fedc6"></a></em>MM_NOCON    4</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p491078391084824"><a name="p491078391084824"></a><a name="p491078391084824"></a>Error writing to the console. </p>
</td>
</tr>
<tr id="row2039527307084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2090940541084824"><a name="p2090940541084824"></a><a name="p2090940541084824"></a><em id="ga174d0d4b9bbda298cd1faec4d4f27202"><a name="ga174d0d4b9bbda298cd1faec4d4f27202"></a><a name="ga174d0d4b9bbda298cd1faec4d4f27202"></a></em>MM_NULLLBL    ((char*)0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p76546798084824"><a name="p76546798084824"></a><a name="p76546798084824"></a>Ignores the <strong id="b2126736506084824"><a name="b2126736506084824"></a><a name="b2126736506084824"></a>label</strong> parameter. </p>
</td>
</tr>
<tr id="row534196735084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p285858031084824"><a name="p285858031084824"></a><a name="p285858031084824"></a><em id="ga345476b2492fd41e52ec6cbb08265b07"><a name="ga345476b2492fd41e52ec6cbb08265b07"></a><a name="ga345476b2492fd41e52ec6cbb08265b07"></a></em>MM_NULLTXT    ((char*)0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1937045959084824"><a name="p1937045959084824"></a><a name="p1937045959084824"></a>Ignores the <strong id="b556845713084824"><a name="b556845713084824"></a><a name="b556845713084824"></a>text</strong> parameter. </p>
</td>
</tr>
<tr id="row523988048084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p905499387084824"><a name="p905499387084824"></a><a name="p905499387084824"></a><em id="ga715bfd49536d249ea7812a4114602db0"><a name="ga715bfd49536d249ea7812a4114602db0"></a><a name="ga715bfd49536d249ea7812a4114602db0"></a></em>MM_NULLACT    ((char*)0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1384138373084824"><a name="p1384138373084824"></a><a name="p1384138373084824"></a>Ignores the <strong id="b2064055532084824"><a name="b2064055532084824"></a><a name="b2064055532084824"></a>action</strong> parameter. </p>
</td>
</tr>
<tr id="row1473567172084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p653681935084824"><a name="p653681935084824"></a><a name="p653681935084824"></a><em id="ga64da80d889e56fc4dc22b0d8e07576cc"><a name="ga64da80d889e56fc4dc22b0d8e07576cc"></a><a name="ga64da80d889e56fc4dc22b0d8e07576cc"></a></em>MM_NULLTAG    ((char*)0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1601873625084824"><a name="p1601873625084824"></a><a name="p1601873625084824"></a>Ignores the <strong id="b1900787132084824"><a name="b1900787132084824"></a><a name="b1900787132084824"></a>tag</strong> parameter. </p>
</td>
</tr>
<tr id="row1669000570084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p74500620084824"><a name="p74500620084824"></a><a name="p74500620084824"></a><em id="gad65c53433554559cdc93e413786cc981"><a name="gad65c53433554559cdc93e413786cc981"></a><a name="gad65c53433554559cdc93e413786cc981"></a></em>MM_NULLSEV    0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p260425843084824"><a name="p260425843084824"></a><a name="p260425843084824"></a>Ignores the <strong id="b304811948084824"><a name="b304811948084824"></a><a name="b304811948084824"></a>severity</strong> parameter. </p>
</td>
</tr>
<tr id="row1392230525084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p976479452084824"><a name="p976479452084824"></a><a name="p976479452084824"></a><em id="gaed9e649990b20ba86e1aa7cacdc1bafe"><a name="gaed9e649990b20ba86e1aa7cacdc1bafe"></a><a name="gaed9e649990b20ba86e1aa7cacdc1bafe"></a></em>FNM_PATHNAME    0x1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p185755867084824"><a name="p185755867084824"></a><a name="p185755867084824"></a>If this flag is set, a slash (/) in <strong id="b567009865084824"><a name="b567009865084824"></a><a name="b567009865084824"></a>string</strong> can be matched by a slash (/) in <strong id="b2069087654084824"><a name="b2069087654084824"></a><a name="b2069087654084824"></a>pattern</strong>, but not by an asterisk (*), or a question mark (?), or a bracket expression ([]) containing a slash. </p>
</td>
</tr>
<tr id="row2063094956084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1073659810084824"><a name="p1073659810084824"></a><a name="p1073659810084824"></a><em id="ga0c050a8a7551c2ca86560396de3d20d0"><a name="ga0c050a8a7551c2ca86560396de3d20d0"></a><a name="ga0c050a8a7551c2ca86560396de3d20d0"></a></em>FNM_NOESCAPE    0x2</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p816028487084824"><a name="p816028487084824"></a><a name="p816028487084824"></a>If this flag is set, the backslash () is treated as an ordinary character, instead of an escape character. </p>
</td>
</tr>
<tr id="row593115254084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p613338485084824"><a name="p613338485084824"></a><a name="p613338485084824"></a><em id="gaab98fecc02c06d6379bfcf416d6d297e"><a name="gaab98fecc02c06d6379bfcf416d6d297e"></a><a name="gaab98fecc02c06d6379bfcf416d6d297e"></a></em>FNM_PERIOD    0x4</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p10724699084824"><a name="p10724699084824"></a><a name="p10724699084824"></a>If this flag is set, a leading period (.) in <strong id="b714969229084824"><a name="b714969229084824"></a><a name="b714969229084824"></a>string</strong> can be exactly matched by the period (.) in <strong id="b1961012775084824"><a name="b1961012775084824"></a><a name="b1961012775084824"></a>pattern</strong>. A period is considered to be leading if it is the first character in <strong id="b149650208084824"><a name="b149650208084824"></a><a name="b149650208084824"></a>string</strong>, or if both <strong id="b1407357535084824"><a name="b1407357535084824"></a><a name="b1407357535084824"></a>FNM_PATHNAME</strong> is set and the period immediately follows a slash. </p>
</td>
</tr>
<tr id="row68333443084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1563665465084824"><a name="p1563665465084824"></a><a name="p1563665465084824"></a><em id="ga94f8f78b6d024e35c971dd3ec057140c"><a name="ga94f8f78b6d024e35c971dd3ec057140c"></a><a name="ga94f8f78b6d024e35c971dd3ec057140c"></a></em>FNM_LEADING_DIR    0x8</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1700855758084824"><a name="p1700855758084824"></a><a name="p1700855758084824"></a>If this flag is set, a trailing sequence of characters starting with a slash (/) is ignored in <strong id="b182668659084824"><a name="b182668659084824"></a><a name="b182668659084824"></a>string</strong>. For example, if this flag is set, either <strong id="b608397088084824"><a name="b608397088084824"></a><a name="b608397088084824"></a>foo*</strong> or <strong id="b915680061084824"><a name="b915680061084824"></a><a name="b915680061084824"></a>foobar</strong> as a pattern would match the string <strong id="b1031555800084824"><a name="b1031555800084824"></a><a name="b1031555800084824"></a>foobar/frobozz</strong>. </p>
</td>
</tr>
<tr id="row1889108701084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p936249587084824"><a name="p936249587084824"></a><a name="p936249587084824"></a><em id="gad41e3158a654dd4dfdab19d97745698a"><a name="gad41e3158a654dd4dfdab19d97745698a"></a><a name="gad41e3158a654dd4dfdab19d97745698a"></a></em>FNM_CASEFOLD    0x10</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p992872011084824"><a name="p992872011084824"></a><a name="p992872011084824"></a>If this flag is set, the pattern is matched case-insensitively. </p>
</td>
</tr>
<tr id="row404606466084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p793990672084824"><a name="p793990672084824"></a><a name="p793990672084824"></a><em id="gad4df04c067e436af77a11440afbded0f"><a name="gad4df04c067e436af77a11440afbded0f"></a><a name="gad4df04c067e436af77a11440afbded0f"></a></em>FNM_FILE_NAME    <a href="utils.md#gaed9e649990b20ba86e1aa7cacdc1bafe">FNM_PATHNAME</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1859521420084824"><a name="p1859521420084824"></a><a name="p1859521420084824"></a>The definition is similar to that of <a href="utils.md#gaed9e649990b20ba86e1aa7cacdc1bafe">FNM_PATHNAME</a>. </p>
</td>
</tr>
<tr id="row1130526671084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p108277912084824"><a name="p108277912084824"></a><a name="p108277912084824"></a><em id="gaf2661230e0cfc9970d6cdbe01571e753"><a name="gaf2661230e0cfc9970d6cdbe01571e753"></a><a name="gaf2661230e0cfc9970d6cdbe01571e753"></a></em>FNM_NOMATCH    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p996007789084824"><a name="p996007789084824"></a><a name="p996007789084824"></a>The <strong id="b234813554084824"><a name="b234813554084824"></a><a name="b234813554084824"></a>string</strong> parameter does not match the <strong id="b1901894708084824"><a name="b1901894708084824"></a><a name="b1901894708084824"></a>pattern</strong> parameter. </p>
</td>
</tr>
<tr id="row1181548071084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p112370016084824"><a name="p112370016084824"></a><a name="p112370016084824"></a><em id="gabf296e95251824c90803dd3aa374190d"><a name="gabf296e95251824c90803dd3aa374190d"></a><a name="gabf296e95251824c90803dd3aa374190d"></a></em>FNM_NOSYS    (-1)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p533217726084824"><a name="p533217726084824"></a><a name="p533217726084824"></a>The function does not support the operation. </p>
</td>
</tr>
<tr id="row1547004354084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p529988537084824"><a name="p529988537084824"></a><a name="p529988537084824"></a><em id="ga5d707bd32338557ced18c6ac76ca1b3a"><a name="ga5d707bd32338557ced18c6ac76ca1b3a"></a><a name="ga5d707bd32338557ced18c6ac76ca1b3a"></a></em>CHAR_MIN    0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p304355926084824"><a name="p304355926084824"></a><a name="p304355926084824"></a>Minimum value of type char. </p>
</td>
</tr>
<tr id="row89220756084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p922719380084824"><a name="p922719380084824"></a><a name="p922719380084824"></a><em id="ga778eefd6535a9d4b752fca5dd0af58db"><a name="ga778eefd6535a9d4b752fca5dd0af58db"></a><a name="ga778eefd6535a9d4b752fca5dd0af58db"></a></em>CHAR_MAX    255</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1669215222084824"><a name="p1669215222084824"></a><a name="p1669215222084824"></a>Maximum value of type char. </p>
</td>
</tr>
<tr id="row815869570084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1906697187084824"><a name="p1906697187084824"></a><a name="p1906697187084824"></a><em id="ga308d9dd2c0028ddb184b455bbd7865de"><a name="ga308d9dd2c0028ddb184b455bbd7865de"></a><a name="ga308d9dd2c0028ddb184b455bbd7865de"></a></em>CHAR_BIT    8</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p619802467084824"><a name="p619802467084824"></a><a name="p619802467084824"></a>Number of bits in type char. </p>
</td>
</tr>
<tr id="row2055915082084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p115365095084824"><a name="p115365095084824"></a><a name="p115365095084824"></a><em id="gaa05d197000ad5c143ada0fcd9379b236"><a name="gaa05d197000ad5c143ada0fcd9379b236"></a><a name="gaa05d197000ad5c143ada0fcd9379b236"></a></em>SCHAR_MIN    (-128)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p430231456084824"><a name="p430231456084824"></a><a name="p430231456084824"></a>Minimum value of type signed char. </p>
</td>
</tr>
<tr id="row352195309084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p165774485084824"><a name="p165774485084824"></a><a name="p165774485084824"></a><em id="ga8c13fdd8c2840edf0cb04a65297037bb"><a name="ga8c13fdd8c2840edf0cb04a65297037bb"></a><a name="ga8c13fdd8c2840edf0cb04a65297037bb"></a></em>SCHAR_MAX    127</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p495438489084824"><a name="p495438489084824"></a><a name="p495438489084824"></a>Maximum value of type signed char. </p>
</td>
</tr>
<tr id="row300703886084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p326865777084824"><a name="p326865777084824"></a><a name="p326865777084824"></a><em id="ga4066e640ee269d5d8f83ff6643b7af5f"><a name="ga4066e640ee269d5d8f83ff6643b7af5f"></a><a name="ga4066e640ee269d5d8f83ff6643b7af5f"></a></em>UCHAR_MAX    255</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1101217543084824"><a name="p1101217543084824"></a><a name="p1101217543084824"></a>Maximum value of type unsigned char. </p>
</td>
</tr>
<tr id="row1691238210084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1409575634084824"><a name="p1409575634084824"></a><a name="p1409575634084824"></a><em id="gae59de266aceffa1c258ac13f45fe0d18"><a name="gae59de266aceffa1c258ac13f45fe0d18"></a><a name="gae59de266aceffa1c258ac13f45fe0d18"></a></em>SHRT_MIN    (-1-0x7fff)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p984098701084824"><a name="p984098701084824"></a><a name="p984098701084824"></a>Minimum value of type short. </p>
</td>
</tr>
<tr id="row664954786084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2110858081084824"><a name="p2110858081084824"></a><a name="p2110858081084824"></a><em id="ga1f758438cb1c7bcf55da2431f5e319e6"><a name="ga1f758438cb1c7bcf55da2431f5e319e6"></a><a name="ga1f758438cb1c7bcf55da2431f5e319e6"></a></em>SHRT_MAX    0x7fff</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1550973457084824"><a name="p1550973457084824"></a><a name="p1550973457084824"></a>Maximum value of type short. </p>
</td>
</tr>
<tr id="row932862497084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p872755219084824"><a name="p872755219084824"></a><a name="p872755219084824"></a><em id="ga689b119da994dece91d44b5aeac643ed"><a name="ga689b119da994dece91d44b5aeac643ed"></a><a name="ga689b119da994dece91d44b5aeac643ed"></a></em>USHRT_MAX    0xffff</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1004054674084824"><a name="p1004054674084824"></a><a name="p1004054674084824"></a>Maximum value of type unsigned short. </p>
</td>
</tr>
<tr id="row783544901084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1924961354084824"><a name="p1924961354084824"></a><a name="p1924961354084824"></a><em id="ga21658776274b3d146c674318b635a334"><a name="ga21658776274b3d146c674318b635a334"></a><a name="ga21658776274b3d146c674318b635a334"></a></em>INT_MIN    (-1-0x7fffffff)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1508990967084824"><a name="p1508990967084824"></a><a name="p1508990967084824"></a>Minimum value of type int. </p>
</td>
</tr>
<tr id="row1871237751084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1061882558084824"><a name="p1061882558084824"></a><a name="p1061882558084824"></a><em id="ga9ec306f36d50c7375e74f0d1c55a3a67"><a name="ga9ec306f36d50c7375e74f0d1c55a3a67"></a><a name="ga9ec306f36d50c7375e74f0d1c55a3a67"></a></em>INT_MAX    0x7fffffff</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1565534571084824"><a name="p1565534571084824"></a><a name="p1565534571084824"></a>Maximum value of type int. </p>
</td>
</tr>
<tr id="row1729684879084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1339122148084824"><a name="p1339122148084824"></a><a name="p1339122148084824"></a><em id="gac998ea02fbd821fc123d60445ce76f38"><a name="gac998ea02fbd821fc123d60445ce76f38"></a><a name="gac998ea02fbd821fc123d60445ce76f38"></a></em>UINT_MAX    0xffffffffU</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1959490356084824"><a name="p1959490356084824"></a><a name="p1959490356084824"></a>Maximum value of type unsigned int. </p>
</td>
</tr>
<tr id="row1898021343084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1642471526084824"><a name="p1642471526084824"></a><a name="p1642471526084824"></a><em id="gad896ef973a3b47ebdc61650fa08e09fe"><a name="gad896ef973a3b47ebdc61650fa08e09fe"></a><a name="gad896ef973a3b47ebdc61650fa08e09fe"></a></em>__LONG_MAX    0x7fffffffL</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1490958554084824"><a name="p1490958554084824"></a><a name="p1490958554084824"></a>Maximum value of type long. </p>
</td>
</tr>
<tr id="row934296605084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1213795329084824"><a name="p1213795329084824"></a><a name="p1213795329084824"></a><em id="gae8a44c5a7436466221e0f3859d02420f"><a name="gae8a44c5a7436466221e0f3859d02420f"></a><a name="gae8a44c5a7436466221e0f3859d02420f"></a></em>LONG_MIN    (-<a href="utils.md#ga50fece4db74f09568b2938db583c5655">LONG_MAX</a>-1)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p726394999084824"><a name="p726394999084824"></a><a name="p726394999084824"></a>Minimum value of type long. </p>
</td>
</tr>
<tr id="row234531860084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p650027231084824"><a name="p650027231084824"></a><a name="p650027231084824"></a><em id="ga50fece4db74f09568b2938db583c5655"><a name="ga50fece4db74f09568b2938db583c5655"></a><a name="ga50fece4db74f09568b2938db583c5655"></a></em>LONG_MAX    <a href="utils.md#gad896ef973a3b47ebdc61650fa08e09fe">__LONG_MAX</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p809505950084824"><a name="p809505950084824"></a><a name="p809505950084824"></a>Maximum value of type long. </p>
</td>
</tr>
<tr id="row1007430646084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1408353929084824"><a name="p1408353929084824"></a><a name="p1408353929084824"></a><em id="ga41c51926a1997aab3503f9083935e06c"><a name="ga41c51926a1997aab3503f9083935e06c"></a><a name="ga41c51926a1997aab3503f9083935e06c"></a></em>ULONG_MAX    (2UL*<a href="utils.md#ga50fece4db74f09568b2938db583c5655">LONG_MAX</a>+1)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p969881307084824"><a name="p969881307084824"></a><a name="p969881307084824"></a>Maximum value of type unsigned long. </p>
</td>
</tr>
<tr id="row371007260084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p908326509084824"><a name="p908326509084824"></a><a name="p908326509084824"></a><em id="gaf17a13b2ae0e9c24c020ac1f044f30c2"><a name="gaf17a13b2ae0e9c24c020ac1f044f30c2"></a><a name="gaf17a13b2ae0e9c24c020ac1f044f30c2"></a></em>LLONG_MIN    (-<a href="utils.md#ga23ec2cf7fc07ea8f817bbac758402baf">LLONG_MAX</a>-1)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1253219672084824"><a name="p1253219672084824"></a><a name="p1253219672084824"></a>Minimum value of type long long. </p>
</td>
</tr>
<tr id="row1932946909084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1568913056084824"><a name="p1568913056084824"></a><a name="p1568913056084824"></a><em id="ga23ec2cf7fc07ea8f817bbac758402baf"><a name="ga23ec2cf7fc07ea8f817bbac758402baf"></a><a name="ga23ec2cf7fc07ea8f817bbac758402baf"></a></em>LLONG_MAX    0x7fffffffffffffffLL</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1545907101084824"><a name="p1545907101084824"></a><a name="p1545907101084824"></a>Maximum value of type long long. </p>
</td>
</tr>
<tr id="row1520619858084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p784091534084824"><a name="p784091534084824"></a><a name="p784091534084824"></a><em id="gaa1dd7166a75b73ad62b111ae6fc17c59"><a name="gaa1dd7166a75b73ad62b111ae6fc17c59"></a><a name="gaa1dd7166a75b73ad62b111ae6fc17c59"></a></em>ULLONG_MAX    (2ULL*<a href="utils.md#ga23ec2cf7fc07ea8f817bbac758402baf">LLONG_MAX</a>+1)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p389018829084824"><a name="p389018829084824"></a><a name="p389018829084824"></a>Maximum value of type unsigned long long. </p>
</td>
</tr>
<tr id="row1920524065084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1314352550084824"><a name="p1314352550084824"></a><a name="p1314352550084824"></a><em id="gad2c1c798d36bdba42d5f4d50da5ae200"><a name="gad2c1c798d36bdba42d5f4d50da5ae200"></a><a name="gad2c1c798d36bdba42d5f4d50da5ae200"></a></em>PIPE_BUF    4096</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2034345424084824"><a name="p2034345424084824"></a><a name="p2034345424084824"></a>Buffer length of pipe. </p>
</td>
</tr>
<tr id="row1735396625084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1770145792084824"><a name="p1770145792084824"></a><a name="p1770145792084824"></a><em id="gac64541bdd81c961304b9babef1402640"><a name="gac64541bdd81c961304b9babef1402640"></a><a name="gac64541bdd81c961304b9babef1402640"></a></em>NAME_MAX    255</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1507736160084824"><a name="p1507736160084824"></a><a name="p1507736160084824"></a>Maximum length of file or directory name. </p>
</td>
</tr>
<tr id="row1120289432084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1966646873084824"><a name="p1966646873084824"></a><a name="p1966646873084824"></a><em id="gae688d728e1acdfe5988c7db45d6f0166"><a name="gae688d728e1acdfe5988c7db45d6f0166"></a><a name="gae688d728e1acdfe5988c7db45d6f0166"></a></em>PATH_MAX    256</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1702641042084824"><a name="p1702641042084824"></a><a name="p1702641042084824"></a>Maximum length of the whole file or directory path. </p>
</td>
</tr>
<tr id="row120065602084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1686493756084824"><a name="p1686493756084824"></a><a name="p1686493756084824"></a><em id="ga7dd33d4d7fdd2221a03ce948d7419424"><a name="ga7dd33d4d7fdd2221a03ce948d7419424"></a><a name="ga7dd33d4d7fdd2221a03ce948d7419424"></a></em>ARG_MAX    4096</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p727403010084824"><a name="p727403010084824"></a><a name="p727403010084824"></a>Maximum length of parameter arg. </p>
</td>
</tr>
<tr id="row100695634084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1068919527084824"><a name="p1068919527084824"></a><a name="p1068919527084824"></a><em id="ga25080e819a36fcf9aede01a6e7298ea4"><a name="ga25080e819a36fcf9aede01a6e7298ea4"></a><a name="ga25080e819a36fcf9aede01a6e7298ea4"></a></em>IOV_MAX    1024</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1710205256084824"><a name="p1710205256084824"></a><a name="p1710205256084824"></a>Maximum vector number. </p>
</td>
</tr>
<tr id="row1476624859084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p964395360084824"><a name="p964395360084824"></a><a name="p964395360084824"></a><em id="gaf95e2cdeed2bb68c59e2c3d07b6c3d04"><a name="gaf95e2cdeed2bb68c59e2c3d07b6c3d04"></a><a name="gaf95e2cdeed2bb68c59e2c3d07b6c3d04"></a></em>WORD_BIT    32</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p390680157084824"><a name="p390680157084824"></a><a name="p390680157084824"></a>Number of bits in word. </p>
</td>
</tr>
<tr id="row420169197084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1403621520084824"><a name="p1403621520084824"></a><a name="p1403621520084824"></a><em id="ga2d6569aa794c2f23e90691e60d2f3ad2"><a name="ga2d6569aa794c2f23e90691e60d2f3ad2"></a><a name="ga2d6569aa794c2f23e90691e60d2f3ad2"></a></em>SSIZE_MAX    <a href="utils.md#ga50fece4db74f09568b2938db583c5655">LONG_MAX</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1860360531084824"><a name="p1860360531084824"></a><a name="p1860360531084824"></a>Maximum value of type ssize_t. </p>
</td>
</tr>
<tr id="row1622709687084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1188542946084824"><a name="p1188542946084824"></a><a name="p1188542946084824"></a><em id="gac956117a90023ec0971b8f9fce9dec75"><a name="gac956117a90023ec0971b8f9fce9dec75"></a><a name="gac956117a90023ec0971b8f9fce9dec75"></a></em>HOST_NAME_MAX    255</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1637019340084824"><a name="p1637019340084824"></a><a name="p1637019340084824"></a>Maximum length of host name. </p>
</td>
</tr>
<tr id="row1291103057084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p711020750084824"><a name="p711020750084824"></a><a name="p711020750084824"></a><em id="ga88c78a5170af546a3417d28875fd3710"><a name="ga88c78a5170af546a3417d28875fd3710"></a><a name="ga88c78a5170af546a3417d28875fd3710"></a></em>LONG_BIT    32</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1996729164084824"><a name="p1996729164084824"></a><a name="p1996729164084824"></a>Number of bits in long. </p>
</td>
</tr>
<tr id="row570541114084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1018173505084824"><a name="p1018173505084824"></a><a name="p1018173505084824"></a><em id="gad1516b4f64b6dc890b1fa3bf576bfef9"><a name="gad1516b4f64b6dc890b1fa3bf576bfef9"></a><a name="gad1516b4f64b6dc890b1fa3bf576bfef9"></a></em>MQ_PRIO_MAX    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1764814874084824"><a name="p1764814874084824"></a><a name="p1764814874084824"></a>Maximum priority number of message queue. </p>
</td>
</tr>
<tr id="row618858825084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1806011404084824"><a name="p1806011404084824"></a><a name="p1806011404084824"></a><em id="ga519adc2af3ba06a8f0548b6690050a89"><a name="ga519adc2af3ba06a8f0548b6690050a89"></a><a name="ga519adc2af3ba06a8f0548b6690050a89"></a></em>PAGESIZE    4096</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1885589371084824"><a name="p1885589371084824"></a><a name="p1885589371084824"></a>Page size. </p>
</td>
</tr>
<tr id="row1668498089084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p903835745084824"><a name="p903835745084824"></a><a name="p903835745084824"></a><em id="ga7d467c1d283fdfa1f2081ba1e0d01b6e"><a name="ga7d467c1d283fdfa1f2081ba1e0d01b6e"></a><a name="ga7d467c1d283fdfa1f2081ba1e0d01b6e"></a></em>PAGE_SIZE    <a href="utils.md#ga519adc2af3ba06a8f0548b6690050a89">PAGESIZE</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p604075219084824"><a name="p604075219084824"></a><a name="p604075219084824"></a>Page size. </p>
</td>
</tr>
<tr id="row2072289521084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1989031424084824"><a name="p1989031424084824"></a><a name="p1989031424084824"></a><a href="utils.md#gaa0628ab596c3d7e78f5e08c2d98e24da">va_start</a>(v, l)   __builtin_va_start(v,l)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p8304547084824"><a name="p8304547084824"></a><a name="p8304547084824"></a>Defines the start position of the variable-length argument list. </p>
</td>
</tr>
<tr id="row252660452084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p106631126084824"><a name="p106631126084824"></a><a name="p106631126084824"></a><a href="utils.md#ga823b205416e9129825841b74c3bf8484">va_end</a>(v)   __builtin_va_end(v)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p4561485084824"><a name="p4561485084824"></a><a name="p4561485084824"></a>Ends a variable-length argument list. </p>
</td>
</tr>
<tr id="row1517396668084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p757179823084824"><a name="p757179823084824"></a><a name="p757179823084824"></a><a href="utils.md#ga9cfd655f1203c9a345ddd90446f0bcee">va_arg</a>(v, l)   __builtin_va_arg(v,l)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1744758261084824"><a name="p1744758261084824"></a><a name="p1744758261084824"></a>Obtains the next argument in the variable-length argument list. </p>
</td>
</tr>
<tr id="row1382971629084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p497098185084824"><a name="p497098185084824"></a><a name="p497098185084824"></a><a href="utils.md#ga23a32070bb5595761e7ed3884a84eb4a">va_copy</a>(d, s)   __builtin_va_copy(d,s)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1738908024084824"><a name="p1738908024084824"></a><a name="p1738908024084824"></a>Copies the previously initialized variable argument list <strong id="b303570121084824"><a name="b303570121084824"></a><a name="b303570121084824"></a>s</strong> to <strong id="b1039681416084824"><a name="b1039681416084824"></a><a name="b1039681416084824"></a>d</strong>. </p>
</td>
</tr>
<tr id="row55294027084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p884596531084824"><a name="p884596531084824"></a><a name="p884596531084824"></a><a href="utils.md#ga6dfceaa174558eaee80a23cb09139dfd">strdupa</a>(x)   <a href="utils.md#ga7a82515b5d377be04817715c5465b647">strcpy</a>(alloca(<a href="utils.md#gaa383452fe445bfae989358c9d7d96f4f">strlen</a>(x)+1),x)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1815811596084824"><a name="p1815811596084824"></a><a name="p1815811596084824"></a>Copies a string to a new position. </p>
</td>
</tr>
<tr id="row865343676084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p370032382084824"><a name="p370032382084824"></a><a name="p370032382084824"></a><em id="gafcf80a6d91178952d107ad00b165752b"><a name="gafcf80a6d91178952d107ad00b165752b"></a><a name="gafcf80a6d91178952d107ad00b165752b"></a></em>STDIN_FILENO    0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p636541536084824"><a name="p636541536084824"></a><a name="p636541536084824"></a>Descriptor ID of the standard input file. </p>
</td>
</tr>
<tr id="row595796268084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p904926648084824"><a name="p904926648084824"></a><a name="p904926648084824"></a><em id="gabd165ee6474b5b75bf075842fff13a04"><a name="gabd165ee6474b5b75bf075842fff13a04"></a><a name="gabd165ee6474b5b75bf075842fff13a04"></a></em>STDOUT_FILENO    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1906055398084824"><a name="p1906055398084824"></a><a name="p1906055398084824"></a>Descriptor ID of the standard output file. </p>
</td>
</tr>
<tr id="row1302625319084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1018828630084824"><a name="p1018828630084824"></a><a name="p1018828630084824"></a><em id="gae2fe1725bb5e9823d089c46b9ed5266e"><a name="gae2fe1725bb5e9823d089c46b9ed5266e"></a><a name="gae2fe1725bb5e9823d089c46b9ed5266e"></a></em>STDERR_FILENO    2</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1558948550084824"><a name="p1558948550084824"></a><a name="p1558948550084824"></a>Descriptor ID of the standard error file. </p>
</td>
</tr>
<tr id="row1787625568084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1676135218084824"><a name="p1676135218084824"></a><a name="p1676135218084824"></a><em id="ga0d112bae8fd35be772185b6ec6bcbe64"><a name="ga0d112bae8fd35be772185b6ec6bcbe64"></a><a name="ga0d112bae8fd35be772185b6ec6bcbe64"></a></em>SEEK_SET    0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1102845176084824"><a name="p1102845176084824"></a><a name="p1102845176084824"></a>Relocation starts from the file header. </p>
</td>
</tr>
<tr id="row663151324084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1695603885084824"><a name="p1695603885084824"></a><a name="p1695603885084824"></a><em id="ga4c8d0b76b470ba65a43ca46a88320f39"><a name="ga4c8d0b76b470ba65a43ca46a88320f39"></a><a name="ga4c8d0b76b470ba65a43ca46a88320f39"></a></em>SEEK_CUR    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p328045211084824"><a name="p328045211084824"></a><a name="p328045211084824"></a>Relocation starts from the position of the currently accessed file. </p>
</td>
</tr>
<tr id="row125531990084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1447302040084824"><a name="p1447302040084824"></a><a name="p1447302040084824"></a><em id="gad2a2e6c114780c3071efd24f16c7f7d8"><a name="gad2a2e6c114780c3071efd24f16c7f7d8"></a><a name="gad2a2e6c114780c3071efd24f16c7f7d8"></a></em>SEEK_END    2</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p313238265084824"><a name="p313238265084824"></a><a name="p313238265084824"></a>Relocation starts from the end of the file. </p>
</td>
</tr>
<tr id="row649405640084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p539222768084824"><a name="p539222768084824"></a><a name="p539222768084824"></a><em id="ga070d2ce7b6bb7e5c05602aa8c308d0c4"><a name="ga070d2ce7b6bb7e5c05602aa8c308d0c4"></a><a name="ga070d2ce7b6bb7e5c05602aa8c308d0c4"></a></em>NULL    ((void*)0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p808710279084824"><a name="p808710279084824"></a><a name="p808710279084824"></a>NULL. </p>
</td>
</tr>
<tr id="row1477766854084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1027684485084824"><a name="p1027684485084824"></a><a name="p1027684485084824"></a><em id="gaf837744613408b57dc3654fbc3bcf900"><a name="gaf837744613408b57dc3654fbc3bcf900"></a><a name="gaf837744613408b57dc3654fbc3bcf900"></a></em>F_OK    0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p589766507084824"><a name="p589766507084824"></a><a name="p589766507084824"></a>Existing file. </p>
</td>
</tr>
<tr id="row829950010084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p164280604084824"><a name="p164280604084824"></a><a name="p164280604084824"></a><em id="ga24a7a0ceb1e8f5f44cb1038bb829030d"><a name="ga24a7a0ceb1e8f5f44cb1038bb829030d"></a><a name="ga24a7a0ceb1e8f5f44cb1038bb829030d"></a></em>R_OK    4</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1068386036084824"><a name="p1068386036084824"></a><a name="p1068386036084824"></a>Readable file. </p>
</td>
</tr>
<tr id="row154590314084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p671033405084824"><a name="p671033405084824"></a><a name="p671033405084824"></a><em id="gae5acf4043c0903cda7436b108e29e8e6"><a name="gae5acf4043c0903cda7436b108e29e8e6"></a><a name="gae5acf4043c0903cda7436b108e29e8e6"></a></em>W_OK    2</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1497871810084824"><a name="p1497871810084824"></a><a name="p1497871810084824"></a>Writable file. </p>
</td>
</tr>
<tr id="row881292479084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1774867768084824"><a name="p1774867768084824"></a><a name="p1774867768084824"></a><em id="ga5e995ef7690698b62bf016b14fbc45ca"><a name="ga5e995ef7690698b62bf016b14fbc45ca"></a><a name="ga5e995ef7690698b62bf016b14fbc45ca"></a></em>X_OK    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1900208202084824"><a name="p1900208202084824"></a><a name="p1900208202084824"></a>Executable file. </p>
</td>
</tr>
</tbody>
</table>

## Typedefs<a name="typedef-members"></a>

<a name="table70838056084824"></a>
<table><thead align="left"><tr id="row1789291375084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p149734733084824"><a name="p149734733084824"></a><a name="p149734733084824"></a>Typedef Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1598266482084824"><a name="p1598266482084824"></a><a name="p1598266482084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1329045913084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1647485389084824"><a name="p1647485389084824"></a><a name="p1647485389084824"></a><em id="gaf609835b21489409e39a22ed20313ab8"><a name="gaf609835b21489409e39a22ed20313ab8"></a><a name="gaf609835b21489409e39a22ed20313ab8"></a></em>ENTRY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p197197868084824"><a name="p197197868084824"></a><a name="p197197868084824"></a><strong id="b683649542"><a name="b683649542"></a><a name="b683649542"></a></strong> typedef struct <a href="entry.md">entry</a> </p>
<p id="p1077388025084824"><a name="p1077388025084824"></a><a name="p1077388025084824"></a>Defines a hash table entry. </p>
</td>
</tr>
</tbody>
</table>

## Functions<a name="func-members"></a>

<a name="table1995448520084824"></a>
<table><thead align="left"><tr id="row1365950101084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2056317386084824"><a name="p2056317386084824"></a><a name="p2056317386084824"></a>Function Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p164289768084824"><a name="p164289768084824"></a><a name="p164289768084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row604700432084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1123898242084824"><a name="p1123898242084824"></a><a name="p1123898242084824"></a><a href="utils.md#gaa25acd51546dafe1b44c97de30188589">crypt</a> (const char *key, const char *setting)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1193424655084824"><a name="p1193424655084824"></a><a name="p1193424655084824"></a>char * </p>
<p id="p1283698062084824"><a name="p1283698062084824"></a><a name="p1283698062084824"></a>Encrypts data. </p>
</td>
</tr>
<tr id="row163030826084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p55104155084824"><a name="p55104155084824"></a><a name="p55104155084824"></a><a href="utils.md#gadf38e126f73a010f30af76db2a28c6e1">isalnum</a> (int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1226814368084824"><a name="p1226814368084824"></a><a name="p1226814368084824"></a>int </p>
<p id="p401819880084824"><a name="p401819880084824"></a><a name="p401819880084824"></a>Checks whether a parameter is an alphabetic character or a decimal digit. </p>
</td>
</tr>
<tr id="row1271784316084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1772293298084824"><a name="p1772293298084824"></a><a name="p1772293298084824"></a><a href="utils.md#ga25908ae63aac2df990634e1ae5bd14d9">isalpha</a> (int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1253362335084824"><a name="p1253362335084824"></a><a name="p1253362335084824"></a>int </p>
<p id="p294469482084824"><a name="p294469482084824"></a><a name="p294469482084824"></a>Checks whether a parameter is an alphabetic character. </p>
</td>
</tr>
<tr id="row960680376084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p776722287084824"><a name="p776722287084824"></a><a name="p776722287084824"></a><a href="utils.md#gaea4929b1b41f1a6d723e0312b1f050ed">isblank</a> (int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1322883139084824"><a name="p1322883139084824"></a><a name="p1322883139084824"></a>int </p>
<p id="p1946124995084824"><a name="p1946124995084824"></a><a name="p1946124995084824"></a>Checks whether a parameter is a blank character (space or tap). </p>
</td>
</tr>
<tr id="row1978372880084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1758387487084824"><a name="p1758387487084824"></a><a name="p1758387487084824"></a><a href="utils.md#ga0008a4e8e7889734dc1d83297de07158">iscntrl</a> (int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1112492569084824"><a name="p1112492569084824"></a><a name="p1112492569084824"></a>int </p>
<p id="p412102899084824"><a name="p412102899084824"></a><a name="p412102899084824"></a>Checks whether a parameter is a control character. A control character is invisible and does not occupy a printing position on a display. </p>
</td>
</tr>
<tr id="row115611821084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p971844018084824"><a name="p971844018084824"></a><a name="p971844018084824"></a><a href="utils.md#ga3fa45b35c8abf67a950b6d3d4063dede">isdigit</a> (int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p381439943084824"><a name="p381439943084824"></a><a name="p381439943084824"></a>int </p>
<p id="p1757772400084824"><a name="p1757772400084824"></a><a name="p1757772400084824"></a>Checks whether a parameter is a decimal digit (0-9). </p>
</td>
</tr>
<tr id="row1769322650084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p914761553084824"><a name="p914761553084824"></a><a name="p914761553084824"></a><a href="utils.md#ga49f40fd869fd0c90e4497fda08c89561">isgraph</a> (int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p210665257084824"><a name="p210665257084824"></a><a name="p210665257084824"></a>int </p>
<p id="p2125538902084824"><a name="p2125538902084824"></a><a name="p2125538902084824"></a>Checks whether a parameter is any printable character except the space character. </p>
</td>
</tr>
<tr id="row1365623902084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p134181477084824"><a name="p134181477084824"></a><a name="p134181477084824"></a><a href="utils.md#ga7b8f652a0423a80922dd89d8829db5f2">islower</a> (int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1261479239084824"><a name="p1261479239084824"></a><a name="p1261479239084824"></a>int </p>
<p id="p207560360084824"><a name="p207560360084824"></a><a name="p207560360084824"></a>Checks whether a parameter is a lowercase letter. </p>
</td>
</tr>
<tr id="row1650086213084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1584138445084824"><a name="p1584138445084824"></a><a name="p1584138445084824"></a><a href="utils.md#ga99355d8f0fb41ec43effb95189db0ed4">isprint</a> (int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p838920045084824"><a name="p838920045084824"></a><a name="p838920045084824"></a>int </p>
<p id="p674043974084824"><a name="p674043974084824"></a><a name="p674043974084824"></a>Checks whether a parameter is a printable character (including space). </p>
</td>
</tr>
<tr id="row735193052084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p776209036084824"><a name="p776209036084824"></a><a name="p776209036084824"></a><a href="utils.md#gaf29554b3ec04ea7684482bffed5dbce6">ispunct</a> (int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p793581783084824"><a name="p793581783084824"></a><a name="p793581783084824"></a>int </p>
<p id="p1326279004084824"><a name="p1326279004084824"></a><a name="p1326279004084824"></a>Checks whether a parameter is a punctuation or special character. </p>
</td>
</tr>
<tr id="row1669528740084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p697678373084824"><a name="p697678373084824"></a><a name="p697678373084824"></a><a href="utils.md#ga56be4166e4673843042a548a7f513dbc">isspace</a> (int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1368629126084824"><a name="p1368629126084824"></a><a name="p1368629126084824"></a>int </p>
<p id="p2107391232084824"><a name="p2107391232084824"></a><a name="p2107391232084824"></a>Checks whether a parameter is a space character. </p>
</td>
</tr>
<tr id="row320638157084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p393001232084824"><a name="p393001232084824"></a><a name="p393001232084824"></a><a href="utils.md#gadadd6582d46775aab6a51e29d16d9f77">isupper</a> (int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p384156420084824"><a name="p384156420084824"></a><a name="p384156420084824"></a>int </p>
<p id="p705291855084824"><a name="p705291855084824"></a><a name="p705291855084824"></a>Checks whether a parameter is an uppercase letter. </p>
</td>
</tr>
<tr id="row2008993298084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p176267918084824"><a name="p176267918084824"></a><a name="p176267918084824"></a><a href="utils.md#gadaf3aadefe3fc4fb07b6be0d7b880f53">isxdigit</a> (int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p151872036084824"><a name="p151872036084824"></a><a name="p151872036084824"></a>int </p>
<p id="p2012235012084824"><a name="p2012235012084824"></a><a name="p2012235012084824"></a>Checks whether a parameter is a hexadecimal digit. </p>
</td>
</tr>
<tr id="row445256084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1099006996084824"><a name="p1099006996084824"></a><a name="p1099006996084824"></a><a href="utils.md#gac79d6114c9df7350cedcd8cf921a6ea4">tolower</a> (int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p263218114084824"><a name="p263218114084824"></a><a name="p263218114084824"></a>int </p>
<p id="p1776493594084824"><a name="p1776493594084824"></a><a name="p1776493594084824"></a>Converts an uppercase letter specified by <strong id="b210569070084824"><a name="b210569070084824"></a><a name="b210569070084824"></a>c</strong> to its lowercase equivalent. </p>
</td>
</tr>
<tr id="row270070229084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p197265528084824"><a name="p197265528084824"></a><a name="p197265528084824"></a><a href="utils.md#ga9c2f57ac3865af9006fdbfd5db9fd517">toupper</a> (int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1663762345084824"><a name="p1663762345084824"></a><a name="p1663762345084824"></a>int </p>
<p id="p239089405084824"><a name="p239089405084824"></a><a name="p239089405084824"></a>Converts a lowercase letter specified by <strong id="b1358493437084824"><a name="b1358493437084824"></a><a name="b1358493437084824"></a>c</strong> to its uppercase equivalent. </p>
</td>
</tr>
<tr id="row422840054084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1132163906084824"><a name="p1132163906084824"></a><a name="p1132163906084824"></a><a href="utils.md#gad87736859769a262b411b49819bc7a25">isalnum_l</a> (int c, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p666612912084824"><a name="p666612912084824"></a><a name="p666612912084824"></a>int </p>
<p id="p1200364994084824"><a name="p1200364994084824"></a><a name="p1200364994084824"></a>Checks whether a parameter is an alphabetic character or digit for the specified locale. </p>
</td>
</tr>
<tr id="row1328468023084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p278611313084824"><a name="p278611313084824"></a><a name="p278611313084824"></a><a href="utils.md#ga6de33cb463fb34283dc5c7c4c230aec4">isalpha_l</a> (int c, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p729047470084824"><a name="p729047470084824"></a><a name="p729047470084824"></a>int </p>
<p id="p1016394626084824"><a name="p1016394626084824"></a><a name="p1016394626084824"></a>Checks whether a parameter is an alphabetic character for the specified locale. </p>
</td>
</tr>
<tr id="row1499870627084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p766939348084824"><a name="p766939348084824"></a><a name="p766939348084824"></a><a href="utils.md#ga650853c2fb9fcf2e9c34ac06e1f6f2d6">isblank_l</a> (int c, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1885642651084824"><a name="p1885642651084824"></a><a name="p1885642651084824"></a>int </p>
<p id="p1883632934084824"><a name="p1883632934084824"></a><a name="p1883632934084824"></a>Checks whether a parameter is a blank character (including spaces and tabs) for the specified locale. </p>
</td>
</tr>
<tr id="row1477189321084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1031344810084824"><a name="p1031344810084824"></a><a name="p1031344810084824"></a><a href="utils.md#gad475d7607e183036b0add584bdf61b35">iscntrl_l</a> (int c, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1163600914084824"><a name="p1163600914084824"></a><a name="p1163600914084824"></a>int </p>
<p id="p2021776366084824"><a name="p2021776366084824"></a><a name="p2021776366084824"></a>Checks whether a parameter is a control character for the specified locale. </p>
</td>
</tr>
<tr id="row1083965559084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1479281166084824"><a name="p1479281166084824"></a><a name="p1479281166084824"></a><a href="utils.md#ga378e9ee0e69cbbb9ed948598f9aa920d">isdigit_l</a> (int c, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p715181305084824"><a name="p715181305084824"></a><a name="p715181305084824"></a>int </p>
<p id="p1817449722084824"><a name="p1817449722084824"></a><a name="p1817449722084824"></a>Checks whether a parameter is a decimal digit for the specified locale. </p>
</td>
</tr>
<tr id="row648030151084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1179703379084824"><a name="p1179703379084824"></a><a name="p1179703379084824"></a><a href="utils.md#gaab3732d493eec8b0c0a720d90dba210c">isgraph_l</a> (int c, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1012210333084824"><a name="p1012210333084824"></a><a name="p1012210333084824"></a>int </p>
<p id="p304485193084824"><a name="p304485193084824"></a><a name="p304485193084824"></a>Checks whether a parameter is any printable character except the space character for the specified locale. </p>
</td>
</tr>
<tr id="row678066260084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p938756070084824"><a name="p938756070084824"></a><a name="p938756070084824"></a><a href="utils.md#gad7c9319bbe71c048505cd30da34334ea">islower_l</a> (int c, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2032783752084824"><a name="p2032783752084824"></a><a name="p2032783752084824"></a>int </p>
<p id="p2030837721084824"><a name="p2030837721084824"></a><a name="p2030837721084824"></a>Checks whether a parameter is a character of lowercase letters for the specified locale. </p>
</td>
</tr>
<tr id="row1792774603084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p331820623084824"><a name="p331820623084824"></a><a name="p331820623084824"></a><a href="utils.md#gaaae36b62a22be9fa67640255ae77ee0d">isprint_l</a> (int c, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p487002762084824"><a name="p487002762084824"></a><a name="p487002762084824"></a>int </p>
<p id="p1103736952084824"><a name="p1103736952084824"></a><a name="p1103736952084824"></a>Checks whether a parameter is a printable character (including space) for the specified locale. A printable character is visible and occupies a printing position on a display. </p>
</td>
</tr>
<tr id="row798400169084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p354550705084824"><a name="p354550705084824"></a><a name="p354550705084824"></a><a href="utils.md#gaa04b7d22f0c24a9aa5a6f12e933405f8">ispunct_l</a> (int c, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2075679004084824"><a name="p2075679004084824"></a><a name="p2075679004084824"></a>int </p>
<p id="p48193026084824"><a name="p48193026084824"></a><a name="p48193026084824"></a>Checks whether a parameter is a punctuation or special character for the specified locale. </p>
</td>
</tr>
<tr id="row211676349084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p504083069084824"><a name="p504083069084824"></a><a name="p504083069084824"></a><a href="utils.md#ga6a6e04048d6363a76a333d17cac62f8a">isspace_l</a> (int c, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p377942336084824"><a name="p377942336084824"></a><a name="p377942336084824"></a>int </p>
<p id="p263327058084824"><a name="p263327058084824"></a><a name="p263327058084824"></a>Checks whether a parameter is a blank character for the specified locale. </p>
</td>
</tr>
<tr id="row711855597084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1230525626084824"><a name="p1230525626084824"></a><a name="p1230525626084824"></a><a href="utils.md#gae10ce576a584fe302d364196d48332c6">isupper_l</a> (int c, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1301938168084824"><a name="p1301938168084824"></a><a name="p1301938168084824"></a>int </p>
<p id="p74680328084824"><a name="p74680328084824"></a><a name="p74680328084824"></a>Checks whether a parameter is a character of uppercase letters for the specified locale. </p>
</td>
</tr>
<tr id="row422467750084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p50424244084824"><a name="p50424244084824"></a><a name="p50424244084824"></a><a href="utils.md#ga21c1d42504e331cf330026dcb47dcbe2">isxdigit_l</a> (int c, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p737036626084824"><a name="p737036626084824"></a><a name="p737036626084824"></a>int </p>
<p id="p232435914084824"><a name="p232435914084824"></a><a name="p232435914084824"></a>Checks whether a parameter is a hexadecimal digit for the specified locale. </p>
</td>
</tr>
<tr id="row2127731673084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p714519332084824"><a name="p714519332084824"></a><a name="p714519332084824"></a><a href="utils.md#ga1921ca31e425387ecff9c9c7657cd4b7">tolower_l</a> (int c, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p829172768084824"><a name="p829172768084824"></a><a name="p829172768084824"></a>int </p>
<p id="p7508105084824"><a name="p7508105084824"></a><a name="p7508105084824"></a>Converts an upper letter specified by <strong id="b1979814756084824"><a name="b1979814756084824"></a><a name="b1979814756084824"></a>c</strong> to its lowercase equivalent for the specified locale. </p>
</td>
</tr>
<tr id="row1536579292084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1547537174084824"><a name="p1547537174084824"></a><a name="p1547537174084824"></a><a href="utils.md#ga77ed6ccc1ae9841df0fc54ad62860715">toupper_l</a> (int c, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p860110481084824"><a name="p860110481084824"></a><a name="p860110481084824"></a>int </p>
<p id="p447290809084824"><a name="p447290809084824"></a><a name="p447290809084824"></a>Converts a lowercase letter specified by <strong id="b1108107475084824"><a name="b1108107475084824"></a><a name="b1108107475084824"></a>c</strong> to its uppercase equivalent for the specified locale. </p>
</td>
</tr>
<tr id="row59562640084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1405556993084824"><a name="p1405556993084824"></a><a name="p1405556993084824"></a><a href="utils.md#gae2edadcc847fa6a98adc9c485da806de">toascii</a> (int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1663550653084824"><a name="p1663550653084824"></a><a name="p1663550653084824"></a>int </p>
<p id="p754862153084824"><a name="p754862153084824"></a><a name="p754862153084824"></a>Converts a parameter of the integer type to an ASCII code. </p>
</td>
</tr>
<tr id="row1255485183084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p845365014084824"><a name="p845365014084824"></a><a name="p845365014084824"></a><a href="utils.md#ga41115d5b017933dcee85d41ed7a743e7">fmtmsg</a> (long classification, const char *label, int severity, const char *text, const char *action, const char *tag)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2124957474084824"><a name="p2124957474084824"></a><a name="p2124957474084824"></a>int </p>
<p id="p578351366084824"><a name="p578351366084824"></a><a name="p578351366084824"></a>Prints formatted messages. </p>
</td>
</tr>
<tr id="row574995012084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2070052737084824"><a name="p2070052737084824"></a><a name="p2070052737084824"></a><a href="utils.md#ga088b414f40eb0ce3dad9e5243816f68f">fnmatch</a> (const char *pattern, const char *string, int flags)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p83157704084824"><a name="p83157704084824"></a><a name="p83157704084824"></a>int </p>
<p id="p1485724338084824"><a name="p1485724338084824"></a><a name="p1485724338084824"></a>Matches a file name or a path name. </p>
</td>
</tr>
<tr id="row1456255755084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1719479398084824"><a name="p1719479398084824"></a><a name="p1719479398084824"></a><a href="utils.md#ga3d26a6a51c3a1576b36c66798a64a3cf">getopt_long</a> (int argc, char *const *argv, const char *optstring, const struct <a href="option.md">option</a> *longopts, int *longindex)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1627023025084824"><a name="p1627023025084824"></a><a name="p1627023025084824"></a>int </p>
<p id="p179399641084824"><a name="p179399641084824"></a><a name="p179399641084824"></a>Parses the command-line arguments. </p>
</td>
</tr>
<tr id="row681837957084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1038708822084824"><a name="p1038708822084824"></a><a name="p1038708822084824"></a><a href="utils.md#ga6606cd658b7339db0fab03d3454bd29c">getopt_long_only</a> (int argc, char *const *argv, const char *optstring, const struct <a href="option.md">option</a> *longopts, int *longindex)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p182679135084824"><a name="p182679135084824"></a><a name="p182679135084824"></a>int </p>
<p id="p398736433084824"><a name="p398736433084824"></a><a name="p398736433084824"></a>Parses the command-line arguments. </p>
</td>
</tr>
<tr id="row1533805719084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1203550442084824"><a name="p1203550442084824"></a><a name="p1203550442084824"></a><a href="utils.md#gad9e8a565a34b6981f500d88773ec7bcd">imaxabs</a> (intmax_t j)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2005448775084824"><a name="p2005448775084824"></a><a name="p2005448775084824"></a>intmax_t </p>
<p id="p338931096084824"><a name="p338931096084824"></a><a name="p338931096084824"></a>Calculates the absolute value of an input parameter of the integer type. </p>
</td>
</tr>
<tr id="row42592926084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1648543741084824"><a name="p1648543741084824"></a><a name="p1648543741084824"></a><a href="utils.md#ga17335f74f0abcfd3047de48f6823f527">imaxdiv</a> (intmax_t numerator, intmax_t denominator)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p892207825084824"><a name="p892207825084824"></a><a name="p892207825084824"></a><a href="imaxdiv_t.md">imaxdiv_t</a> </p>
<p id="p511722489084824"><a name="p511722489084824"></a><a name="p511722489084824"></a>Calculates the quotient and remainder after the division operation is performed on an integer. </p>
</td>
</tr>
<tr id="row1055562714084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p376840420084824"><a name="p376840420084824"></a><a name="p376840420084824"></a><a href="utils.md#ga996146b4c9a860837a1f09868a6c0a61">strtoimax</a> (const char *str, char **endptr, int base)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1602308381084824"><a name="p1602308381084824"></a><a name="p1602308381084824"></a>intmax_t </p>
<p id="p1030146657084824"><a name="p1030146657084824"></a><a name="p1030146657084824"></a>Parses a string to a value of the <strong id="b1346717313084824"><a name="b1346717313084824"></a><a name="b1346717313084824"></a>intmax_t</strong> type. </p>
</td>
</tr>
<tr id="row1537640671084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1944778759084824"><a name="p1944778759084824"></a><a name="p1944778759084824"></a><a href="utils.md#ga706f89e2b5a9a623207f2d77b19ff6f8">strtoumax</a> (const char *str, char **endptr, int base)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1992763389084824"><a name="p1992763389084824"></a><a name="p1992763389084824"></a>uintmax_t </p>
<p id="p683557744084824"><a name="p683557744084824"></a><a name="p683557744084824"></a>Parses a string to a value of the <strong id="b1431043400084824"><a name="b1431043400084824"></a><a name="b1431043400084824"></a>uintmax_t</strong> type. </p>
</td>
</tr>
<tr id="row1971474750084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p195649600084824"><a name="p195649600084824"></a><a name="p195649600084824"></a><a href="utils.md#gaab72fde556caed7f725c0bece02e4cc9">wcstoimax</a> (const wchar_t *str, wchar_t **endptr, int base)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p441551615084824"><a name="p441551615084824"></a><a name="p441551615084824"></a>intmax_t </p>
<p id="p380385138084824"><a name="p380385138084824"></a><a name="p380385138084824"></a>Parses a string to a value of the <strong id="b1187355018084824"><a name="b1187355018084824"></a><a name="b1187355018084824"></a>intmax_t</strong> type. </p>
</td>
</tr>
<tr id="row799507674084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1214189540084824"><a name="p1214189540084824"></a><a name="p1214189540084824"></a><a href="utils.md#gaaf3fa62320e289517f453bf1e470a1f9">wcstoumax</a> (const wchar_t *str, wchar_t **endptr, int base)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2060082756084824"><a name="p2060082756084824"></a><a name="p2060082756084824"></a>uintmax_t </p>
<p id="p1590711229084824"><a name="p1590711229084824"></a><a name="p1590711229084824"></a>Parses a string to a value of the <strong id="b1851543904084824"><a name="b1851543904084824"></a><a name="b1851543904084824"></a>uintmax_t</strong> type. </p>
</td>
</tr>
<tr id="row1810940445084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1253410394084824"><a name="p1253410394084824"></a><a name="p1253410394084824"></a><a href="utils.md#ga3a0a6c5c58dd47a875b745fca1a558fa">strfmon</a> (char *s, size_t max, const char *format,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1879163245084824"><a name="p1879163245084824"></a><a name="p1879163245084824"></a>ssize_t </p>
<p id="p672671175084824"><a name="p672671175084824"></a><a name="p672671175084824"></a>Converts a monetary value to a string. </p>
</td>
</tr>
<tr id="row394408899084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1716763930084824"><a name="p1716763930084824"></a><a name="p1716763930084824"></a><a href="utils.md#gafb18cb23be808765135c3aa903df62fd">hcreate</a> (size_t nel)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p501835921084824"><a name="p501835921084824"></a><a name="p501835921084824"></a>int </p>
<p id="p121997229084824"><a name="p121997229084824"></a><a name="p121997229084824"></a>Creates a hash table based on the number of entries. </p>
</td>
</tr>
<tr id="row1367314906084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1652495529084824"><a name="p1652495529084824"></a><a name="p1652495529084824"></a><a href="utils.md#ga883c8dedada64c9525c78bfa56ad69bf">hdestroy</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1570673035084824"><a name="p1570673035084824"></a><a name="p1570673035084824"></a>void </p>
<p id="p1219722553084824"><a name="p1219722553084824"></a><a name="p1219722553084824"></a>Destroys a hash table. </p>
</td>
</tr>
<tr id="row640774547084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1612514838084824"><a name="p1612514838084824"></a><a name="p1612514838084824"></a><a href="utils.md#ga8082cd062e20579f6a981bb73963b3f4">hsearch</a> (<a href="utils.md#gaf609835b21489409e39a22ed20313ab8">ENTRY</a> item, ACTION action)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2615033084824"><a name="p2615033084824"></a><a name="p2615033084824"></a><a href="utils.md#gaf609835b21489409e39a22ed20313ab8">ENTRY</a> * </p>
<p id="p927073434084824"><a name="p927073434084824"></a><a name="p927073434084824"></a>Adds or searches for a hash entry. </p>
</td>
</tr>
<tr id="row1479392109084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p515541346084824"><a name="p515541346084824"></a><a name="p515541346084824"></a><a href="utils.md#ga038ec523340da68e90a5f22e1e4e5520">hcreate_r</a> (size_t nel, struct <a href="hsearch_data.md">hsearch_data</a> *htab)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p280660820084824"><a name="p280660820084824"></a><a name="p280660820084824"></a>int </p>
<p id="p424824127084824"><a name="p424824127084824"></a><a name="p424824127084824"></a>Creates a hash table based on the number of entries and its description. </p>
</td>
</tr>
<tr id="row717431227084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1924159502084824"><a name="p1924159502084824"></a><a name="p1924159502084824"></a><a href="utils.md#gafb5169db08a09e98495c26bdd7e6d8dc">hdestroy_r</a> (struct <a href="hsearch_data.md">hsearch_data</a> *htab)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p932428966084824"><a name="p932428966084824"></a><a name="p932428966084824"></a>void </p>
<p id="p847046885084824"><a name="p847046885084824"></a><a name="p847046885084824"></a>Destroys a hash table. </p>
</td>
</tr>
<tr id="row1045076812084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2145805335084824"><a name="p2145805335084824"></a><a name="p2145805335084824"></a><a href="utils.md#ga22072d94699358ab02286f4c7b6aac55">hsearch_r</a> (<a href="utils.md#gaf609835b21489409e39a22ed20313ab8">ENTRY</a> item, ACTION action, <a href="utils.md#gaf609835b21489409e39a22ed20313ab8">ENTRY</a> **retval, struct <a href="hsearch_data.md">hsearch_data</a> *htab)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p394228244084824"><a name="p394228244084824"></a><a name="p394228244084824"></a>int </p>
<p id="p1743327346084824"><a name="p1743327346084824"></a><a name="p1743327346084824"></a>Searches for a hash table. </p>
</td>
</tr>
<tr id="row1393381246084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1313692630084824"><a name="p1313692630084824"></a><a name="p1313692630084824"></a><a href="utils.md#ga7dc680d5d6d07984f96737c220058d64">insque</a> (void *element, void *pred)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p391112016084824"><a name="p391112016084824"></a><a name="p391112016084824"></a>void </p>
<p id="p278602197084824"><a name="p278602197084824"></a><a name="p278602197084824"></a>Adds an entry to a queue. </p>
</td>
</tr>
<tr id="row187088782084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1364580806084824"><a name="p1364580806084824"></a><a name="p1364580806084824"></a><a href="utils.md#ga1d2e353620a8dc3bb2702831607a3fc1">remque</a> (void *elem)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1725870454084824"><a name="p1725870454084824"></a><a name="p1725870454084824"></a>void </p>
<p id="p1769422567084824"><a name="p1769422567084824"></a><a name="p1769422567084824"></a>Removes an entry from a queue. </p>
</td>
</tr>
<tr id="row702735936084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1332648045084824"><a name="p1332648045084824"></a><a name="p1332648045084824"></a><a href="utils.md#ga2e48c29ae7f3ef8f5707f4cc4f4ef608">lsearch</a> (const void *key, const void *base, size_t *nelp, size_t width, int(*compar)(const void *, const void *))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p528318313084824"><a name="p528318313084824"></a><a name="p528318313084824"></a>void * </p>
<p id="p605507128084824"><a name="p605507128084824"></a><a name="p605507128084824"></a>Performs a linear search for a key in the array and adds a key to the end of the array if the key is not found. </p>
</td>
</tr>
<tr id="row142112273084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p586077816084824"><a name="p586077816084824"></a><a name="p586077816084824"></a><a href="utils.md#ga9f8c694512c6c8a53f7e5a5f5e25cf86">lfind</a> (const void *key, const void *base, size_t *nelp, size_t width, int(*compar)(const void *, const void *))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1461771739084824"><a name="p1461771739084824"></a><a name="p1461771739084824"></a>void * </p>
<p id="p1444924897084824"><a name="p1444924897084824"></a><a name="p1444924897084824"></a>Performs a linear search for a key in the array. </p>
</td>
</tr>
<tr id="row127932521084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p168002541084824"><a name="p168002541084824"></a><a name="p168002541084824"></a><a href="utils.md#ga58961b9d8ec6333735b53fd0999eff17">tdelete</a> (const void *key, void **rootp, int(*compar)(const void *, const void *))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p335100973084824"><a name="p335100973084824"></a><a name="p335100973084824"></a>void * </p>
<p id="p1339657803084824"><a name="p1339657803084824"></a><a name="p1339657803084824"></a>Deletes a key from the binary tree. </p>
</td>
</tr>
<tr id="row1964182312084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2134532375084824"><a name="p2134532375084824"></a><a name="p2134532375084824"></a><a href="utils.md#ga576dc73ee732b840e09c88972b7d487e">tfind</a> (const void *key, void *const *rootp, int(*compar)(const void *, const void *))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1893658217084824"><a name="p1893658217084824"></a><a name="p1893658217084824"></a>void * </p>
<p id="p782173421084824"><a name="p782173421084824"></a><a name="p782173421084824"></a>Searches for a key in the binary tree. </p>
</td>
</tr>
<tr id="row2127413160084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p861169103084824"><a name="p861169103084824"></a><a name="p861169103084824"></a><a href="utils.md#ga197c455a4e5f17cb8565be72d18344cc">tsearch</a> (const void *key, void *const *rootp, int(*compar)(const void *, const void *))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1591353637084824"><a name="p1591353637084824"></a><a name="p1591353637084824"></a>void * </p>
<p id="p1195566723084824"><a name="p1195566723084824"></a><a name="p1195566723084824"></a>Searches for a key in the binary tree and adds a key to the tree if the key is not found. </p>
</td>
</tr>
<tr id="row87920163084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p241749004084824"><a name="p241749004084824"></a><a name="p241749004084824"></a><a href="utils.md#ga4d8ee780402dd74ec06e7b5089565168">twalk</a> (const void *root, void(*action)(const void *nodep, VISIT which, int depth))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p321931181084824"><a name="p321931181084824"></a><a name="p321931181084824"></a>void </p>
<p id="p1123572872084824"><a name="p1123572872084824"></a><a name="p1123572872084824"></a>Traverses a binary tree from left to right. </p>
</td>
</tr>
<tr id="row404691474084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1572272303084824"><a name="p1572272303084824"></a><a name="p1572272303084824"></a><a href="utils.md#gab12d1869fd9d20ce6706fcef217ba222">tdestroy</a> (void *root, void(*free_node)(void *nodep))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1076088424084824"><a name="p1076088424084824"></a><a name="p1076088424084824"></a>void </p>
<p id="p737246519084824"><a name="p737246519084824"></a><a name="p737246519084824"></a>Releases all nodes in the binary tree. </p>
</td>
</tr>
<tr id="row742046630084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1861685583084824"><a name="p1861685583084824"></a><a name="p1861685583084824"></a><a href="utils.md#gad228deceea1bac4d9f171f647c265059">atoi</a> (const char *nptr)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1322358951084824"><a name="p1322358951084824"></a><a name="p1322358951084824"></a>int </p>
<p id="p1591463723084824"><a name="p1591463723084824"></a><a name="p1591463723084824"></a>Converts an input string to an integer. </p>
</td>
</tr>
<tr id="row1715846571084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1183693570084824"><a name="p1183693570084824"></a><a name="p1183693570084824"></a><a href="utils.md#ga185551efd32d058ef290ebe2d144219f">atol</a> (const char *nptr)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p54301429084824"><a name="p54301429084824"></a><a name="p54301429084824"></a>long </p>
<p id="p196532972084824"><a name="p196532972084824"></a><a name="p196532972084824"></a>Converts an input string to a long integer. </p>
</td>
</tr>
<tr id="row1245901838084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p346648429084824"><a name="p346648429084824"></a><a name="p346648429084824"></a><a href="utils.md#ga5d0555f6ac42472671281e5903244b7b">atoll</a> (const char *nptr)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1456925306084824"><a name="p1456925306084824"></a><a name="p1456925306084824"></a>long long </p>
<p id="p500426072084824"><a name="p500426072084824"></a><a name="p500426072084824"></a>Converts a string to an 8-byte long integer. </p>
</td>
</tr>
<tr id="row985066354084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1621077380084824"><a name="p1621077380084824"></a><a name="p1621077380084824"></a><a href="utils.md#gac03da055b7752247b034fb582cb4372f">atof</a> (const char *nptr)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p564784743084824"><a name="p564784743084824"></a><a name="p564784743084824"></a>double </p>
<p id="p648392664084824"><a name="p648392664084824"></a><a name="p648392664084824"></a>Converts an input string to a double-precision floating-point number. </p>
</td>
</tr>
<tr id="row1911155439084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1211601662084824"><a name="p1211601662084824"></a><a name="p1211601662084824"></a><a href="utils.md#ga2370632318c3797a314f8eb62d37947c">strtof</a> (const char *nptr, char **endptr)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p151642158084824"><a name="p151642158084824"></a><a name="p151642158084824"></a>float </p>
<p id="p394048703084824"><a name="p394048703084824"></a><a name="p394048703084824"></a>Converts an input string to a floating-point number. </p>
</td>
</tr>
<tr id="row592130399084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1025701749084824"><a name="p1025701749084824"></a><a name="p1025701749084824"></a><a href="utils.md#ga0c17a0b44f572941d9f73518f99ea7ed">strtod</a> (const char *nptr, char **endptr)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2131884419084824"><a name="p2131884419084824"></a><a name="p2131884419084824"></a>double </p>
<p id="p1265756820084824"><a name="p1265756820084824"></a><a name="p1265756820084824"></a>Converts a string to <strong id="b1201914229084824"><a name="b1201914229084824"></a><a name="b1201914229084824"></a>double</strong>. </p>
</td>
</tr>
<tr id="row1583153988084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p843391851084824"><a name="p843391851084824"></a><a name="p843391851084824"></a><a href="utils.md#gad2ed05594fb04a126627c0fd5c7e2232">strtold</a> (const char *nptr, char **endptr)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2037918717084824"><a name="p2037918717084824"></a><a name="p2037918717084824"></a>long double </p>
<p id="p367340562084824"><a name="p367340562084824"></a><a name="p367340562084824"></a>Converts a string to <strong id="b862668661084824"><a name="b862668661084824"></a><a name="b862668661084824"></a>long double</strong>. </p>
</td>
</tr>
<tr id="row1026298374084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p160084472084824"><a name="p160084472084824"></a><a name="p160084472084824"></a><a href="utils.md#ga311071298c2fe3e5d7057f396a6acfdc">strtol</a> (const char *nptr, char **endptr, int base)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p663309799084824"><a name="p663309799084824"></a><a name="p663309799084824"></a>long </p>
<p id="p929731316084824"><a name="p929731316084824"></a><a name="p929731316084824"></a>Converts a string to a long integer according to the given <strong id="b1924806273084824"><a name="b1924806273084824"></a><a name="b1924806273084824"></a>base</strong>. </p>
</td>
</tr>
<tr id="row2067355575084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1314321360084824"><a name="p1314321360084824"></a><a name="p1314321360084824"></a><a href="utils.md#ga6d257fc3f00865d0556ed7327c312b55">strtoul</a> (const char *nptr, char **endptr, int base)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1842141698084824"><a name="p1842141698084824"></a><a name="p1842141698084824"></a>unsigned long </p>
<p id="p1891289272084824"><a name="p1891289272084824"></a><a name="p1891289272084824"></a>Converts a string to an unsigned long integer according to the given <strong id="b468933561084824"><a name="b468933561084824"></a><a name="b468933561084824"></a>base</strong>. </p>
</td>
</tr>
<tr id="row879258288084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1151511191084824"><a name="p1151511191084824"></a><a name="p1151511191084824"></a><a href="utils.md#gafb901aa665b7e2e3e27025ca77fecd1b">strtoll</a> (const char *nptr, char **endptr, int base)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1252474882084824"><a name="p1252474882084824"></a><a name="p1252474882084824"></a>long long </p>
<p id="p1624341670084824"><a name="p1624341670084824"></a><a name="p1624341670084824"></a>Converts a string to a long long integer according to the given <strong id="b1314048904084824"><a name="b1314048904084824"></a><a name="b1314048904084824"></a>base</strong>. </p>
</td>
</tr>
<tr id="row665558636084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1451420628084824"><a name="p1451420628084824"></a><a name="p1451420628084824"></a><a href="utils.md#gae5835422eb2dfc17ea8deb3b15bcc541">strtoull</a> (const char *nptr, char **endptr, int base)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1529142213084824"><a name="p1529142213084824"></a><a name="p1529142213084824"></a>unsigned long long </p>
<p id="p2129741850084824"><a name="p2129741850084824"></a><a name="p2129741850084824"></a>Converts a string to an unsigned long long integer according to the given <strong id="b1947213054084824"><a name="b1947213054084824"></a><a name="b1947213054084824"></a>base</strong>. </p>
</td>
</tr>
<tr id="row1467954782084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1856050819084824"><a name="p1856050819084824"></a><a name="p1856050819084824"></a><a href="utils.md#gae23144bcbb8e3742b00eb687c36654d1">rand</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1594760157084824"><a name="p1594760157084824"></a><a name="p1594760157084824"></a>int </p>
<p id="p49607468084824"><a name="p49607468084824"></a><a name="p49607468084824"></a>Generates a pseudo-random number. </p>
</td>
</tr>
<tr id="row333602752084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p58530317084824"><a name="p58530317084824"></a><a name="p58530317084824"></a><a href="utils.md#ga83a727cc697aea22e24cad5f39198dd2">srand</a> (unsigned int seed)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p95061936084824"><a name="p95061936084824"></a><a name="p95061936084824"></a>void </p>
<p id="p2005397429084824"><a name="p2005397429084824"></a><a name="p2005397429084824"></a>Initializes a random number generator. </p>
</td>
</tr>
<tr id="row1355559967084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1904364915084824"><a name="p1904364915084824"></a><a name="p1904364915084824"></a><a href="utils.md#ga7ac38fce3243a7dcf448301ee9ffd392">malloc</a> (size_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p680269286084824"><a name="p680269286084824"></a><a name="p680269286084824"></a>void * </p>
<p id="p135829004084824"><a name="p135829004084824"></a><a name="p135829004084824"></a>Dynamically allocates a memory block of <strong id="b1864509227084824"><a name="b1864509227084824"></a><a name="b1864509227084824"></a>size</strong>. </p>
</td>
</tr>
<tr id="row792949735084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p528872914084824"><a name="p528872914084824"></a><a name="p528872914084824"></a><a href="utils.md#ga62b7798461bd461da64c5f9d35feddf7">calloc</a> (size_t nmemb, size_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1421860366084824"><a name="p1421860366084824"></a><a name="p1421860366084824"></a>void * </p>
<p id="p509584509084824"><a name="p509584509084824"></a><a name="p509584509084824"></a>Dynamically allocates <strong id="b1793146333084824"><a name="b1793146333084824"></a><a name="b1793146333084824"></a>nmemb</strong> memory blocks of <strong id="b394364101084824"><a name="b394364101084824"></a><a name="b394364101084824"></a>size</strong>. </p>
</td>
</tr>
<tr id="row1861959504084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1809158087084824"><a name="p1809158087084824"></a><a name="p1809158087084824"></a><a href="utils.md#ga1a6b5e8d2f1c37e5b43e4345586075be">realloc</a> (void *ptr, size_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p179820689084824"><a name="p179820689084824"></a><a name="p179820689084824"></a>void * </p>
<p id="p1726722506084824"><a name="p1726722506084824"></a><a name="p1726722506084824"></a>Changes the size of the memory block pointed to by <strong id="b1642028402084824"><a name="b1642028402084824"></a><a name="b1642028402084824"></a>ptr</strong> to <strong id="b130302714084824"><a name="b130302714084824"></a><a name="b130302714084824"></a>size</strong> bytes. </p>
</td>
</tr>
<tr id="row1399920243084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p938489419084824"><a name="p938489419084824"></a><a name="p938489419084824"></a><a href="utils.md#gafbedc913aa4651b3c3b4b3aecd9b4711">free</a> (void *ptr)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1851404425084824"><a name="p1851404425084824"></a><a name="p1851404425084824"></a>void </p>
<p id="p576492503084824"><a name="p576492503084824"></a><a name="p576492503084824"></a>Releases the memory space pointed to by <strong id="b1705987053084824"><a name="b1705987053084824"></a><a name="b1705987053084824"></a>ptr</strong>. </p>
</td>
</tr>
<tr id="row1909188428084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p91648744084824"><a name="p91648744084824"></a><a name="p91648744084824"></a><a href="utils.md#ga7d78319026a43c0a5f942436ad3f09a1">abort</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1950217949084824"><a name="p1950217949084824"></a><a name="p1950217949084824"></a>_Noreturn void </p>
<p id="p1334045471084824"><a name="p1334045471084824"></a><a name="p1334045471084824"></a>Terminates an abnormal process and sends the <strong id="b506380904084824"><a name="b506380904084824"></a><a name="b506380904084824"></a>SIGABRT</strong> signal to the caller. </p>
</td>
</tr>
<tr id="row955626649084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p838311785084824"><a name="p838311785084824"></a><a name="p838311785084824"></a><a href="utils.md#ga7fd89c82095df80e5e12d6b2834a2acc">atexit</a> (void(*func)(void))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p467917045084824"><a name="p467917045084824"></a><a name="p467917045084824"></a>int </p>
<p id="p1389027828084824"><a name="p1389027828084824"></a><a name="p1389027828084824"></a>Registers a termination function. </p>
</td>
</tr>
<tr id="row604548236084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1791057414084824"><a name="p1791057414084824"></a><a name="p1791057414084824"></a><a href="utils.md#ga55e99c539cf7723ec15e856b7e0a8cee">exit</a> (int status)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1552267112084824"><a name="p1552267112084824"></a><a name="p1552267112084824"></a>void </p>
<p id="p1789418165084824"><a name="p1789418165084824"></a><a name="p1789418165084824"></a>Terminates the calling process, clears the used memory space and various data structures in the kernel, and sends the process end status to the parent process. All functions registered with atexit and on_exit are called in the reverse order. </p>
</td>
</tr>
<tr id="row1944945710084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p90649963084824"><a name="p90649963084824"></a><a name="p90649963084824"></a><a href="utils.md#gabc6595dbf6880c71628fecf0dbb23d66">getenv</a> (const char *name)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1274990840084824"><a name="p1274990840084824"></a><a name="p1274990840084824"></a>char * </p>
<p id="p1183113042084824"><a name="p1183113042084824"></a><a name="p1183113042084824"></a>Obtains the value of an environment variable. </p>
</td>
</tr>
<tr id="row215927174084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p733537540084824"><a name="p733537540084824"></a><a name="p733537540084824"></a><a href="utils.md#ga7631d470a867ad04b3272667ea4b643e">_Exit</a> (int status)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1266452402084824"><a name="p1266452402084824"></a><a name="p1266452402084824"></a>void </p>
<p id="p893775026084824"><a name="p893775026084824"></a><a name="p893775026084824"></a>Terminates the calling process, clears the used memory space and various data structures in the kernel, and sends the process end status to the parent process. </p>
</td>
</tr>
<tr id="row1022327463084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p362612237084824"><a name="p362612237084824"></a><a name="p362612237084824"></a><a href="utils.md#ga901e482eabd0dedb19224cf731e15403">assert</a> (scalar expression)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p562304847084824"><a name="p562304847084824"></a><a name="p562304847084824"></a>void </p>
<p id="p1283511175084824"><a name="p1283511175084824"></a><a name="p1283511175084824"></a>Aborts the program if assertion is false. </p>
</td>
</tr>
<tr id="row1450744937084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1729114124084824"><a name="p1729114124084824"></a><a name="p1729114124084824"></a><a href="utils.md#ga131d5a62230be50122c603018fdb3fc2">secure_getenv</a> (const char *name)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1936362557084824"><a name="p1936362557084824"></a><a name="p1936362557084824"></a>char * </p>
<p id="p913231136084824"><a name="p913231136084824"></a><a name="p913231136084824"></a>Obtains the value of an environment variable. </p>
</td>
</tr>
<tr id="row1318778966084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p454686985084824"><a name="p454686985084824"></a><a name="p454686985084824"></a><a href="utils.md#gac1ed47dda697f858893a9a68882a9fab">bsearch</a> (const void *key, const void *base, size_t nel, size_t width, int(*compar)(const void *, const void *))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2035348486084824"><a name="p2035348486084824"></a><a name="p2035348486084824"></a>void * </p>
<p id="p1371904478084824"><a name="p1371904478084824"></a><a name="p1371904478084824"></a>Searches for <strong id="b826644111084824"><a name="b826644111084824"></a><a name="b826644111084824"></a>key</strong> using the binary search algorithm from the array element <strong id="b1730718213084824"><a name="b1730718213084824"></a><a name="b1730718213084824"></a>base[0]</strong> to <strong id="b878791396084824"><a name="b878791396084824"></a><a name="b878791396084824"></a>base[num-1]</strong>. </p>
</td>
</tr>
<tr id="row1177543462084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p861993544084824"><a name="p861993544084824"></a><a name="p861993544084824"></a><a href="utils.md#ga56ba7474387aae0977ce6dbe9bef805f">qsort</a> (const void *base, size_t nel, size_t width, int(*compar)(const void *, const void *))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p94946617084824"><a name="p94946617084824"></a><a name="p94946617084824"></a>void </p>
<p id="p247472989084824"><a name="p247472989084824"></a><a name="p247472989084824"></a>Sorts array elements <strong id="b1459912879084824"><a name="b1459912879084824"></a><a name="b1459912879084824"></a>base[0]</strong> to <strong id="b1697163950084824"><a name="b1697163950084824"></a><a name="b1697163950084824"></a>base[num-1]</strong> based on the comparison rules of <strong id="b837455382084824"><a name="b837455382084824"></a><a name="b837455382084824"></a>compar</strong>. </p>
</td>
</tr>
<tr id="row1606126724084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p312589979084824"><a name="p312589979084824"></a><a name="p312589979084824"></a><a href="utils.md#gaf15d7205d8d10c4820f997ce5c526279">abs</a> (int i)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1401957718084824"><a name="p1401957718084824"></a><a name="p1401957718084824"></a>int </p>
<p id="p1704184772084824"><a name="p1704184772084824"></a><a name="p1704184772084824"></a>Obtains the absolute value of an integer value. </p>
</td>
</tr>
<tr id="row637009061084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1889479048084824"><a name="p1889479048084824"></a><a name="p1889479048084824"></a><a href="utils.md#gac39409d0077cf980e4e6419bc6014d10">labs</a> (long i)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1799817559084824"><a name="p1799817559084824"></a><a name="p1799817559084824"></a>long </p>
<p id="p1318430957084824"><a name="p1318430957084824"></a><a name="p1318430957084824"></a>Calculates the absolute value of a long integer. </p>
</td>
</tr>
<tr id="row2023259522084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1167369499084824"><a name="p1167369499084824"></a><a name="p1167369499084824"></a><a href="utils.md#ga7251caa2dd32261e7768d824c0a532c6">llabs</a> (long long i)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p796479821084824"><a name="p796479821084824"></a><a name="p796479821084824"></a>long long </p>
<p id="p753035328084824"><a name="p753035328084824"></a><a name="p753035328084824"></a>Calculates the absolute value of a long long integer. </p>
</td>
</tr>
<tr id="row679044739084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1863941322084824"><a name="p1863941322084824"></a><a name="p1863941322084824"></a><a href="utils.md#ga98cbdcca43b259bf545f16c72f07825b">div</a> (int numerator, int denominator)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1154540376084824"><a name="p1154540376084824"></a><a name="p1154540376084824"></a><a href="div_t.md">div_t</a> </p>
<p id="p1444903862084824"><a name="p1444903862084824"></a><a name="p1444903862084824"></a>Calculates the quotient and remainder of an integer after division. </p>
</td>
</tr>
<tr id="row960520057084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p899366821084824"><a name="p899366821084824"></a><a name="p899366821084824"></a><a href="utils.md#ga9ce9bebe15110c3774f311cd587dc543">ldiv</a> (long numerator, long denominator)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1537138094084824"><a name="p1537138094084824"></a><a name="p1537138094084824"></a><a href="ldiv_t.md">ldiv_t</a> </p>
<p id="p133614281084824"><a name="p133614281084824"></a><a name="p133614281084824"></a>Calculates the quotient and remainder of a long integer after division. </p>
</td>
</tr>
<tr id="row118306384084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1557287988084824"><a name="p1557287988084824"></a><a name="p1557287988084824"></a><a href="utils.md#ga28b92959777798288e1ac1def1c16ddc">lldiv</a> (long long numerator, long long denominator)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2074990568084824"><a name="p2074990568084824"></a><a name="p2074990568084824"></a><a href="lldiv_t.md">lldiv_t</a> </p>
<p id="p2126839655084824"><a name="p2126839655084824"></a><a name="p2126839655084824"></a>Calculates the quotient and remainder of a long long integer after division. </p>
</td>
</tr>
<tr id="row377904102084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1072210512084824"><a name="p1072210512084824"></a><a name="p1072210512084824"></a><a href="utils.md#ga10b28b2a9d994195623066c344fcf1fd">mblen</a> (const char *s, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1508007469084824"><a name="p1508007469084824"></a><a name="p1508007469084824"></a>int </p>
<p id="p375052138084824"><a name="p375052138084824"></a><a name="p375052138084824"></a>Obtains the number of bytes in the next multi-byte string. </p>
</td>
</tr>
<tr id="row1136072478084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1855350511084824"><a name="p1855350511084824"></a><a name="p1855350511084824"></a><a href="utils.md#ga6d2e39eeb319f32608b467c0c0ca1393">mbtowc</a> (wchar_t *pwc, const char *s, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p929375735084824"><a name="p929375735084824"></a><a name="p929375735084824"></a>int </p>
<p id="p1485207874084824"><a name="p1485207874084824"></a><a name="p1485207874084824"></a>Converts a string constant to a wide character. </p>
</td>
</tr>
<tr id="row1442509492084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1907928336084824"><a name="p1907928336084824"></a><a name="p1907928336084824"></a><a href="utils.md#gab576ad05484aba7fe43b3d047a3fabb5">wctomb</a> (char *s, wchar_t wc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p483369973084824"><a name="p483369973084824"></a><a name="p483369973084824"></a>int </p>
<p id="p1856739021084824"><a name="p1856739021084824"></a><a name="p1856739021084824"></a>Converts a wide character to its multi-byte sequence and stores it in a character array. </p>
</td>
</tr>
<tr id="row46146971084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1111821165084824"><a name="p1111821165084824"></a><a name="p1111821165084824"></a><a href="utils.md#ga95b89e577f091ba05d6403ff542c2164">mbstowcs</a> (wchar_t *dest, const char *src, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p206106382084824"><a name="p206106382084824"></a><a name="p206106382084824"></a>size_t </p>
<p id="p1450570134084824"><a name="p1450570134084824"></a><a name="p1450570134084824"></a>Converts a multi-byte string to a wide-character string. </p>
</td>
</tr>
<tr id="row423220829084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p311940127084824"><a name="p311940127084824"></a><a name="p311940127084824"></a><a href="utils.md#gae7586ae6f537a5fd64c8c2d7c850e3be">wcstombs</a> (char *dest, const wchar_t *src, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1833176744084824"><a name="p1833176744084824"></a><a name="p1833176744084824"></a>size_t </p>
<p id="p1825812336084824"><a name="p1825812336084824"></a><a name="p1825812336084824"></a>Converts a wide-character string to a multi-byte string. </p>
</td>
</tr>
<tr id="row1930280173084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1454286886084824"><a name="p1454286886084824"></a><a name="p1454286886084824"></a><a href="utils.md#gaed1e9c27ea92f5ae3a480059bf45c311">posix_memalign</a> (void **memptr, size_t alignment, size_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1869428221084824"><a name="p1869428221084824"></a><a name="p1869428221084824"></a>int </p>
<p id="p1490227695084824"><a name="p1490227695084824"></a><a name="p1490227695084824"></a>Allocates memory with the specified size based on the given <strong id="b1015753485084824"><a name="b1015753485084824"></a><a name="b1015753485084824"></a>alignment</strong>. </p>
</td>
</tr>
<tr id="row12151556084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1990323003084824"><a name="p1990323003084824"></a><a name="p1990323003084824"></a><a href="utils.md#ga1c8b16a3abcb4dc450a0a62b42c554dd">setenv</a> (const char *name, const char *value, int overwrite)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1194371915084824"><a name="p1194371915084824"></a><a name="p1194371915084824"></a>int </p>
<p id="p664979545084824"><a name="p664979545084824"></a><a name="p664979545084824"></a>Add or change an environment variable. </p>
</td>
</tr>
<tr id="row1195939364084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1563101874084824"><a name="p1563101874084824"></a><a name="p1563101874084824"></a><a href="utils.md#ga17a3a11d20a551951a4acbc3872b280c">unsetenv</a> (const char *name)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p86143902084824"><a name="p86143902084824"></a><a name="p86143902084824"></a>int </p>
<p id="p1851600053084824"><a name="p1851600053084824"></a><a name="p1851600053084824"></a>Deletes an environment variable. </p>
</td>
</tr>
<tr id="row2013993225084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1473924664084824"><a name="p1473924664084824"></a><a name="p1473924664084824"></a><a href="utils.md#ga6abe6c5eb77aeaf05ad81a7425547d9e">mkstemp</a> (char *template)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1521636290084824"><a name="p1521636290084824"></a><a name="p1521636290084824"></a>int </p>
<p id="p1986713983084824"><a name="p1986713983084824"></a><a name="p1986713983084824"></a>Creates and opens a unique temporary file. </p>
</td>
</tr>
<tr id="row2052516686084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1286528189084824"><a name="p1286528189084824"></a><a name="p1286528189084824"></a><a href="utils.md#ga691bcfdddb46ab9b43a91217a0ff77c9">mkostemp</a> (char *template, int flags)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p282462924084824"><a name="p282462924084824"></a><a name="p282462924084824"></a>int </p>
<p id="p275753330084824"><a name="p275753330084824"></a><a name="p275753330084824"></a>Creates and opens a unique temporary file. </p>
</td>
</tr>
<tr id="row1532312599084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1020318196084824"><a name="p1020318196084824"></a><a name="p1020318196084824"></a><a href="utils.md#ga4c366b8d0ad8a393cf6224b5fc9ee045">mkdtemp</a> (char *template)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p569332596084824"><a name="p569332596084824"></a><a name="p569332596084824"></a>char * </p>
<p id="p705988868084824"><a name="p705988868084824"></a><a name="p705988868084824"></a>Creates a unique temporary directory based on <strong id="b1030664282084824"><a name="b1030664282084824"></a><a name="b1030664282084824"></a>template</strong>. </p>
</td>
</tr>
<tr id="row312100024084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1490311981084824"><a name="p1490311981084824"></a><a name="p1490311981084824"></a><a href="utils.md#ga2959446c8426187f340f8d5a625bf2e6">getsubopt</a> (char **optionp, char *const *tokens, char **valuep)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1237292277084824"><a name="p1237292277084824"></a><a name="p1237292277084824"></a>int </p>
<p id="p1076224350084824"><a name="p1076224350084824"></a><a name="p1076224350084824"></a>Processes the parameters of an option in the command line. </p>
</td>
</tr>
<tr id="row452822287084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1193579545084824"><a name="p1193579545084824"></a><a name="p1193579545084824"></a><a href="utils.md#ga4d592bbc52a36404b05aa9ff5b7503c1">rand_r</a> (unsigned *seedp)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1695521963084824"><a name="p1695521963084824"></a><a name="p1695521963084824"></a>int </p>
<p id="p2006745247084824"><a name="p2006745247084824"></a><a name="p2006745247084824"></a>Generates a pseudo-random number. </p>
</td>
</tr>
<tr id="row1590906889084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p611022276084824"><a name="p611022276084824"></a><a name="p611022276084824"></a><a href="utils.md#gaae6b0f26f4a57df79f7c497a65d174d9">realpath</a> (const char *__restrict path, char *__restrict resolved)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1413580602084824"><a name="p1413580602084824"></a><a name="p1413580602084824"></a>char * </p>
<p id="p199149259084824"><a name="p199149259084824"></a><a name="p199149259084824"></a>Obtains a normalized absolute path. </p>
</td>
</tr>
<tr id="row1705566324084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1580560469084824"><a name="p1580560469084824"></a><a name="p1580560469084824"></a><a href="utils.md#ga350b5b3334c99bb57d2b39da0b2dd694">random</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1771238704084824"><a name="p1771238704084824"></a><a name="p1771238704084824"></a>long int </p>
<p id="p1252838276084824"><a name="p1252838276084824"></a><a name="p1252838276084824"></a>Generates a pseudo-random number. </p>
</td>
</tr>
<tr id="row620350598084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p820728026084824"><a name="p820728026084824"></a><a name="p820728026084824"></a><a href="utils.md#gaf1e7e3d144face36372f9ae8b18aa009">srandom</a> (unsigned int seed)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p176009346084824"><a name="p176009346084824"></a><a name="p176009346084824"></a>void </p>
<p id="p769481714084824"><a name="p769481714084824"></a><a name="p769481714084824"></a>Initializes a random number generator. </p>
</td>
</tr>
<tr id="row1271040591084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1138273453084824"><a name="p1138273453084824"></a><a name="p1138273453084824"></a><a href="utils.md#ga9250c684f653b1bd715bab29d35d2423">initstate</a> (unsigned int seed, char *state, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2074147625084824"><a name="p2074147625084824"></a><a name="p2074147625084824"></a>char * </p>
<p id="p1196604343084824"><a name="p1196604343084824"></a><a name="p1196604343084824"></a>Initializes a random number generator. </p>
</td>
</tr>
<tr id="row976298027084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1889734291084824"><a name="p1889734291084824"></a><a name="p1889734291084824"></a><a href="utils.md#gaa4970d8361258d9b821ad83036a2da3a">setstate</a> (char *state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p586437026084824"><a name="p586437026084824"></a><a name="p586437026084824"></a>char * </p>
<p id="p748566582084824"><a name="p748566582084824"></a><a name="p748566582084824"></a>Sets the current state list for subsequent random use. </p>
</td>
</tr>
<tr id="row664002953084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p324446091084824"><a name="p324446091084824"></a><a name="p324446091084824"></a><a href="utils.md#ga8a382cc6123c7cf09a144e28fdfe5bc1">putenv</a> (char *s)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2101453609084824"><a name="p2101453609084824"></a><a name="p2101453609084824"></a>int </p>
<p id="p618898519084824"><a name="p618898519084824"></a><a name="p618898519084824"></a>Configures an environment variable. </p>
</td>
</tr>
<tr id="row578007543084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1140313740084824"><a name="p1140313740084824"></a><a name="p1140313740084824"></a><a href="utils.md#gaba5e81f4ce55d1e02fb94974c382b63d">unlockpt</a> (int fd)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1770484023084824"><a name="p1770484023084824"></a><a name="p1770484023084824"></a>int </p>
<p id="p568981238084824"><a name="p568981238084824"></a><a name="p568981238084824"></a>Unlocks the secondary pseudo terminal corresponding to a primary pseudo terminal. </p>
</td>
</tr>
<tr id="row2005381061084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p388437441084824"><a name="p388437441084824"></a><a name="p388437441084824"></a><a href="utils.md#ga4602f14b8c8f146f93d72986341a27b7">ptsname</a> (int fd)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p371750377084824"><a name="p371750377084824"></a><a name="p371750377084824"></a>char * </p>
<p id="p1943338645084824"><a name="p1943338645084824"></a><a name="p1943338645084824"></a>Obtains the name of a pseudo terminal. </p>
</td>
</tr>
<tr id="row1382365475084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1855167696084824"><a name="p1855167696084824"></a><a name="p1855167696084824"></a><a href="utils.md#ga4045440e70229bdb726924f628f66d92">l64a</a> (long value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p832045787084824"><a name="p832045787084824"></a><a name="p832045787084824"></a>char * </p>
<p id="p1883078331084824"><a name="p1883078331084824"></a><a name="p1883078331084824"></a>Converts a long integer to a 64-bit ASCII string. </p>
</td>
</tr>
<tr id="row640075376084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p915502354084824"><a name="p915502354084824"></a><a name="p915502354084824"></a><a href="utils.md#gaed396b4eb37b2a1f5414f9c21749dadb">a64l</a> (const char *str64)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p699119830084824"><a name="p699119830084824"></a><a name="p699119830084824"></a>long </p>
<p id="p1081973820084824"><a name="p1081973820084824"></a><a name="p1081973820084824"></a>Converts between a 32-bit long integer and a little-endian 64-bit ASCII string. </p>
</td>
</tr>
<tr id="row1752567299084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2014336171084824"><a name="p2014336171084824"></a><a name="p2014336171084824"></a><a href="utils.md#gaf9329f9acef07ca14ea2256191c3ce74">drand48</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p598481487084824"><a name="p598481487084824"></a><a name="p598481487084824"></a>double </p>
<p id="p1711356850084824"><a name="p1711356850084824"></a><a name="p1711356850084824"></a>Obtains a random number. </p>
</td>
</tr>
<tr id="row9307979084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p802998638084824"><a name="p802998638084824"></a><a name="p802998638084824"></a><a href="utils.md#ga95f02f2831f093c6e151f0b782f20e48">erand48</a> (unsigned short xsubi[3])</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1665945784084824"><a name="p1665945784084824"></a><a name="p1665945784084824"></a>double </p>
<p id="p1397317535084824"><a name="p1397317535084824"></a><a name="p1397317535084824"></a>Obtains a random number. </p>
</td>
</tr>
<tr id="row503962052084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1678080394084824"><a name="p1678080394084824"></a><a name="p1678080394084824"></a><a href="utils.md#gad20ddf22bece340e3036c60cad913250">lrand48</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1365033552084824"><a name="p1365033552084824"></a><a name="p1365033552084824"></a>long int </p>
<p id="p497428969084824"><a name="p497428969084824"></a><a name="p497428969084824"></a>Generates pseudo-random numbers evenly distributed between [0, 2^31). </p>
</td>
</tr>
<tr id="row2022315099084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p802049394084824"><a name="p802049394084824"></a><a name="p802049394084824"></a><a href="utils.md#gaae8f9c9ee0a49b3bd8bea3331dab500f">nrand48</a> (unsigned short xsubi[3])</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p280894390084824"><a name="p280894390084824"></a><a name="p280894390084824"></a>long int </p>
<p id="p416029737084824"><a name="p416029737084824"></a><a name="p416029737084824"></a>Generates pseudo-random numbers evenly distributed between [0, 2^31). </p>
</td>
</tr>
<tr id="row29047663084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p811866650084824"><a name="p811866650084824"></a><a name="p811866650084824"></a><a href="utils.md#ga9c450a7a3d4437e3d5f8def180f68103">mrand48</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p258456789084824"><a name="p258456789084824"></a><a name="p258456789084824"></a>long </p>
<p id="p1078459222084824"><a name="p1078459222084824"></a><a name="p1078459222084824"></a>Generates pseudo-random numbers evenly distributed between [-2^31, 2^31). </p>
</td>
</tr>
<tr id="row88869145084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1744136420084824"><a name="p1744136420084824"></a><a name="p1744136420084824"></a><a href="utils.md#ga79163d3776f4009f0e7f1830f4be4d02">jrand48</a> (unsigned short xsubi[3])</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p263032777084824"><a name="p263032777084824"></a><a name="p263032777084824"></a>long </p>
<p id="p1117548403084824"><a name="p1117548403084824"></a><a name="p1117548403084824"></a>Generates pseudo-random numbers evenly distributed between [-2^31, 2^31). </p>
</td>
</tr>
<tr id="row320265933084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p754948496084824"><a name="p754948496084824"></a><a name="p754948496084824"></a><a href="utils.md#ga91c6acf8516086891c689926e49f1ddf">srand48</a> (long int seedval)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2075857589084824"><a name="p2075857589084824"></a><a name="p2075857589084824"></a>void </p>
<p id="p1426228541084824"><a name="p1426228541084824"></a><a name="p1426228541084824"></a>Sets the start seed value for the pseudo-random number generator. </p>
</td>
</tr>
<tr id="row994859858084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p629005318084824"><a name="p629005318084824"></a><a name="p629005318084824"></a><a href="utils.md#ga0b86f7fc9964c291844e8112a367721c">seed48</a> (unsigned short[3])</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p250338701084824"><a name="p250338701084824"></a><a name="p250338701084824"></a>unsigned short * </p>
<p id="p517431723084824"><a name="p517431723084824"></a><a name="p517431723084824"></a>Generates an evenly distributed pseudo-random seed. </p>
</td>
</tr>
<tr id="row1927243302084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1381754811084824"><a name="p1381754811084824"></a><a name="p1381754811084824"></a><a href="utils.md#ga71e0019171f5584bb6957867691c3e10">lcong48</a> (unsigned short param[7])</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2043479213084824"><a name="p2043479213084824"></a><a name="p2043479213084824"></a>void </p>
<p id="p103364041084824"><a name="p103364041084824"></a><a name="p103364041084824"></a>Sets the seed and related algorithm parameters for the pseudo-random number generator. </p>
</td>
</tr>
<tr id="row391899173084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1489476378084824"><a name="p1489476378084824"></a><a name="p1489476378084824"></a><a href="utils.md#ga3db0418e1e0258f6a8809286c291cc5b">mktemp</a> (char *template)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1307184682084824"><a name="p1307184682084824"></a><a name="p1307184682084824"></a>char * </p>
<p id="p1841363311084824"><a name="p1841363311084824"></a><a name="p1841363311084824"></a>Creates a unique temporary file name. </p>
</td>
</tr>
<tr id="row1885279928084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1904445275084824"><a name="p1904445275084824"></a><a name="p1904445275084824"></a><a href="utils.md#gab962063e3bb487de132da3016e2c813c">mkstemps</a> (char *template, int suffixlen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1006826822084824"><a name="p1006826822084824"></a><a name="p1006826822084824"></a>int </p>
<p id="p1235676896084824"><a name="p1235676896084824"></a><a name="p1235676896084824"></a>Creates and opens a unique temporary file. </p>
</td>
</tr>
<tr id="row1142239142084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1440915856084824"><a name="p1440915856084824"></a><a name="p1440915856084824"></a><a href="utils.md#gafab16d88038590bdb4900150d2791081">mkostemps</a> (char *template, int suffixlen, int flags)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1399819053084824"><a name="p1399819053084824"></a><a name="p1399819053084824"></a>int </p>
<p id="p1027338856084824"><a name="p1027338856084824"></a><a name="p1027338856084824"></a>Creates and opens a unique temporary file. </p>
</td>
</tr>
<tr id="row1031871174084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2716273084824"><a name="p2716273084824"></a><a name="p2716273084824"></a><a href="utils.md#ga3d09e44a916600a38b367c1b6ebdf118">valloc</a> (size_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2133580891084824"><a name="p2133580891084824"></a><a name="p2133580891084824"></a>void * </p>
<p id="p1789358263084824"><a name="p1789358263084824"></a><a name="p1789358263084824"></a>Allocates memory with the specified size and aligns the allocated memory by page size. </p>
</td>
</tr>
<tr id="row354031815084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1182820136084824"><a name="p1182820136084824"></a><a name="p1182820136084824"></a><a href="utils.md#ga888afe4104cd3bdc07445d8ed27b96bd">ecvt</a> (double number, int ndigits, int *decpt, int *sign)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1282648980084824"><a name="p1282648980084824"></a><a name="p1282648980084824"></a>char * </p>
<p id="p1841151108084824"><a name="p1841151108084824"></a><a name="p1841151108084824"></a>Converts a double-precision floating-point number into a string. </p>
</td>
</tr>
<tr id="row356611609084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p846208765084824"><a name="p846208765084824"></a><a name="p846208765084824"></a><a href="utils.md#gaf2658700b7da33eea87761f928b102de">fcvt</a> (double number, int ndigits, int *decpt, int *sign)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1573398639084824"><a name="p1573398639084824"></a><a name="p1573398639084824"></a>char * </p>
<p id="p1704029918084824"><a name="p1704029918084824"></a><a name="p1704029918084824"></a>Converts a floating-point number to a string. </p>
</td>
</tr>
<tr id="row1029969747084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p629251804084824"><a name="p629251804084824"></a><a name="p629251804084824"></a><a href="utils.md#gafabf46107539bb1ec32994c214b5eeba">gcvt</a> (double x, int n, char *b)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1133810629084824"><a name="p1133810629084824"></a><a name="p1133810629084824"></a>char * </p>
<p id="p1413270010084824"><a name="p1413270010084824"></a><a name="p1413270010084824"></a>Converts a floating-point number to a string. </p>
</td>
</tr>
<tr id="row463317377084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p88635228084824"><a name="p88635228084824"></a><a name="p88635228084824"></a><a href="utils.md#ga0ee37e291991bef6e3f4b49a970171e7">memcpy</a> (void *__restrict dest, const void *__restrict src, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p841416887084824"><a name="p841416887084824"></a><a name="p841416887084824"></a>void * </p>
<p id="p685711886084824"><a name="p685711886084824"></a><a name="p685711886084824"></a>Copies a string (overlapping not allowed). </p>
</td>
</tr>
<tr id="row343243944084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p685802688084824"><a name="p685802688084824"></a><a name="p685802688084824"></a><a href="utils.md#ga802c986820d3866639922b6bc9484f90">memmove</a> (void *dest, const void *src, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p569698127084824"><a name="p569698127084824"></a><a name="p569698127084824"></a>void * </p>
<p id="p979502938084824"><a name="p979502938084824"></a><a name="p979502938084824"></a>Copies a string (overlapping allowed). </p>
</td>
</tr>
<tr id="row2039546834084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1392630944084824"><a name="p1392630944084824"></a><a name="p1392630944084824"></a><a href="utils.md#gace6ee45c30e71865e6eb635200379db9">memset</a> (void *s, int c, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1550788983084824"><a name="p1550788983084824"></a><a name="p1550788983084824"></a>void * </p>
<p id="p961772510084824"><a name="p961772510084824"></a><a name="p961772510084824"></a>Copies a character to the specified memory area. </p>
</td>
</tr>
<tr id="row425040566084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1623007611084824"><a name="p1623007611084824"></a><a name="p1623007611084824"></a><a href="utils.md#ga9e6df54ee04e18a3772335580e2ed872">memcmp</a> (const void *s1, const void *s2, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2103786651084824"><a name="p2103786651084824"></a><a name="p2103786651084824"></a>int </p>
<p id="p2141242083084824"><a name="p2141242083084824"></a><a name="p2141242083084824"></a>Compares two memory areas. </p>
</td>
</tr>
<tr id="row762887550084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1763774601084824"><a name="p1763774601084824"></a><a name="p1763774601084824"></a><a href="utils.md#ga16d6b0bd660cc3f9910924c6b6f4af8e">memchr</a> (const void *s, int c, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1910280817084824"><a name="p1910280817084824"></a><a name="p1910280817084824"></a>void * </p>
<p id="p1446630640084824"><a name="p1446630640084824"></a><a name="p1446630640084824"></a>Searches for a character in the specified memory area. </p>
</td>
</tr>
<tr id="row2045608053084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2097173506084824"><a name="p2097173506084824"></a><a name="p2097173506084824"></a><a href="utils.md#ga7a82515b5d377be04817715c5465b647">strcpy</a> (char *dest, const char *src)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p843104091084824"><a name="p843104091084824"></a><a name="p843104091084824"></a>char * </p>
<p id="p1592829402084824"><a name="p1592829402084824"></a><a name="p1592829402084824"></a>Copies a string. </p>
</td>
</tr>
<tr id="row1760870711084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p305810634084824"><a name="p305810634084824"></a><a name="p305810634084824"></a><a href="utils.md#ga47d54f24198df56da51078a6c540b9ed">strncpy</a> (char *dest, const char *src, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1710396222084824"><a name="p1710396222084824"></a><a name="p1710396222084824"></a>char * </p>
<p id="p170966458084824"><a name="p170966458084824"></a><a name="p170966458084824"></a>Copies <strong id="b1017538560084824"><a name="b1017538560084824"></a><a name="b1017538560084824"></a>n</strong> characters of a string. </p>
</td>
</tr>
<tr id="row941534121084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p620187539084824"><a name="p620187539084824"></a><a name="p620187539084824"></a><a href="utils.md#gadb8723e585ed29f2370cddf90f6891bc">strcat</a> (char *dest, const char *src)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1592313755084824"><a name="p1592313755084824"></a><a name="p1592313755084824"></a>char * </p>
<p id="p705438413084824"><a name="p705438413084824"></a><a name="p705438413084824"></a>Appends a string to another one. </p>
</td>
</tr>
<tr id="row1680624730084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p250654927084824"><a name="p250654927084824"></a><a name="p250654927084824"></a><a href="utils.md#ga0aee928c2844a269966e4832fd2255c5">strncat</a> (char *dest, const char *src, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p333527888084824"><a name="p333527888084824"></a><a name="p333527888084824"></a>char * </p>
<p id="p1055111375084824"><a name="p1055111375084824"></a><a name="p1055111375084824"></a>Appends the first <strong id="b229315337084824"><a name="b229315337084824"></a><a name="b229315337084824"></a>n</strong> bytes of a string to another one. </p>
</td>
</tr>
<tr id="row1135275588084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1573865607084824"><a name="p1573865607084824"></a><a name="p1573865607084824"></a><a href="utils.md#ga11bd144d7d44914099a3aeddf1c8567d">strcmp</a> (const char *s1, const char *s2)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1859669791084824"><a name="p1859669791084824"></a><a name="p1859669791084824"></a>int </p>
<p id="p1909709575084824"><a name="p1909709575084824"></a><a name="p1909709575084824"></a>Compares two strings by characters. </p>
</td>
</tr>
<tr id="row1538081043084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p830049448084824"><a name="p830049448084824"></a><a name="p830049448084824"></a><a href="utils.md#ga07f4a84c11c106e95c32b6ab509346ef">strncmp</a> (const char *s1, const char *s2, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1134078753084824"><a name="p1134078753084824"></a><a name="p1134078753084824"></a>int </p>
<p id="p1427334096084824"><a name="p1427334096084824"></a><a name="p1427334096084824"></a>Compares the first n characters of two strings. </p>
</td>
</tr>
<tr id="row1383398594084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1759528482084824"><a name="p1759528482084824"></a><a name="p1759528482084824"></a><a href="utils.md#gaa4718e50ed45c2275c5d85a121d68097">strcoll</a> (const char *s1, const char *s2)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1270854906084824"><a name="p1270854906084824"></a><a name="p1270854906084824"></a>int </p>
<p id="p39033520084824"><a name="p39033520084824"></a><a name="p39033520084824"></a>Compares two strings by character for the program's current locale. </p>
</td>
</tr>
<tr id="row1242649333084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p545000925084824"><a name="p545000925084824"></a><a name="p545000925084824"></a><a href="utils.md#ga2294f2f1c4eaef870ef3d5d90e5cb36f">strcoll_l</a> (const char *s1, const char *s2, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1374844496084824"><a name="p1374844496084824"></a><a name="p1374844496084824"></a>int </p>
<p id="p392500997084824"><a name="p392500997084824"></a><a name="p392500997084824"></a>Compares two strings by character for the specified locale. </p>
</td>
</tr>
<tr id="row1504182261084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p456220235084824"><a name="p456220235084824"></a><a name="p456220235084824"></a><a href="utils.md#gadd1f1078b3303920c19fd68fcba3f908">strxfrm</a> (char *dest, const char *src, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1821527954084824"><a name="p1821527954084824"></a><a name="p1821527954084824"></a>size_t </p>
<p id="p1048933430084824"><a name="p1048933430084824"></a><a name="p1048933430084824"></a>Converts the first n characters of the source string pointed to by <strong id="b198217019084824"><a name="b198217019084824"></a><a name="b198217019084824"></a>src</strong> based on the program's current locale specified by <a href="io.md#gaab9cf7b1a206fb75e5884934c8d676db">LC_COLLATE</a>, and places them in the destination string pointed to by <strong id="b1513574173084824"><a name="b1513574173084824"></a><a name="b1513574173084824"></a>dest</strong>. </p>
</td>
</tr>
<tr id="row1662802628084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p766018375084824"><a name="p766018375084824"></a><a name="p766018375084824"></a><a href="utils.md#ga12871ed234858ef0e363d2b8aa572fc1">strchr</a> (const char *s, int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1886249683084824"><a name="p1886249683084824"></a><a name="p1886249683084824"></a>char * </p>
<p id="p109608818084824"><a name="p109608818084824"></a><a name="p109608818084824"></a>Locates the first occurrence of a character in a string. </p>
</td>
</tr>
<tr id="row1627459389084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p991403858084824"><a name="p991403858084824"></a><a name="p991403858084824"></a><a href="utils.md#ga0c05a458deff028ef4d4e64059098db4">strrchr</a> (const char *s, int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1835377385084824"><a name="p1835377385084824"></a><a name="p1835377385084824"></a>char * </p>
<p id="p657908184084824"><a name="p657908184084824"></a><a name="p657908184084824"></a>Locates the last occurrence of a character in a string. </p>
</td>
</tr>
<tr id="row15541865084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p692650808084824"><a name="p692650808084824"></a><a name="p692650808084824"></a><a href="utils.md#gaeb6c449e5d77477c057abf00eaaf88fe">strcspn</a> (const char *s, const char *reject)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2076772176084824"><a name="p2076772176084824"></a><a name="p2076772176084824"></a>size_t </p>
<p id="p832378146084824"><a name="p832378146084824"></a><a name="p832378146084824"></a>Obtains the length of the initial segment of a string that contains characters not in reject. </p>
</td>
</tr>
<tr id="row656014395084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p921999298084824"><a name="p921999298084824"></a><a name="p921999298084824"></a><a href="utils.md#ga900a0edfa51f601d479244f7451cedd1">strspn</a> (const char *s, const char *<a href="net.md#ga0807af5ac9dfc2a63624e8c3e0ae95ef">accept</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p205504885084824"><a name="p205504885084824"></a><a name="p205504885084824"></a>size_t </p>
<p id="p30360599084824"><a name="p30360599084824"></a><a name="p30360599084824"></a>Obtains the length of the initial segment of a string that contains characters in accept. </p>
</td>
</tr>
<tr id="row945662538084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p914905685084824"><a name="p914905685084824"></a><a name="p914905685084824"></a><a href="utils.md#ga119f23a5dcb4eb5f1c1eed3cbf5cb0ed">strpbrk</a> (const char *s, const char *<a href="net.md#ga0807af5ac9dfc2a63624e8c3e0ae95ef">accept</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p777317173084824"><a name="p777317173084824"></a><a name="p777317173084824"></a>char * </p>
<p id="p1796229088084824"><a name="p1796229088084824"></a><a name="p1796229088084824"></a>Searches for any of a set of characters in a string. </p>
</td>
</tr>
<tr id="row306549617084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p514884091084824"><a name="p514884091084824"></a><a name="p514884091084824"></a><a href="utils.md#ga4a710d86541afc6b7dafddcdb4b1c94f">strstr</a> (const char *haystack, const char *needle)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1481542563084824"><a name="p1481542563084824"></a><a name="p1481542563084824"></a>char * </p>
<p id="p1167013079084824"><a name="p1167013079084824"></a><a name="p1167013079084824"></a>Searches for a needle string in its haystack string. </p>
</td>
</tr>
<tr id="row1322133842084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p733005602084824"><a name="p733005602084824"></a><a name="p733005602084824"></a><a href="utils.md#ga8cb460f64c449f2a9b9b7a40569ce0fe">strtok</a> (char *str, const char *delim)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p277175023084824"><a name="p277175023084824"></a><a name="p277175023084824"></a>char * </p>
<p id="p1165902245084824"><a name="p1165902245084824"></a><a name="p1165902245084824"></a>Separates a string into a series of tokens separated by a delimiter. </p>
</td>
</tr>
<tr id="row964741933084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p501417734084824"><a name="p501417734084824"></a><a name="p501417734084824"></a><a href="utils.md#gaa383452fe445bfae989358c9d7d96f4f">strlen</a> (const char *s)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p595763421084824"><a name="p595763421084824"></a><a name="p595763421084824"></a>size_t </p>
<p id="p1029060341084824"><a name="p1029060341084824"></a><a name="p1029060341084824"></a>Calculates the length of a string. </p>
</td>
</tr>
<tr id="row993325828084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p551069013084824"><a name="p551069013084824"></a><a name="p551069013084824"></a><a href="utils.md#gadd46ab98f32b76457852dbb872842bf2">strerror</a> (int errnum)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1684799796084824"><a name="p1684799796084824"></a><a name="p1684799796084824"></a>char * </p>
<p id="p877341251084824"><a name="p877341251084824"></a><a name="p877341251084824"></a>Obtains an error description string of the specified error code. </p>
</td>
</tr>
<tr id="row652694337084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p718748475084824"><a name="p718748475084824"></a><a name="p718748475084824"></a><a href="utils.md#gab11d86a2a3af0a355cad2337c6f4e9f7">strtok_r</a> (char *str, const char *delim, char **saveptr)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p136025420084824"><a name="p136025420084824"></a><a name="p136025420084824"></a>char * </p>
<p id="p467919408084824"><a name="p467919408084824"></a><a name="p467919408084824"></a>Separates a string into a series of tokens separated by a delimiter, with the <strong id="b1366548679084824"><a name="b1366548679084824"></a><a name="b1366548679084824"></a>saveptr</strong> parameter specified. </p>
</td>
</tr>
<tr id="row748579485084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1046708810084824"><a name="p1046708810084824"></a><a name="p1046708810084824"></a><a href="utils.md#ga8f7507e357cbd24048ae77e27e5d41d7">strerror_l</a> (int errnum, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2144759746084824"><a name="p2144759746084824"></a><a name="p2144759746084824"></a>char * </p>
<p id="p2086384342084824"><a name="p2086384342084824"></a><a name="p2086384342084824"></a>Obtains an error description string of the specified error code for the specified locale. </p>
</td>
</tr>
<tr id="row1709258144084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1995585053084824"><a name="p1995585053084824"></a><a name="p1995585053084824"></a><a href="utils.md#ga7253ba059153058c57952194237c6b55">strerror_r</a> (int errnum, char *buf, size_t buflen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1867075516084824"><a name="p1867075516084824"></a><a name="p1867075516084824"></a>char * </p>
<p id="p1993070805084824"><a name="p1993070805084824"></a><a name="p1993070805084824"></a>Obtains an error description string of the specified error code. </p>
</td>
</tr>
<tr id="row1522296065084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p211017444084824"><a name="p211017444084824"></a><a name="p211017444084824"></a><a href="utils.md#ga890dbcd7c456828c1b6ff714e405fcc1">stpcpy</a> (char *dest, const char *src)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p930198193084824"><a name="p930198193084824"></a><a name="p930198193084824"></a>char * </p>
<p id="p1856960500084824"><a name="p1856960500084824"></a><a name="p1856960500084824"></a>Copies a string. </p>
</td>
</tr>
<tr id="row1822792429084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2113114239084824"><a name="p2113114239084824"></a><a name="p2113114239084824"></a><a href="utils.md#ga217a70a69e2fc7727278516b7ad2fc26">stpncpy</a> (char *dest, const char *src, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p402054490084824"><a name="p402054490084824"></a><a name="p402054490084824"></a>char * </p>
<p id="p850199410084824"><a name="p850199410084824"></a><a name="p850199410084824"></a>Copies n characters of a string. </p>
</td>
</tr>
<tr id="row1985484338084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p592816978084824"><a name="p592816978084824"></a><a name="p592816978084824"></a><a href="utils.md#gafc92d2231e45d19988c7894aa2a07f0c">strnlen</a> (const char *s, size_t maxlen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p302138400084824"><a name="p302138400084824"></a><a name="p302138400084824"></a>size_t </p>
<p id="p595379146084824"><a name="p595379146084824"></a><a name="p595379146084824"></a>Calculates the length of a string. </p>
</td>
</tr>
<tr id="row454537966084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p932160296084824"><a name="p932160296084824"></a><a name="p932160296084824"></a><a href="utils.md#gab1cc1a3ff560049e22576031c7c2345b">strdup</a> (const char *s)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1409659432084824"><a name="p1409659432084824"></a><a name="p1409659432084824"></a>char * </p>
<p id="p696462289084824"><a name="p696462289084824"></a><a name="p696462289084824"></a>Copies a string to a new position. </p>
</td>
</tr>
<tr id="row305263880084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1031938608084824"><a name="p1031938608084824"></a><a name="p1031938608084824"></a><a href="utils.md#ga8b860ba32fef12da8acd4507c059e509">strndup</a> (const char *s, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1611638256084824"><a name="p1611638256084824"></a><a name="p1611638256084824"></a>char * </p>
<p id="p708019727084824"><a name="p708019727084824"></a><a name="p708019727084824"></a>Copies n characters of a string to a new position. </p>
</td>
</tr>
<tr id="row279281084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1141743105084824"><a name="p1141743105084824"></a><a name="p1141743105084824"></a><a href="utils.md#ga8f7c22bf1131bd6ffe6635e386fb4ebd">strsignal</a> (int sig)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p93532861084824"><a name="p93532861084824"></a><a name="p93532861084824"></a>char * </p>
<p id="p282334885084824"><a name="p282334885084824"></a><a name="p282334885084824"></a>Returns a string describing the signal number. </p>
</td>
</tr>
<tr id="row462444725084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p689979577084824"><a name="p689979577084824"></a><a name="p689979577084824"></a><a href="utils.md#ga2ffbfe50042aaf5b987782dcd16ea1f0">memccpy</a> (void *__restrict dest, const void *__restrict src, int c, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1684941486084824"><a name="p1684941486084824"></a><a name="p1684941486084824"></a>void * </p>
<p id="p1920257919084824"><a name="p1920257919084824"></a><a name="p1920257919084824"></a>Copies a memory area to another one. </p>
</td>
</tr>
<tr id="row1855918348084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1301346154084824"><a name="p1301346154084824"></a><a name="p1301346154084824"></a><a href="utils.md#ga93c766c6e86f4f79e7507c21f1794e15">strsep</a> (char **stringp, const char *delim)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1916718423084824"><a name="p1916718423084824"></a><a name="p1916718423084824"></a>char * </p>
<p id="p1411581414084824"><a name="p1411581414084824"></a><a name="p1411581414084824"></a>Separates a string into a series of tokens separated by a delimiter. </p>
</td>
</tr>
<tr id="row2043552587084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p336222494084824"><a name="p336222494084824"></a><a name="p336222494084824"></a><a href="utils.md#ga0266462615f2f112003cdb591710d299">strlcat</a> (char *d, const char *s, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2052424053084824"><a name="p2052424053084824"></a><a name="p2052424053084824"></a>size_t </p>
<p id="p198637492084824"><a name="p198637492084824"></a><a name="p198637492084824"></a>Appends the first <strong id="b38785744084824"><a name="b38785744084824"></a><a name="b38785744084824"></a>n</strong> bytes of a string to another one. </p>
</td>
</tr>
<tr id="row1858920763084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1176684614084824"><a name="p1176684614084824"></a><a name="p1176684614084824"></a><a href="utils.md#ga50bd3317d65f3da7d180b8981e58c5a4">strlcpy</a> (char *d, const char *s, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p951059801084824"><a name="p951059801084824"></a><a name="p951059801084824"></a>size_t </p>
<p id="p948770451084824"><a name="p948770451084824"></a><a name="p948770451084824"></a>Copies a string. </p>
</td>
</tr>
<tr id="row352410985084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p324021244084824"><a name="p324021244084824"></a><a name="p324021244084824"></a><a href="utils.md#ga1563a7059aabf95c0b588278e8bed575">strverscmp</a> (const char *s1, const char *s2)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1728398115084824"><a name="p1728398115084824"></a><a name="p1728398115084824"></a>int </p>
<p id="p2046643509084824"><a name="p2046643509084824"></a><a name="p2046643509084824"></a>Compares strings of two versions (string 1 and string 2) and returns the comparison result. </p>
</td>
</tr>
<tr id="row628706483084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1465443824084824"><a name="p1465443824084824"></a><a name="p1465443824084824"></a><a href="utils.md#gae9229017a4501f8d6a637b4498cfed2e">strcasestr</a> (const char *haystack, const char *needle)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p866152672084824"><a name="p866152672084824"></a><a name="p866152672084824"></a>char * </p>
<p id="p417993292084824"><a name="p417993292084824"></a><a name="p417993292084824"></a>Searches for a needle string in its haystack string and returns a pointer. </p>
</td>
</tr>
<tr id="row1369624455084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1732199299084824"><a name="p1732199299084824"></a><a name="p1732199299084824"></a><a href="utils.md#ga5f6423417e952f934be0a582d87b663a">memmem</a> (const void *haystack, size_t haystacklen, const void *needle, size_t needlelen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1027152771084824"><a name="p1027152771084824"></a><a name="p1027152771084824"></a>void * </p>
<p id="p779412414084824"><a name="p779412414084824"></a><a name="p779412414084824"></a>Searches for a needle string in its haystack string. </p>
</td>
</tr>
<tr id="row808566326084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1777488610084824"><a name="p1777488610084824"></a><a name="p1777488610084824"></a><a href="utils.md#ga45623070e5e0b7008d44600a283ea2ee">memrchr</a> (const void *s, int c, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1385530779084824"><a name="p1385530779084824"></a><a name="p1385530779084824"></a>void * </p>
<p id="p751942395084824"><a name="p751942395084824"></a><a name="p751942395084824"></a>Searches for a character in the specified memory area. </p>
</td>
</tr>
<tr id="row918758026084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1842774052084824"><a name="p1842774052084824"></a><a name="p1842774052084824"></a><a href="utils.md#ga7ac7c0f43132e3acf013e0c71a58cdc9">mempcpy</a> (void *dest, const void *src, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p67107024084824"><a name="p67107024084824"></a><a name="p67107024084824"></a>void * </p>
<p id="p536776212084824"><a name="p536776212084824"></a><a name="p536776212084824"></a>Copies a string (overlapping not allowed). </p>
</td>
</tr>
<tr id="row174566552084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p297903485084824"><a name="p297903485084824"></a><a name="p297903485084824"></a><a href="utils.md#ga840ecc6fc750bf00e99015d2817b0e12">bcmp</a> (const void *s1, const void *s2, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p532543860084824"><a name="p532543860084824"></a><a name="p532543860084824"></a>int </p>
<p id="p919169922084824"><a name="p919169922084824"></a><a name="p919169922084824"></a>Compares byte sequences. </p>
</td>
</tr>
<tr id="row1277381097084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1357404673084824"><a name="p1357404673084824"></a><a name="p1357404673084824"></a><a href="utils.md#ga2bf0688adef533a3285e7e0c00f98ff8">bcopy</a> (const void *src, void *dest, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1753495926084824"><a name="p1753495926084824"></a><a name="p1753495926084824"></a>void </p>
<p id="p1464926837084824"><a name="p1464926837084824"></a><a name="p1464926837084824"></a>Copies byte sequences. </p>
</td>
</tr>
<tr id="row653502648084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2065654691084824"><a name="p2065654691084824"></a><a name="p2065654691084824"></a><a href="utils.md#ga59505af7f1c47ff01fdb944801642033">bzero</a> (void *s, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p303987653084824"><a name="p303987653084824"></a><a name="p303987653084824"></a>void </p>
<p id="p1243318812084824"><a name="p1243318812084824"></a><a name="p1243318812084824"></a>Sets byte sequences to zero. </p>
</td>
</tr>
<tr id="row321527061084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1633833799084824"><a name="p1633833799084824"></a><a name="p1633833799084824"></a><a href="utils.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a> (const char *s, int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p906755869084824"><a name="p906755869084824"></a><a name="p906755869084824"></a>char * </p>
<p id="p307892014084824"><a name="p307892014084824"></a><a name="p307892014084824"></a>Searches for the first position of the matched character in a string. </p>
</td>
</tr>
<tr id="row2097347810084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p732321044084824"><a name="p732321044084824"></a><a name="p732321044084824"></a><a href="utils.md#ga83d9aa3251fdee263ad43bf75933de46">rindex</a> (const char *s, int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1758874524084824"><a name="p1758874524084824"></a><a name="p1758874524084824"></a>char * </p>
<p id="p365633012084824"><a name="p365633012084824"></a><a name="p365633012084824"></a>Searches for the last position of the matched character in a string. </p>
</td>
</tr>
<tr id="row860096056084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1134137120084824"><a name="p1134137120084824"></a><a name="p1134137120084824"></a><a href="utils.md#ga2385d975eddea296daa497e5d36febc9">ffs</a> (int i)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p920669368084824"><a name="p920669368084824"></a><a name="p920669368084824"></a>int </p>
<p id="p658391890084824"><a name="p658391890084824"></a><a name="p658391890084824"></a>Searches for the first bit in a word of the integer type. </p>
</td>
</tr>
<tr id="row2135632375084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1090562508084824"><a name="p1090562508084824"></a><a name="p1090562508084824"></a><a href="utils.md#ga73690a58537a6dbafa9aa4b3afa7baac">ffsl</a> (long int i)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p384615606084824"><a name="p384615606084824"></a><a name="p384615606084824"></a>int </p>
<p id="p1179959436084824"><a name="p1179959436084824"></a><a name="p1179959436084824"></a>Searches for the first bit in a word of the long integer type. </p>
</td>
</tr>
<tr id="row1972670774084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1646032073084824"><a name="p1646032073084824"></a><a name="p1646032073084824"></a><a href="utils.md#gae7eaa572ad4e097865bd409b121fb33c">ffsll</a> (long long int i)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1316319667084824"><a name="p1316319667084824"></a><a name="p1316319667084824"></a>int </p>
<p id="p1421239927084824"><a name="p1421239927084824"></a><a name="p1421239927084824"></a>Searches for the first bit in a word of the 8-byte long integer type. </p>
</td>
</tr>
<tr id="row817900690084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1920081565084824"><a name="p1920081565084824"></a><a name="p1920081565084824"></a><a href="utils.md#ga2436604f43de7f27e7434ceea7d64528">strcasecmp</a> (const char *_l, const char *_r)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p34222571084824"><a name="p34222571084824"></a><a name="p34222571084824"></a>int </p>
<p id="p1272764452084824"><a name="p1272764452084824"></a><a name="p1272764452084824"></a>Compares two strings (string 1 and string 2), regardless of the letter case. </p>
</td>
</tr>
<tr id="row33158328084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p917235997084824"><a name="p917235997084824"></a><a name="p917235997084824"></a><a href="utils.md#ga103fd689d8438a246e0cd4d90cb084ac">strncasecmp</a> (const char *_l, const char *_r, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p151414943084824"><a name="p151414943084824"></a><a name="p151414943084824"></a>int </p>
<p id="p1641309382084824"><a name="p1641309382084824"></a><a name="p1641309382084824"></a>Compares a specified length of two strings (string 1 and string 2), regardless of the letter case. </p>
</td>
</tr>
<tr id="row559578205084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2144666797084824"><a name="p2144666797084824"></a><a name="p2144666797084824"></a><a href="utils.md#ga3d8839f39526d15b100953d64cc08f10">pipe</a> (int pipefd[2])</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p866667446084824"><a name="p866667446084824"></a><a name="p866667446084824"></a>int </p>
<p id="p1745646241084824"><a name="p1745646241084824"></a><a name="p1745646241084824"></a>Creates an anonymous pipe. </p>
</td>
</tr>
<tr id="row2103932431084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1157467554084824"><a name="p1157467554084824"></a><a name="p1157467554084824"></a><a href="utils.md#gaafbcde67669a1b96577e735ddebd8634">close</a> (int fd)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1730888025084824"><a name="p1730888025084824"></a><a name="p1730888025084824"></a>int </p>
<p id="p1878515618084824"><a name="p1878515618084824"></a><a name="p1878515618084824"></a>Closes a file with a specified file descriptor. </p>
</td>
</tr>
<tr id="row340752416084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1598796298084824"><a name="p1598796298084824"></a><a name="p1598796298084824"></a><a href="utils.md#ga2599c985f9cce0d9d7b11732941bd9dc">dup</a> (int oldfd)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1786758621084824"><a name="p1786758621084824"></a><a name="p1786758621084824"></a>int </p>
<p id="p541455951084824"><a name="p541455951084824"></a><a name="p541455951084824"></a>Copies a specified file descriptor. </p>
</td>
</tr>
<tr id="row928561279084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p125482684084824"><a name="p125482684084824"></a><a name="p125482684084824"></a><a href="utils.md#ga0bbddf8ae4f3dea6e57532be36c04268">dup2</a> (int oldfd, int newfd)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1381609700084824"><a name="p1381609700084824"></a><a name="p1381609700084824"></a>int </p>
<p id="p919639610084824"><a name="p919639610084824"></a><a name="p919639610084824"></a>Copies the descriptor of the target file to a specified descriptor. </p>
</td>
</tr>
<tr id="row1769677201084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p351148454084824"><a name="p351148454084824"></a><a name="p351148454084824"></a><a href="utils.md#ga8bd74caed008a66808d92d57fa74d9f6">lseek</a> (int fd, off_t offset, int whence)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1503528673084824"><a name="p1503528673084824"></a><a name="p1503528673084824"></a>off_t </p>
<p id="p119128015084824"><a name="p119128015084824"></a><a name="p119128015084824"></a>Sets the offset of the pointer to the file. </p>
</td>
</tr>
<tr id="row1372735095084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p565470358084824"><a name="p565470358084824"></a><a name="p565470358084824"></a><a href="utils.md#ga9ba34c4ff72e21db486eedf77c2a18d0">fsync</a> (int fd)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p161672041084824"><a name="p161672041084824"></a><a name="p161672041084824"></a>int </p>
<p id="p326922059084824"><a name="p326922059084824"></a><a name="p326922059084824"></a>Synchronizes a file associated with a specified file descriptor to the storage device. </p>
</td>
</tr>
<tr id="row1938949155084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p938536967084824"><a name="p938536967084824"></a><a name="p938536967084824"></a><a href="utils.md#ga5975018bea8d2811c4b3abe10d493bb6">read</a> (int fd, void *buf, size_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1628054594084824"><a name="p1628054594084824"></a><a name="p1628054594084824"></a>ssize_t </p>
<p id="p1247107968084824"><a name="p1247107968084824"></a><a name="p1247107968084824"></a>Reads the file contents and saves them in a specified buffer location. </p>
</td>
</tr>
<tr id="row830827322084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p49366515084824"><a name="p49366515084824"></a><a name="p49366515084824"></a><a href="utils.md#gac06af22e9ce132f563db5c918ceb1eb1">write</a> (int fd, const void *buf, size_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1594905921084824"><a name="p1594905921084824"></a><a name="p1594905921084824"></a>ssize_t </p>
<p id="p1426911436084824"><a name="p1426911436084824"></a><a name="p1426911436084824"></a>Writes the specified content to the file. </p>
</td>
</tr>
<tr id="row272091459084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1230670122084824"><a name="p1230670122084824"></a><a name="p1230670122084824"></a><a href="utils.md#ga67ceebb141dbf6be0be4484804601e5b">pread</a> (int fd, void *buf, size_t count, off_t offset)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p326732900084824"><a name="p326732900084824"></a><a name="p326732900084824"></a>ssize_t </p>
<p id="p315154466084824"><a name="p315154466084824"></a><a name="p315154466084824"></a>Reads data whose offset is <strong id="b1593545919084824"><a name="b1593545919084824"></a><a name="b1593545919084824"></a>offset</strong> and length is <strong id="b1342773616084824"><a name="b1342773616084824"></a><a name="b1342773616084824"></a>count</strong> from <strong id="b1715924668084824"><a name="b1715924668084824"></a><a name="b1715924668084824"></a>fd</strong> to the buffer. </p>
</td>
</tr>
<tr id="row1956929688084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1041061578084824"><a name="p1041061578084824"></a><a name="p1041061578084824"></a><a href="utils.md#ga6583cb37d551c2553bbb5e7df6c145be">pwrite</a> (int fd, const void *buf, size_t count, off_t offset)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p689132837084824"><a name="p689132837084824"></a><a name="p689132837084824"></a>ssize_t </p>
<p id="p1501371335084824"><a name="p1501371335084824"></a><a name="p1501371335084824"></a>Writes data from the buffer to <strong id="b605791317084824"><a name="b605791317084824"></a><a name="b605791317084824"></a>fd</strong> whose offset is <strong id="b1384725533084824"><a name="b1384725533084824"></a><a name="b1384725533084824"></a>offset</strong> and length is <strong id="b236864509084824"><a name="b236864509084824"></a><a name="b236864509084824"></a>count</strong>. </p>
</td>
</tr>
<tr id="row1788233251084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1678387034084824"><a name="p1678387034084824"></a><a name="p1678387034084824"></a><a href="utils.md#ga28af9471bbdf262321af663e02899a47">unlink</a> (const char *path)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1336986924084824"><a name="p1336986924084824"></a><a name="p1336986924084824"></a>int </p>
<p id="p1533729283084824"><a name="p1533729283084824"></a><a name="p1533729283084824"></a>Deletes a specified file. </p>
</td>
</tr>
<tr id="row864903679084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p889566076084824"><a name="p889566076084824"></a><a name="p889566076084824"></a><a href="utils.md#gaa06a637e291f5d288cae85ce32a2fe49">unlinkat</a> (int fd, const char *path, int flag)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p906400366084824"><a name="p906400366084824"></a><a name="p906400366084824"></a>int </p>
<p id="p1383707647084824"><a name="p1383707647084824"></a><a name="p1383707647084824"></a>Deletes a specified file. </p>
</td>
</tr>
<tr id="row1834471570084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p892815984084824"><a name="p892815984084824"></a><a name="p892815984084824"></a><a href="utils.md#gab2df76f2c62ae012c2e417813b5fe8ce">rmdir</a> (const char *path)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1475114483084824"><a name="p1475114483084824"></a><a name="p1475114483084824"></a>int </p>
<p id="p805584919084824"><a name="p805584919084824"></a><a name="p805584919084824"></a>Deletes a directory. </p>
</td>
</tr>
<tr id="row1876585900084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1972509386084824"><a name="p1972509386084824"></a><a name="p1972509386084824"></a><a href="utils.md#ga87674838dd2bcf61e1a1fb5c9892ab6c">truncate</a> (const char *path, off_t length)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2103894388084824"><a name="p2103894388084824"></a><a name="p2103894388084824"></a>int </p>
<p id="p769159201084824"><a name="p769159201084824"></a><a name="p769159201084824"></a>Truncates a file to a specified size based on the file path. </p>
</td>
</tr>
<tr id="row531121991084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p325844969084824"><a name="p325844969084824"></a><a name="p325844969084824"></a><a href="utils.md#ga0fb7c60877eacbfbd66eff04533ab0fe">ftruncate</a> (int fd, off_t length)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p720149539084824"><a name="p720149539084824"></a><a name="p720149539084824"></a>int </p>
<p id="p1263436160084824"><a name="p1263436160084824"></a><a name="p1263436160084824"></a>Truncates a file to a specified length. </p>
</td>
</tr>
<tr id="row1456653453084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1404447512084824"><a name="p1404447512084824"></a><a name="p1404447512084824"></a><a href="utils.md#gaeff22ad09b35eda92f6c5632300b05da">access</a> (const char *path, int mode)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p930558831084824"><a name="p930558831084824"></a><a name="p930558831084824"></a>int </p>
<p id="p547794383084824"><a name="p547794383084824"></a><a name="p547794383084824"></a>Checks whether a file has the corresponding permission. </p>
</td>
</tr>
<tr id="row772744619084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1755134473084824"><a name="p1755134473084824"></a><a name="p1755134473084824"></a><a href="utils.md#ga03af571dfb595681bfa203c83385c07b">chdir</a> (const char *path)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1768108985084824"><a name="p1768108985084824"></a><a name="p1768108985084824"></a>int </p>
<p id="p1592807305084824"><a name="p1592807305084824"></a><a name="p1592807305084824"></a>Switches the current working directory to a specified directory. </p>
</td>
</tr>
<tr id="row1665952349084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p487703611084824"><a name="p487703611084824"></a><a name="p487703611084824"></a><a href="utils.md#ga3284211bd28346254245c9d4fd071d7f">getcwd</a> (char *buf, size_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p495602126084824"><a name="p495602126084824"></a><a name="p495602126084824"></a>char * </p>
<p id="p1682768812084824"><a name="p1682768812084824"></a><a name="p1682768812084824"></a>Obtains the current working directory. </p>
</td>
</tr>
<tr id="row1958152406084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1593539385084824"><a name="p1593539385084824"></a><a name="p1593539385084824"></a><a href="utils.md#ga8c476685d78ea93ee343f8a0580c79fe">alarm</a> (unsigned int seconds)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1768508203084824"><a name="p1768508203084824"></a><a name="p1768508203084824"></a>unsigned int </p>
<p id="p1447369818084824"><a name="p1447369818084824"></a><a name="p1447369818084824"></a>Arranges a signal to be sent to the current process after the number of seconds specified by <strong id="b532478938084824"><a name="b532478938084824"></a><a name="b532478938084824"></a>seconds</strong>. </p>
</td>
</tr>
<tr id="row2098843219084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1885929430084824"><a name="p1885929430084824"></a><a name="p1885929430084824"></a><a href="utils.md#gad4669b3813c3b4a616a738317fdc974f">sleep</a> (unsigned seconds)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p260948443084824"><a name="p260948443084824"></a><a name="p260948443084824"></a>unsigned </p>
<p id="p1082654153084824"><a name="p1082654153084824"></a><a name="p1082654153084824"></a>Sleeps for a period of time. </p>
</td>
</tr>
<tr id="row118457558084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1063098142084824"><a name="p1063098142084824"></a><a name="p1063098142084824"></a><a href="utils.md#ga47a6ff5872f457ee230458137f2b2409">pause</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1943392998084824"><a name="p1943392998084824"></a><a name="p1943392998084824"></a>int </p>
<p id="p1061565573084824"><a name="p1061565573084824"></a><a name="p1061565573084824"></a>Waits for signal. </p>
</td>
</tr>
<tr id="row1382875022084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p973822448084824"><a name="p973822448084824"></a><a name="p973822448084824"></a><a href="utils.md#gaa4e4714e6e8927c80b2553a40094b6d9">fork</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p700426892084824"><a name="p700426892084824"></a><a name="p700426892084824"></a>pid_t </p>
<p id="p801995896084824"><a name="p801995896084824"></a><a name="p801995896084824"></a>Creates a new process that inherits from the user-mode data of its parent process. </p>
</td>
</tr>
<tr id="row2049984993084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1560826491084824"><a name="p1560826491084824"></a><a name="p1560826491084824"></a><a href="utils.md#ga99ca2b673a47850c541b215ddfd6b23e">execve</a> (const char *path, char *const arg[], char *const envp[])</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p569413470084824"><a name="p569413470084824"></a><a name="p569413470084824"></a>int </p>
<p id="p515581189084824"><a name="p515581189084824"></a><a name="p515581189084824"></a>Executes a specified user program file in ELF format. </p>
</td>
</tr>
<tr id="row697333849084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p836956308084824"><a name="p836956308084824"></a><a name="p836956308084824"></a><a href="utils.md#gadb609bbc5b9255bf715138cda88857b0">execv</a> (const char *path, char *const arg[])</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p462378626084824"><a name="p462378626084824"></a><a name="p462378626084824"></a>int </p>
<p id="p1450903854084824"><a name="p1450903854084824"></a><a name="p1450903854084824"></a>Executes a specified user program file in ELF format. </p>
</td>
</tr>
<tr id="row593830931084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1251695256084824"><a name="p1251695256084824"></a><a name="p1251695256084824"></a><a href="utils.md#ga2c2701379e4144b3105aa83c82363aa3">execle</a> (const char *path, const char *arg,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1677609748084824"><a name="p1677609748084824"></a><a name="p1677609748084824"></a>int </p>
<p id="p377678323084824"><a name="p377678323084824"></a><a name="p377678323084824"></a>Executes a specified user program file in ELF format. </p>
</td>
</tr>
<tr id="row515796376084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1479414722084824"><a name="p1479414722084824"></a><a name="p1479414722084824"></a><a href="utils.md#ga1ade18bb3b763fbcefc507c770dc7e7e">execl</a> (const char *path, const char *arg,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1639861876084824"><a name="p1639861876084824"></a><a name="p1639861876084824"></a>int </p>
<p id="p1162447403084824"><a name="p1162447403084824"></a><a name="p1162447403084824"></a>Executes a specified user program file in ELF format. </p>
</td>
</tr>
<tr id="row2139315868084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p981059406084824"><a name="p981059406084824"></a><a name="p981059406084824"></a><a href="utils.md#ga1bbb0ecd56c097ca82587115b4dfd540">execvp</a> (const char *path, char *const arg[])</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1583996239084824"><a name="p1583996239084824"></a><a name="p1583996239084824"></a>int </p>
<p id="p38038593084824"><a name="p38038593084824"></a><a name="p38038593084824"></a>Executes a specified user program file in ELF format. </p>
</td>
</tr>
<tr id="row1999736157084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1818009810084824"><a name="p1818009810084824"></a><a name="p1818009810084824"></a><a href="utils.md#ga4dd268acb7fc54f403ab6cb56b7ffd3f">execlp</a> (const char *path, const char *arg,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1352371041084824"><a name="p1352371041084824"></a><a name="p1352371041084824"></a>int </p>
<p id="p1521851189084824"><a name="p1521851189084824"></a><a name="p1521851189084824"></a>Executes a specified user program file in ELF format. </p>
</td>
</tr>
<tr id="row449744728084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1916785703084824"><a name="p1916785703084824"></a><a name="p1916785703084824"></a><a href="utils.md#gaee2ffcdf92b92a337c592a7ef9174769">_exit</a> (int status)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1001625622084824"><a name="p1001625622084824"></a><a name="p1001625622084824"></a>_Noreturn void </p>
<p id="p361358143084824"><a name="p361358143084824"></a><a name="p361358143084824"></a>Exits the process immediately and closes all opened file descriptors in the process. </p>
</td>
</tr>
<tr id="row962891759084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p444928141084824"><a name="p444928141084824"></a><a name="p444928141084824"></a><a href="utils.md#ga27ee6e902becdb181addb45b69a50b8c">swab</a> (const void *from, void *to, ssize_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p944987620084824"><a name="p944987620084824"></a><a name="p944987620084824"></a>void </p>
<p id="p1994521493084824"><a name="p1994521493084824"></a><a name="p1994521493084824"></a>Swaps bytes. </p>
</td>
</tr>
<tr id="row820564669084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1900224245084824"><a name="p1900224245084824"></a><a name="p1900224245084824"></a><a href="utils.md#gac61b207337ca21b3b309593fd1a0cb82">getpid</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1228865144084824"><a name="p1228865144084824"></a><a name="p1228865144084824"></a>pid_t </p>
<p id="p365230307084824"><a name="p365230307084824"></a><a name="p365230307084824"></a>Obtains the process ID. </p>
</td>
</tr>
<tr id="row1821644127084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1977375986084824"><a name="p1977375986084824"></a><a name="p1977375986084824"></a><a href="utils.md#gac6d7f7ade00dcdc302b0da5664eee812">getppid</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1367824255084824"><a name="p1367824255084824"></a><a name="p1367824255084824"></a>pid_t </p>
<p id="p124548731084824"><a name="p124548731084824"></a><a name="p124548731084824"></a>Obtains the parent process ID. </p>
</td>
</tr>
<tr id="row678749687084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1042123227084824"><a name="p1042123227084824"></a><a name="p1042123227084824"></a><a href="utils.md#ga06f4ba65249f92cacdba5782a8d70eba">getpgrp</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p361637298084824"><a name="p361637298084824"></a><a name="p361637298084824"></a>pid_t </p>
<p id="p1881994623084824"><a name="p1881994623084824"></a><a name="p1881994623084824"></a>Obtains the ID of the process group of the calling process. </p>
</td>
</tr>
<tr id="row1202992716084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1779740459084824"><a name="p1779740459084824"></a><a name="p1779740459084824"></a><a href="utils.md#ga48f523c98970793dfc2c5a05f6832006">getpgid</a> (pid_t pid)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p370697225084824"><a name="p370697225084824"></a><a name="p370697225084824"></a>pid_t </p>
<p id="p931970265084824"><a name="p931970265084824"></a><a name="p931970265084824"></a>Obtains the ID of the process group whose process ID is specified by <strong id="b1330459348084824"><a name="b1330459348084824"></a><a name="b1330459348084824"></a>pid</strong>. </p>
</td>
</tr>
<tr id="row1769800884084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1936501099084824"><a name="p1936501099084824"></a><a name="p1936501099084824"></a><a href="utils.md#gae5aae5b0275eefe79314a4673195e475">setpgid</a> (pid_t pid, pid_t pgid)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p574915378084824"><a name="p574915378084824"></a><a name="p574915378084824"></a>int </p>
<p id="p909428616084824"><a name="p909428616084824"></a><a name="p909428616084824"></a>Sets the ID of the process group whose process ID is specified by <strong id="b1470190210084824"><a name="b1470190210084824"></a><a name="b1470190210084824"></a>pid</strong>. </p>
</td>
</tr>
<tr id="row1022861094084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1237691169084824"><a name="p1237691169084824"></a><a name="p1237691169084824"></a><a href="utils.md#ga5ffa4c677fc71cecd94f140ef9db624c">getopt</a> (int argc, char *const argv[], const char *optstring)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1235628919084824"><a name="p1235628919084824"></a><a name="p1235628919084824"></a>int </p>
<p id="p24859905084824"><a name="p24859905084824"></a><a name="p24859905084824"></a>Parses command-line arguments based on the specified option. </p>
</td>
</tr>
<tr id="row1736915710084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1163080606084824"><a name="p1163080606084824"></a><a name="p1163080606084824"></a><a href="utils.md#ga2f517436c22ef73337d3de4920908c6c">getuid</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1876552340084824"><a name="p1876552340084824"></a><a name="p1876552340084824"></a>uid_t </p>
<p id="p1791732583084824"><a name="p1791732583084824"></a><a name="p1791732583084824"></a>Obtains the real user ID (UID) of the calling process. </p>
</td>
</tr>
<tr id="row1105220572084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p226190758084824"><a name="p226190758084824"></a><a name="p226190758084824"></a><a href="utils.md#ga8b9a6dcf4e1d237f5607256dad93e26a">geteuid</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p430050467084824"><a name="p430050467084824"></a><a name="p430050467084824"></a>uid_t </p>
<p id="p800560460084824"><a name="p800560460084824"></a><a name="p800560460084824"></a>Obtains the effective user ID (UID) of the calling process. </p>
</td>
</tr>
<tr id="row1043105809084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1148274419084824"><a name="p1148274419084824"></a><a name="p1148274419084824"></a><a href="utils.md#ga58ca281cc6931c62e6a85e2edb5b4b49">getgid</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1477502233084824"><a name="p1477502233084824"></a><a name="p1477502233084824"></a>gid_t </p>
<p id="p1958897527084824"><a name="p1958897527084824"></a><a name="p1958897527084824"></a>Obtains the real group ID (GID) of the calling process. </p>
</td>
</tr>
<tr id="row1668894514084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1438900585084824"><a name="p1438900585084824"></a><a name="p1438900585084824"></a><a href="utils.md#ga3e7c694d68b4e62c1f275612d30b6d9d">getegid</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1076065447084824"><a name="p1076065447084824"></a><a name="p1076065447084824"></a>gid_t </p>
<p id="p1915392338084824"><a name="p1915392338084824"></a><a name="p1915392338084824"></a>Obtains the effective group ID (GID) of the calling process. </p>
</td>
</tr>
<tr id="row1091931662084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p939960784084824"><a name="p939960784084824"></a><a name="p939960784084824"></a><a href="utils.md#gaacfa67f2aef6be4baceace6a00856d21">getgroups</a> (int size, gid_t list[])</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p567586548084824"><a name="p567586548084824"></a><a name="p567586548084824"></a>int </p>
<p id="p434852661084824"><a name="p434852661084824"></a><a name="p434852661084824"></a>Obtains a list of supplementary user group IDs specific to the calling process. </p>
</td>
</tr>
<tr id="row358938557084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p130229309084824"><a name="p130229309084824"></a><a name="p130229309084824"></a><a href="utils.md#gaa426fc963bb0a4f469eef61d9f0c4a26">setuid</a> (uid_t uid)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p963855669084824"><a name="p963855669084824"></a><a name="p963855669084824"></a>int </p>
<p id="p745666033084824"><a name="p745666033084824"></a><a name="p745666033084824"></a>Sets the real user ID for the calling process. </p>
</td>
</tr>
<tr id="row1091300675084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p913587457084824"><a name="p913587457084824"></a><a name="p913587457084824"></a><a href="utils.md#ga1f3f88da554f543f01a02a06c79c7bdd">seteuid</a> (uid_t euid)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1418217437084824"><a name="p1418217437084824"></a><a name="p1418217437084824"></a>int </p>
<p id="p26652451084824"><a name="p26652451084824"></a><a name="p26652451084824"></a>Sets the effective user ID of the calling process. </p>
</td>
</tr>
<tr id="row676462862084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p918855747084824"><a name="p918855747084824"></a><a name="p918855747084824"></a><a href="utils.md#ga3116233500c2c34795d437eaf34b69b5">setgid</a> (gid_t gid)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2140252088084824"><a name="p2140252088084824"></a><a name="p2140252088084824"></a>int </p>
<p id="p851496862084824"><a name="p851496862084824"></a><a name="p851496862084824"></a>Sets the user group ID of the calling process. </p>
</td>
</tr>
<tr id="row769999732084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p432820939084824"><a name="p432820939084824"></a><a name="p432820939084824"></a><a href="utils.md#ga201d5dad2108506c5db5ba8d126ffbb2">setegid</a> (gid_t egid)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p130382896084824"><a name="p130382896084824"></a><a name="p130382896084824"></a>int </p>
<p id="p1103608122084824"><a name="p1103608122084824"></a><a name="p1103608122084824"></a>Sets the effective user group ID of the calling process. </p>
</td>
</tr>
<tr id="row2144824074084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1490210219084824"><a name="p1490210219084824"></a><a name="p1490210219084824"></a><a href="utils.md#gaa4ea4bbebf4841965159e66b5d1a49e8">pathconf</a> (const char *path, int name)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1541713431084824"><a name="p1541713431084824"></a><a name="p1541713431084824"></a>long </p>
<p id="p1786556322084824"><a name="p1786556322084824"></a><a name="p1786556322084824"></a>Obtains the configuration value of a file. </p>
</td>
</tr>
<tr id="row2109601297084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p739874198084824"><a name="p739874198084824"></a><a name="p739874198084824"></a><a href="utils.md#ga0c1be1c8a11bac9cdf41613e996c841b">setreuid</a> (uid_t ruid, uid_t euid)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1183115651084824"><a name="p1183115651084824"></a><a name="p1183115651084824"></a>int </p>
<p id="p1216531473084824"><a name="p1216531473084824"></a><a name="p1216531473084824"></a>Sets the real and effective user IDs of the calling process. </p>
</td>
</tr>
<tr id="row943531353084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1413095284084824"><a name="p1413095284084824"></a><a name="p1413095284084824"></a><a href="utils.md#ga869d651a498782b6f3625e2bdbc439d6">setregid</a> (gid_t rgid, gid_t egid)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p354032976084824"><a name="p354032976084824"></a><a name="p354032976084824"></a>int </p>
<p id="p2036230484084824"><a name="p2036230484084824"></a><a name="p2036230484084824"></a>Sets the real and effective user group IDs of the calling process. </p>
</td>
</tr>
<tr id="row1269104484084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p345006556084824"><a name="p345006556084824"></a><a name="p345006556084824"></a><a href="utils.md#gada2b1e6782cd8fc506fde243f7d313ec">setpgrp</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1365484268084824"><a name="p1365484268084824"></a><a name="p1365484268084824"></a>pid_t </p>
<p id="p1883782773084824"><a name="p1883782773084824"></a><a name="p1883782773084824"></a>Sets the process group ID of the calling process. </p>
</td>
</tr>
<tr id="row1710097336084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2048903541084824"><a name="p2048903541084824"></a><a name="p2048903541084824"></a><a href="utils.md#ga608e849b00b0ac57524b26f45d408a55">usleep</a> (unsigned useconds)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1944489717084824"><a name="p1944489717084824"></a><a name="p1944489717084824"></a>int </p>
<p id="p1654887404084824"><a name="p1654887404084824"></a><a name="p1654887404084824"></a>Sleeps for several microseconds. </p>
</td>
</tr>
<tr id="row1977857847084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1180011537084824"><a name="p1180011537084824"></a><a name="p1180011537084824"></a><a href="utils.md#ga9d35348d3389a721ab5aef5f4f036c61">ualarm</a> (unsigned value, unsigned interval)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2087671602084824"><a name="p2087671602084824"></a><a name="p2087671602084824"></a>unsigned </p>
<p id="p1390012784084824"><a name="p1390012784084824"></a><a name="p1390012784084824"></a>Sets a microsecond-level timer. </p>
</td>
</tr>
<tr id="row864572566084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1602638561084824"><a name="p1602638561084824"></a><a name="p1602638561084824"></a><a href="utils.md#gaf7df624933ff8690b60c537a29659718">setgroups</a> (size_t size, const gid_t *list)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p727214161084824"><a name="p727214161084824"></a><a name="p727214161084824"></a>int </p>
<p id="p2134138847084824"><a name="p2134138847084824"></a><a name="p2134138847084824"></a>Sets the supplementary user group list of the calling process. </p>
</td>
</tr>
<tr id="row1136547091084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p526476896084824"><a name="p526476896084824"></a><a name="p526476896084824"></a><a href="utils.md#gac3827ffb6833b1e282fc2ea856d534a1">setresuid</a> (uid_t ruid, uid_t euid, uid_t suid)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2079051940084824"><a name="p2079051940084824"></a><a name="p2079051940084824"></a>int </p>
<p id="p2070851832084824"><a name="p2070851832084824"></a><a name="p2070851832084824"></a>Sets the real, effective, and saved user IDs of the calling process. </p>
</td>
</tr>
<tr id="row167244010084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1726348915084824"><a name="p1726348915084824"></a><a name="p1726348915084824"></a><a href="utils.md#gabb0ec1f467235bee75ee359400d817e4">setresgid</a> (gid_t rgid, gid_t egid, gid_t sgid)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2042764905084824"><a name="p2042764905084824"></a><a name="p2042764905084824"></a>int </p>
<p id="p1967504255084824"><a name="p1967504255084824"></a><a name="p1967504255084824"></a>Sets the real, effective, and saved group IDs of the calling process. </p>
</td>
</tr>
<tr id="row1984197493084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p696926749084824"><a name="p696926749084824"></a><a name="p696926749084824"></a><a href="utils.md#ga4e92f1f4fb48c6fa8cd15d328950bc68">getresuid</a> (uid_t *ruid, uid_t *euid, uid_t *suid)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p445086324084824"><a name="p445086324084824"></a><a name="p445086324084824"></a>int </p>
<p id="p65440129084824"><a name="p65440129084824"></a><a name="p65440129084824"></a>Obtains the real, effective, and saved user IDs of the calling process. </p>
</td>
</tr>
<tr id="row996616507084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1985802371084824"><a name="p1985802371084824"></a><a name="p1985802371084824"></a><a href="utils.md#gaf74b37e12b6a9418c094479721e8cbf0">getresgid</a> (gid_t *rgid, gid_t *egid, gid_t *sgid)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1711403427084824"><a name="p1711403427084824"></a><a name="p1711403427084824"></a>int </p>
<p id="p923082769084824"><a name="p923082769084824"></a><a name="p923082769084824"></a>Obtains the real, effective, and saved user group IDs of the calling process. </p>
</td>
</tr>
<tr id="row1889340352084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1513211948084824"><a name="p1513211948084824"></a><a name="p1513211948084824"></a><a href="utils.md#gaa0cf2e9b2a054c6ea46db972840fbc51">get_current_dir_name</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p801277182084824"><a name="p801277182084824"></a><a name="p801277182084824"></a>char * </p>
<p id="p298730666084824"><a name="p298730666084824"></a><a name="p298730666084824"></a>Obtains the name of the current working directory. </p>
</td>
</tr>
<tr id="row1414315632084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1409785992084824"><a name="p1409785992084824"></a><a name="p1409785992084824"></a><a href="utils.md#ga3b818446c640442e94e746319f5f2858">sbrk</a> (intptr_t increment)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1339028950084824"><a name="p1339028950084824"></a><a name="p1339028950084824"></a>void * </p>
<p id="p1735493195084824"><a name="p1735493195084824"></a><a name="p1735493195084824"></a>Adjusts the heap size of a process. </p>
</td>
</tr>
<tr id="row1949327810084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p605793109084824"><a name="p605793109084824"></a><a name="p605793109084824"></a><a href="utils.md#ga638757347bd9bf886b3d442b98033cf1">getpagesize</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p142494327084824"><a name="p142494327084824"></a><a name="p142494327084824"></a>int </p>
<p id="p946006023084824"><a name="p946006023084824"></a><a name="p946006023084824"></a>Obtains the memory page size. </p>
</td>
</tr>
<tr id="row1322863727084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1311059142084824"><a name="p1311059142084824"></a><a name="p1311059142084824"></a><a href="utils.md#ga7c080ffcae5180218dda2df501e0cb15">chown</a> (const char *pathname, uid_t owner, gid_t group)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1113689033084824"><a name="p1113689033084824"></a><a name="p1113689033084824"></a>int </p>
<p id="p402278608084824"><a name="p402278608084824"></a><a name="p402278608084824"></a>Changes the user and group ownership of a file. </p>
</td>
</tr>
<tr id="row834006423084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2055641816084824"><a name="p2055641816084824"></a><a name="p2055641816084824"></a><a href="utils.md#gae6b223ed61020ed2abf0279af175b203">wcscpy</a> (wchar_t *dest, const wchar_t *src)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1683799865084824"><a name="p1683799865084824"></a><a name="p1683799865084824"></a>wchar_t * </p>
<p id="p358459757084824"><a name="p358459757084824"></a><a name="p358459757084824"></a>Copies the wide characters pointed to by <strong id="b676097082084824"><a name="b676097082084824"></a><a name="b676097082084824"></a>src</strong> to the wide character array pointed to by <strong id="b361741589084824"><a name="b361741589084824"></a><a name="b361741589084824"></a>dest</strong>, including the terminating null character <strong id="b1345715370084824"><a name="b1345715370084824"></a><a name="b1345715370084824"></a>'\0'</strong>. . </p>
</td>
</tr>
<tr id="row1514080546084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1239617929084824"><a name="p1239617929084824"></a><a name="p1239617929084824"></a><a href="utils.md#gab1f03e735cf92afa01bef89682008c9b">wcsncpy</a> (wchar_t *dest, const wchar_t *src, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p491010934084824"><a name="p491010934084824"></a><a name="p491010934084824"></a>wchar_t * </p>
<p id="p390739728084824"><a name="p390739728084824"></a><a name="p390739728084824"></a>Copies the first <strong id="b66448980084824"><a name="b66448980084824"></a><a name="b66448980084824"></a>n</strong> wide characters pointed to by <strong id="b1571910151084824"><a name="b1571910151084824"></a><a name="b1571910151084824"></a>src</strong> to the wide character array pointed to by <strong id="b359982630084824"><a name="b359982630084824"></a><a name="b359982630084824"></a>dest</strong>. </p>
</td>
</tr>
<tr id="row462740084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1842532440084824"><a name="p1842532440084824"></a><a name="p1842532440084824"></a><a href="utils.md#ga1fa2f722dd578b02ed196a74488f75f0">wcscat</a> (wchar_t *dest, const wchar_t *src)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p486231236084824"><a name="p486231236084824"></a><a name="p486231236084824"></a>wchar_t * </p>
<p id="p55188362084824"><a name="p55188362084824"></a><a name="p55188362084824"></a>Appends a copy of the wide characters pointed to by <strong id="b2040127415084824"><a name="b2040127415084824"></a><a name="b2040127415084824"></a>src</strong> to the end of the wide character array pointed to by <strong id="b1369567353084824"><a name="b1369567353084824"></a><a name="b1369567353084824"></a>dest</strong> and adds a terminating null character <strong id="b461929717084824"><a name="b461929717084824"></a><a name="b461929717084824"></a>'\0'</strong>. </p>
</td>
</tr>
<tr id="row142158350084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p921832865084824"><a name="p921832865084824"></a><a name="p921832865084824"></a><a href="utils.md#ga8af5b08f466d2d6843f7ec250eddb41c">wcsncat</a> (wchar_t *dest, const wchar_t *src, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1091264887084824"><a name="p1091264887084824"></a><a name="p1091264887084824"></a>wchar_t * </p>
<p id="p1064985085084824"><a name="p1064985085084824"></a><a name="p1064985085084824"></a>Appends a copy of the first <strong id="b1770205786084824"><a name="b1770205786084824"></a><a name="b1770205786084824"></a>n</strong> wide characters pointed to by <strong id="b835931057084824"><a name="b835931057084824"></a><a name="b835931057084824"></a>src</strong> to the end of the wide characters pointed to by <strong id="b1644833418084824"><a name="b1644833418084824"></a><a name="b1644833418084824"></a>dest</strong> and adds a terminating null character <strong id="b1968376990084824"><a name="b1968376990084824"></a><a name="b1968376990084824"></a>'\0'</strong>. </p>
</td>
</tr>
<tr id="row690436672084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1942151771084824"><a name="p1942151771084824"></a><a name="p1942151771084824"></a><a href="utils.md#gab361438866831d03563fbb430c1514c5">wcscmp</a> (const wchar_t *s1, const wchar_t *s2)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1694852454084824"><a name="p1694852454084824"></a><a name="p1694852454084824"></a>int </p>
<p id="p2118555283084824"><a name="p2118555283084824"></a><a name="p2118555283084824"></a>Compares each character in the string pointed to by <strong id="b482289515084824"><a name="b482289515084824"></a><a name="b482289515084824"></a>s1</strong> with that in the string pointed to by <strong id="b1829044754084824"><a name="b1829044754084824"></a><a name="b1829044754084824"></a>s2</strong> in ASCII-code order. </p>
</td>
</tr>
<tr id="row96092427084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1862585155084824"><a name="p1862585155084824"></a><a name="p1862585155084824"></a><a href="utils.md#ga422e6bb262f249f2d71b6a2d77408038">wcsncmp</a> (const wchar_t *s1, const wchar_t *s2, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p504903656084824"><a name="p504903656084824"></a><a name="p504903656084824"></a>int </p>
<p id="p1662200693084824"><a name="p1662200693084824"></a><a name="p1662200693084824"></a>Compares the first <strong id="b1551748703084824"><a name="b1551748703084824"></a><a name="b1551748703084824"></a>n</strong> characters in the string pointed to by <strong id="b237259644084824"><a name="b237259644084824"></a><a name="b237259644084824"></a>s1</strong> with those in the string pointed to by <strong id="b1355284456084824"><a name="b1355284456084824"></a><a name="b1355284456084824"></a>s2</strong> in ASCII-code order. </p>
</td>
</tr>
<tr id="row2110249469084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1330665342084824"><a name="p1330665342084824"></a><a name="p1330665342084824"></a><a href="utils.md#ga99ef4b8381c22d8db3b2b13d8c3a3c29">wcscoll</a> (const wchar_t *ws1, const wchar_t *ws2)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1993218311084824"><a name="p1993218311084824"></a><a name="p1993218311084824"></a>int </p>
<p id="p553609586084824"><a name="p553609586084824"></a><a name="p553609586084824"></a>Compares the wide characters in the string pointed to by <strong id="b521870017084824"><a name="b521870017084824"></a><a name="b521870017084824"></a>ws1</strong> with those in the string pointed to by <strong id="b1315684792084824"><a name="b1315684792084824"></a><a name="b1315684792084824"></a>ws2</strong> based on the specified locale <a href="io.md#gaab9cf7b1a206fb75e5884934c8d676db">LC_COLLATE</a>. </p>
</td>
</tr>
<tr id="row481614765084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1064571224084824"><a name="p1064571224084824"></a><a name="p1064571224084824"></a><a href="utils.md#ga3a0974b661a750f99ec204adf0921baf">wcsxfrm</a> (wchar_t *s1, const wchar_t *s2, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p522430072084824"><a name="p522430072084824"></a><a name="p522430072084824"></a>size_t </p>
<p id="p161815724084824"><a name="p161815724084824"></a><a name="p161815724084824"></a>Compares the first <strong id="b1283676442084824"><a name="b1283676442084824"></a><a name="b1283676442084824"></a>n</strong> wide characters in the string pointed to by <strong id="b1025584338084824"><a name="b1025584338084824"></a><a name="b1025584338084824"></a>s1</strong> with those in the string pointed to by <strong id="b1128806668084824"><a name="b1128806668084824"></a><a name="b1128806668084824"></a>s2</strong>. </p>
</td>
</tr>
<tr id="row119800703084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p744793059084824"><a name="p744793059084824"></a><a name="p744793059084824"></a><a href="utils.md#ga3fe8f361d1cff837a204ef0f4fac68eb">wcschr</a> (const wchar_t *wcs, wchar_t wc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1849330079084824"><a name="p1849330079084824"></a><a name="p1849330079084824"></a>wchar_t * </p>
<p id="p1137997423084824"><a name="p1137997423084824"></a><a name="p1137997423084824"></a>Locates the first occurrence of the wide character pointed to by <strong id="b755846831084824"><a name="b755846831084824"></a><a name="b755846831084824"></a>wc</strong> in the wide character string pointed to by <strong id="b776712551084824"><a name="b776712551084824"></a><a name="b776712551084824"></a>wcs</strong>. </p>
</td>
</tr>
<tr id="row850416041084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p266924356084824"><a name="p266924356084824"></a><a name="p266924356084824"></a><a href="utils.md#ga1e2b53d4a4eb975edfd1ec59099a43bd">wcsrchr</a> (const wchar_t *wcs, wchar_t wc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2137933471084824"><a name="p2137933471084824"></a><a name="p2137933471084824"></a>wchar_t * </p>
<p id="p1969737312084824"><a name="p1969737312084824"></a><a name="p1969737312084824"></a>Locates the last occurrence of the wide character pointed to by <strong id="b1562554212084824"><a name="b1562554212084824"></a><a name="b1562554212084824"></a>wc</strong> in the wide character string pointed to by <strong id="b931420828084824"><a name="b931420828084824"></a><a name="b931420828084824"></a>wcs</strong>. </p>
</td>
</tr>
<tr id="row1244424762084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p209416577084824"><a name="p209416577084824"></a><a name="p209416577084824"></a><a href="utils.md#ga188fb5a6a8c210ee46b885a671f55c61">wcscspn</a> (const wchar_t *wcs, const wchar_t *<a href="net.md#ga0807af5ac9dfc2a63624e8c3e0ae95ef">accept</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p127445868084824"><a name="p127445868084824"></a><a name="p127445868084824"></a>size_t </p>
<p id="p2061373268084824"><a name="p2061373268084824"></a><a name="p2061373268084824"></a>Scans the wide character string pointed to by <strong id="b1503860657084824"><a name="b1503860657084824"></a><a name="b1503860657084824"></a>wcs</strong> for any wide characters specified in <strong id="b1820522591084824"><a name="b1820522591084824"></a><a name="b1820522591084824"></a>reject</strong> and obtains the number of unmatched characters in <strong id="b1463504272084824"><a name="b1463504272084824"></a><a name="b1463504272084824"></a>wcs</strong>. </p>
</td>
</tr>
<tr id="row1726967512084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1201707857084824"><a name="p1201707857084824"></a><a name="p1201707857084824"></a><a href="utils.md#ga2a5d42d9b374cbffb3037d0e7efb97a9">wcsspn</a> (const wchar_t *wcs, const wchar_t *<a href="net.md#ga0807af5ac9dfc2a63624e8c3e0ae95ef">accept</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1670934222084824"><a name="p1670934222084824"></a><a name="p1670934222084824"></a>size_t </p>
<p id="p1321884361084824"><a name="p1321884361084824"></a><a name="p1321884361084824"></a>Scans the wide character string pointed to by <strong id="b1524622179084824"><a name="b1524622179084824"></a><a name="b1524622179084824"></a>wcs</strong> for any wide characters specified in <strong id="b1796304193084824"><a name="b1796304193084824"></a><a name="b1796304193084824"></a>reject</strong> and obtains the number matched characters in <strong id="b1386180401084824"><a name="b1386180401084824"></a><a name="b1386180401084824"></a>wcs</strong>. </p>
</td>
</tr>
<tr id="row1618214444084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1492352990084824"><a name="p1492352990084824"></a><a name="p1492352990084824"></a><a href="utils.md#ga65c3cbada5beb856956f682e7ab2d812">wcspbrk</a> (const wchar_t *wcs, const wchar_t *<a href="net.md#ga0807af5ac9dfc2a63624e8c3e0ae95ef">accept</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1062315653084824"><a name="p1062315653084824"></a><a name="p1062315653084824"></a>wchar_t * </p>
<p id="p634172129084824"><a name="p634172129084824"></a><a name="p634172129084824"></a>Scans the wide character string pointed to by <strong id="b201360938084824"><a name="b201360938084824"></a><a name="b201360938084824"></a>wcs</strong> for any wide characters specified in <strong id="b1774123132084824"><a name="b1774123132084824"></a><a name="b1774123132084824"></a>accept</strong> and obtains the first occurrence of the matched character. </p>
</td>
</tr>
<tr id="row2116367958084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p965572851084824"><a name="p965572851084824"></a><a name="p965572851084824"></a><a href="utils.md#ga01f67f93543c36fdae41b410a7f3d963">wcstok</a> (wchar_t *wcs, const wchar_t *delim, wchar_t **ptr)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p15637671084824"><a name="p15637671084824"></a><a name="p15637671084824"></a>wchar_t * </p>
<p id="p1284822305084824"><a name="p1284822305084824"></a><a name="p1284822305084824"></a>Splits a wide character string pointed to by <strong id="b423440377084824"><a name="b423440377084824"></a><a name="b423440377084824"></a>wcs</strong> into tokens using the given delimiter. </p>
</td>
</tr>
<tr id="row1618811311084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p957560464084824"><a name="p957560464084824"></a><a name="p957560464084824"></a><a href="utils.md#ga7859e4ba07f77515772c4632d4caa4e0">wcslen</a> (const wchar_t *s)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p244441569084824"><a name="p244441569084824"></a><a name="p244441569084824"></a>size_t </p>
<p id="p1602041805084824"><a name="p1602041805084824"></a><a name="p1602041805084824"></a>Calculates the length of a wide character string pointed to by <strong id="b1471514637084824"><a name="b1471514637084824"></a><a name="b1471514637084824"></a>s</strong>. </p>
</td>
</tr>
<tr id="row1276319565084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1400619945084824"><a name="p1400619945084824"></a><a name="p1400619945084824"></a><a href="utils.md#ga844ce8231d55e4cc8010130477dd0d5a">wcswcs</a> (const wchar_t *haystack, const wchar_t *needle)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1790802829084824"><a name="p1790802829084824"></a><a name="p1790802829084824"></a>wchar_t * </p>
<p id="p1797777406084824"><a name="p1797777406084824"></a><a name="p1797777406084824"></a>Searches the wide character string pointed to by <strong id="b1118672621084824"><a name="b1118672621084824"></a><a name="b1118672621084824"></a>dest</strong> for the first occurrence of the wide character string pointed to by <strong id="b1981934027084824"><a name="b1981934027084824"></a><a name="b1981934027084824"></a>src</strong>. </p>
</td>
</tr>
<tr id="row1813777835084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1702310412084824"><a name="p1702310412084824"></a><a name="p1702310412084824"></a><a href="utils.md#gacb1e61bbd4b15305803c0e558c00bcdd">wmemchr</a> (const wchar_t *s, wchar_t c, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p106987515084824"><a name="p106987515084824"></a><a name="p106987515084824"></a>wchar_t * </p>
<p id="p415852867084824"><a name="p415852867084824"></a><a name="p415852867084824"></a>Searches for the first position of the matched wide character within the specified number of characters in a wide character string. </p>
</td>
</tr>
<tr id="row1117125901084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1450482664084824"><a name="p1450482664084824"></a><a name="p1450482664084824"></a><a href="utils.md#gaec76ca0ca875ef6cfcc1d7415052eb26">wmemcmp</a> (const wchar_t *lhs, const wchar_t *rhs, size_t count)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1088710867084824"><a name="p1088710867084824"></a><a name="p1088710867084824"></a>int </p>
<p id="p703953174084824"><a name="p703953174084824"></a><a name="p703953174084824"></a>Compares the first <strong id="b1727683846084824"><a name="b1727683846084824"></a><a name="b1727683846084824"></a>count</strong> characters in the string pointed to by <strong id="b1913029171084824"><a name="b1913029171084824"></a><a name="b1913029171084824"></a>lhs</strong> with the first <strong id="b1005152326084824"><a name="b1005152326084824"></a><a name="b1005152326084824"></a>count</strong> characters in the string pointed to by <strong id="b1608485861084824"><a name="b1608485861084824"></a><a name="b1608485861084824"></a>rhs</strong>. </p>
</td>
</tr>
<tr id="row575982906084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p224892267084824"><a name="p224892267084824"></a><a name="p224892267084824"></a><a href="utils.md#gac20ec2fc709b45b0b89dbdc3ae6a537e">wmemcpy</a> (wchar_t *dest, const wchar_t *src, size_t count)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p631816663084824"><a name="p631816663084824"></a><a name="p631816663084824"></a>wchar_t * </p>
<p id="p1554189304084824"><a name="p1554189304084824"></a><a name="p1554189304084824"></a>Copies <strong id="b1902814793084824"><a name="b1902814793084824"></a><a name="b1902814793084824"></a>count</strong> successive characters from the wide character array pointed to by <strong id="b519206431084824"><a name="b519206431084824"></a><a name="b519206431084824"></a>src</strong> to the wide character array pointed to by <strong id="b1060741115084824"><a name="b1060741115084824"></a><a name="b1060741115084824"></a>dest</strong>. </p>
</td>
</tr>
<tr id="row2002198780084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p70308247084824"><a name="p70308247084824"></a><a name="p70308247084824"></a><a href="utils.md#ga7eeab622d3eacdfd8ff0c4226cf85209">wmemmove</a> (wchar_t *dest, const wchar_t *src, size_t count)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p790449235084824"><a name="p790449235084824"></a><a name="p790449235084824"></a>wchar_t * </p>
<p id="p1295675830084824"><a name="p1295675830084824"></a><a name="p1295675830084824"></a>Copies <strong id="b1370837610084824"><a name="b1370837610084824"></a><a name="b1370837610084824"></a>count</strong> successive characters from the wide character array pointed to by <strong id="b1374252184084824"><a name="b1374252184084824"></a><a name="b1374252184084824"></a>src</strong> to the wide character array pointed to by <strong id="b2145338709084824"><a name="b2145338709084824"></a><a name="b2145338709084824"></a>dest</strong> (with possible array overlapping). </p>
</td>
</tr>
<tr id="row78624352084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p669880663084824"><a name="p669880663084824"></a><a name="p669880663084824"></a><a href="utils.md#ga830c36f7d0d13b4dcb5059e7b1d9ab83">wmemset</a> (wchar_t *dest, wchar_t ch, size_t count)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p806005540084824"><a name="p806005540084824"></a><a name="p806005540084824"></a>wchar_t * </p>
<p id="p1137985417084824"><a name="p1137985417084824"></a><a name="p1137985417084824"></a>Fills <strong id="b263582112084824"><a name="b263582112084824"></a><a name="b263582112084824"></a>count</strong> characters specified by <strong id="b320634972084824"><a name="b320634972084824"></a><a name="b320634972084824"></a>ch</strong> to the wide character array pointed to by <strong id="b488570750084824"><a name="b488570750084824"></a><a name="b488570750084824"></a>dest</strong>. </p>
</td>
</tr>
<tr id="row1047269206084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p47518221084824"><a name="p47518221084824"></a><a name="p47518221084824"></a><a href="utils.md#ga263759bc74f8621e89e6077095caa942">btowc</a> (int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p90997181084824"><a name="p90997181084824"></a><a name="p90997181084824"></a>wint_t </p>
<p id="p809248196084824"><a name="p809248196084824"></a><a name="p809248196084824"></a>Converts a single-byte character <strong id="b550569954084824"><a name="b550569954084824"></a><a name="b550569954084824"></a>c</strong> into its wide-character representation. </p>
</td>
</tr>
<tr id="row75949858084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p465022859084824"><a name="p465022859084824"></a><a name="p465022859084824"></a><a href="utils.md#gafea1d08554775797ac259bf0aea62938">wctob</a> (wint_t c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2046224033084824"><a name="p2046224033084824"></a><a name="p2046224033084824"></a>int </p>
<p id="p633435513084824"><a name="p633435513084824"></a><a name="p633435513084824"></a>Converts a wide character <strong id="b207563958084824"><a name="b207563958084824"></a><a name="b207563958084824"></a>c</strong> into its single-byte representation. </p>
</td>
</tr>
<tr id="row937538078084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1253796179084824"><a name="p1253796179084824"></a><a name="p1253796179084824"></a><a href="utils.md#gac87bb41cb64e86b29faf5b569c2533b4">mbsinit</a> (const mbstate_t *ps)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p619791389084824"><a name="p619791389084824"></a><a name="p619791389084824"></a>int </p>
<p id="p1094321255084824"><a name="p1094321255084824"></a><a name="p1094321255084824"></a>Checks whether the <strong id="b260547902084824"><a name="b260547902084824"></a><a name="b260547902084824"></a>mbstate_t</strong> object pointed to by <strong id="b1016315051084824"><a name="b1016315051084824"></a><a name="b1016315051084824"></a>ps</strong> is in the initial state. </p>
</td>
</tr>
<tr id="row1589060815084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p194608952084824"><a name="p194608952084824"></a><a name="p194608952084824"></a><a href="utils.md#ga67e98eb761f2880dc93ceb3833bbf9bd">wcrtomb</a> (char *s, wchar_t wc, mbstate_t *ps)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p154835007084824"><a name="p154835007084824"></a><a name="p154835007084824"></a>size_t </p>
<p id="p2012399051084824"><a name="p2012399051084824"></a><a name="p2012399051084824"></a>Converts the wide character specified by <strong id="b210140421084824"><a name="b210140421084824"></a><a name="b210140421084824"></a>wc</strong> into a character string and stores the string to the beginning of the character array pointed to by <strong id="b1279876005084824"><a name="b1279876005084824"></a><a name="b1279876005084824"></a>s</strong>. </p>
</td>
</tr>
<tr id="row2027890035084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1311676546084824"><a name="p1311676546084824"></a><a name="p1311676546084824"></a><a href="utils.md#gab7c8a08e5174c1235b0e925dfc77b938">mbrlen</a> (const char *s, size_t n, mbstate_t *ps)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1013107307084824"><a name="p1013107307084824"></a><a name="p1013107307084824"></a>size_t </p>
<p id="p684348543084824"><a name="p684348543084824"></a><a name="p684348543084824"></a>Determines the number of bytes in a character string pointed to by <strong id="b1923405038084824"><a name="b1923405038084824"></a><a name="b1923405038084824"></a>s</strong>. </p>
</td>
</tr>
<tr id="row2036557933084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1768998060084824"><a name="p1768998060084824"></a><a name="p1768998060084824"></a><a href="utils.md#gac3ebddff1a73c20b17986a6b7b68fe56">mbsrtowcs</a> (wchar_t *dest, const char **src, size_t len, mbstate_t *ps)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1782978013084824"><a name="p1782978013084824"></a><a name="p1782978013084824"></a>size_t </p>
<p id="p473978560084824"><a name="p473978560084824"></a><a name="p473978560084824"></a>Converts a multi-byte character string with a length of <strong id="b1584001658084824"><a name="b1584001658084824"></a><a name="b1584001658084824"></a>len</strong> into a wide character string. </p>
</td>
</tr>
<tr id="row752817050084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p491672018084824"><a name="p491672018084824"></a><a name="p491672018084824"></a><a href="utils.md#ga0a628490d6458cfc836ebf3721e68a98">wcsrtombs</a> (char *dest, const wchar_t **src, size_t len, mbstate_t *ps)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1913019160084824"><a name="p1913019160084824"></a><a name="p1913019160084824"></a>size_t </p>
<p id="p60484572084824"><a name="p60484572084824"></a><a name="p60484572084824"></a>Converts a wide character string into a multi-byte string. </p>
</td>
</tr>
<tr id="row2031331558084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p628405500084824"><a name="p628405500084824"></a><a name="p628405500084824"></a><a href="utils.md#gadf99123a55665bf0669487a12aee795f">wcstof</a> (const wchar_t *str, wchar_t **endptr)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1540191573084824"><a name="p1540191573084824"></a><a name="p1540191573084824"></a>float </p>
<p id="p2045310588084824"><a name="p2045310588084824"></a><a name="p2045310588084824"></a>Converts a wide character string pointed to by <strong id="b186781760084824"><a name="b186781760084824"></a><a name="b186781760084824"></a>str</strong> into a floating-point value and assigns the next character in <strong id="b347073973084824"><a name="b347073973084824"></a><a name="b347073973084824"></a>str</strong> after the floating-point value to <strong id="b456303841084824"><a name="b456303841084824"></a><a name="b456303841084824"></a>endptr</strong>. </p>
</td>
</tr>
<tr id="row672833029084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p263239284084824"><a name="p263239284084824"></a><a name="p263239284084824"></a><a href="utils.md#ga2030f1f318ded574650a1957574711a0">wcstod</a> (const wchar_t *str, wchar_t **endptr)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p801090709084824"><a name="p801090709084824"></a><a name="p801090709084824"></a>double </p>
<p id="p1675938500084824"><a name="p1675938500084824"></a><a name="p1675938500084824"></a>Converts a wide character string pointed to by <strong id="b430591796084824"><a name="b430591796084824"></a><a name="b430591796084824"></a>str</strong> into a double value and assigns the next character in <strong id="b1882040016084824"><a name="b1882040016084824"></a><a name="b1882040016084824"></a>str</strong> after the double value to <strong id="b1142818930084824"><a name="b1142818930084824"></a><a name="b1142818930084824"></a>endptr</strong>. </p>
</td>
</tr>
<tr id="row785832918084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p39320995084824"><a name="p39320995084824"></a><a name="p39320995084824"></a><a href="utils.md#gaf1879aa0145431434cbac389629bee6a">wcstold</a> (const wchar_t *str, wchar_t **endptr)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1015049322084824"><a name="p1015049322084824"></a><a name="p1015049322084824"></a>long double </p>
<p id="p1211036413084824"><a name="p1211036413084824"></a><a name="p1211036413084824"></a>Converts a wide character string pointed to by <strong id="b2058370534084824"><a name="b2058370534084824"></a><a name="b2058370534084824"></a>str</strong> into a long double value and assigns the next character in <strong id="b919031653084824"><a name="b919031653084824"></a><a name="b919031653084824"></a>str</strong> after the long double value to <strong id="b1205564856084824"><a name="b1205564856084824"></a><a name="b1205564856084824"></a>endptr</strong>. </p>
</td>
</tr>
<tr id="row337034784084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p506665311084824"><a name="p506665311084824"></a><a name="p506665311084824"></a><a href="utils.md#ga623c775bac158351e308fd3811daeb9f">wcstol</a> (const wchar_t *str, wchar_t **endptr, int base)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p34828609084824"><a name="p34828609084824"></a><a name="p34828609084824"></a>long </p>
<p id="p1039094544084824"><a name="p1039094544084824"></a><a name="p1039094544084824"></a>Converts a wide character string pointed to by <strong id="b87914246084824"><a name="b87914246084824"></a><a name="b87914246084824"></a>str</strong> into a long value. </p>
</td>
</tr>
<tr id="row593194138084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1159578264084824"><a name="p1159578264084824"></a><a name="p1159578264084824"></a><a href="utils.md#ga71d821611320a733b3f51ff8077ce92c">wcstoul</a> (const wchar_t *str, wchar_t **endptr, int base)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p460964749084824"><a name="p460964749084824"></a><a name="p460964749084824"></a>unsigned long </p>
<p id="p972934442084824"><a name="p972934442084824"></a><a name="p972934442084824"></a>Converts a wide character string pointed to by <strong id="b1055359292084824"><a name="b1055359292084824"></a><a name="b1055359292084824"></a>str</strong> into an unsigned long value of a specified base. </p>
</td>
</tr>
<tr id="row108076936084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p953538143084824"><a name="p953538143084824"></a><a name="p953538143084824"></a><a href="utils.md#ga1f43fe48b9afd42fb80b0560c1358ad3">wcstoll</a> (const wchar_t *str, wchar_t **endptr, int base)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p342442227084824"><a name="p342442227084824"></a><a name="p342442227084824"></a>long long </p>
<p id="p1379225721084824"><a name="p1379225721084824"></a><a name="p1379225721084824"></a>Converts a wide character string pointed to by <strong id="b1764648597084824"><a name="b1764648597084824"></a><a name="b1764648597084824"></a>str</strong> into a long long value of a specified base. </p>
</td>
</tr>
<tr id="row1452074320084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1560552862084824"><a name="p1560552862084824"></a><a name="p1560552862084824"></a><a href="utils.md#gad28d6c39911a0d99ebaf2ee4e3b9f621">wcstoull</a> (const wchar_t *str, wchar_t **endptr, int base)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2130791147084824"><a name="p2130791147084824"></a><a name="p2130791147084824"></a>unsigned long long </p>
<p id="p722992408084824"><a name="p722992408084824"></a><a name="p722992408084824"></a>Converts a wide character string pointed to by <strong id="b78950097084824"><a name="b78950097084824"></a><a name="b78950097084824"></a>str</strong> into an unsigned long long value of a specified base. </p>
</td>
</tr>
<tr id="row751912235084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1663973795084824"><a name="p1663973795084824"></a><a name="p1663973795084824"></a><a href="utils.md#ga5438ce60b99b0455f356cd27726161ab">fwide</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream, int mode)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p649221205084824"><a name="p649221205084824"></a><a name="p649221205084824"></a>int </p>
<p id="p1879226034084824"><a name="p1879226034084824"></a><a name="p1879226034084824"></a>Sets and determines the orientation of the file stream. </p>
</td>
</tr>
<tr id="row2127890013084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p187107546084824"><a name="p187107546084824"></a><a name="p187107546084824"></a><a href="utils.md#gaf30b50dd88f13675d890857755670a2d">wprintf</a> (const wchar_t *format,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1375595127084824"><a name="p1375595127084824"></a><a name="p1375595127084824"></a>int </p>
<p id="p226630631084824"><a name="p226630631084824"></a><a name="p226630631084824"></a>Prints formatted data to the standard output (stdout). </p>
</td>
</tr>
<tr id="row803517543084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p296679470084824"><a name="p296679470084824"></a><a name="p296679470084824"></a><a href="utils.md#ga2b7ff2e4c9e4d1c0d6dc35bf93542d53">fwprintf</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *__restrict fp, const wchar_t *__restrict fmt,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2068503123084824"><a name="p2068503123084824"></a><a name="p2068503123084824"></a>int </p>
<p id="p1178018971084824"><a name="p1178018971084824"></a><a name="p1178018971084824"></a>Prints wide character strings to a specified file stream. </p>
</td>
</tr>
<tr id="row787254345084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1333565178084824"><a name="p1333565178084824"></a><a name="p1333565178084824"></a><a href="utils.md#ga7c963d10722b32fbcf5508057ccf76ec">swprintf</a> (wchar_t *wcs, size_t maxlen, const wchar_t *format,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1004237540084824"><a name="p1004237540084824"></a><a name="p1004237540084824"></a>int </p>
<p id="p1935151925084824"><a name="p1935151925084824"></a><a name="p1935151925084824"></a>Prints formatted data to a specified string. </p>
</td>
</tr>
<tr id="row1940502498084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1005415882084824"><a name="p1005415882084824"></a><a name="p1005415882084824"></a><a href="utils.md#gadff14929a4410b3ac0ce28b55357e280">vwprintf</a> (const wchar_t *format, va_list args)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1672622825084824"><a name="p1672622825084824"></a><a name="p1672622825084824"></a>int </p>
<p id="p2077439984084824"><a name="p2077439984084824"></a><a name="p2077439984084824"></a>Prints formatted data from a variable argument list to the standard output (stdout). </p>
</td>
</tr>
<tr id="row1593853741084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1896069658084824"><a name="p1896069658084824"></a><a name="p1896069658084824"></a><a href="utils.md#ga52697c5b86b8a3fa892b69f70fac8843">vfwprintf</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream, const wchar_t *format, __isoc_va_list args)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1098327937084824"><a name="p1098327937084824"></a><a name="p1098327937084824"></a>int </p>
<p id="p2015043957084824"><a name="p2015043957084824"></a><a name="p2015043957084824"></a>Prints formatted data from a variable argument list specified by <strong id="b1802901668084824"><a name="b1802901668084824"></a><a name="b1802901668084824"></a>args</strong> to a specified file stream. </p>
</td>
</tr>
<tr id="row1983640128084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1663130032084824"><a name="p1663130032084824"></a><a name="p1663130032084824"></a><a href="utils.md#gad79402226fa58569bee4601eb029b717">vswprintf</a> (wchar_t *wcs, size_t maxlen, const wchar_t *format, __isoc_va_list args)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p184417436084824"><a name="p184417436084824"></a><a name="p184417436084824"></a>int </p>
<p id="p1458613883084824"><a name="p1458613883084824"></a><a name="p1458613883084824"></a>Prints formatted data from a variable argument list specified by <strong id="b2026647056084824"><a name="b2026647056084824"></a><a name="b2026647056084824"></a>args</strong> to a specified string. </p>
</td>
</tr>
<tr id="row1616349199084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p110214013084824"><a name="p110214013084824"></a><a name="p110214013084824"></a><a href="utils.md#ga24e265f34e058454b9a9b6247b1694b0">wscanf</a> (const wchar_t *format,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p863389379084824"><a name="p863389379084824"></a><a name="p863389379084824"></a>int </p>
<p id="p241160697084824"><a name="p241160697084824"></a><a name="p241160697084824"></a>Reads formatted data from the standard input (stdin) and stores it based on the wide string format into the locations pointed to by the variable arguments. </p>
</td>
</tr>
<tr id="row383584053084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p764097714084824"><a name="p764097714084824"></a><a name="p764097714084824"></a><a href="utils.md#ga1e39ec126230aed6ffa3e922be38a014">fwscanf</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream, const wchar_t *format,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1582868869084824"><a name="p1582868869084824"></a><a name="p1582868869084824"></a>int </p>
<p id="p1396564580084824"><a name="p1396564580084824"></a><a name="p1396564580084824"></a>Reads formatted data from a specified stream and stores it based on the wide string format into the locations pointed to by the variable arguments. </p>
</td>
</tr>
<tr id="row935856268084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1451314721084824"><a name="p1451314721084824"></a><a name="p1451314721084824"></a><a href="utils.md#gaac90953229a0d08ce45ba328430d6637">swscanf</a> (const wchar_t *ws, const wchar_t *format,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1852222520084824"><a name="p1852222520084824"></a><a name="p1852222520084824"></a>int </p>
<p id="p1312770642084824"><a name="p1312770642084824"></a><a name="p1312770642084824"></a>Reads data from a wide character string pointed to by <strong id="b1356162948084824"><a name="b1356162948084824"></a><a name="b1356162948084824"></a>ws</strong> and stores it based on the wide string format into the locations pointed to by the variable arguments. </p>
</td>
</tr>
<tr id="row1490200128084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1863571160084824"><a name="p1863571160084824"></a><a name="p1863571160084824"></a><a href="utils.md#ga4406b91b463b1fc3d4d43b44ccb46d1c">vwscanf</a> (const wchar_t *format, va_list arg)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p59893599084824"><a name="p59893599084824"></a><a name="p59893599084824"></a>int </p>
<p id="p1553785883084824"><a name="p1553785883084824"></a><a name="p1553785883084824"></a>Reads data from the stdin and stores it based on the wide string format into the locations pointed to by the elements in the variable argument list identified by <strong id="b975117423084824"><a name="b975117423084824"></a><a name="b975117423084824"></a>arg</strong>. </p>
</td>
</tr>
<tr id="row22129145084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1592123842084824"><a name="p1592123842084824"></a><a name="p1592123842084824"></a><a href="utils.md#ga0d7996cc31075571432fcc7a21c402fa">vfwscanf</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream, const wchar_t *format, va_list arg)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1029288286084824"><a name="p1029288286084824"></a><a name="p1029288286084824"></a>int </p>
<p id="p227000131084824"><a name="p227000131084824"></a><a name="p227000131084824"></a>Reads data from a specified file stream and stores it based on the wide string format into the locations pointed to by the elements in the variable argument list identified by <strong id="b1059268491084824"><a name="b1059268491084824"></a><a name="b1059268491084824"></a>arg</strong>. </p>
</td>
</tr>
<tr id="row1141416503084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1015981735084824"><a name="p1015981735084824"></a><a name="p1015981735084824"></a><a href="utils.md#ga0b70af0bd7f82c6f81886d79ad41b2c1">vswscanf</a> (const wchar_t *ws, const wchar_t *format, va_list arg)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2063794233084824"><a name="p2063794233084824"></a><a name="p2063794233084824"></a>int </p>
<p id="p1793868911084824"><a name="p1793868911084824"></a><a name="p1793868911084824"></a>Reads data from a string pointed to by <strong id="b1658919251084824"><a name="b1658919251084824"></a><a name="b1658919251084824"></a>ws</strong> and stores it based on the wide string format into the locations pointed to by the elements in the variable argument list identified by <strong id="b665017469084824"><a name="b665017469084824"></a><a name="b665017469084824"></a>arg</strong>. </p>
</td>
</tr>
<tr id="row2057313269084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p494383842084824"><a name="p494383842084824"></a><a name="p494383842084824"></a><a href="utils.md#ga2b545d8d6d3209a2eb6129d8ba646fe3">fgetwc</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p160839311084824"><a name="p160839311084824"></a><a name="p160839311084824"></a>wint_t </p>
<p id="p1440913500084824"><a name="p1440913500084824"></a><a name="p1440913500084824"></a>Reads a wide character from a specified file stream. </p>
</td>
</tr>
<tr id="row737450375084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p355269081084824"><a name="p355269081084824"></a><a name="p355269081084824"></a><a href="utils.md#gaadd2028a176fe13a0d6090cec651a369">getwc</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1914150974084824"><a name="p1914150974084824"></a><a name="p1914150974084824"></a>wint_t </p>
<p id="p1740106954084824"><a name="p1740106954084824"></a><a name="p1740106954084824"></a>Reads the first wide character from a specified file stream. </p>
</td>
</tr>
<tr id="row1522977086084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p119093690084824"><a name="p119093690084824"></a><a name="p119093690084824"></a><a href="utils.md#gaa1379ae6936df3415301dc580aa8756e">getwchar</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2042904622084824"><a name="p2042904622084824"></a><a name="p2042904622084824"></a>wint_t </p>
<p id="p45738997084824"><a name="p45738997084824"></a><a name="p45738997084824"></a>Reads a wide character from the stdin. </p>
</td>
</tr>
<tr id="row615482273084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p13558923084824"><a name="p13558923084824"></a><a name="p13558923084824"></a><a href="utils.md#gab405f6ad88ebd1c6150206d19d3c7f12">fputwc</a> (wchar_t wc, <a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p676635051084824"><a name="p676635051084824"></a><a name="p676635051084824"></a>wint_t </p>
<p id="p1427739344084824"><a name="p1427739344084824"></a><a name="p1427739344084824"></a>Writes a wide character <strong id="b857159936084824"><a name="b857159936084824"></a><a name="b857159936084824"></a>wc</strong> to a specified file stream. </p>
</td>
</tr>
<tr id="row1149270234084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p768481320084824"><a name="p768481320084824"></a><a name="p768481320084824"></a><a href="utils.md#ga578ce42fa0cf04469cff45134114b701">putwc</a> (wchar_t wc, <a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p479284304084824"><a name="p479284304084824"></a><a name="p479284304084824"></a>wint_t </p>
<p id="p1865903835084824"><a name="p1865903835084824"></a><a name="p1865903835084824"></a>Writes a wide character <strong id="b37024326084824"><a name="b37024326084824"></a><a name="b37024326084824"></a>wc</strong> to a specified file stream. </p>
</td>
</tr>
<tr id="row76288051084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p736335813084824"><a name="p736335813084824"></a><a name="p736335813084824"></a><a href="utils.md#ga34ef116bac70390d5a2ff8c5fdb45777">putwchar</a> (wchar_t wc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p215188612084824"><a name="p215188612084824"></a><a name="p215188612084824"></a>wint_t </p>
<p id="p1974699724084824"><a name="p1974699724084824"></a><a name="p1974699724084824"></a>Writes a wide character <strong id="b189504335084824"><a name="b189504335084824"></a><a name="b189504335084824"></a>wc</strong> to the stdout. </p>
</td>
</tr>
<tr id="row1870888706084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1947978652084824"><a name="p1947978652084824"></a><a name="p1947978652084824"></a><a href="utils.md#ga6f98d7f5d5d1e6ad282ee1a348eab753">fgetws</a> (wchar_t *ws, int n, <a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p830023798084824"><a name="p830023798084824"></a><a name="p830023798084824"></a>wchar_t * </p>
<p id="p703823221084824"><a name="p703823221084824"></a><a name="p703823221084824"></a>Reads wide characters from a specified file stream. </p>
</td>
</tr>
<tr id="row751384363084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p191411285084824"><a name="p191411285084824"></a><a name="p191411285084824"></a><a href="utils.md#gad3afb048298b1f152181fcac8e20d6e3">fputws</a> (const wchar_t *ws, <a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p657301818084824"><a name="p657301818084824"></a><a name="p657301818084824"></a>int </p>
<p id="p1433334476084824"><a name="p1433334476084824"></a><a name="p1433334476084824"></a>Writes a wide string pointed to by <strong id="b724580362084824"><a name="b724580362084824"></a><a name="b724580362084824"></a>ws</strong> to a specified file stream. </p>
</td>
</tr>
<tr id="row390344128084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1402307104084824"><a name="p1402307104084824"></a><a name="p1402307104084824"></a><a href="utils.md#ga35264055ce08ba6d23ba03075897a0fb">ungetwc</a> (wint_t ch, <a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1009327003084824"><a name="p1009327003084824"></a><a name="p1009327003084824"></a>wint_t </p>
<p id="p1683472112084824"><a name="p1683472112084824"></a><a name="p1683472112084824"></a>Pushes a character back into a specified file stream. </p>
</td>
</tr>
<tr id="row1618734923084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1940893595084824"><a name="p1940893595084824"></a><a name="p1940893595084824"></a><a href="utils.md#ga6fd639ff3ac22621951452b380468327">mbrtowc</a> (wchar_t *pwc, const char *s, size_t n, mbstate_t *ps)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2004901787084824"><a name="p2004901787084824"></a><a name="p2004901787084824"></a>size_t </p>
<p id="p29605267084824"><a name="p29605267084824"></a><a name="p29605267084824"></a>Converts a multi-byte character string with a length of <strong id="b1202879199084824"><a name="b1202879199084824"></a><a name="b1202879199084824"></a>n</strong> into a wide character string. </p>
</td>
</tr>
<tr id="row1574398165084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1277551145084824"><a name="p1277551145084824"></a><a name="p1277551145084824"></a><a href="utils.md#ga08f9c737e4060d9e123e0fc28a1eb2f3">mbsnrtowcs</a> (wchar_t *dest, const char **src, size_t nwc, size_t len, mbstate_t *ps)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1662673190084824"><a name="p1662673190084824"></a><a name="p1662673190084824"></a>size_t </p>
<p id="p213655188084824"><a name="p213655188084824"></a><a name="p213655188084824"></a>Converts a multi-byte character string with a length of <strong id="b249483538084824"><a name="b249483538084824"></a><a name="b249483538084824"></a>n</strong> into a wide character string that can hold a total of <strong id="b796629596084824"><a name="b796629596084824"></a><a name="b796629596084824"></a>nwc</strong> wide characters. </p>
</td>
</tr>
<tr id="row479883076084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p338245729084824"><a name="p338245729084824"></a><a name="p338245729084824"></a><a href="utils.md#gaf189ea21a3aa444f88607ad23f448f37">wcsnrtombs</a> (char *dest, const wchar_t **src, size_t nwc, size_t len, mbstate_t *ps)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1074380913084824"><a name="p1074380913084824"></a><a name="p1074380913084824"></a>size_t </p>
<p id="p39545023084824"><a name="p39545023084824"></a><a name="p39545023084824"></a>Converts <strong id="b1798857064084824"><a name="b1798857064084824"></a><a name="b1798857064084824"></a>nwc</strong> wide characters in the string pointed to by <strong id="b701801101084824"><a name="b701801101084824"></a><a name="b701801101084824"></a>src</strong> into a character string. </p>
</td>
</tr>
<tr id="row1684555032084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p339245933084824"><a name="p339245933084824"></a><a name="p339245933084824"></a><a href="utils.md#ga21234261a334fd22ff3d6ba8883eca3a">wcsdup</a> (const wchar_t *s)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1905930605084824"><a name="p1905930605084824"></a><a name="p1905930605084824"></a>wchar_t * </p>
<p id="p1007800785084824"><a name="p1007800785084824"></a><a name="p1007800785084824"></a>Copies a specified wide character string to a newly allocated buffer. </p>
</td>
</tr>
<tr id="row600566238084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p712577289084824"><a name="p712577289084824"></a><a name="p712577289084824"></a><a href="utils.md#ga5ef7fc85c7678f86f1530fd52dbf2486">wcsnlen</a> (const wchar_t *s, size_t maxlen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1875479798084824"><a name="p1875479798084824"></a><a name="p1875479798084824"></a>size_t </p>
<p id="p640307821084824"><a name="p640307821084824"></a><a name="p640307821084824"></a>Calculates the length of a wide character string pointed to by <strong id="b808688758084824"><a name="b808688758084824"></a><a name="b808688758084824"></a>s</strong>. </p>
</td>
</tr>
<tr id="row1041791557084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1208810207084824"><a name="p1208810207084824"></a><a name="p1208810207084824"></a><a href="utils.md#gaa4f33e46d5c0263f0b3e9a1e8eb0a7a9">wcpcpy</a> (wchar_t *dest, const wchar_t *src)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1972644581084824"><a name="p1972644581084824"></a><a name="p1972644581084824"></a>wchar_t * </p>
<p id="p665885365084824"><a name="p665885365084824"></a><a name="p665885365084824"></a>Copies the wide characters (including the terminating null character <strong id="b2051331801084824"><a name="b2051331801084824"></a><a name="b2051331801084824"></a>'\0'</strong>) pointed to by <strong id="b1165284351084824"><a name="b1165284351084824"></a><a name="b1165284351084824"></a>src</strong> to the wide character array pointed to by <strong id="b140620360084824"><a name="b140620360084824"></a><a name="b140620360084824"></a>dest</strong>. </p>
</td>
</tr>
<tr id="row363837909084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p806141618084824"><a name="p806141618084824"></a><a name="p806141618084824"></a><a href="utils.md#ga2b77c48e45c06857bae5c4720fd977b9">wcpncpy</a> (wchar_t *dest, const wchar_t *src, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p467534771084824"><a name="p467534771084824"></a><a name="p467534771084824"></a>wchar_t * </p>
<p id="p1369996362084824"><a name="p1369996362084824"></a><a name="p1369996362084824"></a>Copies <strong id="b810217143084824"><a name="b810217143084824"></a><a name="b810217143084824"></a>n</strong> wide characters (including the terminating null character <strong id="b2065679782084824"><a name="b2065679782084824"></a><a name="b2065679782084824"></a>'\0'</strong>) pointed to by <strong id="b1297792265084824"><a name="b1297792265084824"></a><a name="b1297792265084824"></a>src</strong> to the wide character array pointed to by <strong id="b640636918084824"><a name="b640636918084824"></a><a name="b640636918084824"></a>dest</strong>. </p>
</td>
</tr>
<tr id="row1635835403084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p737766688084824"><a name="p737766688084824"></a><a name="p737766688084824"></a><a href="utils.md#ga1cfd283a315ce1081565d9370dadbd1e">wcscasecmp</a> (const wchar_t *s1, const wchar_t *s2)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1564309629084824"><a name="p1564309629084824"></a><a name="p1564309629084824"></a>int </p>
<p id="p1841798455084824"><a name="p1841798455084824"></a><a name="p1841798455084824"></a>Compares the wide characters in the string pointed to by <strong id="b1089180546084824"><a name="b1089180546084824"></a><a name="b1089180546084824"></a>s1</strong> with those in the string pointed to by <strong id="b1411473032084824"><a name="b1411473032084824"></a><a name="b1411473032084824"></a>s2</strong>, with their case differences ignored. </p>
</td>
</tr>
<tr id="row1638424927084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p586458077084824"><a name="p586458077084824"></a><a name="p586458077084824"></a><a href="utils.md#gad5fd70aa458e05eaec03bb88d5eefdef">wcscasecmp_l</a> (const wchar_t *s1, const wchar_t *s2, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p663029401084824"><a name="p663029401084824"></a><a name="p663029401084824"></a>int </p>
<p id="p861432225084824"><a name="p861432225084824"></a><a name="p861432225084824"></a>Compares the wide characters in the string pointed to by <strong id="b161951732084824"><a name="b161951732084824"></a><a name="b161951732084824"></a>s1</strong> with those in the string pointed to by <strong id="b178588216084824"><a name="b178588216084824"></a><a name="b178588216084824"></a>s2</strong> based on the specified <strong id="b1633897359084824"><a name="b1633897359084824"></a><a name="b1633897359084824"></a>locale</strong> environment, with their case differences ignored. </p>
</td>
</tr>
<tr id="row1587779880084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1307579484084824"><a name="p1307579484084824"></a><a name="p1307579484084824"></a><a href="utils.md#ga5c9957285778ae41af839bb22cc4a9d0">wcsncasecmp</a> (const wchar_t *s1, const wchar_t *s2, size_t n)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1446579722084824"><a name="p1446579722084824"></a><a name="p1446579722084824"></a>int </p>
<p id="p793476740084824"><a name="p793476740084824"></a><a name="p793476740084824"></a>Compares a maximum of <strong id="b615852773084824"><a name="b615852773084824"></a><a name="b615852773084824"></a>n</strong> wide characters in the string pointed to by <strong id="b813943889084824"><a name="b813943889084824"></a><a name="b813943889084824"></a>s1</strong> with those in the string pointed to by <strong id="b376272847084824"><a name="b376272847084824"></a><a name="b376272847084824"></a>s2</strong>, with their case differences ignored. </p>
</td>
</tr>
<tr id="row331492379084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1080079633084824"><a name="p1080079633084824"></a><a name="p1080079633084824"></a><a href="utils.md#ga157e21d5005c4af440f8fe0407dab8ec">wcsncasecmp_l</a> (const wchar_t *s1, const wchar_t *s2, size_t n, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p607231052084824"><a name="p607231052084824"></a><a name="p607231052084824"></a>int </p>
<p id="p692798893084824"><a name="p692798893084824"></a><a name="p692798893084824"></a>Compares a maximum of <strong id="b1399390942084824"><a name="b1399390942084824"></a><a name="b1399390942084824"></a>n</strong> wide characters in the string pointed to by <strong id="b1528604315084824"><a name="b1528604315084824"></a><a name="b1528604315084824"></a>s1</strong> with those in the string pointed to by <strong id="b430604749084824"><a name="b430604749084824"></a><a name="b430604749084824"></a>s2</strong> based on the specified <strong id="b1996905826084824"><a name="b1996905826084824"></a><a name="b1996905826084824"></a>locale</strong> environment, with their case differences ignored. </p>
</td>
</tr>
<tr id="row1144741452084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1129038430084824"><a name="p1129038430084824"></a><a name="p1129038430084824"></a><a href="utils.md#ga8bdd5a976685e97d9ac7f45f7951a52c">wcscoll_l</a> (const wchar_t *s1, const wchar_t *s2, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1997728561084824"><a name="p1997728561084824"></a><a name="p1997728561084824"></a>int </p>
<p id="p985864014084824"><a name="p985864014084824"></a><a name="p985864014084824"></a>Compares wide characters in the string pointed to by <strong id="b1261691108084824"><a name="b1261691108084824"></a><a name="b1261691108084824"></a>s1</strong> with those in the string pointed to by <strong id="b393674259084824"><a name="b393674259084824"></a><a name="b393674259084824"></a>s2</strong> based on the specified <strong id="b966662903084824"><a name="b966662903084824"></a><a name="b966662903084824"></a>locale</strong> environment. </p>
</td>
</tr>
<tr id="row1240822038084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1593746359084824"><a name="p1593746359084824"></a><a name="p1593746359084824"></a><a href="utils.md#ga215d4539e43613e57c992b87158084b4">wcsftime</a> (wchar_t *__restrict wcs, size_t n, const wchar_t *__restrict f, const struct <a href="tm.md">tm</a> *__restrict <a href="tm.md">tm</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1794449298084824"><a name="p1794449298084824"></a><a name="p1794449298084824"></a>size_t </p>
<p id="p801011972084824"><a name="p801011972084824"></a><a name="p801011972084824"></a>Converts the date and time in the <strong id="b280613296084824"><a name="b280613296084824"></a><a name="b280613296084824"></a>tm</strong> structure to a wide character string. </p>
</td>
</tr>
<tr id="row990279303084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1315011600084824"><a name="p1315011600084824"></a><a name="p1315011600084824"></a><a href="utils.md#gadd93407a6dc241056ae5198b356f07d4">wcsxfrm_l</a> (wchar_t *s1, const wchar_t *s2, size_t n, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2051433813084824"><a name="p2051433813084824"></a><a name="p2051433813084824"></a>size_t </p>
<p id="p820269343084824"><a name="p820269343084824"></a><a name="p820269343084824"></a>Compares the first <strong id="b1346839429084824"><a name="b1346839429084824"></a><a name="b1346839429084824"></a>n</strong> wide characters in the string pointed to by <strong id="b1627452086084824"><a name="b1627452086084824"></a><a name="b1627452086084824"></a>s1</strong> with those in the string pointed to by <strong id="b1820059148084824"><a name="b1820059148084824"></a><a name="b1820059148084824"></a>s2</strong> based on the specified <strong id="b1218269675084824"><a name="b1218269675084824"></a><a name="b1218269675084824"></a>locale</strong> environment. </p>
</td>
</tr>
<tr id="row456343476084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1847262071084824"><a name="p1847262071084824"></a><a name="p1847262071084824"></a><a href="utils.md#gadafb512a79ac9274486d6ddbbbd9d9ba">iswalnum</a> (wint_t wc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1133090911084824"><a name="p1133090911084824"></a><a name="p1133090911084824"></a>int </p>
<p id="p930913172084824"><a name="p930913172084824"></a><a name="p930913172084824"></a>Checks whether a wide character is a letter or digit. </p>
</td>
</tr>
<tr id="row2089980809084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p221216578084824"><a name="p221216578084824"></a><a name="p221216578084824"></a><a href="utils.md#ga72477b4f142de340164deb7bf5a7ae7b">iswalpha</a> (wint_t wc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1830499566084824"><a name="p1830499566084824"></a><a name="p1830499566084824"></a>int </p>
<p id="p933861702084824"><a name="p933861702084824"></a><a name="p933861702084824"></a>Checks whether a wide character is a letter. </p>
</td>
</tr>
<tr id="row1828895242084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1827559908084824"><a name="p1827559908084824"></a><a name="p1827559908084824"></a><a href="utils.md#ga934cbdaad02f3df1b03e566103a5a118">iswblank</a> (wint_t wc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1605099128084824"><a name="p1605099128084824"></a><a name="p1605099128084824"></a>int </p>
<p id="p773438578084824"><a name="p773438578084824"></a><a name="p773438578084824"></a>Checks whether a wide character is a space or tab character (\t). </p>
</td>
</tr>
<tr id="row1849001342084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2110182784084824"><a name="p2110182784084824"></a><a name="p2110182784084824"></a><a href="utils.md#ga35f4bb15841d36c759ab271aa8033ba8">iswcntrl</a> (wint_t wc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1244436403084824"><a name="p1244436403084824"></a><a name="p1244436403084824"></a>int </p>
<p id="p1664596691084824"><a name="p1664596691084824"></a><a name="p1664596691084824"></a>Checks whether a wide character is a control character. </p>
</td>
</tr>
<tr id="row1387511219084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p980538018084824"><a name="p980538018084824"></a><a name="p980538018084824"></a><a href="utils.md#ga972fbaff0c1d4b4e612c789b8532e9af">iswdigit</a> (wint_t wc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1224495752084824"><a name="p1224495752084824"></a><a name="p1224495752084824"></a>int </p>
<p id="p2147464785084824"><a name="p2147464785084824"></a><a name="p2147464785084824"></a>Checks whether a wide character is a decimal digit. </p>
</td>
</tr>
<tr id="row322373420084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1657036767084824"><a name="p1657036767084824"></a><a name="p1657036767084824"></a><a href="utils.md#ga27b090b588b25bacca79bd11926ce308">iswgraph</a> (wint_t wc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1826837809084824"><a name="p1826837809084824"></a><a name="p1826837809084824"></a>int </p>
<p id="p1757095227084824"><a name="p1757095227084824"></a><a name="p1757095227084824"></a>Checks whether a wide character is visible. </p>
</td>
</tr>
<tr id="row1079709712084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1426847456084824"><a name="p1426847456084824"></a><a name="p1426847456084824"></a><a href="utils.md#ga92c2a9aad2bf7e6c56a7c01597f59649">iswlower</a> (wint_t wc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1315467109084824"><a name="p1315467109084824"></a><a name="p1315467109084824"></a>int </p>
<p id="p1187452116084824"><a name="p1187452116084824"></a><a name="p1187452116084824"></a>Checks whether a wide character is a lowercase letter. </p>
</td>
</tr>
<tr id="row1515867514084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p620015643084824"><a name="p620015643084824"></a><a name="p620015643084824"></a><a href="utils.md#ga3eef94f4b2065e786f96e231e871d521">iswprint</a> (wint_t wc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1529249307084824"><a name="p1529249307084824"></a><a name="p1529249307084824"></a>int </p>
<p id="p10120908084824"><a name="p10120908084824"></a><a name="p10120908084824"></a>Checks whether a wide character is printable. </p>
</td>
</tr>
<tr id="row1604224388084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1015728445084824"><a name="p1015728445084824"></a><a name="p1015728445084824"></a><a href="utils.md#gacf0bab8aa20334835ea1b55f715ddd64">iswpunct</a> (wint_t wc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p604477783084824"><a name="p604477783084824"></a><a name="p604477783084824"></a>int </p>
<p id="p2111926427084824"><a name="p2111926427084824"></a><a name="p2111926427084824"></a>Checks whether a wide character is a punctuation mark. </p>
</td>
</tr>
<tr id="row1427124781084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p155752701084824"><a name="p155752701084824"></a><a name="p155752701084824"></a><a href="utils.md#gaf9d04695802b960ca3765c72d73ddb7c">iswupper</a> (wint_t wc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p834420211084824"><a name="p834420211084824"></a><a name="p834420211084824"></a>int </p>
<p id="p1865497114084824"><a name="p1865497114084824"></a><a name="p1865497114084824"></a>Checks whether a wide character is an uppercase letter. </p>
</td>
</tr>
<tr id="row646665848084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1368454479084824"><a name="p1368454479084824"></a><a name="p1368454479084824"></a><a href="utils.md#ga4f1c74cab8bd862ddac6ad81a4e23f72">iswxdigit</a> (wint_t wc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1145541570084824"><a name="p1145541570084824"></a><a name="p1145541570084824"></a>int </p>
<p id="p575199190084824"><a name="p575199190084824"></a><a name="p575199190084824"></a>Checks whether a wide character is a hexadecimal digit. </p>
</td>
</tr>
<tr id="row1383540062084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p556892454084824"><a name="p556892454084824"></a><a name="p556892454084824"></a><a href="utils.md#gae7bade1da794a7950ad25da75e43ad39">iswctype</a> (wint_t wc, wctype_t desc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2111498112084824"><a name="p2111498112084824"></a><a name="p2111498112084824"></a>int </p>
<p id="p1602613911084824"><a name="p1602613911084824"></a><a name="p1602613911084824"></a>Checks whether the character specified by <strong id="b1463799640084824"><a name="b1463799640084824"></a><a name="b1463799640084824"></a>wc</strong> belongs to the <strong id="b346170418084824"><a name="b346170418084824"></a><a name="b346170418084824"></a>desc</strong> class. </p>
</td>
</tr>
<tr id="row1200365583084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p216914476084824"><a name="p216914476084824"></a><a name="p216914476084824"></a><a href="utils.md#gac1d7671abe2a106b481d5bb24717fd11">towctrans</a> (wint_t wc, <a href="utils.md#ga10b40cc6ecda73a91162017d2df251a3">wctrans_t</a> desc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1891648685084824"><a name="p1891648685084824"></a><a name="p1891648685084824"></a>wint_t </p>
<p id="p354064288084824"><a name="p354064288084824"></a><a name="p354064288084824"></a>Translates the type of a wide character based on the conversion mapping relationship. </p>
</td>
</tr>
<tr id="row1350396562084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p470089476084824"><a name="p470089476084824"></a><a name="p470089476084824"></a><a href="utils.md#gab9cd9fba7f8437d2ad5242baa25fd176">towlower</a> (wint_t wc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1349819801084824"><a name="p1349819801084824"></a><a name="p1349819801084824"></a>wint_t </p>
<p id="p1885099612084824"><a name="p1885099612084824"></a><a name="p1885099612084824"></a>Converts an uppercase wide character to lowercase. </p>
</td>
</tr>
<tr id="row2073585240084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1170594146084824"><a name="p1170594146084824"></a><a name="p1170594146084824"></a><a href="utils.md#gaaf8d2b2d230df873695d41757d5889f9">towupper</a> (wint_t wc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p147008235084824"><a name="p147008235084824"></a><a name="p147008235084824"></a>wint_t </p>
<p id="p1538699209084824"><a name="p1538699209084824"></a><a name="p1538699209084824"></a>Converts a lowercase wide character to uppercase. </p>
</td>
</tr>
<tr id="row1528867095084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p489202497084824"><a name="p489202497084824"></a><a name="p489202497084824"></a><a href="utils.md#ga98df6598dc60588b24067b97225070ed">wctrans</a> (const char *name)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1481125550084824"><a name="p1481125550084824"></a><a name="p1481125550084824"></a><a href="utils.md#ga10b40cc6ecda73a91162017d2df251a3">wctrans_t</a> </p>
<p id="p72971258084824"><a name="p72971258084824"></a><a name="p72971258084824"></a>Determines a mapping which can map a wide character to another wide character. </p>
</td>
</tr>
<tr id="row1748097141084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1387132928084824"><a name="p1387132928084824"></a><a name="p1387132928084824"></a><a href="utils.md#gae8a9ddd29c6a369345a12c6cb93aabe1">wctype</a> (const char *name)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1140781647084824"><a name="p1140781647084824"></a><a name="p1140781647084824"></a>wctype_t </p>
<p id="p801960229084824"><a name="p801960229084824"></a><a name="p801960229084824"></a>Checks whether a wide character type exists in the <a href="io.md#ga07c66689961056725d7f50231d740ba9">LC_CTYPE</a> locale. </p>
</td>
</tr>
<tr id="row406526601084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1514421539084824"><a name="p1514421539084824"></a><a name="p1514421539084824"></a><a href="utils.md#ga8d6ca21d11b21620ff32e32ebc5b251a">iswalnum_l</a> (wint_t wc, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1053261595084824"><a name="p1053261595084824"></a><a name="p1053261595084824"></a>int </p>
<p id="p1870630822084824"><a name="p1870630822084824"></a><a name="p1870630822084824"></a>Checks whether a wide character is a letter or digit for the specified locale. </p>
</td>
</tr>
<tr id="row836016538084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p141410879084824"><a name="p141410879084824"></a><a name="p141410879084824"></a><a href="utils.md#gadfbb99771f4af02201ef68fc2377164b">iswalpha_l</a> (wint_t wc, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1569821622084824"><a name="p1569821622084824"></a><a name="p1569821622084824"></a>int </p>
<p id="p338971257084824"><a name="p338971257084824"></a><a name="p338971257084824"></a>Checks whether a wide character is alphabetic for the specified locale. </p>
</td>
</tr>
<tr id="row1566165632084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p189874913084824"><a name="p189874913084824"></a><a name="p189874913084824"></a><a href="utils.md#ga7d5300cc6bbc4ba910a3f9b4d9da2f4d">iswblank_l</a> (wint_t wc, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2070875343084824"><a name="p2070875343084824"></a><a name="p2070875343084824"></a>int </p>
<p id="p739826952084824"><a name="p739826952084824"></a><a name="p739826952084824"></a>Checks whether a wide character is a blank or <strong id="b1439021222084824"><a name="b1439021222084824"></a><a name="b1439021222084824"></a>\t</strong> character for the specified locale. </p>
</td>
</tr>
<tr id="row110507613084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p382893396084824"><a name="p382893396084824"></a><a name="p382893396084824"></a><a href="utils.md#ga51c189ba9f96d6ed8207da1da81100ca">iswcntrl_l</a> (wint_t wc, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p389305060084824"><a name="p389305060084824"></a><a name="p389305060084824"></a>int </p>
<p id="p498481454084824"><a name="p498481454084824"></a><a name="p498481454084824"></a>Checks whether a wide character is a control character for the specified locale. </p>
</td>
</tr>
<tr id="row157648736084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1754109535084824"><a name="p1754109535084824"></a><a name="p1754109535084824"></a><a href="utils.md#gab84fd3a86d300fc49af9d708431566a9">iswdigit_l</a> (wint_t wc, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p195709351084824"><a name="p195709351084824"></a><a name="p195709351084824"></a>int </p>
<p id="p1800914693084824"><a name="p1800914693084824"></a><a name="p1800914693084824"></a>Checks whether a wide character is a decimal digit for the specified locale. </p>
</td>
</tr>
<tr id="row573615203084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p375810904084824"><a name="p375810904084824"></a><a name="p375810904084824"></a><a href="utils.md#gad7529291433b9e8f5e68caada7572244">iswgraph_l</a> (wint_t wc, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1142098943084824"><a name="p1142098943084824"></a><a name="p1142098943084824"></a>int </p>
<p id="p1393706236084824"><a name="p1393706236084824"></a><a name="p1393706236084824"></a>Checks whether a wide character is visible for the specified locale. </p>
</td>
</tr>
<tr id="row265378334084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2096766884084824"><a name="p2096766884084824"></a><a name="p2096766884084824"></a><a href="utils.md#ga944498fac122e95a2da80137e7fffcb4">iswlower_l</a> (wint_t wc, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p4809811084824"><a name="p4809811084824"></a><a name="p4809811084824"></a>int </p>
<p id="p552346752084824"><a name="p552346752084824"></a><a name="p552346752084824"></a>Checks whether a wide character is in lowercase for the specified locale. </p>
</td>
</tr>
<tr id="row1580280601084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1161964739084824"><a name="p1161964739084824"></a><a name="p1161964739084824"></a><a href="utils.md#gacd7a8387b98672ae64f222072eefd38e">iswprint_l</a> (wint_t wc, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p117481081084824"><a name="p117481081084824"></a><a name="p117481081084824"></a>int </p>
<p id="p1846803956084824"><a name="p1846803956084824"></a><a name="p1846803956084824"></a>Checks whether a wide character is printable for the specified locale. </p>
</td>
</tr>
<tr id="row1895290667084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p26122779084824"><a name="p26122779084824"></a><a name="p26122779084824"></a><a href="utils.md#gad355af93606bf5c7688518d78a7c017c">iswpunct_l</a> (wint_t wc, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1193337773084824"><a name="p1193337773084824"></a><a name="p1193337773084824"></a>int </p>
<p id="p317324881084824"><a name="p317324881084824"></a><a name="p317324881084824"></a>Checks whether <strong id="b1052072023084824"><a name="b1052072023084824"></a><a name="b1052072023084824"></a>wc</strong> is a punctuation wide character for the specified locale. </p>
</td>
</tr>
<tr id="row515132761084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p44768026084824"><a name="p44768026084824"></a><a name="p44768026084824"></a><a href="utils.md#gafb90e73f1be310ac1fe22f0d652838bc">iswspace</a> (wint_t wc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p882864178084824"><a name="p882864178084824"></a><a name="p882864178084824"></a>int </p>
<p id="p1412702738084824"><a name="p1412702738084824"></a><a name="p1412702738084824"></a>Checks whether a wide character belongs to the wide-character class <strong id="b1077829253084824"><a name="b1077829253084824"></a><a name="b1077829253084824"></a>space</strong>. </p>
</td>
</tr>
<tr id="row49441606084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p782740021084824"><a name="p782740021084824"></a><a name="p782740021084824"></a><a href="utils.md#gac9068379860381e27a47831612a85c25">iswspace_l</a> (wint_t wc, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1883952998084824"><a name="p1883952998084824"></a><a name="p1883952998084824"></a>int </p>
<p id="p191477330084824"><a name="p191477330084824"></a><a name="p191477330084824"></a>Checks whether a wide character belongs to the wide-character class <strong id="b1765413648084824"><a name="b1765413648084824"></a><a name="b1765413648084824"></a>space</strong> for the specified locale. </p>
</td>
</tr>
<tr id="row626869645084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p372284821084824"><a name="p372284821084824"></a><a name="p372284821084824"></a><a href="utils.md#ga4f73f2368e29bb2fc350479157987bc8">iswupper_l</a> (wint_t wc, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p422797765084824"><a name="p422797765084824"></a><a name="p422797765084824"></a>int </p>
<p id="p1446324252084824"><a name="p1446324252084824"></a><a name="p1446324252084824"></a>Checks whether a wide character is in uppercase for the specified locale. </p>
</td>
</tr>
<tr id="row488536917084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p164579205084824"><a name="p164579205084824"></a><a name="p164579205084824"></a><a href="utils.md#ga2355dbfdaa44cb73ffd0216f97a7ad93">iswxdigit_l</a> (wint_t wc, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p123532854084824"><a name="p123532854084824"></a><a name="p123532854084824"></a>int </p>
<p id="p476483618084824"><a name="p476483618084824"></a><a name="p476483618084824"></a>Checks whether a wide character is a hexadecimal digit for the specified locale. </p>
</td>
</tr>
<tr id="row1929915034084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1600370300084824"><a name="p1600370300084824"></a><a name="p1600370300084824"></a><a href="utils.md#ga0f3b0048ef4d82840c1f7d1c78e25e6b">iswctype_l</a> (wint_t wc, wctype_t desc, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1322109910084824"><a name="p1322109910084824"></a><a name="p1322109910084824"></a>int </p>
<p id="p2038259110084824"><a name="p2038259110084824"></a><a name="p2038259110084824"></a>Checks whether the character specified by <strong id="b813891278084824"><a name="b813891278084824"></a><a name="b813891278084824"></a>wc</strong> belongs to the <strong id="b1130077274084824"><a name="b1130077274084824"></a><a name="b1130077274084824"></a>desc</strong> class for the specified locale. </p>
</td>
</tr>
<tr id="row1755397136084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1348159349084824"><a name="p1348159349084824"></a><a name="p1348159349084824"></a><a href="utils.md#ga6333139346611f59c603f70b61b521b5">towlower_l</a> (wint_t wc, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p542147167084824"><a name="p542147167084824"></a><a name="p542147167084824"></a>wint_t </p>
<p id="p511378617084824"><a name="p511378617084824"></a><a name="p511378617084824"></a>Converts an uppercase wide character to lowercase for the specified locale. </p>
</td>
</tr>
<tr id="row1047104214084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1125506780084824"><a name="p1125506780084824"></a><a name="p1125506780084824"></a><a href="utils.md#gac01816aef7bc2050e1b19db17a26bae8">towupper_l</a> (wint_t wc, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2010095487084824"><a name="p2010095487084824"></a><a name="p2010095487084824"></a>wint_t </p>
<p id="p267073515084824"><a name="p267073515084824"></a><a name="p267073515084824"></a>Converts a lowercase wide character to uppercase for the specified locale. </p>
</td>
</tr>
<tr id="row1578237311084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p720021471084824"><a name="p720021471084824"></a><a name="p720021471084824"></a><a href="utils.md#gaa65f72b343b0d847933e6dbb7454a915">towctrans_l</a> (wint_t wc, wctype_t desc, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p44540257084824"><a name="p44540257084824"></a><a name="p44540257084824"></a>wint_t </p>
<p id="p1288931304084824"><a name="p1288931304084824"></a><a name="p1288931304084824"></a>Translates the type of a wide character based on the translation mapping relationship for the specified locale. </p>
</td>
</tr>
<tr id="row243053908084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p138129297084824"><a name="p138129297084824"></a><a name="p138129297084824"></a><a href="utils.md#ga85e85bc84a644c3a0686fd6e4cfd96d7">wctrans_l</a> (const char *name, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p810517745084824"><a name="p810517745084824"></a><a name="p810517745084824"></a><a href="utils.md#ga10b40cc6ecda73a91162017d2df251a3">wctrans_t</a> </p>
<p id="p289669244084824"><a name="p289669244084824"></a><a name="p289669244084824"></a>Determines a mapping which can map a wide character to another wide character. </p>
</td>
</tr>
<tr id="row1561193320084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p842815894084824"><a name="p842815894084824"></a><a name="p842815894084824"></a><a href="utils.md#gae43cf599bd1eb5674ed9cc17870f7472">wctype_l</a> (const char *name, locale_t locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p725241837084824"><a name="p725241837084824"></a><a name="p725241837084824"></a>wctype_t </p>
<p id="p353285444084824"><a name="p353285444084824"></a><a name="p353285444084824"></a>Checks whether a wide character type exists for the specified locale. </p>
</td>
</tr>
</tbody>
</table>

## **Details**<a name="section666172393084824"></a>

## **Macro Definition Documentation**<a name="section379921530084824"></a>

## \_tolower<a name="ga803da2fa3d4650c493068eb474e5e874"></a>

```
#define _tolower( a)   ((a)|0x20)
```

 **Description:**

Converts an uppercase letter to its lowercase equivalent. 

**Parameters:**

<a name="table367967896084824"></a>
<table><thead align="left"><tr id="row149668776084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1171223439084824"><a name="p1171223439084824"></a><a name="p1171223439084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p615422836084824"><a name="p615422836084824"></a><a name="p615422836084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1326077944084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">a</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to convert. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted lowercase letter if the conversion is successful. 



## \_toupper<a name="ga2a220adaae919f631f86e4ee91667ac2"></a>

```
#define _toupper( a)   ((a)&0x5f)
```

 **Description:**

Converts a lowercase letter to its uppercase equivalent. 

**Parameters:**

<a name="table814852028084824"></a>
<table><thead align="left"><tr id="row979434088084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p699277370084824"><a name="p699277370084824"></a><a name="p699277370084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1837579147084824"><a name="p1837579147084824"></a><a name="p1837579147084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2014184088084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">a</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to convert. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted uppercase letter if the conversion is successful. 



## isascii<a name="ga325ce1f1d55d5b154a914a37b1094cf2"></a>

```
#define isascii( a)   (0 ? isascii(a) : (unsigned)(a) < 128)
```

 **Description:**

Checks whether a parameter is an ASCII character. 

**Parameters:**

<a name="table1207061366084824"></a>
<table><thead align="left"><tr id="row601592367084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1250791704084824"><a name="p1250791704084824"></a><a name="p1250791704084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p53369212084824"><a name="p53369212084824"></a><a name="p53369212084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2003971161084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">a</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## strdupa<a name="ga6dfceaa174558eaee80a23cb09139dfd"></a>

```
#define strdupa( x)   [strcpy](utils.md#ga7a82515b5d377be04817715c5465b647)(alloca([strlen](utils.md#gaa383452fe445bfae989358c9d7d96f4f)(x)+1),x)
```

 **Description:**

Copies a string to a new position. 

**Attention:**

[strdupa\(\)](utils.md#ga6dfceaa174558eaee80a23cb09139dfd)  internally calls  **alloca\(\)**  to allocate space for variables. You should pay attention to the stack space size. 

**Returns:**

Returns the pointer to the space allocated for the copied string if the operation is successful; returns  **NULL**  if the space fails to be allocated. 



## va\_arg<a name="ga9cfd655f1203c9a345ddd90446f0bcee"></a>

```
#define va_arg( v,  l )   __builtin_va_arg(v,l)
```

 **Description:**

Obtains the next argument in the variable-length argument list. 

**Parameters:**

<a name="table64301927084824"></a>
<table><thead align="left"><tr id="row688651817084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p690894406084824"><a name="p690894406084824"></a><a name="p690894406084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1763518624084824"><a name="p1763518624084824"></a><a name="p1763518624084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row634770308084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">v</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the <strong id="b449286664084824"><a name="b449286664084824"></a><a name="b449286664084824"></a>va_list v</strong> initialized by <strong id="b1815402502084824"><a name="b1815402502084824"></a><a name="b1815402502084824"></a><a href="utils.md#gaa0628ab596c3d7e78f5e08c2d98e24da">va_start()</a></strong>. Each call to <strong id="b1549317507084824"><a name="b1549317507084824"></a><a name="b1549317507084824"></a><a href="utils.md#ga9cfd655f1203c9a345ddd90446f0bcee">va_arg()</a></strong> modifies <strong id="b2081398007084824"><a name="b2081398007084824"></a><a name="b2081398007084824"></a>v</strong> so that the next call returns the next argument. </td>
</tr>
<tr id="row1485090796084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">l</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the name of the last argument before the variable argument list, that is, the last argument of which the calling function knows the type. </td>
</tr>
</tbody>
</table>

**Attention:**

**va\_start**  must be called first. 



## va\_copy<a name="ga23a32070bb5595761e7ed3884a84eb4a"></a>

```
#define va_copy( d,  s )   __builtin_va_copy(d,s)
```

 **Description:**

Copies the previously initialized variable argument list  **s**  to  **d**. 

**Parameters:**

<a name="table273830600084824"></a>
<table><thead align="left"><tr id="row1007931302084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1572538741084824"><a name="p1572538741084824"></a><a name="p1572538741084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1731803477084824"><a name="p1731803477084824"></a><a name="p1731803477084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row614042473084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">d</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the destination variable. </td>
</tr>
<tr id="row1814441862084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the source variable. </td>
</tr>
</tbody>
</table>

## va\_end<a name="ga823b205416e9129825841b74c3bf8484"></a>

```
#define va_end( v)   __builtin_va_end(v)
```

 **Description:**

Ends a variable-length argument list. 

This function releases a calling function. 

**Parameters:**

<a name="table1346951841084824"></a>
<table><thead align="left"><tr id="row299656184084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1688712332084824"><a name="p1688712332084824"></a><a name="p1688712332084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p224156708084824"><a name="p224156708084824"></a><a name="p224156708084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row770634321084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">v</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the <strong id="b1260841072084824"><a name="b1260841072084824"></a><a name="b1260841072084824"></a>va_list v</strong> initialized by <strong id="b1698773059084824"><a name="b1698773059084824"></a><a name="b1698773059084824"></a><a href="utils.md#gaa0628ab596c3d7e78f5e08c2d98e24da">va_start()</a></strong>. </td>
</tr>
</tbody>
</table>

**Attention:**

After  **va\_end**  is called,  **v**  is a random value. 



## va\_start<a name="gaa0628ab596c3d7e78f5e08c2d98e24da"></a>

```
#define va_start( v,  l )   __builtin_va_start(v,l)
```

 **Description:**

Defines the start position of the variable-length argument list. 

This function initializes  **v**  for subsequent use by  [va\_arg](utils.md#ga9cfd655f1203c9a345ddd90446f0bcee)  and  [va\_end](utils.md#ga823b205416e9129825841b74c3bf8484), and must be called first. 

**Parameters:**

<a name="table1206502690084824"></a>
<table><thead align="left"><tr id="row182980767084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p183440835084824"><a name="p183440835084824"></a><a name="p183440835084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p810065497084824"><a name="p810065497084824"></a><a name="p810065497084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1020464841084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">v</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the argument to be initialized. </td>
</tr>
<tr id="row119326421084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">l</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the name of the last argument before the variable argument list, that is, the last argument of which the calling function knows the type. </td>
</tr>
</tbody>
</table>

**Attention:**

This function must be used together with  [va\_end](utils.md#ga823b205416e9129825841b74c3bf8484). 



## **Function Documentation**<a name="section754550943084824"></a>

## \_Exit\(\)<a name="ga7631d470a867ad04b3272667ea4b643e"></a>

```
void _Exit (int status)
```

 **Description:**

Terminates the calling process, clears the used memory space and various data structures in the kernel, and sends the process end status to the parent process. 

**Parameters:**

<a name="table720733819084824"></a>
<table><thead align="left"><tr id="row1200349728084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p426988910084824"><a name="p426988910084824"></a><a name="p426988910084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p214188541084824"><a name="p214188541084824"></a><a name="p214188541084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row83831165084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">status</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the status sent to the parent process when the calling process ends. </td>
</tr>
</tbody>
</table>

## \_exit\(\)<a name="gaee2ffcdf92b92a337c592a7ef9174769"></a>

```
_Noreturn void _exit (int status)
```

 **Description:**

Exits the process immediately and closes all opened file descriptors in the process. 

The subprocess is taken over by process 1. 

**Parameters:**

<a name="table1720294267084824"></a>
<table><thead align="left"><tr id="row68330121084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1274852998084824"><a name="p1274852998084824"></a><a name="p1274852998084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1251125037084824"><a name="p1251125037084824"></a><a name="p1251125037084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1243077401084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">status</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the exit status of the process. The status is returned to the parent process of the current process and can be collected by the <a href="process.md#gabf2fbcf6df59fd5234e9eed4db1a1804">wait()</a> series functions. </td>
</tr>
</tbody>
</table>

## a64l\(\)<a name="gaed396b4eb37b2a1f5414f9c21749dadb"></a>

```
long a64l (const char * str64)
```

 **Description:**

Converts between a 32-bit long integer and a little-endian 64-bit ASCII string. 

**Parameters:**

<a name="table1763679914084824"></a>
<table><thead align="left"><tr id="row107168838084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p660867007084824"><a name="p660867007084824"></a><a name="p660867007084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p379963279084824"><a name="p379963279084824"></a><a name="p379963279084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1694123385084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">str64</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the character constant. </td>
</tr>
</tbody>
</table>

**Attention:**

If the length of  **str64**  is greater than  **6**, only the first six bytes are used. 

**Returns:**

Returns the converted value. 



## abort\(\)<a name="ga7d78319026a43c0a5f942436ad3f09a1"></a>

```
_Noreturn void abort (void )
```

 **Description:**

Terminates an abnormal process and sends the  **SIGABRT**  signal to the caller. 

## abs\(\)<a name="gaf15d7205d8d10c4820f997ce5c526279"></a>

```
int abs (int i)
```

 **Description:**

Obtains the absolute value of an integer value. 

**Parameters:**

<a name="table958044863084824"></a>
<table><thead align="left"><tr id="row702371956084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1133284830084824"><a name="p1133284830084824"></a><a name="p1133284830084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1434155257084824"><a name="p1434155257084824"></a><a name="p1434155257084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1580975096084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">i</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the integer value. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the absolute value. 



## access\(\)<a name="gaeff22ad09b35eda92f6c5632300b05da"></a>

```
int access (const char * path, int mode )
```

 **Description:**

Checks whether a file has the corresponding permission. 

**Parameters:**

<a name="table936473267084824"></a>
<table><thead align="left"><tr id="row229750276084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2116314889084824"><a name="p2116314889084824"></a><a name="p2116314889084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p910849501084824"><a name="p910849501084824"></a><a name="p910849501084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1738859440084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the path of the file to be checked. </td>
</tr>
<tr id="row2034436576084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">mode</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the access permission to be checked. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the current file has the permission to be checked; returns  **-1**  and sets  **errno**  to a value in the following table if the current file does not have the permission to be checked or other errors occur. 

<a name="table1660919801084824"></a>
<table><thead align="left"><tr id="row1252324417084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1588102452084824"><a name="p1588102452084824"></a><a name="p1588102452084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2038274536084824"><a name="p2038274536084824"></a><a name="p2038274536084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1364134202084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p382370555084824"><a name="p382370555084824"></a><a name="p382370555084824"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p282184164084824"><a name="p282184164084824"></a><a name="p282184164084824"></a>The permission bit of the file mode does not allow the requested access, or the search permission is denied on the path prefix component. </p>
</td>
</tr>
<tr id="row1790248812084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p469193290084824"><a name="p469193290084824"></a><a name="p469193290084824"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1163070873084824"><a name="p1163070873084824"></a><a name="p1163070873084824"></a>Invalid address. </p>
</td>
</tr>
<tr id="row21461511084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p485490054084824"><a name="p485490054084824"></a><a name="p485490054084824"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1354901478084824"><a name="p1354901478084824"></a><a name="p1354901478084824"></a>The component of <strong id="b1383188363084824"><a name="b1383188363084824"></a><a name="b1383188363084824"></a>path</strong> does not exist or the path is an empty string. </p>
</td>
</tr>
<tr id="row34990145084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p707876360084824"><a name="p707876360084824"></a><a name="p707876360084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p712966739084824"><a name="p712966739084824"></a><a name="p712966739084824"></a>Insufficient memory. </p>
</td>
</tr>
</tbody>
</table>

## alarm\(\)<a name="ga8c476685d78ea93ee343f8a0580c79fe"></a>

```
unsigned int alarm (unsigned int seconds)
```

 **Description:**

Arranges a signal to be sent to the current process after the number of seconds specified by  **seconds**. 

 

**Parameters:**

<a name="table675309145084824"></a>
<table><thead align="left"><tr id="row860117393084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p721619269084824"><a name="p721619269084824"></a><a name="p721619269084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p419132356084824"><a name="p419132356084824"></a><a name="p419132356084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1887359685084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">seconds</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates an unsigned integer <strong id="b1983968430084824"><a name="b1983968430084824"></a><a name="b1983968430084824"></a>seconds</strong> needs to be transferred. </td>
</tr>
</tbody>
</table>

**Attention:**

An exception occurs when this function is used together with  **[setitimer\(\)](time-sys.md#ga81245d77d2f570933cc81f13a101bff8)**,  [ualarm\(\)](utils.md#ga9d35348d3389a721ab5aef5f4f036c61), and  **[sleep\(\)](utils.md#gad4669b3813c3b4a616a738317fdc974f)**. This function shares a timer with  **[setitimer\(\)](time-sys.md#ga81245d77d2f570933cc81f13a101bff8)**  and  [ualarm\(\)](utils.md#ga9d35348d3389a721ab5aef5f4f036c61). You are not advised to use this function together with  **[sleep\(\)](utils.md#gad4669b3813c3b4a616a738317fdc974f)**. 

**Returns:**

Returns the remaining seconds until the countdown of  **seconds**  ends; returns  **0**  if no alarm clock is set. 



## assert\(\)<a name="ga901e482eabd0dedb19224cf731e15403"></a>

```
void assert (scalar expression)
```

 **Description:**

Aborts the program if assertion is false. 

If the  **NDEBUG**  macro is not defined and the value of  **expression**  is false, an error message is displayed and the process is terminated. In other cases, this macro is expanded but no operation is performed. 

**Parameters:**

<a name="table1286907124084824"></a>
<table><thead align="left"><tr id="row8123807084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1683254894084824"><a name="p1683254894084824"></a><a name="p1683254894084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1241341426084824"><a name="p1241341426084824"></a><a name="p1241341426084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row388417514084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">expression</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the condition variable. If the value of <strong id="b1953541346084824"><a name="b1953541346084824"></a><a name="b1953541346084824"></a>expression</strong> is false, an error message is displayed and the process is terminated. </td>
</tr>
</tbody>
</table>

## atexit\(\)<a name="ga7fd89c82095df80e5e12d6b2834a2acc"></a>

```
int atexit (void(*)(void) func)
```

 **Description:**

Registers a termination function. 

The registered function is called when the current process is terminated normally. The sequence of the termination function to be called is opposite to the registration sequence. 

**Parameters:**

<a name="table1719129395084824"></a>
<table><thead align="left"><tr id="row1836310079084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1581574422084824"><a name="p1581574422084824"></a><a name="p1581574422084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p937351387084824"><a name="p937351387084824"></a><a name="p937351387084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row812453669084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">func</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the termination function to be called. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns a non-zero value otherwise. 



## atof\(\)<a name="gac03da055b7752247b034fb582cb4372f"></a>

```
double atof (const char * nptr)
```

 **Description:**

Converts an input string to a double-precision floating-point number. 

The conversion stops when a non-numeric character is encountered. 

**Parameters:**

<a name="table1869467448084824"></a>
<table><thead align="left"><tr id="row1874645052084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1159395055084824"><a name="p1159395055084824"></a><a name="p1159395055084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1679210198084824"><a name="p1679210198084824"></a><a name="p1679210198084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1607314022084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the string to be converted. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted value if the operation is successful; returns  **0**  if the operation fails. 



## atoi\(\)<a name="gad228deceea1bac4d9f171f647c265059"></a>

```
int atoi (const char * nptr)
```

 **Description:**

Converts an input string to an integer. 

The conversion stops when a non-numeric character is encountered. 

**Parameters:**

<a name="table1335181605084824"></a>
<table><thead align="left"><tr id="row1605991188084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p687450409084824"><a name="p687450409084824"></a><a name="p687450409084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p581652957084824"><a name="p581652957084824"></a><a name="p581652957084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2126574787084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the string to be converted. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted value if the operation is successful; returns  **0**  if the operation fails. 



## atol\(\)<a name="ga185551efd32d058ef290ebe2d144219f"></a>

```
long atol (const char * nptr)
```

 **Description:**

Converts an input string to a long integer. 

**Parameters:**

<a name="table1566159697084824"></a>
<table><thead align="left"><tr id="row1576798392084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p320604503084824"><a name="p320604503084824"></a><a name="p320604503084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p105961596084824"><a name="p105961596084824"></a><a name="p105961596084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1810068013084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the string to be converted. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted value if the operation is successful; returns  **0**  if the operation fails. 



## atoll\(\)<a name="ga5d0555f6ac42472671281e5903244b7b"></a>

```
long long atoll (const char * nptr)
```

 **Description:**

Converts a string to an 8-byte long integer. 

The conversion stops when a non-numeric character is encountered. 

**Parameters:**

<a name="table1232440424084824"></a>
<table><thead align="left"><tr id="row930380520084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1788772685084824"><a name="p1788772685084824"></a><a name="p1788772685084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p877428490084824"><a name="p877428490084824"></a><a name="p877428490084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row44924348084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the string to be converted. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted value if the operation is successful; returns  **0**  if the operation fails. 



## bcmp\(\)<a name="ga840ecc6fc750bf00e99015d2817b0e12"></a>

```
int bcmp (const void * s1, const void * s2, size_t n )
```

 **Description:**

Compares byte sequences. 

Specifically, this function checks whether the first  **n**  bytes of the two byte sequences pointed to by  **s1**  and  **s2**  are equal. If they are equal or  **n**  is 0, this function returns  **0**. Otherwise, it returns a non-zero value. 

**Parameters:**

<a name="table185051034084824"></a>
<table><thead align="left"><tr id="row1449547537084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p121445528084824"><a name="p121445528084824"></a><a name="p121445528084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p582892474084824"><a name="p582892474084824"></a><a name="p582892474084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2037584968084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to byte sequence 1 for comparison. </td>
</tr>
<tr id="row1371121740084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to byte sequence 2 for comparison. </td>
</tr>
<tr id="row1985477904084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of bytes to be compared. </td>
</tr>
</tbody>
</table>

**Attention:**

This function is deprecated \(marked as LEGACY in POSIX.1-2001\). Its specifications have been removed since POSIX.1-2008. You can use  [memcmp\(\)](utils.md#ga9e6df54ee04e18a3772335580e2ed872)  in new projects. 

**Returns:**

Returns  **0**  if the two byte sequences are equal or  **n**  is 0; returns a non-zero value if the operation fails. 



## bcopy\(\)<a name="ga2bf0688adef533a3285e7e0c00f98ff8"></a>

```
void bcopy (const void * src, void * dest, size_t n )
```

 **Description:**

Copies byte sequences. 

Specifically, this function copies the first  **n**  bytes from the memory area pointed to by  **src**  to that pointed to by  **dest**. This function can always be called successfully even if the two specified areas overlap. 

**Parameters:**

<a name="table1864964179084824"></a>
<table><thead align="left"><tr id="row871974540084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p731198808084824"><a name="p731198808084824"></a><a name="p731198808084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1073195426084824"><a name="p1073195426084824"></a><a name="p1073195426084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1666142416084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the source memory area. </td>
</tr>
<tr id="row536123630084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination memory area. </td>
</tr>
<tr id="row1797594661084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of bytes to be copied. </td>
</tr>
</tbody>
</table>

**Attention:**

This function is deprecated \(marked as LEGACY in POSIX.1-2001\). Its specifications have been removed since POSIX.1-2008. You can use  [memcpy\(\)](utils.md#ga0ee37e291991bef6e3f4b49a970171e7)  and  [memmove\(\)](utils.md#ga802c986820d3866639922b6bc9484f90)  in new projects. 



## bsearch\(\)<a name="gac1ed47dda697f858893a9a68882a9fab"></a>

```
void* bsearch (const void * key, const void * base, size_t nel, size_t width, int(*)(const void *, const void *) compar )
```

 **Description:**

Searches for  **key**  using the binary search algorithm from the array element  **base\[0\]**  to  **base\[num-1\]**. 

**Parameters:**

<a name="table768275099084824"></a>
<table><thead align="left"><tr id="row403861707084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p909735823084824"><a name="p909735823084824"></a><a name="p909735823084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1208849647084824"><a name="p1208849647084824"></a><a name="p1208849647084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1125500627084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the keyword to be searched. </td>
</tr>
<tr id="row287306087084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">base</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the array to be searched. </td>
</tr>
<tr id="row1641670974084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nel</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of elements in the array to be searched. </td>
</tr>
<tr id="row492248228084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">width</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of each element, in bytes. </td>
</tr>
<tr id="row559192881084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">compare</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the comparison subfunction used to define comparison rules. </td>
</tr>
</tbody>
</table>

**Attention:**

Data must have been sorted, following the same rule as the comparison subfunction pointed to by  **compar**. 

**Returns:**

Returns the matching item if the operation is successful; returns  **NULL**  if the operation fails. 



## btowc\(\)<a name="ga263759bc74f8621e89e6077095caa942"></a>

```
wint_t btowc (int c)
```

 **Description:**

Converts a single-byte character  **c**  into its wide-character representation. 

**Parameters:**

<a name="table137444056084824"></a>
<table><thead align="left"><tr id="row902732787084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1678055198084824"><a name="p1678055198084824"></a><a name="p1678055198084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2000975276084824"><a name="p2000975276084824"></a><a name="p2000975276084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2059247322084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the character to be converted. </td>
</tr>
</tbody>
</table>

**Attention:**

If  **c**  is  **EOF**  or its length is not 1,  **WEOF**  is returned. 

**Returns:**

Returns the wide-character representation if the operation is successful; returns  **WEOF**  if  **c**  is  **EOF**  or its length is not 1. 



## bzero\(\)<a name="ga59505af7f1c47ff01fdb944801642033"></a>

```
void bzero (void * s, size_t n )
```

 **Description:**

Sets byte sequences to zero. 

Specifically, this function sets the first  **n**  bytes in the memory area starting at  **s**  to zero. 

**Parameters:**

<a name="table1142434909084824"></a>
<table><thead align="left"><tr id="row2072846652084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p211717892084824"><a name="p211717892084824"></a><a name="p211717892084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p111816297084824"><a name="p111816297084824"></a><a name="p111816297084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1586439529084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the first token in the byte sequence to be set to zero. </td>
</tr>
<tr id="row920150676084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of bytes to be set to zero. </td>
</tr>
</tbody>
</table>

**Attention:**

This function is deprecated \(marked as LEGACY in POSIX.1-2001\). Its specifications have been removed since POSIX.1-2008. You can use  [memset\(\)](utils.md#gace6ee45c30e71865e6eb635200379db9)  in new projects. 



## calloc\(\)<a name="ga62b7798461bd461da64c5f9d35feddf7"></a>

```
void* calloc (size_t nmemb, size_t size )
```

 **Description:**

Dynamically allocates  **nmemb**  memory blocks of  **size**. 

**Parameters:**

<a name="table466274399084824"></a>
<table><thead align="left"><tr id="row1960364605084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p806204912084824"><a name="p806204912084824"></a><a name="p806204912084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p940589355084824"><a name="p940589355084824"></a><a name="p940589355084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row172587847084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nmemb</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of memory blocks to be allocated. </td>
</tr>
<tr id="row315995977084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the memory block to be allocated. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the allocated memory block if the operation is successful; returns  **NULL**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table292080568084824"></a>
<table><thead align="left"><tr id="row1740917847084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1812578012084824"><a name="p1812578012084824"></a><a name="p1812578012084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1935515598084824"><a name="p1935515598084824"></a><a name="p1935515598084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row227048766084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1501374679084824"><a name="p1501374679084824"></a><a name="p1501374679084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2127169757084824"><a name="p2127169757084824"></a><a name="p2127169757084824"></a>Insufficient memory. </p>
</td>
</tr>
</tbody>
</table>

## chdir\(\)<a name="ga03af571dfb595681bfa203c83385c07b"></a>

```
int chdir (const char * path)
```

 **Description:**

Switches the current working directory to a specified directory. 

**Parameters:**

<a name="table1323669032084824"></a>
<table><thead align="left"><tr id="row2025970370084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p812616259084824"><a name="p812616259084824"></a><a name="p812616259084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1276338924084824"><a name="p1276338924084824"></a><a name="p1276338924084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2018858600084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the target working directory. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the working directory is switched; returns  **-1**  and sets  **errno**  to a value in the following table if the working directory fails to be switched and the current working directory remains unchanged. 

<a name="table1459375222084824"></a>
<table><thead align="left"><tr id="row1846898030084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p329997954084824"><a name="p329997954084824"></a><a name="p329997954084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p403786901084824"><a name="p403786901084824"></a><a name="p403786901084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1333379971084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p905982835084824"><a name="p905982835084824"></a><a name="p905982835084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p451234683084824"><a name="p451234683084824"></a><a name="p451234683084824"></a><strong id="b759789823084824"><a name="b759789823084824"></a><a name="b759789823084824"></a>path</strong> is set to <strong id="b969009256084824"><a name="b969009256084824"></a><a name="b969009256084824"></a>NULL</strong>. </p>
</td>
</tr>
<tr id="row1440377784084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1935605272084824"><a name="p1935605272084824"></a><a name="p1935605272084824"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2062124884084824"><a name="p2062124884084824"></a><a name="p2062124884084824"></a>The length of the path name is greater than <a href="utils.md#gae688d728e1acdfe5988c7db45d6f0166">PATH_MAX</a>. </p>
</td>
</tr>
<tr id="row566321521084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1165272358084824"><a name="p1165272358084824"></a><a name="p1165272358084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1738078788084824"><a name="p1738078788084824"></a><a name="p1738078788084824"></a>Insufficient memory. </p>
</td>
</tr>
<tr id="row229077948084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p213319187084824"><a name="p213319187084824"></a><a name="p213319187084824"></a>ENOTDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1535792316084824"><a name="p1535792316084824"></a><a name="p1535792316084824"></a><strong id="b1626832824084824"><a name="b1626832824084824"></a><a name="b1626832824084824"></a>path</strong> is not a directory name. </p>
</td>
</tr>
<tr id="row988123591084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1624450977084824"><a name="p1624450977084824"></a><a name="p1624450977084824"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p491459142084824"><a name="p491459142084824"></a><a name="p491459142084824"></a>The path does not exist. </p>
</td>
</tr>
</tbody>
</table>

## chown\(\)<a name="ga7c080ffcae5180218dda2df501e0cb15"></a>

```
int chown (const char * pathname, uid_t owner, gid_t group )
```

 **Description:**

Changes the user and group ownership of a file. 

**Parameters:**

<a name="table1638089916084824"></a>
<table><thead align="left"><tr id="row1918615507084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1586324150084824"><a name="p1586324150084824"></a><a name="p1586324150084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1703127697084824"><a name="p1703127697084824"></a><a name="p1703127697084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row725810670084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pathname</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file path. </td>
</tr>
<tr id="row1819860306084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">owner</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the new file owner. </td>
</tr>
<tr id="row404847593084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">group</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the new file group. </td>
</tr>
</tbody>
</table>

**Attention:**

This function can be used only in the JFFS2 file system. 

**Returns:**

Returns  **0**  if the change is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the change fails. 

<a name="table1977002043084824"></a>
<table><thead align="left"><tr id="row12476106084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p815826767084824"><a name="p815826767084824"></a><a name="p815826767084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p447174002084824"><a name="p447174002084824"></a><a name="p447174002084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row242593203084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1235973652084824"><a name="p1235973652084824"></a><a name="p1235973652084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2118060126084824"><a name="p2118060126084824"></a><a name="p2118060126084824"></a><strong id="b1815534171084824"><a name="b1815534171084824"></a><a name="b1815534171084824"></a>pathname</strong> is a null pointer or an empty string. </p>
</td>
</tr>
<tr id="row274217431084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p553578223084824"><a name="p553578223084824"></a><a name="p553578223084824"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p110286925084824"><a name="p110286925084824"></a><a name="p110286925084824"></a>The permission bit of the file mode does not allow the requested access, or the search permission is denied on the path prefix directory. </p>
</td>
</tr>
<tr id="row1728777790084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p674493037084824"><a name="p674493037084824"></a><a name="p674493037084824"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p13486649084824"><a name="p13486649084824"></a><a name="p13486649084824"></a>Invalid address. </p>
</td>
</tr>
<tr id="row387365365084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1246193082084824"><a name="p1246193082084824"></a><a name="p1246193082084824"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p54963734084824"><a name="p54963734084824"></a><a name="p54963734084824"></a>The length of the path name is greater than <a href="utils.md#gac64541bdd81c961304b9babef1402640">NAME_MAX</a>. </p>
</td>
</tr>
<tr id="row569933094084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p890414213084824"><a name="p890414213084824"></a><a name="p890414213084824"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1291247402084824"><a name="p1291247402084824"></a><a name="p1291247402084824"></a>The directory component in the path name does not exist. </p>
</td>
</tr>
<tr id="row241461974084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1850400607084824"><a name="p1850400607084824"></a><a name="p1850400607084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1116032984084824"><a name="p1116032984084824"></a><a name="p1116032984084824"></a>Insufficient memory. </p>
</td>
</tr>
<tr id="row2109167925084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1083361104084824"><a name="p1083361104084824"></a><a name="p1083361104084824"></a>ENOTDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p908144072084824"><a name="p908144072084824"></a><a name="p908144072084824"></a>A component of the path prefix is the name of an existing file, which is neither a directory nor a symbolic link of a directory. </p>
</td>
</tr>
<tr id="row1347186423084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1412907820084824"><a name="p1412907820084824"></a><a name="p1412907820084824"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p690914680084824"><a name="p690914680084824"></a><a name="p690914680084824"></a>The operation is not allowed or access is denied because the access is prohibited or the directory is full. </p>
</td>
</tr>
<tr id="row940758208084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1860780849084824"><a name="p1860780849084824"></a><a name="p1860780849084824"></a>EROFS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1214606667084824"><a name="p1214606667084824"></a><a name="p1214606667084824"></a>The physical drive is write-protected. </p>
</td>
</tr>
<tr id="row1199173319084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1919395383084824"><a name="p1919395383084824"></a><a name="p1919395383084824"></a>EEXIST </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1375714758084824"><a name="p1375714758084824"></a><a name="p1375714758084824"></a>The file or directory already exists. </p>
</td>
</tr>
<tr id="row1615753638084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p70662492084824"><a name="p70662492084824"></a><a name="p70662492084824"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1269384574084824"><a name="p1269384574084824"></a><a name="p1269384574084824"></a>The operation is not supported. </p>
</td>
</tr>
</tbody>
</table>

## close\(\)<a name="gaafbcde67669a1b96577e735ddebd8634"></a>

```
int close (int fd)
```

 **Description:**

Closes a file with a specified file descriptor. 

**Parameters:**

<a name="table1825573867084824"></a>
<table><thead align="left"><tr id="row1818433029084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p966839975084824"><a name="p966839975084824"></a><a name="p966839975084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2060497785084824"><a name="p2060497785084824"></a><a name="p2060497785084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row235835981084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the descriptor of the file to be closed. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the file is closed; returns  **-1**  and sets  **errno**  to a value in the following table if the file fails to be closed. 

<a name="table2095516389084824"></a>
<table><thead align="left"><tr id="row1329072306084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p254086967084824"><a name="p254086967084824"></a><a name="p254086967084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1870558743084824"><a name="p1870558743084824"></a><a name="p1870558743084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1348350797084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p678360630084824"><a name="p678360630084824"></a><a name="p678360630084824"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p202654124084824"><a name="p202654124084824"></a><a name="p202654124084824"></a><strong id="b1402259806084824"><a name="b1402259806084824"></a><a name="b1402259806084824"></a>fd</strong> is invalid. </p>
</td>
</tr>
<tr id="row1890798709084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p275686570084824"><a name="p275686570084824"></a><a name="p275686570084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1201957095084824"><a name="p1201957095084824"></a><a name="p1201957095084824"></a>The file is not owned by the current process. </p>
</td>
</tr>
<tr id="row945517768084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2101728877084824"><a name="p2101728877084824"></a><a name="p2101728877084824"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1621121188084824"><a name="p1621121188084824"></a><a name="p1621121188084824"></a>The file does not exist. </p>
</td>
</tr>
<tr id="row850713690084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1154430460084824"><a name="p1154430460084824"></a><a name="p1154430460084824"></a>ENODEV </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p741887057084824"><a name="p741887057084824"></a><a name="p741887057084824"></a>The disk partition is not found. </p>
</td>
</tr>
</tbody>
</table>

## crypt\(\)<a name="gaa25acd51546dafe1b44c97de30188589"></a>

```
char* crypt (const char * key, const char * setting )
```

 **Description:**

Encrypts data. 

This function converts the string to be encrypted to one-way hash data that can be stored in the user database. 

**Parameters:**

<a name="table123943164084824"></a>
<table><thead align="left"><tr id="row811123948084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p535508817084824"><a name="p535508817084824"></a><a name="p535508817084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p603985527084824"><a name="p603985527084824"></a><a name="p603985527084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1518109691084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the data to be encrypted. </td>
</tr>
<tr id="row231037587084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">setting</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the description of the encryption mode. The description consists of the encryption prefix and random characters, which are selected from (., /, 0-9, A-Z, a-z). The details are as follows: </td>
</tr>
</tbody>
</table>

<a name="table1608213978084824"></a>
<table><thead align="left"><tr id="row2040028811084824"><th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.1.4.1.1"><p id="p2008270723084824"><a name="p2008270723084824"></a><a name="p2008270723084824"></a>Encryption Algorithm </p>
</th>
<th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.1.4.1.2"><p id="p2024900243084824"><a name="p2024900243084824"></a><a name="p2024900243084824"></a>Encryption Prefix </p>
</th>
<th class="cellrowborder" valign="top" width="33.33333333333333%" id="mcps1.1.4.1.3"><p id="p287484146084824"><a name="p287484146084824"></a><a name="p287484146084824"></a>Number of Random Characters  </p>
</th>
</tr>
</thead>
<tbody><tr id="row83398040084824"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.1 "><p id="p2092720236084824"><a name="p2092720236084824"></a><a name="p2092720236084824"></a>SHA-2-512 </p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.2 "><p id="p295090309084824"><a name="p295090309084824"></a><a name="p295090309084824"></a>'$6$' </p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.3 "><p id="p1750430242084824"><a name="p1750430242084824"></a><a name="p1750430242084824"></a>16 </p>
</td>
</tr>
<tr id="row1912955311084824"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.1 "><p id="p275964453084824"><a name="p275964453084824"></a><a name="p275964453084824"></a>SHA-2-256 </p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.2 "><p id="p1631876690084824"><a name="p1631876690084824"></a><a name="p1631876690084824"></a>'$5$' </p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.3 "><p id="p938249740084824"><a name="p938249740084824"></a><a name="p938249740084824"></a>16 </p>
</td>
</tr>
<tr id="row361025792084824"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.1 "><p id="p1737245356084824"><a name="p1737245356084824"></a><a name="p1737245356084824"></a>MD5 </p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.2 "><p id="p1220594782084824"><a name="p1220594782084824"></a><a name="p1220594782084824"></a>'$1$' </p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.3 "><p id="p1481487084824"><a name="p1481487084824"></a><a name="p1481487084824"></a>8 </p>
</td>
</tr>
<tr id="row1618909254084824"><td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.1 "><p id="p1311160232084824"><a name="p1311160232084824"></a><a name="p1311160232084824"></a>DES </p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.2 "><p id="p1512803703084824"><a name="p1512803703084824"></a><a name="p1512803703084824"></a>'' </p>
</td>
<td class="cellrowborder" valign="top" width="33.33333333333333%" headers="mcps1.1.4.1.3 "><p id="p1967173780084824"><a name="p1967173780084824"></a><a name="p1967173780084824"></a>2 </p>
</td>
</tr>
</tbody>
</table>

**Attention:**

The returned string is composed of printable ASCII characters, but does not contain spaces or any of the following characters: \{':', ';', '\*', '!', '\\'\}. 

**Returns:**

Returns the encrypted data if the operation is successful; returns  **NULL**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table820436450084824"></a>
<table><thead align="left"><tr id="row1348285976084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p794203805084824"><a name="p794203805084824"></a><a name="p794203805084824"></a>Input </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1931593309084824"><a name="p1931593309084824"></a><a name="p1931593309084824"></a>Error code  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1905376034084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p648803234084824"><a name="p648803234084824"></a><a name="p648803234084824"></a><strong id="b1743491682084824"><a name="b1743491682084824"></a><a name="b1743491682084824"></a>setting</strong> is set to <strong id="b316443325084824"><a name="b316443325084824"></a><a name="b316443325084824"></a>NULL</strong>. </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1312939443084824"><a name="p1312939443084824"></a><a name="p1312939443084824"></a><a href="utils.md#ga2d1678d5a7cc8ce499643f3b8957def4">EINVAL</a> </p>
</td>
</tr>
<tr id="row413596916084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1125899304084824"><a name="p1125899304084824"></a><a name="p1125899304084824"></a>The hash password or encryption algorithm is not supported. </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2055981382084824"><a name="p2055981382084824"></a><a name="p2055981382084824"></a><a href="utils.md#ga43785b9969e0bd1af532dbde06c5540b">ENOSYS</a> </p>
</td>
</tr>
<tr id="row480132095084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1701273252084824"><a name="p1701273252084824"></a><a name="p1701273252084824"></a>The system does not allow the encryption algorithm. </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1568212740084824"><a name="p1568212740084824"></a><a name="p1568212740084824"></a><a href="utils.md#gadd669d31505a077f769cff8e66c780b3">EPERM</a> </p>
</td>
</tr>
</tbody>
</table>

## div\(\)<a name="ga98cbdcca43b259bf545f16c72f07825b"></a>

```
[div_t](div_t.md) div (int numerator, int denominator )
```

 **Description:**

Calculates the quotient and remainder of an integer after division. 

**Parameters:**

<a name="table2054726886084824"></a>
<table><thead align="left"><tr id="row982280014084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1326935368084824"><a name="p1326935368084824"></a><a name="p1326935368084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p590816063084824"><a name="p590816063084824"></a><a name="p590816063084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1941953316084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">numerator</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the numerator. </td>
</tr>
<tr id="row912017141084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">denominator</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the denominator. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a structure variable that has been defined in the function. 



## drand48\(\)<a name="gaf9329f9acef07ca14ea2256191c3ce74"></a>

```
double drand48 (void )
```

 **Description:**

Obtains a random number. 

This function returns a double-precision random number evenly distributed between \(0.0, 1.0\). 

**Attention:**

Before calling this function, you need to call one of the initialization functions  **[srand48\(\)](utils.md#ga91c6acf8516086891c689926e49f1ddf)**,  **[seed48\(\)](utils.md#ga0b86f7fc9964c291844e8112a367721c)**, and  **[lcong48\(\)](utils.md#ga71e0019171f5584bb6957867691c3e10)**. 

**Returns:**

Returns the obtained double-precision random number. 



## dup\(\)<a name="ga2599c985f9cce0d9d7b11732941bd9dc"></a>

```
int dup (int oldfd)
```

 **Description:**

Copies a specified file descriptor. 

**Parameters:**

<a name="table218468090084824"></a>
<table><thead align="left"><tr id="row122107877084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1980202429084824"><a name="p1980202429084824"></a><a name="p1980202429084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p404641880084824"><a name="p404641880084824"></a><a name="p404641880084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1553318006084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">oldfd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file descriptor to be copied. </td>
</tr>
</tbody>
</table>

**Attention:**

This function can be used only in the NFS file system. 

**Returns:**

Returns a non-negative integer \(minimum descriptor available to the current process\) if the copy is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the copy fails. 

<a name="table1054084925084824"></a>
<table><thead align="left"><tr id="row2078050297084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p781081502084824"><a name="p781081502084824"></a><a name="p781081502084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p634559947084824"><a name="p634559947084824"></a><a name="p634559947084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row55881276084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p681402119084824"><a name="p681402119084824"></a><a name="p681402119084824"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1134128460084824"><a name="p1134128460084824"></a><a name="p1134128460084824"></a><strong id="b20866911084824"><a name="b20866911084824"></a><a name="b20866911084824"></a>oldfd</strong> is invalid. </p>
</td>
</tr>
<tr id="row884814312084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p340321344084824"><a name="p340321344084824"></a><a name="p340321344084824"></a>EMFILE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1486816103084824"><a name="p1486816103084824"></a><a name="p1486816103084824"></a>Failed to allocate file descriptors because too many files are opened. </p>
</td>
</tr>
<tr id="row954056445084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p214474615084824"><a name="p214474615084824"></a><a name="p214474615084824"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p731163295084824"><a name="p731163295084824"></a><a name="p731163295084824"></a>The index node cannot be found based on the path name associated with <strong id="b1757596080084824"><a name="b1757596080084824"></a><a name="b1757596080084824"></a>oldfd</strong>. </p>
</td>
</tr>
<tr id="row1560978359084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p748040564084824"><a name="p748040564084824"></a><a name="p748040564084824"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p696219183084824"><a name="p696219183084824"></a><a name="p696219183084824"></a>The operation is not supported. </p>
</td>
</tr>
<tr id="row1310347194084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p380693732084824"><a name="p380693732084824"></a><a name="p380693732084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1688991966084824"><a name="p1688991966084824"></a><a name="p1688991966084824"></a>Insufficient memory. </p>
</td>
</tr>
</tbody>
</table>

## dup2\(\)<a name="ga0bbddf8ae4f3dea6e57532be36c04268"></a>

```
int dup2 (int oldfd, int newfd )
```

 **Description:**

Copies the descriptor of the target file to a specified descriptor. 

**Parameters:**

<a name="table834048764084824"></a>
<table><thead align="left"><tr id="row1612122518084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p924044322084824"><a name="p924044322084824"></a><a name="p924044322084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2103504278084824"><a name="p2103504278084824"></a><a name="p2103504278084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row320905036084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">oldfd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file descriptor to be copied. </td>
</tr>
<tr id="row1559143356084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">newfd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the new file descriptor for copying. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-negative integer \(descriptor of the new file\) if the copy is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the copy fails. 

<a name="table1014147239084824"></a>
<table><thead align="left"><tr id="row989296215084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p696438092084824"><a name="p696438092084824"></a><a name="p696438092084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p767724421084824"><a name="p767724421084824"></a><a name="p767724421084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row936290143084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p840859066084824"><a name="p840859066084824"></a><a name="p840859066084824"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p240904074084824"><a name="p240904074084824"></a><a name="p240904074084824"></a><strong id="b1332328534084824"><a name="b1332328534084824"></a><a name="b1332328534084824"></a>oldfd</strong> is invalid. </p>
</td>
</tr>
<tr id="row1766364712084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2009437589084824"><a name="p2009437589084824"></a><a name="p2009437589084824"></a>EMFILE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1919722941084824"><a name="p1919722941084824"></a><a name="p1919722941084824"></a>Failed to allocate file descriptors because too many files are opened. </p>
</td>
</tr>
<tr id="row1530313929084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p848449324084824"><a name="p848449324084824"></a><a name="p848449324084824"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p95351648084824"><a name="p95351648084824"></a><a name="p95351648084824"></a>The index node cannot be found based on the path name associated with <strong id="b196301161084824"><a name="b196301161084824"></a><a name="b196301161084824"></a>oldfd</strong>. </p>
</td>
</tr>
<tr id="row1142520863084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p545837727084824"><a name="p545837727084824"></a><a name="p545837727084824"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1091241444084824"><a name="p1091241444084824"></a><a name="p1091241444084824"></a>The operation is not supported. </p>
</td>
</tr>
<tr id="row283743061084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p49494544084824"><a name="p49494544084824"></a><a name="p49494544084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p439946158084824"><a name="p439946158084824"></a><a name="p439946158084824"></a>Insufficient memory. </p>
</td>
</tr>
</tbody>
</table>

## ecvt\(\)<a name="ga888afe4104cd3bdc07445d8ed27b96bd"></a>

```
char* ecvt (double number, int ndigits, int * decpt, int * sign )
```

 **Description:**

Converts a double-precision floating-point number into a string. 

The conversion result does not contain decimal places. 

**Parameters:**

<a name="table216261302084824"></a>
<table><thead align="left"><tr id="row290867919084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1214595534084824"><a name="p1214595534084824"></a><a name="p1214595534084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1229394186084824"><a name="p1229394186084824"></a><a name="p1229394186084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row292388922084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">number</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the double-precision floating-point number to be converted. </td>
</tr>
<tr id="row627118224084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ndigits</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of valid digits to be stored. </td>
</tr>
<tr id="row955199605084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">decpt</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the decimal point position. </td>
</tr>
<tr id="row1587293497084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">sign</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the symbol of the number to be converted. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the generated string. 



## erand48\(\)<a name="ga95f02f2831f093c6e151f0b782f20e48"></a>

```
double erand48 (unsigned short xsubi[3])
```

 **Description:**

Obtains a random number. 

This function returns nonnegative double-precision floating-point values evenly distributed between \[0.0, 1.0\). 

**Parameters:**

<a name="table325419878084824"></a>
<table><thead align="left"><tr id="row777239313084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1122956506084824"><a name="p1122956506084824"></a><a name="p1122956506084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2064818802084824"><a name="p2064818802084824"></a><a name="p2064818802084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row943036286084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">xsubi</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the array of the initialized value of <strong id="b420797289084824"><a name="b420797289084824"></a><a name="b420797289084824"></a>Xi</strong>. </td>
</tr>
</tbody>
</table>

## execl\(\)<a name="ga1ade18bb3b763fbcefc507c770dc7e7e"></a>

```
int execl (const char * path, const char * arg,  ... )
```

 **Description:**

Executes a specified user program file in ELF format. 

**Parameters:**

<a name="table1076343508084824"></a>
<table><thead align="left"><tr id="row1221537710084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2139076125084824"><a name="p2139076125084824"></a><a name="p2139076125084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p237785403084824"><a name="p237785403084824"></a><a name="p237785403084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row582624593084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the full path of the ELF file. </td>
</tr>
<tr id="row536662107084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">arg</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the list of parameters required by the program, ending with a null pointer. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **-1**  and sets  **errno**  to the corresponding error code  [perror](io.md#ga80b37b56a5a42139dccaef56da4bf82a)  if the operation fails. 



## execle\(\)<a name="ga2c2701379e4144b3105aa83c82363aa3"></a>

```
int execle (const char * path, const char * arg,  ... )
```

 **Description:**

Executes a specified user program file in ELF format. 

**Parameters:**

<a name="table900923599084824"></a>
<table><thead align="left"><tr id="row264405088084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2052470203084824"><a name="p2052470203084824"></a><a name="p2052470203084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p882930912084824"><a name="p882930912084824"></a><a name="p882930912084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row915668230084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the full path of the ELF file. </td>
</tr>
<tr id="row314958074084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">arg</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the list of parameters required by the program. The <strong id="b1276631369084824"><a name="b1276631369084824"></a><a name="b1276631369084824"></a>arg</strong> parameter must point to a new environment variable array, that is, the environment variable of the new program. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **-1**  and sets  **errno**  to the corresponding error code  [perror](io.md#ga80b37b56a5a42139dccaef56da4bf82a)  if the operation fails. 



## execlp\(\)<a name="ga4dd268acb7fc54f403ab6cb56b7ffd3f"></a>

```
int execlp (const char * path, const char * arg,  ... )
```

 **Description:**

Executes a specified user program file in ELF format. 

**Parameters:**

<a name="table317703340084824"></a>
<table><thead align="left"><tr id="row464895149084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p150905134084824"><a name="p150905134084824"></a><a name="p150905134084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1045635149084824"><a name="p1045635149084824"></a><a name="p1045635149084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1099282018084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the name or path name of the program file to be executed. </td>
</tr>
<tr id="row1875001882084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">arg</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the list of parameters required by the program, ending with a null pointer. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **-1**  and sets  **errno**  to the corresponding error code  [perror](io.md#ga80b37b56a5a42139dccaef56da4bf82a)  if the operation fails. If the specified file name contains a slash \(/\), the file is executed. If it does not contain a slash \(/\), the current user program traverses the path list specified by the path environment variable. If the path environment variable is not defined, the current user program traverses \("/usr/local/bin:/bin:/usr/bin"\). The path list and file name are combined as an executable file and the file is executed. If the file does not have the execute permission, the system continues to search for other path lists. If no other file is found,  **EACCES**  is returned. If no valid executable file exists in the list of all paths,  **-1**  is returned. 



## execv\(\)<a name="gadb609bbc5b9255bf715138cda88857b0"></a>

```
int execv (const char * path, char *const arg[] )
```

 **Description:**

Executes a specified user program file in ELF format. 

**Parameters:**

<a name="table1686149309084824"></a>
<table><thead align="left"><tr id="row1098176413084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1581694483084824"><a name="p1581694483084824"></a><a name="p1581694483084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p596842874084824"><a name="p596842874084824"></a><a name="p596842874084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1345160680084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the full path of the ELF file. </td>
</tr>
<tr id="row2068511421084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">arg</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the list of program parameters maintained by the pointer to the array. The last element of the array must be a null pointer. </td>
</tr>
</tbody>
</table>

**Attention:**

This function is slightly different from  [execve](utils.md#ga99ca2b673a47850c541b215ddfd6b23e)  in input parameters. The  **arg**  parameter is a string array for storing new environment variables. 

**Returns:**

Returns  **-1**  and sets  **errno**  to the corresponding error code  [perror](io.md#ga80b37b56a5a42139dccaef56da4bf82a)  if the operation fails. 



## execve\(\)<a name="ga99ca2b673a47850c541b215ddfd6b23e"></a>

```
int execve (const char * path, char *const arg[], char *const envp[] )
```

 **Description:**

Executes a specified user program file in ELF format. 

**Parameters:**

<a name="table134124510084824"></a>
<table><thead align="left"><tr id="row719002689084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2136246163084824"><a name="p2136246163084824"></a><a name="p2136246163084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1253560973084824"><a name="p1253560973084824"></a><a name="p1253560973084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row986234811084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the full path of the ELF file. </td>
</tr>
<tr id="row1512543105084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">arg</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the list of program parameters maintained by the pointer to the array. The last element of the array must be a null pointer. </td>
</tr>
<tr id="row750256207084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">envp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string for storing new environment variables. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **-1**  and sets  **errno**  to the corresponding error code  [perror](io.md#ga80b37b56a5a42139dccaef56da4bf82a)  if the operation fails. 



## execvp\(\)<a name="ga1bbb0ecd56c097ca82587115b4dfd540"></a>

```
int execvp (const char * path, char *const arg[] )
```

 **Description:**

Executes a specified user program file in ELF format. 

**Parameters:**

<a name="table1100756578084824"></a>
<table><thead align="left"><tr id="row1500778198084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p339437424084824"><a name="p339437424084824"></a><a name="p339437424084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p864033489084824"><a name="p864033489084824"></a><a name="p864033489084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1492816085084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the name or path name of the program file to be executed. </td>
</tr>
<tr id="row1354486223084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">arg</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the list of parameters required by the program, ending with a null pointer. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **-1**  and sets  **errno**  to the corresponding error code  [perror](io.md#ga80b37b56a5a42139dccaef56da4bf82a)  if the operation fails. If the specified file name contains a slash \(/\), the file is executed. If it does not contain a slash \(/\), the current user program traverses the path list specified by the path environment variable. If the path environment variable is not defined, the current user program traverses \("/usr/local/bin:/bin:/usr/bin"\). The path list and file name are combined as an executable file and the file is executed. If the file does not have the execute permission, the system continues to search for other path lists. If no other file is found,  **EACCES**  is returned. If no valid executable file exists in the list of all paths,  **-1**  is returned. 



## exit\(\)<a name="ga55e99c539cf7723ec15e856b7e0a8cee"></a>

```
void exit (int status)
```

 **Description:**

Terminates the calling process, clears the used memory space and various data structures in the kernel, and sends the process end status to the parent process. All functions registered with atexit and on\_exit are called in the reverse order. 

**Parameters:**

<a name="table755074485084824"></a>
<table><thead align="left"><tr id="row1069995004084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p560160758084824"><a name="p560160758084824"></a><a name="p560160758084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p773064093084824"><a name="p773064093084824"></a><a name="p773064093084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row536034630084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">status</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the status sent to the parent process when the calling process ends. </td>
</tr>
</tbody>
</table>

## fcvt\(\)<a name="gaf2658700b7da33eea87761f928b102de"></a>

```
char* fcvt (double number, int ndigits, int * decpt, int * sign )
```

 **Description:**

Converts a floating-point number to a string. 

**Parameters:**

<a name="table833248344084824"></a>
<table><thead align="left"><tr id="row1431485270084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1294417305084824"><a name="p1294417305084824"></a><a name="p1294417305084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p367858491084824"><a name="p367858491084824"></a><a name="p367858491084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1708915086084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">number</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the floating-point number to be converted. </td>
</tr>
<tr id="row634227407084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ndigits</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of decimal places. </td>
</tr>
<tr id="row1539201933084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">decpt</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the position of the decimal point, which can be obtained by users. </td>
</tr>
<tr id="row947484218084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">sign</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the symbol of <strong id="b2142702023084824"><a name="b2142702023084824"></a><a name="b2142702023084824"></a>number</strong>, which can be obtained by users. <strong id="b1302875113084824"><a name="b1302875113084824"></a><a name="b1302875113084824"></a>0</strong> indicates a positive number, and <strong id="b1315555768084824"><a name="b1315555768084824"></a><a name="b1315555768084824"></a>1</strong> indicates a negative number. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted string. 



## ffs\(\)<a name="ga2385d975eddea296daa497e5d36febc9"></a>

```
int ffs (int i)
```

 **Description:**

Searches for the first bit in a word of the integer type. 

Specifically, this function searches for the least significant bit \(position 1\) set in the word. 

**Parameters:**

<a name="table29220903084824"></a>
<table><thead align="left"><tr id="row1590997308084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1511690022084824"><a name="p1511690022084824"></a><a name="p1511690022084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p906283947084824"><a name="p906283947084824"></a><a name="p906283947084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1937055996084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">i</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the long integer to be searched. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the position of the first bit if the operation is successful; returns  **0**  if no bits are set in the word. 



## ffsl\(\)<a name="ga73690a58537a6dbafa9aa4b3afa7baac"></a>

```
int ffsl (long int i)
```

 **Description:**

Searches for the first bit in a word of the long integer type. 

Specifically, this function searches for the least significant bit \(position 1\) set in the word. 

**Parameters:**

<a name="table72221192084824"></a>
<table><thead align="left"><tr id="row1534761930084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1508205213084824"><a name="p1508205213084824"></a><a name="p1508205213084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1392767213084824"><a name="p1392767213084824"></a><a name="p1392767213084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1977604959084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">i</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the long integer to be searched. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the position of the first bit if the operation is successful; returns  **0**  if no bits are set in the word. 



## ffsll\(\)<a name="gae7eaa572ad4e097865bd409b121fb33c"></a>

```
int ffsll (long long int i)
```

 **Description:**

Searches for the first bit in a word of the 8-byte long integer type. 

Specifically, this function searches for the least significant bit \(position 1\) set in the word. 

**Parameters:**

<a name="table1633611269084824"></a>
<table><thead align="left"><tr id="row447624410084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1682042995084824"><a name="p1682042995084824"></a><a name="p1682042995084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1430480778084824"><a name="p1430480778084824"></a><a name="p1430480778084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1245289551084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">i</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the 8-byte long integer to be searched. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the position of the first bit if the operation is successful; returns  **0**  if no bits are set in the word. 



## fgetwc\(\)<a name="ga2b545d8d6d3209a2eb6129d8ba646fe3"></a>

```
wint_t fgetwc ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream)
```

 **Description:**

Reads a wide character from a specified file stream. 

**Parameters:**

<a name="table1922017846084824"></a>
<table><thead align="left"><tr id="row338975204084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1119543180084824"><a name="p1119543180084824"></a><a name="p1119543180084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p205896847084824"><a name="p205896847084824"></a><a name="p205896847084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1120220009084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the wide character if the operation is successful; returns  **WEOF**  if the operation fails or the end-of-file is reached during data reading. 



## fgetws\(\)<a name="ga6f98d7f5d5d1e6ad282ee1a348eab753"></a>

```
wchar_t* fgetws (wchar_t * ws, int n, [FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream )
```

 **Description:**

Reads wide characters from a specified file stream. 

**Parameters:**

<a name="table1293159170084824"></a>
<table><thead align="left"><tr id="row1684498029084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p746793433084824"><a name="p746793433084824"></a><a name="p746793433084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p194816761084824"><a name="p194816761084824"></a><a name="p194816761084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1002220747084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ws</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide character array that stores the characters to read. </td>
</tr>
<tr id="row549233452084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of characters to read. </td>
</tr>
<tr id="row1246947225084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the read string if the operation is successful; returns a null pointer if no characters are read or the end-of-file is reached during data reading. 



## fmtmsg\(\)<a name="ga41115d5b017933dcee85d41ed7a743e7"></a>

```
int fmtmsg (long classification, const char * label, int severity, const char * text, const char * action, const char * tag )
```

 **Description:**

Prints formatted messages. 

This function is used to print formatted messages to the output device specified by  **classification**. The messages include the message definition, error severity, possible recovery steps, and reference to online documents. 

**Parameters:**

<a name="table826596794084824"></a>
<table><thead align="left"><tr id="row1118001952084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p16089541084824"><a name="p16089541084824"></a><a name="p16089541084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p458147570084824"><a name="p458147570084824"></a><a name="p458147570084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2125949353084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">classification</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates four types of information, including the output device, error source, problem detector, and problem severity. This parameter is of the long integer type. </td>
</tr>
<tr id="row2012942319084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">label</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the message source. This parameter consists of two fields separated by a colon (:). The first field is up to 10 characters, the second is up to 14 characters. </td>
</tr>
<tr id="row1414616320084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">severity</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the severity level of an error message. For details, see <a href="utils.md#ga3d5f92b4ab4f31431e764e04cd74de61">MM_HALT</a>, <a href="utils.md#ga691f4cd7904d1f6579e093fb40226b98">MM_ERROR</a>, <a href="utils.md#ga277b9951914986b139db5750177091f3">MM_WARNING</a>, <a href="utils.md#ga0c65f03a4d4009ddbc8b318c4cca2662">MM_INFO</a>, and <strong id="b772151597084824"><a name="b772151597084824"></a><a name="b772151597084824"></a>MM_NOOSEV</strong>. </td>
</tr>
<tr id="row1563909572084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">text</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the condition of the error. </td>
</tr>
<tr id="row1647224672084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">action</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Describes possible steps to recover from the error. </td>
</tr>
<tr id="row523818661084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tag</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the referenced online documents where more information can be found. </td>
</tr>
</tbody>
</table>

<a name="table1492609868084824"></a>
<table><thead align="left"><tr id="row1668333328084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p541376234084824"><a name="p541376234084824"></a><a name="p541376234084824"></a>Message Type </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2055060605084824"><a name="p2055060605084824"></a><a name="p2055060605084824"></a>Macro Definition Corresponding to the Message Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1817150677084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1532770421084824"><a name="p1532770421084824"></a><a name="p1532770421084824"></a>Message output device </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p451873008084824"><a name="p451873008084824"></a><a name="p451873008084824"></a><a href="utils.md#ga28f8601bbd8dfa8c1a1133892dbaaeaf">MM_PRINT</a>, <a href="utils.md#ga28df3705304c876e17ee22267eaa01af">MM_CONSOLE</a> or both </p>
</td>
</tr>
<tr id="row1298811375084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2092643017084824"><a name="p2092643017084824"></a><a name="p2092643017084824"></a>Message source </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1384170666084824"><a name="p1384170666084824"></a><a name="p1384170666084824"></a><a href="utils.md#ga7250644aab1a485bd6a24720d2867ad8">MM_HARD</a>, <a href="utils.md#ga95d4386c5cab57599cf9fdad75dbd9ef">MM_SOFT</a>, or <a href="utils.md#gaad8873c0512aaad8e20a95d8d7867fa6">MM_FIRM</a> </p>
</td>
</tr>
<tr id="row283742743084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1552552569084824"><a name="p1552552569084824"></a><a name="p1552552569084824"></a>Message detector </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1948532108084824"><a name="p1948532108084824"></a><a name="p1948532108084824"></a><a href="utils.md#ga9c8b88fc46ddd4d418c05b4c5c685786">MM_APPL</a>, <a href="utils.md#ga5b43fa612f8e72db32d32385192f5bd9">MM_UTIL</a>, or <a href="utils.md#ga3257723578ef85fb0cef91ac18a6a8e9">MM_OPSYS</a> </p>
</td>
</tr>
<tr id="row1886298840084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1697073285084824"><a name="p1697073285084824"></a><a name="p1697073285084824"></a>Severity of the incident </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p817330538084824"><a name="p817330538084824"></a><a name="p817330538084824"></a><a href="utils.md#ga655710ff6f4600613aba693f2c933844">MM_RECOVER</a> or <a href="utils.md#gaac7ced5531ea5e8af060a12930bd930b">MM_NRECOV</a> </p>
</td>
</tr>
</tbody>
</table>

**Attention:**

All parameters in this function can be ignored based on the following definitions:  [MM\_NULLLBL](utils.md#ga174d0d4b9bbda298cd1faec4d4f27202),  [MM\_NULLSEV](utils.md#gad65c53433554559cdc93e413786cc981),  [MM\_NULLTXT](utils.md#ga345476b2492fd41e52ec6cbb08265b07),  [MM\_NULLACT](utils.md#ga715bfd49536d249ea7812a4114602db0), and  [MM\_NULLTAG](utils.md#ga64da80d889e56fc4dc22b0d8e07576cc). 

**Returns:**

The function can return 4 values:  [MM\_OK](utils.md#ga2d55c51901766d6400ea645cfaa56ad7),  [MM\_NOTOK](utils.md#ga6c6fa7e4345318cb7b7a12a6492f414b),  [MM\_NOMSG](utils.md#ga16ba492651e5414d28fbca6da09999e2), and  [MM\_NOCON](utils.md#ga47ee40d662d07179517362f5796fedc6). 



## fnmatch\(\)<a name="ga088b414f40eb0ce3dad9e5243816f68f"></a>

```
int fnmatch (const char * pattern, const char * string, int flags )
```

 **Description:**

Matches a file name or a path name. 

This function is used to check whether the value specified by  **string**  matches the value specified by  **pattern**. Wildcards can be used in  **pattern**, for example,  **./foo\***  and  **foo\*.boo\***. You can use  **flags**  to set your required matching rule. 

**Parameters:**

<a name="table905503103084824"></a>
<table><thead align="left"><tr id="row1990248959084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2022612855084824"><a name="p2022612855084824"></a><a name="p2022612855084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1325831637084824"><a name="p1325831637084824"></a><a name="p1325831637084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1292030163084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pattern</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the pattern to match. </td>
</tr>
<tr id="row745030431084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">string</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to match against <strong id="b1332384635084824"><a name="b1332384635084824"></a><a name="b1332384635084824"></a>pattern</strong>. </td>
</tr>
<tr id="row383468579084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">flags</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates a combination of flag bits that specify the matching rule. For details, see <a href="utils.md#ga0c050a8a7551c2ca86560396de3d20d0">FNM_NOESCAPE</a>, <a href="utils.md#gaed9e649990b20ba86e1aa7cacdc1bafe">FNM_PATHNAME</a>, <a href="utils.md#gaab98fecc02c06d6379bfcf416d6d297e">FNM_PERIOD</a>, <a href="utils.md#ga94f8f78b6d024e35c971dd3ec057140c">FNM_LEADING_DIR</a>, <a href="utils.md#gad41e3158a654dd4dfdab19d97745698a">FNM_CASEFOLD</a>, and <a href="utils.md#gad4df04c067e436af77a11440afbded0f">FNM_FILE_NAME</a>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the matching is successful; returns  [FNM\_NOMATCH](utils.md#gaf2661230e0cfc9970d6cdbe01571e753)  if the matching fails; returns a non-zero value if an error occurs. 



## fork\(\)<a name="gaa4e4714e6e8927c80b2553a40094b6d9"></a>

```
pid_t fork (void )
```

 **Description:**

Creates a new process that inherits from the user-mode data of its parent process. 

**Returns:**

Returns  **0**  in the child process and returns the ID of the created child process in the parent process if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table944855625084824"></a>
<table><thead align="left"><tr id="row565493215084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1731556311084824"><a name="p1731556311084824"></a><a name="p1731556311084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1178677887084824"><a name="p1178677887084824"></a><a name="p1178677887084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row2120846926084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p163540641084824"><a name="p163540641084824"></a><a name="p163540641084824"></a>EAGAIN </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1909914227084824"><a name="p1909914227084824"></a><a name="p1909914227084824"></a>Insufficient process or thread control blocks. </p>
</td>
</tr>
<tr id="row1832625855084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p939704536084824"><a name="p939704536084824"></a><a name="p939704536084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p177582777084824"><a name="p177582777084824"></a><a name="p177582777084824"></a>Insufficient memory. </p>
</td>
</tr>
</tbody>
</table>

## fputwc\(\)<a name="gab405f6ad88ebd1c6150206d19d3c7f12"></a>

```
wint_t fputwc (wchar_t wc, [FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream )
```

 **Description:**

Writes a wide character  **wc**  to a specified file stream. 

**Parameters:**

<a name="table862508222084824"></a>
<table><thead align="left"><tr id="row233002290084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1293517813084824"><a name="p1293517813084824"></a><a name="p1293517813084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1995289483084824"><a name="p1995289483084824"></a><a name="p1995289483084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row208215828084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character to write. </td>
</tr>
<tr id="row1647778465084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the wide character if the operation is successful; returns  **WEOF**  otherwise. 



## fputws\(\)<a name="gad3afb048298b1f152181fcac8e20d6e3"></a>

```
int fputws (const wchar_t * ws, [FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream )
```

 **Description:**

Writes a wide string pointed to by  **ws**  to a specified file stream. 

**Parameters:**

<a name="table1637797665084824"></a>
<table><thead align="left"><tr id="row1677277633084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p880931670084824"><a name="p880931670084824"></a><a name="p880931670084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1647822949084824"><a name="p1647822949084824"></a><a name="p1647822949084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row454344369084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ws</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide string to write. </td>
</tr>
<tr id="row178894625084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-negative value if the operation is successful; returns  **-1**  \(EOF\) otherwise. 



## free\(\)<a name="gafbedc913aa4651b3c3b4b3aecd9b4711"></a>

```
void free (void * ptr)
```

 **Description:**

Releases the memory space pointed to by  **ptr**. 

The memory space was allocated by using  [calloc\(\)](mem.md#ga62b7798461bd461da64c5f9d35feddf7),  [malloc\(\)](mem.md#ga7ac38fce3243a7dcf448301ee9ffd392), or  [realloc\(\)](mem.md#ga1a6b5e8d2f1c37e5b43e4345586075be). 

**Parameters:**

<a name="table91156404084824"></a>
<table><thead align="left"><tr id="row1144528264084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1636866518084824"><a name="p1636866518084824"></a><a name="p1636866518084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p392198785084824"><a name="p392198785084824"></a><a name="p392198785084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1926628719084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the memory space to be released. </td>
</tr>
</tbody>
</table>

## fsync\(\)<a name="ga9ba34c4ff72e21db486eedf77c2a18d0"></a>

```
int fsync (int fd)
```

 **Description:**

Synchronizes a file associated with a specified file descriptor to the storage device. 

**Parameters:**

<a name="table1286919345084824"></a>
<table><thead align="left"><tr id="row1036804234084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1094601507084824"><a name="p1094601507084824"></a><a name="p1094601507084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2138664064084824"><a name="p2138664064084824"></a><a name="p2138664064084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row622956377084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the descriptor of the file to be synchronized. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table561303677084824"></a>
<table><thead align="left"><tr id="row1601167047084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p370931516084824"><a name="p370931516084824"></a><a name="p370931516084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1554673879084824"><a name="p1554673879084824"></a><a name="p1554673879084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row2004290992084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1669192868084824"><a name="p1669192868084824"></a><a name="p1669192868084824"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p156579521084824"><a name="p156579521084824"></a><a name="p156579521084824"></a><strong id="b71320499084824"><a name="b71320499084824"></a><a name="b71320499084824"></a>fd</strong> is invalid. </p>
</td>
</tr>
<tr id="row1192569324084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p386081459084824"><a name="p386081459084824"></a><a name="p386081459084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p498560408084824"><a name="p498560408084824"></a><a name="p498560408084824"></a><strong id="b321896999084824"><a name="b321896999084824"></a><a name="b321896999084824"></a>fd</strong> is invalid for this device. </p>
</td>
</tr>
<tr id="row2079467774084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1151147155084824"><a name="p1151147155084824"></a><a name="p1151147155084824"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p283338180084824"><a name="p283338180084824"></a><a name="p283338180084824"></a>The operation is not supported. </p>
</td>
</tr>
</tbody>
</table>

## ftruncate\(\)<a name="ga0fb7c60877eacbfbd66eff04533ab0fe"></a>

```
int ftruncate (int fd, off_t length )
```

 **Description:**

Truncates a file to a specified length. 

**Parameters:**

<a name="table743915872084824"></a>
<table><thead align="left"><tr id="row1628690028084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p584710874084824"><a name="p584710874084824"></a><a name="p584710874084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1201234342084824"><a name="p1201234342084824"></a><a name="p1201234342084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row757071522084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file descriptor. </td>
</tr>
<tr id="row1884927987084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">length</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the file to be truncated. </td>
</tr>
</tbody>
</table>

**Attention:**

This function can be used only in the FAT file system based on the file descriptor. 

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1660828044084824"></a>
<table><thead align="left"><tr id="row1057709009084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1470654704084824"><a name="p1470654704084824"></a><a name="p1470654704084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1489735031084824"><a name="p1489735031084824"></a><a name="p1489735031084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row701458920084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1704490617084824"><a name="p1704490617084824"></a><a name="p1704490617084824"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2025620417084824"><a name="p2025620417084824"></a><a name="p2025620417084824"></a>The file has no write permission. </p>
</td>
</tr>
<tr id="row1496853209084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p84735320084824"><a name="p84735320084824"></a><a name="p84735320084824"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1142007319084824"><a name="p1142007319084824"></a><a name="p1142007319084824"></a>Failed to open the file in the specified path. </p>
</td>
</tr>
<tr id="row1767023630084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1129685239084824"><a name="p1129685239084824"></a><a name="p1129685239084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1455441980084824"><a name="p1455441980084824"></a><a name="p1455441980084824"></a>The target length is less than <strong id="b2007973043084824"><a name="b2007973043084824"></a><a name="b2007973043084824"></a>0</strong>. </p>
</td>
</tr>
<tr id="row1026565485084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p153006112084824"><a name="p153006112084824"></a><a name="p153006112084824"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1728119662084824"><a name="p1728119662084824"></a><a name="p1728119662084824"></a>The operation is not supported. </p>
</td>
</tr>
<tr id="row1516494836084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1925805471084824"><a name="p1925805471084824"></a><a name="p1925805471084824"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1103184026084824"><a name="p1103184026084824"></a><a name="p1103184026084824"></a>Failed to obtain the file structure corresponding to the file specified by <strong id="b243453730084824"><a name="b243453730084824"></a><a name="b243453730084824"></a>path</strong>, or the file access is rejected. </p>
</td>
</tr>
</tbody>
</table>

## fwide\(\)<a name="ga5438ce60b99b0455f356cd27726161ab"></a>

```
int fwide ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream, int mode )
```

 **Description:**

Sets and determines the orientation of the file stream. 

**Parameters:**

<a name="table1373031212084824"></a>
<table><thead align="left"><tr id="row1722107136084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2023136024084824"><a name="p2023136024084824"></a><a name="p2023136024084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1239635574084824"><a name="p1239635574084824"></a><a name="p1239635574084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1204581336084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
<tr id="row1810872523084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">mode</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the orientation of the stream. The value can be: A negative value indicating that the stream is byte-oriented A positive value indicating that the stream is wide-oriented <strong id="b2071888652084824"><a name="b2071888652084824"></a><a name="b2071888652084824"></a>0</strong> indicating that the stream orientation is not set </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a positive value if the stream is wide-oriented; returns a negative value if the stream is byte-oriented; returns  **0**  if the stream has no orientation. 



## fwprintf\(\)<a name="ga2b7ff2e4c9e4d1c0d6dc35bf93542d53"></a>

```
int fwprintf ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) *__restrict fp, const wchar_t *__restrict fmt,  ... )
```

 **Description:**

Prints wide character strings to a specified file stream. 

**Parameters:**

<a name="table1137692351084824"></a>
<table><thead align="left"><tr id="row96426684084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2049735451084824"><a name="p2049735451084824"></a><a name="p2049735451084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2090174672084824"><a name="p2090174672084824"></a><a name="p2090174672084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row886768242084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the stream to print data. </td>
</tr>
<tr id="row1151536631084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fmt</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the output format of the data. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of wide characters that are successfully printed; returns  **-1**  if the operation fails. 



## fwscanf\(\)<a name="ga1e39ec126230aed6ffa3e922be38a014"></a>

```
int fwscanf ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream, const wchar_t * format,  ... )
```

 **Description:**

Reads formatted data from a specified stream and stores it based on the wide string format into the locations pointed to by the variable arguments. 

**Parameters:**

<a name="table65238105084824"></a>
<table><thead align="left"><tr id="row779956568084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1422584371084824"><a name="p1422584371084824"></a><a name="p1422584371084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p953984788084824"><a name="p953984788084824"></a><a name="p953984788084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2090276112084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
<tr id="row2136986697084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string that may contain the format specifiers. </td>
</tr>
<tr id="row193781350084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">...</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the variable arguments storing the input data. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of variable arguments that are successfully stored. 



## gcvt\(\)<a name="gafabf46107539bb1ec32994c214b5eeba"></a>

```
char* gcvt (double x, int n, char * b )
```

 **Description:**

Converts a floating-point number to a string. 

**Parameters:**

<a name="table1275688607084824"></a>
<table><thead align="left"><tr id="row2060630055084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1031768822084824"><a name="p1031768822084824"></a><a name="p1031768822084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p175029493084824"><a name="p175029493084824"></a><a name="p175029493084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1085382054084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">x</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the floating-point number to convert. </td>
</tr>
<tr id="row1625627307084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of decimal places. </td>
</tr>
<tr id="row1099479757084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">b</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the output conversion result. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted string. 



## get\_current\_dir\_name\(\)<a name="gaa0cf2e9b2a054c6ea46db972840fbc51"></a>

```
char* get_current_dir_name (void )
```

 **Description:**

Obtains the name of the current working directory. 

**Returns:**

Returns the name of the current working directory if the operation is successful; returns  **NULL**  if the operation fails. 



## getcwd\(\)<a name="ga3284211bd28346254245c9d4fd071d7f"></a>

```
char* getcwd (char * buf, size_t size )
```

 **Description:**

Obtains the current working directory. 

**Parameters:**

<a name="table2073848316084824"></a>
<table><thead align="left"><tr id="row2107094675084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p982727957084824"><a name="p982727957084824"></a><a name="p982727957084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1784926365084824"><a name="p1784926365084824"></a><a name="p1784926365084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row297684821084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the buffer of the array for storing the absolute path name of the current working directory. </td>
</tr>
<tr id="row1354305512084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the array to which the buffer points. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **buf**  if the operation is successful; returns  **NULL**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table2048973920084824"></a>
<table><thead align="left"><tr id="row739979975084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1821600318084824"><a name="p1821600318084824"></a><a name="p1821600318084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1339496529084824"><a name="p1339496529084824"></a><a name="p1339496529084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row166143870084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1418045309084824"><a name="p1418045309084824"></a><a name="p1418045309084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p195719013084824"><a name="p195719013084824"></a><a name="p195719013084824"></a><strong id="b1928171298084824"><a name="b1928171298084824"></a><a name="b1928171298084824"></a>buf</strong> is set to <strong id="b2062390130084824"><a name="b2062390130084824"></a><a name="b2062390130084824"></a>NULL</strong>. </p>
</td>
</tr>
<tr id="row1515001755084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p346995891084824"><a name="p346995891084824"></a><a name="p346995891084824"></a>ERANGE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1103510155084824"><a name="p1103510155084824"></a><a name="p1103510155084824"></a><strong id="b552357156084824"><a name="b552357156084824"></a><a name="b552357156084824"></a>size</strong> is less than the length of the current working directory (including the terminating null byte \0). </p>
</td>
</tr>
<tr id="row2076185906084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1547977062084824"><a name="p1547977062084824"></a><a name="p1547977062084824"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p970481633084824"><a name="p970481633084824"></a><a name="p970481633084824"></a>Failed to copy the name of the current working directory to the buffer using <strong id="b1503826500084824"><a name="b1503826500084824"></a><a name="b1503826500084824"></a>memcpy_s</strong>. </p>
</td>
</tr>
</tbody>
</table>

## getegid\(\)<a name="ga3e7c694d68b4e62c1f275612d30b6d9d"></a>

```
gid_t getegid (void )
```

 **Description:**

Obtains the effective group ID \(GID\) of the calling process. 

**Returns:**

Returns the effective GID. 



## getenv\(\)<a name="gabc6595dbf6880c71628fecf0dbb23d66"></a>

```
char* getenv (const char * name)
```

 **Description:**

Obtains the value of an environment variable. 

**Parameters:**

<a name="table902498395084824"></a>
<table><thead align="left"><tr id="row826841326084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1910910772084824"><a name="p1910910772084824"></a><a name="p1910910772084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p753224299084824"><a name="p753224299084824"></a><a name="p753224299084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1249170786084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">name</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the name of the environment variable whose value needs to be obtained. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the environment variable value if the operation is successful; returns  **NULL**  if there is no match. 



## geteuid\(\)<a name="ga8b9a6dcf4e1d237f5607256dad93e26a"></a>

```
uid_t geteuid (void )
```

 **Description:**

Obtains the effective user ID \(UID\) of the calling process. 

**Returns:**

Returns the effective UID. 



## getgid\(\)<a name="ga58ca281cc6931c62e6a85e2edb5b4b49"></a>

```
gid_t getgid (void )
```

 **Description:**

Obtains the real group ID \(GID\) of the calling process. 

**Returns:**

Returns the real GID. 



## getgroups\(\)<a name="gaacfa67f2aef6be4baceace6a00856d21"></a>

```
int getgroups (int size, gid_t list[] )
```

 **Description:**

Obtains a list of supplementary user group IDs specific to the calling process. 

**Parameters:**

<a name="table1259357124084824"></a>
<table><thead align="left"><tr id="row382266047084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1403263653084824"><a name="p1403263653084824"></a><a name="p1403263653084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1067402517084824"><a name="p1067402517084824"></a><a name="p1067402517084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2040287431084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum size allowed for the supplementary group <strong id="b1982098425084824"><a name="b1982098425084824"></a><a name="b1982098425084824"></a>list</strong>. If the value is <strong id="b516857786084824"><a name="b516857786084824"></a><a name="b516857786084824"></a>0</strong>, this function obtains the total number of supplementary groups. </td>
</tr>
<tr id="row2059591815084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">list</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the list of supplementary groups. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of supplementary groups of the calling process if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1171609966084824"></a>
<table><thead align="left"><tr id="row2016562800084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p22984726084824"><a name="p22984726084824"></a><a name="p22984726084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p26974193084824"><a name="p26974193084824"></a><a name="p26974193084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1137920375084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1671984923084824"><a name="p1671984923084824"></a><a name="p1671984923084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1817607165084824"><a name="p1817607165084824"></a><a name="p1817607165084824"></a><strong id="b1281808835084824"><a name="b1281808835084824"></a><a name="b1281808835084824"></a>size</strong> is invalid. </p>
</td>
</tr>
<tr id="row1100438283084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p226274775084824"><a name="p226274775084824"></a><a name="p226274775084824"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1888384840084824"><a name="p1888384840084824"></a><a name="p1888384840084824"></a>Invalid address. </p>
</td>
</tr>
<tr id="row1671756864084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1112998074084824"><a name="p1112998074084824"></a><a name="p1112998074084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2081484891084824"><a name="p2081484891084824"></a><a name="p2081484891084824"></a>Insufficient memory. </p>
</td>
</tr>
</tbody>
</table>

## getopt\(\)<a name="ga5ffa4c677fc71cecd94f140ef9db624c"></a>

```
int getopt (int argc, char *const argv[], const char * optstring )
```

 **Description:**

Parses command-line arguments based on the specified option. 

**Parameters:**

<a name="table1098806017084824"></a>
<table><thead align="left"><tr id="row1649292039084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p829994267084824"><a name="p829994267084824"></a><a name="p829994267084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1726017188084824"><a name="p1726017188084824"></a><a name="p1726017188084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row792519107084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">argc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of arguments when the file of the function is executed. </td>
</tr>
<tr id="row312158260084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">argv</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the argument content when the file of the function is executed. </td>
</tr>
<tr id="row1005342030084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">optstring</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the string containing the optional arguments of the executable file. If this function obtains an option without arguments, the value of <strong id="b1876319321084824"><a name="b1876319321084824"></a><a name="b1876319321084824"></a>optind</strong> increases by 1. If this function obtains an option with arguments and the result is saved to <strong id="b1080492017084824"><a name="b1080492017084824"></a><a name="b1080492017084824"></a>optarg</strong>, the value of <strong id="b226152768084824"><a name="b226152768084824"></a><a name="b226152768084824"></a>optind</strong> increases by 2. </td>
</tr>
</tbody>
</table>

<a name="table189945281084824"></a>
<table><thead align="left"><tr id="row1050659601084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p711948757084824"><a name="p711948757084824"></a><a name="p711948757084824"></a>Character Option Expression </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p714093636084824"><a name="p714093636084824"></a><a name="p714093636084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row127117509084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1436262949084824"><a name="p1436262949084824"></a><a name="p1436262949084824"></a>Only characters that indicate different options are available. </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1178245606084824"><a name="p1178245606084824"></a><a name="p1178245606084824"></a><strong id="b1312330126084824"><a name="b1312330126084824"></a><a name="b1312330126084824"></a>abc</strong> indicates that the file has three options <strong id="b1023279198084824"><a name="b1023279198084824"></a><a name="b1023279198084824"></a>-a</strong>, <strong id="b1427164438084824"><a name="b1427164438084824"></a><a name="b1427164438084824"></a>-b</strong>, and <strong id="b107264302084824"><a name="b107264302084824"></a><a name="b107264302084824"></a>-c</strong>. </p>
</td>
</tr>
<tr id="row1848663913084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1706942594084824"><a name="p1706942594084824"></a><a name="p1706942594084824"></a>The character is followed by a colon. </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1034095373084824"><a name="p1034095373084824"></a><a name="p1034095373084824"></a><strong id="b923817419084824"><a name="b923817419084824"></a><a name="b923817419084824"></a>b</strong> indicates that <strong id="b1077243982084824"><a name="b1077243982084824"></a><a name="b1077243982084824"></a>-b</strong> must be followed by an argument in the executable file that contains the <strong id="b1682077375084824"><a name="b1682077375084824"></a><a name="b1682077375084824"></a><a href="utils.md#ga5ffa4c677fc71cecd94f140ef9db624c">getopt()</a></strong> function. </p>
</td>
</tr>
<tr id="row484231788084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p368220787084824"><a name="p368220787084824"></a><a name="p368220787084824"></a>The character is followed by two colons. </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p89975943084824"><a name="p89975943084824"></a><a name="p89975943084824"></a><strong id="b83677021084824"><a name="b83677021084824"></a><a name="b83677021084824"></a>b</strong> indicates that <strong id="b901070154084824"><a name="b901070154084824"></a><a name="b901070154084824"></a>-b</strong> can be followed by or without the corresponding argument in the executable file that contains the <strong id="b1244520647084824"><a name="b1244520647084824"></a><a name="b1244520647084824"></a><a href="utils.md#ga5ffa4c677fc71cecd94f140ef9db624c">getopt()</a></strong> function. </p>
</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the parsed option character if the parsing is successful; returns  **?**  if an option character that is not in  **optstring**  is encountered during parsing. When an option is encountered but there is no argument during parsing, this function returns  **:**  if the first character of  **optstring**  is a colon \(:\); returns  **?**  otherwise. Returns  **-1**  in the following cases: if all options have been parsed or  **argv\[optind\]**  is a null pointer; if the first character of the string to which  **argv\[optind\]**  points is not  **-**, that is, the non-option  **argv**  parameter cannot appear in the middle of the parameter list. If a non-option parameter is encountered during parsing, the parsing is terminated. if the string to which  **argv\[optind\]**  points is  **-**. 



## getopt\_long\(\)<a name="ga3d26a6a51c3a1576b36c66798a64a3cf"></a>

```
int getopt_long (int argc, char *const * argv, const char * optstring, const struct [option](option.md) * longopts, int * longindex )
```

 **Description:**

Parses the command-line arguments. 

**Parameters:**

<a name="table2050772908084824"></a>
<table><thead align="left"><tr id="row1372385470084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2062795584084824"><a name="p2062795584084824"></a><a name="p2062795584084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1039843007084824"><a name="p1039843007084824"></a><a name="p1039843007084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row358280361084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">argc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of command-line arguments. </td>
</tr>
<tr id="row507482222084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">argv</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the command-line argument content. </td>
</tr>
<tr id="row682994343084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">optstring</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the string containing the optional arguments of the executable file. </td>
</tr>
<tr id="row860567291084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">longopts</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the long argument structure. </td>
</tr>
<tr id="row790353331084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">longindex</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the index of the current long argument in <strong id="b1443502772084824"><a name="b1443502772084824"></a><a name="b1443502772084824"></a>longopts</strong>. </td>
</tr>
</tbody>
</table>

<a name="table1016555663084824"></a>
<table><thead align="left"><tr id="row881985456084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1147052856084824"><a name="p1147052856084824"></a><a name="p1147052856084824"></a>Character Option Expression </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p164327942084824"><a name="p164327942084824"></a><a name="p164327942084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1166046900084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1172116642084824"><a name="p1172116642084824"></a><a name="p1172116642084824"></a>Only characters that indicate different options are available. </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p877295738084824"><a name="p877295738084824"></a><a name="p877295738084824"></a><strong id="b429855317084824"><a name="b429855317084824"></a><a name="b429855317084824"></a>abc</strong> indicates that the file has three options <strong id="b661542935084824"><a name="b661542935084824"></a><a name="b661542935084824"></a>-a</strong>, <strong id="b1911264674084824"><a name="b1911264674084824"></a><a name="b1911264674084824"></a>-b</strong>, and <strong id="b1905936369084824"><a name="b1905936369084824"></a><a name="b1905936369084824"></a>-c</strong>. </p>
</td>
</tr>
<tr id="row1369032287084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p585710662084824"><a name="p585710662084824"></a><a name="p585710662084824"></a>The character is followed by a colon. </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p232013409084824"><a name="p232013409084824"></a><a name="p232013409084824"></a><strong id="b1714694289084824"><a name="b1714694289084824"></a><a name="b1714694289084824"></a>b</strong> indicates that <strong id="b1904635882084824"><a name="b1904635882084824"></a><a name="b1904635882084824"></a>-b</strong> must be followed by an argument in the executable file that contains the <strong id="b1481890403084824"><a name="b1481890403084824"></a><a name="b1481890403084824"></a><a href="utils.md#ga5ffa4c677fc71cecd94f140ef9db624c">getopt()</a></strong> function. </p>
</td>
</tr>
<tr id="row247432885084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p520717847084824"><a name="p520717847084824"></a><a name="p520717847084824"></a>The character is followed by two colons. </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p984506216084824"><a name="p984506216084824"></a><a name="p984506216084824"></a><strong id="b1774477076084824"><a name="b1774477076084824"></a><a name="b1774477076084824"></a>b</strong> indicates that <strong id="b371925317084824"><a name="b371925317084824"></a><a name="b371925317084824"></a>-b</strong> can be followed by or without the corresponding argument in the executable file that contains the <strong id="b1886130173084824"><a name="b1886130173084824"></a><a name="b1886130173084824"></a><a href="utils.md#ga5ffa4c677fc71cecd94f140ef9db624c">getopt()</a></strong> function. </p>
</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the parsed option character if the parsing is successful; returns  **-1**  if all options have been parsed; returns  **?**  if an option character that is not in  **optstring**  is encountered during parsing. When an option is encountered but there is no argument during parsing, this function returns  **:**  if the first character of  **optstring**  is a colon \(:\); returns  **?**  otherwise. 



## getopt\_long\_only\(\)<a name="ga6606cd658b7339db0fab03d3454bd29c"></a>

```
int getopt_long_only (int argc, char *const * argv, const char * optstring, const struct [option](option.md) * longopts, int * longindex )
```

 **Description:**

Parses the command-line arguments. 

**Parameters:**

<a name="table344880024084824"></a>
<table><thead align="left"><tr id="row1980685345084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p973679145084824"><a name="p973679145084824"></a><a name="p973679145084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2077760647084824"><a name="p2077760647084824"></a><a name="p2077760647084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1904469349084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">argc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of command-line arguments. </td>
</tr>
<tr id="row712567365084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">argv</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the command-line argument content. </td>
</tr>
<tr id="row1632124541084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">optstring</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the string containing the optional arguments of the executable file. </td>
</tr>
<tr id="row420062438084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">longopts</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the long argument structure. </td>
</tr>
<tr id="row1885384652084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">longindex</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the index of the current long argument in <strong id="b712539371084824"><a name="b712539371084824"></a><a name="b712539371084824"></a>longopts</strong>. </td>
</tr>
</tbody>
</table>

<a name="table1137350824084824"></a>
<table><thead align="left"><tr id="row709122268084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2017709665084824"><a name="p2017709665084824"></a><a name="p2017709665084824"></a>Character Option Expression </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p656957146084824"><a name="p656957146084824"></a><a name="p656957146084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row406613661084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1227474058084824"><a name="p1227474058084824"></a><a name="p1227474058084824"></a>Only characters that indicate different options are available. </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2102370323084824"><a name="p2102370323084824"></a><a name="p2102370323084824"></a><strong id="b2059744932084824"><a name="b2059744932084824"></a><a name="b2059744932084824"></a>abc</strong> indicates that the file has three options <strong id="b535729378084824"><a name="b535729378084824"></a><a name="b535729378084824"></a>-a</strong>, <strong id="b1439855755084824"><a name="b1439855755084824"></a><a name="b1439855755084824"></a>-b</strong>, and <strong id="b1308817481084824"><a name="b1308817481084824"></a><a name="b1308817481084824"></a>-c</strong>. </p>
</td>
</tr>
<tr id="row832550560084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1970339231084824"><a name="p1970339231084824"></a><a name="p1970339231084824"></a>The character is followed by a colon. </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1314664542084824"><a name="p1314664542084824"></a><a name="p1314664542084824"></a><strong id="b1018339343084824"><a name="b1018339343084824"></a><a name="b1018339343084824"></a>b</strong> indicates that <strong id="b1801531752084824"><a name="b1801531752084824"></a><a name="b1801531752084824"></a>-b</strong> must be followed by an argument in the executable file that contains the <strong id="b1985835969084824"><a name="b1985835969084824"></a><a name="b1985835969084824"></a><a href="utils.md#ga5ffa4c677fc71cecd94f140ef9db624c">getopt()</a></strong> function. </p>
</td>
</tr>
<tr id="row814209961084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1076866157084824"><a name="p1076866157084824"></a><a name="p1076866157084824"></a>The character is followed by two colons. </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1843081124084824"><a name="p1843081124084824"></a><a name="p1843081124084824"></a><strong id="b1353366198084824"><a name="b1353366198084824"></a><a name="b1353366198084824"></a>b</strong> indicates that <strong id="b1286277986084824"><a name="b1286277986084824"></a><a name="b1286277986084824"></a>-b</strong> can be followed by or without the corresponding argument in the executable file that contains the <strong id="b217458219084824"><a name="b217458219084824"></a><a name="b217458219084824"></a><a href="utils.md#ga5ffa4c677fc71cecd94f140ef9db624c">getopt()</a></strong> function. </p>
</td>
</tr>
</tbody>
</table>

**Attention:**

Different from  [getopt\_long](utils.md#ga3d26a6a51c3a1576b36c66798a64a3cf), this function matches  **–name**  and  **-name**  as long arguments. 

**Returns:**

Returns the parsed option character if the parsing is successful; returns  **-1**  if all options have been parsed; returns  **?**  if an option character that is not in  **optstring**  is encountered during parsing. When an option is encountered but there is no argument during parsing, this function returns  **:**  if the first character of  **optstring**  is a colon \(:\); returns  **?**  otherwise. 



## getpagesize\(\)<a name="ga638757347bd9bf886b3d442b98033cf1"></a>

```
int getpagesize (void )
```

 **Description:**

Obtains the memory page size. 

**Returns:**

Returns the number of bytes in a memory page. 



## getpgid\(\)<a name="ga48f523c98970793dfc2c5a05f6832006"></a>

```
pid_t getpgid (pid_t pid)
```

 **Description:**

Obtains the ID of the process group whose process ID is specified by  **pid**. 

**Parameters:**

<a name="table1562040224084824"></a>
<table><thead align="left"><tr id="row430349245084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1305186010084824"><a name="p1305186010084824"></a><a name="p1305186010084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p781492867084824"><a name="p781492867084824"></a><a name="p781492867084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row586093162084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the process ID. If the value is <strong id="b733023149084824"><a name="b733023149084824"></a><a name="b733023149084824"></a>0</strong>, the process group ID of the current process is obtained. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1946816681084824"></a>
<table><thead align="left"><tr id="row1837503337084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1731876364084824"><a name="p1731876364084824"></a><a name="p1731876364084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p872686396084824"><a name="p872686396084824"></a><a name="p872686396084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1591004686084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p385272959084824"><a name="p385272959084824"></a><a name="p385272959084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1338784730084824"><a name="p1338784730084824"></a><a name="p1338784730084824"></a>Invalid process ID. </p>
</td>
</tr>
<tr id="row82624558084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1506303299084824"><a name="p1506303299084824"></a><a name="p1506303299084824"></a>ESRCH </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1249135832084824"><a name="p1249135832084824"></a><a name="p1249135832084824"></a>The specified process cannot be found. </p>
</td>
</tr>
</tbody>
</table>

## getpgrp\(\)<a name="ga06f4ba65249f92cacdba5782a8d70eba"></a>

```
pid_t getpgrp (void )
```

 **Description:**

Obtains the ID of the process group of the calling process. 

**Returns:**

Returns the process group ID if the operation is successful. 



## getpid\(\)<a name="gac61b207337ca21b3b309593fd1a0cb82"></a>

```
pid_t getpid (void )
```

 **Description:**

Obtains the process ID. 

**Returns:**

Returns the process ID. 



## getppid\(\)<a name="gac6d7f7ade00dcdc302b0da5664eee812"></a>

```
pid_t getppid (void )
```

 **Description:**

Obtains the parent process ID. 

**Returns:**

Returns the parent process ID. 



## getresgid\(\)<a name="gaf74b37e12b6a9418c094479721e8cbf0"></a>

```
int getresgid (gid_t * rgid, gid_t * egid, gid_t * sgid )
```

 **Description:**

Obtains the real, effective, and saved user group IDs of the calling process. 

**Parameters:**

<a name="table1847067131084824"></a>
<table><thead align="left"><tr id="row1347645139084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1439044850084824"><a name="p1439044850084824"></a><a name="p1439044850084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p937788014084824"><a name="p937788014084824"></a><a name="p937788014084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1877589978084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">rgid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the real user group ID. </td>
</tr>
<tr id="row1373843369084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">egid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the effective user group ID. </td>
</tr>
<tr id="row803734070084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">sgid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the saved user group ID. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1564021774084824"></a>
<table><thead align="left"><tr id="row561194068084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p980134118084824"><a name="p980134118084824"></a><a name="p980134118084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p67152868084824"><a name="p67152868084824"></a><a name="p67152868084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row368802448084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p799920641084824"><a name="p799920641084824"></a><a name="p799920641084824"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p143822775084824"><a name="p143822775084824"></a><a name="p143822775084824"></a>Invalid address. </p>
</td>
</tr>
</tbody>
</table>

## getresuid\(\)<a name="ga4e92f1f4fb48c6fa8cd15d328950bc68"></a>

```
int getresuid (uid_t * ruid, uid_t * euid, uid_t * suid )
```

 **Description:**

Obtains the real, effective, and saved user IDs of the calling process. 

**Parameters:**

<a name="table2123151057084824"></a>
<table><thead align="left"><tr id="row1671206515084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2001316364084824"><a name="p2001316364084824"></a><a name="p2001316364084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p260544929084824"><a name="p260544929084824"></a><a name="p260544929084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1937501925084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ruid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the real user ID. </td>
</tr>
<tr id="row1445136246084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">euid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the effective user ID. </td>
</tr>
<tr id="row1468549341084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">suid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the saved user ID. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table407793298084824"></a>
<table><thead align="left"><tr id="row323289202084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1943471621084824"><a name="p1943471621084824"></a><a name="p1943471621084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1059322532084824"><a name="p1059322532084824"></a><a name="p1059322532084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row562526769084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p217059922084824"><a name="p217059922084824"></a><a name="p217059922084824"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p976566999084824"><a name="p976566999084824"></a><a name="p976566999084824"></a>Invalid address. </p>
</td>
</tr>
</tbody>
</table>

## getsubopt\(\)<a name="ga2959446c8426187f340f8d5a625bf2e6"></a>

```
int getsubopt (char ** optionp, char *const * tokens, char ** valuep )
```

 **Description:**

Processes the parameters of an option in the command line. 

Generally, this function is used together with the  [getopt\(\)](utils.md#ga5ffa4c677fc71cecd94f140ef9db624c)  to process the parameters of an option. You are advised to use this function if the parameters of an option are complex. 

**Parameters:**

<a name="table665187469084824"></a>
<table><thead align="left"><tr id="row537409988084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1604532191084824"><a name="p1604532191084824"></a><a name="p1604532191084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2107941526084824"><a name="p2107941526084824"></a><a name="p2107941526084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1692896030084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">optionp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the command word option. </td>
</tr>
<tr id="row2052685144084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tokens</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the queried token. </td>
</tr>
<tr id="row884881890084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">valuep</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the suboption of the command word value. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the index of the matched suboption element in  **tokens**  if the operation is successful; returns  **-1**  if the operation fails.  [1.0 1.0 ](utils.md#ga5ffa4c677fc71cecd94f140ef9db624c) 

## getuid\(\)<a name="ga2f517436c22ef73337d3de4920908c6c"></a>

```
uid_t getuid (void )
```

 **Description:**

Obtains the real user ID \(UID\) of the calling process. 

**Returns:**

Returns the real UID. 



## getwc\(\)<a name="gaadd2028a176fe13a0d6090cec651a369"></a>

```
wint_t getwc ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream)
```

 **Description:**

Reads the first wide character from a specified file stream. 

**Parameters:**

<a name="table1825689885084824"></a>
<table><thead align="left"><tr id="row1954067139084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p507222931084824"><a name="p507222931084824"></a><a name="p507222931084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p476832086084824"><a name="p476832086084824"></a><a name="p476832086084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row363302458084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Attention:**

This function is similar to  [fgetwc](utils.md#ga2b545d8d6d3209a2eb6129d8ba646fe3)  except that it is implemented as a macro. 

**Returns:**

Returns the wide character if the operation is successful; returns  **WEOF**  if an error occurs. 



## getwchar\(\)<a name="gaa1379ae6936df3415301dc580aa8756e"></a>

```
wint_t getwchar (void )
```

 **Description:**

Reads a wide character from the stdin. 

**Attention:**

For details about unlocked objects, see  **unlocked\_stdio**. 

**Returns:**

Returns the wide character if the operation is successful; returns  **WEOF**  if an error occurs. 



## hcreate\(\)<a name="gafb18cb23be808765135c3aa903df62fd"></a>

```
int hcreate (size_t nel)
```

 **Description:**

Creates a hash table based on the number of entries. 

 

**Parameters:**

<a name="table1947756001084824"></a>
<table><thead align="left"><tr id="row1798845130084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p339551079084824"><a name="p339551079084824"></a><a name="p339551079084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1053473683084824"><a name="p1053473683084824"></a><a name="p1053473683084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1331777666084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nel</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum number of entries allowed in the hash table. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  and sets  **errno**  to a value if the operation fails. 



## hcreate\_r\(\)<a name="ga038ec523340da68e90a5f22e1e4e5520"></a>

```
int hcreate_r (size_t nel, struct [hsearch_data](hsearch_data.md) * htab )
```

 **Description:**

Creates a hash table based on the number of entries and its description. 

**Parameters:**

<a name="table1792582859084824"></a>
<table><thead align="left"><tr id="row1249065840084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p875973499084824"><a name="p875973499084824"></a><a name="p875973499084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1603535640084824"><a name="p1603535640084824"></a><a name="p1603535640084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1378771632084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nel</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum number of entries allowed in the hash table. </td>
</tr>
<tr id="row309468469084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">htab</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the hash table. </td>
</tr>
</tbody>
</table>

**Attention:**

The hash table must be initialized before use. 

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  and sets  **errno**  to a value if the operation fails. 



## hdestroy\(\)<a name="ga883c8dedada64c9525c78bfa56ad69bf"></a>

```
void hdestroy (void )
```

 **Description:**

Destroys a hash table. 

This function releases the memory for creating a hash table. 

## hdestroy\_r\(\)<a name="gafb5169db08a09e98495c26bdd7e6d8dc"></a>

```
void hdestroy_r (struct [hsearch_data](hsearch_data.md) * htab)
```

 **Description:**

Destroys a hash table. 

This function releases the memory occupied by the specified hash table. 

**Parameters:**

<a name="table344486447084824"></a>
<table><thead align="left"><tr id="row1559474417084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1090124002084824"><a name="p1090124002084824"></a><a name="p1090124002084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1974109031084824"><a name="p1974109031084824"></a><a name="p1974109031084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row298130332084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">htab</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the hash table. </td>
</tr>
</tbody>
</table>

## hsearch\(\)<a name="ga8082cd062e20579f6a981bb73963b3f4"></a>

```
[ENTRY](utils.md#gaf609835b21489409e39a22ed20313ab8)* hsearch ([ENTRY](utils.md#gaf609835b21489409e39a22ed20313ab8) item, ACTION action )
```

 **Description:**

Adds or searches for a hash entry. 

This function searches for the entry in the hash table based on the specified action. If the action is  **FIND**, only the search action is performed. If the action is  **ENTER**, an entry not found is added to the hash table. 

**Parameters:**

<a name="table160230254084824"></a>
<table><thead align="left"><tr id="row1692773981084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1579513077084824"><a name="p1579513077084824"></a><a name="p1579513077084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1408501907084824"><a name="p1408501907084824"></a><a name="p1408501907084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row428305935084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">item</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the hash table entry to be searched. </td>
</tr>
<tr id="row1545630708084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">action</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the function action. <strong id="b780812887084824"><a name="b780812887084824"></a><a name="b780812887084824"></a>ENTER</strong> indicates that an entry is added, and <strong id="b1075328993084824"><a name="b1075328993084824"></a><a name="b1075328993084824"></a>FIND</strong> indicates that an entry is searched. For details, see <strong id="b1083196690084824"><a name="b1083196690084824"></a><a name="b1083196690084824"></a>ACTION</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the hash table if the operation is successful. 



## hsearch\_r\(\)<a name="ga22072d94699358ab02286f4c7b6aac55"></a>

```
int hsearch_r ([ENTRY](utils.md#gaf609835b21489409e39a22ed20313ab8) item, ACTION action, [ENTRY](utils.md#gaf609835b21489409e39a22ed20313ab8) ** retval, struct [hsearch_data](hsearch_data.md) * htab )
```

 **Description:**

Searches for a hash table. 

This function searches for the entry in the hash table based on the specified action. If the action is  **FIND**, only the search action is performed. If the action is  **ENTER**, an entry not found is added to the hash table. 

**Parameters:**

<a name="table1650764558084824"></a>
<table><thead align="left"><tr id="row2065724025084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p117125925084824"><a name="p117125925084824"></a><a name="p117125925084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1722349688084824"><a name="p1722349688084824"></a><a name="p1722349688084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row423302145084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">item</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the hash table entry to be searched. </td>
</tr>
<tr id="row928613806084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">action</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the function action. <strong id="b929139737084824"><a name="b929139737084824"></a><a name="b929139737084824"></a>ENTER</strong> indicates that an entry is added, and <strong id="b889171325084824"><a name="b889171325084824"></a><a name="b889171325084824"></a>FIND</strong> indicates that an entry is searched. <strong id="b1215143156084824"><a name="b1215143156084824"></a><a name="b1215143156084824"></a>ACTION</strong> </td>
</tr>
<tr id="row816587207084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">htab</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the hash table. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  if the operation fails. 



## imaxabs\(\)<a name="gad9e8a565a34b6981f500d88773ec7bcd"></a>

```
intmax_t imaxabs (intmax_t j)
```

 **Description:**

Calculates the absolute value of an input parameter of the integer type. 

This function is used to calculate the absolute value of the input parameter specified by  **j**  of the  **intmax\_t**  type. 

**Parameters:**

<a name="table1998978067084824"></a>
<table><thead align="left"><tr id="row81796573084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1406958770084824"><a name="p1406958770084824"></a><a name="p1406958770084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1221155823084824"><a name="p1221155823084824"></a><a name="p1221155823084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row731669825084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">j</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the input parameter. </td>
</tr>
</tbody>
</table>

**Attention:**

Pay attention to the parameter type. 

**Returns:**

Returns the absolute value of the input parameter if the operation is successful. 



## imaxdiv\(\)<a name="ga17335f74f0abcfd3047de48f6823f527"></a>

```
[imaxdiv_t](imaxdiv_t.md) imaxdiv (intmax_t numerator, intmax_t denominator )
```

 **Description:**

Calculates the quotient and remainder after the division operation is performed on an integer. 

**Parameters:**

<a name="table106814744084824"></a>
<table><thead align="left"><tr id="row1176944870084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1841503149084824"><a name="p1841503149084824"></a><a name="p1841503149084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p696282723084824"><a name="p696282723084824"></a><a name="p696282723084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row582806083084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">numerator</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the numerator. </td>
</tr>
<tr id="row1615767708084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">denominator</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the denominator. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a structure variable that has been defined in the function. 



## index\(\)<a name="ga1d3748ca570dcb09a2fb28e8015107dd"></a>

```
char* index (const char * s, int c )
```

 **Description:**

Searches for the first position of the matched character in a string. 

**Parameters:**

<a name="table792383554084824"></a>
<table><thead align="left"><tr id="row895276031084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1211538104084824"><a name="p1211538104084824"></a><a name="p1211538104084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1403686609084824"><a name="p1403686609084824"></a><a name="p1403686609084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2067627208084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to be searched. </td>
</tr>
<tr id="row2089335191084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the character to be matched. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the matched character if the operation is successful; returns  **NULL**  if the operation fails. 



## initstate\(\)<a name="ga9250c684f653b1bd715bab29d35d2423"></a>

```
char* initstate (unsigned int seed, char * state, size_t n )
```

 **Description:**

Initializes a random number generator. 

This function initializes the state array for subsequent random use. 

**Parameters:**

<a name="table1157584083084824"></a>
<table><thead align="left"><tr id="row764809315084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p445895371084824"><a name="p445895371084824"></a><a name="p445895371084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1981816002084824"><a name="p1981816002084824"></a><a name="p1981816002084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row800325825084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">seed</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the seed for initialization, which specifies the start point of the random number sequence and provides the information for restarting at the same point. </td>
</tr>
<tr id="row1230624283084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">Indicates</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">the state array used to generate random numbers. </td>
</tr>
<tr id="row2068317991084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the state array. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the state array if the operation is successful; returns  **NULL**  if the operation fails. 



## insque\(\)<a name="ga7dc680d5d6d07984f96737c220058d64"></a>

```
void insque (void * element, void * pred )
```

 **Description:**

Adds an entry to a queue. 

**Parameters:**

<a name="table604568975084824"></a>
<table><thead align="left"><tr id="row663293236084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1253469757084824"><a name="p1253469757084824"></a><a name="p1253469757084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1777899455084824"><a name="p1777899455084824"></a><a name="p1777899455084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row94752571084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">element</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the <strong id="b2106110832084824"><a name="b2106110832084824"></a><a name="b2106110832084824"></a>element</strong> to be added to the queue. </td>
</tr>
<tr id="row1159263476084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pred</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">After the position of <strong id="b452867874084824"><a name="b452867874084824"></a><a name="b452867874084824"></a>prev</strong> to add the <strong id="b549409947084824"><a name="b549409947084824"></a><a name="b549409947084824"></a>element</strong>. </td>
</tr>
</tbody>
</table>

## isalnum\(\)<a name="gadf38e126f73a010f30af76db2a28c6e1"></a>

```
int isalnum (int c)
```

 **Description:**

Checks whether a parameter is an alphabetic character or a decimal digit. 

**Parameters:**

<a name="table4505140084824"></a>
<table><thead align="left"><tr id="row1827705766084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2015486735084824"><a name="p2015486735084824"></a><a name="p2015486735084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1042400947084824"><a name="p1042400947084824"></a><a name="p1042400947084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row259309037084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is an alphabetic character or a decimal digit; returns  **0**  otherwise. 



## isalnum\_l\(\)<a name="gad87736859769a262b411b49819bc7a25"></a>

```
int isalnum_l (int c, locale_t locale )
```

 **Description:**

Checks whether a parameter is an alphabetic character or digit for the specified locale. 

**Parameters:**

<a name="table1718587060084824"></a>
<table><thead align="left"><tr id="row30801162084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p218615574084824"><a name="p218615574084824"></a><a name="p218615574084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p847331642084824"><a name="p847331642084824"></a><a name="p847331642084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row858194751084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
<tr id="row1405898854084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is an alphabetic character or digit; returns  **0**  otherwise. 



## isalpha\(\)<a name="ga25908ae63aac2df990634e1ae5bd14d9"></a>

```
int isalpha (int c)
```

 **Description:**

Checks whether a parameter is an alphabetic character. 

**Parameters:**

<a name="table1910254258084824"></a>
<table><thead align="left"><tr id="row1729772612084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2089240293084824"><a name="p2089240293084824"></a><a name="p2089240293084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p13207475084824"><a name="p13207475084824"></a><a name="p13207475084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row131474595084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is an alphabetic character; returns  **0**  otherwise. 



## isalpha\_l\(\)<a name="ga6de33cb463fb34283dc5c7c4c230aec4"></a>

```
int isalpha_l (int c, locale_t locale )
```

 **Description:**

Checks whether a parameter is an alphabetic character for the specified locale. 

**Parameters:**

<a name="table1842781941084824"></a>
<table><thead align="left"><tr id="row181972897084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1217634128084824"><a name="p1217634128084824"></a><a name="p1217634128084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1664188016084824"><a name="p1664188016084824"></a><a name="p1664188016084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row675386106084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
<tr id="row2145024308084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is an alphabetic character; returns  **0**  otherwise. 



## isblank\(\)<a name="gaea4929b1b41f1a6d723e0312b1f050ed"></a>

```
int isblank (int c)
```

 **Description:**

Checks whether a parameter is a blank character \(space or tap\). 

**Parameters:**

<a name="table155004246084824"></a>
<table><thead align="left"><tr id="row172065805084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1390244248084824"><a name="p1390244248084824"></a><a name="p1390244248084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1828119666084824"><a name="p1828119666084824"></a><a name="p1828119666084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1869769226084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is a blank character; returns  **0**  otherwise. 



## isblank\_l\(\)<a name="ga650853c2fb9fcf2e9c34ac06e1f6f2d6"></a>

```
int isblank_l (int c, locale_t locale )
```

 **Description:**

Checks whether a parameter is a blank character \(including spaces and tabs\) for the specified locale. 

**Parameters:**

<a name="table483270359084824"></a>
<table><thead align="left"><tr id="row1479141293084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p228345909084824"><a name="p228345909084824"></a><a name="p228345909084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1158294151084824"><a name="p1158294151084824"></a><a name="p1158294151084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row558774281084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
<tr id="row748962889084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is a blank character; returns  **0**  otherwise. 



## iscntrl\(\)<a name="ga0008a4e8e7889734dc1d83297de07158"></a>

```
int iscntrl (int c)
```

 **Description:**

Checks whether a parameter is a control character. A control character is invisible and does not occupy a printing position on a display. 

**Parameters:**

<a name="table2103688969084824"></a>
<table><thead align="left"><tr id="row98211945084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1161631507084824"><a name="p1161631507084824"></a><a name="p1161631507084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p229186599084824"><a name="p229186599084824"></a><a name="p229186599084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row935889889084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is a control character; returns  **0**  otherwise. 



## iscntrl\_l\(\)<a name="gad475d7607e183036b0add584bdf61b35"></a>

```
int iscntrl_l (int c, locale_t locale )
```

 **Description:**

Checks whether a parameter is a control character for the specified locale. 

A control character is invisible and does not occupy a printing position on a display. 

**Parameters:**

<a name="table2063310980084824"></a>
<table><thead align="left"><tr id="row1533696613084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1710544833084824"><a name="p1710544833084824"></a><a name="p1710544833084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1251265560084824"><a name="p1251265560084824"></a><a name="p1251265560084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row114141379084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
<tr id="row573758481084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is a control character; returns  **0**  otherwise. 



## isdigit\(\)<a name="ga3fa45b35c8abf67a950b6d3d4063dede"></a>

```
int isdigit (int c)
```

 **Description:**

Checks whether a parameter is a decimal digit \(0-9\). 

**Parameters:**

<a name="table1847536262084824"></a>
<table><thead align="left"><tr id="row1588984491084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1154734394084824"><a name="p1154734394084824"></a><a name="p1154734394084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1346815092084824"><a name="p1346815092084824"></a><a name="p1346815092084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1972447798084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is a decimal digit; returns  **0**  otherwise. 



## isdigit\_l\(\)<a name="ga378e9ee0e69cbbb9ed948598f9aa920d"></a>

```
int isdigit_l (int c, locale_t locale )
```

 **Description:**

Checks whether a parameter is a decimal digit for the specified locale. 

**Parameters:**

<a name="table802563748084824"></a>
<table><thead align="left"><tr id="row1665857867084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p48724270084824"><a name="p48724270084824"></a><a name="p48724270084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1398270789084824"><a name="p1398270789084824"></a><a name="p1398270789084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2137190591084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
<tr id="row781003364084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is a decimal digit; returns  **0**  otherwise. 



## isgraph\(\)<a name="ga49f40fd869fd0c90e4497fda08c89561"></a>

```
int isgraph (int c)
```

 **Description:**

Checks whether a parameter is any printable character except the space character. 

**Parameters:**

<a name="table472199213084824"></a>
<table><thead align="left"><tr id="row1248171170084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p840293923084824"><a name="p840293923084824"></a><a name="p840293923084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p471073089084824"><a name="p471073089084824"></a><a name="p471073089084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1425500187084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is a printable character except the space character; returns  **0**  otherwise. 



## isgraph\_l\(\)<a name="gaab3732d493eec8b0c0a720d90dba210c"></a>

```
int isgraph_l (int c, locale_t locale )
```

 **Description:**

Checks whether a parameter is any printable character except the space character for the specified locale. 

**Parameters:**

<a name="table1237493258084824"></a>
<table><thead align="left"><tr id="row827787684084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1620732334084824"><a name="p1620732334084824"></a><a name="p1620732334084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1874895363084824"><a name="p1874895363084824"></a><a name="p1874895363084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1289898088084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
<tr id="row1015425420084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is a printable character except the space character; returns  **0**  otherwise. 



## islower\(\)<a name="ga7b8f652a0423a80922dd89d8829db5f2"></a>

```
int islower (int c)
```

 **Description:**

Checks whether a parameter is a lowercase letter. 

**Parameters:**

<a name="table552471203084824"></a>
<table><thead align="left"><tr id="row713796917084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1185509163084824"><a name="p1185509163084824"></a><a name="p1185509163084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p716551670084824"><a name="p716551670084824"></a><a name="p716551670084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2134349366084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is a lowercase letter; returns  **0**  otherwise. 



## islower\_l\(\)<a name="gad7c9319bbe71c048505cd30da34334ea"></a>

```
int islower_l (int c, locale_t locale )
```

 **Description:**

Checks whether a parameter is a character of lowercase letters for the specified locale. 

**Parameters:**

<a name="table2035241788084824"></a>
<table><thead align="left"><tr id="row2014491744084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1708192541084824"><a name="p1708192541084824"></a><a name="p1708192541084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1975768830084824"><a name="p1975768830084824"></a><a name="p1975768830084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row439654449084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
<tr id="row2143182778084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is a lowercase letter; returns  **0**  otherwise. 



## isprint\(\)<a name="ga99355d8f0fb41ec43effb95189db0ed4"></a>

```
int isprint (int c)
```

 **Description:**

Checks whether a parameter is a printable character \(including space\). 

A printable character is a character that occupies a printing position on a display. 

**Parameters:**

<a name="table1120134626084824"></a>
<table><thead align="left"><tr id="row1429358688084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1416623501084824"><a name="p1416623501084824"></a><a name="p1416623501084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p618611197084824"><a name="p618611197084824"></a><a name="p618611197084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2032986681084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is a printable character; returns  **0**  otherwise. 



## isprint\_l\(\)<a name="gaaae36b62a22be9fa67640255ae77ee0d"></a>

```
int isprint_l (int c, locale_t locale )
```

 **Description:**

Checks whether a parameter is a printable character \(including space\) for the specified locale. A printable character is visible and occupies a printing position on a display. 

**Parameters:**

<a name="table535495040084824"></a>
<table><thead align="left"><tr id="row1743291898084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1615017011084824"><a name="p1615017011084824"></a><a name="p1615017011084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1701829937084824"><a name="p1701829937084824"></a><a name="p1701829937084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row458407951084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
<tr id="row1672224287084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is a printable character; returns  **0**  otherwise. 



## ispunct\(\)<a name="gaf29554b3ec04ea7684482bffed5dbce6"></a>

```
int ispunct (int c)
```

 **Description:**

Checks whether a parameter is a punctuation or special character. 

**Parameters:**

<a name="table1990854312084824"></a>
<table><thead align="left"><tr id="row574038404084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p71663929084824"><a name="p71663929084824"></a><a name="p71663929084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2116350328084824"><a name="p2116350328084824"></a><a name="p2116350328084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1291167409084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is a punctuation or special character; returns  **0**  otherwise. 



## ispunct\_l\(\)<a name="gaa04b7d22f0c24a9aa5a6f12e933405f8"></a>

```
int ispunct_l (int c, locale_t locale )
```

 **Description:**

Checks whether a parameter is a punctuation or special character for the specified locale. 

**Parameters:**

<a name="table146274550084824"></a>
<table><thead align="left"><tr id="row1609077624084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p616342239084824"><a name="p616342239084824"></a><a name="p616342239084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1417818158084824"><a name="p1417818158084824"></a><a name="p1417818158084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1325761470084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
<tr id="row1364516763084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is a punctuation or special character; returns  **0**  otherwise. 



## isspace\(\)<a name="ga56be4166e4673843042a548a7f513dbc"></a>

```
int isspace (int c)
```

 **Description:**

Checks whether a parameter is a space character. 

The space characters are: space, horizontal tab \(**\\t**\), vertical tab \(**\\v**\), form feed \(**\\f**\), carriage return \(**\\r**\), and line feed \(** **\). 

**Parameters:**

<a name="table115064873084824"></a>
<table><thead align="left"><tr id="row70248879084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p706238854084824"><a name="p706238854084824"></a><a name="p706238854084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p131540488084824"><a name="p131540488084824"></a><a name="p131540488084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1538116175084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is a space character; returns  **0**  otherwise. 



## isspace\_l\(\)<a name="ga6a6e04048d6363a76a333d17cac62f8a"></a>

```
int isspace_l (int c, locale_t locale )
```

 **Description:**

Checks whether a parameter is a blank character for the specified locale. 

Blank characters refer to space, horizontal tab \(**\\t**\), vertical tab \(**\\v**\), form feed \(**\\f**\), carriage return \(**\\r**\), and line feed \(** **\). 

**Parameters:**

<a name="table1489912128084824"></a>
<table><thead align="left"><tr id="row8916537084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1515170588084824"><a name="p1515170588084824"></a><a name="p1515170588084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p453904930084824"><a name="p453904930084824"></a><a name="p453904930084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row902769697084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
<tr id="row568604475084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is a blank character; returns  **0**  otherwise. 



## isupper\(\)<a name="gadadd6582d46775aab6a51e29d16d9f77"></a>

```
int isupper (int c)
```

 **Description:**

Checks whether a parameter is an uppercase letter. 

**Parameters:**

<a name="table1767653739084824"></a>
<table><thead align="left"><tr id="row1753533067084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1383654145084824"><a name="p1383654145084824"></a><a name="p1383654145084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p355815585084824"><a name="p355815585084824"></a><a name="p355815585084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1010863238084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is an uppercase letter; returns  **0**  otherwise. 



## isupper\_l\(\)<a name="gae10ce576a584fe302d364196d48332c6"></a>

```
int isupper_l (int c, locale_t locale )
```

 **Description:**

Checks whether a parameter is a character of uppercase letters for the specified locale. 

**Parameters:**

<a name="table1693476440084824"></a>
<table><thead align="left"><tr id="row251871597084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p285947765084824"><a name="p285947765084824"></a><a name="p285947765084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1668806667084824"><a name="p1668806667084824"></a><a name="p1668806667084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1475016620084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
<tr id="row2097551475084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is in uppercase; returns  **0**  otherwise. 



## iswalnum\(\)<a name="gadafb512a79ac9274486d6ddbbbd9d9ba"></a>

```
int iswalnum (wint_t wc)
```

 **Description:**

Checks whether a wide character is a letter or digit. 

**Parameters:**

<a name="table713910786084824"></a>
<table><thead align="left"><tr id="row2104583883084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p535628993084824"><a name="p535628993084824"></a><a name="p535628993084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1102919300084824"><a name="p1102919300084824"></a><a name="p1102919300084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1274978563084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswalnum\_l\(\)<a name="ga8d6ca21d11b21620ff32e32ebc5b251a"></a>

```
int iswalnum_l (wint_t wc, locale_t locale )
```

 **Description:**

Checks whether a wide character is a letter or digit for the specified locale. 

**Parameters:**

<a name="table437582769084824"></a>
<table><thead align="left"><tr id="row524829204084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p211996894084824"><a name="p211996894084824"></a><a name="p211996894084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p261628540084824"><a name="p261628540084824"></a><a name="p261628540084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1707939490084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
<tr id="row364309828084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswalpha\(\)<a name="ga72477b4f142de340164deb7bf5a7ae7b"></a>

```
int iswalpha (wint_t wc)
```

 **Description:**

Checks whether a wide character is a letter. 

**Parameters:**

<a name="table2051453566084824"></a>
<table><thead align="left"><tr id="row694266492084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2012182332084824"><a name="p2012182332084824"></a><a name="p2012182332084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1327261347084824"><a name="p1327261347084824"></a><a name="p1327261347084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1415627865084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswalpha\_l\(\)<a name="gadfbb99771f4af02201ef68fc2377164b"></a>

```
int iswalpha_l (wint_t wc, locale_t locale )
```

 **Description:**

Checks whether a wide character is alphabetic for the specified locale. 

**Parameters:**

<a name="table789603582084824"></a>
<table><thead align="left"><tr id="row891365453084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1158478872084824"><a name="p1158478872084824"></a><a name="p1158478872084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1160255615084824"><a name="p1160255615084824"></a><a name="p1160255615084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row578165322084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
<tr id="row1503504240084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswblank\(\)<a name="ga934cbdaad02f3df1b03e566103a5a118"></a>

```
int iswblank (wint_t wc)
```

 **Description:**

Checks whether a wide character is a space or tab character \(\\t\). 

**Parameters:**

<a name="table1094933376084824"></a>
<table><thead align="left"><tr id="row1350643499084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p785914605084824"><a name="p785914605084824"></a><a name="p785914605084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p797719148084824"><a name="p797719148084824"></a><a name="p797719148084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row351213875084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswblank\_l\(\)<a name="ga7d5300cc6bbc4ba910a3f9b4d9da2f4d"></a>

```
int iswblank_l (wint_t wc, locale_t locale )
```

 **Description:**

Checks whether a wide character is a blank or  **\\t**  character for the specified locale. 

**Parameters:**

<a name="table1301834336084824"></a>
<table><thead align="left"><tr id="row1991295598084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p610750390084824"><a name="p610750390084824"></a><a name="p610750390084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p200888794084824"><a name="p200888794084824"></a><a name="p200888794084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2101593647084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
<tr id="row120580841084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswcntrl\(\)<a name="ga35f4bb15841d36c759ab271aa8033ba8"></a>

```
int iswcntrl (wint_t wc)
```

 **Description:**

Checks whether a wide character is a control character. 

**Parameters:**

<a name="table1821866401084824"></a>
<table><thead align="left"><tr id="row1871104595084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1306289613084824"><a name="p1306289613084824"></a><a name="p1306289613084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1790895222084824"><a name="p1790895222084824"></a><a name="p1790895222084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1896825833084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswcntrl\_l\(\)<a name="ga51c189ba9f96d6ed8207da1da81100ca"></a>

```
int iswcntrl_l (wint_t wc, locale_t locale )
```

 **Description:**

Checks whether a wide character is a control character for the specified locale. 

**Parameters:**

<a name="table1906095506084824"></a>
<table><thead align="left"><tr id="row1802381481084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p602603494084824"><a name="p602603494084824"></a><a name="p602603494084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1378430893084824"><a name="p1378430893084824"></a><a name="p1378430893084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row908145042084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
<tr id="row737084679084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswctype\(\)<a name="gae7bade1da794a7950ad25da75e43ad39"></a>

```
int iswctype (wint_t wc, wctype_t desc )
```

 **Description:**

Checks whether the character specified by  **wc**  belongs to the  **desc**  class. 

**Parameters:**

<a name="table1045873217084824"></a>
<table><thead align="left"><tr id="row1334130856084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p557733468084824"><a name="p557733468084824"></a><a name="p557733468084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1381110654084824"><a name="p1381110654084824"></a><a name="p1381110654084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1450044044084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
<tr id="row1460597771084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">desc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character class. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswctype\_l\(\)<a name="ga0f3b0048ef4d82840c1f7d1c78e25e6b"></a>

```
int iswctype_l (wint_t wc, wctype_t desc, locale_t locale )
```

 **Description:**

Checks whether the character specified by  **wc**  belongs to the  **desc**  class for the specified locale. 

**Parameters:**

<a name="table1425627941084824"></a>
<table><thead align="left"><tr id="row1125461912084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p551550656084824"><a name="p551550656084824"></a><a name="p551550656084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1107279453084824"><a name="p1107279453084824"></a><a name="p1107279453084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1759444048084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
<tr id="row425018034084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">desc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character class. </td>
</tr>
<tr id="row282951420084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswdigit\(\)<a name="ga972fbaff0c1d4b4e612c789b8532e9af"></a>

```
int iswdigit (wint_t wc)
```

 **Description:**

Checks whether a wide character is a decimal digit. 

**Parameters:**

<a name="table1972715773084824"></a>
<table><thead align="left"><tr id="row52469262084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p361827529084824"><a name="p361827529084824"></a><a name="p361827529084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p50191305084824"><a name="p50191305084824"></a><a name="p50191305084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row564040947084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswdigit\_l\(\)<a name="gab84fd3a86d300fc49af9d708431566a9"></a>

```
int iswdigit_l (wint_t wc, locale_t locale )
```

 **Description:**

Checks whether a wide character is a decimal digit for the specified locale. 

**Parameters:**

<a name="table358477511084824"></a>
<table><thead align="left"><tr id="row788594564084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1184895097084824"><a name="p1184895097084824"></a><a name="p1184895097084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p590209139084824"><a name="p590209139084824"></a><a name="p590209139084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1823789081084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
<tr id="row416483562084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswgraph\(\)<a name="ga27b090b588b25bacca79bd11926ce308"></a>

```
int iswgraph (wint_t wc)
```

 **Description:**

Checks whether a wide character is visible. 

**Parameters:**

<a name="table2049586317084824"></a>
<table><thead align="left"><tr id="row855996272084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p633039982084824"><a name="p633039982084824"></a><a name="p633039982084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p511356368084824"><a name="p511356368084824"></a><a name="p511356368084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1257363541084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswgraph\_l\(\)<a name="gad7529291433b9e8f5e68caada7572244"></a>

```
int iswgraph_l (wint_t wc, locale_t locale )
```

 **Description:**

Checks whether a wide character is visible for the specified locale. 

**Parameters:**

<a name="table847621819084824"></a>
<table><thead align="left"><tr id="row1981733346084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1122931662084824"><a name="p1122931662084824"></a><a name="p1122931662084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p943720039084824"><a name="p943720039084824"></a><a name="p943720039084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row103025785084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
<tr id="row521069080084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswlower\(\)<a name="ga92c2a9aad2bf7e6c56a7c01597f59649"></a>

```
int iswlower (wint_t wc)
```

 **Description:**

Checks whether a wide character is a lowercase letter. 

**Parameters:**

<a name="table1644542137084824"></a>
<table><thead align="left"><tr id="row1246910207084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1553687415084824"><a name="p1553687415084824"></a><a name="p1553687415084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1079223384084824"><a name="p1079223384084824"></a><a name="p1079223384084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1975385335084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswlower\_l\(\)<a name="ga944498fac122e95a2da80137e7fffcb4"></a>

```
int iswlower_l (wint_t wc, locale_t locale )
```

 **Description:**

Checks whether a wide character is in lowercase for the specified locale. 

**Parameters:**

<a name="table254654014084824"></a>
<table><thead align="left"><tr id="row1825680779084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1248493483084824"><a name="p1248493483084824"></a><a name="p1248493483084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p962344378084824"><a name="p962344378084824"></a><a name="p962344378084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row601120683084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
<tr id="row399675620084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswprint\(\)<a name="ga3eef94f4b2065e786f96e231e871d521"></a>

```
int iswprint (wint_t wc)
```

 **Description:**

Checks whether a wide character is printable. 

**Parameters:**

<a name="table132329829084824"></a>
<table><thead align="left"><tr id="row449765676084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p953783016084824"><a name="p953783016084824"></a><a name="p953783016084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p527571644084824"><a name="p527571644084824"></a><a name="p527571644084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1409337465084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswprint\_l\(\)<a name="gacd7a8387b98672ae64f222072eefd38e"></a>

```
int iswprint_l (wint_t wc, locale_t locale )
```

 **Description:**

Checks whether a wide character is printable for the specified locale. 

**Parameters:**

<a name="table1283912981084824"></a>
<table><thead align="left"><tr id="row197465541084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1682983214084824"><a name="p1682983214084824"></a><a name="p1682983214084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1948809582084824"><a name="p1948809582084824"></a><a name="p1948809582084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1932118954084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
<tr id="row72435961084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswpunct\(\)<a name="gacf0bab8aa20334835ea1b55f715ddd64"></a>

```
int iswpunct (wint_t wc)
```

 **Description:**

Checks whether a wide character is a punctuation mark. 

**Parameters:**

<a name="table628430591084824"></a>
<table><thead align="left"><tr id="row2007510483084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1271744646084824"><a name="p1271744646084824"></a><a name="p1271744646084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1845927681084824"><a name="p1845927681084824"></a><a name="p1845927681084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2060536446084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswpunct\_l\(\)<a name="gad355af93606bf5c7688518d78a7c017c"></a>

```
int iswpunct_l (wint_t wc, locale_t locale )
```

 **Description:**

Checks whether  **wc**  is a punctuation wide character for the specified locale. 

**Parameters:**

<a name="table777826940084824"></a>
<table><thead align="left"><tr id="row1257564271084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1434450601084824"><a name="p1434450601084824"></a><a name="p1434450601084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1332089649084824"><a name="p1332089649084824"></a><a name="p1332089649084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1496723481084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
<tr id="row1928712672084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswspace\(\)<a name="gafb90e73f1be310ac1fe22f0d652838bc"></a>

```
int iswspace (wint_t wc)
```

 **Description:**

Checks whether a wide character belongs to the wide-character class  **space**. 

**Parameters:**

<a name="table913554669084824"></a>
<table><thead align="left"><tr id="row1877352036084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p724304103084824"><a name="p724304103084824"></a><a name="p724304103084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2057078148084824"><a name="p2057078148084824"></a><a name="p2057078148084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1057589586084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswspace\_l\(\)<a name="gac9068379860381e27a47831612a85c25"></a>

```
int iswspace_l (wint_t wc, locale_t locale )
```

 **Description:**

Checks whether a wide character belongs to the wide-character class  **space**  for the specified locale. 

**Parameters:**

<a name="table968649027084824"></a>
<table><thead align="left"><tr id="row1216605335084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2123318036084824"><a name="p2123318036084824"></a><a name="p2123318036084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p706470026084824"><a name="p706470026084824"></a><a name="p706470026084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2085568400084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
<tr id="row1148035917084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswupper\(\)<a name="gaf9d04695802b960ca3765c72d73ddb7c"></a>

```
int iswupper (wint_t wc)
```

 **Description:**

Checks whether a wide character is an uppercase letter. 

**Parameters:**

<a name="table646021790084824"></a>
<table><thead align="left"><tr id="row1008918573084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p191533837084824"><a name="p191533837084824"></a><a name="p191533837084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p648948448084824"><a name="p648948448084824"></a><a name="p648948448084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row390339240084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswupper\_l\(\)<a name="ga4f73f2368e29bb2fc350479157987bc8"></a>

```
int iswupper_l (wint_t wc, locale_t locale )
```

 **Description:**

Checks whether a wide character is in uppercase for the specified locale. 

**Parameters:**

<a name="table2003142193084824"></a>
<table><thead align="left"><tr id="row1300597695084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p433624756084824"><a name="p433624756084824"></a><a name="p433624756084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p977100477084824"><a name="p977100477084824"></a><a name="p977100477084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1269255144084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
<tr id="row135283339084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswxdigit\(\)<a name="ga4f1c74cab8bd862ddac6ad81a4e23f72"></a>

```
int iswxdigit (wint_t wc)
```

 **Description:**

Checks whether a wide character is a hexadecimal digit. 

**Parameters:**

<a name="table1295620226084824"></a>
<table><thead align="left"><tr id="row1170222325084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p421330059084824"><a name="p421330059084824"></a><a name="p421330059084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p793499039084824"><a name="p793499039084824"></a><a name="p793499039084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row216594484084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## iswxdigit\_l\(\)<a name="ga2355dbfdaa44cb73ffd0216f97a7ad93"></a>

```
int iswxdigit_l (wint_t wc, locale_t locale )
```

 **Description:**

Checks whether a wide character is a hexadecimal digit for the specified locale. 

**Parameters:**

<a name="table1547322085084824"></a>
<table><thead align="left"><tr id="row1997418838084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1739807907084824"><a name="p1739807907084824"></a><a name="p1739807907084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p483037618084824"><a name="p483037618084824"></a><a name="p483037618084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2003707513084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
<tr id="row1122140747084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the operation is successful; returns  **0**  otherwise. 



## isxdigit\(\)<a name="gadaf3aadefe3fc4fb07b6be0d7b880f53"></a>

```
int isxdigit (int c)
```

 **Description:**

Checks whether a parameter is a hexadecimal digit. 

**Parameters:**

<a name="table1953959407084824"></a>
<table><thead align="left"><tr id="row899277146084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p514725287084824"><a name="p514725287084824"></a><a name="p514725287084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p876373993084824"><a name="p876373993084824"></a><a name="p876373993084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1836977868084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **c**  is a hexadecimal digit; returns  **0**  otherwise. 



## isxdigit\_l\(\)<a name="ga21c1d42504e331cf330026dcb47dcbe2"></a>

```
int isxdigit_l (int c, locale_t locale )
```

 **Description:**

Checks whether a parameter is a hexadecimal digit for the specified locale. 

**Parameters:**

<a name="table1962443936084824"></a>
<table><thead align="left"><tr id="row8441118084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1437942644084824"><a name="p1437942644084824"></a><a name="p1437942644084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p662515116084824"><a name="p662515116084824"></a><a name="p662515116084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row675167750084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to check. </td>
</tr>
<tr id="row1340203043084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the parameter is a hexadecimal digit; returns  **0**  otherwise. 



## jrand48\(\)<a name="ga79163d3776f4009f0e7f1830f4be4d02"></a>

```
long jrand48 (unsigned short xsubi[3])
```

 **Description:**

Generates pseudo-random numbers evenly distributed between \[-2^31, 2^31\). 

**Parameters:**

<a name="table1459335144084824"></a>
<table><thead align="left"><tr id="row1241090431084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1463211757084824"><a name="p1463211757084824"></a><a name="p1463211757084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2029974610084824"><a name="p2029974610084824"></a><a name="p2029974610084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row582362591084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">xsubi[3]</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the array of the initialized value of <strong id="b1664499972084824"><a name="b1664499972084824"></a><a name="b1664499972084824"></a>Xi</strong>. </td>
</tr>
</tbody>
</table>

**Attention:**

This function works by generating a 48-bit integer sequence, and  **X\(i+1\)**  must be generated by using the value of  **Xi**. The correlation is obtained by using a linear congruential formula, Xn+1 = \(aXn + c\) mod m, where n = 0, m = 2^48, a = 0x5DEECE66D, and c = 0xB.  **Xi**  is specified by  **xsubi\[3\]**. 

**Returns:**

Returns signed long integers evenly distributed between \[-2^31, 2^31\) if the operation is successful. 



## l64a\(\)<a name="ga4045440e70229bdb726924f628f66d92"></a>

```
char* l64a (long value)
```

 **Description:**

Converts a long integer to a 64-bit ASCII string. 

**Parameters:**

<a name="table1624076589084824"></a>
<table><thead align="left"><tr id="row537949772084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1195750648084824"><a name="p1195750648084824"></a><a name="p1195750648084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p625607282084824"><a name="p625607282084824"></a><a name="p625607282084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1641326926084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">value</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the long integer to be converted. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the static buffer if the operation is successful. The content in the buffer is overwritten each time the function is called. For multithreaded programs, this function returns a pointer to thread-specific data. 



## labs\(\)<a name="gac39409d0077cf980e4e6419bc6014d10"></a>

```
long labs (long i)
```

 **Description:**

Calculates the absolute value of a long integer. 

**Parameters:**

<a name="table356167046084824"></a>
<table><thead align="left"><tr id="row1901360182084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p943352439084824"><a name="p943352439084824"></a><a name="p943352439084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1421925278084824"><a name="p1421925278084824"></a><a name="p1421925278084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1424062217084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">i</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the long integer to be converted. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the absolute value. 



## lcong48\(\)<a name="ga71e0019171f5584bb6957867691c3e10"></a>

```
void lcong48 (unsigned short param[7])
```

 **Description:**

Sets the seed and related algorithm parameters for the pseudo-random number generator. 

**Parameters:**

<a name="table153983922084824"></a>
<table><thead align="left"><tr id="row1366513739084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p731355784084824"><a name="p731355784084824"></a><a name="p731355784084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p418309477084824"><a name="p418309477084824"></a><a name="p418309477084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row289246566084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">param[7]</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameters of the random number generator. </td>
</tr>
</tbody>
</table>

**Attention:**

This function works by generating a 48-bit integer sequence, and  **X\(i+1\)**  must be generated by using the value of  **Xi**. The correlation is obtained by using a linear congruential formula, Xn+1 = \(aXn + c\) mod m, where n = 0, m = 2^48, a = 0x5DEECE66D, and c = 0xB.  **param\[0 - 2\]**  is the initialized value of  **Xi**.  **param \[3-5\]**  specifies the value of  **a**, and  **param\[6\]**  specifies the value of  **c**. After this function is called, calling  **srand48 \(\)**  or  **seed48 \(\)**  will restore the standard values of  **a**  and  **c**. 



## ldiv\(\)<a name="ga9ce9bebe15110c3774f311cd587dc543"></a>

```
[ldiv_t](ldiv_t.md) ldiv (long numerator, long denominator )
```

 **Description:**

Calculates the quotient and remainder of a long integer after division. 

**Parameters:**

<a name="table1262312037084824"></a>
<table><thead align="left"><tr id="row1124507826084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1284760521084824"><a name="p1284760521084824"></a><a name="p1284760521084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p521960482084824"><a name="p521960482084824"></a><a name="p521960482084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row328087833084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">numerator</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the numerator. </td>
</tr>
<tr id="row1898428453084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">denominator</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the denominator. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a structure variable that has been defined in the function. 



## lfind\(\)<a name="ga9f8c694512c6c8a53f7e5a5f5e25cf86"></a>

```
void* lfind (const void * key, const void * base, size_t * nelp, size_t width, int(*)(const void *, const void *) compar )
```

 **Description:**

Performs a linear search for a key in the array. 

**Parameters:**

<a name="table1699241591084824"></a>
<table><thead align="left"><tr id="row788126390084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1952660541084824"><a name="p1952660541084824"></a><a name="p1952660541084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1735378662084824"><a name="p1735378662084824"></a><a name="p1735378662084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row137863108084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the key to be searched. </td>
</tr>
<tr id="row1056313604084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">base</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the array buffer. </td>
</tr>
<tr id="row1901357912084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nelp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the linear search length. </td>
</tr>
<tr id="row1400769518084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">width</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the array buffer width. </td>
</tr>
<tr id="row1293177834084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">compar</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the function to match. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the obtained key if the operation is successful; returns  **NULL**  if the operation fails. 



## llabs\(\)<a name="ga7251caa2dd32261e7768d824c0a532c6"></a>

```
long long llabs (long long i)
```

 **Description:**

Calculates the absolute value of a long long integer. 

**Parameters:**

<a name="table1927230815084824"></a>
<table><thead align="left"><tr id="row921503272084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1465587709084824"><a name="p1465587709084824"></a><a name="p1465587709084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p405468872084824"><a name="p405468872084824"></a><a name="p405468872084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1565658306084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">i</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the long long integer to be converted. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the absolute value. 



## lldiv\(\)<a name="ga28b92959777798288e1ac1def1c16ddc"></a>

```
[lldiv_t](lldiv_t.md) lldiv (long long numerator, long long denominator )
```

 **Description:**

Calculates the quotient and remainder of a long long integer after division. 

**Parameters:**

<a name="table414987283084824"></a>
<table><thead align="left"><tr id="row1454069356084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1699755744084824"><a name="p1699755744084824"></a><a name="p1699755744084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p531926627084824"><a name="p531926627084824"></a><a name="p531926627084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1451407381084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">numerator</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the numerator. </td>
</tr>
<tr id="row884427761084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">denominator</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the denominator. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a structure variable that has been defined in the function. 



## lrand48\(\)<a name="gad20ddf22bece340e3036c60cad913250"></a>

```
long int lrand48 (void )
```

 **Description:**

Generates pseudo-random numbers evenly distributed between \[0, 2^31\). 

**Attention:**

This function works by generating a 48-bit integer sequence, and  **X\(i+1\)**  must be generated by using the value of  **Xi**. The correlation is obtained by using a linear congruential formula, Xn+1 = \(aXn + c\) mod m, where n = 0, m = 2^48, a = 0x5DEECE66D, and c = 0xB. Before this function is called, one of the functions  **[srand48\(\)](utils.md#ga91c6acf8516086891c689926e49f1ddf)**,  **[seed48\(\)](utils.md#ga0b86f7fc9964c291844e8112a367721c)**, and  **[lcong48\(\)](utils.md#ga71e0019171f5584bb6957867691c3e10)**  must be used to initialize  **Xi**. 

**Returns:**

Returns nonnegative long integers evenly distributed between \[0, 2^31\) if the operation is successful. 



## lsearch\(\)<a name="ga2e48c29ae7f3ef8f5707f4cc4f4ef608"></a>

```
void* lsearch (const void * key, const void * base, size_t * nelp, size_t width, int(*)(const void *, const void *) compar )
```

 **Description:**

Performs a linear search for a key in the array and adds a key to the end of the array if the key is not found. 

**Parameters:**

<a name="table1613992726084824"></a>
<table><thead align="left"><tr id="row624114713084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1571591748084824"><a name="p1571591748084824"></a><a name="p1571591748084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2140269400084824"><a name="p2140269400084824"></a><a name="p2140269400084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row62927868084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the key to be searched. </td>
</tr>
<tr id="row657692569084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">base</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the array buffer. </td>
</tr>
<tr id="row1036006383084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nelp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the linear search length. </td>
</tr>
<tr id="row1667289497084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">width</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the array buffer width. </td>
</tr>
<tr id="row1986440513084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">compar</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the function to match. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the obtained key if the operation is successful. 



## lseek\(\)<a name="ga8bd74caed008a66808d92d57fa74d9f6"></a>

```
off_t lseek (int fd, off_t offset, int whence )
```

 **Description:**

Sets the offset of the pointer to the file. 

The pointer to the file is used to read and write data. 

**Parameters:**

<a name="table1421468669084824"></a>
<table><thead align="left"><tr id="row1277892780084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1285566495084824"><a name="p1285566495084824"></a><a name="p1285566495084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p493445338084824"><a name="p493445338084824"></a><a name="p493445338084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row282570526084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file descriptor. </td>
</tr>
<tr id="row1232010513084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer offset to be set. </td>
</tr>
<tr id="row276795826084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">whence</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer position. The value can be <strong id="b700082859084824"><a name="b700082859084824"></a><a name="b700082859084824"></a>SEEK_CUR</strong> (current position), <strong id="b456360736084824"><a name="b456360736084824"></a><a name="b456360736084824"></a>SEEK_SET</strong> (beginning of the file), or <strong id="b1181311567084824"><a name="b1181311567084824"></a><a name="b1181311567084824"></a>SEEK_END</strong> (end of the file). </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the offset to the beginning of the file if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1783145566084824"></a>
<table><thead align="left"><tr id="row1723721825084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2022173364084824"><a name="p2022173364084824"></a><a name="p2022173364084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p162316032084824"><a name="p162316032084824"></a><a name="p162316032084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row2136382606084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p342231811084824"><a name="p342231811084824"></a><a name="p342231811084824"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p288653554084824"><a name="p288653554084824"></a><a name="p288653554084824"></a><strong id="b892256196084824"><a name="b892256196084824"></a><a name="b892256196084824"></a>fd</strong> is invalid. </p>
</td>
</tr>
<tr id="row18444611084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1571746559084824"><a name="p1571746559084824"></a><a name="p1571746559084824"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1366814336084824"><a name="p1366814336084824"></a><a name="p1366814336084824"></a>This operation is not supported. </p>
</td>
</tr>
<tr id="row482667640084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p269963839084824"><a name="p269963839084824"></a><a name="p269963839084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1566388992084824"><a name="p1566388992084824"></a><a name="p1566388992084824"></a><strong id="b2003895358084824"><a name="b2003895358084824"></a><a name="b2003895358084824"></a>whence</strong> is invalid. </p>
</td>
</tr>
<tr id="row483677043084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1195102432084824"><a name="p1195102432084824"></a><a name="p1195102432084824"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1074715242084824"><a name="p1074715242084824"></a><a name="p1074715242084824"></a>A hardware error occurs at the I/O layer. </p>
</td>
</tr>
</tbody>
</table>

## malloc\(\)<a name="ga7ac38fce3243a7dcf448301ee9ffd392"></a>

```
void* malloc (size_t size)
```

 **Description:**

Dynamically allocates a memory block of  **size**. 

The allocated memory is not initialized. 

**Parameters:**

<a name="table1875280588084824"></a>
<table><thead align="left"><tr id="row2108571867084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p40590087084824"><a name="p40590087084824"></a><a name="p40590087084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1200506164084824"><a name="p1200506164084824"></a><a name="p1200506164084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row703067380084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the memory block to be allocated. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the allocated memory block if the operation is successful; returns  **NULL**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table384063355084824"></a>
<table><thead align="left"><tr id="row175677382084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1240617596084824"><a name="p1240617596084824"></a><a name="p1240617596084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p870109862084824"><a name="p870109862084824"></a><a name="p870109862084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1728536514084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1788719033084824"><a name="p1788719033084824"></a><a name="p1788719033084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1680911879084824"><a name="p1680911879084824"></a><a name="p1680911879084824"></a>Insufficient memory. </p>
</td>
</tr>
</tbody>
</table>

## mblen\(\)<a name="ga10b28b2a9d994195623066c344fcf1fd"></a>

```
int mblen (const char * s, size_t n )
```

 **Description:**

Obtains the number of bytes in the next multi-byte string. 

If  **s**  is not  **NULL**, this function inspects at most  **n**  bytes of the multi-byte string starting at  **s**. 

**Parameters:**

<a name="table208556925084824"></a>
<table><thead align="left"><tr id="row1528496830084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1566345605084824"><a name="p1566345605084824"></a><a name="p1566345605084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p775017116084824"><a name="p775017116084824"></a><a name="p775017116084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2075939427084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to a string constant. </td>
</tr>
<tr id="row2950027084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of bytes to be checked. The value cannot be greater than <strong id="b1439462054084824"><a name="b1439462054084824"></a><a name="b1439462054084824"></a>MB_CUR_MAX</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of bytes of the string constant if the operation is successful; returns  **0**  if the string constant content is a wide character that is empty; returns  **-1**  if the string constant content is invalid or cannot be parsed. 



## mbrlen\(\)<a name="gab7c8a08e5174c1235b0e925dfc77b938"></a>

```
size_t mbrlen (const char * s, size_t n, mbstate_t * ps )
```

 **Description:**

Determines the number of bytes in a character string pointed to by  **s**. 

If  **s**  is not  **NULL**, this function checks at most  **n**  bytes in the string of  **s**. It also uses a static anonymous shift state pointed to by  **ps**. 

**Parameters:**

<a name="table719550391084824"></a>
<table><thead align="left"><tr id="row1031230921084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1439490278084824"><a name="p1439490278084824"></a><a name="p1439490278084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2012546757084824"><a name="p2012546757084824"></a><a name="p2012546757084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row874218667084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to check. </td>
</tr>
<tr id="row1007949606084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum number of bytes to check. </td>
</tr>
<tr id="row1343262194084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ps</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the <strong id="b834891150084824"><a name="b834891150084824"></a><a name="b834891150084824"></a>mbstate_t</strong> object describing the conversion state. </td>
</tr>
</tbody>
</table>

**Attention:**

The behavior of this function depends on the  [LC\_CTYPE](io.md#ga07c66689961056725d7f50231d740ba9)  type of the current locale. 

**Returns:**

Returns the number of bytes in the string if the operation is successful. If  **s**  is a null pointer, this function returns  **0**. If the characters in  **s**  are invalid or cannot be parsed, this function returns  **-1**. If the first  **n**  bytes in the string of  **s**  do not contribute to a complete multi-byte character, this function returns  **\(size\_t\)-2**. If the first  **n**  bytes in the string of  **s**  contain an invalid multi-byte character, this function returns  **\(size\_t\)-1**  and sets  **errno**  to  [EILSEQ](utils.md#gac6c071293826a4e66a717bb38db7794d). 



## mbrtowc\(\)<a name="ga6fd639ff3ac22621951452b380468327"></a>

```
size_t mbrtowc (wchar_t * pwc, const char * s, size_t n, mbstate_t * ps )
```

 **Description:**

Converts a multi-byte character string with a length of  **n**  into a wide character string. 

**Parameters:**

<a name="table938492048084824"></a>
<table><thead align="left"><tr id="row2026701720084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p860669209084824"><a name="p860669209084824"></a><a name="p860669209084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1249619204084824"><a name="p1249619204084824"></a><a name="p1249619204084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row133994820084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pwc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination wide character array to store the converted string. </td>
</tr>
<tr id="row159436326084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the multi-byte character string to be converted. </td>
</tr>
<tr id="row1464402142084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of bytes to read from <strong id="b1030807737084824"><a name="b1030807737084824"></a><a name="b1030807737084824"></a>s</strong>. </td>
</tr>
<tr id="row2016128170084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ps</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the <strong id="b400995591084824"><a name="b400995591084824"></a><a name="b400995591084824"></a>mbstate_t</strong> object describing the conversion state. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of characters written to the destination wide character array. If the first  **n**  bytes in the string of  **s**  do not contribute to a complete multi-byte character, this function returns  **\(size\_t\)-2**. If the first  **n**  bytes in the string of  **s**  contain an invalid multi-byte character, this function returns  **\(size\_t\)-1**  and sets  **errno**  to  [EILSEQ](utils.md#gac6c071293826a4e66a717bb38db7794d). If the converted wide character is  **L'\\ 0'**, this function returns  **0**  and resets  **\* ps**  to the initial state. 



## mbsinit\(\)<a name="gac87bb41cb64e86b29faf5b569c2533b4"></a>

```
int mbsinit (const mbstate_t * ps)
```

 **Description:**

Checks whether the  **mbstate\_t**  object pointed to by  **ps**  is in the initial state. 

**Parameters:**

<a name="table188767235084824"></a>
<table><thead align="left"><tr id="row163333186084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1172762195084824"><a name="p1172762195084824"></a><a name="p1172762195084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1998569319084824"><a name="p1998569319084824"></a><a name="p1998569319084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1078240363084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ps</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the <strong id="b9519197084824"><a name="b9519197084824"></a><a name="b9519197084824"></a>mbstate_t</strong> object to check. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if  **ps**  points to an object that is in the initial state or it is a null pointer; returns  **0**  otherwise. 



## mbsnrtowcs\(\)<a name="ga08f9c737e4060d9e123e0fc28a1eb2f3"></a>

```
size_t mbsnrtowcs (wchar_t * dest, const char ** src, size_t nwc, size_t len, mbstate_t * ps )
```

 **Description:**

Converts a multi-byte character string with a length of  **n**  into a wide character string that can hold a total of  **nwc**  wide characters. 

**Parameters:**

<a name="table1795337028084824"></a>
<table><thead align="left"><tr id="row1006782848084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p344481198084824"><a name="p344481198084824"></a><a name="p344481198084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p18238042084824"><a name="p18238042084824"></a><a name="p18238042084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2040101004084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination wide character array to store the converted string. </td>
</tr>
<tr id="row328452974084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the double pointer to the source string to be converted. </td>
</tr>
<tr id="row977620372084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nwc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of wide characters that can be written to the destination wide character array. </td>
</tr>
<tr id="row2042838208084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">len</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of characters to be converted. </td>
</tr>
<tr id="row862420024084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ps</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the <strong id="b62207363084824"><a name="b62207363084824"></a><a name="b62207363084824"></a>mbstate_t</strong> object describing the conversion state. </td>
</tr>
</tbody>
</table>

**Attention:**

The  **dest**  value cannot be  **NULL**. 

**Returns:**

Returns the number of characters written to the destination wide character array. If the first  **n**  bytes in the string of  **s**  contain an invalid multi-byte character, this function returns  **\(size\_t\)-1**  and sets  **errno**  to  [EILSEQ](utils.md#gac6c071293826a4e66a717bb38db7794d). If more than  **nwc**  characters will be written or more than  **len**  characters are to be converted,  **src**  points to the next character to be converted, and this function returns the number of characters successfully written to the destination wide character array. If the converted wide character is  **L'\\ 0'**, this function returns  **0**  and resets  **\* ps**  to the initial state. 



## mbsrtowcs\(\)<a name="gac3ebddff1a73c20b17986a6b7b68fe56"></a>

```
size_t mbsrtowcs (wchar_t * dest, const char ** src, size_t len, mbstate_t * ps )
```

 **Description:**

Converts a multi-byte character string with a length of  **len**  into a wide character string. 

**Parameters:**

<a name="table242569215084824"></a>
<table><thead align="left"><tr id="row1297772603084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1223441755084824"><a name="p1223441755084824"></a><a name="p1223441755084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1757210571084824"><a name="p1757210571084824"></a><a name="p1757210571084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1948254730084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination wide character array to store the converted string. </td>
</tr>
<tr id="row110154635084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the double pointer to the source string to be converted. </td>
</tr>
<tr id="row1701251628084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">len</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of wide characters to be converted. </td>
</tr>
<tr id="row517955789084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ps</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the <strong id="b108761104084824"><a name="b108761104084824"></a><a name="b108761104084824"></a>mbstate_t</strong> object describing the conversion state. </td>
</tr>
</tbody>
</table>

**Attention:**

**dest**  cannot be  **NULL**. 

**Returns:**

Returns the number of characters written to the destination wide character array. If an invalid character is encountered, this function returns  **len-1**  and sets  **errno**  to  [EILSEQ](utils.md#gac6c071293826a4e66a717bb38db7794d). If  **len**  non-**L'\\0'**  characters have been successfully written to the destination wide character array,  **src**  points to the next character to be converted, and this function returns the number of wide characters successfully written to the destination array. If the converted wide character is  **L'\\0'**, this function returns  **0**  and resets  **\* ps**  to the initial state. 



## mbstowcs\(\)<a name="ga95b89e577f091ba05d6403ff542c2164"></a>

```
size_t mbstowcs (wchar_t * dest, const char * src, size_t n )
```

 **Description:**

Converts a multi-byte string to a wide-character string. 

**Parameters:**

<a name="table747563644084824"></a>
<table><thead align="left"><tr id="row2018166450084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1018113347084824"><a name="p1018113347084824"></a><a name="p1018113347084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p628402739084824"><a name="p628402739084824"></a><a name="p628402739084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1196329709084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to an array for the <strong id="b656000676084824"><a name="b656000676084824"></a><a name="b656000676084824"></a>wchar_t</strong> element. The array length can store a wide-character string whose length is specified by <strong id="b381621592084824"><a name="b381621592084824"></a><a name="b381621592084824"></a>n</strong>. </td>
</tr>
<tr id="row594382285084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the multi-byte string to convert. </td>
</tr>
<tr id="row615777292084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum number of wide characters to convert. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of wide characters, excluding the terminating null wide character if the operation is successful; returns  **-1**  if an invalid multibyte character is encountered. 



## mbtowc\(\)<a name="ga6d2e39eeb319f32608b467c0c0ca1393"></a>

```
int mbtowc (wchar_t * pwc, const char * s, size_t n )
```

 **Description:**

Converts a string constant to a wide character. 

If  **s**  is not  **NULL**, this function inspects at most  **n**  bytes of the multi-byte string starting at  **s**  and converts it to a wide character and stores it. 

**Parameters:**

<a name="table2024606054084824"></a>
<table><thead align="left"><tr id="row749501223084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p297475992084824"><a name="p297475992084824"></a><a name="p297475992084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p263429307084824"><a name="p263429307084824"></a><a name="p263429307084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1485720519084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pwc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string for storing the wide character. </td>
</tr>
<tr id="row810815127084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to a string constant. </td>
</tr>
<tr id="row631702614084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of bytes to be checked. The value cannot be greater than <strong id="b1379426705084824"><a name="b1379426705084824"></a><a name="b1379426705084824"></a>MB_CUR_MAX</strong>. </td>
</tr>
</tbody>
</table>

**Attention:**

**s**  and  **pwc**  cannot be  **NULL**. If  **s**  is  **NULL**,  **pwc**  and  **n**  are ignored. 

**Returns:**

Returns the number of bytes converted from  **s**  if the operation is successful; returns  **0**  if  **s**  points to an empty byte; returns  **-1**  if the string constant content is invalid or cannot be parsed. 



## memccpy\(\)<a name="ga2ffbfe50042aaf5b987782dcd16ea1f0"></a>

```
void* memccpy (void *__restrict dest, const void *__restrict src, int c, size_t n )
```

 **Description:**

Copies a memory area to another one. 

This function copies no more than  **n**  bytes from the source memory area pointed to by  **src**  to the destination memory area pointed to by  **dest**. The copy stops when a character specified by  **c**  is found. The result for two overlapped memory areas is undefined. 

**Parameters:**

<a name="table1135198905084824"></a>
<table><thead align="left"><tr id="row1708005722084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p709237997084824"><a name="p709237997084824"></a><a name="p709237997084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1877752307084824"><a name="p1877752307084824"></a><a name="p1877752307084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1857518357084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination memory area. </td>
</tr>
<tr id="row641035805084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the source memory area. </td>
</tr>
<tr id="row1082583461084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the character for stopping copying. </td>
</tr>
<tr id="row1254668795084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the string to be copied, in bytes. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the next character of the character  **c**  in the destination memory area if the operation is successful; returns  **NULL**  if the character  **c**  is not found in the n bytes of the source memory area. 



## memchr\(\)<a name="ga16d6b0bd660cc3f9910924c6b6f4af8e"></a>

```
void* memchr (const void * s, int c, size_t n )
```

 **Description:**

Searches for a character in the specified memory area. 

This function searches for the first occurrence of the character specified by  **c**  in the n-byte memory area pointed to by  **s**. Both the character  **c**  and the memory area pointed to by  **s**  are interpreted as unsigned characters. 

**Parameters:**

<a name="table1369105239084824"></a>
<table><thead align="left"><tr id="row1641345560084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p595393433084824"><a name="p595393433084824"></a><a name="p595393433084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p342095036084824"><a name="p342095036084824"></a><a name="p342095036084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row90971040084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the start of the bytes to be searched. </td>
</tr>
<tr id="row175429982084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the character to be searched for. </td>
</tr>
<tr id="row703806951084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the memory area to be searched. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the character if found; returns  **NULL**  if no matching character is found. 



## memcmp\(\)<a name="ga9e6df54ee04e18a3772335580e2ed872"></a>

```
int memcmp (const void * s1, const void * s2, size_t n )
```

 **Description:**

Compares two memory areas. 

This function checks whether the first  **n**  bytes of the two memory areas pointed to by  **s1**  and  **s2**  are equal. 

**Parameters:**

<a name="table169949027084824"></a>
<table><thead align="left"><tr id="row2101899284084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p10995205084824"><a name="p10995205084824"></a><a name="p10995205084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1177876876084824"><a name="p1177876876084824"></a><a name="p1177876876084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1980843505084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to memory area 1 for comparison. </td>
</tr>
<tr id="row832044487084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to memory area 2 for comparison. </td>
</tr>
<tr id="row1644728851084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the memory area to be compared, in bytes. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the first  **n**  bytes of two memory areas are the same or  **n**  is 0; returns the difference between the first pair of bytes that differ in  **s1**  and  **s2**  if the contents of two memory areas are different. 



## memcpy\(\)<a name="ga0ee37e291991bef6e3f4b49a970171e7"></a>

```
void* memcpy (void *__restrict dest, const void *__restrict src, size_t n )
```

 **Description:**

Copies a string \(overlapping not allowed\). 

This function copies  **n**  bytes from the source memory area pointed to by  **src**  to the destination memory area pointed to by  **dest**. The two memory areas cannot overlap. If they overlap, use  [memmove\(\)](utils.md#ga802c986820d3866639922b6bc9484f90)  instead. 

**Parameters:**

<a name="table854911303084824"></a>
<table><thead align="left"><tr id="row393396307084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p532434062084824"><a name="p532434062084824"></a><a name="p532434062084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p423684058084824"><a name="p423684058084824"></a><a name="p423684058084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1817349380084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination memory area. </td>
</tr>
<tr id="row1535279049084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the source memory area. </td>
</tr>
<tr id="row1535482194084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the string to be copied, in bytes. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer \(**dest**\) to the destination memory area. 



## memmem\(\)<a name="ga5f6423417e952f934be0a582d87b663a"></a>

```
void* memmem (const void * haystack, size_t haystacklen, const void * needle, size_t needlelen )
```

 **Description:**

Searches for a needle string in its haystack string. 

This function searches for the start position of the first occurrence of the needle string whose length is  **needlelen**  in the memory area holding the haystack string which starts at the position pointed to by  **haystack**. 

**Parameters:**

<a name="table846514604084824"></a>
<table><thead align="left"><tr id="row2066825096084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1180384924084824"><a name="p1180384924084824"></a><a name="p1180384924084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p538577839084824"><a name="p538577839084824"></a><a name="p538577839084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row813391821084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">haystack</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the start position of the memory area to be searched. </td>
</tr>
<tr id="row1455909274084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">haystacklen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length (in bytes) of the memory area to be searched. </td>
</tr>
<tr id="row526233776084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">needle</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the start position of the needle string to be searched for. </td>
</tr>
<tr id="row225181015084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">needlelen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length (in bytes) of the needle string to be searched for. </td>
</tr>
</tbody>
</table>

**Attention:**

This is an extended GNU function. 

**Returns:**

Returns the start position of the needle string in the memory area if the position is found; returns  **NULL**  if the position is not found. 



## memmove\(\)<a name="ga802c986820d3866639922b6bc9484f90"></a>

```
void* memmove (void * dest, const void * src, size_t n )
```

 **Description:**

Copies a string \(overlapping allowed\). 

This function copies  **n**  bytes from the source memory area pointed to by  **src**  to the destination memory area pointed to by  **dest**. The two memory areas can overlap. 

**Parameters:**

<a name="table379153299084824"></a>
<table><thead align="left"><tr id="row1322136112084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p999823783084824"><a name="p999823783084824"></a><a name="p999823783084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p322307624084824"><a name="p322307624084824"></a><a name="p322307624084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1356913990084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination memory area. </td>
</tr>
<tr id="row1047659026084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the source memory area. </td>
</tr>
<tr id="row566869202084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the string to be copied, in bytes. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer \(**dest**\) to the destination memory area. 

**See also:**

[memcpy\(\)](utils.md#ga0ee37e291991bef6e3f4b49a970171e7) 

## mempcpy\(\)<a name="ga7ac7c0f43132e3acf013e0c71a58cdc9"></a>

```
void* mempcpy (void * dest, const void * src, size_t n )
```

 **Description:**

Copies a string \(overlapping not allowed\). 

This function copies  **n**  bytes from the source memory area pointed to by  **src**  to the destination memory area pointed to by  **dest**. The two memory areas cannot overlap. This function is similar to  [memcpy\(\)](utils.md#ga0ee37e291991bef6e3f4b49a970171e7)  except for the return value. This function returns the pointer to the last byte written during the copy. 

**Parameters:**

<a name="table2074327120084824"></a>
<table><thead align="left"><tr id="row877509182084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1363176637084824"><a name="p1363176637084824"></a><a name="p1363176637084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p641462637084824"><a name="p641462637084824"></a><a name="p641462637084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row60413307084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination memory area. </td>
</tr>
<tr id="row508912326084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the source memory area. </td>
</tr>
<tr id="row1986274291084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the string to be copied, in bytes. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the last byte written during the copy. 



## memrchr\(\)<a name="ga45623070e5e0b7008d44600a283ea2ee"></a>

```
void* memrchr (const void * s, int c, size_t n )
```

 **Description:**

Searches for a character in the specified memory area. 

This function searches for the first occurrence of the character specified by  **c**  in the n-byte memory area pointed to by  **s**. This function searches backward from the end of the n bytes pointed to by s, while the  [memchr\(\)](utils.md#ga16d6b0bd660cc3f9910924c6b6f4af8e)  function searches forward from the beginning. 

**Parameters:**

<a name="table1756263521084824"></a>
<table><thead align="left"><tr id="row644673068084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p344234290084824"><a name="p344234290084824"></a><a name="p344234290084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p622184215084824"><a name="p622184215084824"></a><a name="p622184215084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row813265891084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the start of the bytes to be searched. </td>
</tr>
<tr id="row1495013871084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the character to be searched for. </td>
</tr>
<tr id="row766986774084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the memory area to be searched. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the character if found; returns  **NULL**  if no matching character is found. 



## memset\(\)<a name="gace6ee45c30e71865e6eb635200379db9"></a>

```
void* memset (void * s, int c, size_t n )
```

 **Description:**

Copies a character to the specified memory area. 

This function copies the character specified by  **c**  to the n-byte memory area pointed to by  **s**. 

**Parameters:**

<a name="table1597790378084824"></a>
<table><thead align="left"><tr id="row384502513084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p355203018084824"><a name="p355203018084824"></a><a name="p355203018084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1052664745084824"><a name="p1052664745084824"></a><a name="p1052664745084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row735883812084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the memory area to hold the character. </td>
</tr>
<tr id="row492568457084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the character to be copied. </td>
</tr>
<tr id="row517211297084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the memory area. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer \(**s**\) to the memory area. 



## mkdtemp\(\)<a name="ga4c366b8d0ad8a393cf6224b5fc9ee045"></a>

```
char* mkdtemp (char * template)
```

 **Description:**

Creates a unique temporary directory based on  **template**. 

**Parameters:**

<a name="table2039846065084824"></a>
<table><thead align="left"><tr id="row902991872084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1715842944084824"><a name="p1715842944084824"></a><a name="p1715842944084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p218726081084824"><a name="p218726081084824"></a><a name="p218726081084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2040468481084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">template</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the name of the directory to be created. The last six characters must be <strong id="b2057200458084824"><a name="b2057200458084824"></a><a name="b2057200458084824"></a>XXXXXX</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the modified  **template**  string if the operation is successful; returns  **NULL**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1683183560084824"></a>
<table><thead align="left"><tr id="row254053382084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1201497895084824"><a name="p1201497895084824"></a><a name="p1201497895084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p588002473084824"><a name="p588002473084824"></a><a name="p588002473084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1529637817084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p817341642084824"><a name="p817341642084824"></a><a name="p817341642084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p465208413084824"><a name="p465208413084824"></a><a name="p465208413084824"></a>The last six characters are not <strong id="b1472386681084824"><a name="b1472386681084824"></a><a name="b1472386681084824"></a>XXXXXX</strong>. </p>
</td>
</tr>
<tr id="row240031586084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1536425786084824"><a name="p1536425786084824"></a><a name="p1536425786084824"></a>Other </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2107625832084824"><a name="p2107625832084824"></a><a name="p2107625832084824"></a>For details, see <a href="fs.md#gaee98bbe743c2d14dbaa67f01c3fb9ed5">mkdir</a>. </p>
</td>
</tr>
</tbody>
</table>

**See also:**

[mkdir](fs.md#gaee98bbe743c2d14dbaa67f01c3fb9ed5) 

## mkostemp\(\)<a name="ga691bcfdddb46ab9b43a91217a0ff77c9"></a>

```
int mkostemp (char * template, int flags )
```

 **Description:**

Creates and opens a unique temporary file. 

Different from  [mkstemp](utils.md#ga6abe6c5eb77aeaf05ad81a7425547d9e), this function has the  **flags**  parameter. 

**Parameters:**

<a name="table819972065084824"></a>
<table><thead align="left"><tr id="row2086119875084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1163833723084824"><a name="p1163833723084824"></a><a name="p1163833723084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1920510125084824"><a name="p1920510125084824"></a><a name="p1920510125084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1176755707084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">template</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the name of the file to be created. The last six characters must be <strong id="b1772026760084824"><a name="b1772026760084824"></a><a name="b1772026760084824"></a>XXXXXX</strong>. </td>
</tr>
<tr id="row123448148084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">flags</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the flag for creating a file. For details, see <a href="fs.md#ga219205a58e244a5acd35b767ac50ef9c">open</a>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the descriptor of the opened file if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1021516072084824"></a>
<table><thead align="left"><tr id="row1745714286084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1699868754084824"><a name="p1699868754084824"></a><a name="p1699868754084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p575178828084824"><a name="p575178828084824"></a><a name="p575178828084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row607327747084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p51836890084824"><a name="p51836890084824"></a><a name="p51836890084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p242335544084824"><a name="p242335544084824"></a><a name="p242335544084824"></a>The last six characters are not <strong id="b1505287142084824"><a name="b1505287142084824"></a><a name="b1505287142084824"></a>XXXXXX</strong>. </p>
</td>
</tr>
<tr id="row709415425084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1649996599084824"><a name="p1649996599084824"></a><a name="p1649996599084824"></a>EEXIST </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p843984106084824"><a name="p843984106084824"></a><a name="p843984106084824"></a>Failed to create a unique temporary file name. </p>
</td>
</tr>
<tr id="row1124987801084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p415713328084824"><a name="p415713328084824"></a><a name="p415713328084824"></a>Other </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1161561431084824"><a name="p1161561431084824"></a><a name="p1161561431084824"></a>For details, see <a href="fs.md#ga219205a58e244a5acd35b767ac50ef9c">open()</a>. </p>
</td>
</tr>
</tbody>
</table>

**See also:**

[open](fs.md#ga219205a58e244a5acd35b767ac50ef9c) 

## mkostemps\(\)<a name="gafab16d88038590bdb4900150d2791081"></a>

```
int mkostemps (char * template, int suffixlen, int flags )
```

 **Description:**

Creates and opens a unique temporary file. 

**Parameters:**

<a name="table313037582084824"></a>
<table><thead align="left"><tr id="row1005641974084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2041461764084824"><a name="p2041461764084824"></a><a name="p2041461764084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1899230253084824"><a name="p1899230253084824"></a><a name="p1899230253084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row413787882084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">template</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the name of the file to be created. </td>
</tr>
<tr id="row1670099613084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">suffixlen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the placeholder suffix <strong id="b2128209864084824"><a name="b2128209864084824"></a><a name="b2128209864084824"></a>XXXXXX</strong>. </td>
</tr>
<tr id="row1241153150084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">flags</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the flag for creating a file. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the descriptor of the opened file if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table95045380084824"></a>
<table><thead align="left"><tr id="row1404043753084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1829579016084824"><a name="p1829579016084824"></a><a name="p1829579016084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p493802836084824"><a name="p493802836084824"></a><a name="p493802836084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row768335012084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p553197906084824"><a name="p553197906084824"></a><a name="p553197906084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p847694497084824"><a name="p847694497084824"></a><a name="p847694497084824"></a>The <strong id="b648240204084824"><a name="b648240204084824"></a><a name="b648240204084824"></a>template</strong> length is less than (6 + <strong id="b2112755605084824"><a name="b2112755605084824"></a><a name="b2112755605084824"></a>suffixlen</strong>), or the last six characters of <strong id="b2109015076084824"><a name="b2109015076084824"></a><a name="b2109015076084824"></a>template</strong> are not <strong id="b617319879084824"><a name="b617319879084824"></a><a name="b617319879084824"></a>XXXXXX</strong>. </p>
</td>
</tr>
<tr id="row926440403084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1871007021084824"><a name="p1871007021084824"></a><a name="p1871007021084824"></a>EEXIST </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1002261107084824"><a name="p1002261107084824"></a><a name="p1002261107084824"></a>Failed to create a unique temporary file name. </p>
</td>
</tr>
<tr id="row1967395831084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1138219794084824"><a name="p1138219794084824"></a><a name="p1138219794084824"></a>Other </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p421866374084824"><a name="p421866374084824"></a><a name="p421866374084824"></a>For details, see <a href="fs.md#ga219205a58e244a5acd35b767ac50ef9c">open()</a>. </p>
</td>
</tr>
</tbody>
</table>

**See also:**

[open](fs.md#ga219205a58e244a5acd35b767ac50ef9c) 

## mkstemp\(\)<a name="ga6abe6c5eb77aeaf05ad81a7425547d9e"></a>

```
int mkstemp (char * template)
```

 **Description:**

Creates and opens a unique temporary file. 

**Parameters:**

<a name="table391117221084824"></a>
<table><thead align="left"><tr id="row1096407798084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p585956912084824"><a name="p585956912084824"></a><a name="p585956912084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p940147514084824"><a name="p940147514084824"></a><a name="p940147514084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2106925544084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">template</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the name of the file to be created. The last six characters must be <strong id="b1084423942084824"><a name="b1084423942084824"></a><a name="b1084423942084824"></a>XXXXXX</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the descriptor of the opened file if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table632535594084824"></a>
<table><thead align="left"><tr id="row1770640724084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p264122169084824"><a name="p264122169084824"></a><a name="p264122169084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p930219979084824"><a name="p930219979084824"></a><a name="p930219979084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1282059521084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2077562730084824"><a name="p2077562730084824"></a><a name="p2077562730084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1279871049084824"><a name="p1279871049084824"></a><a name="p1279871049084824"></a>The last six characters are not <strong id="b1102235928084824"><a name="b1102235928084824"></a><a name="b1102235928084824"></a>XXXXXX</strong>. </p>
</td>
</tr>
<tr id="row1638385420084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1176819638084824"><a name="p1176819638084824"></a><a name="p1176819638084824"></a>EEXIST </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1610926707084824"><a name="p1610926707084824"></a><a name="p1610926707084824"></a>Failed to create a unique temporary file name. </p>
</td>
</tr>
<tr id="row513329614084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p418380709084824"><a name="p418380709084824"></a><a name="p418380709084824"></a>Other </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p5072306084824"><a name="p5072306084824"></a><a name="p5072306084824"></a>For details, see <a href="fs.md#ga219205a58e244a5acd35b767ac50ef9c">open()</a>. </p>
</td>
</tr>
</tbody>
</table>

**See also:**

[open](fs.md#ga219205a58e244a5acd35b767ac50ef9c) 

## mkstemps\(\)<a name="gab962063e3bb487de132da3016e2c813c"></a>

```
int mkstemps (char * template, int suffixlen )
```

 **Description:**

Creates and opens a unique temporary file. 

**Parameters:**

<a name="table1894255894084824"></a>
<table><thead align="left"><tr id="row1917248092084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p855947291084824"><a name="p855947291084824"></a><a name="p855947291084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2135197886084824"><a name="p2135197886084824"></a><a name="p2135197886084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row645105872084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">template</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the name of the file to be created. </td>
</tr>
<tr id="row1150584636084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">suffixlen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the placeholder suffix <strong id="b1884998705084824"><a name="b1884998705084824"></a><a name="b1884998705084824"></a>XXXXXX</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the descriptor of the opened file if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1751512114084824"></a>
<table><thead align="left"><tr id="row509935384084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p755748407084824"><a name="p755748407084824"></a><a name="p755748407084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2146484086084824"><a name="p2146484086084824"></a><a name="p2146484086084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row416377763084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p595467193084824"><a name="p595467193084824"></a><a name="p595467193084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p910055694084824"><a name="p910055694084824"></a><a name="p910055694084824"></a>The <strong id="b290247565084824"><a name="b290247565084824"></a><a name="b290247565084824"></a>template</strong> length is less than (6 + <strong id="b1502748833084824"><a name="b1502748833084824"></a><a name="b1502748833084824"></a>suffixlen</strong>), or the last six characters of <strong id="b2091213441084824"><a name="b2091213441084824"></a><a name="b2091213441084824"></a>template</strong> are not <strong id="b1288127054084824"><a name="b1288127054084824"></a><a name="b1288127054084824"></a>XXXXXX</strong>. </p>
</td>
</tr>
<tr id="row1036059872084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1557509389084824"><a name="p1557509389084824"></a><a name="p1557509389084824"></a>EEXIST </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p643332137084824"><a name="p643332137084824"></a><a name="p643332137084824"></a>Failed to create a unique temporary file name. </p>
</td>
</tr>
<tr id="row1022831996084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p411674412084824"><a name="p411674412084824"></a><a name="p411674412084824"></a>Other </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p972598419084824"><a name="p972598419084824"></a><a name="p972598419084824"></a>For details, see <a href="fs.md#ga219205a58e244a5acd35b767ac50ef9c">open()</a>. </p>
</td>
</tr>
</tbody>
</table>

**See also:**

[open](fs.md#ga219205a58e244a5acd35b767ac50ef9c) 

## mktemp\(\)<a name="ga3db0418e1e0258f6a8809286c291cc5b"></a>

```
char* mktemp (char * template)
```

 **Description:**

Creates a unique temporary file name. 

**Parameters:**

<a name="table547209971084824"></a>
<table><thead align="left"><tr id="row351746152084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1359071664084824"><a name="p1359071664084824"></a><a name="p1359071664084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p285177983084824"><a name="p285177983084824"></a><a name="p285177983084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row674107854084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">template</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the name of the file to be created. The last six characters are <strong id="b1112051731084824"><a name="b1112051731084824"></a><a name="b1112051731084824"></a>XXXXXX</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the created file name if the operation is successful; returns  **NULL**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table2010708620084824"></a>
<table><thead align="left"><tr id="row901934178084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1039506577084824"><a name="p1039506577084824"></a><a name="p1039506577084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1854429719084824"><a name="p1854429719084824"></a><a name="p1854429719084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1729219287084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1992467877084824"><a name="p1992467877084824"></a><a name="p1992467877084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p955411687084824"><a name="p955411687084824"></a><a name="p955411687084824"></a>The last six characters are not <strong id="b399708294084824"><a name="b399708294084824"></a><a name="b399708294084824"></a>XXXXXX</strong>. </p>
</td>
</tr>
<tr id="row1139893361084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p722825456084824"><a name="p722825456084824"></a><a name="p722825456084824"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1575909090084824"><a name="p1575909090084824"></a><a name="p1575909090084824"></a>The file name already exists. </p>
</td>
</tr>
</tbody>
</table>

## mrand48\(\)<a name="ga9c450a7a3d4437e3d5f8def180f68103"></a>

```
long mrand48 (void )
```

 **Description:**

Generates pseudo-random numbers evenly distributed between \[-2^31, 2^31\). 

**Attention:**

This function works by generating a 48-bit integer sequence, and  **X\(i+1\)**  must be generated by using the value of  **Xi**. The correlation is obtained by using a linear congruential formula, Xn+1 = \(aXn + c\) mod m, where n = 0, m = 2^48, a = 0x5DEECE66D, and c = 0xB. Before this function is called, one of the functions  **[srand48\(\)](utils.md#ga91c6acf8516086891c689926e49f1ddf)**,  **[seed48\(\)](utils.md#ga0b86f7fc9964c291844e8112a367721c)**, and  **[lcong48\(\)](utils.md#ga71e0019171f5584bb6957867691c3e10)**  must be used to initialize  **Xi**. 

**Returns:**

Returns signed long integers evenly distributed between \[-2^31, 2^31\) if the operation is successful. 



## nrand48\(\)<a name="gaae8f9c9ee0a49b3bd8bea3331dab500f"></a>

```
long int nrand48 (unsigned short xsubi[3])
```

 **Description:**

Generates pseudo-random numbers evenly distributed between \[0, 2^31\). 

**Parameters:**

<a name="table941175985084824"></a>
<table><thead align="left"><tr id="row91621454084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p733287148084824"><a name="p733287148084824"></a><a name="p733287148084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1561738121084824"><a name="p1561738121084824"></a><a name="p1561738121084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1630732603084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">xsubi[3]</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the array of the initialized value of <strong id="b1813622950084824"><a name="b1813622950084824"></a><a name="b1813622950084824"></a>Xi</strong>. </td>
</tr>
</tbody>
</table>

**Attention:**

This function works by generating a 48-bit integer sequence, and  **X\(i+1\)**  must be generated by using the value of  **Xi**. The correlation is obtained by using a linear congruential formula, Xn+1 = \(aXn + c\) mod m, where n = 0, m = 2^48, a = 0x5DEECE66D, and c = 0xB.  **Xi**  is specified by  **xsubi\[3\]**. 

**Returns:**

Returns nonnegative long integers evenly distributed between \[0, 2^31\) if the operation is successful. 



## pathconf\(\)<a name="gaa4ea4bbebf4841965159e66b5d1a49e8"></a>

```
long pathconf (const char * path, int name )
```

 **Description:**

Obtains the configuration value of a file. 

**Parameters:**

<a name="table914707092084824"></a>
<table><thead align="left"><tr id="row1808118022084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1218112779084824"><a name="p1218112779084824"></a><a name="p1218112779084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p800611611084824"><a name="p800611611084824"></a><a name="p800611611084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row677994338084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file path. </td>
</tr>
<tr id="row854249171084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">name</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the name of the configuration value. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the actual value of the configuration file if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1923007344084824"></a>
<table><thead align="left"><tr id="row1355548674084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p327369555084824"><a name="p327369555084824"></a><a name="p327369555084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1910707288084824"><a name="p1910707288084824"></a><a name="p1910707288084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row748254864084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p661086957084824"><a name="p661086957084824"></a><a name="p661086957084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1576487632084824"><a name="p1576487632084824"></a><a name="p1576487632084824"></a>The value of <strong id="b633275794084824"><a name="b633275794084824"></a><a name="b633275794084824"></a>name</strong> does not match any existing configuration option. </p>
</td>
</tr>
</tbody>
</table>

## pause\(\)<a name="ga47a6ff5872f457ee230458137f2b2409"></a>

```
int pause (void )
```

 **Description:**

Waits for signal. 

This function is used to stop the current process or thread until a signal is delivered. 

**Returns:**

Returns when a signal was caught and returns  **-1**  and sets  **errno**  to EINTR. 

<a name="table296733750084824"></a>
<table><thead align="left"><tr id="row1211310214084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2050107851084824"><a name="p2050107851084824"></a><a name="p2050107851084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1842791206084824"><a name="p1842791206084824"></a><a name="p1842791206084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1722826804084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p896814166084824"><a name="p896814166084824"></a><a name="p896814166084824"></a>EINTR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p835514015084824"><a name="p835514015084824"></a><a name="p835514015084824"></a>A signal was caught during execution. </p>
</td>
</tr>
</tbody>
</table>

## pipe\(\)<a name="ga3d8839f39526d15b100953d64cc08f10"></a>

```
int pipe (int pipefd[2])
```

 **Description:**

Creates an anonymous pipe. 

**Parameters:**

<a name="table271784464084824"></a>
<table><thead align="left"><tr id="row781325377084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p134072381084824"><a name="p134072381084824"></a><a name="p134072381084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p392155134084824"><a name="p392155134084824"></a><a name="p392155134084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row831158695084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pipefd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the buffer for storing the created pipe descriptor. The buffer has two sizes of the <strong id="b1080946632084824"><a name="b1080946632084824"></a><a name="b1080946632084824"></a>int</strong> type, one for the read-end descriptor and the other for the write-end descriptor. </td>
</tr>
</tbody>
</table>

**Attention:**

A maximum of 32 anonymous pipes can be created, and the internal buffer of a pipe is 1023 bytes. 

**Returns:**

Returns  **0**  if the creation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the creation fails. 

<a name="table289931048084824"></a>
<table><thead align="left"><tr id="row1578455024084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1516264424084824"><a name="p1516264424084824"></a><a name="p1516264424084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1180386402084824"><a name="p1180386402084824"></a><a name="p1180386402084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row530599658084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2051225378084824"><a name="p2051225378084824"></a><a name="p2051225378084824"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1616464049084824"><a name="p1616464049084824"></a><a name="p1616464049084824"></a><strong id="b54561215084824"><a name="b54561215084824"></a><a name="b54561215084824"></a>pipefd</strong> is invalid. </p>
</td>
</tr>
<tr id="row1659210689084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1384694124084824"><a name="p1384694124084824"></a><a name="p1384694124084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1420203061084824"><a name="p1420203061084824"></a><a name="p1420203061084824"></a>Creation failed due to insufficient space. </p>
</td>
</tr>
<tr id="row666271704084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1191639156084824"><a name="p1191639156084824"></a><a name="p1191639156084824"></a>ENFILE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p934381830084824"><a name="p934381830084824"></a><a name="p934381830084824"></a>Failed to create an anonymous pipe because the number of anonymous pipes has reached the upper limit. </p>
</td>
</tr>
</tbody>
</table>

## posix\_memalign\(\)<a name="gaed1e9c27ea92f5ae3a480059bf45c311"></a>

```
int posix_memalign (void ** memptr, size_t alignment, size_t size )
```

 **Description:**

Allocates memory with the specified size based on the given  **alignment**. 

The value of  **alignment**  must be a power of 2 and a multiple of  **sizeof\(void \*\)**. The allocated memory address is stored in  **\*memptr**. If  **size**  is  **0**,  **\*memptr**  is either  **NULL**  or a unique pointer value that can later be successfully passed to  [free\(\)](mem.md#gafbedc913aa4651b3c3b4b3aecd9b4711). 

**Parameters:**

<a name="table2097273293084824"></a>
<table><thead align="left"><tr id="row20470553084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p27081250084824"><a name="p27081250084824"></a><a name="p27081250084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1604410039084824"><a name="p1604410039084824"></a><a name="p1604410039084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1867759431084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">memptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the double pointer to the allocated memory block. </td>
</tr>
<tr id="row439124810084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">alignment</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the alignment size of the allocated memory block. </td>
</tr>
<tr id="row344618209084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the memory block to be allocated. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns an error code if the operation fails. 

<a name="table542353805084824"></a>
<table><thead align="left"><tr id="row2138416969084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p566951750084824"><a name="p566951750084824"></a><a name="p566951750084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1393059172084824"><a name="p1393059172084824"></a><a name="p1393059172084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row437729078084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1530915181084824"><a name="p1530915181084824"></a><a name="p1530915181084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p132558314084824"><a name="p132558314084824"></a><a name="p132558314084824"></a>The value of <strong id="b92350973084824"><a name="b92350973084824"></a><a name="b92350973084824"></a>alignment</strong> is not a power of 2, or is not a multiple of <strong id="b1256967137084824"><a name="b1256967137084824"></a><a name="b1256967137084824"></a>sizeof(void *)</strong>. </p>
</td>
</tr>
<tr id="row791823163084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p861880000084824"><a name="p861880000084824"></a><a name="p861880000084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p685518490084824"><a name="p685518490084824"></a><a name="p685518490084824"></a>Insufficient memory. </p>
</td>
</tr>
</tbody>
</table>

## pread\(\)<a name="ga67ceebb141dbf6be0be4484804601e5b"></a>

```
ssize_t pread (int fd, void * buf, size_t count, off_t offset )
```

 **Description:**

Reads data whose offset is  **offset**  and length is  **count**  from  **fd**  to the buffer. 

**Parameters:**

<a name="table384756196084824"></a>
<table><thead align="left"><tr id="row1974641733084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p526090682084824"><a name="p526090682084824"></a><a name="p526090682084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1127335846084824"><a name="p1127335846084824"></a><a name="p1127335846084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1612008915084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file descriptor to read. </td>
</tr>
<tr id="row1571309339084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the buffer for storing data. </td>
</tr>
<tr id="row778540179084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">count</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the data to read. </td>
</tr>
<tr id="row717205847084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the offset of the file descriptor to read. </td>
</tr>
</tbody>
</table>

**Attention:**

The  **fd**  offset does not change after the function is called. This function is helpful in multithreaded applications. They allow multiple threads to execute the I/O on the same file descriptor without being affected by changes in other file offsets. It is not an error if the number of transferred bytes is less than the number of requested bytes after the function is called. 

**Returns:**

Returns the number of records read if the operation is successful; returns  **-1**  and sets  **errno**  to a value if the operation fails. 



## ptsname\(\)<a name="ga4602f14b8c8f146f93d72986341a27b7"></a>

```
char* ptsname (int fd)
```

 **Description:**

Obtains the name of a pseudo terminal. 

**Parameters:**

<a name="table283916164084824"></a>
<table><thead align="left"><tr id="row1468902865084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p345298346084824"><a name="p345298346084824"></a><a name="p345298346084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p540675775084824"><a name="p540675775084824"></a><a name="p540675775084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1712841107084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the terminal descriptor. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the name if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1799636266084824"></a>
<table><thead align="left"><tr id="row1253252001084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p359964783084824"><a name="p359964783084824"></a><a name="p359964783084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2120456788084824"><a name="p2120456788084824"></a><a name="p2120456788084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row2137477698084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1924063771084824"><a name="p1924063771084824"></a><a name="p1924063771084824"></a>ERANGE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1528493750084824"><a name="p1528493750084824"></a><a name="p1528493750084824"></a><strong id="b1587640820084824"><a name="b1587640820084824"></a><a name="b1587640820084824"></a>fd</strong> is too long. </p>
</td>
</tr>
</tbody>
</table>

## putenv\(\)<a name="ga8a382cc6123c7cf09a144e28fdfe5bc1"></a>

```
int putenv (char * s)
```

 **Description:**

Configures an environment variable. 

**Parameters:**

<a name="table1988732814084824"></a>
<table><thead align="left"><tr id="row2029325623084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p907579216084824"><a name="p907579216084824"></a><a name="p907579216084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1983727095084824"><a name="p1983727095084824"></a><a name="p1983727095084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row897313780084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the content of the environment variable to configure. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  otherwise. 



## putwc\(\)<a name="ga578ce42fa0cf04469cff45134114b701"></a>

```
wint_t putwc (wchar_t wc, [FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream )
```

 **Description:**

Writes a wide character  **wc**  to a specified file stream. 

**Parameters:**

<a name="table2044448225084824"></a>
<table><thead align="left"><tr id="row972670330084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1012730812084824"><a name="p1012730812084824"></a><a name="p1012730812084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p521046750084824"><a name="p521046750084824"></a><a name="p521046750084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row306042051084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character to write. </td>
</tr>
<tr id="row1818399108084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Attention:**

This function is similar to  [fputwc](utils.md#gab405f6ad88ebd1c6150206d19d3c7f12)  only except that it is implemented as a macro. 

**Returns:**

Returns the wide character if the operation is successful; returns  **WEOF**  otherwise. 



## putwchar\(\)<a name="ga34ef116bac70390d5a2ff8c5fdb45777"></a>

```
wint_t putwchar (wchar_t wc)
```

 **Description:**

Writes a wide character  **wc**  to the stdout. 

**Parameters:**

<a name="table1357005284084824"></a>
<table><thead align="left"><tr id="row482607828084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p175097007084824"><a name="p175097007084824"></a><a name="p175097007084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p274712485084824"><a name="p274712485084824"></a><a name="p274712485084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row721849120084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character to write. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the wide character if the operation is successful; returns  **WEOF**  otherwise. 



## pwrite\(\)<a name="ga6583cb37d551c2553bbb5e7df6c145be"></a>

```
ssize_t pwrite (int fd, const void * buf, size_t count, off_t offset )
```

 **Description:**

Writes data from the buffer to  **fd**  whose offset is  **offset**  and length is  **count**. 

**Parameters:**

<a name="table1647297341084824"></a>
<table><thead align="left"><tr id="row491352630084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p298483489084824"><a name="p298483489084824"></a><a name="p298483489084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p212786416084824"><a name="p212786416084824"></a><a name="p212786416084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1751308811084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file descriptor to write. </td>
</tr>
<tr id="row364333909084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the buffer to which data is written. </td>
</tr>
<tr id="row570428947084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">count</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the data to write. </td>
</tr>
<tr id="row1633528627084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the offset of the file to write. </td>
</tr>
</tbody>
</table>

**Attention:**

The  **fd**  offset does not change after the function is called. This function is helpful in multithreaded applications. They allow multiple threads to execute the I/O on the same file descriptor without being affected by changes in other file offsets. It is not an error if the number of transferred bytes is less than the number of requested bytes after the function is called. For details, see  [write\(\)](utils.md#gac06af22e9ce132f563db5c918ceb1eb1). 

**Returns:**

Returns the number of records written if the operation is successful; returns  **-1**  and sets  **errno**  to a value if the operation fails. Global variables of the  **int**  type can be directly obtained. 



## qsort\(\)<a name="ga56ba7474387aae0977ce6dbe9bef805f"></a>

```
void qsort (const void * base, size_t nel, size_t width, int(*)(const void *, const void *) compar )
```

 **Description:**

Sorts array elements  **base\[0\]**  to  **base\[num-1\]**  based on the comparison rules of  **compar**. 

**Parameters:**

<a name="table105942560084824"></a>
<table><thead align="left"><tr id="row1324259347084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p502322218084824"><a name="p502322218084824"></a><a name="p502322218084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1079756994084824"><a name="p1079756994084824"></a><a name="p1079756994084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1085442544084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">base</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the array to be sorted. </td>
</tr>
<tr id="row2090569369084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nel</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of elements in the array to be searched. </td>
</tr>
<tr id="row1633311075084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">width</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of each element, in bytes. </td>
</tr>
<tr id="row61885006084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">compare</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the comparison subfunction used to define comparison rules. </td>
</tr>
</tbody>
</table>

## rand\(\)<a name="gae23144bcbb8e3742b00eb687c36654d1"></a>

```
int rand (void )
```

 **Description:**

Generates a pseudo-random number. 

The random number ranges from  **0**  to  **RAND\_MAX**. 

**Attention:**

**RAND\_MAX**  is defined in this header file. This function is implemented using the linear congruence method. If the random number seed does not change, the generated random number complies with the normal distribution. The generated random number is not a real random number but a pseudo-random number. Therefore, you need to use the  **[srand\(\)](utils.md#ga83a727cc697aea22e24cad5f39198dd2)**  function to initialize the random number seed to the unique values. 

**Returns:**

Returns a non-negative integer that is evenly distributed in the interval \[0,  **RAND\_MAX**\] if the operation is successful. 



## rand\_r\(\)<a name="ga4d592bbc52a36404b05aa9ff5b7503c1"></a>

```
int rand_r (unsigned * seedp)
```

 **Description:**

Generates a pseudo-random number. 

The random number ranges from  **0**  to  **RAND\_MAX**. 

**Parameters:**

<a name="table1859400953084824"></a>
<table><thead align="left"><tr id="row67065643084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p110881464084824"><a name="p110881464084824"></a><a name="p110881464084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p545100955084824"><a name="p545100955084824"></a><a name="p545100955084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2062445322084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">seedp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the random number seed. </td>
</tr>
</tbody>
</table>

**Attention:**

This function is implemented using the linear congruence method. If the random number seed does not change, the generated random number complies with the normal distribution. The generated random number is not a real random number but a pseudo-random number. Therefore, you need to use  [srand](utils.md#ga83a727cc697aea22e24cad5f39198dd2)  to initialize the random number seed to the unique values. 

**Returns:**

Returns a non-negative integer that is evenly distributed in the interval \[0,  **RAND\_MAX**\] if the operation is successful. 



## random\(\)<a name="ga350b5b3334c99bb57d2b39da0b2dd694"></a>

```
long int random (void )
```

 **Description:**

Generates a pseudo-random number. 

**Attention:**

Generally,  [srandom\(\)](utils.md#gaf1e7e3d144face36372f9ae8b18aa009)  is called before this function to generate a random number seed. If  [srandom\(\)](utils.md#gaf1e7e3d144face36372f9ae8b18aa009)  is not called or  **srandom\(0\)**  is used to generate a random number seed, the random number seed generated by  **srandom\(1\)**  is used. 



## read\(\)<a name="ga5975018bea8d2811c4b3abe10d493bb6"></a>

```
ssize_t read (int fd, void * buf, size_t size )
```

 **Description:**

Reads the file contents and saves them in a specified buffer location. 

**Parameters:**

<a name="table337625672084824"></a>
<table><thead align="left"><tr id="row445831463084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p280106786084824"><a name="p280106786084824"></a><a name="p280106786084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p390852773084824"><a name="p390852773084824"></a><a name="p390852773084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row641091092084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the descriptor of the file to read. </td>
</tr>
<tr id="row774594873084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the buffer for storing the data read. </td>
</tr>
<tr id="row432213660084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the content to read. If the length exceeds that of the buffer, memory corruption may occur. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of bytes read if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table229472359084824"></a>
<table><thead align="left"><tr id="row788054500084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p123699570084824"><a name="p123699570084824"></a><a name="p123699570084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2099838406084824"><a name="p2099838406084824"></a><a name="p2099838406084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row373907543084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p397534388084824"><a name="p397534388084824"></a><a name="p397534388084824"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p207327358084824"><a name="p207327358084824"></a><a name="p207327358084824"></a><strong id="b349651205084824"><a name="b349651205084824"></a><a name="b349651205084824"></a>fd</strong> is invalid. </p>
</td>
</tr>
<tr id="row770368080084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p66344602084824"><a name="p66344602084824"></a><a name="p66344602084824"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1335530857084824"><a name="p1335530857084824"></a><a name="p1335530857084824"></a>The file cannot be read. </p>
</td>
</tr>
<tr id="row872522204084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p453006599084824"><a name="p453006599084824"></a><a name="p453006599084824"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1134507151084824"><a name="p1134507151084824"></a><a name="p1134507151084824"></a><strong id="b1513023894084824"><a name="b1513023894084824"></a><a name="b1513023894084824"></a>buf</strong> is set to <strong id="b1808354391084824"><a name="b1808354391084824"></a><a name="b1808354391084824"></a>NULL</strong>. </p>
</td>
</tr>
<tr id="row780232122084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2058296763084824"><a name="p2058296763084824"></a><a name="p2058296763084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p280814516084824"><a name="p280814516084824"></a><a name="p280814516084824"></a>Insufficient memory. </p>
</td>
</tr>
</tbody>
</table>

## realloc\(\)<a name="ga1a6b5e8d2f1c37e5b43e4345586075be"></a>

```
void* realloc (void * ptr, size_t size )
```

 **Description:**

Changes the size of the memory block pointed to by  **ptr**  to  **size**  bytes. 

The contents will remain unchanged in the range from the start of  **ptr**  to the minimum of the old and new sizes. If the new size is larger than the old size, the added memory will not be initialized. If  **ptr**  is  **NULL**, this function call is equivalent to  **malloc\(size\)**; if  **size**  is equal to  **0**  and  **ptr**  is not  **NULL**, the function call is equivalent to  **free\(ptr\)**. If  **ptr**  is not  **NULL**, it must be the returned value of  [malloc\(\)](mem.md#ga7ac38fce3243a7dcf448301ee9ffd392),  [calloc\(\)](mem.md#ga62b7798461bd461da64c5f9d35feddf7), or  [realloc](utils.md#ga1a6b5e8d2f1c37e5b43e4345586075be). If the memory block pointed to by  **ptr**  has been moved,  **free\(ptr\)**  is executed. 

**Parameters:**

<a name="table1270735805084824"></a>
<table><thead align="left"><tr id="row93129727084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p802718732084824"><a name="p802718732084824"></a><a name="p802718732084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p404535480084824"><a name="p404535480084824"></a><a name="p404535480084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1732997510084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the memory block to be adjusted. </td>
</tr>
<tr id="row111633632084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the new size of the memory block. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the new memory block if the operation is successful; returns  **NULL**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table70663337084824"></a>
<table><thead align="left"><tr id="row365625225084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1908696377084824"><a name="p1908696377084824"></a><a name="p1908696377084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1458425850084824"><a name="p1458425850084824"></a><a name="p1458425850084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1651207245084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1244529683084824"><a name="p1244529683084824"></a><a name="p1244529683084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1538140710084824"><a name="p1538140710084824"></a><a name="p1538140710084824"></a>Insufficient memory. </p>
</td>
</tr>
</tbody>
</table>

## realpath\(\)<a name="gaae6b0f26f4a57df79f7c497a65d174d9"></a>

```
char* realpath (const char *__restrict path, char *__restrict resolved )
```

 **Description:**

Obtains a normalized absolute path. 

**Parameters:**

<a name="table805458356084824"></a>
<table><thead align="left"><tr id="row2045229885084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2000654321084824"><a name="p2000654321084824"></a><a name="p2000654321084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p724546216084824"><a name="p724546216084824"></a><a name="p724546216084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row932987577084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the name of the absolute path to be obtained. </td>
</tr>
<tr id="row518253705084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">resolved</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the obtained absolute path. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to  **resolved\_path**  if the operation is successful; returns  **NULL**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table2012224976084824"></a>
<table><thead align="left"><tr id="row1432105042084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p537736110084824"><a name="p537736110084824"></a><a name="p537736110084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1382828056084824"><a name="p1382828056084824"></a><a name="p1382828056084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row2094525881084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2076485315084824"><a name="p2076485315084824"></a><a name="p2076485315084824"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p709424407084824"><a name="p709424407084824"></a><a name="p709424407084824"></a>Read or search permission is denied on a component of the path prefix. </p>
</td>
</tr>
<tr id="row1167619516084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p370952955084824"><a name="p370952955084824"></a><a name="p370952955084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p903413491084824"><a name="p903413491084824"></a><a name="p903413491084824"></a><strong id="b1105670433084824"><a name="b1105670433084824"></a><a name="b1105670433084824"></a>path</strong> is <strong id="b676609549084824"><a name="b676609549084824"></a><a name="b676609549084824"></a>NULL</strong>. </p>
</td>
</tr>
<tr id="row902271979084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2131478046084824"><a name="p2131478046084824"></a><a name="p2131478046084824"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2001777423084824"><a name="p2001777423084824"></a><a name="p2001777423084824"></a>An I/O error occurred while reading from the file system. </p>
</td>
</tr>
<tr id="row623125290084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p556582824084824"><a name="p556582824084824"></a><a name="p556582824084824"></a>ELOOP </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1138344438084824"><a name="p1138344438084824"></a><a name="p1138344438084824"></a>Too many symbolic links are encountered when the path name is parsed. </p>
</td>
</tr>
<tr id="row954996668084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1207139723084824"><a name="p1207139723084824"></a><a name="p1207139723084824"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1841875984084824"><a name="p1841875984084824"></a><a name="p1841875984084824"></a>The path name is too long. </p>
</td>
</tr>
<tr id="row1995951670084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p253726802084824"><a name="p253726802084824"></a><a name="p253726802084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1848897585084824"><a name="p1848897585084824"></a><a name="p1848897585084824"></a>Insufficient memory. </p>
</td>
</tr>
<tr id="row1820685266084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1405933934084824"><a name="p1405933934084824"></a><a name="p1405933934084824"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p944779361084824"><a name="p944779361084824"></a><a name="p944779361084824"></a>The file does not exist. </p>
</td>
</tr>
<tr id="row1051518569084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p336649530084824"><a name="p336649530084824"></a><a name="p336649530084824"></a>ENOTDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p678990989084824"><a name="p678990989084824"></a><a name="p678990989084824"></a>The component of the path prefix is not a directory. </p>
</td>
</tr>
</tbody>
</table>

## remque\(\)<a name="ga1d2e353620a8dc3bb2702831607a3fc1"></a>

```
void remque (void * elem)
```

 **Description:**

Removes an entry from a queue. 

**Parameters:**

<a name="table896961901084824"></a>
<table><thead align="left"><tr id="row1513276366084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1105026966084824"><a name="p1105026966084824"></a><a name="p1105026966084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p335105155084824"><a name="p335105155084824"></a><a name="p335105155084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1894547469084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">element</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the <strong id="b1913653281084824"><a name="b1913653281084824"></a><a name="b1913653281084824"></a>element</strong> to be removed from the queue. </td>
</tr>
</tbody>
</table>

## rindex\(\)<a name="ga83d9aa3251fdee263ad43bf75933de46"></a>

```
char* rindex (const char * s, int c )
```

 **Description:**

Searches for the last position of the matched character in a string. 

**Parameters:**

<a name="table593702124084824"></a>
<table><thead align="left"><tr id="row1117264315084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p17810460084824"><a name="p17810460084824"></a><a name="p17810460084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1250260743084824"><a name="p1250260743084824"></a><a name="p1250260743084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row196193845084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to be searched. </td>
</tr>
<tr id="row307019626084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the character to be matched. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the matched character if the operation is successful; returns  **NULL**  if the operation fails. 



## rmdir\(\)<a name="gab2df76f2c62ae012c2e417813b5fe8ce"></a>

```
int rmdir (const char * path)
```

 **Description:**

Deletes a directory. 

**Parameters:**

<a name="table733138087084824"></a>
<table><thead align="left"><tr id="row1443172311084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2021660111084824"><a name="p2021660111084824"></a><a name="p2021660111084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1875724758084824"><a name="p1875724758084824"></a><a name="p1875724758084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1205755163084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the name of the directory to be deleted. </td>
</tr>
</tbody>
</table>

**Attention:**

This function can NOT be used in the PROC file system. 

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table54259951084824"></a>
<table><thead align="left"><tr id="row217530889084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1340885172084824"><a name="p1340885172084824"></a><a name="p1340885172084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1363241665084824"><a name="p1363241665084824"></a><a name="p1363241665084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1162351746084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1243097940084824"><a name="p1243097940084824"></a><a name="p1243097940084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p613623271084824"><a name="p613623271084824"></a><a name="p613623271084824"></a><strong id="b794491050084824"><a name="b794491050084824"></a><a name="b794491050084824"></a>path</strong> is a null pointer or an empty string. </p>
</td>
</tr>
<tr id="row1479090833084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1434889082084824"><a name="p1434889082084824"></a><a name="p1434889082084824"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p901220701084824"><a name="p901220701084824"></a><a name="p901220701084824"></a>The length of the path name is greater than <a href="utils.md#gae688d728e1acdfe5988c7db45d6f0166">PATH_MAX</a>. </p>
</td>
</tr>
<tr id="row766232566084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1362209538084824"><a name="p1362209538084824"></a><a name="p1362209538084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p541370885084824"><a name="p541370885084824"></a><a name="p541370885084824"></a>Insufficient memory. </p>
</td>
</tr>
<tr id="row1796152687084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p905450628084824"><a name="p905450628084824"></a><a name="p905450628084824"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p760869981084824"><a name="p760869981084824"></a><a name="p760869981084824"></a>The directory does not exist. </p>
</td>
</tr>
<tr id="row1143310665084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p360386425084824"><a name="p360386425084824"></a><a name="p360386425084824"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1093578675084824"><a name="p1093578675084824"></a><a name="p1093578675084824"></a>The path is a mount point, or it is neither a directory nor a file. </p>
</td>
</tr>
<tr id="row766401499084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1835785952084824"><a name="p1835785952084824"></a><a name="p1835785952084824"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p420210228084824"><a name="p420210228084824"></a><a name="p420210228084824"></a>The operation is not supported. </p>
</td>
</tr>
<tr id="row540675843084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1287073916084824"><a name="p1287073916084824"></a><a name="p1287073916084824"></a>ENOTEMPTY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1667679374084824"><a name="p1667679374084824"></a><a name="p1667679374084824"></a>The directory is not empty. </p>
</td>
</tr>
<tr id="row2142431503084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p554425704084824"><a name="p554425704084824"></a><a name="p554425704084824"></a>ENOTDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1934895403084824"><a name="p1934895403084824"></a><a name="p1934895403084824"></a>The specified path is not a directory. </p>
</td>
</tr>
<tr id="row145535086084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p633274932084824"><a name="p633274932084824"></a><a name="p633274932084824"></a>ENXIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1790252091084824"><a name="p1790252091084824"></a><a name="p1790252091084824"></a>No such device or address. </p>
</td>
</tr>
</tbody>
</table>

## sbrk\(\)<a name="ga3b818446c640442e94e746319f5f2858"></a>

```
void* sbrk (intptr_t increment)
```

 **Description:**

Adjusts the heap size of a process. 

**Parameters:**

<a name="table1542510429084824"></a>
<table><thead align="left"><tr id="row1434044069084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p992705126084824"><a name="p992705126084824"></a><a name="p992705126084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p961071090084824"><a name="p961071090084824"></a><a name="p961071090084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2136100186084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">increment</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the memory space to obtain. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the memory space if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1402825935084824"></a>
<table><thead align="left"><tr id="row766832348084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p970378097084824"><a name="p970378097084824"></a><a name="p970378097084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1250789267084824"><a name="p1250789267084824"></a><a name="p1250789267084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row160047754084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p279625956084824"><a name="p279625956084824"></a><a name="p279625956084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1983729732084824"><a name="p1983729732084824"></a><a name="p1983729732084824"></a>Insufficient memory. </p>
</td>
</tr>
</tbody>
</table>

## secure\_getenv\(\)<a name="ga131d5a62230be50122c603018fdb3fc2"></a>

```
char* secure_getenv (const char * name)
```

 **Description:**

Obtains the value of an environment variable. 

The feature of this function is the same as that of  [getenv\(\)](utils.md#gabc6595dbf6880c71628fecf0dbb23d66)  during non-secure execution. 

**Parameters:**

<a name="table1703987150084824"></a>
<table><thead align="left"><tr id="row494836091084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p904792559084824"><a name="p904792559084824"></a><a name="p904792559084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p284219150084824"><a name="p284219150084824"></a><a name="p284219150084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1528203808084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">name</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the name of the environment variable whose value needs to be obtained. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the environment variable value if the operation is successful; returns  **NULL**  if there is no match. 



## seed48\(\)<a name="ga0b86f7fc9964c291844e8112a367721c"></a>

```
unsigned short* seed48 (unsigned short [3])
```

 **Description:**

Generates an evenly distributed pseudo-random seed. 

**Parameters:**

<a name="table1044951924084824"></a>
<table><thead align="left"><tr id="row1900416421084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p86178912084824"><a name="p86178912084824"></a><a name="p86178912084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1990131427084824"><a name="p1990131427084824"></a><a name="p1990131427084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1970790379084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">seed16v</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the 48-bit seed. </td>
</tr>
</tbody>
</table>

**Attention:**

This function is an initialization function and can be called before calling  [drand48](utils.md#gaf9329f9acef07ca14ea2256191c3ce74),  [lrand48](utils.md#gad20ddf22bece340e3036c60cad913250), or  [mrand48](utils.md#ga9c450a7a3d4437e3d5f8def180f68103). 

**Returns:**

Returns the pointer to the pseudo-random seed. 



## setegid\(\)<a name="ga201d5dad2108506c5db5ba8d126ffbb2"></a>

```
int setegid (gid_t egid)
```

 **Description:**

Sets the effective user group ID of the calling process. 

**Parameters:**

<a name="table1648569359084824"></a>
<table><thead align="left"><tr id="row124993263084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p172667022084824"><a name="p172667022084824"></a><a name="p172667022084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1344849627084824"><a name="p1344849627084824"></a><a name="p1344849627084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1204675544084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">egid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the effective user group ID to set. </td>
</tr>
</tbody>
</table>

**Attention:**

The real user group ID is the same as the effective user group ID and saved user group ID. 

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1964302348084824"></a>
<table><thead align="left"><tr id="row1929012142084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p399748358084824"><a name="p399748358084824"></a><a name="p399748358084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p931357346084824"><a name="p931357346084824"></a><a name="p931357346084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row733627304084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p680234028084824"><a name="p680234028084824"></a><a name="p680234028084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1949993699084824"><a name="p1949993699084824"></a><a name="p1949993699084824"></a><strong id="b10781348084824"><a name="b10781348084824"></a><a name="b10781348084824"></a>egid</strong> is invalid. </p>
</td>
</tr>
<tr id="row747700884084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p788970183084824"><a name="p788970183084824"></a><a name="p788970183084824"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1224707955084824"><a name="p1224707955084824"></a><a name="p1224707955084824"></a>No setting permission. </p>
</td>
</tr>
</tbody>
</table>

## setenv\(\)<a name="ga1c8b16a3abcb4dc450a0a62b42c554dd"></a>

```
int setenv (const char * name, const char * value, int overwrite )
```

 **Description:**

Add or change an environment variable. 

This function adds the varible  **name**  to environment with string  **value**  if  **name**  is not exist. 

**Parameters:**

<a name="table257403762084824"></a>
<table><thead align="left"><tr id="row1986182282084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p34788042084824"><a name="p34788042084824"></a><a name="p34788042084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2135266731084824"><a name="p2135266731084824"></a><a name="p2135266731084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row587443863084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">name</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the name of environment variable. </td>
</tr>
<tr id="row348809266084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">value</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the value of environment variable. </td>
</tr>
<tr id="row49601215084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">overwrite</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">If the varible <strong id="b954398630084824"><a name="b954398630084824"></a><a name="b954398630084824"></a>name</strong> does exit and the value <strong id="b1907408491084824"><a name="b1907408491084824"></a><a name="b1907408491084824"></a>overwrite</strong> is nonzero, then value of <strong id="b692029252084824"><a name="b692029252084824"></a><a name="b692029252084824"></a>name</strong> will be change to new <strong id="b339155466084824"><a name="b339155466084824"></a><a name="b339155466084824"></a>value</strong>; if <strong id="b1812369365084824"><a name="b1812369365084824"></a><a name="b1812369365084824"></a>overwrite</strong> is zero, then the value of <strong id="b56729545084824"><a name="b56729545084824"></a><a name="b56729545084824"></a>name</strong> remains unchanged. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails 

<a name="table1690651831084824"></a>
<table><thead align="left"><tr id="row1012625905084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p353415244084824"><a name="p353415244084824"></a><a name="p353415244084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p303906721084824"><a name="p303906721084824"></a><a name="p303906721084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row2082833834084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2116265646084824"><a name="p2116265646084824"></a><a name="p2116265646084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p537371743084824"><a name="p537371743084824"></a><a name="p537371743084824"></a>The name is <strong id="b254784522084824"><a name="b254784522084824"></a><a name="b254784522084824"></a>NULL</strong>, or its length is zero, or contains an "=" character. </p>
</td>
</tr>
<tr id="row407491578084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p800259936084824"><a name="p800259936084824"></a><a name="p800259936084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p762109272084824"><a name="p762109272084824"></a><a name="p762109272084824"></a>Insufficient memory. </p>
</td>
</tr>
</tbody>
</table>

## seteuid\(\)<a name="ga1f3f88da554f543f01a02a06c79c7bdd"></a>

```
int seteuid (uid_t euid)
```

 **Description:**

Sets the effective user ID of the calling process. 

**Parameters:**

<a name="table1996125101084824"></a>
<table><thead align="left"><tr id="row457341169084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p614264648084824"><a name="p614264648084824"></a><a name="p614264648084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p405823686084824"><a name="p405823686084824"></a><a name="p405823686084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row953459376084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">euid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the effective user ID to set. </td>
</tr>
</tbody>
</table>

**Attention:**

The real user ID is the same as the effective user ID and saved user ID. 

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1386800509084824"></a>
<table><thead align="left"><tr id="row374073541084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p967117557084824"><a name="p967117557084824"></a><a name="p967117557084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p38212795084824"><a name="p38212795084824"></a><a name="p38212795084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row2084597164084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1999151424084824"><a name="p1999151424084824"></a><a name="p1999151424084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p295508765084824"><a name="p295508765084824"></a><a name="p295508765084824"></a><strong id="b588090063084824"><a name="b588090063084824"></a><a name="b588090063084824"></a>euid</strong> is invalid. </p>
</td>
</tr>
<tr id="row887259560084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1569187081084824"><a name="p1569187081084824"></a><a name="p1569187081084824"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p194104205084824"><a name="p194104205084824"></a><a name="p194104205084824"></a>No setting permission. </p>
</td>
</tr>
</tbody>
</table>

## setgid\(\)<a name="ga3116233500c2c34795d437eaf34b69b5"></a>

```
int setgid (gid_t gid)
```

 **Description:**

Sets the user group ID of the calling process. 

**Parameters:**

<a name="table980006017084824"></a>
<table><thead align="left"><tr id="row430950611084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1382045551084824"><a name="p1382045551084824"></a><a name="p1382045551084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p474425973084824"><a name="p474425973084824"></a><a name="p474425973084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1579810811084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">gid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the user group ID to set. </td>
</tr>
</tbody>
</table>

**Attention:**

The real user group ID is the same as the effective user group ID and saved user group ID. 

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1287536363084824"></a>
<table><thead align="left"><tr id="row1224551328084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1342395151084824"><a name="p1342395151084824"></a><a name="p1342395151084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p74439526084824"><a name="p74439526084824"></a><a name="p74439526084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1672251241084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p608117857084824"><a name="p608117857084824"></a><a name="p608117857084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1584287753084824"><a name="p1584287753084824"></a><a name="p1584287753084824"></a><strong id="b61832073084824"><a name="b61832073084824"></a><a name="b61832073084824"></a>gid</strong> is invalid. </p>
</td>
</tr>
<tr id="row720060726084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p690913609084824"><a name="p690913609084824"></a><a name="p690913609084824"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1089827377084824"><a name="p1089827377084824"></a><a name="p1089827377084824"></a>No setting permission. </p>
</td>
</tr>
</tbody>
</table>

## setgroups\(\)<a name="gaf7df624933ff8690b60c537a29659718"></a>

```
int setgroups (size_t size, const gid_t * list )
```

 **Description:**

Sets the supplementary user group list of the calling process. 

**Parameters:**

<a name="table2131827187084824"></a>
<table><thead align="left"><tr id="row758955404084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p920397270084824"><a name="p920397270084824"></a><a name="p920397270084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p904909313084824"><a name="p904909313084824"></a><a name="p904909313084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1792887932084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum size of the supplementary user group list. If the value is <strong id="b1037008042084824"><a name="b1037008042084824"></a><a name="b1037008042084824"></a>0</strong>, the list is cleared. The maximum value is <strong id="b83225991084824"><a name="b83225991084824"></a><a name="b83225991084824"></a>255</strong>. </td>
</tr>
<tr id="row1672428292084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">list</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the target supplementary group list. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1164808245084824"></a>
<table><thead align="left"><tr id="row2128857361084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1093843837084824"><a name="p1093843837084824"></a><a name="p1093843837084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1163468606084824"><a name="p1163468606084824"></a><a name="p1163468606084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row786898572084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p393722934084824"><a name="p393722934084824"></a><a name="p393722934084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p161582024084824"><a name="p161582024084824"></a><a name="p161582024084824"></a><strong id="b589103302084824"><a name="b589103302084824"></a><a name="b589103302084824"></a>size</strong> is invalid. </p>
</td>
</tr>
<tr id="row459210235084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2021813019084824"><a name="p2021813019084824"></a><a name="p2021813019084824"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p168911579084824"><a name="p168911579084824"></a><a name="p168911579084824"></a>Invalid address. </p>
</td>
</tr>
<tr id="row1552569035084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1612522421084824"><a name="p1612522421084824"></a><a name="p1612522421084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p850324827084824"><a name="p850324827084824"></a><a name="p850324827084824"></a>Insufficient memory. </p>
</td>
</tr>
</tbody>
</table>

## setpgid\(\)<a name="gae5aae5b0275eefe79314a4673195e475"></a>

```
int setpgid (pid_t pid, pid_t pgid )
```

 **Description:**

Sets the ID of the process group whose process ID is specified by  **pid**. 

**Parameters:**

<a name="table686935753084824"></a>
<table><thead align="left"><tr id="row1579976641084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p5671467084824"><a name="p5671467084824"></a><a name="p5671467084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p158525196084824"><a name="p158525196084824"></a><a name="p158525196084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1133764700084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the process ID. If the value is <strong id="b1396889866084824"><a name="b1396889866084824"></a><a name="b1396889866084824"></a>0</strong>, the process group ID of the current process is obtained. </td>
</tr>
<tr id="row1789563045084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pgid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the process group ID. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1305550100084824"></a>
<table><thead align="left"><tr id="row1440595965084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p390604867084824"><a name="p390604867084824"></a><a name="p390604867084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p354280546084824"><a name="p354280546084824"></a><a name="p354280546084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row678471045084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p526227637084824"><a name="p526227637084824"></a><a name="p526227637084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p699311469084824"><a name="p699311469084824"></a><a name="p699311469084824"></a>Invalid process ID. </p>
</td>
</tr>
<tr id="row2073347174084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p632492060084824"><a name="p632492060084824"></a><a name="p632492060084824"></a>ESRCH </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p567617142084824"><a name="p567617142084824"></a><a name="p567617142084824"></a>The specified process cannot be found. </p>
</td>
</tr>
<tr id="row1558565747084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p463184730084824"><a name="p463184730084824"></a><a name="p463184730084824"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p398763572084824"><a name="p398763572084824"></a><a name="p398763572084824"></a>No permission to operate the process group. </p>
</td>
</tr>
<tr id="row2032053994084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1881813974084824"><a name="p1881813974084824"></a><a name="p1881813974084824"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p456415737084824"><a name="p456415737084824"></a><a name="p456415737084824"></a>The child process has performed <strong id="b719233633084824"><a name="b719233633084824"></a><a name="b719233633084824"></a>exec</strong>, and the parent process does not have the operation permission. </p>
</td>
</tr>
</tbody>
</table>

## setpgrp\(\)<a name="gada2b1e6782cd8fc506fde243f7d313ec"></a>

```
pid_t setpgrp (void )
```

 **Description:**

Sets the process group ID of the calling process. 

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value if the operation fails. 



## setregid\(\)<a name="ga869d651a498782b6f3625e2bdbc439d6"></a>

```
int setregid (gid_t rgid, gid_t egid )
```

 **Description:**

Sets the real and effective user group IDs of the calling process. 

**Parameters:**

<a name="table2140888116084824"></a>
<table><thead align="left"><tr id="row759291088084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1018102886084824"><a name="p1018102886084824"></a><a name="p1018102886084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1905143581084824"><a name="p1905143581084824"></a><a name="p1905143581084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row825594838084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">rgid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the real user group ID to set. If the value is <strong id="b1000728281084824"><a name="b1000728281084824"></a><a name="b1000728281084824"></a>-1</strong>, the real user group ID is left unchanged. </td>
</tr>
<tr id="row1548152509084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">egid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the effective user group ID to set. If the value is <strong id="b316209223084824"><a name="b316209223084824"></a><a name="b316209223084824"></a>-1</strong>, the effective user group ID is left unchanged. </td>
</tr>
</tbody>
</table>

**Attention:**

The real user group ID is the same as the effective user group ID and saved user group ID. 

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table673836197084824"></a>
<table><thead align="left"><tr id="row125987270084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1627258260084824"><a name="p1627258260084824"></a><a name="p1627258260084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p123126696084824"><a name="p123126696084824"></a><a name="p123126696084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1483808453084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p628335501084824"><a name="p628335501084824"></a><a name="p628335501084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1666503467084824"><a name="p1666503467084824"></a><a name="p1666503467084824"></a><strong id="b1526950663084824"><a name="b1526950663084824"></a><a name="b1526950663084824"></a>rgid</strong> or <strong id="b1933184554084824"><a name="b1933184554084824"></a><a name="b1933184554084824"></a>egid</strong> is invalid. </p>
</td>
</tr>
<tr id="row514000504084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p110208680084824"><a name="p110208680084824"></a><a name="p110208680084824"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1620294435084824"><a name="p1620294435084824"></a><a name="p1620294435084824"></a>No setting permission. </p>
</td>
</tr>
</tbody>
</table>

## setresgid\(\)<a name="gabb0ec1f467235bee75ee359400d817e4"></a>

```
int setresgid (gid_t rgid, gid_t egid, gid_t sgid )
```

 **Description:**

Sets the real, effective, and saved group IDs of the calling process. 

**Parameters:**

<a name="table1568904097084824"></a>
<table><thead align="left"><tr id="row513060151084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1079219840084824"><a name="p1079219840084824"></a><a name="p1079219840084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p752685460084824"><a name="p752685460084824"></a><a name="p752685460084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2089692801084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">rgid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the real user group ID to set. If the value is <strong id="b620022265084824"><a name="b620022265084824"></a><a name="b620022265084824"></a>-1</strong>, the real user group ID is left unchanged. </td>
</tr>
<tr id="row1508809867084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">egid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the effective user group ID to set. If the value is <strong id="b278275674084824"><a name="b278275674084824"></a><a name="b278275674084824"></a>-1</strong>, the effective user group ID is left unchanged. </td>
</tr>
<tr id="row1531655226084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">sgid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the saved group ID to set. If the value is <strong id="b510718691084824"><a name="b510718691084824"></a><a name="b510718691084824"></a>-1</strong>, the saved user group ID is left unchanged. </td>
</tr>
</tbody>
</table>

**Attention:**

The real user group ID is the same as the effective user group ID and saved user group ID. 

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table574295018084824"></a>
<table><thead align="left"><tr id="row125354725084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p996623431084824"><a name="p996623431084824"></a><a name="p996623431084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1464326011084824"><a name="p1464326011084824"></a><a name="p1464326011084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1670827425084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1139585515084824"><a name="p1139585515084824"></a><a name="p1139585515084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p614604655084824"><a name="p614604655084824"></a><a name="p614604655084824"></a><strong id="b40342009084824"><a name="b40342009084824"></a><a name="b40342009084824"></a>rgid</strong>, <strong id="b303106914084824"><a name="b303106914084824"></a><a name="b303106914084824"></a>egid</strong>, or <strong id="b775266010084824"><a name="b775266010084824"></a><a name="b775266010084824"></a>sgid</strong> is invalid. </p>
</td>
</tr>
<tr id="row1465704802084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1328621625084824"><a name="p1328621625084824"></a><a name="p1328621625084824"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1528202477084824"><a name="p1528202477084824"></a><a name="p1528202477084824"></a>No setting permission. </p>
</td>
</tr>
</tbody>
</table>

## setresuid\(\)<a name="gac3827ffb6833b1e282fc2ea856d534a1"></a>

```
int setresuid (uid_t ruid, uid_t euid, uid_t suid )
```

 **Description:**

Sets the real, effective, and saved user IDs of the calling process. 

**Parameters:**

<a name="table463931099084824"></a>
<table><thead align="left"><tr id="row742922394084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p112975952084824"><a name="p112975952084824"></a><a name="p112975952084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1428454282084824"><a name="p1428454282084824"></a><a name="p1428454282084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1648436705084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ruid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the real user ID to set. If the value is <strong id="b783505070084824"><a name="b783505070084824"></a><a name="b783505070084824"></a>-1</strong>, the real user ID is left unchanged. </td>
</tr>
<tr id="row1202409379084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">euid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the effective user ID to set. If the value is <strong id="b1230274289084824"><a name="b1230274289084824"></a><a name="b1230274289084824"></a>-1</strong>, the effective user ID is left unchanged. </td>
</tr>
<tr id="row178180063084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">suid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the saved user ID to set. If the value is <strong id="b1659153683084824"><a name="b1659153683084824"></a><a name="b1659153683084824"></a>-1</strong>, the saved user ID is left unchanged. </td>
</tr>
</tbody>
</table>

**Attention:**

The real user ID is the same as the effective user ID and saved user ID. 

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1379396784084824"></a>
<table><thead align="left"><tr id="row1597172164084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p893940155084824"><a name="p893940155084824"></a><a name="p893940155084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1743517921084824"><a name="p1743517921084824"></a><a name="p1743517921084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row2089532578084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p299013975084824"><a name="p299013975084824"></a><a name="p299013975084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1424473692084824"><a name="p1424473692084824"></a><a name="p1424473692084824"></a><strong id="b1368060856084824"><a name="b1368060856084824"></a><a name="b1368060856084824"></a>ruid</strong>, <strong id="b1732014030084824"><a name="b1732014030084824"></a><a name="b1732014030084824"></a>euid</strong>, or <strong id="b1626386362084824"><a name="b1626386362084824"></a><a name="b1626386362084824"></a>suid</strong> is invalid. </p>
</td>
</tr>
<tr id="row974508605084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p208383862084824"><a name="p208383862084824"></a><a name="p208383862084824"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p672019744084824"><a name="p672019744084824"></a><a name="p672019744084824"></a>No setting permission. </p>
</td>
</tr>
</tbody>
</table>

## setreuid\(\)<a name="ga0c1be1c8a11bac9cdf41613e996c841b"></a>

```
int setreuid (uid_t ruid, uid_t euid )
```

 **Description:**

Sets the real and effective user IDs of the calling process. 

**Parameters:**

<a name="table1464559304084824"></a>
<table><thead align="left"><tr id="row273081848084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1931651848084824"><a name="p1931651848084824"></a><a name="p1931651848084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1684639461084824"><a name="p1684639461084824"></a><a name="p1684639461084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1466959304084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ruid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the real user ID to set. If the value is <strong id="b1431149148084824"><a name="b1431149148084824"></a><a name="b1431149148084824"></a>-1</strong>, the real user ID is left unchanged. </td>
</tr>
<tr id="row870426670084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">euid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the effective user ID to set. If the value is <strong id="b598953335084824"><a name="b598953335084824"></a><a name="b598953335084824"></a>-1</strong>, the effective user ID is left unchanged. </td>
</tr>
</tbody>
</table>

**Attention:**

The real user ID is the same as the effective user ID and saved user ID. 

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table600112603084824"></a>
<table><thead align="left"><tr id="row1138963424084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p577614794084824"><a name="p577614794084824"></a><a name="p577614794084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1363427064084824"><a name="p1363427064084824"></a><a name="p1363427064084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1984442258084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1502306201084824"><a name="p1502306201084824"></a><a name="p1502306201084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p651721604084824"><a name="p651721604084824"></a><a name="p651721604084824"></a><strong id="b632065873084824"><a name="b632065873084824"></a><a name="b632065873084824"></a>ruid</strong> or <strong id="b1802552190084824"><a name="b1802552190084824"></a><a name="b1802552190084824"></a>euid</strong> is invalid. </p>
</td>
</tr>
<tr id="row1625527835084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p527065487084824"><a name="p527065487084824"></a><a name="p527065487084824"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2107254337084824"><a name="p2107254337084824"></a><a name="p2107254337084824"></a>No setting permission. </p>
</td>
</tr>
</tbody>
</table>

## setstate\(\)<a name="gaa4970d8361258d9b821ad83036a2da3a"></a>

```
char* setstate (char * state)
```

 **Description:**

Sets the current state list for subsequent random use. 

**Parameters:**

<a name="table709870536084824"></a>
<table><thead align="left"><tr id="row679665566084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2094368644084824"><a name="p2094368644084824"></a><a name="p2094368644084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p231141256084824"><a name="p231141256084824"></a><a name="p231141256084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1643207897084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">state</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the state list. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the current state list if the operation is successful; returns  **NULL**  if the operation fails.  **errno**  is set to  **EINVAL**  if  **state**  is empty or the size of the state list is less than 8 bytes. 



## setuid\(\)<a name="gaa426fc963bb0a4f469eef61d9f0c4a26"></a>

```
int setuid (uid_t uid)
```

 **Description:**

Sets the real user ID for the calling process. 

**Parameters:**

<a name="table1241440332084824"></a>
<table><thead align="left"><tr id="row1485372180084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p631154957084824"><a name="p631154957084824"></a><a name="p631154957084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1781668391084824"><a name="p1781668391084824"></a><a name="p1781668391084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1564541922084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">uid</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the user ID to set. </td>
</tr>
</tbody>
</table>

**Attention:**

The real user ID is the same as the effective user ID and saved user ID. 

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1774306223084824"></a>
<table><thead align="left"><tr id="row1804484069084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p916649963084824"><a name="p916649963084824"></a><a name="p916649963084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1616995166084824"><a name="p1616995166084824"></a><a name="p1616995166084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row2817595084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1142965231084824"><a name="p1142965231084824"></a><a name="p1142965231084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1694096747084824"><a name="p1694096747084824"></a><a name="p1694096747084824"></a><strong id="b570475808084824"><a name="b570475808084824"></a><a name="b570475808084824"></a>uid</strong> is invalid. </p>
</td>
</tr>
<tr id="row946109159084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1655275596084824"><a name="p1655275596084824"></a><a name="p1655275596084824"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1558427531084824"><a name="p1558427531084824"></a><a name="p1558427531084824"></a>No setting permission. </p>
</td>
</tr>
</tbody>
</table>

## sleep\(\)<a name="gad4669b3813c3b4a616a738317fdc974f"></a>

```
unsigned sleep (unsigned seconds)
```

 **Description:**

Sleeps for a period of time. 

This function is used to stop the current thread until the specified time. A sleeping thread cannot be woken up by a signal. 

**Parameters:**

<a name="table1294164803084824"></a>
<table><thead align="left"><tr id="row56187308084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p9146833084824"><a name="p9146833084824"></a><a name="p9146833084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p339469272084824"><a name="p339469272084824"></a><a name="p339469272084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1822179711084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">seconds</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the sleeping seconds. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the seconds if the operation is successful; returns  **0**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1894017419084824"></a>
<table><thead align="left"><tr id="row1424654447084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p110655893084824"><a name="p110655893084824"></a><a name="p110655893084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1680991236084824"><a name="p1680991236084824"></a><a name="p1680991236084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1762951146084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p545432782084824"><a name="p545432782084824"></a><a name="p545432782084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1968167820084824"><a name="p1968167820084824"></a><a name="p1968167820084824"></a>Incorrect input. </p>
</td>
</tr>
</tbody>
</table>

## srand\(\)<a name="ga83a727cc697aea22e24cad5f39198dd2"></a>

```
void srand (unsigned int seed)
```

 **Description:**

Initializes a random number generator. 

**Parameters:**

<a name="table1639000598084824"></a>
<table><thead align="left"><tr id="row127705701084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1194260181084824"><a name="p1194260181084824"></a><a name="p1194260181084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p676494900084824"><a name="p676494900084824"></a><a name="p676494900084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row304925510084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">seed</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the seed for generating a pseudo-random number. </td>
</tr>
</tbody>
</table>

**Attention:**

If  **seed**  is  **0**, this function is equivalent to  **srand\(1\)**. Before the  **[rand\(\)](utils.md#gae23144bcbb8e3742b00eb687c36654d1)**  function is executed, this function is used to initialize different algorithm seeds to generate true random numbers. 



## srand48\(\)<a name="ga91c6acf8516086891c689926e49f1ddf"></a>

```
void srand48 (long int seedval)
```

 **Description:**

Sets the start seed value for the pseudo-random number generator. 

**Parameters:**

<a name="table179224414084824"></a>
<table><thead align="left"><tr id="row534530847084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1431664607084824"><a name="p1431664607084824"></a><a name="p1431664607084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1988129396084824"><a name="p1988129396084824"></a><a name="p1988129396084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1015735068084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">seedval</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the 48-bit start seed value. </td>
</tr>
</tbody>
</table>

**Attention:**

This function sets the high order 32 bits of  **Xi**  to  **seedval**. The lower order 16 bits are set to  **0x330E**. 



## srandom\(\)<a name="gaf1e7e3d144face36372f9ae8b18aa009"></a>

```
void srandom (unsigned int seed)
```

 **Description:**

Initializes a random number generator. 

**Parameters:**

<a name="table32644551084824"></a>
<table><thead align="left"><tr id="row905154568084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1094224846084824"><a name="p1094224846084824"></a><a name="p1094224846084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p657764802084824"><a name="p657764802084824"></a><a name="p657764802084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1583829129084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">seed</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the seed for generating a pseudo-random number. </td>
</tr>
</tbody>
</table>

## stpcpy\(\)<a name="ga890dbcd7c456828c1b6ff714e405fcc1"></a>

```
char* stpcpy (char * dest, const char * src )
```

 **Description:**

Copies a string. 

This function copies the source string to the destination string and returns the pointer to the terminating null byte  **\\0**  of the destination string. 

**Parameters:**

<a name="table910067351084824"></a>
<table><thead align="left"><tr id="row1557473945084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1984024324084824"><a name="p1984024324084824"></a><a name="p1984024324084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p184827927084824"><a name="p184827927084824"></a><a name="p184827927084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row628856734084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination string. </td>
</tr>
<tr id="row1890649260084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the source string. </td>
</tr>
</tbody>
</table>

**Attention:**

The null byte  **\\0**  in the source string is also copied to the destination string. The two strings cannot overlap. The destination string must be large enough to receive the copied string. You should be aware of a buffer overflow. 

**Returns:**

Returns the pointer to the terminating null byte  **\\0**  of the destination string. 



## stpncpy\(\)<a name="ga217a70a69e2fc7727278516b7ad2fc26"></a>

```
char* stpncpy (char * dest, const char * src, size_t n )
```

 **Description:**

Copies n characters of a string. 

This function copies n characters of the source string to the destination string and returns the pointer to the terminating null byte  **\\0**  of the destination string. 

**Parameters:**

<a name="table1466694459084824"></a>
<table><thead align="left"><tr id="row1849362804084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p238353366084824"><a name="p238353366084824"></a><a name="p238353366084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1658682848084824"><a name="p1658682848084824"></a><a name="p1658682848084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1262722912084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination string. </td>
</tr>
<tr id="row1886939210084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the source string. </td>
</tr>
<tr id="row2113555246084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of characters to be copied. </td>
</tr>
</tbody>
</table>

**Attention:**

The null byte  **\\0**  in the source string is also copied to the destination string. The two strings cannot overlap. The destination string must be large enough to receive the copied string. You should be aware of a buffer overflow. If the length of the source string is less than  **n**, this function copies the null byte  **\\0**  to the destination string. 

**Returns:**

Returns the pointer to the terminating null byte  **\\0**  of the destination string if the operation is successful; returns the pointer to the  **\(dest+n\)**  position if the destination string does not end with  **\\0**. 



## strcasecmp\(\)<a name="ga2436604f43de7f27e7434ceea7d64528"></a>

```
int strcasecmp (const char * _l, const char * _r )
```

 **Description:**

Compares two strings \(string 1 and string 2\), regardless of the letter case. 

**Parameters:**

<a name="table690037159084824"></a>
<table><thead align="left"><tr id="row1772962736084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p798748185084824"><a name="p798748185084824"></a><a name="p798748185084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p768405873084824"><a name="p768405873084824"></a><a name="p768405873084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1169781653084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">_l</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to string 1 for comparison. </td>
</tr>
<tr id="row29626383084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">_r</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to string 2 for comparison. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the two strings are equal; returns a value greater than  **0**  if  **\_l**  is greater than  **\_r**; returns a value less than  **0**  if  **\_l**  is less than  **\_r**. 



## strcasestr\(\)<a name="gae9229017a4501f8d6a637b4498cfed2e"></a>

```
char* strcasestr (const char * haystack, const char * needle )
```

 **Description:**

Searches for a needle string in its haystack string and returns a pointer. 

**Parameters:**

<a name="table1288163569084824"></a>
<table><thead align="left"><tr id="row76958978084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p395110526084824"><a name="p395110526084824"></a><a name="p395110526084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p490597288084824"><a name="p490597288084824"></a><a name="p490597288084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row509912473084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">haystack</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the haystack string. </td>
</tr>
<tr id="row2086741766084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">needle</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the needle string. </td>
</tr>
</tbody>
</table>

**Attention:**

The case difference is ignored during comparison. 

**Returns:**

Returns the pointer to the beginning of the first needle string found in the haystack string if the operation is successful; returns  **NULL**  if the needle string is not found in the haystack string. 



## strcat\(\)<a name="gadb8723e585ed29f2370cddf90f6891bc"></a>

```
char* strcat (char * dest, const char * src )
```

 **Description:**

Appends a string to another one. 

This function appends the source string to the destination string. 

**Parameters:**

<a name="table505570917084824"></a>
<table><thead align="left"><tr id="row1335845831084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p364275570084824"><a name="p364275570084824"></a><a name="p364275570084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p208454681084824"><a name="p208454681084824"></a><a name="p208454681084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row817648799084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination string. </td>
</tr>
<tr id="row681378064084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the source string. </td>
</tr>
</tbody>
</table>

**Attention:**

The null byte  **\\0**  of the destination string will be overwritten by the first byte of the source string. The destination string must have enough space for data storage. Otherwise, a buffer overflow may occur. If the destination string is not large enough, the program behavior will be unpredictable, and buffer overflows are the favorite choice for attacking secure programs. 

**Returns:**

Returns the pointer to the destination string. 



## strchr\(\)<a name="ga12871ed234858ef0e363d2b8aa572fc1"></a>

```
char* strchr (const char * s, int c )
```

 **Description:**

Locates the first occurrence of a character in a string. 

 

**Parameters:**

<a name="table1094664574084824"></a>
<table><thead align="left"><tr id="row427535223084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1731207971084824"><a name="p1731207971084824"></a><a name="p1731207971084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p546407960084824"><a name="p546407960084824"></a><a name="p546407960084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row590881665084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to be searched. </td>
</tr>
<tr id="row1702604134084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the character to be searched for. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the position that the character appears for the first time in the string if the operation is successful; returns  **NULL**  if the character is not found in the string. 



## strcmp\(\)<a name="ga11bd144d7d44914099a3aeddf1c8567d"></a>

```
int strcmp (const char * s1, const char * s2 )
```

 **Description:**

Compares two strings by characters. 

**Parameters:**

<a name="table1926412912084824"></a>
<table><thead align="left"><tr id="row2112272882084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1546074831084824"><a name="p1546074831084824"></a><a name="p1546074831084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p963766532084824"><a name="p963766532084824"></a><a name="p963766532084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row471652869084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to string 1 for comparison. </td>
</tr>
<tr id="row441172331084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to string 2 for comparison. </td>
</tr>
</tbody>
</table>

**Attention:**

The two strings are compared based on the ASCII code. 

**Returns:**

Returns  **0**  if the operation is successful \(the two strings are the same\); returns the result of the ASCII character of string 1 minus the ASCII character of string 2 if the first pair of characters is at different positions in string 1 and string 2. 



## strcoll\(\)<a name="gaa4718e50ed45c2275c5d85a121d68097"></a>

```
int strcoll (const char * s1, const char * s2 )
```

 **Description:**

Compares two strings by character for the program's current locale. 

**Parameters:**

<a name="table84238159084824"></a>
<table><thead align="left"><tr id="row1189591235084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1213653110084824"><a name="p1213653110084824"></a><a name="p1213653110084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p688339233084824"><a name="p688339233084824"></a><a name="p688339233084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2034705577084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to string 1 for comparison. </td>
</tr>
<tr id="row76121833084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to string 2 for comparison. </td>
</tr>
</tbody>
</table>

**Attention:**

By default, the program's current locale specified by  **LC\_COLLATE**  is POSIX or C. 

**Returns:**

Returns  **0**  if the operation is successful \(the two strings are the same\); returns an integer less than  **0**  if the value of a character in string 1 is less than the value of the corresponding character in string 2 when the first unmatched character appears; returns an integer greater than  **0**  if the value of a character in string 1 is greater than the value of the corresponding character in string 2 when the first unmatched character appears. 



## strcoll\_l\(\)<a name="ga2294f2f1c4eaef870ef3d5d90e5cb36f"></a>

```
int strcoll_l (const char * s1, const char * s2, locale_t locale )
```

 **Description:**

Compares two strings by character for the specified locale. 

**Parameters:**

<a name="table1358844702084824"></a>
<table><thead align="left"><tr id="row487343746084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1500437121084824"><a name="p1500437121084824"></a><a name="p1500437121084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p227185514084824"><a name="p227185514084824"></a><a name="p227185514084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1727306300084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to string 1 for comparison. </td>
</tr>
<tr id="row2128661934084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to string 2 for comparison. </td>
</tr>
<tr id="row1233158310084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful \(the two strings are the same\); returns an integer less than  **0**  if the value of a character in string 1 is less than the value of the corresponding character in string 2 when the first unmatched character appears; returns an integer greater than  **0**  if the value of a character in string 1 is greater than the value of the corresponding character in string 2 when the first unmatched character appears. 



## strcpy\(\)<a name="ga7a82515b5d377be04817715c5465b647"></a>

```
char* strcpy (char * dest, const char * src )
```

 **Description:**

Copies a string. 

This function copies the source string pointed to by  **s**  to the destination string pointed to by  **s**  and returns the pointer to the destination string. 

**Parameters:**

<a name="table146009208084824"></a>
<table><thead align="left"><tr id="row918286500084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2127599124084824"><a name="p2127599124084824"></a><a name="p2127599124084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1707892957084824"><a name="p1707892957084824"></a><a name="p1707892957084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1230058229084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination string. </td>
</tr>
<tr id="row81380484084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the source string. </td>
</tr>
</tbody>
</table>

**Attention:**

The terminating null byte  **\\0**  in the source string is also copied to the destination string. The two strings cannot overlap. The destination string must be large enough to receive the copied string. You should be aware of a buffer overflow. 

**Returns:**

Returns the pointer to the destination string. 



## strcspn\(\)<a name="gaeb6c449e5d77477c057abf00eaaf88fe"></a>

```
size_t strcspn (const char * s, const char * reject )
```

 **Description:**

Obtains the length of the initial segment of a string that contains characters not in reject. 

This function is used to determine whether the characters in the string pointed to by  **s**  are in the string pointed to by  **reject**. 

**Parameters:**

<a name="table365250885084824"></a>
<table><thead align="left"><tr id="row1098390449084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p686448615084824"><a name="p686448615084824"></a><a name="p686448615084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1920759797084824"><a name="p1920759797084824"></a><a name="p1920759797084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row672925097084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to be retrieved. </td>
</tr>
<tr id="row580634853084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">reject</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string containing all unmatched characters. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the total number of consecutive unmatched characters in the initial segment of the string pointed to by  **s**  if the operation is successful; returns the length of the string pointed to by  **s**  if its characters cannot be found in the string pointed to by  **reject**. 



## strdup\(\)<a name="gab1cc1a3ff560049e22576031c7c2345b"></a>

```
char* strdup (const char * s)
```

 **Description:**

Copies a string to a new position. 

**Parameters:**

<a name="table1215069106084824"></a>
<table><thead align="left"><tr id="row264261498084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1335768574084824"><a name="p1335768574084824"></a><a name="p1335768574084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1300081707084824"><a name="p1300081707084824"></a><a name="p1300081707084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1339985595084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to be copied. </td>
</tr>
</tbody>
</table>

**Attention:**

The memory space is dynamically allocated in the function. Therefore, when the returned string is not required, the allocated memory space needs to be released. Otherwise, memory leakage occurs. 

**Returns:**

Returns the pointer to the memory space holding the copied string if the operation is successful; returns  **NULL**  if the memory space for the copied string is insufficient. 



## strerror\(\)<a name="gadd46ab98f32b76457852dbb872842bf2"></a>

```
char* strerror (int errnum)
```

 **Description:**

Obtains an error description string of the specified error code. 

This function queries the string representation of the error description matching the error code specified by  **errnum**. 

**Parameters:**

<a name="table936171763084824"></a>
<table><thead align="left"><tr id="row1565839858084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p590795952084824"><a name="p590795952084824"></a><a name="p590795952084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1747364346084824"><a name="p1747364346084824"></a><a name="p1747364346084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row35477143084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">errnum</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the error code. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table1796611675084824"></a>
<table><thead align="left"><tr id="row726121825084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1417667473084824"><a name="p1417667473084824"></a><a name="p1417667473084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p743183425084824"><a name="p743183425084824"></a><a name="p743183425084824"></a>description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1106706978084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p708787536084824"><a name="p708787536084824"></a><a name="p708787536084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1160337529084824"><a name="p1160337529084824"></a><a name="p1160337529084824"></a><strong id="b380577841084824"><a name="b380577841084824"></a><a name="b380577841084824"></a>errnum</strong> is invalid. </p>
</td>
</tr>
</tbody>
</table>

## strerror\_l\(\)<a name="ga8f7507e357cbd24048ae77e27e5d41d7"></a>

```
char* strerror_l (int errnum, locale_t locale )
```

 **Description:**

Obtains an error description string of the specified error code for the specified locale. 

This function queries the string representation of the error description matching the error code specified by  **errnum**. 

**Parameters:**

<a name="table820789867084824"></a>
<table><thead align="left"><tr id="row1597893686084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1335026790084824"><a name="p1335026790084824"></a><a name="p1335026790084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p46454187084824"><a name="p46454187084824"></a><a name="p46454187084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row176465960084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">errnum</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the error code. </td>
</tr>
<tr id="row724226837084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the appropriate error description string if the operation is successful; returns  **NULL**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table1241262577084824"></a>
<table><thead align="left"><tr id="row1725256747084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1181633482084824"><a name="p1181633482084824"></a><a name="p1181633482084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p17530224084824"><a name="p17530224084824"></a><a name="p17530224084824"></a>description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row977727780084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p789088808084824"><a name="p789088808084824"></a><a name="p789088808084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1582285036084824"><a name="p1582285036084824"></a><a name="p1582285036084824"></a><strong id="b897403079084824"><a name="b897403079084824"></a><a name="b897403079084824"></a>errnum</strong> is invalid. </p>
</td>
</tr>
<tr id="row149541878084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1381213580084824"><a name="p1381213580084824"></a><a name="p1381213580084824"></a>ERANGE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p239732452084824"><a name="p239732452084824"></a><a name="p239732452084824"></a>The buffer is insufficient to contain the error description string. </p>
</td>
</tr>
</tbody>
</table>

## strerror\_r\(\)<a name="ga7253ba059153058c57952194237c6b55"></a>

```
char* strerror_r (int errnum, char * buf, size_t buflen )
```

 **Description:**

Obtains an error description string of the specified error code. 

This function queries the string representation of the error description matching the error code specified by  **errnum**. 

**Parameters:**

<a name="table437036736084824"></a>
<table><thead align="left"><tr id="row1508791964084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p78665242084824"><a name="p78665242084824"></a><a name="p78665242084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1695651946084824"><a name="p1695651946084824"></a><a name="p1695651946084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1197261927084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">errnum</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the error code. </td>
</tr>
<tr id="row1627494762084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the buffer for storing the error description string. </td>
</tr>
<tr id="row181268640084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buflen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the <strong id="b1792374403084824"><a name="b1792374403084824"></a><a name="b1792374403084824"></a>buf</strong> parameter. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the appropriate error description string if the operation is successful; returns  **NULL**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table39442646084824"></a>
<table><thead align="left"><tr id="row173848307084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p702111014084824"><a name="p702111014084824"></a><a name="p702111014084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2087584393084824"><a name="p2087584393084824"></a><a name="p2087584393084824"></a>description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1454249836084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p789754182084824"><a name="p789754182084824"></a><a name="p789754182084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1871837448084824"><a name="p1871837448084824"></a><a name="p1871837448084824"></a><strong id="b1437855037084824"><a name="b1437855037084824"></a><a name="b1437855037084824"></a>errnum</strong> is invalid. </p>
</td>
</tr>
<tr id="row147212785084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p236546677084824"><a name="p236546677084824"></a><a name="p236546677084824"></a>ERANGE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1476182669084824"><a name="p1476182669084824"></a><a name="p1476182669084824"></a>The buffer is insufficient to contain the error description string. </p>
</td>
</tr>
</tbody>
</table>

## strfmon\(\)<a name="ga3a0a6c5c58dd47a875b745fca1a558fa"></a>

```
ssize_t strfmon (char * s, size_t max, const char * format,  ... )
```

 **Description:**

Converts a monetary value to a string. 

This function formats the monetary parameters according to a specified format and saves the results as a string. 

**Parameters:**

<a name="table1794506844084824"></a>
<table><thead align="left"><tr id="row1182203140084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p856666950084824"><a name="p856666950084824"></a><a name="p856666950084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p705946783084824"><a name="p705946783084824"></a><a name="p705946783084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1869210873084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the target string. </td>
</tr>
<tr id="row422653532084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">max</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum length of the target string. </td>
</tr>
<tr id="row1507495650084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format of the string. </td>
</tr>
<tr id="row1617702255084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">...</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameters corresponding to the format. </td>
</tr>
</tbody>
</table>

**Attention:**

For details about currency symbols, see  [lconv](lconv.md). 

**Returns:**

Returns number of bytes stored in the target string, excluding the terminating null byte  **\\0**, if the operation is successful; returns  **-1**  sets  **errno**  to  [E2BIG](utils.md#gaba8481985c201ff726f349d7f2d09895)  if the operation fails. 



## strlcat\(\)<a name="ga0266462615f2f112003cdb591710d299"></a>

```
size_t strlcat (char * d, const char * s, size_t n )
```

 **Description:**

Appends the first  **n**  bytes of a string to another one. 

This function appends the first  **n**  bytes of the source string to the destination string. 

**Parameters:**

<a name="table1165751440084824"></a>
<table><thead align="left"><tr id="row540552950084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1167807070084824"><a name="p1167807070084824"></a><a name="p1167807070084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p680781732084824"><a name="p680781732084824"></a><a name="p680781732084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row545006461084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">d</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination string. </td>
</tr>
<tr id="row1825560927084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the source string. </td>
</tr>
<tr id="row1020549045084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of characters to be copied from the source string. </td>
</tr>
</tbody>
</table>

**Attention:**

The null byte  **\\0**  of the destination string will be overwritten by the first byte of the source string, and the source string will end with  **\\0**. 

**Returns:**

Returns  **strlen\(src\)**  plus  **MIN\(n, strlen\(initial d\)\)**. 



## strlcpy\(\)<a name="ga50bd3317d65f3da7d180b8981e58c5a4"></a>

```
size_t strlcpy (char * d, const char * s, size_t n )
```

 **Description:**

Copies a string. 

This function copies n bytes of the source string pointed to by  **s**  to the destination string pointed to by  **d**. 

**Parameters:**

<a name="table1699006412084824"></a>
<table><thead align="left"><tr id="row64203633084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p543987589084824"><a name="p543987589084824"></a><a name="p543987589084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p6235702084824"><a name="p6235702084824"></a><a name="p6235702084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1872415112084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">d</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination string. </td>
</tr>
<tr id="row1668292841084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the source string. </td>
</tr>
<tr id="row1316801210084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of characters to be copied from the source string. </td>
</tr>
</tbody>
</table>

**Attention:**

If the value of  **n**  is the same as the length of the destination string, the last character of the destination string will be  **\\0**. 

**Returns:**

Returns the length of the source string, excluding the null byte  **\\0**. 



## strlen\(\)<a name="gaa383452fe445bfae989358c9d7d96f4f"></a>

```
size_t strlen (const char * s)
```

 **Description:**

Calculates the length of a string. 

The length of a string does not include the terminating null byte  **\\0**  of the string. 

**Parameters:**

<a name="table1975292092084824"></a>
<table><thead align="left"><tr id="row1112679716084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1075702585084824"><a name="p1075702585084824"></a><a name="p1075702585084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p228210252084824"><a name="p228210252084824"></a><a name="p228210252084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row843878384084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the string length. 



## strncasecmp\(\)<a name="ga103fd689d8438a246e0cd4d90cb084ac"></a>

```
int strncasecmp (const char * _l, const char * _r, size_t n )
```

 **Description:**

Compares a specified length of two strings \(string 1 and string 2\), regardless of the letter case. 

**Parameters:**

<a name="table1654989719084824"></a>
<table><thead align="left"><tr id="row882083345084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1125789669084824"><a name="p1125789669084824"></a><a name="p1125789669084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p96667438084824"><a name="p96667438084824"></a><a name="p96667438084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1652211504084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">_l</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to string 1 for comparison. </td>
</tr>
<tr id="row2040505664084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">_r</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to string 2 for comparison. </td>
</tr>
<tr id="row1117262184084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the string length to be compared. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the two strings are equal; returns a value greater than  **0**  if  **\_l**  is greater than  **\_r**; returns a value less than  **0**  if  **\_l**  is less than  **\_r**. 



## strncat\(\)<a name="ga0aee928c2844a269966e4832fd2255c5"></a>

```
char* strncat (char * dest, const char * src, size_t n )
```

 **Description:**

Appends the first  **n**  bytes of a string to another one. 

This function appends the first  **n**  bytes of the source string to the destination string. 

**Parameters:**

<a name="table946480875084824"></a>
<table><thead align="left"><tr id="row1123260338084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2085722804084824"><a name="p2085722804084824"></a><a name="p2085722804084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1179727354084824"><a name="p1179727354084824"></a><a name="p1179727354084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1789192586084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination string. </td>
</tr>
<tr id="row1942890468084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the source string. </td>
</tr>
<tr id="row938744053084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of bytes to be appended. </td>
</tr>
</tbody>
</table>

**Attention:**

The null byte  **\\0**  of the destination string will be overwritten by the first byte of the source string. The destination string must have enough space for data storage. Otherwise, a buffer overflow may occur. If the destination string is not large enough, the program behavior will be unpredictable, and buffer overflows are the favorite choice for attacking secure programs. 

**Returns:**

Returns the pointer to the destination string. 



## strncmp\(\)<a name="ga07f4a84c11c106e95c32b6ab509346ef"></a>

```
int strncmp (const char * s1, const char * s2, size_t n )
```

 **Description:**

Compares the first n characters of two strings. 

**Parameters:**

<a name="table15503457084824"></a>
<table><thead align="left"><tr id="row1957569862084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2102161122084824"><a name="p2102161122084824"></a><a name="p2102161122084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p991662378084824"><a name="p991662378084824"></a><a name="p991662378084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row752723086084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to string 1 for comparison. </td>
</tr>
<tr id="row650859620084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to string 2 for comparison. </td>
</tr>
<tr id="row1551782843084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of characters for comparison. </td>
</tr>
</tbody>
</table>

**Attention:**

The two strings are compared based on the ASCII code. 

**Returns:**

Returns  **0**  if the operation is successful \(the first n characters of the two strings are the same\); returns the result of the ASCII character of string 1 minus the ASCII character of string 2 if the first pair of characters is at different positions in string 1 and string 2. 



## strncpy\(\)<a name="ga47d54f24198df56da51078a6c540b9ed"></a>

```
char* strncpy (char * dest, const char * src, size_t n )
```

 **Description:**

Copies  **n**  characters of a string. 

This function copies  **n**  bytes of the source string pointed to by  **src**  to the destination string pointed to by  **dest**  and returns the pointer to the destination string. 

**Parameters:**

<a name="table1793278513084824"></a>
<table><thead align="left"><tr id="row1137304231084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1251201494084824"><a name="p1251201494084824"></a><a name="p1251201494084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1695292738084824"><a name="p1695292738084824"></a><a name="p1695292738084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1036126464084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination string. </td>
</tr>
<tr id="row2018695650084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the source string. </td>
</tr>
<tr id="row1131926254084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of characters to be copied from the source string. </td>
</tr>
</tbody>
</table>

**Attention:**

The null byte  **\\0**  in the source string is also copied to the destination string. The two strings cannot overlap. The destination string must be large enough to receive the copied string. You should be aware of a buffer overflow. If the length of the source string is less than  **n**, this function copies the null byte  **\\0**  to the destination string. 

**Returns:**

Returns the pointer to the destination string. 



## strndup\(\)<a name="ga8b860ba32fef12da8acd4507c059e509"></a>

```
char* strndup (const char * s, size_t n )
```

 **Description:**

Copies n characters of a string to a new position. 

**Parameters:**

<a name="table989875215084824"></a>
<table><thead align="left"><tr id="row2034551139084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p168423685084824"><a name="p168423685084824"></a><a name="p168423685084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1813228546084824"><a name="p1813228546084824"></a><a name="p1813228546084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1879602231084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to be copied. </td>
</tr>
<tr id="row658778033084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total number of characters to be copied. </td>
</tr>
</tbody>
</table>

**Attention:**

The memory space is dynamically allocated in the function. Therefore, when the returned string is not required, the allocated memory space needs to be released. Otherwise, memory leakage occurs. If the string is longer than  **n**, only  **n-1**  characters are copied and a terminating null byte  **\\0**  is added. 

**Returns:**

Returns the pointer to the memory space holding the copied string if the operation is successful; returns  **NULL**  if the memory space for the copied string is insufficient. 



## strnlen\(\)<a name="gafc92d2231e45d19988c7894aa2a07f0c"></a>

```
size_t strnlen (const char * s, size_t maxlen )
```

 **Description:**

Calculates the length of a string. 

The actual length of a string does not include the terminating null byte  **\\0**  of the string. 

**Parameters:**

<a name="table1818214434084824"></a>
<table><thead align="left"><tr id="row579894733084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1018692815084824"><a name="p1018692815084824"></a><a name="p1018692815084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1157568521084824"><a name="p1157568521084824"></a><a name="p1157568521084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1650835004084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string. </td>
</tr>
<tr id="row1699413597084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">maxlen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum length of the string. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the actual length of the string if it is less than the maximum length specified by  **maxlen**; returns the value of  **maxlen**  if the actual length is greater than the maximum length specified by  **maxlen**. 



## strpbrk\(\)<a name="ga119f23a5dcb4eb5f1c1eed3cbf5cb0ed"></a>

```
char* strpbrk (const char * s, const char * accept )
```

 **Description:**

Searches for any of a set of characters in a string. 

This function is used to determine whether the characters in the string pointed to by  **s**  are in the string pointed to by  **accept**. 

**Parameters:**

<a name="table283752214084824"></a>
<table><thead align="left"><tr id="row1125236444084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p370737605084824"><a name="p370737605084824"></a><a name="p370737605084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2029062758084824"><a name="p2029062758084824"></a><a name="p2029062758084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row632650247084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to be searched. </td>
</tr>
<tr id="row217489411084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">accept</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string containing all matched characters. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to a character in the string pointed to by  **s**  that first matches one of the characters in the string pointed to by  **accept**  if the operation is successful; returns  **NULL**  if no characters are found in the string pointed to by  **accept**. 



## strrchr\(\)<a name="ga0c05a458deff028ef4d4e64059098db4"></a>

```
char* strrchr (const char * s, int c )
```

 **Description:**

Locates the last occurrence of a character in a string. 

**Parameters:**

<a name="table243099358084824"></a>
<table><thead align="left"><tr id="row2083506249084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1103783389084824"><a name="p1103783389084824"></a><a name="p1103783389084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1023773560084824"><a name="p1023773560084824"></a><a name="p1023773560084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1381247613084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to be searched. </td>
</tr>
<tr id="row2063474012084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the character to be searched for. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the position that the character appears for the last time in the string if the operation is successful; returns  **NULL**  if the character is not found in the string. 



## strsep\(\)<a name="ga93c766c6e86f4f79e7507c21f1794e15"></a>

```
char* strsep (char ** stringp, const char * delim )
```

 **Description:**

Separates a string into a series of tokens separated by a delimiter. 

The function starts from  **\*stringp**  and checks whether the string matches a character in the string representing the delimiter. This operation is terminated by overwriting the delimiter with a null byte  **\\0**. 

**Parameters:**

<a name="table1594096449084824"></a>
<table><thead align="left"><tr id="row1214828423084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1545979160084824"><a name="p1545979160084824"></a><a name="p1545979160084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1719366959084824"><a name="p1719366959084824"></a><a name="p1719366959084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1299266570084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stringp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the first token of the source string. </td>
</tr>
<tr id="row1786074471084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">delim</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string representing the delimiter. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the first token; returns  **NULL**  if  **\*stringp**  is  **NULL**  or the delimiter is not found in the source string. 



## strsignal\(\)<a name="ga8f7c22bf1131bd6ffe6635e386fb4ebd"></a>

```
char* strsignal (int sig)
```

 **Description:**

Returns a string describing the signal number. 

**Parameters:**

<a name="table2106680960084824"></a>
<table><thead align="left"><tr id="row1779655572084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p230386403084824"><a name="p230386403084824"></a><a name="p230386403084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p291180609084824"><a name="p291180609084824"></a><a name="p291180609084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1081583994084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">sig</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the signal number to be parsed. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the signal description associated with the specified signal number if the operation is successful; returns  **NULL**  or an unknown signal message for an invalid signal number if the operation fails. 



## strspn\(\)<a name="ga900a0edfa51f601d479244f7451cedd1"></a>

```
size_t strspn (const char * s, const char * accept )
```

 **Description:**

Obtains the length of the initial segment of a string that contains characters in accept. 

This function is used to determine whether the characters in the string pointed to by  **s**  are in the string pointed to by  **accept**. 

**Parameters:**

<a name="table1701024791084824"></a>
<table><thead align="left"><tr id="row1288059393084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p801009668084824"><a name="p801009668084824"></a><a name="p801009668084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p312235735084824"><a name="p312235735084824"></a><a name="p312235735084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1791946760084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to be retrieved. </td>
</tr>
<tr id="row1969093978084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">accept</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string containing all matched characters. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the total number of consecutive matched characters in the initial segment of the string pointed to by  **s**  if the operation is successful; returns  **0**  if its characters cannot be found in the string pointed to by  **accept**. 



## strstr\(\)<a name="ga4a710d86541afc6b7dafddcdb4b1c94f"></a>

```
char* strstr (const char * haystack, const char * needle )
```

 **Description:**

Searches for a needle string in its haystack string. 

**Parameters:**

<a name="table1781229983084824"></a>
<table><thead align="left"><tr id="row1184386945084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p746320458084824"><a name="p746320458084824"></a><a name="p746320458084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p410340751084824"><a name="p410340751084824"></a><a name="p410340751084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1784497935084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">haystack</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the haystack string. </td>
</tr>
<tr id="row1510454132084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">needle</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the needle string. </td>
</tr>
</tbody>
</table>

**Attention:**

The null byte  **\\0**  in the needle string is not searched for. 

**Returns:**

Returns the pointer to the first occurrence of the needle string in the haystack string if the operation is successful; returns  **NULL**  if the needle string is not found in the haystack string. 



## strtod\(\)<a name="ga0c17a0b44f572941d9f73518f99ea7ed"></a>

```
double strtod (const char * nptr, char ** endptr )
```

 **Description:**

Converts a string to  **double**. 

This function skips the space characters, starts the conversion at a digit or a positive or negative sign, and ends at a non-digit or the terminating null byte  **'\\0'**. If the value of  **endptr**  is not  **NULL**, the pointer to the character in  **nptr**  where the conversion is terminated due to an invalid condition is stored in  **endptr**. 

**Parameters:**

<a name="table870133612084824"></a>
<table><thead align="left"><tr id="row985125130084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1666671702084824"><a name="p1666671702084824"></a><a name="p1666671702084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1532443688084824"><a name="p1532443688084824"></a><a name="p1532443688084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1524962041084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the input string. </td>
</tr>
<tr id="row119253963084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the double pointer to the first unrecognized character. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted value. 



## strtof\(\)<a name="ga2370632318c3797a314f8eb62d37947c"></a>

```
float strtof (const char * nptr, char ** endptr )
```

 **Description:**

Converts an input string to a floating-point number. 

This function skips the space characters, starts the conversion at a digit or a positive or negative sign, and ends at a non-digit or the terminating null byte  **'\\0'**. If the value of  **endptr**  is not  **NULL**, the pointer to the character in  **nptr**  where the conversion is terminated due to an invalid condition is stored in  **endptr**. 

**Parameters:**

<a name="table661810183084824"></a>
<table><thead align="left"><tr id="row1163597296084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1865216920084824"><a name="p1865216920084824"></a><a name="p1865216920084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p482638312084824"><a name="p482638312084824"></a><a name="p482638312084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1122824605084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the input string. </td>
</tr>
<tr id="row1391068942084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the double pointer to the first unrecognized character. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted value if the operation is successful. 



## strtoimax\(\)<a name="ga996146b4c9a860837a1f09868a6c0a61"></a>

```
intmax_t strtoimax (const char * str, char ** endptr, int base )
```

 **Description:**

Parses a string to a value of the  **intmax\_t**  type. 

This function is used to convert the string pointed to by  **str**  to a value of the  **intmax\_t**  type. If  **endptr**  is not a null pointer, the function also sets the value of  **endptr**  to point to the first character following the integer. 

**Parameters:**

<a name="table774700767084824"></a>
<table><thead align="left"><tr id="row1357590802084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p549279801084824"><a name="p549279801084824"></a><a name="p549279801084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p321104519084824"><a name="p321104519084824"></a><a name="p321104519084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row115310273084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">str</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to parse. </td>
</tr>
<tr id="row1933182214084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the double pointer to the first character following the integer obtained from <strong id="b1035741811084824"><a name="b1035741811084824"></a><a name="b1035741811084824"></a>str</strong>. </td>
</tr>
<tr id="row1673211337084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">base</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the conversion of number system. The common types are <strong id="b854467699084824"><a name="b854467699084824"></a><a name="b854467699084824"></a>2</strong>, <strong id="b1924171489084824"><a name="b1924171489084824"></a><a name="b1924171489084824"></a>8</strong>, <strong id="b1617083555084824"><a name="b1617083555084824"></a><a name="b1617083555084824"></a>10</strong>, and <strong id="b1181961066084824"><a name="b1181961066084824"></a><a name="b1181961066084824"></a>16</strong>, which indicate binary, octal, decimal, and hexadecimal, respectively. </td>
</tr>
</tbody>
</table>

**Attention:**

This function discards as many spaces as possible until the first non-space character is found. 

**Returns:**

Returns a floating-point number if the operation is successful; returns  **0**  if no conversion was performed; returns the positive or negative value of  [HUGE\_VAL](math.md#gaf2164b2db92d8a0ed3838ad5c28db971)  and sets  **errno**  to  [ERANGE](utils.md#gaa1591a4f3a86360108de5b9ba34980ca)  if the value falls out of the floating-point number range. 



## strtok\(\)<a name="ga8cb460f64c449f2a9b9b7a40569ce0fe"></a>

```
char* strtok (char * str, const char * delim )
```

 **Description:**

Separates a string into a series of tokens separated by a delimiter. 

**Parameters:**

<a name="table537380921084824"></a>
<table><thead align="left"><tr id="row660279422084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p42771038084824"><a name="p42771038084824"></a><a name="p42771038084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p506251321084824"><a name="p506251321084824"></a><a name="p506251321084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1068563323084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">str</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the first token in the string to be separated. This parameter is set to <strong id="b592531525084824"><a name="b592531525084824"></a><a name="b592531525084824"></a>NULL</strong> in subsequent calls to this function. </td>
</tr>
<tr id="row1623986131084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">delim</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the delimiter used to separate tokens. </td>
</tr>
</tbody>
</table>

**Attention:**

In each call of this function, the string is separated only once. You can call this function multiple times to separate the string into a set of tokens. 

**Returns:**

Returns the pointer to the first token in the string if the operation is successful; returns  **NULL**  if no delimiter is found in the string. 



## strtok\_r\(\)<a name="gab11d86a2a3af0a355cad2337c6f4e9f7"></a>

```
char* strtok_r (char * str, const char * delim, char ** saveptr )
```

 **Description:**

Separates a string into a series of tokens separated by a delimiter, with the  **saveptr**  parameter specified. 

**Parameters:**

<a name="table1614588135084824"></a>
<table><thead align="left"><tr id="row1237842878084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p810625752084824"><a name="p810625752084824"></a><a name="p810625752084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p451313241084824"><a name="p451313241084824"></a><a name="p451313241084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row894242615084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">str</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the first token in the string to be separated. This parameter is set to <strong id="b16676417084824"><a name="b16676417084824"></a><a name="b16676417084824"></a>NULL</strong> in subsequent calls to this function. </td>
</tr>
<tr id="row475183543084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">delim</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the delimiter used to separate tokens. </td>
</tr>
<tr id="row1443197354084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">saveptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the double pointer to the <strong id="b1401781406084824"><a name="b1401781406084824"></a><a name="b1401781406084824"></a>char *</strong> variable. </td>
</tr>
</tbody>
</table>

**Attention:**

In each call of this function, the string is separated only once. You can call this function multiple times to separate the string into a set of tokens.  **saveptr**  is specified to maintain context between successive calls that parse the same string. 

**Returns:**

Returns the pointer to the first token in the string if the operation is successful; returns  **NULL**  if no delimiter is found in the string. 



## strtol\(\)<a name="ga311071298c2fe3e5d7057f396a6acfdc"></a>

```
long strtol (const char * nptr, char ** endptr, int base )
```

 **Description:**

Converts a string to a long integer according to the given  **base**. 

**Parameters:**

<a name="table2002485228084824"></a>
<table><thead align="left"><tr id="row248130151084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2013103394084824"><a name="p2013103394084824"></a><a name="p2013103394084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p160825174084824"><a name="p160825174084824"></a><a name="p160825174084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2045255740084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the input string. </td>
</tr>
<tr id="row173396038084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the first character that is unrecognized. </td>
</tr>
<tr id="row786620051084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">base</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number system. </td>
</tr>
</tbody>
</table>

**Attention:**

The value of  **base**  ranges from  **2**  to  **36**. If the value of  **base**  is  **0**, the decimal format is used for conversion. Otherwise, the hexadecimal format is used, or the octal format is used if the next character is  **0**  instead of  **0x**. 

**Returns:**

Returns the converted value. 



## strtold\(\)<a name="gad2ed05594fb04a126627c0fd5c7e2232"></a>

```
long double strtold (const char * nptr, char ** endptr )
```

 **Description:**

Converts a string to  **long double**. 

This function skips the space characters, starts the conversion at a digit or a positive or negative sign, and ends at a non-digit or the terminating null byte  **'\\0'**. If the value of  **endptr**  is not  **NULL**, the pointer to the character in  **nptr**  where the conversion is terminated due to an invalid condition is stored in  **endptr**. 

**Parameters:**

<a name="table767621704084824"></a>
<table><thead align="left"><tr id="row121757260084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p809339514084824"><a name="p809339514084824"></a><a name="p809339514084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p540315872084824"><a name="p540315872084824"></a><a name="p540315872084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row637505003084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the input string. </td>
</tr>
<tr id="row1876984663084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the double pointer to the first unrecognized character. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted value. 



## strtoll\(\)<a name="gafb901aa665b7e2e3e27025ca77fecd1b"></a>

```
long long strtoll (const char * nptr, char ** endptr, int base )
```

 **Description:**

Converts a string to a long long integer according to the given  **base**. 

**Parameters:**

<a name="table951602455084824"></a>
<table><thead align="left"><tr id="row1304052123084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p411422171084824"><a name="p411422171084824"></a><a name="p411422171084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p758521299084824"><a name="p758521299084824"></a><a name="p758521299084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1297158365084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the input string. </td>
</tr>
<tr id="row1293522066084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the first character that is unrecognized. </td>
</tr>
<tr id="row1789583405084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">base</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number system. </td>
</tr>
</tbody>
</table>

**Attention:**

The value of  **base**  ranges from  **2**  to  **36**. If the value of  **base**  is  **0**, the decimal format is used for conversion. Otherwise, the hexadecimal format is used, or the octal format is used if the next character is  **0**  instead of  **0x**. 

**Returns:**

Returns the converted value. 



## strtoul\(\)<a name="ga6d257fc3f00865d0556ed7327c312b55"></a>

```
unsigned long strtoul (const char * nptr, char ** endptr, int base )
```

 **Description:**

Converts a string to an unsigned long integer according to the given  **base**. 

**Parameters:**

<a name="table198958034084824"></a>
<table><thead align="left"><tr id="row339768351084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1760669272084824"><a name="p1760669272084824"></a><a name="p1760669272084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p272439474084824"><a name="p272439474084824"></a><a name="p272439474084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1495676607084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the input string. </td>
</tr>
<tr id="row1917335742084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the first character that is unrecognized. </td>
</tr>
<tr id="row1335943507084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">base</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number system. </td>
</tr>
</tbody>
</table>

**Attention:**

The value of  **base**  ranges from  **2**  to  **36**. If the value of  **base**  is  **0**, the decimal format is used for conversion. Otherwise, the hexadecimal format is used, or the octal format is used if the next character is  **0**  instead of  **0x**. 

**Returns:**

Returns the converted value. 



## strtoull\(\)<a name="gae5835422eb2dfc17ea8deb3b15bcc541"></a>

```
unsigned long long strtoull (const char * nptr, char ** endptr, int base )
```

 **Description:**

Converts a string to an unsigned long long integer according to the given  **base**. 

**Parameters:**

<a name="table538080462084824"></a>
<table><thead align="left"><tr id="row103971822084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1381076204084824"><a name="p1381076204084824"></a><a name="p1381076204084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1730555745084824"><a name="p1730555745084824"></a><a name="p1730555745084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1800481192084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the input string. </td>
</tr>
<tr id="row846216302084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the first character that is unrecognized. </td>
</tr>
<tr id="row869424733084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">base</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number system. </td>
</tr>
</tbody>
</table>

**Attention:**

The value of  **base**  ranges from  **2**  to  **36**. If the value of  **base**  is  **0**, the decimal format is used for conversion. Otherwise, the hexadecimal format is used, or the octal format is used if the next character is  **0**  instead of  **0x**. 

**Returns:**

Returns the converted value. 



## strtoumax\(\)<a name="ga706f89e2b5a9a623207f2d77b19ff6f8"></a>

```
uintmax_t strtoumax (const char * str, char ** endptr, int base )
```

 **Description:**

Parses a string to a value of the  **uintmax\_t**  type. 

This function is used to convert the string pointed to by  **str**  to a value of the  **uintmax\_t**  type. If  **endptr**  is not a null pointer, the function also sets the value of  **endptr**  to point to the first character following the integer. 

**Parameters:**

<a name="table652332833084824"></a>
<table><thead align="left"><tr id="row207646234084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1809275518084824"><a name="p1809275518084824"></a><a name="p1809275518084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1384116261084824"><a name="p1384116261084824"></a><a name="p1384116261084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1910451212084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">str</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to parse. </td>
</tr>
<tr id="row1991175940084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the double pointer to the first character following the integer obtained from <strong id="b589122939084824"><a name="b589122939084824"></a><a name="b589122939084824"></a>str</strong>. </td>
</tr>
<tr id="row404610023084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">base</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the conversion of number system. </td>
</tr>
</tbody>
</table>

**Attention:**

This function discards as many spaces as possible until the first non-space character is found. 

**Returns:**

Returns a floating-point number if the operation is successful; returns  **0**  if no conversion was performed; returns the positive or negative value of  [HUGE\_VAL](math.md#gaf2164b2db92d8a0ed3838ad5c28db971)  and sets  **errno**  to  **ERANGE**  if the value falls out of the floating-point number range; returns a value that is not greater than the smallest positive normalized number if the correct value causes an overflow. 



## strverscmp\(\)<a name="ga1563a7059aabf95c0b588278e8bed575"></a>

```
int strverscmp (const char * s1, const char * s2 )
```

 **Description:**

Compares strings of two versions \(string 1 and string 2\) and returns the comparison result. 

**Parameters:**

<a name="table2002353895084824"></a>
<table><thead align="left"><tr id="row552287187084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p587782318084824"><a name="p587782318084824"></a><a name="p587782318084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p455296367084824"><a name="p455296367084824"></a><a name="p455296367084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1672335198084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to string 1 for comparison. </td>
</tr>
<tr id="row1023165206084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to string 2 for comparison. </td>
</tr>
</tbody>
</table>

**Attention:**

[strcmp](utils.md#ga11bd144d7d44914099a3aeddf1c8567d)  compares two strings based on the lexicographic order, while this function compares two strings based on the locale specified by  [LC\_COLLATE](io.md#gaab9cf7b1a206fb75e5884934c8d676db). 

**Returns:**

Returns any of the following values: Assuming that a difference is found at the xth character, 

<a name="table1721294621084824"></a>
<table><thead align="left"><tr id="row822548687084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1929101381084824"><a name="p1929101381084824"></a><a name="p1929101381084824"></a>Input </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p335384930084824"><a name="p335384930084824"></a><a name="p335384930084824"></a>Return Value  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1942878104084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1996628024084824"><a name="p1996628024084824"></a><a name="p1996628024084824"></a>The value for s1[x] is equal to that for s2[x]. </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1600930283084824"><a name="p1600930283084824"></a><a name="p1600930283084824"></a>The difference between the values </p>
</td>
</tr>
<tr id="row701188692084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1623206411084824"><a name="p1623206411084824"></a><a name="p1623206411084824"></a>The values for the first n characters of string 1 and string 2 are the same. </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1516604380084824"><a name="p1516604380084824"></a><a name="p1516604380084824"></a><strong id="b991191785084824"><a name="b991191785084824"></a><a name="b991191785084824"></a>0</strong> </p>
</td>
</tr>
</tbody>
</table>

## strxfrm\(\)<a name="gadd1f1078b3303920c19fd68fcba3f908"></a>

```
size_t strxfrm (char * dest, const char * src, size_t n )
```

 **Description:**

Converts the first n characters of the source string pointed to by  **src**  based on the program's current locale specified by  [LC\_COLLATE](io.md#gaab9cf7b1a206fb75e5884934c8d676db), and places them in the destination string pointed to by  **dest**. 

**Parameters:**

<a name="table1166893308084824"></a>
<table><thead align="left"><tr id="row1237891889084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1766030832084824"><a name="p1766030832084824"></a><a name="p1766030832084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1769301249084824"><a name="p1769301249084824"></a><a name="p1769301249084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2127132865084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination string. </td>
</tr>
<tr id="row114709052084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the source string. </td>
</tr>
<tr id="row2018024888084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum string space. </td>
</tr>
</tbody>
</table>

**Attention:**

If the return value is greater than or equal to  **n**, the content of the destination string is uncertain. 

**Returns:**

Returns the number of bytes in the destination string \(excluding the terminating null byte '\\0'\).

## swab\(\)<a name="ga27ee6e902becdb181addb45b69a50b8c"></a>

```
void swab (const void * from, void * to, ssize_t n )
```

 **Description:**

Swaps bytes. 

This function is used to copy n bytes from the  **from**  array to the  **to**  array, exchanging adjacent even and odd bytes. 

**Parameters:**

<a name="table1538444525084824"></a>
<table><thead align="left"><tr id="row1361343325084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1659698325084824"><a name="p1659698325084824"></a><a name="p1659698325084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1614394464084824"><a name="p1614394464084824"></a><a name="p1614394464084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1991154643084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">from</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">source array. </td>
</tr>
<tr id="row1503006394084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">to</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">destination array. </td>
</tr>
<tr id="row405584638084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">number of bytes. </td>
</tr>
</tbody>
</table>

## swprintf\(\)<a name="ga7c963d10722b32fbcf5508057ccf76ec"></a>

```
int swprintf (wchar_t * wcs, size_t maxlen, const wchar_t * format,  ... )
```

 **Description:**

Prints formatted data to a specified string. 

**Parameters:**

<a name="table1446330262084824"></a>
<table><thead align="left"><tr id="row1601395811084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p291835299084824"><a name="p291835299084824"></a><a name="p291835299084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1654627144084824"><a name="p1654627144084824"></a><a name="p1654627144084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row809980935084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wcs</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination string. </td>
</tr>
<tr id="row1421312579084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">maxlen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum length of the destination string. </td>
</tr>
<tr id="row1247552510084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format string that contains the formatted data. </td>
</tr>
<tr id="row1561499735084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">....</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the variable arguments written to the formatted data. </td>
</tr>
</tbody>
</table>

**Attention:**

A maximum of  **maxlen-1**  valid characters can be printed to the destination string. 

**Returns:**

Returns the number of formatted characters \(excluding the terminating null character  **'\\0'**\) if the operation is successful; returns  **-1**  if the operation fails. 



## swscanf\(\)<a name="gaac90953229a0d08ce45ba328430d6637"></a>

```
int swscanf (const wchar_t * ws, const wchar_t * format,  ... )
```

 **Description:**

Reads data from a wide character string pointed to by  **ws**  and stores it based on the wide string format into the locations pointed to by the variable arguments. 

**Parameters:**

<a name="table302946661084824"></a>
<table><thead align="left"><tr id="row765498007084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1171725962084824"><a name="p1171725962084824"></a><a name="p1171725962084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2018499188084824"><a name="p2018499188084824"></a><a name="p2018499188084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1145171398084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ws</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide character string to read. </td>
</tr>
<tr id="row391079636084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format string that contains the formatted data. </td>
</tr>
<tr id="row162827708084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">....</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the variable arguments specifying the data to store. </td>
</tr>
</tbody>
</table>

**Attention:**

An asterisk \( \* \) right after the percent symbol \(such as  **%\*d**  and  **%\*s**\) in the format denotes that the value for the format will be read but will not be stored into a variable. 

**Returns:**

Returns the number of fields successfully assigned to the argument list if the operation is successful; returns  **0**  if no fields are assigned; returns  **EOF**  if a reading error occurs or the end-of-file is reached during data reading. 



## tdelete\(\)<a name="ga58961b9d8ec6333735b53fd0999eff17"></a>

```
void* tdelete (const void * key, void ** rootp, int(*)(const void *, const void *) compar )
```

 **Description:**

Deletes a key from the binary tree. 

**Parameters:**

<a name="table143371300084824"></a>
<table><thead align="left"><tr id="row844752826084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1127856993084824"><a name="p1127856993084824"></a><a name="p1127856993084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p733317965084824"><a name="p733317965084824"></a><a name="p733317965084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row309949342084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the key to be deleted. </td>
</tr>
<tr id="row1012664144084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">rootp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the root node of the tree. If the tree is empty, the value of this parameter should be <strong id="b694249293084824"><a name="b694249293084824"></a><a name="b694249293084824"></a>NULL</strong>. </td>
</tr>
<tr id="row728132633084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">compar</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the judgment function for searching for a key in the tree. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the parent pointer to the deleted key if the operation is successful; returns  **NULL**  if the operation fails. 



## tdestroy\(\)<a name="gab12d1869fd9d20ce6706fcef217ba222"></a>

```
void tdestroy (void * root, void(*)(void *nodep) free_node )
```

 **Description:**

Releases all nodes in the binary tree. 

**Parameters:**

<a name="table11245584084824"></a>
<table><thead align="left"><tr id="row1729281429084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p481482435084824"><a name="p481482435084824"></a><a name="p481482435084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1656978480084824"><a name="p1656978480084824"></a><a name="p1656978480084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2106878809084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">root</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the root node of the binary tree to be released. </td>
</tr>
<tr id="row812487859084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">free_node</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the callback function each time when a node is released. </td>
</tr>
</tbody>
</table>

## tfind\(\)<a name="ga576dc73ee732b840e09c88972b7d487e"></a>

```
void* tfind (const void * key, void *const * rootp, int(*)(const void *, const void *) compar )
```

 **Description:**

Searches for a key in the binary tree. 

**Parameters:**

<a name="table632586100084824"></a>
<table><thead align="left"><tr id="row1601691218084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1289580779084824"><a name="p1289580779084824"></a><a name="p1289580779084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p70961675084824"><a name="p70961675084824"></a><a name="p70961675084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1682951752084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the key to be searched. </td>
</tr>
<tr id="row1265327822084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">rootp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the root node of the tree. If the tree is empty, the value of this parameter should be <strong id="b276724681084824"><a name="b276724681084824"></a><a name="b276724681084824"></a>NULL</strong>. </td>
</tr>
<tr id="row951137263084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">compar</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the judgment function for searching for a key in the tree. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the parent pointer to the deleted key if the operation is successful; returns  **NULL**  if the operation fails. 



## toascii\(\)<a name="gae2edadcc847fa6a98adc9c485da806de"></a>

```
int toascii (int c)
```

 **Description:**

Converts a parameter of the integer type to an ASCII code. 

**Parameters:**

<a name="table1722225091084824"></a>
<table><thead align="left"><tr id="row516200878084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p787019126084824"><a name="p787019126084824"></a><a name="p787019126084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1628142245084824"><a name="p1628142245084824"></a><a name="p1628142245084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row764180455084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to convert. </td>
</tr>
</tbody>
</table>

**Attention:**

The function clears all but the lower seven bits of  **c**. 

**Returns:**

Returns the ASCII code if the conversion is successful. 



## tolower\(\)<a name="gac79d6114c9df7350cedcd8cf921a6ea4"></a>

```
int tolower (int c)
```

 **Description:**

Converts an uppercase letter specified by  **c**  to its lowercase equivalent. 

**Parameters:**

<a name="table481290073084824"></a>
<table><thead align="left"><tr id="row1326132662084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1524952161084824"><a name="p1524952161084824"></a><a name="p1524952161084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1224747801084824"><a name="p1224747801084824"></a><a name="p1224747801084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row633337307084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to convert. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted letter if the conversion is successful; returns  **c**  otherwise. 



## tolower\_l\(\)<a name="ga1921ca31e425387ecff9c9c7657cd4b7"></a>

```
int tolower_l (int c, locale_t locale )
```

 **Description:**

Converts an upper letter specified by  **c**  to its lowercase equivalent for the specified locale. 

**Parameters:**

<a name="table1696471898084824"></a>
<table><thead align="left"><tr id="row48370862084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1362251373084824"><a name="p1362251373084824"></a><a name="p1362251373084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1420863537084824"><a name="p1420863537084824"></a><a name="p1420863537084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row748977303084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to convert. </td>
</tr>
<tr id="row1892771152084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted value if the conversion is successful; returns  **c**  unchanged otherwise. 



## toupper\(\)<a name="ga9c2f57ac3865af9006fdbfd5db9fd517"></a>

```
int toupper (int c)
```

 **Description:**

Converts a lowercase letter specified by  **c**  to its uppercase equivalent. 

**Parameters:**

<a name="table1478506794084824"></a>
<table><thead align="left"><tr id="row861734123084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2110199505084824"><a name="p2110199505084824"></a><a name="p2110199505084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p132465919084824"><a name="p132465919084824"></a><a name="p132465919084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row270126282084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to convert. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted letter if the conversion is successful; returns  **c**  otherwise. 



## toupper\_l\(\)<a name="ga77ed6ccc1ae9841df0fc54ad62860715"></a>

```
int toupper_l (int c, locale_t locale )
```

 **Description:**

Converts a lowercase letter specified by  **c**  to its uppercase equivalent for the specified locale. 

**Parameters:**

<a name="table2001333071084824"></a>
<table><thead align="left"><tr id="row1729873775084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p807282746084824"><a name="p807282746084824"></a><a name="p807282746084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1555860080084824"><a name="p1555860080084824"></a><a name="p1555860080084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1757967877084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter to convert. </td>
</tr>
<tr id="row810305290084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the converted value if the conversion is successful; returns  **c**  unchanged otherwise. 



## towctrans\(\)<a name="gac1d7671abe2a106b481d5bb24717fd11"></a>

```
wint_t towctrans (wint_t wc, [wctrans_t](utils.md#ga10b40cc6ecda73a91162017d2df251a3) desc )
```

 **Description:**

Translates the type of a wide character based on the conversion mapping relationship. 

**Parameters:**

<a name="table1967805682084824"></a>
<table><thead align="left"><tr id="row1529013889084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1381310807084824"><a name="p1381310807084824"></a><a name="p1381310807084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1756035009084824"><a name="p1756035009084824"></a><a name="p1756035009084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row143040296084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
<tr id="row2066885056084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">desc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the mapping relationship, which can be obtained from <a href="utils.md#ga98df6598dc60588b24067b97225070ed">wctrans()</a>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the translated wide character if the operation is successful; returns  **WEOF**  if  **wc**  is  **WEOF**. 



## towctrans\_l\(\)<a name="gaa65f72b343b0d847933e6dbb7454a915"></a>

```
wint_t towctrans_l (wint_t wc, wctype_t desc, locale_t locale )
```

 **Description:**

Translates the type of a wide character based on the translation mapping relationship for the specified locale. 

**Parameters:**

<a name="table24180501084824"></a>
<table><thead align="left"><tr id="row1483815246084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1999422112084824"><a name="p1999422112084824"></a><a name="p1999422112084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1135790031084824"><a name="p1135790031084824"></a><a name="p1135790031084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1418439806084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
<tr id="row554886531084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">desc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the mapping relationship, which can be obtained from <a href="utils.md#ga85e85bc84a644c3a0686fd6e4cfd96d7">wctrans_l()</a>. </td>
</tr>
<tr id="row892147164084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the translated wide character if the operation is successful; returns  **WEOF**  if  **wc**  is  **WEOF**. 



## towlower\(\)<a name="gab9cd9fba7f8437d2ad5242baa25fd176"></a>

```
wint_t towlower (wint_t wc)
```

 **Description:**

Converts an uppercase wide character to lowercase. 

**Parameters:**

<a name="table1857210618084824"></a>
<table><thead align="left"><tr id="row1252180443084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p191772547084824"><a name="p191772547084824"></a><a name="p191772547084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p459069606084824"><a name="p459069606084824"></a><a name="p459069606084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row941211934084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the lowercase wide character if the conversion is successful; returns  **wc**  unchanged otherwise. 



## towlower\_l\(\)<a name="ga6333139346611f59c603f70b61b521b5"></a>

```
wint_t towlower_l (wint_t wc, locale_t locale )
```

 **Description:**

Converts an uppercase wide character to lowercase for the specified locale. 

**Parameters:**

<a name="table166929685084824"></a>
<table><thead align="left"><tr id="row572503523084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1489109927084824"><a name="p1489109927084824"></a><a name="p1489109927084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2142068628084824"><a name="p2142068628084824"></a><a name="p2142068628084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row272202599084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
<tr id="row1360554591084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the lowercase wide character if the conversion is successful; returns  **wc**  unchanged otherwise.  **1.0 1.0 ** 

## towupper\(\)<a name="gaaf8d2b2d230df873695d41757d5889f9"></a>

```
wint_t towupper (wint_t wc)
```

 **Description:**

Converts a lowercase wide character to uppercase. 

**Parameters:**

<a name="table1979013026084824"></a>
<table><thead align="left"><tr id="row1109471961084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1819638429084824"><a name="p1819638429084824"></a><a name="p1819638429084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p464818897084824"><a name="p464818897084824"></a><a name="p464818897084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1977833979084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the uppercase wide character if the conversion is successful; returns  **wc**  unchanged otherwise. 



## towupper\_l\(\)<a name="gac01816aef7bc2050e1b19db17a26bae8"></a>

```
wint_t towupper_l (wint_t wc, locale_t locale )
```

 **Description:**

Converts a lowercase wide character to uppercase for the specified locale. 

**Parameters:**

<a name="table364037555084824"></a>
<table><thead align="left"><tr id="row1815331027084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1362930371084824"><a name="p1362930371084824"></a><a name="p1362930371084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1997910696084824"><a name="p1997910696084824"></a><a name="p1997910696084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row170446255084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character. </td>
</tr>
<tr id="row1109578043084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. This parameter is ignored currently. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the uppercase wide character if the conversion is successful; returns  **wc**  unchanged otherwise.  **1.0 1.0 ** 

## truncate\(\)<a name="ga87674838dd2bcf61e1a1fb5c9892ab6c"></a>

```
int truncate (const char * path, off_t length )
```

 **Description:**

Truncates a file to a specified size based on the file path. 

**Parameters:**

<a name="table1127709781084824"></a>
<table><thead align="left"><tr id="row344721902084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p23973917084824"><a name="p23973917084824"></a><a name="p23973917084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p665673418084824"><a name="p665673418084824"></a><a name="p665673418084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row33068035084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the path of the file to be truncated. </td>
</tr>
<tr id="row499191515084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">length</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the file to be truncated. </td>
</tr>
</tbody>
</table>

**Attention:**

This function can be used only in the FAT file system. 

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1366572678084824"></a>
<table><thead align="left"><tr id="row353010627084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1771929573084824"><a name="p1771929573084824"></a><a name="p1771929573084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1037824884084824"><a name="p1037824884084824"></a><a name="p1037824884084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1385295274084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1365408653084824"><a name="p1365408653084824"></a><a name="p1365408653084824"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1744282631084824"><a name="p1744282631084824"></a><a name="p1744282631084824"></a>The file has no write permission. </p>
</td>
</tr>
<tr id="row1471027566084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p686649677084824"><a name="p686649677084824"></a><a name="p686649677084824"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p29708571084824"><a name="p29708571084824"></a><a name="p29708571084824"></a>Failed to open the file in the specified path. </p>
</td>
</tr>
<tr id="row273376920084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1581745723084824"><a name="p1581745723084824"></a><a name="p1581745723084824"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p563885410084824"><a name="p563885410084824"></a><a name="p563885410084824"></a>Failed to open the file because the length of path is greater than <a href="utils.md#gae688d728e1acdfe5988c7db45d6f0166">PATH_MAX</a>. </p>
</td>
</tr>
<tr id="row1832430833084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p937103304084824"><a name="p937103304084824"></a><a name="p937103304084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1215336142084824"><a name="p1215336142084824"></a><a name="p1215336142084824"></a>Insufficient memory. </p>
</td>
</tr>
<tr id="row798532758084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2025955919084824"><a name="p2025955919084824"></a><a name="p2025955919084824"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p145870159084824"><a name="p145870159084824"></a><a name="p145870159084824"></a>Failed to obtain the file structure corresponding to the file descriptor when opening the file. </p>
</td>
</tr>
<tr id="row1553038635084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p613121035084824"><a name="p613121035084824"></a><a name="p613121035084824"></a>EMFILE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p573542013084824"><a name="p573542013084824"></a><a name="p573542013084824"></a>Failed to open the file because the maximum number of files that can be opened has been reached. </p>
</td>
</tr>
<tr id="row897971391084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p775200188084824"><a name="p775200188084824"></a><a name="p775200188084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1914700772084824"><a name="p1914700772084824"></a><a name="p1914700772084824"></a>The target length is less than <strong id="b1928188937084824"><a name="b1928188937084824"></a><a name="b1928188937084824"></a>0</strong>. </p>
</td>
</tr>
<tr id="row609927290084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1501162170084824"><a name="p1501162170084824"></a><a name="p1501162170084824"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p820128224084824"><a name="p820128224084824"></a><a name="p820128224084824"></a>The operation is not supported. </p>
</td>
</tr>
<tr id="row1272996770084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p792651370084824"><a name="p792651370084824"></a><a name="p792651370084824"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p499862721084824"><a name="p499862721084824"></a><a name="p499862721084824"></a>Failed to obtain the file structure corresponding to the file specified by <strong id="b1552160454084824"><a name="b1552160454084824"></a><a name="b1552160454084824"></a>path</strong>, or the file access is rejected. </p>
</td>
</tr>
</tbody>
</table>

## tsearch\(\)<a name="ga197c455a4e5f17cb8565be72d18344cc"></a>

```
void* tsearch (const void * key, void *const * rootp, int(*)(const void *, const void *) compar )
```

 **Description:**

Searches for a key in the binary tree and adds a key to the tree if the key is not found. 

**Parameters:**

<a name="table1237647322084824"></a>
<table><thead align="left"><tr id="row8026445084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1091737925084824"><a name="p1091737925084824"></a><a name="p1091737925084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1401910763084824"><a name="p1401910763084824"></a><a name="p1401910763084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1218275243084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the key to be searched. </td>
</tr>
<tr id="row1497474113084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">rootp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the root node of the tree. If the tree is empty, the value of this parameter should be <strong id="b1976990875084824"><a name="b1976990875084824"></a><a name="b1976990875084824"></a>NULL</strong>. </td>
</tr>
<tr id="row2096060818084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">compar</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the judgment function for searching for a key in the tree. </td>
</tr>
</tbody>
</table>

## twalk\(\)<a name="ga4d8ee780402dd74ec06e7b5089565168"></a>

```
void twalk (const void * root, void(*)(const void *nodep, VISIT which, int depth) action )
```

 **Description:**

Traverses a binary tree from left to right. 

**root **  points to the start node for the traversal. If the node is not the root, only part of the tree will be visited. 

**Parameters:**

<a name="table1807798902084824"></a>
<table><thead align="left"><tr id="row1194511052084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p408938790084824"><a name="p408938790084824"></a><a name="p408938790084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1216240509084824"><a name="p1216240509084824"></a><a name="p1216240509084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1358563359084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">root</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the start node to be searched. </td>
</tr>
<tr id="row768421996084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">action</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the running function for each node access. </td>
</tr>
<tr id="row542323995084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nodep</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the node to be accessed. </td>
</tr>
<tr id="row1491820803084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">which</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the value sequence, which is <strong id="b1074270716084824"><a name="b1074270716084824"></a><a name="b1074270716084824"></a>preorder</strong>, <strong id="b1705968284084824"><a name="b1705968284084824"></a><a name="b1705968284084824"></a>inorder</strong>, <strong id="b1109963417084824"><a name="b1109963417084824"></a><a name="b1109963417084824"></a>postorder</strong>, and <strong id="b1579645339084824"><a name="b1579645339084824"></a><a name="b1579645339084824"></a>leaf</strong>. For details, see <strong id="b48031972084824"><a name="b48031972084824"></a><a name="b48031972084824"></a>VISIT</strong>. </td>
</tr>
<tr id="row339815948084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">depth</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the depth of the node. </td>
</tr>
</tbody>
</table>

## ualarm\(\)<a name="ga9d35348d3389a721ab5aef5f4f036c61"></a>

```
unsigned ualarm (unsigned value, unsigned interval )
```

 **Description:**

Sets a microsecond-level timer. 

**Parameters:**

<a name="table690379029084824"></a>
<table><thead align="left"><tr id="row2144333681084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1230275358084824"><a name="p1230275358084824"></a><a name="p1230275358084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1484052654084824"><a name="p1484052654084824"></a><a name="p1484052654084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row332671362084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">value</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of microseconds to be set for the timer. The precision unit is tick, and the deviation is &plusmn;1 tick. </td>
</tr>
<tr id="row769872840084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">interval</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the interval for triggering the timer. The precision unit is tick, and the deviation is &plusmn;1 tick. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the remaining microseconds of the previous timer if the operation is successful; returns  **0**  if the operation fails. 

<a name="table1794787546084824"></a>
<table><thead align="left"><tr id="row1493462622084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1792782618084824"><a name="p1792782618084824"></a><a name="p1792782618084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p852066857084824"><a name="p852066857084824"></a><a name="p852066857084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row406322860084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p249860222084824"><a name="p249860222084824"></a><a name="p249860222084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1282126142084824"><a name="p1282126142084824"></a><a name="p1282126142084824"></a>Incorrect input parameter. </p>
</td>
</tr>
</tbody>
</table>

## ungetwc\(\)<a name="ga35264055ce08ba6d23ba03075897a0fb"></a>

```
wint_t ungetwc (wint_t ch, [FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream )
```

 **Description:**

Pushes a character back into a specified file stream. 

**Parameters:**

<a name="table2012311224084824"></a>
<table><thead align="left"><tr id="row1102359219084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p578060965084824"><a name="p578060965084824"></a><a name="p578060965084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1703576033084824"><a name="p1703576033084824"></a><a name="p1703576033084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row689297997084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ch</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the character to push back. </td>
</tr>
<tr id="row1500789485084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Attention:**

If you call this function multiple times without any character inserting or reading operation or file stream repositioning, the calls will fail. 

**Returns:**

Returns  **ch**  if the operation is successful; returns  **EOF**  otherwise. 



## unlink\(\)<a name="ga28af9471bbdf262321af663e02899a47"></a>

```
int unlink (const char * path)
```

 **Description:**

Deletes a specified file. 

**Parameters:**

<a name="table1131703938084824"></a>
<table><thead align="left"><tr id="row1752479291084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p436769473084824"><a name="p436769473084824"></a><a name="p436769473084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p253420823084824"><a name="p253420823084824"></a><a name="p253420823084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1503892347084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the path of the file to be deleted. </td>
</tr>
</tbody>
</table>

**Attention:**

This function can NOT be used in the PROC file system. 

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1703151333084824"></a>
<table><thead align="left"><tr id="row450336462084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p477893462084824"><a name="p477893462084824"></a><a name="p477893462084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1914873533084824"><a name="p1914873533084824"></a><a name="p1914873533084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row346077821084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p977908449084824"><a name="p977908449084824"></a><a name="p977908449084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p534630905084824"><a name="p534630905084824"></a><a name="p534630905084824"></a><strong id="b1752479321084824"><a name="b1752479321084824"></a><a name="b1752479321084824"></a>path</strong> is a null pointer or an empty string. </p>
</td>
</tr>
<tr id="row432421851084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p625943685084824"><a name="p625943685084824"></a><a name="p625943685084824"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1984134276084824"><a name="p1984134276084824"></a><a name="p1984134276084824"></a>The length of the path name is greater than <a href="utils.md#gac64541bdd81c961304b9babef1402640">NAME_MAX</a>. </p>
</td>
</tr>
<tr id="row1649287350084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2003301377084824"><a name="p2003301377084824"></a><a name="p2003301377084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2116279569084824"><a name="p2116279569084824"></a><a name="p2116279569084824"></a>Insufficient memory. </p>
</td>
</tr>
<tr id="row1474062955084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p62836070084824"><a name="p62836070084824"></a><a name="p62836070084824"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p790043201084824"><a name="p790043201084824"></a><a name="p790043201084824"></a>The file does not exist. </p>
</td>
</tr>
<tr id="row1555540975084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p613388975084824"><a name="p613388975084824"></a><a name="p613388975084824"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2146693632084824"><a name="p2146693632084824"></a><a name="p2146693632084824"></a>The operation is not supported. </p>
</td>
</tr>
<tr id="row1945662299084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1863131986084824"><a name="p1863131986084824"></a><a name="p1863131986084824"></a>ENOTEMPTY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p172148701084824"><a name="p172148701084824"></a><a name="p172148701084824"></a>The path is a pseudo file used as a directory, or the directory is not empty. </p>
</td>
</tr>
<tr id="row1034091628084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p910706219084824"><a name="p910706219084824"></a><a name="p910706219084824"></a>EISDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1630684805084824"><a name="p1630684805084824"></a><a name="p1630684805084824"></a>The specified path is a directory. </p>
</td>
</tr>
<tr id="row1257095175084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p303806136084824"><a name="p303806136084824"></a><a name="p303806136084824"></a>ENXIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1292350682084824"><a name="p1292350682084824"></a><a name="p1292350682084824"></a>No such device or address. </p>
</td>
</tr>
<tr id="row1531768050084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p507767940084824"><a name="p507767940084824"></a><a name="p507767940084824"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1818550333084824"><a name="p1818550333084824"></a><a name="p1818550333084824"></a>The search permission on the path prefix component is denied, or the write permission of the directory in the path is denied. </p>
</td>
</tr>
</tbody>
</table>

## unlinkat\(\)<a name="gaa06a637e291f5d288cae85ce32a2fe49"></a>

```
int unlinkat (int fd, const char * path, int flag )
```

 **Description:**

Deletes a specified file. 

**Parameters:**

<a name="table1996394514084824"></a>
<table><thead align="left"><tr id="row781956215084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p952716464084824"><a name="p952716464084824"></a><a name="p952716464084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1506850506084824"><a name="p1506850506084824"></a><a name="p1506850506084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row25021805084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the descriptor of the directory where the file to be deleted is located. Currently, this parameter can only be set to <strong id="b1475266138084824"><a name="b1475266138084824"></a><a name="b1475266138084824"></a>AT_FDCWD</strong>. </td>
</tr>
<tr id="row897832439084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the path of the file to be deleted. This parameter must be set to an absolute path. </td>
</tr>
<tr id="row729826547084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">flag</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the operation flag. The value can only be <strong id="b807550021084824"><a name="b807550021084824"></a><a name="b807550021084824"></a>0</strong> (deleting a file) or <strong id="b66566993084824"><a name="b66566993084824"></a><a name="b66566993084824"></a>AT_REMOVEDIR</strong> (deleting a directory, equivalent to <a href="utils.md#gab2df76f2c62ae012c2e417813b5fe8ce">rmdir</a>). If this parameter is set to other values, the function will fail. </td>
</tr>
</tbody>
</table>

**Attention:**

This function can NOT be used in the PROC file system. 

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table274899029084824"></a>
<table><thead align="left"><tr id="row465132329084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2004131633084824"><a name="p2004131633084824"></a><a name="p2004131633084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p421584753084824"><a name="p421584753084824"></a><a name="p421584753084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row272390161084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p932004962084824"><a name="p932004962084824"></a><a name="p932004962084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1744776871084824"><a name="p1744776871084824"></a><a name="p1744776871084824"></a><strong id="b973920366084824"><a name="b973920366084824"></a><a name="b973920366084824"></a>path</strong> is a null pointer or an empty string. </p>
</td>
</tr>
<tr id="row665789039084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p134713801084824"><a name="p134713801084824"></a><a name="p134713801084824"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p735772629084824"><a name="p735772629084824"></a><a name="p735772629084824"></a>The length of the path name is greater than <a href="utils.md#gac64541bdd81c961304b9babef1402640">NAME_MAX</a>. </p>
</td>
</tr>
<tr id="row148457530084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1806419713084824"><a name="p1806419713084824"></a><a name="p1806419713084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1542483479084824"><a name="p1542483479084824"></a><a name="p1542483479084824"></a>Insufficient memory. </p>
</td>
</tr>
<tr id="row732809297084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p617546453084824"><a name="p617546453084824"></a><a name="p617546453084824"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2016156595084824"><a name="p2016156595084824"></a><a name="p2016156595084824"></a>The file does not exist. </p>
</td>
</tr>
<tr id="row65160058084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p746167890084824"><a name="p746167890084824"></a><a name="p746167890084824"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1637709413084824"><a name="p1637709413084824"></a><a name="p1637709413084824"></a>The operation is not supported. </p>
</td>
</tr>
<tr id="row1335889012084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1509743267084824"><a name="p1509743267084824"></a><a name="p1509743267084824"></a>ENOTEMPTY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p914452827084824"><a name="p914452827084824"></a><a name="p914452827084824"></a>The path is a pseudo file used as a directory, or the directory is not empty. </p>
</td>
</tr>
<tr id="row1100636233084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p412114175084824"><a name="p412114175084824"></a><a name="p412114175084824"></a>EISDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p759075056084824"><a name="p759075056084824"></a><a name="p759075056084824"></a>The specified path is a directory. </p>
</td>
</tr>
<tr id="row824094854084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p693155845084824"><a name="p693155845084824"></a><a name="p693155845084824"></a>ENXIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p822031084084824"><a name="p822031084084824"></a><a name="p822031084084824"></a>No such device or address. </p>
</td>
</tr>
<tr id="row1802156331084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1633434885084824"><a name="p1633434885084824"></a><a name="p1633434885084824"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p437049923084824"><a name="p437049923084824"></a><a name="p437049923084824"></a>The search permission on the path prefix component is denied, or the write permission of the directory in the path is denied. </p>
</td>
</tr>
</tbody>
</table>

## unlockpt\(\)<a name="gaba5e81f4ce55d1e02fb94974c382b63d"></a>

```
int unlockpt (int fd)
```

 **Description:**

Unlocks the secondary pseudo terminal corresponding to a primary pseudo terminal. 

**Parameters:**

<a name="table1098601052084824"></a>
<table><thead align="left"><tr id="row738508891084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p558742268084824"><a name="p558742268084824"></a><a name="p558742268084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p683600292084824"><a name="p683600292084824"></a><a name="p683600292084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row242243828084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the primary terminal descriptor. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1215030206084824"></a>
<table><thead align="left"><tr id="row1189079685084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p601142104084824"><a name="p601142104084824"></a><a name="p601142104084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p939052297084824"><a name="p939052297084824"></a><a name="p939052297084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row441312389084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1562179558084824"><a name="p1562179558084824"></a><a name="p1562179558084824"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1309737627084824"><a name="p1309737627084824"></a><a name="p1309737627084824"></a>Invalid descriptor </p>
</td>
</tr>
<tr id="row1011948999084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p576350028084824"><a name="p576350028084824"></a><a name="p576350028084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p134339193084824"><a name="p134339193084824"></a><a name="p134339193084824"></a><strong id="b2039528498084824"><a name="b2039528498084824"></a><a name="b2039528498084824"></a>fd</strong> is invalid. </p>
</td>
</tr>
</tbody>
</table>

## unsetenv\(\)<a name="ga17a3a11d20a551951a4acbc3872b280c"></a>

```
int unsetenv (const char * name)
```

 **Description:**

Deletes an environment variable. 

**Parameters:**

<a name="table401651433084824"></a>
<table><thead align="left"><tr id="row1085820255084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2092094592084824"><a name="p2092094592084824"></a><a name="p2092094592084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1388639557084824"><a name="p1388639557084824"></a><a name="p1388639557084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row970471811084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">name</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the name of environment variable to be deleted. if <strong id="b1815381514084824"><a name="b1815381514084824"></a><a name="b1815381514084824"></a>overwrite</strong> is zero, then the value of <strong id="b27819685084824"><a name="b27819685084824"></a><a name="b27819685084824"></a>name</strong> remains unchanged. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails



## usleep\(\)<a name="ga608e849b00b0ac57524b26f45d408a55"></a>

```
int usleep (unsigned useconds)
```

 **Description:**

Sleeps for several microseconds. 

This function is used to suspend the current thread for the specified duration. A sleeping thread cannot be woken up by a signal. 

**Parameters:**

<a name="table1564434879084824"></a>
<table><thead align="left"><tr id="row1546210656084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p637453849084824"><a name="p637453849084824"></a><a name="p637453849084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1714235372084824"><a name="p1714235372084824"></a><a name="p1714235372084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row58129758084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">useconds</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the sleeping time in microseconds. The precision unit is tick, and the deviation is less than 2 ticks. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1387521131084824"></a>
<table><thead align="left"><tr id="row1097985465084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p881523255084824"><a name="p881523255084824"></a><a name="p881523255084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p83290587084824"><a name="p83290587084824"></a><a name="p83290587084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row946036388084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p456621679084824"><a name="p456621679084824"></a><a name="p456621679084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p148146264084824"><a name="p148146264084824"></a><a name="p148146264084824"></a>Incorrect input parameter. </p>
</td>
</tr>
</tbody>
</table>

## valloc\(\)<a name="ga3d09e44a916600a38b367c1b6ebdf118"></a>

```
void* valloc (size_t size)
```

 **Description:**

Allocates memory with the specified size and aligns the allocated memory by page size. 

**Parameters:**

<a name="table1271335034084824"></a>
<table><thead align="left"><tr id="row1875734298084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p578245409084824"><a name="p578245409084824"></a><a name="p578245409084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2015122938084824"><a name="p2015122938084824"></a><a name="p2015122938084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1813495467084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the memory block to be allocated. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the allocated memory block if the operation is successful; returns  **NULL**  and sets  **errno**  to a value in the following table if the operation fails and  **size**  is  **0**. 

<a name="table1082320485084824"></a>
<table><thead align="left"><tr id="row1678889208084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1551962653084824"><a name="p1551962653084824"></a><a name="p1551962653084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p648486908084824"><a name="p648486908084824"></a><a name="p648486908084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row2082979429084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p123795177084824"><a name="p123795177084824"></a><a name="p123795177084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1133684045084824"><a name="p1133684045084824"></a><a name="p1133684045084824"></a>Insufficient memory. </p>
</td>
</tr>
</tbody>
</table>

## vfwprintf\(\)<a name="ga52697c5b86b8a3fa892b69f70fac8843"></a>

```
int vfwprintf ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream, const wchar_t * format, __isoc_va_list args )
```

 **Description:**

Prints formatted data from a variable argument list specified by  **args**  to a specified file stream. 

**Parameters:**

<a name="table888045432084824"></a>
<table><thead align="left"><tr id="row437754578084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1096644033084824"><a name="p1096644033084824"></a><a name="p1096644033084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p645797958084824"><a name="p645797958084824"></a><a name="p645797958084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row348632215084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to a file object that identifies an output stream. </td>
</tr>
<tr id="row1357678322084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide character string that may contain the format specifiers. </td>
</tr>
<tr id="row556033830084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">args</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates a value identifying a variable argument list initialized by using <strong id="b381183683084824"><a name="b381183683084824"></a><a name="b381183683084824"></a>va_start</strong>. </td>
</tr>
</tbody>
</table>

**Attention:**

This function is generally used together with  [va\_start](utils.md#gaa0628ab596c3d7e78f5e08c2d98e24da)  and  [va\_end](utils.md#ga823b205416e9129825841b74c3bf8484)  and is the wide character equivalent of the  [vfprintf](io.md#gad80f05917df38df3a5e1817498d67c26)  function. 

**Returns:**

Returns the number of written characters \(excluding the terminating null character  **'\\0'**\) if the operation is successful; returns  **-1**  if the operation fails. 



## vfwscanf\(\)<a name="ga0d7996cc31075571432fcc7a21c402fa"></a>

```
int vfwscanf ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream, const wchar_t * format, va_list arg )
```

 **Description:**

Reads data from a specified file stream and stores it based on the wide string format into the locations pointed to by the elements in the variable argument list identified by  **arg**. 

**Parameters:**

<a name="table1494247386084824"></a>
<table><thead align="left"><tr id="row1554727375084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1097596002084824"><a name="p1097596002084824"></a><a name="p1097596002084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1017409428084824"><a name="p1017409428084824"></a><a name="p1017409428084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row948515939084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to a file object that identifies an output stream. </td>
</tr>
<tr id="row706924048084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide character string that may contain the format specifiers. </td>
</tr>
<tr id="row1954212397084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">arg</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates a value identifying a variable argument list initialized by using <strong id="b331367175084824"><a name="b331367175084824"></a><a name="b331367175084824"></a>va_start</strong>. </td>
</tr>
</tbody>
</table>

**Attention:**

This function is generally used together with  [va\_start](utils.md#gaa0628ab596c3d7e78f5e08c2d98e24da)  and  [va\_end](utils.md#ga823b205416e9129825841b74c3bf8484)  and is the wide character equivalent of the  [vfscanf](io.md#gabdd32e401e37c9d954f3f0a6907500d9)  function. 

**Returns:**

Returns the number of fields successfully assigned to the argument list if the operation is successful; returns  **0**  if no fields are assigned; returns  **EOF**  if a reading error occurs or the end-of-file is reached during data reading. If an encoding error occurs when wide characters are parsed, this function sets  **errno**  to  [EILSEQ](utils.md#gac6c071293826a4e66a717bb38db7794d). 



## vswprintf\(\)<a name="gad79402226fa58569bee4601eb029b717"></a>

```
int vswprintf (wchar_t * wcs, size_t maxlen, const wchar_t * format, __isoc_va_list args )
```

 **Description:**

Prints formatted data from a variable argument list specified by  **args**  to a specified string. 

**Parameters:**

<a name="table504592731084824"></a>
<table><thead align="left"><tr id="row515806214084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p159770134084824"><a name="p159770134084824"></a><a name="p159770134084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p748063732084824"><a name="p748063732084824"></a><a name="p748063732084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1158394714084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wcs</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination wide character string. </td>
</tr>
<tr id="row313885725084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">maxlen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum length of the destination wide character string. </td>
</tr>
<tr id="row522786997084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string that may contain the format specifiers. </td>
</tr>
<tr id="row879597555084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">args</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates a value identifying a variable argument list initialized by using <strong id="b1121898349084824"><a name="b1121898349084824"></a><a name="b1121898349084824"></a>va_start</strong>. </td>
</tr>
</tbody>
</table>

**Attention:**

The destination wide character string must end with the terminating null character  **'\\0'**. This function is generally used together with  [va\_start](utils.md#gaa0628ab596c3d7e78f5e08c2d98e24da)  and  [va\_end](utils.md#ga823b205416e9129825841b74c3bf8484)  and is the wide character equivalent of the  [vsnprintf](io.md#ga2cadafbeb2d6e0d5781f6e5106d41fc2)  function. 

**Returns:**

Returns the number of written characters \(excluding the terminating null character  **'\\0'**\) if the operation is successful; returns  **-1**  if the operation fails. 



## vswscanf\(\)<a name="ga0b70af0bd7f82c6f81886d79ad41b2c1"></a>

```
int vswscanf (const wchar_t * ws, const wchar_t * format, va_list arg )
```

 **Description:**

Reads data from a string pointed to by  **ws**  and stores it based on the wide string format into the locations pointed to by the elements in the variable argument list identified by  **arg**. 

**Parameters:**

<a name="table691546537084824"></a>
<table><thead align="left"><tr id="row213672586084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p667736711084824"><a name="p667736711084824"></a><a name="p667736711084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1712334675084824"><a name="p1712334675084824"></a><a name="p1712334675084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1961823763084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ws</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide character string to read. </td>
</tr>
<tr id="row433234296084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide character string that may contain the format specifiers. </td>
</tr>
<tr id="row2088574366084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">arg</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates a value identifying a variable argument list initialized by using <strong id="b1157872431084824"><a name="b1157872431084824"></a><a name="b1157872431084824"></a>va_start</strong>. </td>
</tr>
</tbody>
</table>

**Attention:**

This function is generally used together with  [va\_start](utils.md#gaa0628ab596c3d7e78f5e08c2d98e24da)  and  [va\_end](utils.md#ga823b205416e9129825841b74c3bf8484)  and is the wide character equivalent of the  [vsscanf](io.md#gab1c4552aba80fe03c9b45fe27f4331ad)  function. 

**Returns:**

Returns the number of fields successfully assigned to the argument list if the operation is successful; returns  **0**  if no fields are assigned; returns  **EOF**  if a reading error occurs or the end-of-file is reached during data reading. If an encoding error occurs when wide characters are parsed, this function sets  **errno**  to  [EILSEQ](utils.md#gac6c071293826a4e66a717bb38db7794d). 



## vwprintf\(\)<a name="gadff14929a4410b3ac0ce28b55357e280"></a>

```
int vwprintf (const wchar_t * format, va_list args )
```

 **Description:**

Prints formatted data from a variable argument list to the standard output \(stdout\). 

**Parameters:**

<a name="table2044040215084824"></a>
<table><thead align="left"><tr id="row56766957084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p200739847084824"><a name="p200739847084824"></a><a name="p200739847084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p941730083084824"><a name="p941730083084824"></a><a name="p941730083084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1688269815084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string that may contain the format specifiers. </td>
</tr>
<tr id="row1709016339084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">args</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates a value identifying a variable argument list initialized by using <strong id="b232459686084824"><a name="b232459686084824"></a><a name="b232459686084824"></a>va_start</strong>. </td>
</tr>
</tbody>
</table>

**Attention:**

This function is generally used together with  [va\_start](utils.md#gaa0628ab596c3d7e78f5e08c2d98e24da)  and  [va\_end](utils.md#ga823b205416e9129825841b74c3bf8484)  and is the wide character equivalent of the  [vprintf](io.md#gaa715ef816dc040c8b367fde4ba84d6f3)  function. 

**Returns:**

Returns the total number of output characters \(excluding the terminating null character  **'\\0'**\) if the operation is successful; returns a negative value otherwise. 



## vwscanf\(\)<a name="ga4406b91b463b1fc3d4d43b44ccb46d1c"></a>

```
int vwscanf (const wchar_t * format, va_list arg )
```

 **Description:**

Reads data from the stdin and stores it based on the wide string format into the locations pointed to by the elements in the variable argument list identified by  **arg**. 

**Parameters:**

<a name="table1876441638084824"></a>
<table><thead align="left"><tr id="row628063568084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p178720866084824"><a name="p178720866084824"></a><a name="p178720866084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2035797436084824"><a name="p2035797436084824"></a><a name="p2035797436084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1320758073084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string that may contain the format specifiers. </td>
</tr>
<tr id="row1748904308084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">arg</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates a value identifying a variable argument list initialized by using <strong id="b807603022084824"><a name="b807603022084824"></a><a name="b807603022084824"></a>va_start</strong>. </td>
</tr>
</tbody>
</table>

**Attention:**

This function is generally used together with  [va\_start](utils.md#gaa0628ab596c3d7e78f5e08c2d98e24da)  and  [va\_end](utils.md#ga823b205416e9129825841b74c3bf8484)  and is the wide character equivalent of the  [vscanf](io.md#ga40250d63904acd3e898061c9eab6ead3)  function. 

**Returns:**

Returns the number of fields successfully assigned to the argument list if the operation is successful; returns  **0**  if no fields are assigned; returns  **EOF**  if a reading error occurs or the end-of-file is reached during data reading. If an encoding error occurs when wide characters are parsed, this function sets  **errno**  to  [EILSEQ](utils.md#gac6c071293826a4e66a717bb38db7794d). 



## wcpcpy\(\)<a name="gaa4f33e46d5c0263f0b3e9a1e8eb0a7a9"></a>

```
wchar_t* wcpcpy (wchar_t * dest, const wchar_t * src )
```

 **Description:**

Copies the wide characters \(including the terminating null character  **'\\0'**\) pointed to by  **src**  to the wide character array pointed to by  **dest**. 

**Parameters:**

<a name="table82202474084824"></a>
<table><thead align="left"><tr id="row265831758084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2109270812084824"><a name="p2109270812084824"></a><a name="p2109270812084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p866554898084824"><a name="p866554898084824"></a><a name="p866554898084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row975485795084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide character array to copy the wide characters to. </td>
</tr>
<tr id="row771719034084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide characters to copy. </td>
</tr>
</tbody>
</table>

**Attention:**

Ensure that the array pointed to by  **dest**  has sufficient space to hold the wide characters to be written. 

**Returns:**

Returns the pointer to the end of the destination wide character array. 



## wcpncpy\(\)<a name="ga2b77c48e45c06857bae5c4720fd977b9"></a>

```
wchar_t* wcpncpy (wchar_t * dest, const wchar_t * src, size_t n )
```

 **Description:**

Copies  **n**  wide characters \(including the terminating null character  **'\\0'**\) pointed to by  **src**  to the wide character array pointed to by  **dest**. 

**Parameters:**

<a name="table2138743840084824"></a>
<table><thead align="left"><tr id="row1760103758084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1627588282084824"><a name="p1627588282084824"></a><a name="p1627588282084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p409992268084824"><a name="p409992268084824"></a><a name="p409992268084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1591853258084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the array to accommodate the copied wide characters. </td>
</tr>
<tr id="row1556340155084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide character string to be copied. </td>
</tr>
<tr id="row1519757844084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum number of wide characters to be copied. </td>
</tr>
</tbody>
</table>

**Attention:**

Ensure that the array pointed to by  **dest**  has sufficient space to hold the wide characters to be written. 

**Returns:**

Returns the pointer to the end of the destination wide character array. 



## wcrtomb\(\)<a name="ga67e98eb761f2880dc93ceb3833bbf9bd"></a>

```
size_t wcrtomb (char * s, wchar_t wc, mbstate_t * ps )
```

 **Description:**

Converts the wide character specified by  **wc**  into a character string and stores the string to the beginning of the character array pointed to by  **s**. 

**Parameters:**

<a name="table1798842957084824"></a>
<table><thead align="left"><tr id="row1897858810084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1278147835084824"><a name="p1278147835084824"></a><a name="p1278147835084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p160301437084824"><a name="p160301437084824"></a><a name="p160301437084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row875540803084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the address storing the converted string. </td>
</tr>
<tr id="row1460496584084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character to be converted. </td>
</tr>
<tr id="row1164774495084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ps</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the <strong id="b586485983084824"><a name="b586485983084824"></a><a name="b586485983084824"></a>mbstate_t</strong> object describing the conversion state. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of characters written to the character string if the operation is successful; returns  **-1**  and sets  **errno**  to  [EILSEQ](utils.md#gac6c071293826a4e66a717bb38db7794d)  if the operation fails. 



## wcscasecmp\(\)<a name="ga1cfd283a315ce1081565d9370dadbd1e"></a>

```
int wcscasecmp (const wchar_t * s1, const wchar_t * s2 )
```

 **Description:**

Compares the wide characters in the string pointed to by  **s1**  with those in the string pointed to by  **s2**, with their case differences ignored. 

**Parameters:**

<a name="table684100004084824"></a>
<table><thead align="left"><tr id="row234827890084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1035884644084824"><a name="p1035884644084824"></a><a name="p1035884644084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p229093966084824"><a name="p229093966084824"></a><a name="p229093966084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1891864209084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to wide character string 1 for comparison. </td>
</tr>
<tr id="row1902121304084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to wide character string 2 for comparison. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the two wide character strings are equal; returns the code difference between the two wide character strings if they are not equal. 



## wcscasecmp\_l\(\)<a name="gad5fd70aa458e05eaec03bb88d5eefdef"></a>

```
int wcscasecmp_l (const wchar_t * s1, const wchar_t * s2, locale_t locale )
```

 **Description:**

Compares the wide characters in the string pointed to by  **s1**  with those in the string pointed to by  **s2**  based on the specified  **locale**  environment, with their case differences ignored. 

**Parameters:**

<a name="table266395576084824"></a>
<table><thead align="left"><tr id="row1484668767084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1171816145084824"><a name="p1171816145084824"></a><a name="p1171816145084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p498490225084824"><a name="p498490225084824"></a><a name="p498490225084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1477709302084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to wide character string 1 for comparison. </td>
</tr>
<tr id="row450361873084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to wide character string 2 for comparison. </td>
</tr>
<tr id="row1622407815084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the two wide character strings are equal; returns the code difference between the two wide character strings if they are not equal. 



## wcscat\(\)<a name="ga1fa2f722dd578b02ed196a74488f75f0"></a>

```
wchar_t* wcscat (wchar_t * dest, const wchar_t * src )
```

 **Description:**

Appends a copy of the wide characters pointed to by  **src**  to the end of the wide character array pointed to by  **dest**  and adds a terminating null character  **'\\0'**. 

**Parameters:**

<a name="table1981899518084824"></a>
<table><thead align="left"><tr id="row149691065084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p307859735084824"><a name="p307859735084824"></a><a name="p307859735084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1241694632084824"><a name="p1241694632084824"></a><a name="p1241694632084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1938531955084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the array to accommodate the concatenated wide characters. </td>
</tr>
<tr id="row72722376084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide characters to be concatenated. </td>
</tr>
</tbody>
</table>

**Attention:**

Ensure that the wide character array pointed to by  **dest**  has enough space to accommodate the concatenated characters \([wcslen](utils.md#ga7859e4ba07f77515772c4632d4caa4e0)  \(**dest**\) +  [wcslen](utils.md#ga7859e4ba07f77515772c4632d4caa4e0)  \(**src**\) + 1\). 

**Returns:**

Returns the pointer to the destination string after concatenation. 



## wcschr\(\)<a name="ga3fe8f361d1cff837a204ef0f4fac68eb"></a>

```
wchar_t* wcschr (const wchar_t * wcs, wchar_t wc )
```

 **Description:**

Locates the first occurrence of the wide character pointed to by  **wc**  in the wide character string pointed to by  **wcs**. 

**Parameters:**

<a name="table821238880084824"></a>
<table><thead align="left"><tr id="row1373887128084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1545298203084824"><a name="p1545298203084824"></a><a name="p1545298203084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p454747649084824"><a name="p454747649084824"></a><a name="p454747649084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row317243306084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wcs</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide character string to match the specified wide character. </td>
</tr>
<tr id="row1325624195084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character to be located. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the first occurrence of the wide character; returns  **NULL**  if no match is found in the wide character string. 



## wcscmp\(\)<a name="gab361438866831d03563fbb430c1514c5"></a>

```
int wcscmp (const wchar_t * s1, const wchar_t * s2 )
```

 **Description:**

Compares each character in the string pointed to by  **s1**  with that in the string pointed to by  **s2**  in ASCII-code order. 

This comparison starts from the first character in the two strings. 

**Parameters:**

<a name="table1199857055084824"></a>
<table><thead align="left"><tr id="row1903974173084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1887565661084824"><a name="p1887565661084824"></a><a name="p1887565661084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p39084631084824"><a name="p39084631084824"></a><a name="p39084631084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1429032163084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to string 1 for comparison. </td>
</tr>
<tr id="row1673748738084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to string 2 for comparison. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the two strings are equal; returns the result of subtracting the ASCII code of string 2 from the ASCII code of string 1 if the first mismatch is found. 



## wcscoll\(\)<a name="ga99ef4b8381c22d8db3b2b13d8c3a3c29"></a>

```
int wcscoll (const wchar_t * ws1, const wchar_t * ws2 )
```

 **Description:**

Compares the wide characters in the string pointed to by  **ws1**  with those in the string pointed to by  **ws2**  based on the specified locale  [LC\_COLLATE](io.md#gaab9cf7b1a206fb75e5884934c8d676db). 

**Parameters:**

<a name="table1216784785084824"></a>
<table><thead align="left"><tr id="row1154852859084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2052129124084824"><a name="p2052129124084824"></a><a name="p2052129124084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p540228648084824"><a name="p540228648084824"></a><a name="p540228648084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row656303543084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ws1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to string 1 for comparison. </td>
</tr>
<tr id="row596571177084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ws2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to string 2 for comparison. </td>
</tr>
</tbody>
</table>

**Attention:**

By default, the program's current locale specified by  [LC\_COLLATE](io.md#gaab9cf7b1a206fb75e5884934c8d676db)  is  **POSIX**  or  **C**. 

**Returns:**

Returns  **0**  if the two strings are equal; returns the result of subtracting the ASCII code of string 2 from the ASCII code of string 1 if the first mismatch is found. 



## wcscoll\_l\(\)<a name="ga8bdd5a976685e97d9ac7f45f7951a52c"></a>

```
int wcscoll_l (const wchar_t * s1, const wchar_t * s2, locale_t locale )
```

 **Description:**

Compares wide characters in the string pointed to by  **s1**  with those in the string pointed to by  **s2**  based on the specified  **locale**  environment. 

**Parameters:**

<a name="table1389324267084824"></a>
<table><thead align="left"><tr id="row2085005006084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p514695533084824"><a name="p514695533084824"></a><a name="p514695533084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1257029374084824"><a name="p1257029374084824"></a><a name="p1257029374084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1033270696084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to wide character string 1 for comparison. </td>
</tr>
<tr id="row1479901791084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to wide character string 2 for comparison. </td>
</tr>
<tr id="row536733092084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the two wide character strings are equal; returns the code difference between the two wide character strings if they are not equal. 



## wcscpy\(\)<a name="gae6b223ed61020ed2abf0279af175b203"></a>

```
wchar_t* wcscpy (wchar_t * dest, const wchar_t * src )
```

 **Description:**

Copies the wide characters pointed to by  **src**  to the wide character array pointed to by  **dest**, including the terminating null character  **'\\0'**. . 

## wcscspn\(\)<a name="ga188fb5a6a8c210ee46b885a671f55c61"></a>

```
size_t wcscspn (const wchar_t * wcs, const wchar_t * accept )
```

 **Description:**

Scans the wide character string pointed to by  **wcs**  for any wide characters specified in  **reject**  and obtains the number of unmatched characters in  **wcs**. 

**Parameters:**

<a name="table895090056084824"></a>
<table><thead align="left"><tr id="row782990151084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p132143256084824"><a name="p132143256084824"></a><a name="p132143256084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1336024285084824"><a name="p1336024285084824"></a><a name="p1336024285084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row507052584084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wcs</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide character string to be scanned. </td>
</tr>
<tr id="row26416872084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">accept</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide characters to be matched with the string. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of unmatched characters in  **wcs**. 



## wcsdup\(\)<a name="ga21234261a334fd22ff3d6ba8883eca3a"></a>

```
wchar_t* wcsdup (const wchar_t * s)
```

 **Description:**

Copies a specified wide character string to a newly allocated buffer. 

**Parameters:**

<a name="table964032813084824"></a>
<table><thead align="left"><tr id="row1855583019084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1773603398084824"><a name="p1773603398084824"></a><a name="p1773603398084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p987556871084824"><a name="p987556871084824"></a><a name="p987556871084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1200214699084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide character string to copy. </td>
</tr>
</tbody>
</table>

**Attention:**

This function allocates memory for variables. It is best practice to release the memory if you do not use the returned wide character string. 

**Returns:**

Returns the pointer to the new wide string buffer. 



## wcsftime\(\)<a name="ga215d4539e43613e57c992b87158084b4"></a>

```
size_t wcsftime (wchar_t *__restrict wcs, size_t n, const wchar_t *__restrict f, const struct [tm](tm.md) *__restrict tm )
```

 **Description:**

Converts the date and time in the  **tm**  structure to a wide character string. 

**Parameters:**

<a name="table449906562084824"></a>
<table><thead align="left"><tr id="row1431340918084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1246900018084824"><a name="p1246900018084824"></a><a name="p1246900018084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p706910900084824"><a name="p706910900084824"></a><a name="p706910900084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1927083861084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wcs</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide character array to accommodate the converted string. </td>
</tr>
<tr id="row761658082084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the buffer for the wide character array. </td>
</tr>
<tr id="row384013706084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">f</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the required format. </td>
</tr>
<tr id="row2072281821084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tm</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the broken-down time in the <strong id="b619794976084824"><a name="b619794976084824"></a><a name="b619794976084824"></a>tm</strong> structure. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of bytes in the string if the conversion is successful; returns  **0**  otherwise. 



## wcslen\(\)<a name="ga7859e4ba07f77515772c4632d4caa4e0"></a>

```
size_t wcslen (const wchar_t * s)
```

 **Description:**

Calculates the length of a wide character string pointed to by  **s**. 

The length does not include the terminating null character  **'\\0'**. 

**Parameters:**

<a name="table1464908604084824"></a>
<table><thead align="left"><tr id="row1026404364084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1430867479084824"><a name="p1430867479084824"></a><a name="p1430867479084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1800847132084824"><a name="p1800847132084824"></a><a name="p1800847132084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1338435911084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide character string to be calculated. This parameter cannot be <strong id="b1691047708084824"><a name="b1691047708084824"></a><a name="b1691047708084824"></a>NULL</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the length of the string. 



## wcsncasecmp\(\)<a name="ga5c9957285778ae41af839bb22cc4a9d0"></a>

```
int wcsncasecmp (const wchar_t * s1, const wchar_t * s2, size_t n )
```

 **Description:**

Compares a maximum of  **n**  wide characters in the string pointed to by  **s1**  with those in the string pointed to by  **s2**, with their case differences ignored. 

**Parameters:**

<a name="table1474960915084824"></a>
<table><thead align="left"><tr id="row1355483288084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p744918151084824"><a name="p744918151084824"></a><a name="p744918151084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2143748571084824"><a name="p2143748571084824"></a><a name="p2143748571084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1438419431084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to wide character string 1 for comparison. </td>
</tr>
<tr id="row802193760084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to wide character string 2 for comparison. </td>
</tr>
<tr id="row111679413084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum number of wide characters to be compared. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the two wide character strings are equal; returns the code difference between the two wide character strings if they are not equal. 



## wcsncasecmp\_l\(\)<a name="ga157e21d5005c4af440f8fe0407dab8ec"></a>

```
int wcsncasecmp_l (const wchar_t * s1, const wchar_t * s2, size_t n, locale_t locale )
```

 **Description:**

Compares a maximum of  **n**  wide characters in the string pointed to by  **s1**  with those in the string pointed to by  **s2**  based on the specified  **locale**  environment, with their case differences ignored. 

**Parameters:**

<a name="table70158768084824"></a>
<table><thead align="left"><tr id="row994648230084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1811901296084824"><a name="p1811901296084824"></a><a name="p1811901296084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p867339143084824"><a name="p867339143084824"></a><a name="p867339143084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row592862208084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to wide character string 1 for comparison. </td>
</tr>
<tr id="row609298721084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to wide character string 2 for comparison. </td>
</tr>
<tr id="row932407023084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum number of wide characters to be compared. </td>
</tr>
<tr id="row2134466616084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the locale. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the two wide character strings are equal; returns the code difference between the two wide character strings if they are not equal. 



## wcsncat\(\)<a name="ga8af5b08f466d2d6843f7ec250eddb41c"></a>

```
wchar_t* wcsncat (wchar_t * dest, const wchar_t * src, size_t n )
```

 **Description:**

Appends a copy of the first  **n**  wide characters pointed to by  **src**  to the end of the wide characters pointed to by  **dest**  and adds a terminating null character  **'\\0'**. 

**Parameters:**

<a name="table97846610084824"></a>
<table><thead align="left"><tr id="row1800527798084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1291419023084824"><a name="p1291419023084824"></a><a name="p1291419023084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1318289831084824"><a name="p1318289831084824"></a><a name="p1318289831084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1660544340084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the array to accommodate the concatenated wide characters. </td>
</tr>
<tr id="row1129990689084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide characters to be concatenated. </td>
</tr>
<tr id="row1014951948084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum number of wide characters to be concatenated. </td>
</tr>
</tbody>
</table>

**Attention:**

Ensure that the wide character array pointed to by  **dest**  has enough space to accommodate the concatenated characters \([wcslen](utils.md#ga7859e4ba07f77515772c4632d4caa4e0)  \(**dest**\) +  **n**  + 1\). 

**Returns:**

Returns the pointer to the destination string after concatenation. 



## wcsncmp\(\)<a name="ga422e6bb262f249f2d71b6a2d77408038"></a>

```
int wcsncmp (const wchar_t * s1, const wchar_t * s2, size_t n )
```

 **Description:**

Compares the first  **n**  characters in the string pointed to by  **s1**  with those in the string pointed to by  **s2**  in ASCII-code order. 

**Parameters:**

<a name="table1399628939084824"></a>
<table><thead align="left"><tr id="row401725985084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1322277756084824"><a name="p1322277756084824"></a><a name="p1322277756084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1458037667084824"><a name="p1458037667084824"></a><a name="p1458037667084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1281957879084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to string 1 for comparison. </td>
</tr>
<tr id="row1655167265084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to string 2 for comparison. </td>
</tr>
<tr id="row1385282600084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum number of characters to be compared. </td>
</tr>
</tbody>
</table>

**Attention:**

If  **n**  is greater than the length of string 1 or string 2, the comparison stops when reaching the terminating null character  **L'\\0'**  for the first time. 

**Returns:**

Returns  **0**  if the two strings are equal; returns the result of subtracting the ASCII code of string 2 from the ASCII code of string 1 if the first mismatch is found. 



## wcsncpy\(\)<a name="gab1f03e735cf92afa01bef89682008c9b"></a>

```
wchar_t* wcsncpy (wchar_t * dest, const wchar_t * src, size_t n )
```

 **Description:**

Copies the first  **n**  wide characters pointed to by  **src**  to the wide character array pointed to by  **dest**. 

**Parameters:**

<a name="table1610942602084824"></a>
<table><thead align="left"><tr id="row1125525816084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p808519116084824"><a name="p808519116084824"></a><a name="p808519116084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p725340077084824"><a name="p725340077084824"></a><a name="p725340077084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row203472881084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the array to accommodate the copied wide characters. </td>
</tr>
<tr id="row866438805084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide characters to be copied. </td>
</tr>
<tr id="row2101519253084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum number of wide characters to be copied. </td>
</tr>
</tbody>
</table>

**Attention:**

Ensure that the array pointed to by  **dest**  is large enough to accommodate the source characters. If the  **dest**  space is insufficient, unexpected exceptions may occur. Whenever a program reads data from or copies data to a buffer, it should first check whether there is enough space for the data. If the first  **n**  wide characters pointed to by  **src**  do not contain null characters, the character string copied to  **dest**  does not end with  **null**. 

**Returns:**

Returns the pointer to the destination string. 



## wcsnlen\(\)<a name="ga5ef7fc85c7678f86f1530fd52dbf2486"></a>

```
size_t wcsnlen (const wchar_t * s, size_t maxlen )
```

 **Description:**

Calculates the length of a wide character string pointed to by  **s**. 

If the length of the string exceeds  **maxlen**,  **maxlen**  is returned. 

**Parameters:**

<a name="table1711883452084824"></a>
<table><thead align="left"><tr id="row1218420426084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1079372709084824"><a name="p1079372709084824"></a><a name="p1079372709084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1198280454084824"><a name="p1198280454084824"></a><a name="p1198280454084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1900530453084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide character string whose length is to be calculated. </td>
</tr>
<tr id="row1844142276084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">maxlen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum length of the string whose length is to be calculated. </td>
</tr>
</tbody>
</table>

**Attention:**

The length of the string does not include the terminating null character  **'\\0'**. 

**Returns:**

Returns the length of the wide character string if the operation is successful; returns  **maxlen**  if the length of the string exceeds  **maxlen**. 



## wcsnrtombs\(\)<a name="gaf189ea21a3aa444f88607ad23f448f37"></a>

```
size_t wcsnrtombs (char * dest, const wchar_t ** src, size_t nwc, size_t len, mbstate_t * ps )
```

 **Description:**

Converts  **nwc**  wide characters in the string pointed to by  **src**  into a character string. 

**Parameters:**

<a name="table1546437634084824"></a>
<table><thead align="left"><tr id="row102807350084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1973453508084824"><a name="p1973453508084824"></a><a name="p1973453508084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p659963998084824"><a name="p659963998084824"></a><a name="p659963998084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row20732089084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to character array to accommodate the character string. </td>
</tr>
<tr id="row82021553084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the double pointer to the source wide character string to be converted. </td>
</tr>
<tr id="row657563679084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nwc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of wide characters to be converted. </td>
</tr>
<tr id="row1869114287084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">len</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum number of bytes to be written to the destination string. </td>
</tr>
<tr id="row1722001739084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ps</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the <strong id="b2074200268084824"><a name="b2074200268084824"></a><a name="b2074200268084824"></a>mbstate_t</strong> object describing the conversion state. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of converted bytes, excluding the terminating null byte  **'\\0'**  if the operation is successful; returns  **-1**  and sets  **errno**  to  [EILSEQ](utils.md#gac6c071293826a4e66a717bb38db7794d)  if the operation fails. 



## wcspbrk\(\)<a name="ga65c3cbada5beb856956f682e7ab2d812"></a>

```
wchar_t* wcspbrk (const wchar_t * wcs, const wchar_t * accept )
```

 **Description:**

Scans the wide character string pointed to by  **wcs**  for any wide characters specified in  **accept**  and obtains the first occurrence of the matched character. 

**Parameters:**

<a name="table643235462084824"></a>
<table><thead align="left"><tr id="row1395175118084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p562387395084824"><a name="p562387395084824"></a><a name="p562387395084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1991103920084824"><a name="p1991103920084824"></a><a name="p1991103920084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row801960962084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wcs</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide character string to be scanned. </td>
</tr>
<tr id="row2007982119084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">accept</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide characters to be matched with the string. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the first occurrence of the matched character; returns  **NULL**  if no match is found. 



## wcsrchr\(\)<a name="ga1e2b53d4a4eb975edfd1ec59099a43bd"></a>

```
wchar_t* wcsrchr (const wchar_t * wcs, wchar_t wc )
```

 **Description:**

Locates the last occurrence of the wide character pointed to by  **wc**  in the wide character string pointed to by  **wcs**. 

**Parameters:**

<a name="table1247340703084824"></a>
<table><thead align="left"><tr id="row279281560084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p84254036084824"><a name="p84254036084824"></a><a name="p84254036084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p95709902084824"><a name="p95709902084824"></a><a name="p95709902084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row15638837084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wcs</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide character string to match the specified wide character. </td>
</tr>
<tr id="row974612549084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the wide character to be located. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the last occurrence of the wide character; returns  **NULL**  if no match is found in the wide character string. 



## wcsrtombs\(\)<a name="ga0a628490d6458cfc836ebf3721e68a98"></a>

```
size_t wcsrtombs (char * dest, const wchar_t ** src, size_t len, mbstate_t * ps )
```

 **Description:**

Converts a wide character string into a multi-byte string. 

**Parameters:**

<a name="table1315696118084824"></a>
<table><thead align="left"><tr id="row16211366084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1331878576084824"><a name="p1331878576084824"></a><a name="p1331878576084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p657325516084824"><a name="p657325516084824"></a><a name="p657325516084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1204337401084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dest</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the character string array to accommodate the multi-byte string. </td>
</tr>
<tr id="row1509742621084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">src</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the double pointer to the source string to be converted. </td>
</tr>
<tr id="row1188533719084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">len</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum number of bytes to be written to the destination string array. </td>
</tr>
<tr id="row2098852919084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ps</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the <strong id="b1132641987084824"><a name="b1132641987084824"></a><a name="b1132641987084824"></a>mbstate_t</strong> object describing the conversion state. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of converted bytes, excluding the terminating null byte  **'\\0'**  if the operation is successful; returns  **-1**  and sets  **errno**  to  [EILSEQ](utils.md#gac6c071293826a4e66a717bb38db7794d)  if the operation fails. 



## wcsspn\(\)<a name="ga2a5d42d9b374cbffb3037d0e7efb97a9"></a>

```
size_t wcsspn (const wchar_t * wcs, const wchar_t * accept )
```

 **Description:**

Scans the wide character string pointed to by  **wcs**  for any wide characters specified in  **reject**  and obtains the number matched characters in  **wcs**. 

**Parameters:**

<a name="table673197808084824"></a>
<table><thead align="left"><tr id="row294477464084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p285038055084824"><a name="p285038055084824"></a><a name="p285038055084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1700196051084824"><a name="p1700196051084824"></a><a name="p1700196051084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1943007944084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wcs</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide character string to be scanned. </td>
</tr>
<tr id="row363932843084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">accept</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide characters to be matched with the string. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of matched characters in  **wcs**. 



## wcstod\(\)<a name="ga2030f1f318ded574650a1957574711a0"></a>

```
double wcstod (const wchar_t * str, wchar_t ** endptr )
```

 **Description:**

Converts a wide character string pointed to by  **str**  into a double value and assigns the next character in  **str**  after the double value to  **endptr**. 

**Parameters:**

<a name="table1498846784084824"></a>
<table><thead align="left"><tr id="row1132980617084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2123071204084824"><a name="p2123071204084824"></a><a name="p2123071204084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p74699704084824"><a name="p74699704084824"></a><a name="p74699704084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1726222658084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">str</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the wide character string to be conv