# Surface<a name="EN-US_TOPIC_0000001054479515"></a>

## **Overview**<a name="section351233139093522"></a>

Provides the capabilities of applying for and releasing shared memory in multimedia and graphics scenarios. 

Provides shared memory for multimedia and graphics.

This module is used to apply for and release shared memory and is used by the multimedia and graphics modules across processes.

**Since:**

1.0

**Version:**

1.0

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section1345510197093522"></a>

## Files<a name="files"></a>

<a name="table1285623106093522"></a>
<table><thead align="left"><tr id="row991080647093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p754545824093522"><a name="p754545824093522"></a><a name="p754545824093522"></a>File Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1936396249093522"><a name="p1936396249093522"></a><a name="p1936396249093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1784971280093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1423238432093522"><a name="p1423238432093522"></a><a name="p1423238432093522"></a><a href="ibuffer_consumer_listener-h.md">ibuffer_consumer_listener.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p890325285093522"><a name="p890325285093522"></a><a name="p890325285093522"></a>Declares the consumer listener used to notify consumers when the surface status is updated. </p>
</td>
</tr>
<tr id="row681425548093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p730858407093522"><a name="p730858407093522"></a><a name="p730858407093522"></a><a href="surface-h.md">surface.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2021253754093522"><a name="p2021253754093522"></a><a name="p2021253754093522"></a>Provides the capabilities of applying for and releasing shared memory in multimedia and graphics scenarios. </p>
</td>
</tr>
<tr id="row1509273340093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1194000063093522"><a name="p1194000063093522"></a><a name="p1194000063093522"></a><a href="surface_buffer-h.md">surface_buffer.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1704180026093522"><a name="p1704180026093522"></a><a name="p1704180026093522"></a>Provides functions such as setting the virtual address, size, and additional attributes of shared memory. </p>
</td>
</tr>
<tr id="row655261039093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1234689917093522"><a name="p1234689917093522"></a><a name="p1234689917093522"></a><a href="surface_type-h.md">surface_type.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1580168438093522"><a name="p1580168438093522"></a><a name="p1580168438093522"></a>Provides the capabilities of setting shared memory parameters. </p>
</td>
</tr>
</tbody>
</table>

## Data Structures<a name="nested-classes"></a>

<a name="table1864571618093522"></a>
<table><thead align="left"><tr id="row127698623093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p348225689093522"><a name="p348225689093522"></a><a name="p348225689093522"></a>Data Structure Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p745961000093522"><a name="p745961000093522"></a><a name="p745961000093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row27223865093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1978932221093522"><a name="p1978932221093522"></a><a name="p1978932221093522"></a><a href="ohos-ibufferconsumerlistener.md">OHOS::IBufferConsumerListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2032439082093522"><a name="p2032439082093522"></a><a name="p2032439082093522"></a>Defines the consumer listener used to notify consumers when the surface status is updated. </p>
</td>
</tr>
<tr id="row1675268435093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1080781173093522"><a name="p1080781173093522"></a><a name="p1080781173093522"></a><a href="ohos-surface.md">OHOS::Surface</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p814876509093522"><a name="p814876509093522"></a><a name="p814876509093522"></a>Defines the consumer listener used to notify consumers when the surface status is updated. </p>
</td>
</tr>
<tr id="row1038900142093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2033559065093522"><a name="p2033559065093522"></a><a name="p2033559065093522"></a><a href="ohos-surfacebuffer.md">OHOS::SurfaceBuffer</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1870344104093522"><a name="p1870344104093522"></a><a name="p1870344104093522"></a>Provides functions such as setting the virtual address, size, and additional attributes of shared memory. </p>
</td>
</tr>
</tbody>
</table>

## Enumerations<a name="enum-members"></a>

<a name="table1323905441093522"></a>
<table><thead align="left"><tr id="row1165728887093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1533235906093522"><a name="p1533235906093522"></a><a name="p1533235906093522"></a>Enumeration Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1569093571093522"><a name="p1569093571093522"></a><a name="p1569093571093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row143723237093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1822453283093522"><a name="p1822453283093522"></a><a name="p1822453283093522"></a><a href="surface.md#ga16d4d4f73d748455e45924ffbdd1e891">OHOS::BufferConsumerUsage</a> {   <a href="surface.md#gga16d4d4f73d748455e45924ffbdd1e891a59c0ac95bd7994b6eda43b34f59c237b">OHOS::BUFFER_CONSUMER_USAGE_SORTWARE</a> = 0, <a href="surface.md#gga16d4d4f73d748455e45924ffbdd1e891abe0bc63ca1799ca0b2182e908780da7b">OHOS::BUFFER_CONSUMER_USAGE_HARDWARE</a>, <a href="surface.md#gga16d4d4f73d748455e45924ffbdd1e891a93eebf8af6f264494a57771865c90b08">OHOS::BUFFER_CONSUMER_USAGE_HARDWARE_CONSUMER_CACHE</a>, <a href="surface.md#gga16d4d4f73d748455e45924ffbdd1e891a7a31f6403b7aa4ba989e7cd5b3eb7a06">OHOS::BUFFER_CONSUMER_USAGE_HARDWARE_PRODUCER_CACHE</a>,   <a href="surface.md#gga16d4d4f73d748455e45924ffbdd1e891a56aa1994f77d06504c40421f6555f1cf">OHOS::BUFFER_CONSUMER_USAGE_MAX</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1845226383093522"><a name="p1845226383093522"></a><a name="p1845226383093522"></a>Enumerates shared memory usage scenarios, including physically contiguous memory and virtual memory. </p>
</td>
</tr>
<tr id="row396713906093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p996031685093522"><a name="p996031685093522"></a><a name="p996031685093522"></a><a href="surface.md#gaa191d6e3b92a0f527744d43e056ae025">OHOS::ImagePixelFormat</a> {   <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025a9690a1d8cf1d21fcad76876f122a12ab">OHOS::IMAGE_PIXEL_FORMAT_NONE</a> = 0, <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025aff11848c6a38afb3afdcbeaec2400055">OHOS::IMAGE_PIXEL_FORMAT_RGB565</a> = 101, <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025a9cf3bfb5153d8cf23f4c0d3bb9cc4f43">OHOS::IMAGE_PIXEL_FORMAT_ARGB1555</a>, <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025ad4774f5ba15cf25a3d0951f5986ab0d5">OHOS::IMAGE_PIXEL_FORMAT_RGB888</a>,   <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025a1a18541878a09cbca269918a7ef4796f">OHOS::IMAGE_PIXEL_FORMAT_ARGB8888</a>, <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025affcb2a4b4832e3c33789f9e8efffe7b0">OHOS::IMAGE_PIXEL_FORMAT_YUYV</a> = 201, <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025a4ec5bc985a5f49f26178ab18c074cfa6">OHOS::IMAGE_PIXEL_FORMAT_YVYU</a>, <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025a098b93504ac8e11c4d5d488930187f37">OHOS::IMAGE_PIXEL_FORMAT_UYVY</a>,   <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025a0e242cad6dae11690013c6771b80fc9b">OHOS::IMAGE_PIXEL_FORMAT_VYUY</a>, <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025ab690ca190de1686041f0d0c320427b1c">OHOS::IMAGE_PIXEL_FORMAT_AYUV</a>, <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025aa4e3c6974a86c29cf707f371ad1b0b49">OHOS::IMAGE_PIXEL_FORMAT_YUV410</a>, <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025a3c4c9612392a81fa2d1d305d08064146">OHOS::IMAGE_PIXEL_FORMAT_YVU410</a>,   <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025acc77b028562f155f1099de249b7bffae">OHOS::IMAGE_PIXEL_FORMAT_YUV411</a>, <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025a99cb00970d669d9ba2ac1049d19c60e4">OHOS::IMAGE_PIXEL_FORMAT_YVU411</a>, <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025acf60892315d8aee3d421f75d70db796f">OHOS::IMAGE_PIXEL_FORMAT_YUV420</a>, <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025ac3dfd6c2f350194d2a525a14d9e72b71">OHOS::IMAGE_PIXEL_FORMAT_YVU420</a>,   <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025ae87be6ce296c907d99381d1db48c288f">OHOS::IMAGE_PIXEL_FORMAT_YUV422</a>, <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025ab33d1df10479e267ca7c3cb6102d8dbb">OHOS::IMAGE_PIXEL_FORMAT_YVU422</a>, <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025a7f2a90344e786071a49db0da82b201e4">OHOS::IMAGE_PIXEL_FORMAT_YUV444</a>, <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025a4e18880bae5fa08cbd510f23f549087d">OHOS::IMAGE_PIXEL_FORMAT_YVU444</a>,   <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025a93a54b97b83f6e042c993d045be27a33">OHOS::IMAGE_PIXEL_FORMAT_NV12</a> = 301, <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025ab7d0f6b75189a47fdf613bbbeaa3b628">OHOS::IMAGE_PIXEL_FORMAT_NV21</a>, <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025a5fd084cc32d1fdbe8017fd210a7e3ffa">OHOS::IMAGE_PIXEL_FORMAT_NV16</a>, <a href="surface.md#ggaa191d6e3b92a0f527744d43e056ae025a77a0063a555db3ca68a304e494f094cf">OHOS::IMAGE_PIXEL_FORMAT_NV61</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p802777964093522"><a name="p802777964093522"></a><a name="p802777964093522"></a>Enumerates a pixel format. </p>
</td>
</tr>
</tbody>
</table>

## Functions<a name="func-members"></a>

<a name="table1246194742093522"></a>
<table><thead align="left"><tr id="row28315575093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p964742587093522"><a name="p964742587093522"></a><a name="p964742587093522"></a>Function Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p860860150093522"><a name="p860860150093522"></a><a name="p860860150093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1846512457093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1174626438093522"><a name="p1174626438093522"></a><a name="p1174626438093522"></a><a href="surface.md#ga9a99aa36b37197b2ca409b8f4e7335c7">OHOS::IBufferConsumerListener::OnBufferAvailable</a> ()=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1957221819093522"><a name="p1957221819093522"></a><a name="p1957221819093522"></a>virtual void </p>
<p id="p591243292093522"><a name="p591243292093522"></a><a name="p591243292093522"></a>Called to notify a consumer that a buffer is available for consumption. </p>
</td>
</tr>
<tr id="row543083298093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p294548380093522"><a name="p294548380093522"></a><a name="p294548380093522"></a><a href="surface.md#ga49d6a759bec670ea5a47bee4eb252ae3">OHOS::Surface::CreateSurface</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p769301519093522"><a name="p769301519093522"></a><a name="p769301519093522"></a>static <a href="ohos-surface.md">Surface</a> * </p>
<p id="p744680206093522"><a name="p744680206093522"></a><a name="p744680206093522"></a>A constructor used to create a <a href="surface.md">Surface</a> object for consumers to use. </p>
</td>
</tr>
<tr id="row732359013093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p374565277093522"><a name="p374565277093522"></a><a name="p374565277093522"></a><a href="surface.md#ga1d35e9b436057032ec4598f24e31dbfb">OHOS::Surface::~Surface</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p59921082093522"><a name="p59921082093522"></a><a name="p59921082093522"></a>virtual </p>
<p id="p588201037093522"><a name="p588201037093522"></a><a name="p588201037093522"></a>A destructor used to delete the <strong id="b231966662093522"><a name="b231966662093522"></a><a name="b231966662093522"></a><a href="ohos-surface.md">Surface</a></strong> instance. </p>
</td>
</tr>
<tr id="row1868797235093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p149670164093522"><a name="p149670164093522"></a><a name="p149670164093522"></a><a href="surface.md#ga44138c9aa20a108358da26893b92150c">OHOS::Surface::SetQueueSize</a> (uint8_t queueSize)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p100375817093522"><a name="p100375817093522"></a><a name="p100375817093522"></a>virtual void </p>
<p id="p675008275093522"><a name="p675008275093522"></a><a name="p675008275093522"></a>Sets the number of buffers that can be allocated to the surface. The default value is <strong id="b354670153093522"><a name="b354670153093522"></a><a name="b354670153093522"></a>1</strong>. The value range is [1, 10]. </p>
</td>
</tr>
<tr id="row272134287093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p960377493093522"><a name="p960377493093522"></a><a name="p960377493093522"></a><a href="surface.md#gaff365f4d3178798ff28f0aaab9f467de">OHOS::Surface::GetQueueSize</a> ()=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1604341591093522"><a name="p1604341591093522"></a><a name="p1604341591093522"></a>virtual uint8_t </p>
<p id="p1435638854093522"><a name="p1435638854093522"></a><a name="p1435638854093522"></a>Obtains the number of surface buffers that can be allocated to the surface. The default value is <strong id="b2093376758093522"><a name="b2093376758093522"></a><a name="b2093376758093522"></a>1</strong>. The value range is [1, 10]. </p>
</td>
</tr>
<tr id="row1278737614093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1021020927093522"><a name="p1021020927093522"></a><a name="p1021020927093522"></a><a href="surface.md#ga260c12281c283e5a0b63a49f24bd0cc0">OHOS::Surface::SetWidthAndHeight</a> (uint32_t width, uint32_t height)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1270707431093522"><a name="p1270707431093522"></a><a name="p1270707431093522"></a>virtual void </p>
<p id="p986910988093522"><a name="p986910988093522"></a><a name="p986910988093522"></a>Sets the width and height of the surface for calculating its stride and size. The default value range of width and height is (0,7680]. </p>
</td>
</tr>
<tr id="row1957272126093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1925624685093522"><a name="p1925624685093522"></a><a name="p1925624685093522"></a><a href="surface.md#ga1220bd15e73d891105d310cf37422b56">OHOS::Surface::GetWidth</a> ()=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p739560101093522"><a name="p739560101093522"></a><a name="p739560101093522"></a>virtual uint32_t </p>
<p id="p1485717479093522"><a name="p1485717479093522"></a><a name="p1485717479093522"></a>Obtains the width of the surface. </p>
</td>
</tr>
<tr id="row1257730026093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1410970598093522"><a name="p1410970598093522"></a><a name="p1410970598093522"></a><a href="surface.md#ga0e6be0887bd69cf749c0d994bd826699">OHOS::Surface::GetHeight</a> ()=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p786746692093522"><a name="p786746692093522"></a><a name="p786746692093522"></a>virtual uint32_t </p>
<p id="p1689944196093522"><a name="p1689944196093522"></a><a name="p1689944196093522"></a>Obtains the height of the surface. </p>
</td>
</tr>
<tr id="row1007491308093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p749588638093522"><a name="p749588638093522"></a><a name="p749588638093522"></a><a href="surface.md#ga8e44c9100296571a9294dc9851ef48dc">OHOS::Surface::SetFormat</a> (uint32_t format)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p791482778093522"><a name="p791482778093522"></a><a name="p791482778093522"></a>virtual void </p>
<p id="p1779410944093522"><a name="p1779410944093522"></a><a name="p1779410944093522"></a>Sets the pixel format of the surface. For details, see <strong id="b725418910093522"><a name="b725418910093522"></a><a name="b725418910093522"></a>ImageFormat</strong>. The default pixel format is <strong id="b1866963365093522"><a name="b1866963365093522"></a><a name="b1866963365093522"></a>IMAGE_PIXEL_FORMAT_RGB565</strong>. </p>
</td>
</tr>
<tr id="row2095045221093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p697579884093522"><a name="p697579884093522"></a><a name="p697579884093522"></a><a href="surface.md#ga461caa118503a471c78ea09a8403a6ec">OHOS::Surface::GetFormat</a> ()=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p996321262093522"><a name="p996321262093522"></a><a name="p996321262093522"></a>virtual uint32_t </p>
<p id="p1828867495093522"><a name="p1828867495093522"></a><a name="p1828867495093522"></a>Obtains the pixel format of the surface. For details, see <strong id="b1579517631093522"><a name="b1579517631093522"></a><a name="b1579517631093522"></a>ImageFormat</strong>. The default pixel format is <strong id="b1208574631093522"><a name="b1208574631093522"></a><a name="b1208574631093522"></a>IMAGE_PIXEL_FORMAT_RGB565</strong>. </p>
</td>
</tr>
<tr id="row1160097259093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p613946927093522"><a name="p613946927093522"></a><a name="p613946927093522"></a><a href="surface.md#ga5b27f54101d9d3371038b73373c36530">OHOS::Surface::SetStrideAlignment</a> (uint32_t strideAlignment)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p200596140093522"><a name="p200596140093522"></a><a name="p200596140093522"></a>virtual void </p>
<p id="p741210185093522"><a name="p741210185093522"></a><a name="p741210185093522"></a>Sets the number of bytes for stride alignment. </p>
</td>
</tr>
<tr id="row1170255729093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p919702408093522"><a name="p919702408093522"></a><a name="p919702408093522"></a><a href="surface.md#ga0d5317e6a008b8fd0ee98ebd516a0e7c">OHOS::Surface::GetStrideAlignment</a> ()=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p463612115093522"><a name="p463612115093522"></a><a name="p463612115093522"></a>virtual uint32_t </p>
<p id="p75065834093522"><a name="p75065834093522"></a><a name="p75065834093522"></a>Obtains the number of bytes for stride alignment. By default, 4-byte aligned is used. </p>
</td>
</tr>
<tr id="row1217832452093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p267470810093522"><a name="p267470810093522"></a><a name="p267470810093522"></a><a href="surface.md#ga5aabbb48f86992494c88ee2a7d00aa09">OHOS::Surface::GetStride</a> ()=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p273853232093522"><a name="p273853232093522"></a><a name="p273853232093522"></a>virtual uint32_t </p>
<p id="p1186843778093522"><a name="p1186843778093522"></a><a name="p1186843778093522"></a>Obtains the stride of the surface. </p>
</td>
</tr>
<tr id="row110361914093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1117759598093522"><a name="p1117759598093522"></a><a name="p1117759598093522"></a><a href="surface.md#ga3b2391ee37e762fa0fb093585c084714">OHOS::Surface::SetSize</a> (uint32_t size)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p354722398093522"><a name="p354722398093522"></a><a name="p354722398093522"></a>virtual void </p>
<p id="p457647320093522"><a name="p457647320093522"></a><a name="p457647320093522"></a>Sets the size of the shared memory to allocate. </p>
</td>
</tr>
<tr id="row38685159093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p851014734093522"><a name="p851014734093522"></a><a name="p851014734093522"></a><a href="surface.md#ga88e74ff7dc0ae3beb23df3ed00a81fc9">OHOS::Surface::GetSize</a> ()=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p812301268093522"><a name="p812301268093522"></a><a name="p812301268093522"></a>virtual uint32_t </p>
<p id="p1079646186093522"><a name="p1079646186093522"></a><a name="p1079646186093522"></a>Obtains the size of the shared memory to allocate. </p>
</td>
</tr>
<tr id="row2020865934093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p866713812093522"><a name="p866713812093522"></a><a name="p866713812093522"></a><a href="surface.md#ga01df6145a5fda3ba72c50258634720b8">OHOS::Surface::SetUsage</a> (uint32_t usage)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p49495158093522"><a name="p49495158093522"></a><a name="p49495158093522"></a>virtual void </p>
<p id="p373522716093522"><a name="p373522716093522"></a><a name="p373522716093522"></a>Sets the usage scenario of the buffer. Physically contiguous memory and virtual memory (by default) are supported. By default, virtual memory is allocated. </p>
</td>
</tr>
<tr id="row52321942093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p711949938093522"><a name="p711949938093522"></a><a name="p711949938093522"></a><a href="surface.md#ga6a043b41406f282339bb68c1fc4793f9">OHOS::Surface::GetUsage</a> ()=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1286285344093522"><a name="p1286285344093522"></a><a name="p1286285344093522"></a>virtual uint32_t </p>
<p id="p2071590851093522"><a name="p2071590851093522"></a><a name="p2071590851093522"></a>Obtains the usage scenario of the buffer. Physically contiguous memory and virtual memory are supported. </p>
</td>
</tr>
<tr id="row1757625223093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p444722713093522"><a name="p444722713093522"></a><a name="p444722713093522"></a><a href="surface.md#gae264fef4c98719a7c34bc85442cd1a5b">OHOS::Surface::SetUserData</a> (const std::string &amp;key, const std::string &amp;value)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2101665934093522"><a name="p2101665934093522"></a><a name="p2101665934093522"></a>virtual void </p>
<p id="p305242951093522"><a name="p305242951093522"></a><a name="p305242951093522"></a>Sets surface user data, which is stored in the format of &lt;key, value&gt;. </p>
</td>
</tr>
<tr id="row1519759113093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1624532381093522"><a name="p1624532381093522"></a><a name="p1624532381093522"></a><a href="surface.md#gadd1c8826fd3191cd5f6a52594c5ef3ba">OHOS::Surface::GetUserData</a> (const std::string &amp;key)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1447758633093522"><a name="p1447758633093522"></a><a name="p1447758633093522"></a>virtual std::string </p>
<p id="p1521679580093522"><a name="p1521679580093522"></a><a name="p1521679580093522"></a>Obtains surface user data. </p>
</td>
</tr>
<tr id="row1876356462093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p76741984093522"><a name="p76741984093522"></a><a name="p76741984093522"></a><a href="surface.md#gacc46ffcd4258b2660dc6cde05854c4ac">OHOS::Surface::RequestBuffer</a> (uint8_t <a href="en-us_topic_0000001054479509.md#gabf2fbcf6df59fd5234e9eed4db1a1804">wait</a>=0)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1498392338093522"><a name="p1498392338093522"></a><a name="p1498392338093522"></a>virtual <a href="ohos-surfacebuffer.md">SurfaceBuffer</a> * </p>
<p id="p1142522236093522"><a name="p1142522236093522"></a><a name="p1142522236093522"></a>Obtains a buffer to write data. </p>
</td>
</tr>
<tr id="row725000942093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p552561168093522"><a name="p552561168093522"></a><a name="p552561168093522"></a><a href="surface.md#ga8af29f3c031c1b3effe8de7366579329">OHOS::Surface::FlushBuffer</a> (<a href="ohos-surfacebuffer.md">SurfaceBuffer</a> *buffer)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1195668321093522"><a name="p1195668321093522"></a><a name="p1195668321093522"></a>virtual int32_t </p>
<p id="p2116919036093522"><a name="p2116919036093522"></a><a name="p2116919036093522"></a>Flushes a buffer to the dirty queue for consumers to use. </p>
</td>
</tr>
<tr id="row760727815093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1899747238093522"><a name="p1899747238093522"></a><a name="p1899747238093522"></a><a href="surface.md#ga7acd9899b1ca4eb02ed13d54c2aca0af">OHOS::Surface::AcquireBuffer</a> ()=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p602819726093522"><a name="p602819726093522"></a><a name="p602819726093522"></a>virtual <a href="ohos-surfacebuffer.md">SurfaceBuffer</a> * </p>
<p id="p1377525821093522"><a name="p1377525821093522"></a><a name="p1377525821093522"></a>Obtains a buffer. </p>
</td>
</tr>
<tr id="row2056133337093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p762274931093522"><a name="p762274931093522"></a><a name="p762274931093522"></a><a href="surface.md#ga4150c81248f516882ef120731d9abb66">OHOS::Surface::ReleaseBuffer</a> (<a href="ohos-surfacebuffer.md">SurfaceBuffer</a> *buffer)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p264309635093522"><a name="p264309635093522"></a><a name="p264309635093522"></a>virtual bool </p>
<p id="p1829560895093522"><a name="p1829560895093522"></a><a name="p1829560895093522"></a>Releases the consumed buffer. </p>
</td>
</tr>
<tr id="row1785327074093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p320269696093522"><a name="p320269696093522"></a><a name="p320269696093522"></a><a href="surface.md#ga6bae4ebcdc4e300eb5a076054f3379e4">OHOS::Surface::CancelBuffer</a> (<a href="ohos-surfacebuffer.md">SurfaceBuffer</a> *buffer)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p411347964093522"><a name="p411347964093522"></a><a name="p411347964093522"></a>virtual void </p>
<p id="p507302144093522"><a name="p507302144093522"></a><a name="p507302144093522"></a>Releases a buffer to the free queue. </p>
</td>
</tr>
<tr id="row12137020093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1812744777093522"><a name="p1812744777093522"></a><a name="p1812744777093522"></a><a href="surface.md#ga4b997a5b9493ad6d2015f86766f12b02">OHOS::Surface::RegisterConsumerListener</a> (<a href="ohos-ibufferconsumerlistener.md">IBufferConsumerListener</a> &amp;listener)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1219339323093522"><a name="p1219339323093522"></a><a name="p1219339323093522"></a>virtual void </p>
<p id="p1381587269093522"><a name="p1381587269093522"></a><a name="p1381587269093522"></a>Registers a consumer listener. </p>
</td>
</tr>
<tr id="row68443442093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p48130014093522"><a name="p48130014093522"></a><a name="p48130014093522"></a><a href="surface.md#ga0f303409d32d8d2b467888bf8fdc3223">OHOS::Surface::UnregisterConsumerListener</a> ()=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1278275888093522"><a name="p1278275888093522"></a><a name="p1278275888093522"></a>virtual void </p>
<p id="p1295912550093522"><a name="p1295912550093522"></a><a name="p1295912550093522"></a>Unregisters the consumer listener. </p>
</td>
</tr>
<tr id="row1634324332093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p767083059093522"><a name="p767083059093522"></a><a name="p767083059093522"></a><a href="surface.md#ga623d6c8ced742a36017bb71f6441b2a7">OHOS::SurfaceBuffer::GetVirAddr</a> () const =0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p6249625093522"><a name="p6249625093522"></a><a name="p6249625093522"></a>virtual void * </p>
<p id="p1657382860093522"><a name="p1657382860093522"></a><a name="p1657382860093522"></a>Obtains the virtual address of shared memory for producers and consumers. </p>
</td>
</tr>
<tr id="row179597031093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p41357252093522"><a name="p41357252093522"></a><a name="p41357252093522"></a><a href="surface.md#ga5d797958fed83fdea15b3f6ad5ddf97e">OHOS::SurfaceBuffer::GetPhyAddr</a> () const =0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2017610963093522"><a name="p2017610963093522"></a><a name="p2017610963093522"></a>virtual uint64_t </p>
<p id="p1748760164093522"><a name="p1748760164093522"></a><a name="p1748760164093522"></a>Obtains the physical address of shared memory. </p>
</td>
</tr>
<tr id="row729332118093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1500487961093522"><a name="p1500487961093522"></a><a name="p1500487961093522"></a><a href="surface.md#gaad9d0ca349b3f398b31c38ac9a650138">OHOS::SurfaceBuffer::GetSize</a> () const =0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p409318303093522"><a name="p409318303093522"></a><a name="p409318303093522"></a>virtual uint32_t </p>
<p id="p620724688093522"><a name="p620724688093522"></a><a name="p620724688093522"></a>Obtains the size of shared memory. </p>
</td>
</tr>
<tr id="row996074276093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1237964316093522"><a name="p1237964316093522"></a><a name="p1237964316093522"></a><a href="surface.md#ga818ee9015ff03d536b9a73d52f36b4f2">OHOS::SurfaceBuffer::SetSize</a> (uint32_t size)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1805754698093522"><a name="p1805754698093522"></a><a name="p1805754698093522"></a>virtual void </p>
<p id="p1142843219093522"><a name="p1142843219093522"></a><a name="p1142843219093522"></a>Sets the size of shared memory. </p>
</td>
</tr>
<tr id="row221995900093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1299022683093522"><a name="p1299022683093522"></a><a name="p1299022683093522"></a><a href="surface.md#gaf4b467cb2d7015d00f4bcf77c5b19875">OHOS::SurfaceBuffer::SetInt32</a> (uint32_t key, int32_t value)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1525714969093522"><a name="p1525714969093522"></a><a name="p1525714969093522"></a>virtual int32_t </p>
<p id="p210568588093522"><a name="p210568588093522"></a><a name="p210568588093522"></a>Sets an extra attribute value of the int32 type. </p>
</td>
</tr>
<tr id="row1163105656093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1064929051093522"><a name="p1064929051093522"></a><a name="p1064929051093522"></a><a href="surface.md#ga54a916606158a8799fe421eb3842848e">OHOS::SurfaceBuffer::GetInt32</a> (uint32_t key, int32_t &amp;value)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p582303982093522"><a name="p582303982093522"></a><a name="p582303982093522"></a>virtual int32_t </p>
<p id="p1216826053093522"><a name="p1216826053093522"></a><a name="p1216826053093522"></a>Obtains an extra attribute value of the int32 type. </p>
</td>
</tr>
<tr id="row1896457092093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p77287894093522"><a name="p77287894093522"></a><a name="p77287894093522"></a><a href="surface.md#ga479eea3722e4d8448ead051c2f11cec5">OHOS::SurfaceBuffer::SetInt64</a> (uint32_t key, int64_t value)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p231412705093522"><a name="p231412705093522"></a><a name="p231412705093522"></a>virtual int32_t </p>
<p id="p1478847373093522"><a name="p1478847373093522"></a><a name="p1478847373093522"></a>Sets an extra attribute value of the int64 type. </p>
</td>
</tr>
<tr id="row331065389093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1639881366093522"><a name="p1639881366093522"></a><a name="p1639881366093522"></a><a href="surface.md#ga3a442c71aee865c7b7a9bb6505ce800a">OHOS::SurfaceBuffer::GetInt64</a> (uint32_t key, int64_t &amp;value)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p725388409093522"><a name="p725388409093522"></a><a name="p725388409093522"></a>virtual int32_t </p>
<p id="p1696775664093522"><a name="p1696775664093522"></a><a name="p1696775664093522"></a>Obtains an extra attribute value of the int64 type. </p>
</td>
</tr>
</tbody>
</table>

## **Details**<a name="section294421894093522"></a>

## **Enumeration Type Documentation**<a name="section239974349093522"></a>

## BufferConsumerUsage<a name="ga16d4d4f73d748455e45924ffbdd1e891"></a>

```
enum [OHOS::BufferConsumerUsage](surface.md#ga16d4d4f73d748455e45924ffbdd1e891)
```

 **Description:**

Enumerates shared memory usage scenarios, including physically contiguous memory and virtual memory. 

<a name="table391834321093522"></a>
<table><thead align="left"><tr id="row1954360736093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2070855943093522"><a name="p2070855943093522"></a><a name="p2070855943093522"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1197833794093522"><a name="p1197833794093522"></a><a name="p1197833794093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1050824716093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga16d4d4f73d748455e45924ffbdd1e891a59c0ac95bd7994b6eda43b34f59c237b"><a name="gga16d4d4f73d748455e45924ffbdd1e891a59c0ac95bd7994b6eda43b34f59c237b"></a><a name="gga16d4d4f73d748455e45924ffbdd1e891a59c0ac95bd7994b6eda43b34f59c237b"></a></strong>BUFFER_CONSUMER_USAGE_SORTWARE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p346125354093522"><a name="p346125354093522"></a><a name="p346125354093522"></a>Virtual memory </p>
 </td>
</tr>
<tr id="row599945098093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga16d4d4f73d748455e45924ffbdd1e891abe0bc63ca1799ca0b2182e908780da7b"><a name="gga16d4d4f73d748455e45924ffbdd1e891abe0bc63ca1799ca0b2182e908780da7b"></a><a name="gga16d4d4f73d748455e45924ffbdd1e891abe0bc63ca1799ca0b2182e908780da7b"></a></strong>BUFFER_CONSUMER_USAGE_HARDWARE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p178958550093522"><a name="p178958550093522"></a><a name="p178958550093522"></a>Physically contiguous memory. The cache is not used. </p>
 </td>
</tr>
<tr id="row1985929625093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga16d4d4f73d748455e45924ffbdd1e891a93eebf8af6f264494a57771865c90b08"><a name="gga16d4d4f73d748455e45924ffbdd1e891a93eebf8af6f264494a57771865c90b08"></a><a name="gga16d4d4f73d748455e45924ffbdd1e891a93eebf8af6f264494a57771865c90b08"></a></strong>BUFFER_CONSUMER_USAGE_HARDWARE_CONSUMER_CACHE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1138913875093522"><a name="p1138913875093522"></a><a name="p1138913875093522"></a>Physically contiguous memory. Consumers use the cache. </p>
 </td>
</tr>
<tr id="row435389110093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga16d4d4f73d748455e45924ffbdd1e891a7a31f6403b7aa4ba989e7cd5b3eb7a06"><a name="gga16d4d4f73d748455e45924ffbdd1e891a7a31f6403b7aa4ba989e7cd5b3eb7a06"></a><a name="gga16d4d4f73d748455e45924ffbdd1e891a7a31f6403b7aa4ba989e7cd5b3eb7a06"></a></strong>BUFFER_CONSUMER_USAGE_HARDWARE_PRODUCER_CACHE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p804717536093522"><a name="p804717536093522"></a><a name="p804717536093522"></a>Physically contiguous memory. Producers use the cache. </p>
 </td>
</tr>
<tr id="row678590830093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga16d4d4f73d748455e45924ffbdd1e891a56aa1994f77d06504c40421f6555f1cf"><a name="gga16d4d4f73d748455e45924ffbdd1e891a56aa1994f77d06504c40421f6555f1cf"></a><a name="gga16d4d4f73d748455e45924ffbdd1e891a56aa1994f77d06504c40421f6555f1cf"></a></strong>BUFFER_CONSUMER_USAGE_MAX </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p456967245093522"><a name="p456967245093522"></a><a name="p456967245093522"></a>Valid maximum value, used to determine whether the current shared memory usage scenario is within a proper range. </p>
 </td>
</tr>
</tbody>
</table>

## ImagePixelFormat<a name="gaa191d6e3b92a0f527744d43e056ae025"></a>

```
enum [OHOS::ImagePixelFormat](surface.md#gaa191d6e3b92a0f527744d43e056ae025)
```

 **Description:**

Enumerates a pixel format. 

<a name="table1745399625093522"></a>
<table><thead align="left"><tr id="row1774443806093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1967209365093522"><a name="p1967209365093522"></a><a name="p1967209365093522"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1739829629093522"><a name="p1739829629093522"></a><a name="p1739829629093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row216541131093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025a9690a1d8cf1d21fcad76876f122a12ab"><a name="ggaa191d6e3b92a0f527744d43e056ae025a9690a1d8cf1d21fcad76876f122a12ab"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025a9690a1d8cf1d21fcad76876f122a12ab"></a></strong>IMAGE_PIXEL_FORMAT_NONE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p530997455093522"><a name="p530997455093522"></a><a name="p530997455093522"></a>Invalid pixel format </p>
 </td>
</tr>
<tr id="row632361893093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025aff11848c6a38afb3afdcbeaec2400055"><a name="ggaa191d6e3b92a0f527744d43e056ae025aff11848c6a38afb3afdcbeaec2400055"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025aff11848c6a38afb3afdcbeaec2400055"></a></strong>IMAGE_PIXEL_FORMAT_RGB565 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p408108500093522"><a name="p408108500093522"></a><a name="p408108500093522"></a>RGB565 pixel format </p>
 </td>
</tr>
<tr id="row701960207093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025a9cf3bfb5153d8cf23f4c0d3bb9cc4f43"><a name="ggaa191d6e3b92a0f527744d43e056ae025a9cf3bfb5153d8cf23f4c0d3bb9cc4f43"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025a9cf3bfb5153d8cf23f4c0d3bb9cc4f43"></a></strong>IMAGE_PIXEL_FORMAT_ARGB1555 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p586337403093522"><a name="p586337403093522"></a><a name="p586337403093522"></a>ARGB555 pixel format </p>
 </td>
</tr>
<tr id="row475110400093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025ad4774f5ba15cf25a3d0951f5986ab0d5"><a name="ggaa191d6e3b92a0f527744d43e056ae025ad4774f5ba15cf25a3d0951f5986ab0d5"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025ad4774f5ba15cf25a3d0951f5986ab0d5"></a></strong>IMAGE_PIXEL_FORMAT_RGB888 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p416190313093522"><a name="p416190313093522"></a><a name="p416190313093522"></a>RGB888 pixel format </p>
 </td>
</tr>
<tr id="row757807403093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025a1a18541878a09cbca269918a7ef4796f"><a name="ggaa191d6e3b92a0f527744d43e056ae025a1a18541878a09cbca269918a7ef4796f"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025a1a18541878a09cbca269918a7ef4796f"></a></strong>IMAGE_PIXEL_FORMAT_ARGB8888 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p32158943093522"><a name="p32158943093522"></a><a name="p32158943093522"></a>ARGB8888 pixel format </p>
 </td>
</tr>
<tr id="row972428251093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025affcb2a4b4832e3c33789f9e8efffe7b0"><a name="ggaa191d6e3b92a0f527744d43e056ae025affcb2a4b4832e3c33789f9e8efffe7b0"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025affcb2a4b4832e3c33789f9e8efffe7b0"></a></strong>IMAGE_PIXEL_FORMAT_YUYV </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1768356108093522"><a name="p1768356108093522"></a><a name="p1768356108093522"></a>YUYV pixel format </p>
 </td>
</tr>
<tr id="row1992087266093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025a4ec5bc985a5f49f26178ab18c074cfa6"><a name="ggaa191d6e3b92a0f527744d43e056ae025a4ec5bc985a5f49f26178ab18c074cfa6"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025a4ec5bc985a5f49f26178ab18c074cfa6"></a></strong>IMAGE_PIXEL_FORMAT_YVYU </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p271207672093522"><a name="p271207672093522"></a><a name="p271207672093522"></a>YVYU pixel format </p>
 </td>
</tr>
<tr id="row1443576476093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025a098b93504ac8e11c4d5d488930187f37"><a name="ggaa191d6e3b92a0f527744d43e056ae025a098b93504ac8e11c4d5d488930187f37"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025a098b93504ac8e11c4d5d488930187f37"></a></strong>IMAGE_PIXEL_FORMAT_UYVY </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p246730627093522"><a name="p246730627093522"></a><a name="p246730627093522"></a>UYVY pixel format </p>
 </td>
</tr>
<tr id="row822937360093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025a0e242cad6dae11690013c6771b80fc9b"><a name="ggaa191d6e3b92a0f527744d43e056ae025a0e242cad6dae11690013c6771b80fc9b"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025a0e242cad6dae11690013c6771b80fc9b"></a></strong>IMAGE_PIXEL_FORMAT_VYUY </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1172783294093522"><a name="p1172783294093522"></a><a name="p1172783294093522"></a>VYUY pixel format </p>
 </td>
</tr>
<tr id="row1495948877093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025ab690ca190de1686041f0d0c320427b1c"><a name="ggaa191d6e3b92a0f527744d43e056ae025ab690ca190de1686041f0d0c320427b1c"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025ab690ca190de1686041f0d0c320427b1c"></a></strong>IMAGE_PIXEL_FORMAT_AYUV </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1424510681093522"><a name="p1424510681093522"></a><a name="p1424510681093522"></a>AYUV pixel format </p>
 </td>
</tr>
<tr id="row126816652093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025aa4e3c6974a86c29cf707f371ad1b0b49"><a name="ggaa191d6e3b92a0f527744d43e056ae025aa4e3c6974a86c29cf707f371ad1b0b49"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025aa4e3c6974a86c29cf707f371ad1b0b49"></a></strong>IMAGE_PIXEL_FORMAT_YUV410 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1873620770093522"><a name="p1873620770093522"></a><a name="p1873620770093522"></a>YUV410 pixel format </p>
 </td>
</tr>
<tr id="row826880473093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025a3c4c9612392a81fa2d1d305d08064146"><a name="ggaa191d6e3b92a0f527744d43e056ae025a3c4c9612392a81fa2d1d305d08064146"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025a3c4c9612392a81fa2d1d305d08064146"></a></strong>IMAGE_PIXEL_FORMAT_YVU410 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p296116606093522"><a name="p296116606093522"></a><a name="p296116606093522"></a>YVU410 pixel format </p>
 </td>
</tr>
<tr id="row674710350093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025acc77b028562f155f1099de249b7bffae"><a name="ggaa191d6e3b92a0f527744d43e056ae025acc77b028562f155f1099de249b7bffae"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025acc77b028562f155f1099de249b7bffae"></a></strong>IMAGE_PIXEL_FORMAT_YUV411 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1931512995093522"><a name="p1931512995093522"></a><a name="p1931512995093522"></a>YUV411 pixel format </p>
 </td>
</tr>
<tr id="row1279181849093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025a99cb00970d669d9ba2ac1049d19c60e4"><a name="ggaa191d6e3b92a0f527744d43e056ae025a99cb00970d669d9ba2ac1049d19c60e4"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025a99cb00970d669d9ba2ac1049d19c60e4"></a></strong>IMAGE_PIXEL_FORMAT_YVU411 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p588119412093522"><a name="p588119412093522"></a><a name="p588119412093522"></a>YVU411 pixel format </p>
 </td>
</tr>
<tr id="row267685813093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025acf60892315d8aee3d421f75d70db796f"><a name="ggaa191d6e3b92a0f527744d43e056ae025acf60892315d8aee3d421f75d70db796f"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025acf60892315d8aee3d421f75d70db796f"></a></strong>IMAGE_PIXEL_FORMAT_YUV420 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p198486022093522"><a name="p198486022093522"></a><a name="p198486022093522"></a>YUV420 pixel format </p>
 </td>
</tr>
<tr id="row959370604093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025ac3dfd6c2f350194d2a525a14d9e72b71"><a name="ggaa191d6e3b92a0f527744d43e056ae025ac3dfd6c2f350194d2a525a14d9e72b71"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025ac3dfd6c2f350194d2a525a14d9e72b71"></a></strong>IMAGE_PIXEL_FORMAT_YVU420 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2006583671093522"><a name="p2006583671093522"></a><a name="p2006583671093522"></a>YVU420 pixel format </p>
 </td>
</tr>
<tr id="row1785477284093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025ae87be6ce296c907d99381d1db48c288f"><a name="ggaa191d6e3b92a0f527744d43e056ae025ae87be6ce296c907d99381d1db48c288f"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025ae87be6ce296c907d99381d1db48c288f"></a></strong>IMAGE_PIXEL_FORMAT_YUV422 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1288059798093522"><a name="p1288059798093522"></a><a name="p1288059798093522"></a>YUV422 pixel format </p>
 </td>
</tr>
<tr id="row1899886850093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025ab33d1df10479e267ca7c3cb6102d8dbb"><a name="ggaa191d6e3b92a0f527744d43e056ae025ab33d1df10479e267ca7c3cb6102d8dbb"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025ab33d1df10479e267ca7c3cb6102d8dbb"></a></strong>IMAGE_PIXEL_FORMAT_YVU422 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p633702189093522"><a name="p633702189093522"></a><a name="p633702189093522"></a>YVU422 pixel format </p>
 </td>
</tr>
<tr id="row1618610702093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025a7f2a90344e786071a49db0da82b201e4"><a name="ggaa191d6e3b92a0f527744d43e056ae025a7f2a90344e786071a49db0da82b201e4"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025a7f2a90344e786071a49db0da82b201e4"></a></strong>IMAGE_PIXEL_FORMAT_YUV444 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1548537193093522"><a name="p1548537193093522"></a><a name="p1548537193093522"></a>YUV444 pixel format </p>
 </td>
</tr>
<tr id="row727472218093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025a4e18880bae5fa08cbd510f23f549087d"><a name="ggaa191d6e3b92a0f527744d43e056ae025a4e18880bae5fa08cbd510f23f549087d"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025a4e18880bae5fa08cbd510f23f549087d"></a></strong>IMAGE_PIXEL_FORMAT_YVU444 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p704315175093522"><a name="p704315175093522"></a><a name="p704315175093522"></a>YVU444 pixel format </p>
 </td>
</tr>
<tr id="row1753140297093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025a93a54b97b83f6e042c993d045be27a33"><a name="ggaa191d6e3b92a0f527744d43e056ae025a93a54b97b83f6e042c993d045be27a33"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025a93a54b97b83f6e042c993d045be27a33"></a></strong>IMAGE_PIXEL_FORMAT_NV12 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1001533320093522"><a name="p1001533320093522"></a><a name="p1001533320093522"></a>NV12 pixel format </p>
 </td>
</tr>
<tr id="row784963122093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025ab7d0f6b75189a47fdf613bbbeaa3b628"><a name="ggaa191d6e3b92a0f527744d43e056ae025ab7d0f6b75189a47fdf613bbbeaa3b628"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025ab7d0f6b75189a47fdf613bbbeaa3b628"></a></strong>IMAGE_PIXEL_FORMAT_NV21 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p906259118093522"><a name="p906259118093522"></a><a name="p906259118093522"></a>NV21 pixel format </p>
 </td>
</tr>
<tr id="row557585883093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025a5fd084cc32d1fdbe8017fd210a7e3ffa"><a name="ggaa191d6e3b92a0f527744d43e056ae025a5fd084cc32d1fdbe8017fd210a7e3ffa"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025a5fd084cc32d1fdbe8017fd210a7e3ffa"></a></strong>IMAGE_PIXEL_FORMAT_NV16 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p748605835093522"><a name="p748605835093522"></a><a name="p748605835093522"></a>NV16 pixel format </p>
 </td>
</tr>
<tr id="row546528190093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa191d6e3b92a0f527744d43e056ae025a77a0063a555db3ca68a304e494f094cf"><a name="ggaa191d6e3b92a0f527744d43e056ae025a77a0063a555db3ca68a304e494f094cf"></a><a name="ggaa191d6e3b92a0f527744d43e056ae025a77a0063a555db3ca68a304e494f094cf"></a></strong>IMAGE_PIXEL_FORMAT_NV61 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1405772801093522"><a name="p1405772801093522"></a><a name="p1405772801093522"></a>NV61 pixel format </p>
 </td>
</tr>
</tbody>
</table>

## **Function Documentation**<a name="section319698048093522"></a>

## AcquireBuffer\(\)<a name="ga7acd9899b1ca4eb02ed13d54c2aca0af"></a>

```
virtual [SurfaceBuffer](ohos-surfacebuffer.md)* OHOS::Surface::AcquireBuffer ()
```

 **Description:**

Obtains a buffer. 

Consumers can use this function to obtain the buffer placed in the dirty queue by producers. If there is no buffer in the queue,  **nullptr**  is returned.

**Returns:**

Returns the pointer to the  [SurfaceBuffer](ohos-surfacebuffer.md)  object. 



## CancelBuffer\(\)<a name="ga6bae4ebcdc4e300eb5a076054f3379e4"></a>

```
virtual void OHOS::Surface::CancelBuffer ([SurfaceBuffer](ohos-surfacebuffer.md) * buffer)
```

 **Description:**

Releases a buffer to the free queue. 

**Parameters:**

<a name="table1974430855093522"></a>
<table><thead align="left"><tr id="row428479733093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p364918596093522"><a name="p364918596093522"></a><a name="p364918596093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1852700230093522"><a name="p1852700230093522"></a><a name="p1852700230093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row393232421093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><a href="ohos-surfacebuffer.md">SurfaceBuffer</a></td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the buffer to be released by producers. </td>
</tr>
</tbody>
</table>

## CreateSurface\(\)<a name="ga49d6a759bec670ea5a47bee4eb252ae3"></a>

```
static [Surface](ohos-surface.md)* OHOS::Surface::CreateSurface ()
```

 **Description:**

A constructor used to create a  [Surface](surface.md)  object for consumers to use. 

In multi-process scenarios, this function is provided for consumers to obtain buffers generated by producers for consumption. In single-process scenarios, this function can be used by both consumers and producers. 

## FlushBuffer\(\)<a name="ga8af29f3c031c1b3effe8de7366579329"></a>

```
virtual int32_t OHOS::Surface::FlushBuffer ([SurfaceBuffer](ohos-surfacebuffer.md) * buffer)
```

 **Description:**

Flushes a buffer to the dirty queue for consumers to use. 

**Parameters:**

<a name="table630009552093522"></a>
<table><thead align="left"><tr id="row525219332093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p347922815093522"><a name="p347922815093522"></a><a name="p347922815093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1695809104093522"><a name="p1695809104093522"></a><a name="p1695809104093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2142795346093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><a href="ohos-surfacebuffer.md">SurfaceBuffer</a></td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the buffer flushed by producers. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  otherwise. 



## GetFormat\(\)<a name="ga461caa118503a471c78ea09a8403a6ec"></a>

```
virtual uint32_t OHOS::Surface::GetFormat ()
```

 **Description:**

Obtains the pixel format of the surface. For details, see  **ImageFormat**. The default pixel format is  **IMAGE\_PIXEL\_FORMAT\_RGB565**. 

**Returns:**

Returns the pixel format. 



## GetHeight\(\)<a name="ga0e6be0887bd69cf749c0d994bd826699"></a>

```
virtual uint32_t OHOS::Surface::GetHeight ()
```

 **Description:**

Obtains the height of the surface. 

**Returns:**

Returns the surface height, in pixels. 



## GetInt32\(\)<a name="ga54a916606158a8799fe421eb3842848e"></a>

```
virtual int32_t OHOS::SurfaceBuffer::GetInt32 (uint32_t key, int32_t & value )
```

 **Description:**

Obtains an extra attribute value of the int32 type. 

Obtains an extra attribute value of the int32 type, The extra attribute is stored in the format of <key, value\>. Each key corresponds to a value. If the key does not exist or the value is not int32,  **-1**  is returned.

**Parameters:**

<a name="table941517043093522"></a>
<table><thead align="left"><tr id="row417571214093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p815568340093522"><a name="p815568340093522"></a><a name="p815568340093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1355492295093522"><a name="p1355492295093522"></a><a name="p1355492295093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1346946195093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the key of a key-value pair for which the value is to be obtained. </td>
</tr>
<tr id="row130478357093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">value</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the value of the key-value pair obtained. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  otherwise. 



## GetInt64\(\)<a name="ga3a442c71aee865c7b7a9bb6505ce800a"></a>

```
virtual int32_t OHOS::SurfaceBuffer::GetInt64 (uint32_t key, int64_t & value )
```

 **Description:**

Obtains an extra attribute value of the int64 type. 

Obtains an extra attribute value of the int64 type, The extra attribute is stored in the format of <key, value\>. Each key corresponds to a value. If the key does not exist or the value is not int64,  **-1**  is returned.

**Parameters:**

<a name="table1927502820093522"></a>
<table><thead align="left"><tr id="row1416779926093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1545183283093522"><a name="p1545183283093522"></a><a name="p1545183283093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p302390368093522"><a name="p302390368093522"></a><a name="p302390368093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1205189071093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the key of a key-value pair for which the value is to be obtained. </td>
</tr>
<tr id="row807217888093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">value</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the value of the key-value pair obtained. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  otherwise. 



## GetPhyAddr\(\)<a name="ga5d797958fed83fdea15b3f6ad5ddf97e"></a>

```
virtual uint64_t OHOS::SurfaceBuffer::GetPhyAddr () const
```

 **Description:**

Obtains the physical address of shared memory. 

**Returns:**

Returns the physical address of shared memory. 



## GetQueueSize\(\)<a name="gaff365f4d3178798ff28f0aaab9f467de"></a>

```
virtual uint8_t OHOS::Surface::GetQueueSize ()
```

 **Description:**

Obtains the number of surface buffers that can be allocated to the surface. The default value is  **1**. The value range is \[1, 10\]. 

**Returns:**

Returns the number of buffers. 



## GetSize\(\) \[1/2\]<a name="gaad9d0ca349b3f398b31c38ac9a650138"></a>

```
virtual uint32_t OHOS::SurfaceBuffer::GetSize () const
```

 **Description:**

Obtains the size of shared memory. 

**Returns:**

Returns the size of shared memory. 



## GetSize\(\) \[2/2\]<a name="ga88e74ff7dc0ae3beb23df3ed00a81fc9"></a>

```
virtual uint32_t OHOS::Surface::GetSize ()
```

 **Description:**

Obtains the size of the shared memory to allocate. 

**Returns:**

Returns the size of the shared memory. 



## GetStride\(\)<a name="ga5aabbb48f86992494c88ee2a7d00aa09"></a>

```
virtual uint32_t OHOS::Surface::GetStride ()
```

 **Description:**

Obtains the stride of the surface. 

**Returns:**

Returns the stride. 



## GetStrideAlignment\(\)<a name="ga0d5317e6a008b8fd0ee98ebd516a0e7c"></a>

```
virtual uint32_t OHOS::Surface::GetStrideAlignment ()
```

 **Description:**

Obtains the number of bytes for stride alignment. By default, 4-byte aligned is used. 

**Returns:**

Returns the number of bytes for stride alignment. 



## GetUsage\(\)<a name="ga6a043b41406f282339bb68c1fc4793f9"></a>

```
virtual uint32_t OHOS::Surface::GetUsage ()
```

 **Description:**

Obtains the usage scenario of the buffer. Physically contiguous memory and virtual memory are supported. 

**Returns:**

Returns the usage scenario of the buffer. For details, see  **BUFFER\_CONSUMER\_USAGE**. 



## GetUserData\(\)<a name="gadd1c8826fd3191cd5f6a52594c5ef3ba"></a>

```
virtual std::string OHOS::Surface::GetUserData (const std::string & key)
```

 **Description:**

Obtains surface user data. 

**Parameters:**

<a name="table1637032558093522"></a>
<table><thead align="left"><tr id="row1495388560093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1888017654093522"><a name="p1888017654093522"></a><a name="p1888017654093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1397953285093522"><a name="p1397953285093522"></a><a name="p1397953285093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1698051109093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the key of a key-value pair for which the value is to be obtained. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the value of the key-value pair obtained. 



## GetVirAddr\(\)<a name="ga623d6c8ced742a36017bb71f6441b2a7"></a>

```
virtual void* OHOS::SurfaceBuffer::GetVirAddr () const
```

 **Description:**

Obtains the virtual address of shared memory for producers and consumers. 

**Returns:**

Returns the virtual address of shared memory. 



## GetWidth\(\)<a name="ga1220bd15e73d891105d310cf37422b56"></a>

```
virtual uint32_t OHOS::Surface::GetWidth ()
```

 **Description:**

Obtains the width of the surface. 

**Returns:**

Returns the surface width, in pixels. 



## OnBufferAvailable\(\)<a name="ga9a99aa36b37197b2ca409b8f4e7335c7"></a>

```
virtual void OHOS::IBufferConsumerListener::OnBufferAvailable ()
```

 **Description:**

Called to notify a consumer that a buffer is available for consumption. 

## RegisterConsumerListener\(\)<a name="ga4b997a5b9493ad6d2015f86766f12b02"></a>

```
virtual void OHOS::Surface::RegisterConsumerListener ([IBufferConsumerListener](ohos-ibufferconsumerlistener.md) & listener)
```

 **Description:**

Registers a consumer listener. 

When a buffer is placed in the dirty queue,  **OnBufferAvailable**  is called to notify consumers. If the listener is repeatedly registered, only the latest one is retained.

**Parameters:**

<a name="table1120812274093522"></a>
<table><thead align="left"><tr id="row1858543718093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p565351977093522"><a name="p565351977093522"></a><a name="p565351977093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1298120082093522"><a name="p1298120082093522"></a><a name="p1298120082093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row825584713093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><a href="ohos-ibufferconsumerlistener.md">IBufferConsumerListener</a></td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the listener to register. </td>
</tr>
</tbody>
</table>

## ReleaseBuffer\(\)<a name="ga4150c81248f516882ef120731d9abb66"></a>

```
virtual bool OHOS::Surface::ReleaseBuffer ([SurfaceBuffer](ohos-surfacebuffer.md) * buffer)
```

 **Description:**

Releases the consumed buffer. 

After a consumer has used a  [SurfaceBuffer](ohos-surfacebuffer.md)  object, the consumer can release it through  [ReleaseBuffer](surface.md#ga4150c81248f516882ef120731d9abb66). The released object is placed into the free queue so that producers can apply for the object.

**Parameters:**

<a name="table963120065093522"></a>
<table><thead align="left"><tr id="row1921437500093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1052500455093522"><a name="p1052500455093522"></a><a name="p1052500455093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1118091098093522"><a name="p1118091098093522"></a><a name="p1118091098093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row958882598093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><a href="ohos-surfacebuffer.md">SurfaceBuffer</a></td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the buffer released. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the buffer is released; returns  **false**  otherwise. 



## RequestBuffer\(\)<a name="gacc46ffcd4258b2660dc6cde05854c4ac"></a>

```
virtual [SurfaceBuffer](ohos-surfacebuffer.md)* OHOS::Surface::RequestBuffer (uint8_t wait = [/topic/body/section/screen/code
     {""}) 0 (code])
```

 **Description:**

Obtains a buffer to write data. 

**Parameters:**

<a name="table1723658614093522"></a>
<table><thead align="left"><tr id="row1425411524093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1928751659093522"><a name="p1928751659093522"></a><a name="p1928751659093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1147381337093522"><a name="p1147381337093522"></a><a name="p1147381337093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row76953583093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wait</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Specifies whether the function waits for an available buffer. If <strong id="b1522792734093522"><a name="b1522792734093522"></a><a name="b1522792734093522"></a>wait</strong> is <strong id="b833706038093522"><a name="b833706038093522"></a><a name="b833706038093522"></a>1</strong>, the function waits until there is an available buffer in the free queue before returning a pointer. If the <strong id="b1195419497093522"><a name="b1195419497093522"></a><a name="b1195419497093522"></a>wait</strong> is <strong id="b1765228605093522"><a name="b1765228605093522"></a><a name="b1765228605093522"></a>0</strong>, the function does not wait and returns <strong id="b775490361093522"><a name="b775490361093522"></a><a name="b775490361093522"></a>nullptr</strong> if there is no buffer in the free queue. The default value is <strong id="b2064753610093522"><a name="b2064753610093522"></a><a name="b2064753610093522"></a>0</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the buffer if the operation is successful; returns  **nullptr**  otherwise. 



## SetFormat\(\)<a name="ga8e44c9100296571a9294dc9851ef48dc"></a>

```
virtual void OHOS::Surface::SetFormat (uint32_t format)
```

 **Description:**

Sets the pixel format of the surface. For details, see  **ImageFormat**. The default pixel format is  **IMAGE\_PIXEL\_FORMAT\_RGB565**. 

**Parameters:**

<a name="table1983035916093522"></a>
<table><thead align="left"><tr id="row696300499093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1430989887093522"><a name="p1430989887093522"></a><a name="p1430989887093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1018238003093522"><a name="p1018238003093522"></a><a name="p1018238003093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row224947726093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pixel format to be set. </td>
</tr>
</tbody>
</table>

## SetInt32\(\)<a name="gaf4b467cb2d7015d00f4bcf77c5b19875"></a>

```
virtual int32_t OHOS::SurfaceBuffer::SetInt32 (uint32_t key, int32_t value )
```

 **Description:**

Sets an extra attribute value of the int32 type. 

Sets an extra attribute value of the int32 type, The extra attribute is stored in the format of <key, value\>. Each key corresponds to a value. If the same keys are used in two calls, the value in the second call overwrites that in the first call. 

**Parameters:**

<a name="table623976349093522"></a>
<table><thead align="left"><tr id="row308273715093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1048005965093522"><a name="p1048005965093522"></a><a name="p1048005965093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p254477601093522"><a name="p254477601093522"></a><a name="p254477601093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2144087666093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the key of a key-value pair to set. </td>
</tr>
<tr id="row1527686003093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">value</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the value of the key-value pair to set. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  otherwise. 



## SetInt64\(\)<a name="ga479eea3722e4d8448ead051c2f11cec5"></a>

```
virtual int32_t OHOS::SurfaceBuffer::SetInt64 (uint32_t key, int64_t value )
```

 **Description:**

Sets an extra attribute value of the int64 type. 

Sets an extra attribute value of the int64 type. The storage mode of the extra attribute is <key, value\>. the value in the second call overwrites that in the first call.

**Parameters:**

<a name="table228996750093522"></a>
<table><thead align="left"><tr id="row1821982467093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p431643286093522"><a name="p431643286093522"></a><a name="p431643286093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1249340594093522"><a name="p1249340594093522"></a><a name="p1249340594093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row100745709093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the key of a key-value pair to set. </td>
</tr>
<tr id="row1396934070093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">value</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the value of the key-value pair to set. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  otherwise. 



## SetQueueSize\(\)<a name="ga44138c9aa20a108358da26893b92150c"></a>

```
virtual void OHOS::Surface::SetQueueSize (uint8_t queueSize)
```

 **Description:**

Sets the number of buffers that can be allocated to the surface. The default value is  **1**. The value range is \[1, 10\]. 

**Parameters:**

<a name="table1799267779093522"></a>
<table><thead align="left"><tr id="row237738390093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1391823093093522"><a name="p1391823093093522"></a><a name="p1391823093093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p279519691093522"><a name="p279519691093522"></a><a name="p279519691093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row314026052093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">queueSize</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of buffers to set. </td>
</tr>
</tbody>
</table>

## SetSize\(\) \[1/2\]<a name="ga818ee9015ff03d536b9a73d52f36b4f2"></a>

```
virtual void OHOS::SurfaceBuffer::SetSize (uint32_t size)
```

 **Description:**

Sets the size of shared memory. 

**Parameters:**

<a name="table1866521197093522"></a>
<table><thead align="left"><tr id="row1964401960093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1761464265093522"><a name="p1761464265093522"></a><a name="p1761464265093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1492540553093522"><a name="p1492540553093522"></a><a name="p1492540553093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1356906098093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of shared memory to set. </td>
</tr>
</tbody>
</table>

## SetSize\(\) \[2/2\]<a name="ga3b2391ee37e762fa0fb093585c084714"></a>

```
virtual void OHOS::Surface::SetSize (uint32_t size)
```

 **Description:**

Sets the size of the shared memory to allocate. 

**Parameters:**

<a name="table834865759093522"></a>
<table><thead align="left"><tr id="row1927993416093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p278520826093522"><a name="p278520826093522"></a><a name="p278520826093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p868684216093522"><a name="p868684216093522"></a><a name="p868684216093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row767884298093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the shared memory. The value range is (0,58982400]. </td>
</tr>
</tbody>
</table>

## SetStrideAlignment\(\)<a name="ga5b27f54101d9d3371038b73373c36530"></a>

```
virtual void OHOS::Surface::SetStrideAlignment (uint32_t strideAlignment)
```

 **Description:**

Sets the number of bytes for stride alignment. 

By default, 4-byte aligned is used. The value range is \[4,32\].

**Parameters:**

<a name="table1891685146093522"></a>
<table><thead align="left"><tr id="row107509189093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1431596508093522"><a name="p1431596508093522"></a><a name="p1431596508093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p370289831093522"><a name="p370289831093522"></a><a name="p370289831093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row967049534093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">strideAlignment</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of bytes for stride alignment. </td>
</tr>
</tbody>
</table>

## SetUsage\(\)<a name="ga01df6145a5fda3ba72c50258634720b8"></a>

```
virtual void OHOS::Surface::SetUsage (uint32_t usage)
```

 **Description:**

Sets the usage scenario of the buffer. Physically contiguous memory and virtual memory \(by default\) are supported. By default, virtual memory is allocated. 

**Parameters:**

<a name="table79394086093522"></a>
<table><thead align="left"><tr id="row1225467442093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p528656405093522"><a name="p528656405093522"></a><a name="p528656405093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p663759617093522"><a name="p663759617093522"></a><a name="p663759617093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1767270424093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">usage</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the usage scenario of the buffer. For details, see <strong id="b1032580534093522"><a name="b1032580534093522"></a><a name="b1032580534093522"></a>BUFFER_CONSUMER_USAGE</strong>. </td>
</tr>
</tbody>
</table>

## SetUserData\(\)<a name="gae264fef4c98719a7c34bc85442cd1a5b"></a>

```
virtual void OHOS::Surface::SetUserData (const std::string & key, const std::string & value )
```

 **Description:**

Sets surface user data, which is stored in the format of <key, value\>. 

**Parameters:**

<a name="table721365161093522"></a>
<table><thead align="left"><tr id="row775540920093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p432850629093522"><a name="p432850629093522"></a><a name="p432850629093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p331886343093522"><a name="p331886343093522"></a><a name="p331886343093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1763214403093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">key</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the key of a key-value pair to store. </td>
</tr>
<tr id="row1119314720093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">value</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the value of the key-value pair to store. </td>
</tr>
</tbody>
</table>

## SetWidthAndHeight\(\)<a name="ga260c12281c283e5a0b63a49f24bd0cc0"></a>

```
virtual void OHOS::Surface::SetWidthAndHeight (uint32_t width, uint32_t height )
```

 **Description:**

Sets the width and height of the surface for calculating its stride and size. The default value range of width and height is \(0,7680\]. 

**Parameters:**

<a name="table1815743303093522"></a>
<table><thead align="left"><tr id="row1701349937093522"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1155991930093522"><a name="p1155991930093522"></a><a name="p1155991930093522"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1504613562093522"><a name="p1504613562093522"></a><a name="p1504613562093522"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1171147660093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">width</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the surface width, in pixels. </td>
</tr>
<tr id="row1643539050093522"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">height</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the surface height, in pixels. </td>
</tr>
</tbody>
</table>

## UnregisterConsumerListener\(\)<a name="ga0f303409d32d8d2b467888bf8fdc3223"></a>

```
virtual void OHOS::Surface::UnregisterConsumerListener ()
```

 **Description:**

Unregisters the consumer listener. 

After the listener is unregistered, no callback is triggered when a buffer is placed in the dirty queue.

## \~Surface\(\)<a name="ga1d35e9b436057032ec4598f24e31dbfb"></a>

```
virtual OHOS::Surface::~Surface ()
```

 **Description:**

A destructor used to delete the  **[Surface](ohos-surface.md)**  instance. 

This function releases the surface and all buffers applied for the surface.

