# MultiMedia\_FrameConfig<a name="EN-US_TOPIC_0000001055358062"></a>

## **Overview**<a name="section64154854093523"></a>

Defines the  **FrameConfig**  class for operations related to frame configurations. 

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section108627515093523"></a>

## Files<a name="files"></a>

<a name="table648881924093523"></a>
<table><thead align="left"><tr id="row1021002906093523"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1308736680093523"><a name="p1308736680093523"></a><a name="p1308736680093523"></a>File Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1356937870093523"><a name="p1356937870093523"></a><a name="p1356937870093523"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1043430902093523"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1174376897093523"><a name="p1174376897093523"></a><a name="p1174376897093523"></a><a href="frame_config-h.md">frame_config.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1379440633093523"><a name="p1379440633093523"></a><a name="p1379440633093523"></a>Declares APIs of the <strong id="b1064737119093523"><a name="b1064737119093523"></a><a name="b1064737119093523"></a>FrameConfig</strong> class. </p>
</td>
</tr>
</tbody>
</table>

## Data Structures<a name="nested-classes"></a>

<a name="table554374737093523"></a>
<table><thead align="left"><tr id="row598206591093523"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2037647199093523"><a name="p2037647199093523"></a><a name="p2037647199093523"></a>Data Structure Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p205067662093523"><a name="p205067662093523"></a><a name="p205067662093523"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row236179082093523"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1784793263093523"><a name="p1784793263093523"></a><a name="p1784793263093523"></a><a href="ohos-media-frameconfig.md">OHOS::Media::FrameConfig</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p181207320093523"><a name="p181207320093523"></a><a name="p181207320093523"></a>Provides functions to configure frames. </p>
</td>
</tr>
</tbody>
</table>

## Functions<a name="func-members"></a>

<a name="table724166384093523"></a>
<table><thead align="left"><tr id="row2062310529093523"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1271008636093523"><a name="p1271008636093523"></a><a name="p1271008636093523"></a>Function Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2125919020093523"><a name="p2125919020093523"></a><a name="p2125919020093523"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1068503985093523"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1985073593093523"><a name="p1985073593093523"></a><a name="p1985073593093523"></a><em id="ga043537d52f5db46d981f9e89848b0fba"><a name="ga043537d52f5db46d981f9e89848b0fba"></a><a name="ga043537d52f5db46d981f9e89848b0fba"></a></em>OHOS::Media::FrameConfig::FrameConfig ()=delete</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2064233726093523"><a name="p2064233726093523"></a><a name="p2064233726093523"></a><strong id="b1508074933"><a name="b1508074933"></a><a name="b1508074933"></a></strong>  </p>
<p id="p968096835093523"><a name="p968096835093523"></a><a name="p968096835093523"></a>A constructor used to create a <strong id="b802164531093523"><a name="b802164531093523"></a><a name="b802164531093523"></a><a href="ohos-media-frameconfig.md">FrameConfig</a></strong> instance. </p>
</td>
</tr>
<tr id="row1599958108093523"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1142815873093523"><a name="p1142815873093523"></a><a name="p1142815873093523"></a><a href="multimedia_frameconfig.md#gac8f74ff3689605a59a17997bdeaec1fc">OHOS::Media::FrameConfig::FrameConfig</a> (int32_t type)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1057110657093523"><a name="p1057110657093523"></a><a name="p1057110657093523"></a> </p>
<p id="p21088837093523"><a name="p21088837093523"></a><a name="p21088837093523"></a>A constructor used to create a <strong id="b1897196341093523"><a name="b1897196341093523"></a><a name="b1897196341093523"></a><a href="ohos-media-frameconfig.md">FrameConfig</a></strong> instance based on the configuration mode. </p>
</td>
</tr>
<tr id="row847001695093523"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1515304811093523"><a name="p1515304811093523"></a><a name="p1515304811093523"></a><em id="gaa2e58c2ce602d9263b76596374823616"><a name="gaa2e58c2ce602d9263b76596374823616"></a><a name="gaa2e58c2ce602d9263b76596374823616"></a></em>OHOS::Media::FrameConfig::~FrameConfig ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p592191295093523"><a name="p592191295093523"></a><a name="p592191295093523"></a><strong id="b614264304"><a name="b614264304"></a><a name="b614264304"></a></strong>  </p>
<p id="p1732693624093523"><a name="p1732693624093523"></a><a name="p1732693624093523"></a>A destructor used to delete the <strong id="b2137068351093523"><a name="b2137068351093523"></a><a name="b2137068351093523"></a><a href="ohos-media-frameconfig.md">FrameConfig</a></strong> instance. </p>
</td>
</tr>
<tr id="row934343455093523"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1196308376093523"><a name="p1196308376093523"></a><a name="p1196308376093523"></a><a href="multimedia_frameconfig.md#ga382977445a583ed0424c5ccf581e824c">OHOS::Media::FrameConfig::GetFrameConfigType</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1186044981093523"><a name="p1186044981093523"></a><a name="p1186044981093523"></a>int32_t </p>
<p id="p1393678935093523"><a name="p1393678935093523"></a><a name="p1393678935093523"></a>Obtains the frame configuration type. </p>
</td>
</tr>
<tr id="row1439886953093523"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2055011540093523"><a name="p2055011540093523"></a><a name="p2055011540093523"></a><a href="multimedia_frameconfig.md#ga955d04df96c009e4699ea6ed46d9e758">OHOS::Media::FrameConfig::GetSurfaces</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1911655097093523"><a name="p1911655097093523"></a><a name="p1911655097093523"></a>std::list&lt; <a href="ohos-surface.md">Surface</a> * &gt; </p>
<p id="p818061415093523"><a name="p818061415093523"></a><a name="p818061415093523"></a>Obtains a list of shared memories (surface objects). </p>
</td>
</tr>
<tr id="row325036203093523"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p624747723093523"><a name="p624747723093523"></a><a name="p624747723093523"></a><a href="multimedia_frameconfig.md#ga16760311713db03bf06ea0a6d6622013">OHOS::Media::FrameConfig::AddSurface</a> (<a href="ohos-surface.md">Surface</a> &amp;surface)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1881805007093523"><a name="p1881805007093523"></a><a name="p1881805007093523"></a>void </p>
<p id="p780662453093523"><a name="p780662453093523"></a><a name="p780662453093523"></a>Adds a surface (an object of shared memory). </p>
</td>
</tr>
<tr id="row874257263093523"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1202893916093523"><a name="p1202893916093523"></a><a name="p1202893916093523"></a><a href="multimedia_frameconfig.md#ga9ac4bc5e52840ee579482a3836774762">OHOS::Media::FrameConfig::RemoveSurface</a> (<a href="ohos-surface.md">Surface</a> &amp;surface)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p36914678093523"><a name="p36914678093523"></a><a name="p36914678093523"></a>void </p>
<p id="p315354923093523"><a name="p315354923093523"></a><a name="p315354923093523"></a>Removes a surface (an object of shared memory). You can call this function to release the surface when your application does not need to obtain data. </p>
</td>
</tr>
</tbody>
</table>

## **Details**<a name="section1316972923093523"></a>

## **Function Documentation**<a name="section99643443093523"></a>

## AddSurface\(\)<a name="ga16760311713db03bf06ea0a6d6622013"></a>

```
void OHOS::Media::FrameConfig::AddSurface ([Surface](ohos-surface.md) & surface)
```

 **Description:**

Adds a surface \(an object of shared memory\). 

**Parameters:**

<a name="table1200864310093523"></a>
<table><thead align="left"><tr id="row1691906856093523"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1131745059093523"><a name="p1131745059093523"></a><a name="p1131745059093523"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p573520453093523"><a name="p573520453093523"></a><a name="p573520453093523"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1576660451093523"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">surface</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the surface to add. </td>
</tr>
</tbody>
</table>

## FrameConfig\(\)<a name="gac8f74ff3689605a59a17997bdeaec1fc"></a>

```
OHOS::Media::FrameConfig::FrameConfig (int32_t type)
```

 **Description:**

A constructor used to create a  **[FrameConfig](ohos-media-frameconfig.md)**  instance based on the configuration mode. 

**Parameters:**

<a name="table3916437093523"></a>
<table><thead align="left"><tr id="row943098068093523"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p653396384093523"><a name="p653396384093523"></a><a name="p653396384093523"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1425294822093523"><a name="p1425294822093523"></a><a name="p1425294822093523"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row216483368093523"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">type</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the frame configuration mode, which can be <strong id="b61206256093523"><a name="b61206256093523"></a><a name="b61206256093523"></a>FRAME_CONFIG_PREVIEW</strong>, &lt;b&gt;FRAME_CONFIG_RECORD, or <strong id="b1926145786093523"><a name="b1926145786093523"></a><a name="b1926145786093523"></a>FRAME_CONFIG_CAPTURE</strong>. </td>
</tr>
</tbody>
</table>

## GetFrameConfigType\(\)<a name="ga382977445a583ed0424c5ccf581e824c"></a>

```
int32_t OHOS::Media::FrameConfig::GetFrameConfigType ()
```

 **Description:**

Obtains the frame configuration type. 

**Returns:**

Returns the frame configuration type if obtained; returns  **-1**  otherwise. 



## GetSurfaces\(\)<a name="ga955d04df96c009e4699ea6ed46d9e758"></a>

```
std::list<[Surface](ohos-surface.md) *> OHOS::Media::FrameConfig::GetSurfaces ()
```

 **Description:**

Obtains a list of shared memories \(surface objects\). 

**Returns:**

Returns the list of shared memories if obtained; returns  **NULL**  otherwise. 



## RemoveSurface\(\)<a name="ga9ac4bc5e52840ee579482a3836774762"></a>

```
void OHOS::Media::FrameConfig::RemoveSurface ([Surface](ohos-surface.md) & surface)
```

 **Description:**

Removes a surface \(an object of shared memory\). You can call this function to release the surface when your application does not need to obtain data. 

**Parameters:**

<a name="table632482882093523"></a>
<table><thead align="left"><tr id="row963311700093523"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1055726798093523"><a name="p1055726798093523"></a><a name="p1055726798093523"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p586865510093523"><a name="p586865510093523"></a><a name="p586865510093523"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row770823012093523"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">surface</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the surface to remove. </td>
</tr>
</tbody>
</table>

