# MultiMedia\_CameraKit<a name="EN-US_TOPIC_0000001054598115"></a>

## **Overview**<a name="section683597193084827"></a>

Defines the  **CameraKit**  class for using camera functionalities. 

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section1484193652084827"></a>

## Files<a name="files"></a>

<a name="table334043110084827"></a>
<table><thead align="left"><tr id="row1826580329084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2107746870084827"><a name="p2107746870084827"></a><a name="p2107746870084827"></a>File Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1283562380084827"><a name="p1283562380084827"></a><a name="p1283562380084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row903268435084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1119641327084827"><a name="p1119641327084827"></a><a name="p1119641327084827"></a><a href="camera_kit-h.md">camera_kit.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p690072345084827"><a name="p690072345084827"></a><a name="p690072345084827"></a>Declares functions in the <strong id="b344916150084827"><a name="b344916150084827"></a><a name="b344916150084827"></a>CameraKit</strong> class. </p>
</td>
</tr>
</tbody>
</table>

## Data Structures<a name="nested-classes"></a>

<a name="table935100149084827"></a>
<table><thead align="left"><tr id="row1671317617084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1939868370084827"><a name="p1939868370084827"></a><a name="p1939868370084827"></a>Data Structure Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1553526741084827"><a name="p1553526741084827"></a><a name="p1553526741084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1590846664084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p103904195084827"><a name="p103904195084827"></a><a name="p103904195084827"></a><a href="ohos-media-camerakit.md">OHOS::Media::CameraKit</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1263734831084827"><a name="p1263734831084827"></a><a name="p1263734831084827"></a>Provides functions in the <strong id="b1222512211084827"><a name="b1222512211084827"></a><a name="b1222512211084827"></a><a href="ohos-media-camerakit.md">CameraKit</a></strong> class. </p>
</td>
</tr>
</tbody>
</table>

## Functions<a name="func-members"></a>

<a name="table1054311415084827"></a>
<table><thead align="left"><tr id="row1666062271084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p54601845084827"><a name="p54601845084827"></a><a name="p54601845084827"></a>Function Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1006479028084827"><a name="p1006479028084827"></a><a name="p1006479028084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row581780631084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1816604427084827"><a name="p1816604427084827"></a><a name="p1816604427084827"></a><a href="multimedia_camerakit.md#ga7d36867ec1bd57e25d1c60b5de24cbe6">OHOS::Media::CameraKit::~CameraKit</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1619116092084827"><a name="p1619116092084827"></a><a name="p1619116092084827"></a> </p>
<p id="p1252907784084827"><a name="p1252907784084827"></a><a name="p1252907784084827"></a>A destructor used to delete the <strong id="b1253605341084827"><a name="b1253605341084827"></a><a name="b1253605341084827"></a><a href="ohos-media-camerakit.md">CameraKit</a></strong> instance. </p>
</td>
</tr>
<tr id="row1037689089084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p374698470084827"><a name="p374698470084827"></a><a name="p374698470084827"></a><a href="multimedia_camerakit.md#ga1911ba8eca0e57ddc15df25cf2b21f7b">OHOS::Media::CameraKit::GetInstance</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1044063199084827"><a name="p1044063199084827"></a><a name="p1044063199084827"></a>static <a href="ohos-media-camerakit.md">CameraKit</a> * </p>
<p id="p266466968084827"><a name="p266466968084827"></a><a name="p266466968084827"></a>Obtains a single instance of the <strong id="b2101860447084827"><a name="b2101860447084827"></a><a name="b2101860447084827"></a><a href="ohos-media-camerakit.md">CameraKit</a></strong>. </p>
</td>
</tr>
<tr id="row1651684844084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1231387692084827"><a name="p1231387692084827"></a><a name="p1231387692084827"></a><a href="multimedia_camerakit.md#ga8894d876198f2614d65b432a8a002163">OHOS::Media::CameraKit::GetCameraIds</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1888341529084827"><a name="p1888341529084827"></a><a name="p1888341529084827"></a>std::list&lt; std::string &gt; </p>
<p id="p1837810454084827"><a name="p1837810454084827"></a><a name="p1837810454084827"></a>Obtains IDs of cameras that are currently available. </p>
</td>
</tr>
<tr id="row1825790813084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p194244963084827"><a name="p194244963084827"></a><a name="p194244963084827"></a><a href="multimedia_camerakit.md#gab4cfb051de29415d080a203ca4639448">OHOS::Media::CameraKit::GetCameraAbility</a> (std::string cameraId)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p520593555084827"><a name="p520593555084827"></a><a name="p520593555084827"></a>const <a href="ohos-media-cameraability.md">CameraAbility</a> * </p>
<p id="p34919709084827"><a name="p34919709084827"></a><a name="p34919709084827"></a>Obtains the camera capability, including the resolutions and frame rates. </p>
</td>
</tr>
<tr id="row1650936824084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1172085601084827"><a name="p1172085601084827"></a><a name="p1172085601084827"></a><a href="multimedia_camerakit.md#ga4e6cd8787f06c4a82ad982d36029b3ec">OHOS::Media::CameraKit::RegisterCameraDeviceCallback</a> (<a href="ohos-media-cameradevicecallback.md">CameraDeviceCallback</a> &amp;callback, EventHandler &amp;handler)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p418136677084827"><a name="p418136677084827"></a><a name="p418136677084827"></a>void </p>
<p id="p1907523166084827"><a name="p1907523166084827"></a><a name="p1907523166084827"></a>Registers a camera callback for camera status changes and an event callback to respond to a triggered event. </p>
</td>
</tr>
<tr id="row1298271604084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2107620567084827"><a name="p2107620567084827"></a><a name="p2107620567084827"></a><a href="multimedia_camerakit.md#ga4f0117575ee988f6d74a3636e01f0aba">OHOS::Media::CameraKit::UnregisterCameraDeviceCallback</a> (<a href="ohos-media-cameradevicecallback.md">CameraDeviceCallback</a> &amp;callback)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1103417097084827"><a name="p1103417097084827"></a><a name="p1103417097084827"></a>void </p>
<p id="p1135077910084827"><a name="p1135077910084827"></a><a name="p1135077910084827"></a>Unregisters a camera callback. </p>
</td>
</tr>
<tr id="row678578169084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p671493436084827"><a name="p671493436084827"></a><a name="p671493436084827"></a><a href="multimedia_camerakit.md#gaa21f4e248e3a46a4f78f4261cba82fe2">OHOS::Media::CameraKit::CreateCamera</a> (const std::string &amp;cameraId, <a href="ohos-media-camerastatecallback.md">CameraStateCallback</a> &amp;callback, EventHandler &amp;handler)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p702766830084827"><a name="p702766830084827"></a><a name="p702766830084827"></a>void </p>
<p id="p529554427084827"><a name="p529554427084827"></a><a name="p529554427084827"></a>Creates a camera object. </p>
</td>
</tr>
</tbody>
</table>

## **Details**<a name="section166943826084827"></a>

## **Function Documentation**<a name="section390699371084827"></a>

## CreateCamera\(\)<a name="gaa21f4e248e3a46a4f78f4261cba82fe2"></a>

```
void OHOS::Media::CameraKit::CreateCamera (const std::string & cameraId, [CameraStateCallback](ohos-media-camerastatecallback.md) & callback, EventHandler & handler )
```

 **Description:**

Creates a camera object. 

**Parameters:**

<a name="table434693209084827"></a>
<table><thead align="left"><tr id="row1882474995084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1995613672084827"><a name="p1995613672084827"></a><a name="p1995613672084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1921173270084827"><a name="p1921173270084827"></a><a name="p1921173270084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row250287188084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">cameraId</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the camera ID. </td>
</tr>
<tr id="row1005769167084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">callback</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the camera callback. </td>
</tr>
<tr id="row986493613084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">handler</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the event callback to register. </td>
</tr>
</tbody>
</table>

## GetCameraAbility\(\)<a name="gab4cfb051de29415d080a203ca4639448"></a>

```
const [CameraAbility](ohos-media-cameraability.md)* OHOS::Media::CameraKit::GetCameraAbility (std::string cameraId)
```

 **Description:**

Obtains the camera capability, including the resolutions and frame rates. 

**Parameters:**

<a name="table1683773556084827"></a>
<table><thead align="left"><tr id="row1196745251084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p189854119084827"><a name="p189854119084827"></a><a name="p189854119084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p647083428084827"><a name="p647083428084827"></a><a name="p647083428084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1736646166084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">cameraId</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the camera ID. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the  **[CameraAbility](ohos-media-cameraability.md)**  object. 



## GetCameraIds\(\)<a name="ga8894d876198f2614d65b432a8a002163"></a>

```
std::list<std::string> OHOS::Media::CameraKit::GetCameraIds ()
```

 **Description:**

Obtains IDs of cameras that are currently available. 

**Returns:**

Returns the camera IDs if obtained; returns  **NULL**  otherwise. 



## GetInstance\(\)<a name="ga1911ba8eca0e57ddc15df25cf2b21f7b"></a>

```
static [CameraKit](ohos-media-camerakit.md)* OHOS::Media::CameraKit::GetInstance ()
```

 **Description:**

Obtains a single instance of the  **[CameraKit](ohos-media-camerakit.md)**. 

**Returns:**

Returns the  **[CameraKit](ohos-media-camerakit.md)**  instance if obtained; returns  **NULL**  otherwise. 



## RegisterCameraDeviceCallback\(\)<a name="ga4e6cd8787f06c4a82ad982d36029b3ec"></a>

```
void OHOS::Media::CameraKit::RegisterCameraDeviceCallback ([CameraDeviceCallback](ohos-media-cameradevicecallback.md) & callback, EventHandler & handler )
```

 **Description:**

Registers a camera callback for camera status changes and an event callback to respond to a triggered event. 

**Parameters:**

<a name="table93748303084827"></a>
<table><thead align="left"><tr id="row2108134398084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1894260116084827"><a name="p1894260116084827"></a><a name="p1894260116084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1610416423084827"><a name="p1610416423084827"></a><a name="p1610416423084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1691893688084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">callback</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the camera callback to register. </td>
</tr>
<tr id="row1443766939084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">handler</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the event callback to register. </td>
</tr>
</tbody>
</table>

## UnregisterCameraDeviceCallback\(\)<a name="ga4f0117575ee988f6d74a3636e01f0aba"></a>

```
void OHOS::Media::CameraKit::UnregisterCameraDeviceCallback ([CameraDeviceCallback](ohos-media-cameradevicecallback.md) & callback)
```

 **Description:**

Unregisters a camera callback. 

**Parameters:**

<a name="table1779259241084827"></a>
<table><thead align="left"><tr id="row1593785208084827"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p153850553084827"><a name="p153850553084827"></a><a name="p153850553084827"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p450793440084827"><a name="p450793440084827"></a><a name="p450793440084827"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1980706539084827"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">callback</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the camera callback to unregister. </td>
</tr>
</tbody>
</table>

## \~CameraKit\(\)<a name="ga7d36867ec1bd57e25d1c60b5de24cbe6"></a>

```
OHOS::Media::CameraKit::~CameraKit ()
```

 **Description:**

A destructor used to delete the  **[CameraKit](ohos-media-camerakit.md)**  instance. 

