# IO<a name="EN-US_TOPIC_0000001054909424"></a>

## **Overview**<a name="section32747528084824"></a>

Provides data structures and functions for performing input/output \(I/O\) operations, such as printf and scanf. 

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section1369670415084824"></a>

## Files<a name="files"></a>

<a name="table1444992503084824"></a>
<table><thead align="left"><tr id="row2005903257084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2055479227084824"><a name="p2055479227084824"></a><a name="p2055479227084824"></a>File Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1050396552084824"><a name="p1050396552084824"></a><a name="p1050396552084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row549306871084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1737814673084824"><a name="p1737814673084824"></a><a name="p1737814673084824"></a><a href="aio-h.md">aio.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p905749188084824"><a name="p905749188084824"></a><a name="p905749188084824"></a>Declares functions related to asynchronous I/O (AIO) operations. </p>
</td>
</tr>
<tr id="row492312495084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1585050500084824"><a name="p1585050500084824"></a><a name="p1585050500084824"></a><a href="err-h.md">err.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p621738135084824"><a name="p621738135084824"></a><a name="p621738135084824"></a>Provides common functions for error messages. </p>
</td>
</tr>
<tr id="row1015161886084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p205535853084824"><a name="p205535853084824"></a><a name="p205535853084824"></a><a href="iconv-h.md">iconv.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p512613911084824"><a name="p512613911084824"></a><a name="p512613911084824"></a>Declares functions related to the I/O character set conversion. </p>
</td>
</tr>
<tr id="row1221025841084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p867753513084824"><a name="p867753513084824"></a><a name="p867753513084824"></a><a href="locale-h.md">locale.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p711504688084824"><a name="p711504688084824"></a><a name="p711504688084824"></a>Provides functions to set and obtain the locale language environment. </p>
</td>
</tr>
<tr id="row1882199929084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1665002178084824"><a name="p1665002178084824"></a><a name="p1665002178084824"></a><a href="nl_types-h.md">nl_types.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p366654567084824"><a name="p366654567084824"></a><a name="p366654567084824"></a>Defines I/O multiplexing functions related to message catalog operations. </p>
</td>
</tr>
<tr id="row1070747779084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p261477369084824"><a name="p261477369084824"></a><a name="p261477369084824"></a><a href="poll-h.md">poll.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1955483924084824"><a name="p1955483924084824"></a><a name="p1955483924084824"></a>Declares I/O multiplexing functions. </p>
</td>
</tr>
<tr id="row27324335084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2024290867084824"><a name="p2024290867084824"></a><a name="p2024290867084824"></a><a href="stdio-h.md">stdio.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p177264066084824"><a name="p177264066084824"></a><a name="p177264066084824"></a>Declares common functions used for performing input and output (I/O) operations. </p>
</td>
</tr>
<tr id="row1456167763084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1776019273084824"><a name="p1776019273084824"></a><a name="p1776019273084824"></a><a href="select-h.md">select.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1593954754084824"><a name="p1593954754084824"></a><a name="p1593954754084824"></a>Provides functions and structures related to I/O multiplexing. </p>
</td>
</tr>
<tr id="row1025688103084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p828879851084824"><a name="p828879851084824"></a><a name="p828879851084824"></a><a href="uio-h.md">uio.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p886208814084824"><a name="p886208814084824"></a><a name="p886208814084824"></a>Provides functions and structures related to input/output (I/O) to a file or buffer. </p>
</td>
</tr>
<tr id="row1498748411084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1974301731084824"><a name="p1974301731084824"></a><a name="p1974301731084824"></a><a href="wordexp-h.md">wordexp.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1653852793084824"><a name="p1653852793084824"></a><a name="p1653852793084824"></a>Declares functions related to word expansion. </p>
</td>
</tr>
</tbody>
</table>

## Data Structures<a name="nested-classes"></a>

<a name="table877250596084824"></a>
<table><thead align="left"><tr id="row1999324186084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1576707676084824"><a name="p1576707676084824"></a><a name="p1576707676084824"></a>Data Structure Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1702343387084824"><a name="p1702343387084824"></a><a name="p1702343387084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1962014097084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2024282368084824"><a name="p2024282368084824"></a><a name="p2024282368084824"></a><a href="lconv.md">lconv</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1318706521084824"><a name="p1318706521084824"></a><a name="p1318706521084824"></a>Indicates format information about a number. </p>
</td>
</tr>
<tr id="row76585976084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2131594539084824"><a name="p2131594539084824"></a><a name="p2131594539084824"></a><a href="pollfd.md">pollfd</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1239404531084824"><a name="p1239404531084824"></a><a name="p1239404531084824"></a>Defines I/O multiplexing. </p>
</td>
</tr>
<tr id="row824139510084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p529767820084824"><a name="p529767820084824"></a><a name="p529767820084824"></a><a href="fd_set.md">fd_set</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1017353548084824"><a name="p1017353548084824"></a><a name="p1017353548084824"></a>Defines a file descriptor set. </p>
</td>
</tr>
<tr id="row1864121693084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p145465457084824"><a name="p145465457084824"></a><a name="p145465457084824"></a><a href="wordexp_t.md">wordexp_t</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p912811481084824"><a name="p912811481084824"></a><a name="p912811481084824"></a>Describes information about word expansion. </p>
</td>
</tr>
</tbody>
</table>

## Macros<a name="define-members"></a>

<a name="table2111739805084824"></a>
<table><thead align="left"><tr id="row1772031994084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p605863373084824"><a name="p605863373084824"></a><a name="p605863373084824"></a>Macro Name and Value</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2085685088084824"><a name="p2085685088084824"></a><a name="p2085685088084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row637343870084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2110966215084824"><a name="p2110966215084824"></a><a name="p2110966215084824"></a><em id="ga6643367cfb016dbacaef01c4ef3706b0"><a name="ga6643367cfb016dbacaef01c4ef3706b0"></a><a name="ga6643367cfb016dbacaef01c4ef3706b0"></a></em>LIO_WAIT    0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1420979265084824"><a name="p1420979265084824"></a><a name="p1420979265084824"></a>Waiting to be notified of the completion of all asynchronous I/O operations. </p>
</td>
</tr>
<tr id="row119437125084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1475333885084824"><a name="p1475333885084824"></a><a name="p1475333885084824"></a><em id="gaed8f2a06da21fad02bfc0e5749a8ecca"><a name="gaed8f2a06da21fad02bfc0e5749a8ecca"></a><a name="gaed8f2a06da21fad02bfc0e5749a8ecca"></a></em>LIO_NOWAIT    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1338998602084824"><a name="p1338998602084824"></a><a name="p1338998602084824"></a>Not waiting to be notified of the completion of all asynchronous I/O operations. </p>
</td>
</tr>
<tr id="row1022746238084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p410058728084824"><a name="p410058728084824"></a><a name="p410058728084824"></a><em id="ga07c66689961056725d7f50231d740ba9"><a name="ga07c66689961056725d7f50231d740ba9"></a><a name="ga07c66689961056725d7f50231d740ba9"></a></em>LC_CTYPE    0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p177524401084824"><a name="p177524401084824"></a><a name="p177524401084824"></a>Language symbol type, which affects character classification and case conversion. </p>
</td>
</tr>
<tr id="row970315348084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p659316083084824"><a name="p659316083084824"></a><a name="p659316083084824"></a><em id="ga158abb82c565096465ade138c98970d0"><a name="ga158abb82c565096465ade138c98970d0"></a><a name="ga158abb82c565096465ade138c98970d0"></a></em>LC_NUMERIC    1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p57977965084824"><a name="p57977965084824"></a><a name="p57977965084824"></a>Number type, which affects the number format. </p>
</td>
</tr>
<tr id="row340731194084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1109934094084824"><a name="p1109934094084824"></a><a name="p1109934094084824"></a><em id="gaa652c62b53b6bf728d592bfbdc7d5852"><a name="gaa652c62b53b6bf728d592bfbdc7d5852"></a><a name="gaa652c62b53b6bf728d592bfbdc7d5852"></a></em>LC_TIME    2</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1945147229084824"><a name="p1945147229084824"></a><a name="p1945147229084824"></a>Time type, which affects date and time formats. </p>
</td>
</tr>
<tr id="row1122163898084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p37252653084824"><a name="p37252653084824"></a><a name="p37252653084824"></a><em id="gaab9cf7b1a206fb75e5884934c8d676db"><a name="gaab9cf7b1a206fb75e5884934c8d676db"></a><a name="gaab9cf7b1a206fb75e5884934c8d676db"></a></em>LC_COLLATE    3</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1457870185084824"><a name="p1457870185084824"></a><a name="p1457870185084824"></a>Character sorting type, which affects string comparison and sorting habits. </p>
</td>
</tr>
<tr id="row440122681084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p434022760084824"><a name="p434022760084824"></a><a name="p434022760084824"></a><em id="ga6d033a83772ef6e6c10dbf13a6a58fb7"><a name="ga6d033a83772ef6e6c10dbf13a6a58fb7"></a><a name="ga6d033a83772ef6e6c10dbf13a6a58fb7"></a></em>LC_MONETARY    4</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1369507550084824"><a name="p1369507550084824"></a><a name="p1369507550084824"></a>Monetary type, which affects monetary information. </p>
</td>
</tr>
<tr id="row991727670084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p471532654084824"><a name="p471532654084824"></a><a name="p471532654084824"></a><em id="ga7195d6f0a8d1b9d164a3988a1b8249e8"><a name="ga7195d6f0a8d1b9d164a3988a1b8249e8"></a><a name="ga7195d6f0a8d1b9d164a3988a1b8249e8"></a></em>LC_MESSAGES    5</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1348537910084824"><a name="p1348537910084824"></a><a name="p1348537910084824"></a>Message type, which affects prompt information, error information, status information, titles, labels, buttons, and menus. </p>
</td>
</tr>
<tr id="row438603775084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1015684668084824"><a name="p1015684668084824"></a><a name="p1015684668084824"></a><em id="ga9cc5213b5dca4f8e48e64586ee444c33"><a name="ga9cc5213b5dca4f8e48e64586ee444c33"></a><a name="ga9cc5213b5dca4f8e48e64586ee444c33"></a></em>LC_ALL    6</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1380021845084824"><a name="p1380021845084824"></a><a name="p1380021845084824"></a>All types, which affect all content of locale settings. If <strong id="b1160154096084824"><a name="b1160154096084824"></a><a name="b1160154096084824"></a>LC_ALL</strong> is set, the locale information of all types is set to be consistent with <strong id="b1624179877084824"><a name="b1624179877084824"></a><a name="b1624179877084824"></a>LC_ALL</strong>. </p>
</td>
</tr>
<tr id="row423974529084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p721962003084824"><a name="p721962003084824"></a><a name="p721962003084824"></a><em id="ga52ac479a805051f59643588b096024ff"><a name="ga52ac479a805051f59643588b096024ff"></a><a name="ga52ac479a805051f59643588b096024ff"></a></em>POLLIN    0x001</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1471505466084824"><a name="p1471505466084824"></a><a name="p1471505466084824"></a>POLLIN event. </p>
</td>
</tr>
<tr id="row1897896596084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p396372772084824"><a name="p396372772084824"></a><a name="p396372772084824"></a><em id="gab6f53b89c7a4cc5e8349f7c778d85168"><a name="gab6f53b89c7a4cc5e8349f7c778d85168"></a><a name="gab6f53b89c7a4cc5e8349f7c778d85168"></a></em>POLLPRI    0x002</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1164174772084824"><a name="p1164174772084824"></a><a name="p1164174772084824"></a>POLLPRI event. </p>
</td>
</tr>
<tr id="row2145869185084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p371457581084824"><a name="p371457581084824"></a><a name="p371457581084824"></a><em id="ga91b3c67129ac7675062f316b840a0d58"><a name="ga91b3c67129ac7675062f316b840a0d58"></a><a name="ga91b3c67129ac7675062f316b840a0d58"></a></em>POLLOUT    0x004</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p628199694084824"><a name="p628199694084824"></a><a name="p628199694084824"></a>POLLOUT event. </p>
</td>
</tr>
<tr id="row308580121084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1105584988084824"><a name="p1105584988084824"></a><a name="p1105584988084824"></a><em id="gab1c532446408c98559d4aaaeeeb99820"><a name="gab1c532446408c98559d4aaaeeeb99820"></a><a name="gab1c532446408c98559d4aaaeeeb99820"></a></em>POLLERR    0x008</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1847850780084824"><a name="p1847850780084824"></a><a name="p1847850780084824"></a>POLLERR event. </p>
</td>
</tr>
<tr id="row172366502084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1800687556084824"><a name="p1800687556084824"></a><a name="p1800687556084824"></a><em id="ga262754fe6bdf27c2cd3da43284ec8536"><a name="ga262754fe6bdf27c2cd3da43284ec8536"></a><a name="ga262754fe6bdf27c2cd3da43284ec8536"></a></em>POLLHUP    0x010</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p899363386084824"><a name="p899363386084824"></a><a name="p899363386084824"></a>POLLHUP event. </p>
</td>
</tr>
<tr id="row1109631892084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p289565754084824"><a name="p289565754084824"></a><a name="p289565754084824"></a><em id="gae8bffe35c61e12fb7b408b89721896df"><a name="gae8bffe35c61e12fb7b408b89721896df"></a><a name="gae8bffe35c61e12fb7b408b89721896df"></a></em>POLLNVAL    0x020</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1337662134084824"><a name="p1337662134084824"></a><a name="p1337662134084824"></a>POLLNVAL event. </p>
</td>
</tr>
<tr id="row288003230084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p523545001084824"><a name="p523545001084824"></a><a name="p523545001084824"></a><em id="ga86c5dbf5a99358e288f573d6a1e0873f"><a name="ga86c5dbf5a99358e288f573d6a1e0873f"></a><a name="ga86c5dbf5a99358e288f573d6a1e0873f"></a></em>FD_SETSIZE    1024</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1608086077084824"><a name="p1608086077084824"></a><a name="p1608086077084824"></a>Defines the size of <strong id="b1167889871084824"><a name="b1167889871084824"></a><a name="b1167889871084824"></a><a href="fd_set.md">fd_set</a></strong>, that is, the maximum number of monitored files. </p>
</td>
</tr>
<tr id="row212102281084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2129181361084824"><a name="p2129181361084824"></a><a name="p2129181361084824"></a><a href="io.md#ga92ab86a10f942411365b9078833559f0">FD_ZERO</a>(s)   do { int __i; unsigned long *__b=(s)-&gt;fds_bits; for(__i=sizeof (<a href="fd_set.md">fd_set</a>)/sizeof (long); __i; __i--) *__b++=0; } while(0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p480514889084824"><a name="p480514889084824"></a><a name="p480514889084824"></a>Clears all elements in the file descriptor set. </p>
</td>
</tr>
<tr id="row1813330077084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p378358035084824"><a name="p378358035084824"></a><a name="p378358035084824"></a><a href="io.md#gaa7701be461ce602ff7043cbd898a0c53">FD_SET</a>(d, s)   ((s)-&gt;fds_bits[(d)/(8*sizeof(long))] |= (1UL&lt;&lt;((d)%(8*sizeof(long)))))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2047521936084824"><a name="p2047521936084824"></a><a name="p2047521936084824"></a>Adds a file descriptor to a set. </p>
</td>
</tr>
<tr id="row2043603408084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1305727462084824"><a name="p1305727462084824"></a><a name="p1305727462084824"></a><a href="io.md#ga60efc4a969e971f91b7a73bcace62e58">FD_CLR</a>(d, s)   ((s)-&gt;fds_bits[(d)/(8*sizeof(long))] &amp;= ~(1UL&lt;&lt;((d)%(8*sizeof(long)))))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p352232290084824"><a name="p352232290084824"></a><a name="p352232290084824"></a>Removes a file descriptor from a set. </p>
</td>
</tr>
<tr id="row1015394528084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1508153562084824"><a name="p1508153562084824"></a><a name="p1508153562084824"></a><a href="io.md#ga99a3a0e4d7d1d3eb7be68f37554c0a30">FD_ISSET</a>(d, s)   !!((s)-&gt;fds_bits[(d)/(8*sizeof(long))] &amp; (1UL&lt;&lt;((d)%(8*sizeof(long)))))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1133212083084824"><a name="p1133212083084824"></a><a name="p1133212083084824"></a>Checks whether a file descriptor is in a set. </p>
</td>
</tr>
</tbody>
</table>

## Typedefs<a name="typedef-members"></a>

<a name="table1332745807084824"></a>
<table><thead align="left"><tr id="row793962010084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p11334924084824"><a name="p11334924084824"></a><a name="p11334924084824"></a>Typedef Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1819458470084824"><a name="p1819458470084824"></a><a name="p1819458470084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1636663835084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p443890178084824"><a name="p443890178084824"></a><a name="p443890178084824"></a><em id="ga72517f6ffadddaafa9d51dee9b535c9f"><a name="ga72517f6ffadddaafa9d51dee9b535c9f"></a><a name="ga72517f6ffadddaafa9d51dee9b535c9f"></a></em>iconv_t </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1030878529084824"><a name="p1030878529084824"></a><a name="p1030878529084824"></a><strong id="b556821486"><a name="b556821486"></a><a name="b556821486"></a></strong> typedef void * </p>
<p id="p51976302084824"><a name="p51976302084824"></a><a name="p51976302084824"></a>Type of the character set conversion descriptor. </p>
</td>
</tr>
<tr id="row696320222084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1740192128084824"><a name="p1740192128084824"></a><a name="p1740192128084824"></a><em id="ga3f305b6699c89f91aecfc0b5f8604a5f"><a name="ga3f305b6699c89f91aecfc0b5f8604a5f"></a><a name="ga3f305b6699c89f91aecfc0b5f8604a5f"></a></em>nl_catd </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p809595909084824"><a name="p809595909084824"></a><a name="p809595909084824"></a><strong id="b112347597"><a name="b112347597"></a><a name="b112347597"></a></strong> typedef void * </p>
<p id="p1838528833084824"><a name="p1838528833084824"></a><a name="p1838528833084824"></a>Type of message catalog descriptor. </p>
</td>
</tr>
<tr id="row529565323084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p546462329084824"><a name="p546462329084824"></a><a name="p546462329084824"></a><em id="ga0af7a8bdafcd5532e620a11f0d373d52"><a name="ga0af7a8bdafcd5532e620a11f0d373d52"></a><a name="ga0af7a8bdafcd5532e620a11f0d373d52"></a></em>nfds_t </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p716606889084824"><a name="p716606889084824"></a><a name="p716606889084824"></a><strong id="b412263468"><a name="b412263468"></a><a name="b412263468"></a></strong> typedef unsigned long </p>
<p id="p2024288668084824"><a name="p2024288668084824"></a><a name="p2024288668084824"></a>Number of poll types. </p>
</td>
</tr>
<tr id="row1682718917084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p995506855084824"><a name="p995506855084824"></a><a name="p995506855084824"></a><em id="ga912af5ab9f8a52ddd387b7defc0b49f1"><a name="ga912af5ab9f8a52ddd387b7defc0b49f1"></a><a name="ga912af5ab9f8a52ddd387b7defc0b49f1"></a></em>FILE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1687949399084824"><a name="p1687949399084824"></a><a name="p1687949399084824"></a><strong id="b504638019"><a name="b504638019"></a><a name="b504638019"></a></strong> typedef struct _IO_FILE </p>
<p id="p1092680722084824"><a name="p1092680722084824"></a><a name="p1092680722084824"></a>Struct of file stream. </p>
</td>
</tr>
<tr id="row1258405524084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p973131826084824"><a name="p973131826084824"></a><a name="p973131826084824"></a><em id="gaf78c256e09db7de8ea18def79fc5e6b2"><a name="gaf78c256e09db7de8ea18def79fc5e6b2"></a><a name="gaf78c256e09db7de8ea18def79fc5e6b2"></a></em>fd_mask </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p417488075084824"><a name="p417488075084824"></a><a name="p417488075084824"></a><strong id="b1450897648"><a name="b1450897648"></a><a name="b1450897648"></a></strong> typedef unsigned long </p>
<p id="p423039292084824"><a name="p423039292084824"></a><a name="p423039292084824"></a>Defines <strong id="b1304812245084824"><a name="b1304812245084824"></a><a name="b1304812245084824"></a><a href="fd_set.md">fd_set</a></strong> as the alias of the element type. </p>
</td>
</tr>
</tbody>
</table>

## Functions<a name="func-members"></a>

<a name="table1985949743084824"></a>
<table><thead align="left"><tr id="row1450879648084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p275967719084824"><a name="p275967719084824"></a><a name="p275967719084824"></a>Function Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p306060427084824"><a name="p306060427084824"></a><a name="p306060427084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1915764891084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1663579339084824"><a name="p1663579339084824"></a><a name="p1663579339084824"></a><a href="io.md#gae15ea0aaa18c5f007c3933085749ecaf">lio_listio</a> (int mode, struct aiocb *restrict const *restrict cbs, int cnt, struct <a href="sigevent.md">sigevent</a> *restrict sev)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1424253853084824"><a name="p1424253853084824"></a><a name="p1424253853084824"></a>int </p>
<p id="p70561235084824"><a name="p70561235084824"></a><a name="p70561235084824"></a>Initiates AIO requests. </p>
</td>
</tr>
<tr id="row1907061084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1296874977084824"><a name="p1296874977084824"></a><a name="p1296874977084824"></a><a href="io.md#gaf80d19f1297a11626fab61a248959c71">warn</a> (const char *fmt,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1703092742084824"><a name="p1703092742084824"></a><a name="p1703092742084824"></a>void </p>
<p id="p2133299280084824"><a name="p2133299280084824"></a><a name="p2133299280084824"></a>Displays a formatted error message on the standard error (stderr) output. </p>
</td>
</tr>
<tr id="row741724860084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1222079696084824"><a name="p1222079696084824"></a><a name="p1222079696084824"></a><a href="io.md#ga9ca1ffba0c6f5df7b172d25917611b4a">vwarn</a> (const char *fmt, va_list args)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1628536931084824"><a name="p1628536931084824"></a><a name="p1628536931084824"></a>void </p>
<p id="p2051361235084824"><a name="p2051361235084824"></a><a name="p2051361235084824"></a>Displays a formatted error message on the stderr output. </p>
</td>
</tr>
<tr id="row574958686084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p53181378084824"><a name="p53181378084824"></a><a name="p53181378084824"></a><a href="io.md#ga58f3d9691c146f86e562022d39567b7f">warnx</a> (const char *fmt,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p164469354084824"><a name="p164469354084824"></a><a name="p164469354084824"></a>void </p>
<p id="p77253608084824"><a name="p77253608084824"></a><a name="p77253608084824"></a>Displays a formatted error message on the stderr output. </p>
</td>
</tr>
<tr id="row568184204084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1890109263084824"><a name="p1890109263084824"></a><a name="p1890109263084824"></a><a href="io.md#ga22924aaaaa6b6e8bba4c76d0a0fe86cd">vwarnx</a> (const char *fmt, va_list args)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p519330287084824"><a name="p519330287084824"></a><a name="p519330287084824"></a>void </p>
<p id="p280425870084824"><a name="p280425870084824"></a><a name="p280425870084824"></a>Displays a formatted error message on the stderr output. </p>
</td>
</tr>
<tr id="row936188716084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p334983381084824"><a name="p334983381084824"></a><a name="p334983381084824"></a><a href="io.md#gaa6b66a9a8eb4be40e4424a4dc92ae056">err</a> (int eval, const char *fmt, va_list args)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p126716938084824"><a name="p126716938084824"></a><a name="p126716938084824"></a>void </p>
<p id="p2047353950084824"><a name="p2047353950084824"></a><a name="p2047353950084824"></a>Displays error information. </p>
</td>
</tr>
<tr id="row1458076262084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1147704230084824"><a name="p1147704230084824"></a><a name="p1147704230084824"></a><a href="io.md#gaeaca83913c785b95d6c50f35207ff739">errx</a> (int eval, const char *fmt,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1825440026084824"><a name="p1825440026084824"></a><a name="p1825440026084824"></a>void </p>
<p id="p4895544084824"><a name="p4895544084824"></a><a name="p4895544084824"></a>Displays error information. </p>
</td>
</tr>
<tr id="row2054968998084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2073025954084824"><a name="p2073025954084824"></a><a name="p2073025954084824"></a><a href="io.md#gaf5491fca8b356da75d96fc469bf32ea6">verr</a> (int eval, const char *fmt, va_list args)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2027419901084824"><a name="p2027419901084824"></a><a name="p2027419901084824"></a>void </p>
<p id="p1925437434084824"><a name="p1925437434084824"></a><a name="p1925437434084824"></a>Displays error information. </p>
</td>
</tr>
<tr id="row1035970648084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1708287540084824"><a name="p1708287540084824"></a><a name="p1708287540084824"></a><a href="io.md#ga4b5f9ccd84c00dc473329e4bf64125e1">verrx</a> (int eval, const char *fmt, va_list args)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2043437472084824"><a name="p2043437472084824"></a><a name="p2043437472084824"></a>void </p>
<p id="p85579407084824"><a name="p85579407084824"></a><a name="p85579407084824"></a>Displays a formatted error message. </p>
</td>
</tr>
<tr id="row477177245084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1807212497084824"><a name="p1807212497084824"></a><a name="p1807212497084824"></a><a href="io.md#ga934548ab8aaae237ac5cce0ed0b3edec">iconv_open</a> (const char *to, const char *from)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1912744111084824"><a name="p1912744111084824"></a><a name="p1912744111084824"></a><a href="io.md#ga72517f6ffadddaafa9d51dee9b535c9f">iconv_t</a> </p>
<p id="p1356258745084824"><a name="p1356258745084824"></a><a name="p1356258745084824"></a>Obtain a character set conversion descriptor. </p>
</td>
</tr>
<tr id="row1496450107084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p442048917084824"><a name="p442048917084824"></a><a name="p442048917084824"></a><a href="io.md#gab7c1300a663def659ce6d4a01076c39d">iconv</a> (<a href="io.md#ga72517f6ffadddaafa9d51dee9b535c9f">iconv_t</a> cd, char **restrict in, size_t *restrict inb, char **restrict out, size_t *restrict outb)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1889769489084824"><a name="p1889769489084824"></a><a name="p1889769489084824"></a>size_t </p>
<p id="p1796129432084824"><a name="p1796129432084824"></a><a name="p1796129432084824"></a>Converts a character set. </p>
</td>
</tr>
<tr id="row2144567468084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1049708146084824"><a name="p1049708146084824"></a><a name="p1049708146084824"></a><a href="io.md#ga062da5f802d9e274a8702f11921e691b">iconv_close</a> (<a href="io.md#ga72517f6ffadddaafa9d51dee9b535c9f">iconv_t</a> cd)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1103950301084824"><a name="p1103950301084824"></a><a name="p1103950301084824"></a>int </p>
<p id="p1881511508084824"><a name="p1881511508084824"></a><a name="p1881511508084824"></a>Closes a character set conversion descriptor. </p>
</td>
</tr>
<tr id="row585364403084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p513792058084824"><a name="p513792058084824"></a><a name="p513792058084824"></a><a href="io.md#gafe784c4f5d12b74272740c5211c960c5">setlocale</a> (int category, const char *locale)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p210485197084824"><a name="p210485197084824"></a><a name="p210485197084824"></a>char * </p>
<p id="p13592356084824"><a name="p13592356084824"></a><a name="p13592356084824"></a>Sets the current locale information based on input parameters. </p>
</td>
</tr>
<tr id="row2097910131084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1880666779084824"><a name="p1880666779084824"></a><a name="p1880666779084824"></a><a href="io.md#ga69b40f71a20a7c8bd67b9eeeae7f40c9">localeconv</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p413531698084824"><a name="p413531698084824"></a><a name="p413531698084824"></a>struct <a href="lconv.md">lconv</a> * </p>
<p id="p621450640084824"><a name="p621450640084824"></a><a name="p621450640084824"></a>Obtains the locale information about a region and stores them in <a href="lconv.md">lconv</a>. </p>
</td>
</tr>
<tr id="row2012679152084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1367917667084824"><a name="p1367917667084824"></a><a name="p1367917667084824"></a><a href="io.md#gac898c5cfd3f2352d639b8356ff6aa343">catopen</a> (const char *name, int oflag)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p348370947084824"><a name="p348370947084824"></a><a name="p348370947084824"></a><a href="io.md#ga3f305b6699c89f91aecfc0b5f8604a5f">nl_catd</a> </p>
<p id="p262542831084824"><a name="p262542831084824"></a><a name="p262542831084824"></a>Opens a message catalog and returns its descriptor. </p>
</td>
</tr>
<tr id="row605415895084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2019092445084824"><a name="p2019092445084824"></a><a name="p2019092445084824"></a><a href="io.md#gaa615f433a6a187d0ee5ed647efc0e091">catgets</a> (<a href="io.md#ga3f305b6699c89f91aecfc0b5f8604a5f">nl_catd</a> catd, int set_id, int msg_id, const char *s)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1477855234084824"><a name="p1477855234084824"></a><a name="p1477855234084824"></a>char * </p>
<p id="p497475893084824"><a name="p497475893084824"></a><a name="p497475893084824"></a>Obtains information from a message catalog. </p>
</td>
</tr>
<tr id="row621458321084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1773662441084824"><a name="p1773662441084824"></a><a name="p1773662441084824"></a><a href="io.md#ga87f06c3df6f24c6b46a9c7fe13e2cb9c">catclose</a> (<a href="io.md#ga3f305b6699c89f91aecfc0b5f8604a5f">nl_catd</a> catd)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1097288111084824"><a name="p1097288111084824"></a><a name="p1097288111084824"></a>int </p>
<p id="p1174453851084824"><a name="p1174453851084824"></a><a name="p1174453851084824"></a>Closes a catalog descriptor. </p>
</td>
</tr>
<tr id="row239963149084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p684825970084824"><a name="p684825970084824"></a><a name="p684825970084824"></a><a href="io.md#gab7fc0f6be5f13c81de180c1288ba3b6f">poll</a> (struct <a href="pollfd.md">pollfd</a> fds[], <a href="io.md#ga0af7a8bdafcd5532e620a11f0d373d52">nfds_t</a> nfds, int timeout)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p425422899084824"><a name="p425422899084824"></a><a name="p425422899084824"></a>int </p>
<p id="p716683026084824"><a name="p716683026084824"></a><a name="p716683026084824"></a>Defines the I/O multiplexing system. </p>
</td>
</tr>
<tr id="row1179218017084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1516842061084824"><a name="p1516842061084824"></a><a name="p1516842061084824"></a><a href="io.md#ga58386e895d3c07b008c8865b2a9716fb">fopen</a> (const char *__restrict path, const char *__restrict mode)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1715717141084824"><a name="p1715717141084824"></a><a name="p1715717141084824"></a><a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> * </p>
<p id="p371719649084824"><a name="p371719649084824"></a><a name="p371719649084824"></a>Opens the file stored in the specified path based on the given mode. </p>
</td>
</tr>
<tr id="row1827291265084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1279569252084824"><a name="p1279569252084824"></a><a name="p1279569252084824"></a><a href="io.md#gac41a0ad4b31be2ad59d8222a0de30bda">fclose</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *fd)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p659053757084824"><a name="p659053757084824"></a><a name="p659053757084824"></a>int </p>
<p id="p684392219084824"><a name="p684392219084824"></a><a name="p684392219084824"></a>Closes a file based on the specified file descriptor. </p>
</td>
</tr>
<tr id="row470628426084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2142316051084824"><a name="p2142316051084824"></a><a name="p2142316051084824"></a><a href="io.md#ga02b13b56a188401119ea4da43c184913">remove</a> (const char *pathname)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1570113228084824"><a name="p1570113228084824"></a><a name="p1570113228084824"></a>int </p>
<p id="p448481199084824"><a name="p448481199084824"></a><a name="p448481199084824"></a>Deletes a specified file or directory from the file system. </p>
</td>
</tr>
<tr id="row1327572975084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1973112175084824"><a name="p1973112175084824"></a><a name="p1973112175084824"></a><a href="io.md#ga4d4709508ed7604103d77c3fdc5ea4a2">rename</a> (const char *oldpath, const char *newpath)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1717604838084824"><a name="p1717604838084824"></a><a name="p1717604838084824"></a>int </p>
<p id="p337469946084824"><a name="p337469946084824"></a><a name="p337469946084824"></a>Renames a specified file. </p>
</td>
</tr>
<tr id="row887902184084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p10708002084824"><a name="p10708002084824"></a><a name="p10708002084824"></a><a href="io.md#gafb95de1535a5a185954819539f3c6ca5">feof</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *fp)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p887102854084824"><a name="p887102854084824"></a><a name="p887102854084824"></a>int </p>
<p id="p1412099467084824"><a name="p1412099467084824"></a><a name="p1412099467084824"></a>Tests the end-of-file indicator for a specified stream. </p>
</td>
</tr>
<tr id="row1416676680084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p185677424084824"><a name="p185677424084824"></a><a name="p185677424084824"></a><a href="io.md#ga4a98383bb54291c2abede7aa28acf597">ferror</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1146328744084824"><a name="p1146328744084824"></a><a name="p1146328744084824"></a>int </p>
<p id="p1005821997084824"><a name="p1005821997084824"></a><a name="p1005821997084824"></a>Tests for the error identifier of a specified file stream. </p>
</td>
</tr>
<tr id="row1155714177084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p754259785084824"><a name="p754259785084824"></a><a name="p754259785084824"></a><a href="io.md#gae4459e830d3e2abcf428337a661d9456">fflush</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *fp)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p780345308084824"><a name="p780345308084824"></a><a name="p780345308084824"></a>int </p>
<p id="p2130936566084824"><a name="p2130936566084824"></a><a name="p2130936566084824"></a>Flushes the output buffer of a specified stream. </p>
</td>
</tr>
<tr id="row624243618084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1740168660084824"><a name="p1740168660084824"></a><a name="p1740168660084824"></a><a href="io.md#ga81202d6a15259fbceb71a961a878b01a">clearerr</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *fp)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1737616752084824"><a name="p1737616752084824"></a><a name="p1737616752084824"></a>void </p>
<p id="p1922387857084824"><a name="p1922387857084824"></a><a name="p1922387857084824"></a>Resets the error indicators. </p>
</td>
</tr>
<tr id="row933614387084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p985816903084824"><a name="p985816903084824"></a><a name="p985816903084824"></a><a href="io.md#gaece5d6e00c239ffd0847d8d2ef65bd57">fseek</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *fp, long offset, int whence)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p255071366084824"><a name="p255071366084824"></a><a name="p255071366084824"></a>int </p>
<p id="p348719568084824"><a name="p348719568084824"></a><a name="p348719568084824"></a>Changes the position of a specified stream to a new position. </p>
</td>
</tr>
<tr id="row1470190332084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2082255753084824"><a name="p2082255753084824"></a><a name="p2082255753084824"></a><a href="io.md#gaae4231ac8066eb54ea1d9d12d551605c">ftell</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *fp)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2033829946084824"><a name="p2033829946084824"></a><a name="p2033829946084824"></a>long </p>
<p id="p1721419823084824"><a name="p1721419823084824"></a><a name="p1721419823084824"></a>Obtains the current value of the file position indicator for a specified file stream. </p>
</td>
</tr>
<tr id="row128771199084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1829528291084824"><a name="p1829528291084824"></a><a name="p1829528291084824"></a><a href="io.md#gaa0cd401f198d33d9d01a9e8aa4026819">rewind</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1936603246084824"><a name="p1936603246084824"></a><a name="p1936603246084824"></a>void </p>
<p id="p744054960084824"><a name="p744054960084824"></a><a name="p744054960084824"></a>Sets the position indicator of a specified stream to the beginning of the file. </p>
</td>
</tr>
<tr id="row425087878084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1635926327084824"><a name="p1635926327084824"></a><a name="p1635926327084824"></a><a href="io.md#gaf2e2b1a01359f5f7068b61d1dffcdcdd">fgetpos</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream, fpos_t *pos)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p808710137084824"><a name="p808710137084824"></a><a name="p808710137084824"></a>int </p>
<p id="p1906553184084824"><a name="p1906553184084824"></a><a name="p1906553184084824"></a>Obtains the current file position of a specified stream and writes it to the <strong id="b636878242084824"><a name="b636878242084824"></a><a name="b636878242084824"></a>pos</strong> parameter. </p>
</td>
</tr>
<tr id="row1388383037084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2120022434084824"><a name="p2120022434084824"></a><a name="p2120022434084824"></a><a href="io.md#gae47e3f92dd8fc42ce0b6384c03ce6a9b">fsetpos</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *fp, const fpos_t *pos)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p121021241084824"><a name="p121021241084824"></a><a name="p121021241084824"></a>int </p>
<p id="p1647864584084824"><a name="p1647864584084824"></a><a name="p1647864584084824"></a>Sets the file position indicator for a specified file stream. </p>
</td>
</tr>
<tr id="row1228803426084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p261500302084824"><a name="p261500302084824"></a><a name="p261500302084824"></a><a href="io.md#ga091b3f41bdd6984d63ea48d87a62bfd2">fread</a> (void *__restrict ptr, size_t size, size_t nmemb, <a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *__restrict stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1018097527084824"><a name="p1018097527084824"></a><a name="p1018097527084824"></a>size_t </p>
<p id="p1868561900084824"><a name="p1868561900084824"></a><a name="p1868561900084824"></a>Reads data from a specified stream. </p>
</td>
</tr>
<tr id="row316599864084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p904156651084824"><a name="p904156651084824"></a><a name="p904156651084824"></a><a href="io.md#gaf86a4505e5de39a100f7ea828377b585">fwrite</a> (const void *__restrict ptr, size_t size, size_t nmemb, <a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *__restrict stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1601970704084824"><a name="p1601970704084824"></a><a name="p1601970704084824"></a>size_t </p>
<p id="p169861035084824"><a name="p169861035084824"></a><a name="p169861035084824"></a>Writes data to a specified stream. </p>
</td>
</tr>
<tr id="row1509145432084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1793006797084824"><a name="p1793006797084824"></a><a name="p1793006797084824"></a><a href="io.md#gad5a0ea2c21a23a380b7c30fe35fa9456">getc</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1671168614084824"><a name="p1671168614084824"></a><a name="p1671168614084824"></a>int </p>
<p id="p105262108084824"><a name="p105262108084824"></a><a name="p105262108084824"></a>Reads a character from a specified file stream. </p>
</td>
</tr>
<tr id="row1656814383084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1421126934084824"><a name="p1421126934084824"></a><a name="p1421126934084824"></a><a href="io.md#ga3e29caa20f7cffe18f410f01278905a8">getchar</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p308584423084824"><a name="p308584423084824"></a><a name="p308584423084824"></a>int </p>
<p id="p1446558163084824"><a name="p1446558163084824"></a><a name="p1446558163084824"></a>Obtains the next character from the standard input (stdin). </p>
</td>
</tr>
<tr id="row576331887084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p198937461084824"><a name="p198937461084824"></a><a name="p198937461084824"></a><a href="io.md#ga54efa95b6d5b41adec98e5b8a1a9f27b">ungetc</a> (int c, <a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p538867687084824"><a name="p538867687084824"></a><a name="p538867687084824"></a>int </p>
<p id="p1279473295084824"><a name="p1279473295084824"></a><a name="p1279473295084824"></a>Pushes a character back into a specified file stream. </p>
</td>
</tr>
<tr id="row1307350566084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p423528137084824"><a name="p423528137084824"></a><a name="p423528137084824"></a><a href="io.md#gabe6299d5823dd023e610aaa619735a3f">fputc</a> (int c, <a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1354186667084824"><a name="p1354186667084824"></a><a name="p1354186667084824"></a>int </p>
<p id="p1728161881084824"><a name="p1728161881084824"></a><a name="p1728161881084824"></a>Writes a character into the position pointed to by a specified stream. </p>
</td>
</tr>
<tr id="row1727159193084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1017235107084824"><a name="p1017235107084824"></a><a name="p1017235107084824"></a><a href="io.md#ga38f980218f04ebdddcdcd1b77e1cf6b1">putc</a> (int c, <a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1314245062084824"><a name="p1314245062084824"></a><a name="p1314245062084824"></a>int </p>
<p id="p561705048084824"><a name="p561705048084824"></a><a name="p561705048084824"></a>Writes a character to a specified file stream. </p>
</td>
</tr>
<tr id="row1526891958084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1703019937084824"><a name="p1703019937084824"></a><a name="p1703019937084824"></a><a href="io.md#gaf4de2514b7778805db3815e8dd6cf09a">putchar</a> (int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p712498240084824"><a name="p712498240084824"></a><a name="p712498240084824"></a>int </p>
<p id="p2022626810084824"><a name="p2022626810084824"></a><a name="p2022626810084824"></a>Writes a character into the standard output (stdout). </p>
</td>
</tr>
<tr id="row555571063084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1489591233084824"><a name="p1489591233084824"></a><a name="p1489591233084824"></a><a href="io.md#ga2b3df0e66b41edab3c039191fe6cc4f9">fgets</a> (char *s, int size, <a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p674355250084824"><a name="p674355250084824"></a><a name="p674355250084824"></a>char * </p>
<p id="p652625481084824"><a name="p652625481084824"></a><a name="p652625481084824"></a>Reads a line of characters from a specified file stream and stores it into the string pointed to by <strong id="b333234321084824"><a name="b333234321084824"></a><a name="b333234321084824"></a>s</strong>. </p>
</td>
</tr>
<tr id="row1361102194084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1979219028084824"><a name="p1979219028084824"></a><a name="p1979219028084824"></a><a href="io.md#gaab85b30d68ce9d9e0475e0f51bf610b1">gets</a> (char *s)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1549697259084824"><a name="p1549697259084824"></a><a name="p1549697259084824"></a>char * </p>
<p id="p1744899861084824"><a name="p1744899861084824"></a><a name="p1744899861084824"></a>Reads a line of characters from the stdin and stores it in the buffer. </p>
</td>
</tr>
<tr id="row1415158426084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1742216652084824"><a name="p1742216652084824"></a><a name="p1742216652084824"></a><a href="io.md#ga68236e664c1f0da049b25fba1c1695f6">fputs</a> (const char *s, <a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1984984946084824"><a name="p1984984946084824"></a><a name="p1984984946084824"></a>int </p>
<p id="p851606686084824"><a name="p851606686084824"></a><a name="p851606686084824"></a>Writes a character string (excluding the terminating null character) to a specified file stream. </p>
</td>
</tr>
<tr id="row1276569976084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p98974485084824"><a name="p98974485084824"></a><a name="p98974485084824"></a><a href="io.md#gad41876f99f190c7488e64ef39c50a23f">puts</a> (const char *s)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1388070379084824"><a name="p1388070379084824"></a><a name="p1388070379084824"></a>int </p>
<p id="p1382004465084824"><a name="p1382004465084824"></a><a name="p1382004465084824"></a>Writes a character string and appends a new-line character to the stdout. </p>
</td>
</tr>
<tr id="row91549512084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p969972412084824"><a name="p969972412084824"></a><a name="p969972412084824"></a><a href="io.md#ga98631211a4a8aee62f572375d5b637be">printf</a> (const char *format,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p986336953084824"><a name="p986336953084824"></a><a name="p986336953084824"></a>int </p>
<p id="p1735376725084824"><a name="p1735376725084824"></a><a name="p1735376725084824"></a>Formats arguments based on <strong id="b1441709408084824"><a name="b1441709408084824"></a><a name="b1441709408084824"></a>format</strong> and prints formatted data to the stdout. </p>
</td>
</tr>
<tr id="row1049541539084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2103881318084824"><a name="p2103881318084824"></a><a name="p2103881318084824"></a><a href="io.md#gad9291335f34e874c8431285d705bc3aa">fprintf</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream, const char *format,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p355990172084824"><a name="p355990172084824"></a><a name="p355990172084824"></a>int </p>
<p id="p1040355241084824"><a name="p1040355241084824"></a><a name="p1040355241084824"></a>Formats arguments based on <strong id="b1806371598084824"><a name="b1806371598084824"></a><a name="b1806371598084824"></a>format</strong> and prints formatted data to a specified file stream. </p>
</td>
</tr>
<tr id="row2112538585084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1069359320084824"><a name="p1069359320084824"></a><a name="p1069359320084824"></a><a href="io.md#ga3082155ec11e7229f7a20439b31a169e">sprintf</a> (char *str, const char *format,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p871409788084824"><a name="p871409788084824"></a><a name="p871409788084824"></a>int </p>
<p id="p471663953084824"><a name="p471663953084824"></a><a name="p471663953084824"></a>Prints formatted data from a variable argument list to a specified string. </p>
</td>
</tr>
<tr id="row2001781021084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1724965359084824"><a name="p1724965359084824"></a><a name="p1724965359084824"></a><a href="io.md#gad76145a6edfc98981ded8815a760e0cd">snprintf</a> (char *str, size_t size, const char *format,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1958060306084824"><a name="p1958060306084824"></a><a name="p1958060306084824"></a>int </p>
<p id="p2019270173084824"><a name="p2019270173084824"></a><a name="p2019270173084824"></a>Prints formatted data of a maximum of <strong id="b1722004882084824"><a name="b1722004882084824"></a><a name="b1722004882084824"></a>size</strong> bytes from a variable argument list to a specified string. </p>
</td>
</tr>
<tr id="row425313860084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2008916680084824"><a name="p2008916680084824"></a><a name="p2008916680084824"></a><a href="io.md#gaa715ef816dc040c8b367fde4ba84d6f3">vprintf</a> (const char *format, va_list ap)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p44659190084824"><a name="p44659190084824"></a><a name="p44659190084824"></a>int </p>
<p id="p2022008731084824"><a name="p2022008731084824"></a><a name="p2022008731084824"></a>Prints formatted data from a variable argument list to the stdout. </p>
</td>
</tr>
<tr id="row306485017084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p127486552084824"><a name="p127486552084824"></a><a name="p127486552084824"></a><a href="io.md#gad80f05917df38df3a5e1817498d67c26">vfprintf</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream, const char *format, va_list ap)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p781341678084824"><a name="p781341678084824"></a><a name="p781341678084824"></a>int </p>
<p id="p1717745273084824"><a name="p1717745273084824"></a><a name="p1717745273084824"></a>Prints formatted data from a variable argument list to a specified file stream. </p>
</td>
</tr>
<tr id="row709536802084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p447542995084824"><a name="p447542995084824"></a><a name="p447542995084824"></a><a href="io.md#gaab3db67c98c32122fcb3d076d4207bbc">vsprintf</a> (char *str, const char *format, va_list ap)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2043475923084824"><a name="p2043475923084824"></a><a name="p2043475923084824"></a>int </p>
<p id="p1962184453084824"><a name="p1962184453084824"></a><a name="p1962184453084824"></a>Prints formatted data from a variable argument list to a specified string. </p>
</td>
</tr>
<tr id="row1252189247084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2134491661084824"><a name="p2134491661084824"></a><a name="p2134491661084824"></a><a href="io.md#ga2cadafbeb2d6e0d5781f6e5106d41fc2">vsnprintf</a> (char *str, size_t size, const char *format, va_list ap)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p155087003084824"><a name="p155087003084824"></a><a name="p155087003084824"></a>int </p>
<p id="p907715273084824"><a name="p907715273084824"></a><a name="p907715273084824"></a>Prints formatted data of a maximum of <strong id="b384750033084824"><a name="b384750033084824"></a><a name="b384750033084824"></a>size</strong> bytes from a variable argument list to a specified string. </p>
</td>
</tr>
<tr id="row232423438084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p189006990084824"><a name="p189006990084824"></a><a name="p189006990084824"></a><a href="io.md#ga5c48433db9c04031772d5b36e6c4411d">scanf</a> (const char *format,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p772570550084824"><a name="p772570550084824"></a><a name="p772570550084824"></a>int </p>
<p id="p142277029084824"><a name="p142277029084824"></a><a name="p142277029084824"></a>Reads formatted data from the stdin and stores the data to the additional arguments based on <strong id="b1170323621084824"><a name="b1170323621084824"></a><a name="b1170323621084824"></a>format</strong>. </p>
</td>
</tr>
<tr id="row382381702084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1533823470084824"><a name="p1533823470084824"></a><a name="p1533823470084824"></a><a href="io.md#gae902a7b8796799a6e076f07e9d7de045">fscanf</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream, const char *format,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p343869290084824"><a name="p343869290084824"></a><a name="p343869290084824"></a>int </p>
<p id="p891168265084824"><a name="p891168265084824"></a><a name="p891168265084824"></a>Reads formatted data from a specified file stream and stores it based on <strong id="b1374334325084824"><a name="b1374334325084824"></a><a name="b1374334325084824"></a>format</strong> into the locations pointed to by the variable arguments. </p>
</td>
</tr>
<tr id="row1775651534084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p623979149084824"><a name="p623979149084824"></a><a name="p623979149084824"></a><a href="io.md#gaec1e54556dca3bd701d44395d34818dd">sscanf</a> (const char *str, const char *format,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1320077080084824"><a name="p1320077080084824"></a><a name="p1320077080084824"></a>int </p>
<p id="p1489489642084824"><a name="p1489489642084824"></a><a name="p1489489642084824"></a>Reads data from a character string pointed to by <strong id="b605623663084824"><a name="b605623663084824"></a><a name="b605623663084824"></a>str</strong> and stores it based on <strong id="b705317642084824"><a name="b705317642084824"></a><a name="b705317642084824"></a>format</strong> into the locations pointed to by the variable arguments. </p>
</td>
</tr>
<tr id="row290071057084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p190604181084824"><a name="p190604181084824"></a><a name="p190604181084824"></a><a href="io.md#ga40250d63904acd3e898061c9eab6ead3">vscanf</a> (const char *format, va_list ap)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1615186564084824"><a name="p1615186564084824"></a><a name="p1615186564084824"></a>int </p>
<p id="p303716752084824"><a name="p303716752084824"></a><a name="p303716752084824"></a>Reads data from the stdin and stores it based on <strong id="b1496715371084824"><a name="b1496715371084824"></a><a name="b1496715371084824"></a>format</strong> into the locations pointed to by the elements in the variable argument list identified by <strong id="b1719685929084824"><a name="b1719685929084824"></a><a name="b1719685929084824"></a>ap</strong>. </p>
</td>
</tr>
<tr id="row2134775663084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1910710650084824"><a name="p1910710650084824"></a><a name="p1910710650084824"></a><a href="io.md#gabdd32e401e37c9d954f3f0a6907500d9">vfscanf</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream, const char *format, va_list ap)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p472918343084824"><a name="p472918343084824"></a><a name="p472918343084824"></a>int </p>
<p id="p43805900084824"><a name="p43805900084824"></a><a name="p43805900084824"></a>Reads data from a specified file stream and stores it based on <strong id="b406931645084824"><a name="b406931645084824"></a><a name="b406931645084824"></a>format</strong> into the locations pointed to by the elements in the variable argument list identified by <strong id="b1108526364084824"><a name="b1108526364084824"></a><a name="b1108526364084824"></a>ap</strong>. </p>
</td>
</tr>
<tr id="row1845535788084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1238572730084824"><a name="p1238572730084824"></a><a name="p1238572730084824"></a><a href="io.md#gab1c4552aba80fe03c9b45fe27f4331ad">vsscanf</a> (const char *str, const char *format, va_list ap)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2019075068084824"><a name="p2019075068084824"></a><a name="p2019075068084824"></a>int </p>
<p id="p230583600084824"><a name="p230583600084824"></a><a name="p230583600084824"></a>Reads data from a specified string and stores it based on <strong id="b1130806056084824"><a name="b1130806056084824"></a><a name="b1130806056084824"></a>format</strong> into the locations pointed to by the elements in the variable argument list identified by <strong id="b1838635899084824"><a name="b1838635899084824"></a><a name="b1838635899084824"></a>ap</strong>. </p>
</td>
</tr>
<tr id="row748557526084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p270585093084824"><a name="p270585093084824"></a><a name="p270585093084824"></a><a href="io.md#ga80b37b56a5a42139dccaef56da4bf82a">perror</a> (const char *msg)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2021879369084824"><a name="p2021879369084824"></a><a name="p2021879369084824"></a>void </p>
<p id="p57825951084824"><a name="p57825951084824"></a><a name="p57825951084824"></a>Prints the last error occurred during a call to a system or library function to the standard error output stream (stderr). </p>
</td>
</tr>
<tr id="row552960618084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1293259000084824"><a name="p1293259000084824"></a><a name="p1293259000084824"></a><a href="io.md#gaf691eb990d669a9edec8a9ec721ce3bc">setvbuf</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream, char *buf, int mode, size_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p866570128084824"><a name="p866570128084824"></a><a name="p866570128084824"></a>int </p>
<p id="p1138876489084824"><a name="p1138876489084824"></a><a name="p1138876489084824"></a>Sets the mode and size of the buffer for a specified stream. </p>
</td>
</tr>
<tr id="row193310807084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p655049768084824"><a name="p655049768084824"></a><a name="p655049768084824"></a><a href="io.md#ga36d24924e1acc69f9c3ce49a832615fe">setbuf</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream, char *buf)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p39486001084824"><a name="p39486001084824"></a><a name="p39486001084824"></a>void </p>
<p id="p1387660638084824"><a name="p1387660638084824"></a><a name="p1387660638084824"></a>Sets a buffer to be used by a specified stream. </p>
</td>
</tr>
<tr id="row1602533319084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1982229635084824"><a name="p1982229635084824"></a><a name="p1982229635084824"></a><a href="io.md#ga6b2efc6515c53ab5f0c9800c35f65789">fmemopen</a> (void *buf, size_t size, const char *mode)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1428734217084824"><a name="p1428734217084824"></a><a name="p1428734217084824"></a><a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> * </p>
<p id="p1266017127084824"><a name="p1266017127084824"></a><a name="p1266017127084824"></a>Opens a memory stream that allows the access mode specified by <strong id="b678488244084824"><a name="b678488244084824"></a><a name="b678488244084824"></a>mode</strong>. </p>
</td>
</tr>
<tr id="row957942549084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1281439371084824"><a name="p1281439371084824"></a><a name="p1281439371084824"></a><a href="io.md#gac7250554d80d31f4d8ad316c4c3c3c85">open_memstream</a> (char **ptr, size_t *size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p94953286084824"><a name="p94953286084824"></a><a name="p94953286084824"></a><a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> * </p>
<p id="p1808186830084824"><a name="p1808186830084824"></a><a name="p1808186830084824"></a>Opens a stream for writing to a specified buffer. </p>
</td>
</tr>
<tr id="row518150761084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1358478455084824"><a name="p1358478455084824"></a><a name="p1358478455084824"></a><a href="io.md#ga30839d83d780a6a3d13bf40c2d666827">pclose</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *f)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1364783401084824"><a name="p1364783401084824"></a><a name="p1364783401084824"></a>int </p>
<p id="p1472588160084824"><a name="p1472588160084824"></a><a name="p1472588160084824"></a>Closes a specified pipe. </p>
</td>
</tr>
<tr id="row1461918641084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1329662909084824"><a name="p1329662909084824"></a><a name="p1329662909084824"></a><a href="io.md#ga03681b8592bba6fe02941b9abc182808">fileno</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *fp)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1304837324084824"><a name="p1304837324084824"></a><a name="p1304837324084824"></a>int </p>
<p id="p2098007889084824"><a name="p2098007889084824"></a><a name="p2098007889084824"></a>Obtains the file descriptor of a specified file stream. </p>
</td>
</tr>
<tr id="row1998845989084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p115746810084824"><a name="p115746810084824"></a><a name="p115746810084824"></a><a href="io.md#ga6926f47b76b028f112045fbe7ced4115">fseeko</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *fp, off_t offset, int whence)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1688092594084824"><a name="p1688092594084824"></a><a name="p1688092594084824"></a>int </p>
<p id="p1844616740084824"><a name="p1844616740084824"></a><a name="p1844616740084824"></a>Sets the position of the next input or output operation on a specified file stream. </p>
</td>
</tr>
<tr id="row1279104146084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1413286557084824"><a name="p1413286557084824"></a><a name="p1413286557084824"></a><a href="io.md#ga5f52ea043b9a2aa4d8cc92d674a2117b">ftello</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *fp)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p668067171084824"><a name="p668067171084824"></a><a name="p668067171084824"></a>off_t </p>
<p id="p195000082084824"><a name="p195000082084824"></a><a name="p195000082084824"></a>Obtains the current value of the file position indicator for a specified file stream. </p>
</td>
</tr>
<tr id="row1340267015084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1756618638084824"><a name="p1756618638084824"></a><a name="p1756618638084824"></a><a href="io.md#ga5fe0fc8fe920b640d488856c5ca43cb5">dprintf</a> (int fd, const char *format,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1563172189084824"><a name="p1563172189084824"></a><a name="p1563172189084824"></a>int </p>
<p id="p404243766084824"><a name="p404243766084824"></a><a name="p404243766084824"></a>Prints formatted data to a specified file. </p>
</td>
</tr>
<tr id="row502530866084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1797242751084824"><a name="p1797242751084824"></a><a name="p1797242751084824"></a><a href="io.md#ga0d0a950c2b4e6fba795cb7d8f2e8b8b8">vdprintf</a> (int fd, const char *format, va_list ap)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1381939119084824"><a name="p1381939119084824"></a><a name="p1381939119084824"></a>int </p>
<p id="p397779317084824"><a name="p397779317084824"></a><a name="p397779317084824"></a>Prints formatted data from a variable argument list to a specified file. </p>
</td>
</tr>
<tr id="row291362272084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2013792077084824"><a name="p2013792077084824"></a><a name="p2013792077084824"></a><a href="io.md#gab486b89691678e4873ec8b1b15c2678a">ftrylockfile</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *filehandle)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p487505303084824"><a name="p487505303084824"></a><a name="p487505303084824"></a>int </p>
<p id="p102453613084824"><a name="p102453613084824"></a><a name="p102453613084824"></a>Locks a specified file. </p>
</td>
</tr>
<tr id="row2008853958084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1649902511084824"><a name="p1649902511084824"></a><a name="p1649902511084824"></a><a href="io.md#ga4f016c54ff86ca62454417bb7b32ab11">funlockfile</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *filehandle)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p259677000084824"><a name="p259677000084824"></a><a name="p259677000084824"></a>void </p>
<p id="p726225091084824"><a name="p726225091084824"></a><a name="p726225091084824"></a>Unlocks a specified file. </p>
</td>
</tr>
<tr id="row183550400084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p407405858084824"><a name="p407405858084824"></a><a name="p407405858084824"></a><a href="io.md#ga169f9b7e933ba56156885e30f7263b28">getc_unlocked</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p328142053084824"><a name="p328142053084824"></a><a name="p328142053084824"></a>int </p>
<p id="p47839128084824"><a name="p47839128084824"></a><a name="p47839128084824"></a>Obtains a character from a specified file stream without locking the file stream or checking whether it is locked. </p>
</td>
</tr>
<tr id="row853202918084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1674211020084824"><a name="p1674211020084824"></a><a name="p1674211020084824"></a><a href="io.md#gafef7e39f2376c63728163cd5ccfbe99e">getchar_unlocked</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2108117183084824"><a name="p2108117183084824"></a><a name="p2108117183084824"></a>int </p>
<p id="p1164589195084824"><a name="p1164589195084824"></a><a name="p1164589195084824"></a>Obtains the next character from stdin. </p>
</td>
</tr>
<tr id="row1670867781084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p626246818084824"><a name="p626246818084824"></a><a name="p626246818084824"></a><a href="io.md#ga340b21ecb337abb08905095e673672f6">putc_unlocked</a> (int c, <a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p774856201084824"><a name="p774856201084824"></a><a name="p774856201084824"></a>int </p>
<p id="p812132431084824"><a name="p812132431084824"></a><a name="p812132431084824"></a>Writes a character to a specified file stream with the thread remains unlocked. </p>
</td>
</tr>
<tr id="row994243724084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2072307216084824"><a name="p2072307216084824"></a><a name="p2072307216084824"></a><a href="io.md#ga07ff061a8fed45cdedbecdd899b5fdb1">putchar_unlocked</a> (int c)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1155596544084824"><a name="p1155596544084824"></a><a name="p1155596544084824"></a>int </p>
<p id="p712938161084824"><a name="p712938161084824"></a><a name="p712938161084824"></a>Writes a character to the stdout with the thread remains unlocked. </p>
</td>
</tr>
<tr id="row1915894683084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p92755362084824"><a name="p92755362084824"></a><a name="p92755362084824"></a><a href="io.md#gab87a24b4c09e8fc3712a6d6090bfd371">getdelim</a> (char **lineptr, size_t *n, int delim, <a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p135510151084824"><a name="p135510151084824"></a><a name="p135510151084824"></a>ssize_t </p>
<p id="p1096971660084824"><a name="p1096971660084824"></a><a name="p1096971660084824"></a>Reads an entire line from a specified file stream. </p>
</td>
</tr>
<tr id="row1283830441084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p179367471084824"><a name="p179367471084824"></a><a name="p179367471084824"></a><a href="io.md#gaaf07c1bbc2aa081a54bdd66f0e152312">getline</a> (char **lineptr, size_t *n, <a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p942910705084824"><a name="p942910705084824"></a><a name="p942910705084824"></a>ssize_t </p>
<p id="p464478687084824"><a name="p464478687084824"></a><a name="p464478687084824"></a>Reads an entire line from a specified file stream. </p>
</td>
</tr>
<tr id="row1712057004084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1735008467084824"><a name="p1735008467084824"></a><a name="p1735008467084824"></a><a href="io.md#ga44dcf948b2c1dc3356d2937635a27839">tempnam</a> (const char *dir, const char *prefix)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1801557734084824"><a name="p1801557734084824"></a><a name="p1801557734084824"></a>char * </p>
<p id="p192425840084824"><a name="p192425840084824"></a><a name="p192425840084824"></a>Creates a temporary file with a unique file name. </p>
</td>
</tr>
<tr id="row546441385084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p789951265084824"><a name="p789951265084824"></a><a name="p789951265084824"></a><a href="io.md#ga53a57437279b4ed57b7f116dfc9cbbcc">setbuffer</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *f, char *buf, size_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p996150557084824"><a name="p996150557084824"></a><a name="p996150557084824"></a>void </p>
<p id="p829647068084824"><a name="p829647068084824"></a><a name="p829647068084824"></a>Sets the buffer for a specified file stream. </p>
</td>
</tr>
<tr id="row1742675564084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p799734311084824"><a name="p799734311084824"></a><a name="p799734311084824"></a><a href="io.md#ga2e13e101d5a57cfccf1bab51f8768a5d">setlinebuf</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *f)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1008103635084824"><a name="p1008103635084824"></a><a name="p1008103635084824"></a>void </p>
<p id="p407884633084824"><a name="p407884633084824"></a><a name="p407884633084824"></a>Sets the linear buffer for a specified file stream. </p>
</td>
</tr>
<tr id="row171069180084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p89609306084824"><a name="p89609306084824"></a><a name="p89609306084824"></a><a href="io.md#gab11a990e4f8863a1e7736e3c1d430092">fgetc</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p312848790084824"><a name="p312848790084824"></a><a name="p312848790084824"></a>int </p>
<p id="p2048865045084824"><a name="p2048865045084824"></a><a name="p2048865045084824"></a>Reads a character from the file pointed to by <strong id="b368807432084824"><a name="b368807432084824"></a><a name="b368807432084824"></a>stream</strong>. </p>
</td>
</tr>
<tr id="row34652954084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p231530566084824"><a name="p231530566084824"></a><a name="p231530566084824"></a><a href="io.md#ga9b8e6d63482eb1fe38f3eb9d7fc9bd8e">fgetc_unlocked</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2008508549084824"><a name="p2008508549084824"></a><a name="p2008508549084824"></a>int </p>
<p id="p392065677084824"><a name="p392065677084824"></a><a name="p392065677084824"></a>Reads a character from the file pointed to by <strong id="b1840540813084824"><a name="b1840540813084824"></a><a name="b1840540813084824"></a>stream</strong> with the thread remains unlocked. </p>
</td>
</tr>
<tr id="row413427854084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2114747621084824"><a name="p2114747621084824"></a><a name="p2114747621084824"></a><a href="io.md#gab8680ff3f49f3fe7ce0fb78b4cb8394c">fputc_unlocked</a> (int c, <a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p764260357084824"><a name="p764260357084824"></a><a name="p764260357084824"></a>int </p>
<p id="p1754031055084824"><a name="p1754031055084824"></a><a name="p1754031055084824"></a>Writes a character to the file stream pointed to by <strong id="b727013219084824"><a name="b727013219084824"></a><a name="b727013219084824"></a>stream</strong> at the current position. </p>
</td>
</tr>
<tr id="row1097236764084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p289046606084824"><a name="p289046606084824"></a><a name="p289046606084824"></a><a href="io.md#ga089fd72e6218cf6805c8fc21123d3d5f">ferror_unlocked</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p955938818084824"><a name="p955938818084824"></a><a name="p955938818084824"></a>int </p>
<p id="p946321755084824"><a name="p946321755084824"></a><a name="p946321755084824"></a>Tests for the error identifier of a specified file stream. </p>
</td>
</tr>
<tr id="row1935233698084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1491088238084824"><a name="p1491088238084824"></a><a name="p1491088238084824"></a><a href="io.md#ga6d475ead5d1f35e3f14423a99ef3a992">getw</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p655572846084824"><a name="p655572846084824"></a><a name="p655572846084824"></a>int </p>
<p id="p1798685542084824"><a name="p1798685542084824"></a><a name="p1798685542084824"></a>Reads a word (an int value) from a specified file stream. </p>
</td>
</tr>
<tr id="row740116402084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p937456337084824"><a name="p937456337084824"></a><a name="p937456337084824"></a><a href="io.md#gae3a2f96dac9fa87b964b69ff6d5cce46">putw</a> (int w, <a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1983790814084824"><a name="p1983790814084824"></a><a name="p1983790814084824"></a>int </p>
<p id="p1227473032084824"><a name="p1227473032084824"></a><a name="p1227473032084824"></a>Writes a word (an int value) to a specified file stream. </p>
</td>
</tr>
<tr id="row1111791819084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p552445922084824"><a name="p552445922084824"></a><a name="p552445922084824"></a><a href="io.md#ga8e6fe2fcd5eaa8e2d146a50eeaae5b40">fgetln</a> (<a href="io.md#ga912af5ab9f8a52ddd387b7defc0b49f1">FILE</a> *stream, size_t *len)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2136341623084824"><a name="p2136341623084824"></a><a name="p2136341623084824"></a>char * </p>
<p id="p1729377334084824"><a name="p1729377334084824"></a><a name="p1729377334084824"></a>Reads a line of data from the current position of a specified file stream. </p>
</td>
</tr>
<tr id="row73307326084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p558495151084824"><a name="p558495151084824"></a><a name="p558495151084824"></a><a href="io.md#ga1af9acc6b6efdca3576cb8223d95f401">asprintf</a> (char **strp, const char *fmt,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p459718479084824"><a name="p459718479084824"></a><a name="p459718479084824"></a>int </p>
<p id="p1293286081084824"><a name="p1293286081084824"></a><a name="p1293286081084824"></a>Prints formatted data to a specified character string. </p>
</td>
</tr>
<tr id="row639617571084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1441599435084824"><a name="p1441599435084824"></a><a name="p1441599435084824"></a><a href="io.md#ga5ec7fd90ebe6015636bce974c192c86a">vasprintf</a> (char **strp, const char *fmt, va_list ap)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1026879718084824"><a name="p1026879718084824"></a><a name="p1026879718084824"></a>int </p>
<p id="p1046553987084824"><a name="p1046553987084824"></a><a name="p1046553987084824"></a>Prints formatted data from a variable argument list to a specified character string. </p>
</td>
</tr>
<tr id="row1060656045084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p481926878084824"><a name="p481926878084824"></a><a name="p481926878084824"></a><a href="io.md#gaf916439863bed6ba92594e390c227c7e">select</a> (int nfds, <a href="fd_set.md">fd_set</a> *__restrict readfds, <a href="fd_set.md">fd_set</a> *__restrict writefds, <a href="fd_set.md">fd_set</a> *__restrict exceptfds, struct <a href="timeval.md">timeval</a> *__restrict timeout)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1473682853084824"><a name="p1473682853084824"></a><a name="p1473682853084824"></a>int </p>
<p id="p1657052033084824"><a name="p1657052033084824"></a><a name="p1657052033084824"></a>Monitors the I/O events of multiple file descriptors. </p>
</td>
</tr>
<tr id="row1678916935084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p696545345084824"><a name="p696545345084824"></a><a name="p696545345084824"></a><a href="io.md#gaa1952d693ed3c43292566e643ceb9858">readv</a> (int fd, const struct iovec *iov, int iovcnt)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1210756100084824"><a name="p1210756100084824"></a><a name="p1210756100084824"></a>ssize_t </p>
<p id="p1312363572084824"><a name="p1312363572084824"></a><a name="p1312363572084824"></a>Reads the data of <strong id="b1386488365084824"><a name="b1386488365084824"></a><a name="b1386488365084824"></a>fd</strong> to <strong id="b672415787084824"><a name="b672415787084824"></a><a name="b672415787084824"></a>iov</strong>. </p>
</td>
</tr>
<tr id="row748802417084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1760561045084824"><a name="p1760561045084824"></a><a name="p1760561045084824"></a><a href="io.md#gad57f362a0aef72b52ea59288f74dd1ea">writev</a> (int fd, const struct iovec *iov, int iovcnt)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p489591519084824"><a name="p489591519084824"></a><a name="p489591519084824"></a>ssize_t </p>
<p id="p1240122150084824"><a name="p1240122150084824"></a><a name="p1240122150084824"></a>Writes a given length of data into a file. </p>
</td>
</tr>
<tr id="row101271188084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p537766548084824"><a name="p537766548084824"></a><a name="p537766548084824"></a><a href="io.md#ga94adc8dd94a6bdaaa9cf4d9f388418b3">preadv</a> (int fd, const struct iovec *iov, int iovcnt, off_t offset)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p811589113084824"><a name="p811589113084824"></a><a name="p811589113084824"></a>ssize_t </p>
<p id="p1948887010084824"><a name="p1948887010084824"></a><a name="p1948887010084824"></a>Reads the data in a file whose <strong id="b1541727012084824"><a name="b1541727012084824"></a><a name="b1541727012084824"></a>fd</strong> offset is <strong id="b485407921084824"><a name="b485407921084824"></a><a name="b485407921084824"></a>offset</strong> to the multi-group buffer space pointed to by <strong id="b619505679084824"><a name="b619505679084824"></a><a name="b619505679084824"></a>iov</strong>. </p>
</td>
</tr>
<tr id="row414142809084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1626183879084824"><a name="p1626183879084824"></a><a name="p1626183879084824"></a><a href="io.md#ga3de6f9331d6bb930e748bb61860edbd6">pwritev</a> (int fd, const struct iovec *iov, int iovcnt, off_t offset)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1001184926084824"><a name="p1001184926084824"></a><a name="p1001184926084824"></a>ssize_t </p>
<p id="p287414236084824"><a name="p287414236084824"></a><a name="p287414236084824"></a>Writes the data of a multi-group buffer space pointed to by <strong id="b784529610084824"><a name="b784529610084824"></a><a name="b784529610084824"></a>iov</strong> to the offset of <strong id="b1655876194084824"><a name="b1655876194084824"></a><a name="b1655876194084824"></a>fd</strong>. </p>
</td>
</tr>
<tr id="row1366457835084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p85647165084824"><a name="p85647165084824"></a><a name="p85647165084824"></a><a href="io.md#ga1b296371dffe80c14d0c9ebd27165140">wordfree</a> (<a href="wordexp_t.md">wordexp_t</a> *we)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1353560725084824"><a name="p1353560725084824"></a><a name="p1353560725084824"></a>void </p>
<p id="p1911853188084824"><a name="p1911853188084824"></a><a name="p1911853188084824"></a>Frees a word expansion buffer. </p>
</td>
</tr>
</tbody>
</table>

## **Details**<a name="section1747387645084824"></a>

## **Macro Definition Documentation**<a name="section664740196084824"></a>

## FD\_CLR<a name="ga60efc4a969e971f91b7a73bcace62e58"></a>

```
#define FD_CLR( d,  s )   ((s)->fds_bits[(d)/(8*sizeof(long))] &= ~(1UL<<((d)%(8*sizeof(long)))))
```

 **Description:**

Removes a file descriptor from a set. 

**Parameters:**

<a name="table1774380745084824"></a>
<table><thead align="left"><tr id="row2119855132084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1560111977084824"><a name="p1560111977084824"></a><a name="p1560111977084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1448608754084824"><a name="p1448608754084824"></a><a name="p1448608754084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1901911447084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">d</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file descriptor of the <strong id="b1552065383084824"><a name="b1552065383084824"></a><a name="b1552065383084824"></a>int</strong> type. </td>
</tr>
<tr id="row1859976655084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the descriptor set of the <strong id="b1352164763084824"><a name="b1352164763084824"></a><a name="b1352164763084824"></a><a href="fd_set.md">fd_set</a></strong> type. </td>
</tr>
</tbody>
</table>

## FD\_ISSET<a name="ga99a3a0e4d7d1d3eb7be68f37554c0a30"></a>

```
#define FD_ISSET( d,  s )   !!((s)->fds_bits[(d)/(8*sizeof(long))] & (1UL<<((d)%(8*sizeof(long)))))
```

 **Description:**

Checks whether a file descriptor is in a set. 

**Parameters:**

<a name="table1001847787084824"></a>
<table><thead align="left"><tr id="row38102030084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2023858628084824"><a name="p2023858628084824"></a><a name="p2023858628084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p706882551084824"><a name="p706882551084824"></a><a name="p706882551084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row354916221084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">d</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file descriptor of the <strong id="b1623732827084824"><a name="b1623732827084824"></a><a name="b1623732827084824"></a>int</strong> type. </td>
</tr>
<tr id="row1581218066084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the descriptor set of the <strong id="b1723666579084824"><a name="b1723666579084824"></a><a name="b1723666579084824"></a><a href="fd_set.md">fd_set</a></strong> type. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the file descriptor is not in the set; returns  **1**  if the file descriptor is in the set. 



## FD\_SET<a name="gaa7701be461ce602ff7043cbd898a0c53"></a>

```
#define FD_SET( d,  s )   ((s)->fds_bits[(d)/(8*sizeof(long))] |= (1UL<<((d)%(8*sizeof(long)))))
```

 **Description:**

Adds a file descriptor to a set. 

**Parameters:**

<a name="table169321881084824"></a>
<table><thead align="left"><tr id="row350036225084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1447233914084824"><a name="p1447233914084824"></a><a name="p1447233914084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p948980455084824"><a name="p948980455084824"></a><a name="p948980455084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1288083593084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">d</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file descriptor of the <strong id="b403122896084824"><a name="b403122896084824"></a><a name="b403122896084824"></a>int</strong> type. </td>
</tr>
<tr id="row1796208633084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the descriptor set of the <strong id="b655629489084824"><a name="b655629489084824"></a><a name="b655629489084824"></a><a href="fd_set.md">fd_set</a></strong> type. </td>
</tr>
</tbody>
</table>

## FD\_ZERO<a name="ga92ab86a10f942411365b9078833559f0"></a>

```
#define FD_ZERO( s)   do { int __i; unsigned long *__b=(s)->fds_bits; for(__i=sizeof ([fd_set](fd_set.md))/sizeof (long); __i; __i--) *__b++=0; } while(0)
```

 **Description:**

Clears all elements in the file descriptor set. 

**Parameters:**

<a name="table1223134092084824"></a>
<table><thead align="left"><tr id="row922597840084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p428317915084824"><a name="p428317915084824"></a><a name="p428317915084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1829434796084824"><a name="p1829434796084824"></a><a name="p1829434796084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1401841112084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the descriptor set of the <strong id="b526120461084824"><a name="b526120461084824"></a><a name="b526120461084824"></a><a href="fd_set.md">fd_set</a></strong> type. </td>
</tr>
</tbody>
</table>

## **Function Documentation**<a name="section1860532002084824"></a>

## asprintf\(\)<a name="ga1af9acc6b6efdca3576cb8223d95f401"></a>

```
int asprintf (char ** strp, const char * fmt,  ... )
```

 **Description:**

Prints formatted data to a specified character string. 

If the length of the string is uncertain, this function applies for sufficient memory space based on the length of the formatted character string. 

**Parameters:**

<a name="table104236772084824"></a>
<table><thead align="left"><tr id="row1378288563084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p799477396084824"><a name="p799477396084824"></a><a name="p799477396084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p54096475084824"><a name="p54096475084824"></a><a name="p54096475084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2071593427084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">strp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the double pointer to the start address of the target string. </td>
</tr>
<tr id="row1608997656084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fmt</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format string. </td>
</tr>
<tr id="row1009980843084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">...</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the list of arguments corresponding to the format specifiers. </td>
</tr>
</tbody>
</table>

**Attention:**

If  **strp**  is no longer used, the applied space must be released. 

**Returns:**

Returns the number of output characters if the operation is successful; returns  **-1**  otherwise. 



## catclose\(\)<a name="ga87f06c3df6f24c6b46a9c7fe13e2cb9c"></a>

```
int catclose ([nl_catd](io.md#ga3f305b6699c89f91aecfc0b5f8604a5f) catd)
```

 **Description:**

Closes a catalog descriptor. 

**Parameters:**

<a name="table270843608084824"></a>
<table><thead align="left"><tr id="row759226890084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1117757478084824"><a name="p1117757478084824"></a><a name="p1117757478084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1811332877084824"><a name="p1811332877084824"></a><a name="p1811332877084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row694687955084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">catd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the catalog descriptor to close. </td>
</tr>
</tbody>
</table>

**Returns:**

0 



## catgets\(\)<a name="gaa615f433a6a187d0ee5ed647efc0e091"></a>

```
char* catgets ([nl_catd](io.md#ga3f305b6699c89f91aecfc0b5f8604a5f) catd, int set_id, int msg_id, const char * s )
```

 **Description:**

Obtains information from a message catalog. 

**Parameters:**

<a name="table436968435084824"></a>
<table><thead align="left"><tr id="row1977515204084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1637700704084824"><a name="p1637700704084824"></a><a name="p1637700704084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1823149461084824"><a name="p1823149461084824"></a><a name="p1823149461084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row314892302084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">catd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the descriptor of the message catalog. </td>
</tr>
<tr id="row758610499084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">set_id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the setting ID of the message catalog. </td>
</tr>
<tr id="row909739937084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">msg_id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the ID of the message catalog. </td>
</tr>
<tr id="row1282490241084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to a string to be returned if the operation fails. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the information obtained from the message catalog if the operation is successful; returns  **s**  otherwise. 



## catopen\(\)<a name="gac898c5cfd3f2352d639b8356ff6aa343"></a>

```
[nl_catd](io.md#ga3f305b6699c89f91aecfc0b5f8604a5f) catopen (const char * name, int oflag )
```

 **Description:**

Opens a message catalog and returns its descriptor. 

**Parameters:**

<a name="table435662192084824"></a>
<table><thead align="left"><tr id="row336096031084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2024207924084824"><a name="p2024207924084824"></a><a name="p2024207924084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p39977048084824"><a name="p39977048084824"></a><a name="p39977048084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row606935120084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">name</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the path name of the message catalog to open. </td>
</tr>
<tr id="row153144482084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">oflag</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the source of the language to use. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the catalog descriptor if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1160949680084824"></a>
<table><thead align="left"><tr id="row1210187251084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1695512423084824"><a name="p1695512423084824"></a><a name="p1695512423084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1094896638084824"><a name="p1094896638084824"></a><a name="p1094896638084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1433308203084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p471156529084824"><a name="p471156529084824"></a><a name="p471156529084824"></a>EIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p292594822084824"><a name="p292594822084824"></a><a name="p292594822084824"></a>A hardware error occurs at the low-level disk I/O layer. </p>
</td>
</tr>
<tr id="row1341193937084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1687918881084824"><a name="p1687918881084824"></a><a name="p1687918881084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1940401280084824"><a name="p1940401280084824"></a><a name="p1940401280084824"></a>The path name format is invalid. </p>
</td>
</tr>
<tr id="row722267668084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1113439108084824"><a name="p1113439108084824"></a><a name="p1113439108084824"></a>ENOTDIR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p941204998084824"><a name="p941204998084824"></a><a name="p941204998084824"></a>A part of the path prefix is the name of an existing file and is not a catalog. </p>
</td>
</tr>
<tr id="row1086052501084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p790266009084824"><a name="p790266009084824"></a><a name="p790266009084824"></a>EBUSY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1882281423084824"><a name="p1882281423084824"></a><a name="p1882281423084824"></a>The operation is rejected as it does not conform to the file sharing policy. </p>
</td>
</tr>
<tr id="row1996395056084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1740425029084824"><a name="p1740425029084824"></a><a name="p1740425029084824"></a>ENODEV </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p410597522084824"><a name="p410597522084824"></a><a name="p410597522084824"></a>The corresponding device does not exist. </p>
</td>
</tr>
<tr id="row135773181084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p557047760084824"><a name="p557047760084824"></a><a name="p557047760084824"></a>ENFILE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1908209543084824"><a name="p1908209543084824"></a><a name="p1908209543084824"></a>The number of opened files in the system has reached the maximum. </p>
</td>
</tr>
<tr id="row989635275084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p32182452084824"><a name="p32182452084824"></a><a name="p32182452084824"></a>ELOOP </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p446193588084824"><a name="p446193588084824"></a><a name="p446193588084824"></a>Too many symbolic links are encountered. </p>
</td>
</tr>
<tr id="row2004604559084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1819103054084824"><a name="p1819103054084824"></a><a name="p1819103054084824"></a>EFAULT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1223848723084824"><a name="p1223848723084824"></a><a name="p1223848723084824"></a>The memory address is invalid. </p>
</td>
</tr>
<tr id="row1317831850084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p267681494084824"><a name="p267681494084824"></a><a name="p267681494084824"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p180418747084824"><a name="p180418747084824"></a><a name="p180418747084824"></a>Any input parameter is incorrect. </p>
</td>
</tr>
</tbody>
</table>

## clearerr\(\)<a name="ga81202d6a15259fbceb71a961a878b01a"></a>

```
void clearerr ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * fp)
```

 **Description:**

Resets the error indicators. 

This function is used to set both the file error indicator and end-of-file indicator to  **0**. 

**Parameters:**

<a name="table1619428516084824"></a>
<table><thead align="left"><tr id="row624572673084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p445822025084824"><a name="p445822025084824"></a><a name="p445822025084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2601303084824"><a name="p2601303084824"></a><a name="p2601303084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1304043005084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream to set. </td>
</tr>
</tbody>
</table>

## dprintf\(\)<a name="ga5fe0fc8fe920b640d488856c5ca43cb5"></a>

```
int dprintf (int fd, const char * format,  ... )
```

 **Description:**

Prints formatted data to a specified file. 

**Parameters:**

<a name="table618215065084824"></a>
<table><thead align="left"><tr id="row1275717730084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2047599611084824"><a name="p2047599611084824"></a><a name="p2047599611084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1422845721084824"><a name="p1422845721084824"></a><a name="p1422845721084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1070643027084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file descriptor that identifies a file. </td>
</tr>
<tr id="row687874211084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format string. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the total number of written characters if the operation is successful; returns a negative value otherwise. 



## err\(\)<a name="gaa6b66a9a8eb4be40e4424a4dc92ae056"></a>

```
void err (int eval, const char * fmt, va_list args )
```

 **Description:**

Displays error information. 

If the  **fmt**  parameter is not  **NULL**, stderr displays the error code description obtained from strerror\(errno\), followed by a space and a colon \(:\), and the error message to print. 

**Parameters:**

<a name="table1657328018084824"></a>
<table><thead align="left"><tr id="row2056399975084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1709134594084824"><a name="p1709134594084824"></a><a name="p1709134594084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p671118620084824"><a name="p671118620084824"></a><a name="p671118620084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row195516416084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">eval</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">This function does not return, but exits with the value of <strong id="b806080601084824"><a name="b806080601084824"></a><a name="b806080601084824"></a>eval</strong>. </td>
</tr>
<tr id="row876224418084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fmt</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to format. </td>
</tr>
<tr id="row2010430171084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">args</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameters initialized by using <a href="utils.md#gaa0628ab596c3d7e78f5e08c2d98e24da">va_start</a>. </td>
</tr>
</tbody>
</table>

## errx\(\)<a name="gaeaca83913c785b95d6c50f35207ff739"></a>

```
void errx (int eval, const char * fmt,  ... )
```

 **Description:**

Displays error information. 

This function outputs the executable file name  **argv\[0\]**  and the accepted second formal parameter to stderr. 

**Parameters:**

<a name="table118752151084824"></a>
<table><thead align="left"><tr id="row1260211463084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p310584746084824"><a name="p310584746084824"></a><a name="p310584746084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p235575019084824"><a name="p235575019084824"></a><a name="p235575019084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row82105434084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">eval</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">This function does not return, but exits with the value of <strong id="b231384203084824"><a name="b231384203084824"></a><a name="b231384203084824"></a>eval</strong>. </td>
</tr>
<tr id="row148961628084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fmt</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to format. </td>
</tr>
</tbody>
</table>

## fclose\(\)<a name="gac41a0ad4b31be2ad59d8222a0de30bda"></a>

```
int fclose ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * fd)
```

 **Description:**

Closes a file based on the specified file descriptor. 

**Parameters:**

<a name="table2044009387084824"></a>
<table><thead align="left"><tr id="row2041290484084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p255981873084824"><a name="p255981873084824"></a><a name="p255981873084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2111257415084824"><a name="p2111257415084824"></a><a name="p2111257415084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row322399658084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file descriptor of the file to close. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1642275998084824"></a>
<table><thead align="left"><tr id="row456403585084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1147744410084824"><a name="p1147744410084824"></a><a name="p1147744410084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1356410319084824"><a name="p1356410319084824"></a><a name="p1356410319084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row890377344084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p952423371084824"><a name="p952423371084824"></a><a name="p952423371084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1457703517084824"><a name="p1457703517084824"></a><a name="p1457703517084824"></a><strong id="b1218843073084824"><a name="b1218843073084824"></a><a name="b1218843073084824"></a>fd</strong> is <strong id="b819016666084824"><a name="b819016666084824"></a><a name="b819016666084824"></a>NULL</strong>. </p>
</td>
</tr>
</tbody>
</table>

## feof\(\)<a name="gafb95de1535a5a185954819539f3c6ca5"></a>

```
int feof ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * fp)
```

 **Description:**

Tests the end-of-file indicator for a specified stream. 

**Parameters:**

<a name="table526358899084824"></a>
<table><thead align="left"><tr id="row1382716013084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p761699757084824"><a name="p761699757084824"></a><a name="p761699757084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p704311357084824"><a name="p704311357084824"></a><a name="p704311357084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1311767401084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream to test. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value if the end-of-file indicator is set; returns  **0**  otherwise. 



## ferror\(\)<a name="ga4a98383bb54291c2abede7aa28acf597"></a>

```
int ferror ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream)
```

 **Description:**

Tests for the error identifier of a specified file stream. 

**Parameters:**

<a name="table778812214084824"></a>
<table><thead align="left"><tr id="row285951051084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1980289489084824"><a name="p1980289489084824"></a><a name="p1980289489084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1121493554084824"><a name="p1121493554084824"></a><a name="p1121493554084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row683039691084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value to indicate an error for the stream if the operation is successful; returns  **0**  otherwise. 



## ferror\_unlocked\(\)<a name="ga089fd72e6218cf6805c8fc21123d3d5f"></a>

```
int ferror_unlocked ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream)
```

 **Description:**

Tests for the error identifier of a specified file stream. 

**Parameters:**

<a name="table1003680303084824"></a>
<table><thead align="left"><tr id="row1536520694084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p550217371084824"><a name="p550217371084824"></a><a name="p550217371084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1338848966084824"><a name="p1338848966084824"></a><a name="p1338848966084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row342884363084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-zero value to indicate an error for the stream if the operation is successful; returns  **0**  otherwise. 



## fflush\(\)<a name="gae4459e830d3e2abcf428337a661d9456"></a>

```
int fflush ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * fp)
```

 **Description:**

Flushes the output buffer of a specified stream. 

**Parameters:**

<a name="table1668026715084824"></a>
<table><thead align="left"><tr id="row90946209084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1874926552084824"><a name="p1874926552084824"></a><a name="p1874926552084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1449037332084824"><a name="p1449037332084824"></a><a name="p1449037332084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1496983170084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream to flush. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table377204475084824"></a>
<table><thead align="left"><tr id="row1658994276084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p522351306084824"><a name="p522351306084824"></a><a name="p522351306084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1067911947084824"><a name="p1067911947084824"></a><a name="p1067911947084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1349781967084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p411879517084824"><a name="p411879517084824"></a><a name="p411879517084824"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1665377895084824"><a name="p1665377895084824"></a><a name="p1665377895084824"></a><strong id="b494093426084824"><a name="b494093426084824"></a><a name="b494093426084824"></a>fp</strong> points to an invalid stream. </p>
</td>
</tr>
</tbody>
</table>

## fgetc\(\)<a name="gab11a990e4f8863a1e7736e3c1d430092"></a>

```
int fgetc ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream)
```

 **Description:**

Reads a character from the file pointed to by  **stream**. 

This function reads the next character from the current position of the file stream and returns the character, then advances the file position indicator. You can read each character of the file by continuously calling this function. 

**Parameters:**

<a name="table760566926084824"></a>
<table><thead align="left"><tr id="row147465280084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1555051185084824"><a name="p1555051185084824"></a><a name="p1555051185084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p901360833084824"><a name="p901360833084824"></a><a name="p901360833084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1060256206084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the character read as an int value if the operation is successful; returns  **EOF**  if the end-of-file is reached or a reading error occurs. 



## fgetc\_unlocked\(\)<a name="ga9b8e6d63482eb1fe38f3eb9d7fc9bd8e"></a>

```
int fgetc_unlocked ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream)
```

 **Description:**

Reads a character from the file pointed to by  **stream**  with the thread remains unlocked. 

This function reads the next character from the current position of the file stream and returns the character, then advances the file position indicator. You can read each character of the file by continuously calling this function. 

**Parameters:**

<a name="table1207237026084824"></a>
<table><thead align="left"><tr id="row667249207084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p454543596084824"><a name="p454543596084824"></a><a name="p454543596084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1798611655084824"><a name="p1798611655084824"></a><a name="p1798611655084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row13113888084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Attention:**

This function cannot be used in a multi-thread process because it does not use locking during the call. \(It does not set locks itself, and does not test for the presence of locks set by others.\) An error occurs upon a multi-thread operation. 

**Returns:**

Returns the character read as an int value if the operation is successful; returns  **EOF**  if the end-of-file is reached or a reading error occurs. 



## fgetln\(\)<a name="ga8e6fe2fcd5eaa8e2d146a50eeaae5b40"></a>

```
char* fgetln ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream, size_t * len )
```

 **Description:**

Reads a line of data from the current position of a specified file stream. 

**Parameters:**

<a name="table1772999065084824"></a>
<table><thead align="left"><tr id="row481037013084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p337442233084824"><a name="p337442233084824"></a><a name="p337442233084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1242657925084824"><a name="p1242657925084824"></a><a name="p1242657925084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2001116664084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
<tr id="row826776249084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">len</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the length of the string that is read. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the string read. 



## fgetpos\(\)<a name="gaf2e2b1a01359f5f7068b61d1dffcdcdd"></a>

```
int fgetpos ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream, fpos_t * pos )
```

 **Description:**

Obtains the current file position of a specified stream and writes it to the  **pos**  parameter. 

**Parameters:**

<a name="table33937501084824"></a>
<table><thead align="left"><tr id="row1857947584084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p130850821084824"><a name="p130850821084824"></a><a name="p130850821084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p607091791084824"><a name="p607091791084824"></a><a name="p607091791084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row743362753084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
<tr id="row185391886084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the <strong id="b1452351084084824"><a name="b1452351084084824"></a><a name="b1452351084084824"></a>fpos_t</strong> object. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns a non-zero value otherwise. 



## fgets\(\)<a name="ga2b3df0e66b41edab3c039191fe6cc4f9"></a>

```
char* fgets (char * s, int size, [FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream )
```

 **Description:**

Reads a line of characters from a specified file stream and stores it into the string pointed to by  **s**. 

**Parameters:**

<a name="table1252895262084824"></a>
<table><thead align="left"><tr id="row384933580084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1395510908084824"><a name="p1395510908084824"></a><a name="p1395510908084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1217646036084824"><a name="p1217646036084824"></a><a name="p1217646036084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row15760923084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the character array for storing the obtained string. </td>
</tr>
<tr id="row1140509723084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum number of characters to read (including the terminating null character). The value of this parameter is usually the length of the array pointed to by <strong id="b1128200873084824"><a name="b1128200873084824"></a><a name="b1128200873084824"></a>s</strong>. </td>
</tr>
<tr id="row1922631386084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the read string if the operation is successful; returns a null pointer if the end-of-file is reached, no characters have been read, or if an error occurs. 



## fileno\(\)<a name="ga03681b8592bba6fe02941b9abc182808"></a>

```
int fileno ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * fp)
```

 **Description:**

Obtains the file descriptor of a specified file stream. 

**Parameters:**

<a name="table18510950084824"></a>
<table><thead align="left"><tr id="row894423448084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1215503229084824"><a name="p1215503229084824"></a><a name="p1215503229084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1932061694084824"><a name="p1932061694084824"></a><a name="p1932061694084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row783172370084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream for which the file descriptor is obtained. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the file descriptor if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table1533030949084824"></a>
<table><thead align="left"><tr id="row1754478235084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p153587371084824"><a name="p153587371084824"></a><a name="p153587371084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p87335849084824"><a name="p87335849084824"></a><a name="p87335849084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1998049355084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2128566749084824"><a name="p2128566749084824"></a><a name="p2128566749084824"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p693883594084824"><a name="p693883594084824"></a><a name="p693883594084824"></a><strong id="b768505741084824"><a name="b768505741084824"></a><a name="b768505741084824"></a>fp</strong> points to an invalid stream. </p>
</td>
</tr>
</tbody>
</table>

## fmemopen\(\)<a name="ga6b2efc6515c53ab5f0c9800c35f65789"></a>

```
[FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1)* fmemopen (void * buf, size_t size, const char * mode )
```

 **Description:**

Opens a memory stream that allows the access mode specified by  **mode**. 

This function is used for applications that do not support memory operations but support file operations. After the function call, you can directly operate the returned file stream, which is equivalent to operating the memory stream. 

**Parameters:**

<a name="table491253281084824"></a>
<table><thead align="left"><tr id="row1875372150084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1741683172084824"><a name="p1741683172084824"></a><a name="p1741683172084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p593117798084824"><a name="p593117798084824"></a><a name="p593117798084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1294920473084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the buffer. </td>
</tr>
<tr id="row418552503084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the buffer. </td>
</tr>
<tr id="row1416470699084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">mode</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file operation mode. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the opened memory stream as a file stream. 



## fopen\(\)<a name="ga58386e895d3c07b008c8865b2a9716fb"></a>

```
[FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1)* fopen (const char *__restrict path, const char *__restrict mode )
```

 **Description:**

Opens the file stored in the specified path based on the given mode. 

**Parameters:**

<a name="table1576386759084824"></a>
<table><thead align="left"><tr id="row899252657084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1710509169084824"><a name="p1710509169084824"></a><a name="p1710509169084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1528021906084824"><a name="p1528021906084824"></a><a name="p1528021906084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row161624638084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">path</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the path of the file to open. </td>
</tr>
<tr id="row81342633084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">mode</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file access mode. The following table describes the available values. </td>
</tr>
</tbody>
</table>

<a name="table1362772358084824"></a>
<table><thead align="left"><tr id="row1697037908084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p996296564084824"><a name="p996296564084824"></a><a name="p996296564084824"></a>mode </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p34935951084824"><a name="p34935951084824"></a><a name="p34935951084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1567729057084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1910210565084824"><a name="p1910210565084824"></a><a name="p1910210565084824"></a>"r" </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1301464803084824"><a name="p1301464803084824"></a><a name="p1301464803084824"></a>Open a file in read-only mode. The file must exist. </p>
</td>
</tr>
<tr id="row598795442084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p202421949084824"><a name="p202421949084824"></a><a name="p202421949084824"></a>"w" </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1276372765084824"><a name="p1276372765084824"></a><a name="p1276372765084824"></a>Open a file in write-only mode. The file is created if it does not exist. If the file already exists, its existing contents will be cleared. </p>
</td>
</tr>
<tr id="row1062670292084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1025170715084824"><a name="p1025170715084824"></a><a name="p1025170715084824"></a>"a" </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2116040118084824"><a name="p2116040118084824"></a><a name="p2116040118084824"></a>Open a write-only file in append mode. The file is created if it does not exist. If the file already exists, new contents will be written at the end of the file. </p>
</td>
</tr>
<tr id="row206214857084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p430254392084824"><a name="p430254392084824"></a><a name="p430254392084824"></a>"r+" </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1164861626084824"><a name="p1164861626084824"></a><a name="p1164861626084824"></a>Open a file in read and write mode. The file must exist. </p>
</td>
</tr>
<tr id="row1360317568084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p979402663084824"><a name="p979402663084824"></a><a name="p979402663084824"></a>"w+" </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1244183059084824"><a name="p1244183059084824"></a><a name="p1244183059084824"></a>Open a file for both reading and writing. The file is created if it does not exist. If the file already exists, its contents are cleared. </p>
</td>
</tr>
<tr id="row2014744526084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p914916243084824"><a name="p914916243084824"></a><a name="p914916243084824"></a>"a+" </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p699743907084824"><a name="p699743907084824"></a><a name="p699743907084824"></a>Open a file in append mode for both reading and writing. The file is created if it does not exist. If the file already exists, new contents will be written at the end of the file. </p>
</td>
</tr>
<tr id="row898493103084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p859840906084824"><a name="p859840906084824"></a><a name="p859840906084824"></a>"rb" </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p508427160084824"><a name="p508427160084824"></a><a name="p508427160084824"></a>Open a binary file in read-only mode. </p>
</td>
</tr>
<tr id="row1977249951084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p364712672084824"><a name="p364712672084824"></a><a name="p364712672084824"></a>"wb" </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p144430732084824"><a name="p144430732084824"></a><a name="p144430732084824"></a>Open or create a binary file in write-only mode. </p>
</td>
</tr>
<tr id="row1580032119084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1136292892084824"><a name="p1136292892084824"></a><a name="p1136292892084824"></a>"ab" </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1857096716084824"><a name="p1857096716084824"></a><a name="p1857096716084824"></a>Open a binary file in append mode and write data at the end of the file. </p>
</td>
</tr>
<tr id="row1366277968084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1914263117084824"><a name="p1914263117084824"></a><a name="p1914263117084824"></a>"rb+" </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p524514106084824"><a name="p524514106084824"></a><a name="p524514106084824"></a>Open a binary file in read and write mode. The file must exist. </p>
</td>
</tr>
<tr id="row655931286084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1121295920084824"><a name="p1121295920084824"></a><a name="p1121295920084824"></a>"wb+" </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p430401080084824"><a name="p430401080084824"></a><a name="p430401080084824"></a>Open or create a binary file in read and write mode. </p>
</td>
</tr>
<tr id="row1442238175084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p45545616084824"><a name="p45545616084824"></a><a name="p45545616084824"></a>"ab+" </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1242060556084824"><a name="p1242060556084824"></a><a name="p1242060556084824"></a>Open a binary file in append mode for wring data at the end of the file. The file is also readable. </p>
</td>
</tr>
<tr id="row487522956084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p155337122084824"><a name="p155337122084824"></a><a name="p155337122084824"></a>"rt" </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1053497922084824"><a name="p1053497922084824"></a><a name="p1053497922084824"></a>Open a text file in read-only mode. </p>
</td>
</tr>
<tr id="row1130812998084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1431017298084824"><a name="p1431017298084824"></a><a name="p1431017298084824"></a>"wt" </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1787016154084824"><a name="p1787016154084824"></a><a name="p1787016154084824"></a>Open or create a text file in write-only mode. </p>
</td>
</tr>
<tr id="row2032523962084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1750186315084824"><a name="p1750186315084824"></a><a name="p1750186315084824"></a>"at" </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1202204307084824"><a name="p1202204307084824"></a><a name="p1202204307084824"></a>Open a text file in append mode and write data at the end of the file. </p>
</td>
</tr>
<tr id="row1513229681084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1288151948084824"><a name="p1288151948084824"></a><a name="p1288151948084824"></a>"rt+" </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p843774248084824"><a name="p843774248084824"></a><a name="p843774248084824"></a>Open a text file in read and write mode. </p>
</td>
</tr>
<tr id="row575781168084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1929051269084824"><a name="p1929051269084824"></a><a name="p1929051269084824"></a>"wt+" </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1754980247084824"><a name="p1754980247084824"></a><a name="p1754980247084824"></a>Open or create a text file in read and write mode. </p>
</td>
</tr>
<tr id="row1110061494084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1642202473084824"><a name="p1642202473084824"></a><a name="p1642202473084824"></a>"at+" </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p951764064084824"><a name="p951764064084824"></a><a name="p951764064084824"></a>Open a text file in append mode for writing data at the end of the file. The file is also readable. </p>
</td>
</tr>
</tbody>
</table>

**Attention:**

This function can NOT be used in the PROC file system to create a file. 

**Returns:**

Returns the pointer to the file if the operation is successful; returns  **NULL**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1490884769084824"></a>
<table><thead align="left"><tr id="row2112812737084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1752666470084824"><a name="p1752666470084824"></a><a name="p1752666470084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p461798962084824"><a name="p461798962084824"></a><a name="p461798962084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1346710944084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1175360506084824"><a name="p1175360506084824"></a><a name="p1175360506084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p923154057084824"><a name="p923154057084824"></a><a name="p923154057084824"></a>Invalid mode. </p>
</td>
</tr>
<tr id="row2014396619084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1920876678084824"><a name="p1920876678084824"></a><a name="p1920876678084824"></a>EMFILE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p176099678084824"><a name="p176099678084824"></a><a name="p176099678084824"></a>The number of opened files exceeds the maximum number. </p>
</td>
</tr>
</tbody>
</table>

## fprintf\(\)<a name="gad9291335f34e874c8431285d705bc3aa"></a>

```
int fprintf ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream, const char * format,  ... )
```

 **Description:**

Formats arguments based on  **format**  and prints formatted data to a specified file stream. 

**Parameters:**

<a name="table1676535658084824"></a>
<table><thead align="left"><tr id="row929791226084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p357445191084824"><a name="p357445191084824"></a><a name="p357445191084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p847880966084824"><a name="p847880966084824"></a><a name="p847880966084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row996687712084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
<tr id="row1304744146084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format string. </td>
</tr>
<tr id="row1159671864084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">...</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the list of arguments corresponding to the format specifiers. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the total number of characters \(excluding the terminating null character  **'\\0'**\) if the operation is successful; returns a negative value otherwise. 



## fputc\(\)<a name="gabe6299d5823dd023e610aaa619735a3f"></a>

```
int fputc (int c, [FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream )
```

 **Description:**

Writes a character into the position pointed to by a specified stream. 

**Parameters:**

<a name="table1005529503084824"></a>
<table><thead align="left"><tr id="row1247792386084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p341782325084824"><a name="p341782325084824"></a><a name="p341782325084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1623679028084824"><a name="p1623679028084824"></a><a name="p1623679028084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row651593741084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the int promotion of the character to write. </td>
</tr>
<tr id="row2089070348084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the ASCII code of the character written if the operation is successful; returns  **EOF**  otherwise. 



## fputc\_unlocked\(\)<a name="gab8680ff3f49f3fe7ce0fb78b4cb8394c"></a>

```
int fputc_unlocked (int c, [FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream )
```

 **Description:**

Writes a character to the file stream pointed to by  **stream**  at the current position. 

**Parameters:**

<a name="table1375109376084824"></a>
<table><thead align="left"><tr id="row2056970453084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1011733562084824"><a name="p1011733562084824"></a><a name="p1011733562084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p760392350084824"><a name="p760392350084824"></a><a name="p760392350084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1555017082084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the int promotion of the character to write. </td>
</tr>
<tr id="row913732114084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file stream. </td>
</tr>
</tbody>
</table>

**Attention:**

This function cannot be used in a multi-thread process because it does not use locking during the call. \(It does not set locks itself, and does not test for the presence of locks set by others.\) An error occurs upon a multi-thread operation. 

**Returns:**

Returns the ASCII code of the character written if the operation is successful; returns  **EOF**  otherwise. 



## fputs\(\)<a name="ga68236e664c1f0da049b25fba1c1695f6"></a>

```
int fputs (const char * s, [FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream )
```

 **Description:**

Writes a character string \(excluding the terminating null character\) to a specified file stream. 

**Parameters:**

<a name="table1222539475084824"></a>
<table><thead align="left"><tr id="row678254584084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p84393059084824"><a name="p84393059084824"></a><a name="p84393059084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1282926732084824"><a name="p1282926732084824"></a><a name="p1282926732084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row884246359084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the character string to write. </td>
</tr>
<tr id="row1669672277084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-negative value if the operation is successful; returns  **EOF**  otherwise. 



## fread\(\)<a name="ga091b3f41bdd6984d63ea48d87a62bfd2"></a>

```
size_t fread (void *__restrict ptr, size_t size, size_t nmemb, [FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) *__restrict stream )
```

 **Description:**

Reads data from a specified stream. 

**Parameters:**

<a name="table1905010941084824"></a>
<table><thead align="left"><tr id="row1455541974084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1943743970084824"><a name="p1943743970084824"></a><a name="p1943743970084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1330770073084824"><a name="p1330770073084824"></a><a name="p1330770073084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1136401230084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the array for storing the read data. </td>
</tr>
<tr id="row1265051435084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of each element to read, in bytes. </td>
</tr>
<tr id="row463458546084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nmemb</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of elements to read. </td>
</tr>
<tr id="row986952288084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream to read. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if  **size**  or  **nmemb**  is  **0**; returns the number of elements successfully read otherwise. This function sets  **errno**  to a value in the following table if a reading error occurs or the end-of-file is reached \(**fread**  does not distinguish the two error reporting situations, and you can call  **feof**  and  **ferror**  to determine the specific situation\). 

<a name="table1635104771084824"></a>
<table><thead align="left"><tr id="row962729998084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p644890894084824"><a name="p644890894084824"></a><a name="p644890894084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p594664057084824"><a name="p594664057084824"></a><a name="p594664057084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1895369116084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p906588073084824"><a name="p906588073084824"></a><a name="p906588073084824"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1017617975084824"><a name="p1017617975084824"></a><a name="p1017617975084824"></a><strong id="b1101974061084824"><a name="b1101974061084824"></a><a name="b1101974061084824"></a>stream</strong> points to an invalid stream. </p>
</td>
</tr>
<tr id="row321445178084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p375154787084824"><a name="p375154787084824"></a><a name="p375154787084824"></a>EEOF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p92062500084824"><a name="p92062500084824"></a><a name="p92062500084824"></a>The end-of-file is reached. </p>
</td>
</tr>
</tbody>
</table>

## fscanf\(\)<a name="gae902a7b8796799a6e076f07e9d7de045"></a>

```
int fscanf ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream, const char * format,  ... )
```

 **Description:**

Reads formatted data from a specified file stream and stores it based on  **format**  into the locations pointed to by the variable arguments. 

The operation ends when a space or line feed character is encountered. 

**Parameters:**

<a name="table352147379084824"></a>
<table><thead align="left"><tr id="row546859711084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p295115222084824"><a name="p295115222084824"></a><a name="p295115222084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1237633159084824"><a name="p1237633159084824"></a><a name="p1237633159084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1904440377084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
<tr id="row354329269084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format string. </td>
</tr>
<tr id="row727054181084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">...</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the list of arguments corresponding to the format specifiers. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of variables that are successfully read. If the matching fails quickly, the return value may be less than the number of members in the argument list or even zero. If no complete conversion format is available or the input format fails to be matched,  **EOF**  is returned. The return value is also  **EOF**  if a reading error occurs. 



## fseek\(\)<a name="gaece5d6e00c239ffd0847d8d2ef65bd57"></a>

```
int fseek ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * fp, long offset, int whence )
```

 **Description:**

Changes the position of a specified stream to a new position. 

**Parameters:**

<a name="table1144228230084824"></a>
<table><thead align="left"><tr id="row1320455424084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2056642322084824"><a name="p2056642322084824"></a><a name="p2056642322084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1678570878084824"><a name="p1678570878084824"></a><a name="p1678570878084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1745414136084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream for which the position is to set. </td>
</tr>
<tr id="row2107480219084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the offset that determines the position. </td>
</tr>
<tr id="row1976299235084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">whence</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start position of the offset. The following table describes the available values. </td>
</tr>
</tbody>
</table>

<a name="table461901605084824"></a>
<table><thead align="left"><tr id="row257377075084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2009543626084824"><a name="p2009543626084824"></a><a name="p2009543626084824"></a>value </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p403149874084824"><a name="p403149874084824"></a><a name="p403149874084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1068705398084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1209927998084824"><a name="p1209927998084824"></a><a name="p1209927998084824"></a>SEEK_SET </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1953728347084824"><a name="p1953728347084824"></a><a name="p1953728347084824"></a>Beginning of the file </p>
</td>
</tr>
<tr id="row2039537057084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p847220295084824"><a name="p847220295084824"></a><a name="p847220295084824"></a>SEEK_CUR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1310472546084824"><a name="p1310472546084824"></a><a name="p1310472546084824"></a>Current position </p>
</td>
</tr>
<tr id="row802931605084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1167284439084824"><a name="p1167284439084824"></a><a name="p1167284439084824"></a>SEEK_END </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2136926724084824"><a name="p2136926724084824"></a><a name="p2136926724084824"></a>End of the file </p>
</td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table363842080084824"></a>
<table><thead align="left"><tr id="row595652483084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1405051112084824"><a name="p1405051112084824"></a><a name="p1405051112084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p151677400084824"><a name="p151677400084824"></a><a name="p151677400084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1169776398084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1766480501084824"><a name="p1766480501084824"></a><a name="p1766480501084824"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1989820768084824"><a name="p1989820768084824"></a><a name="p1989820768084824"></a><strong id="b1295524916084824"><a name="b1295524916084824"></a><a name="b1295524916084824"></a>fp</strong> points to an invalid stream. </p>
</td>
</tr>
<tr id="row362145748084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p426410633084824"><a name="p426410633084824"></a><a name="p426410633084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p154788739084824"><a name="p154788739084824"></a><a name="p154788739084824"></a>The value of <strong id="b1304821324084824"><a name="b1304821324084824"></a><a name="b1304821324084824"></a>whence</strong> is not <strong id="b564891487084824"><a name="b564891487084824"></a><a name="b564891487084824"></a>SEEK_SET</strong>, <strong id="b466038311084824"><a name="b466038311084824"></a><a name="b466038311084824"></a>SEEK_END</strong>, or <strong id="b1107483169084824"><a name="b1107483169084824"></a><a name="b1107483169084824"></a>SEEK_CUR</strong>. </p>
</td>
</tr>
<tr id="row505232827084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p432881786084824"><a name="p432881786084824"></a><a name="p432881786084824"></a>ESPIPE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1224630490084824"><a name="p1224630490084824"></a><a name="p1224630490084824"></a>Invalid seek. </p>
</td>
</tr>
</tbody>
</table>

## fseeko\(\)<a name="ga6926f47b76b028f112045fbe7ced4115"></a>

```
int fseeko ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * fp, off_t offset, int whence )
```

 **Description:**

Sets the position of the next input or output operation on a specified file stream. 

**Parameters:**

<a name="table1021531806084824"></a>
<table><thead align="left"><tr id="row1075342603084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1171165321084824"><a name="p1171165321084824"></a><a name="p1171165321084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2146749948084824"><a name="p2146749948084824"></a><a name="p2146749948084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1459716722084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream for which the position is to set. </td>
</tr>
<tr id="row1597494346084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the offset that determines the next operation. </td>
</tr>
<tr id="row1920121511084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">whence</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start position of the offset. The following table describes the available values. </td>
</tr>
</tbody>
</table>

<a name="table1725899372084824"></a>
<table><thead align="left"><tr id="row1857924598084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2104635173084824"><a name="p2104635173084824"></a><a name="p2104635173084824"></a>value </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p926548554084824"><a name="p926548554084824"></a><a name="p926548554084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1447406032084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p35694286084824"><a name="p35694286084824"></a><a name="p35694286084824"></a>SEEK_SET </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p348807792084824"><a name="p348807792084824"></a><a name="p348807792084824"></a>Beginning of the file </p>
</td>
</tr>
<tr id="row1637296128084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p785384602084824"><a name="p785384602084824"></a><a name="p785384602084824"></a>SEEK_CUR </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p537584699084824"><a name="p537584699084824"></a><a name="p537584699084824"></a>Current position </p>
</td>
</tr>
<tr id="row2043220634084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1589492207084824"><a name="p1589492207084824"></a><a name="p1589492207084824"></a>SEEK_END </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1125198982084824"><a name="p1125198982084824"></a><a name="p1125198982084824"></a>End of the file </p>
</td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1996427184084824"></a>
<table><thead align="left"><tr id="row1410880878084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1863120677084824"><a name="p1863120677084824"></a><a name="p1863120677084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1493989890084824"><a name="p1493989890084824"></a><a name="p1493989890084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1795488630084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p139753032084824"><a name="p139753032084824"></a><a name="p139753032084824"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p916982324084824"><a name="p916982324084824"></a><a name="p916982324084824"></a><strong id="b493210783084824"><a name="b493210783084824"></a><a name="b493210783084824"></a>fp</strong> points to an invalid stream. </p>
</td>
</tr>
<tr id="row993128608084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p241983663084824"><a name="p241983663084824"></a><a name="p241983663084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p347636126084824"><a name="p347636126084824"></a><a name="p347636126084824"></a>The value of <strong id="b948944561084824"><a name="b948944561084824"></a><a name="b948944561084824"></a>whence</strong> is not <strong id="b21880890084824"><a name="b21880890084824"></a><a name="b21880890084824"></a>SEEK_SET</strong>, <strong id="b838865876084824"><a name="b838865876084824"></a><a name="b838865876084824"></a>SEEK_END</strong>, or <strong id="b2009435712084824"><a name="b2009435712084824"></a><a name="b2009435712084824"></a>SEEK_CUR</strong>. </p>
</td>
</tr>
<tr id="row751770326084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2133621487084824"><a name="p2133621487084824"></a><a name="p2133621487084824"></a>ESPIPE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p218842335084824"><a name="p218842335084824"></a><a name="p218842335084824"></a>Invalid seek. </p>
</td>
</tr>
</tbody>
</table>

## fsetpos\(\)<a name="gae47e3f92dd8fc42ce0b6384c03ce6a9b"></a>

```
int fsetpos ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * fp, const fpos_t * pos )
```

 **Description:**

Sets the file position indicator for a specified file stream. 

**Parameters:**

<a name="table1211231126084824"></a>
<table><thead align="left"><tr id="row244824827084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p500145371084824"><a name="p500145371084824"></a><a name="p500145371084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p791150582084824"><a name="p791150582084824"></a><a name="p791150582084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1690067190084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream for which the position is to set. </td>
</tr>
<tr id="row1811669159084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the position to set. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns a non-zero value and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1841463791084824"></a>
<table><thead align="left"><tr id="row1720519671084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p63822774084824"><a name="p63822774084824"></a><a name="p63822774084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1046034074084824"><a name="p1046034074084824"></a><a name="p1046034074084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1047411244084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p955610389084824"><a name="p955610389084824"></a><a name="p955610389084824"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1321830094084824"><a name="p1321830094084824"></a><a name="p1321830094084824"></a><strong id="b1569132511084824"><a name="b1569132511084824"></a><a name="b1569132511084824"></a>fp</strong> points to an invalid stream. </p>
</td>
</tr>
<tr id="row394322462084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1788454122084824"><a name="p1788454122084824"></a><a name="p1788454122084824"></a>ESPIPE </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p355278229084824"><a name="p355278229084824"></a><a name="p355278229084824"></a>Invalid seek. </p>
</td>
</tr>
</tbody>
</table>

## ftell\(\)<a name="gaae4231ac8066eb54ea1d9d12d551605c"></a>

```
long ftell ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * fp)
```

 **Description:**

Obtains the current value of the file position indicator for a specified file stream. 

**Parameters:**

<a name="table243539161084824"></a>
<table><thead align="left"><tr id="row1307022887084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p645226562084824"><a name="p645226562084824"></a><a name="p645226562084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1407871558084824"><a name="p1407871558084824"></a><a name="p1407871558084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row276994318084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream for which the position is to obtain. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the current offset if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table570081159084824"></a>
<table><thead align="left"><tr id="row649188007084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p10163732084824"><a name="p10163732084824"></a><a name="p10163732084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p41600827084824"><a name="p41600827084824"></a><a name="p41600827084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row336335513084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1347707155084824"><a name="p1347707155084824"></a><a name="p1347707155084824"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p360279603084824"><a name="p360279603084824"></a><a name="p360279603084824"></a><strong id="b1725356406084824"><a name="b1725356406084824"></a><a name="b1725356406084824"></a>fp</strong> points to an invalid stream. </p>
</td>
</tr>
</tbody>
</table>

## ftello\(\)<a name="ga5f52ea043b9a2aa4d8cc92d674a2117b"></a>

```
off_t ftello ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * fp)
```

 **Description:**

Obtains the current value of the file position indicator for a specified file stream. 

**Parameters:**

<a name="table1933181945084824"></a>
<table><thead align="left"><tr id="row409037396084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p952341646084824"><a name="p952341646084824"></a><a name="p952341646084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2039613476084824"><a name="p2039613476084824"></a><a name="p2039613476084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1241116716084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream for which the position is to obtain. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the current offset if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1375335792084824"></a>
<table><thead align="left"><tr id="row1515502276084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p249560418084824"><a name="p249560418084824"></a><a name="p249560418084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p333616294084824"><a name="p333616294084824"></a><a name="p333616294084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1967289512084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p713502192084824"><a name="p713502192084824"></a><a name="p713502192084824"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p451134362084824"><a name="p451134362084824"></a><a name="p451134362084824"></a><strong id="b152606107084824"><a name="b152606107084824"></a><a name="b152606107084824"></a>fp</strong> points to an invalid stream. </p>
</td>
</tr>
</tbody>
</table>

## ftrylockfile\(\)<a name="gab486b89691678e4873ec8b1b15c2678a"></a>

```
int ftrylockfile ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * filehandle)
```

 **Description:**

Locks a specified file. 

This function facilitates I/O operations in multiple threads. If the file has been locked by another thread, this function waits until the file object is no longer locked by any thread and then locks it. 

**Parameters:**

<a name="table2102702878084824"></a>
<table><thead align="left"><tr id="row467165761084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p537678775084824"><a name="p537678775084824"></a><a name="p537678775084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2073656560084824"><a name="p2073656560084824"></a><a name="p2073656560084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1955536400084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">filehandle</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the locking is successful; returns a non-zero value otherwise. 



## funlockfile\(\)<a name="ga4f016c54ff86ca62454417bb7b32ab11"></a>

```
void funlockfile ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * filehandle)
```

 **Description:**

Unlocks a specified file. 

This function is used to reduce the lock count. 

**Parameters:**

<a name="table2015957129084824"></a>
<table><thead align="left"><tr id="row1094388831084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1162597710084824"><a name="p1162597710084824"></a><a name="p1162597710084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1908532304084824"><a name="p1908532304084824"></a><a name="p1908532304084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1992555770084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">filehandle</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file whose lock count is to be reduced. </td>
</tr>
</tbody>
</table>

## fwrite\(\)<a name="gaf86a4505e5de39a100f7ea828377b585"></a>

```
size_t fwrite (const void *__restrict ptr, size_t size, size_t nmemb, [FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) *__restrict stream )
```

 **Description:**

Writes data to a specified stream. 

**Parameters:**

<a name="table730286807084824"></a>
<table><thead align="left"><tr id="row1824395964084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p518718022084824"><a name="p518718022084824"></a><a name="p518718022084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1139264469084824"><a name="p1139264469084824"></a><a name="p1139264469084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row668954785084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the data to write. </td>
</tr>
<tr id="row1156293275084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of each element to write, in bytes. </td>
</tr>
<tr id="row593497556084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nmemb</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of elements to write. </td>
</tr>
<tr id="row899986029084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream to which data is to write. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if  **size**  or  **nmemb**  is  **0**; returns the number of elements successfully written otherwise. If this number is not  **nmemb**, this function sets  **errno**  to a value in the following table if the number is not  **nmemb**. 

<a name="table633877124084824"></a>
<table><thead align="left"><tr id="row327632478084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1355502515084824"><a name="p1355502515084824"></a><a name="p1355502515084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1733311174084824"><a name="p1733311174084824"></a><a name="p1733311174084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row613135657084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1245050998084824"><a name="p1245050998084824"></a><a name="p1245050998084824"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p826294384084824"><a name="p826294384084824"></a><a name="p826294384084824"></a><strong id="b1423177830084824"><a name="b1423177830084824"></a><a name="b1423177830084824"></a>stream</strong> points to an invalid stream. </p>
</td>
</tr>
</tbody>
</table>

## getc\(\)<a name="gad5a0ea2c21a23a380b7c30fe35fa9456"></a>

```
int getc ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream)
```

 **Description:**

Reads a character from a specified file stream. 

**Parameters:**

<a name="table408869158084824"></a>
<table><thead align="left"><tr id="row1911999694084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1291054198084824"><a name="p1291054198084824"></a><a name="p1291054198084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p81652850084824"><a name="p81652850084824"></a><a name="p81652850084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row688620259084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Attention:**

The difference between this function and  **fgetc**  is that this function can be implemented as a macro. 

**Returns:**

Returns the character read as an int value if the operation is successful; returns  **EOF**  if the end-of-file is reached or a reading error occurs. 



## getc\_unlocked\(\)<a name="ga169f9b7e933ba56156885e30f7263b28"></a>

```
int getc_unlocked ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream)
```

 **Description:**

Obtains a character from a specified file stream without locking the file stream or checking whether it is locked. 

**Parameters:**

<a name="table363639248084824"></a>
<table><thead align="left"><tr id="row998031419084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1739748879084824"><a name="p1739748879084824"></a><a name="p1739748879084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1647233749084824"><a name="p1647233749084824"></a><a name="p1647233749084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1212375396084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Attention:**

Use this function with caution in multi-thread scenarios. 

**Returns:**

Returns the obtained character. 



## getchar\(\)<a name="ga3e29caa20f7cffe18f410f01278905a8"></a>

```
int getchar (void )
```

 **Description:**

Obtains the next character from the standard input \(stdin\). 

This function waits for user input and does not return until any input is available. 

**Returns:**

Returns the character read as an int value if the operation is successful; returns  **EOF**  if the end-of-file is reached or a reading error occurs. 



## getchar\_unlocked\(\)<a name="gafef7e39f2376c63728163cd5ccfbe99e"></a>

```
int getchar_unlocked (void )
```

 **Description:**

Obtains the next character from stdin. 

This function waits for user input and does not return until any input is available. 

**Attention:**

Use this function with caution in multi-thread scenarios. 

**Returns:**

Returns the character forcibly converted to an int value if the operation is successful; returns  **EOF**  if the end-of-file is reached or a reading error occurs. 



## getdelim\(\)<a name="gab87a24b4c09e8fc3712a6d6090bfd371"></a>

```
ssize_t getdelim (char ** lineptr, size_t * n, int delim, [FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream )
```

 **Description:**

Reads an entire line from a specified file stream. 

**Parameters:**

<a name="table1376945098084824"></a>
<table><thead align="left"><tr id="row1284623447084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p25351975084824"><a name="p25351975084824"></a><a name="p25351975084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p877744076084824"><a name="p877744076084824"></a><a name="p877744076084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1832442405084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">lineptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the double pointer to the buffer for storing the characters in the line. </td>
</tr>
<tr id="row569883764084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the size of the buffer. If the system needs to dynamically allocate memory, set this parameter to <strong id="b1971581629084824"><a name="b1971581629084824"></a><a name="b1971581629084824"></a>0</strong>. </td>
</tr>
<tr id="row325514936084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">delim</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the line delimiter. </td>
</tr>
<tr id="row1189519957084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Attention:**

If the system dynamically allocates memory, the memory needs to be released after being used. 

**Returns:**

Returns the number of bytes read if the operation is successful; returns  **-1**  otherwise. 



## getline\(\)<a name="gaaf07c1bbc2aa081a54bdd66f0e152312"></a>

```
ssize_t getline (char ** lineptr, size_t * n, [FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream )
```

 **Description:**

Reads an entire line from a specified file stream. 

**Parameters:**

<a name="table197444183084824"></a>
<table><thead align="left"><tr id="row601144980084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p798395648084824"><a name="p798395648084824"></a><a name="p798395648084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1403482801084824"><a name="p1403482801084824"></a><a name="p1403482801084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2145399536084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">lineptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the double pointer to the buffer for storing the characters in the line. </td>
</tr>
<tr id="row1191983060084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the size of the buffer. If the system needs to dynamically allocate memory, set this parameter to <strong id="b2083293039084824"><a name="b2083293039084824"></a><a name="b2083293039084824"></a>0</strong>. </td>
</tr>
<tr id="row604833631084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Attention:**

If the system dynamically allocates memory, the memory needs to be released after being used. 

**Returns:**

Returns the number of bytes read if the operation is successful; returns  **-1**  otherwise. 



## gets\(\)<a name="gaab85b30d68ce9d9e0475e0f51bf610b1"></a>

```
char* gets (char * s)
```

 **Description:**

Reads a line of characters from the stdin and stores it in the buffer. 

**Parameters:**

<a name="table1805712489084824"></a>
<table><thead align="left"><tr id="row936134999084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1521318582084824"><a name="p1521318582084824"></a><a name="p1521318582084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1047602051084824"><a name="p1047602051084824"></a><a name="p1047602051084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1095629579084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the memory buffer for storing the obtained string. </td>
</tr>
</tbody>
</table>

**Attention:**

The  **[gets\(\)](io.md#gaab85b30d68ce9d9e0475e0f51bf610b1)**  function cannot predict the size of the line to be read, which may cause buffer overflow. You are recommended not to use this function. POSIX.1-2008 and ISO C11 have marked this function as obsolete. 

**Returns:**

Returns the value of  **s**  if the operation is successful; returns  **NULL**  otherwise. 



## getw\(\)<a name="ga6d475ead5d1f35e3f14423a99ef3a992"></a>

```
int getw ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream)
```

 **Description:**

Reads a word \(an int value\) from a specified file stream. 

**Parameters:**

<a name="table205249756084824"></a>
<table><thead align="left"><tr id="row89896252084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1956058177084824"><a name="p1956058177084824"></a><a name="p1956058177084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1271123222084824"><a name="p1271123222084824"></a><a name="p1271123222084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row171550975084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Attention:**

This function is provided for compatibility with System V Release 4 \(SVR4\). You are advised to use  [fread](io.md#ga091b3f41bdd6984d63ea48d87a62bfd2)  instead. The value returned upon an error is also a valid data value. 

**Returns:**

Returns the integer read if the operation is successful; returns  **EOP**  otherwise. 



## iconv\(\)<a name="gab7c1300a663def659ce6d4a01076c39d"></a>

```
size_t iconv ([iconv_t](io.md#ga72517f6ffadddaafa9d51dee9b535c9f) cd, char **restrict in, size_t *restrict inb, char **restrict out, size_t *restrict outb )
```

 **Description:**

Converts a character set. 

**Parameters:**

<a name="table1008839594084824"></a>
<table><thead align="left"><tr id="row402186762084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1785571366084824"><a name="p1785571366084824"></a><a name="p1785571366084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1455634770084824"><a name="p1455634770084824"></a><a name="p1455634770084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1136096435084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">cd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the conversion descriptor obtained via <a href="io.md#ga934548ab8aaae237ac5cce0ed0b3edec">iconv_open</a>. </td>
</tr>
<tr id="row571059866084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">in</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the double pointer to the buffer for storing the input character. </td>
</tr>
<tr id="row2128151530084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">inb</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the length of the character input buffer. </td>
</tr>
<tr id="row1746317385084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">out</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the double pointer to the buffer for storing the output character. </td>
</tr>
<tr id="row1510752850084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">outb</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to length of the character output buffer. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of irreversibly converted characters if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table2048483029084824"></a>
<table><thead align="left"><tr id="row9992104084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p67605487084824"><a name="p67605487084824"></a><a name="p67605487084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1071020455084824"><a name="p1071020455084824"></a><a name="p1071020455084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1958296856084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1334161392084824"><a name="p1334161392084824"></a><a name="p1334161392084824"></a>EILSEQ </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2006337978084824"><a name="p2006337978084824"></a><a name="p2006337978084824"></a>An invalid multi-byte sequence is encountered in the input. </p>
</td>
</tr>
<tr id="row1976518634084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p142738260084824"><a name="p142738260084824"></a><a name="p142738260084824"></a>E2BIG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1240725063084824"><a name="p1240725063084824"></a><a name="p1240725063084824"></a>The output buffer space is insufficient. </p>
</td>
</tr>
<tr id="row1908267683084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2008881299084824"><a name="p2008881299084824"></a><a name="p2008881299084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1377047557084824"><a name="p1377047557084824"></a><a name="p1377047557084824"></a>An incomplete multi-byte sequence is encountered in the input. </p>
</td>
</tr>
</tbody>
</table>

## iconv\_close\(\)<a name="ga062da5f802d9e274a8702f11921e691b"></a>

```
int iconv_close ([iconv_t](io.md#ga72517f6ffadddaafa9d51dee9b535c9f) cd)
```

 **Description:**

Closes a character set conversion descriptor. 

**Parameters:**

<a name="table1701721541084824"></a>
<table><thead align="left"><tr id="row2062823284084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p297124119084824"><a name="p297124119084824"></a><a name="p297124119084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p639312981084824"><a name="p639312981084824"></a><a name="p639312981084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1658957022084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">cd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the conversion descriptor to close. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**. 



## iconv\_open\(\)<a name="ga934548ab8aaae237ac5cce0ed0b3edec"></a>

```
[iconv_t](io.md#ga72517f6ffadddaafa9d51dee9b535c9f) iconv_open (const char * to, const char * from )
```

 **Description:**

Obtain a character set conversion descriptor. 

**Parameters:**

<a name="table1956950161084824"></a>
<table><thead align="left"><tr id="row73969919084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p80790165084824"><a name="p80790165084824"></a><a name="p80790165084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p93582199084824"><a name="p93582199084824"></a><a name="p93582199084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row856716473084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">to</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the source character set for conversion. </td>
</tr>
<tr id="row875814902084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">from</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the target character set for conversion. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the character set conversion descriptor if the operation is successful; returns  **-1**  otherwise. 



## lio\_listio\(\)<a name="gae15ea0aaa18c5f007c3933085749ecaf"></a>

```
int lio_listio (int mode, struct aiocb *restrict const *restrict cbs, int cnt, struct [sigevent](sigevent.md) *restrict sev )
```

 **Description:**

Initiates AIO requests. 

**Parameters:**

<a name="table601034553084824"></a>
<table><thead align="left"><tr id="row1348868553084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p899905478084824"><a name="p899905478084824"></a><a name="p899905478084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1282577279084824"><a name="p1282577279084824"></a><a name="p1282577279084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1172219036084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">mode</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the mode of notification upon the completion of AIO operations. </td>
</tr>
<tr id="row1730229713084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">cbs</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to an array of pointers to the <strong id="b21776584084824"><a name="b21776584084824"></a><a name="b21776584084824"></a>aiocb</strong> structure. </td>
</tr>
<tr id="row1947915183084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">cnt</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the array size. </td>
</tr>
<tr id="row1307656571084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">sev</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the asynchronous notification mode. The value <strong id="b421870478084824"><a name="b421870478084824"></a><a name="b421870478084824"></a>NULL</strong> indicates that a notification is not required. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table831936321084824"></a>
<table><thead align="left"><tr id="row1307076938084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p727895801084824"><a name="p727895801084824"></a><a name="p727895801084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p786549433084824"><a name="p786549433084824"></a><a name="p786549433084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row2041845940084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p80743307084824"><a name="p80743307084824"></a><a name="p80743307084824"></a>EAGAIN </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p745736232084824"><a name="p745736232084824"></a><a name="p745736232084824"></a>Insufficient resources </p>
</td>
</tr>
</tbody>
</table>

## localeconv\(\)<a name="ga69b40f71a20a7c8bd67b9eeeae7f40c9"></a>

```
struct [lconv](lconv.md)* localeconv (void )
```

 **Description:**

Obtains the locale information about a region and stores them in  [lconv](lconv.md). 

**Returns:**

Returns a pointer to  **lconv**  that stores region information. 



## open\_memstream\(\)<a name="gac7250554d80d31f4d8ad316c4c3c3c85"></a>

```
[FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1)* open_memstream (char ** ptr, size_t * size )
```

 **Description:**

Opens a stream for writing to a specified buffer. 

The buffer is dynamically allocated and grown. After the stream is closed, call  [free\(\)](mem.md#gafbedc913aa4651b3c3b4b3aecd9b4711)  to release the buffer. When  [fclose\(\)](io.md#gac41a0ad4b31be2ad59d8222a0de30bda)  or  [fflush\(\)](io.md#gae4459e830d3e2abcf428337a661d9456)  is called to close or flush the stream, the pointers to the allocated buffer address and buffer size are updated to  **ptr**  and  **size**, respectively. @attentions This function is defined in POSIX.1-2008. It is not defined in POSIX.1-2001 and is not widely used in other systems. 

**Parameters:**

<a name="table1062773333084824"></a>
<table><thead align="left"><tr id="row753188463084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1880888708084824"><a name="p1880888708084824"></a><a name="p1880888708084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1915520789084824"><a name="p1915520789084824"></a><a name="p1915520789084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row497342200084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ptr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the buffer address. </td>
</tr>
<tr id="row885955896084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the buffer size. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the stream if the operation is successful; returns  **NULL**  and sets  **errno**  to indicate an error otherwise. 



## pclose\(\)<a name="ga30839d83d780a6a3d13bf40c2d666827"></a>

```
int pclose ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * f)
```

 **Description:**

Closes a specified pipe. 

**Parameters:**

<a name="table3732236084824"></a>
<table><thead align="left"><tr id="row1973961517084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p518515434084824"><a name="p518515434084824"></a><a name="p518515434084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p521510770084824"><a name="p521510770084824"></a><a name="p521510770084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1039000952084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">f</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a pipe to close. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the thread termination status code if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table otherwise. 

<a name="table1361022526084824"></a>
<table><thead align="left"><tr id="row1523490038084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1848739616084824"><a name="p1848739616084824"></a><a name="p1848739616084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1402938303084824"><a name="p1402938303084824"></a><a name="p1402938303084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row660770865084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p286286981084824"><a name="p286286981084824"></a><a name="p286286981084824"></a>ECHILD </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1465335737084824"><a name="p1465335737084824"></a><a name="p1465335737084824"></a>The child process does not exist, or the specified process group does not exist. </p>
</td>
</tr>
<tr id="row569146530084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p532146403084824"><a name="p532146403084824"></a><a name="p532146403084824"></a>ESRCH </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2129463989084824"><a name="p2129463989084824"></a><a name="p2129463989084824"></a>The child process ends abnormally. </p>
</td>
</tr>
</tbody>
</table>

## perror\(\)<a name="ga80b37b56a5a42139dccaef56da4bf82a"></a>

```
void perror (const char * msg)
```

 **Description:**

Prints the last error occurred during a call to a system or library function to the standard error output stream \(stderr\). 

**Parameters:**

<a name="table1737899153084824"></a>
<table><thead align="left"><tr id="row575709417084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1104047880084824"><a name="p1104047880084824"></a><a name="p1104047880084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p966947998084824"><a name="p966947998084824"></a><a name="p966947998084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row688093571084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">msg</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the prompt message printed to stderr before the error message itself. </td>
</tr>
</tbody>
</table>

**Attention:**

To make the output message more useful,  **msg**  should convey obvious information describing what happened. When a system call fails, it usually returns  **-1**  and sets  **errno**  to a value that describes what went wrong. The error codes can be found in  **[errno.h](errno-h.md)**. 



## poll\(\)<a name="gab7fc0f6be5f13c81de180c1288ba3b6f"></a>

```
int poll (struct [pollfd](pollfd.md) fds[], [nfds_t](io.md#ga0af7a8bdafcd5532e620a11f0d373d52) nfds, int timeout )
```

 **Description:**

Defines the I/O multiplexing system. 

This function is used to mount the pointer to the  **pollfd**  file to the waiting queue and then monitor the file. 

**Parameters:**

<a name="table16882620084824"></a>
<table><thead align="left"><tr id="row63813434084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p219665653084824"><a name="p219665653084824"></a><a name="p219665653084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1262807646084824"><a name="p1262807646084824"></a><a name="p1262807646084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1179636033084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fds[]</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the <strong id="b288575385084824"><a name="b288575385084824"></a><a name="b288575385084824"></a>pollfd</strong> array used to store the socket descriptor to be checked. </td>
</tr>
<tr id="row1542223887084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nfds</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the <strong id="b1498480330084824"><a name="b1498480330084824"></a><a name="b1498480330084824"></a>nfds_t</strong> parameter used to mark the total number of structure elements in <strong id="b1780472991084824"><a name="b1780472991084824"></a><a name="b1780472991084824"></a>fds</strong>. </td>
</tr>
<tr id="row579402309084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">timeout</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the blocking time, in milliseconds. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a value greater than 0 if the total number of socket descriptors in  **fds**  is ready for read or write, or on which errors occur; returns  **0**  otherwise, in which case  **poll**  timed out. Returns  **-1**  and sets  **errno**  to a value if this function fails to be called. 



## preadv\(\)<a name="ga94adc8dd94a6bdaaa9cf4d9f388418b3"></a>

```
ssize_t preadv (int fd, const struct iovec * iov, int iovcnt, off_t offset )
```

 **Description:**

Reads the data in a file whose  **fd**  offset is  **offset**  to the multi-group buffer space pointed to by  **iov**. 

**Parameters:**

<a name="table107868047084824"></a>
<table><thead align="left"><tr id="row420564474084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1813208596084824"><a name="p1813208596084824"></a><a name="p1813208596084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p680730417084824"><a name="p680730417084824"></a><a name="p680730417084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row581675168084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file descriptor. </td>
</tr>
<tr id="row20259077084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">iov</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the multi-group buffer. </td>
</tr>
<tr id="row1672414819084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">iovcnt</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of buffers. For details, see <a href="utils.md#ga25080e819a36fcf9aede01a6e7298ea4">IOV_MAX</a>. </td>
</tr>
<tr id="row1671317546084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the offset of the file descriptor to read. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of bytes read if the operation is successful; returns  **-1**  and sets  **errno**  to a value if the operation fails. If  **errno**  is set to  **EINVAL**, the sum of the  **iov\_len**  values overflows an  **ssize\_t**  value, or the vector count  **iovcnt**  is less than 0 or greater than the permitted maximum. 



## printf\(\)<a name="ga98631211a4a8aee62f572375d5b637be"></a>

```
int printf (const char * format,  ... )
```

 **Description:**

Formats arguments based on  **format**  and prints formatted data to the stdout. 

**Parameters:**

<a name="table1241070654084824"></a>
<table><thead align="left"><tr id="row1547411181084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p525038101084824"><a name="p525038101084824"></a><a name="p525038101084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1515179634084824"><a name="p1515179634084824"></a><a name="p1515179634084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2141426395084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format string. </td>
</tr>
<tr id="row1864612537084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">...</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the list of arguments corresponding to the format specifiers. </td>
</tr>
</tbody>
</table>

**Attention:**

**format**  must correspond to the arguments specified in  **...**. Otherwise, an error is returned. 

**Returns:**

Returns the total number of characters \(excluding the terminating null character  **'\\0'**\) if the operation is successful; returns a negative value otherwise. 



## putc\(\)<a name="ga38f980218f04ebdddcdcd1b77e1cf6b1"></a>

```
int putc (int c, [FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream )
```

 **Description:**

Writes a character to a specified file stream. 

**Parameters:**

<a name="table1723178719084824"></a>
<table><thead align="left"><tr id="row488602135084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1492218152084824"><a name="p1492218152084824"></a><a name="p1492218152084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1030765721084824"><a name="p1030765721084824"></a><a name="p1030765721084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1078696380084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the int promotion of the character to write. </td>
</tr>
<tr id="row996542598084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file stream. </td>
</tr>
</tbody>
</table>

**Attention:**

**Returns:**

Returns the ASCII code of the character written if the operation is successful; returns  **EOF**  otherwise. 



## putc\_unlocked\(\)<a name="ga340b21ecb337abb08905095e673672f6"></a>

```
int putc_unlocked (int c, [FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream )
```

 **Description:**

Writes a character to a specified file stream with the thread remains unlocked. 

**Parameters:**

<a name="table1134967750084824"></a>
<table><thead align="left"><tr id="row2082728438084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p546303919084824"><a name="p546303919084824"></a><a name="p546303919084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1264638752084824"><a name="p1264638752084824"></a><a name="p1264638752084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row241277099084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the int promotion of the character to write. </td>
</tr>
<tr id="row1746807246084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Attention:**

This function cannot be used in a multi-thread process because it does not use locking during the call. 

**Returns:**

Returns the ASCII code of the character written if the operation is successful; returns  **EOF**  otherwise. 



## putchar\(\)<a name="gaf4de2514b7778805db3815e8dd6cf09a"></a>

```
int putchar (int c)
```

 **Description:**

Writes a character into the standard output \(stdout\). 

**Parameters:**

<a name="table2053960213084824"></a>
<table><thead align="left"><tr id="row559076139084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1310070484084824"><a name="p1310070484084824"></a><a name="p1310070484084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1109639886084824"><a name="p1109639886084824"></a><a name="p1109639886084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1773269036084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the int promotion of the character to write. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the ASCII code of the character written if the operation is successful; returns  **EOF**  otherwise. 



## putchar\_unlocked\(\)<a name="ga07ff061a8fed45cdedbecdd899b5fdb1"></a>

```
int putchar_unlocked (int c)
```

 **Description:**

Writes a character to the stdout with the thread remains unlocked. 

**Parameters:**

<a name="table1401280242084824"></a>
<table><thead align="left"><tr id="row1632628579084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1094368499084824"><a name="p1094368499084824"></a><a name="p1094368499084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1833136550084824"><a name="p1833136550084824"></a><a name="p1833136550084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row831080844084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the int promotion of the character to write. </td>
</tr>
</tbody>
</table>

**Attention:**

This function cannot be used in a multi-thread process because it does not use locking during the call. 

**Returns:**

Returns the ASCII code of the character written if the operation is successful; returns  **EOF**  otherwise. 



## puts\(\)<a name="gad41876f99f190c7488e64ef39c50a23f"></a>

```
int puts (const char * s)
```

 **Description:**

Writes a character string and appends a new-line character to the stdout. 

**Parameters:**

<a name="table756763452084824"></a>
<table><thead align="left"><tr id="row1913525978084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1515637593084824"><a name="p1515637593084824"></a><a name="p1515637593084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1998665361084824"><a name="p1998665361084824"></a><a name="p1998665361084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1248025816084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the start address of the output buffer. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns a non-negative value if the operation is successful; returns  **EOF**  otherwise. 



## putw\(\)<a name="gae3a2f96dac9fa87b964b69ff6d5cce46"></a>

```
int putw (int w, [FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream )
```

 **Description:**

Writes a word \(an int value\) to a specified file stream. 

**Parameters:**

<a name="table2053591807084824"></a>
<table><thead align="left"><tr id="row447145868084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1398966727084824"><a name="p1398966727084824"></a><a name="p1398966727084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p628262685084824"><a name="p628262685084824"></a><a name="p628262685084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2012097917084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">w</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the word to write. </td>
</tr>
<tr id="row1662832172084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Attention:**

This function is provided for compatibility with SVR4. You are advised to use  [fwrite](io.md#gaf86a4505e5de39a100f7ea828377b585)  instead. 

**Returns:**

Returns  **0**  if the operation is successful; returns  **EOP**  otherwise. 



## pwritev\(\)<a name="ga3de6f9331d6bb930e748bb61860edbd6"></a>

```
ssize_t pwritev (int fd, const struct iovec * iov, int iovcnt, off_t offset )
```

 **Description:**

Writes the data of a multi-group buffer space pointed to by  **iov**  to the offset of  **fd**. 

**Parameters:**

<a name="table701074955084824"></a>
<table><thead align="left"><tr id="row2000906858084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p421804543084824"><a name="p421804543084824"></a><a name="p421804543084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1727023109084824"><a name="p1727023109084824"></a><a name="p1727023109084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1393577816084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file descriptor. </td>
</tr>
<tr id="row283135753084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">iov</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the multi-group buffer. </td>
</tr>
<tr id="row85810145084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">iovcnt</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of buffers. For details, see <a href="utils.md#ga25080e819a36fcf9aede01a6e7298ea4">IOV_MAX</a>. </td>
</tr>
<tr id="row1288002885084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the offset of the file descriptor to write. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of bytes written if the operation is successful; returns  **-1**  and sets  **errno**  to a value if the operation fails. If  **errno**  is set to  **EINVAL**, the sum of the  **iov\_len**  values overflows an  **ssize\_t**  value, or the vector count  **iovcnt**  is less than 0 or greater than the permitted maximum. 



## readv\(\)<a name="gaa1952d693ed3c43292566e643ceb9858"></a>

```
ssize_t readv (int fd, const struct iovec * iov, int iovcnt )
```

 **Description:**

Reads the data of  **fd**  to  **iov**. 

**Parameters:**

<a name="table411956521084824"></a>
<table><thead align="left"><tr id="row2026937776084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p759912475084824"><a name="p759912475084824"></a><a name="p759912475084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p341107978084824"><a name="p341107978084824"></a><a name="p341107978084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row371509541084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file descriptor. </td>
</tr>
<tr id="row1928752583084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">iov</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the multi-group buffer. </td>
</tr>
<tr id="row1413639642084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">iovcnt</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of buffers. For details, see <a href="utils.md#ga25080e819a36fcf9aede01a6e7298ea4">IOV_MAX</a>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of bytes read if the operation is successful; returns  **-1**  and sets  **errno**  to a value if the operation fails. If  **errno**  is set to  **EINVAL**, the sum of the  **iov\_len**  values overflows an  **ssize\_t**  value, or the vector count  **iovcnt**  is less than 0 or greater than the permitted maximum. 



## remove\(\)<a name="ga02b13b56a188401119ea4da43c184913"></a>

```
int remove (const char * pathname)
```

 **Description:**

Deletes a specified file or directory from the file system. 

**Parameters:**

<a name="table1788890373084824"></a>
<table><thead align="left"><tr id="row1127201576084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1121807250084824"><a name="p1121807250084824"></a><a name="p1121807250084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1450039190084824"><a name="p1450039190084824"></a><a name="p1450039190084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row28477652084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pathname</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file or directory to delete. </td>
</tr>
</tbody>
</table>

**Attention:**

This function can NOT be used in the PROC file system. 

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1396000526084824"></a>
<table><thead align="left"><tr id="row243119795084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1561574612084824"><a name="p1561574612084824"></a><a name="p1561574612084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p45465522084824"><a name="p45465522084824"></a><a name="p45465522084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row2120291770084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p301424833084824"><a name="p301424833084824"></a><a name="p301424833084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1837133583084824"><a name="p1837133583084824"></a><a name="p1837133583084824"></a><strong id="b1197206294084824"><a name="b1197206294084824"></a><a name="b1197206294084824"></a>pathname</strong> is a null pointer or an empty string. </p>
</td>
</tr>
<tr id="row266555579084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1215402176084824"><a name="p1215402176084824"></a><a name="p1215402176084824"></a>ENAMETOOLONG </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1178615494084824"><a name="p1178615494084824"></a><a name="p1178615494084824"></a>The length of <strong id="b593405683084824"><a name="b593405683084824"></a><a name="b593405683084824"></a>pathname</strong> is greater than <a href="utils.md#gac64541bdd81c961304b9babef1402640">NAME_MAX</a>. </p>
</td>
</tr>
<tr id="row1260740799084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1734340151084824"><a name="p1734340151084824"></a><a name="p1734340151084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1263575569084824"><a name="p1263575569084824"></a><a name="p1263575569084824"></a>Insufficient memory. </p>
</td>
</tr>
<tr id="row461620349084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2015618511084824"><a name="p2015618511084824"></a><a name="p2015618511084824"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1109618199084824"><a name="p1109618199084824"></a><a name="p1109618199084824"></a>The file or directory pointed to by <strong id="b2090263549084824"><a name="b2090263549084824"></a><a name="b2090263549084824"></a>pathname</strong> does not exist. </p>
</td>
</tr>
<tr id="row1059262828084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p675603217084824"><a name="p675603217084824"></a><a name="p675603217084824"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p644970750084824"><a name="p644970750084824"></a><a name="p644970750084824"></a>The file system does not support this operation. </p>
</td>
</tr>
<tr id="row1890009397084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1574875215084824"><a name="p1574875215084824"></a><a name="p1574875215084824"></a>EPERM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1885428380084824"><a name="p1885428380084824"></a><a name="p1885428380084824"></a>The path is a mount point or is neither a directory nor a file. </p>
</td>
</tr>
<tr id="row1413575632084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1250871199084824"><a name="p1250871199084824"></a><a name="p1250871199084824"></a>ENOTEMPTY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1567061509084824"><a name="p1567061509084824"></a><a name="p1567061509084824"></a>When <strong id="b885798718084824"><a name="b885798718084824"></a><a name="b885798718084824"></a>pathname</strong> points to a directory, the directory is not empty. </p>
</td>
</tr>
<tr id="row1998370916084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1255945309084824"><a name="p1255945309084824"></a><a name="p1255945309084824"></a>ENXIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p411229637084824"><a name="p411229637084824"></a><a name="p411229637084824"></a>No such device or address. </p>
</td>
</tr>
<tr id="row1744917623084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1165452204084824"><a name="p1165452204084824"></a><a name="p1165452204084824"></a>EACCES </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1264867620084824"><a name="p1264867620084824"></a><a name="p1264867620084824"></a>The search permission on the path prefix component is denied, or the write permission of the directory in the path is denied. </p>
</td>
</tr>
</tbody>
</table>

## rename\(\)<a name="ga4d4709508ed7604103d77c3fdc5ea4a2"></a>

```
int rename (const char * oldpath, const char * newpath )
```

 **Description:**

Renames a specified file. 

**Parameters:**

<a name="table1128634724084824"></a>
<table><thead align="left"><tr id="row2061238023084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p880490505084824"><a name="p880490505084824"></a><a name="p880490505084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p567497702084824"><a name="p567497702084824"></a><a name="p567497702084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1583867987084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">oldpath</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the old path name of the file to rename. </td>
</tr>
<tr id="row242804472084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">newpath</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the new path name of the file. </td>
</tr>
</tbody>
</table>

**Attention:**

This function can NOT be used in the PROC file system. 

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table540375395084824"></a>
<table><thead align="left"><tr id="row1741366116084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1646564610084824"><a name="p1646564610084824"></a><a name="p1646564610084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p629009664084824"><a name="p629009664084824"></a><a name="p629009664084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row729578823084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1028229753084824"><a name="p1028229753084824"></a><a name="p1028229753084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1344919380084824"><a name="p1344919380084824"></a><a name="p1344919380084824"></a>Invalid input parameter. </p>
</td>
</tr>
<tr id="row947203954084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p22164948084824"><a name="p22164948084824"></a><a name="p22164948084824"></a>ENOENT </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1153423233084824"><a name="p1153423233084824"></a><a name="p1153423233084824"></a>The file or directory does not exist. </p>
</td>
</tr>
<tr id="row349698445084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p44242817084824"><a name="p44242817084824"></a><a name="p44242817084824"></a>EXDEV </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p237578118084824"><a name="p237578118084824"></a><a name="p237578118084824"></a><strong id="b346826461084824"><a name="b346826461084824"></a><a name="b346826461084824"></a>oldpath</strong> and <strong id="b2096820660084824"><a name="b2096820660084824"></a><a name="b2096820660084824"></a>newpath</strong> are not on the same file system. </p>
</td>
</tr>
<tr id="row1846652349084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1638772849084824"><a name="p1638772849084824"></a><a name="p1638772849084824"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p52639423084824"><a name="p52639423084824"></a><a name="p52639423084824"></a>The function is unavailable. </p>
</td>
</tr>
<tr id="row664979046084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p260992650084824"><a name="p260992650084824"></a><a name="p260992650084824"></a>EBUSY </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1007286218084824"><a name="p1007286218084824"></a><a name="p1007286218084824"></a>The device or resource is in use by the system or another process. </p>
</td>
</tr>
<tr id="row666362149084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p23875071084824"><a name="p23875071084824"></a><a name="p23875071084824"></a>EEXIST </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p274563125084824"><a name="p274563125084824"></a><a name="p274563125084824"></a>The file path pointed to by <strong id="b651835859084824"><a name="b651835859084824"></a><a name="b651835859084824"></a>newpath</strong> already exists. </p>
</td>
</tr>
<tr id="row1041471018084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p781868808084824"><a name="p781868808084824"></a><a name="p781868808084824"></a>ENXIO </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1548453641084824"><a name="p1548453641084824"></a><a name="p1548453641084824"></a>The device or address does not exist. </p>
</td>
</tr>
</tbody>
</table>

## rewind\(\)<a name="gaa0cd401f198d33d9d01a9e8aa4026819"></a>

```
void rewind ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream)
```

 **Description:**

Sets the position indicator of a specified stream to the beginning of the file. 

**Parameters:**

<a name="table2093562302084824"></a>
<table><thead align="left"><tr id="row684343379084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2016694592084824"><a name="p2016694592084824"></a><a name="p2016694592084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p302038201084824"><a name="p302038201084824"></a><a name="p302038201084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row578472736084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

## scanf\(\)<a name="ga5c48433db9c04031772d5b36e6c4411d"></a>

```
int scanf (const char * format,  ... )
```

 **Description:**

Reads formatted data from the stdin and stores the data to the additional arguments based on  **format**. 

**Parameters:**

<a name="table797123431084824"></a>
<table><thead align="left"><tr id="row118992574084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1931842457084824"><a name="p1931842457084824"></a><a name="p1931842457084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p515538944084824"><a name="p515538944084824"></a><a name="p515538944084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row979741484084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format string. </td>
</tr>
<tr id="row1996502007084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">...</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the list of arguments corresponding to the format specifiers. </td>
</tr>
</tbody>
</table>

**Attention:**

The type of each argument must match a format specifier in  **format**. 

**Returns:**

Returns the number of variables that are successfully read. If the matching fails quickly, the return value may be less than the number of members in the argument list or even zero. If no complete conversion format is available or the input format fails to be matched,  **EOF**  is returned. The return value is also  **EOF**  if a reading error occurs. If the number of arguments exceeds the number of the format specifiers, the excess arguments are ignored. 



## select\(\)<a name="gaf916439863bed6ba92594e390c227c7e"></a>

```
int select (int nfds, [fd_set](fd_set.md) *__restrict readfds, [fd_set](fd_set.md) *__restrict writefds, [fd_set](fd_set.md) *__restrict exceptfds, struct [timeval](timeval.md) *__restrict timeout )
```

 **Description:**

Monitors the I/O events of multiple file descriptors. 

**Parameters:**

<a name="table796541626084824"></a>
<table><thead align="left"><tr id="row841710812084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p907769992084824"><a name="p907769992084824"></a><a name="p907769992084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1337666762084824"><a name="p1337666762084824"></a><a name="p1337666762084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1771558348084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">nfds</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum value of the file descriptor of the <strong id="b358424484084824"><a name="b358424484084824"></a><a name="b358424484084824"></a>int</strong> type. </td>
</tr>
<tr id="row1265724240084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">readfds</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the descriptor set of the readable event to observe, which is the <strong id="b1375385101084824"><a name="b1375385101084824"></a><a name="b1375385101084824"></a><a href="fd_set.md">fd_set</a> *</strong> type. </td>
</tr>
<tr id="row1835839938084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">writefds</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the descriptor set of the writable event to observe, which is the <strong id="b201564225084824"><a name="b201564225084824"></a><a name="b201564225084824"></a><a href="fd_set.md">fd_set</a> *</strong> type. </td>
</tr>
<tr id="row1947690517084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">exceptfds</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the descriptor set of exception event to observe, which is the <strong id="b1861855745084824"><a name="b1861855745084824"></a><a name="b1861855745084824"></a><a href="fd_set.md">fd_set</a> *</strong> type. </td>
</tr>
<tr id="row770093187084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">timeout</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the timeout interval, which is the <strong id="b192221941084824"><a name="b192221941084824"></a><a name="b192221941084824"></a>struct timeval *</strong> type. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the total number of file descriptors of the observed events \(that is, the sum of all file descriptors in  **readfds**,  **writefds**, and  **exceptfds**\) if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1878537314084824"></a>
<table><thead align="left"><tr id="row279294777084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1417348247084824"><a name="p1417348247084824"></a><a name="p1417348247084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2142497738084824"><a name="p2142497738084824"></a><a name="p2142497738084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1146735061084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1467999245084824"><a name="p1467999245084824"></a><a name="p1467999245084824"></a>EBADF </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1360789746084824"><a name="p1360789746084824"></a><a name="p1360789746084824"></a>An invalid file descriptor is given in one of the sets. </p>
</td>
</tr>
<tr id="row1091688805084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p701694158084824"><a name="p701694158084824"></a><a name="p701694158084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p355005240084824"><a name="p355005240084824"></a><a name="p355005240084824"></a><strong id="b608977955084824"><a name="b608977955084824"></a><a name="b608977955084824"></a>nfds</strong> is less than 0. </p>
</td>
</tr>
<tr id="row277792578084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1284913365084824"><a name="p1284913365084824"></a><a name="p1284913365084824"></a>ENOMEM </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2064918089084824"><a name="p2064918089084824"></a><a name="p2064918089084824"></a>Failed to apply for memory. </p>
</td>
</tr>
</tbody>
</table>

## setbuf\(\)<a name="ga36d24924e1acc69f9c3ce49a832615fe"></a>

```
void setbuf ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream, char * buf )
```

 **Description:**

Sets a buffer to be used by a specified stream. 

**Parameters:**

<a name="table765330734084824"></a>
<table><thead align="left"><tr id="row925052389084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p981560362084824"><a name="p981560362084824"></a><a name="p981560362084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1169673475084824"><a name="p1169673475084824"></a><a name="p1169673475084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1213944960084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
<tr id="row379111159084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the start address of the buffer. </td>
</tr>
</tbody>
</table>

**Attention:**

When the input parameter  **buf**  is not null, the buffer mode is  **\_IOFBF**. The default buffer size is determined by the value of  **BUFSIZ**  defined in this file. When  **buf**  is null, the buffer mode is  **\_IONBF**  \(unbuffered\). 



## setbuffer\(\)<a name="ga53a57437279b4ed57b7f116dfc9cbbcc"></a>

```
void setbuffer ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * f, char * buf, size_t size )
```

 **Description:**

Sets the buffer for a specified file stream. 

**Parameters:**

<a name="table1874190054084824"></a>
<table><thead align="left"><tr id="row251997472084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1601281794084824"><a name="p1601281794084824"></a><a name="p1601281794084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1088742759084824"><a name="p1088742759084824"></a><a name="p1088742759084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1736784267084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">f</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream to set. </td>
</tr>
<tr id="row141920627084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the buffer to set. </td>
</tr>
<tr id="row1129104481084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the buffer size. </td>
</tr>
</tbody>
</table>

## setlinebuf\(\)<a name="ga2e13e101d5a57cfccf1bab51f8768a5d"></a>

```
void setlinebuf ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * f)
```

 **Description:**

Sets the linear buffer for a specified file stream. 

**Parameters:**

<a name="table1638550654084824"></a>
<table><thead align="left"><tr id="row714968266084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1088289333084824"><a name="p1088289333084824"></a><a name="p1088289333084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p770659779084824"><a name="p770659779084824"></a><a name="p770659779084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row769816649084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">f</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream to set. </td>
</tr>
</tbody>
</table>

## setlocale\(\)<a name="gafe784c4f5d12b74272740c5211c960c5"></a>

```
char* setlocale (int category, const char * locale )
```

 **Description:**

Sets the current locale information based on input parameters. 

If  **locale**  is  **NULL**, it can be used to obtain the current region settings. 

**Parameters:**

<a name="table1186984245084824"></a>
<table><thead align="left"><tr id="row1217263687084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2029296627084824"><a name="p2029296627084824"></a><a name="p2029296627084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p319107956084824"><a name="p319107956084824"></a><a name="p319107956084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row748940485084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">category</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the type of locale information used to set the impact scope of region settings. The value can be <a href="io.md#ga07c66689961056725d7f50231d740ba9">LC_CTYPE</a>, <a href="io.md#ga158abb82c565096465ade138c98970d0">LC_NUMERIC</a>, <a href="io.md#gaa652c62b53b6bf728d592bfbdc7d5852">LC_TIME</a>, <a href="io.md#gaab9cf7b1a206fb75e5884934c8d676db">LC_COLLATE</a>, <a href="io.md#ga6d033a83772ef6e6c10dbf13a6a58fb7">LC_MONETARY</a>, <a href="io.md#ga7195d6f0a8d1b9d164a3988a1b8249e8">LC_MESSAGES</a>, or <a href="io.md#ga9cc5213b5dca4f8e48e64586ee444c33">LC_ALL</a>. The region settings include the date format, numeric format, currency format, character processing, and character comparison. The current region settings can affect only one aspect of the content or all the content. </td>
</tr>
<tr id="row1263091447084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">locale</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the string containing region names. These names are system-specific, but at least the following three language environments must exist: </td>
</tr>
</tbody>
</table>

<a name="table823066188084824"></a>
<table><thead align="left"><tr id="row664477564084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p470333329084824"><a name="p470333329084824"></a><a name="p470333329084824"></a>Language Name </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2063077379084824"><a name="p2063077379084824"></a><a name="p2063077379084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row543512329084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p354027180084824"><a name="p354027180084824"></a><a name="p354027180084824"></a><strong id="b2029578258084824"><a name="b2029578258084824"></a><a name="b2029578258084824"></a>C</strong> </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p736024094084824"><a name="p736024094084824"></a><a name="p736024094084824"></a>Indicates the C language execution environment. </p>
</td>
</tr>
<tr id="row1796372933084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1778628858084824"><a name="p1778628858084824"></a><a name="p1778628858084824"></a><strong id="b1529616904084824"><a name="b1529616904084824"></a><a name="b1529616904084824"></a>""</strong> </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1607293900084824"><a name="p1607293900084824"></a><a name="p1607293900084824"></a>Uses the default region settings of the current system. </p>
</td>
</tr>
<tr id="row1633330661084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1733132514084824"><a name="p1733132514084824"></a><a name="p1733132514084824"></a><strong id="b1891839544084824"><a name="b1891839544084824"></a><a name="b1891839544084824"></a>NULL</strong> </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p703482926084824"><a name="p703482926084824"></a><a name="p703482926084824"></a>No name needs to be specified. </p>
</td>
</tr>
</tbody>
</table>

**Returns:**

Returns a pointer to the string representation of the language environment set for the type if the operation is successful; returns a null pointer and the locale is not changed if the operation fails. 



## setvbuf\(\)<a name="gaf691eb990d669a9edec8a9ec721ce3bc"></a>

```
int setvbuf ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream, char * buf, int mode, size_t size )
```

 **Description:**

Sets the mode and size of the buffer for a specified stream. 

**Parameters:**

<a name="table643127338084824"></a>
<table><thead align="left"><tr id="row648630217084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1300650903084824"><a name="p1300650903084824"></a><a name="p1300650903084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2000208418084824"><a name="p2000208418084824"></a><a name="p2000208418084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row975761756084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
<tr id="row2009400368084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the start address of the buffer. </td>
</tr>
<tr id="row173645327084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">mode</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the buffer mode to set. There are three modes: <strong id="b629265195084824"><a name="b629265195084824"></a><a name="b629265195084824"></a>_IONBF</strong> (unbuffered), <strong id="b1092353825084824"><a name="b1092353825084824"></a><a name="b1092353825084824"></a> _IOLBF</strong> (line buffered), and <strong id="b496817753084824"><a name="b496817753084824"></a><a name="b496817753084824"></a>_IOFBF</strong> (fully buffered). </td>
</tr>
<tr id="row30385182084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the buffer block size when the buffer mode is <strong id="b653905379084824"><a name="b653905379084824"></a><a name="b653905379084824"></a>_IOFBF</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns a non-zero value otherwise. 



## snprintf\(\)<a name="gad76145a6edfc98981ded8815a760e0cd"></a>

```
int snprintf (char * str, size_t size, const char * format,  ... )
```

 **Description:**

Prints formatted data of a maximum of  **size**  bytes from a variable argument list to a specified string. 

**Parameters:**

<a name="table889686527084824"></a>
<table><thead align="left"><tr id="row1229938562084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1515549435084824"><a name="p1515549435084824"></a><a name="p1515549435084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p235130313084824"><a name="p235130313084824"></a><a name="p235130313084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1263777658084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">str</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to which the data is to be written. </td>
</tr>
<tr id="row1543165836084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum length of the destination string. </td>
</tr>
<tr id="row233691032084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format string. </td>
</tr>
<tr id="row1369031754084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">...</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the list of arguments corresponding to the format specifiers. </td>
</tr>
</tbody>
</table>

**Attention:**

This function can write a maximum of size-1 valid characters to the destination string. 

**Returns:**

Returns the number of formatted characters written \(excluding the terminating null character  **'\\0'**\) if the operation is successful; returns a negative value otherwise. If the return value is a non-negative value smaller than the value of  **size**, the string has been completely written.



## sprintf\(\)<a name="ga3082155ec11e7229f7a20439b31a169e"></a>

```
int sprintf (char * str, const char * format,  ... )
```

 **Description:**

Prints formatted data from a variable argument list to a specified string. 

**Parameters:**

<a name="table24183504084824"></a>
<table><thead align="left"><tr id="row451431906084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1680202057084824"><a name="p1680202057084824"></a><a name="p1680202057084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2130874884084824"><a name="p2130874884084824"></a><a name="p2130874884084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row321531698084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">str</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to which the data is to be written. </td>
</tr>
<tr id="row629739617084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format string. </td>
</tr>
<tr id="row2096803487084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">...</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the list of arguments corresponding to the format specifiers. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the total number of characters \(excluding the terminating null character  **'\\0'**\) if the operation is successful; returns a negative value otherwise. 



## sscanf\(\)<a name="gaec1e54556dca3bd701d44395d34818dd"></a>

```
int sscanf (const char * str, const char * format,  ... )
```

 **Description:**

Reads data from a character string pointed to by  **str**  and stores it based on  **format**  into the locations pointed to by the variable arguments. 

**Parameters:**

<a name="table1559609089084824"></a>
<table><thead align="left"><tr id="row1153533880084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1464947653084824"><a name="p1464947653084824"></a><a name="p1464947653084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p836805430084824"><a name="p836805430084824"></a><a name="p836805430084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row23457185084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">str</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the character string to read. </td>
</tr>
<tr id="row487751513084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format string. </td>
</tr>
<tr id="row583920874084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">...</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the list of arguments corresponding to the format specifiers. </td>
</tr>
</tbody>
</table>

**Attention:**

An asterisk \(\*\) right after the percent symbol \(such as  **%\*d**  and  **%\*s**\) in the format denotes that the value for the format will be read but will not be stored into a variable. 

**Returns:**

Returns the number of fields successfully assigned to the argument list if the operation is successful; returns  **0**  if no fields are assigned; returns  **EOF**  if a reading error occurs or the end-of-file is reached during data reading. If an encoding error occurs when characters are parsed, this function sets  **errno**  to  [EILSEQ](utils.md#gac6c071293826a4e66a717bb38db7794d). 



## tempnam\(\)<a name="ga44dcf948b2c1dc3356d2937635a27839"></a>

```
char* tempnam (const char * dir, const char * prefix )
```

 **Description:**

Creates a temporary file with a unique file name. 

**Parameters:**

<a name="table1690468791084824"></a>
<table><thead align="left"><tr id="row2063214668084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p590791559084824"><a name="p590791559084824"></a><a name="p590791559084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p790780897084824"><a name="p790780897084824"></a><a name="p790780897084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row236060750084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dir</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to directory for creating the temporary file. </td>
</tr>
<tr id="row392522974084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">prefix</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the prefix of the file name. </td>
</tr>
</tbody>
</table>

**Attention:**

Do not use this function. Use  **[mkstemp\(\)](utils.md#ga6abe6c5eb77aeaf05ad81a7425547d9e)**  or  **tmpfile\(\)**  instead. 

**Returns:**

Returns the pointer to the unique name of the created temporary file if the operation is successful; returns  **NULL**  and sets  **errno**  to indicate an error otherwise. 

**See also:**

[mkstemp\(\)](utils.md#ga6abe6c5eb77aeaf05ad81a7425547d9e)  | tmpfile\(\) 



## ungetc\(\)<a name="ga54efa95b6d5b41adec98e5b8a1a9f27b"></a>

```
int ungetc (int c, [FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream )
```

 **Description:**

Pushes a character back into a specified file stream. 

This function is usually used together with  **getc**. 

**Parameters:**

<a name="table998691973084824"></a>
<table><thead align="left"><tr id="row278166110084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p987842785084824"><a name="p987842785084824"></a><a name="p987842785084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1338820435084824"><a name="p1338820435084824"></a><a name="p1338820435084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1656527355084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">c</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the int promotion of the character to be pushed back. </td>
</tr>
<tr id="row453619659084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
</tbody>
</table>

**Attention:**

The pushed characters are returned in reverse order if multiple characters are pushed back. Only one pushback is guaranteed. 

**Returns:**

Returns the character specified in  **c**  if the operation is successful; returns  **EOF**  otherwise. 



## vasprintf\(\)<a name="ga5ec7fd90ebe6015636bce974c192c86a"></a>

```
int vasprintf (char ** strp, const char * fmt, va_list ap )
```

 **Description:**

Prints formatted data from a variable argument list to a specified character string. 

If the length of the string is uncertain, this function applies for sufficient memory space based on the length of the formatted character string. 

**Parameters:**

<a name="table607293813084824"></a>
<table><thead align="left"><tr id="row1438011657084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p506006406084824"><a name="p506006406084824"></a><a name="p506006406084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p432241264084824"><a name="p432241264084824"></a><a name="p432241264084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1642252816084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">strp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the double pointer to the start address of the target string. </td>
</tr>
<tr id="row1749394988084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fmt</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format string. </td>
</tr>
<tr id="row606028687084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ap</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates a value identifying a variable argument list initialized by using <strong id="b302078643084824"><a name="b302078643084824"></a><a name="b302078643084824"></a>va_start</strong>. </td>
</tr>
</tbody>
</table>

**Attention:**

If  **strp**  is no longer used, the applied space must be released. 

**Returns:**

Returns the number of output characters if the operation is successful; returns  **-1**  otherwise. 



## vdprintf\(\)<a name="ga0d0a950c2b4e6fba795cb7d8f2e8b8b8"></a>

```
int vdprintf (int fd, const char * format, va_list ap )
```

 **Description:**

Prints formatted data from a variable argument list to a specified file. 

**Parameters:**

<a name="table1109369388084824"></a>
<table><thead align="left"><tr id="row550842915084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1667607111084824"><a name="p1667607111084824"></a><a name="p1667607111084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1183251135084824"><a name="p1183251135084824"></a><a name="p1183251135084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1782012457084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file descriptor that identifies a file. </td>
</tr>
<tr id="row1544640601084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format string. </td>
</tr>
<tr id="row188492304084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ap</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates a value identifying a variable argument list initialized by using <strong id="b2004459037084824"><a name="b2004459037084824"></a><a name="b2004459037084824"></a>va_start</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the total number of written characters if the operation is successful; returns a negative value otherwise. 



## verr\(\)<a name="gaf5491fca8b356da75d96fc469bf32ea6"></a>

```
void verr (int eval, const char * fmt, va_list args )
```

 **Description:**

Displays error information. 

This function outputs the executable file name  **argv\[0\]**  and the accepted second formal parameter to stderr. 

**Parameters:**

<a name="table277794419084824"></a>
<table><thead align="left"><tr id="row179752216084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p357287798084824"><a name="p357287798084824"></a><a name="p357287798084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p583304514084824"><a name="p583304514084824"></a><a name="p583304514084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1134886548084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">eval</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">This function does not return, but exits with the value of <strong id="b703619944084824"><a name="b703619944084824"></a><a name="b703619944084824"></a>eval</strong>. </td>
</tr>
<tr id="row231357156084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fmt</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to format. </td>
</tr>
<tr id="row2087846856084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">args</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameters initialized by using <a href="utils.md#gaa0628ab596c3d7e78f5e08c2d98e24da">va_start</a>. </td>
</tr>
</tbody>
</table>

## verrx\(\)<a name="ga4b5f9ccd84c00dc473329e4bf64125e1"></a>

```
void verrx (int eval, const char * fmt, va_list args )
```

 **Description:**

Displays a formatted error message. 

**Parameters:**

<a name="table1959581353084824"></a>
<table><thead align="left"><tr id="row1459186692084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1635708593084824"><a name="p1635708593084824"></a><a name="p1635708593084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p371340250084824"><a name="p371340250084824"></a><a name="p371340250084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row990224109084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">eval</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">This function does not return, but exits with the value of <strong id="b1413563426084824"><a name="b1413563426084824"></a><a name="b1413563426084824"></a>eval</strong>. </td>
</tr>
<tr id="row1164357029084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fmt</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to format. </td>
</tr>
<tr id="row1490040721084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">args</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameters initialized by using <a href="utils.md#gaa0628ab596c3d7e78f5e08c2d98e24da">va_start</a>. </td>
</tr>
</tbody>
</table>

## vfprintf\(\)<a name="gad80f05917df38df3a5e1817498d67c26"></a>

```
int vfprintf ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream, const char * format, va_list ap )
```

 **Description:**

Prints formatted data from a variable argument list to a specified file stream. 

**Parameters:**

<a name="table1688618026084824"></a>
<table><thead align="left"><tr id="row1602147432084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1069715220084824"><a name="p1069715220084824"></a><a name="p1069715220084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1431606282084824"><a name="p1431606282084824"></a><a name="p1431606282084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1974375046084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
<tr id="row1345047255084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format string. </td>
</tr>
<tr id="row740192875084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ap</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates a value identifying a variable argument list initialized by using <strong id="b1732855405084824"><a name="b1732855405084824"></a><a name="b1732855405084824"></a>va_start</strong>. </td>
</tr>
</tbody>
</table>

**Attention:**

This function is generally used together with  **va\_start**  and  **va\_end**. 

**Returns:**

Returns the total number of characters \(excluding the terminating null character  **'\\0'**\) if the operation is successful; returns a negative value otherwise. 



## vfscanf\(\)<a name="gabdd32e401e37c9d954f3f0a6907500d9"></a>

```
int vfscanf ([FILE](io.md#ga912af5ab9f8a52ddd387b7defc0b49f1) * stream, const char * format, va_list ap )
```

 **Description:**

Reads data from a specified file stream and stores it based on  **format**  into the locations pointed to by the elements in the variable argument list identified by  **ap**. 

**Parameters:**

<a name="table379247048084824"></a>
<table><thead align="left"><tr id="row631024607084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1400566294084824"><a name="p1400566294084824"></a><a name="p1400566294084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p530961682084824"><a name="p530961682084824"></a><a name="p530961682084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1333200817084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">stream</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the file object that identifies a stream. </td>
</tr>
<tr id="row2043340356084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format string. </td>
</tr>
<tr id="row473806298084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ap</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates a value identifying a variable argument list initialized by using <strong id="b2111416897084824"><a name="b2111416897084824"></a><a name="b2111416897084824"></a>va_start</strong>. </td>
</tr>
</tbody>
</table>

**Attention:**

This function is generally used together with  **va\_start**  and  **va\_end**. 

**Returns:**

Returns the number of fields successfully assigned to the argument list if the operation is successful; returns  **0**  if no fields are assigned; returns  **EOF**  if a reading error occurs or the end-of-file is reached during data reading. If an encoding error occurs when characters are parsed, this function sets  **errno**  to  [EILSEQ](utils.md#gac6c071293826a4e66a717bb38db7794d). 



## vprintf\(\)<a name="gaa715ef816dc040c8b367fde4ba84d6f3"></a>

```
int vprintf (const char * format, va_list ap )
```

 **Description:**

Prints formatted data from a variable argument list to the stdout. 

**Parameters:**

<a name="table616085808084824"></a>
<table><thead align="left"><tr id="row1807482643084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1984475843084824"><a name="p1984475843084824"></a><a name="p1984475843084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1132314883084824"><a name="p1132314883084824"></a><a name="p1132314883084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2113690751084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format string. </td>
</tr>
<tr id="row554990730084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ap</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates a value identifying a variable argument list initialized by using <strong id="b458887501084824"><a name="b458887501084824"></a><a name="b458887501084824"></a>va_start</strong>. </td>
</tr>
</tbody>
</table>

**Attention:**

This function is generally used together with  **va\_start**  and  **va\_end**. 

**Returns:**

Returns the total number of characters \(excluding the terminating null character  **'\\0'**\) if the operation is successful; returns a negative value otherwise. 



## vscanf\(\)<a name="ga40250d63904acd3e898061c9eab6ead3"></a>

```
int vscanf (const char * format, va_list ap )
```

 **Description:**

Reads data from the stdin and stores it based on  **format**  into the locations pointed to by the elements in the variable argument list identified by  **ap**. 

**Parameters:**

<a name="table726368643084824"></a>
<table><thead align="left"><tr id="row716530766084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1129248415084824"><a name="p1129248415084824"></a><a name="p1129248415084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1736752293084824"><a name="p1736752293084824"></a><a name="p1736752293084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1719588358084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format string. </td>
</tr>
<tr id="row1474802002084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ap</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates a value identifying a variable argument list initialized by using <strong id="b1186793317084824"><a name="b1186793317084824"></a><a name="b1186793317084824"></a>va_start</strong>. </td>
</tr>
</tbody>
</table>

**Attention:**

This function is generally used together with  **va\_start**  and  **va\_end**. 

**Returns:**

Returns the number of fields successfully assigned to the argument list if the operation is successful; returns  **0**  if no fields are assigned; returns  **EOF**  if a reading error occurs or the end-of-file is reached during data reading. If an encoding error occurs when characters are parsed, this function sets  **errno**  to  [EILSEQ](utils.md#gac6c071293826a4e66a717bb38db7794d). 



## vsnprintf\(\)<a name="ga2cadafbeb2d6e0d5781f6e5106d41fc2"></a>

```
int vsnprintf (char * str, size_t size, const char * format, va_list ap )
```

 **Description:**

Prints formatted data of a maximum of  **size**  bytes from a variable argument list to a specified string. 

**Parameters:**

<a name="table799684618084824"></a>
<table><thead align="left"><tr id="row2014338208084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1033362730084824"><a name="p1033362730084824"></a><a name="p1033362730084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2078343437084824"><a name="p2078343437084824"></a><a name="p2078343437084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2137969478084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">str</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination character string. </td>
</tr>
<tr id="row1478148576084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum length of the destination string. </td>
</tr>
<tr id="row76950501084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format string. </td>
</tr>
<tr id="row1259815396084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ap</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates a value identifying a variable argument list initialized by using <strong id="b311080643084824"><a name="b311080643084824"></a><a name="b311080643084824"></a>va_start</strong>. </td>
</tr>
</tbody>
</table>

**Attention:**

This function can write a maximum of size-1 characters to the destination string. 

**Returns:**

Returns the number of formatted characters written \(excluding the terminating null character  **'\\0'**\) if the operation is successful; returns a negative value otherwise. If the return value is a non-negative value smaller than the value of  **size**, the string has been completely written.



## vsprintf\(\)<a name="gaab3db67c98c32122fcb3d076d4207bbc"></a>

```
int vsprintf (char * str, const char * format, va_list ap )
```

 **Description:**

Prints formatted data from a variable argument list to a specified string. 

**Parameters:**

<a name="table530680646084824"></a>
<table><thead align="left"><tr id="row1458100344084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p210151366084824"><a name="p210151366084824"></a><a name="p210151366084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1062663134084824"><a name="p1062663134084824"></a><a name="p1062663134084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1327838596084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">str</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the destination character string. </td>
</tr>
<tr id="row432553948084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format string. </td>
</tr>
<tr id="row14470647084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ap</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates a value identifying a variable argument list initialized by using <strong id="b932987663084824"><a name="b932987663084824"></a><a name="b932987663084824"></a>va_start</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the total number of characters written \(excluding the terminating null character  **'\\0'**\) if the operation is successful; returns a negative value otherwise. 



## vsscanf\(\)<a name="gab1c4552aba80fe03c9b45fe27f4331ad"></a>

```
int vsscanf (const char * str, const char * format, va_list ap )
```

 **Description:**

Reads data from a specified string and stores it based on  **format**  into the locations pointed to by the elements in the variable argument list identified by  **ap**. 

**Parameters:**

<a name="table1126409088084824"></a>
<table><thead align="left"><tr id="row496794604084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1713763709084824"><a name="p1713763709084824"></a><a name="p1713763709084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p988874887084824"><a name="p988874887084824"></a><a name="p988874887084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1734613927084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">str</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the character string to read. </td>
</tr>
<tr id="row1086933683084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the format string. </td>
</tr>
<tr id="row1354565118084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ap</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates a value identifying a variable argument list initialized by using <strong id="b2102355142084824"><a name="b2102355142084824"></a><a name="b2102355142084824"></a>va_start</strong>. </td>
</tr>
</tbody>
</table>

**Attention:**

This function is generally used together with  **va\_start**  and  **va\_end**. 

**Returns:**

Returns the number of fields successfully assigned to the argument list if the operation is successful; returns  **0**  if no fields are assigned; returns  **EOF**  if a reading error occurs or the end-of-file is reached during data reading. If an encoding error occurs when characters are parsed, this function sets  **errno**  to  [EILSEQ](utils.md#gac6c071293826a4e66a717bb38db7794d). 



## vwarn\(\)<a name="ga9ca1ffba0c6f5df7b172d25917611b4a"></a>

```
void vwarn (const char * fmt, va_list args )
```

 **Description:**

Displays a formatted error message on the stderr output. 

If the  **fmt**  parameter is not  **NULL**, stderr displays the error code description obtained from strerror\(errno\), followed by a space and a colon \(:\), and the error message to print. 

**Parameters:**

<a name="table1994702449084824"></a>
<table><thead align="left"><tr id="row1504113977084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p369320350084824"><a name="p369320350084824"></a><a name="p369320350084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1896117161084824"><a name="p1896117161084824"></a><a name="p1896117161084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row465695802084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fmt</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to format. </td>
</tr>
<tr id="row189666967084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">args</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameters initialized by using <a href="utils.md#gaa0628ab596c3d7e78f5e08c2d98e24da">va_start</a>. </td>
</tr>
</tbody>
</table>

## vwarnx\(\)<a name="ga22924aaaaa6b6e8bba4c76d0a0fe86cd"></a>

```
void vwarnx (const char * fmt, va_list args )
```

 **Description:**

Displays a formatted error message on the stderr output. 

If the  **fmt**  parameter is not  **NULL**, stderr displays the error code description obtained from strerror\(errno\), followed by a space and a colon \(:\), and the error message to print. 

**Parameters:**

<a name="table1180382374084824"></a>
<table><thead align="left"><tr id="row409040990084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p735321499084824"><a name="p735321499084824"></a><a name="p735321499084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p695405690084824"><a name="p695405690084824"></a><a name="p695405690084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row811168708084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fmt</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to format. </td>
</tr>
<tr id="row1072921405084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">args</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameters initialized by using <a href="utils.md#gaa0628ab596c3d7e78f5e08c2d98e24da">va_start</a>. </td>
</tr>
</tbody>
</table>

## warn\(\)<a name="gaf80d19f1297a11626fab61a248959c71"></a>

```
void warn (const char * fmt,  ... )
```

 **Description:**

Displays a formatted error message on the standard error \(stderr\) output. 

If the  **fmt**  parameter is not  **NULL**, stderr displays the error code description obtained from strerror\(errno\), followed by a space and a colon \(:\), and the error message to print. 

**Parameters:**

<a name="table548082059084824"></a>
<table><thead align="left"><tr id="row1200513512084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1070908807084824"><a name="p1070908807084824"></a><a name="p1070908807084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p137336201084824"><a name="p137336201084824"></a><a name="p137336201084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row148543467084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fmt</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to format. </td>
</tr>
<tr id="row1542990366084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">...</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameters corresponding to the format declaration. </td>
</tr>
</tbody>
</table>

## warnx\(\)<a name="ga58f3d9691c146f86e562022d39567b7f"></a>

```
void warnx (const char * fmt,  ... )
```

 **Description:**

Displays a formatted error message on the stderr output. 

If the  **fmt**  parameter is not  **NULL**, stderr displays the error code description obtained from strerror\(errno\), followed by a space and a colon \(:\), and the error message to print. 

**Parameters:**

<a name="table830248555084824"></a>
<table><thead align="left"><tr id="row414627215084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p801471892084824"><a name="p801471892084824"></a><a name="p801471892084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1888376368084824"><a name="p1888376368084824"></a><a name="p1888376368084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1729048785084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fmt</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string to format. </td>
</tr>
<tr id="row944223427084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">...</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameters corresponding to the format declaration. </td>
</tr>
</tbody>
</table>

## wordfree\(\)<a name="ga1b296371dffe80c14d0c9ebd27165140"></a>

```
void wordfree ([wordexp_t](wordexp_t.md) * we)
```

 **Description:**

Frees a word expansion buffer. 

**Parameters:**

<a name="table753630191084824"></a>
<table><thead align="left"><tr id="row1672216035084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1230986898084824"><a name="p1230986898084824"></a><a name="p1230986898084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p230614428084824"><a name="p230614428084824"></a><a name="p230614428084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1194213738084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">we</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the word expansion buffer to free. </td>
</tr>
</tbody>
</table>

## writev\(\)<a name="gad57f362a0aef72b52ea59288f74dd1ea"></a>

```
ssize_t writev (int fd, const struct iovec * iov, int iovcnt )
```

 **Description:**

Writes a given length of data into a file. 

This function is used to write the  **iovcnt**  length of  **iov**  to  **fd**. 

**Parameters:**

<a name="table904494806084824"></a>
<table><thead align="left"><tr id="row1643658199084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p133359513084824"><a name="p133359513084824"></a><a name="p133359513084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p201553841084824"><a name="p201553841084824"></a><a name="p201553841084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row152366516084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the file descriptor. </td>
</tr>
<tr id="row218632314084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">iov</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the multi-group buffer. </td>
</tr>
<tr id="row1035162795084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">iovcnt</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of buffers. For details, see <a href="utils.md#ga25080e819a36fcf9aede01a6e7298ea4">IOV_MAX</a>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of bytes written if the operation is successful; returns  **-1**  and sets  **errno**  to a value if the operation fails. If  **errno**  is set to  **EINVAL**, the sum of the  **iov\_len**  values overflows an  **ssize\_t**  value, or the vector count  **iovcnt**  is less than 0 or greater than the permitted maximum. 



