# Audio<a name="EN-US_TOPIC_0000001054479511"></a>

## **Overview**<a name="section17912038084825"></a>

Defines audio-related APIs, including custom data types and functions for loading drivers, accessing a driver adapter, and rendering and capturing audios. 

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section1268417438084825"></a>

## Files<a name="files"></a>

<a name="table456970370084825"></a>
<table><thead align="left"><tr id="row1702118338084825"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1236444550084825"><a name="p1236444550084825"></a><a name="p1236444550084825"></a>File Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p80070986084825"><a name="p80070986084825"></a><a name="p80070986084825"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1981079241084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p977704517084825"><a name="p977704517084825"></a><a name="p977704517084825"></a><a href="audio_adapter-h.md">audio_adapter.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1851977110084825"><a name="p1851977110084825"></a><a name="p1851977110084825"></a>Declares APIs for operations related to the audio adapter. </p>
</td>
</tr>
<tr id="row768865526084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1900194596084825"><a name="p1900194596084825"></a><a name="p1900194596084825"></a><a href="audio_attribute-h.md">audio_attribute.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1673696133084825"><a name="p1673696133084825"></a><a name="p1673696133084825"></a>Declares APIs for audio attributes. </p>
</td>
</tr>
<tr id="row1611711583084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2020963390084825"><a name="p2020963390084825"></a><a name="p2020963390084825"></a><a href="audio_capture-h.md">audio_capture.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1989186762084825"><a name="p1989186762084825"></a><a name="p1989186762084825"></a>Declares APIs for audio capturing. </p>
</td>
</tr>
<tr id="row819588749084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1503088240084825"><a name="p1503088240084825"></a><a name="p1503088240084825"></a><a href="audio_control-h.md">audio_control.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1746788172084825"><a name="p1746788172084825"></a><a name="p1746788172084825"></a>Declares APIs for audio control. </p>
</td>
</tr>
<tr id="row104530195084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1547173905084825"><a name="p1547173905084825"></a><a name="p1547173905084825"></a><a href="audio_manager-h.md">audio_manager.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p382397809084825"><a name="p382397809084825"></a><a name="p382397809084825"></a>Declares APIs for audio adapter management and loading. </p>
</td>
</tr>
<tr id="row621030756084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p471308719084825"><a name="p471308719084825"></a><a name="p471308719084825"></a><a href="audio_render-h.md">audio_render.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p74297960084825"><a name="p74297960084825"></a><a name="p74297960084825"></a>Declares APIs for audio rendering. </p>
</td>
</tr>
<tr id="row1536025529084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p720939814084825"><a name="p720939814084825"></a><a name="p720939814084825"></a><a href="audio_scene-h.md">audio_scene.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1681745115084825"><a name="p1681745115084825"></a><a name="p1681745115084825"></a>Declares APIs for audio scenes. </p>
</td>
</tr>
<tr id="row1976948422084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1801156357084825"><a name="p1801156357084825"></a><a name="p1801156357084825"></a><a href="audio_types-h.md">audio_types.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p806677399084825"><a name="p806677399084825"></a><a name="p806677399084825"></a>Defines custom data types used in API declarations for the audio module, including audio ports, adapter descriptors, device descriptors, scene descriptors, sampling attributes, and timestamp. </p>
</td>
</tr>
<tr id="row794524562084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p46653876084825"><a name="p46653876084825"></a><a name="p46653876084825"></a><a href="audio_volume-h.md">audio_volume.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1130285271084825"><a name="p1130285271084825"></a><a name="p1130285271084825"></a>Declares APIs for audio volume. </p>
</td>
</tr>
</tbody>
</table>

## Data Structures<a name="nested-classes"></a>

<a name="table1802718288084825"></a>
<table><thead align="left"><tr id="row1126119952084825"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p4928580084825"><a name="p4928580084825"></a><a name="p4928580084825"></a>Data Structure Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p480526313084825"><a name="p480526313084825"></a><a name="p480526313084825"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1414086373084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p173121875084825"><a name="p173121875084825"></a><a name="p173121875084825"></a><a href="audioadapter.md">AudioAdapter</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p94037513084825"><a name="p94037513084825"></a><a name="p94037513084825"></a>Provides audio adapter capabilities, including initializing ports, creating rendering and capturing tasks, and obtaining the port capability set. </p>
</td>
</tr>
<tr id="row99661825084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1633223067084825"><a name="p1633223067084825"></a><a name="p1633223067084825"></a><a href="audioattribute.md">AudioAttribute</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p691533041084825"><a name="p691533041084825"></a><a name="p691533041084825"></a>Provides attribute-related APIs for audio rendering or capturing, including functions to obtain frame information and set audio sampling attributes. </p>
</td>
</tr>
<tr id="row759009595084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1626231006084825"><a name="p1626231006084825"></a><a name="p1626231006084825"></a><a href="audiocapture.md">AudioCapture</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p323060169084825"><a name="p323060169084825"></a><a name="p323060169084825"></a>Provides capabilities for audio capturing, including controlling the capturing, setting audio attributes, scenes, and volume, and capturing audio frames. </p>
</td>
</tr>
<tr id="row2109866197084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p968795113084825"><a name="p968795113084825"></a><a name="p968795113084825"></a><a href="audiocontrol.md">AudioControl</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2146757997084825"><a name="p2146757997084825"></a><a name="p2146757997084825"></a>Provides control-related APIs for audio rendering or capturing, including functions to start, stop, pause, and resume audio rendering or capturing, and flush data in the audio buffer. </p>
</td>
</tr>
<tr id="row1494297266084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2142895946084825"><a name="p2142895946084825"></a><a name="p2142895946084825"></a><a href="audiomanager.md">AudioManager</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1130824115084825"><a name="p1130824115084825"></a><a name="p1130824115084825"></a>Manages audio adapters through a specific adapter driver program loaded based on the given audio adapter descriptor. </p>
</td>
</tr>
<tr id="row872909915084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p458205965084825"><a name="p458205965084825"></a><a name="p458205965084825"></a><a href="audiorender.md">AudioRender</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1984944532084825"><a name="p1984944532084825"></a><a name="p1984944532084825"></a>Provides capabilities for audio rendering, including controlling the rendering, setting audio attributes, scenes, and volume, obtaining hardware latency, and rendering audio frames. </p>
</td>
</tr>
<tr id="row398547216084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2137955395084825"><a name="p2137955395084825"></a><a name="p2137955395084825"></a><a href="audioscene.md">AudioScene</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1324169316084825"><a name="p1324169316084825"></a><a name="p1324169316084825"></a>Provides scene-related APIs for audio rendering or capturing, including functions to select an audio scene and check whether the configuration of an audio scene is supported. </p>
</td>
</tr>
<tr id="row1975530372084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1182262569084825"><a name="p1182262569084825"></a><a name="p1182262569084825"></a><a href="audioport.md">AudioPort</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p25261728084825"><a name="p25261728084825"></a><a name="p25261728084825"></a>Defines the audio port. </p>
</td>
</tr>
<tr id="row939051669084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1912470654084825"><a name="p1912470654084825"></a><a name="p1912470654084825"></a><a href="audioadapterdescriptor.md">AudioAdapterDescriptor</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1956912013084825"><a name="p1956912013084825"></a><a name="p1956912013084825"></a>Defines the audio adapter descriptor. </p>
</td>
</tr>
<tr id="row1810692342084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1963665318084825"><a name="p1963665318084825"></a><a name="p1963665318084825"></a><a href="audiodevicedescriptor.md">AudioDeviceDescriptor</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p622884411084825"><a name="p622884411084825"></a><a name="p622884411084825"></a>Defines the audio device descriptor. </p>
</td>
</tr>
<tr id="row305177583084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1876113027084825"><a name="p1876113027084825"></a><a name="p1876113027084825"></a><a href="audioscenedescriptor.md">AudioSceneDescriptor</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1506285208084825"><a name="p1506285208084825"></a><a name="p1506285208084825"></a>Defines the audio scene descriptor. </p>
</td>
</tr>
<tr id="row164654852084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1969224723084825"><a name="p1969224723084825"></a><a name="p1969224723084825"></a><a href="audioscenedescriptor-scenedesc.md">AudioSceneDescriptor::SceneDesc</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p334406139084825"><a name="p334406139084825"></a><a name="p334406139084825"></a>Describes the audio scene. </p>
</td>
</tr>
<tr id="row239470668084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p706076530084825"><a name="p706076530084825"></a><a name="p706076530084825"></a><a href="audiosampleattributes.md">AudioSampleAttributes</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p238829528084825"><a name="p238829528084825"></a><a name="p238829528084825"></a>Defines audio sampling attributes. </p>
</td>
</tr>
<tr id="row1667269048084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p853075861084825"><a name="p853075861084825"></a><a name="p853075861084825"></a><a href="audiotimestamp.md">AudioTimeStamp</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p717090233084825"><a name="p717090233084825"></a><a name="p717090233084825"></a>Defines the audio timestamp, which is a substitute for POSIX <strong id="b472715045084825"><a name="b472715045084825"></a><a name="b472715045084825"></a>timespec</strong>. </p>
</td>
</tr>
<tr id="row1466140993084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p121460597084825"><a name="p121460597084825"></a><a name="p121460597084825"></a><a href="audiosubportcapability.md">AudioSubPortCapability</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1405271059084825"><a name="p1405271059084825"></a><a name="p1405271059084825"></a>Defines the sub-port capability. </p>
</td>
</tr>
<tr id="row225564775084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1004423607084825"><a name="p1004423607084825"></a><a name="p1004423607084825"></a><a href="audioportcapability.md">AudioPortCapability</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p652324062084825"><a name="p652324062084825"></a><a name="p652324062084825"></a>Defines the audio port capability. </p>
</td>
</tr>
<tr id="row789456503084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p900952211084825"><a name="p900952211084825"></a><a name="p900952211084825"></a><a href="audiovolume.md">AudioVolume</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1454372280084825"><a name="p1454372280084825"></a><a name="p1454372280084825"></a>Provides volume-related APIs for audio rendering or capturing, including functions to set the mute operation, volume, and gain. </p>
</td>
</tr>
</tbody>
</table>

## Typedefs<a name="typedef-members"></a>

<a name="table182605624084825"></a>
<table><thead align="left"><tr id="row845929926084825"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1095018819084825"><a name="p1095018819084825"></a><a name="p1095018819084825"></a>Typedef Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1515211930084825"><a name="p1515211930084825"></a><a name="p1515211930084825"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row436129416084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p671149657084825"><a name="p671149657084825"></a><a name="p671149657084825"></a><em id="ga18675ddb073465fdeac33a897f675d79"><a name="ga18675ddb073465fdeac33a897f675d79"></a><a name="ga18675ddb073465fdeac33a897f675d79"></a></em>AudioHandle </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p282487847084825"><a name="p282487847084825"></a><a name="p282487847084825"></a><strong id="b1673077389"><a name="b1673077389"></a><a name="b1673077389"></a></strong> typedef void * </p>
<p id="p835098438084825"><a name="p835098438084825"></a><a name="p835098438084825"></a>Defines the audio handle. </p>
</td>
</tr>
</tbody>
</table>

## Enumerations<a name="enum-members"></a>

<a name="table1814219955084825"></a>
<table><thead align="left"><tr id="row1509401570084825"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1282339081084825"><a name="p1282339081084825"></a><a name="p1282339081084825"></a>Enumeration Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2123378263084825"><a name="p2123378263084825"></a><a name="p2123378263084825"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1135327410084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p312752499084825"><a name="p312752499084825"></a><a name="p312752499084825"></a><a href="audio.md#ga68ff7140b15790debbac4bbc62f8e9f8">AudioPortDirection</a> { <a href="audio.md#gga68ff7140b15790debbac4bbc62f8e9f8af54f110a0f64337d474989fbac06bc22">PORT_OUT</a> = 0x1u, <a href="audio.md#gga68ff7140b15790debbac4bbc62f8e9f8a154a6db110515b7afde52d3a36d57846">PORT_IN</a> = 0x2u, <a href="audio.md#gga68ff7140b15790debbac4bbc62f8e9f8a87e14fe9da9c332ba29185b9213d7bbf">PORT_OUT_IN</a> = 0x3u }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1349529263084825"><a name="p1349529263084825"></a><a name="p1349529263084825"></a>Enumerates the audio port type. </p>
</td>
</tr>
<tr id="row1752168084084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1590641023084825"><a name="p1590641023084825"></a><a name="p1590641023084825"></a><a href="audio.md#gaa7114aeeccf3ac4f5f7e1d880bcfa835">AudioPortPin</a> {   <a href="audio.md#ggaa7114aeeccf3ac4f5f7e1d880bcfa835ad2f867652c04c17517db7731af03bf20">PIN_NONE</a> = 0x0u, <a href="audio.md#ggaa7114aeeccf3ac4f5f7e1d880bcfa835ab1070439bab93e06446c21157771dd6f">PIN_OUT_SPEAKER</a> = 0x1u, <a href="audio.md#ggaa7114aeeccf3ac4f5f7e1d880bcfa835a271013721c8840cc2700c19b3ff8d0a6">PIN_OUT_HEADSET</a> = 0x2u, <a href="audio.md#ggaa7114aeeccf3ac4f5f7e1d880bcfa835a411e9037214c75d22c9080505cf9cae6">PIN_OUT_LINEOUT</a> = 0x4u,   <a href="audio.md#ggaa7114aeeccf3ac4f5f7e1d880bcfa835ab4aaa2ec71ec77480f60743cd79340b9">PIN_OUT_HDMI</a> = 0x8u, <a href="audio.md#ggaa7114aeeccf3ac4f5f7e1d880bcfa835a336001f5685d9c206b1251714553b485">PIN_IN_MIC</a> = 0x8000001u, <a href="audio.md#ggaa7114aeeccf3ac4f5f7e1d880bcfa835aaeca21ac0a7b249905d1cea5b683f574">PIN_IN_HS_MIC</a> = 0x8000002u, <a href="audio.md#ggaa7114aeeccf3ac4f5f7e1d880bcfa835a5146add03ff98f06648567bb0e02a477">PIN_IN_LINEIN</a> = 0x8000004u }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p644273612084825"><a name="p644273612084825"></a><a name="p644273612084825"></a>Enumerates the pin of an audio adapter. </p>
</td>
</tr>
<tr id="row1634883298084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p987134234084825"><a name="p987134234084825"></a><a name="p987134234084825"></a><a href="audio.md#gaf210d41d152890f3aaf2aaac99bd28d5">AudioCategory</a> { <a href="audio.md#ggaf210d41d152890f3aaf2aaac99bd28d5a6ac6cfd90dcc34de100c1cecb3df44c3">AUDIO_IN_MEDIA</a> = 0, <a href="audio.md#ggaf210d41d152890f3aaf2aaac99bd28d5a474576c773934a0df994bad4cf781b41">AUDIO_IN_COMMUNICATION</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1473238556084825"><a name="p1473238556084825"></a><a name="p1473238556084825"></a>Enumerates the audio category. </p>
</td>
</tr>
<tr id="row1152775690084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p50297353084825"><a name="p50297353084825"></a><a name="p50297353084825"></a><a href="audio.md#ga98d5d077cca088ddf77314871474fe59">AudioFormat</a> {   <a href="audio.md#gga98d5d077cca088ddf77314871474fe59a321cc2160af35aa86b8ee55f231ef1e6">AUDIO_FORMAT_PCM_8_BIT</a> = 0x1u, <a href="audio.md#gga98d5d077cca088ddf77314871474fe59ae188cf87c8f2e6218c74b3b2385068e6">AUDIO_FORMAT_PCM_16_BIT</a> = 0x2u, <a href="audio.md#gga98d5d077cca088ddf77314871474fe59a21eb864e2117df577dcd90ad81da3b14">AUDIO_FORMAT_PCM_24_BIT</a> = 0x3u, <a href="audio.md#gga98d5d077cca088ddf77314871474fe59adf7a0bf1f3dd15c9c43fac07c0c6ea26">AUDIO_FORMAT_PCM_32_BIT</a> = 0x4u,   <a href="audio.md#gga98d5d077cca088ddf77314871474fe59a5a781e6f8b145066ae7fb2c310804bab">AUDIO_FORMAT_AAC_MAIN</a> = 0x1000001u, <a href="audio.md#gga98d5d077cca088ddf77314871474fe59a3d4bc5d534d0452635455ed8d2cade57">AUDIO_FORMAT_AAC_LC</a> = 0x1000002u, <a href="audio.md#gga98d5d077cca088ddf77314871474fe59ad4baf87ff9f4684c03483c572052b700">AUDIO_FORMAT_AAC_LD</a> = 0x1000003u, <a href="audio.md#gga98d5d077cca088ddf77314871474fe59a4b8d42988fecf03e2bf73c4395501852">AUDIO_FORMAT_AAC_ELD</a> = 0x1000004u,   <a href="audio.md#gga98d5d077cca088ddf77314871474fe59abaddb86f122d3185de9407dbc673bf0e">AUDIO_FORMAT_AAC_HE_V1</a> = 0x1000005u, <a href="audio.md#gga98d5d077cca088ddf77314871474fe59ab610e0121e0b5076b3f78831e3c237fd">AUDIO_FORMAT_AAC_HE_V2</a> = 0x1000006u }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1781521422084825"><a name="p1781521422084825"></a><a name="p1781521422084825"></a>Enumerates the audio format. </p>
</td>
</tr>
<tr id="row537718345084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p648338938084825"><a name="p648338938084825"></a><a name="p648338938084825"></a><a href="audio.md#ga137eb03027d5947ea294b32f5095b83c">AudioChannelMask</a> { <a href="audio.md#gga137eb03027d5947ea294b32f5095b83ca0419483310bfc5abe46a0c586070ed18">AUDIO_CHANNEL_FRONT_LEFT</a> = 0x1, <a href="audio.md#gga137eb03027d5947ea294b32f5095b83ca05525a25c5912eda05e9a8786a743a75">AUDIO_CHANNEL_FRONT_RIGHT</a> = 0x2, <a href="audio.md#gga137eb03027d5947ea294b32f5095b83ca0479e1cd2137cbbad68efae1d2b2c9a9">AUDIO_CHANNEL_MONO</a> = 0x1u, <a href="audio.md#gga137eb03027d5947ea294b32f5095b83ca70f2212ea5439c13f7fcba3e30b15c1a">AUDIO_CHANNEL_STEREO</a> = 0x3u }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p872930634084825"><a name="p872930634084825"></a><a name="p872930634084825"></a>Enumerates the audio channel mask. </p>
</td>
</tr>
<tr id="row2068933381084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1421568318084825"><a name="p1421568318084825"></a><a name="p1421568318084825"></a><a href="audio.md#ga7053fcaa56d1dc47d2fcd83ee131fe4c">AudioSampleRatesMask</a> {   <a href="audio.md#gga7053fcaa56d1dc47d2fcd83ee131fe4ca046a26906a4df81bfc38c583ba3606e9">AUDIO_SAMPLE_RATE_MASK_8000</a> = 0x1u, <a href="audio.md#gga7053fcaa56d1dc47d2fcd83ee131fe4caf1f34aa763f2bf6d5f43178f2d335d10">AUDIO_SAMPLE_RATE_MASK_12000</a> = 0x2u, <a href="audio.md#gga7053fcaa56d1dc47d2fcd83ee131fe4ca5f13b000ef455b858506fc90d17e2dd7">AUDIO_SAMPLE_RATE_MASK_11025</a> = 0x4u, <a href="audio.md#gga7053fcaa56d1dc47d2fcd83ee131fe4ca3102248493467e00d16c2cf1971635a7">AUDIO_SAMPLE_RATE_MASK_16000</a> = 0x8u,   <a href="audio.md#gga7053fcaa56d1dc47d2fcd83ee131fe4cae7cfb2244a15cd133373cfa5e96ec82e">AUDIO_SAMPLE_RATE_MASK_22050</a> = 0x10u, <a href="audio.md#gga7053fcaa56d1dc47d2fcd83ee131fe4cacce4defc0cf23abfe52d399b4aa68fdf">AUDIO_SAMPLE_RATE_MASK_24000</a> = 0x20u, <a href="audio.md#gga7053fcaa56d1dc47d2fcd83ee131fe4ca5594285d8ef3897e9f29a15e0795b814">AUDIO_SAMPLE_RATE_MASK_32000</a> = 0x40u, <a href="audio.md#gga7053fcaa56d1dc47d2fcd83ee131fe4ca52345265822f55a62b2e038438daf37e">AUDIO_SAMPLE_RATE_MASK_44100</a> = 0x80u,   <a href="audio.md#gga7053fcaa56d1dc47d2fcd83ee131fe4caa52c49624fecf6d9f1d075d0d3ad0bbf">AUDIO_SAMPLE_RATE_MASK_48000</a> = 0x100u, <a href="audio.md#gga7053fcaa56d1dc47d2fcd83ee131fe4caf111a8b9762ec169361a106ba7efdb0f">AUDIO_SAMPLE_RATE_MASK_64000</a> = 0x200u, <a href="audio.md#gga7053fcaa56d1dc47d2fcd83ee131fe4caa9e4deb07b2a7c32e5a19b8c81d9fd0d">AUDIO_SAMPLE_RATE_MASK_96000</a> = 0x400u, <a href="audio.md#gga7053fcaa56d1dc47d2fcd83ee131fe4ca41f8d22ab95c84d0acb3d0c78679274c">AUDIO_SAMPLE_RATE_MASK_INVALID</a> = 0xFFFFFFFFu }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2095280095084825"><a name="p2095280095084825"></a><a name="p2095280095084825"></a>Enumerates masks of audio sampling rates. </p>
</td>
</tr>
<tr id="row1969862044084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p161445374084825"><a name="p161445374084825"></a><a name="p161445374084825"></a><a href="audio.md#ga186d2d4f9a2ecacb80cd2cce2bd26f0e">AudioPortPassthroughMode</a> { <a href="audio.md#gga186d2d4f9a2ecacb80cd2cce2bd26f0ea48da60ec7958d35e8884e67cc32cb465">PORT_PASSTHROUGH_LPCM</a> = 0x1, <a href="audio.md#gga186d2d4f9a2ecacb80cd2cce2bd26f0eaf44936c424fbadafda9e1a12829b291f">PORT_PASSTHROUGH_RAW</a> = 0x2, <a href="audio.md#gga186d2d4f9a2ecacb80cd2cce2bd26f0eada09d902428d269446b94c2b7e9eb95e">PORT_PASSTHROUGH_HBR2LBR</a> = 0x4, <a href="audio.md#gga186d2d4f9a2ecacb80cd2cce2bd26f0ea6fd7a77031d807247e159c3deec07e11">PORT_PASSTHROUGH_AUTO</a> = 0x8 }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p801396168084825"><a name="p801396168084825"></a><a name="p801396168084825"></a>Enumerates the passthrough data transmission mode of an audio port. </p>
</td>
</tr>
<tr id="row1727473090084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p834116760084825"><a name="p834116760084825"></a><a name="p834116760084825"></a><a href="audio.md#ga78aab1fafb9657451804e42b42897123">AudioChannelMode</a> {   <a href="audio.md#gga78aab1fafb9657451804e42b42897123aa97ec21f6627e1dfd4854b5b470cdfba">AUDIO_CHANNEL_NORMAL</a> = 0, <a href="audio.md#gga78aab1fafb9657451804e42b42897123a47fd61e4531acb6b5cc058ac26af5d51">AUDIO_CHANNEL_BOTH_LEFT</a>, <a href="audio.md#gga78aab1fafb9657451804e42b42897123a3341b11cad1d47bda2b4a2be60dda023">AUDIO_CHANNEL_BOTH_RIGHT</a>, <a href="audio.md#gga78aab1fafb9657451804e42b42897123a3f2e41939cc24c51213d8730c32e74e9">AUDIO_CHANNEL_EXCHANGE</a>,   <a href="audio.md#gga78aab1fafb9657451804e42b42897123a2c1537bccd5c2a05d1c515e58ec4481e">AUDIO_CHANNEL_MIX</a>, <a href="audio.md#gga78aab1fafb9657451804e42b42897123a485c0423ce07fbb7f844a387ed9bb546">AUDIO_CHANNEL_LEFT_MUTE</a>, <a href="audio.md#gga78aab1fafb9657451804e42b42897123a0878cdf6f3e0d9ae9ae1f61b7f74257e">AUDIO_CHANNEL_RIGHT_MUTE</a>, <a href="audio.md#gga78aab1fafb9657451804e42b42897123a22540143eb96abf8176e73c19fc0d8e5">AUDIO_CHANNEL_BOTH_MUTE</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p343927374084825"><a name="p343927374084825"></a><a name="p343927374084825"></a>Enumerates channel modes for audio rendering. </p>
</td>
</tr>
</tbody>
</table>

## Functions<a name="func-members"></a>

<a name="table194398382084825"></a>
<table><thead align="left"><tr id="row1513885812084825"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1065665411084825"><a name="p1065665411084825"></a><a name="p1065665411084825"></a>Function Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p316989166084825"><a name="p316989166084825"></a><a name="p316989166084825"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row427384364084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p182694093084825"><a name="p182694093084825"></a><a name="p182694093084825"></a><a href="audio.md#ga0c7824f4fe89625d3c9b1d0534ad0151">GetAudioManagerFuncs</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p878475947084825"><a name="p878475947084825"></a><a name="p878475947084825"></a>struct <a href="audiomanager.md">AudioManager</a> * </p>
<p id="p1721756526084825"><a name="p1721756526084825"></a><a name="p1721756526084825"></a>Obtains the operation function list of the <a href="audiomanager.md">AudioManager</a> class. </p>
</td>
</tr>
</tbody>
</table>

## **Details**<a name="section371358399084825"></a>

## **Enumeration Type Documentation**<a name="section361237366084825"></a>

## AudioCategory<a name="gaf210d41d152890f3aaf2aaac99bd28d5"></a>

```
enum [AudioCategory](audio.md#gaf210d41d152890f3aaf2aaac99bd28d5)
```

 **Description:**

Enumerates the audio category. 

<a name="table866318671084825"></a>
<table><thead align="left"><tr id="row581686794084825"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p820377135084825"><a name="p820377135084825"></a><a name="p820377135084825"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1874833772084825"><a name="p1874833772084825"></a><a name="p1874833772084825"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row808697268084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaf210d41d152890f3aaf2aaac99bd28d5a6ac6cfd90dcc34de100c1cecb3df44c3"><a name="ggaf210d41d152890f3aaf2aaac99bd28d5a6ac6cfd90dcc34de100c1cecb3df44c3"></a><a name="ggaf210d41d152890f3aaf2aaac99bd28d5a6ac6cfd90dcc34de100c1cecb3df44c3"></a></strong>AUDIO_IN_MEDIA </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p614245258084825"><a name="p614245258084825"></a><a name="p614245258084825"></a>Media </p>
 </td>
</tr>
<tr id="row2145762799084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaf210d41d152890f3aaf2aaac99bd28d5a474576c773934a0df994bad4cf781b41"><a name="ggaf210d41d152890f3aaf2aaac99bd28d5a474576c773934a0df994bad4cf781b41"></a><a name="ggaf210d41d152890f3aaf2aaac99bd28d5a474576c773934a0df994bad4cf781b41"></a></strong>AUDIO_IN_COMMUNICATION </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2040548361084825"><a name="p2040548361084825"></a><a name="p2040548361084825"></a>Communications </p>
 </td>
</tr>
</tbody>
</table>

## AudioChannelMask<a name="ga137eb03027d5947ea294b32f5095b83c"></a>

```
enum [AudioChannelMask](audio.md#ga137eb03027d5947ea294b32f5095b83c)
```

 **Description:**

Enumerates the audio channel mask. 

A mask describes an audio channel position. 

<a name="table2115177322084825"></a>
<table><thead align="left"><tr id="row1416192255084825"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1408233891084825"><a name="p1408233891084825"></a><a name="p1408233891084825"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1288306073084825"><a name="p1288306073084825"></a><a name="p1288306073084825"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1891229079084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga137eb03027d5947ea294b32f5095b83ca0419483310bfc5abe46a0c586070ed18"><a name="gga137eb03027d5947ea294b32f5095b83ca0419483310bfc5abe46a0c586070ed18"></a><a name="gga137eb03027d5947ea294b32f5095b83ca0419483310bfc5abe46a0c586070ed18"></a></strong>AUDIO_CHANNEL_FRONT_LEFT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1470294772084825"><a name="p1470294772084825"></a><a name="p1470294772084825"></a>Front left channel </p>
 </td>
</tr>
<tr id="row1424557453084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga137eb03027d5947ea294b32f5095b83ca05525a25c5912eda05e9a8786a743a75"><a name="gga137eb03027d5947ea294b32f5095b83ca05525a25c5912eda05e9a8786a743a75"></a><a name="gga137eb03027d5947ea294b32f5095b83ca05525a25c5912eda05e9a8786a743a75"></a></strong>AUDIO_CHANNEL_FRONT_RIGHT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p281292006084825"><a name="p281292006084825"></a><a name="p281292006084825"></a>Front right channel </p>
 </td>
</tr>
<tr id="row2100237610084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga137eb03027d5947ea294b32f5095b83ca0479e1cd2137cbbad68efae1d2b2c9a9"><a name="gga137eb03027d5947ea294b32f5095b83ca0479e1cd2137cbbad68efae1d2b2c9a9"></a><a name="gga137eb03027d5947ea294b32f5095b83ca0479e1cd2137cbbad68efae1d2b2c9a9"></a></strong>AUDIO_CHANNEL_MONO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p668863541084825"><a name="p668863541084825"></a><a name="p668863541084825"></a>Mono channel </p>
 </td>
</tr>
<tr id="row1566706616084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga137eb03027d5947ea294b32f5095b83ca70f2212ea5439c13f7fcba3e30b15c1a"><a name="gga137eb03027d5947ea294b32f5095b83ca70f2212ea5439c13f7fcba3e30b15c1a"></a><a name="gga137eb03027d5947ea294b32f5095b83ca70f2212ea5439c13f7fcba3e30b15c1a"></a></strong>AUDIO_CHANNEL_STEREO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p878100649084825"><a name="p878100649084825"></a><a name="p878100649084825"></a>Stereo channel, consisting of front left and front right channels </p>
 </td>
</tr>
</tbody>
</table>

## AudioChannelMode<a name="ga78aab1fafb9657451804e42b42897123"></a>

```
enum [AudioChannelMode](audio.md#ga78aab1fafb9657451804e42b42897123)
```

 **Description:**

Enumerates channel modes for audio rendering. 

**Attention:**

The following modes are set for rendering dual-channel audios. Others are not supported. 


<a name="table1774515722084825"></a>
<table><thead align="left"><tr id="row1628424522084825"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1766202813084825"><a name="p1766202813084825"></a><a name="p1766202813084825"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1100728961084825"><a name="p1100728961084825"></a><a name="p1100728961084825"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1361724916084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga78aab1fafb9657451804e42b42897123aa97ec21f6627e1dfd4854b5b470cdfba"><a name="gga78aab1fafb9657451804e42b42897123aa97ec21f6627e1dfd4854b5b470cdfba"></a><a name="gga78aab1fafb9657451804e42b42897123aa97ec21f6627e1dfd4854b5b470cdfba"></a></strong>AUDIO_CHANNEL_NORMAL </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p639556496084825"><a name="p639556496084825"></a><a name="p639556496084825"></a>Normal mode. No processing is required. </p>
 </td>
</tr>
<tr id="row216323173084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga78aab1fafb9657451804e42b42897123a47fd61e4531acb6b5cc058ac26af5d51"><a name="gga78aab1fafb9657451804e42b42897123a47fd61e4531acb6b5cc058ac26af5d51"></a><a name="gga78aab1fafb9657451804e42b42897123a47fd61e4531acb6b5cc058ac26af5d51"></a></strong>AUDIO_CHANNEL_BOTH_LEFT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p62530952084825"><a name="p62530952084825"></a><a name="p62530952084825"></a>Two left channels </p>
 </td>
</tr>
<tr id="row1941864037084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga78aab1fafb9657451804e42b42897123a3341b11cad1d47bda2b4a2be60dda023"><a name="gga78aab1fafb9657451804e42b42897123a3341b11cad1d47bda2b4a2be60dda023"></a><a name="gga78aab1fafb9657451804e42b42897123a3341b11cad1d47bda2b4a2be60dda023"></a></strong>AUDIO_CHANNEL_BOTH_RIGHT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p909413250084825"><a name="p909413250084825"></a><a name="p909413250084825"></a>Two right channels </p>
 </td>
</tr>
<tr id="row916646821084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga78aab1fafb9657451804e42b42897123a3f2e41939cc24c51213d8730c32e74e9"><a name="gga78aab1fafb9657451804e42b42897123a3f2e41939cc24c51213d8730c32e74e9"></a><a name="gga78aab1fafb9657451804e42b42897123a3f2e41939cc24c51213d8730c32e74e9"></a></strong>AUDIO_CHANNEL_EXCHANGE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1906728956084825"><a name="p1906728956084825"></a><a name="p1906728956084825"></a>Data exchange between the left and right channels. The left channel takes the audio stream of the right channel, and the right channel takes that of the left channel. </p>
 </td>
</tr>
<tr id="row103699270084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga78aab1fafb9657451804e42b42897123a2c1537bccd5c2a05d1c515e58ec4481e"><a name="gga78aab1fafb9657451804e42b42897123a2c1537bccd5c2a05d1c515e58ec4481e"></a><a name="gga78aab1fafb9657451804e42b42897123a2c1537bccd5c2a05d1c515e58ec4481e"></a></strong>AUDIO_CHANNEL_MIX </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p24012098084825"><a name="p24012098084825"></a><a name="p24012098084825"></a>Mix of streams of the left and right channels </p>
 </td>
</tr>
<tr id="row1211339119084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga78aab1fafb9657451804e42b42897123a485c0423ce07fbb7f844a387ed9bb546"><a name="gga78aab1fafb9657451804e42b42897123a485c0423ce07fbb7f844a387ed9bb546"></a><a name="gga78aab1fafb9657451804e42b42897123a485c0423ce07fbb7f844a387ed9bb546"></a></strong>AUDIO_CHANNEL_LEFT_MUTE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p544279483084825"><a name="p544279483084825"></a><a name="p544279483084825"></a>Left channel muted. The stream of the right channel is output. </p>
 </td>
</tr>
<tr id="row590037081084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga78aab1fafb9657451804e42b42897123a0878cdf6f3e0d9ae9ae1f61b7f74257e"><a name="gga78aab1fafb9657451804e42b42897123a0878cdf6f3e0d9ae9ae1f61b7f74257e"></a><a name="gga78aab1fafb9657451804e42b42897123a0878cdf6f3e0d9ae9ae1f61b7f74257e"></a></strong>AUDIO_CHANNEL_RIGHT_MUTE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p629372302084825"><a name="p629372302084825"></a><a name="p629372302084825"></a>Right channel muted. The stream of the left channel is output. </p>
 </td>
</tr>
<tr id="row1147705386084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga78aab1fafb9657451804e42b42897123a22540143eb96abf8176e73c19fc0d8e5"><a name="gga78aab1fafb9657451804e42b42897123a22540143eb96abf8176e73c19fc0d8e5"></a><a name="gga78aab1fafb9657451804e42b42897123a22540143eb96abf8176e73c19fc0d8e5"></a></strong>AUDIO_CHANNEL_BOTH_MUTE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1996009843084825"><a name="p1996009843084825"></a><a name="p1996009843084825"></a>Both left and right channels muted </p>
 </td>
</tr>
</tbody>
</table>

## AudioFormat<a name="ga98d5d077cca088ddf77314871474fe59"></a>

```
enum [AudioFormat](audio.md#ga98d5d077cca088ddf77314871474fe59)
```

 **Description:**

Enumerates the audio format. 

<a name="table34600565084825"></a>
<table><thead align="left"><tr id="row1367366576084825"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1473045037084825"><a name="p1473045037084825"></a><a name="p1473045037084825"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p310853743084825"><a name="p310853743084825"></a><a name="p310853743084825"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row94137642084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga98d5d077cca088ddf77314871474fe59a321cc2160af35aa86b8ee55f231ef1e6"><a name="gga98d5d077cca088ddf77314871474fe59a321cc2160af35aa86b8ee55f231ef1e6"></a><a name="gga98d5d077cca088ddf77314871474fe59a321cc2160af35aa86b8ee55f231ef1e6"></a></strong>AUDIO_FORMAT_PCM_8_BIT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1004829643084825"><a name="p1004829643084825"></a><a name="p1004829643084825"></a>8-bit PCM </p>
 </td>
</tr>
<tr id="row1048123720084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga98d5d077cca088ddf77314871474fe59ae188cf87c8f2e6218c74b3b2385068e6"><a name="gga98d5d077cca088ddf77314871474fe59ae188cf87c8f2e6218c74b3b2385068e6"></a><a name="gga98d5d077cca088ddf77314871474fe59ae188cf87c8f2e6218c74b3b2385068e6"></a></strong>AUDIO_FORMAT_PCM_16_BIT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2136987508084825"><a name="p2136987508084825"></a><a name="p2136987508084825"></a>16-bit PCM </p>
 </td>
</tr>
<tr id="row520517925084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga98d5d077cca088ddf77314871474fe59a21eb864e2117df577dcd90ad81da3b14"><a name="gga98d5d077cca088ddf77314871474fe59a21eb864e2117df577dcd90ad81da3b14"></a><a name="gga98d5d077cca088ddf77314871474fe59a21eb864e2117df577dcd90ad81da3b14"></a></strong>AUDIO_FORMAT_PCM_24_BIT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1478296829084825"><a name="p1478296829084825"></a><a name="p1478296829084825"></a>24-bit PCM </p>
 </td>
</tr>
<tr id="row975788057084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga98d5d077cca088ddf77314871474fe59adf7a0bf1f3dd15c9c43fac07c0c6ea26"><a name="gga98d5d077cca088ddf77314871474fe59adf7a0bf1f3dd15c9c43fac07c0c6ea26"></a><a name="gga98d5d077cca088ddf77314871474fe59adf7a0bf1f3dd15c9c43fac07c0c6ea26"></a></strong>AUDIO_FORMAT_PCM_32_BIT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1267586262084825"><a name="p1267586262084825"></a><a name="p1267586262084825"></a>32-bit PCM </p>
 </td>
</tr>
<tr id="row1359279695084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga98d5d077cca088ddf77314871474fe59a5a781e6f8b145066ae7fb2c310804bab"><a name="gga98d5d077cca088ddf77314871474fe59a5a781e6f8b145066ae7fb2c310804bab"></a><a name="gga98d5d077cca088ddf77314871474fe59a5a781e6f8b145066ae7fb2c310804bab"></a></strong>AUDIO_FORMAT_AAC_MAIN </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1398476373084825"><a name="p1398476373084825"></a><a name="p1398476373084825"></a>AAC main </p>
 </td>
</tr>
<tr id="row1701647710084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga98d5d077cca088ddf77314871474fe59a3d4bc5d534d0452635455ed8d2cade57"><a name="gga98d5d077cca088ddf77314871474fe59a3d4bc5d534d0452635455ed8d2cade57"></a><a name="gga98d5d077cca088ddf77314871474fe59a3d4bc5d534d0452635455ed8d2cade57"></a></strong>AUDIO_FORMAT_AAC_LC </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1072449831084825"><a name="p1072449831084825"></a><a name="p1072449831084825"></a>AAC LC </p>
 </td>
</tr>
<tr id="row751048020084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga98d5d077cca088ddf77314871474fe59ad4baf87ff9f4684c03483c572052b700"><a name="gga98d5d077cca088ddf77314871474fe59ad4baf87ff9f4684c03483c572052b700"></a><a name="gga98d5d077cca088ddf77314871474fe59ad4baf87ff9f4684c03483c572052b700"></a></strong>AUDIO_FORMAT_AAC_LD </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1078747112084825"><a name="p1078747112084825"></a><a name="p1078747112084825"></a>AAC LD </p>
 </td>
</tr>
<tr id="row993717308084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga98d5d077cca088ddf77314871474fe59a4b8d42988fecf03e2bf73c4395501852"><a name="gga98d5d077cca088ddf77314871474fe59a4b8d42988fecf03e2bf73c4395501852"></a><a name="gga98d5d077cca088ddf77314871474fe59a4b8d42988fecf03e2bf73c4395501852"></a></strong>AUDIO_FORMAT_AAC_ELD </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p882002829084825"><a name="p882002829084825"></a><a name="p882002829084825"></a>AAC ELD </p>
 </td>
</tr>
<tr id="row424357356084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga98d5d077cca088ddf77314871474fe59abaddb86f122d3185de9407dbc673bf0e"><a name="gga98d5d077cca088ddf77314871474fe59abaddb86f122d3185de9407dbc673bf0e"></a><a name="gga98d5d077cca088ddf77314871474fe59abaddb86f122d3185de9407dbc673bf0e"></a></strong>AUDIO_FORMAT_AAC_HE_V1 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1051875436084825"><a name="p1051875436084825"></a><a name="p1051875436084825"></a>AAC HE_V1 </p>
 </td>
</tr>
<tr id="row1043502153084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga98d5d077cca088ddf77314871474fe59ab610e0121e0b5076b3f78831e3c237fd"><a name="gga98d5d077cca088ddf77314871474fe59ab610e0121e0b5076b3f78831e3c237fd"></a><a name="gga98d5d077cca088ddf77314871474fe59ab610e0121e0b5076b3f78831e3c237fd"></a></strong>AUDIO_FORMAT_AAC_HE_V2 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1063950852084825"><a name="p1063950852084825"></a><a name="p1063950852084825"></a>AAC HE_V2 </p>
 </td>
</tr>
</tbody>
</table>

## AudioPortDirection<a name="ga68ff7140b15790debbac4bbc62f8e9f8"></a>

```
enum [AudioPortDirection](audio.md#ga68ff7140b15790debbac4bbc62f8e9f8)
```

 **Description:**

Enumerates the audio port type. 

<a name="table508363881084825"></a>
<table><thead align="left"><tr id="row447062623084825"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1776795150084825"><a name="p1776795150084825"></a><a name="p1776795150084825"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1000986765084825"><a name="p1000986765084825"></a><a name="p1000986765084825"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1595536258084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga68ff7140b15790debbac4bbc62f8e9f8af54f110a0f64337d474989fbac06bc22"><a name="gga68ff7140b15790debbac4bbc62f8e9f8af54f110a0f64337d474989fbac06bc22"></a><a name="gga68ff7140b15790debbac4bbc62f8e9f8af54f110a0f64337d474989fbac06bc22"></a></strong>PORT_OUT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1441385809084825"><a name="p1441385809084825"></a><a name="p1441385809084825"></a>Output port </p>
 </td>
</tr>
<tr id="row1378134559084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga68ff7140b15790debbac4bbc62f8e9f8a154a6db110515b7afde52d3a36d57846"><a name="gga68ff7140b15790debbac4bbc62f8e9f8a154a6db110515b7afde52d3a36d57846"></a><a name="gga68ff7140b15790debbac4bbc62f8e9f8a154a6db110515b7afde52d3a36d57846"></a></strong>PORT_IN </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1054916310084825"><a name="p1054916310084825"></a><a name="p1054916310084825"></a>Input port </p>
 </td>
</tr>
<tr id="row154933946084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga68ff7140b15790debbac4bbc62f8e9f8a87e14fe9da9c332ba29185b9213d7bbf"><a name="gga68ff7140b15790debbac4bbc62f8e9f8a87e14fe9da9c332ba29185b9213d7bbf"></a><a name="gga68ff7140b15790debbac4bbc62f8e9f8a87e14fe9da9c332ba29185b9213d7bbf"></a></strong>PORT_OUT_IN </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1945830406084825"><a name="p1945830406084825"></a><a name="p1945830406084825"></a>Input/output port, supporting both audio input and output </p>
 </td>
</tr>
</tbody>
</table>

## AudioPortPassthroughMode<a name="ga186d2d4f9a2ecacb80cd2cce2bd26f0e"></a>

```
enum [AudioPortPassthroughMode](audio.md#ga186d2d4f9a2ecacb80cd2cce2bd26f0e)
```

 **Description:**

Enumerates the passthrough data transmission mode of an audio port. 

<a name="table260334677084825"></a>
<table><thead align="left"><tr id="row251391267084825"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p766640412084825"><a name="p766640412084825"></a><a name="p766640412084825"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1828589509084825"><a name="p1828589509084825"></a><a name="p1828589509084825"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row457403517084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga186d2d4f9a2ecacb80cd2cce2bd26f0ea48da60ec7958d35e8884e67cc32cb465"><a name="gga186d2d4f9a2ecacb80cd2cce2bd26f0ea48da60ec7958d35e8884e67cc32cb465"></a><a name="gga186d2d4f9a2ecacb80cd2cce2bd26f0ea48da60ec7958d35e8884e67cc32cb465"></a></strong>PORT_PASSTHROUGH_LPCM </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1434689346084825"><a name="p1434689346084825"></a><a name="p1434689346084825"></a>Stereo PCM </p>
 </td>
</tr>
<tr id="row1286591345084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga186d2d4f9a2ecacb80cd2cce2bd26f0eaf44936c424fbadafda9e1a12829b291f"><a name="gga186d2d4f9a2ecacb80cd2cce2bd26f0eaf44936c424fbadafda9e1a12829b291f"></a><a name="gga186d2d4f9a2ecacb80cd2cce2bd26f0eaf44936c424fbadafda9e1a12829b291f"></a></strong>PORT_PASSTHROUGH_RAW </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2076321762084825"><a name="p2076321762084825"></a><a name="p2076321762084825"></a>HDMI passthrough </p>
 </td>
</tr>
<tr id="row1332885984084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga186d2d4f9a2ecacb80cd2cce2bd26f0eada09d902428d269446b94c2b7e9eb95e"><a name="gga186d2d4f9a2ecacb80cd2cce2bd26f0eada09d902428d269446b94c2b7e9eb95e"></a><a name="gga186d2d4f9a2ecacb80cd2cce2bd26f0eada09d902428d269446b94c2b7e9eb95e"></a></strong>PORT_PASSTHROUGH_HBR2LBR </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1852624369084825"><a name="p1852624369084825"></a><a name="p1852624369084825"></a>Blu-ray next-generation audio output with reduced specifications </p>
 </td>
</tr>
<tr id="row1711505356084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga186d2d4f9a2ecacb80cd2cce2bd26f0ea6fd7a77031d807247e159c3deec07e11"><a name="gga186d2d4f9a2ecacb80cd2cce2bd26f0ea6fd7a77031d807247e159c3deec07e11"></a><a name="gga186d2d4f9a2ecacb80cd2cce2bd26f0ea6fd7a77031d807247e159c3deec07e11"></a></strong>PORT_PASSTHROUGH_AUTO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p9516249084825"><a name="p9516249084825"></a><a name="p9516249084825"></a>Mode automatically matched based on the HDMI EDID </p>
 </td>
</tr>
</tbody>
</table>

## AudioPortPin<a name="gaa7114aeeccf3ac4f5f7e1d880bcfa835"></a>

```
enum [AudioPortPin](audio.md#gaa7114aeeccf3ac4f5f7e1d880bcfa835)
```

 **Description:**

Enumerates the pin of an audio adapter. 

<a name="table1231814562084825"></a>
<table><thead align="left"><tr id="row1212074284084825"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p427155524084825"><a name="p427155524084825"></a><a name="p427155524084825"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1445437373084825"><a name="p1445437373084825"></a><a name="p1445437373084825"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row285210791084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa7114aeeccf3ac4f5f7e1d880bcfa835ad2f867652c04c17517db7731af03bf20"><a name="ggaa7114aeeccf3ac4f5f7e1d880bcfa835ad2f867652c04c17517db7731af03bf20"></a><a name="ggaa7114aeeccf3ac4f5f7e1d880bcfa835ad2f867652c04c17517db7731af03bf20"></a></strong>PIN_NONE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p794998958084825"><a name="p794998958084825"></a><a name="p794998958084825"></a>Invalid pin </p>
 </td>
</tr>
<tr id="row1069780679084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa7114aeeccf3ac4f5f7e1d880bcfa835ab1070439bab93e06446c21157771dd6f"><a name="ggaa7114aeeccf3ac4f5f7e1d880bcfa835ab1070439bab93e06446c21157771dd6f"></a><a name="ggaa7114aeeccf3ac4f5f7e1d880bcfa835ab1070439bab93e06446c21157771dd6f"></a></strong>PIN_OUT_SPEAKER </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1209466960084825"><a name="p1209466960084825"></a><a name="p1209466960084825"></a>Speaker output pin </p>
 </td>
</tr>
<tr id="row218523980084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa7114aeeccf3ac4f5f7e1d880bcfa835a271013721c8840cc2700c19b3ff8d0a6"><a name="ggaa7114aeeccf3ac4f5f7e1d880bcfa835a271013721c8840cc2700c19b3ff8d0a6"></a><a name="ggaa7114aeeccf3ac4f5f7e1d880bcfa835a271013721c8840cc2700c19b3ff8d0a6"></a></strong>PIN_OUT_HEADSET </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1287992188084825"><a name="p1287992188084825"></a><a name="p1287992188084825"></a>Wired headset pin for output </p>
 </td>
</tr>
<tr id="row1765660765084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa7114aeeccf3ac4f5f7e1d880bcfa835a411e9037214c75d22c9080505cf9cae6"><a name="ggaa7114aeeccf3ac4f5f7e1d880bcfa835a411e9037214c75d22c9080505cf9cae6"></a><a name="ggaa7114aeeccf3ac4f5f7e1d880bcfa835a411e9037214c75d22c9080505cf9cae6"></a></strong>PIN_OUT_LINEOUT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1877308982084825"><a name="p1877308982084825"></a><a name="p1877308982084825"></a>Line-out pin </p>
 </td>
</tr>
<tr id="row608055281084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa7114aeeccf3ac4f5f7e1d880bcfa835ab4aaa2ec71ec77480f60743cd79340b9"><a name="ggaa7114aeeccf3ac4f5f7e1d880bcfa835ab4aaa2ec71ec77480f60743cd79340b9"></a><a name="ggaa7114aeeccf3ac4f5f7e1d880bcfa835ab4aaa2ec71ec77480f60743cd79340b9"></a></strong>PIN_OUT_HDMI </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1205749455084825"><a name="p1205749455084825"></a><a name="p1205749455084825"></a>HDMI output pin </p>
 </td>
</tr>
<tr id="row1937137355084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa7114aeeccf3ac4f5f7e1d880bcfa835a336001f5685d9c206b1251714553b485"><a name="ggaa7114aeeccf3ac4f5f7e1d880bcfa835a336001f5685d9c206b1251714553b485"></a><a name="ggaa7114aeeccf3ac4f5f7e1d880bcfa835a336001f5685d9c206b1251714553b485"></a></strong>PIN_IN_MIC </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p985406930084825"><a name="p985406930084825"></a><a name="p985406930084825"></a>Microphone input pin </p>
 </td>
</tr>
<tr id="row162389720084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa7114aeeccf3ac4f5f7e1d880bcfa835aaeca21ac0a7b249905d1cea5b683f574"><a name="ggaa7114aeeccf3ac4f5f7e1d880bcfa835aaeca21ac0a7b249905d1cea5b683f574"></a><a name="ggaa7114aeeccf3ac4f5f7e1d880bcfa835aaeca21ac0a7b249905d1cea5b683f574"></a></strong>PIN_IN_HS_MIC </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1002177990084825"><a name="p1002177990084825"></a><a name="p1002177990084825"></a>Wired headset microphone pin for input </p>
 </td>
</tr>
<tr id="row1051058651084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa7114aeeccf3ac4f5f7e1d880bcfa835a5146add03ff98f06648567bb0e02a477"><a name="ggaa7114aeeccf3ac4f5f7e1d880bcfa835a5146add03ff98f06648567bb0e02a477"></a><a name="ggaa7114aeeccf3ac4f5f7e1d880bcfa835a5146add03ff98f06648567bb0e02a477"></a></strong>PIN_IN_LINEIN </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p83050979084825"><a name="p83050979084825"></a><a name="p83050979084825"></a>Line-in pin </p>
 </td>
</tr>
</tbody>
</table>

## AudioSampleRatesMask<a name="ga7053fcaa56d1dc47d2fcd83ee131fe4c"></a>

```
enum [AudioSampleRatesMask](audio.md#ga7053fcaa56d1dc47d2fcd83ee131fe4c)
```

 **Description:**

Enumerates masks of audio sampling rates. 

<a name="table28448199084825"></a>
<table><thead align="left"><tr id="row452360623084825"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1854736535084825"><a name="p1854736535084825"></a><a name="p1854736535084825"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p478483982084825"><a name="p478483982084825"></a><a name="p478483982084825"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row571403668084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga7053fcaa56d1dc47d2fcd83ee131fe4ca046a26906a4df81bfc38c583ba3606e9"><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4ca046a26906a4df81bfc38c583ba3606e9"></a><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4ca046a26906a4df81bfc38c583ba3606e9"></a></strong>AUDIO_SAMPLE_RATE_MASK_8000 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p870225967084825"><a name="p870225967084825"></a><a name="p870225967084825"></a>8 kHz </p>
 </td>
</tr>
<tr id="row1225962693084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga7053fcaa56d1dc47d2fcd83ee131fe4caf1f34aa763f2bf6d5f43178f2d335d10"><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4caf1f34aa763f2bf6d5f43178f2d335d10"></a><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4caf1f34aa763f2bf6d5f43178f2d335d10"></a></strong>AUDIO_SAMPLE_RATE_MASK_12000 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p736067065084825"><a name="p736067065084825"></a><a name="p736067065084825"></a>12 kHz </p>
 </td>
</tr>
<tr id="row283903714084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga7053fcaa56d1dc47d2fcd83ee131fe4ca5f13b000ef455b858506fc90d17e2dd7"><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4ca5f13b000ef455b858506fc90d17e2dd7"></a><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4ca5f13b000ef455b858506fc90d17e2dd7"></a></strong>AUDIO_SAMPLE_RATE_MASK_11025 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p109566608084825"><a name="p109566608084825"></a><a name="p109566608084825"></a>11.025 kHz </p>
 </td>
</tr>
<tr id="row542145181084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga7053fcaa56d1dc47d2fcd83ee131fe4ca3102248493467e00d16c2cf1971635a7"><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4ca3102248493467e00d16c2cf1971635a7"></a><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4ca3102248493467e00d16c2cf1971635a7"></a></strong>AUDIO_SAMPLE_RATE_MASK_16000 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p753510104084825"><a name="p753510104084825"></a><a name="p753510104084825"></a>16 kHz </p>
 </td>
</tr>
<tr id="row147358764084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga7053fcaa56d1dc47d2fcd83ee131fe4cae7cfb2244a15cd133373cfa5e96ec82e"><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4cae7cfb2244a15cd133373cfa5e96ec82e"></a><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4cae7cfb2244a15cd133373cfa5e96ec82e"></a></strong>AUDIO_SAMPLE_RATE_MASK_22050 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1737270331084825"><a name="p1737270331084825"></a><a name="p1737270331084825"></a>22.050 kHz </p>
 </td>
</tr>
<tr id="row621426022084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga7053fcaa56d1dc47d2fcd83ee131fe4cacce4defc0cf23abfe52d399b4aa68fdf"><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4cacce4defc0cf23abfe52d399b4aa68fdf"></a><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4cacce4defc0cf23abfe52d399b4aa68fdf"></a></strong>AUDIO_SAMPLE_RATE_MASK_24000 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1611767635084825"><a name="p1611767635084825"></a><a name="p1611767635084825"></a>24 kHz </p>
 </td>
</tr>
<tr id="row601645977084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga7053fcaa56d1dc47d2fcd83ee131fe4ca5594285d8ef3897e9f29a15e0795b814"><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4ca5594285d8ef3897e9f29a15e0795b814"></a><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4ca5594285d8ef3897e9f29a15e0795b814"></a></strong>AUDIO_SAMPLE_RATE_MASK_32000 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p149128271084825"><a name="p149128271084825"></a><a name="p149128271084825"></a>32 kHz </p>
 </td>
</tr>
<tr id="row812691655084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga7053fcaa56d1dc47d2fcd83ee131fe4ca52345265822f55a62b2e038438daf37e"><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4ca52345265822f55a62b2e038438daf37e"></a><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4ca52345265822f55a62b2e038438daf37e"></a></strong>AUDIO_SAMPLE_RATE_MASK_44100 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p937209395084825"><a name="p937209395084825"></a><a name="p937209395084825"></a>44.1 kHz </p>
 </td>
</tr>
<tr id="row1482212368084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga7053fcaa56d1dc47d2fcd83ee131fe4caa52c49624fecf6d9f1d075d0d3ad0bbf"><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4caa52c49624fecf6d9f1d075d0d3ad0bbf"></a><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4caa52c49624fecf6d9f1d075d0d3ad0bbf"></a></strong>AUDIO_SAMPLE_RATE_MASK_48000 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2080794754084825"><a name="p2080794754084825"></a><a name="p2080794754084825"></a>48 kHz </p>
 </td>
</tr>
<tr id="row1394575402084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga7053fcaa56d1dc47d2fcd83ee131fe4caf111a8b9762ec169361a106ba7efdb0f"><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4caf111a8b9762ec169361a106ba7efdb0f"></a><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4caf111a8b9762ec169361a106ba7efdb0f"></a></strong>AUDIO_SAMPLE_RATE_MASK_64000 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p805165357084825"><a name="p805165357084825"></a><a name="p805165357084825"></a>64 kHz </p>
 </td>
</tr>
<tr id="row1874007078084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga7053fcaa56d1dc47d2fcd83ee131fe4caa9e4deb07b2a7c32e5a19b8c81d9fd0d"><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4caa9e4deb07b2a7c32e5a19b8c81d9fd0d"></a><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4caa9e4deb07b2a7c32e5a19b8c81d9fd0d"></a></strong>AUDIO_SAMPLE_RATE_MASK_96000 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1139157567084825"><a name="p1139157567084825"></a><a name="p1139157567084825"></a>96 kHz </p>
 </td>
</tr>
<tr id="row88990974084825"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga7053fcaa56d1dc47d2fcd83ee131fe4ca41f8d22ab95c84d0acb3d0c78679274c"><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4ca41f8d22ab95c84d0acb3d0c78679274c"></a><a name="gga7053fcaa56d1dc47d2fcd83ee131fe4ca41f8d22ab95c84d0acb3d0c78679274c"></a></strong>AUDIO_SAMPLE_RATE_MASK_INVALID </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p521893504084825"><a name="p521893504084825"></a><a name="p521893504084825"></a>Invalid sampling rate </p>
 </td>
</tr>
</tbody>
</table>

## **Function Documentation**<a name="section798868839084825"></a>

## GetAudioManagerFuncs\(\)<a name="ga0c7824f4fe89625d3c9b1d0534ad0151"></a>

```
struct [AudioManager](audiomanager.md)* GetAudioManagerFuncs (void )
```

 **Description:**

Obtains the operation function list of the  [AudioManager](audiomanager.md)  class. 

**Returns:**

Returns the pointer to the  **[AudioManager](audiomanager.md)**  object if the list is obtained; returns  **NULL**  otherwise. 



## **Variable Documentation**<a name="section2033369980084825"></a>

## adapterName<a name="gadbe46bc7d9b4c20c409e30942ad794cf"></a>

```
const char* AudioAdapterDescriptor::adapterName
```

 **Description:**

Name of the audio adapter 

## channelCount \[1/2\]<a name="ga9c629d8ad8f0119d9b0acae3f2ed9b78"></a>

```
uint32_t AudioSampleAttributes::channelCount
```

 **Description:**

Number of audio channels. For example, for the mono channel, the value is 1, and for the stereo channel, the value is 2. 

## channelCount \[2/2\]<a name="ga48253c4fbc171f241bb0494524891bb1"></a>

```
uint32_t AudioPortCapability::channelCount
```

 **Description:**

Supported maximum number of audio channels 

## channelMasks<a name="ga357e90ee8116e04144f57e6f7d3d9efb"></a>

```
enum [AudioChannelMask](audio.md#ga137eb03027d5947ea294b32f5095b83c) AudioPortCapability::channelMasks
```

 **Description:**

Audio channel layout mask of the device. For details, see  [AudioChannelMask](audio.md#ga137eb03027d5947ea294b32f5095b83c). 

## desc \[1/4\]<a name="ga560700ce0e6f047a617e21b41e0425b9"></a>

```
const char* AudioDeviceDescriptor::desc
```

 **Description:**

Audio device name 

## desc \[2/4\]<a name="gab855beab3a08e8c9a7f814cce53e2001"></a>

```
struct [AudioDeviceDescriptor](audiodevicedescriptor.md) AudioSceneDescriptor::desc
```

 **Description:**

Audio device descriptor 

## desc \[3/4\]<a name="ga81e44604a869f47c88c3f9503b9287e1"></a>

```
const char* AudioSceneDescriptor::SceneDesc::desc
```

 **Description:**

Name of the audio scene 

## desc \[4/4\]<a name="gafe579a4229429c8665d1c3d95fc1f964"></a>

```
const char* AudioSubPortCapability::desc
```

 **Description:**

Sub-port name 

## deviceId<a name="ga0485197a750c63938602b339a3b9c77f"></a>

```
uint32_t AudioPortCapability::deviceId
```

 **Description:**

Device ID used for device binding 

## deviceType<a name="ga00860eb6de81efe5b1654b45617fb902"></a>

```
uint32_t AudioPortCapability::deviceType
```

 **Description:**

Device type \(output or input\) 

## dir<a name="ga144336f0f64927730a184c16d8c27698"></a>

```
enum [AudioPortDirection](audio.md#ga68ff7140b15790debbac4bbc62f8e9f8) AudioPort::dir
```

 **Description:**

Audio port type. For details, see  [AudioPortDirection](audio.md#ga68ff7140b15790debbac4bbc62f8e9f8) 

## format<a name="ga441305acec64ee1ed840c8920e167c9e"></a>

```
enum [AudioFormat](audio.md#ga98d5d077cca088ddf77314871474fe59) AudioSampleAttributes::format
```

 **Description:**

Audio data format. For details, see  [AudioFormat](audio.md#ga98d5d077cca088ddf77314871474fe59). 

## formatNum<a name="gaca895984cf53ddd8769d33c8298b0c6d"></a>

```
uint32_t AudioPortCapability::formatNum
```

 **Description:**

Number of the supported audio formats 

## formats<a name="gad01bfa329a21628287ee21df5000e34d"></a>

```
enum [AudioFormat](audio.md#ga98d5d077cca088ddf77314871474fe59)* AudioPortCapability::formats
```

 **Description:**

Supported audio formats. For details, see  [AudioFormat](audio.md#ga98d5d077cca088ddf77314871474fe59). 

## hardwareMode<a name="ga377ecdaf229087a7d17c220a65a7162f"></a>

```
bool AudioPortCapability::hardwareMode
```

 **Description:**

Whether to support device binding 

## id<a name="ga3e54db28a854f634bd847919e7ae8e32"></a>

```
uint32_t AudioSceneDescriptor::SceneDesc::id
```

 **Description:**

Audio scene ID 

## interleaved<a name="gab00c777b594436a4fae1a4bcdad70c6d"></a>

```
bool AudioSampleAttributes::interleaved
```

 **Description:**

Interleaving flag of audio data 

## mask<a name="ga958a6104e7ab64f75618015bfb097a32"></a>

```
enum [AudioPortPassthroughMode](audio.md#ga186d2d4f9a2ecacb80cd2cce2bd26f0e) AudioSubPortCapability::mask
```

 **Description:**

Passthrough mode of data transmission. For details, see  [AudioPortPassthroughMode](audio.md#ga186d2d4f9a2ecacb80cd2cce2bd26f0e). 

## pins<a name="gab2e66ca83a7ef39211b53d4afe7b7b73"></a>

```
enum [AudioPortPin](audio.md#gaa7114aeeccf3ac4f5f7e1d880bcfa835) AudioDeviceDescriptor::pins
```

 **Description:**

Pins of audio ports \(input and output\). For details, see  [AudioPortPin](audio.md#gaa7114aeeccf3ac4f5f7e1d880bcfa835). 

## portId \[1/3\]<a name="gaa534605f1ef1993f47063c3f7fbccbde"></a>

```
uint32_t AudioPort::portId
```

 **Description:**

Audio port ID 

## portId \[2/3\]<a name="gabc4bdf3c11cada00cfebbd9b1218ab3a"></a>

```
uint32_t AudioDeviceDescriptor::portId
```

 **Description:**

Audio port ID 

## portId \[3/3\]<a name="ga4b35c30d09b716f0bd2c7c22587e3f7a"></a>

```
uint32_t AudioSubPortCapability::portId
```

 **Description:**

Sub-port ID 

## portName<a name="ga6cbf88ceff4bcd03b125d45873e654a1"></a>

```
const char* AudioPort::portName
```

 **Description:**

Audio port name 

## portNum<a name="ga2bef8f9b5ea3c1e30639fcb3ec8dd717"></a>

```
uint32_t AudioAdapterDescriptor::portNum
```

 **Description:**

Number of ports supported by an audio adapter 

## ports<a name="ga64d0c55b881fb0a3bc15b2fecea86f24"></a>

```
struct [AudioPort](audioport.md)* AudioAdapterDescriptor::ports
```

 **Description:**

List of ports supported by an audio adapter 

## sampleRate<a name="gaa322b72a4cdf9007c75814853e7ad4af"></a>

```
uint32_t AudioSampleAttributes::sampleRate
```

 **Description:**

Audio sampling rate 

## sampleRateMasks<a name="ga30c8a08e5d939c0e9844d6d9a165c681"></a>

```
uint32_t AudioPortCapability::sampleRateMasks
```

 **Description:**

Supported audio sampling rates \(8 kHz, 16 kHz, 32 kHz, and 48 kHz\) 

## scene<a name="ga3246105a88851b68c71e16a511ea6b47"></a>

```
union [AudioSceneDescriptor::SceneDesc](audioscenedescriptor-scenedesc.md) AudioSceneDescriptor::scene
```

 **Description:**

The  **scene**  object 

## subPorts<a name="gaccd18b70e7d121169f3df5e53fe055f9"></a>

```
struct [AudioSubPortCapability](audiosubportcapability.md)* AudioPortCapability::subPorts
```

 **Description:**

List of supported sub-ports 

## subPortsNum<a name="gab784694fd6a60a3d5a3ae404cd6fe6fd"></a>

```
uint32_t AudioPortCapability::subPortsNum
```

 **Description:**

Number of supported sub-ports \(for output devices only\) 

## tvNSec<a name="gadae6151a2f7e0432dbaf6e89e743de9c"></a>

```
int64_t AudioTimeStamp::tvNSec
```

 **Description:**

Nanoseconds 

## tvSec<a name="gaa6205cc4d86425bc23f2d860f44644ce"></a>

```
int64_t AudioTimeStamp::tvSec
```

 **Description:**

Seconds 

## type<a name="ga658c38c76290ea6c8b9e0a2ddf7d1db4"></a>

```
enum [AudioCategory](audio.md#gaf210d41d152890f3aaf2aaac99bd28d5) AudioSampleAttributes::type
```

 **Description:**

Audio type. For details, see  [AudioCategory](audio.md#gaf210d41d152890f3aaf2aaac99bd28d5) 

