# Wifiservice<a name="EN-US_TOPIC_0000001055195054"></a>

## **Overview**<a name="section2055840408090251"></a>

Provides functions for the Wi-Fi station and hotspot modes. 

You can use this module to enable and disable the Wi-Fi station or hotspot mode, connect to and disconnect from a station or hotspot, query the station or hotspot status, and listen for events. 

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section620262878090251"></a>

## Files<a name="files"></a>

<a name="table266467485090251"></a>
<table><thead align="left"><tr id="row1686223276090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1782780783090251"><a name="p1782780783090251"></a><a name="p1782780783090251"></a>File Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1683552626090251"><a name="p1683552626090251"></a><a name="p1683552626090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1404920455090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1951164329090251"><a name="p1951164329090251"></a><a name="p1951164329090251"></a><a href="station_info-h.md">station_info.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1429829852090251"><a name="p1429829852090251"></a><a name="p1429829852090251"></a>Defines the structure and macro of the station information contained in the event information. </p>
</td>
</tr>
<tr id="row1659325008090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1200763841090251"><a name="p1200763841090251"></a><a name="p1200763841090251"></a><a href="wifi_device-h.md">wifi_device.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1572909256090251"><a name="p1572909256090251"></a><a name="p1572909256090251"></a>Provides capabilities to enable and disable the station mode, connect to and disconnect from a station, query the station status, and listen for events. </p>
</td>
</tr>
<tr id="row1861369012090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1763391421090251"><a name="p1763391421090251"></a><a name="p1763391421090251"></a><a href="wifi_device_config-h.md">wifi_device_config.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p377931305090251"><a name="p377931305090251"></a><a name="p377931305090251"></a>Defines the Wi-Fi station configuration. </p>
</td>
</tr>
<tr id="row759708983090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p783298439090251"><a name="p783298439090251"></a><a name="p783298439090251"></a><a href="wifi_error_code-h.md">wifi_error_code.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1109429337090251"><a name="p1109429337090251"></a><a name="p1109429337090251"></a>Defines error codes of the Wi-Fi service. </p>
</td>
</tr>
<tr id="row1199195955090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1981386209090251"><a name="p1981386209090251"></a><a name="p1981386209090251"></a><a href="wifi_event-h.md">wifi_event.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1485128727090251"><a name="p1485128727090251"></a><a name="p1485128727090251"></a>Defines callbacks and structure of Wi-Fi events. </p>
</td>
</tr>
<tr id="row2042528532090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p609625305090251"><a name="p609625305090251"></a><a name="p609625305090251"></a><a href="wifi_hotspot-h.md">wifi_hotspot.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p886078659090251"><a name="p886078659090251"></a><a name="p886078659090251"></a>Provides capabilities to enable and disable the hotspot mode, connect to and disconnect from a hotspot, query the hotspot status, and listen for events. </p>
</td>
</tr>
<tr id="row1710413701090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1550771013090251"><a name="p1550771013090251"></a><a name="p1550771013090251"></a><a href="wifi_hotspot_config-h.md">wifi_hotspot_config.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1683530079090251"><a name="p1683530079090251"></a><a name="p1683530079090251"></a>Defines the Wi-Fi hotspot configuration. </p>
</td>
</tr>
<tr id="row2061171604090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p744513365090251"><a name="p744513365090251"></a><a name="p744513365090251"></a><a href="wifi_linked_info-h.md">wifi_linked_info.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1722593244090251"><a name="p1722593244090251"></a><a name="p1722593244090251"></a>Defines the data structure and macro of the Wi-Fi connection information. </p>
</td>
</tr>
<tr id="row292339028090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p485544272090251"><a name="p485544272090251"></a><a name="p485544272090251"></a><a href="wifi_scan_info-h.md">wifi_scan_info.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p877143745090251"><a name="p877143745090251"></a><a name="p877143745090251"></a>Defines the data structure and macro of the Wi-Fi scan result information. </p>
</td>
</tr>
</tbody>
</table>

## Data Structures<a name="nested-classes"></a>

<a name="table959577654090251"></a>
<table><thead align="left"><tr id="row644045680090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1939428945090251"><a name="p1939428945090251"></a><a name="p1939428945090251"></a>Data Structure Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p809135935090251"><a name="p809135935090251"></a><a name="p809135935090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row375686282090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p952378821090251"><a name="p952378821090251"></a><a name="p952378821090251"></a><a href="stationinfo.md">StationInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1538572108090251"><a name="p1538572108090251"></a><a name="p1538572108090251"></a>Represents the station information. </p>
</td>
</tr>
<tr id="row2103807348090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2079089308090251"><a name="p2079089308090251"></a><a name="p2079089308090251"></a><a href="wifideviceconfig.md">WifiDeviceConfig</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p953884050090251"><a name="p953884050090251"></a><a name="p953884050090251"></a>Represents the Wi-Fi station configuration used to connect to a specified Wi-Fi device. </p>
</td>
</tr>
<tr id="row270886703090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p187620987090251"><a name="p187620987090251"></a><a name="p187620987090251"></a><a href="wifiscanparams.md">WifiScanParams</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1977131236090251"><a name="p1977131236090251"></a><a name="p1977131236090251"></a>Represents the Wi-Fi station configuration used to connect to a specified Wi-Fi device. </p>
</td>
</tr>
<tr id="row1995884671090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p234809387090251"><a name="p234809387090251"></a><a name="p234809387090251"></a><a href="wifievent.md">WifiEvent</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p524092844090251"><a name="p524092844090251"></a><a name="p524092844090251"></a>Represents the pointer to a Wi-Fi event callback for station and hotspot connection, disconnection, or scan. </p>
</td>
</tr>
<tr id="row1939542392090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p555088594090251"><a name="p555088594090251"></a><a name="p555088594090251"></a><a href="hotspotconfig.md">HotspotConfig</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p670214888090251"><a name="p670214888090251"></a><a name="p670214888090251"></a>Represents the hotspot configuration. </p>
</td>
</tr>
<tr id="row1391581049090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p825962633090251"><a name="p825962633090251"></a><a name="p825962633090251"></a><a href="wifilinkedinfo.md">WifiLinkedInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1334799036090251"><a name="p1334799036090251"></a><a name="p1334799036090251"></a>Represents the Wi-Fi connection information. </p>
</td>
</tr>
<tr id="row558353505090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2011073574090251"><a name="p2011073574090251"></a><a name="p2011073574090251"></a><a href="wifiscaninfo.md">WifiScanInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2021837109090251"><a name="p2021837109090251"></a><a name="p2021837109090251"></a>Represents the Wi-Fi scan result information. </p>
</td>
</tr>
</tbody>
</table>

## Macros<a name="define-members"></a>

<a name="table1308598500090251"></a>
<table><thead align="left"><tr id="row1715357150090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1667919410090251"><a name="p1667919410090251"></a><a name="p1667919410090251"></a>Macro Name and Value</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1172479420090251"><a name="p1172479420090251"></a><a name="p1172479420090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1151905782090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p721914048090251"><a name="p721914048090251"></a><a name="p721914048090251"></a><a href="wifiservice.md#ga87d47fede3b37780bbd2f4981b560e54">WIFI_MAX_CONFIG_SIZE</a>   10</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1045717384090251"><a name="p1045717384090251"></a><a name="p1045717384090251"></a>Indicates the maximum number of Wi-Fi station configurations that can be added using <a href="wifiservice.md#gaa0a50013ff978d6f82c655403946d8c9">AddDeviceConfig</a>. </p>
</td>
</tr>
<tr id="row1381579466090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1679317594090251"><a name="p1679317594090251"></a><a name="p1679317594090251"></a><a href="wifiservice.md#ga658039dc314dff5e764e40677c84f5d9">WIFI_CONFIG_INVALID</a>   (-1)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p273097268090251"><a name="p273097268090251"></a><a name="p273097268090251"></a>Indicates the value of <strong id="b619086435090251"><a name="b619086435090251"></a><a name="b619086435090251"></a>networkId</strong> when the configuration file is unavailable. </p>
</td>
</tr>
<tr id="row421726328090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p514487878090251"><a name="p514487878090251"></a><a name="p514487878090251"></a><a href="wifiservice.md#ga7e01d8c5079081de486637b4482c937a">WIFI_MAX_SSID_LEN</a>   33</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p738885771090251"><a name="p738885771090251"></a><a name="p738885771090251"></a>Indicates the maximum length of a Wi-Fi SSID. </p>
</td>
</tr>
<tr id="row1593887928090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p996256758090251"><a name="p996256758090251"></a><a name="p996256758090251"></a><a href="wifiservice.md#ga6017e2d011b6cffcd3663db81a2b52d8">WIFI_MAX_KEY_LEN</a>   65</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p312061011090251"><a name="p312061011090251"></a><a name="p312061011090251"></a>Indicates the maximum length of a Wi-Fi key. </p>
</td>
</tr>
<tr id="row1640676525090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p500943840090251"><a name="p500943840090251"></a><a name="p500943840090251"></a><a href="wifiservice.md#gabc871a0934ad71ec71b29de3f9bc4815">WIFI_MAC_LEN</a>   6</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p146896113090251"><a name="p146896113090251"></a><a name="p146896113090251"></a>Indicates the maximum length of a Wi-Fi MAC address or a Wi-Fi BSSID. </p>
</td>
</tr>
<tr id="row750925255090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1147187198090251"><a name="p1147187198090251"></a><a name="p1147187198090251"></a><a href="wifiservice.md#ga101f9d44cb01fce5704f10ba8d9c7960">WIFI_PSK_LEN</a>   32</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1852279261090251"><a name="p1852279261090251"></a><a name="p1852279261090251"></a>Indicates the maximum length of a Wi-Fi PSK. </p>
</td>
</tr>
<tr id="row515089286090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p446352183090251"><a name="p446352183090251"></a><a name="p446352183090251"></a><a href="wifiservice.md#ga9f956732e8e8da52eb25a84a7c42e2bb">WIFI_STA_ACTIVE</a>   1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1504247452090251"><a name="p1504247452090251"></a><a name="p1504247452090251"></a>Indicates that the Wi-Fi station mode is enabled. </p>
</td>
</tr>
<tr id="row358687369090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p143643035090251"><a name="p143643035090251"></a><a name="p143643035090251"></a><a href="wifiservice.md#gaf26289b0fe6ef5ae86395c0556187cf8">WIFI_STA_NOT_ACTIVE</a>   0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p203187098090251"><a name="p203187098090251"></a><a name="p203187098090251"></a>Indicates that the Wi-Fi station mode is disabled. </p>
</td>
</tr>
<tr id="row955516904090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p445803951090251"><a name="p445803951090251"></a><a name="p445803951090251"></a><a href="wifiservice.md#gabf45f5779e5e04c8204db6a0d206af11">WIFI_HOTSPOT_ACTIVE</a>   1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1027063933090251"><a name="p1027063933090251"></a><a name="p1027063933090251"></a>Indicates that the Wi-Fi hotspot mode is enabled. </p>
</td>
</tr>
<tr id="row488718305090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1606357717090251"><a name="p1606357717090251"></a><a name="p1606357717090251"></a><a href="wifiservice.md#ga7dd021b8f69312a304632fd1d0244f02">WIFI_HOTSPOT_NOT_ACTIVE</a>   0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1324649677090251"><a name="p1324649677090251"></a><a name="p1324649677090251"></a>Indicates that the Wi-Fi hotspot mode is disabled. </p>
</td>
</tr>
<tr id="row866242414090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p963991800090251"><a name="p963991800090251"></a><a name="p963991800090251"></a><a href="wifiservice.md#gaace417e14bf248f54aaa3d4f84138b14">WIFI_MAX_EVENT_SIZE</a>   10</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p493400595090251"><a name="p493400595090251"></a><a name="p493400595090251"></a>Indicates the maximum number of event listeners that can be registered using <a href="wifiservice.md#ga0e4d452915d1588664b91837b821eada">RegisterWifiEvent</a>. </p>
</td>
</tr>
<tr id="row339207284090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p160245544090251"><a name="p160245544090251"></a><a name="p160245544090251"></a><em id="gaa8e698699e6bd587bb936c3dbac2265f"><a name="gaa8e698699e6bd587bb936c3dbac2265f"></a><a name="gaa8e698699e6bd587bb936c3dbac2265f"></a></em>HOTSPOT_DEFAULT_CHANNEL    6</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1743230234090251"><a name="p1743230234090251"></a><a name="p1743230234090251"></a>Defines the default channel of the hotspot mode. </p>
</td>
</tr>
<tr id="row909921899090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1882394490090251"><a name="p1882394490090251"></a><a name="p1882394490090251"></a><em id="ga3aaba95d8760c837c01e209e52387711"><a name="ga3aaba95d8760c837c01e209e52387711"></a><a name="ga3aaba95d8760c837c01e209e52387711"></a></em>WIFI_MAX_STA_NUM    6</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1886710399090251"><a name="p1886710399090251"></a><a name="p1886710399090251"></a>Defines the maximum number of stations connected to a hotspot. </p>
</td>
</tr>
<tr id="row2121610706090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p303876962090251"><a name="p303876962090251"></a><a name="p303876962090251"></a><em id="gae280c9f1344a0b632d4097faa0d84555"><a name="gae280c9f1344a0b632d4097faa0d84555"></a><a name="gae280c9f1344a0b632d4097faa0d84555"></a></em>WIFI_SCAN_HOTSPOT_LIMIT    64</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p970615199090251"><a name="p970615199090251"></a><a name="p970615199090251"></a>Indicates the maximum number of hotspots that can be detected in a Wi-Fi scan. </p>
</td>
</tr>
</tbody>
</table>

## Typedefs<a name="typedef-members"></a>

<a name="table1461222742090251"></a>
<table><thead align="left"><tr id="row1014112365090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2142783218090251"><a name="p2142783218090251"></a><a name="p2142783218090251"></a>Typedef Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1501587641090251"><a name="p1501587641090251"></a><a name="p1501587641090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row683861744090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p131022149090251"><a name="p131022149090251"></a><a name="p131022149090251"></a><a href="wifiservice.md#gaa32cc451f81eeb416eda5968f71f4612">WifiDeviceConfig</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p422357886090251"><a name="p422357886090251"></a><a name="p422357886090251"></a>typedef struct <a href="wifideviceconfig.md">WifiDeviceConfig</a> </p>
<p id="p1417562084090251"><a name="p1417562084090251"></a><a name="p1417562084090251"></a>Represents the Wi-Fi station configuration used to connect to a specified Wi-Fi device. </p>
</td>
</tr>
</tbody>
</table>

## Enumerations<a name="enum-members"></a>

<a name="table419055143090251"></a>
<table><thead align="left"><tr id="row204473687090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1563031264090251"><a name="p1563031264090251"></a><a name="p1563031264090251"></a>Enumeration Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p464484503090251"><a name="p464484503090251"></a><a name="p464484503090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row806633354090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1093801883090251"><a name="p1093801883090251"></a><a name="p1093801883090251"></a><a href="wifiservice.md#ga97c133f7db7c1234babcde03c4ce1b05">WifiSecurityType</a> {   <a href="wifiservice.md#gga97c133f7db7c1234babcde03c4ce1b05ad512f146aed5b76788c5be8dfb370f13">WIFI_SEC_TYPE_INVALID</a> = -1, <a href="wifiservice.md#gga97c133f7db7c1234babcde03c4ce1b05a0ee2ed98b3ed21009c7d1b19945b8976">WIFI_SEC_TYPE_OPEN</a>, <a href="wifiservice.md#gga97c133f7db7c1234babcde03c4ce1b05a2d99c910346eb2a47965aea234f2fbe6">WIFI_SEC_TYPE_WEP</a>, <a href="wifiservice.md#gga97c133f7db7c1234babcde03c4ce1b05acec838f5f04a983f722c0cf749468870">WIFI_SEC_TYPE_PSK</a>,   <a href="wifiservice.md#gga97c133f7db7c1234babcde03c4ce1b05a7fe59ec8c8f2b2337f6b3a2268a9cfb4">WIFI_SEC_TYPE_SAE</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p905910143090251"><a name="p905910143090251"></a><a name="p905910143090251"></a>Enumerates Wi-Fi security types. </p>
</td>
</tr>
<tr id="row52952780090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p846670576090251"><a name="p846670576090251"></a><a name="p846670576090251"></a><a href="wifiservice.md#gaa1a44d23b8478232f14d2adfc82cee77">WifiPskType</a> { <a href="wifiservice.md#ggaa1a44d23b8478232f14d2adfc82cee77aedaceae77cb05c54cc8775653cfea4e8">WIFI_PSK_TYPE_ASCII</a> = 0, <a href="wifiservice.md#ggaa1a44d23b8478232f14d2adfc82cee77ad480d8db3b2f13d7d53c8d8cab22f10a">WIFI_PSK_TYPE_HEX</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1303830049090251"><a name="p1303830049090251"></a><a name="p1303830049090251"></a>Enumerates psk encryption types. </p>
</td>
</tr>
<tr id="row1387465170090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1162998772090251"><a name="p1162998772090251"></a><a name="p1162998772090251"></a><a href="wifiservice.md#ga007bf5e22727debc02cad860e41a60a3">WifiScanType</a> { <a href="wifiservice.md#gga007bf5e22727debc02cad860e41a60a3ad0d2a6703ee6092223acfae5bd295ab0">WIFI_FREQ_SCAN</a>, <a href="wifiservice.md#gga007bf5e22727debc02cad860e41a60a3a0b97d9caa917ae9d6f23738424dd25a1">WIFI_SSID_SCAN</a>, <a href="wifiservice.md#gga007bf5e22727debc02cad860e41a60a3a95e3be3877b0f9c483cb3b0575b6dce2">WIFI_BSSID_SCAN</a>, <a href="wifiservice.md#gga007bf5e22727debc02cad860e41a60a3a75b4c033f7ddd140a17061c0bdb9d71a">WIFI_BAND_SCAN</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p913188475090251"><a name="p913188475090251"></a><a name="p913188475090251"></a>Enumerates Wi-Fi scan types. </p>
</td>
</tr>
<tr id="row486933546090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p189887626090251"><a name="p189887626090251"></a><a name="p189887626090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> {   <a href="wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e">WIFI_SUCCESS</a> = 0, <a href="wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568a254a2c9cb1bc2265e22a3664300ab7f6">ERROR_WIFI_INVALID_ARGS</a> = -1, <a href="wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568a5a44965477d4640f18c5530c550dd713">ERROR_WIFI_CHIP_INVALID</a> = -2, <a href="wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568a65aea729766935f24296c909332e49dd">ERROR_WIFI_IFACE_INVALID</a> = -3,   <a href="wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568aad0d24ea74cf194e34d7eee09c23497a">ERROR_WIFI_RTT_CONTROLLER_INVALID</a> = -4, <a href="wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568a08a0d323d9c0565d0cd0e50505760aea">ERROR_WIFI_NOT_SUPPORTED</a> = -5, <a href="wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ae6421614f352b5c98bdb0f2ad96ed69b">ERROR_WIFI_NOT_AVAILABLE</a> = -6, <a href="wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568af961fdaa2b25e55977119d52b25fc6bb">ERROR_WIFI_NOT_STARTED</a> = -7,   <a href="wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568a7d4644e036859887013ac6c833ddd67e">ERROR_WIFI_BUSY</a> = -8, <a href="wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568a2575b9a3e195f8f7d000efda525ee82a">ERROR_WIFI_UNKNOWN</a> = -9 }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p276112278090251"><a name="p276112278090251"></a><a name="p276112278090251"></a>Enumerates Wi-Fi error codes. </p>
</td>
</tr>
<tr id="row39669401090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2027916303090251"><a name="p2027916303090251"></a><a name="p2027916303090251"></a><a href="wifiservice.md#ga6be99f93ce0d2d222c1f5f0a8217354d">WifiEventState</a> { <a href="wifiservice.md#gga6be99f93ce0d2d222c1f5f0a8217354daf35b74863c0b412178cb09d48303736b">WIFI_STATE_NOT_AVALIABLE</a> = 0, <a href="wifiservice.md#gga6be99f93ce0d2d222c1f5f0a8217354dac8939f62259c1f574abd1b251aa3b7c5">WIFI_STATE_AVALIABLE</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p730415393090251"><a name="p730415393090251"></a><a name="p730415393090251"></a>Enumerates states in Wi-Fi events. </p>
</td>
</tr>
<tr id="row1490296627090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1213934504090251"><a name="p1213934504090251"></a><a name="p1213934504090251"></a><a href="wifiservice.md#gadb1b12fe6311711103e759aac7a470d4">RssiLevel</a> { <a href="wifiservice.md#ggadb1b12fe6311711103e759aac7a470d4aac8c19cbf7131479b25de098fbdeb8d8">RSSI_LEVEL_1</a> = 1, <a href="wifiservice.md#ggadb1b12fe6311711103e759aac7a470d4a57b5d33edaf93c78c05ab061d0592f0b">RSSI_LEVEL_2</a> = 2, <a href="wifiservice.md#ggadb1b12fe6311711103e759aac7a470d4af91f262e971e83291e8bf6abe2bb7658">RSSI_LEVEL_3</a> = 3, <a href="wifiservice.md#ggadb1b12fe6311711103e759aac7a470d4a553e0aaf0ca409a2cde703825ffbe0d2">RSSI_LEVEL_4</a> = 4 }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1480914393090251"><a name="p1480914393090251"></a><a name="p1480914393090251"></a>Enumerates received signal strength indicator (RSSI) levels. </p>
</td>
</tr>
<tr id="row811547211090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p122908835090251"><a name="p122908835090251"></a><a name="p122908835090251"></a><a href="wifiservice.md#ga37e10532da87571ee89193beac42d246">HotspotBandType</a> { <a href="wifiservice.md#gga37e10532da87571ee89193beac42d246ad4c4672bd05d6d0ef3f22861758df731">HOTSPOT_BAND_TYPE_2G</a> = 1, <a href="wifiservice.md#gga37e10532da87571ee89193beac42d246a6eef5e29e90860fbffaa4744e5f069de">HOTSPOT_BAND_TYPE_5G</a> = 2 }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1336302874090251"><a name="p1336302874090251"></a><a name="p1336302874090251"></a>Enumerates frequency bands supported by the Wi-Fi hotspot mode. </p>
</td>
</tr>
<tr id="row1653153569090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1939624835090251"><a name="p1939624835090251"></a><a name="p1939624835090251"></a><a href="wifiservice.md#ga970b7d5373775b1c7f3b31074bae50e1">WifiConnState</a> { <a href="wifiservice.md#gga970b7d5373775b1c7f3b31074bae50e1ad5eea4330187ea7e6e389f00a75172dd">WIFI_DISCONNECTED</a>, <a href="wifiservice.md#gga970b7d5373775b1c7f3b31074bae50e1a7dff20e13d4cccaafe8f5976194ca3c3">WIFI_CONNECTED</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1616271933090251"><a name="p1616271933090251"></a><a name="p1616271933090251"></a>Enumerates Wi-Fi connection states. </p>
</td>
</tr>
</tbody>
</table>

## Functions<a name="func-members"></a>

<a name="table1611100849090251"></a>
<table><thead align="left"><tr id="row209323314090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2020426688090251"><a name="p2020426688090251"></a><a name="p2020426688090251"></a>Function Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1614357779090251"><a name="p1614357779090251"></a><a name="p1614357779090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1346779556090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1272493323090251"><a name="p1272493323090251"></a><a name="p1272493323090251"></a><a href="wifiservice.md#ga81afd7d5f0437260e93536b50437d99b">EnableWifi</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2062611905090251"><a name="p2062611905090251"></a><a name="p2062611905090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p173150247090251"><a name="p173150247090251"></a><a name="p173150247090251"></a>Enables the station mode. </p>
</td>
</tr>
<tr id="row644555864090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1187433451090251"><a name="p1187433451090251"></a><a name="p1187433451090251"></a><a href="wifiservice.md#ga96b28d8f77966a4cd042a46c598b3a9a">DisableWifi</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1678151742090251"><a name="p1678151742090251"></a><a name="p1678151742090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p1447666857090251"><a name="p1447666857090251"></a><a name="p1447666857090251"></a>Disables the station mode. </p>
</td>
</tr>
<tr id="row1371812717090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1052789089090251"><a name="p1052789089090251"></a><a name="p1052789089090251"></a><a href="wifiservice.md#ga57ee7c4c4ee6092098cb35965f507fb9">IsWifiActive</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1060380547090251"><a name="p1060380547090251"></a><a name="p1060380547090251"></a>int </p>
<p id="p606264836090251"><a name="p606264836090251"></a><a name="p606264836090251"></a>Checks whether the station mode is enabled. </p>
</td>
</tr>
<tr id="row1300960501090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1214102597090251"><a name="p1214102597090251"></a><a name="p1214102597090251"></a><a href="wifiservice.md#ga72d138ede38fbd6425f1fe7fbc35c262">Scan</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1097051106090251"><a name="p1097051106090251"></a><a name="p1097051106090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p729428276090251"><a name="p729428276090251"></a><a name="p729428276090251"></a>Starts a Wi-Fi scan. </p>
</td>
</tr>
<tr id="row2123200652090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p645437616090251"><a name="p645437616090251"></a><a name="p645437616090251"></a><a href="wifiservice.md#gadbbc62c6d2a16d5f1547097992aa9369">GetScanInfoList</a> (<a href="wifiscaninfo.md">WifiScanInfo</a> *result, unsigned int *size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p564665751090251"><a name="p564665751090251"></a><a name="p564665751090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p986315794090251"><a name="p986315794090251"></a><a name="p986315794090251"></a>Obtains an array of hotspots detected in a Wi-Fi scan. </p>
</td>
</tr>
<tr id="row1179116450090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p150897027090251"><a name="p150897027090251"></a><a name="p150897027090251"></a><a href="wifiservice.md#gaa0a50013ff978d6f82c655403946d8c9">AddDeviceConfig</a> (const <a href="wifideviceconfig.md">WifiDeviceConfig</a> *config, int *result)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1661851846090251"><a name="p1661851846090251"></a><a name="p1661851846090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p1195075957090251"><a name="p1195075957090251"></a><a name="p1195075957090251"></a>Adds a specified hotspot configuration for connecting to a hotspot. </p>
</td>
</tr>
<tr id="row1840474965090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1360676878090251"><a name="p1360676878090251"></a><a name="p1360676878090251"></a><a href="wifiservice.md#ga2202a6de3fdd8f463d827fc18f46e75b">GetDeviceConfigs</a> (<a href="wifideviceconfig.md">WifiDeviceConfig</a> *result, unsigned int *size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p234633241090251"><a name="p234633241090251"></a><a name="p234633241090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p552521418090251"><a name="p552521418090251"></a><a name="p552521418090251"></a>Obtains all hotspot configurations. </p>
</td>
</tr>
<tr id="row201331696090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1712442016090251"><a name="p1712442016090251"></a><a name="p1712442016090251"></a><a href="wifiservice.md#ga13d79f9dc92bf445b7ef2b98ab050c3a">RemoveDevice</a> (int networkId)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1937266571090251"><a name="p1937266571090251"></a><a name="p1937266571090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p1533197941090251"><a name="p1533197941090251"></a><a name="p1533197941090251"></a>Removes a hotspot configuration matching a specified <strong id="b2120052276090251"><a name="b2120052276090251"></a><a name="b2120052276090251"></a>networkId</strong>. </p>
</td>
</tr>
<tr id="row132176478090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1329847964090251"><a name="p1329847964090251"></a><a name="p1329847964090251"></a><a href="wifiservice.md#ga775ec0cfc1d5b4bf620bbd7245492344">ConnectTo</a> (int networkId)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p182813150090251"><a name="p182813150090251"></a><a name="p182813150090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p1896158210090251"><a name="p1896158210090251"></a><a name="p1896158210090251"></a>Connects to a hotspot matching a specified <strong id="b1568804791090251"><a name="b1568804791090251"></a><a name="b1568804791090251"></a>networkId</strong>. </p>
</td>
</tr>
<tr id="row394681292090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1317589119090251"><a name="p1317589119090251"></a><a name="p1317589119090251"></a><a href="wifiservice.md#gafbed9a87b5fef2c837a16c6de469652e">Disconnect</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1157752587090251"><a name="p1157752587090251"></a><a name="p1157752587090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p612568034090251"><a name="p612568034090251"></a><a name="p612568034090251"></a>Disconnects this Wi-Fi connection. </p>
</td>
</tr>
<tr id="row1281654767090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p446337309090251"><a name="p446337309090251"></a><a name="p446337309090251"></a><a href="wifiservice.md#gaa8f07a31b01761da44f0fe90d461c168">GetLinkedInfo</a> (<a href="wifilinkedinfo.md">WifiLinkedInfo</a> *result)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p871737938090251"><a name="p871737938090251"></a><a name="p871737938090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p193911380090251"><a name="p193911380090251"></a><a name="p193911380090251"></a>Obtains information about the connected hotspot. </p>
</td>
</tr>
<tr id="row691836527090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2066328488090251"><a name="p2066328488090251"></a><a name="p2066328488090251"></a><a href="wifiservice.md#ga0e4d452915d1588664b91837b821eada">RegisterWifiEvent</a> (<a href="wifievent.md">WifiEvent</a> *event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2147033429090251"><a name="p2147033429090251"></a><a name="p2147033429090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p93121312090251"><a name="p93121312090251"></a><a name="p93121312090251"></a>Registers a callback for a specified Wi-Fi event. </p>
</td>
</tr>
<tr id="row1333504637090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1380340205090251"><a name="p1380340205090251"></a><a name="p1380340205090251"></a><a href="wifiservice.md#gaee648c923f6594e222d0c592b929b3f1">UnRegisterWifiEvent</a> (const <a href="wifievent.md">WifiEvent</a> *event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p370355899090251"><a name="p370355899090251"></a><a name="p370355899090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p68856649090251"><a name="p68856649090251"></a><a name="p68856649090251"></a>Unregisters a callback previously registered for a specified Wi-Fi event. </p>
</td>
</tr>
<tr id="row480749978090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1602507494090251"><a name="p1602507494090251"></a><a name="p1602507494090251"></a><a href="wifiservice.md#ga951232a54faaa791a82b5e2456c44dcd">GetDeviceMacAddress</a> (unsigned char *result)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p383591696090251"><a name="p383591696090251"></a><a name="p383591696090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p1923569096090251"><a name="p1923569096090251"></a><a name="p1923569096090251"></a>Obtains the MAC address of this device. </p>
</td>
</tr>
<tr id="row1156039612090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1774722128090251"><a name="p1774722128090251"></a><a name="p1774722128090251"></a><a href="wifiservice.md#gaafff61f96ad29922b524dc9514cfbfd0">AdvanceScan</a> (<a href="wifiscanparams.md">WifiScanParams</a> *params)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p509964151090251"><a name="p509964151090251"></a><a name="p509964151090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p794465190090251"><a name="p794465190090251"></a><a name="p794465190090251"></a>Starts a Wi-Fi scan based on a specified parameter. </p>
</td>
</tr>
<tr id="row1429189406090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1052305247090251"><a name="p1052305247090251"></a><a name="p1052305247090251"></a><a href="wifiservice.md#ga6b5f219980f4c378384efd1b5560a0b5">EnableHotspot</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1907284269090251"><a name="p1907284269090251"></a><a name="p1907284269090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p1580289989090251"><a name="p1580289989090251"></a><a name="p1580289989090251"></a>Enables the hotspot mode. </p>
</td>
</tr>
<tr id="row1133521135090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1109185174090251"><a name="p1109185174090251"></a><a name="p1109185174090251"></a><a href="wifiservice.md#gaf164ccd00830d8acd9093b28a77b6096">DisableHotspot</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1172444851090251"><a name="p1172444851090251"></a><a name="p1172444851090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p301375354090251"><a name="p301375354090251"></a><a name="p301375354090251"></a>Disables the hotspot mode. </p>
</td>
</tr>
<tr id="row1698924224090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p638541046090251"><a name="p638541046090251"></a><a name="p638541046090251"></a><a href="wifiservice.md#gafebbb0442cc9334441ff0edc979753ca">SetHotspotConfig</a> (const <a href="hotspotconfig.md">HotspotConfig</a> *config)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1677846146090251"><a name="p1677846146090251"></a><a name="p1677846146090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p502242556090251"><a name="p502242556090251"></a><a name="p502242556090251"></a>Sets a specified hotspot configuration. </p>
</td>
</tr>
<tr id="row1580658408090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1134043023090251"><a name="p1134043023090251"></a><a name="p1134043023090251"></a><a href="wifiservice.md#ga0275a72cc29a7f331175726caa8444cd">GetHotspotConfig</a> (<a href="hotspotconfig.md">HotspotConfig</a> *result)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1877886949090251"><a name="p1877886949090251"></a><a name="p1877886949090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p1931031975090251"><a name="p1931031975090251"></a><a name="p1931031975090251"></a>Obtains a specified hotspot configuration. </p>
</td>
</tr>
<tr id="row2080871500090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p69855595090251"><a name="p69855595090251"></a><a name="p69855595090251"></a><a href="wifiservice.md#ga4085f013f3a4df6792bdbf780a938e89">IsHotspotActive</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p742919791090251"><a name="p742919791090251"></a><a name="p742919791090251"></a>int </p>
<p id="p1942108882090251"><a name="p1942108882090251"></a><a name="p1942108882090251"></a>Checks whether the hotspot mode is enabled. </p>
</td>
</tr>
<tr id="row30419476090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1845448515090251"><a name="p1845448515090251"></a><a name="p1845448515090251"></a><a href="wifiservice.md#ga7babac79dc6a618b5762b6436af2cb28">GetStationList</a> (<a href="stationinfo.md">StationInfo</a> *result, unsigned int *size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1831941029090251"><a name="p1831941029090251"></a><a name="p1831941029090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p544632897090251"><a name="p544632897090251"></a><a name="p544632897090251"></a>Obtains an array of stations connected to this hotspot. </p>
</td>
</tr>
<tr id="row1503164026090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2022221418090251"><a name="p2022221418090251"></a><a name="p2022221418090251"></a><a href="wifiservice.md#ga8711a25e460e961dc32e1296be060f6d">GetSignalLevel</a> (int rssi, int band)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p630389539090251"><a name="p630389539090251"></a><a name="p630389539090251"></a>int </p>
<p id="p388261331090251"><a name="p388261331090251"></a><a name="p388261331090251"></a>Obtains the signal level indicated by a specified received signal strength indicator (RSSI) and frequency band. </p>
</td>
</tr>
<tr id="row1272767182090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1730391951090251"><a name="p1730391951090251"></a><a name="p1730391951090251"></a><a href="wifiservice.md#gaf384863106ea0ba10efc4a0bd3c86d24">SetBand</a> (int band)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p175279558090251"><a name="p175279558090251"></a><a name="p175279558090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p219247428090251"><a name="p219247428090251"></a><a name="p219247428090251"></a>Sets the frequency band for this hotspot. </p>
</td>
</tr>
<tr id="row794430369090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p608922480090251"><a name="p608922480090251"></a><a name="p608922480090251"></a><a href="wifiservice.md#gaa7b20be6e6d8f9b04ec7d417a1c6410c">GetBand</a> (int *result)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1779470049090251"><a name="p1779470049090251"></a><a name="p1779470049090251"></a><a href="wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568">WifiErrorCode</a> </p>
<p id="p1116748333090251"><a name="p1116748333090251"></a><a name="p1116748333090251"></a>Obtains the frequency band of this hotspot. </p>
</td>
</tr>
</tbody>
</table>

## **Details**<a name="section1970760028090251"></a>

## **Macro Definition Documentation**<a name="section1102511850090251"></a>

## WIFI\_CONFIG\_INVALID<a name="ga658039dc314dff5e764e40677c84f5d9"></a>

```
#define WIFI_CONFIG_INVALID   (-1)
```

 **Description:**

Indicates the value of  **networkId**  when the configuration file is unavailable. 

Generally, the configuration file is unavailable because the configuration matching the  **networkId**  is uninitialized. 

## WIFI\_HOTSPOT\_ACTIVE<a name="gabf45f5779e5e04c8204db6a0d206af11"></a>

```
#define WIFI_HOTSPOT_ACTIVE   1
```

 **Description:**

Indicates that the Wi-Fi hotspot mode is enabled. 

## WIFI\_HOTSPOT\_NOT\_ACTIVE<a name="ga7dd021b8f69312a304632fd1d0244f02"></a>

```
#define WIFI_HOTSPOT_NOT_ACTIVE   0
```

 **Description:**

Indicates that the Wi-Fi hotspot mode is disabled. 

## WIFI\_MAC\_LEN<a name="gabc871a0934ad71ec71b29de3f9bc4815"></a>

```
#define WIFI_MAC_LEN   6
```

 **Description:**

Indicates the maximum length of a Wi-Fi MAC address or a Wi-Fi BSSID. 

## WIFI\_MAX\_CONFIG\_SIZE<a name="ga87d47fede3b37780bbd2f4981b560e54"></a>

```
#define WIFI_MAX_CONFIG_SIZE   10
```

 **Description:**

Indicates the maximum number of Wi-Fi station configurations that can be added using  [AddDeviceConfig](wifiservice.md#gaa0a50013ff978d6f82c655403946d8c9). 

If the maximum number is reached, an error will be returned. In this case, you must delete at least one configuration before you can add new ones. 

## WIFI\_MAX\_EVENT\_SIZE<a name="gaace417e14bf248f54aaa3d4f84138b14"></a>

```
#define WIFI_MAX_EVENT_SIZE   10
```

 **Description:**

Indicates the maximum number of event listeners that can be registered using  [RegisterWifiEvent](wifiservice.md#ga0e4d452915d1588664b91837b821eada). 

When the maximum number is reached, you need to unregister at least one listener before registering new ones. 

## WIFI\_MAX\_KEY\_LEN<a name="ga6017e2d011b6cffcd3663db81a2b52d8"></a>

```
#define WIFI_MAX_KEY_LEN   65
```

 **Description:**

Indicates the maximum length of a Wi-Fi key. 

The maximum length is 64, and the last bit is reserved and set to  **\\0**. 

## WIFI\_MAX\_SSID\_LEN<a name="ga7e01d8c5079081de486637b4482c937a"></a>

```
#define WIFI_MAX_SSID_LEN   33
```

 **Description:**

Indicates the maximum length of a Wi-Fi SSID. 

The maximum length is 32, and the last bit is reserved and set to  **\\0**. 

## WIFI\_PSK\_LEN<a name="ga101f9d44cb01fce5704f10ba8d9c7960"></a>

```
#define WIFI_PSK_LEN   32
```

 **Description:**

Indicates the maximum length of a Wi-Fi PSK. 

## WIFI\_STA\_ACTIVE<a name="ga9f956732e8e8da52eb25a84a7c42e2bb"></a>

```
#define WIFI_STA_ACTIVE   1
```

 **Description:**

Indicates that the Wi-Fi station mode is enabled. 

## WIFI\_STA\_NOT\_ACTIVE<a name="gaf26289b0fe6ef5ae86395c0556187cf8"></a>

```
#define WIFI_STA_NOT_ACTIVE   0
```

 **Description:**

Indicates that the Wi-Fi station mode is disabled. 

## **Typedef Documentation**<a name="section426233848090251"></a>

## WifiDeviceConfig<a name="gaa32cc451f81eeb416eda5968f71f4612"></a>

```
typedef struct [WifiDeviceConfig](wifideviceconfig.md) [WifiDeviceConfig](wifideviceconfig.md)
```

 **Description:**

Represents the Wi-Fi station configuration used to connect to a specified Wi-Fi device. 

## **Enumeration Type Documentation**<a name="section306454597090251"></a>

## HotspotBandType<a name="ga37e10532da87571ee89193beac42d246"></a>

```
enum [HotspotBandType](wifiservice.md#ga37e10532da87571ee89193beac42d246)
```

 **Description:**

Enumerates frequency bands supported by the Wi-Fi hotspot mode. 

<a name="table1652039646090251"></a>
<table><thead align="left"><tr id="row273236615090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1183484094090251"><a name="p1183484094090251"></a><a name="p1183484094090251"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1384999753090251"><a name="p1384999753090251"></a><a name="p1384999753090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row594059528090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga37e10532da87571ee89193beac42d246ad4c4672bd05d6d0ef3f22861758df731"><a name="gga37e10532da87571ee89193beac42d246ad4c4672bd05d6d0ef3f22861758df731"></a><a name="gga37e10532da87571ee89193beac42d246ad4c4672bd05d6d0ef3f22861758df731"></a></strong>HOTSPOT_BAND_TYPE_2G </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p468704109090251"><a name="p468704109090251"></a><a name="p468704109090251"></a>2.4 GHz </p>
 </td>
</tr>
<tr id="row624857867090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga37e10532da87571ee89193beac42d246a6eef5e29e90860fbffaa4744e5f069de"><a name="gga37e10532da87571ee89193beac42d246a6eef5e29e90860fbffaa4744e5f069de"></a><a name="gga37e10532da87571ee89193beac42d246a6eef5e29e90860fbffaa4744e5f069de"></a></strong>HOTSPOT_BAND_TYPE_5G </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1923228465090251"><a name="p1923228465090251"></a><a name="p1923228465090251"></a>5 GHz </p>
 </td>
</tr>
</tbody>
</table>

## RssiLevel<a name="gadb1b12fe6311711103e759aac7a470d4"></a>

```
enum [RssiLevel](wifiservice.md#gadb1b12fe6311711103e759aac7a470d4)
```

 **Description:**

Enumerates received signal strength indicator \(RSSI\) levels. 

Four RSSI levels are available: 1 to 4. The higher the RSSI level, the stronger the Wi-Fi signal.

<a name="table197188043090251"></a>
<table><thead align="left"><tr id="row678290178090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1824888458090251"><a name="p1824888458090251"></a><a name="p1824888458090251"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1455196663090251"><a name="p1455196663090251"></a><a name="p1455196663090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1172464956090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggadb1b12fe6311711103e759aac7a470d4aac8c19cbf7131479b25de098fbdeb8d8"><a name="ggadb1b12fe6311711103e759aac7a470d4aac8c19cbf7131479b25de098fbdeb8d8"></a><a name="ggadb1b12fe6311711103e759aac7a470d4aac8c19cbf7131479b25de098fbdeb8d8"></a></strong>RSSI_LEVEL_1 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1572105926090251"><a name="p1572105926090251"></a><a name="p1572105926090251"></a>Level 1. The RSSI value for a 2.4 GHz hotspot ranges from <strong id="b1967912224090251"><a name="b1967912224090251"></a><a name="b1967912224090251"></a>-88</strong> (included) to <strong id="b1626014038090251"><a name="b1626014038090251"></a><a name="b1626014038090251"></a>-82</strong> (excluded), and that for a 5 GHz hotspot ranges from <strong id="b1352552614090251"><a name="b1352552614090251"></a><a name="b1352552614090251"></a>-85</strong> (included) to <strong id="b1429376123090251"><a name="b1429376123090251"></a><a name="b1429376123090251"></a>-79</strong> (excluded). </p>
 </td>
</tr>
<tr id="row1288119562090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggadb1b12fe6311711103e759aac7a470d4a57b5d33edaf93c78c05ab061d0592f0b"><a name="ggadb1b12fe6311711103e759aac7a470d4a57b5d33edaf93c78c05ab061d0592f0b"></a><a name="ggadb1b12fe6311711103e759aac7a470d4a57b5d33edaf93c78c05ab061d0592f0b"></a></strong>RSSI_LEVEL_2 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1985799745090251"><a name="p1985799745090251"></a><a name="p1985799745090251"></a>Level 2. The RSSI value for a 2.4 GHz hotspot ranges from <strong id="b978943731090251"><a name="b978943731090251"></a><a name="b978943731090251"></a>-82</strong> (included) to <strong id="b2018409105090251"><a name="b2018409105090251"></a><a name="b2018409105090251"></a>-75</strong> (excluded), and that for a 5 GHz hotspot ranges from <strong id="b1693974589090251"><a name="b1693974589090251"></a><a name="b1693974589090251"></a>-79</strong> (included) to <strong id="b824092707090251"><a name="b824092707090251"></a><a name="b824092707090251"></a>-72</strong> (excluded). </p>
 </td>
</tr>
<tr id="row954536684090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggadb1b12fe6311711103e759aac7a470d4af91f262e971e83291e8bf6abe2bb7658"><a name="ggadb1b12fe6311711103e759aac7a470d4af91f262e971e83291e8bf6abe2bb7658"></a><a name="ggadb1b12fe6311711103e759aac7a470d4af91f262e971e83291e8bf6abe2bb7658"></a></strong>RSSI_LEVEL_3 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1868791492090251"><a name="p1868791492090251"></a><a name="p1868791492090251"></a>Level 3. The RSSI value for a 2.4 GHz hotspot ranges from <strong id="b1887693127090251"><a name="b1887693127090251"></a><a name="b1887693127090251"></a>-75</strong> (included) to <strong id="b1015290293090251"><a name="b1015290293090251"></a><a name="b1015290293090251"></a>-65</strong> (excluded), and that for a 5 GHz hotspot ranges from <strong id="b697577476090251"><a name="b697577476090251"></a><a name="b697577476090251"></a>-72</strong> (included) to <strong id="b1512950373090251"><a name="b1512950373090251"></a><a name="b1512950373090251"></a>-65</strong> (excluded). </p>
 </td>
</tr>
<tr id="row95442908090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggadb1b12fe6311711103e759aac7a470d4a553e0aaf0ca409a2cde703825ffbe0d2"><a name="ggadb1b12fe6311711103e759aac7a470d4a553e0aaf0ca409a2cde703825ffbe0d2"></a><a name="ggadb1b12fe6311711103e759aac7a470d4a553e0aaf0ca409a2cde703825ffbe0d2"></a></strong>RSSI_LEVEL_4 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1037567919090251"><a name="p1037567919090251"></a><a name="p1037567919090251"></a>Level 4. The RSSI value for a 2.4 GHz or 5 GHz hotspot is greater than or equal to <strong id="b1765533297090251"><a name="b1765533297090251"></a><a name="b1765533297090251"></a>-65</strong>. </p>
 </td>
</tr>
</tbody>
</table>

## WifiConnState<a name="ga970b7d5373775b1c7f3b31074bae50e1"></a>

```
enum [WifiConnState](wifiservice.md#ga970b7d5373775b1c7f3b31074bae50e1)
```

 **Description:**

Enumerates Wi-Fi connection states. 

<a name="table113063049090251"></a>
<table><thead align="left"><tr id="row562484334090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p664270040090251"><a name="p664270040090251"></a><a name="p664270040090251"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p925749837090251"><a name="p925749837090251"></a><a name="p925749837090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row743851673090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga970b7d5373775b1c7f3b31074bae50e1ad5eea4330187ea7e6e389f00a75172dd"><a name="gga970b7d5373775b1c7f3b31074bae50e1ad5eea4330187ea7e6e389f00a75172dd"></a><a name="gga970b7d5373775b1c7f3b31074bae50e1ad5eea4330187ea7e6e389f00a75172dd"></a></strong>WIFI_DISCONNECTED </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p855156540090251"><a name="p855156540090251"></a><a name="p855156540090251"></a>Disconnected </p>
 </td>
</tr>
<tr id="row168775957090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga970b7d5373775b1c7f3b31074bae50e1a7dff20e13d4cccaafe8f5976194ca3c3"><a name="gga970b7d5373775b1c7f3b31074bae50e1a7dff20e13d4cccaafe8f5976194ca3c3"></a><a name="gga970b7d5373775b1c7f3b31074bae50e1a7dff20e13d4cccaafe8f5976194ca3c3"></a></strong>WIFI_CONNECTED </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1831304810090251"><a name="p1831304810090251"></a><a name="p1831304810090251"></a>Connected </p>
 </td>
</tr>
</tbody>
</table>

## WifiErrorCode<a name="ga2506c6ad226c4feb1d19248013ff9568"></a>

```
enum [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)
```

 **Description:**

Enumerates Wi-Fi error codes. 

<a name="table885327614090251"></a>
<table><thead align="left"><tr id="row692208830090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p24712756090251"><a name="p24712756090251"></a><a name="p24712756090251"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p265354304090251"><a name="p265354304090251"></a><a name="p265354304090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row454883012090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e"><a name="gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e"></a><a name="gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e"></a></strong>WIFI_SUCCESS </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1896344332090251"><a name="p1896344332090251"></a><a name="p1896344332090251"></a>No errors. </p>
 </td>
</tr>
<tr id="row1184736212090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2506c6ad226c4feb1d19248013ff9568a254a2c9cb1bc2265e22a3664300ab7f6"><a name="gga2506c6ad226c4feb1d19248013ff9568a254a2c9cb1bc2265e22a3664300ab7f6"></a><a name="gga2506c6ad226c4feb1d19248013ff9568a254a2c9cb1bc2265e22a3664300ab7f6"></a></strong>ERROR_WIFI_INVALID_ARGS </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p84069727090251"><a name="p84069727090251"></a><a name="p84069727090251"></a>Invalid parameters </p>
 </td>
</tr>
<tr id="row2025885861090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2506c6ad226c4feb1d19248013ff9568a5a44965477d4640f18c5530c550dd713"><a name="gga2506c6ad226c4feb1d19248013ff9568a5a44965477d4640f18c5530c550dd713"></a><a name="gga2506c6ad226c4feb1d19248013ff9568a5a44965477d4640f18c5530c550dd713"></a></strong>ERROR_WIFI_CHIP_INVALID </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1598055029090251"><a name="p1598055029090251"></a><a name="p1598055029090251"></a>Invalid chip </p>
 </td>
</tr>
<tr id="row1124186181090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2506c6ad226c4feb1d19248013ff9568a65aea729766935f24296c909332e49dd"><a name="gga2506c6ad226c4feb1d19248013ff9568a65aea729766935f24296c909332e49dd"></a><a name="gga2506c6ad226c4feb1d19248013ff9568a65aea729766935f24296c909332e49dd"></a></strong>ERROR_WIFI_IFACE_INVALID </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p998006306090251"><a name="p998006306090251"></a><a name="p998006306090251"></a>Invalid Wi-Fi interface </p>
 </td>
</tr>
<tr id="row974636689090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2506c6ad226c4feb1d19248013ff9568aad0d24ea74cf194e34d7eee09c23497a"><a name="gga2506c6ad226c4feb1d19248013ff9568aad0d24ea74cf194e34d7eee09c23497a"></a><a name="gga2506c6ad226c4feb1d19248013ff9568aad0d24ea74cf194e34d7eee09c23497a"></a></strong>ERROR_WIFI_RTT_CONTROLLER_INVALID </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1736149392090251"><a name="p1736149392090251"></a><a name="p1736149392090251"></a>Invalid RTT controller </p>
 </td>
</tr>
<tr id="row28175085090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2506c6ad226c4feb1d19248013ff9568a08a0d323d9c0565d0cd0e50505760aea"><a name="gga2506c6ad226c4feb1d19248013ff9568a08a0d323d9c0565d0cd0e50505760aea"></a><a name="gga2506c6ad226c4feb1d19248013ff9568a08a0d323d9c0565d0cd0e50505760aea"></a></strong>ERROR_WIFI_NOT_SUPPORTED </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1853681782090251"><a name="p1853681782090251"></a><a name="p1853681782090251"></a>Wi-Fi not supported by the current version or device </p>
 </td>
</tr>
<tr id="row1259968780090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2506c6ad226c4feb1d19248013ff9568ae6421614f352b5c98bdb0f2ad96ed69b"><a name="gga2506c6ad226c4feb1d19248013ff9568ae6421614f352b5c98bdb0f2ad96ed69b"></a><a name="gga2506c6ad226c4feb1d19248013ff9568ae6421614f352b5c98bdb0f2ad96ed69b"></a></strong>ERROR_WIFI_NOT_AVAILABLE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p725269849090251"><a name="p725269849090251"></a><a name="p725269849090251"></a>Wi-Fi unavailable </p>
 </td>
</tr>
<tr id="row563071815090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2506c6ad226c4feb1d19248013ff9568af961fdaa2b25e55977119d52b25fc6bb"><a name="gga2506c6ad226c4feb1d19248013ff9568af961fdaa2b25e55977119d52b25fc6bb"></a><a name="gga2506c6ad226c4feb1d19248013ff9568af961fdaa2b25e55977119d52b25fc6bb"></a></strong>ERROR_WIFI_NOT_STARTED </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p511358762090251"><a name="p511358762090251"></a><a name="p511358762090251"></a>Wi-Fi not initialized or started </p>
 </td>
</tr>
<tr id="row1210257192090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2506c6ad226c4feb1d19248013ff9568a7d4644e036859887013ac6c833ddd67e"><a name="gga2506c6ad226c4feb1d19248013ff9568a7d4644e036859887013ac6c833ddd67e"></a><a name="gga2506c6ad226c4feb1d19248013ff9568a7d4644e036859887013ac6c833ddd67e"></a></strong>ERROR_WIFI_BUSY </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p558422859090251"><a name="p558422859090251"></a><a name="p558422859090251"></a>System busy </p>
 </td>
</tr>
<tr id="row2001302709090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2506c6ad226c4feb1d19248013ff9568a2575b9a3e195f8f7d000efda525ee82a"><a name="gga2506c6ad226c4feb1d19248013ff9568a2575b9a3e195f8f7d000efda525ee82a"></a><a name="gga2506c6ad226c4feb1d19248013ff9568a2575b9a3e195f8f7d000efda525ee82a"></a></strong>ERROR_WIFI_UNKNOWN </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p549553401090251"><a name="p549553401090251"></a><a name="p549553401090251"></a>Unknown error </p>
 </td>
</tr>
</tbody>
</table>

## WifiEventState<a name="ga6be99f93ce0d2d222c1f5f0a8217354d"></a>

```
enum [WifiEventState](wifiservice.md#ga6be99f93ce0d2d222c1f5f0a8217354d)
```

 **Description:**

Enumerates states in Wi-Fi events. 

<a name="table597599597090251"></a>
<table><thead align="left"><tr id="row145444833090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1525194742090251"><a name="p1525194742090251"></a><a name="p1525194742090251"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2070307423090251"><a name="p2070307423090251"></a><a name="p2070307423090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row65927160090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6be99f93ce0d2d222c1f5f0a8217354daf35b74863c0b412178cb09d48303736b"><a name="gga6be99f93ce0d2d222c1f5f0a8217354daf35b74863c0b412178cb09d48303736b"></a><a name="gga6be99f93ce0d2d222c1f5f0a8217354daf35b74863c0b412178cb09d48303736b"></a></strong>WIFI_STATE_NOT_AVALIABLE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p955046081090251"><a name="p955046081090251"></a><a name="p955046081090251"></a>Unavailable state </p>
 </td>
</tr>
<tr id="row91658774090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6be99f93ce0d2d222c1f5f0a8217354dac8939f62259c1f574abd1b251aa3b7c5"><a name="gga6be99f93ce0d2d222c1f5f0a8217354dac8939f62259c1f574abd1b251aa3b7c5"></a><a name="gga6be99f93ce0d2d222c1f5f0a8217354dac8939f62259c1f574abd1b251aa3b7c5"></a></strong>WIFI_STATE_AVALIABLE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p366915086090251"><a name="p366915086090251"></a><a name="p366915086090251"></a>Available state </p>
 </td>
</tr>
</tbody>
</table>

## WifiPskType<a name="gaa1a44d23b8478232f14d2adfc82cee77"></a>

```
enum [WifiPskType](wifiservice.md#gaa1a44d23b8478232f14d2adfc82cee77)
```

 **Description:**

Enumerates psk encryption types. 

<a name="table327190977090251"></a>
<table><thead align="left"><tr id="row1639727780090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p449636925090251"><a name="p449636925090251"></a><a name="p449636925090251"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p512531053090251"><a name="p512531053090251"></a><a name="p512531053090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row920020980090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa1a44d23b8478232f14d2adfc82cee77aedaceae77cb05c54cc8775653cfea4e8"><a name="ggaa1a44d23b8478232f14d2adfc82cee77aedaceae77cb05c54cc8775653cfea4e8"></a><a name="ggaa1a44d23b8478232f14d2adfc82cee77aedaceae77cb05c54cc8775653cfea4e8"></a></strong>WIFI_PSK_TYPE_ASCII </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1618593039090251"><a name="p1618593039090251"></a><a name="p1618593039090251"></a>Indicates that the ascii type of psk encryption type </p>
 </td>
</tr>
<tr id="row252256972090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa1a44d23b8478232f14d2adfc82cee77ad480d8db3b2f13d7d53c8d8cab22f10a"><a name="ggaa1a44d23b8478232f14d2adfc82cee77ad480d8db3b2f13d7d53c8d8cab22f10a"></a><a name="ggaa1a44d23b8478232f14d2adfc82cee77ad480d8db3b2f13d7d53c8d8cab22f10a"></a></strong>WIFI_PSK_TYPE_HEX </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1322803036090251"><a name="p1322803036090251"></a><a name="p1322803036090251"></a>Indicates that the hex type of psk encryption type </p>
 </td>
</tr>
</tbody>
</table>

## WifiScanType<a name="ga007bf5e22727debc02cad860e41a60a3"></a>

```
enum [WifiScanType](wifiservice.md#ga007bf5e22727debc02cad860e41a60a3)
```

 **Description:**

Enumerates Wi-Fi scan types. 

<a name="table735119771090251"></a>
<table><thead align="left"><tr id="row925587115090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p880037611090251"><a name="p880037611090251"></a><a name="p880037611090251"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p318234169090251"><a name="p318234169090251"></a><a name="p318234169090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1971765853090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga007bf5e22727debc02cad860e41a60a3ad0d2a6703ee6092223acfae5bd295ab0"><a name="gga007bf5e22727debc02cad860e41a60a3ad0d2a6703ee6092223acfae5bd295ab0"></a><a name="gga007bf5e22727debc02cad860e41a60a3ad0d2a6703ee6092223acfae5bd295ab0"></a></strong>WIFI_FREQ_SCAN </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1920902539090251"><a name="p1920902539090251"></a><a name="p1920902539090251"></a>A scan based on a specified frequency. </p>
 </td>
</tr>
<tr id="row1081446608090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga007bf5e22727debc02cad860e41a60a3a0b97d9caa917ae9d6f23738424dd25a1"><a name="gga007bf5e22727debc02cad860e41a60a3a0b97d9caa917ae9d6f23738424dd25a1"></a><a name="gga007bf5e22727debc02cad860e41a60a3a0b97d9caa917ae9d6f23738424dd25a1"></a></strong>WIFI_SSID_SCAN </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1928679933090251"><a name="p1928679933090251"></a><a name="p1928679933090251"></a>A scan based on a specified SSID. </p>
 </td>
</tr>
<tr id="row774477989090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga007bf5e22727debc02cad860e41a60a3a95e3be3877b0f9c483cb3b0575b6dce2"><a name="gga007bf5e22727debc02cad860e41a60a3a95e3be3877b0f9c483cb3b0575b6dce2"></a><a name="gga007bf5e22727debc02cad860e41a60a3a95e3be3877b0f9c483cb3b0575b6dce2"></a></strong>WIFI_BSSID_SCAN </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p204145345090251"><a name="p204145345090251"></a><a name="p204145345090251"></a>A scan based on a specified BSSID. </p>
 </td>
</tr>
<tr id="row2061208859090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga007bf5e22727debc02cad860e41a60a3a75b4c033f7ddd140a17061c0bdb9d71a"><a name="gga007bf5e22727debc02cad860e41a60a3a75b4c033f7ddd140a17061c0bdb9d71a"></a><a name="gga007bf5e22727debc02cad860e41a60a3a75b4c033f7ddd140a17061c0bdb9d71a"></a></strong>WIFI_BAND_SCAN </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p616107170090251"><a name="p616107170090251"></a><a name="p616107170090251"></a>A scan based on a specified frequency band. </p>
 </td>
</tr>
</tbody>
</table>

## WifiSecurityType<a name="ga97c133f7db7c1234babcde03c4ce1b05"></a>

```
enum [WifiSecurityType](wifiservice.md#ga97c133f7db7c1234babcde03c4ce1b05)
```

 **Description:**

Enumerates Wi-Fi security types. 

<a name="table1762016140090251"></a>
<table><thead align="left"><tr id="row186298519090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1568550925090251"><a name="p1568550925090251"></a><a name="p1568550925090251"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1465081509090251"><a name="p1465081509090251"></a><a name="p1465081509090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row559697479090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga97c133f7db7c1234babcde03c4ce1b05ad512f146aed5b76788c5be8dfb370f13"><a name="gga97c133f7db7c1234babcde03c4ce1b05ad512f146aed5b76788c5be8dfb370f13"></a><a name="gga97c133f7db7c1234babcde03c4ce1b05ad512f146aed5b76788c5be8dfb370f13"></a></strong>WIFI_SEC_TYPE_INVALID </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p808908265090251"><a name="p808908265090251"></a><a name="p808908265090251"></a>Invalid security type </p>
 </td>
</tr>
<tr id="row351241063090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga97c133f7db7c1234babcde03c4ce1b05a0ee2ed98b3ed21009c7d1b19945b8976"><a name="gga97c133f7db7c1234babcde03c4ce1b05a0ee2ed98b3ed21009c7d1b19945b8976"></a><a name="gga97c133f7db7c1234babcde03c4ce1b05a0ee2ed98b3ed21009c7d1b19945b8976"></a></strong>WIFI_SEC_TYPE_OPEN </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1244256564090251"><a name="p1244256564090251"></a><a name="p1244256564090251"></a>Open </p>
 </td>
</tr>
<tr id="row314603545090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga97c133f7db7c1234babcde03c4ce1b05a2d99c910346eb2a47965aea234f2fbe6"><a name="gga97c133f7db7c1234babcde03c4ce1b05a2d99c910346eb2a47965aea234f2fbe6"></a><a name="gga97c133f7db7c1234babcde03c4ce1b05a2d99c910346eb2a47965aea234f2fbe6"></a></strong>WIFI_SEC_TYPE_WEP </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p760244241090251"><a name="p760244241090251"></a><a name="p760244241090251"></a>Wired Equivalent Privacy (WEP) </p>
 </td>
</tr>
<tr id="row1147213333090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga97c133f7db7c1234babcde03c4ce1b05acec838f5f04a983f722c0cf749468870"><a name="gga97c133f7db7c1234babcde03c4ce1b05acec838f5f04a983f722c0cf749468870"></a><a name="gga97c133f7db7c1234babcde03c4ce1b05acec838f5f04a983f722c0cf749468870"></a></strong>WIFI_SEC_TYPE_PSK </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p215485424090251"><a name="p215485424090251"></a><a name="p215485424090251"></a>Pre-shared key (PSK) </p>
 </td>
</tr>
<tr id="row1358054602090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga97c133f7db7c1234babcde03c4ce1b05a7fe59ec8c8f2b2337f6b3a2268a9cfb4"><a name="gga97c133f7db7c1234babcde03c4ce1b05a7fe59ec8c8f2b2337f6b3a2268a9cfb4"></a><a name="gga97c133f7db7c1234babcde03c4ce1b05a7fe59ec8c8f2b2337f6b3a2268a9cfb4"></a></strong>WIFI_SEC_TYPE_SAE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p778990310090251"><a name="p778990310090251"></a><a name="p778990310090251"></a>Simultaneous Authentication of Equals (SAE) </p>
 </td>
</tr>
</tbody>
</table>

## **Function Documentation**<a name="section574728733090251"></a>

## AddDeviceConfig\(\)<a name="gaa0a50013ff978d6f82c655403946d8c9"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) AddDeviceConfig (const [WifiDeviceConfig](wifideviceconfig.md) * config, int * result )
```

 **Description:**

Adds a specified hotspot configuration for connecting to a hotspot. 

This function generates a  **networkId**. 

**Parameters:**

<a name="table155539391090251"></a>
<table><thead align="left"><tr id="row1938124353090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1146506716090251"><a name="p1146506716090251"></a><a name="p1146506716090251"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p376689013090251"><a name="p376689013090251"></a><a name="p376689013090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1154419322090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">config</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the hotspot configuration to add. </td>
</tr>
<tr id="row464976272090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">result</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the generated <strong id="b145656838090251"><a name="b145656838090251"></a><a name="b145656838090251"></a>networkId</strong>. Each <strong id="b2082473999090251"><a name="b2082473999090251"></a><a name="b2082473999090251"></a>networkId</strong> matches a hotspot configuration. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if the specified hotspot configuration is added; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



## AdvanceScan\(\)<a name="gaafff61f96ad29922b524dc9514cfbfd0"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) AdvanceScan ([WifiScanParams](wifiscanparams.md) * params)
```

 **Description:**

Starts a Wi-Fi scan based on a specified parameter. 

Only results matching the specified parameter will be returned for the Wi-Fi scan. 

**Parameters:**

<a name="table895500801090251"></a>
<table><thead align="left"><tr id="row731256325090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p474165801090251"><a name="p474165801090251"></a><a name="p474165801090251"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p419533295090251"><a name="p419533295090251"></a><a name="p419533295090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1868165996090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">params</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the parameter for starting the Wi-Fi scan. For details, see <a href="wifiscanparams.md">WifiScanParams</a>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if the Wi-Fi scan is started successfully; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



## ConnectTo\(\)<a name="ga775ec0cfc1d5b4bf620bbd7245492344"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) ConnectTo (int networkId)
```

 **Description:**

Connects to a hotspot matching a specified  **networkId**. 

Before calling this function, call  [AddDeviceConfig](wifiservice.md#gaa0a50013ff978d6f82c655403946d8c9)  to add a hotspot configuration. 

**Parameters:**

<a name="table1967199770090251"></a>
<table><thead align="left"><tr id="row1346621928090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p948473223090251"><a name="p948473223090251"></a><a name="p948473223090251"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1832132598090251"><a name="p1832132598090251"></a><a name="p1832132598090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1304720609090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">networkId</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the <strong id="b926448626090251"><a name="b926448626090251"></a><a name="b926448626090251"></a>networkId</strong> matching the target hotspot. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if the hotspot is connected; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



## DisableHotspot\(\)<a name="gaf164ccd00830d8acd9093b28a77b6096"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) DisableHotspot (void )
```

 **Description:**

Disables the hotspot mode. 

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if the hotspot mode is disabled; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



## DisableWifi\(\)<a name="ga96b28d8f77966a4cd042a46c598b3a9a"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) DisableWifi (void )
```

 **Description:**

Disables the station mode. 

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if the station mode is disabled; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



## Disconnect\(\)<a name="gafbed9a87b5fef2c837a16c6de469652e"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) Disconnect (void )
```

 **Description:**

Disconnects this Wi-Fi connection. 

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if this Wi-Fi connection is disconnected; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



## EnableHotspot\(\)<a name="ga6b5f219980f4c378384efd1b5560a0b5"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) EnableHotspot (void )
```

 **Description:**

Enables the hotspot mode. 

Before using this function, you need to invoke  [SetHotspotConfig](wifiservice.md#gafebbb0442cc9334441ff0edc979753ca)  and set at least the SSID, security type, and key. 

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if the hotspot mode is enabled; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



## EnableWifi\(\)<a name="ga81afd7d5f0437260e93536b50437d99b"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) EnableWifi (void )
```

 **Description:**

Enables the station mode. 

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if the station mode is enabled; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



## GetBand\(\)<a name="gaa7b20be6e6d8f9b04ec7d417a1c6410c"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) GetBand (int * result)
```

 **Description:**

Obtains the frequency band of this hotspot. 

**Parameters:**

<a name="table2024450552090251"></a>
<table><thead align="left"><tr id="row2078322657090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p275163960090251"><a name="p275163960090251"></a><a name="p275163960090251"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1926011608090251"><a name="p1926011608090251"></a><a name="p1926011608090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row540657054090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">result</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the obtained frequency band. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if the frequency band is obtained; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



## GetDeviceConfigs\(\)<a name="ga2202a6de3fdd8f463d827fc18f46e75b"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) GetDeviceConfigs ([WifiDeviceConfig](wifideviceconfig.md) * result, unsigned int * size )
```

 **Description:**

Obtains all hotspot configurations. 

Hotspot configurations were added using  [AddDeviceConfig](wifiservice.md#gaa0a50013ff978d6f82c655403946d8c9). 

**Parameters:**

<a name="table678722547090251"></a>
<table><thead align="left"><tr id="row740419245090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1377150078090251"><a name="p1377150078090251"></a><a name="p1377150078090251"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p810199971090251"><a name="p810199971090251"></a><a name="p810199971090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1346532768090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">result</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the array of all hotspot configurations. The array is requested and released by the caller. The value must be greater than or equal to <a href="wifiservice.md#ga87d47fede3b37780bbd2f4981b560e54">WIFI_MAX_CONFIG_SIZE</a>. </td>
</tr>
<tr id="row1260714387090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the array. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if all hotspot configurations are obtained; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



## GetDeviceMacAddress\(\)<a name="ga951232a54faaa791a82b5e2456c44dcd"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) GetDeviceMacAddress (unsigned char * result)
```

 **Description:**

Obtains the MAC address of this device. 

**Parameters:**

<a name="table1454860360090251"></a>
<table><thead align="left"><tr id="row1547204508090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1986961651090251"><a name="p1986961651090251"></a><a name="p1986961651090251"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1160256484090251"><a name="p1160256484090251"></a><a name="p1160256484090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row18362719090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">result</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the MAC address of this device. It is a char array whose length is 6. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if the MAC address of this device is obtained; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



## GetHotspotConfig\(\)<a name="ga0275a72cc29a7f331175726caa8444cd"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) GetHotspotConfig ([HotspotConfig](hotspotconfig.md) * result)
```

 **Description:**

Obtains a specified hotspot configuration. 

The hotspot configuration includes the SSID, security type, and key. 

**Parameters:**

<a name="table428978645090251"></a>
<table><thead align="left"><tr id="row1768181192090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p447286892090251"><a name="p447286892090251"></a><a name="p447286892090251"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p166042912090251"><a name="p166042912090251"></a><a name="p166042912090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row416746967090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">result</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the obtained hotspot configuration. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if the hotspot configuration is obtained; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



## GetLinkedInfo\(\)<a name="gaa8f07a31b01761da44f0fe90d461c168"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) GetLinkedInfo ([WifiLinkedInfo](wifilinkedinfo.md) * result)
```

 **Description:**

Obtains information about the connected hotspot. 

**Parameters:**

<a name="table703083249090251"></a>
<table><thead align="left"><tr id="row796303353090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1047247943090251"><a name="p1047247943090251"></a><a name="p1047247943090251"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p104528815090251"><a name="p104528815090251"></a><a name="p104528815090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1757010567090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">result</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the information about the connected hotspot. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if the information about the connected hotspot is obtained; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



## GetScanInfoList\(\)<a name="gadbbc62c6d2a16d5f1547097992aa9369"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) GetScanInfoList ([WifiScanInfo](wifiscaninfo.md) * result, unsigned int * size )
```

 **Description:**

Obtains an array of hotspots detected in a Wi-Fi scan. 

The array of hotspots can be obtained only after the Wi-Fi scan is complete. 

**Parameters:**

<a name="table1210299788090251"></a>
<table><thead align="left"><tr id="row1645207281090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1306657811090251"><a name="p1306657811090251"></a><a name="p1306657811090251"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1222766701090251"><a name="p1222766701090251"></a><a name="p1222766701090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row752218802090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">result</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the array of hotspots detected in a Wi-Fi scan. The array is requested and released by the caller. The value must be greater than or equal to <a href="wifiservice.md#gae280c9f1344a0b632d4097faa0d84555">WIFI_SCAN_HOTSPOT_LIMIT</a>. </td>
</tr>
<tr id="row1878822491090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the array. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if the array of hotspots detected in the Wi-Fi scan is obtained; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



## GetSignalLevel\(\)<a name="ga8711a25e460e961dc32e1296be060f6d"></a>

```
int GetSignalLevel (int rssi, int band )
```

 **Description:**

Obtains the signal level indicated by a specified received signal strength indicator \(RSSI\) and frequency band. 

Based on the signal level, you can display the signal strength represented by the number of signal bars. 

**Parameters:**

<a name="table509545797090251"></a>
<table><thead align="left"><tr id="row110863664090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1755624170090251"><a name="p1755624170090251"></a><a name="p1755624170090251"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1921574026090251"><a name="p1921574026090251"></a><a name="p1921574026090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row674172403090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">rssi</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the RSSI. </td>
</tr>
<tr id="row829085526090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">band</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the frequency band, either <a href="wifiservice.md#gga37e10532da87571ee89193beac42d246a6eef5e29e90860fbffaa4744e5f069de">HOTSPOT_BAND_TYPE_5G</a> or <a href="wifiservice.md#gga37e10532da87571ee89193beac42d246ad4c4672bd05d6d0ef3f22861758df731">HOTSPOT_BAND_TYPE_2G</a>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the signal level if it is obtained; returns  **-1**  otherwise. 



## GetStationList\(\)<a name="ga7babac79dc6a618b5762b6436af2cb28"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) GetStationList ([StationInfo](stationinfo.md) * result, unsigned int * size )
```

 **Description:**

Obtains an array of stations connected to this hotspot. 

The station information is defined in  [StationInfo](stationinfo.md). 

**Parameters:**

<a name="table1735171429090251"></a>
<table><thead align="left"><tr id="row1726530597090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p590375609090251"><a name="p590375609090251"></a><a name="p590375609090251"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p77974937090251"><a name="p77974937090251"></a><a name="p77974937090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1294890905090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">result</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the array of stations connected to this hotspot. The array is requested and released by the caller. The value must be greater than or equal to <a href="wifiservice.md#ga3aaba95d8760c837c01e209e52387711">WIFI_MAX_STA_NUM</a>. </td>
</tr>
<tr id="row955333524090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the array. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if the array of stations connected to this hotspot is obtained; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



## IsHotspotActive\(\)<a name="ga4085f013f3a4df6792bdbf780a938e89"></a>

```
int IsHotspotActive (void )
```

 **Description:**

Checks whether the hotspot mode is enabled. 

**Returns:**

Returns  [WIFI\_HOTSPOT\_ACTIVE](wifiservice.md#gabf45f5779e5e04c8204db6a0d206af11)  if the hotspot mode is enabled; returns  [WIFI\_HOTSPOT\_NOT\_ACTIVE](wifiservice.md#ga7dd021b8f69312a304632fd1d0244f02)  otherwise. 



## IsWifiActive\(\)<a name="ga57ee7c4c4ee6092098cb35965f507fb9"></a>

```
int IsWifiActive (void )
```

 **Description:**

Checks whether the station mode is enabled. 

**Returns:**

Returns  [WIFI\_STA\_ACTIVE](wifiservice.md#ga9f956732e8e8da52eb25a84a7c42e2bb)  if the station mode is enabled; returns  [WIFI\_STA\_NOT\_ACTIVE](wifiservice.md#gaf26289b0fe6ef5ae86395c0556187cf8)  otherwise. 



## RegisterWifiEvent\(\)<a name="ga0e4d452915d1588664b91837b821eada"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) RegisterWifiEvent ([WifiEvent](wifievent.md) * event)
```

 **Description:**

Registers a callback for a specified Wi-Fi event. 

The registered callback will be invoked when the Wi-Fi event defined in  [WifiEvent](wifievent.md)  occurs. 

**Parameters:**

<a name="table491699015090251"></a>
<table><thead align="left"><tr id="row36293583090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p194463471090251"><a name="p194463471090251"></a><a name="p194463471090251"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1407864832090251"><a name="p1407864832090251"></a><a name="p1407864832090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1888229209090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">event</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the event for which the callback is to be registered. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if the callback is registered successfully; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



## RemoveDevice\(\)<a name="ga13d79f9dc92bf445b7ef2b98ab050c3a"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) RemoveDevice (int networkId)
```

 **Description:**

Removes a hotspot configuration matching a specified  **networkId**. 

**Parameters:**

<a name="table456512265090251"></a>
<table><thead align="left"><tr id="row1440146978090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1358923565090251"><a name="p1358923565090251"></a><a name="p1358923565090251"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p357996025090251"><a name="p357996025090251"></a><a name="p357996025090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1938988661090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">networkId</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the <strong id="b1739985350090251"><a name="b1739985350090251"></a><a name="b1739985350090251"></a>networkId</strong> matching the hotspot configuration to remove. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if the hotspot configuration is removed; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



## Scan\(\)<a name="ga72d138ede38fbd6425f1fe7fbc35c262"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) Scan (void )
```

 **Description:**

Starts a Wi-Fi scan. 

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if the Wi-Fi scan is started; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



## SetBand\(\)<a name="gaf384863106ea0ba10efc4a0bd3c86d24"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) SetBand (int band)
```

 **Description:**

Sets the frequency band for this hotspot. 

**Parameters:**

<a name="table96277641090251"></a>
<table><thead align="left"><tr id="row1158794656090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1252469899090251"><a name="p1252469899090251"></a><a name="p1252469899090251"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1263275423090251"><a name="p1263275423090251"></a><a name="p1263275423090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1317685755090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">band</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the frequency band to set. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if the frequency band is set; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



## SetHotspotConfig\(\)<a name="gafebbb0442cc9334441ff0edc979753ca"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) SetHotspotConfig (const [HotspotConfig](hotspotconfig.md) * config)
```

 **Description:**

Sets a specified hotspot configuration. 

The hotspot configuration includes the SSID, security type, and key. The configuration set overwrites the existing configuration and takes effect after the hotspot mode is re-enabled. Before enabling the hotspot mode for the first time, you must call this function. 

**Parameters:**

<a name="table705792922090251"></a>
<table><thead align="left"><tr id="row1983323672090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p578552773090251"><a name="p578552773090251"></a><a name="p578552773090251"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1122327017090251"><a name="p1122327017090251"></a><a name="p1122327017090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row103080777090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">config</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the hotspot configuration to set. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if the hotspot configuration is set; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



## UnRegisterWifiEvent\(\)<a name="gaee648c923f6594e222d0c592b929b3f1"></a>

```
[WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568) UnRegisterWifiEvent (const [WifiEvent](wifievent.md) * event)
```

 **Description:**

Unregisters a callback previously registered for a specified Wi-Fi event. 

**Parameters:**

<a name="table587963323090251"></a>
<table><thead align="left"><tr id="row1257527052090251"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1501293748090251"><a name="p1501293748090251"></a><a name="p1501293748090251"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1353987217090251"><a name="p1353987217090251"></a><a name="p1353987217090251"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row490324030090251"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">event</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the event for which the callback is to be unregistered. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_SUCCESS](wifiservice.md#gga2506c6ad226c4feb1d19248013ff9568ad1c692e09196ec357d0150f1853a758e)  if the callback is unregistered successfully; returns an error code defined in  [WifiErrorCode](wifiservice.md#ga2506c6ad226c4feb1d19248013ff9568)  otherwise. 



