# Wifiiot<a name="EN-US_TOPIC_0000001054876466"></a>

## **Overview**<a name="section1433755558090252"></a>

Provides dedicated device operation interfaces on the Wi-Fi module, including ADC, AT, flash, GPIO, I2C, I2S, partition, PWM, SDIO, UART, and watchdog. 

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section1558133865090252"></a>

## Files<a name="files"></a>

<a name="table786299456090252"></a>
<table><thead align="left"><tr id="row1426289313090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1226324903090252"><a name="p1226324903090252"></a><a name="p1226324903090252"></a>File Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1916798223090252"><a name="p1916798223090252"></a><a name="p1916798223090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1930628039090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p369076160090252"><a name="p369076160090252"></a><a name="p369076160090252"></a><a href="wifiiot_adc-h.md">wifiiot_adc.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1702357033090252"><a name="p1702357033090252"></a><a name="p1702357033090252"></a>Declares the ADC interface functions for you to read data. </p>
</td>
</tr>
<tr id="row1028746862090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p518349086090252"><a name="p518349086090252"></a><a name="p518349086090252"></a><a href="wifiiot_at-h.md">wifiiot_at.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1848359159090252"><a name="p1848359159090252"></a><a name="p1848359159090252"></a>Declares the AT interface functions. </p>
</td>
</tr>
<tr id="row2041417957090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p264016082090252"><a name="p264016082090252"></a><a name="p264016082090252"></a><a href="wifiiot_errno-h.md">wifiiot_errno.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p516283133090252"><a name="p516283133090252"></a><a name="p516283133090252"></a>Defines error codes used by the Wi-Fi module. </p>
</td>
</tr>
<tr id="row2001135643090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p366392345090252"><a name="p366392345090252"></a><a name="p366392345090252"></a><a href="wifiiot_flash-h.md">wifiiot_flash.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1507560392090252"><a name="p1507560392090252"></a><a name="p1507560392090252"></a>Declares the flash interface functions. </p>
</td>
</tr>
<tr id="row677711791090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p940135539090252"><a name="p940135539090252"></a><a name="p940135539090252"></a><a href="wifiiot_flash_ex-h.md">wifiiot_flash_ex.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1205575903090252"><a name="p1205575903090252"></a><a name="p1205575903090252"></a>Declares the extended flash interface functions for obtaining flash information. </p>
</td>
</tr>
<tr id="row71182580090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p903343494090252"><a name="p903343494090252"></a><a name="p903343494090252"></a><a href="wifiiot_gpio-h.md">wifiiot_gpio.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p402858170090252"><a name="p402858170090252"></a><a name="p402858170090252"></a>Declares the GPIO interface functions. </p>
</td>
</tr>
<tr id="row173873155090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p189633920090252"><a name="p189633920090252"></a><a name="p189633920090252"></a><a href="wifiiot_gpio_ex-h.md">wifiiot_gpio_ex.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1372719144090252"><a name="p1372719144090252"></a><a name="p1372719144090252"></a>Declares the extended GPIO interface functions. </p>
</td>
</tr>
<tr id="row1331082053090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p454179762090252"><a name="p454179762090252"></a><a name="p454179762090252"></a><a href="wifiiot_i2c-h.md">wifiiot_i2c.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1953581150090252"><a name="p1953581150090252"></a><a name="p1953581150090252"></a>Declares the I2C interface functions. </p>
</td>
</tr>
<tr id="row1021869496090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p491974154090252"><a name="p491974154090252"></a><a name="p491974154090252"></a><a href="wifiiot_i2c_ex-h.md">wifiiot_i2c_ex.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1074538124090252"><a name="p1074538124090252"></a><a name="p1074538124090252"></a>Declares the extended I2C interface functions. </p>
</td>
</tr>
<tr id="row1781605578090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p620280661090252"><a name="p620280661090252"></a><a name="p620280661090252"></a><a href="wifiiot_i2s-h.md">wifiiot_i2s.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p452537411090252"><a name="p452537411090252"></a><a name="p452537411090252"></a>Declares the I2S interface functions. </p>
</td>
</tr>
<tr id="row1514389635090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p571036132090252"><a name="p571036132090252"></a><a name="p571036132090252"></a><a href="wifiiot_kal-h.md">wifiiot_kal.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1633933373090252"><a name="p1633933373090252"></a><a name="p1633933373090252"></a>Declares the KAL interface functions. </p>
</td>
</tr>
<tr id="row972124496090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p649457713090252"><a name="p649457713090252"></a><a name="p649457713090252"></a><a href="wifiiot_partition-h.md">wifiiot_partition.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p387673476090252"><a name="p387673476090252"></a><a name="p387673476090252"></a>Declares the partition interface functions. </p>
</td>
</tr>
<tr id="row1766817805090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p174941012090252"><a name="p174941012090252"></a><a name="p174941012090252"></a><a href="wifiiot_pwm-h.md">wifiiot_pwm.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2046421839090252"><a name="p2046421839090252"></a><a name="p2046421839090252"></a>Declares the PWM interface functions. </p>
</td>
</tr>
<tr id="row958791164090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1834728668090252"><a name="p1834728668090252"></a><a name="p1834728668090252"></a><a href="wifiiot_sdio-h.md">wifiiot_sdio.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p501098884090252"><a name="p501098884090252"></a><a name="p501098884090252"></a>Declares the SDIO interface functions. </p>
</td>
</tr>
<tr id="row1842988237090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p850020914090252"><a name="p850020914090252"></a><a name="p850020914090252"></a><a href="wifiiot_spi-h.md">wifiiot_spi.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p938386279090252"><a name="p938386279090252"></a><a name="p938386279090252"></a>Declares the SPI interface functions. </p>
</td>
</tr>
<tr id="row1994716465090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1327411781090252"><a name="p1327411781090252"></a><a name="p1327411781090252"></a><a href="wifiiot_uart-h.md">wifiiot_uart.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1510538902090252"><a name="p1510538902090252"></a><a name="p1510538902090252"></a>Declares the UART interface functions. </p>
</td>
</tr>
<tr id="row1783947784090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1623116539090252"><a name="p1623116539090252"></a><a name="p1623116539090252"></a><a href="wifiiot_uart_ex-h.md">wifiiot_uart_ex.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1804542501090252"><a name="p1804542501090252"></a><a name="p1804542501090252"></a>Declares the extended UART interface functions. </p>
</td>
</tr>
<tr id="row1770461760090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p11736252090252"><a name="p11736252090252"></a><a name="p11736252090252"></a><a href="wifiiot_watchdog-h.md">wifiiot_watchdog.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1502499453090252"><a name="p1502499453090252"></a><a name="p1502499453090252"></a>Declares the watchdog interface functions. </p>
</td>
</tr>
</tbody>
</table>

## Data Structures<a name="nested-classes"></a>

<a name="table1531231703090252"></a>
<table><thead align="left"><tr id="row413736680090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1133551014090252"><a name="p1133551014090252"></a><a name="p1133551014090252"></a>Data Structure Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1712832522090252"><a name="p1712832522090252"></a><a name="p1712832522090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row20523068090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p284490616090252"><a name="p284490616090252"></a><a name="p284490616090252"></a><a href="atcmdtbl.md">AtCmdTbl</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1365683993090252"><a name="p1365683993090252"></a><a name="p1365683993090252"></a>Defines the AT command registration structure. </p>
</td>
</tr>
<tr id="row484338302090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1802853616090252"><a name="p1802853616090252"></a><a name="p1802853616090252"></a><a href="wifiioti2cdata.md">WifiIotI2cData</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2019854244090252"><a name="p2019854244090252"></a><a name="p2019854244090252"></a>Defines I2C data transmission attributes. </p>
</td>
</tr>
<tr id="row132532804090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1554405551090252"><a name="p1554405551090252"></a><a name="p1554405551090252"></a><a href="wifiioti2cfunc.md">WifiIotI2cFunc</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p719244524090252"><a name="p719244524090252"></a><a name="p719244524090252"></a>Defines I2C callbacks. </p>
</td>
</tr>
<tr id="row301580162090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p354980578090252"><a name="p354980578090252"></a><a name="p354980578090252"></a><a href="wifiioti2sattribute.md">WifiIotI2sAttribute</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1323076245090252"><a name="p1323076245090252"></a><a name="p1323076245090252"></a>Defines I2S attributes. </p>
</td>
</tr>
<tr id="row1596146023090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2140783804090252"><a name="p2140783804090252"></a><a name="p2140783804090252"></a><a href="wifiiotflashpartitioninfo.md">WifiIotFlashPartitionInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p446629211090252"><a name="p446629211090252"></a><a name="p446629211090252"></a>Describes an entry in a flash partition table. </p>
</td>
</tr>
<tr id="row892683848090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1753939586090252"><a name="p1753939586090252"></a><a name="p1753939586090252"></a><a href="wifiiotflashpartitiontable.md">WifiIotFlashPartitionTable</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p922862900090252"><a name="p922862900090252"></a><a name="p922862900090252"></a>Describes a flash partition table. </p>
</td>
</tr>
<tr id="row1757255300090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1531243660090252"><a name="p1531243660090252"></a><a name="p1531243660090252"></a><a href="wifiiotsdioextendfunc.md">WifiIotSdioExtendFunc</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1241593859090252"><a name="p1241593859090252"></a><a name="p1241593859090252"></a>Provides extended SDIO attributes. </p>
</td>
</tr>
<tr id="row593574073090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p980573138090252"><a name="p980573138090252"></a><a name="p980573138090252"></a><a href="wifiiotsdioadmatable.md">WifiIotSdioAdmatable</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1841132054090252"><a name="p1841132054090252"></a><a name="p1841132054090252"></a>Defines attributes of an SDIO ADMA table. </p>
</td>
</tr>
<tr id="row903500937090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1051239315090252"><a name="p1051239315090252"></a><a name="p1051239315090252"></a><a href="wifiiotsdiointcallback.md">WifiIotSdioIntcallback</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p370758758090252"><a name="p370758758090252"></a><a name="p370758758090252"></a>SDIO interrupt callback structure. </p>
</td>
</tr>
<tr id="row974167967090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1036536296090252"><a name="p1036536296090252"></a><a name="p1036536296090252"></a><a href="wifiiotspicfgbasicinfo.md">WifiIotSpiCfgBasicInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1359395353090252"><a name="p1359395353090252"></a><a name="p1359395353090252"></a>Defines data communication parameters. </p>
</td>
</tr>
<tr id="row2066004165090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1077836277090252"><a name="p1077836277090252"></a><a name="p1077836277090252"></a><a href="wifiiotspicfginitparam.md">WifiIotSpiCfgInitParam</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1634282499090252"><a name="p1634282499090252"></a><a name="p1634282499090252"></a>Specifies whether a device is a master or slave device. </p>
</td>
</tr>
<tr id="row1555339159090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2122786182090252"><a name="p2122786182090252"></a><a name="p2122786182090252"></a><a href="wifiiotuartattribute.md">WifiIotUartAttribute</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1152350739090252"><a name="p1152350739090252"></a><a name="p1152350739090252"></a>Defines the basic attributes of a UART device. </p>
</td>
</tr>
<tr id="row1032203743090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p524276733090252"><a name="p524276733090252"></a><a name="p524276733090252"></a><a href="wifiiotuartextraattr.md">WifiIotUartExtraAttr</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p488428269090252"><a name="p488428269090252"></a><a name="p488428269090252"></a>Defines the extended attributes of a UART device. </p>
</td>
</tr>
</tbody>
</table>

## Macros<a name="define-members"></a>

<a name="table1633001373090252"></a>
<table><thead align="left"><tr id="row727477789090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p484311657090252"><a name="p484311657090252"></a><a name="p484311657090252"></a>Macro Name and Value</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1424345838090252"><a name="p1424345838090252"></a><a name="p1424345838090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1439568681090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p895624634090252"><a name="p895624634090252"></a><a name="p895624634090252"></a><a href="wifiiot.md#gae70eaf627c0370cc271dcb8060aee861">WIFI_IOT_SUCCESS</a>   0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p880908722090252"><a name="p880908722090252"></a><a name="p880908722090252"></a>Defines a module-level return value to indicate a successful operation. </p>
</td>
</tr>
<tr id="row384842873090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1144105887090252"><a name="p1144105887090252"></a><a name="p1144105887090252"></a><a href="wifiiot.md#gae2bfd5a14f6126c51fa6206a7f1008be">WIFI_IOT_FAILURE</a>   (-1)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1881575149090252"><a name="p1881575149090252"></a><a name="p1881575149090252"></a>Defines a module-level return value to indicate an operation failure. </p>
</td>
</tr>
<tr id="row2107925353090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1527249480090252"><a name="p1527249480090252"></a><a name="p1527249480090252"></a><a href="wifiiot.md#gaf5cf7e2b308037a65be66bb755dc5880">WIFI_IOT_ERR_UART_INVALID_PARAMETER</a>   0x80001000</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p952753297090252"><a name="p952753297090252"></a><a name="p952753297090252"></a>Defines a UART error code to indicate an invalid parameter. </p>
</td>
</tr>
<tr id="row1689387620090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1610873228090252"><a name="p1610873228090252"></a><a name="p1610873228090252"></a><a href="wifiiot.md#ga5877267c67a4620a43d714d3d853d2e3">WIFI_IOT_ERR_UART_INVALID_SUSPEND</a>   0x80001001</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p346198320090252"><a name="p346198320090252"></a><a name="p346198320090252"></a>Defines a UART error code to indicate an invalid pause operation. </p>
</td>
</tr>
<tr id="row884387723090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1377137788090252"><a name="p1377137788090252"></a><a name="p1377137788090252"></a><a href="wifiiot.md#ga2ba1db97d77cf3d74466a7951861538a">WIFI_IOT_ERR_UART_INVALID_PARITY</a>   0x80001002</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p992376825090252"><a name="p992376825090252"></a><a name="p992376825090252"></a>Defines a UART error code to indicate an invalid parity check. </p>
</td>
</tr>
<tr id="row1866179384090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p772169476090252"><a name="p772169476090252"></a><a name="p772169476090252"></a><a href="wifiiot.md#ga20dfd6fedd138cdd065e70e267c90340">WIFI_IOT_ERR_UART_INVALID_DATA_BITS</a>   0x80001003</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p383957104090252"><a name="p383957104090252"></a><a name="p383957104090252"></a>Defines a UART error code to indicate an invalid data bit. </p>
</td>
</tr>
<tr id="row1063278908090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1148589178090252"><a name="p1148589178090252"></a><a name="p1148589178090252"></a><a href="wifiiot.md#ga936de56f79c06da2e782b00b66e47e8c">WIFI_IOT_ERR_UART_INVALID_STOP_BITS</a>   0x80001004</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1201536508090252"><a name="p1201536508090252"></a><a name="p1201536508090252"></a>Defines a UART error code to indicate an invalid stop bit. </p>
</td>
</tr>
<tr id="row1307846780090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1544083184090252"><a name="p1544083184090252"></a><a name="p1544083184090252"></a><a href="wifiiot.md#gacb947326cf340c964edb6ccdbb5273f1">WIFI_IOT_ERR_UART_INVALID_BAUD</a>   0x80001005</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p460458209090252"><a name="p460458209090252"></a><a name="p460458209090252"></a>Defines a UART error code to indicate an invalid baud rate. </p>
</td>
</tr>
<tr id="row46947480090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1368335801090252"><a name="p1368335801090252"></a><a name="p1368335801090252"></a><a href="wifiiot.md#ga4c677c899cabd847fe4627400e27f4b0">WIFI_IOT_ERR_UART_INVALID_COM_PORT</a>   0x80001006</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p862703891090252"><a name="p862703891090252"></a><a name="p862703891090252"></a>Defines a UART error code to indicate an invalid port number. </p>
</td>
</tr>
<tr id="row1029892442090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1742163305090252"><a name="p1742163305090252"></a><a name="p1742163305090252"></a><a href="wifiiot.md#ga08fefa68d06c7559dc59e69a4a5ff58d">WIFI_IOT_ERR_UART_NOT_SUPPORT_DMA</a>   0x80001007</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1826771903090252"><a name="p1826771903090252"></a><a name="p1826771903090252"></a>Defines a UART error code to indicate a non-support for DMA. </p>
</td>
</tr>
<tr id="row1398574963090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1149257863090252"><a name="p1149257863090252"></a><a name="p1149257863090252"></a><a href="wifiiot.md#ga2261c686d955fb1caca8a2b123330341">WIFI_IOT_ERR_UART_NOT_BLOCK_MODE</a>   0x80001008</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1629779149090252"><a name="p1629779149090252"></a><a name="p1629779149090252"></a>Defines a UART error code to indicate the non-block mode. </p>
</td>
</tr>
<tr id="row503266202090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2136851008090252"><a name="p2136851008090252"></a><a name="p2136851008090252"></a><a href="wifiiot.md#gae1dde2925aab87cc79a5cf3b55f69d7b">WIFI_IOT_ERR_GPIO_INVALID_PARAMETER</a>   0x80001040</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p308401509090252"><a name="p308401509090252"></a><a name="p308401509090252"></a>Defines a GPIO error code to indicate an invalid parameter. </p>
</td>
</tr>
<tr id="row1570424809090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1027662879090252"><a name="p1027662879090252"></a><a name="p1027662879090252"></a><a href="wifiiot.md#ga86c5c689c1ba112ef2875bf01418281f">WIFI_IOT_ERR_GPIO_REPEAT_INIT</a>   0x80001041</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p898951233090252"><a name="p898951233090252"></a><a name="p898951233090252"></a>Defines a GPIO error code to indicate repeated initialization. </p>
</td>
</tr>
<tr id="row1090113784090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p785805178090252"><a name="p785805178090252"></a><a name="p785805178090252"></a><a href="wifiiot.md#ga4607e3646ccfe40732d4c068c071f53a">WIFI_IOT_ERR_GPIO_NOT_INIT</a>   0x80001042</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1263899876090252"><a name="p1263899876090252"></a><a name="p1263899876090252"></a>Defines a GPIO error code to indicate non-initialization. </p>
</td>
</tr>
<tr id="row304416040090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p366223642090252"><a name="p366223642090252"></a><a name="p366223642090252"></a><a href="wifiiot.md#ga0080f4d4a86cbce7e86d319386fd9cd2">WIFI_IOT_ERR_GPIO_NOT_SUPPORT</a>   0x80001043</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1762894056090252"><a name="p1762894056090252"></a><a name="p1762894056090252"></a>Defines a GPIO error code to indicate a non-support. </p>
</td>
</tr>
<tr id="row326496707090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p726244204090252"><a name="p726244204090252"></a><a name="p726244204090252"></a><a href="wifiiot.md#gaebd30986c46f1c6a01931f04776531a0">WIFI_IOT_ERR_FLASH_NOT_INIT</a>   0x800010C0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p46331359090252"><a name="p46331359090252"></a><a name="p46331359090252"></a>Defines a flash error code to indicate non-initialization. </p>
</td>
</tr>
<tr id="row1574608299090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2067022531090252"><a name="p2067022531090252"></a><a name="p2067022531090252"></a><a href="wifiiot.md#ga2cd1281dc392b88851c7da895d121696">WIFI_IOT_ERR_FLASH_INVALID_PARAM</a>   0x800010C1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1593472738090252"><a name="p1593472738090252"></a><a name="p1593472738090252"></a>Defines a flash error code to indicate an invalid parameter. </p>
</td>
</tr>
<tr id="row999754997090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p922283633090252"><a name="p922283633090252"></a><a name="p922283633090252"></a><a href="wifiiot.md#ga0b58bc9856c6879faf0c6a65510fe341">WIFI_IOT_ERR_FLASH_INVALID_PARAM_BEYOND_ADDR</a>   0x800010C2</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p81419636090252"><a name="p81419636090252"></a><a name="p81419636090252"></a>Defines a flash error code to indicate that the address is out of range. </p>
</td>
</tr>
<tr id="row1994171677090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p842821442090252"><a name="p842821442090252"></a><a name="p842821442090252"></a><a href="wifiiot.md#gaefb0daa74035564d57262ae477bc7fa2">WIFI_IOT_ERR_FLASH_INVALID_PARAM_SIZE_ZERO</a>   0x800010C3</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p626855226090252"><a name="p626855226090252"></a><a name="p626855226090252"></a>Defines a flash error code to indicate that the parameter size is <strong id="b1544006707090252"><a name="b1544006707090252"></a><a name="b1544006707090252"></a>0</strong> </p>
</td>
</tr>
<tr id="row2033144571090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p508984919090252"><a name="p508984919090252"></a><a name="p508984919090252"></a><a href="wifiiot.md#gaadfebe4ca2dfbfbd5e6121216bb2b4cf">WIFI_IOT_ERR_FLASH_INVALID_PARAM_ERASE_NOT_ALIGN</a>   0x800010C4</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p631580298090252"><a name="p631580298090252"></a><a name="p631580298090252"></a>Defines a flash error code to indicate that the erase size is not aligned. </p>
</td>
</tr>
<tr id="row152472063090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1544144241090252"><a name="p1544144241090252"></a><a name="p1544144241090252"></a><a href="wifiiot.md#gae9ae811688863c24f7be8c89583ef5cb">WIFI_IOT_ERR_FLASH_INVALID_PARAM_IOCTRL_DATA_NULL</a>   0x800010C5</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p993808953090252"><a name="p993808953090252"></a><a name="p993808953090252"></a>Defines a flash error code to indicate that the data of the I/O controller is empty. </p>
</td>
</tr>
<tr id="row1179122755090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p302376349090252"><a name="p302376349090252"></a><a name="p302376349090252"></a><a href="wifiiot.md#ga41abe9a86b37f2c88714111895c5a7fd">WIFI_IOT_ERR_FLASH_INVALID_PARAM_DATA_NULL</a>   0x800010C6</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2083513279090252"><a name="p2083513279090252"></a><a name="p2083513279090252"></a>Defines a flash error code to indicate empty data. </p>
</td>
</tr>
<tr id="row1244342944090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p549600442090252"><a name="p549600442090252"></a><a name="p549600442090252"></a><a href="wifiiot.md#ga9f31319390fdaa4051abaa5cf9c1e6bd">WIFI_IOT_ERR_FLASH_INVALID_PARAM_PAD1</a>   0x800010C7</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p270370162090252"><a name="p270370162090252"></a><a name="p270370162090252"></a>Defines a flash error code to indicate that pad1 is incorrect. </p>
</td>
</tr>
<tr id="row814543143090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p836770483090252"><a name="p836770483090252"></a><a name="p836770483090252"></a><a href="wifiiot.md#ga3aeceb16cc526bc3977e363533c4caf2">WIFI_IOT_ERR_FLASH_INVALID_PARAM_PAD2</a>   0x800010C8</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1668910632090252"><a name="p1668910632090252"></a><a name="p1668910632090252"></a>Defines a flash error code to indicate that pad2 is incorrect. </p>
</td>
</tr>
<tr id="row1405210197090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1620123917090252"><a name="p1620123917090252"></a><a name="p1620123917090252"></a><a href="wifiiot.md#gacb66dcc29fa65a9fa64a43a20acc3e6d">WIFI_IOT_ERR_FLASH_INVALID_PARAM_PAD3</a>   0x800010C9</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1344702191090252"><a name="p1344702191090252"></a><a name="p1344702191090252"></a>Defines a flash error code to indicate that pad3 is incorrect. </p>
</td>
</tr>
<tr id="row1515671567090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1883396400090252"><a name="p1883396400090252"></a><a name="p1883396400090252"></a><a href="wifiiot.md#ga3d5fe958b7383f49040abc6f1f1c9976">WIFI_IOT_ERR_FLASH_INVALID_PARAM_PAD4</a>   0x800010CA</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p958560166090252"><a name="p958560166090252"></a><a name="p958560166090252"></a>Defines a flash error code to indicate that pad4 is incorrect. </p>
</td>
</tr>
<tr id="row1223584011090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1703681438090252"><a name="p1703681438090252"></a><a name="p1703681438090252"></a><a href="wifiiot.md#gaf067c19a95c6c8c38a46956ec0aea959">WIFI_IOT_ERR_FLASH_TIME_OUT_WAIT_READY</a>   0x800010CB</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p538346986090252"><a name="p538346986090252"></a><a name="p538346986090252"></a>Defines a flash error code to indicate a timeout on waiting for ready. </p>
</td>
</tr>
<tr id="row1127347755090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2058669096090252"><a name="p2058669096090252"></a><a name="p2058669096090252"></a><a href="wifiiot.md#gad25105354cedaa65cadfd01e011d58aa">WIFI_IOT_ERR_FLASH_QUAD_MODE_READ_REG1</a>   0x800010CC</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2035403789090252"><a name="p2035403789090252"></a><a name="p2035403789090252"></a>Defines a flash error code to indicate that an error occurs when reading register 1. </p>
</td>
</tr>
<tr id="row1499436492090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p460729597090252"><a name="p460729597090252"></a><a name="p460729597090252"></a><a href="wifiiot.md#gaf86f02647b83f2b4ad942748de6c3877">WIFI_IOT_ERR_FLASH_QUAD_MODE_READ_REG2</a>   0x800010CD</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1266612550090252"><a name="p1266612550090252"></a><a name="p1266612550090252"></a>Defines a flash error code to indicate that an error occurs when reading register 2. </p>
</td>
</tr>
<tr id="row1594777167090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p106394929090252"><a name="p106394929090252"></a><a name="p106394929090252"></a><a href="wifiiot.md#ga436294992f32cc090be1f296ef7edb1a">WIFI_IOT_ERR_FLASH_QUAD_MODE_COMPARE_REG</a>   0x800010CE</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p840092756090252"><a name="p840092756090252"></a><a name="p840092756090252"></a>Defines a flash error code to indicate that an error occurs when comparing registers. </p>
</td>
</tr>
<tr id="row1681637806090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2125341472090252"><a name="p2125341472090252"></a><a name="p2125341472090252"></a><a href="wifiiot.md#ga749a534281fe75e79788ac6bbd2ab6ab">WIFI_IOT_ERR_FLASH_NO_MATCH_FLASH</a>   0x800010CF</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1495979519090252"><a name="p1495979519090252"></a><a name="p1495979519090252"></a>Defines a flash error code to indicate a flash mismatch. </p>
</td>
</tr>
<tr id="row1223576586090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1042920545090252"><a name="p1042920545090252"></a><a name="p1042920545090252"></a><a href="wifiiot.md#ga8e7bba169009c4a64d9d5d1c566d2d21">WIFI_IOT_ERR_FLASH_WRITE_ENABLE</a>   0x800010D0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1161075564090252"><a name="p1161075564090252"></a><a name="p1161075564090252"></a>Defines a flash error code to indicate a failure in enabling write. </p>
</td>
</tr>
<tr id="row515600966090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p941964733090252"><a name="p941964733090252"></a><a name="p941964733090252"></a><a href="wifiiot.md#ga0abb8298403aeb5a5362663affc67bf8">WIFI_IOT_ERR_FLASH_NO_MATCH_ERASE_SIZE</a>   0x800010D1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p914614513090252"><a name="p914614513090252"></a><a name="p914614513090252"></a>Defines a flash error code to indicate a mismatch in the size of data to erase. </p>
</td>
</tr>
<tr id="row1777777643090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1544811077090252"><a name="p1544811077090252"></a><a name="p1544811077090252"></a><a href="wifiiot.md#gaca07e3664b7ca260316507fe5bc0ece1">WIFI_IOT_ERR_FLASH_MAX_SPI_OP</a>   0x800010D2</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2066356778090252"><a name="p2066356778090252"></a><a name="p2066356778090252"></a>Defines a flash error code to indicate the maximum value of the SPI operation. </p>
</td>
</tr>
<tr id="row703898311090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p354577454090252"><a name="p354577454090252"></a><a name="p354577454090252"></a><a href="wifiiot.md#gad836fbc11d75d82a80f01c1517742e5a">WIFI_IOT_ERR_FLASH_NOT_SUPPORT_IOCTRL_ID</a>   0x800010D3</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p347991601090252"><a name="p347991601090252"></a><a name="p347991601090252"></a>Defines a flash error code to indicate an unsupported IO controller ID.. </p>
</td>
</tr>
<tr id="row1273156202090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1846786141090252"><a name="p1846786141090252"></a><a name="p1846786141090252"></a><a href="wifiiot.md#gad8b63e06e4ab22df1965868a5b8e9c34">WIFI_IOT_ERR_FLASH_INVALID_CHIP_ID</a>   0x800010D4</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p601341490090252"><a name="p601341490090252"></a><a name="p601341490090252"></a>Defines a flash error code to indicate an invalid chip ID. </p>
</td>
</tr>
<tr id="row888262083090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p718876318090252"><a name="p718876318090252"></a><a name="p718876318090252"></a><a href="wifiiot.md#ga0658f79d7edb143919457775b77cc0ac">WIFI_IOT_ERR_FLASH_RE_INIT</a>   0x800010D5</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p235045007090252"><a name="p235045007090252"></a><a name="p235045007090252"></a>Defines a flash error code to indicate repeated initialization. </p>
</td>
</tr>
<tr id="row1450946625090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p930148683090252"><a name="p930148683090252"></a><a name="p930148683090252"></a><a href="wifiiot.md#ga4b2d2f87ed5fbd5dae380b1faf41b4b8">WIFI_IOT_ERR_FLASH_WRITE_NOT_SUPPORT_ERASE</a>   0x800010D6</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1914965813090252"><a name="p1914965813090252"></a><a name="p1914965813090252"></a>Defines a flash error code to indicate a non-support for data erasure. </p>
</td>
</tr>
<tr id="row316112010090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1660380073090252"><a name="p1660380073090252"></a><a name="p1660380073090252"></a><a href="wifiiot.md#ga93d94962d03d6551b528e1a65760a43c">WIFI_IOT_ERR_FLASH_WRITE_COMPARE_WRONG</a>   0x800010D7</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1224761354090252"><a name="p1224761354090252"></a><a name="p1224761354090252"></a>Defines a flash error code to indicate that an error occurs when comparing the data written. </p>
</td>
</tr>
<tr id="row342076249090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1723098542090252"><a name="p1723098542090252"></a><a name="p1723098542090252"></a><a href="wifiiot.md#gaff332b79601f3f3ed37fe184fe797fba">WIFI_IOT_ERR_FLASH_WAIT_CFG_START_TIME_OUT</a>   0x800010D8</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p702722665090252"><a name="p702722665090252"></a><a name="p702722665090252"></a>Defines a flash error code to indicate a timeout on waiting for a configuration to start. </p>
</td>
</tr>
<tr id="row1958963179090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1698896043090252"><a name="p1698896043090252"></a><a name="p1698896043090252"></a><a href="wifiiot.md#ga5ee3d72623a4d33d3d0373578a3a2361">WIFI_IOT_ERR_FLASH_PATITION_INIT_FAIL</a>   0x800010D9</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2051082785090252"><a name="p2051082785090252"></a><a name="p2051082785090252"></a>Defines a flash error code to indicate a partition initialization failure. </p>
</td>
</tr>
<tr id="row1334970879090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p50347333090252"><a name="p50347333090252"></a><a name="p50347333090252"></a><a href="wifiiot.md#gac104ab385c136cf5eaf40f7dc51f81cd">WIFI_IOT_ERR_FLASH_INITILIZATION</a>   0x800010DA</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p151339683090252"><a name="p151339683090252"></a><a name="p151339683090252"></a>Defines a flash error code to indicate initialization. </p>
</td>
</tr>
<tr id="row770811803090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1541666741090252"><a name="p1541666741090252"></a><a name="p1541666741090252"></a><a href="wifiiot.md#gaa7e9a59dbe5dea2a9bf0c31da1c3cc10">WIFI_IOT_ERR_FLASH_ERASE_NOT_4K_ALIGN</a>   0x800010DB</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1642701261090252"><a name="p1642701261090252"></a><a name="p1642701261090252"></a>Defines a flash error code to indicate that the size of data to erase is not a multiple of 4K bytes. </p>
</td>
</tr>
<tr id="row1654864610090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1009248439090252"><a name="p1009248439090252"></a><a name="p1009248439090252"></a><a href="wifiiot.md#ga608fd06772893b809c7f0f158e85d09d">WIFI_IOT_ERR_FLASH_PROTECT_NOT_SUPPORT</a>   0x800010DC</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p766364020090252"><a name="p766364020090252"></a><a name="p766364020090252"></a>Defines a flash error code to indicate a non-support. </p>
</td>
</tr>
<tr id="row548697061090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2063157895090252"><a name="p2063157895090252"></a><a name="p2063157895090252"></a><a href="wifiiot.md#gaccc1cff2256173d6504b236d36733c6d">WIFI_IOT_ERR_FLASH_PROTECT_NOT_INIT</a>   0x800010DD</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p321412456090252"><a name="p321412456090252"></a><a name="p321412456090252"></a>Defines a flash error code to indicate non-initialization. </p>
</td>
</tr>
<tr id="row2081254369090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1731449744090252"><a name="p1731449744090252"></a><a name="p1731449744090252"></a><a href="wifiiot.md#ga76a2feb8426c43b143cb4f3ba9cfa0e2">WIFI_IOT_ERR_FLASH_PROTECT_RE_INIT</a>   0x800010DE</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p188972988090252"><a name="p188972988090252"></a><a name="p188972988090252"></a>Defines a flash error code to indicate repeated initialization. </p>
</td>
</tr>
<tr id="row48540859090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p311459623090252"><a name="p311459623090252"></a><a name="p311459623090252"></a><a href="wifiiot.md#ga148b4bd927a934584b15362b7a56ed9b">WIFI_IOT_ERR_FLASH_PROTECT_NOT_FIND_CHIP</a>   0x800010DF</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1844463470090252"><a name="p1844463470090252"></a><a name="p1844463470090252"></a>Defines a flash error code to indicate that no chip is found. </p>
</td>
</tr>
<tr id="row2100026792090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1838625266090252"><a name="p1838625266090252"></a><a name="p1838625266090252"></a><a href="wifiiot.md#ga422a081f8d37f63e0fcaeec383d8e478">WIFI_IOT_ERR_FLASH_CRYPTO_INVALID_PARAM</a>   0x800010F0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1568351027090252"><a name="p1568351027090252"></a><a name="p1568351027090252"></a>Defines a flash error code to indicate an invalid parameter. </p>
</td>
</tr>
<tr id="row1110009086090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p863302135090252"><a name="p863302135090252"></a><a name="p863302135090252"></a><a href="wifiiot.md#ga271adaa6c3c576b4c871b0c28722e6c2">WIFI_IOT_ERR_FLASH_CRYPTO_BEYOND_ADDR_SIZE</a>   0x800010F1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p239318977090252"><a name="p239318977090252"></a><a name="p239318977090252"></a>Defines a flash error code to indicate that the address is out of range. </p>
</td>
</tr>
<tr id="row703542578090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p820850605090252"><a name="p820850605090252"></a><a name="p820850605090252"></a><a href="wifiiot.md#ga5b9858094e8f0cd73050f0079f41a18d">WIFI_IOT_ERR_FLASH_CRYPTO_MALLOC_FAIL</a>   0x800001F2</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1751486026090252"><a name="p1751486026090252"></a><a name="p1751486026090252"></a>Defines a flash error code to indicate a failure in applying for memory. </p>
</td>
</tr>
<tr id="row1695980067090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p667276278090252"><a name="p667276278090252"></a><a name="p667276278090252"></a><a href="wifiiot.md#ga20381f13537e23d77a33a43917f8b7bc">WIFI_IOT_ERR_FLASH_CRYPTO_DATA_ENCRYPT_ERR</a>   0x800001F3</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p3017919090252"><a name="p3017919090252"></a><a name="p3017919090252"></a>Defines a flash error code to indicate an encryption error. </p>
</td>
</tr>
<tr id="row2052030617090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p936315553090252"><a name="p936315553090252"></a><a name="p936315553090252"></a><a href="wifiiot.md#ga3727ba9b17d5b3ce5f53c4bb41b03ea6">WIFI_IOT_ERR_FLASH_CRYPTO_DATA_DECRYPT_ERR</a>   0x800001F4</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1601028541090252"><a name="p1601028541090252"></a><a name="p1601028541090252"></a>Defines a flash error code to indicate a decryption error. </p>
</td>
</tr>
<tr id="row1306323106090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1142145469090252"><a name="p1142145469090252"></a><a name="p1142145469090252"></a><a href="wifiiot.md#gaeddc722740b9d1405b6d4338e8f22abe">WIFI_IOT_ERR_FLASH_CRYPTO_KEY_EMPTY_ERR</a>   0x800001F5</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p711210604090252"><a name="p711210604090252"></a><a name="p711210604090252"></a>Defines a flash error code to indicate an empty key value. </p>
</td>
</tr>
<tr id="row1881479505090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p913001302090252"><a name="p913001302090252"></a><a name="p913001302090252"></a><a href="wifiiot.md#ga95cbe0f9ca1f79c65a8eab2338b25dc3">WIFI_IOT_ERR_FLASH_CRYPTO_MEMCPY_FAIL</a>   0x800001F6</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2017786327090252"><a name="p2017786327090252"></a><a name="p2017786327090252"></a>Defines a flash error code to indicate a copy failure. </p>
</td>
</tr>
<tr id="row688434883090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p873458360090252"><a name="p873458360090252"></a><a name="p873458360090252"></a><a href="wifiiot.md#gaff6ccf87c21ba2f1786b0823d492b814">WIFI_IOT_ERR_FLASH_CRYPTO_NOT_SUPPORT</a>   0x800001F7</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p634981015090252"><a name="p634981015090252"></a><a name="p634981015090252"></a>Defines a flash error code to indicate a non-support for encryption. </p>
</td>
</tr>
<tr id="row236428915090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p663661330090252"><a name="p663661330090252"></a><a name="p663661330090252"></a><a href="wifiiot.md#gac6e8d4d70fe1ca039b5e853f261c8fd8">WIFI_IOT_ERR_FLASH_CRYPTO_PREPARE_ERR</a>   0x800001F8</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2010811799090252"><a name="p2010811799090252"></a><a name="p2010811799090252"></a>Defines a flash error code to indicate an incorrect parameter during encryption. </p>
</td>
</tr>
<tr id="row324758514090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p613244619090252"><a name="p613244619090252"></a><a name="p613244619090252"></a><a href="wifiiot.md#ga8d1bfe4560224e99df17820ca283baa5">WIFI_IOT_ERR_FLASH_CRYPTO_KEY_INVALID_ERR</a>   0x800001F9</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2095239249090252"><a name="p2095239249090252"></a><a name="p2095239249090252"></a>Defines a flash error code to indicate an invalid key. </p>
</td>
</tr>
<tr id="row373587625090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p505254478090252"><a name="p505254478090252"></a><a name="p505254478090252"></a><a href="wifiiot.md#ga4ddacb6881da562bd8906a2374a21d15">WIFI_IOT_ERR_FLASH_CRYPTO_KEY_SAVE_ERR</a>   0x800001FA</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2037180542090252"><a name="p2037180542090252"></a><a name="p2037180542090252"></a>Defines a flash error code to indicate a failure in saving the key. </p>
</td>
</tr>
<tr id="row1963236180090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1536344273090252"><a name="p1536344273090252"></a><a name="p1536344273090252"></a><a href="wifiiot.md#gab414fb9ce381560a725fe725511812b1">WIFI_IOT_ERR_FLASH_CRYPTO_KERNEL_ADDR_ERR</a>   0x800001FB</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p347706834090252"><a name="p347706834090252"></a><a name="p347706834090252"></a>Defines a flash error code to indicate an incorrect kernel address.. </p>
</td>
</tr>
<tr id="row1131418125090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p514674417090252"><a name="p514674417090252"></a><a name="p514674417090252"></a><a href="wifiiot.md#ga86974c4b426016d366b978096938101f">WIFI_IOT_ERR_I2C_NOT_INIT</a>   0x80001180</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p525699728090252"><a name="p525699728090252"></a><a name="p525699728090252"></a>Defines an I2C error code to indicate a non-support. </p>
</td>
</tr>
<tr id="row1104904135090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p48388613090252"><a name="p48388613090252"></a><a name="p48388613090252"></a><a href="wifiiot.md#gab663a535e93102e3c3ea1512f63664f8">WIFI_IOT_ERR_I2C_INVALID_PARAMETER</a>   0x80001181</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p505881757090252"><a name="p505881757090252"></a><a name="p505881757090252"></a>Defines an I2C error code to indicate an invalid parameter. </p>
</td>
</tr>
<tr id="row1504238956090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1734562057090252"><a name="p1734562057090252"></a><a name="p1734562057090252"></a><a href="wifiiot.md#ga355774fcb1d6cc687d41e6ac93988e37">WIFI_IOT_ERR_I2C_TIMEOUT_START</a>   0x80001182</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p33703478090252"><a name="p33703478090252"></a><a name="p33703478090252"></a>Defines an I2C error code to indicate a start timeout. </p>
</td>
</tr>
<tr id="row832717057090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p664712833090252"><a name="p664712833090252"></a><a name="p664712833090252"></a><a href="wifiiot.md#ga5504ab71071109a4adcc5ab594636bd0">WIFI_IOT_ERR_I2C_TIMEOUT_WAIT</a>   0x80001183</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2008280122090252"><a name="p2008280122090252"></a><a name="p2008280122090252"></a>Defines an I2C error code to indicate a wait timeout. </p>
</td>
</tr>
<tr id="row1239033071090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p672381635090252"><a name="p672381635090252"></a><a name="p672381635090252"></a><a href="wifiiot.md#ga70fe483466bb0a1908838d09af9e08ee">WIFI_IOT_ERR_I2C_TIMEOUT_STOP</a>   0x80001184</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p544432785090252"><a name="p544432785090252"></a><a name="p544432785090252"></a>Defines an I2C error code to indicate a stop timeout. </p>
</td>
</tr>
<tr id="row111034206090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p297697077090252"><a name="p297697077090252"></a><a name="p297697077090252"></a><a href="wifiiot.md#ga07d88ba023c14c7051330bb505fcf2a2">WIFI_IOT_ERR_I2C_TIMEOUT_RCV_BYTE</a>   0x80001185</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p557616054090252"><a name="p557616054090252"></a><a name="p557616054090252"></a>Defines an I2C error code to indicate a receive timeout. </p>
</td>
</tr>
<tr id="row567616915090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1538725076090252"><a name="p1538725076090252"></a><a name="p1538725076090252"></a><a href="wifiiot.md#gadc61cee9de2201533a19247b2d8e991d">WIFI_IOT_ERR_I2C_TIMEOUT_RCV_BYTE_PROC</a>   0x80001186</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p821874973090252"><a name="p821874973090252"></a><a name="p821874973090252"></a>Defines an I2C error code to indicate a processing timeout. </p>
</td>
</tr>
<tr id="row1798822324090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2059452146090252"><a name="p2059452146090252"></a><a name="p2059452146090252"></a><a href="wifiiot.md#ga0535100d16963cfd5b83da321871c2e3">WIFI_IOT_ERR_I2C_WAIT_SEM_FAIL</a>   0x80001187</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1792292711090252"><a name="p1792292711090252"></a><a name="p1792292711090252"></a>Defines an I2C error code to indicate a waiting failure. </p>
</td>
</tr>
<tr id="row179260058090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1580753422090252"><a name="p1580753422090252"></a><a name="p1580753422090252"></a><a href="wifiiot.md#ga1f827afc8a122131000e3c3a415482cb">WIFI_IOT_ERR_I2C_START_ACK_ERR</a>   0x80001188</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1070725037090252"><a name="p1070725037090252"></a><a name="p1070725037090252"></a>Defines an I2C error code to indicate a responding failure. </p>
</td>
</tr>
<tr id="row862821016090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p267770870090252"><a name="p267770870090252"></a><a name="p267770870090252"></a><a href="wifiiot.md#ga8244270946d616498697e8f3f14ec777">WIFI_IOT_ERR_I2C_WAIT_ACK_ERR</a>   0x80001189</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1260334931090252"><a name="p1260334931090252"></a><a name="p1260334931090252"></a>Defines an I2C error code to indicate a failure in waiting for a response. </p>
</td>
</tr>
<tr id="row246515077090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p60924262090252"><a name="p60924262090252"></a><a name="p60924262090252"></a><a href="wifiiot.md#gad4e8ba59aa79284855f8097e2a10f2df">WIFI_IOT_ERR_SPI_NOT_INIT</a>   0x800011C0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1913219635090252"><a name="p1913219635090252"></a><a name="p1913219635090252"></a>Defines an SPI error code to indicate non-initialization. </p>
</td>
</tr>
<tr id="row980005966090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1700640408090252"><a name="p1700640408090252"></a><a name="p1700640408090252"></a><a href="wifiiot.md#ga503c84a7a64db295583a4c32c799002f">WIFI_IOT_ERR_SPI_REINIT</a>   0x800011C1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1813091057090252"><a name="p1813091057090252"></a><a name="p1813091057090252"></a>Defines an SPI error code to indicate repeated initialization. </p>
</td>
</tr>
<tr id="row593165008090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1358308523090252"><a name="p1358308523090252"></a><a name="p1358308523090252"></a><a href="wifiiot.md#gafacaaace84501679b61488c53d5e76c3">WIFI_IOT_ERR_SPI_PARAMETER_WRONG</a>   0x800011C2</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p355061965090252"><a name="p355061965090252"></a><a name="p355061965090252"></a>Defines an SPI error code to indicate a parameter error. </p>
</td>
</tr>
<tr id="row512377421090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1419277131090252"><a name="p1419277131090252"></a><a name="p1419277131090252"></a><a href="wifiiot.md#gaa419999b00bbb93a9bf7ec6e5729d3c3">WIFI_IOT_ERR_SPI_BUSY</a>   0x800011C3</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p654296449090252"><a name="p654296449090252"></a><a name="p654296449090252"></a>Defines an SPI error code to indicate the busy state. </p>
</td>
</tr>
<tr id="row1002226276090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2034793263090252"><a name="p2034793263090252"></a><a name="p2034793263090252"></a><a href="wifiiot.md#ga9063703b367dc0e392759c6e9f2f84ec">WIFI_IOT_ERR_SPI_WRITE_TIMEOUT</a>   0x800011C4</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p15342054090252"><a name="p15342054090252"></a><a name="p15342054090252"></a>Defines an SPI error code to indicate a write timeout. </p>
</td>
</tr>
<tr id="row622227931090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1343150844090252"><a name="p1343150844090252"></a><a name="p1343150844090252"></a><a href="wifiiot.md#ga10a6043e83efd5639859fce4dc3ffa6c">WIFI_IOT_ERR_SPI_READ_TIMEOUT</a>   0x800011C5</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1904434501090252"><a name="p1904434501090252"></a><a name="p1904434501090252"></a>Defines an SPI error code to indicate a read timeout. </p>
</td>
</tr>
<tr id="row202052008090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p745931272090252"><a name="p745931272090252"></a><a name="p745931272090252"></a><a href="wifiiot.md#gade8e979043f1d0641ac08adb73197730">WIFI_IOT_ERR_SPI_NOT_SUPPORT_DMA</a>   0x800011C6</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p307331471090252"><a name="p307331471090252"></a><a name="p307331471090252"></a>Defines an SPI error code to indicate a non-support for DMA. </p>
</td>
</tr>
<tr id="row1592163077090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p393250891090252"><a name="p393250891090252"></a><a name="p393250891090252"></a><a href="wifiiot.md#gac059172aa16736913b47cd9fff537afc">WIFI_IOT_ERR_SDIO_INVALID_PARAMETER</a>   0x80001280</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1651597947090252"><a name="p1651597947090252"></a><a name="p1651597947090252"></a>Defines an SDIO error code to indicate an invalid parameter. </p>
</td>
</tr>
<tr id="row794344156090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1553527608090252"><a name="p1553527608090252"></a><a name="p1553527608090252"></a><a href="wifiiot.md#ga26eb2003b98a03a78822e072ea9d6f1a">WIFI_IOT_ERR_ADC_PARAMETER_WRONG</a>   0x80001300</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p302970961090252"><a name="p302970961090252"></a><a name="p302970961090252"></a>Defines an ADC error code to indicate a parameter error. </p>
</td>
</tr>
<tr id="row303528159090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2030112428090252"><a name="p2030112428090252"></a><a name="p2030112428090252"></a><a href="wifiiot.md#ga51d02496da9b876fb3953fde207ab83e">WIFI_IOT_ERR_ADC_INVALID_CHANNEL_ID</a>   0x80001301</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p325878080090252"><a name="p325878080090252"></a><a name="p325878080090252"></a>Defines an ADC error code to indicate an invalid channel. </p>
</td>
</tr>
<tr id="row71611820090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p612679697090252"><a name="p612679697090252"></a><a name="p612679697090252"></a><a href="wifiiot.md#gad43d862b02b1e8d7e11562bb8192e18d">WIFI_IOT_ERR_ADC_TIMEOUT</a>   0x80001302</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1104653140090252"><a name="p1104653140090252"></a><a name="p1104653140090252"></a>Defines an ADC error code to indicate a timeout. </p>
</td>
</tr>
<tr id="row694311113090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p591266143090252"><a name="p591266143090252"></a><a name="p591266143090252"></a><a href="wifiiot.md#gad299ef5c0943421884e6941827679935">WIFI_IOT_ERR_ADC_NOT_INIT</a>   0x80001303</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1569895020090252"><a name="p1569895020090252"></a><a name="p1569895020090252"></a>Defines an ADC error code to indicate non-initialization. </p>
</td>
</tr>
<tr id="row566548970090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1466446136090252"><a name="p1466446136090252"></a><a name="p1466446136090252"></a><a href="wifiiot.md#ga59e7a7be362105ba9f68558a305df640">WIFI_IOT_ERR_PWM_NO_INIT</a>   0x80001340</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1844574928090252"><a name="p1844574928090252"></a><a name="p1844574928090252"></a>Defines a PWM error code to indicate non-initialization. </p>
</td>
</tr>
<tr id="row804970760090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p113056918090252"><a name="p113056918090252"></a><a name="p113056918090252"></a><a href="wifiiot.md#gacfc74f2eb47edfc1c5fc6f0a8eb06853">WIFI_IOT_ERR_PWM_INITILIZATION_ALREADY</a>   0x80001341</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1074238676090252"><a name="p1074238676090252"></a><a name="p1074238676090252"></a>Defines a PWM error code to indicate an initialization error. </p>
</td>
</tr>
<tr id="row2096649210090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p940652776090252"><a name="p940652776090252"></a><a name="p940652776090252"></a><a href="wifiiot.md#ga63e9f9737a00e8fc7147ba18d21682a5">WIFI_IOT_ERR_PWM_INVALID_PARAMETER</a>   0x80001342</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p220128581090252"><a name="p220128581090252"></a><a name="p220128581090252"></a>Defines a PWM error code to indicate an invalid parameter. </p>
</td>
</tr>
<tr id="row580788749090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p348056367090252"><a name="p348056367090252"></a><a name="p348056367090252"></a><a href="wifiiot.md#gaa0095a6a3cce0f1b5ac6d76167ac5db9">WIFI_IOT_ERR_DMA_INVALID_PARA</a>   0x80001380</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p910905902090252"><a name="p910905902090252"></a><a name="p910905902090252"></a>Defines a DMA error code to indicate an invalid parameter. </p>
</td>
</tr>
<tr id="row1917200235090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1439278718090252"><a name="p1439278718090252"></a><a name="p1439278718090252"></a><a href="wifiiot.md#gabb302953a44571fa73d9142037e8369c">WIFI_IOT_ERR_DMA_NOT_INIT</a>   0x80001381</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p982692396090252"><a name="p982692396090252"></a><a name="p982692396090252"></a>Defines a DMA error code to indicate non-initialization. </p>
</td>
</tr>
<tr id="row1234347895090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1822526400090252"><a name="p1822526400090252"></a><a name="p1822526400090252"></a><a href="wifiiot.md#ga8e39d0a271b7dc5226f73a1e8e4bf540">WIFI_IOT_ERR_DMA_BUSY</a>   0x80001382</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1606996146090252"><a name="p1606996146090252"></a><a name="p1606996146090252"></a>Defines a DMA error code to indicate the busy state. </p>
</td>
</tr>
<tr id="row1199749907090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1907703393090252"><a name="p1907703393090252"></a><a name="p1907703393090252"></a><a href="wifiiot.md#gaac0d381fd56d357ca04f5ba662630ad4">WIFI_IOT_ERR_DMA_TRANSFER_FAIL</a>   0x80001383</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1756515531090252"><a name="p1756515531090252"></a><a name="p1756515531090252"></a>Defines a DMA error code to indicate a transmission failure. </p>
</td>
</tr>
<tr id="row736225194090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p120084624090252"><a name="p120084624090252"></a><a name="p120084624090252"></a><a href="wifiiot.md#ga2d964ec500835559f09356795773081c">WIFI_IOT_ERR_DMA_TRANSFER_TIMEOUT</a>   0x80001384</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p926235882090252"><a name="p926235882090252"></a><a name="p926235882090252"></a>Defines a DMA error code to indicate a transmission timeout. </p>
</td>
</tr>
<tr id="row2092902565090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2082726473090252"><a name="p2082726473090252"></a><a name="p2082726473090252"></a><a href="wifiiot.md#ga126bae9f91f5c1cc91bdcc1f8d10acd3">WIFI_IOT_ERR_DMA_GET_NOTE_FAIL</a>   0x80001385</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p279713076090252"><a name="p279713076090252"></a><a name="p279713076090252"></a>Defines a DMA error code to indicate a retrieval failure. </p>
</td>
</tr>
<tr id="row355702358090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p827444704090252"><a name="p827444704090252"></a><a name="p827444704090252"></a><a href="wifiiot.md#ga0676eed6e7e5e5771fce800a131dde53">WIFI_IOT_ERR_DMA_LLI_NOT_CREATE</a>   0x80001386</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1489468792090252"><a name="p1489468792090252"></a><a name="p1489468792090252"></a>Defines a DMA error code to indicate that the LLI is not created. </p>
</td>
</tr>
<tr id="row1488268656090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1084720025090252"><a name="p1084720025090252"></a><a name="p1084720025090252"></a><a href="wifiiot.md#gaf8502b3f56b5750a131d36bf91d8fea0">WIFI_IOT_ERR_DMA_CH_IRQ_ENABLE_FAIL</a>   0x80001387</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1251004715090252"><a name="p1251004715090252"></a><a name="p1251004715090252"></a>Defines a DMA error code to indicate a failure in enabling channel interrupt. </p>
</td>
</tr>
<tr id="row2139191655090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1035491031090252"><a name="p1035491031090252"></a><a name="p1035491031090252"></a><a href="wifiiot.md#ga24837886814d447997ba4e147d7b88b7">WIFI_IOT_ERR_I2S_INVALID_PARAMETER</a>   0x80001400</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1687685798090252"><a name="p1687685798090252"></a><a name="p1687685798090252"></a>Defines an I2S error code to indicate an invalid parameter. </p>
</td>
</tr>
<tr id="row2058002808090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p302044576090252"><a name="p302044576090252"></a><a name="p302044576090252"></a><a href="wifiiot.md#ga624feb752f94207583f7529eea816197">WIFI_IOT_ERR_I2S_WRITE_TIMEOUT</a>   0x80001401</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p350616199090252"><a name="p350616199090252"></a><a name="p350616199090252"></a>Defines an I2S error code to indicate a write timeout. </p>
</td>
</tr>
<tr id="row1617934882090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p261385689090252"><a name="p261385689090252"></a><a name="p261385689090252"></a><a href="wifiiot.md#ga227218024cb39b3c9569b5ca1512cdd7">WIFI_IOT_ERR_AT_NAME_OR_FUNC_REPEAT_REGISTERED</a>   0x80003280</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1119179801090252"><a name="p1119179801090252"></a><a name="p1119179801090252"></a>Defines an AT error code to indicate repeated function registration. </p>
</td>
</tr>
<tr id="row1945688940090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p251444340090252"><a name="p251444340090252"></a><a name="p251444340090252"></a><a href="wifiiot.md#gafeeea5f2038721f00f3233c32b81d176">WIFI_IOT_ERR_AT_INVALID_PARAMETER</a>   0x80003281</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p450409144090252"><a name="p450409144090252"></a><a name="p450409144090252"></a>Defines an AT error code to indicate an invalid parameter. </p>
</td>
</tr>
<tr id="row1245630108090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1280119728090252"><a name="p1280119728090252"></a><a name="p1280119728090252"></a><em id="gafa09129be9f2e306ae54ab9d913d4c96"><a name="gafa09129be9f2e306ae54ab9d913d4c96"></a><a name="gafa09129be9f2e306ae54ab9d913d4c96"></a></em>WIFI_IOT_FLASH_PARTITON_MAX    12</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p804743927090252"><a name="p804743927090252"></a><a name="p804743927090252"></a>Indicates the maximum number of partition tables. </p>
</td>
</tr>
<tr id="row544616515090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p639012368090252"><a name="p639012368090252"></a><a name="p639012368090252"></a><em id="ga107279ca1341146ae076f8e08c10d1dc"><a name="ga107279ca1341146ae076f8e08c10d1dc"></a><a name="ga107279ca1341146ae076f8e08c10d1dc"></a></em>WIFI_IOT_SDIO_EXTENDREG_COUNT    64</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p535102386090252"><a name="p535102386090252"></a><a name="p535102386090252"></a>Indicates the number of extended registers on an SDIO device. </p>
</td>
</tr>
</tbody>
</table>

## Typedefs<a name="typedef-members"></a>

<a name="table895140366090252"></a>
<table><thead align="left"><tr id="row1197137658090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p114164966090252"><a name="p114164966090252"></a><a name="p114164966090252"></a>Typedef Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1367448233090252"><a name="p1367448233090252"></a><a name="p1367448233090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1397044871090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1533893123090252"><a name="p1533893123090252"></a><a name="p1533893123090252"></a><a href="wifiiot.md#ga93120443d8150e18701ce6d3dd290408">GpioIsrCallbackFunc</a>) (char *arg)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p248791667090252"><a name="p248791667090252"></a><a name="p248791667090252"></a>typedef void(* </p>
<p id="p2098751815090252"><a name="p2098751815090252"></a><a name="p2098751815090252"></a>Indicates the GPIO interrupt callback. </p>
</td>
</tr>
<tr id="row1570372971090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1316149436090252"><a name="p1316149436090252"></a><a name="p1316149436090252"></a><a href="wifiiot.md#ga1176c2c06eca906f3e662027df156109">I2CResetFunc</a>) (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1112025845090252"><a name="p1112025845090252"></a><a name="p1112025845090252"></a>typedef void(* </p>
<p id="p1839021990090252"><a name="p1839021990090252"></a><a name="p1839021990090252"></a>Indicates the callback invoked when a device exception occurs. </p>
</td>
</tr>
<tr id="row1465821865090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1812265670090252"><a name="p1812265670090252"></a><a name="p1812265670090252"></a><a href="wifiiot.md#ga1f0c8fe1deb1cf1fc8b19d69c2fca729">I2cPrepareFunc</a>) (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1258835512090252"><a name="p1258835512090252"></a><a name="p1258835512090252"></a>typedef void(* </p>
<p id="p1514339998090252"><a name="p1514339998090252"></a><a name="p1514339998090252"></a>Indicates the callback invoked for device preparation. </p>
</td>
</tr>
<tr id="row1274821852090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1265179799090252"><a name="p1265179799090252"></a><a name="p1265179799090252"></a><a href="wifiiot.md#ga16779c755404f2ec8543452268a9fb3b">I2cRestoreFunc</a>) (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2053641222090252"><a name="p2053641222090252"></a><a name="p2053641222090252"></a>typedef void(* </p>
<p id="p1348613263090252"><a name="p1348613263090252"></a><a name="p1348613263090252"></a>Indicates the callback invoked for device recovery. </p>
</td>
</tr>
<tr id="row831729753090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p414174869090252"><a name="p414174869090252"></a><a name="p414174869090252"></a><a href="wifiiot.md#ga8be54bbf12f538188db10aaaf4bdbdf9">TickIdleKalCallback</a>) (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1279521175090252"><a name="p1279521175090252"></a><a name="p1279521175090252"></a>typedef void(* </p>
<p id="p398728142090252"><a name="p398728142090252"></a><a name="p398728142090252"></a>Indicates the idle task and CPU tick callbacks. </p>
</td>
</tr>
<tr id="row1997165322090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1706235268090252"><a name="p1706235268090252"></a><a name="p1706235268090252"></a><em id="ga133bb67c0fa6e9dcab35f00edff68e58"><a name="ga133bb67c0fa6e9dcab35f00edff68e58"></a><a name="ga133bb67c0fa6e9dcab35f00edff68e58"></a></em>NotifyHostMessageEvent ) (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p245679871090252"><a name="p245679871090252"></a><a name="p245679871090252"></a><strong id="b677643547"><a name="b677643547"></a><a name="b677643547"></a></strong> typedef void(* </p>
<p id="p1399256564090252"><a name="p1399256564090252"></a><a name="p1399256564090252"></a>Indicates the callback invoked upon a message event on the host. </p>
</td>
</tr>
<tr id="row1098209750090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p486679184090252"><a name="p486679184090252"></a><a name="p486679184090252"></a><em id="gad1acc3e9c9d1c63f70aeb9d5201ed1f0"><a name="gad1acc3e9c9d1c63f70aeb9d5201ed1f0"></a><a name="gad1acc3e9c9d1c63f70aeb9d5201ed1f0"></a></em>SpiIsrFunc ) (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1874146660090252"><a name="p1874146660090252"></a><a name="p1874146660090252"></a><strong id="b1207632301"><a name="b1207632301"></a><a name="b1207632301"></a></strong> typedef void(* </p>
<p id="p424199461090252"><a name="p424199461090252"></a><a name="p424199461090252"></a>Indicates the SPI callback, which is used in <a href="wifiiot.md#ga35305efc779b6386532fdb7a96fc5a1a">SpiRegisterUsrFunc</a>. </p>
</td>
</tr>
</tbody>
</table>

## Enumerations<a name="enum-members"></a>

<a name="table1188446428090252"></a>
<table><thead align="left"><tr id="row1061404558090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p673861912090252"><a name="p673861912090252"></a><a name="p673861912090252"></a>Enumeration Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2101644254090252"><a name="p2101644254090252"></a><a name="p2101644254090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1321961425090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1976140268090252"><a name="p1976140268090252"></a><a name="p1976140268090252"></a><a href="wifiiot.md#ga4c8b663163c7b23071914947a2bca73b">WifiIotAdcChannelIndex</a> {   <a href="wifiiot.md#gga4c8b663163c7b23071914947a2bca73bafe850394965c1431bf6fa82471a12540">WIFI_IOT_ADC_CHANNEL_0</a>, <a href="wifiiot.md#gga4c8b663163c7b23071914947a2bca73bab418db8068026df85efc38e86543b2f8">WIFI_IOT_ADC_CHANNEL_1</a>, <a href="wifiiot.md#gga4c8b663163c7b23071914947a2bca73ba9fb27592172d4ed7652afb7eb67df4f7">WIFI_IOT_ADC_CHANNEL_2</a>, <a href="wifiiot.md#gga4c8b663163c7b23071914947a2bca73ba80a93121e6990776a192d0e2a25f4420">WIFI_IOT_ADC_CHANNEL_3</a>,   <a href="wifiiot.md#gga4c8b663163c7b23071914947a2bca73bae5516e741e66cab4fac522aac5a4cd13">WIFI_IOT_ADC_CHANNEL_4</a>, <a href="wifiiot.md#gga4c8b663163c7b23071914947a2bca73ba462ea6a6767d412e7599fe1c258bd277">WIFI_IOT_ADC_CHANNEL_5</a>, <a href="wifiiot.md#gga4c8b663163c7b23071914947a2bca73bac973eb63cc515666c23bd2a743aaeab9">WIFI_IOT_ADC_CHANNEL_6</a>, <a href="wifiiot.md#gga4c8b663163c7b23071914947a2bca73bab6811d77d85f9280fb12ab02de1ed784">WIFI_IOT_ADC_CHANNEL_7</a>,   <a href="wifiiot.md#gga4c8b663163c7b23071914947a2bca73bab50fa87c837f92c0c93b4b24ca7b6a04">WIFI_IOT_ADC_CHANNEL_BUTT</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p380107521090252"><a name="p380107521090252"></a><a name="p380107521090252"></a>Enumerates ADC channel indexes. </p>
</td>
</tr>
<tr id="row1851744557090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p764137627090252"><a name="p764137627090252"></a><a name="p764137627090252"></a><a href="wifiiot.md#gaac161eb7075f815f6d39a63615bfa82d">WifiIotAdcCurBais</a> {   <a href="wifiiot.md#ggaac161eb7075f815f6d39a63615bfa82da610431a53604392e121dbd6b760de1b0">WIFI_IOT_ADC_CUR_BAIS_DEFAULT</a>, <a href="wifiiot.md#ggaac161eb7075f815f6d39a63615bfa82da0b63185aa983959d4fdc6158d23dbb82">WIFI_IOT_ADC_CUR_BAIS_AUTO</a>, <a href="wifiiot.md#ggaac161eb7075f815f6d39a63615bfa82dafd16a8f9dbcebb676d920e7708782ff0">WIFI_IOT_ADC_CUR_BAIS_1P8V</a>, <a href="wifiiot.md#ggaac161eb7075f815f6d39a63615bfa82da28c17a3bb256e352492c06421b890bc9">WIFI_IOT_ADC_CUR_BAIS_3P3V</a>,   <a href="wifiiot.md#ggaac161eb7075f815f6d39a63615bfa82da7f2ef39248469813c6e99bdc6a1f5b25">WIFI_IOT_ADC_CUR_BAIS_BUTT</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p660968422090252"><a name="p660968422090252"></a><a name="p660968422090252"></a>Enumerates analog power control modes. </p>
</td>
</tr>
<tr id="row1496919985090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p976135084090252"><a name="p976135084090252"></a><a name="p976135084090252"></a><a href="wifiiot.md#gafb9992ebf1655f994dc56883c8fe4b2e">WifiIotAdcEquModelSel</a> {   <a href="wifiiot.md#ggafb9992ebf1655f994dc56883c8fe4b2ea4e277052ddc958f8cbbe3476061bb08c">WIFI_IOT_ADC_EQU_MODEL_1</a>, <a href="wifiiot.md#ggafb9992ebf1655f994dc56883c8fe4b2ea1607975f67fcf1ecd9a12c2ff8007a73">WIFI_IOT_ADC_EQU_MODEL_2</a>, <a href="wifiiot.md#ggafb9992ebf1655f994dc56883c8fe4b2ea2ebb62372c9b0ecd305d5833f8ebee32">WIFI_IOT_ADC_EQU_MODEL_4</a>, <a href="wifiiot.md#ggafb9992ebf1655f994dc56883c8fe4b2eac1d53c7c2cdc479296e2adfec8f7de6b">WIFI_IOT_ADC_EQU_MODEL_8</a>,   <a href="wifiiot.md#ggafb9992ebf1655f994dc56883c8fe4b2ea6c73c22db275621900ad3594106af20c">WIFI_IOT_ADC_EQU_MODEL_BUTT</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p604462152090252"><a name="p604462152090252"></a><a name="p604462152090252"></a>Enumerates equation models. </p>
</td>
</tr>
<tr id="row1618336740090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p541358183090252"><a name="p541358183090252"></a><a name="p541358183090252"></a><a href="wifiiot.md#gacb21f234cf149161f1f95f3330eeb8e7">WifiIotGpioIdx</a> {   <a href="wifiiot.md#ggacb21f234cf149161f1f95f3330eeb8e7ae046fd3cc933c4a52555b32e0ffdb305">WIFI_IOT_GPIO_IDX_0</a>, <a href="wifiiot.md#ggacb21f234cf149161f1f95f3330eeb8e7a07e8f1a810e4eea4bbf62c3090b9b2c3">WIFI_IOT_GPIO_IDX_1</a>, <a href="wifiiot.md#ggacb21f234cf149161f1f95f3330eeb8e7ac7c272c3c3023e61b1aa7a496ca6520e">WIFI_IOT_GPIO_IDX_2</a>, <a href="wifiiot.md#ggacb21f234cf149161f1f95f3330eeb8e7a4fbcd92ee8ce17811e439e9741ede927">WIFI_IOT_GPIO_IDX_3</a>,   <a href="wifiiot.md#ggacb21f234cf149161f1f95f3330eeb8e7aa4fd128cc42f5059812f16ab7731db1f">WIFI_IOT_GPIO_IDX_4</a>, <a href="wifiiot.md#ggacb21f234cf149161f1f95f3330eeb8e7a2aab1a0fc68cbbc834a8c9244e9b45f8">WIFI_IOT_GPIO_IDX_5</a>, <a href="wifiiot.md#ggacb21f234cf149161f1f95f3330eeb8e7a01e89ab69b089341b8fc10dc6df8b5ff">WIFI_IOT_GPIO_IDX_6</a>, <a href="wifiiot.md#ggacb21f234cf149161f1f95f3330eeb8e7a035a212d1b1da2f84c7dcba0b9a5c8e6">WIFI_IOT_GPIO_IDX_7</a>,   <a href="wifiiot.md#ggacb21f234cf149161f1f95f3330eeb8e7ac48a013c85a5701a8c18ce474ba76baf">WIFI_IOT_GPIO_IDX_8</a>, <a href="wifiiot.md#ggacb21f234cf149161f1f95f3330eeb8e7ad4279d9a32bfaf63d1f1cf1e7bcea696">WIFI_IOT_GPIO_IDX_9</a>, <a href="wifiiot.md#ggacb21f234cf149161f1f95f3330eeb8e7aa3d9ce72cd5fe2382390cd74e902a033">WIFI_IOT_GPIO_IDX_10</a>, <a href="wifiiot.md#ggacb21f234cf149161f1f95f3330eeb8e7a596f9afca31a79a1bc43bf929c7045cd">WIFI_IOT_GPIO_IDX_11</a>,   <a href="wifiiot.md#ggacb21f234cf149161f1f95f3330eeb8e7a0e2bde0b5d0914e590803a2c280b3fcd">WIFI_IOT_GPIO_IDX_12</a>, <a href="wifiiot.md#ggacb21f234cf149161f1f95f3330eeb8e7a46b47d9cb13dab42e31ec6c6b73447b5">WIFI_IOT_GPIO_IDX_13</a>, <a href="wifiiot.md#ggacb21f234cf149161f1f95f3330eeb8e7aefb8b54fba7f3938b23a07838ab330ac">WIFI_IOT_GPIO_IDX_14</a>, <a href="wifiiot.md#ggacb21f234cf149161f1f95f3330eeb8e7a7d4d2abc5105e7d3f9a9a4f96e778232">WIFI_IOT_GPIO_IDX_MAX</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p245886093090252"><a name="p245886093090252"></a><a name="p245886093090252"></a>Enumerates GPIO pin IDs. </p>
</td>
</tr>
<tr id="row381051973090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p82655521090252"><a name="p82655521090252"></a><a name="p82655521090252"></a><a href="wifiiot.md#gac9095d1db72e5046b2ec1895aaec0e6b">WifiIotGpioValue</a> { <a href="wifiiot.md#ggac9095d1db72e5046b2ec1895aaec0e6ba5af1f302a77089f4310cafdf0f19a8e9">WIFI_IOT_GPIO_VALUE0</a> = 0, <a href="wifiiot.md#ggac9095d1db72e5046b2ec1895aaec0e6ba13488c68c87449410ef3de8855025708">WIFI_IOT_GPIO_VALUE1</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1877791919090252"><a name="p1877791919090252"></a><a name="p1877791919090252"></a>Enumerates GPIO level values. </p>
</td>
</tr>
<tr id="row443742807090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1097969731090252"><a name="p1097969731090252"></a><a name="p1097969731090252"></a><a href="wifiiot.md#gab4b1fb50c758d491ba297a65e1c7a70a">WifiIotGpioDir</a> { <a href="wifiiot.md#ggab4b1fb50c758d491ba297a65e1c7a70aa4cf28c4ada04aa47ffad38cf1ba4a50d">WIFI_IOT_GPIO_DIR_IN</a> = 0, <a href="wifiiot.md#ggab4b1fb50c758d491ba297a65e1c7a70aa142b702aa598f2482ae27f7d11bdb6eb">WIFI_IOT_GPIO_DIR_OUT</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1707892256090252"><a name="p1707892256090252"></a><a name="p1707892256090252"></a>Enumerates GPIO directions. </p>
</td>
</tr>
<tr id="row2025003021090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1676043806090252"><a name="p1676043806090252"></a><a name="p1676043806090252"></a><a href="wifiiot.md#gac8eb8ad448903ed52c96ccc675e81f94">WifiIotGpioIntType</a> { <a href="wifiiot.md#ggac8eb8ad448903ed52c96ccc675e81f94ab195772135577e55af672a4e40cb7cfe">WIFI_IOT_INT_TYPE_LEVEL</a> = 0, <a href="wifiiot.md#ggac8eb8ad448903ed52c96ccc675e81f94ab06457c13bf24678921dd844e5380b68">WIFI_IOT_INT_TYPE_EDGE</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p737739094090252"><a name="p737739094090252"></a><a name="p737739094090252"></a>Enumerates GPIO interrupt trigger modes. </p>
</td>
</tr>
<tr id="row222786203090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p777222049090252"><a name="p777222049090252"></a><a name="p777222049090252"></a><a href="wifiiot.md#gab81589838cedcc3933bb789c97ad3643">WifiIotGpioIntPolarity</a> { <a href="wifiiot.md#ggab81589838cedcc3933bb789c97ad3643a31fc3445fff6122de496652f3e9023cd">WIFI_IOT_GPIO_EDGE_FALL_LEVEL_LOW</a> = 0, <a href="wifiiot.md#ggab81589838cedcc3933bb789c97ad3643ac1c7abc9c4ecc8c336160a1c36d3bfed">WIFI_IOT_GPIO_EDGE_RISE_LEVEL_HIGH</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1215785561090252"><a name="p1215785561090252"></a><a name="p1215785561090252"></a>Enumerates I/O interrupt polarities. </p>
</td>
</tr>
<tr id="row871123260090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1675396568090252"><a name="p1675396568090252"></a><a name="p1675396568090252"></a><a href="wifiiot.md#ga2f42c70f1dd8a04746e30a97b3dfc415">WifiIotIoName</a> {   <a href="wifiiot.md#gga2f42c70f1dd8a04746e30a97b3dfc415a97963c85f73b7efc5df2b4e791518dd6">WIFI_IOT_IO_NAME_GPIO_0</a>, <a href="wifiiot.md#gga2f42c70f1dd8a04746e30a97b3dfc415a5a7f8f802106534ed2fcff69e70d5223">WIFI_IOT_IO_NAME_GPIO_1</a>, <a href="wifiiot.md#gga2f42c70f1dd8a04746e30a97b3dfc415ab491c9b7b4854b1bed8fe93fb1d1c039">WIFI_IOT_IO_NAME_GPIO_2</a>, <a href="wifiiot.md#gga2f42c70f1dd8a04746e30a97b3dfc415a294203a8cfbf7effec255f87c8e58781">WIFI_IOT_IO_NAME_GPIO_3</a>,   <a href="wifiiot.md#gga2f42c70f1dd8a04746e30a97b3dfc415a8d055a5e935871680109ca2e9ceb3d86">WIFI_IOT_IO_NAME_GPIO_4</a>, <a href="wifiiot.md#gga2f42c70f1dd8a04746e30a97b3dfc415a2a7792d90d0fd908967bb8b116b7a72d">WIFI_IOT_IO_NAME_GPIO_5</a>, <a href="wifiiot.md#gga2f42c70f1dd8a04746e30a97b3dfc415aad36530a39eb4cfa2faa2903b41c2adc">WIFI_IOT_IO_NAME_GPIO_6</a>, <a href="wifiiot.md#gga2f42c70f1dd8a04746e30a97b3dfc415aa2d160d6184312c399dc5c6e0453a499">WIFI_IOT_IO_NAME_GPIO_7</a>,   <a href="wifiiot.md#gga2f42c70f1dd8a04746e30a97b3dfc415a5795930c51751bdac0acb70fe2f78225">WIFI_IOT_IO_NAME_GPIO_8</a>, <a href="wifiiot.md#gga2f42c70f1dd8a04746e30a97b3dfc415a3aa2a8978276384c825dc55f386b6aa6">WIFI_IOT_IO_NAME_GPIO_9</a>, <a href="wifiiot.md#gga2f42c70f1dd8a04746e30a97b3dfc415a10c27fe57a83adc596834140b497a318">WIFI_IOT_IO_NAME_GPIO_10</a>, <a href="wifiiot.md#gga2f42c70f1dd8a04746e30a97b3dfc415a9490124d4cb5c76607c3c7eaf4a3f388">WIFI_IOT_IO_NAME_GPIO_11</a>,   <a href="wifiiot.md#gga2f42c70f1dd8a04746e30a97b3dfc415ae4a090169da74a374b2f693d42e8d22c">WIFI_IOT_IO_NAME_GPIO_12</a>, <a href="wifiiot.md#gga2f42c70f1dd8a04746e30a97b3dfc415ada638b112db327afb19b352a27ba4649">WIFI_IOT_IO_NAME_GPIO_13</a>, <a href="wifiiot.md#gga2f42c70f1dd8a04746e30a97b3dfc415a42eb2173954adcd9a3eed481df2d4bd2">WIFI_IOT_IO_NAME_GPIO_14</a>, <a href="wifiiot.md#gga2f42c70f1dd8a04746e30a97b3dfc415a736421d5c5f92bae9262a8bf1058dfd8">WIFI_IOT_IO_NAME_MAX</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p570051942090252"><a name="p570051942090252"></a><a name="p570051942090252"></a>Enumerates GPIO hardware pin IDs. </p>
</td>
</tr>
<tr id="row979938002090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1033545750090252"><a name="p1033545750090252"></a><a name="p1033545750090252"></a><a href="wifiiot.md#ga2b08eb2a302e2c4fa216a1373bea4a01">WifiIotIoFuncGpio0</a> {   <a href="wifiiot.md#gga2b08eb2a302e2c4fa216a1373bea4a01afb74c7f71f79f223937187b960cd5366">WIFI_IOT_IO_FUNC_GPIO_0_GPIO</a>, <a href="wifiiot.md#gga2b08eb2a302e2c4fa216a1373bea4a01a56f807eaf7e6c867430756964f5fd895">WIFI_IOT_IO_FUNC_GPIO_0_UART1_TXD</a> = 2, <a href="wifiiot.md#gga2b08eb2a302e2c4fa216a1373bea4a01aa918b50f788a9260b8f76d3e3122b113">WIFI_IOT_IO_FUNC_GPIO_0_SPI1_CK</a>, <a href="wifiiot.md#gga2b08eb2a302e2c4fa216a1373bea4a01a5f47990c1eac7597fe91c101ce0a1925">WIFI_IOT_IO_FUNC_GPIO_0_JTAG_TDO</a>,   <a href="wifiiot.md#gga2b08eb2a302e2c4fa216a1373bea4a01ace60a126e858f4281a4cc7d7a2cd4e0c">WIFI_IOT_IO_FUNC_GPIO_0_PWM3_OUT</a>, <a href="wifiiot.md#gga2b08eb2a302e2c4fa216a1373bea4a01a17f92e6fa9b18b21f0749889fdb2a827">WIFI_IOT_IO_FUNC_GPIO_0_I2C1_SDA</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p859815212090252"><a name="p859815212090252"></a><a name="p859815212090252"></a>Enumerates the functions of GPIO hardware pin 0. </p>
</td>
</tr>
<tr id="row106731409090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1659574095090252"><a name="p1659574095090252"></a><a name="p1659574095090252"></a><a href="wifiiot.md#gae9c6ae0f852d8701036823a6223adf7e">WifiiIotIoFuncGpio1</a> { <a href="wifiiot.md#ggae9c6ae0f852d8701036823a6223adf7ea97ed23afc3bd351f4592d10203104983">WIFI_IOT_IO_FUNC_GPIO_1_GPIO</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p716162381090252"><a name="p716162381090252"></a><a name="p716162381090252"></a>Enumerates the functions of GPIO hardware pin 1. </p>
</td>
</tr>
<tr id="row2127165030090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2000585644090252"><a name="p2000585644090252"></a><a name="p2000585644090252"></a><a href="wifiiot.md#gac9d0974184776d35ca9b0f73829f317b">WifiIotIoFuncGpio2</a> {   <a href="wifiiot.md#ggac9d0974184776d35ca9b0f73829f317ba9e9e5978a41b3e8a98afc8341d8118aa">WIFI_IOT_IO_FUNC_GPIO_2_GPIO</a>, <a href="wifiiot.md#ggac9d0974184776d35ca9b0f73829f317ba43585a8b91976d3e6ab9ab24f78be34e">WIFI_IOT_IO_FUNC_GPIO_2_UART1_RTS_N</a> = 2, <a href="wifiiot.md#ggac9d0974184776d35ca9b0f73829f317ba57c97e076eed823905fa8a0dcc48a95d">WIFI_IOT_IO_FUNC_GPIO_2_SPI1_TXD</a>, <a href="wifiiot.md#ggac9d0974184776d35ca9b0f73829f317ba930dbfc4b167e2952ee27edb5affacc2">WIFI_IOT_IO_FUNC_GPIO_2_JTAG_TRSTN</a>,   <a href="wifiiot.md#ggac9d0974184776d35ca9b0f73829f317ba33d45d0432d5a5d59c92526c1567e3a8">WIFI_IOT_IO_FUNC_GPIO_2_PWM2_OUT</a>, <a href="wifiiot.md#ggac9d0974184776d35ca9b0f73829f317bacedc367f8cfcfa29a326e83a35bf7cb4">WIFI_IOT_IO_FUNC_GPIO_2_SSI_CLK</a> = 7 }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1457328075090252"><a name="p1457328075090252"></a><a name="p1457328075090252"></a>Enumerates the functions of GPIO hardware pin 2. </p>
</td>
</tr>
<tr id="row933655591090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1906217930090252"><a name="p1906217930090252"></a><a name="p1906217930090252"></a><a href="wifiiot.md#gaca745c98fc2ef9994e67444c9aa53db8">WifiIotIoFuncGpio3</a> {   <a href="wifiiot.md#ggaca745c98fc2ef9994e67444c9aa53db8a900852cb44e4e5683293935b1638542c">WIFI_IOT_IO_FUNC_GPIO_3_GPIO</a>, <a href="wifiiot.md#ggaca745c98fc2ef9994e67444c9aa53db8ab73e5c02208920999b8b90563cef3966">WIFI_IOT_IO_FUNC_GPIO_3_UART0_TXD</a>, <a href="wifiiot.md#ggaca745c98fc2ef9994e67444c9aa53db8a9781f77096742039e4179f2c7bf5bcc9">WIFI_IOT_IO_FUNC_GPIO_3_UART1_CTS_N</a>, <a href="wifiiot.md#ggaca745c98fc2ef9994e67444c9aa53db8acad4b35de5675ce4e0e4d182e93e024a">WIFI_IOT_IO_FUNC_GPIO_3_SPI1_CSN</a>,   <a href="wifiiot.md#ggaca745c98fc2ef9994e67444c9aa53db8acbe7ac3fc1f3b7885c6fab1b349b530f">WIFI_IOT_IO_FUNC_GPIO_3_JTAG_TDI</a>, <a href="wifiiot.md#ggaca745c98fc2ef9994e67444c9aa53db8ab6fc7d2ba28c9541492fa5b9242f489f">WIFI_IOT_IO_FUNC_GPIO_3_PWM5_OUT</a>, <a href="wifiiot.md#ggaca745c98fc2ef9994e67444c9aa53db8aefe458d1134ebc716c4f0ac4a0a7e87f">WIFI_IOT_IO_FUNC_GPIO_3_I2C1_SDA</a>, <a href="wifiiot.md#ggaca745c98fc2ef9994e67444c9aa53db8ae1f7cb6f32e78a2f4f676c154b26a84a">WIFI_IOT_IO_FUNC_GPIO_3_SSI_DATA</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p764304448090252"><a name="p764304448090252"></a><a name="p764304448090252"></a>Enumerates the functions of GPIO hardware pin 3. </p>
</td>
</tr>
<tr id="row548177948090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1588012400090252"><a name="p1588012400090252"></a><a name="p1588012400090252"></a><a href="wifiiot.md#ga70218b6740d703737739ce4372e2f1e2">WifiIotIoFuncGpio4</a> {   <a href="wifiiot.md#gga70218b6740d703737739ce4372e2f1e2addbb34e879ddba03407a4229116c23ac">WIFI_IOT_IO_FUNC_GPIO_4_GPIO</a>, <a href="wifiiot.md#gga70218b6740d703737739ce4372e2f1e2a1fc155f21a4132b19f63559bcff1f7f9">WIFI_IOT_IO_FUNC_GPIO_4_UART0_RXD</a> = 2, <a href="wifiiot.md#gga70218b6740d703737739ce4372e2f1e2a6acf3b98636223ca6978c72954b62003">WIFI_IOT_IO_FUNC_GPIO_4_JTAG_TMS</a> = 4, <a href="wifiiot.md#gga70218b6740d703737739ce4372e2f1e2a32dd2cc66001ab46db29bb846c52197e">WIFI_IOT_IO_FUNC_GPIO_4_PWM1_OUT</a>,   <a href="wifiiot.md#gga70218b6740d703737739ce4372e2f1e2ae543e2931a4f36ac0325c1540855d661">WIFI_IOT_IO_FUNC_GPIO_4_I2C1_SCL</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1661619055090252"><a name="p1661619055090252"></a><a name="p1661619055090252"></a>Enumerates the functions of GPIO hardware pin 4. </p>
</td>
</tr>
<tr id="row138367842090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1431893286090252"><a name="p1431893286090252"></a><a name="p1431893286090252"></a><a href="wifiiot.md#ga6cbed71f3a94f8e7513c4b91ae1e54ce">WifiIotIoFuncGpio5</a> {   <a href="wifiiot.md#gga6cbed71f3a94f8e7513c4b91ae1e54cea2627264cdc21a54b73d0f7e3d21c3b5f">WIFI_IOT_IO_FUNC_GPIO_5_GPIO</a>, <a href="wifiiot.md#gga6cbed71f3a94f8e7513c4b91ae1e54cea20e6b45cd687dee2ebb1dde55cf02860">WIFI_IOT_IO_FUNC_GPIO_5_UART1_RXD</a> = 2, <a href="wifiiot.md#gga6cbed71f3a94f8e7513c4b91ae1e54cea314bb175969cdf4b56dd38ef648fc409">WIFI_IOT_IO_FUNC_GPIO_5_SPI0_CSN</a>, <a href="wifiiot.md#gga6cbed71f3a94f8e7513c4b91ae1e54cea4944d83dcad39cfdbbc75bd2a72cb4ea">WIFI_IOT_IO_FUNC_GPIO_5_PWM2_OUT</a> = 5,   <a href="wifiiot.md#gga6cbed71f3a94f8e7513c4b91ae1e54cea5aaf6d79a5325bba396a32e240ee689e">WIFI_IOT_IO_FUNC_GPIO_5_I2S0_MCLK</a>, <a href="wifiiot.md#gga6cbed71f3a94f8e7513c4b91ae1e54ceaef4ff12208ea1aec33b99924f1d31f7e">WIFI_IOT_IO_FUNC_GPIO_5_BT_STATUS</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1892852181090252"><a name="p1892852181090252"></a><a name="p1892852181090252"></a>Enumerates the functions of GPIO hardware pin 5. </p>
</td>
</tr>
<tr id="row25906616090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1283367514090252"><a name="p1283367514090252"></a><a name="p1283367514090252"></a><a href="wifiiot.md#ga42008386d7791b97dbfa1fa6b6c4dc1d">WifiIotIoFuncGpio6</a> {   <a href="wifiiot.md#gga42008386d7791b97dbfa1fa6b6c4dc1dab62d9164a716b5adb9e19e8836ab7a86">WIFI_IOT_IO_FUNC_GPIO_6_GPIO</a>, <a href="wifiiot.md#gga42008386d7791b97dbfa1fa6b6c4dc1da2ddce114a7cc5e36018dbcccc51aa18f">WIFI_IOT_IO_FUNC_GPIO_6_UART1_TXD</a> = 2, <a href="wifiiot.md#gga42008386d7791b97dbfa1fa6b6c4dc1da135b58a503fcb9597cc6dc121a31ce20">WIFI_IOT_IO_FUNC_GPIO_6_SPI0_CK</a>, <a href="wifiiot.md#gga42008386d7791b97dbfa1fa6b6c4dc1da592f96e2859ccd5d12df5395a32d7960">WIFI_IOT_IO_FUNC_GPIO_6_PWM3_OUT</a> = 5,   <a href="wifiiot.md#gga42008386d7791b97dbfa1fa6b6c4dc1dad35204fd9982ec2bc34e8b6761ccf6b1">WIFI_IOT_IO_FUNC_GPIO_6_I2S0_TX</a>, <a href="wifiiot.md#gga42008386d7791b97dbfa1fa6b6c4dc1da57cca649a73e43ba821859c3a70c0c4f">WIFI_IOT_IO_FUNC_GPIO_6_COEX_SWITCH</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p906702149090252"><a name="p906702149090252"></a><a name="p906702149090252"></a>Enumerates the functions of GPIO hardware pin 6. </p>
</td>
</tr>
<tr id="row320801167090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1610446111090252"><a name="p1610446111090252"></a><a name="p1610446111090252"></a><a href="wifiiot.md#gac66dc390f39e0933c051790b20552b7c">WifiIotIoFuncGpio7</a> {   <a href="wifiiot.md#ggac66dc390f39e0933c051790b20552b7ca73da6d7633e44681a31b770f10b06aed">WIFI_IOT_IO_FUNC_GPIO_7_GPIO</a>, <a href="wifiiot.md#ggac66dc390f39e0933c051790b20552b7cae1c90084d66c48ebadc657e7b41d4d5a">WIFI_IOT_IO_FUNC_GPIO_7_UART1_CTS_N</a> = 2, <a href="wifiiot.md#ggac66dc390f39e0933c051790b20552b7ca5ef6f43f43355ff8fd9c2fefa53081b4">WIFI_IOT_IO_FUNC_GPIO_7_SPI0_RXD</a>, <a href="wifiiot.md#ggac66dc390f39e0933c051790b20552b7ca06bc301e0d776922e9d4b236d3a30e99">WIFI_IOT_IO_FUNC_GPIO_7_PWM0_OUT</a> = 5,   <a href="wifiiot.md#ggac66dc390f39e0933c051790b20552b7ca23fe50b89ddd6af8cafff14a58cba4bb">WIFI_IOT_IO_FUNC_GPIO_7_I2S0_BCLK</a>, <a href="wifiiot.md#ggac66dc390f39e0933c051790b20552b7ca20325d806adef2ddbb4c553662b1da55">WIFI_IOT_IO_FUNC_GPIO_7_BT_ACTIVE</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1146017282090252"><a name="p1146017282090252"></a><a name="p1146017282090252"></a>Enumerates the functions of GPIO hardware pin 7. </p>
</td>
</tr>
<tr id="row977629716090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1326667723090252"><a name="p1326667723090252"></a><a name="p1326667723090252"></a><a href="wifiiot.md#gae63cd3d5c677fac3b01a3c67e8faf0fb">WifiIotIoFuncGpio8</a> {   <a href="wifiiot.md#ggae63cd3d5c677fac3b01a3c67e8faf0fba6539bffea7913b2a60021c181a0594ef">WIFI_IOT_IO_FUNC_GPIO_8_GPIO</a>, <a href="wifiiot.md#ggae63cd3d5c677fac3b01a3c67e8faf0fba2da69d8ed888cc62f9a2f1b51a011fe8">WIFI_IOT_IO_FUNC_GPIO_8_UART1_RTS_N</a> = 2, <a href="wifiiot.md#ggae63cd3d5c677fac3b01a3c67e8faf0fba13aeec689990e7dc07081faabe165350">WIFI_IOT_IO_FUNC_GPIO_8_SPI0_TXD</a>, <a href="wifiiot.md#ggae63cd3d5c677fac3b01a3c67e8faf0fba7567a0979b39fdc708d5162920260749">WIFI_IOT_IO_FUNC_GPIO_8_PWM1_OUT</a> = 5,   <a href="wifiiot.md#ggae63cd3d5c677fac3b01a3c67e8faf0fba8d67e0d5b97a805d6b080fe280998c9e">WIFI_IOT_IO_FUNC_GPIO_8_I2S0_WS</a>, <a href="wifiiot.md#ggae63cd3d5c677fac3b01a3c67e8faf0fbae605af66f479ef031dccf609f2b38d44">WIFI_IOT_IO_FUNC_GPIO_8_WLAN_ACTIVE</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p747740050090252"><a name="p747740050090252"></a><a name="p747740050090252"></a>Enumerates the functions of GPIO hardware pin 8. </p>
</td>
</tr>
<tr id="row60633686090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1413320168090252"><a name="p1413320168090252"></a><a name="p1413320168090252"></a><a href="wifiiot.md#ga641da9889bd5a8a758e1a4eb2a5a19e4">WifiIotIoFuncGpio9</a> {   <a href="wifiiot.md#gga641da9889bd5a8a758e1a4eb2a5a19e4a350d1fbb9b4821c4b0145245cc1b20ae">WIFI_IOT_IO_FUNC_GPIO_9_GPIO</a>, <a href="wifiiot.md#gga641da9889bd5a8a758e1a4eb2a5a19e4a619cf8d896cf5567dae216d51cb941d7">WIFI_IOT_IO_FUNC_GPIO_9_I2C0_SCL</a>, <a href="wifiiot.md#gga641da9889bd5a8a758e1a4eb2a5a19e4aafa2a6520f7d641e640675ab6a3b020d">WIFI_IOT_IO_FUNC_GPIO_9_UART2_RTS_N</a>, <a href="wifiiot.md#gga641da9889bd5a8a758e1a4eb2a5a19e4a1988d957b5d66e06cd649849d59eaaf6">WIFI_IOT_IO_FUNC_GPIO_9_SDIO_D2</a>,   <a href="wifiiot.md#gga641da9889bd5a8a758e1a4eb2a5a19e4a5a92c3f1f65d07814ce0c9ddce14d321">WIFI_IOT_IO_FUNC_GPIO_9_SPI0_TXD</a>, <a href="wifiiot.md#gga641da9889bd5a8a758e1a4eb2a5a19e4ae35b5602e39b9168dc52d6f4bdf027fd">WIFI_IOT_IO_FUNC_GPIO_9_PWM0_OUT</a>, <a href="wifiiot.md#gga641da9889bd5a8a758e1a4eb2a5a19e4a2408d710172cf78129e56f729083c855">WIFI_IOT_IO_FUNC_GPIO_9_I2S0_MCLK</a> = 7 }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2110915089090252"><a name="p2110915089090252"></a><a name="p2110915089090252"></a>Enumerates the functions of GPIO hardware pin 9. </p>
</td>
</tr>
<tr id="row515813412090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p498435939090252"><a name="p498435939090252"></a><a name="p498435939090252"></a><a href="wifiiot.md#gad4670688ad729f40424bccfeb1afc3b2">WifiIotIoFuncGpio10</a> {   <a href="wifiiot.md#ggad4670688ad729f40424bccfeb1afc3b2a980bb121945c694bbe897de946945267">WIFI_IOT_IO_FUNC_GPIO_10_GPIO</a>, <a href="wifiiot.md#ggad4670688ad729f40424bccfeb1afc3b2acfb8d0df44e655a80d5788dddd08804b">WIFI_IOT_IO_FUNC_GPIO_10_I2C0_SDA</a>, <a href="wifiiot.md#ggad4670688ad729f40424bccfeb1afc3b2a71e59d7f1ef0e39a776a9b2513bf4542">WIFI_IOT_IO_FUNC_GPIO_10_UART2_CTS_N</a>, <a href="wifiiot.md#ggad4670688ad729f40424bccfeb1afc3b2aa0b0898a65f7ac13a733fcba77bc21d0">WIFI_IOT_IO_FUNC_GPIO_10_SDIO_D3</a>,   <a href="wifiiot.md#ggad4670688ad729f40424bccfeb1afc3b2aaf71bf6e3ffc24dfa41be0ef7d30a7a4">WIFI_IOT_IO_FUNC_GPIO_10_SPI0_CK</a>, <a href="wifiiot.md#ggad4670688ad729f40424bccfeb1afc3b2a273d2a5cc021d3f70de7598706da190b">WIFI_IOT_IO_FUNC_GPIO_10_PWM1_OUT</a>, <a href="wifiiot.md#ggad4670688ad729f40424bccfeb1afc3b2a3659f2aa6eda13221af2782569b7f7ba">WIFI_IOT_IO_FUNC_GPIO_10_I2S0_TX</a> = 7 }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p552239970090252"><a name="p552239970090252"></a><a name="p552239970090252"></a>Enumerates the functions of GPIO hardware pin 10. </p>
</td>
</tr>
<tr id="row354204703090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p645171031090252"><a name="p645171031090252"></a><a name="p645171031090252"></a><a href="wifiiot.md#ga5099248aa82355e85ba5a6227f2ab1a7">WifiIotIoFuncGpio11</a> {   <a href="wifiiot.md#gga5099248aa82355e85ba5a6227f2ab1a7aa4116d6aa72f96dd5b9ef648ef642be3">WIFI_IOT_IO_FUNC_GPIO_11_GPIO</a>, <a href="wifiiot.md#gga5099248aa82355e85ba5a6227f2ab1a7a6a1f4f4f8d97c39820c4d2b0a41d8e57">WIFI_IOT_IO_FUNC_GPIO_11_UART2_TXD</a> = 2, <a href="wifiiot.md#gga5099248aa82355e85ba5a6227f2ab1a7aa9313853653525a833917ed4d964741d">WIFI_IOT_IO_FUNC_GPIO_11_SDIO_CMD</a>, <a href="wifiiot.md#gga5099248aa82355e85ba5a6227f2ab1a7a144ce7df4661202d80898acb2ade8b24">WIFI_IOT_IO_FUNC_GPIO_11_SPI0_RXD</a>,   <a href="wifiiot.md#gga5099248aa82355e85ba5a6227f2ab1a7a51f2c16d8b2df9e730fb919db696c3dc">WIFI_IOT_IO_FUNC_GPIO_11_PWM2_OUT</a>, <a href="wifiiot.md#gga5099248aa82355e85ba5a6227f2ab1a7aa6da0b5b2e9c8ba7657e995969f0db7b">WIFI_IOT_IO_FUNC_GPIO_11_RF_TX_EN_EXT</a>, <a href="wifiiot.md#gga5099248aa82355e85ba5a6227f2ab1a7a04954f86710fcfd0ddf5cc7bcb5e09ee">WIFI_IOT_IO_FUNC_GPIO_11_I2S0_RX</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p21309944090252"><a name="p21309944090252"></a><a name="p21309944090252"></a>Enumerates the functions of GPIO hardware pin 11. </p>
</td>
</tr>
<tr id="row39835009090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p726247541090252"><a name="p726247541090252"></a><a name="p726247541090252"></a><a href="wifiiot.md#gaed0008f886fc864d90f6d1c2ae9677a0">WifiIotIoFuncGpio12</a> {   <a href="wifiiot.md#ggaed0008f886fc864d90f6d1c2ae9677a0a51521f4b32e2bf093ac6d1adf2489ad3">WIFI_IOT_IO_FUNC_GPIO_12_GPIO</a>, <a href="wifiiot.md#ggaed0008f886fc864d90f6d1c2ae9677a0a72cfe0d59218319d28b82c996e8061dc">WIFI_IOT_IO_FUNC_GPIO_12_UART2_RXD</a> = 2, <a href="wifiiot.md#ggaed0008f886fc864d90f6d1c2ae9677a0adb573f70a428b79007c934637f954f45">WIFI_IOT_IO_FUNC_GPIO_12_SDIO_CLK</a>, <a href="wifiiot.md#ggaed0008f886fc864d90f6d1c2ae9677a0a5b8d84bb7b7729bb039d1d862064a505">WIFI_IOT_IO_FUNC_GPIO_12_SPI0_CSN</a>,   <a href="wifiiot.md#ggaed0008f886fc864d90f6d1c2ae9677a0a6ec0171f11721b9c27b7182167de4ca7">WIFI_IOT_IO_FUNC_GPIO_12_PWM3_OUT</a>, <a href="wifiiot.md#ggaed0008f886fc864d90f6d1c2ae9677a0a93a3914b6cf990c5a31ba21fc68b37c8">WIFI_IOT_IO_FUNC_GPIO_12_RF_RX_EN_EXT</a>, <a href="wifiiot.md#ggaed0008f886fc864d90f6d1c2ae9677a0a42708c43bf265eae320df358fd737146">WIFI_IOT_IO_FUNC_GPIO_12_I2S0_BCLK</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1214581298090252"><a name="p1214581298090252"></a><a name="p1214581298090252"></a>Enumerates the functions of GPIO hardware pin 12. </p>
</td>
</tr>
<tr id="row105456679090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1630572993090252"><a name="p1630572993090252"></a><a name="p1630572993090252"></a><a href="wifiiot.md#ga364b7c7cc88086ad40c4c3d2dd098648">WifiIotIoFuncGpio13</a> {   <a href="wifiiot.md#gga364b7c7cc88086ad40c4c3d2dd098648a0f2b57575a4463b8cb0141f2313f5ad7">WIFI_IOT_IO_FUNC_GPIO_13_SSI_DATA</a>, <a href="wifiiot.md#gga364b7c7cc88086ad40c4c3d2dd098648a8605c5abf1d51e5f279345cb1b7ee93b">WIFI_IOT_IO_FUNC_GPIO_13_UART0_TXD</a>, <a href="wifiiot.md#gga364b7c7cc88086ad40c4c3d2dd098648a6300109a97003b70942f0157bdbd93a2">WIFI_IOT_IO_FUNC_GPIO_13_UART2_RTS_N</a>, <a href="wifiiot.md#gga364b7c7cc88086ad40c4c3d2dd098648a041cef6b72032e671fa448e2ccd87c0d">WIFI_IOT_IO_FUNC_GPIO_13_SDIO_D0</a>,   <a href="wifiiot.md#gga364b7c7cc88086ad40c4c3d2dd098648a5fa81c0c0bc86f0c7af184b0da088f70">WIFI_IOT_IO_FUNC_GPIO_13_GPIO</a>, <a href="wifiiot.md#gga364b7c7cc88086ad40c4c3d2dd098648a3ee8f8ce9db21a7752af81d023f02700">WIFI_IOT_IO_FUNC_GPIO_13_PWM4_OUT</a>, <a href="wifiiot.md#gga364b7c7cc88086ad40c4c3d2dd098648ac9ee6ac9fae28de25c222350db957be3">WIFI_IOT_IO_FUNC_GPIO_13_I2C0_SDA</a>, <a href="wifiiot.md#gga364b7c7cc88086ad40c4c3d2dd098648a68d69347b2c3e25ed68ee56672789c70">WIFI_IOT_IO_FUNC_GPIO_13_I2S0_WS</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1129672036090252"><a name="p1129672036090252"></a><a name="p1129672036090252"></a>Enumerates the functions of GPIO hardware pin 13. </p>
</td>
</tr>
<tr id="row603129759090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2048523798090252"><a name="p2048523798090252"></a><a name="p2048523798090252"></a><a href="wifiiot.md#gafcf6d4cb0113b803d834bac89af8d9b8">WifiIotIoFuncGpio14</a> {   <a href="wifiiot.md#ggafcf6d4cb0113b803d834bac89af8d9b8ad3c279c96d416bb679a12632e043c869">WIFI_IOT_IO_FUNC_GPIO_14_SSI_CLK</a>, <a href="wifiiot.md#ggafcf6d4cb0113b803d834bac89af8d9b8a74b51226f0832c4e8e178098ca5b52da">WIFI_IOT_IO_FUNC_GPIO_14_UART0_RXD</a>, <a href="wifiiot.md#ggafcf6d4cb0113b803d834bac89af8d9b8a41d571aaeb611fedd801d2623b53ed3b">WIFI_IOT_IO_FUNC_GPIO_14_UART2_CTS_N</a>, <a href="wifiiot.md#ggafcf6d4cb0113b803d834bac89af8d9b8a02e3f6f241d4088eb5245726c528705e">WIFI_IOT_IO_FUNC_GPIO_14_SDIO_D1</a>,   <a href="wifiiot.md#ggafcf6d4cb0113b803d834bac89af8d9b8adc43efa86c4218d6749732899cfff9bd">WIFI_IOT_IO_FUNC_GPIO_14_GPIO</a>, <a href="wifiiot.md#ggafcf6d4cb0113b803d834bac89af8d9b8acd2191145a6a0aeac212036d8c763a88">WIFI_IOT_IO_FUNC_GPIO_14_PWM5_OUT</a>, <a href="wifiiot.md#ggafcf6d4cb0113b803d834bac89af8d9b8aa2b4ea5f2d923bb163ad52a8d6bece2c">WIFI_IOT_IO_FUNC_GPIO_14_I2C0_SCL</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p844611992090252"><a name="p844611992090252"></a><a name="p844611992090252"></a>Enumerates the functions of GPIO hardware pin 14. </p>
</td>
</tr>
<tr id="row1302393576090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1918876284090252"><a name="p1918876284090252"></a><a name="p1918876284090252"></a><a href="wifiiot.md#gae97ab4109f511ceeee889dba9e79a968">WifiIotIoDriverStrength</a> {   <a href="wifiiot.md#ggae97ab4109f511ceeee889dba9e79a968a3640019ffd659132e3cb7ca0d91451b0">WIFI_IOT_IO_DRIVER_STRENGTH_0</a> = 0, <a href="wifiiot.md#ggae97ab4109f511ceeee889dba9e79a968a1c4db14256c5ad110440d2b124f104bd">WIFI_IOT_IO_DRIVER_STRENGTH_1</a>, <a href="wifiiot.md#ggae97ab4109f511ceeee889dba9e79a968a6626c0ecb0ac767493f3705d91045c33">WIFI_IOT_IO_DRIVER_STRENGTH_2</a>, <a href="wifiiot.md#ggae97ab4109f511ceeee889dba9e79a968a1eb7957f7c27f4e347ee9779fa5cf525">WIFI_IOT_IO_DRIVER_STRENGTH_3</a>,   <a href="wifiiot.md#ggae97ab4109f511ceeee889dba9e79a968ab073c01bd41de1e31b8850e7c927a9c0">WIFI_IOT_IO_DRIVER_STRENGTH_4</a>, <a href="wifiiot.md#ggae97ab4109f511ceeee889dba9e79a968a0daaac21180250d6f49dfc4de4c441fb">WIFI_IOT_IO_DRIVER_STRENGTH_5</a>, <a href="wifiiot.md#ggae97ab4109f511ceeee889dba9e79a968ae966a5dd645a6699507b6901c2a02734">WIFI_IOT_IO_DRIVER_STRENGTH_6</a>, <a href="wifiiot.md#ggae97ab4109f511ceeee889dba9e79a968a048d5db3385e0e40561af665b6dc914f">WIFI_IOT_IO_DRIVER_STRENGTH_7</a>,   <a href="wifiiot.md#ggae97ab4109f511ceeee889dba9e79a968a6a751b7c9907d1ac9eb89be807c13506">WIFI_IOT_IO_DRIVER_STRENGTH_MAX</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p605861998090252"><a name="p605861998090252"></a><a name="p605861998090252"></a>Enumerates I/O driver strength levels. </p>
</td>
</tr>
<tr id="row152042129090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1650882194090252"><a name="p1650882194090252"></a><a name="p1650882194090252"></a><a href="wifiiot.md#gacc20a5c6456ec381ed931232c29d1c4f">WifiIotIoPull</a> { <a href="wifiiot.md#ggacc20a5c6456ec381ed931232c29d1c4fa8699edd19f2fe1c8e2e0f843c100b665">WIFI_IOT_IO_PULL_NONE</a>, <a href="wifiiot.md#ggacc20a5c6456ec381ed931232c29d1c4fa101a6db99a7c37721ee35dfdb93bf705">WIFI_IOT_IO_PULL_UP</a>, <a href="wifiiot.md#ggacc20a5c6456ec381ed931232c29d1c4fa61e259c36a0567f7ca43ff7abd1b1d81">WIFI_IOT_IO_PULL_DOWN</a>, <a href="wifiiot.md#ggacc20a5c6456ec381ed931232c29d1c4fa4d8b63c757a91e4dc317fb4e9b8e2955">WIFI_IOT_IO_PULL_MAX</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p108857020090252"><a name="p108857020090252"></a><a name="p108857020090252"></a>Enumerates GPIO pull-up or pull-down settings. </p>
</td>
</tr>
<tr id="row1480241287090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p157256831090252"><a name="p157256831090252"></a><a name="p157256831090252"></a><a href="wifiiot.md#gaeeb58e02e3783d02e1ed4bad313cc0b8">WifiIotI2cIdx</a> { <a href="wifiiot.md#ggaeeb58e02e3783d02e1ed4bad313cc0b8a626c3ef4caf51e1f1f7d8b4413e399bb">WIFI_IOT_I2C_IDX_0</a>, <a href="wifiiot.md#ggaeeb58e02e3783d02e1ed4bad313cc0b8ad35ceb88fb8b4b6b9cb123d4d32b9316">WIFI_IOT_I2C_IDX_1</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p145281207090252"><a name="p145281207090252"></a><a name="p145281207090252"></a>Enumerates I2C hardware indexes. </p>
</td>
</tr>
<tr id="row523932018090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1546111089090252"><a name="p1546111089090252"></a><a name="p1546111089090252"></a><a href="wifiiot.md#ga5e124d70b18cf4cff40bcce78445f689">WifiIotI2sSampleRate</a> { <a href="wifiiot.md#gga5e124d70b18cf4cff40bcce78445f689ace40be85474a4c93a09f249c217a6e41">WIFI_IOT_I2S_SAMPLE_RATE_8K</a> = 8, <a href="wifiiot.md#gga5e124d70b18cf4cff40bcce78445f689a70144626b7f06acc91ca0439d44ad1b7">WIFI_IOT_I2S_SAMPLE_RATE_16K</a> = 16, <a href="wifiiot.md#gga5e124d70b18cf4cff40bcce78445f689a4ccb67a70dc96f4faf074ab676728258">WIFI_IOT_I2S_SAMPLE_RATE_32K</a> = 32, <a href="wifiiot.md#gga5e124d70b18cf4cff40bcce78445f689aa8987a10f3c5206bae1f875d45cc854c">WIFI_IOT_I2S_SAMPLE_RATE_48K</a> = 48 }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p791099036090252"><a name="p791099036090252"></a><a name="p791099036090252"></a>Enumerates I2S sampling rates. </p>
</td>
</tr>
<tr id="row1609319531090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p615563621090252"><a name="p615563621090252"></a><a name="p615563621090252"></a><a href="wifiiot.md#gac024b870d63e802d8119e88a82953807">WifiIotI2sResolution</a> { <a href="wifiiot.md#ggac024b870d63e802d8119e88a82953807af441b8fd738e63fc6237077d018b0eda">WIFI_IOT_I2S_RESOLUTION_16BIT</a> = 16, <a href="wifiiot.md#ggac024b870d63e802d8119e88a82953807a0a73e0bc3019668a6d75a1200a899db9">WIFI_IOT_I2S_RESOLUTION_24BIT</a> = 24 }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1949223918090252"><a name="p1949223918090252"></a><a name="p1949223918090252"></a>Enumerates I2S resolution. </p>
</td>
</tr>
<tr id="row1624778876090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p540860736090252"><a name="p540860736090252"></a><a name="p540860736090252"></a><a href="wifiiot.md#ga2f287bbb40987fe6d1d7fa525574c00c">WifiIotFlashPartitionTableId</a> {   <a href="wifiiot.md#gga2f287bbb40987fe6d1d7fa525574c00ca084dbf8aafce9c7a3ecad33da66e05b0">WIFI_IOT_FLASH_PARTITON_BOOT</a> = 0, <a href="wifiiot.md#gga2f287bbb40987fe6d1d7fa525574c00cabb8d227a662a66aad9557d9fc817a8fb">WIFI_IOT_FLASH_PARTITON_FACTORY_NV</a>, <a href="wifiiot.md#gga2f287bbb40987fe6d1d7fa525574c00ca427d6a8603c364374b5eb714450e18c8">WIFI_IOT_FLASH_PARTITON_NORMAL_NV</a>, <a href="wifiiot.md#gga2f287bbb40987fe6d1d7fa525574c00ca50131238794a26984f0f1209f94b338f">WIFI_IOT_FLASH_PARTITON_NORMAL_NV_BACKUP</a>,   <a href="wifiiot.md#gga2f287bbb40987fe6d1d7fa525574c00ca779875726c11006ea771f1ad2fb8af9b">WIFI_IOT_FLASH_PARTITON_KERNEL_A</a>, <a href="wifiiot.md#gga2f287bbb40987fe6d1d7fa525574c00caddd52544b51d83e70cfe5966852f9780">WIFI_IOT_FLASH_PARTITON_KERNEL_B</a>, <a href="wifiiot.md#gga2f287bbb40987fe6d1d7fa525574c00ca4f7f1e1f9120cf095a9c7b5d076c4ba4">WIFI_IOT_FLASH_PARTITON_HILINK</a>, <a href="wifiiot.md#gga2f287bbb40987fe6d1d7fa525574c00cacff32ff0901d4ca46814d747880579fa">WIFI_IOT_FLASH_PARTITON_FILE_SYSTEM</a>,   <a href="wifiiot.md#gga2f287bbb40987fe6d1d7fa525574c00cae8c645e2e5d130218b6eaec1e57dc8ee">WIFI_IOT_FLASH_PARTITON_USR_RESERVE</a>, <a href="wifiiot.md#gga2f287bbb40987fe6d1d7fa525574c00ca70a3cdffb76b64cbacf6973bf06e0a0a">WIFI_IOT_FLASH_PARTITON_HILINK_PKI</a>, <a href="wifiiot.md#gga2f287bbb40987fe6d1d7fa525574c00ca84650ae2f4cd3e7be0a1a24eb378e28c">WIFI_IOT_FLASH_PARTITON_CRASH_INFO</a>, <a href="wifiiot.md#gga2f287bbb40987fe6d1d7fa525574c00ca7068d177a4cdb8239445b7cc5763d132">WIFI_IOT_FLASH_PARTITON_BOOT_BACK</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p414623135090252"><a name="p414623135090252"></a><a name="p414623135090252"></a>Indicates the partition table ID. </p>
</td>
</tr>
<tr id="row1192960190090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1153253227090252"><a name="p1153253227090252"></a><a name="p1153253227090252"></a><a href="wifiiot.md#ga2ecbd0ab9636fedd354de7447056df29">WifiIotPwmClkSource</a> { <a href="wifiiot.md#gga2ecbd0ab9636fedd354de7447056df29adaadc6f6a5e89f7d1a8fa55d8cc89d0f">WIFI_IOT_PWM_CLK_160M</a>, <a href="wifiiot.md#gga2ecbd0ab9636fedd354de7447056df29a610c246fc1c129b3c223884b5f644888">WIFI_IOT_PWM_CLK_XTAL</a>, <a href="wifiiot.md#gga2ecbd0ab9636fedd354de7447056df29a09394bc5af28cf9e01eb6cca9bf8e633">WIFI_IOT_PWM_CLK_MAX</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p516352422090252"><a name="p516352422090252"></a><a name="p516352422090252"></a>Enumerates PWM clock sources. </p>
</td>
</tr>
<tr id="row1100435388090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2097129182090252"><a name="p2097129182090252"></a><a name="p2097129182090252"></a><a href="wifiiot.md#gab3518ce878df4a40d614e88a6f81dea7">WifiIotPwmPort</a> {   <a href="wifiiot.md#ggab3518ce878df4a40d614e88a6f81dea7a99047f09c031299d4c68c0eb2dc523e9">WIFI_IOT_PWM_PORT_PWM0</a> = 0, <a href="wifiiot.md#ggab3518ce878df4a40d614e88a6f81dea7afe267b92864e4b1bb171724d8f555922">WIFI_IOT_PWM_PORT_PWM1</a> = 1, <a href="wifiiot.md#ggab3518ce878df4a40d614e88a6f81dea7ac6530394f6bab8fecc8cf7417646c66b">WIFI_IOT_PWM_PORT_PWM2</a> = 2, <a href="wifiiot.md#ggab3518ce878df4a40d614e88a6f81dea7a0b16863a2291abfac01581c15e184126">WIFI_IOT_PWM_PORT_PWM3</a> = 3,   <a href="wifiiot.md#ggab3518ce878df4a40d614e88a6f81dea7aa6d4371910a891288c6181ffd358b7fb">WIFI_IOT_PWM_PORT_PWM4</a> = 4, <a href="wifiiot.md#ggab3518ce878df4a40d614e88a6f81dea7a3f7666b782bb361e556e8062b4ff80aa">WIFI_IOT_PWM_PORT_PWM5</a> = 5, <a href="wifiiot.md#ggab3518ce878df4a40d614e88a6f81dea7a24bfb3984d6e6e91f897e20e267ada3b">WIFI_IOT_PWM_PORT_MAX</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1037250360090252"><a name="p1037250360090252"></a><a name="p1037250360090252"></a>Enumerates PWM ports. </p>
</td>
</tr>
<tr id="row2102435391090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1031446433090252"><a name="p1031446433090252"></a><a name="p1031446433090252"></a><a href="wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b">WifiIotSpiIdx</a> { <a href="wifiiot.md#gga1d095e78d92cdf2ffc5e34443726e44ba3a13c86181ffb2c6927f86f423ec40b4">WIFI_IOT_SPI_ID_0</a> = 0, <a href="wifiiot.md#gga1d095e78d92cdf2ffc5e34443726e44baeb87de3e3fe320957bc97c2fcc430da1">WIFI_IOT_SPI_ID_1</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1372742787090252"><a name="p1372742787090252"></a><a name="p1372742787090252"></a>Enumerates SPI channel IDs. </p>
</td>
</tr>
<tr id="row141081884090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1818259605090252"><a name="p1818259605090252"></a><a name="p1818259605090252"></a><a href="wifiiot.md#gad6674c8b0989b6a329d5fd5ff0d5d750">WifiIotSpiCfgClockCpol</a> { <a href="wifiiot.md#ggad6674c8b0989b6a329d5fd5ff0d5d750a07059b75b690958e26aa89a6004bf271">WIFI_IOT_SPI_CFG_CLOCK_CPOL_0</a>, <a href="wifiiot.md#ggad6674c8b0989b6a329d5fd5ff0d5d750a0a0c2d8a56ac7fb1c965e496ef9d24fd">WIFI_IOT_SPI_CFG_CLOCK_CPOL_1</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1239467634090252"><a name="p1239467634090252"></a><a name="p1239467634090252"></a>Enumerates communication polarities. </p>
</td>
</tr>
<tr id="row1569912537090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p710206760090252"><a name="p710206760090252"></a><a name="p710206760090252"></a><a href="wifiiot.md#ga1eb13cffbbdec9da1d57c766763b94e5">WifiIotSpiCfgClockCpha</a> { <a href="wifiiot.md#gga1eb13cffbbdec9da1d57c766763b94e5af8cbca20bbbc6c065eae3cb21382d3b6">WIFI_IOT_SPI_CFG_CLOCK_CPHA_0</a>, <a href="wifiiot.md#gga1eb13cffbbdec9da1d57c766763b94e5abd4a35c6cbe22a90892f1f877eb9be3f">WIFI_IOT_SPI_CFG_CLOCK_CPHA_1</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p116365273090252"><a name="p116365273090252"></a><a name="p116365273090252"></a>Enumerates communication phases. </p>
</td>
</tr>
<tr id="row169374755090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1898478957090252"><a name="p1898478957090252"></a><a name="p1898478957090252"></a><a href="wifiiot.md#gaef7c192e049db14e2326c0bfba181670">WifiIotSpiCfgFramMode</a> { <a href="wifiiot.md#ggaef7c192e049db14e2326c0bfba181670a3d7e1d60fe5cdf86cd72cca5e20109fb">WIFI_IOT_SPI_CFG_FRAM_MODE_MOTOROLA</a>, <a href="wifiiot.md#ggaef7c192e049db14e2326c0bfba181670a8b16cdb5100d57654c512e88275c789d">WIFI_IOT_SPI_CFG_FRAM_MODE_TI</a>, <a href="wifiiot.md#ggaef7c192e049db14e2326c0bfba181670a2f0198dff6d832a556a621b5de0606fc">WIFI_IOT_SPI_CFG_FRAM_MODE_MICROWIRE</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2047423859090252"><a name="p2047423859090252"></a><a name="p2047423859090252"></a>Enumerates communication protocols. </p>
</td>
</tr>
<tr id="row761540900090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1017352570090252"><a name="p1017352570090252"></a><a name="p1017352570090252"></a><a href="wifiiot.md#ga6f2e44db2698c33b81bd6caa438a55ea">WifiIotSpiCfgDataWidth</a> {   <a href="wifiiot.md#gga6f2e44db2698c33b81bd6caa438a55eaaddfa282d58578fc81ac526987564e6ee">WIFI_IOT_SPI_CFG_DATA_WIDTH_E_4BIT</a> = 0x3, <a href="wifiiot.md#gga6f2e44db2698c33b81bd6caa438a55eaa9de2e6dd354e226a820c079b8bac65b6">WIFI_IOT_SPI_CFG_DATA_WIDTH_E_5BIT</a>, <a href="wifiiot.md#gga6f2e44db2698c33b81bd6caa438a55eaaa4144e7267c3a0417d8d0100cfcf50dd">WIFI_IOT_SPI_CFG_DATA_WIDTH_E_6BIT</a>, <a href="wifiiot.md#gga6f2e44db2698c33b81bd6caa438a55eaa95f9ec882c23c6e61182dbc64a4204ff">WIFI_IOT_SPI_CFG_DATA_WIDTH_E_7BIT</a>,   <a href="wifiiot.md#gga6f2e44db2698c33b81bd6caa438a55eaa87c4e51ad22460a2ee1e8f4a818ab4d0">WIFI_IOT_SPI_CFG_DATA_WIDTH_E_8BIT</a>, <a href="wifiiot.md#gga6f2e44db2698c33b81bd6caa438a55eaa1760c12ab9015525fa00483aa3ae6ce3">WIFI_IOT_SPI_CFG_DATA_WIDTH_E_9BIT</a>, <a href="wifiiot.md#gga6f2e44db2698c33b81bd6caa438a55eaa2d5436642374f2e20544f4dd23b2a82e">WIFI_IOT_SPI_CFG_DATA_WIDTH_E_10BIT</a>, <a href="wifiiot.md#gga6f2e44db2698c33b81bd6caa438a55eaa7de25e82ef22f3d7ecca7ba6740affaf">WIFI_IOT_SPI_CFG_DATA_WIDTH_E_11BIT</a>,   <a href="wifiiot.md#gga6f2e44db2698c33b81bd6caa438a55eaa7ef096c72549f4bdccd2da349928d197">WIFI_IOT_SPI_CFG_DATA_WIDTH_E_12BIT</a>, <a href="wifiiot.md#gga6f2e44db2698c33b81bd6caa438a55eaadfa6793a7643c016f8946dbb6fefb393">WIFI_IOT_SPI_CFG_DATA_WIDTH_E_13BIT</a>, <a href="wifiiot.md#gga6f2e44db2698c33b81bd6caa438a55eaaa10903f6e508f27f7290345ad77e8aad">WIFI_IOT_SPI_CFG_DATA_WIDTH_E_14BIT</a>, <a href="wifiiot.md#gga6f2e44db2698c33b81bd6caa438a55eaa626cba1c95892d1265908e94b8df725a">WIFI_IOT_SPI_CFG_DATA_WIDTH_E_15BIT</a>,   <a href="wifiiot.md#gga6f2e44db2698c33b81bd6caa438a55eaa3dba59e8d0c84fa68875aa4ff3988e9c">WIFI_IOT_SPI_CFG_DATA_WIDTH_E_16BIT</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p613553924090252"><a name="p613553924090252"></a><a name="p613553924090252"></a>Enumerates the communication data width, that is, the number of valid bits in each frame. </p>
</td>
</tr>
<tr id="row599764771090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p502957355090252"><a name="p502957355090252"></a><a name="p502957355090252"></a><a href="wifiiot.md#ga31924085df23a024413fa6e63e13c41e">WifiIotSpiCfgEndian</a> { <a href="wifiiot.md#gga31924085df23a024413fa6e63e13c41ea68812944912ba0729ae0efeb2d126c2a">WIFI_IOT_SPI_CFG_ENDIAN_LITTLE</a>, <a href="wifiiot.md#gga31924085df23a024413fa6e63e13c41eabed491171ca62fc1cfcc5d7b7b0413b1">WIFI_IOT_SPI_CFG_ENDIAN_BIG</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1055899132090252"><a name="p1055899132090252"></a><a name="p1055899132090252"></a>Enumerates the endian mode of each frame. </p>
</td>
</tr>
<tr id="row146391826090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1409592300090252"><a name="p1409592300090252"></a><a name="p1409592300090252"></a><a href="wifiiot.md#ga2699252424e5469ef243ae279a263c44">WifiIotUartIdx</a> { <a href="wifiiot.md#gga2699252424e5469ef243ae279a263c44a857a6dfad592ed99b2d8bb33d904efc1">WIFI_IOT_UART_IDX_0</a>, <a href="wifiiot.md#gga2699252424e5469ef243ae279a263c44afb78269eebd0488de767da02fd576c97">WIFI_IOT_UART_IDX_1</a>, <a href="wifiiot.md#gga2699252424e5469ef243ae279a263c44afe10e4ecae6f290980243f74c0582e8f">WIFI_IOT_UART_IDX_2</a>, <a href="wifiiot.md#gga2699252424e5469ef243ae279a263c44a4f01b665c25a5c2fb4188156c138a13d">WIFI_IOT_UART_IDX_MAX</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1982031905090252"><a name="p1982031905090252"></a><a name="p1982031905090252"></a>Enumerates the UART serial number. </p>
</td>
</tr>
<tr id="row798160806090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p147848058090252"><a name="p147848058090252"></a><a name="p147848058090252"></a><a href="wifiiot.md#gafdf1adfc0e0ed18282aa3006300b12b4">WifiIotUartIdxDataBit</a> { <a href="wifiiot.md#ggafdf1adfc0e0ed18282aa3006300b12b4afd012e7a4332f70fd227e3471adf337b">WIFI_IOT_UART_DATA_BIT_5</a> = 5, <a href="wifiiot.md#ggafdf1adfc0e0ed18282aa3006300b12b4aff9e05b0da6c4120371c89d0c07e25b8">WIFI_IOT_UART_DATA_BIT_6</a>, <a href="wifiiot.md#ggafdf1adfc0e0ed18282aa3006300b12b4a45121424f9ea54a738fbb976ff3e9bee">WIFI_IOT_UART_DATA_BIT_7</a>, <a href="wifiiot.md#ggafdf1adfc0e0ed18282aa3006300b12b4a2dd7698b7154c4905e6908336347ddb1">WIFI_IOT_UART_DATA_BIT_8</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1139775398090252"><a name="p1139775398090252"></a><a name="p1139775398090252"></a>Enumerates the number of UART data bits. </p>
</td>
</tr>
<tr id="row1411607625090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1756283897090252"><a name="p1756283897090252"></a><a name="p1756283897090252"></a><a href="wifiiot.md#gab0a1b43e8e98b028717e6557003b3172">WifiIotUartStopBit</a> { <a href="wifiiot.md#ggab0a1b43e8e98b028717e6557003b3172accbf9f04cf5f1e8203ead9d5663ee8e8">WIFI_IOT_UART_STOP_BIT_1</a> = 1, <a href="wifiiot.md#ggab0a1b43e8e98b028717e6557003b3172a6c40d45a17b4c9d38696284d01faa8e8">WIFI_IOT_UART_STOP_BIT_2</a> = 2 }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p98903288090252"><a name="p98903288090252"></a><a name="p98903288090252"></a>Enumerates the number of UART stop bits. </p>
</td>
</tr>
<tr id="row247239945090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1717125919090252"><a name="p1717125919090252"></a><a name="p1717125919090252"></a><a href="wifiiot.md#ga9cee98ab295d2e42ab7f0fb614268602">WifiIotUartParity</a> { <a href="wifiiot.md#gga9cee98ab295d2e42ab7f0fb614268602aaa5d06991c6d267b87c8b2e89e3bae4b">WIFI_IOT_UART_PARITY_NONE</a> = 0, <a href="wifiiot.md#gga9cee98ab295d2e42ab7f0fb614268602a2552846d7dac988f292b2495a6a3b193">WIFI_IOT_UART_PARITY_ODD</a> = 1, <a href="wifiiot.md#gga9cee98ab295d2e42ab7f0fb614268602af4deb913ecbe142ef3df8e9f0b985e36">WIFI_IOT_UART_PARITY_EVEN</a> = 2 }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1647975119090252"><a name="p1647975119090252"></a><a name="p1647975119090252"></a>Enumerates the UART parity bit. </p>
</td>
</tr>
<tr id="row545727970090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1182411577090252"><a name="p1182411577090252"></a><a name="p1182411577090252"></a><a href="wifiiot.md#ga1c15f86994b472d35bee5d6b57d42a49">WifiIotUartFifoLine</a> {   <a href="wifiiot.md#gga1c15f86994b472d35bee5d6b57d42a49a3003d4ad2672ef855b80317b708a0fdb">WIFI_IOT_FIFO_LINE_ONE_EIGHT</a> = 1, <a href="wifiiot.md#gga1c15f86994b472d35bee5d6b57d42a49af9a3ea60c05bd3cc8cc793d358543f7c">WIFI_IOT_FIFO_LINE_ONE_QUARTER</a>, <a href="wifiiot.md#gga1c15f86994b472d35bee5d6b57d42a49a3f8731dc0941726af9cd00ba1b2bf3ee">WIFI_IOT_FIFO_LINE_HALF</a>, <a href="wifiiot.md#gga1c15f86994b472d35bee5d6b57d42a49aac418922b4708891f9b35b7169569eae">WIFI_IOT_FIFO_LINE_THREE_QUARTERS</a>,   <a href="wifiiot.md#gga1c15f86994b472d35bee5d6b57d42a49a6fb9cbffe9467f79f72bd49f504d6407">WIFI_IOT_FIFO_LINE_SEVEN_EIGHTS</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p146789020090252"><a name="p146789020090252"></a><a name="p146789020090252"></a>Enumerates UART FIFO interrupt thresholds. </p>
</td>
</tr>
<tr id="row1232470184090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1853877210090252"><a name="p1853877210090252"></a><a name="p1853877210090252"></a><a href="wifiiot.md#ga93f35a58dc54e29d4892d1e94179c72d">WifiIotUartBlockState</a> { <a href="wifiiot.md#gga93f35a58dc54e29d4892d1e94179c72da4c82baa44ed8c8c48f3a0f4659e9a05b">WIFI_IOT_UART_BLOCK_STATE_NONE_BLOCK</a> = 1, <a href="wifiiot.md#gga93f35a58dc54e29d4892d1e94179c72da17f7be87206b00b8e42a5ab3d48be1de">WIFI_IOT_UART_BLOCK_STATE_BLOCK</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p44569741090252"><a name="p44569741090252"></a><a name="p44569741090252"></a>Enumerates UART block states. </p>
</td>
</tr>
<tr id="row932703888090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p981818417090252"><a name="p981818417090252"></a><a name="p981818417090252"></a><a href="wifiiot.md#gaf36ed6a640d85e79dfee020131e0d86f">WifiIotUartDmaState</a> { <a href="wifiiot.md#ggaf36ed6a640d85e79dfee020131e0d86fa7c272d8288c6a14d6f8a663e6aa148c7">WIFI_IOT_UART_NONE_DMA</a> = 1, <a href="wifiiot.md#ggaf36ed6a640d85e79dfee020131e0d86facdc483dbfb6421d1604e1b2008fac7ac">WIFI_IOT_UART_USE_DMA</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1551702373090252"><a name="p1551702373090252"></a><a name="p1551702373090252"></a>Enumerates UART DMA states. </p>
</td>
</tr>
<tr id="row1916398290090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1451796717090252"><a name="p1451796717090252"></a><a name="p1451796717090252"></a><a href="wifiiot.md#gacf7ec5d973706e8239c7c6e4a470d8ab">WifiIotFlowCtrl</a> { <a href="wifiiot.md#ggacf7ec5d973706e8239c7c6e4a470d8aba90bfc480060d1a4e23805dd0512fe428">WIFI_IOT_FLOW_CTRL_NONE</a>, <a href="wifiiot.md#ggacf7ec5d973706e8239c7c6e4a470d8aba0abb36c9eb6e80ed338f99d87d3ebfbf">WIFI_IOT_FLOW_CTRL_RTS_CTS</a>, <a href="wifiiot.md#ggacf7ec5d973706e8239c7c6e4a470d8aba92b50039dcab731820e2b360ab9ecaeb">WIFI_IOT_FLOW_CTRL_RTS_ONLY</a>, <a href="wifiiot.md#ggacf7ec5d973706e8239c7c6e4a470d8aba470242c7e05e69b3e24de131bdd418ae">WIFI_IOT_FLOW_CTRL_CTS_ONLY</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2141649776090252"><a name="p2141649776090252"></a><a name="p2141649776090252"></a>Enumerates hardware flow control modes. </p>
</td>
</tr>
</tbody>
</table>

## Functions<a name="func-members"></a>

<a name="table75263660090252"></a>
<table><thead align="left"><tr id="row1481115623090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p119152482090252"><a name="p119152482090252"></a><a name="p119152482090252"></a>Function Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p799828923090252"><a name="p799828923090252"></a><a name="p799828923090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row450319763090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2052955575090252"><a name="p2052955575090252"></a><a name="p2052955575090252"></a><a href="wifiiot.md#ga6e43b3c41859efd279c9a539a4e38731">AdcRead</a> (<a href="wifiiot.md#ga4c8b663163c7b23071914947a2bca73b">WifiIotAdcChannelIndex</a> channel, unsigned short *data, <a href="wifiiot.md#gafb9992ebf1655f994dc56883c8fe4b2e">WifiIotAdcEquModelSel</a> equModel, <a href="wifiiot.md#gaac161eb7075f815f6d39a63615bfa82d">WifiIotAdcCurBais</a> curBais, unsigned short rstCnt)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1353069656090252"><a name="p1353069656090252"></a><a name="p1353069656090252"></a>unsigned int </p>
<p id="p819851755090252"><a name="p819851755090252"></a><a name="p819851755090252"></a>Reads a piece of sampled data from a specified ADC channel based on the input parameters. </p>
</td>
</tr>
<tr id="row1107527298090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p439455181090252"><a name="p439455181090252"></a><a name="p439455181090252"></a><a href="wifiiot.md#ga2967ccc90396327f31df7365f3bb8501">AtRegisterCmd</a> (const <a href="atcmdtbl.md">AtCmdTbl</a> *cmdTbl, unsigned short cmdNum)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p743906570090252"><a name="p743906570090252"></a><a name="p743906570090252"></a>unsigned int </p>
<p id="p1256631713090252"><a name="p1256631713090252"></a><a name="p1256631713090252"></a>Registers a certain number of AT commands. </p>
</td>
</tr>
<tr id="row1392390278090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p993931373090252"><a name="p993931373090252"></a><a name="p993931373090252"></a><a href="wifiiot.md#ga73b1bb803919e709a2a9a4a21530cf7b">AtSysCmdRegister</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1678358088090252"><a name="p1678358088090252"></a><a name="p1678358088090252"></a>void </p>
<p id="p1058285863090252"><a name="p1058285863090252"></a><a name="p1058285863090252"></a>Registers a system AT command. </p>
</td>
</tr>
<tr id="row452973667090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1444185061090252"><a name="p1444185061090252"></a><a name="p1444185061090252"></a><a href="wifiiot.md#gad03e3a92ab85a6ee0660df82272be5e9">AtPrintf</a> (const char *fmt,...)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1010038312090252"><a name="p1010038312090252"></a><a name="p1010038312090252"></a>int </p>
<p id="p1912227548090252"><a name="p1912227548090252"></a><a name="p1912227548090252"></a>Formats data and outputs it to the AT command terminal. </p>
</td>
</tr>
<tr id="row1432827788090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1901915960090252"><a name="p1901915960090252"></a><a name="p1901915960090252"></a><a href="wifiiot.md#gaa72b05261c0b633751d7bd4e10db4870">AtInit</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p612814723090252"><a name="p612814723090252"></a><a name="p612814723090252"></a>unsigned int </p>
<p id="p1167887631090252"><a name="p1167887631090252"></a><a name="p1167887631090252"></a>Initializes an AT command task. </p>
</td>
</tr>
<tr id="row1326783299090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p309745226090252"><a name="p309745226090252"></a><a name="p309745226090252"></a><a href="wifiiot.md#ga9068fd445d529fbc468fd27c336f1c43">AtCheckUartBusy</a> (unsigned char enable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2134199009090252"><a name="p2134199009090252"></a><a name="p2134199009090252"></a>void </p>
<p id="p1947924659090252"><a name="p1947924659090252"></a><a name="p1947924659090252"></a>Sets whether to check the UART busy status during low-power voting. </p>
</td>
</tr>
<tr id="row989359890090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1212280364090252"><a name="p1212280364090252"></a><a name="p1212280364090252"></a><a href="wifiiot.md#ga710155ea010eab98ef503abc7b0d7d2c">FlashRead</a> (const unsigned int flashOffset, const unsigned int size, unsigned char *ramData)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1988208962090252"><a name="p1988208962090252"></a><a name="p1988208962090252"></a>unsigned int </p>
<p id="p823585951090252"><a name="p823585951090252"></a><a name="p823585951090252"></a>Reads data from a flash memory address. </p>
</td>
</tr>
<tr id="row1364927595090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p816685414090252"><a name="p816685414090252"></a><a name="p816685414090252"></a><a href="wifiiot.md#gaf565413854f5b2581aa93a5e6143b04a">FlashWrite</a> (const unsigned int flashOffset, unsigned int size, const unsigned char *ramData, unsigned char doErase)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1852593367090252"><a name="p1852593367090252"></a><a name="p1852593367090252"></a>unsigned int </p>
<p id="p1472198572090252"><a name="p1472198572090252"></a><a name="p1472198572090252"></a>Writes data to a flash memory address. </p>
</td>
</tr>
<tr id="row1839583634090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p996190916090252"><a name="p996190916090252"></a><a name="p996190916090252"></a><a href="wifiiot.md#ga4f8879ba35704afb014eab657f2a6b29">FlashErase</a> (const unsigned int flashOffset, const unsigned int size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p826718859090252"><a name="p826718859090252"></a><a name="p826718859090252"></a>unsigned int </p>
<p id="p1377808385090252"><a name="p1377808385090252"></a><a name="p1377808385090252"></a>Erases data in a specified flash memory address. </p>
</td>
</tr>
<tr id="row354267556090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p543126286090252"><a name="p543126286090252"></a><a name="p543126286090252"></a><a href="wifiiot.md#ga1cf4ab1534ea2b52787838b59dd752cb">FlashInit</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1888470937090252"><a name="p1888470937090252"></a><a name="p1888470937090252"></a>unsigned int </p>
<p id="p123551430090252"><a name="p123551430090252"></a><a name="p123551430090252"></a>Initializes the flash device. </p>
</td>
</tr>
<tr id="row841545948090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1845524743090252"><a name="p1845524743090252"></a><a name="p1845524743090252"></a><a href="wifiiot.md#ga5241dc71f2e9fd54acb65ef52575740a">FlashDeinit</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1506064042090252"><a name="p1506064042090252"></a><a name="p1506064042090252"></a>unsigned int </p>
<p id="p498718405090252"><a name="p498718405090252"></a><a name="p498718405090252"></a>Deinitializes the flash device. </p>
</td>
</tr>
<tr id="row1506885084090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1685203140090252"><a name="p1685203140090252"></a><a name="p1685203140090252"></a><a href="wifiiot.md#ga74ae7c7cbfa0dd54840fe23f2a535786">FlashIoctl</a> (unsigned short cmd, char *data)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p521848874090252"><a name="p521848874090252"></a><a name="p521848874090252"></a>unsigned int </p>
<p id="p1623914039090252"><a name="p1623914039090252"></a><a name="p1623914039090252"></a>Obtains flash information based on a specific command. </p>
</td>
</tr>
<tr id="row1512978945090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p274395016090252"><a name="p274395016090252"></a><a name="p274395016090252"></a><a href="wifiiot.md#ga7a0c4f45b99870ae828a0d3f71561421">GpioInit</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p534900979090252"><a name="p534900979090252"></a><a name="p534900979090252"></a>unsigned int </p>
<p id="p871614395090252"><a name="p871614395090252"></a><a name="p871614395090252"></a>Initializes the GPIO device. </p>
</td>
</tr>
<tr id="row1192352439090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p622831588090252"><a name="p622831588090252"></a><a name="p622831588090252"></a><a href="wifiiot.md#ga2f829dbe36b81f093f43f59e3fa36212">GpioDeinit</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1170806780090252"><a name="p1170806780090252"></a><a name="p1170806780090252"></a>unsigned int </p>
<p id="p1152011988090252"><a name="p1152011988090252"></a><a name="p1152011988090252"></a>Deinitializes the GPIO device. </p>
</td>
</tr>
<tr id="row44559223090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1728495912090252"><a name="p1728495912090252"></a><a name="p1728495912090252"></a><a href="wifiiot.md#gabe3de0ab249704929ec95c82815e02b7">GpioSetDir</a> (<a href="wifiiot.md#gacb21f234cf149161f1f95f3330eeb8e7">WifiIotGpioIdx</a> id, <a href="wifiiot.md#gab4b1fb50c758d491ba297a65e1c7a70a">WifiIotGpioDir</a> dir)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1520383150090252"><a name="p1520383150090252"></a><a name="p1520383150090252"></a>unsigned int </p>
<p id="p1853473644090252"><a name="p1853473644090252"></a><a name="p1853473644090252"></a>Sets the direction for a GPIO pin. </p>
</td>
</tr>
<tr id="row1267600127090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p715972790090252"><a name="p715972790090252"></a><a name="p715972790090252"></a><a href="wifiiot.md#gafdd6f6a174bd31c3805a23dc923d8114">GpioGetDir</a> (<a href="wifiiot.md#gacb21f234cf149161f1f95f3330eeb8e7">WifiIotGpioIdx</a> id, <a href="wifiiot.md#gab4b1fb50c758d491ba297a65e1c7a70a">WifiIotGpioDir</a> *dir)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1355407282090252"><a name="p1355407282090252"></a><a name="p1355407282090252"></a>unsigned int </p>
<p id="p1692476913090252"><a name="p1692476913090252"></a><a name="p1692476913090252"></a>Obtains the direction for a GPIO pin. </p>
</td>
</tr>
<tr id="row439470608090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1486111490090252"><a name="p1486111490090252"></a><a name="p1486111490090252"></a><a href="wifiiot.md#ga13718f6a5c52a272baca64167b67606f">GpioSetOutputVal</a> (<a href="wifiiot.md#gacb21f234cf149161f1f95f3330eeb8e7">WifiIotGpioIdx</a> id, <a href="wifiiot.md#gac9095d1db72e5046b2ec1895aaec0e6b">WifiIotGpioValue</a> val)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1002034508090252"><a name="p1002034508090252"></a><a name="p1002034508090252"></a>unsigned int </p>
<p id="p1361700366090252"><a name="p1361700366090252"></a><a name="p1361700366090252"></a>Sets the output level value for a GPIO pin. </p>
</td>
</tr>
<tr id="row1778440044090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1051565977090252"><a name="p1051565977090252"></a><a name="p1051565977090252"></a><a href="wifiiot.md#gadea7c9475f510d00baa054364fd8de9a">GpioGetOutputVal</a> (<a href="wifiiot.md#gacb21f234cf149161f1f95f3330eeb8e7">WifiIotGpioIdx</a> id, <a href="wifiiot.md#gac9095d1db72e5046b2ec1895aaec0e6b">WifiIotGpioValue</a> *val)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p121712855090252"><a name="p121712855090252"></a><a name="p121712855090252"></a>unsigned int </p>
<p id="p1541782403090252"><a name="p1541782403090252"></a><a name="p1541782403090252"></a>Obtains the output level value of a GPIO pin. </p>
</td>
</tr>
<tr id="row194918587090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p776835511090252"><a name="p776835511090252"></a><a name="p776835511090252"></a><a href="wifiiot.md#gad63e45fa986b5dbcf3fb94f4fe7c3ee6">GpioGetInputVal</a> (<a href="wifiiot.md#gacb21f234cf149161f1f95f3330eeb8e7">WifiIotGpioIdx</a> id, <a href="wifiiot.md#gac9095d1db72e5046b2ec1895aaec0e6b">WifiIotGpioValue</a> *val)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1902050033090252"><a name="p1902050033090252"></a><a name="p1902050033090252"></a>unsigned int </p>
<p id="p227723954090252"><a name="p227723954090252"></a><a name="p227723954090252"></a>Obtains the input level value of a GPIO pin. </p>
</td>
</tr>
<tr id="row159655001090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p562459423090252"><a name="p562459423090252"></a><a name="p562459423090252"></a><a href="wifiiot.md#ga2eaec33b87a24bf1ae6b2a8d7ec38674">GpioRegisterIsrFunc</a> (<a href="wifiiot.md#gacb21f234cf149161f1f95f3330eeb8e7">WifiIotGpioIdx</a> id, <a href="wifiiot.md#gac8eb8ad448903ed52c96ccc675e81f94">WifiIotGpioIntType</a> intType, <a href="wifiiot.md#gab81589838cedcc3933bb789c97ad3643">WifiIotGpioIntPolarity</a> intPolarity, <a href="wifiiot.md#ga93120443d8150e18701ce6d3dd290408">GpioIsrCallbackFunc</a> func, char *arg)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1447354298090252"><a name="p1447354298090252"></a><a name="p1447354298090252"></a>unsigned int </p>
<p id="p1277472546090252"><a name="p1277472546090252"></a><a name="p1277472546090252"></a>Enables the interrupt function for a GPIO pin. </p>
</td>
</tr>
<tr id="row1572376040090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1595548558090252"><a name="p1595548558090252"></a><a name="p1595548558090252"></a><a href="wifiiot.md#ga403b7bb8037ae1415d5d0dd623379e50">GpioUnregisterIsrFunc</a> (<a href="wifiiot.md#gacb21f234cf149161f1f95f3330eeb8e7">WifiIotGpioIdx</a> id)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p158031491090252"><a name="p158031491090252"></a><a name="p158031491090252"></a>unsigned int </p>
<p id="p624573243090252"><a name="p624573243090252"></a><a name="p624573243090252"></a>Disables the interrupt function for a GPIO pin. </p>
</td>
</tr>
<tr id="row579384156090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1380771589090252"><a name="p1380771589090252"></a><a name="p1380771589090252"></a><a href="wifiiot.md#ga3d2e70a9ffded1937e7423cf59e0f40f">GpioSetIsrMask</a> (<a href="wifiiot.md#gacb21f234cf149161f1f95f3330eeb8e7">WifiIotGpioIdx</a> id, unsigned char mask)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1593375908090252"><a name="p1593375908090252"></a><a name="p1593375908090252"></a>unsigned int </p>
<p id="p1305627541090252"><a name="p1305627541090252"></a><a name="p1305627541090252"></a>Masks the interrupt function for a GPIO pin. </p>
</td>
</tr>
<tr id="row302277669090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p697856180090252"><a name="p697856180090252"></a><a name="p697856180090252"></a><a href="wifiiot.md#ga400c1978a35742c101881aa825749152">GpioSetIsrMode</a> (<a href="wifiiot.md#gacb21f234cf149161f1f95f3330eeb8e7">WifiIotGpioIdx</a> id, <a href="wifiiot.md#gac8eb8ad448903ed52c96ccc675e81f94">WifiIotGpioIntType</a> intType, <a href="wifiiot.md#gab81589838cedcc3933bb789c97ad3643">WifiIotGpioIntPolarity</a> intPolarity)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p654627895090252"><a name="p654627895090252"></a><a name="p654627895090252"></a>unsigned int </p>
<p id="p1716867862090252"><a name="p1716867862090252"></a><a name="p1716867862090252"></a>Sets the interrupt trigger mode of a GPIO pin. </p>
</td>
</tr>
<tr id="row1972406202090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p390222594090252"><a name="p390222594090252"></a><a name="p390222594090252"></a><a href="wifiiot.md#ga372f6e774614f5b4e7280c9e564be5a2">IoSetPull</a> (<a href="wifiiot.md#ga2f42c70f1dd8a04746e30a97b3dfc415">WifiIotIoName</a> id, <a href="wifiiot.md#gacc20a5c6456ec381ed931232c29d1c4f">WifiIotIoPull</a> val)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2069859337090252"><a name="p2069859337090252"></a><a name="p2069859337090252"></a>unsigned int </p>
<p id="p709146524090252"><a name="p709146524090252"></a><a name="p709146524090252"></a>Sets the pull for a GPIO pin. </p>
</td>
</tr>
<tr id="row872580002090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1755671303090252"><a name="p1755671303090252"></a><a name="p1755671303090252"></a><a href="wifiiot.md#ga706a98bedbef79002c43efcb98b841ab">IoSetFunc</a> (<a href="wifiiot.md#ga2f42c70f1dd8a04746e30a97b3dfc415">WifiIotIoName</a> id, unsigned char val)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1892014202090252"><a name="p1892014202090252"></a><a name="p1892014202090252"></a>unsigned int </p>
<p id="p1604146770090252"><a name="p1604146770090252"></a><a name="p1604146770090252"></a>Sets the multiplexing function for a GPIO pin. </p>
</td>
</tr>
<tr id="row729538024090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1044599408090252"><a name="p1044599408090252"></a><a name="p1044599408090252"></a><a href="wifiiot.md#ga899a2d8d5a058bcd9d32dbce43a9dbb2">IoGetPull</a> (<a href="wifiiot.md#ga2f42c70f1dd8a04746e30a97b3dfc415">WifiIotIoName</a> id, <a href="wifiiot.md#gacc20a5c6456ec381ed931232c29d1c4f">WifiIotIoPull</a> *val)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p668647738090252"><a name="p668647738090252"></a><a name="p668647738090252"></a>unsigned int </p>
<p id="p489085529090252"><a name="p489085529090252"></a><a name="p489085529090252"></a>Obtains the pull type of a GPIO pin. </p>
</td>
</tr>
<tr id="row1171246519090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1813435537090252"><a name="p1813435537090252"></a><a name="p1813435537090252"></a><a href="wifiiot.md#ga4131898393c55a07abf254dc7f2a9541">IoGetFunc</a> (<a href="wifiiot.md#ga2f42c70f1dd8a04746e30a97b3dfc415">WifiIotIoName</a> id, unsigned char *val)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p929838065090252"><a name="p929838065090252"></a><a name="p929838065090252"></a>unsigned int </p>
<p id="p1541043693090252"><a name="p1541043693090252"></a><a name="p1541043693090252"></a>Obtains the multiplexing function for a GPIO pin. </p>
</td>
</tr>
<tr id="row373001358090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1272084730090252"><a name="p1272084730090252"></a><a name="p1272084730090252"></a><a href="wifiiot.md#ga64e637417c653b431c67cf4445fc8e65">IOGetDriverStrength</a> (<a href="wifiiot.md#ga2f42c70f1dd8a04746e30a97b3dfc415">WifiIotIoName</a> id, <a href="wifiiot.md#gae97ab4109f511ceeee889dba9e79a968">WifiIotIoDriverStrength</a> *val)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p347943470090252"><a name="p347943470090252"></a><a name="p347943470090252"></a>unsigned int </p>
<p id="p1944765165090252"><a name="p1944765165090252"></a><a name="p1944765165090252"></a>Obtains the driver strength of a GPIO pin. </p>
</td>
</tr>
<tr id="row1010605871090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1831871517090252"><a name="p1831871517090252"></a><a name="p1831871517090252"></a><a href="wifiiot.md#ga631065a13f9794dc0b4de4870e62cfaa">IOSetDriverStrength</a> (<a href="wifiiot.md#ga2f42c70f1dd8a04746e30a97b3dfc415">WifiIotIoName</a> id, <a href="wifiiot.md#gae97ab4109f511ceeee889dba9e79a968">WifiIotIoDriverStrength</a> val)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1453310533090252"><a name="p1453310533090252"></a><a name="p1453310533090252"></a>unsigned int </p>
<p id="p834177833090252"><a name="p834177833090252"></a><a name="p834177833090252"></a>Sets the driver strength of a GPIO pin. </p>
</td>
</tr>
<tr id="row31464839090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p926735480090252"><a name="p926735480090252"></a><a name="p926735480090252"></a><a href="wifiiot.md#ga01f5b9b16ad378ad1ad5d3ee37d0c4c0">I2cInit</a> (<a href="wifiiot.md#gaeeb58e02e3783d02e1ed4bad313cc0b8">WifiIotI2cIdx</a> id, unsigned int baudrate)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p797256143090252"><a name="p797256143090252"></a><a name="p797256143090252"></a>unsigned int </p>
<p id="p1861180982090252"><a name="p1861180982090252"></a><a name="p1861180982090252"></a>Initializes an I2C device with a specified baud rate. </p>
</td>
</tr>
<tr id="row1815028791090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1434902395090252"><a name="p1434902395090252"></a><a name="p1434902395090252"></a><a href="wifiiot.md#gaaa7f69e289e203f40bff4289bc8e332f">I2cDeinit</a> (<a href="wifiiot.md#gaeeb58e02e3783d02e1ed4bad313cc0b8">WifiIotI2cIdx</a> id)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p624883846090252"><a name="p624883846090252"></a><a name="p624883846090252"></a>unsigned int </p>
<p id="p944187106090252"><a name="p944187106090252"></a><a name="p944187106090252"></a>Deinitializes an I2C device. </p>
</td>
</tr>
<tr id="row911348801090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1965354275090252"><a name="p1965354275090252"></a><a name="p1965354275090252"></a><a href="wifiiot.md#ga0c72d160332184ddddc264411e00fcc9">I2cWrite</a> (<a href="wifiiot.md#gaeeb58e02e3783d02e1ed4bad313cc0b8">WifiIotI2cIdx</a> id, unsigned short deviceAddr, const <a href="wifiioti2cdata.md">WifiIotI2cData</a> *i2cData)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p760841665090252"><a name="p760841665090252"></a><a name="p760841665090252"></a>unsigned int </p>
<p id="p53807140090252"><a name="p53807140090252"></a><a name="p53807140090252"></a>Writes data to an I2C device. </p>
</td>
</tr>
<tr id="row1475292270090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p137809277090252"><a name="p137809277090252"></a><a name="p137809277090252"></a><a href="wifiiot.md#gac058f6ee969c5873280c11220d04f026">I2cRead</a> (<a href="wifiiot.md#gaeeb58e02e3783d02e1ed4bad313cc0b8">WifiIotI2cIdx</a> id, unsigned short deviceAddr, const <a href="wifiioti2cdata.md">WifiIotI2cData</a> *i2cData)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1407429197090252"><a name="p1407429197090252"></a><a name="p1407429197090252"></a>unsigned int </p>
<p id="p749143682090252"><a name="p749143682090252"></a><a name="p749143682090252"></a>Reads data from an I2C device. </p>
</td>
</tr>
<tr id="row552531596090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p408857522090252"><a name="p408857522090252"></a><a name="p408857522090252"></a><a href="wifiiot.md#gae4c60ea6732bbee9f779540cb431fe85">I2cWriteread</a> (<a href="wifiiot.md#gaeeb58e02e3783d02e1ed4bad313cc0b8">WifiIotI2cIdx</a> id, unsigned short deviceAddr, const <a href="wifiioti2cdata.md">WifiIotI2cData</a> *i2cData)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p40807010090252"><a name="p40807010090252"></a><a name="p40807010090252"></a>unsigned int </p>
<p id="p866213319090252"><a name="p866213319090252"></a><a name="p866213319090252"></a>Sends data to and receives data responses from an I2C device. </p>
</td>
</tr>
<tr id="row2034549401090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1286574944090252"><a name="p1286574944090252"></a><a name="p1286574944090252"></a><a href="wifiiot.md#ga76d3fad576fe209eedb203bc61ad4f6b">I2cRegisterResetBusFunc</a> (<a href="wifiiot.md#gaeeb58e02e3783d02e1ed4bad313cc0b8">WifiIotI2cIdx</a> id, <a href="wifiioti2cfunc.md">WifiIotI2cFunc</a> pfn)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1124563218090252"><a name="p1124563218090252"></a><a name="p1124563218090252"></a>void </p>
<p id="p772862420090252"><a name="p772862420090252"></a><a name="p772862420090252"></a>Registers an I2C callback. </p>
</td>
</tr>
<tr id="row854065084090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1395461779090252"><a name="p1395461779090252"></a><a name="p1395461779090252"></a><a href="wifiiot.md#gaf4962dc9dd012c125294fe5683955454">I2cSetBaudrate</a> (<a href="wifiiot.md#gaeeb58e02e3783d02e1ed4bad313cc0b8">WifiIotI2cIdx</a> id, unsigned int baudrate)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p496571949090252"><a name="p496571949090252"></a><a name="p496571949090252"></a>unsigned int </p>
<p id="p564234599090252"><a name="p564234599090252"></a><a name="p564234599090252"></a>Sets the baud rate for an I2C device. </p>
</td>
</tr>
<tr id="row230650976090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1190278489090252"><a name="p1190278489090252"></a><a name="p1190278489090252"></a><a href="wifiiot.md#gaab1affd53de2567a6eb3803649d1c706">I2sInit</a> (const <a href="wifiioti2sattribute.md">WifiIotI2sAttribute</a> *i2sAttribute)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1636753758090252"><a name="p1636753758090252"></a><a name="p1636753758090252"></a>unsigned int </p>
<p id="p1989573532090252"><a name="p1989573532090252"></a><a name="p1989573532090252"></a>Initializes the I2S device. </p>
</td>
</tr>
<tr id="row474990228090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p117255692090252"><a name="p117255692090252"></a><a name="p117255692090252"></a><a href="wifiiot.md#ga2f47b7e0c350d305cb0b495bda78450c">I2sDeinit</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2081011976090252"><a name="p2081011976090252"></a><a name="p2081011976090252"></a>unsigned int </p>
<p id="p1075418629090252"><a name="p1075418629090252"></a><a name="p1075418629090252"></a>Deinitializes the I2S device. </p>
</td>
</tr>
<tr id="row1571404869090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p96922985090252"><a name="p96922985090252"></a><a name="p96922985090252"></a><a href="wifiiot.md#gad30ea8ed658514b8864ab8ddba4fd4f0">I2sWrite</a> (unsigned char *wrData, unsigned int wrLen, unsigned int timeOutMs)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p77532756090252"><a name="p77532756090252"></a><a name="p77532756090252"></a>unsigned int </p>
<p id="p1199083724090252"><a name="p1199083724090252"></a><a name="p1199083724090252"></a>Writes data to the I2S device. </p>
</td>
</tr>
<tr id="row1777799027090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p57559640090252"><a name="p57559640090252"></a><a name="p57559640090252"></a><a href="wifiiot.md#ga8d2e8cc248252007325cace65bedb742">I2sRead</a> (unsigned char *rdData, unsigned int rdLen, unsigned int timeOutMs)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1328601133090252"><a name="p1328601133090252"></a><a name="p1328601133090252"></a>unsigned int </p>
<p id="p59237596090252"><a name="p59237596090252"></a><a name="p59237596090252"></a>Reads data from the I2S device. </p>
</td>
</tr>
<tr id="row1917541366090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p891749776090252"><a name="p891749776090252"></a><a name="p891749776090252"></a><a href="wifiiot.md#ga08e802255973f1fe58cbe59f03e1e2a8">KalTickRegisterCallback</a> (<a href="wifiiot.md#ga8be54bbf12f538188db10aaaf4bdbdf9">TickIdleKalCallback</a> cb)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p503057182090252"><a name="p503057182090252"></a><a name="p503057182090252"></a>void </p>
<p id="p888832427090252"><a name="p888832427090252"></a><a name="p888832427090252"></a>Registers the CPU tick callback. </p>
</td>
</tr>
<tr id="row1473272818090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1598230213090252"><a name="p1598230213090252"></a><a name="p1598230213090252"></a><a href="wifiiot.md#ga2cb2a204b7f242f4b387896924883de2">KalThreadRegisterIdleCallback</a> (<a href="wifiiot.md#ga8be54bbf12f538188db10aaaf4bdbdf9">TickIdleKalCallback</a> cb)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1710435816090252"><a name="p1710435816090252"></a><a name="p1710435816090252"></a>void </p>
<p id="p1644714311090252"><a name="p1644714311090252"></a><a name="p1644714311090252"></a>Registers the idle task callback. </p>
</td>
</tr>
<tr id="row929727418090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p757258089090252"><a name="p757258089090252"></a><a name="p757258089090252"></a><a href="wifiiot.md#ga89c372b7c3071619dfe5b05d3e779e9e">FlashPartitionInit</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p41610730090252"><a name="p41610730090252"></a><a name="p41610730090252"></a>unsigned int </p>
<p id="p98291567090252"><a name="p98291567090252"></a><a name="p98291567090252"></a>Initializes a flash partition. </p>
</td>
</tr>
<tr id="row1600078690090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1828787002090252"><a name="p1828787002090252"></a><a name="p1828787002090252"></a><a href="wifiiot.md#ga1279111f8892710f1a84bb03fd8df2be">GetPartitionTable</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1653349412090252"><a name="p1653349412090252"></a><a name="p1653349412090252"></a><a href="wifiiotflashpartitiontable.md">WifiIotFlashPartitionTable</a> * </p>
<p id="p517851603090252"><a name="p517851603090252"></a><a name="p517851603090252"></a>Obtains a flash partition table. </p>
</td>
</tr>
<tr id="row46318441090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2051083097090252"><a name="p2051083097090252"></a><a name="p2051083097090252"></a><a href="wifiiot.md#ga27d50a2258388ba88ed35581096fb5eb">PwmInit</a> (<a href="wifiiot.md#gab3518ce878df4a40d614e88a6f81dea7">WifiIotPwmPort</a> port)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1288183791090252"><a name="p1288183791090252"></a><a name="p1288183791090252"></a>unsigned int </p>
<p id="p438913514090252"><a name="p438913514090252"></a><a name="p438913514090252"></a>Initializes a PWM device. </p>
</td>
</tr>
<tr id="row2072156177090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1383506998090252"><a name="p1383506998090252"></a><a name="p1383506998090252"></a><a href="wifiiot.md#gac63da03016596aed4234e9c4053c15b9">PwmDeinit</a> (<a href="wifiiot.md#gab3518ce878df4a40d614e88a6f81dea7">WifiIotPwmPort</a> port)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p132080297090252"><a name="p132080297090252"></a><a name="p132080297090252"></a>unsigned int </p>
<p id="p1709411502090252"><a name="p1709411502090252"></a><a name="p1709411502090252"></a>Deinitializes a PWM device. </p>
</td>
</tr>
<tr id="row1708174284090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1527906018090252"><a name="p1527906018090252"></a><a name="p1527906018090252"></a><a href="wifiiot.md#gae853022c27750fcdb9a2c60653761afe">PwmStart</a> (<a href="wifiiot.md#gab3518ce878df4a40d614e88a6f81dea7">WifiIotPwmPort</a> port, unsigned short duty, unsigned short freq)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1151868526090252"><a name="p1151868526090252"></a><a name="p1151868526090252"></a>unsigned int </p>
<p id="p1215713791090252"><a name="p1215713791090252"></a><a name="p1215713791090252"></a>Outputs PWM signals based on the input parameters. </p>
</td>
</tr>
<tr id="row1166001441090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1124641415090252"><a name="p1124641415090252"></a><a name="p1124641415090252"></a><a href="wifiiot.md#ga158474c4e73c1e557352c12cc31a154f">PwmStop</a> (<a href="wifiiot.md#gab3518ce878df4a40d614e88a6f81dea7">WifiIotPwmPort</a> port)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1499065764090252"><a name="p1499065764090252"></a><a name="p1499065764090252"></a>unsigned int </p>
<p id="p763709939090252"><a name="p763709939090252"></a><a name="p763709939090252"></a>Stops the PWM signal output. </p>
</td>
</tr>
<tr id="row2135380662090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1459640363090252"><a name="p1459640363090252"></a><a name="p1459640363090252"></a><a href="wifiiot.md#gaad3bec1e62fb695ed4b8f0627b3f4e84">SdioInit</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p468609448090252"><a name="p468609448090252"></a><a name="p468609448090252"></a>unsigned int </p>
<p id="p1537336184090252"><a name="p1537336184090252"></a><a name="p1537336184090252"></a>Initializes the SDIO device. </p>
</td>
</tr>
<tr id="row1578751228090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1330772004090252"><a name="p1330772004090252"></a><a name="p1330772004090252"></a><a href="wifiiot.md#ga7093b6e5941cedd1d3fa706500fb3c66">SdioReinit</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p620415839090252"><a name="p620415839090252"></a><a name="p620415839090252"></a>unsigned int </p>
<p id="p1010769789090252"><a name="p1010769789090252"></a><a name="p1010769789090252"></a>Reinitializes the SDIO device. </p>
</td>
</tr>
<tr id="row263739393090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1469581144090252"><a name="p1469581144090252"></a><a name="p1469581144090252"></a><a href="wifiiot.md#ga180aae06228682aee1e7ac335498c94f">SdioSoftReset</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1884449644090252"><a name="p1884449644090252"></a><a name="p1884449644090252"></a>void </p>
<p id="p1521127672090252"><a name="p1521127672090252"></a><a name="p1521127672090252"></a>Resets the SDIO device. </p>
</td>
</tr>
<tr id="row1329813471090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p704033698090252"><a name="p704033698090252"></a><a name="p704033698090252"></a><a href="wifiiot.md#ga8d8b7169c2668a0be5f3870e12d41071">SdioRegisterCallback</a> (const <a href="wifiiotsdiointcallback.md">WifiIotSdioIntcallback</a> *callbackFunc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p973704516090252"><a name="p973704516090252"></a><a name="p973704516090252"></a>unsigned int </p>
<p id="p148367959090252"><a name="p148367959090252"></a><a name="p148367959090252"></a>Registers an interrupt callback for the SDIO device. </p>
</td>
</tr>
<tr id="row1646893881090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1817438646090252"><a name="p1817438646090252"></a><a name="p1817438646090252"></a><a href="wifiiot.md#ga2615d7d406366292f8b2fd445d841971">SdioCompleteSend</a> (unsigned char *admaTable, unsigned int admaIndex)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p323260956090252"><a name="p323260956090252"></a><a name="p323260956090252"></a>unsigned int </p>
<p id="p768067668090252"><a name="p768067668090252"></a><a name="p768067668090252"></a>Completes data sending on the SDIO device. </p>
</td>
</tr>
<tr id="row1615280800090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1916065382090252"><a name="p1916065382090252"></a><a name="p1916065382090252"></a><a href="wifiiot.md#ga257b72a879ec478d9434d2a2a2a69281">SdioSetPadAdmatab</a> (unsigned int padlen, unsigned char *admatable, unsigned int admaIndex)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1765468923090252"><a name="p1765468923090252"></a><a name="p1765468923090252"></a>unsigned int </p>
<p id="p1472244086090252"><a name="p1472244086090252"></a><a name="p1472244086090252"></a>Sets the ADMA table that requires data padding. </p>
</td>
</tr>
<tr id="row155322815090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1790229928090252"><a name="p1790229928090252"></a><a name="p1790229928090252"></a><a href="wifiiot.md#ga79d11f1582ccd79d55e28c4a3c3896ad">SdioWriteExtinfo</a> (<a href="wifiiotsdioextendfunc.md">WifiIotSdioExtendFunc</a> *extFunc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p69874220090252"><a name="p69874220090252"></a><a name="p69874220090252"></a>unsigned int </p>
<p id="p1543054312090252"><a name="p1543054312090252"></a><a name="p1543054312090252"></a>Sets the extended SDIO attributes. </p>
</td>
</tr>
<tr id="row548249604090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p184953115090252"><a name="p184953115090252"></a><a name="p184953115090252"></a><a href="wifiiot.md#ga5a38e3c0f2848972cbe736980ea6e355">SdioSendData</a> (unsigned int xferBytes)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1530932111090252"><a name="p1530932111090252"></a><a name="p1530932111090252"></a>void </p>
<p id="p1241198177090252"><a name="p1241198177090252"></a><a name="p1241198177090252"></a>Starts to send data. </p>
</td>
</tr>
<tr id="row374361142090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1826775940090252"><a name="p1826775940090252"></a><a name="p1826775940090252"></a><a href="wifiiot.md#gadbd7176d96c0a92bc8dd3186d5e56044">SdioSetAdmatable</a> (unsigned char *admatable, unsigned int admaIndex, const unsigned int *dataAddr, unsigned int dataLen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p505684406090252"><a name="p505684406090252"></a><a name="p505684406090252"></a>unsigned int </p>
<p id="p638450874090252"><a name="p638450874090252"></a><a name="p638450874090252"></a>Sets an SDIO ADMA. </p>
</td>
</tr>
<tr id="row653890295090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1656943004090252"><a name="p1656943004090252"></a><a name="p1656943004090252"></a><a href="wifiiot.md#ga6ce36235d20976c2f4668798de3fd0fb">SdioSchedMsg</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p958193037090252"><a name="p958193037090252"></a><a name="p958193037090252"></a>unsigned int </p>
<p id="p411051765090252"><a name="p411051765090252"></a><a name="p411051765090252"></a>Sends a suspended SDIO message. </p>
</td>
</tr>
<tr id="row387636574090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1444030013090252"><a name="p1444030013090252"></a><a name="p1444030013090252"></a><a href="wifiiot.md#ga475a381fc4b9357aee48386bd1825d28">SdioSendSyncMsg</a> (unsigned int msg)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1839040278090252"><a name="p1839040278090252"></a><a name="p1839040278090252"></a>unsigned int </p>
<p id="p1995105791090252"><a name="p1995105791090252"></a><a name="p1995105791090252"></a>Adds a message to a message queue and sends the message. </p>
</td>
</tr>
<tr id="row890190813090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p638757899090252"><a name="p638757899090252"></a><a name="p638757899090252"></a><a href="wifiiot.md#gae8c8a1b4725d9f291fbf17e2760e5bb9">SdioSendMsgAck</a> (unsigned int msg)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p391604326090252"><a name="p391604326090252"></a><a name="p391604326090252"></a>unsigned int </p>
<p id="p935344973090252"><a name="p935344973090252"></a><a name="p935344973090252"></a>Sends a specified message. </p>
</td>
</tr>
<tr id="row859126208090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p968672179090252"><a name="p968672179090252"></a><a name="p968672179090252"></a><a href="wifiiot.md#ga1e8370bf332882774ca34d6a9b4164b8">SdioProcessMsg</a> (unsigned int sendMsg, unsigned int clearMsg)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1627416785090252"><a name="p1627416785090252"></a><a name="p1627416785090252"></a>unsigned int </p>
<p id="p1675230732090252"><a name="p1675230732090252"></a><a name="p1675230732090252"></a>Clears a specified suspended message in the message queue, adds a new message to it, and sends the new message. </p>
</td>
</tr>
<tr id="row1576894813090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1126086366090252"><a name="p1126086366090252"></a><a name="p1126086366090252"></a><a href="wifiiot.md#gafc188bce50a808f7ebd6641d01725602">SdioIsPendingMsg</a> (unsigned int msg)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p466780775090252"><a name="p466780775090252"></a><a name="p466780775090252"></a>unsigned int </p>
<p id="p1689431150090252"><a name="p1689431150090252"></a><a name="p1689431150090252"></a>Checks whether a specified message is suspended. </p>
</td>
</tr>
<tr id="row1324723785090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p589867330090252"><a name="p589867330090252"></a><a name="p589867330090252"></a><a href="wifiiot.md#ga5ee18bbecf0f451068e943f44ada8b9c">SdioIsSendingMsg</a> (unsigned int msg)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p533326553090252"><a name="p533326553090252"></a><a name="p533326553090252"></a>unsigned int </p>
<p id="p1516364272090252"><a name="p1516364272090252"></a><a name="p1516364272090252"></a>Checks whether a specified message is being sent. </p>
</td>
</tr>
<tr id="row2128750755090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p839041460090252"><a name="p839041460090252"></a><a name="p839041460090252"></a><a href="wifiiot.md#gac4b082298d466441c68e0e916f92dc03">SdioGetExtendInfo</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p711547060090252"><a name="p711547060090252"></a><a name="p711547060090252"></a><a href="wifiiotsdioextendfunc.md">WifiIotSdioExtendFunc</a> * </p>
<p id="p654030158090252"><a name="p654030158090252"></a><a name="p654030158090252"></a>Obtains the extended configuration. </p>
</td>
</tr>
<tr id="row600356169090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p568495743090252"><a name="p568495743090252"></a><a name="p568495743090252"></a><a href="wifiiot.md#gae8925d25b4fc160d0fa9760c28c87e84">SdioRegisterNotifyMessageCallback</a> (<a href="wifiiot.md#ga133bb67c0fa6e9dcab35f00edff68e58">NotifyHostMessageEvent</a> msgEventCallback)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p262824229090252"><a name="p262824229090252"></a><a name="p262824229090252"></a>void </p>
<p id="p1059378480090252"><a name="p1059378480090252"></a><a name="p1059378480090252"></a>Registers the callback that will be invoked when the host sends a message or data. </p>
</td>
</tr>
<tr id="row748417679090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p93668598090252"><a name="p93668598090252"></a><a name="p93668598090252"></a><a href="wifiiot.md#gaa507e3ae762f43b644c716aa5385172a">SdioSetPowerdownWhenDeepSleep</a> (unsigned char powerDown)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2141210318090252"><a name="p2141210318090252"></a><a name="p2141210318090252"></a>void </p>
<p id="p541344000090252"><a name="p541344000090252"></a><a name="p541344000090252"></a>Sets whether the SDIO device is powered off in deep sleep mode. </p>
</td>
</tr>
<tr id="row910000615090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2097363488090252"><a name="p2097363488090252"></a><a name="p2097363488090252"></a><a href="wifiiot.md#gabc5bfa19d08bcbd824a81cfdb476bc03">SpiSlaveWrite</a> (<a href="wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b">WifiIotSpiIdx</a> spiId, char *writeData, unsigned int byteLen, unsigned int timeOutMs)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1659374718090252"><a name="p1659374718090252"></a><a name="p1659374718090252"></a>unsigned int </p>
<p id="p683930872090252"><a name="p683930872090252"></a><a name="p683930872090252"></a>Sends data in SPI slave mode. </p>
</td>
</tr>
<tr id="row700434431090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p834328266090252"><a name="p834328266090252"></a><a name="p834328266090252"></a><a href="wifiiot.md#gaf6b980dbae9b819c801db16cd933379d">SpiSlaveRead</a> (<a href="wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b">WifiIotSpiIdx</a> spiId, char *readData, unsigned int byteLen, unsigned int timeOutMs)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p611299628090252"><a name="p611299628090252"></a><a name="p611299628090252"></a>unsigned int </p>
<p id="p914681651090252"><a name="p914681651090252"></a><a name="p914681651090252"></a>Reads data in SPI slave mode. </p>
</td>
</tr>
<tr id="row1157421407090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1988139301090252"><a name="p1988139301090252"></a><a name="p1988139301090252"></a><a href="wifiiot.md#ga9b550208916b4fa86385768cc81e0c5b">SpiHostWrite</a> (<a href="wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b">WifiIotSpiIdx</a> spiId, char *writeData, unsigned int byteLen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p206259718090252"><a name="p206259718090252"></a><a name="p206259718090252"></a>unsigned int </p>
<p id="p123616944090252"><a name="p123616944090252"></a><a name="p123616944090252"></a>Sends data in half-duplex SPI master mode. </p>
</td>
</tr>
<tr id="row345472957090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1056132159090252"><a name="p1056132159090252"></a><a name="p1056132159090252"></a><a href="wifiiot.md#ga72b7cd1ad546f88982385c5ca054580d">SpiHostRead</a> (<a href="wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b">WifiIotSpiIdx</a> spiId, char *readData, unsigned int byteLen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p189051138090252"><a name="p189051138090252"></a><a name="p189051138090252"></a>unsigned int </p>
<p id="p302483133090252"><a name="p302483133090252"></a><a name="p302483133090252"></a>Reads data in half-duplex SPI master mode. </p>
</td>
</tr>
<tr id="row406659494090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2079238777090252"><a name="p2079238777090252"></a><a name="p2079238777090252"></a><a href="wifiiot.md#ga3ad87923c61c537f8366da76d6384dd1">SpiHostWriteread</a> (<a href="wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b">WifiIotSpiIdx</a> spiId, char *writeData, char *readData, unsigned int byteLen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1658160105090252"><a name="p1658160105090252"></a><a name="p1658160105090252"></a>unsigned int </p>
<p id="p2009444069090252"><a name="p2009444069090252"></a><a name="p2009444069090252"></a>Sends and reads data in full-duplex SPI master mode. </p>
</td>
</tr>
<tr id="row1293411363090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2110112561090252"><a name="p2110112561090252"></a><a name="p2110112561090252"></a><a href="wifiiot.md#ga7218dd7e5ae463ce2c29a6952c100893">SpiSetBasicInfo</a> (<a href="wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b">WifiIotSpiIdx</a> spiId, const <a href="wifiiotspicfgbasicinfo.md">WifiIotSpiCfgBasicInfo</a> *param)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1417355779090252"><a name="p1417355779090252"></a><a name="p1417355779090252"></a>unsigned int </p>
<p id="p1079754828090252"><a name="p1079754828090252"></a><a name="p1079754828090252"></a>Sets the SPI channel parameter. </p>
</td>
</tr>
<tr id="row1117401834090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p731577864090252"><a name="p731577864090252"></a><a name="p731577864090252"></a><a href="wifiiot.md#gafb1a0999baf079d2907b73554f3fe458">SpiInit</a> (<a href="wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b">WifiIotSpiIdx</a> spiId, <a href="wifiiotspicfginitparam.md">WifiIotSpiCfgInitParam</a> initParam, const <a href="wifiiotspicfgbasicinfo.md">WifiIotSpiCfgBasicInfo</a> *param)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1711352526090252"><a name="p1711352526090252"></a><a name="p1711352526090252"></a>unsigned int </p>
<p id="p688723196090252"><a name="p688723196090252"></a><a name="p688723196090252"></a>Initializes an SPI device. </p>
</td>
</tr>
<tr id="row282164859090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1085681807090252"><a name="p1085681807090252"></a><a name="p1085681807090252"></a><a href="wifiiot.md#ga1e39213f9d9fa488eaf9f172ab675b24">SpiDeinit</a> (<a href="wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b">WifiIotSpiIdx</a> spiId)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1232412912090252"><a name="p1232412912090252"></a><a name="p1232412912090252"></a>unsigned int </p>
<p id="p538273800090252"><a name="p538273800090252"></a><a name="p538273800090252"></a>Deinitializes an SPI device. </p>
</td>
</tr>
<tr id="row359073930090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1351563648090252"><a name="p1351563648090252"></a><a name="p1351563648090252"></a><a href="wifiiot.md#gaea32f9be9e75da8ee8ae342c513ccbfb">SpiSetIrqMode</a> (<a href="wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b">WifiIotSpiIdx</a> spiId, unsigned char irqEn)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2058289644090252"><a name="p2058289644090252"></a><a name="p2058289644090252"></a>unsigned int </p>
<p id="p445150636090252"><a name="p445150636090252"></a><a name="p445150636090252"></a>Sets whether to enable the interrupt request (IRQ) mode for an SPI device. </p>
</td>
</tr>
<tr id="row1118821845090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1384300946090252"><a name="p1384300946090252"></a><a name="p1384300946090252"></a><a href="wifiiot.md#ga607d3d5b1f69cb89183566fb1d23f4cc">SpiSetDmaMode</a> (<a href="wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b">WifiIotSpiIdx</a> spiId, unsigned char dmaEn)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p962188682090252"><a name="p962188682090252"></a><a name="p962188682090252"></a>unsigned int </p>
<p id="p626743225090252"><a name="p626743225090252"></a><a name="p626743225090252"></a>Sets whether to enable DMA to transfer data for an SPI device in slave mode. </p>
</td>
</tr>
<tr id="row1297549408090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1979059906090252"><a name="p1979059906090252"></a><a name="p1979059906090252"></a><a href="wifiiot.md#ga35305efc779b6386532fdb7a96fc5a1a">SpiRegisterUsrFunc</a> (<a href="wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b">WifiIotSpiIdx</a> spiId, <a href="wifiiot.md#gad1acc3e9c9d1c63f70aeb9d5201ed1f0">SpiIsrFunc</a> prepareF, <a href="wifiiot.md#gad1acc3e9c9d1c63f70aeb9d5201ed1f0">SpiIsrFunc</a> restoreF)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1683237058090252"><a name="p1683237058090252"></a><a name="p1683237058090252"></a>unsigned int </p>
<p id="p68408752090252"><a name="p68408752090252"></a><a name="p68408752090252"></a>Registers the data TX preparation/recovery function. </p>
</td>
</tr>
<tr id="row48774672090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1296092051090252"><a name="p1296092051090252"></a><a name="p1296092051090252"></a><a href="wifiiot.md#ga42dad507650369b456549515d73d75a1">SpiSetLoopBackMode</a> (<a href="wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b">WifiIotSpiIdx</a> spiId, unsigned char lbEn)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1668756566090252"><a name="p1668756566090252"></a><a name="p1668756566090252"></a>unsigned int </p>
<p id="p1126859753090252"><a name="p1126859753090252"></a><a name="p1126859753090252"></a>Sets whether to enable loopback test for an SPI device. </p>
</td>
</tr>
<tr id="row170458885090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p992957459090252"><a name="p992957459090252"></a><a name="p992957459090252"></a><a href="wifiiot.md#gabd8789246727fe776404b03814822376">UartInit</a> (<a href="wifiiot.md#ga2699252424e5469ef243ae279a263c44">WifiIotUartIdx</a> id, const <a href="wifiiotuartattribute.md">WifiIotUartAttribute</a> *param, const <a href="wifiiotuartextraattr.md">WifiIotUartExtraAttr</a> *extraAttr)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1235815576090252"><a name="p1235815576090252"></a><a name="p1235815576090252"></a>unsigned int </p>
<p id="p584062220090252"><a name="p584062220090252"></a><a name="p584062220090252"></a>Configures a UART device. </p>
</td>
</tr>
<tr id="row2127725144090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p184999474090252"><a name="p184999474090252"></a><a name="p184999474090252"></a><a href="wifiiot.md#ga048ac867ce0e1cac9b588840e8a50d1d">UartRead</a> (<a href="wifiiot.md#ga2699252424e5469ef243ae279a263c44">WifiIotUartIdx</a> id, unsigned char *data, unsigned int dataLen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1325157930090252"><a name="p1325157930090252"></a><a name="p1325157930090252"></a>int </p>
<p id="p1906224081090252"><a name="p1906224081090252"></a><a name="p1906224081090252"></a>Reads data from a UART device. </p>
</td>
</tr>
<tr id="row1718173714090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p65808165090252"><a name="p65808165090252"></a><a name="p65808165090252"></a><a href="wifiiot.md#gaac619810d8212e36ac8fbbc133d6308c">UartWrite</a> (<a href="wifiiot.md#ga2699252424e5469ef243ae279a263c44">WifiIotUartIdx</a> id, const unsigned char *data, unsigned int dataLen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1570508770090252"><a name="p1570508770090252"></a><a name="p1570508770090252"></a>int </p>
<p id="p1147237172090252"><a name="p1147237172090252"></a><a name="p1147237172090252"></a>Writes data to a UART device. </p>
</td>
</tr>
<tr id="row2078071135090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1057589313090252"><a name="p1057589313090252"></a><a name="p1057589313090252"></a><a href="wifiiot.md#gaa0519aee188e7def8ea1e76caaabab7b">UartDeinit</a> (<a href="wifiiot.md#ga2699252424e5469ef243ae279a263c44">WifiIotUartIdx</a> id)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1928184660090252"><a name="p1928184660090252"></a><a name="p1928184660090252"></a>unsigned int </p>
<p id="p1934721888090252"><a name="p1934721888090252"></a><a name="p1934721888090252"></a>Deinitializes a UART device. </p>
</td>
</tr>
<tr id="row1130976186090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p749146010090252"><a name="p749146010090252"></a><a name="p749146010090252"></a><a href="wifiiot.md#ga5ae5acc039c3446225daf8b1b60a89d1">UartSetFlowCtrl</a> (<a href="wifiiot.md#ga2699252424e5469ef243ae279a263c44">WifiIotUartIdx</a> id, <a href="wifiiot.md#gacf7ec5d973706e8239c7c6e4a470d8ab">WifiIotFlowCtrl</a> flowCtrl)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1425774432090252"><a name="p1425774432090252"></a><a name="p1425774432090252"></a>unsigned int </p>
<p id="p514638252090252"><a name="p514638252090252"></a><a name="p514638252090252"></a>Sets UART hardware flow control. </p>
</td>
</tr>
<tr id="row1863278229090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1315856046090252"><a name="p1315856046090252"></a><a name="p1315856046090252"></a><a href="wifiiot.md#gafcea2c43c0f614ec9a02bcc1eaf81da1">UartIsBufEmpty</a> (<a href="wifiiot.md#ga2699252424e5469ef243ae279a263c44">WifiIotUartIdx</a> id, unsigned char *empty)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1419573152090252"><a name="p1419573152090252"></a><a name="p1419573152090252"></a>unsigned int </p>
<p id="p1969389451090252"><a name="p1969389451090252"></a><a name="p1969389451090252"></a>Checks whether the buffer on a UART device is empty. </p>
</td>
</tr>
<tr id="row677449057090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p969286922090252"><a name="p969286922090252"></a><a name="p969286922090252"></a><a href="wifiiot.md#gab6630d50726f5c57e726c3465fc0eb96">UartWriteImmediately</a> (<a href="wifiiot.md#ga2699252424e5469ef243ae279a263c44">WifiIotUartIdx</a> id, const unsigned char *data, unsigned int dataLen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1933191198090252"><a name="p1933191198090252"></a><a name="p1933191198090252"></a>int </p>
<p id="p1874327085090252"><a name="p1874327085090252"></a><a name="p1874327085090252"></a>Writes data to be sent to a UART device in polling mode. </p>
</td>
</tr>
<tr id="row1515953365090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2070088437090252"><a name="p2070088437090252"></a><a name="p2070088437090252"></a><a href="wifiiot.md#gabc811333b8add98cd2eabb0ee2d726a3">UartGetAttribute</a> (<a href="wifiiot.md#ga2699252424e5469ef243ae279a263c44">WifiIotUartIdx</a> id, <a href="wifiiotuartattribute.md">WifiIotUartAttribute</a> *attr, <a href="wifiiotuartextraattr.md">WifiIotUartExtraAttr</a> *extraAttr)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1786615903090252"><a name="p1786615903090252"></a><a name="p1786615903090252"></a>unsigned int </p>
<p id="p1503591969090252"><a name="p1503591969090252"></a><a name="p1503591969090252"></a>Obtains UART attributes. </p>
</td>
</tr>
<tr id="row1211308902090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p844799400090252"><a name="p844799400090252"></a><a name="p844799400090252"></a><a href="wifiiot.md#ga67d7b274aaddc162c0140e32f6bc4486">UartIsBusy</a> (<a href="wifiiot.md#ga2699252424e5469ef243ae279a263c44">WifiIotUartIdx</a> id, unsigned char *busy)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p593631878090252"><a name="p593631878090252"></a><a name="p593631878090252"></a>unsigned int </p>
<p id="p1068677174090252"><a name="p1068677174090252"></a><a name="p1068677174090252"></a>Checks whether the buffer on a UART device is busy. </p>
</td>
</tr>
<tr id="row619204747090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1413987223090252"><a name="p1413987223090252"></a><a name="p1413987223090252"></a><a href="wifiiot.md#ga33305a45dcc141336c8dcdb10e0b71b1">WatchDogEnable</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p708270305090252"><a name="p708270305090252"></a><a name="p708270305090252"></a>void </p>
<p id="p1302681636090252"><a name="p1302681636090252"></a><a name="p1302681636090252"></a>Enables the watchdog. </p>
</td>
</tr>
<tr id="row1928257350090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p966830961090252"><a name="p966830961090252"></a><a name="p966830961090252"></a><a href="wifiiot.md#gadded4aa52fb304e815811edc4bc1ce41">WatchDogKick</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1812879120090252"><a name="p1812879120090252"></a><a name="p1812879120090252"></a>void </p>
<p id="p383484645090252"><a name="p383484645090252"></a><a name="p383484645090252"></a>Feeds the watchdog. </p>
</td>
</tr>
<tr id="row1280633462090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1912932339090252"><a name="p1912932339090252"></a><a name="p1912932339090252"></a><a href="wifiiot.md#ga37e8662b7a4f2ad084a43c6309c83a14">WatchDogDisable</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p377791280090252"><a name="p377791280090252"></a><a name="p377791280090252"></a>void </p>
<p id="p481676416090252"><a name="p481676416090252"></a><a name="p481676416090252"></a>Disables the watchdog. </p>
</td>
</tr>
</tbody>
</table>

## **Details**<a name="section858222215090252"></a>

## **Macro Definition Documentation**<a name="section394452353090252"></a>

## WIFI\_IOT\_ERR\_ADC\_INVALID\_CHANNEL\_ID<a name="ga51d02496da9b876fb3953fde207ab83e"></a>

```
#define WIFI_IOT_ERR_ADC_INVALID_CHANNEL_ID   0x80001301
```

 **Description:**

Defines an ADC error code to indicate an invalid channel. 

## WIFI\_IOT\_ERR\_ADC\_NOT\_INIT<a name="gad299ef5c0943421884e6941827679935"></a>

```
#define WIFI_IOT_ERR_ADC_NOT_INIT   0x80001303
```

 **Description:**

Defines an ADC error code to indicate non-initialization. 

## WIFI\_IOT\_ERR\_ADC\_PARAMETER\_WRONG<a name="ga26eb2003b98a03a78822e072ea9d6f1a"></a>

```
#define WIFI_IOT_ERR_ADC_PARAMETER_WRONG   0x80001300
```

 **Description:**

Defines an ADC error code to indicate a parameter error. 

## WIFI\_IOT\_ERR\_ADC\_TIMEOUT<a name="gad43d862b02b1e8d7e11562bb8192e18d"></a>

```
#define WIFI_IOT_ERR_ADC_TIMEOUT   0x80001302
```

 **Description:**

Defines an ADC error code to indicate a timeout. 

## WIFI\_IOT\_ERR\_AT\_INVALID\_PARAMETER<a name="gafeeea5f2038721f00f3233c32b81d176"></a>

```
#define WIFI_IOT_ERR_AT_INVALID_PARAMETER   0x80003281
```

 **Description:**

Defines an AT error code to indicate an invalid parameter. 

## WIFI\_IOT\_ERR\_AT\_NAME\_OR\_FUNC\_REPEAT\_REGISTERED<a name="ga227218024cb39b3c9569b5ca1512cdd7"></a>

```
#define WIFI_IOT_ERR_AT_NAME_OR_FUNC_REPEAT_REGISTERED   0x80003280
```

 **Description:**

Defines an AT error code to indicate repeated function registration. 

## WIFI\_IOT\_ERR\_DMA\_BUSY<a name="ga8e39d0a271b7dc5226f73a1e8e4bf540"></a>

```
#define WIFI_IOT_ERR_DMA_BUSY   0x80001382
```

 **Description:**

Defines a DMA error code to indicate the busy state. 

## WIFI\_IOT\_ERR\_DMA\_CH\_IRQ\_ENABLE\_FAIL<a name="gaf8502b3f56b5750a131d36bf91d8fea0"></a>

```
#define WIFI_IOT_ERR_DMA_CH_IRQ_ENABLE_FAIL   0x80001387
```

 **Description:**

Defines a DMA error code to indicate a failure in enabling channel interrupt. 

## WIFI\_IOT\_ERR\_DMA\_GET\_NOTE\_FAIL<a name="ga126bae9f91f5c1cc91bdcc1f8d10acd3"></a>

```
#define WIFI_IOT_ERR_DMA_GET_NOTE_FAIL   0x80001385
```

 **Description:**

Defines a DMA error code to indicate a retrieval failure. 

## WIFI\_IOT\_ERR\_DMA\_INVALID\_PARA<a name="gaa0095a6a3cce0f1b5ac6d76167ac5db9"></a>

```
#define WIFI_IOT_ERR_DMA_INVALID_PARA   0x80001380
```

 **Description:**

Defines a DMA error code to indicate an invalid parameter. 

## WIFI\_IOT\_ERR\_DMA\_LLI\_NOT\_CREATE<a name="ga0676eed6e7e5e5771fce800a131dde53"></a>

```
#define WIFI_IOT_ERR_DMA_LLI_NOT_CREATE   0x80001386
```

 **Description:**

Defines a DMA error code to indicate that the LLI is not created. 

## WIFI\_IOT\_ERR\_DMA\_NOT\_INIT<a name="gabb302953a44571fa73d9142037e8369c"></a>

```
#define WIFI_IOT_ERR_DMA_NOT_INIT   0x80001381
```

 **Description:**

Defines a DMA error code to indicate non-initialization. 

## WIFI\_IOT\_ERR\_DMA\_TRANSFER\_FAIL<a name="gaac0d381fd56d357ca04f5ba662630ad4"></a>

```
#define WIFI_IOT_ERR_DMA_TRANSFER_FAIL   0x80001383
```

 **Description:**

Defines a DMA error code to indicate a transmission failure. 

## WIFI\_IOT\_ERR\_DMA\_TRANSFER\_TIMEOUT<a name="ga2d964ec500835559f09356795773081c"></a>

```
#define WIFI_IOT_ERR_DMA_TRANSFER_TIMEOUT   0x80001384
```

 **Description:**

Defines a DMA error code to indicate a transmission timeout. 

## WIFI\_IOT\_ERR\_FLASH\_CRYPTO\_BEYOND\_ADDR\_SIZE<a name="ga271adaa6c3c576b4c871b0c28722e6c2"></a>

```
#define WIFI_IOT_ERR_FLASH_CRYPTO_BEYOND_ADDR_SIZE   0x800010F1
```

 **Description:**

Defines a flash error code to indicate that the address is out of range. 

## WIFI\_IOT\_ERR\_FLASH\_CRYPTO\_DATA\_DECRYPT\_ERR<a name="ga3727ba9b17d5b3ce5f53c4bb41b03ea6"></a>

```
#define WIFI_IOT_ERR_FLASH_CRYPTO_DATA_DECRYPT_ERR   0x800001F4
```

 **Description:**

Defines a flash error code to indicate a decryption error. 

## WIFI\_IOT\_ERR\_FLASH\_CRYPTO\_DATA\_ENCRYPT\_ERR<a name="ga20381f13537e23d77a33a43917f8b7bc"></a>

```
#define WIFI_IOT_ERR_FLASH_CRYPTO_DATA_ENCRYPT_ERR   0x800001F3
```

 **Description:**

Defines a flash error code to indicate an encryption error. 

## WIFI\_IOT\_ERR\_FLASH\_CRYPTO\_INVALID\_PARAM<a name="ga422a081f8d37f63e0fcaeec383d8e478"></a>

```
#define WIFI_IOT_ERR_FLASH_CRYPTO_INVALID_PARAM   0x800010F0
```

 **Description:**

Defines a flash error code to indicate an invalid parameter. 

## WIFI\_IOT\_ERR\_FLASH\_CRYPTO\_KERNEL\_ADDR\_ERR<a name="gab414fb9ce381560a725fe725511812b1"></a>

```
#define WIFI_IOT_ERR_FLASH_CRYPTO_KERNEL_ADDR_ERR   0x800001FB
```

 **Description:**

Defines a flash error code to indicate an incorrect kernel address.. 

## WIFI\_IOT\_ERR\_FLASH\_CRYPTO\_KEY\_EMPTY\_ERR<a name="gaeddc722740b9d1405b6d4338e8f22abe"></a>

```
#define WIFI_IOT_ERR_FLASH_CRYPTO_KEY_EMPTY_ERR   0x800001F5
```

 **Description:**

Defines a flash error code to indicate an empty key value. 

## WIFI\_IOT\_ERR\_FLASH\_CRYPTO\_KEY\_INVALID\_ERR<a name="ga8d1bfe4560224e99df17820ca283baa5"></a>

```
#define WIFI_IOT_ERR_FLASH_CRYPTO_KEY_INVALID_ERR   0x800001F9
```

 **Description:**

Defines a flash error code to indicate an invalid key. 

## WIFI\_IOT\_ERR\_FLASH\_CRYPTO\_KEY\_SAVE\_ERR<a name="ga4ddacb6881da562bd8906a2374a21d15"></a>

```
#define WIFI_IOT_ERR_FLASH_CRYPTO_KEY_SAVE_ERR   0x800001FA
```

 **Description:**

Defines a flash error code to indicate a failure in saving the key. 

## WIFI\_IOT\_ERR\_FLASH\_CRYPTO\_MALLOC\_FAIL<a name="ga5b9858094e8f0cd73050f0079f41a18d"></a>

```
#define WIFI_IOT_ERR_FLASH_CRYPTO_MALLOC_FAIL   0x800001F2
```

 **Description:**

Defines a flash error code to indicate a failure in applying for memory. 

## WIFI\_IOT\_ERR\_FLASH\_CRYPTO\_MEMCPY\_FAIL<a name="ga95cbe0f9ca1f79c65a8eab2338b25dc3"></a>

```
#define WIFI_IOT_ERR_FLASH_CRYPTO_MEMCPY_FAIL   0x800001F6
```

 **Description:**

Defines a flash error code to indicate a copy failure. 

## WIFI\_IOT\_ERR\_FLASH\_CRYPTO\_NOT\_SUPPORT<a name="gaff6ccf87c21ba2f1786b0823d492b814"></a>

```
#define WIFI_IOT_ERR_FLASH_CRYPTO_NOT_SUPPORT   0x800001F7
```

 **Description:**

Defines a flash error code to indicate a non-support for encryption. 

## WIFI\_IOT\_ERR\_FLASH\_CRYPTO\_PREPARE\_ERR<a name="gac6e8d4d70fe1ca039b5e853f261c8fd8"></a>

```
#define WIFI_IOT_ERR_FLASH_CRYPTO_PREPARE_ERR   0x800001F8
```

 **Description:**

Defines a flash error code to indicate an incorrect parameter during encryption. 

## WIFI\_IOT\_ERR\_FLASH\_ERASE\_NOT\_4K\_ALIGN<a name="gaa7e9a59dbe5dea2a9bf0c31da1c3cc10"></a>

```
#define WIFI_IOT_ERR_FLASH_ERASE_NOT_4K_ALIGN   0x800010DB
```

 **Description:**

Defines a flash error code to indicate that the size of data to erase is not a multiple of 4K bytes. 

## WIFI\_IOT\_ERR\_FLASH\_INITILIZATION<a name="gac104ab385c136cf5eaf40f7dc51f81cd"></a>

```
#define WIFI_IOT_ERR_FLASH_INITILIZATION   0x800010DA
```

 **Description:**

Defines a flash error code to indicate initialization. 

## WIFI\_IOT\_ERR\_FLASH\_INVALID\_CHIP\_ID<a name="gad8b63e06e4ab22df1965868a5b8e9c34"></a>

```
#define WIFI_IOT_ERR_FLASH_INVALID_CHIP_ID   0x800010D4
```

 **Description:**

Defines a flash error code to indicate an invalid chip ID. 

## WIFI\_IOT\_ERR\_FLASH\_INVALID\_PARAM<a name="ga2cd1281dc392b88851c7da895d121696"></a>

```
#define WIFI_IOT_ERR_FLASH_INVALID_PARAM   0x800010C1
```

 **Description:**

Defines a flash error code to indicate an invalid parameter. 

## WIFI\_IOT\_ERR\_FLASH\_INVALID\_PARAM\_BEYOND\_ADDR<a name="ga0b58bc9856c6879faf0c6a65510fe341"></a>

```
#define WIFI_IOT_ERR_FLASH_INVALID_PARAM_BEYOND_ADDR   0x800010C2
```

 **Description:**

Defines a flash error code to indicate that the address is out of range. 

## WIFI\_IOT\_ERR\_FLASH\_INVALID\_PARAM\_DATA\_NULL<a name="ga41abe9a86b37f2c88714111895c5a7fd"></a>

```
#define WIFI_IOT_ERR_FLASH_INVALID_PARAM_DATA_NULL   0x800010C6
```

 **Description:**

Defines a flash error code to indicate empty data. 

## WIFI\_IOT\_ERR\_FLASH\_INVALID\_PARAM\_ERASE\_NOT\_ALIGN<a name="gaadfebe4ca2dfbfbd5e6121216bb2b4cf"></a>

```
#define WIFI_IOT_ERR_FLASH_INVALID_PARAM_ERASE_NOT_ALIGN   0x800010C4
```

 **Description:**

Defines a flash error code to indicate that the erase size is not aligned. 

## WIFI\_IOT\_ERR\_FLASH\_INVALID\_PARAM\_IOCTRL\_DATA\_NULL<a name="gae9ae811688863c24f7be8c89583ef5cb"></a>

```
#define WIFI_IOT_ERR_FLASH_INVALID_PARAM_IOCTRL_DATA_NULL   0x800010C5
```

 **Description:**

Defines a flash error code to indicate that the data of the I/O controller is empty. 

## WIFI\_IOT\_ERR\_FLASH\_INVALID\_PARAM\_PAD1<a name="ga9f31319390fdaa4051abaa5cf9c1e6bd"></a>

```
#define WIFI_IOT_ERR_FLASH_INVALID_PARAM_PAD1   0x800010C7
```

 **Description:**

Defines a flash error code to indicate that pad1 is incorrect. 

## WIFI\_IOT\_ERR\_FLASH\_INVALID\_PARAM\_PAD2<a name="ga3aeceb16cc526bc3977e363533c4caf2"></a>

```
#define WIFI_IOT_ERR_FLASH_INVALID_PARAM_PAD2   0x800010C8
```

 **Description:**

Defines a flash error code to indicate that pad2 is incorrect. 

## WIFI\_IOT\_ERR\_FLASH\_INVALID\_PARAM\_PAD3<a name="gacb66dcc29fa65a9fa64a43a20acc3e6d"></a>

```
#define WIFI_IOT_ERR_FLASH_INVALID_PARAM_PAD3   0x800010C9
```

 **Description:**

Defines a flash error code to indicate that pad3 is incorrect. 

## WIFI\_IOT\_ERR\_FLASH\_INVALID\_PARAM\_PAD4<a name="ga3d5fe958b7383f49040abc6f1f1c9976"></a>

```
#define WIFI_IOT_ERR_FLASH_INVALID_PARAM_PAD4   0x800010CA
```

 **Description:**

Defines a flash error code to indicate that pad4 is incorrect. 

## WIFI\_IOT\_ERR\_FLASH\_INVALID\_PARAM\_SIZE\_ZERO<a name="gaefb0daa74035564d57262ae477bc7fa2"></a>

```
#define WIFI_IOT_ERR_FLASH_INVALID_PARAM_SIZE_ZERO   0x800010C3
```

 **Description:**

Defines a flash error code to indicate that the parameter size is  **0** 

## WIFI\_IOT\_ERR\_FLASH\_MAX\_SPI\_OP<a name="gaca07e3664b7ca260316507fe5bc0ece1"></a>

```
#define WIFI_IOT_ERR_FLASH_MAX_SPI_OP   0x800010D2
```

 **Description:**

Defines a flash error code to indicate the maximum value of the SPI operation. 

## WIFI\_IOT\_ERR\_FLASH\_NO\_MATCH\_ERASE\_SIZE<a name="ga0abb8298403aeb5a5362663affc67bf8"></a>

```
#define WIFI_IOT_ERR_FLASH_NO_MATCH_ERASE_SIZE   0x800010D1
```

 **Description:**

Defines a flash error code to indicate a mismatch in the size of data to erase. 

## WIFI\_IOT\_ERR\_FLASH\_NO\_MATCH\_FLASH<a name="ga749a534281fe75e79788ac6bbd2ab6ab"></a>

```
#define WIFI_IOT_ERR_FLASH_NO_MATCH_FLASH   0x800010CF
```

 **Description:**

Defines a flash error code to indicate a flash mismatch. 

## WIFI\_IOT\_ERR\_FLASH\_NOT\_INIT<a name="gaebd30986c46f1c6a01931f04776531a0"></a>

```
#define WIFI_IOT_ERR_FLASH_NOT_INIT   0x800010C0
```

 **Description:**

Defines a flash error code to indicate non-initialization. 

## WIFI\_IOT\_ERR\_FLASH\_NOT\_SUPPORT\_IOCTRL\_ID<a name="gad836fbc11d75d82a80f01c1517742e5a"></a>

```
#define WIFI_IOT_ERR_FLASH_NOT_SUPPORT_IOCTRL_ID   0x800010D3
```

 **Description:**

Defines a flash error code to indicate an unsupported IO controller ID.. 

## WIFI\_IOT\_ERR\_FLASH\_PATITION\_INIT\_FAIL<a name="ga5ee3d72623a4d33d3d0373578a3a2361"></a>

```
#define WIFI_IOT_ERR_FLASH_PATITION_INIT_FAIL   0x800010D9
```

 **Description:**

Defines a flash error code to indicate a partition initialization failure. 

## WIFI\_IOT\_ERR\_FLASH\_PROTECT\_NOT\_FIND\_CHIP<a name="ga148b4bd927a934584b15362b7a56ed9b"></a>

```
#define WIFI_IOT_ERR_FLASH_PROTECT_NOT_FIND_CHIP   0x800010DF
```

 **Description:**

Defines a flash error code to indicate that no chip is found. 

## WIFI\_IOT\_ERR\_FLASH\_PROTECT\_NOT\_INIT<a name="gaccc1cff2256173d6504b236d36733c6d"></a>

```
#define WIFI_IOT_ERR_FLASH_PROTECT_NOT_INIT   0x800010DD
```

 **Description:**

Defines a flash error code to indicate non-initialization. 

## WIFI\_IOT\_ERR\_FLASH\_PROTECT\_NOT\_SUPPORT<a name="ga608fd06772893b809c7f0f158e85d09d"></a>

```
#define WIFI_IOT_ERR_FLASH_PROTECT_NOT_SUPPORT   0x800010DC
```

 **Description:**

Defines a flash error code to indicate a non-support. 

## WIFI\_IOT\_ERR\_FLASH\_PROTECT\_RE\_INIT<a name="ga76a2feb8426c43b143cb4f3ba9cfa0e2"></a>

```
#define WIFI_IOT_ERR_FLASH_PROTECT_RE_INIT   0x800010DE
```

 **Description:**

Defines a flash error code to indicate repeated initialization. 

## WIFI\_IOT\_ERR\_FLASH\_QUAD\_MODE\_COMPARE\_REG<a name="ga436294992f32cc090be1f296ef7edb1a"></a>

```
#define WIFI_IOT_ERR_FLASH_QUAD_MODE_COMPARE_REG   0x800010CE
```

 **Description:**

Defines a flash error code to indicate that an error occurs when comparing registers. 

## WIFI\_IOT\_ERR\_FLASH\_QUAD\_MODE\_READ\_REG1<a name="gad25105354cedaa65cadfd01e011d58aa"></a>

```
#define WIFI_IOT_ERR_FLASH_QUAD_MODE_READ_REG1   0x800010CC
```

 **Description:**

Defines a flash error code to indicate that an error occurs when reading register 1. 

## WIFI\_IOT\_ERR\_FLASH\_QUAD\_MODE\_READ\_REG2<a name="gaf86f02647b83f2b4ad942748de6c3877"></a>

```
#define WIFI_IOT_ERR_FLASH_QUAD_MODE_READ_REG2   0x800010CD
```

 **Description:**

Defines a flash error code to indicate that an error occurs when reading register 2. 

## WIFI\_IOT\_ERR\_FLASH\_RE\_INIT<a name="ga0658f79d7edb143919457775b77cc0ac"></a>

```
#define WIFI_IOT_ERR_FLASH_RE_INIT   0x800010D5
```

 **Description:**

Defines a flash error code to indicate repeated initialization. 

## WIFI\_IOT\_ERR\_FLASH\_TIME\_OUT\_WAIT\_READY<a name="gaf067c19a95c6c8c38a46956ec0aea959"></a>

```
#define WIFI_IOT_ERR_FLASH_TIME_OUT_WAIT_READY   0x800010CB
```

 **Description:**

Defines a flash error code to indicate a timeout on waiting for ready. 

## WIFI\_IOT\_ERR\_FLASH\_WAIT\_CFG\_START\_TIME\_OUT<a name="gaff332b79601f3f3ed37fe184fe797fba"></a>

```
#define WIFI_IOT_ERR_FLASH_WAIT_CFG_START_TIME_OUT   0x800010D8
```

 **Description:**

Defines a flash error code to indicate a timeout on waiting for a configuration to start. 

## WIFI\_IOT\_ERR\_FLASH\_WRITE\_COMPARE\_WRONG<a name="ga93d94962d03d6551b528e1a65760a43c"></a>

```
#define WIFI_IOT_ERR_FLASH_WRITE_COMPARE_WRONG   0x800010D7
```

 **Description:**

Defines a flash error code to indicate that an error occurs when comparing the data written. 

## WIFI\_IOT\_ERR\_FLASH\_WRITE\_ENABLE<a name="ga8e7bba169009c4a64d9d5d1c566d2d21"></a>

```
#define WIFI_IOT_ERR_FLASH_WRITE_ENABLE   0x800010D0
```

 **Description:**

Defines a flash error code to indicate a failure in enabling write. 

## WIFI\_IOT\_ERR\_FLASH\_WRITE\_NOT\_SUPPORT\_ERASE<a name="ga4b2d2f87ed5fbd5dae380b1faf41b4b8"></a>

```
#define WIFI_IOT_ERR_FLASH_WRITE_NOT_SUPPORT_ERASE   0x800010D6
```

 **Description:**

Defines a flash error code to indicate a non-support for data erasure. 

## WIFI\_IOT\_ERR\_GPIO\_INVALID\_PARAMETER<a name="gae1dde2925aab87cc79a5cf3b55f69d7b"></a>

```
#define WIFI_IOT_ERR_GPIO_INVALID_PARAMETER   0x80001040
```

 **Description:**

Defines a GPIO error code to indicate an invalid parameter. 

## WIFI\_IOT\_ERR\_GPIO\_NOT\_INIT<a name="ga4607e3646ccfe40732d4c068c071f53a"></a>

```
#define WIFI_IOT_ERR_GPIO_NOT_INIT   0x80001042
```

 **Description:**

Defines a GPIO error code to indicate non-initialization. 

## WIFI\_IOT\_ERR\_GPIO\_NOT\_SUPPORT<a name="ga0080f4d4a86cbce7e86d319386fd9cd2"></a>

```
#define WIFI_IOT_ERR_GPIO_NOT_SUPPORT   0x80001043
```

 **Description:**

Defines a GPIO error code to indicate a non-support. 

## WIFI\_IOT\_ERR\_GPIO\_REPEAT\_INIT<a name="ga86c5c689c1ba112ef2875bf01418281f"></a>

```
#define WIFI_IOT_ERR_GPIO_REPEAT_INIT   0x80001041
```

 **Description:**

Defines a GPIO error code to indicate repeated initialization. 

## WIFI\_IOT\_ERR\_I2C\_INVALID\_PARAMETER<a name="gab663a535e93102e3c3ea1512f63664f8"></a>

```
#define WIFI_IOT_ERR_I2C_INVALID_PARAMETER   0x80001181
```

 **Description:**

Defines an I2C error code to indicate an invalid parameter. 

## WIFI\_IOT\_ERR\_I2C\_NOT\_INIT<a name="ga86974c4b426016d366b978096938101f"></a>

```
#define WIFI_IOT_ERR_I2C_NOT_INIT   0x80001180
```

 **Description:**

Defines an I2C error code to indicate a non-support. 

## WIFI\_IOT\_ERR\_I2C\_START\_ACK\_ERR<a name="ga1f827afc8a122131000e3c3a415482cb"></a>

```
#define WIFI_IOT_ERR_I2C_START_ACK_ERR   0x80001188
```

 **Description:**

Defines an I2C error code to indicate a responding failure. 

## WIFI\_IOT\_ERR\_I2C\_TIMEOUT\_RCV\_BYTE<a name="ga07d88ba023c14c7051330bb505fcf2a2"></a>

```
#define WIFI_IOT_ERR_I2C_TIMEOUT_RCV_BYTE   0x80001185
```

 **Description:**

Defines an I2C error code to indicate a receive timeout. 

## WIFI\_IOT\_ERR\_I2C\_TIMEOUT\_RCV\_BYTE\_PROC<a name="gadc61cee9de2201533a19247b2d8e991d"></a>

```
#define WIFI_IOT_ERR_I2C_TIMEOUT_RCV_BYTE_PROC   0x80001186
```

 **Description:**

Defines an I2C error code to indicate a processing timeout. 

## WIFI\_IOT\_ERR\_I2C\_TIMEOUT\_START<a name="ga355774fcb1d6cc687d41e6ac93988e37"></a>

```
#define WIFI_IOT_ERR_I2C_TIMEOUT_START   0x80001182
```

 **Description:**

Defines an I2C error code to indicate a start timeout. 

## WIFI\_IOT\_ERR\_I2C\_TIMEOUT\_STOP<a name="ga70fe483466bb0a1908838d09af9e08ee"></a>

```
#define WIFI_IOT_ERR_I2C_TIMEOUT_STOP   0x80001184
```

 **Description:**

Defines an I2C error code to indicate a stop timeout. 

## WIFI\_IOT\_ERR\_I2C\_TIMEOUT\_WAIT<a name="ga5504ab71071109a4adcc5ab594636bd0"></a>

```
#define WIFI_IOT_ERR_I2C_TIMEOUT_WAIT   0x80001183
```

 **Description:**

Defines an I2C error code to indicate a wait timeout. 

## WIFI\_IOT\_ERR\_I2C\_WAIT\_ACK\_ERR<a name="ga8244270946d616498697e8f3f14ec777"></a>

```
#define WIFI_IOT_ERR_I2C_WAIT_ACK_ERR   0x80001189
```

 **Description:**

Defines an I2C error code to indicate a failure in waiting for a response. 

## WIFI\_IOT\_ERR\_I2C\_WAIT\_SEM\_FAIL<a name="ga0535100d16963cfd5b83da321871c2e3"></a>

```
#define WIFI_IOT_ERR_I2C_WAIT_SEM_FAIL   0x80001187
```

 **Description:**

Defines an I2C error code to indicate a waiting failure. 

## WIFI\_IOT\_ERR\_I2S\_INVALID\_PARAMETER<a name="ga24837886814d447997ba4e147d7b88b7"></a>

```
#define WIFI_IOT_ERR_I2S_INVALID_PARAMETER   0x80001400
```

 **Description:**

Defines an I2S error code to indicate an invalid parameter. 

## WIFI\_IOT\_ERR\_I2S\_WRITE\_TIMEOUT<a name="ga624feb752f94207583f7529eea816197"></a>

```
#define WIFI_IOT_ERR_I2S_WRITE_TIMEOUT   0x80001401
```

 **Description:**

Defines an I2S error code to indicate a write timeout. 

## WIFI\_IOT\_ERR\_PWM\_INITILIZATION\_ALREADY<a name="gacfc74f2eb47edfc1c5fc6f0a8eb06853"></a>

```
#define WIFI_IOT_ERR_PWM_INITILIZATION_ALREADY   0x80001341
```

 **Description:**

Defines a PWM error code to indicate an initialization error. 

## WIFI\_IOT\_ERR\_PWM\_INVALID\_PARAMETER<a name="ga63e9f9737a00e8fc7147ba18d21682a5"></a>

```
#define WIFI_IOT_ERR_PWM_INVALID_PARAMETER   0x80001342
```

 **Description:**

Defines a PWM error code to indicate an invalid parameter. 

## WIFI\_IOT\_ERR\_PWM\_NO\_INIT<a name="ga59e7a7be362105ba9f68558a305df640"></a>

```
#define WIFI_IOT_ERR_PWM_NO_INIT   0x80001340
```

 **Description:**

Defines a PWM error code to indicate non-initialization. 

## WIFI\_IOT\_ERR\_SDIO\_INVALID\_PARAMETER<a name="gac059172aa16736913b47cd9fff537afc"></a>

```
#define WIFI_IOT_ERR_SDIO_INVALID_PARAMETER   0x80001280
```

 **Description:**

Defines an SDIO error code to indicate an invalid parameter. 

## WIFI\_IOT\_ERR\_SPI\_BUSY<a name="gaa419999b00bbb93a9bf7ec6e5729d3c3"></a>

```
#define WIFI_IOT_ERR_SPI_BUSY   0x800011C3
```

 **Description:**

Defines an SPI error code to indicate the busy state. 

## WIFI\_IOT\_ERR\_SPI\_NOT\_INIT<a name="gad4e8ba59aa79284855f8097e2a10f2df"></a>

```
#define WIFI_IOT_ERR_SPI_NOT_INIT   0x800011C0
```

 **Description:**

Defines an SPI error code to indicate non-initialization. 

## WIFI\_IOT\_ERR\_SPI\_NOT\_SUPPORT\_DMA<a name="gade8e979043f1d0641ac08adb73197730"></a>

```
#define WIFI_IOT_ERR_SPI_NOT_SUPPORT_DMA   0x800011C6
```

 **Description:**

Defines an SPI error code to indicate a non-support for DMA. 

## WIFI\_IOT\_ERR\_SPI\_PARAMETER\_WRONG<a name="gafacaaace84501679b61488c53d5e76c3"></a>

```
#define WIFI_IOT_ERR_SPI_PARAMETER_WRONG   0x800011C2
```

 **Description:**

Defines an SPI error code to indicate a parameter error. 

## WIFI\_IOT\_ERR\_SPI\_READ\_TIMEOUT<a name="ga10a6043e83efd5639859fce4dc3ffa6c"></a>

```
#define WIFI_IOT_ERR_SPI_READ_TIMEOUT   0x800011C5
```

 **Description:**

Defines an SPI error code to indicate a read timeout. 

## WIFI\_IOT\_ERR\_SPI\_REINIT<a name="ga503c84a7a64db295583a4c32c799002f"></a>

```
#define WIFI_IOT_ERR_SPI_REINIT   0x800011C1
```

 **Description:**

Defines an SPI error code to indicate repeated initialization. 

## WIFI\_IOT\_ERR\_SPI\_WRITE\_TIMEOUT<a name="ga9063703b367dc0e392759c6e9f2f84ec"></a>

```
#define WIFI_IOT_ERR_SPI_WRITE_TIMEOUT   0x800011C4
```

 **Description:**

Defines an SPI error code to indicate a write timeout. 

## WIFI\_IOT\_ERR\_UART\_INVALID\_BAUD<a name="gacb947326cf340c964edb6ccdbb5273f1"></a>

```
#define WIFI_IOT_ERR_UART_INVALID_BAUD   0x80001005
```

 **Description:**

Defines a UART error code to indicate an invalid baud rate. 

## WIFI\_IOT\_ERR\_UART\_INVALID\_COM\_PORT<a name="ga4c677c899cabd847fe4627400e27f4b0"></a>

```
#define WIFI_IOT_ERR_UART_INVALID_COM_PORT   0x80001006
```

 **Description:**

Defines a UART error code to indicate an invalid port number. 

## WIFI\_IOT\_ERR\_UART\_INVALID\_DATA\_BITS<a name="ga20dfd6fedd138cdd065e70e267c90340"></a>

```
#define WIFI_IOT_ERR_UART_INVALID_DATA_BITS   0x80001003
```

 **Description:**

Defines a UART error code to indicate an invalid data bit. 

## WIFI\_IOT\_ERR\_UART\_INVALID\_PARAMETER<a name="gaf5cf7e2b308037a65be66bb755dc5880"></a>

```
#define WIFI_IOT_ERR_UART_INVALID_PARAMETER   0x80001000
```

 **Description:**

Defines a UART error code to indicate an invalid parameter. 

## WIFI\_IOT\_ERR\_UART\_INVALID\_PARITY<a name="ga2ba1db97d77cf3d74466a7951861538a"></a>

```
#define WIFI_IOT_ERR_UART_INVALID_PARITY   0x80001002
```

 **Description:**

Defines a UART error code to indicate an invalid parity check. 

## WIFI\_IOT\_ERR\_UART\_INVALID\_STOP\_BITS<a name="ga936de56f79c06da2e782b00b66e47e8c"></a>

```
#define WIFI_IOT_ERR_UART_INVALID_STOP_BITS   0x80001004
```

 **Description:**

Defines a UART error code to indicate an invalid stop bit. 

## WIFI\_IOT\_ERR\_UART\_INVALID\_SUSPEND<a name="ga5877267c67a4620a43d714d3d853d2e3"></a>

```
#define WIFI_IOT_ERR_UART_INVALID_SUSPEND   0x80001001
```

 **Description:**

Defines a UART error code to indicate an invalid pause operation. 

## WIFI\_IOT\_ERR\_UART\_NOT\_BLOCK\_MODE<a name="ga2261c686d955fb1caca8a2b123330341"></a>

```
#define WIFI_IOT_ERR_UART_NOT_BLOCK_MODE   0x80001008
```

 **Description:**

Defines a UART error code to indicate the non-block mode. 

## WIFI\_IOT\_ERR\_UART\_NOT\_SUPPORT\_DMA<a name="ga08fefa68d06c7559dc59e69a4a5ff58d"></a>

```
#define WIFI_IOT_ERR_UART_NOT_SUPPORT_DMA   0x80001007
```

 **Description:**

Defines a UART error code to indicate a non-support for DMA. 

## WIFI\_IOT\_FAILURE<a name="gae2bfd5a14f6126c51fa6206a7f1008be"></a>

```
#define WIFI_IOT_FAILURE   (-1)
```

 **Description:**

Defines a module-level return value to indicate an operation failure. 

## WIFI\_IOT\_SUCCESS<a name="gae70eaf627c0370cc271dcb8060aee861"></a>

```
#define WIFI_IOT_SUCCESS   0
```

 **Description:**

Defines a module-level return value to indicate a successful operation. 

## **Typedef Documentation**<a name="section1019362461090252"></a>

## GpioIsrCallbackFunc<a name="ga93120443d8150e18701ce6d3dd290408"></a>

```
typedef void(* GpioIsrCallbackFunc) (char *arg)
```

 **Description:**

Indicates the GPIO interrupt callback. 

## I2cPrepareFunc<a name="ga1f0c8fe1deb1cf1fc8b19d69c2fca729"></a>

```
typedef void(* I2cPrepareFunc) (void)
```

 **Description:**

Indicates the callback invoked for device preparation. 

## I2CResetFunc<a name="ga1176c2c06eca906f3e662027df156109"></a>

```
typedef void(* I2CResetFunc) (void)
```

 **Description:**

Indicates the callback invoked when a device exception occurs. 

## I2cRestoreFunc<a name="ga16779c755404f2ec8543452268a9fb3b"></a>

```
typedef void(* I2cRestoreFunc) (void)
```

 **Description:**

Indicates the callback invoked for device recovery. 

## TickIdleKalCallback<a name="ga8be54bbf12f538188db10aaaf4bdbdf9"></a>

```
typedef void(* TickIdleKalCallback) (void)
```

 **Description:**

Indicates the idle task and CPU tick callbacks. 

## **Enumeration Type Documentation**<a name="section24784141090252"></a>

## WifiiIotIoFuncGpio1<a name="gae9c6ae0f852d8701036823a6223adf7e"></a>

```
enum [WifiiIotIoFuncGpio1](wifiiot.md#gae9c6ae0f852d8701036823a6223adf7e)
```

 **Description:**

Enumerates the functions of GPIO hardware pin 1. 

<a name="table1577212608090252"></a>
<table><thead align="left"><tr id="row96749845090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p328040664090252"><a name="p328040664090252"></a><a name="p328040664090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p828445957090252"><a name="p828445957090252"></a><a name="p828445957090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row845487721090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae9c6ae0f852d8701036823a6223adf7ea97ed23afc3bd351f4592d10203104983"><a name="ggae9c6ae0f852d8701036823a6223adf7ea97ed23afc3bd351f4592d10203104983"></a><a name="ggae9c6ae0f852d8701036823a6223adf7ea97ed23afc3bd351f4592d10203104983"></a></strong>WIFI_IOT_IO_FUNC_GPIO_1_GPIO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1199839312090252"><a name="p1199839312090252"></a><a name="p1199839312090252"></a>GPIO1 function </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotAdcChannelIndex<a name="ga4c8b663163c7b23071914947a2bca73b"></a>

```
enum [WifiIotAdcChannelIndex](wifiiot.md#ga4c8b663163c7b23071914947a2bca73b)
```

 **Description:**

Enumerates ADC channel indexes. 

<a name="table413819919090252"></a>
<table><thead align="left"><tr id="row1827496397090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p914563005090252"><a name="p914563005090252"></a><a name="p914563005090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1778185570090252"><a name="p1778185570090252"></a><a name="p1778185570090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1730919515090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga4c8b663163c7b23071914947a2bca73bafe850394965c1431bf6fa82471a12540"><a name="gga4c8b663163c7b23071914947a2bca73bafe850394965c1431bf6fa82471a12540"></a><a name="gga4c8b663163c7b23071914947a2bca73bafe850394965c1431bf6fa82471a12540"></a></strong>WIFI_IOT_ADC_CHANNEL_0 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p659368269090252"><a name="p659368269090252"></a><a name="p659368269090252"></a>Channel 0 </p>
 </td>
</tr>
<tr id="row1521155235090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga4c8b663163c7b23071914947a2bca73bab418db8068026df85efc38e86543b2f8"><a name="gga4c8b663163c7b23071914947a2bca73bab418db8068026df85efc38e86543b2f8"></a><a name="gga4c8b663163c7b23071914947a2bca73bab418db8068026df85efc38e86543b2f8"></a></strong>WIFI_IOT_ADC_CHANNEL_1 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1827825499090252"><a name="p1827825499090252"></a><a name="p1827825499090252"></a>Channel 1 </p>
 </td>
</tr>
<tr id="row1651239615090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga4c8b663163c7b23071914947a2bca73ba9fb27592172d4ed7652afb7eb67df4f7"><a name="gga4c8b663163c7b23071914947a2bca73ba9fb27592172d4ed7652afb7eb67df4f7"></a><a name="gga4c8b663163c7b23071914947a2bca73ba9fb27592172d4ed7652afb7eb67df4f7"></a></strong>WIFI_IOT_ADC_CHANNEL_2 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p680498208090252"><a name="p680498208090252"></a><a name="p680498208090252"></a>Channel 2 </p>
 </td>
</tr>
<tr id="row934372346090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga4c8b663163c7b23071914947a2bca73ba80a93121e6990776a192d0e2a25f4420"><a name="gga4c8b663163c7b23071914947a2bca73ba80a93121e6990776a192d0e2a25f4420"></a><a name="gga4c8b663163c7b23071914947a2bca73ba80a93121e6990776a192d0e2a25f4420"></a></strong>WIFI_IOT_ADC_CHANNEL_3 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1003702324090252"><a name="p1003702324090252"></a><a name="p1003702324090252"></a>Channel 3 </p>
 </td>
</tr>
<tr id="row1546720837090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga4c8b663163c7b23071914947a2bca73bae5516e741e66cab4fac522aac5a4cd13"><a name="gga4c8b663163c7b23071914947a2bca73bae5516e741e66cab4fac522aac5a4cd13"></a><a name="gga4c8b663163c7b23071914947a2bca73bae5516e741e66cab4fac522aac5a4cd13"></a></strong>WIFI_IOT_ADC_CHANNEL_4 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1205295034090252"><a name="p1205295034090252"></a><a name="p1205295034090252"></a>Channel 4 </p>
 </td>
</tr>
<tr id="row519771356090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga4c8b663163c7b23071914947a2bca73ba462ea6a6767d412e7599fe1c258bd277"><a name="gga4c8b663163c7b23071914947a2bca73ba462ea6a6767d412e7599fe1c258bd277"></a><a name="gga4c8b663163c7b23071914947a2bca73ba462ea6a6767d412e7599fe1c258bd277"></a></strong>WIFI_IOT_ADC_CHANNEL_5 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1903334471090252"><a name="p1903334471090252"></a><a name="p1903334471090252"></a>Channel 5 </p>
 </td>
</tr>
<tr id="row1250359181090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga4c8b663163c7b23071914947a2bca73bac973eb63cc515666c23bd2a743aaeab9"><a name="gga4c8b663163c7b23071914947a2bca73bac973eb63cc515666c23bd2a743aaeab9"></a><a name="gga4c8b663163c7b23071914947a2bca73bac973eb63cc515666c23bd2a743aaeab9"></a></strong>WIFI_IOT_ADC_CHANNEL_6 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1786645199090252"><a name="p1786645199090252"></a><a name="p1786645199090252"></a>Channel 6 </p>
 </td>
</tr>
<tr id="row261574262090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga4c8b663163c7b23071914947a2bca73bab6811d77d85f9280fb12ab02de1ed784"><a name="gga4c8b663163c7b23071914947a2bca73bab6811d77d85f9280fb12ab02de1ed784"></a><a name="gga4c8b663163c7b23071914947a2bca73bab6811d77d85f9280fb12ab02de1ed784"></a></strong>WIFI_IOT_ADC_CHANNEL_7 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p214665465090252"><a name="p214665465090252"></a><a name="p214665465090252"></a>Channel 7 </p>
 </td>
</tr>
<tr id="row735542949090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga4c8b663163c7b23071914947a2bca73bab50fa87c837f92c0c93b4b24ca7b6a04"><a name="gga4c8b663163c7b23071914947a2bca73bab50fa87c837f92c0c93b4b24ca7b6a04"></a><a name="gga4c8b663163c7b23071914947a2bca73bab50fa87c837f92c0c93b4b24ca7b6a04"></a></strong>WIFI_IOT_ADC_CHANNEL_BUTT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1443007658090252"><a name="p1443007658090252"></a><a name="p1443007658090252"></a>Button value </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotAdcCurBais<a name="gaac161eb7075f815f6d39a63615bfa82d"></a>

```
enum [WifiIotAdcCurBais](wifiiot.md#gaac161eb7075f815f6d39a63615bfa82d)
```

 **Description:**

Enumerates analog power control modes. 

<a name="table1696626181090252"></a>
<table><thead align="left"><tr id="row1992424645090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1950843778090252"><a name="p1950843778090252"></a><a name="p1950843778090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1201198159090252"><a name="p1201198159090252"></a><a name="p1201198159090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row19172309090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaac161eb7075f815f6d39a63615bfa82da610431a53604392e121dbd6b760de1b0"><a name="ggaac161eb7075f815f6d39a63615bfa82da610431a53604392e121dbd6b760de1b0"></a><a name="ggaac161eb7075f815f6d39a63615bfa82da610431a53604392e121dbd6b760de1b0"></a></strong>WIFI_IOT_ADC_CUR_BAIS_DEFAULT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p481480260090252"><a name="p481480260090252"></a><a name="p481480260090252"></a>Automatic control </p>
 </td>
</tr>
<tr id="row583356617090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaac161eb7075f815f6d39a63615bfa82da0b63185aa983959d4fdc6158d23dbb82"><a name="ggaac161eb7075f815f6d39a63615bfa82da0b63185aa983959d4fdc6158d23dbb82"></a><a name="ggaac161eb7075f815f6d39a63615bfa82da0b63185aa983959d4fdc6158d23dbb82"></a></strong>WIFI_IOT_ADC_CUR_BAIS_AUTO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1178845155090252"><a name="p1178845155090252"></a><a name="p1178845155090252"></a>Automatic control </p>
 </td>
</tr>
<tr id="row557531804090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaac161eb7075f815f6d39a63615bfa82dafd16a8f9dbcebb676d920e7708782ff0"><a name="ggaac161eb7075f815f6d39a63615bfa82dafd16a8f9dbcebb676d920e7708782ff0"></a><a name="ggaac161eb7075f815f6d39a63615bfa82dafd16a8f9dbcebb676d920e7708782ff0"></a></strong>WIFI_IOT_ADC_CUR_BAIS_1P8V </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1650172590090252"><a name="p1650172590090252"></a><a name="p1650172590090252"></a>Manual control (AVDD = 1.8 V) </p>
 </td>
</tr>
<tr id="row173317889090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaac161eb7075f815f6d39a63615bfa82da28c17a3bb256e352492c06421b890bc9"><a name="ggaac161eb7075f815f6d39a63615bfa82da28c17a3bb256e352492c06421b890bc9"></a><a name="ggaac161eb7075f815f6d39a63615bfa82da28c17a3bb256e352492c06421b890bc9"></a></strong>WIFI_IOT_ADC_CUR_BAIS_3P3V </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p199216672090252"><a name="p199216672090252"></a><a name="p199216672090252"></a>Manual control (AVDD = 3.3 V) </p>
 </td>
</tr>
<tr id="row1071563442090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaac161eb7075f815f6d39a63615bfa82da7f2ef39248469813c6e99bdc6a1f5b25"><a name="ggaac161eb7075f815f6d39a63615bfa82da7f2ef39248469813c6e99bdc6a1f5b25"></a><a name="ggaac161eb7075f815f6d39a63615bfa82da7f2ef39248469813c6e99bdc6a1f5b25"></a></strong>WIFI_IOT_ADC_CUR_BAIS_BUTT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p975497217090252"><a name="p975497217090252"></a><a name="p975497217090252"></a>Button value </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotAdcEquModelSel<a name="gafb9992ebf1655f994dc56883c8fe4b2e"></a>

```
enum [WifiIotAdcEquModelSel](wifiiot.md#gafb9992ebf1655f994dc56883c8fe4b2e)
```

 **Description:**

Enumerates equation models. 

<a name="table418888918090252"></a>
<table><thead align="left"><tr id="row218543104090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1853819352090252"><a name="p1853819352090252"></a><a name="p1853819352090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1380012550090252"><a name="p1380012550090252"></a><a name="p1380012550090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row204035204090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggafb9992ebf1655f994dc56883c8fe4b2ea4e277052ddc958f8cbbe3476061bb08c"><a name="ggafb9992ebf1655f994dc56883c8fe4b2ea4e277052ddc958f8cbbe3476061bb08c"></a><a name="ggafb9992ebf1655f994dc56883c8fe4b2ea4e277052ddc958f8cbbe3476061bb08c"></a></strong>WIFI_IOT_ADC_EQU_MODEL_1 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1617122582090252"><a name="p1617122582090252"></a><a name="p1617122582090252"></a>One-equation model </p>
 </td>
</tr>
<tr id="row1915941788090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggafb9992ebf1655f994dc56883c8fe4b2ea1607975f67fcf1ecd9a12c2ff8007a73"><a name="ggafb9992ebf1655f994dc56883c8fe4b2ea1607975f67fcf1ecd9a12c2ff8007a73"></a><a name="ggafb9992ebf1655f994dc56883c8fe4b2ea1607975f67fcf1ecd9a12c2ff8007a73"></a></strong>WIFI_IOT_ADC_EQU_MODEL_2 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2127738684090252"><a name="p2127738684090252"></a><a name="p2127738684090252"></a>Two-equation model </p>
 </td>
</tr>
<tr id="row13028783090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggafb9992ebf1655f994dc56883c8fe4b2ea2ebb62372c9b0ecd305d5833f8ebee32"><a name="ggafb9992ebf1655f994dc56883c8fe4b2ea2ebb62372c9b0ecd305d5833f8ebee32"></a><a name="ggafb9992ebf1655f994dc56883c8fe4b2ea2ebb62372c9b0ecd305d5833f8ebee32"></a></strong>WIFI_IOT_ADC_EQU_MODEL_4 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1330325827090252"><a name="p1330325827090252"></a><a name="p1330325827090252"></a>Four-equation model </p>
 </td>
</tr>
<tr id="row1138576116090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggafb9992ebf1655f994dc56883c8fe4b2eac1d53c7c2cdc479296e2adfec8f7de6b"><a name="ggafb9992ebf1655f994dc56883c8fe4b2eac1d53c7c2cdc479296e2adfec8f7de6b"></a><a name="ggafb9992ebf1655f994dc56883c8fe4b2eac1d53c7c2cdc479296e2adfec8f7de6b"></a></strong>WIFI_IOT_ADC_EQU_MODEL_8 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1581105170090252"><a name="p1581105170090252"></a><a name="p1581105170090252"></a>Eight-equation model </p>
 </td>
</tr>
<tr id="row1486170597090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggafb9992ebf1655f994dc56883c8fe4b2ea6c73c22db275621900ad3594106af20c"><a name="ggafb9992ebf1655f994dc56883c8fe4b2ea6c73c22db275621900ad3594106af20c"></a><a name="ggafb9992ebf1655f994dc56883c8fe4b2ea6c73c22db275621900ad3594106af20c"></a></strong>WIFI_IOT_ADC_EQU_MODEL_BUTT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p660936029090252"><a name="p660936029090252"></a><a name="p660936029090252"></a>Button value </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotFlashPartitionTableId<a name="ga2f287bbb40987fe6d1d7fa525574c00c"></a>

```
enum [WifiIotFlashPartitionTableId](wifiiot.md#ga2f287bbb40987fe6d1d7fa525574c00c)
```

 **Description:**

Indicates the partition table ID. 

<a name="table1865417468090252"></a>
<table><thead align="left"><tr id="row641192429090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1050282909090252"><a name="p1050282909090252"></a><a name="p1050282909090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1137704258090252"><a name="p1137704258090252"></a><a name="p1137704258090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row893073271090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f287bbb40987fe6d1d7fa525574c00ca084dbf8aafce9c7a3ecad33da66e05b0"><a name="gga2f287bbb40987fe6d1d7fa525574c00ca084dbf8aafce9c7a3ecad33da66e05b0"></a><a name="gga2f287bbb40987fe6d1d7fa525574c00ca084dbf8aafce9c7a3ecad33da66e05b0"></a></strong>WIFI_IOT_FLASH_PARTITON_BOOT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1037536960090252"><a name="p1037536960090252"></a><a name="p1037536960090252"></a>Boot partition ID </p>
 </td>
</tr>
<tr id="row138768590090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f287bbb40987fe6d1d7fa525574c00cabb8d227a662a66aad9557d9fc817a8fb"><a name="gga2f287bbb40987fe6d1d7fa525574c00cabb8d227a662a66aad9557d9fc817a8fb"></a><a name="gga2f287bbb40987fe6d1d7fa525574c00cabb8d227a662a66aad9557d9fc817a8fb"></a></strong>WIFI_IOT_FLASH_PARTITON_FACTORY_NV </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p332925079090252"><a name="p332925079090252"></a><a name="p332925079090252"></a>Factory NV partition ID </p>
 </td>
</tr>
<tr id="row177698506090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f287bbb40987fe6d1d7fa525574c00ca427d6a8603c364374b5eb714450e18c8"><a name="gga2f287bbb40987fe6d1d7fa525574c00ca427d6a8603c364374b5eb714450e18c8"></a><a name="gga2f287bbb40987fe6d1d7fa525574c00ca427d6a8603c364374b5eb714450e18c8"></a></strong>WIFI_IOT_FLASH_PARTITON_NORMAL_NV </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1621098100090252"><a name="p1621098100090252"></a><a name="p1621098100090252"></a>Normal NV partition ID </p>
 </td>
</tr>
<tr id="row1283940997090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f287bbb40987fe6d1d7fa525574c00ca50131238794a26984f0f1209f94b338f"><a name="gga2f287bbb40987fe6d1d7fa525574c00ca50131238794a26984f0f1209f94b338f"></a><a name="gga2f287bbb40987fe6d1d7fa525574c00ca50131238794a26984f0f1209f94b338f"></a></strong>WIFI_IOT_FLASH_PARTITON_NORMAL_NV_BACKUP </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1882343330090252"><a name="p1882343330090252"></a><a name="p1882343330090252"></a>Normal backup NV partition ID </p>
 </td>
</tr>
<tr id="row1851874425090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f287bbb40987fe6d1d7fa525574c00ca779875726c11006ea771f1ad2fb8af9b"><a name="gga2f287bbb40987fe6d1d7fa525574c00ca779875726c11006ea771f1ad2fb8af9b"></a><a name="gga2f287bbb40987fe6d1d7fa525574c00ca779875726c11006ea771f1ad2fb8af9b"></a></strong>WIFI_IOT_FLASH_PARTITON_KERNEL_A </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1108770322090252"><a name="p1108770322090252"></a><a name="p1108770322090252"></a>Kernel A running partition ID </p>
 </td>
</tr>
<tr id="row1350615318090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f287bbb40987fe6d1d7fa525574c00caddd52544b51d83e70cfe5966852f9780"><a name="gga2f287bbb40987fe6d1d7fa525574c00caddd52544b51d83e70cfe5966852f9780"></a><a name="gga2f287bbb40987fe6d1d7fa525574c00caddd52544b51d83e70cfe5966852f9780"></a></strong>WIFI_IOT_FLASH_PARTITON_KERNEL_B </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p878494255090252"><a name="p878494255090252"></a><a name="p878494255090252"></a>Kernel B running partition ID </p>
 </td>
</tr>
<tr id="row1779678258090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f287bbb40987fe6d1d7fa525574c00ca4f7f1e1f9120cf095a9c7b5d076c4ba4"><a name="gga2f287bbb40987fe6d1d7fa525574c00ca4f7f1e1f9120cf095a9c7b5d076c4ba4"></a><a name="gga2f287bbb40987fe6d1d7fa525574c00ca4f7f1e1f9120cf095a9c7b5d076c4ba4"></a></strong>WIFI_IOT_FLASH_PARTITON_HILINK </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1957990526090252"><a name="p1957990526090252"></a><a name="p1957990526090252"></a>HiLink partition ID </p>
 </td>
</tr>
<tr id="row1283222240090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f287bbb40987fe6d1d7fa525574c00cacff32ff0901d4ca46814d747880579fa"><a name="gga2f287bbb40987fe6d1d7fa525574c00cacff32ff0901d4ca46814d747880579fa"></a><a name="gga2f287bbb40987fe6d1d7fa525574c00cacff32ff0901d4ca46814d747880579fa"></a></strong>WIFI_IOT_FLASH_PARTITON_FILE_SYSTEM </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p573079212090252"><a name="p573079212090252"></a><a name="p573079212090252"></a>File system partition ID </p>
 </td>
</tr>
<tr id="row1007374780090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f287bbb40987fe6d1d7fa525574c00cae8c645e2e5d130218b6eaec1e57dc8ee"><a name="gga2f287bbb40987fe6d1d7fa525574c00cae8c645e2e5d130218b6eaec1e57dc8ee"></a><a name="gga2f287bbb40987fe6d1d7fa525574c00cae8c645e2e5d130218b6eaec1e57dc8ee"></a></strong>WIFI_IOT_FLASH_PARTITON_USR_RESERVE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p495214441090252"><a name="p495214441090252"></a><a name="p495214441090252"></a>User reserved partition ID </p>
 </td>
</tr>
<tr id="row1658484668090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f287bbb40987fe6d1d7fa525574c00ca70a3cdffb76b64cbacf6973bf06e0a0a"><a name="gga2f287bbb40987fe6d1d7fa525574c00ca70a3cdffb76b64cbacf6973bf06e0a0a"></a><a name="gga2f287bbb40987fe6d1d7fa525574c00ca70a3cdffb76b64cbacf6973bf06e0a0a"></a></strong>WIFI_IOT_FLASH_PARTITON_HILINK_PKI </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p958984787090252"><a name="p958984787090252"></a><a name="p958984787090252"></a>HiLink PKI partition ID </p>
 </td>
</tr>
<tr id="row1504025965090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f287bbb40987fe6d1d7fa525574c00ca84650ae2f4cd3e7be0a1a24eb378e28c"><a name="gga2f287bbb40987fe6d1d7fa525574c00ca84650ae2f4cd3e7be0a1a24eb378e28c"></a><a name="gga2f287bbb40987fe6d1d7fa525574c00ca84650ae2f4cd3e7be0a1a24eb378e28c"></a></strong>WIFI_IOT_FLASH_PARTITON_CRASH_INFO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1131828719090252"><a name="p1131828719090252"></a><a name="p1131828719090252"></a>Crash log partition ID </p>
 </td>
</tr>
<tr id="row848319551090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f287bbb40987fe6d1d7fa525574c00ca7068d177a4cdb8239445b7cc5763d132"><a name="gga2f287bbb40987fe6d1d7fa525574c00ca7068d177a4cdb8239445b7cc5763d132"></a><a name="gga2f287bbb40987fe6d1d7fa525574c00ca7068d177a4cdb8239445b7cc5763d132"></a></strong>WIFI_IOT_FLASH_PARTITON_BOOT_BACK </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p931034523090252"><a name="p931034523090252"></a><a name="p931034523090252"></a>Backup boot partition ID </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotFlowCtrl<a name="gacf7ec5d973706e8239c7c6e4a470d8ab"></a>

```
enum [WifiIotFlowCtrl](wifiiot.md#gacf7ec5d973706e8239c7c6e4a470d8ab)
```

 **Description:**

Enumerates hardware flow control modes. 

<a name="table773456241090252"></a>
<table><thead align="left"><tr id="row46856373090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1920905158090252"><a name="p1920905158090252"></a><a name="p1920905158090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2146821712090252"><a name="p2146821712090252"></a><a name="p2146821712090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2139805713090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacf7ec5d973706e8239c7c6e4a470d8aba90bfc480060d1a4e23805dd0512fe428"><a name="ggacf7ec5d973706e8239c7c6e4a470d8aba90bfc480060d1a4e23805dd0512fe428"></a><a name="ggacf7ec5d973706e8239c7c6e4a470d8aba90bfc480060d1a4e23805dd0512fe428"></a></strong>WIFI_IOT_FLOW_CTRL_NONE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2058786157090252"><a name="p2058786157090252"></a><a name="p2058786157090252"></a>Hardware flow control disabled </p>
 </td>
</tr>
<tr id="row344844089090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacf7ec5d973706e8239c7c6e4a470d8aba0abb36c9eb6e80ed338f99d87d3ebfbf"><a name="ggacf7ec5d973706e8239c7c6e4a470d8aba0abb36c9eb6e80ed338f99d87d3ebfbf"></a><a name="ggacf7ec5d973706e8239c7c6e4a470d8aba0abb36c9eb6e80ed338f99d87d3ebfbf"></a></strong>WIFI_IOT_FLOW_CTRL_RTS_CTS </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2096570483090252"><a name="p2096570483090252"></a><a name="p2096570483090252"></a>RTS and CTS hardware flow control enabled </p>
 </td>
</tr>
<tr id="row791141070090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacf7ec5d973706e8239c7c6e4a470d8aba92b50039dcab731820e2b360ab9ecaeb"><a name="ggacf7ec5d973706e8239c7c6e4a470d8aba92b50039dcab731820e2b360ab9ecaeb"></a><a name="ggacf7ec5d973706e8239c7c6e4a470d8aba92b50039dcab731820e2b360ab9ecaeb"></a></strong>WIFI_IOT_FLOW_CTRL_RTS_ONLY </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p503510564090252"><a name="p503510564090252"></a><a name="p503510564090252"></a>RTS hardware flow control enabled </p>
 </td>
</tr>
<tr id="row814986844090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacf7ec5d973706e8239c7c6e4a470d8aba470242c7e05e69b3e24de131bdd418ae"><a name="ggacf7ec5d973706e8239c7c6e4a470d8aba470242c7e05e69b3e24de131bdd418ae"></a><a name="ggacf7ec5d973706e8239c7c6e4a470d8aba470242c7e05e69b3e24de131bdd418ae"></a></strong>WIFI_IOT_FLOW_CTRL_CTS_ONLY </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p822242029090252"><a name="p822242029090252"></a><a name="p822242029090252"></a>RTS hardware flow control enabled </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotGpioDir<a name="gab4b1fb50c758d491ba297a65e1c7a70a"></a>

```
enum [WifiIotGpioDir](wifiiot.md#gab4b1fb50c758d491ba297a65e1c7a70a)
```

 **Description:**

Enumerates GPIO directions. 

<a name="table96274609090252"></a>
<table><thead align="left"><tr id="row768764501090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1312612870090252"><a name="p1312612870090252"></a><a name="p1312612870090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1563489255090252"><a name="p1563489255090252"></a><a name="p1563489255090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row955886964090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggab4b1fb50c758d491ba297a65e1c7a70aa4cf28c4ada04aa47ffad38cf1ba4a50d"><a name="ggab4b1fb50c758d491ba297a65e1c7a70aa4cf28c4ada04aa47ffad38cf1ba4a50d"></a><a name="ggab4b1fb50c758d491ba297a65e1c7a70aa4cf28c4ada04aa47ffad38cf1ba4a50d"></a></strong>WIFI_IOT_GPIO_DIR_IN </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2057905921090252"><a name="p2057905921090252"></a><a name="p2057905921090252"></a>Input </p>
 </td>
</tr>
<tr id="row50262344090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggab4b1fb50c758d491ba297a65e1c7a70aa142b702aa598f2482ae27f7d11bdb6eb"><a name="ggab4b1fb50c758d491ba297a65e1c7a70aa142b702aa598f2482ae27f7d11bdb6eb"></a><a name="ggab4b1fb50c758d491ba297a65e1c7a70aa142b702aa598f2482ae27f7d11bdb6eb"></a></strong>WIFI_IOT_GPIO_DIR_OUT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2011591361090252"><a name="p2011591361090252"></a><a name="p2011591361090252"></a>Output </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotGpioIdx<a name="gacb21f234cf149161f1f95f3330eeb8e7"></a>

```
enum [WifiIotGpioIdx](wifiiot.md#gacb21f234cf149161f1f95f3330eeb8e7)
```

 **Description:**

Enumerates GPIO pin IDs. 

<a name="table2003123679090252"></a>
<table><thead align="left"><tr id="row1691149211090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1599109850090252"><a name="p1599109850090252"></a><a name="p1599109850090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p234373695090252"><a name="p234373695090252"></a><a name="p234373695090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1307838781090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacb21f234cf149161f1f95f3330eeb8e7ae046fd3cc933c4a52555b32e0ffdb305"><a name="ggacb21f234cf149161f1f95f3330eeb8e7ae046fd3cc933c4a52555b32e0ffdb305"></a><a name="ggacb21f234cf149161f1f95f3330eeb8e7ae046fd3cc933c4a52555b32e0ffdb305"></a></strong>WIFI_IOT_GPIO_IDX_0 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p154147079090252"><a name="p154147079090252"></a><a name="p154147079090252"></a>GPIO0 </p>
 </td>
</tr>
<tr id="row1240857272090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacb21f234cf149161f1f95f3330eeb8e7a07e8f1a810e4eea4bbf62c3090b9b2c3"><a name="ggacb21f234cf149161f1f95f3330eeb8e7a07e8f1a810e4eea4bbf62c3090b9b2c3"></a><a name="ggacb21f234cf149161f1f95f3330eeb8e7a07e8f1a810e4eea4bbf62c3090b9b2c3"></a></strong>WIFI_IOT_GPIO_IDX_1 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1878487448090252"><a name="p1878487448090252"></a><a name="p1878487448090252"></a>GPIO1 </p>
 </td>
</tr>
<tr id="row1202227246090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacb21f234cf149161f1f95f3330eeb8e7ac7c272c3c3023e61b1aa7a496ca6520e"><a name="ggacb21f234cf149161f1f95f3330eeb8e7ac7c272c3c3023e61b1aa7a496ca6520e"></a><a name="ggacb21f234cf149161f1f95f3330eeb8e7ac7c272c3c3023e61b1aa7a496ca6520e"></a></strong>WIFI_IOT_GPIO_IDX_2 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1074245767090252"><a name="p1074245767090252"></a><a name="p1074245767090252"></a>GPIO2 </p>
 </td>
</tr>
<tr id="row2009239479090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacb21f234cf149161f1f95f3330eeb8e7a4fbcd92ee8ce17811e439e9741ede927"><a name="ggacb21f234cf149161f1f95f3330eeb8e7a4fbcd92ee8ce17811e439e9741ede927"></a><a name="ggacb21f234cf149161f1f95f3330eeb8e7a4fbcd92ee8ce17811e439e9741ede927"></a></strong>WIFI_IOT_GPIO_IDX_3 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1445612002090252"><a name="p1445612002090252"></a><a name="p1445612002090252"></a>GPIO3 </p>
 </td>
</tr>
<tr id="row1842749855090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacb21f234cf149161f1f95f3330eeb8e7aa4fd128cc42f5059812f16ab7731db1f"><a name="ggacb21f234cf149161f1f95f3330eeb8e7aa4fd128cc42f5059812f16ab7731db1f"></a><a name="ggacb21f234cf149161f1f95f3330eeb8e7aa4fd128cc42f5059812f16ab7731db1f"></a></strong>WIFI_IOT_GPIO_IDX_4 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p442409811090252"><a name="p442409811090252"></a><a name="p442409811090252"></a>GPIO4 </p>
 </td>
</tr>
<tr id="row139717470090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacb21f234cf149161f1f95f3330eeb8e7a2aab1a0fc68cbbc834a8c9244e9b45f8"><a name="ggacb21f234cf149161f1f95f3330eeb8e7a2aab1a0fc68cbbc834a8c9244e9b45f8"></a><a name="ggacb21f234cf149161f1f95f3330eeb8e7a2aab1a0fc68cbbc834a8c9244e9b45f8"></a></strong>WIFI_IOT_GPIO_IDX_5 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2106172248090252"><a name="p2106172248090252"></a><a name="p2106172248090252"></a>GPIO5 </p>
 </td>
</tr>
<tr id="row477326140090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacb21f234cf149161f1f95f3330eeb8e7a01e89ab69b089341b8fc10dc6df8b5ff"><a name="ggacb21f234cf149161f1f95f3330eeb8e7a01e89ab69b089341b8fc10dc6df8b5ff"></a><a name="ggacb21f234cf149161f1f95f3330eeb8e7a01e89ab69b089341b8fc10dc6df8b5ff"></a></strong>WIFI_IOT_GPIO_IDX_6 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p764507421090252"><a name="p764507421090252"></a><a name="p764507421090252"></a>GPIO6 </p>
 </td>
</tr>
<tr id="row2052985130090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacb21f234cf149161f1f95f3330eeb8e7a035a212d1b1da2f84c7dcba0b9a5c8e6"><a name="ggacb21f234cf149161f1f95f3330eeb8e7a035a212d1b1da2f84c7dcba0b9a5c8e6"></a><a name="ggacb21f234cf149161f1f95f3330eeb8e7a035a212d1b1da2f84c7dcba0b9a5c8e6"></a></strong>WIFI_IOT_GPIO_IDX_7 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p813632648090252"><a name="p813632648090252"></a><a name="p813632648090252"></a>GPIO7 </p>
 </td>
</tr>
<tr id="row1008441422090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacb21f234cf149161f1f95f3330eeb8e7ac48a013c85a5701a8c18ce474ba76baf"><a name="ggacb21f234cf149161f1f95f3330eeb8e7ac48a013c85a5701a8c18ce474ba76baf"></a><a name="ggacb21f234cf149161f1f95f3330eeb8e7ac48a013c85a5701a8c18ce474ba76baf"></a></strong>WIFI_IOT_GPIO_IDX_8 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p117504758090252"><a name="p117504758090252"></a><a name="p117504758090252"></a>GPIO8 </p>
 </td>
</tr>
<tr id="row879030975090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacb21f234cf149161f1f95f3330eeb8e7ad4279d9a32bfaf63d1f1cf1e7bcea696"><a name="ggacb21f234cf149161f1f95f3330eeb8e7ad4279d9a32bfaf63d1f1cf1e7bcea696"></a><a name="ggacb21f234cf149161f1f95f3330eeb8e7ad4279d9a32bfaf63d1f1cf1e7bcea696"></a></strong>WIFI_IOT_GPIO_IDX_9 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1900330054090252"><a name="p1900330054090252"></a><a name="p1900330054090252"></a>GPIO9 </p>
 </td>
</tr>
<tr id="row2140362417090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacb21f234cf149161f1f95f3330eeb8e7aa3d9ce72cd5fe2382390cd74e902a033"><a name="ggacb21f234cf149161f1f95f3330eeb8e7aa3d9ce72cd5fe2382390cd74e902a033"></a><a name="ggacb21f234cf149161f1f95f3330eeb8e7aa3d9ce72cd5fe2382390cd74e902a033"></a></strong>WIFI_IOT_GPIO_IDX_10 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p39284151090252"><a name="p39284151090252"></a><a name="p39284151090252"></a>GPIO10 </p>
 </td>
</tr>
<tr id="row2126707596090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacb21f234cf149161f1f95f3330eeb8e7a596f9afca31a79a1bc43bf929c7045cd"><a name="ggacb21f234cf149161f1f95f3330eeb8e7a596f9afca31a79a1bc43bf929c7045cd"></a><a name="ggacb21f234cf149161f1f95f3330eeb8e7a596f9afca31a79a1bc43bf929c7045cd"></a></strong>WIFI_IOT_GPIO_IDX_11 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1002776837090252"><a name="p1002776837090252"></a><a name="p1002776837090252"></a>GPIO11 </p>
 </td>
</tr>
<tr id="row33663284090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacb21f234cf149161f1f95f3330eeb8e7a0e2bde0b5d0914e590803a2c280b3fcd"><a name="ggacb21f234cf149161f1f95f3330eeb8e7a0e2bde0b5d0914e590803a2c280b3fcd"></a><a name="ggacb21f234cf149161f1f95f3330eeb8e7a0e2bde0b5d0914e590803a2c280b3fcd"></a></strong>WIFI_IOT_GPIO_IDX_12 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1148225100090252"><a name="p1148225100090252"></a><a name="p1148225100090252"></a>GPIO12 </p>
 </td>
</tr>
<tr id="row226702287090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacb21f234cf149161f1f95f3330eeb8e7a46b47d9cb13dab42e31ec6c6b73447b5"><a name="ggacb21f234cf149161f1f95f3330eeb8e7a46b47d9cb13dab42e31ec6c6b73447b5"></a><a name="ggacb21f234cf149161f1f95f3330eeb8e7a46b47d9cb13dab42e31ec6c6b73447b5"></a></strong>WIFI_IOT_GPIO_IDX_13 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p117656617090252"><a name="p117656617090252"></a><a name="p117656617090252"></a>GPIO13 </p>
 </td>
</tr>
<tr id="row985314647090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacb21f234cf149161f1f95f3330eeb8e7aefb8b54fba7f3938b23a07838ab330ac"><a name="ggacb21f234cf149161f1f95f3330eeb8e7aefb8b54fba7f3938b23a07838ab330ac"></a><a name="ggacb21f234cf149161f1f95f3330eeb8e7aefb8b54fba7f3938b23a07838ab330ac"></a></strong>WIFI_IOT_GPIO_IDX_14 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1371332503090252"><a name="p1371332503090252"></a><a name="p1371332503090252"></a>GPIO14 </p>
 </td>
</tr>
<tr id="row1235106150090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacb21f234cf149161f1f95f3330eeb8e7a7d4d2abc5105e7d3f9a9a4f96e778232"><a name="ggacb21f234cf149161f1f95f3330eeb8e7a7d4d2abc5105e7d3f9a9a4f96e778232"></a><a name="ggacb21f234cf149161f1f95f3330eeb8e7a7d4d2abc5105e7d3f9a9a4f96e778232"></a></strong>WIFI_IOT_GPIO_IDX_MAX </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p936286030090252"><a name="p936286030090252"></a><a name="p936286030090252"></a>Maximum value </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotGpioIntPolarity<a name="gab81589838cedcc3933bb789c97ad3643"></a>

```
enum [WifiIotGpioIntPolarity](wifiiot.md#gab81589838cedcc3933bb789c97ad3643)
```

 **Description:**

Enumerates I/O interrupt polarities. 

<a name="table1708028833090252"></a>
<table><thead align="left"><tr id="row739000608090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p563769752090252"><a name="p563769752090252"></a><a name="p563769752090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p313550511090252"><a name="p313550511090252"></a><a name="p313550511090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1950999182090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggab81589838cedcc3933bb789c97ad3643a31fc3445fff6122de496652f3e9023cd"><a name="ggab81589838cedcc3933bb789c97ad3643a31fc3445fff6122de496652f3e9023cd"></a><a name="ggab81589838cedcc3933bb789c97ad3643a31fc3445fff6122de496652f3e9023cd"></a></strong>WIFI_IOT_GPIO_EDGE_FALL_LEVEL_LOW </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1747173295090252"><a name="p1747173295090252"></a><a name="p1747173295090252"></a>Interrupt at a low level or falling edge </p>
 </td>
</tr>
<tr id="row1225013879090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggab81589838cedcc3933bb789c97ad3643ac1c7abc9c4ecc8c336160a1c36d3bfed"><a name="ggab81589838cedcc3933bb789c97ad3643ac1c7abc9c4ecc8c336160a1c36d3bfed"></a><a name="ggab81589838cedcc3933bb789c97ad3643ac1c7abc9c4ecc8c336160a1c36d3bfed"></a></strong>WIFI_IOT_GPIO_EDGE_RISE_LEVEL_HIGH </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1585314679090252"><a name="p1585314679090252"></a><a name="p1585314679090252"></a>Interrupt at a high level or rising edge </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotGpioIntType<a name="gac8eb8ad448903ed52c96ccc675e81f94"></a>

```
enum [WifiIotGpioIntType](wifiiot.md#gac8eb8ad448903ed52c96ccc675e81f94)
```

 **Description:**

Enumerates GPIO interrupt trigger modes. 

<a name="table1637931213090252"></a>
<table><thead align="left"><tr id="row1600830799090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2017578460090252"><a name="p2017578460090252"></a><a name="p2017578460090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p28518060090252"><a name="p28518060090252"></a><a name="p28518060090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row797805088090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggac8eb8ad448903ed52c96ccc675e81f94ab195772135577e55af672a4e40cb7cfe"><a name="ggac8eb8ad448903ed52c96ccc675e81f94ab195772135577e55af672a4e40cb7cfe"></a><a name="ggac8eb8ad448903ed52c96ccc675e81f94ab195772135577e55af672a4e40cb7cfe"></a></strong>WIFI_IOT_INT_TYPE_LEVEL </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1055429194090252"><a name="p1055429194090252"></a><a name="p1055429194090252"></a>Level-sensitive interrupt </p>
 </td>
</tr>
<tr id="row1975766888090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggac8eb8ad448903ed52c96ccc675e81f94ab06457c13bf24678921dd844e5380b68"><a name="ggac8eb8ad448903ed52c96ccc675e81f94ab06457c13bf24678921dd844e5380b68"></a><a name="ggac8eb8ad448903ed52c96ccc675e81f94ab06457c13bf24678921dd844e5380b68"></a></strong>WIFI_IOT_INT_TYPE_EDGE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1176014977090252"><a name="p1176014977090252"></a><a name="p1176014977090252"></a>Edge-sensitive interrupt </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotGpioValue<a name="gac9095d1db72e5046b2ec1895aaec0e6b"></a>

```
enum [WifiIotGpioValue](wifiiot.md#gac9095d1db72e5046b2ec1895aaec0e6b)
```

 **Description:**

Enumerates GPIO level values. 

<a name="table1681142041090252"></a>
<table><thead align="left"><tr id="row1890362906090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1565559354090252"><a name="p1565559354090252"></a><a name="p1565559354090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p981524466090252"><a name="p981524466090252"></a><a name="p981524466090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row957900503090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggac9095d1db72e5046b2ec1895aaec0e6ba5af1f302a77089f4310cafdf0f19a8e9"><a name="ggac9095d1db72e5046b2ec1895aaec0e6ba5af1f302a77089f4310cafdf0f19a8e9"></a><a name="ggac9095d1db72e5046b2ec1895aaec0e6ba5af1f302a77089f4310cafdf0f19a8e9"></a></strong>WIFI_IOT_GPIO_VALUE0 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p415608403090252"><a name="p415608403090252"></a><a name="p415608403090252"></a>Low GPIO level </p>
 </td>
</tr>
<tr id="row857241691090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggac9095d1db72e5046b2ec1895aaec0e6ba13488c68c87449410ef3de8855025708"><a name="ggac9095d1db72e5046b2ec1895aaec0e6ba13488c68c87449410ef3de8855025708"></a><a name="ggac9095d1db72e5046b2ec1895aaec0e6ba13488c68c87449410ef3de8855025708"></a></strong>WIFI_IOT_GPIO_VALUE1 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1082049582090252"><a name="p1082049582090252"></a><a name="p1082049582090252"></a>High GPIO level </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotI2cIdx<a name="gaeeb58e02e3783d02e1ed4bad313cc0b8"></a>

```
enum [WifiIotI2cIdx](wifiiot.md#gaeeb58e02e3783d02e1ed4bad313cc0b8)
```

 **Description:**

Enumerates I2C hardware indexes. 

<a name="table1588338082090252"></a>
<table><thead align="left"><tr id="row1907118081090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p657069743090252"><a name="p657069743090252"></a><a name="p657069743090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1504109213090252"><a name="p1504109213090252"></a><a name="p1504109213090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1182556049090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaeeb58e02e3783d02e1ed4bad313cc0b8a626c3ef4caf51e1f1f7d8b4413e399bb"><a name="ggaeeb58e02e3783d02e1ed4bad313cc0b8a626c3ef4caf51e1f1f7d8b4413e399bb"></a><a name="ggaeeb58e02e3783d02e1ed4bad313cc0b8a626c3ef4caf51e1f1f7d8b4413e399bb"></a></strong>WIFI_IOT_I2C_IDX_0 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1601743810090252"><a name="p1601743810090252"></a><a name="p1601743810090252"></a>I2C hardware index 0 </p>
 </td>
</tr>
<tr id="row844329730090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaeeb58e02e3783d02e1ed4bad313cc0b8ad35ceb88fb8b4b6b9cb123d4d32b9316"><a name="ggaeeb58e02e3783d02e1ed4bad313cc0b8ad35ceb88fb8b4b6b9cb123d4d32b9316"></a><a name="ggaeeb58e02e3783d02e1ed4bad313cc0b8ad35ceb88fb8b4b6b9cb123d4d32b9316"></a></strong>WIFI_IOT_I2C_IDX_1 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p413967713090252"><a name="p413967713090252"></a><a name="p413967713090252"></a>I2C hardware index 1 </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotI2sResolution<a name="gac024b870d63e802d8119e88a82953807"></a>

```
enum [WifiIotI2sResolution](wifiiot.md#gac024b870d63e802d8119e88a82953807)
```

 **Description:**

Enumerates I2S resolution. 

<a name="table136763987090252"></a>
<table><thead align="left"><tr id="row1128313227090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1904592858090252"><a name="p1904592858090252"></a><a name="p1904592858090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1062073993090252"><a name="p1062073993090252"></a><a name="p1062073993090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2002467635090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggac024b870d63e802d8119e88a82953807af441b8fd738e63fc6237077d018b0eda"><a name="ggac024b870d63e802d8119e88a82953807af441b8fd738e63fc6237077d018b0eda"></a><a name="ggac024b870d63e802d8119e88a82953807af441b8fd738e63fc6237077d018b0eda"></a></strong>WIFI_IOT_I2S_RESOLUTION_16BIT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p608896241090252"><a name="p608896241090252"></a><a name="p608896241090252"></a>16-bit resolution </p>
 </td>
</tr>
<tr id="row114779894090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggac024b870d63e802d8119e88a82953807a0a73e0bc3019668a6d75a1200a899db9"><a name="ggac024b870d63e802d8119e88a82953807a0a73e0bc3019668a6d75a1200a899db9"></a><a name="ggac024b870d63e802d8119e88a82953807a0a73e0bc3019668a6d75a1200a899db9"></a></strong>WIFI_IOT_I2S_RESOLUTION_24BIT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p768876609090252"><a name="p768876609090252"></a><a name="p768876609090252"></a>24-bit resolution </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotI2sSampleRate<a name="ga5e124d70b18cf4cff40bcce78445f689"></a>

```
enum [WifiIotI2sSampleRate](wifiiot.md#ga5e124d70b18cf4cff40bcce78445f689)
```

 **Description:**

Enumerates I2S sampling rates. 

<a name="table1520893743090252"></a>
<table><thead align="left"><tr id="row978303537090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p822482438090252"><a name="p822482438090252"></a><a name="p822482438090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1454229779090252"><a name="p1454229779090252"></a><a name="p1454229779090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1572966635090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga5e124d70b18cf4cff40bcce78445f689ace40be85474a4c93a09f249c217a6e41"><a name="gga5e124d70b18cf4cff40bcce78445f689ace40be85474a4c93a09f249c217a6e41"></a><a name="gga5e124d70b18cf4cff40bcce78445f689ace40be85474a4c93a09f249c217a6e41"></a></strong>WIFI_IOT_I2S_SAMPLE_RATE_8K </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p642282166090252"><a name="p642282166090252"></a><a name="p642282166090252"></a>8K sampling rate </p>
 </td>
</tr>
<tr id="row1233590930090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga5e124d70b18cf4cff40bcce78445f689a70144626b7f06acc91ca0439d44ad1b7"><a name="gga5e124d70b18cf4cff40bcce78445f689a70144626b7f06acc91ca0439d44ad1b7"></a><a name="gga5e124d70b18cf4cff40bcce78445f689a70144626b7f06acc91ca0439d44ad1b7"></a></strong>WIFI_IOT_I2S_SAMPLE_RATE_16K </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1788607279090252"><a name="p1788607279090252"></a><a name="p1788607279090252"></a>16K sampling rate </p>
 </td>
</tr>
<tr id="row403679463090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga5e124d70b18cf4cff40bcce78445f689a4ccb67a70dc96f4faf074ab676728258"><a name="gga5e124d70b18cf4cff40bcce78445f689a4ccb67a70dc96f4faf074ab676728258"></a><a name="gga5e124d70b18cf4cff40bcce78445f689a4ccb67a70dc96f4faf074ab676728258"></a></strong>WIFI_IOT_I2S_SAMPLE_RATE_32K </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2085703643090252"><a name="p2085703643090252"></a><a name="p2085703643090252"></a>32K sampling rate </p>
 </td>
</tr>
<tr id="row1924203537090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga5e124d70b18cf4cff40bcce78445f689aa8987a10f3c5206bae1f875d45cc854c"><a name="gga5e124d70b18cf4cff40bcce78445f689aa8987a10f3c5206bae1f875d45cc854c"></a><a name="gga5e124d70b18cf4cff40bcce78445f689aa8987a10f3c5206bae1f875d45cc854c"></a></strong>WIFI_IOT_I2S_SAMPLE_RATE_48K </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p688146702090252"><a name="p688146702090252"></a><a name="p688146702090252"></a>48K sampling rate </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotIoDriverStrength<a name="gae97ab4109f511ceeee889dba9e79a968"></a>

```
enum [WifiIotIoDriverStrength](wifiiot.md#gae97ab4109f511ceeee889dba9e79a968)
```

 **Description:**

Enumerates I/O driver strength levels. 

<a name="table1849723525090252"></a>
<table><thead align="left"><tr id="row4404625090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p180918416090252"><a name="p180918416090252"></a><a name="p180918416090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p710487179090252"><a name="p710487179090252"></a><a name="p710487179090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1327824569090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae97ab4109f511ceeee889dba9e79a968a3640019ffd659132e3cb7ca0d91451b0"><a name="ggae97ab4109f511ceeee889dba9e79a968a3640019ffd659132e3cb7ca0d91451b0"></a><a name="ggae97ab4109f511ceeee889dba9e79a968a3640019ffd659132e3cb7ca0d91451b0"></a></strong>WIFI_IOT_IO_DRIVER_STRENGTH_0 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p293169575090252"><a name="p293169575090252"></a><a name="p293169575090252"></a>Driver strength level 0 (highest) </p>
 </td>
</tr>
<tr id="row309407475090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae97ab4109f511ceeee889dba9e79a968a1c4db14256c5ad110440d2b124f104bd"><a name="ggae97ab4109f511ceeee889dba9e79a968a1c4db14256c5ad110440d2b124f104bd"></a><a name="ggae97ab4109f511ceeee889dba9e79a968a1c4db14256c5ad110440d2b124f104bd"></a></strong>WIFI_IOT_IO_DRIVER_STRENGTH_1 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1613494058090252"><a name="p1613494058090252"></a><a name="p1613494058090252"></a>Driver strength level 1 </p>
 </td>
</tr>
<tr id="row1650312356090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae97ab4109f511ceeee889dba9e79a968a6626c0ecb0ac767493f3705d91045c33"><a name="ggae97ab4109f511ceeee889dba9e79a968a6626c0ecb0ac767493f3705d91045c33"></a><a name="ggae97ab4109f511ceeee889dba9e79a968a6626c0ecb0ac767493f3705d91045c33"></a></strong>WIFI_IOT_IO_DRIVER_STRENGTH_2 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1569603000090252"><a name="p1569603000090252"></a><a name="p1569603000090252"></a>Driver strength level 2 </p>
 </td>
</tr>
<tr id="row613404782090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae97ab4109f511ceeee889dba9e79a968a1eb7957f7c27f4e347ee9779fa5cf525"><a name="ggae97ab4109f511ceeee889dba9e79a968a1eb7957f7c27f4e347ee9779fa5cf525"></a><a name="ggae97ab4109f511ceeee889dba9e79a968a1eb7957f7c27f4e347ee9779fa5cf525"></a></strong>WIFI_IOT_IO_DRIVER_STRENGTH_3 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1171434515090252"><a name="p1171434515090252"></a><a name="p1171434515090252"></a>Driver strength level 3 </p>
 </td>
</tr>
<tr id="row1076680022090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae97ab4109f511ceeee889dba9e79a968ab073c01bd41de1e31b8850e7c927a9c0"><a name="ggae97ab4109f511ceeee889dba9e79a968ab073c01bd41de1e31b8850e7c927a9c0"></a><a name="ggae97ab4109f511ceeee889dba9e79a968ab073c01bd41de1e31b8850e7c927a9c0"></a></strong>WIFI_IOT_IO_DRIVER_STRENGTH_4 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p16818820090252"><a name="p16818820090252"></a><a name="p16818820090252"></a>Driver strength level 4 </p>
 </td>
</tr>
<tr id="row1768431655090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae97ab4109f511ceeee889dba9e79a968a0daaac21180250d6f49dfc4de4c441fb"><a name="ggae97ab4109f511ceeee889dba9e79a968a0daaac21180250d6f49dfc4de4c441fb"></a><a name="ggae97ab4109f511ceeee889dba9e79a968a0daaac21180250d6f49dfc4de4c441fb"></a></strong>WIFI_IOT_IO_DRIVER_STRENGTH_5 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p392842101090252"><a name="p392842101090252"></a><a name="p392842101090252"></a>Driver strength level 5 </p>
 </td>
</tr>
<tr id="row1234921258090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae97ab4109f511ceeee889dba9e79a968ae966a5dd645a6699507b6901c2a02734"><a name="ggae97ab4109f511ceeee889dba9e79a968ae966a5dd645a6699507b6901c2a02734"></a><a name="ggae97ab4109f511ceeee889dba9e79a968ae966a5dd645a6699507b6901c2a02734"></a></strong>WIFI_IOT_IO_DRIVER_STRENGTH_6 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p893651888090252"><a name="p893651888090252"></a><a name="p893651888090252"></a>Driver strength level 6 </p>
 </td>
</tr>
<tr id="row299520897090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae97ab4109f511ceeee889dba9e79a968a048d5db3385e0e40561af665b6dc914f"><a name="ggae97ab4109f511ceeee889dba9e79a968a048d5db3385e0e40561af665b6dc914f"></a><a name="ggae97ab4109f511ceeee889dba9e79a968a048d5db3385e0e40561af665b6dc914f"></a></strong>WIFI_IOT_IO_DRIVER_STRENGTH_7 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1268922926090252"><a name="p1268922926090252"></a><a name="p1268922926090252"></a>Driver strength level 7 (lowest) </p>
 </td>
</tr>
<tr id="row960742579090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae97ab4109f511ceeee889dba9e79a968a6a751b7c9907d1ac9eb89be807c13506"><a name="ggae97ab4109f511ceeee889dba9e79a968a6a751b7c9907d1ac9eb89be807c13506"></a><a name="ggae97ab4109f511ceeee889dba9e79a968a6a751b7c9907d1ac9eb89be807c13506"></a></strong>WIFI_IOT_IO_DRIVER_STRENGTH_MAX </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1150445980090252"><a name="p1150445980090252"></a><a name="p1150445980090252"></a>Maximum value </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotIoFuncGpio0<a name="ga2b08eb2a302e2c4fa216a1373bea4a01"></a>

```
enum [WifiIotIoFuncGpio0](wifiiot.md#ga2b08eb2a302e2c4fa216a1373bea4a01)
```

 **Description:**

Enumerates the functions of GPIO hardware pin 0. 

<a name="table3470007090252"></a>
<table><thead align="left"><tr id="row1206919752090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1255377620090252"><a name="p1255377620090252"></a><a name="p1255377620090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p866560469090252"><a name="p866560469090252"></a><a name="p866560469090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row129805518090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2b08eb2a302e2c4fa216a1373bea4a01afb74c7f71f79f223937187b960cd5366"><a name="gga2b08eb2a302e2c4fa216a1373bea4a01afb74c7f71f79f223937187b960cd5366"></a><a name="gga2b08eb2a302e2c4fa216a1373bea4a01afb74c7f71f79f223937187b960cd5366"></a></strong>WIFI_IOT_IO_FUNC_GPIO_0_GPIO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1393015698090252"><a name="p1393015698090252"></a><a name="p1393015698090252"></a>GPIO0 function </p>
 </td>
</tr>
<tr id="row2076097900090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2b08eb2a302e2c4fa216a1373bea4a01a56f807eaf7e6c867430756964f5fd895"><a name="gga2b08eb2a302e2c4fa216a1373bea4a01a56f807eaf7e6c867430756964f5fd895"></a><a name="gga2b08eb2a302e2c4fa216a1373bea4a01a56f807eaf7e6c867430756964f5fd895"></a></strong>WIFI_IOT_IO_FUNC_GPIO_0_UART1_TXD </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2105768560090252"><a name="p2105768560090252"></a><a name="p2105768560090252"></a>Functions of UART1 TXD </p>
 </td>
</tr>
<tr id="row1993869352090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2b08eb2a302e2c4fa216a1373bea4a01aa918b50f788a9260b8f76d3e3122b113"><a name="gga2b08eb2a302e2c4fa216a1373bea4a01aa918b50f788a9260b8f76d3e3122b113"></a><a name="gga2b08eb2a302e2c4fa216a1373bea4a01aa918b50f788a9260b8f76d3e3122b113"></a></strong>WIFI_IOT_IO_FUNC_GPIO_0_SPI1_CK </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p235923582090252"><a name="p235923582090252"></a><a name="p235923582090252"></a>SPI1 CK function </p>
 </td>
</tr>
<tr id="row1694585092090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2b08eb2a302e2c4fa216a1373bea4a01a5f47990c1eac7597fe91c101ce0a1925"><a name="gga2b08eb2a302e2c4fa216a1373bea4a01a5f47990c1eac7597fe91c101ce0a1925"></a><a name="gga2b08eb2a302e2c4fa216a1373bea4a01a5f47990c1eac7597fe91c101ce0a1925"></a></strong>WIFI_IOT_IO_FUNC_GPIO_0_JTAG_TDO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1013331633090252"><a name="p1013331633090252"></a><a name="p1013331633090252"></a>Functions of JTAG TD0 </p>
 </td>
</tr>
<tr id="row842882446090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2b08eb2a302e2c4fa216a1373bea4a01ace60a126e858f4281a4cc7d7a2cd4e0c"><a name="gga2b08eb2a302e2c4fa216a1373bea4a01ace60a126e858f4281a4cc7d7a2cd4e0c"></a><a name="gga2b08eb2a302e2c4fa216a1373bea4a01ace60a126e858f4281a4cc7d7a2cd4e0c"></a></strong>WIFI_IOT_IO_FUNC_GPIO_0_PWM3_OUT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1286029296090252"><a name="p1286029296090252"></a><a name="p1286029296090252"></a>PWM3 OUT function </p>
 </td>
</tr>
<tr id="row1672540220090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2b08eb2a302e2c4fa216a1373bea4a01a17f92e6fa9b18b21f0749889fdb2a827"><a name="gga2b08eb2a302e2c4fa216a1373bea4a01a17f92e6fa9b18b21f0749889fdb2a827"></a><a name="gga2b08eb2a302e2c4fa216a1373bea4a01a17f92e6fa9b18b21f0749889fdb2a827"></a></strong>WIFI_IOT_IO_FUNC_GPIO_0_I2C1_SDA </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p774802480090252"><a name="p774802480090252"></a><a name="p774802480090252"></a>I2C1 SDA function </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotIoFuncGpio10<a name="gad4670688ad729f40424bccfeb1afc3b2"></a>

```
enum [WifiIotIoFuncGpio10](wifiiot.md#gad4670688ad729f40424bccfeb1afc3b2)
```

 **Description:**

Enumerates the functions of GPIO hardware pin 10. 

<a name="table1026671836090252"></a>
<table><thead align="left"><tr id="row1054730259090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1994885180090252"><a name="p1994885180090252"></a><a name="p1994885180090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p488555062090252"><a name="p488555062090252"></a><a name="p488555062090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1640443183090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggad4670688ad729f40424bccfeb1afc3b2a980bb121945c694bbe897de946945267"><a name="ggad4670688ad729f40424bccfeb1afc3b2a980bb121945c694bbe897de946945267"></a><a name="ggad4670688ad729f40424bccfeb1afc3b2a980bb121945c694bbe897de946945267"></a></strong>WIFI_IOT_IO_FUNC_GPIO_10_GPIO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1114803407090252"><a name="p1114803407090252"></a><a name="p1114803407090252"></a>GPIO10 function </p>
 </td>
</tr>
<tr id="row585879027090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggad4670688ad729f40424bccfeb1afc3b2acfb8d0df44e655a80d5788dddd08804b"><a name="ggad4670688ad729f40424bccfeb1afc3b2acfb8d0df44e655a80d5788dddd08804b"></a><a name="ggad4670688ad729f40424bccfeb1afc3b2acfb8d0df44e655a80d5788dddd08804b"></a></strong>WIFI_IOT_IO_FUNC_GPIO_10_I2C0_SDA </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1488568471090252"><a name="p1488568471090252"></a><a name="p1488568471090252"></a>I2C0 SDA function </p>
 </td>
</tr>
<tr id="row971803474090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggad4670688ad729f40424bccfeb1afc3b2a71e59d7f1ef0e39a776a9b2513bf4542"><a name="ggad4670688ad729f40424bccfeb1afc3b2a71e59d7f1ef0e39a776a9b2513bf4542"></a><a name="ggad4670688ad729f40424bccfeb1afc3b2a71e59d7f1ef0e39a776a9b2513bf4542"></a></strong>WIFI_IOT_IO_FUNC_GPIO_10_UART2_CTS_N </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1119536238090252"><a name="p1119536238090252"></a><a name="p1119536238090252"></a>UART2 CTS function </p>
 </td>
</tr>
<tr id="row858137909090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggad4670688ad729f40424bccfeb1afc3b2aa0b0898a65f7ac13a733fcba77bc21d0"><a name="ggad4670688ad729f40424bccfeb1afc3b2aa0b0898a65f7ac13a733fcba77bc21d0"></a><a name="ggad4670688ad729f40424bccfeb1afc3b2aa0b0898a65f7ac13a733fcba77bc21d0"></a></strong>WIFI_IOT_IO_FUNC_GPIO_10_SDIO_D3 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1579200320090252"><a name="p1579200320090252"></a><a name="p1579200320090252"></a>SDIO D3 function </p>
 </td>
</tr>
<tr id="row967171455090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggad4670688ad729f40424bccfeb1afc3b2aaf71bf6e3ffc24dfa41be0ef7d30a7a4"><a name="ggad4670688ad729f40424bccfeb1afc3b2aaf71bf6e3ffc24dfa41be0ef7d30a7a4"></a><a name="ggad4670688ad729f40424bccfeb1afc3b2aaf71bf6e3ffc24dfa41be0ef7d30a7a4"></a></strong>WIFI_IOT_IO_FUNC_GPIO_10_SPI0_CK </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2043194037090252"><a name="p2043194037090252"></a><a name="p2043194037090252"></a>SPI0 CK function </p>
 </td>
</tr>
<tr id="row1870995801090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggad4670688ad729f40424bccfeb1afc3b2a273d2a5cc021d3f70de7598706da190b"><a name="ggad4670688ad729f40424bccfeb1afc3b2a273d2a5cc021d3f70de7598706da190b"></a><a name="ggad4670688ad729f40424bccfeb1afc3b2a273d2a5cc021d3f70de7598706da190b"></a></strong>WIFI_IOT_IO_FUNC_GPIO_10_PWM1_OUT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p743841891090252"><a name="p743841891090252"></a><a name="p743841891090252"></a>PWM1 OUT function </p>
 </td>
</tr>
<tr id="row1560746740090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggad4670688ad729f40424bccfeb1afc3b2a3659f2aa6eda13221af2782569b7f7ba"><a name="ggad4670688ad729f40424bccfeb1afc3b2a3659f2aa6eda13221af2782569b7f7ba"></a><a name="ggad4670688ad729f40424bccfeb1afc3b2a3659f2aa6eda13221af2782569b7f7ba"></a></strong>WIFI_IOT_IO_FUNC_GPIO_10_I2S0_TX </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2038823231090252"><a name="p2038823231090252"></a><a name="p2038823231090252"></a>I2S0 TX function </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotIoFuncGpio11<a name="ga5099248aa82355e85ba5a6227f2ab1a7"></a>

```
enum [WifiIotIoFuncGpio11](wifiiot.md#ga5099248aa82355e85ba5a6227f2ab1a7)
```

 **Description:**

Enumerates the functions of GPIO hardware pin 11. 

<a name="table658032548090252"></a>
<table><thead align="left"><tr id="row1057483948090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1116471208090252"><a name="p1116471208090252"></a><a name="p1116471208090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1360144500090252"><a name="p1360144500090252"></a><a name="p1360144500090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1542288411090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga5099248aa82355e85ba5a6227f2ab1a7aa4116d6aa72f96dd5b9ef648ef642be3"><a name="gga5099248aa82355e85ba5a6227f2ab1a7aa4116d6aa72f96dd5b9ef648ef642be3"></a><a name="gga5099248aa82355e85ba5a6227f2ab1a7aa4116d6aa72f96dd5b9ef648ef642be3"></a></strong>WIFI_IOT_IO_FUNC_GPIO_11_GPIO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1528537150090252"><a name="p1528537150090252"></a><a name="p1528537150090252"></a>GPIO11 function </p>
 </td>
</tr>
<tr id="row2074668048090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga5099248aa82355e85ba5a6227f2ab1a7a6a1f4f4f8d97c39820c4d2b0a41d8e57"><a name="gga5099248aa82355e85ba5a6227f2ab1a7a6a1f4f4f8d97c39820c4d2b0a41d8e57"></a><a name="gga5099248aa82355e85ba5a6227f2ab1a7a6a1f4f4f8d97c39820c4d2b0a41d8e57"></a></strong>WIFI_IOT_IO_FUNC_GPIO_11_UART2_TXD </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1713411304090252"><a name="p1713411304090252"></a><a name="p1713411304090252"></a>UART2 TXD function </p>
 </td>
</tr>
<tr id="row851902738090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga5099248aa82355e85ba5a6227f2ab1a7aa9313853653525a833917ed4d964741d"><a name="gga5099248aa82355e85ba5a6227f2ab1a7aa9313853653525a833917ed4d964741d"></a><a name="gga5099248aa82355e85ba5a6227f2ab1a7aa9313853653525a833917ed4d964741d"></a></strong>WIFI_IOT_IO_FUNC_GPIO_11_SDIO_CMD </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p533124427090252"><a name="p533124427090252"></a><a name="p533124427090252"></a>SDIO CMD function </p>
 </td>
</tr>
<tr id="row1857842461090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga5099248aa82355e85ba5a6227f2ab1a7a144ce7df4661202d80898acb2ade8b24"><a name="gga5099248aa82355e85ba5a6227f2ab1a7a144ce7df4661202d80898acb2ade8b24"></a><a name="gga5099248aa82355e85ba5a6227f2ab1a7a144ce7df4661202d80898acb2ade8b24"></a></strong>WIFI_IOT_IO_FUNC_GPIO_11_SPI0_RXD </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1473582447090252"><a name="p1473582447090252"></a><a name="p1473582447090252"></a>SDIO RXD function </p>
 </td>
</tr>
<tr id="row1556436523090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga5099248aa82355e85ba5a6227f2ab1a7a51f2c16d8b2df9e730fb919db696c3dc"><a name="gga5099248aa82355e85ba5a6227f2ab1a7a51f2c16d8b2df9e730fb919db696c3dc"></a><a name="gga5099248aa82355e85ba5a6227f2ab1a7a51f2c16d8b2df9e730fb919db696c3dc"></a></strong>WIFI_IOT_IO_FUNC_GPIO_11_PWM2_OUT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1942072714090252"><a name="p1942072714090252"></a><a name="p1942072714090252"></a>PWM2 OUT function </p>
 </td>
</tr>
<tr id="row1037544396090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga5099248aa82355e85ba5a6227f2ab1a7aa6da0b5b2e9c8ba7657e995969f0db7b"><a name="gga5099248aa82355e85ba5a6227f2ab1a7aa6da0b5b2e9c8ba7657e995969f0db7b"></a><a name="gga5099248aa82355e85ba5a6227f2ab1a7aa6da0b5b2e9c8ba7657e995969f0db7b"></a></strong>WIFI_IOT_IO_FUNC_GPIO_11_RF_TX_EN_EXT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1835974513090252"><a name="p1835974513090252"></a><a name="p1835974513090252"></a>RF TX_EN_EXT function </p>
 </td>
</tr>
<tr id="row1442983686090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga5099248aa82355e85ba5a6227f2ab1a7a04954f86710fcfd0ddf5cc7bcb5e09ee"><a name="gga5099248aa82355e85ba5a6227f2ab1a7a04954f86710fcfd0ddf5cc7bcb5e09ee"></a><a name="gga5099248aa82355e85ba5a6227f2ab1a7a04954f86710fcfd0ddf5cc7bcb5e09ee"></a></strong>WIFI_IOT_IO_FUNC_GPIO_11_I2S0_RX </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1180435050090252"><a name="p1180435050090252"></a><a name="p1180435050090252"></a>I2S0 RX function </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotIoFuncGpio12<a name="gaed0008f886fc864d90f6d1c2ae9677a0"></a>

```
enum [WifiIotIoFuncGpio12](wifiiot.md#gaed0008f886fc864d90f6d1c2ae9677a0)
```

 **Description:**

Enumerates the functions of GPIO hardware pin 12. 

<a name="table157312806090252"></a>
<table><thead align="left"><tr id="row638300084090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p937520734090252"><a name="p937520734090252"></a><a name="p937520734090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p732155262090252"><a name="p732155262090252"></a><a name="p732155262090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row118064625090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaed0008f886fc864d90f6d1c2ae9677a0a51521f4b32e2bf093ac6d1adf2489ad3"><a name="ggaed0008f886fc864d90f6d1c2ae9677a0a51521f4b32e2bf093ac6d1adf2489ad3"></a><a name="ggaed0008f886fc864d90f6d1c2ae9677a0a51521f4b32e2bf093ac6d1adf2489ad3"></a></strong>WIFI_IOT_IO_FUNC_GPIO_12_GPIO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2075112625090252"><a name="p2075112625090252"></a><a name="p2075112625090252"></a>GPIO12 function </p>
 </td>
</tr>
<tr id="row609106525090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaed0008f886fc864d90f6d1c2ae9677a0a72cfe0d59218319d28b82c996e8061dc"><a name="ggaed0008f886fc864d90f6d1c2ae9677a0a72cfe0d59218319d28b82c996e8061dc"></a><a name="ggaed0008f886fc864d90f6d1c2ae9677a0a72cfe0d59218319d28b82c996e8061dc"></a></strong>WIFI_IOT_IO_FUNC_GPIO_12_UART2_RXD </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p691107572090252"><a name="p691107572090252"></a><a name="p691107572090252"></a>SUART2 RXD function </p>
 </td>
</tr>
<tr id="row833680520090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaed0008f886fc864d90f6d1c2ae9677a0adb573f70a428b79007c934637f954f45"><a name="ggaed0008f886fc864d90f6d1c2ae9677a0adb573f70a428b79007c934637f954f45"></a><a name="ggaed0008f886fc864d90f6d1c2ae9677a0adb573f70a428b79007c934637f954f45"></a></strong>WIFI_IOT_IO_FUNC_GPIO_12_SDIO_CLK </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p634000406090252"><a name="p634000406090252"></a><a name="p634000406090252"></a>SDIO CLK function </p>
 </td>
</tr>
<tr id="row876404430090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaed0008f886fc864d90f6d1c2ae9677a0a5b8d84bb7b7729bb039d1d862064a505"><a name="ggaed0008f886fc864d90f6d1c2ae9677a0a5b8d84bb7b7729bb039d1d862064a505"></a><a name="ggaed0008f886fc864d90f6d1c2ae9677a0a5b8d84bb7b7729bb039d1d862064a505"></a></strong>WIFI_IOT_IO_FUNC_GPIO_12_SPI0_CSN </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1906964685090252"><a name="p1906964685090252"></a><a name="p1906964685090252"></a>SDIO CSN function </p>
 </td>
</tr>
<tr id="row1611136212090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaed0008f886fc864d90f6d1c2ae9677a0a6ec0171f11721b9c27b7182167de4ca7"><a name="ggaed0008f886fc864d90f6d1c2ae9677a0a6ec0171f11721b9c27b7182167de4ca7"></a><a name="ggaed0008f886fc864d90f6d1c2ae9677a0a6ec0171f11721b9c27b7182167de4ca7"></a></strong>WIFI_IOT_IO_FUNC_GPIO_12_PWM3_OUT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1124197627090252"><a name="p1124197627090252"></a><a name="p1124197627090252"></a>PWM3 OUT function </p>
 </td>
</tr>
<tr id="row1772329749090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaed0008f886fc864d90f6d1c2ae9677a0a93a3914b6cf990c5a31ba21fc68b37c8"><a name="ggaed0008f886fc864d90f6d1c2ae9677a0a93a3914b6cf990c5a31ba21fc68b37c8"></a><a name="ggaed0008f886fc864d90f6d1c2ae9677a0a93a3914b6cf990c5a31ba21fc68b37c8"></a></strong>WIFI_IOT_IO_FUNC_GPIO_12_RF_RX_EN_EXT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1639987036090252"><a name="p1639987036090252"></a><a name="p1639987036090252"></a>RF RX_EN_EXT function </p>
 </td>
</tr>
<tr id="row1408119683090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaed0008f886fc864d90f6d1c2ae9677a0a42708c43bf265eae320df358fd737146"><a name="ggaed0008f886fc864d90f6d1c2ae9677a0a42708c43bf265eae320df358fd737146"></a><a name="ggaed0008f886fc864d90f6d1c2ae9677a0a42708c43bf265eae320df358fd737146"></a></strong>WIFI_IOT_IO_FUNC_GPIO_12_I2S0_BCLK </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p801984289090252"><a name="p801984289090252"></a><a name="p801984289090252"></a>I2S0 BCLK function </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotIoFuncGpio13<a name="ga364b7c7cc88086ad40c4c3d2dd098648"></a>

```
enum [WifiIotIoFuncGpio13](wifiiot.md#ga364b7c7cc88086ad40c4c3d2dd098648)
```

 **Description:**

Enumerates the functions of GPIO hardware pin 13. 

<a name="table493662412090252"></a>
<table><thead align="left"><tr id="row488139781090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p559187620090252"><a name="p559187620090252"></a><a name="p559187620090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1821559668090252"><a name="p1821559668090252"></a><a name="p1821559668090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row106068813090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga364b7c7cc88086ad40c4c3d2dd098648a0f2b57575a4463b8cb0141f2313f5ad7"><a name="gga364b7c7cc88086ad40c4c3d2dd098648a0f2b57575a4463b8cb0141f2313f5ad7"></a><a name="gga364b7c7cc88086ad40c4c3d2dd098648a0f2b57575a4463b8cb0141f2313f5ad7"></a></strong>WIFI_IOT_IO_FUNC_GPIO_13_SSI_DATA </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1409933886090252"><a name="p1409933886090252"></a><a name="p1409933886090252"></a>SSI DATA function </p>
 </td>
</tr>
<tr id="row77202897090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga364b7c7cc88086ad40c4c3d2dd098648a8605c5abf1d51e5f279345cb1b7ee93b"><a name="gga364b7c7cc88086ad40c4c3d2dd098648a8605c5abf1d51e5f279345cb1b7ee93b"></a><a name="gga364b7c7cc88086ad40c4c3d2dd098648a8605c5abf1d51e5f279345cb1b7ee93b"></a></strong>WIFI_IOT_IO_FUNC_GPIO_13_UART0_TXD </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p917730666090252"><a name="p917730666090252"></a><a name="p917730666090252"></a>UART0 TXD function </p>
 </td>
</tr>
<tr id="row763241281090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga364b7c7cc88086ad40c4c3d2dd098648a6300109a97003b70942f0157bdbd93a2"><a name="gga364b7c7cc88086ad40c4c3d2dd098648a6300109a97003b70942f0157bdbd93a2"></a><a name="gga364b7c7cc88086ad40c4c3d2dd098648a6300109a97003b70942f0157bdbd93a2"></a></strong>WIFI_IOT_IO_FUNC_GPIO_13_UART2_RTS_N </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1717438361090252"><a name="p1717438361090252"></a><a name="p1717438361090252"></a>UART2 RTS function </p>
 </td>
</tr>
<tr id="row1193179892090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga364b7c7cc88086ad40c4c3d2dd098648a041cef6b72032e671fa448e2ccd87c0d"><a name="gga364b7c7cc88086ad40c4c3d2dd098648a041cef6b72032e671fa448e2ccd87c0d"></a><a name="gga364b7c7cc88086ad40c4c3d2dd098648a041cef6b72032e671fa448e2ccd87c0d"></a></strong>WIFI_IOT_IO_FUNC_GPIO_13_SDIO_D0 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p829813499090252"><a name="p829813499090252"></a><a name="p829813499090252"></a>SDIO D0 function </p>
 </td>
</tr>
<tr id="row511215071090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga364b7c7cc88086ad40c4c3d2dd098648a5fa81c0c0bc86f0c7af184b0da088f70"><a name="gga364b7c7cc88086ad40c4c3d2dd098648a5fa81c0c0bc86f0c7af184b0da088f70"></a><a name="gga364b7c7cc88086ad40c4c3d2dd098648a5fa81c0c0bc86f0c7af184b0da088f70"></a></strong>WIFI_IOT_IO_FUNC_GPIO_13_GPIO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p358174021090252"><a name="p358174021090252"></a><a name="p358174021090252"></a>GPIO13 function </p>
 </td>
</tr>
<tr id="row874500134090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga364b7c7cc88086ad40c4c3d2dd098648a3ee8f8ce9db21a7752af81d023f02700"><a name="gga364b7c7cc88086ad40c4c3d2dd098648a3ee8f8ce9db21a7752af81d023f02700"></a><a name="gga364b7c7cc88086ad40c4c3d2dd098648a3ee8f8ce9db21a7752af81d023f02700"></a></strong>WIFI_IOT_IO_FUNC_GPIO_13_PWM4_OUT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1297604235090252"><a name="p1297604235090252"></a><a name="p1297604235090252"></a>PWM4 OUT function </p>
 </td>
</tr>
<tr id="row681015110090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga364b7c7cc88086ad40c4c3d2dd098648ac9ee6ac9fae28de25c222350db957be3"><a name="gga364b7c7cc88086ad40c4c3d2dd098648ac9ee6ac9fae28de25c222350db957be3"></a><a name="gga364b7c7cc88086ad40c4c3d2dd098648ac9ee6ac9fae28de25c222350db957be3"></a></strong>WIFI_IOT_IO_FUNC_GPIO_13_I2C0_SDA </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p242922973090252"><a name="p242922973090252"></a><a name="p242922973090252"></a>I2C0 SDA function </p>
 </td>
</tr>
<tr id="row1930740837090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga364b7c7cc88086ad40c4c3d2dd098648a68d69347b2c3e25ed68ee56672789c70"><a name="gga364b7c7cc88086ad40c4c3d2dd098648a68d69347b2c3e25ed68ee56672789c70"></a><a name="gga364b7c7cc88086ad40c4c3d2dd098648a68d69347b2c3e25ed68ee56672789c70"></a></strong>WIFI_IOT_IO_FUNC_GPIO_13_I2S0_WS </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1640927426090252"><a name="p1640927426090252"></a><a name="p1640927426090252"></a>I2S0 WS function </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotIoFuncGpio14<a name="gafcf6d4cb0113b803d834bac89af8d9b8"></a>

```
enum [WifiIotIoFuncGpio14](wifiiot.md#gafcf6d4cb0113b803d834bac89af8d9b8)
```

 **Description:**

Enumerates the functions of GPIO hardware pin 14. 

<a name="table344480425090252"></a>
<table><thead align="left"><tr id="row1349073976090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1716604964090252"><a name="p1716604964090252"></a><a name="p1716604964090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p370998419090252"><a name="p370998419090252"></a><a name="p370998419090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1745548693090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggafcf6d4cb0113b803d834bac89af8d9b8ad3c279c96d416bb679a12632e043c869"><a name="ggafcf6d4cb0113b803d834bac89af8d9b8ad3c279c96d416bb679a12632e043c869"></a><a name="ggafcf6d4cb0113b803d834bac89af8d9b8ad3c279c96d416bb679a12632e043c869"></a></strong>WIFI_IOT_IO_FUNC_GPIO_14_SSI_CLK </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p793431528090252"><a name="p793431528090252"></a><a name="p793431528090252"></a>SSI CLK function </p>
 </td>
</tr>
<tr id="row1681269974090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggafcf6d4cb0113b803d834bac89af8d9b8a74b51226f0832c4e8e178098ca5b52da"><a name="ggafcf6d4cb0113b803d834bac89af8d9b8a74b51226f0832c4e8e178098ca5b52da"></a><a name="ggafcf6d4cb0113b803d834bac89af8d9b8a74b51226f0832c4e8e178098ca5b52da"></a></strong>WIFI_IOT_IO_FUNC_GPIO_14_UART0_RXD </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p201642145090252"><a name="p201642145090252"></a><a name="p201642145090252"></a>UART0 RXD function </p>
 </td>
</tr>
<tr id="row203994357090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggafcf6d4cb0113b803d834bac89af8d9b8a41d571aaeb611fedd801d2623b53ed3b"><a name="ggafcf6d4cb0113b803d834bac89af8d9b8a41d571aaeb611fedd801d2623b53ed3b"></a><a name="ggafcf6d4cb0113b803d834bac89af8d9b8a41d571aaeb611fedd801d2623b53ed3b"></a></strong>WIFI_IOT_IO_FUNC_GPIO_14_UART2_CTS_N </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1472838896090252"><a name="p1472838896090252"></a><a name="p1472838896090252"></a>UART2 CTS function </p>
 </td>
</tr>
<tr id="row1968206759090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggafcf6d4cb0113b803d834bac89af8d9b8a02e3f6f241d4088eb5245726c528705e"><a name="ggafcf6d4cb0113b803d834bac89af8d9b8a02e3f6f241d4088eb5245726c528705e"></a><a name="ggafcf6d4cb0113b803d834bac89af8d9b8a02e3f6f241d4088eb5245726c528705e"></a></strong>WIFI_IOT_IO_FUNC_GPIO_14_SDIO_D1 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1941332129090252"><a name="p1941332129090252"></a><a name="p1941332129090252"></a>SDIO D1 function </p>
 </td>
</tr>
<tr id="row1397818131090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggafcf6d4cb0113b803d834bac89af8d9b8adc43efa86c4218d6749732899cfff9bd"><a name="ggafcf6d4cb0113b803d834bac89af8d9b8adc43efa86c4218d6749732899cfff9bd"></a><a name="ggafcf6d4cb0113b803d834bac89af8d9b8adc43efa86c4218d6749732899cfff9bd"></a></strong>WIFI_IOT_IO_FUNC_GPIO_14_GPIO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1619998587090252"><a name="p1619998587090252"></a><a name="p1619998587090252"></a>GPIO14 function </p>
 </td>
</tr>
<tr id="row1943026979090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggafcf6d4cb0113b803d834bac89af8d9b8acd2191145a6a0aeac212036d8c763a88"><a name="ggafcf6d4cb0113b803d834bac89af8d9b8acd2191145a6a0aeac212036d8c763a88"></a><a name="ggafcf6d4cb0113b803d834bac89af8d9b8acd2191145a6a0aeac212036d8c763a88"></a></strong>WIFI_IOT_IO_FUNC_GPIO_14_PWM5_OUT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1758110941090252"><a name="p1758110941090252"></a><a name="p1758110941090252"></a>PWM5 OUT function </p>
 </td>
</tr>
<tr id="row1643953531090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggafcf6d4cb0113b803d834bac89af8d9b8aa2b4ea5f2d923bb163ad52a8d6bece2c"><a name="ggafcf6d4cb0113b803d834bac89af8d9b8aa2b4ea5f2d923bb163ad52a8d6bece2c"></a><a name="ggafcf6d4cb0113b803d834bac89af8d9b8aa2b4ea5f2d923bb163ad52a8d6bece2c"></a></strong>WIFI_IOT_IO_FUNC_GPIO_14_I2C0_SCL </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p975644443090252"><a name="p975644443090252"></a><a name="p975644443090252"></a>I2C0 SCL function </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotIoFuncGpio2<a name="gac9d0974184776d35ca9b0f73829f317b"></a>

```
enum [WifiIotIoFuncGpio2](wifiiot.md#gac9d0974184776d35ca9b0f73829f317b)
```

 **Description:**

Enumerates the functions of GPIO hardware pin 2. 

<a name="table19933832090252"></a>
<table><thead align="left"><tr id="row1204156937090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1648890406090252"><a name="p1648890406090252"></a><a name="p1648890406090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p649426035090252"><a name="p649426035090252"></a><a name="p649426035090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row17267872090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggac9d0974184776d35ca9b0f73829f317ba9e9e5978a41b3e8a98afc8341d8118aa"><a name="ggac9d0974184776d35ca9b0f73829f317ba9e9e5978a41b3e8a98afc8341d8118aa"></a><a name="ggac9d0974184776d35ca9b0f73829f317ba9e9e5978a41b3e8a98afc8341d8118aa"></a></strong>WIFI_IOT_IO_FUNC_GPIO_2_GPIO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1494932095090252"><a name="p1494932095090252"></a><a name="p1494932095090252"></a>GPIO2 function </p>
 </td>
</tr>
<tr id="row654555440090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggac9d0974184776d35ca9b0f73829f317ba43585a8b91976d3e6ab9ab24f78be34e"><a name="ggac9d0974184776d35ca9b0f73829f317ba43585a8b91976d3e6ab9ab24f78be34e"></a><a name="ggac9d0974184776d35ca9b0f73829f317ba43585a8b91976d3e6ab9ab24f78be34e"></a></strong>WIFI_IOT_IO_FUNC_GPIO_2_UART1_RTS_N </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p629247198090252"><a name="p629247198090252"></a><a name="p629247198090252"></a>UART1 RTS function </p>
 </td>
</tr>
<tr id="row905828914090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggac9d0974184776d35ca9b0f73829f317ba57c97e076eed823905fa8a0dcc48a95d"><a name="ggac9d0974184776d35ca9b0f73829f317ba57c97e076eed823905fa8a0dcc48a95d"></a><a name="ggac9d0974184776d35ca9b0f73829f317ba57c97e076eed823905fa8a0dcc48a95d"></a></strong>WIFI_IOT_IO_FUNC_GPIO_2_SPI1_TXD </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1468483427090252"><a name="p1468483427090252"></a><a name="p1468483427090252"></a>SPI1 TXD function </p>
 </td>
</tr>
<tr id="row810043882090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggac9d0974184776d35ca9b0f73829f317ba930dbfc4b167e2952ee27edb5affacc2"><a name="ggac9d0974184776d35ca9b0f73829f317ba930dbfc4b167e2952ee27edb5affacc2"></a><a name="ggac9d0974184776d35ca9b0f73829f317ba930dbfc4b167e2952ee27edb5affacc2"></a></strong>WIFI_IOT_IO_FUNC_GPIO_2_JTAG_TRSTN </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p479947432090252"><a name="p479947432090252"></a><a name="p479947432090252"></a>JTAG TRSTN function </p>
 </td>
</tr>
<tr id="row1730131766090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggac9d0974184776d35ca9b0f73829f317ba33d45d0432d5a5d59c92526c1567e3a8"><a name="ggac9d0974184776d35ca9b0f73829f317ba33d45d0432d5a5d59c92526c1567e3a8"></a><a name="ggac9d0974184776d35ca9b0f73829f317ba33d45d0432d5a5d59c92526c1567e3a8"></a></strong>WIFI_IOT_IO_FUNC_GPIO_2_PWM2_OUT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p896312855090252"><a name="p896312855090252"></a><a name="p896312855090252"></a>PWM2 OUT function </p>
 </td>
</tr>
<tr id="row1596119515090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggac9d0974184776d35ca9b0f73829f317bacedc367f8cfcfa29a326e83a35bf7cb4"><a name="ggac9d0974184776d35ca9b0f73829f317bacedc367f8cfcfa29a326e83a35bf7cb4"></a><a name="ggac9d0974184776d35ca9b0f73829f317bacedc367f8cfcfa29a326e83a35bf7cb4"></a></strong>WIFI_IOT_IO_FUNC_GPIO_2_SSI_CLK </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p444550884090252"><a name="p444550884090252"></a><a name="p444550884090252"></a>SSI CLK function </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotIoFuncGpio3<a name="gaca745c98fc2ef9994e67444c9aa53db8"></a>

```
enum [WifiIotIoFuncGpio3](wifiiot.md#gaca745c98fc2ef9994e67444c9aa53db8)
```

 **Description:**

Enumerates the functions of GPIO hardware pin 3. 

<a name="table1657911648090252"></a>
<table><thead align="left"><tr id="row2126647710090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2057957197090252"><a name="p2057957197090252"></a><a name="p2057957197090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p833835069090252"><a name="p833835069090252"></a><a name="p833835069090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1862857912090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaca745c98fc2ef9994e67444c9aa53db8a900852cb44e4e5683293935b1638542c"><a name="ggaca745c98fc2ef9994e67444c9aa53db8a900852cb44e4e5683293935b1638542c"></a><a name="ggaca745c98fc2ef9994e67444c9aa53db8a900852cb44e4e5683293935b1638542c"></a></strong>WIFI_IOT_IO_FUNC_GPIO_3_GPIO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2065608737090252"><a name="p2065608737090252"></a><a name="p2065608737090252"></a>GPIO3 function </p>
 </td>
</tr>
<tr id="row1647849675090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaca745c98fc2ef9994e67444c9aa53db8ab73e5c02208920999b8b90563cef3966"><a name="ggaca745c98fc2ef9994e67444c9aa53db8ab73e5c02208920999b8b90563cef3966"></a><a name="ggaca745c98fc2ef9994e67444c9aa53db8ab73e5c02208920999b8b90563cef3966"></a></strong>WIFI_IOT_IO_FUNC_GPIO_3_UART0_TXD </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1163041779090252"><a name="p1163041779090252"></a><a name="p1163041779090252"></a>UART0 TXD function </p>
 </td>
</tr>
<tr id="row1504040629090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaca745c98fc2ef9994e67444c9aa53db8a9781f77096742039e4179f2c7bf5bcc9"><a name="ggaca745c98fc2ef9994e67444c9aa53db8a9781f77096742039e4179f2c7bf5bcc9"></a><a name="ggaca745c98fc2ef9994e67444c9aa53db8a9781f77096742039e4179f2c7bf5bcc9"></a></strong>WIFI_IOT_IO_FUNC_GPIO_3_UART1_CTS_N </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p683848941090252"><a name="p683848941090252"></a><a name="p683848941090252"></a>UART1 CTS function </p>
 </td>
</tr>
<tr id="row986711217090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaca745c98fc2ef9994e67444c9aa53db8acad4b35de5675ce4e0e4d182e93e024a"><a name="ggaca745c98fc2ef9994e67444c9aa53db8acad4b35de5675ce4e0e4d182e93e024a"></a><a name="ggaca745c98fc2ef9994e67444c9aa53db8acad4b35de5675ce4e0e4d182e93e024a"></a></strong>WIFI_IOT_IO_FUNC_GPIO_3_SPI1_CSN </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p152780099090252"><a name="p152780099090252"></a><a name="p152780099090252"></a>SPI CSN function </p>
 </td>
</tr>
<tr id="row800896183090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaca745c98fc2ef9994e67444c9aa53db8acbe7ac3fc1f3b7885c6fab1b349b530f"><a name="ggaca745c98fc2ef9994e67444c9aa53db8acbe7ac3fc1f3b7885c6fab1b349b530f"></a><a name="ggaca745c98fc2ef9994e67444c9aa53db8acbe7ac3fc1f3b7885c6fab1b349b530f"></a></strong>WIFI_IOT_IO_FUNC_GPIO_3_JTAG_TDI </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p37455767090252"><a name="p37455767090252"></a><a name="p37455767090252"></a>JTAG TDI function </p>
 </td>
</tr>
<tr id="row1439627096090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaca745c98fc2ef9994e67444c9aa53db8ab6fc7d2ba28c9541492fa5b9242f489f"><a name="ggaca745c98fc2ef9994e67444c9aa53db8ab6fc7d2ba28c9541492fa5b9242f489f"></a><a name="ggaca745c98fc2ef9994e67444c9aa53db8ab6fc7d2ba28c9541492fa5b9242f489f"></a></strong>WIFI_IOT_IO_FUNC_GPIO_3_PWM5_OUT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p488289523090252"><a name="p488289523090252"></a><a name="p488289523090252"></a>PWM5 OUT function </p>
 </td>
</tr>
<tr id="row366738238090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaca745c98fc2ef9994e67444c9aa53db8aefe458d1134ebc716c4f0ac4a0a7e87f"><a name="ggaca745c98fc2ef9994e67444c9aa53db8aefe458d1134ebc716c4f0ac4a0a7e87f"></a><a name="ggaca745c98fc2ef9994e67444c9aa53db8aefe458d1134ebc716c4f0ac4a0a7e87f"></a></strong>WIFI_IOT_IO_FUNC_GPIO_3_I2C1_SDA </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p824422613090252"><a name="p824422613090252"></a><a name="p824422613090252"></a>I2C1 SDA function </p>
 </td>
</tr>
<tr id="row1469211290090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaca745c98fc2ef9994e67444c9aa53db8ae1f7cb6f32e78a2f4f676c154b26a84a"><a name="ggaca745c98fc2ef9994e67444c9aa53db8ae1f7cb6f32e78a2f4f676c154b26a84a"></a><a name="ggaca745c98fc2ef9994e67444c9aa53db8ae1f7cb6f32e78a2f4f676c154b26a84a"></a></strong>WIFI_IOT_IO_FUNC_GPIO_3_SSI_DATA </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p755637831090252"><a name="p755637831090252"></a><a name="p755637831090252"></a>SSI DATA function </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotIoFuncGpio4<a name="ga70218b6740d703737739ce4372e2f1e2"></a>

```
enum [WifiIotIoFuncGpio4](wifiiot.md#ga70218b6740d703737739ce4372e2f1e2)
```

 **Description:**

Enumerates the functions of GPIO hardware pin 4. 

<a name="table431710091090252"></a>
<table><thead align="left"><tr id="row1134443273090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p899256386090252"><a name="p899256386090252"></a><a name="p899256386090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p646513365090252"><a name="p646513365090252"></a><a name="p646513365090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1284291813090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga70218b6740d703737739ce4372e2f1e2addbb34e879ddba03407a4229116c23ac"><a name="gga70218b6740d703737739ce4372e2f1e2addbb34e879ddba03407a4229116c23ac"></a><a name="gga70218b6740d703737739ce4372e2f1e2addbb34e879ddba03407a4229116c23ac"></a></strong>WIFI_IOT_IO_FUNC_GPIO_4_GPIO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p954812837090252"><a name="p954812837090252"></a><a name="p954812837090252"></a>GPIO4 function </p>
 </td>
</tr>
<tr id="row2127790419090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga70218b6740d703737739ce4372e2f1e2a1fc155f21a4132b19f63559bcff1f7f9"><a name="gga70218b6740d703737739ce4372e2f1e2a1fc155f21a4132b19f63559bcff1f7f9"></a><a name="gga70218b6740d703737739ce4372e2f1e2a1fc155f21a4132b19f63559bcff1f7f9"></a></strong>WIFI_IOT_IO_FUNC_GPIO_4_UART0_RXD </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1705409331090252"><a name="p1705409331090252"></a><a name="p1705409331090252"></a>UART0 RXD function </p>
 </td>
</tr>
<tr id="row1876724763090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga70218b6740d703737739ce4372e2f1e2a6acf3b98636223ca6978c72954b62003"><a name="gga70218b6740d703737739ce4372e2f1e2a6acf3b98636223ca6978c72954b62003"></a><a name="gga70218b6740d703737739ce4372e2f1e2a6acf3b98636223ca6978c72954b62003"></a></strong>WIFI_IOT_IO_FUNC_GPIO_4_JTAG_TMS </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1799744002090252"><a name="p1799744002090252"></a><a name="p1799744002090252"></a>JTAG TMS function </p>
 </td>
</tr>
<tr id="row28996817090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga70218b6740d703737739ce4372e2f1e2a32dd2cc66001ab46db29bb846c52197e"><a name="gga70218b6740d703737739ce4372e2f1e2a32dd2cc66001ab46db29bb846c52197e"></a><a name="gga70218b6740d703737739ce4372e2f1e2a32dd2cc66001ab46db29bb846c52197e"></a></strong>WIFI_IOT_IO_FUNC_GPIO_4_PWM1_OUT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p833276119090252"><a name="p833276119090252"></a><a name="p833276119090252"></a>PWM1 OUT function </p>
 </td>
</tr>
<tr id="row1798476589090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga70218b6740d703737739ce4372e2f1e2ae543e2931a4f36ac0325c1540855d661"><a name="gga70218b6740d703737739ce4372e2f1e2ae543e2931a4f36ac0325c1540855d661"></a><a name="gga70218b6740d703737739ce4372e2f1e2ae543e2931a4f36ac0325c1540855d661"></a></strong>WIFI_IOT_IO_FUNC_GPIO_4_I2C1_SCL </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p284118586090252"><a name="p284118586090252"></a><a name="p284118586090252"></a>I2C1 SCL function </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotIoFuncGpio5<a name="ga6cbed71f3a94f8e7513c4b91ae1e54ce"></a>

```
enum [WifiIotIoFuncGpio5](wifiiot.md#ga6cbed71f3a94f8e7513c4b91ae1e54ce)
```

 **Description:**

Enumerates the functions of GPIO hardware pin 5. 

<a name="table906727324090252"></a>
<table><thead align="left"><tr id="row47769456090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p143486143090252"><a name="p143486143090252"></a><a name="p143486143090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1528801454090252"><a name="p1528801454090252"></a><a name="p1528801454090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1233597730090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6cbed71f3a94f8e7513c4b91ae1e54cea2627264cdc21a54b73d0f7e3d21c3b5f"><a name="gga6cbed71f3a94f8e7513c4b91ae1e54cea2627264cdc21a54b73d0f7e3d21c3b5f"></a><a name="gga6cbed71f3a94f8e7513c4b91ae1e54cea2627264cdc21a54b73d0f7e3d21c3b5f"></a></strong>WIFI_IOT_IO_FUNC_GPIO_5_GPIO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1062264598090252"><a name="p1062264598090252"></a><a name="p1062264598090252"></a>GPIO5 function </p>
 </td>
</tr>
<tr id="row1000186133090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6cbed71f3a94f8e7513c4b91ae1e54cea20e6b45cd687dee2ebb1dde55cf02860"><a name="gga6cbed71f3a94f8e7513c4b91ae1e54cea20e6b45cd687dee2ebb1dde55cf02860"></a><a name="gga6cbed71f3a94f8e7513c4b91ae1e54cea20e6b45cd687dee2ebb1dde55cf02860"></a></strong>WIFI_IOT_IO_FUNC_GPIO_5_UART1_RXD </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p249276725090252"><a name="p249276725090252"></a><a name="p249276725090252"></a>UART1 RXD function </p>
 </td>
</tr>
<tr id="row604126903090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6cbed71f3a94f8e7513c4b91ae1e54cea314bb175969cdf4b56dd38ef648fc409"><a name="gga6cbed71f3a94f8e7513c4b91ae1e54cea314bb175969cdf4b56dd38ef648fc409"></a><a name="gga6cbed71f3a94f8e7513c4b91ae1e54cea314bb175969cdf4b56dd38ef648fc409"></a></strong>WIFI_IOT_IO_FUNC_GPIO_5_SPI0_CSN </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p722524454090252"><a name="p722524454090252"></a><a name="p722524454090252"></a>SPI0 CSN function </p>
 </td>
</tr>
<tr id="row806620649090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6cbed71f3a94f8e7513c4b91ae1e54cea4944d83dcad39cfdbbc75bd2a72cb4ea"><a name="gga6cbed71f3a94f8e7513c4b91ae1e54cea4944d83dcad39cfdbbc75bd2a72cb4ea"></a><a name="gga6cbed71f3a94f8e7513c4b91ae1e54cea4944d83dcad39cfdbbc75bd2a72cb4ea"></a></strong>WIFI_IOT_IO_FUNC_GPIO_5_PWM2_OUT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p103760321090252"><a name="p103760321090252"></a><a name="p103760321090252"></a>PWM2 OUT function </p>
 </td>
</tr>
<tr id="row177069331090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6cbed71f3a94f8e7513c4b91ae1e54cea5aaf6d79a5325bba396a32e240ee689e"><a name="gga6cbed71f3a94f8e7513c4b91ae1e54cea5aaf6d79a5325bba396a32e240ee689e"></a><a name="gga6cbed71f3a94f8e7513c4b91ae1e54cea5aaf6d79a5325bba396a32e240ee689e"></a></strong>WIFI_IOT_IO_FUNC_GPIO_5_I2S0_MCLK </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1009945872090252"><a name="p1009945872090252"></a><a name="p1009945872090252"></a>I2C0 MCLK function </p>
 </td>
</tr>
<tr id="row1972570698090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6cbed71f3a94f8e7513c4b91ae1e54ceaef4ff12208ea1aec33b99924f1d31f7e"><a name="gga6cbed71f3a94f8e7513c4b91ae1e54ceaef4ff12208ea1aec33b99924f1d31f7e"></a><a name="gga6cbed71f3a94f8e7513c4b91ae1e54ceaef4ff12208ea1aec33b99924f1d31f7e"></a></strong>WIFI_IOT_IO_FUNC_GPIO_5_BT_STATUS </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1671392133090252"><a name="p1671392133090252"></a><a name="p1671392133090252"></a>BT STATUS function </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotIoFuncGpio6<a name="ga42008386d7791b97dbfa1fa6b6c4dc1d"></a>

```
enum [WifiIotIoFuncGpio6](wifiiot.md#ga42008386d7791b97dbfa1fa6b6c4dc1d)
```

 **Description:**

Enumerates the functions of GPIO hardware pin 6. 

<a name="table1120284520090252"></a>
<table><thead align="left"><tr id="row359191051090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p859371268090252"><a name="p859371268090252"></a><a name="p859371268090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1915532861090252"><a name="p1915532861090252"></a><a name="p1915532861090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row251318234090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga42008386d7791b97dbfa1fa6b6c4dc1dab62d9164a716b5adb9e19e8836ab7a86"><a name="gga42008386d7791b97dbfa1fa6b6c4dc1dab62d9164a716b5adb9e19e8836ab7a86"></a><a name="gga42008386d7791b97dbfa1fa6b6c4dc1dab62d9164a716b5adb9e19e8836ab7a86"></a></strong>WIFI_IOT_IO_FUNC_GPIO_6_GPIO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1860535982090252"><a name="p1860535982090252"></a><a name="p1860535982090252"></a>GPIO6 function </p>
 </td>
</tr>
<tr id="row788430063090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga42008386d7791b97dbfa1fa6b6c4dc1da2ddce114a7cc5e36018dbcccc51aa18f"><a name="gga42008386d7791b97dbfa1fa6b6c4dc1da2ddce114a7cc5e36018dbcccc51aa18f"></a><a name="gga42008386d7791b97dbfa1fa6b6c4dc1da2ddce114a7cc5e36018dbcccc51aa18f"></a></strong>WIFI_IOT_IO_FUNC_GPIO_6_UART1_TXD </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p256451699090252"><a name="p256451699090252"></a><a name="p256451699090252"></a>UART1 TXD function </p>
 </td>
</tr>
<tr id="row1329469344090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga42008386d7791b97dbfa1fa6b6c4dc1da135b58a503fcb9597cc6dc121a31ce20"><a name="gga42008386d7791b97dbfa1fa6b6c4dc1da135b58a503fcb9597cc6dc121a31ce20"></a><a name="gga42008386d7791b97dbfa1fa6b6c4dc1da135b58a503fcb9597cc6dc121a31ce20"></a></strong>WIFI_IOT_IO_FUNC_GPIO_6_SPI0_CK </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p717972068090252"><a name="p717972068090252"></a><a name="p717972068090252"></a>SPI0 CK function </p>
 </td>
</tr>
<tr id="row703256221090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga42008386d7791b97dbfa1fa6b6c4dc1da592f96e2859ccd5d12df5395a32d7960"><a name="gga42008386d7791b97dbfa1fa6b6c4dc1da592f96e2859ccd5d12df5395a32d7960"></a><a name="gga42008386d7791b97dbfa1fa6b6c4dc1da592f96e2859ccd5d12df5395a32d7960"></a></strong>WIFI_IOT_IO_FUNC_GPIO_6_PWM3_OUT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1553824248090252"><a name="p1553824248090252"></a><a name="p1553824248090252"></a>PWM3 OUT function </p>
 </td>
</tr>
<tr id="row1501365644090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga42008386d7791b97dbfa1fa6b6c4dc1dad35204fd9982ec2bc34e8b6761ccf6b1"><a name="gga42008386d7791b97dbfa1fa6b6c4dc1dad35204fd9982ec2bc34e8b6761ccf6b1"></a><a name="gga42008386d7791b97dbfa1fa6b6c4dc1dad35204fd9982ec2bc34e8b6761ccf6b1"></a></strong>WIFI_IOT_IO_FUNC_GPIO_6_I2S0_TX </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1357741838090252"><a name="p1357741838090252"></a><a name="p1357741838090252"></a>I2S0 TX function </p>
 </td>
</tr>
<tr id="row1763093367090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga42008386d7791b97dbfa1fa6b6c4dc1da57cca649a73e43ba821859c3a70c0c4f"><a name="gga42008386d7791b97dbfa1fa6b6c4dc1da57cca649a73e43ba821859c3a70c0c4f"></a><a name="gga42008386d7791b97dbfa1fa6b6c4dc1da57cca649a73e43ba821859c3a70c0c4f"></a></strong>WIFI_IOT_IO_FUNC_GPIO_6_COEX_SWITCH </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p26080553090252"><a name="p26080553090252"></a><a name="p26080553090252"></a>COEX switch function </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotIoFuncGpio7<a name="gac66dc390f39e0933c051790b20552b7c"></a>

```
enum [WifiIotIoFuncGpio7](wifiiot.md#gac66dc390f39e0933c051790b20552b7c)
```

 **Description:**

Enumerates the functions of GPIO hardware pin 7. 

<a name="table2056277877090252"></a>
<table><thead align="left"><tr id="row908597172090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p15407301090252"><a name="p15407301090252"></a><a name="p15407301090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p835825609090252"><a name="p835825609090252"></a><a name="p835825609090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row110454615090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggac66dc390f39e0933c051790b20552b7ca73da6d7633e44681a31b770f10b06aed"><a name="ggac66dc390f39e0933c051790b20552b7ca73da6d7633e44681a31b770f10b06aed"></a><a name="ggac66dc390f39e0933c051790b20552b7ca73da6d7633e44681a31b770f10b06aed"></a></strong>WIFI_IOT_IO_FUNC_GPIO_7_GPIO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2025856009090252"><a name="p2025856009090252"></a><a name="p2025856009090252"></a>GPIO7 function </p>
 </td>
</tr>
<tr id="row1093444855090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggac66dc390f39e0933c051790b20552b7cae1c90084d66c48ebadc657e7b41d4d5a"><a name="ggac66dc390f39e0933c051790b20552b7cae1c90084d66c48ebadc657e7b41d4d5a"></a><a name="ggac66dc390f39e0933c051790b20552b7cae1c90084d66c48ebadc657e7b41d4d5a"></a></strong>WIFI_IOT_IO_FUNC_GPIO_7_UART1_CTS_N </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1259419010090252"><a name="p1259419010090252"></a><a name="p1259419010090252"></a>UART1 CTS function </p>
 </td>
</tr>
<tr id="row882147219090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggac66dc390f39e0933c051790b20552b7ca5ef6f43f43355ff8fd9c2fefa53081b4"><a name="ggac66dc390f39e0933c051790b20552b7ca5ef6f43f43355ff8fd9c2fefa53081b4"></a><a name="ggac66dc390f39e0933c051790b20552b7ca5ef6f43f43355ff8fd9c2fefa53081b4"></a></strong>WIFI_IOT_IO_FUNC_GPIO_7_SPI0_RXD </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1160766375090252"><a name="p1160766375090252"></a><a name="p1160766375090252"></a>SPI0 RXD function </p>
 </td>
</tr>
<tr id="row2130436707090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggac66dc390f39e0933c051790b20552b7ca06bc301e0d776922e9d4b236d3a30e99"><a name="ggac66dc390f39e0933c051790b20552b7ca06bc301e0d776922e9d4b236d3a30e99"></a><a name="ggac66dc390f39e0933c051790b20552b7ca06bc301e0d776922e9d4b236d3a30e99"></a></strong>WIFI_IOT_IO_FUNC_GPIO_7_PWM0_OUT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1045649208090252"><a name="p1045649208090252"></a><a name="p1045649208090252"></a>PWM0 OUT function </p>
 </td>
</tr>
<tr id="row31731902090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggac66dc390f39e0933c051790b20552b7ca23fe50b89ddd6af8cafff14a58cba4bb"><a name="ggac66dc390f39e0933c051790b20552b7ca23fe50b89ddd6af8cafff14a58cba4bb"></a><a name="ggac66dc390f39e0933c051790b20552b7ca23fe50b89ddd6af8cafff14a58cba4bb"></a></strong>WIFI_IOT_IO_FUNC_GPIO_7_I2S0_BCLK </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1591224090090252"><a name="p1591224090090252"></a><a name="p1591224090090252"></a>I2S0 BCLK function </p>
 </td>
</tr>
<tr id="row780768180090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggac66dc390f39e0933c051790b20552b7ca20325d806adef2ddbb4c553662b1da55"><a name="ggac66dc390f39e0933c051790b20552b7ca20325d806adef2ddbb4c553662b1da55"></a><a name="ggac66dc390f39e0933c051790b20552b7ca20325d806adef2ddbb4c553662b1da55"></a></strong>WIFI_IOT_IO_FUNC_GPIO_7_BT_ACTIVE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1986106017090252"><a name="p1986106017090252"></a><a name="p1986106017090252"></a>BT ACTIVE function </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotIoFuncGpio8<a name="gae63cd3d5c677fac3b01a3c67e8faf0fb"></a>

```
enum [WifiIotIoFuncGpio8](wifiiot.md#gae63cd3d5c677fac3b01a3c67e8faf0fb)
```

 **Description:**

Enumerates the functions of GPIO hardware pin 8. 

<a name="table1199107527090252"></a>
<table><thead align="left"><tr id="row1727520761090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1953557017090252"><a name="p1953557017090252"></a><a name="p1953557017090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p9835560090252"><a name="p9835560090252"></a><a name="p9835560090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row732980996090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae63cd3d5c677fac3b01a3c67e8faf0fba6539bffea7913b2a60021c181a0594ef"><a name="ggae63cd3d5c677fac3b01a3c67e8faf0fba6539bffea7913b2a60021c181a0594ef"></a><a name="ggae63cd3d5c677fac3b01a3c67e8faf0fba6539bffea7913b2a60021c181a0594ef"></a></strong>WIFI_IOT_IO_FUNC_GPIO_8_GPIO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p161706430090252"><a name="p161706430090252"></a><a name="p161706430090252"></a>GPIO8 function </p>
 </td>
</tr>
<tr id="row739044170090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae63cd3d5c677fac3b01a3c67e8faf0fba2da69d8ed888cc62f9a2f1b51a011fe8"><a name="ggae63cd3d5c677fac3b01a3c67e8faf0fba2da69d8ed888cc62f9a2f1b51a011fe8"></a><a name="ggae63cd3d5c677fac3b01a3c67e8faf0fba2da69d8ed888cc62f9a2f1b51a011fe8"></a></strong>WIFI_IOT_IO_FUNC_GPIO_8_UART1_RTS_N </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1138366815090252"><a name="p1138366815090252"></a><a name="p1138366815090252"></a>UART1 RTS function </p>
 </td>
</tr>
<tr id="row961547796090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae63cd3d5c677fac3b01a3c67e8faf0fba13aeec689990e7dc07081faabe165350"><a name="ggae63cd3d5c677fac3b01a3c67e8faf0fba13aeec689990e7dc07081faabe165350"></a><a name="ggae63cd3d5c677fac3b01a3c67e8faf0fba13aeec689990e7dc07081faabe165350"></a></strong>WIFI_IOT_IO_FUNC_GPIO_8_SPI0_TXD </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1310414560090252"><a name="p1310414560090252"></a><a name="p1310414560090252"></a>SPI0 TXD function </p>
 </td>
</tr>
<tr id="row971609482090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae63cd3d5c677fac3b01a3c67e8faf0fba7567a0979b39fdc708d5162920260749"><a name="ggae63cd3d5c677fac3b01a3c67e8faf0fba7567a0979b39fdc708d5162920260749"></a><a name="ggae63cd3d5c677fac3b01a3c67e8faf0fba7567a0979b39fdc708d5162920260749"></a></strong>WIFI_IOT_IO_FUNC_GPIO_8_PWM1_OUT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p627547927090252"><a name="p627547927090252"></a><a name="p627547927090252"></a>PWM1 OUT function </p>
 </td>
</tr>
<tr id="row355085113090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae63cd3d5c677fac3b01a3c67e8faf0fba8d67e0d5b97a805d6b080fe280998c9e"><a name="ggae63cd3d5c677fac3b01a3c67e8faf0fba8d67e0d5b97a805d6b080fe280998c9e"></a><a name="ggae63cd3d5c677fac3b01a3c67e8faf0fba8d67e0d5b97a805d6b080fe280998c9e"></a></strong>WIFI_IOT_IO_FUNC_GPIO_8_I2S0_WS </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1580797726090252"><a name="p1580797726090252"></a><a name="p1580797726090252"></a>I2S0 WS function </p>
 </td>
</tr>
<tr id="row270624067090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggae63cd3d5c677fac3b01a3c67e8faf0fbae605af66f479ef031dccf609f2b38d44"><a name="ggae63cd3d5c677fac3b01a3c67e8faf0fbae605af66f479ef031dccf609f2b38d44"></a><a name="ggae63cd3d5c677fac3b01a3c67e8faf0fbae605af66f479ef031dccf609f2b38d44"></a></strong>WIFI_IOT_IO_FUNC_GPIO_8_WLAN_ACTIVE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2069980790090252"><a name="p2069980790090252"></a><a name="p2069980790090252"></a>WLAN ACTIVE function </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotIoFuncGpio9<a name="ga641da9889bd5a8a758e1a4eb2a5a19e4"></a>

```
enum [WifiIotIoFuncGpio9](wifiiot.md#ga641da9889bd5a8a758e1a4eb2a5a19e4)
```

 **Description:**

Enumerates the functions of GPIO hardware pin 9. 

<a name="table245088469090252"></a>
<table><thead align="left"><tr id="row1721261403090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1200938743090252"><a name="p1200938743090252"></a><a name="p1200938743090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1272877767090252"><a name="p1272877767090252"></a><a name="p1272877767090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row959903356090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga641da9889bd5a8a758e1a4eb2a5a19e4a350d1fbb9b4821c4b0145245cc1b20ae"><a name="gga641da9889bd5a8a758e1a4eb2a5a19e4a350d1fbb9b4821c4b0145245cc1b20ae"></a><a name="gga641da9889bd5a8a758e1a4eb2a5a19e4a350d1fbb9b4821c4b0145245cc1b20ae"></a></strong>WIFI_IOT_IO_FUNC_GPIO_9_GPIO </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p735807035090252"><a name="p735807035090252"></a><a name="p735807035090252"></a>GPIO9 function </p>
 </td>
</tr>
<tr id="row663709396090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga641da9889bd5a8a758e1a4eb2a5a19e4a619cf8d896cf5567dae216d51cb941d7"><a name="gga641da9889bd5a8a758e1a4eb2a5a19e4a619cf8d896cf5567dae216d51cb941d7"></a><a name="gga641da9889bd5a8a758e1a4eb2a5a19e4a619cf8d896cf5567dae216d51cb941d7"></a></strong>WIFI_IOT_IO_FUNC_GPIO_9_I2C0_SCL </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1730664652090252"><a name="p1730664652090252"></a><a name="p1730664652090252"></a>I2C0 SCL function </p>
 </td>
</tr>
<tr id="row770522415090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga641da9889bd5a8a758e1a4eb2a5a19e4aafa2a6520f7d641e640675ab6a3b020d"><a name="gga641da9889bd5a8a758e1a4eb2a5a19e4aafa2a6520f7d641e640675ab6a3b020d"></a><a name="gga641da9889bd5a8a758e1a4eb2a5a19e4aafa2a6520f7d641e640675ab6a3b020d"></a></strong>WIFI_IOT_IO_FUNC_GPIO_9_UART2_RTS_N </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1553276817090252"><a name="p1553276817090252"></a><a name="p1553276817090252"></a>UART2 RTS function </p>
 </td>
</tr>
<tr id="row1183231665090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga641da9889bd5a8a758e1a4eb2a5a19e4a1988d957b5d66e06cd649849d59eaaf6"><a name="gga641da9889bd5a8a758e1a4eb2a5a19e4a1988d957b5d66e06cd649849d59eaaf6"></a><a name="gga641da9889bd5a8a758e1a4eb2a5a19e4a1988d957b5d66e06cd649849d59eaaf6"></a></strong>WIFI_IOT_IO_FUNC_GPIO_9_SDIO_D2 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p376603266090252"><a name="p376603266090252"></a><a name="p376603266090252"></a>SDIO D2 function </p>
 </td>
</tr>
<tr id="row1622579898090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga641da9889bd5a8a758e1a4eb2a5a19e4a5a92c3f1f65d07814ce0c9ddce14d321"><a name="gga641da9889bd5a8a758e1a4eb2a5a19e4a5a92c3f1f65d07814ce0c9ddce14d321"></a><a name="gga641da9889bd5a8a758e1a4eb2a5a19e4a5a92c3f1f65d07814ce0c9ddce14d321"></a></strong>WIFI_IOT_IO_FUNC_GPIO_9_SPI0_TXD </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1685214369090252"><a name="p1685214369090252"></a><a name="p1685214369090252"></a>SPI0 TXD function </p>
 </td>
</tr>
<tr id="row2071916113090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga641da9889bd5a8a758e1a4eb2a5a19e4ae35b5602e39b9168dc52d6f4bdf027fd"><a name="gga641da9889bd5a8a758e1a4eb2a5a19e4ae35b5602e39b9168dc52d6f4bdf027fd"></a><a name="gga641da9889bd5a8a758e1a4eb2a5a19e4ae35b5602e39b9168dc52d6f4bdf027fd"></a></strong>WIFI_IOT_IO_FUNC_GPIO_9_PWM0_OUT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1338115311090252"><a name="p1338115311090252"></a><a name="p1338115311090252"></a>PWM0 OUT function </p>
 </td>
</tr>
<tr id="row1610833645090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga641da9889bd5a8a758e1a4eb2a5a19e4a2408d710172cf78129e56f729083c855"><a name="gga641da9889bd5a8a758e1a4eb2a5a19e4a2408d710172cf78129e56f729083c855"></a><a name="gga641da9889bd5a8a758e1a4eb2a5a19e4a2408d710172cf78129e56f729083c855"></a></strong>WIFI_IOT_IO_FUNC_GPIO_9_I2S0_MCLK </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1465796823090252"><a name="p1465796823090252"></a><a name="p1465796823090252"></a>I2S0 MCLK function </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotIoName<a name="ga2f42c70f1dd8a04746e30a97b3dfc415"></a>

```
enum [WifiIotIoName](wifiiot.md#ga2f42c70f1dd8a04746e30a97b3dfc415)
```

 **Description:**

Enumerates GPIO hardware pin IDs. 

<a name="table1698267809090252"></a>
<table><thead align="left"><tr id="row1360441850090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1763609569090252"><a name="p1763609569090252"></a><a name="p1763609569090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1542939568090252"><a name="p1542939568090252"></a><a name="p1542939568090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1297328263090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f42c70f1dd8a04746e30a97b3dfc415a97963c85f73b7efc5df2b4e791518dd6"><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a97963c85f73b7efc5df2b4e791518dd6"></a><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a97963c85f73b7efc5df2b4e791518dd6"></a></strong>WIFI_IOT_IO_NAME_GPIO_0 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p745138116090252"><a name="p745138116090252"></a><a name="p745138116090252"></a>GPIO hardware pin 0 </p>
 </td>
</tr>
<tr id="row306551487090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f42c70f1dd8a04746e30a97b3dfc415a5a7f8f802106534ed2fcff69e70d5223"><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a5a7f8f802106534ed2fcff69e70d5223"></a><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a5a7f8f802106534ed2fcff69e70d5223"></a></strong>WIFI_IOT_IO_NAME_GPIO_1 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2107000822090252"><a name="p2107000822090252"></a><a name="p2107000822090252"></a>GPIO hardware pin 1 </p>
 </td>
</tr>
<tr id="row1530652538090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f42c70f1dd8a04746e30a97b3dfc415ab491c9b7b4854b1bed8fe93fb1d1c039"><a name="gga2f42c70f1dd8a04746e30a97b3dfc415ab491c9b7b4854b1bed8fe93fb1d1c039"></a><a name="gga2f42c70f1dd8a04746e30a97b3dfc415ab491c9b7b4854b1bed8fe93fb1d1c039"></a></strong>WIFI_IOT_IO_NAME_GPIO_2 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1729381175090252"><a name="p1729381175090252"></a><a name="p1729381175090252"></a>GPIO hardware pin 2 </p>
 </td>
</tr>
<tr id="row91542818090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f42c70f1dd8a04746e30a97b3dfc415a294203a8cfbf7effec255f87c8e58781"><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a294203a8cfbf7effec255f87c8e58781"></a><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a294203a8cfbf7effec255f87c8e58781"></a></strong>WIFI_IOT_IO_NAME_GPIO_3 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1588490849090252"><a name="p1588490849090252"></a><a name="p1588490849090252"></a>GPIO hardware pin 3 </p>
 </td>
</tr>
<tr id="row1385105598090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f42c70f1dd8a04746e30a97b3dfc415a8d055a5e935871680109ca2e9ceb3d86"><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a8d055a5e935871680109ca2e9ceb3d86"></a><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a8d055a5e935871680109ca2e9ceb3d86"></a></strong>WIFI_IOT_IO_NAME_GPIO_4 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1979995869090252"><a name="p1979995869090252"></a><a name="p1979995869090252"></a>GPIO hardware pin 4 </p>
 </td>
</tr>
<tr id="row133694799090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f42c70f1dd8a04746e30a97b3dfc415a2a7792d90d0fd908967bb8b116b7a72d"><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a2a7792d90d0fd908967bb8b116b7a72d"></a><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a2a7792d90d0fd908967bb8b116b7a72d"></a></strong>WIFI_IOT_IO_NAME_GPIO_5 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1543667197090252"><a name="p1543667197090252"></a><a name="p1543667197090252"></a>GPIO hardware pin 5 </p>
 </td>
</tr>
<tr id="row976807001090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f42c70f1dd8a04746e30a97b3dfc415aad36530a39eb4cfa2faa2903b41c2adc"><a name="gga2f42c70f1dd8a04746e30a97b3dfc415aad36530a39eb4cfa2faa2903b41c2adc"></a><a name="gga2f42c70f1dd8a04746e30a97b3dfc415aad36530a39eb4cfa2faa2903b41c2adc"></a></strong>WIFI_IOT_IO_NAME_GPIO_6 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p721974591090252"><a name="p721974591090252"></a><a name="p721974591090252"></a>GPIO hardware pin 6 </p>
 </td>
</tr>
<tr id="row1789264732090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f42c70f1dd8a04746e30a97b3dfc415aa2d160d6184312c399dc5c6e0453a499"><a name="gga2f42c70f1dd8a04746e30a97b3dfc415aa2d160d6184312c399dc5c6e0453a499"></a><a name="gga2f42c70f1dd8a04746e30a97b3dfc415aa2d160d6184312c399dc5c6e0453a499"></a></strong>WIFI_IOT_IO_NAME_GPIO_7 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p792231760090252"><a name="p792231760090252"></a><a name="p792231760090252"></a>GPIO hardware pin 7 </p>
 </td>
</tr>
<tr id="row1262456661090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f42c70f1dd8a04746e30a97b3dfc415a5795930c51751bdac0acb70fe2f78225"><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a5795930c51751bdac0acb70fe2f78225"></a><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a5795930c51751bdac0acb70fe2f78225"></a></strong>WIFI_IOT_IO_NAME_GPIO_8 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1955001436090252"><a name="p1955001436090252"></a><a name="p1955001436090252"></a>GPIO hardware pin 8 </p>
 </td>
</tr>
<tr id="row1936246943090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f42c70f1dd8a04746e30a97b3dfc415a3aa2a8978276384c825dc55f386b6aa6"><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a3aa2a8978276384c825dc55f386b6aa6"></a><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a3aa2a8978276384c825dc55f386b6aa6"></a></strong>WIFI_IOT_IO_NAME_GPIO_9 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p185074594090252"><a name="p185074594090252"></a><a name="p185074594090252"></a>GPIO hardware pin 9 </p>
 </td>
</tr>
<tr id="row409939880090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f42c70f1dd8a04746e30a97b3dfc415a10c27fe57a83adc596834140b497a318"><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a10c27fe57a83adc596834140b497a318"></a><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a10c27fe57a83adc596834140b497a318"></a></strong>WIFI_IOT_IO_NAME_GPIO_10 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1609755393090252"><a name="p1609755393090252"></a><a name="p1609755393090252"></a>GPIO hardware pin 10 </p>
 </td>
</tr>
<tr id="row2061941601090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f42c70f1dd8a04746e30a97b3dfc415a9490124d4cb5c76607c3c7eaf4a3f388"><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a9490124d4cb5c76607c3c7eaf4a3f388"></a><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a9490124d4cb5c76607c3c7eaf4a3f388"></a></strong>WIFI_IOT_IO_NAME_GPIO_11 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1821260678090252"><a name="p1821260678090252"></a><a name="p1821260678090252"></a>GPIO hardware pin 11 </p>
 </td>
</tr>
<tr id="row614833735090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f42c70f1dd8a04746e30a97b3dfc415ae4a090169da74a374b2f693d42e8d22c"><a name="gga2f42c70f1dd8a04746e30a97b3dfc415ae4a090169da74a374b2f693d42e8d22c"></a><a name="gga2f42c70f1dd8a04746e30a97b3dfc415ae4a090169da74a374b2f693d42e8d22c"></a></strong>WIFI_IOT_IO_NAME_GPIO_12 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1955751244090252"><a name="p1955751244090252"></a><a name="p1955751244090252"></a>GPIO hardware pin 12 </p>
 </td>
</tr>
<tr id="row939429088090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f42c70f1dd8a04746e30a97b3dfc415ada638b112db327afb19b352a27ba4649"><a name="gga2f42c70f1dd8a04746e30a97b3dfc415ada638b112db327afb19b352a27ba4649"></a><a name="gga2f42c70f1dd8a04746e30a97b3dfc415ada638b112db327afb19b352a27ba4649"></a></strong>WIFI_IOT_IO_NAME_GPIO_13 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1086375217090252"><a name="p1086375217090252"></a><a name="p1086375217090252"></a>GPIO hardware pin 13 </p>
 </td>
</tr>
<tr id="row1849638298090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f42c70f1dd8a04746e30a97b3dfc415a42eb2173954adcd9a3eed481df2d4bd2"><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a42eb2173954adcd9a3eed481df2d4bd2"></a><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a42eb2173954adcd9a3eed481df2d4bd2"></a></strong>WIFI_IOT_IO_NAME_GPIO_14 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p862937063090252"><a name="p862937063090252"></a><a name="p862937063090252"></a>GPIO hardware pin 14 </p>
 </td>
</tr>
<tr id="row825544017090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2f42c70f1dd8a04746e30a97b3dfc415a736421d5c5f92bae9262a8bf1058dfd8"><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a736421d5c5f92bae9262a8bf1058dfd8"></a><a name="gga2f42c70f1dd8a04746e30a97b3dfc415a736421d5c5f92bae9262a8bf1058dfd8"></a></strong>WIFI_IOT_IO_NAME_MAX </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p901543939090252"><a name="p901543939090252"></a><a name="p901543939090252"></a>Maximum value </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotIoPull<a name="gacc20a5c6456ec381ed931232c29d1c4f"></a>

```
enum [WifiIotIoPull](wifiiot.md#gacc20a5c6456ec381ed931232c29d1c4f)
```

 **Description:**

Enumerates GPIO pull-up or pull-down settings. 

<a name="table681294128090252"></a>
<table><thead align="left"><tr id="row1965738332090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p201462323090252"><a name="p201462323090252"></a><a name="p201462323090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2011851371090252"><a name="p2011851371090252"></a><a name="p2011851371090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1381230436090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacc20a5c6456ec381ed931232c29d1c4fa8699edd19f2fe1c8e2e0f843c100b665"><a name="ggacc20a5c6456ec381ed931232c29d1c4fa8699edd19f2fe1c8e2e0f843c100b665"></a><a name="ggacc20a5c6456ec381ed931232c29d1c4fa8699edd19f2fe1c8e2e0f843c100b665"></a></strong>WIFI_IOT_IO_PULL_NONE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2105606745090252"><a name="p2105606745090252"></a><a name="p2105606745090252"></a>No pull </p>
 </td>
</tr>
<tr id="row942132459090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacc20a5c6456ec381ed931232c29d1c4fa101a6db99a7c37721ee35dfdb93bf705"><a name="ggacc20a5c6456ec381ed931232c29d1c4fa101a6db99a7c37721ee35dfdb93bf705"></a><a name="ggacc20a5c6456ec381ed931232c29d1c4fa101a6db99a7c37721ee35dfdb93bf705"></a></strong>WIFI_IOT_IO_PULL_UP </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1231012081090252"><a name="p1231012081090252"></a><a name="p1231012081090252"></a>Pull-up </p>
 </td>
</tr>
<tr id="row444672039090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacc20a5c6456ec381ed931232c29d1c4fa61e259c36a0567f7ca43ff7abd1b1d81"><a name="ggacc20a5c6456ec381ed931232c29d1c4fa61e259c36a0567f7ca43ff7abd1b1d81"></a><a name="ggacc20a5c6456ec381ed931232c29d1c4fa61e259c36a0567f7ca43ff7abd1b1d81"></a></strong>WIFI_IOT_IO_PULL_DOWN </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p598491305090252"><a name="p598491305090252"></a><a name="p598491305090252"></a>Pull-down </p>
 </td>
</tr>
<tr id="row1106090930090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggacc20a5c6456ec381ed931232c29d1c4fa4d8b63c757a91e4dc317fb4e9b8e2955"><a name="ggacc20a5c6456ec381ed931232c29d1c4fa4d8b63c757a91e4dc317fb4e9b8e2955"></a><a name="ggacc20a5c6456ec381ed931232c29d1c4fa4d8b63c757a91e4dc317fb4e9b8e2955"></a></strong>WIFI_IOT_IO_PULL_MAX </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p243572329090252"><a name="p243572329090252"></a><a name="p243572329090252"></a>Maximum value </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotPwmClkSource<a name="ga2ecbd0ab9636fedd354de7447056df29"></a>

```
enum [WifiIotPwmClkSource](wifiiot.md#ga2ecbd0ab9636fedd354de7447056df29)
```

 **Description:**

Enumerates PWM clock sources. 

<a name="table125302843090252"></a>
<table><thead align="left"><tr id="row487582417090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p170409456090252"><a name="p170409456090252"></a><a name="p170409456090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p680460689090252"><a name="p680460689090252"></a><a name="p680460689090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1482559078090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2ecbd0ab9636fedd354de7447056df29adaadc6f6a5e89f7d1a8fa55d8cc89d0f"><a name="gga2ecbd0ab9636fedd354de7447056df29adaadc6f6a5e89f7d1a8fa55d8cc89d0f"></a><a name="gga2ecbd0ab9636fedd354de7447056df29adaadc6f6a5e89f7d1a8fa55d8cc89d0f"></a></strong>WIFI_IOT_PWM_CLK_160M </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1048493325090252"><a name="p1048493325090252"></a><a name="p1048493325090252"></a>160 MHz working clock </p>
 </td>
</tr>
<tr id="row1225592300090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2ecbd0ab9636fedd354de7447056df29a610c246fc1c129b3c223884b5f644888"><a name="gga2ecbd0ab9636fedd354de7447056df29a610c246fc1c129b3c223884b5f644888"></a><a name="gga2ecbd0ab9636fedd354de7447056df29a610c246fc1c129b3c223884b5f644888"></a></strong>WIFI_IOT_PWM_CLK_XTAL </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p427215862090252"><a name="p427215862090252"></a><a name="p427215862090252"></a>24 MHz or 40 MHz external crystal </p>
 </td>
</tr>
<tr id="row748276451090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2ecbd0ab9636fedd354de7447056df29a09394bc5af28cf9e01eb6cca9bf8e633"><a name="gga2ecbd0ab9636fedd354de7447056df29a09394bc5af28cf9e01eb6cca9bf8e633"></a><a name="gga2ecbd0ab9636fedd354de7447056df29a09394bc5af28cf9e01eb6cca9bf8e633"></a></strong>WIFI_IOT_PWM_CLK_MAX </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1487087932090252"><a name="p1487087932090252"></a><a name="p1487087932090252"></a>Maximum value </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotPwmPort<a name="gab3518ce878df4a40d614e88a6f81dea7"></a>

```
enum [WifiIotPwmPort](wifiiot.md#gab3518ce878df4a40d614e88a6f81dea7)
```

 **Description:**

Enumerates PWM ports. 

<a name="table1259438692090252"></a>
<table><thead align="left"><tr id="row1420110465090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p190314422090252"><a name="p190314422090252"></a><a name="p190314422090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1505207936090252"><a name="p1505207936090252"></a><a name="p1505207936090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1994008118090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggab3518ce878df4a40d614e88a6f81dea7a99047f09c031299d4c68c0eb2dc523e9"><a name="ggab3518ce878df4a40d614e88a6f81dea7a99047f09c031299d4c68c0eb2dc523e9"></a><a name="ggab3518ce878df4a40d614e88a6f81dea7a99047f09c031299d4c68c0eb2dc523e9"></a></strong>WIFI_IOT_PWM_PORT_PWM0 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1852640798090252"><a name="p1852640798090252"></a><a name="p1852640798090252"></a>PWM0 </p>
 </td>
</tr>
<tr id="row117583064090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggab3518ce878df4a40d614e88a6f81dea7afe267b92864e4b1bb171724d8f555922"><a name="ggab3518ce878df4a40d614e88a6f81dea7afe267b92864e4b1bb171724d8f555922"></a><a name="ggab3518ce878df4a40d614e88a6f81dea7afe267b92864e4b1bb171724d8f555922"></a></strong>WIFI_IOT_PWM_PORT_PWM1 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1030495421090252"><a name="p1030495421090252"></a><a name="p1030495421090252"></a>PWM1 </p>
 </td>
</tr>
<tr id="row1156213035090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggab3518ce878df4a40d614e88a6f81dea7ac6530394f6bab8fecc8cf7417646c66b"><a name="ggab3518ce878df4a40d614e88a6f81dea7ac6530394f6bab8fecc8cf7417646c66b"></a><a name="ggab3518ce878df4a40d614e88a6f81dea7ac6530394f6bab8fecc8cf7417646c66b"></a></strong>WIFI_IOT_PWM_PORT_PWM2 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p427063997090252"><a name="p427063997090252"></a><a name="p427063997090252"></a>PWM2 </p>
 </td>
</tr>
<tr id="row1739291024090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggab3518ce878df4a40d614e88a6f81dea7a0b16863a2291abfac01581c15e184126"><a name="ggab3518ce878df4a40d614e88a6f81dea7a0b16863a2291abfac01581c15e184126"></a><a name="ggab3518ce878df4a40d614e88a6f81dea7a0b16863a2291abfac01581c15e184126"></a></strong>WIFI_IOT_PWM_PORT_PWM3 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p624700615090252"><a name="p624700615090252"></a><a name="p624700615090252"></a>PWM3 </p>
 </td>
</tr>
<tr id="row904766598090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggab3518ce878df4a40d614e88a6f81dea7aa6d4371910a891288c6181ffd358b7fb"><a name="ggab3518ce878df4a40d614e88a6f81dea7aa6d4371910a891288c6181ffd358b7fb"></a><a name="ggab3518ce878df4a40d614e88a6f81dea7aa6d4371910a891288c6181ffd358b7fb"></a></strong>WIFI_IOT_PWM_PORT_PWM4 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1720585913090252"><a name="p1720585913090252"></a><a name="p1720585913090252"></a>PWM4 </p>
 </td>
</tr>
<tr id="row1643991230090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggab3518ce878df4a40d614e88a6f81dea7a3f7666b782bb361e556e8062b4ff80aa"><a name="ggab3518ce878df4a40d614e88a6f81dea7a3f7666b782bb361e556e8062b4ff80aa"></a><a name="ggab3518ce878df4a40d614e88a6f81dea7a3f7666b782bb361e556e8062b4ff80aa"></a></strong>WIFI_IOT_PWM_PORT_PWM5 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1011190545090252"><a name="p1011190545090252"></a><a name="p1011190545090252"></a>PWM5 </p>
 </td>
</tr>
<tr id="row1060298356090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggab3518ce878df4a40d614e88a6f81dea7a24bfb3984d6e6e91f897e20e267ada3b"><a name="ggab3518ce878df4a40d614e88a6f81dea7a24bfb3984d6e6e91f897e20e267ada3b"></a><a name="ggab3518ce878df4a40d614e88a6f81dea7a24bfb3984d6e6e91f897e20e267ada3b"></a></strong>WIFI_IOT_PWM_PORT_MAX </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1589628119090252"><a name="p1589628119090252"></a><a name="p1589628119090252"></a>Maximum value </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotSpiCfgClockCpha<a name="ga1eb13cffbbdec9da1d57c766763b94e5"></a>

```
enum [WifiIotSpiCfgClockCpha](wifiiot.md#ga1eb13cffbbdec9da1d57c766763b94e5)
```

 **Description:**

Enumerates communication phases. 

<a name="table840467561090252"></a>
<table><thead align="left"><tr id="row353487331090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p666649986090252"><a name="p666649986090252"></a><a name="p666649986090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1805936707090252"><a name="p1805936707090252"></a><a name="p1805936707090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row429700678090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga1eb13cffbbdec9da1d57c766763b94e5af8cbca20bbbc6c065eae3cb21382d3b6"><a name="gga1eb13cffbbdec9da1d57c766763b94e5af8cbca20bbbc6c065eae3cb21382d3b6"></a><a name="gga1eb13cffbbdec9da1d57c766763b94e5af8cbca20bbbc6c065eae3cb21382d3b6"></a></strong>WIFI_IOT_SPI_CFG_CLOCK_CPHA_0 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1076708382090252"><a name="p1076708382090252"></a><a name="p1076708382090252"></a>Phase 0 </p>
 </td>
</tr>
<tr id="row1686076131090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga1eb13cffbbdec9da1d57c766763b94e5abd4a35c6cbe22a90892f1f877eb9be3f"><a name="gga1eb13cffbbdec9da1d57c766763b94e5abd4a35c6cbe22a90892f1f877eb9be3f"></a><a name="gga1eb13cffbbdec9da1d57c766763b94e5abd4a35c6cbe22a90892f1f877eb9be3f"></a></strong>WIFI_IOT_SPI_CFG_CLOCK_CPHA_1 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p321488013090252"><a name="p321488013090252"></a><a name="p321488013090252"></a>Phase 1 </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotSpiCfgClockCpol<a name="gad6674c8b0989b6a329d5fd5ff0d5d750"></a>

```
enum [WifiIotSpiCfgClockCpol](wifiiot.md#gad6674c8b0989b6a329d5fd5ff0d5d750)
```

 **Description:**

Enumerates communication polarities. 

<a name="table1747527370090252"></a>
<table><thead align="left"><tr id="row1912930005090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1792514201090252"><a name="p1792514201090252"></a><a name="p1792514201090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p445088001090252"><a name="p445088001090252"></a><a name="p445088001090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row612783793090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggad6674c8b0989b6a329d5fd5ff0d5d750a07059b75b690958e26aa89a6004bf271"><a name="ggad6674c8b0989b6a329d5fd5ff0d5d750a07059b75b690958e26aa89a6004bf271"></a><a name="ggad6674c8b0989b6a329d5fd5ff0d5d750a07059b75b690958e26aa89a6004bf271"></a></strong>WIFI_IOT_SPI_CFG_CLOCK_CPOL_0 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p742870236090252"><a name="p742870236090252"></a><a name="p742870236090252"></a>Polarity 0 </p>
 </td>
</tr>
<tr id="row295043933090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggad6674c8b0989b6a329d5fd5ff0d5d750a0a0c2d8a56ac7fb1c965e496ef9d24fd"><a name="ggad6674c8b0989b6a329d5fd5ff0d5d750a0a0c2d8a56ac7fb1c965e496ef9d24fd"></a><a name="ggad6674c8b0989b6a329d5fd5ff0d5d750a0a0c2d8a56ac7fb1c965e496ef9d24fd"></a></strong>WIFI_IOT_SPI_CFG_CLOCK_CPOL_1 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p107466906090252"><a name="p107466906090252"></a><a name="p107466906090252"></a>Polarity 1 </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotSpiCfgDataWidth<a name="ga6f2e44db2698c33b81bd6caa438a55ea"></a>

```
enum [WifiIotSpiCfgDataWidth](wifiiot.md#ga6f2e44db2698c33b81bd6caa438a55ea)
```

 **Description:**

Enumerates the communication data width, that is, the number of valid bits in each frame. 

<a name="table1434394702090252"></a>
<table><thead align="left"><tr id="row384694293090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p571063717090252"><a name="p571063717090252"></a><a name="p571063717090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p300108088090252"><a name="p300108088090252"></a><a name="p300108088090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row607612333090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6f2e44db2698c33b81bd6caa438a55eaaddfa282d58578fc81ac526987564e6ee"><a name="gga6f2e44db2698c33b81bd6caa438a55eaaddfa282d58578fc81ac526987564e6ee"></a><a name="gga6f2e44db2698c33b81bd6caa438a55eaaddfa282d58578fc81ac526987564e6ee"></a></strong>WIFI_IOT_SPI_CFG_DATA_WIDTH_E_4BIT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p416728701090252"><a name="p416728701090252"></a><a name="p416728701090252"></a>4 bits </p>
 </td>
</tr>
<tr id="row975181404090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6f2e44db2698c33b81bd6caa438a55eaa9de2e6dd354e226a820c079b8bac65b6"><a name="gga6f2e44db2698c33b81bd6caa438a55eaa9de2e6dd354e226a820c079b8bac65b6"></a><a name="gga6f2e44db2698c33b81bd6caa438a55eaa9de2e6dd354e226a820c079b8bac65b6"></a></strong>WIFI_IOT_SPI_CFG_DATA_WIDTH_E_5BIT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p332790013090252"><a name="p332790013090252"></a><a name="p332790013090252"></a>5 bits </p>
 </td>
</tr>
<tr id="row1450467296090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6f2e44db2698c33b81bd6caa438a55eaaa4144e7267c3a0417d8d0100cfcf50dd"><a name="gga6f2e44db2698c33b81bd6caa438a55eaaa4144e7267c3a0417d8d0100cfcf50dd"></a><a name="gga6f2e44db2698c33b81bd6caa438a55eaaa4144e7267c3a0417d8d0100cfcf50dd"></a></strong>WIFI_IOT_SPI_CFG_DATA_WIDTH_E_6BIT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1661734340090252"><a name="p1661734340090252"></a><a name="p1661734340090252"></a>6 bits </p>
 </td>
</tr>
<tr id="row389621522090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6f2e44db2698c33b81bd6caa438a55eaa95f9ec882c23c6e61182dbc64a4204ff"><a name="gga6f2e44db2698c33b81bd6caa438a55eaa95f9ec882c23c6e61182dbc64a4204ff"></a><a name="gga6f2e44db2698c33b81bd6caa438a55eaa95f9ec882c23c6e61182dbc64a4204ff"></a></strong>WIFI_IOT_SPI_CFG_DATA_WIDTH_E_7BIT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p239620223090252"><a name="p239620223090252"></a><a name="p239620223090252"></a>7 bits </p>
 </td>
</tr>
<tr id="row1769414319090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6f2e44db2698c33b81bd6caa438a55eaa87c4e51ad22460a2ee1e8f4a818ab4d0"><a name="gga6f2e44db2698c33b81bd6caa438a55eaa87c4e51ad22460a2ee1e8f4a818ab4d0"></a><a name="gga6f2e44db2698c33b81bd6caa438a55eaa87c4e51ad22460a2ee1e8f4a818ab4d0"></a></strong>WIFI_IOT_SPI_CFG_DATA_WIDTH_E_8BIT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p286576268090252"><a name="p286576268090252"></a><a name="p286576268090252"></a>8 bits </p>
 </td>
</tr>
<tr id="row1140539293090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6f2e44db2698c33b81bd6caa438a55eaa1760c12ab9015525fa00483aa3ae6ce3"><a name="gga6f2e44db2698c33b81bd6caa438a55eaa1760c12ab9015525fa00483aa3ae6ce3"></a><a name="gga6f2e44db2698c33b81bd6caa438a55eaa1760c12ab9015525fa00483aa3ae6ce3"></a></strong>WIFI_IOT_SPI_CFG_DATA_WIDTH_E_9BIT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1365956512090252"><a name="p1365956512090252"></a><a name="p1365956512090252"></a>9 bits </p>
 </td>
</tr>
<tr id="row139925008090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6f2e44db2698c33b81bd6caa438a55eaa2d5436642374f2e20544f4dd23b2a82e"><a name="gga6f2e44db2698c33b81bd6caa438a55eaa2d5436642374f2e20544f4dd23b2a82e"></a><a name="gga6f2e44db2698c33b81bd6caa438a55eaa2d5436642374f2e20544f4dd23b2a82e"></a></strong>WIFI_IOT_SPI_CFG_DATA_WIDTH_E_10BIT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1472628930090252"><a name="p1472628930090252"></a><a name="p1472628930090252"></a>10 bits </p>
 </td>
</tr>
<tr id="row361782873090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6f2e44db2698c33b81bd6caa438a55eaa7de25e82ef22f3d7ecca7ba6740affaf"><a name="gga6f2e44db2698c33b81bd6caa438a55eaa7de25e82ef22f3d7ecca7ba6740affaf"></a><a name="gga6f2e44db2698c33b81bd6caa438a55eaa7de25e82ef22f3d7ecca7ba6740affaf"></a></strong>WIFI_IOT_SPI_CFG_DATA_WIDTH_E_11BIT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1628692303090252"><a name="p1628692303090252"></a><a name="p1628692303090252"></a>11 bits </p>
 </td>
</tr>
<tr id="row1987040549090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6f2e44db2698c33b81bd6caa438a55eaa7ef096c72549f4bdccd2da349928d197"><a name="gga6f2e44db2698c33b81bd6caa438a55eaa7ef096c72549f4bdccd2da349928d197"></a><a name="gga6f2e44db2698c33b81bd6caa438a55eaa7ef096c72549f4bdccd2da349928d197"></a></strong>WIFI_IOT_SPI_CFG_DATA_WIDTH_E_12BIT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1611618817090252"><a name="p1611618817090252"></a><a name="p1611618817090252"></a>12 bits </p>
 </td>
</tr>
<tr id="row1397320518090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6f2e44db2698c33b81bd6caa438a55eaadfa6793a7643c016f8946dbb6fefb393"><a name="gga6f2e44db2698c33b81bd6caa438a55eaadfa6793a7643c016f8946dbb6fefb393"></a><a name="gga6f2e44db2698c33b81bd6caa438a55eaadfa6793a7643c016f8946dbb6fefb393"></a></strong>WIFI_IOT_SPI_CFG_DATA_WIDTH_E_13BIT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1683649815090252"><a name="p1683649815090252"></a><a name="p1683649815090252"></a>13 bits </p>
 </td>
</tr>
<tr id="row162441365090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6f2e44db2698c33b81bd6caa438a55eaaa10903f6e508f27f7290345ad77e8aad"><a name="gga6f2e44db2698c33b81bd6caa438a55eaaa10903f6e508f27f7290345ad77e8aad"></a><a name="gga6f2e44db2698c33b81bd6caa438a55eaaa10903f6e508f27f7290345ad77e8aad"></a></strong>WIFI_IOT_SPI_CFG_DATA_WIDTH_E_14BIT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p259985861090252"><a name="p259985861090252"></a><a name="p259985861090252"></a>14 bits </p>
 </td>
</tr>
<tr id="row200083745090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6f2e44db2698c33b81bd6caa438a55eaa626cba1c95892d1265908e94b8df725a"><a name="gga6f2e44db2698c33b81bd6caa438a55eaa626cba1c95892d1265908e94b8df725a"></a><a name="gga6f2e44db2698c33b81bd6caa438a55eaa626cba1c95892d1265908e94b8df725a"></a></strong>WIFI_IOT_SPI_CFG_DATA_WIDTH_E_15BIT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1669575036090252"><a name="p1669575036090252"></a><a name="p1669575036090252"></a>15 bits </p>
 </td>
</tr>
<tr id="row2045062949090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga6f2e44db2698c33b81bd6caa438a55eaa3dba59e8d0c84fa68875aa4ff3988e9c"><a name="gga6f2e44db2698c33b81bd6caa438a55eaa3dba59e8d0c84fa68875aa4ff3988e9c"></a><a name="gga6f2e44db2698c33b81bd6caa438a55eaa3dba59e8d0c84fa68875aa4ff3988e9c"></a></strong>WIFI_IOT_SPI_CFG_DATA_WIDTH_E_16BIT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1638874157090252"><a name="p1638874157090252"></a><a name="p1638874157090252"></a>16 bits </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotSpiCfgEndian<a name="ga31924085df23a024413fa6e63e13c41e"></a>

```
enum [WifiIotSpiCfgEndian](wifiiot.md#ga31924085df23a024413fa6e63e13c41e)
```

 **Description:**

Enumerates the endian mode of each frame. 

<a name="table1288379563090252"></a>
<table><thead align="left"><tr id="row1592539602090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p924012174090252"><a name="p924012174090252"></a><a name="p924012174090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1457420720090252"><a name="p1457420720090252"></a><a name="p1457420720090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row684784909090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga31924085df23a024413fa6e63e13c41ea68812944912ba0729ae0efeb2d126c2a"><a name="gga31924085df23a024413fa6e63e13c41ea68812944912ba0729ae0efeb2d126c2a"></a><a name="gga31924085df23a024413fa6e63e13c41ea68812944912ba0729ae0efeb2d126c2a"></a></strong>WIFI_IOT_SPI_CFG_ENDIAN_LITTLE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1090490789090252"><a name="p1090490789090252"></a><a name="p1090490789090252"></a>Little-endian </p>
 </td>
</tr>
<tr id="row1946347489090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga31924085df23a024413fa6e63e13c41eabed491171ca62fc1cfcc5d7b7b0413b1"><a name="gga31924085df23a024413fa6e63e13c41eabed491171ca62fc1cfcc5d7b7b0413b1"></a><a name="gga31924085df23a024413fa6e63e13c41eabed491171ca62fc1cfcc5d7b7b0413b1"></a></strong>WIFI_IOT_SPI_CFG_ENDIAN_BIG </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1914539013090252"><a name="p1914539013090252"></a><a name="p1914539013090252"></a>Big-endian </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotSpiCfgFramMode<a name="gaef7c192e049db14e2326c0bfba181670"></a>

```
enum [WifiIotSpiCfgFramMode](wifiiot.md#gaef7c192e049db14e2326c0bfba181670)
```

 **Description:**

Enumerates communication protocols. 

<a name="table2029491684090252"></a>
<table><thead align="left"><tr id="row1278967436090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p225512693090252"><a name="p225512693090252"></a><a name="p225512693090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p747294065090252"><a name="p747294065090252"></a><a name="p747294065090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2014219717090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaef7c192e049db14e2326c0bfba181670a3d7e1d60fe5cdf86cd72cca5e20109fb"><a name="ggaef7c192e049db14e2326c0bfba181670a3d7e1d60fe5cdf86cd72cca5e20109fb"></a><a name="ggaef7c192e049db14e2326c0bfba181670a3d7e1d60fe5cdf86cd72cca5e20109fb"></a></strong>WIFI_IOT_SPI_CFG_FRAM_MODE_MOTOROLA </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1133764434090252"><a name="p1133764434090252"></a><a name="p1133764434090252"></a>Motorola protocol </p>
 </td>
</tr>
<tr id="row287226637090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaef7c192e049db14e2326c0bfba181670a8b16cdb5100d57654c512e88275c789d"><a name="ggaef7c192e049db14e2326c0bfba181670a8b16cdb5100d57654c512e88275c789d"></a><a name="ggaef7c192e049db14e2326c0bfba181670a8b16cdb5100d57654c512e88275c789d"></a></strong>WIFI_IOT_SPI_CFG_FRAM_MODE_TI </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p170588209090252"><a name="p170588209090252"></a><a name="p170588209090252"></a>Texas Instruments protocol </p>
 </td>
</tr>
<tr id="row1568681585090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaef7c192e049db14e2326c0bfba181670a2f0198dff6d832a556a621b5de0606fc"><a name="ggaef7c192e049db14e2326c0bfba181670a2f0198dff6d832a556a621b5de0606fc"></a><a name="ggaef7c192e049db14e2326c0bfba181670a2f0198dff6d832a556a621b5de0606fc"></a></strong>WIFI_IOT_SPI_CFG_FRAM_MODE_MICROWIRE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p396076334090252"><a name="p396076334090252"></a><a name="p396076334090252"></a>Microwire protocol </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotSpiIdx<a name="ga1d095e78d92cdf2ffc5e34443726e44b"></a>

```
enum [WifiIotSpiIdx](wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b)
```

 **Description:**

Enumerates SPI channel IDs. 

<a name="table1564557193090252"></a>
<table><thead align="left"><tr id="row815796791090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p739085137090252"><a name="p739085137090252"></a><a name="p739085137090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1224626464090252"><a name="p1224626464090252"></a><a name="p1224626464090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row880867669090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga1d095e78d92cdf2ffc5e34443726e44ba3a13c86181ffb2c6927f86f423ec40b4"><a name="gga1d095e78d92cdf2ffc5e34443726e44ba3a13c86181ffb2c6927f86f423ec40b4"></a><a name="gga1d095e78d92cdf2ffc5e34443726e44ba3a13c86181ffb2c6927f86f423ec40b4"></a></strong>WIFI_IOT_SPI_ID_0 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p410003072090252"><a name="p410003072090252"></a><a name="p410003072090252"></a>Channel 0 </p>
 </td>
</tr>
<tr id="row346208096090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga1d095e78d92cdf2ffc5e34443726e44baeb87de3e3fe320957bc97c2fcc430da1"><a name="gga1d095e78d92cdf2ffc5e34443726e44baeb87de3e3fe320957bc97c2fcc430da1"></a><a name="gga1d095e78d92cdf2ffc5e34443726e44baeb87de3e3fe320957bc97c2fcc430da1"></a></strong>WIFI_IOT_SPI_ID_1 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p912045801090252"><a name="p912045801090252"></a><a name="p912045801090252"></a>Channel 1 </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotUartBlockState<a name="ga93f35a58dc54e29d4892d1e94179c72d"></a>

```
enum [WifiIotUartBlockState](wifiiot.md#ga93f35a58dc54e29d4892d1e94179c72d)
```

 **Description:**

Enumerates UART block states. 

<a name="table719167529090252"></a>
<table><thead align="left"><tr id="row1964584049090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1613869047090252"><a name="p1613869047090252"></a><a name="p1613869047090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p917390219090252"><a name="p917390219090252"></a><a name="p917390219090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1361075074090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga93f35a58dc54e29d4892d1e94179c72da4c82baa44ed8c8c48f3a0f4659e9a05b"><a name="gga93f35a58dc54e29d4892d1e94179c72da4c82baa44ed8c8c48f3a0f4659e9a05b"></a><a name="gga93f35a58dc54e29d4892d1e94179c72da4c82baa44ed8c8c48f3a0f4659e9a05b"></a></strong>WIFI_IOT_UART_BLOCK_STATE_NONE_BLOCK </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p803944686090252"><a name="p803944686090252"></a><a name="p803944686090252"></a>Block disabled </p>
 </td>
</tr>
<tr id="row1220057422090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga93f35a58dc54e29d4892d1e94179c72da17f7be87206b00b8e42a5ab3d48be1de"><a name="gga93f35a58dc54e29d4892d1e94179c72da17f7be87206b00b8e42a5ab3d48be1de"></a><a name="gga93f35a58dc54e29d4892d1e94179c72da17f7be87206b00b8e42a5ab3d48be1de"></a></strong>WIFI_IOT_UART_BLOCK_STATE_BLOCK </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1264721409090252"><a name="p1264721409090252"></a><a name="p1264721409090252"></a>Block enabled </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotUartDmaState<a name="gaf36ed6a640d85e79dfee020131e0d86f"></a>

```
enum [WifiIotUartDmaState](wifiiot.md#gaf36ed6a640d85e79dfee020131e0d86f)
```

 **Description:**

Enumerates UART DMA states. 

<a name="table1488923190090252"></a>
<table><thead align="left"><tr id="row227184250090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p965679933090252"><a name="p965679933090252"></a><a name="p965679933090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p772159741090252"><a name="p772159741090252"></a><a name="p772159741090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row864236147090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaf36ed6a640d85e79dfee020131e0d86fa7c272d8288c6a14d6f8a663e6aa148c7"><a name="ggaf36ed6a640d85e79dfee020131e0d86fa7c272d8288c6a14d6f8a663e6aa148c7"></a><a name="ggaf36ed6a640d85e79dfee020131e0d86fa7c272d8288c6a14d6f8a663e6aa148c7"></a></strong>WIFI_IOT_UART_NONE_DMA </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1323160966090252"><a name="p1323160966090252"></a><a name="p1323160966090252"></a>DMA disabled </p>
 </td>
</tr>
<tr id="row1035581803090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaf36ed6a640d85e79dfee020131e0d86facdc483dbfb6421d1604e1b2008fac7ac"><a name="ggaf36ed6a640d85e79dfee020131e0d86facdc483dbfb6421d1604e1b2008fac7ac"></a><a name="ggaf36ed6a640d85e79dfee020131e0d86facdc483dbfb6421d1604e1b2008fac7ac"></a></strong>WIFI_IOT_UART_USE_DMA </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1355262053090252"><a name="p1355262053090252"></a><a name="p1355262053090252"></a>DMA enabled </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotUartFifoLine<a name="ga1c15f86994b472d35bee5d6b57d42a49"></a>

```
enum [WifiIotUartFifoLine](wifiiot.md#ga1c15f86994b472d35bee5d6b57d42a49)
```

 **Description:**

Enumerates UART FIFO interrupt thresholds. 

<a name="table1866372220090252"></a>
<table><thead align="left"><tr id="row430274650090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p658528368090252"><a name="p658528368090252"></a><a name="p658528368090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1849420803090252"><a name="p1849420803090252"></a><a name="p1849420803090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1469767073090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga1c15f86994b472d35bee5d6b57d42a49a3003d4ad2672ef855b80317b708a0fdb"><a name="gga1c15f86994b472d35bee5d6b57d42a49a3003d4ad2672ef855b80317b708a0fdb"></a><a name="gga1c15f86994b472d35bee5d6b57d42a49a3003d4ad2672ef855b80317b708a0fdb"></a></strong>WIFI_IOT_FIFO_LINE_ONE_EIGHT </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p100661717090252"><a name="p100661717090252"></a><a name="p100661717090252"></a>FIFO = 1/8 full </p>
 </td>
</tr>
<tr id="row911620278090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga1c15f86994b472d35bee5d6b57d42a49af9a3ea60c05bd3cc8cc793d358543f7c"><a name="gga1c15f86994b472d35bee5d6b57d42a49af9a3ea60c05bd3cc8cc793d358543f7c"></a><a name="gga1c15f86994b472d35bee5d6b57d42a49af9a3ea60c05bd3cc8cc793d358543f7c"></a></strong>WIFI_IOT_FIFO_LINE_ONE_QUARTER </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1945830331090252"><a name="p1945830331090252"></a><a name="p1945830331090252"></a>FIFO = 1/4 full </p>
 </td>
</tr>
<tr id="row927588430090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga1c15f86994b472d35bee5d6b57d42a49a3f8731dc0941726af9cd00ba1b2bf3ee"><a name="gga1c15f86994b472d35bee5d6b57d42a49a3f8731dc0941726af9cd00ba1b2bf3ee"></a><a name="gga1c15f86994b472d35bee5d6b57d42a49a3f8731dc0941726af9cd00ba1b2bf3ee"></a></strong>WIFI_IOT_FIFO_LINE_HALF </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1114302855090252"><a name="p1114302855090252"></a><a name="p1114302855090252"></a>FIFO = 1/2 full </p>
 </td>
</tr>
<tr id="row891711678090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga1c15f86994b472d35bee5d6b57d42a49aac418922b4708891f9b35b7169569eae"><a name="gga1c15f86994b472d35bee5d6b57d42a49aac418922b4708891f9b35b7169569eae"></a><a name="gga1c15f86994b472d35bee5d6b57d42a49aac418922b4708891f9b35b7169569eae"></a></strong>WIFI_IOT_FIFO_LINE_THREE_QUARTERS </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1416180704090252"><a name="p1416180704090252"></a><a name="p1416180704090252"></a>FIFO = 3/4 full </p>
 </td>
</tr>
<tr id="row591801766090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga1c15f86994b472d35bee5d6b57d42a49a6fb9cbffe9467f79f72bd49f504d6407"><a name="gga1c15f86994b472d35bee5d6b57d42a49a6fb9cbffe9467f79f72bd49f504d6407"></a><a name="gga1c15f86994b472d35bee5d6b57d42a49a6fb9cbffe9467f79f72bd49f504d6407"></a></strong>WIFI_IOT_FIFO_LINE_SEVEN_EIGHTS </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p51515941090252"><a name="p51515941090252"></a><a name="p51515941090252"></a>FIFO = 7/8 full </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotUartIdx<a name="ga2699252424e5469ef243ae279a263c44"></a>

```
enum [WifiIotUartIdx](wifiiot.md#ga2699252424e5469ef243ae279a263c44)
```

 **Description:**

Enumerates the UART serial number. 

<a name="table746107829090252"></a>
<table><thead align="left"><tr id="row2036665039090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p870878679090252"><a name="p870878679090252"></a><a name="p870878679090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p885288938090252"><a name="p885288938090252"></a><a name="p885288938090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row11645776090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2699252424e5469ef243ae279a263c44a857a6dfad592ed99b2d8bb33d904efc1"><a name="gga2699252424e5469ef243ae279a263c44a857a6dfad592ed99b2d8bb33d904efc1"></a><a name="gga2699252424e5469ef243ae279a263c44a857a6dfad592ed99b2d8bb33d904efc1"></a></strong>WIFI_IOT_UART_IDX_0 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p691588730090252"><a name="p691588730090252"></a><a name="p691588730090252"></a>Physical port 0 </p>
 </td>
</tr>
<tr id="row1646792658090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2699252424e5469ef243ae279a263c44afb78269eebd0488de767da02fd576c97"><a name="gga2699252424e5469ef243ae279a263c44afb78269eebd0488de767da02fd576c97"></a><a name="gga2699252424e5469ef243ae279a263c44afb78269eebd0488de767da02fd576c97"></a></strong>WIFI_IOT_UART_IDX_1 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2129850498090252"><a name="p2129850498090252"></a><a name="p2129850498090252"></a>Physical port 1 </p>
 </td>
</tr>
<tr id="row1703490993090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2699252424e5469ef243ae279a263c44afe10e4ecae6f290980243f74c0582e8f"><a name="gga2699252424e5469ef243ae279a263c44afe10e4ecae6f290980243f74c0582e8f"></a><a name="gga2699252424e5469ef243ae279a263c44afe10e4ecae6f290980243f74c0582e8f"></a></strong>WIFI_IOT_UART_IDX_2 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p167100770090252"><a name="p167100770090252"></a><a name="p167100770090252"></a>Physical port 2 </p>
 </td>
</tr>
<tr id="row1455670000090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2699252424e5469ef243ae279a263c44a4f01b665c25a5c2fb4188156c138a13d"><a name="gga2699252424e5469ef243ae279a263c44a4f01b665c25a5c2fb4188156c138a13d"></a><a name="gga2699252424e5469ef243ae279a263c44a4f01b665c25a5c2fb4188156c138a13d"></a></strong>WIFI_IOT_UART_IDX_MAX </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1840477877090252"><a name="p1840477877090252"></a><a name="p1840477877090252"></a>Maximum value </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotUartIdxDataBit<a name="gafdf1adfc0e0ed18282aa3006300b12b4"></a>

```
enum [WifiIotUartIdxDataBit](wifiiot.md#gafdf1adfc0e0ed18282aa3006300b12b4)
```

 **Description:**

Enumerates the number of UART data bits. 

<a name="table990235073090252"></a>
<table><thead align="left"><tr id="row1027016632090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2058255561090252"><a name="p2058255561090252"></a><a name="p2058255561090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p591725567090252"><a name="p591725567090252"></a><a name="p591725567090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1365619688090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggafdf1adfc0e0ed18282aa3006300b12b4afd012e7a4332f70fd227e3471adf337b"><a name="ggafdf1adfc0e0ed18282aa3006300b12b4afd012e7a4332f70fd227e3471adf337b"></a><a name="ggafdf1adfc0e0ed18282aa3006300b12b4afd012e7a4332f70fd227e3471adf337b"></a></strong>WIFI_IOT_UART_DATA_BIT_5 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1590938515090252"><a name="p1590938515090252"></a><a name="p1590938515090252"></a>5 data bits </p>
 </td>
</tr>
<tr id="row1377128825090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggafdf1adfc0e0ed18282aa3006300b12b4aff9e05b0da6c4120371c89d0c07e25b8"><a name="ggafdf1adfc0e0ed18282aa3006300b12b4aff9e05b0da6c4120371c89d0c07e25b8"></a><a name="ggafdf1adfc0e0ed18282aa3006300b12b4aff9e05b0da6c4120371c89d0c07e25b8"></a></strong>WIFI_IOT_UART_DATA_BIT_6 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p257390012090252"><a name="p257390012090252"></a><a name="p257390012090252"></a>6 data bits </p>
 </td>
</tr>
<tr id="row1231803537090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggafdf1adfc0e0ed18282aa3006300b12b4a45121424f9ea54a738fbb976ff3e9bee"><a name="ggafdf1adfc0e0ed18282aa3006300b12b4a45121424f9ea54a738fbb976ff3e9bee"></a><a name="ggafdf1adfc0e0ed18282aa3006300b12b4a45121424f9ea54a738fbb976ff3e9bee"></a></strong>WIFI_IOT_UART_DATA_BIT_7 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1261618711090252"><a name="p1261618711090252"></a><a name="p1261618711090252"></a>7 data bits </p>
 </td>
</tr>
<tr id="row1104986521090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggafdf1adfc0e0ed18282aa3006300b12b4a2dd7698b7154c4905e6908336347ddb1"><a name="ggafdf1adfc0e0ed18282aa3006300b12b4a2dd7698b7154c4905e6908336347ddb1"></a><a name="ggafdf1adfc0e0ed18282aa3006300b12b4a2dd7698b7154c4905e6908336347ddb1"></a></strong>WIFI_IOT_UART_DATA_BIT_8 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p578691445090252"><a name="p578691445090252"></a><a name="p578691445090252"></a>8 data bits </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotUartParity<a name="ga9cee98ab295d2e42ab7f0fb614268602"></a>

```
enum [WifiIotUartParity](wifiiot.md#ga9cee98ab295d2e42ab7f0fb614268602)
```

 **Description:**

Enumerates the UART parity bit. 

<a name="table490281915090252"></a>
<table><thead align="left"><tr id="row2104560754090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1426871922090252"><a name="p1426871922090252"></a><a name="p1426871922090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1943736263090252"><a name="p1943736263090252"></a><a name="p1943736263090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row229446076090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga9cee98ab295d2e42ab7f0fb614268602aaa5d06991c6d267b87c8b2e89e3bae4b"><a name="gga9cee98ab295d2e42ab7f0fb614268602aaa5d06991c6d267b87c8b2e89e3bae4b"></a><a name="gga9cee98ab295d2e42ab7f0fb614268602aaa5d06991c6d267b87c8b2e89e3bae4b"></a></strong>WIFI_IOT_UART_PARITY_NONE </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2036370928090252"><a name="p2036370928090252"></a><a name="p2036370928090252"></a>No parity </p>
 </td>
</tr>
<tr id="row851813229090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga9cee98ab295d2e42ab7f0fb614268602a2552846d7dac988f292b2495a6a3b193"><a name="gga9cee98ab295d2e42ab7f0fb614268602a2552846d7dac988f292b2495a6a3b193"></a><a name="gga9cee98ab295d2e42ab7f0fb614268602a2552846d7dac988f292b2495a6a3b193"></a></strong>WIFI_IOT_UART_PARITY_ODD </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1394730422090252"><a name="p1394730422090252"></a><a name="p1394730422090252"></a>Odd parity </p>
 </td>
</tr>
<tr id="row1361883004090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga9cee98ab295d2e42ab7f0fb614268602af4deb913ecbe142ef3df8e9f0b985e36"><a name="gga9cee98ab295d2e42ab7f0fb614268602af4deb913ecbe142ef3df8e9f0b985e36"></a><a name="gga9cee98ab295d2e42ab7f0fb614268602af4deb913ecbe142ef3df8e9f0b985e36"></a></strong>WIFI_IOT_UART_PARITY_EVEN </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p258122763090252"><a name="p258122763090252"></a><a name="p258122763090252"></a>Even parity </p>
 </td>
</tr>
</tbody>
</table>

## WifiIotUartStopBit<a name="gab0a1b43e8e98b028717e6557003b3172"></a>

```
enum [WifiIotUartStopBit](wifiiot.md#gab0a1b43e8e98b028717e6557003b3172)
```

 **Description:**

Enumerates the number of UART stop bits. 

<a name="table753118074090252"></a>
<table><thead align="left"><tr id="row877463647090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p108952607090252"><a name="p108952607090252"></a><a name="p108952607090252"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p499024068090252"><a name="p499024068090252"></a><a name="p499024068090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row736508380090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggab0a1b43e8e98b028717e6557003b3172accbf9f04cf5f1e8203ead9d5663ee8e8"><a name="ggab0a1b43e8e98b028717e6557003b3172accbf9f04cf5f1e8203ead9d5663ee8e8"></a><a name="ggab0a1b43e8e98b028717e6557003b3172accbf9f04cf5f1e8203ead9d5663ee8e8"></a></strong>WIFI_IOT_UART_STOP_BIT_1 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p297017894090252"><a name="p297017894090252"></a><a name="p297017894090252"></a>1 stop bit </p>
 </td>
</tr>
<tr id="row1429091369090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggab0a1b43e8e98b028717e6557003b3172a6c40d45a17b4c9d38696284d01faa8e8"><a name="ggab0a1b43e8e98b028717e6557003b3172a6c40d45a17b4c9d38696284d01faa8e8"></a><a name="ggab0a1b43e8e98b028717e6557003b3172a6c40d45a17b4c9d38696284d01faa8e8"></a></strong>WIFI_IOT_UART_STOP_BIT_2 </td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1394188559090252"><a name="p1394188559090252"></a><a name="p1394188559090252"></a>2 stop bit </p>
 </td>
</tr>
</tbody>
</table>

## **Function Documentation**<a name="section297926972090252"></a>

## AdcRead\(\)<a name="ga6e43b3c41859efd279c9a539a4e38731"></a>

```
unsigned int AdcRead ([WifiIotAdcChannelIndex](wifiiot.md#ga4c8b663163c7b23071914947a2bca73b) channel, unsigned short * data, [WifiIotAdcEquModelSel](wifiiot.md#gafb9992ebf1655f994dc56883c8fe4b2e) equModel, [WifiIotAdcCurBais](wifiiot.md#gaac161eb7075f815f6d39a63615bfa82d) curBais, unsigned short rstCnt )
```

 **Description:**

Reads a piece of sampled data from a specified ADC channel based on the input parameters. 

**Parameters:**

<a name="table677041271090252"></a>
<table><thead align="left"><tr id="row1883814120090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p652735477090252"><a name="p652735477090252"></a><a name="p652735477090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1829583221090252"><a name="p1829583221090252"></a><a name="p1829583221090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row304788589090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">channel</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the ADC channel index. </td>
</tr>
<tr id="row747889213090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">data</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the address for storing the read data. </td>
</tr>
<tr id="row1157272645090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">equModel</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the equation model. </td>
</tr>
<tr id="row1434312479090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curBais</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the analog power control mode. </td>
</tr>
<tr id="row1360563043090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">rstCnt</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the count of the time from reset to conversion start. One count is equal to 334 ns. The value must range from 0 to 0xFF0. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## AtCheckUartBusy\(\)<a name="ga9068fd445d529fbc468fd27c336f1c43"></a>

```
void AtCheckUartBusy (unsigned char enable)
```

 **Description:**

Sets whether to check the UART busy status during low-power voting. 

This function determines whether to check the UART status before the device enters the low-power mode. If  **enable**  is set to  **1**  and the UART is found to be busy, the device does not enter the low-power mode. In other scenarios, the device enters the low-power mode.

**Parameters:**

<a name="table175513777090252"></a>
<table><thead align="left"><tr id="row236207591090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1023617932090252"><a name="p1023617932090252"></a><a name="p1023617932090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1265813168090252"><a name="p1265813168090252"></a><a name="p1265813168090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1740657365090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">enable</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Specifies whether to check the UART busy status. The value <strong id="b1772650727090252"><a name="b1772650727090252"></a><a name="b1772650727090252"></a>1</strong> means to check the UART busy status, and <strong id="b1523780653090252"><a name="b1523780653090252"></a><a name="b1523780653090252"></a>0</strong> means not to check the busy status. </td>
</tr>
</tbody>
</table>

## AtInit\(\)<a name="gaa72b05261c0b633751d7bd4e10db4870"></a>

```
unsigned int AtInit (void )
```

 **Description:**

Initializes an AT command task. 

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## AtPrintf\(\)<a name="gad03e3a92ab85a6ee0660df82272be5e9"></a>

```
int AtPrintf (const char * fmt,  ... )
```

 **Description:**

Formats data and outputs it to the AT command terminal. 

**Parameters:**

<a name="table1455871371090252"></a>
<table><thead align="left"><tr id="row1579401989090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p423845625090252"><a name="p423845625090252"></a><a name="p423845625090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p388533495090252"><a name="p388533495090252"></a><a name="p388533495090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row179139258090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fmt</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the control character string to format. </td>
</tr>
<tr id="row2058349320090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">...</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Represents a variable parameter list in the character string format. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of bytes \(excluding the end character\) output to the AT command terminal if the operation is successful; returns  **-1**  otherwise. 



## AtRegisterCmd\(\)<a name="ga2967ccc90396327f31df7365f3bb8501"></a>

```
unsigned int AtRegisterCmd (const [AtCmdTbl](atcmdtbl.md) * cmdTbl, unsigned short cmdNum )
```

 **Description:**

Registers a certain number of AT commands. 

**Parameters:**

<a name="table368879236090252"></a>
<table><thead align="left"><tr id="row297377165090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1257328108090252"><a name="p1257328108090252"></a><a name="p1257328108090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1828696127090252"><a name="p1828696127090252"></a><a name="p1828696127090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row876415653090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">cmdTbl</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the command table. </td>
</tr>
<tr id="row631685683090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">cmdNum</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of AT commands in the command table. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## AtSysCmdRegister\(\)<a name="ga73b1bb803919e709a2a9a4a21530cf7b"></a>

```
void AtSysCmdRegister (void )
```

 **Description:**

Registers a system AT command. 

For example, you can use this function to register the AT+RST command, which is a system AT command used to reset a device.

## FlashDeinit\(\)<a name="ga5241dc71f2e9fd54acb65ef52575740a"></a>

```
unsigned int FlashDeinit (void )
```

 **Description:**

Deinitializes the flash device. 

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## FlashErase\(\)<a name="ga4f8879ba35704afb014eab657f2a6b29"></a>

```
unsigned int FlashErase (const unsigned int flashOffset, const unsigned int size )
```

 **Description:**

Erases data in a specified flash memory address. 

**Parameters:**

<a name="table325781614090252"></a>
<table><thead align="left"><tr id="row24345461090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p422022592090252"><a name="p422022592090252"></a><a name="p422022592090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2024886903090252"><a name="p2024886903090252"></a><a name="p2024886903090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1419842917090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">flashOffset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the address of the flash memory data to erase. </td>
</tr>
<tr id="row486408841090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the data to erase, in bytes. The value must be a multiple of 4000 bytes. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## FlashInit\(\)<a name="ga1cf4ab1534ea2b52787838b59dd752cb"></a>

```
unsigned int FlashInit (void )
```

 **Description:**

Initializes the flash device. 

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## FlashIoctl\(\)<a name="ga74ae7c7cbfa0dd54840fe23f2a535786"></a>

```
unsigned int FlashIoctl (unsigned short cmd, char * data )
```

 **Description:**

Obtains flash information based on a specific command. 

**Parameters:**

<a name="table1087921382090252"></a>
<table><thead align="left"><tr id="row1899670116090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1214950661090252"><a name="p1214950661090252"></a><a name="p1214950661090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1832027515090252"><a name="p1832027515090252"></a><a name="p1832027515090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row993328076090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">cmd</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the command ID. The value <strong id="b463719841090252"><a name="b463719841090252"></a><a name="b463719841090252"></a>0</strong> indicates an attempt to obtain flash partition information, and <strong id="b915067154090252"><a name="b915067154090252"></a><a name="b915067154090252"></a>1</strong> indicates an attempt to obtain the flash busy status. </td>
</tr>
<tr id="row14825935090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">data</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the memory where the obtained information will be saved. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the flash information is obtained; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## FlashPartitionInit\(\)<a name="ga89c372b7c3071619dfe5b05d3e779e9e"></a>

```
unsigned int FlashPartitionInit (void )
```

 **Description:**

Initializes a flash partition. 

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## FlashRead\(\)<a name="ga710155ea010eab98ef503abc7b0d7d2c"></a>

```
unsigned int FlashRead (const unsigned int flashOffset, const unsigned int size, unsigned char * ramData )
```

 **Description:**

Reads data from a flash memory address. 

This function reads a specified length of data from a specified flash memory address.

**Parameters:**

<a name="table1711409120090252"></a>
<table><thead align="left"><tr id="row366452860090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p95530264090252"><a name="p95530264090252"></a><a name="p95530264090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p736619667090252"><a name="p736619667090252"></a><a name="p736619667090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1868031738090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">flashOffset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the address of the flash memory from which data is to read. </td>
</tr>
<tr id="row192692570090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the data to read. </td>
</tr>
<tr id="row538056751090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ramData</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the RAM for storing the read data. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## FlashWrite\(\)<a name="gaf565413854f5b2581aa93a5e6143b04a"></a>

```
unsigned int FlashWrite (const unsigned int flashOffset, unsigned int size, const unsigned char * ramData, unsigned char doErase )
```

 **Description:**

Writes data to a flash memory address. 

This function writes a specified length of data to a specified flash memory address.

**Parameters:**

<a name="table1226486035090252"></a>
<table><thead align="left"><tr id="row147019202090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p458257062090252"><a name="p458257062090252"></a><a name="p458257062090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p680478973090252"><a name="p680478973090252"></a><a name="p680478973090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1536961327090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">flashOffset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the address of the flash memory to which data is to write. </td>
</tr>
<tr id="row1142155748090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">size</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the data to write. </td>
</tr>
<tr id="row285322703090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">ramData</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the RAM for storing the data to write. </td>
</tr>
<tr id="row1863219490090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">doErase</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates whether to automatically erase and overwrite the data. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## GetPartitionTable\(\)<a name="ga1279111f8892710f1a84bb03fd8df2be"></a>

```
[WifiIotFlashPartitionTable](wifiiotflashpartitiontable.md)* GetPartitionTable (void )
```

 **Description:**

Obtains a flash partition table. 

**Returns:**

Returns the pointer to the partition table. 



## GpioDeinit\(\)<a name="ga2f829dbe36b81f093f43f59e3fa36212"></a>

```
unsigned int GpioDeinit (void )
```

 **Description:**

Deinitializes the GPIO device. 

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## GpioGetDir\(\)<a name="gafdd6f6a174bd31c3805a23dc923d8114"></a>

```
unsigned int GpioGetDir ([WifiIotGpioIdx](wifiiot.md#gacb21f234cf149161f1f95f3330eeb8e7) id, [WifiIotGpioDir](wifiiot.md#gab4b1fb50c758d491ba297a65e1c7a70a) * dir )
```

 **Description:**

Obtains the direction for a GPIO pin. 

**Parameters:**

<a name="table824254664090252"></a>
<table><thead align="left"><tr id="row2071087194090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p701808500090252"><a name="p701808500090252"></a><a name="p701808500090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1581637530090252"><a name="p1581637530090252"></a><a name="p1581637530090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1993974540090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the GPIO pin ID. </td>
</tr>
<tr id="row1703776739090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dir</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the GPIO input/output direction. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## GpioGetInputVal\(\)<a name="gad63e45fa986b5dbcf3fb94f4fe7c3ee6"></a>

```
unsigned int GpioGetInputVal ([WifiIotGpioIdx](wifiiot.md#gacb21f234cf149161f1f95f3330eeb8e7) id, [WifiIotGpioValue](wifiiot.md#gac9095d1db72e5046b2ec1895aaec0e6b) * val )
```

 **Description:**

Obtains the input level value of a GPIO pin. 

**Parameters:**

<a name="table1252825171090252"></a>
<table><thead align="left"><tr id="row1671266808090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p887754755090252"><a name="p887754755090252"></a><a name="p887754755090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p507539374090252"><a name="p507539374090252"></a><a name="p507539374090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row461733442090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the GPIO pin ID. </td>
</tr>
<tr id="row1067302791090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">val</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the input level value. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## GpioGetOutputVal\(\)<a name="gadea7c9475f510d00baa054364fd8de9a"></a>

```
unsigned int GpioGetOutputVal ([WifiIotGpioIdx](wifiiot.md#gacb21f234cf149161f1f95f3330eeb8e7) id, [WifiIotGpioValue](wifiiot.md#gac9095d1db72e5046b2ec1895aaec0e6b) * val )
```

 **Description:**

Obtains the output level value of a GPIO pin. 

**Parameters:**

<a name="table1825568811090252"></a>
<table><thead align="left"><tr id="row1893928382090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1563012925090252"><a name="p1563012925090252"></a><a name="p1563012925090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1594788890090252"><a name="p1594788890090252"></a><a name="p1594788890090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row337055189090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the GPIO pin ID. </td>
</tr>
<tr id="row676170054090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">val</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the output level value. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## GpioInit\(\)<a name="ga7a0c4f45b99870ae828a0d3f71561421"></a>

```
unsigned int GpioInit (void )
```

 **Description:**

Initializes the GPIO device. 

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## GpioRegisterIsrFunc\(\)<a name="ga2eaec33b87a24bf1ae6b2a8d7ec38674"></a>

```
unsigned int GpioRegisterIsrFunc ([WifiIotGpioIdx](wifiiot.md#gacb21f234cf149161f1f95f3330eeb8e7) id, [WifiIotGpioIntType](wifiiot.md#gac8eb8ad448903ed52c96ccc675e81f94) intType, [WifiIotGpioIntPolarity](wifiiot.md#gab81589838cedcc3933bb789c97ad3643) intPolarity, [GpioIsrCallbackFunc](wifiiot.md#ga93120443d8150e18701ce6d3dd290408) func, char * arg )
```

 **Description:**

Enables the interrupt function for a GPIO pin. 

This function can be used to set the interrupt type, interrupt polarity, and interrupt callback for a GPIO pin.

**Parameters:**

<a name="table2093819181090252"></a>
<table><thead align="left"><tr id="row354728373090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1079455409090252"><a name="p1079455409090252"></a><a name="p1079455409090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p29104966090252"><a name="p29104966090252"></a><a name="p29104966090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row118787259090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the GPIO pin ID. </td>
</tr>
<tr id="row1504177247090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">intType</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the interrupt type. </td>
</tr>
<tr id="row1983268439090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">intPolarity</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the interrupt polarity. </td>
</tr>
<tr id="row1006507890090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">func</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the interrupt callback function. </td>
</tr>
<tr id="row1313745738090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">arg</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the argument used in the interrupt callback function. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## GpioSetDir\(\)<a name="gabe3de0ab249704929ec95c82815e02b7"></a>

```
unsigned int GpioSetDir ([WifiIotGpioIdx](wifiiot.md#gacb21f234cf149161f1f95f3330eeb8e7) id, [WifiIotGpioDir](wifiiot.md#gab4b1fb50c758d491ba297a65e1c7a70a) dir )
```

 **Description:**

Sets the direction for a GPIO pin. 

**Parameters:**

<a name="table1888987422090252"></a>
<table><thead align="left"><tr id="row2043456291090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1274804809090252"><a name="p1274804809090252"></a><a name="p1274804809090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p687711314090252"><a name="p687711314090252"></a><a name="p687711314090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1762367479090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the GPIO pin ID. </td>
</tr>
<tr id="row1367778716090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dir</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the GPIO input/output direction. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## GpioSetIsrMask\(\)<a name="ga3d2e70a9ffded1937e7423cf59e0f40f"></a>

```
unsigned int GpioSetIsrMask ([WifiIotGpioIdx](wifiiot.md#gacb21f234cf149161f1f95f3330eeb8e7) id, unsigned char mask )
```

 **Description:**

Masks the interrupt function for a GPIO pin. 

**Parameters:**

<a name="table937638080090252"></a>
<table><thead align="left"><tr id="row336731034090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1495345511090252"><a name="p1495345511090252"></a><a name="p1495345511090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2120527728090252"><a name="p2120527728090252"></a><a name="p2120527728090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2061675633090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the GPIO pin ID. </td>
</tr>
<tr id="row1555166392090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">mask</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates whether the interrupt function is masked. The value <strong id="b2079343620090252"><a name="b2079343620090252"></a><a name="b2079343620090252"></a>1</strong> means to mask the interrupt function, and <strong id="b55984734090252"><a name="b55984734090252"></a><a name="b55984734090252"></a>0</strong> means not to mask the interrupt function. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## GpioSetIsrMode\(\)<a name="ga400c1978a35742c101881aa825749152"></a>

```
unsigned int GpioSetIsrMode ([WifiIotGpioIdx](wifiiot.md#gacb21f234cf149161f1f95f3330eeb8e7) id, [WifiIotGpioIntType](wifiiot.md#gac8eb8ad448903ed52c96ccc675e81f94) intType, [WifiIotGpioIntPolarity](wifiiot.md#gab81589838cedcc3933bb789c97ad3643) intPolarity )
```

 **Description:**

Sets the interrupt trigger mode of a GPIO pin. 

This function configures a GPIO pin based on the interrupt type and interrupt polarity.

**Parameters:**

<a name="table974926663090252"></a>
<table><thead align="left"><tr id="row281344206090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p272746821090252"><a name="p272746821090252"></a><a name="p272746821090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1476487967090252"><a name="p1476487967090252"></a><a name="p1476487967090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1570978801090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the GPIO pin ID. </td>
</tr>
<tr id="row617026063090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">intType</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the interrupt type. </td>
</tr>
<tr id="row851458851090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">intPolarity</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the interrupt polarity. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## GpioSetOutputVal\(\)<a name="ga13718f6a5c52a272baca64167b67606f"></a>

```
unsigned int GpioSetOutputVal ([WifiIotGpioIdx](wifiiot.md#gacb21f234cf149161f1f95f3330eeb8e7) id, [WifiIotGpioValue](wifiiot.md#gac9095d1db72e5046b2ec1895aaec0e6b) val )
```

 **Description:**

Sets the output level value for a GPIO pin. 

**Parameters:**

<a name="table998923740090252"></a>
<table><thead align="left"><tr id="row533028044090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p620625603090252"><a name="p620625603090252"></a><a name="p620625603090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1701903373090252"><a name="p1701903373090252"></a><a name="p1701903373090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row722237943090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the GPIO pin ID. </td>
</tr>
<tr id="row1566111849090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">val</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the output level value. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## GpioUnregisterIsrFunc\(\)<a name="ga403b7bb8037ae1415d5d0dd623379e50"></a>

```
unsigned int GpioUnregisterIsrFunc ([WifiIotGpioIdx](wifiiot.md#gacb21f234cf149161f1f95f3330eeb8e7) id)
```

 **Description:**

Disables the interrupt function for a GPIO pin. 

**Parameters:**

<a name="table2049015957090252"></a>
<table><thead align="left"><tr id="row1780524104090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p94773112090252"><a name="p94773112090252"></a><a name="p94773112090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p504675430090252"><a name="p504675430090252"></a><a name="p504675430090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row725628327090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the GPIO pin ID. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## I2cDeinit\(\)<a name="gaaa7f69e289e203f40bff4289bc8e332f"></a>

```
unsigned int I2cDeinit ([WifiIotI2cIdx](wifiiot.md#gaeeb58e02e3783d02e1ed4bad313cc0b8) id)
```

 **Description:**

Deinitializes an I2C device. 

**Parameters:**

<a name="table1560550724090252"></a>
<table><thead align="left"><tr id="row847301899090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1201446945090252"><a name="p1201446945090252"></a><a name="p1201446945090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p611452220090252"><a name="p611452220090252"></a><a name="p611452220090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1360172632090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the I2C device ID. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## I2cInit\(\)<a name="ga01f5b9b16ad378ad1ad5d3ee37d0c4c0"></a>

```
unsigned int I2cInit ([WifiIotI2cIdx](wifiiot.md#gaeeb58e02e3783d02e1ed4bad313cc0b8) id, unsigned int baudrate )
```

 **Description:**

Initializes an I2C device with a specified baud rate. 

**Parameters:**

<a name="table1157335677090252"></a>
<table><thead align="left"><tr id="row1318782054090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1465672855090252"><a name="p1465672855090252"></a><a name="p1465672855090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p116965215090252"><a name="p116965215090252"></a><a name="p116965215090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1354352774090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the I2C device ID. </td>
</tr>
<tr id="row230149452090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">baudrate</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the I2C baud rate. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## I2cRead\(\)<a name="gac058f6ee969c5873280c11220d04f026"></a>

```
unsigned int I2cRead ([WifiIotI2cIdx](wifiiot.md#gaeeb58e02e3783d02e1ed4bad313cc0b8) id, unsigned short deviceAddr, const [WifiIotI2cData](wifiioti2cdata.md) * i2cData )
```

 **Description:**

Reads data from an I2C device. 

The data read will be saved to the address specified by  **i2cData**.

**Parameters:**

<a name="table1139469587090252"></a>
<table><thead align="left"><tr id="row1375295646090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p252590131090252"><a name="p252590131090252"></a><a name="p252590131090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p730403694090252"><a name="p730403694090252"></a><a name="p730403694090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2058386830090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the I2C device ID. </td>
</tr>
<tr id="row1741696797090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">deviceAddr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the I2C device address. </td>
</tr>
<tr id="row1941897785090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">i2cData</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the data descriptor to read. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## I2cRegisterResetBusFunc\(\)<a name="ga76d3fad576fe209eedb203bc61ad4f6b"></a>

```
void I2cRegisterResetBusFunc ([WifiIotI2cIdx](wifiiot.md#gaeeb58e02e3783d02e1ed4bad313cc0b8) id, [WifiIotI2cFunc](wifiioti2cfunc.md) pfn )
```

 **Description:**

Registers an I2C callback. 

**Parameters:**

<a name="table168917693090252"></a>
<table><thead align="left"><tr id="row1099944052090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p923307171090252"><a name="p923307171090252"></a><a name="p923307171090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p342494284090252"><a name="p342494284090252"></a><a name="p342494284090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1125206949090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the I2C device ID. </td>
</tr>
<tr id="row1238983517090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pfn</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the type of the callback to register.</td>
</tr>
</tbody>
</table>

## I2cSetBaudrate\(\)<a name="gaf4962dc9dd012c125294fe5683955454"></a>

```
unsigned int I2cSetBaudrate ([WifiIotI2cIdx](wifiiot.md#gaeeb58e02e3783d02e1ed4bad313cc0b8) id, unsigned int baudrate )
```

 **Description:**

Sets the baud rate for an I2C device. 

**Parameters:**

<a name="table1503634729090252"></a>
<table><thead align="left"><tr id="row696286880090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p242646053090252"><a name="p242646053090252"></a><a name="p242646053090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1565474996090252"><a name="p1565474996090252"></a><a name="p1565474996090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row839156672090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the I2C device ID. </td>
</tr>
<tr id="row843176356090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">baudrate</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the I2C baud rate to set. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## I2cWrite\(\)<a name="ga0c72d160332184ddddc264411e00fcc9"></a>

```
unsigned int I2cWrite ([WifiIotI2cIdx](wifiiot.md#gaeeb58e02e3783d02e1ed4bad313cc0b8) id, unsigned short deviceAddr, const [WifiIotI2cData](wifiioti2cdata.md) * i2cData )
```

 **Description:**

Writes data to an I2C device. 

**Parameters:**

<a name="table1464822989090252"></a>
<table><thead align="left"><tr id="row1470101578090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p498169886090252"><a name="p498169886090252"></a><a name="p498169886090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p684952820090252"><a name="p684952820090252"></a><a name="p684952820090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row966079005090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the I2C device ID. </td>
</tr>
<tr id="row871457248090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">deviceAddr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the I2C device address. </td>
</tr>
<tr id="row1479434395090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">i2cData</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the data descriptor to write. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## I2cWriteread\(\)<a name="gae4c60ea6732bbee9f779540cb431fe85"></a>

```
unsigned int I2cWriteread ([WifiIotI2cIdx](wifiiot.md#gaeeb58e02e3783d02e1ed4bad313cc0b8) id, unsigned short deviceAddr, const [WifiIotI2cData](wifiioti2cdata.md) * i2cData )
```

 **Description:**

Sends data to and receives data responses from an I2C device. 

**Parameters:**

<a name="table450947750090252"></a>
<table><thead align="left"><tr id="row2092786948090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2141085432090252"><a name="p2141085432090252"></a><a name="p2141085432090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p340057960090252"><a name="p340057960090252"></a><a name="p340057960090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row405384736090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the I2C device ID. </td>
</tr>
<tr id="row1555333886090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">deviceAddr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the I2C device address. </td>
</tr>
<tr id="row673591460090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">i2cData</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the device descriptor of the data to receive. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## I2sDeinit\(\)<a name="ga2f47b7e0c350d305cb0b495bda78450c"></a>

```
unsigned int I2sDeinit (void )
```

 **Description:**

Deinitializes the I2S device. 

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## I2sInit\(\)<a name="gaab1affd53de2567a6eb3803649d1c706"></a>

```
unsigned int I2sInit (const [WifiIotI2sAttribute](wifiioti2sattribute.md) * i2sAttribute)
```

 **Description:**

Initializes the I2S device. 

**Parameters:**

<a name="table1113037040090252"></a>
<table><thead align="left"><tr id="row78451979090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1583361943090252"><a name="p1583361943090252"></a><a name="p1583361943090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p979876341090252"><a name="p979876341090252"></a><a name="p979876341090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1127818747090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">i2sAttribute</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the I2S configuration parameter. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## I2sRead\(\)<a name="ga8d2e8cc248252007325cace65bedb742"></a>

```
unsigned int I2sRead (unsigned char * rdData, unsigned int rdLen, unsigned int timeOutMs )
```

 **Description:**

Reads data from the I2S device. 

This function reads data with the length specified by  **rdLen**  from an I2S device within the duration specified by  **timeOutMs**.

**Parameters:**

<a name="table703459677090252"></a>
<table><thead align="left"><tr id="row535641417090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1167918103090252"><a name="p1167918103090252"></a><a name="p1167918103090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1998169909090252"><a name="p1998169909090252"></a><a name="p1998169909090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row661720254090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">rdData</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the data to read. </td>
</tr>
<tr id="row1665599025090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">rdLen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the data to read. </td>
</tr>
<tr id="row1712845073090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">timeOutMs</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the timeout interval. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## I2sWrite\(\)<a name="gad30ea8ed658514b8864ab8ddba4fd4f0"></a>

```
unsigned int I2sWrite (unsigned char * wrData, unsigned int wrLen, unsigned int timeOutMs )
```

 **Description:**

Writes data to the I2S device. 

This function writes data with the length specified by  **wrLen**  to an I2S device within the duration specified by  **timeOutMs**.

**Parameters:**

<a name="table1969603429090252"></a>
<table><thead align="left"><tr id="row1329290562090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p948768942090252"><a name="p948768942090252"></a><a name="p948768942090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1069046796090252"><a name="p1069046796090252"></a><a name="p1069046796090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1579200907090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wrData</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the data to write. </td>
</tr>
<tr id="row1219587760090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">wrLen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the data to write. </td>
</tr>
<tr id="row1455789044090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">timeOutMs</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the timeout interval. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## IOGetDriverStrength\(\)<a name="ga64e637417c653b431c67cf4445fc8e65"></a>

```
unsigned int IOGetDriverStrength ([WifiIotIoName](wifiiot.md#ga2f42c70f1dd8a04746e30a97b3dfc415) id, [WifiIotIoDriverStrength](wifiiot.md#gae97ab4109f511ceeee889dba9e79a968) * val )
```

 **Description:**

Obtains the driver strength of a GPIO pin. 

**Parameters:**

<a name="table1452431217090252"></a>
<table><thead align="left"><tr id="row730293584090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p659030135090252"><a name="p659030135090252"></a><a name="p659030135090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p320835449090252"><a name="p320835449090252"></a><a name="p320835449090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row245984747090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the GPIO pin. </td>
</tr>
<tr id="row2061843492090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">val</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the address where the I/O driver strength level is to be stored. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## IoGetFunc\(\)<a name="ga4131898393c55a07abf254dc7f2a9541"></a>

```
unsigned int IoGetFunc ([WifiIotIoName](wifiiot.md#ga2f42c70f1dd8a04746e30a97b3dfc415) id, unsigned char * val )
```

 **Description:**

Obtains the multiplexing function for a GPIO pin. 

**Parameters:**

<a name="table288344444090252"></a>
<table><thead align="left"><tr id="row1341475050090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1330162880090252"><a name="p1330162880090252"></a><a name="p1330162880090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p166863139090252"><a name="p166863139090252"></a><a name="p166863139090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1529111142090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the GPIO pin. </td>
</tr>
<tr id="row1846519679090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">val</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the address whether I/O multiplexing function is to be stored. For example, if the value of <strong id="b2132859486090252"><a name="b2132859486090252"></a><a name="b2132859486090252"></a>id</strong> is <a href="wifiiot.md#gga2f42c70f1dd8a04746e30a97b3dfc415a97963c85f73b7efc5df2b4e791518dd6">WIFI_IOT_IO_NAME_GPIO_0</a>, the value type of <strong id="b1197841380090252"><a name="b1197841380090252"></a><a name="b1197841380090252"></a>val</strong> is <a href="wifiiot.md#ga2b08eb2a302e2c4fa216a1373bea4a01">WifiIotIoFuncGpio0</a>. If the value of <strong id="b1558059256090252"><a name="b1558059256090252"></a><a name="b1558059256090252"></a>id</strong> is <a href="wifiiot.md#gga2f42c70f1dd8a04746e30a97b3dfc415a5a7f8f802106534ed2fcff69e70d5223">WIFI_IOT_IO_NAME_GPIO_1</a>, the value type of <strong id="b1775302490090252"><a name="b1775302490090252"></a><a name="b1775302490090252"></a>val</strong> is <strong id="b183656133090252"><a name="b183656133090252"></a><a name="b183656133090252"></a>WifiIotIoFuncGpio1</strong>. The same rule applies to other values. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## IoGetPull\(\)<a name="ga899a2d8d5a058bcd9d32dbce43a9dbb2"></a>

```
unsigned int IoGetPull ([WifiIotIoName](wifiiot.md#ga2f42c70f1dd8a04746e30a97b3dfc415) id, [WifiIotIoPull](wifiiot.md#gacc20a5c6456ec381ed931232c29d1c4f) * val )
```

 **Description:**

Obtains the pull type of a GPIO pin. 

**Parameters:**

<a name="table27785996090252"></a>
<table><thead align="left"><tr id="row150199244090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1200035714090252"><a name="p1200035714090252"></a><a name="p1200035714090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p678373994090252"><a name="p678373994090252"></a><a name="p678373994090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row501924566090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the GPIO pin. </td>
</tr>
<tr id="row900392701090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">val</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the address where the pull type is to be stored. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## IOSetDriverStrength\(\)<a name="ga631065a13f9794dc0b4de4870e62cfaa"></a>

```
unsigned int IOSetDriverStrength ([WifiIotIoName](wifiiot.md#ga2f42c70f1dd8a04746e30a97b3dfc415) id, [WifiIotIoDriverStrength](wifiiot.md#gae97ab4109f511ceeee889dba9e79a968) val )
```

 **Description:**

Sets the driver strength of a GPIO pin. 

**Parameters:**

<a name="table1221428929090252"></a>
<table><thead align="left"><tr id="row1660933138090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2010612347090252"><a name="p2010612347090252"></a><a name="p2010612347090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1130898078090252"><a name="p1130898078090252"></a><a name="p1130898078090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row205006011090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the GPIO pin. </td>
</tr>
<tr id="row387128898090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">val</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the I/O driver strength level obtained. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## IoSetFunc\(\)<a name="ga706a98bedbef79002c43efcb98b841ab"></a>

```
unsigned int IoSetFunc ([WifiIotIoName](wifiiot.md#ga2f42c70f1dd8a04746e30a97b3dfc415) id, unsigned char val )
```

 **Description:**

Sets the multiplexing function for a GPIO pin. 

**Parameters:**

<a name="table1520592224090252"></a>
<table><thead align="left"><tr id="row279644016090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2070729644090252"><a name="p2070729644090252"></a><a name="p2070729644090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1923841838090252"><a name="p1923841838090252"></a><a name="p1923841838090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1736157738090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the GPIO pin. </td>
</tr>
<tr id="row1307504282090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">val</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the I/O multiplexing function. For example, if the value of <strong id="b1059054103090252"><a name="b1059054103090252"></a><a name="b1059054103090252"></a>id</strong> is <a href="wifiiot.md#gga2f42c70f1dd8a04746e30a97b3dfc415a97963c85f73b7efc5df2b4e791518dd6">WIFI_IOT_IO_NAME_GPIO_0</a>, the value type of <strong id="b1698177960090252"><a name="b1698177960090252"></a><a name="b1698177960090252"></a>val</strong> is <a href="wifiiot.md#ga2b08eb2a302e2c4fa216a1373bea4a01">WifiIotIoFuncGpio0</a>. If the value of <strong id="b1202403207090252"><a name="b1202403207090252"></a><a name="b1202403207090252"></a>id</strong> is <a href="wifiiot.md#gga2f42c70f1dd8a04746e30a97b3dfc415a5a7f8f802106534ed2fcff69e70d5223">WIFI_IOT_IO_NAME_GPIO_1</a>, the value type of <strong id="b1089390782090252"><a name="b1089390782090252"></a><a name="b1089390782090252"></a>val</strong> is <strong id="b1360498749090252"><a name="b1360498749090252"></a><a name="b1360498749090252"></a>WifiIotIoFuncGpio1</strong>. The same rule applies to other values. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## IoSetPull\(\)<a name="ga372f6e774614f5b4e7280c9e564be5a2"></a>

```
unsigned int IoSetPull ([WifiIotIoName](wifiiot.md#ga2f42c70f1dd8a04746e30a97b3dfc415) id, [WifiIotIoPull](wifiiot.md#gacc20a5c6456ec381ed931232c29d1c4f) val )
```

 **Description:**

Sets the pull for a GPIO pin. 

**Parameters:**

<a name="table1053605463090252"></a>
<table><thead align="left"><tr id="row9798564090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p867192865090252"><a name="p867192865090252"></a><a name="p867192865090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1313055712090252"><a name="p1313055712090252"></a><a name="p1313055712090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1925739335090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the GPIO pin. </td>
</tr>
<tr id="row720799242090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">val</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pull-up or pull-down to set. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## KalThreadRegisterIdleCallback\(\)<a name="ga2cb2a204b7f242f4b387896924883de2"></a>

```
void KalThreadRegisterIdleCallback ([TickIdleKalCallback](wifiiot.md#ga8be54bbf12f538188db10aaaf4bdbdf9) cb)
```

 **Description:**

Registers the idle task callback. 

**Parameters:**

<a name="table944194944090252"></a>
<table><thead align="left"><tr id="row1332406052090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1374267240090252"><a name="p1374267240090252"></a><a name="p1374267240090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1312196657090252"><a name="p1312196657090252"></a><a name="p1312196657090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row376584013090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">cb</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the idle task callback to register. </td>
</tr>
</tbody>
</table>

## KalTickRegisterCallback\(\)<a name="ga08e802255973f1fe58cbe59f03e1e2a8"></a>

```
void KalTickRegisterCallback ([TickIdleKalCallback](wifiiot.md#ga8be54bbf12f538188db10aaaf4bdbdf9) cb)
```

 **Description:**

Registers the CPU tick callback. 

**Parameters:**

<a name="table1558476860090252"></a>
<table><thead align="left"><tr id="row20879875090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p630894164090252"><a name="p630894164090252"></a><a name="p630894164090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p20699179090252"><a name="p20699179090252"></a><a name="p20699179090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1607076199090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">cb</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the CPU tick callback to register. </td>
</tr>
</tbody>
</table>

## PwmDeinit\(\)<a name="gac63da03016596aed4234e9c4053c15b9"></a>

```
unsigned int PwmDeinit ([WifiIotPwmPort](wifiiot.md#gab3518ce878df4a40d614e88a6f81dea7) port)
```

 **Description:**

Deinitializes a PWM device. 

**Parameters:**

<a name="table457783434090252"></a>
<table><thead align="left"><tr id="row2010070656090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1871815687090252"><a name="p1871815687090252"></a><a name="p1871815687090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p189790822090252"><a name="p189790822090252"></a><a name="p189790822090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1341406126090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">port</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the PWM port number. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; eturns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## PwmInit\(\)<a name="ga27d50a2258388ba88ed35581096fb5eb"></a>

```
unsigned int PwmInit ([WifiIotPwmPort](wifiiot.md#gab3518ce878df4a40d614e88a6f81dea7) port)
```

 **Description:**

Initializes a PWM device. 

**Parameters:**

<a name="table1134607736090252"></a>
<table><thead align="left"><tr id="row1300318880090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1764472103090252"><a name="p1764472103090252"></a><a name="p1764472103090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1777727120090252"><a name="p1777727120090252"></a><a name="p1777727120090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row109114914090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">port</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the PWM port number. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## PwmStart\(\)<a name="gae853022c27750fcdb9a2c60653761afe"></a>

```
unsigned int PwmStart ([WifiIotPwmPort](wifiiot.md#gab3518ce878df4a40d614e88a6f81dea7) port, unsigned short duty, unsigned short freq )
```

 **Description:**

Outputs PWM signals based on the input parameters. 

This function outputs PWM signals from a specified port based on the configured frequency division multiple and duty cycle.

**Parameters:**

<a name="table1916363702090252"></a>
<table><thead align="left"><tr id="row1974291650090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p687361440090252"><a name="p687361440090252"></a><a name="p687361440090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p993944251090252"><a name="p993944251090252"></a><a name="p993944251090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1790635535090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">port</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the PWM port number. </td>
</tr>
<tr id="row2010251597090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">duty</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the PWM duty cycle. </td>
</tr>
<tr id="row1970562963090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">freq</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the frequency-division multiple. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## PwmStop\(\)<a name="ga158474c4e73c1e557352c12cc31a154f"></a>

```
unsigned int PwmStop ([WifiIotPwmPort](wifiiot.md#gab3518ce878df4a40d614e88a6f81dea7) port)
```

 **Description:**

Stops the PWM signal output. 

**Parameters:**

<a name="table1743212945090252"></a>
<table><thead align="left"><tr id="row505518779090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p764280922090252"><a name="p764280922090252"></a><a name="p764280922090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p573388762090252"><a name="p573388762090252"></a><a name="p573388762090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1476717469090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">port</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the PWM port number. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## SdioCompleteSend\(\)<a name="ga2615d7d406366292f8b2fd445d841971"></a>

```
unsigned int SdioCompleteSend (unsigned char * admaTable, unsigned int admaIndex )
```

 **Description:**

Completes data sending on the SDIO device. 

After data sending is complete, the SDIO device sets a complete flag for the ADMA ID  **admaIndex**  to indicate that the ADMA data between channel 0 and the complete flag is set.

**Parameters:**

<a name="table1971001307090252"></a>
<table><thead align="left"><tr id="row215019763090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p843292051090252"><a name="p843292051090252"></a><a name="p843292051090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p428067441090252"><a name="p428067441090252"></a><a name="p428067441090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1571176075090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">admaTable</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the start address of the ADMA table. Each ADMA table occupies 8 bytes. </td>
</tr>
<tr id="row1957725478090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">admaIndex</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the ADMA ID, ranging from 0 to 130. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## SdioGetExtendInfo\(\)<a name="gac4b082298d466441c68e0e916f92dc03"></a>

```
[WifiIotSdioExtendFunc](wifiiotsdioextendfunc.md)* SdioGetExtendInfo (void )
```

 **Description:**

Obtains the extended configuration. 

**Returns:**

Returns the pointer to the address of the extended configuration. 



## SdioInit\(\)<a name="gaad3bec1e62fb695ed4b8f0627b3f4e84"></a>

```
unsigned int SdioInit (void )
```

 **Description:**

Initializes the SDIO device. 

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## SdioIsPendingMsg\(\)<a name="gafc188bce50a808f7ebd6641d01725602"></a>

```
unsigned int SdioIsPendingMsg (unsigned int msg)
```

 **Description:**

Checks whether a specified message is suspended. 

**Parameters:**

<a name="table354377727090252"></a>
<table><thead align="left"><tr id="row475688217090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2083215447090252"><a name="p2083215447090252"></a><a name="p2083215447090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p494113200090252"><a name="p494113200090252"></a><a name="p494113200090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row418756250090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">msg</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the ID of the message to check, ranging from 0 to 31. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **1**  if the message is suspended; returns  **0**  otherwise. 



## SdioIsSendingMsg\(\)<a name="ga5ee18bbecf0f451068e943f44ada8b9c"></a>

```
unsigned int SdioIsSendingMsg (unsigned int msg)
```

 **Description:**

Checks whether a specified message is being sent. 

**Parameters:**

<a name="table459241333090252"></a>
<table><thead align="left"><tr id="row718011579090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1686974056090252"><a name="p1686974056090252"></a><a name="p1686974056090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p14969935090252"><a name="p14969935090252"></a><a name="p14969935090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row538268330090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">msg</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the ID of the message to check, ranging from 0 to 31. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **1**  if the message is being sent; returns  **0**  otherwise. 



## SdioProcessMsg\(\)<a name="ga1e8370bf332882774ca34d6a9b4164b8"></a>

```
unsigned int SdioProcessMsg (unsigned int sendMsg, unsigned int clearMsg )
```

 **Description:**

Clears a specified suspended message in the message queue, adds a new message to it, and sends the new message. 

**Parameters:**

<a name="table910357890090252"></a>
<table><thead align="left"><tr id="row1334439024090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1534103181090252"><a name="p1534103181090252"></a><a name="p1534103181090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1845305925090252"><a name="p1845305925090252"></a><a name="p1845305925090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1722813001090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">sendMsg</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the ID of the message to send, ranging from 0 to 31. </td>
</tr>
<tr id="row1167454535090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">clearMsg</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the ID of the message to clear, ranging from 0 to 31. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **1**  if the operation is successful; returns  **0**  otherwise. 



## SdioRegisterCallback\(\)<a name="ga8d8b7169c2668a0be5f3870e12d41071"></a>

```
unsigned int SdioRegisterCallback (const [WifiIotSdioIntcallback](wifiiotsdiointcallback.md) * callbackFunc)
```

 **Description:**

Registers an interrupt callback for the SDIO device. 

**Parameters:**

<a name="table316524552090252"></a>
<table><thead align="left"><tr id="row1750771504090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1957573327090252"><a name="p1957573327090252"></a><a name="p1957573327090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1068140233090252"><a name="p1068140233090252"></a><a name="p1068140233090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1965461532090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">callbackFunc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the interrupt callback to register. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## SdioRegisterNotifyMessageCallback\(\)<a name="gae8925d25b4fc160d0fa9760c28c87e84"></a>

```
void SdioRegisterNotifyMessageCallback ([NotifyHostMessageEvent](wifiiot.md#ga133bb67c0fa6e9dcab35f00edff68e58) msgEventCallback)
```

 **Description:**

Registers the callback that will be invoked when the host sends a message or data. 

**Parameters:**

<a name="table1904872038090252"></a>
<table><thead align="left"><tr id="row1912318138090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p92324532090252"><a name="p92324532090252"></a><a name="p92324532090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p45314362090252"><a name="p45314362090252"></a><a name="p45314362090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1006224247090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">msgEventCallback</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the callback to be invoked when a message or data is sent. </td>
</tr>
</tbody>
</table>

## SdioReinit\(\)<a name="ga7093b6e5941cedd1d3fa706500fb3c66"></a>

```
unsigned int SdioReinit (void )
```

 **Description:**

Reinitializes the SDIO device. 

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## SdioSchedMsg\(\)<a name="ga6ce36235d20976c2f4668798de3fd0fb"></a>

```
unsigned int SdioSchedMsg (void )
```

 **Description:**

Sends a suspended SDIO message. 

**Returns:**

Returns  **1**  if no message is suspended or the suspended message is successfully sent; returns  **0**  if the SDIO device is not working or is sending messages. 



## SdioSendData\(\)<a name="ga5a38e3c0f2848972cbe736980ea6e355"></a>

```
void SdioSendData (unsigned int xferBytes)
```

 **Description:**

Starts to send data. 

Data with the length specified by  **xferBytes**  is ready for transmission.

**Parameters:**

<a name="table1178782040090252"></a>
<table><thead align="left"><tr id="row1812085746090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p655035631090252"><a name="p655035631090252"></a><a name="p655035631090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1829900342090252"><a name="p1829900342090252"></a><a name="p1829900342090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1823744323090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">xferBytes</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the data to send. </td>
</tr>
</tbody>
</table>

## SdioSendMsgAck\(\)<a name="gae8c8a1b4725d9f291fbf17e2760e5bb9"></a>

```
unsigned int SdioSendMsgAck (unsigned int msg)
```

 **Description:**

Sends a specified message. 

**Parameters:**

<a name="table2063443859090252"></a>
<table><thead align="left"><tr id="row618261437090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p961033794090252"><a name="p961033794090252"></a><a name="p961033794090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1308522574090252"><a name="p1308522574090252"></a><a name="p1308522574090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row578934743090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">msg</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the ID of the message to send, ranging from 0 to 31. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **1**  if the operation is successful; returns  **0**  otherwise. 



## SdioSendSyncMsg\(\)<a name="ga475a381fc4b9357aee48386bd1825d28"></a>

```
unsigned int SdioSendSyncMsg (unsigned int msg)
```

 **Description:**

Adds a message to a message queue and sends the message. 

**Parameters:**

<a name="table784511553090252"></a>
<table><thead align="left"><tr id="row1406988937090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1470285024090252"><a name="p1470285024090252"></a><a name="p1470285024090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p536020999090252"><a name="p536020999090252"></a><a name="p536020999090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row224634634090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">msg</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the ID of the message to add to the message queue and send, ranging from 0 to 31. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **1**  if the operation is successful; returns  **0**  otherwise. 



## SdioSetAdmatable\(\)<a name="gadbd7176d96c0a92bc8dd3186d5e56044"></a>

```
unsigned int SdioSetAdmatable (unsigned char * admatable, unsigned int admaIndex, const unsigned int * dataAddr, unsigned int dataLen )
```

 **Description:**

Sets an SDIO ADMA. 

This function places a specified length of data into the ADMA with a specified ADMA ID  **admaIndex**.

**Parameters:**

<a name="table571721886090252"></a>
<table><thead align="left"><tr id="row1641804522090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p990297989090252"><a name="p990297989090252"></a><a name="p990297989090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1816495643090252"><a name="p1816495643090252"></a><a name="p1816495643090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1260532840090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">admatable</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the start address of the ADMA table. Each ADMA table occupies 8 bytes. </td>
</tr>
<tr id="row1281021189090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">admaIndex</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the ADMA ID, ranging from 0 to 130. </td>
</tr>
<tr id="row1811046086090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dataAddr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the address where data is to send. </td>
</tr>
<tr id="row1523658065090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dataLen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the data to send. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## SdioSetPadAdmatab\(\)<a name="ga257b72a879ec478d9434d2a2a2a69281"></a>

```
unsigned int SdioSetPadAdmatab (unsigned int padlen, unsigned char * admatable, unsigned int admaIndex )
```

 **Description:**

Sets the ADMA table that requires data padding. 

**Parameters:**

<a name="table785174607090252"></a>
<table><thead align="left"><tr id="row822521533090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1589111106090252"><a name="p1589111106090252"></a><a name="p1589111106090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p953832135090252"><a name="p953832135090252"></a><a name="p953832135090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1682187887090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">padlen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the data to pad. </td>
</tr>
<tr id="row894784573090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">admatable</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the start address of the ADMA table. Each ADMA table occupies 8 bytes. </td>
</tr>
<tr id="row34449575090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">admaIndex</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the ADMA ID, ranging from 0 to 130. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## SdioSetPowerdownWhenDeepSleep\(\)<a name="gaa507e3ae762f43b644c716aa5385172a"></a>

```
void SdioSetPowerdownWhenDeepSleep (unsigned char powerDown)
```

 **Description:**

Sets whether the SDIO device is powered off in deep sleep mode. 

**Parameters:**

<a name="table750001098090252"></a>
<table><thead align="left"><tr id="row1434939465090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p920784530090252"><a name="p920784530090252"></a><a name="p920784530090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1468845842090252"><a name="p1468845842090252"></a><a name="p1468845842090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1188492783090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">powerDown</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Specifies whether to power off the SDIO device. The value <strong id="b1164749120090252"><a name="b1164749120090252"></a><a name="b1164749120090252"></a>1</strong> means to power it off, and <strong id="b709921217090252"><a name="b709921217090252"></a><a name="b709921217090252"></a>0</strong> means not to power it off. </td>
</tr>
</tbody>
</table>

## SdioSoftReset\(\)<a name="ga180aae06228682aee1e7ac335498c94f"></a>

```
void SdioSoftReset (void )
```

 **Description:**

Resets the SDIO device. 

## SdioWriteExtinfo\(\)<a name="ga79d11f1582ccd79d55e28c4a3c3896ad"></a>

```
unsigned int SdioWriteExtinfo ([WifiIotSdioExtendFunc](wifiiotsdioextendfunc.md) * extFunc)
```

 **Description:**

Sets the extended SDIO attributes. 

**Parameters:**

<a name="table781098682090252"></a>
<table><thead align="left"><tr id="row1802047095090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p26209178090252"><a name="p26209178090252"></a><a name="p26209178090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2122581794090252"><a name="p2122581794090252"></a><a name="p2122581794090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1851715196090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">extFunc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the extended attributes. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## SpiDeinit\(\)<a name="ga1e39213f9d9fa488eaf9f172ab675b24"></a>

```
unsigned int SpiDeinit ([WifiIotSpiIdx](wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b) spiId)
```

 **Description:**

Deinitializes an SPI device. 

**Parameters:**

<a name="table535075141090252"></a>
<table><thead align="left"><tr id="row147378357090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1011847553090252"><a name="p1011847553090252"></a><a name="p1011847553090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p786436830090252"><a name="p786436830090252"></a><a name="p786436830090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row965339326090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">spiId</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the SPI channel ID. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## SpiHostRead\(\)<a name="ga72b7cd1ad546f88982385c5ca054580d"></a>

```
unsigned int SpiHostRead ([WifiIotSpiIdx](wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b) spiId, char * readData, unsigned int byteLen )
```

 **Description:**

Reads data in half-duplex SPI master mode. 

In SPI master mode, this function reads data of the length specified by  **byteLen**  in  **readData**  through the channel specified by  **spiId**.

**Parameters:**

<a name="table1492781894090252"></a>
<table><thead align="left"><tr id="row115879691090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p919201056090252"><a name="p919201056090252"></a><a name="p919201056090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p261387149090252"><a name="p261387149090252"></a><a name="p261387149090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row248433471090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">spiId</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the SPI channel ID. </td>
</tr>
<tr id="row1344097227090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">readData</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the data to read. </td>
</tr>
<tr id="row1803797741090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">byteLen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the data to read. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## SpiHostWrite\(\)<a name="ga9b550208916b4fa86385768cc81e0c5b"></a>

```
unsigned int SpiHostWrite ([WifiIotSpiIdx](wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b) spiId, char * writeData, unsigned int byteLen )
```

 **Description:**

Sends data in half-duplex SPI master mode. 

In SPI master mode, this function sends data of the length specified by  **byteLen**  in  **writeData**  through the channel specified by  **spiId**.

**Parameters:**

<a name="table363272628090252"></a>
<table><thead align="left"><tr id="row1020329831090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1931757433090252"><a name="p1931757433090252"></a><a name="p1931757433090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p834976836090252"><a name="p834976836090252"></a><a name="p834976836090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1543815331090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">spiId</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the SPI channel ID. </td>
</tr>
<tr id="row2089204563090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">writeData</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the data to send. </td>
</tr>
<tr id="row674864667090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">byteLen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the data to send. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## SpiHostWriteread\(\)<a name="ga3ad87923c61c537f8366da76d6384dd1"></a>

```
unsigned int SpiHostWriteread ([WifiIotSpiIdx](wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b) spiId, char * writeData, char * readData, unsigned int byteLen )
```

 **Description:**

Sends and reads data in full-duplex SPI master mode. 

In SPI master mode, this function sends data in  **writeData**  and reads data of the length specified by  **byteLen**  in  **readData**  both through the channel specified by  **spiId**.

**Parameters:**

<a name="table1699515145090252"></a>
<table><thead align="left"><tr id="row467384962090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p764316655090252"><a name="p764316655090252"></a><a name="p764316655090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1378203465090252"><a name="p1378203465090252"></a><a name="p1378203465090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row15422068090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">spiId</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the SPI channel ID. </td>
</tr>
<tr id="row1595438739090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">writeData</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the data to send. </td>
</tr>
<tr id="row785161180090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">readData</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the data to read. </td>
</tr>
<tr id="row1035675474090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">byteLen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the data to read. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## SpiInit\(\)<a name="gafb1a0999baf079d2907b73554f3fe458"></a>

```
unsigned int SpiInit ([WifiIotSpiIdx](wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b) spiId, [WifiIotSpiCfgInitParam](wifiiotspicfginitparam.md) initParam, const [WifiIotSpiCfgBasicInfo](wifiiotspicfgbasicinfo.md) * param )
```

 **Description:**

Initializes an SPI device. 

This function initializes the device with the channel ID  **spiId**, device type  **initParam**, and device parameter  **param**.

**Parameters:**

<a name="table339715601090252"></a>
<table><thead align="left"><tr id="row794121926090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p776857509090252"><a name="p776857509090252"></a><a name="p776857509090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p321614907090252"><a name="p321614907090252"></a><a name="p321614907090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1674235218090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">spiId</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the SPI channel ID. </td>
</tr>
<tr id="row2051651997090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">initParam</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Specifies whether the device is a slave one. </td>
</tr>
<tr id="row912966480090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">param</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the SPI device parameter. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## SpiRegisterUsrFunc\(\)<a name="ga35305efc779b6386532fdb7a96fc5a1a"></a>

```
unsigned int SpiRegisterUsrFunc ([WifiIotSpiIdx](wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b) spiId, [SpiIsrFunc](wifiiot.md#gad1acc3e9c9d1c63f70aeb9d5201ed1f0) prepareF, [SpiIsrFunc](wifiiot.md#gad1acc3e9c9d1c63f70aeb9d5201ed1f0) restoreF )
```

 **Description:**

Registers the data TX preparation/recovery function. 

This function registers the functions registered by  **prepareF**  and  **restoreF**  for an SPI device with a channel specified by  **spiId**.

**Parameters:**

<a name="table1108445343090252"></a>
<table><thead align="left"><tr id="row1139922227090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p161762477090252"><a name="p161762477090252"></a><a name="p161762477090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p583616916090252"><a name="p583616916090252"></a><a name="p583616916090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1815032179090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">spiId</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the SPI channel ID. </td>
</tr>
<tr id="row1732097169090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">prepareF</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the function used for data preparation. </td>
</tr>
<tr id="row1597024281090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">restoreF</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the function used for data recovery. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## SpiSetBasicInfo\(\)<a name="ga7218dd7e5ae463ce2c29a6952c100893"></a>

```
unsigned int SpiSetBasicInfo ([WifiIotSpiIdx](wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b) spiId, const [WifiIotSpiCfgBasicInfo](wifiiotspicfgbasicinfo.md) * param )
```

 **Description:**

Sets the SPI channel parameter. 

**Parameters:**

<a name="table806299201090252"></a>
<table><thead align="left"><tr id="row155433698090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1193389020090252"><a name="p1193389020090252"></a><a name="p1193389020090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1241825019090252"><a name="p1241825019090252"></a><a name="p1241825019090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row359713608090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">spiId</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the SPI channel ID. </td>
</tr>
<tr id="row1327710358090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">param</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the SPI parameter to set. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## SpiSetDmaMode\(\)<a name="ga607d3d5b1f69cb89183566fb1d23f4cc"></a>

```
unsigned int SpiSetDmaMode ([WifiIotSpiIdx](wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b) spiId, unsigned char dmaEn )
```

 **Description:**

Sets whether to enable DMA to transfer data for an SPI device in slave mode. 

**Parameters:**

<a name="table43710623090252"></a>
<table><thead align="left"><tr id="row676768164090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p782128187090252"><a name="p782128187090252"></a><a name="p782128187090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p496463175090252"><a name="p496463175090252"></a><a name="p496463175090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1759877637090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">spiId</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the SPI channel ID. </td>
</tr>
<tr id="row1375992129090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dmaEn</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Specifies whether to enable DMA. The value <strong id="b1178071383090252"><a name="b1178071383090252"></a><a name="b1178071383090252"></a>1</strong> means to enable DMA, and <strong id="b1554132114090252"><a name="b1554132114090252"></a><a name="b1554132114090252"></a>0</strong> means to disable DMA. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## SpiSetIrqMode\(\)<a name="gaea32f9be9e75da8ee8ae342c513ccbfb"></a>

```
unsigned int SpiSetIrqMode ([WifiIotSpiIdx](wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b) spiId, unsigned char irqEn )
```

 **Description:**

Sets whether to enable the interrupt request \(IRQ\) mode for an SPI device. 

**Parameters:**

<a name="table1211209784090252"></a>
<table><thead align="left"><tr id="row542344372090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p221834554090252"><a name="p221834554090252"></a><a name="p221834554090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p40842910090252"><a name="p40842910090252"></a><a name="p40842910090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row639507176090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">spiId</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the SPI channel ID. </td>
</tr>
<tr id="row57773553090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">irqEn</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Specifies whether to enable IRQ. The value <strong id="b244276159090252"><a name="b244276159090252"></a><a name="b244276159090252"></a>1</strong> means to enable IRQ, and <strong id="b732703035090252"><a name="b732703035090252"></a><a name="b732703035090252"></a>0</strong> means to disable IRQ. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## SpiSetLoopBackMode\(\)<a name="ga42dad507650369b456549515d73d75a1"></a>

```
unsigned int SpiSetLoopBackMode ([WifiIotSpiIdx](wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b) spiId, unsigned char lbEn )
```

 **Description:**

Sets whether to enable loopback test for an SPI device. 

**Parameters:**

<a name="table1066200768090252"></a>
<table><thead align="left"><tr id="row1208945543090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p399721604090252"><a name="p399721604090252"></a><a name="p399721604090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1916992128090252"><a name="p1916992128090252"></a><a name="p1916992128090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1425446799090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">spiId</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the SPI channel ID. </td>
</tr>
<tr id="row865502601090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">lbEn</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Specifies whether to enable loopback test. The value <strong id="b1826662377090252"><a name="b1826662377090252"></a><a name="b1826662377090252"></a>1</strong> means to enable loopback test, and <strong id="b1796632350090252"><a name="b1796632350090252"></a><a name="b1796632350090252"></a>0</strong> means to disable loopback test. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## SpiSlaveRead\(\)<a name="gaf6b980dbae9b819c801db16cd933379d"></a>

```
unsigned int SpiSlaveRead ([WifiIotSpiIdx](wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b) spiId, char * readData, unsigned int byteLen, unsigned int timeOutMs )
```

 **Description:**

Reads data in SPI slave mode. 

In SPI slave mode, this function reads data of the length specified by  **byteLen**  in  **readData**  through the channel specified by  **spiId**  within the duration  **timeOutMs**.

**Parameters:**

<a name="table1449848014090252"></a>
<table><thead align="left"><tr id="row1773429838090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2100402500090252"><a name="p2100402500090252"></a><a name="p2100402500090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1624231096090252"><a name="p1624231096090252"></a><a name="p1624231096090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1065997760090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">spiId</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the SPI channel ID. </td>
</tr>
<tr id="row1696176929090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">readData</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the data to read. </td>
</tr>
<tr id="row1765757287090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">byteLen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the data to read. </td>
</tr>
<tr id="row1946747002090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">timeOutMs</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the timeout interval. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## SpiSlaveWrite\(\)<a name="gabc5bfa19d08bcbd824a81cfdb476bc03"></a>

```
unsigned int SpiSlaveWrite ([WifiIotSpiIdx](wifiiot.md#ga1d095e78d92cdf2ffc5e34443726e44b) spiId, char * writeData, unsigned int byteLen, unsigned int timeOutMs )
```

 **Description:**

Sends data in SPI slave mode. 

In SPI slave mode, this function sends data of the length specified by  **byteLen**  in  **writeData**  through the channel specified by  **spiId**  within the duration  **timeOutMs**.

**Parameters:**

<a name="table892586808090252"></a>
<table><thead align="left"><tr id="row1997905245090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p314540397090252"><a name="p314540397090252"></a><a name="p314540397090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1906769067090252"><a name="p1906769067090252"></a><a name="p1906769067090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1614800999090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">spiId</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the SPI channel ID. </td>
</tr>
<tr id="row1465293483090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">writeData</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the data to send. </td>
</tr>
<tr id="row949843605090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">byteLen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the length of the data to send. </td>
</tr>
<tr id="row230933329090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">timeOutMs</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the timeout interval. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## UartDeinit\(\)<a name="gaa0519aee188e7def8ea1e76caaabab7b"></a>

```
unsigned int UartDeinit ([WifiIotUartIdx](wifiiot.md#ga2699252424e5469ef243ae279a263c44) id)
```

 **Description:**

Deinitializes a UART device. 

**Parameters:**

<a name="table136256524090252"></a>
<table><thead align="left"><tr id="row1082096681090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2098197674090252"><a name="p2098197674090252"></a><a name="p2098197674090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p203479229090252"><a name="p203479229090252"></a><a name="p203479229090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row403441515090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the UART port number. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## UartGetAttribute\(\)<a name="gabc811333b8add98cd2eabb0ee2d726a3"></a>

```
unsigned int UartGetAttribute ([WifiIotUartIdx](wifiiot.md#ga2699252424e5469ef243ae279a263c44) id, [WifiIotUartAttribute](wifiiotuartattribute.md) * attr, [WifiIotUartExtraAttr](wifiiotuartextraattr.md) * extraAttr )
```

 **Description:**

Obtains UART attributes. 

This function obtains the basic and extended attributes of a UART device.

**Parameters:**

<a name="table1914953532090252"></a>
<table><thead align="left"><tr id="row1140028801090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p25999163090252"><a name="p25999163090252"></a><a name="p25999163090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1624143422090252"><a name="p1624143422090252"></a><a name="p1624143422090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1700680314090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the UART port number. </td>
</tr>
<tr id="row1875630674090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">attr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the basic UART attributes. </td>
</tr>
<tr id="row1386115098090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">extraAttr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the extended UART attributes. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## UartInit\(\)<a name="gabd8789246727fe776404b03814822376"></a>

```
unsigned int UartInit ([WifiIotUartIdx](wifiiot.md#ga2699252424e5469ef243ae279a263c44) id, const [WifiIotUartAttribute](wifiiotuartattribute.md) * param, const [WifiIotUartExtraAttr](wifiiotuartextraattr.md) * extraAttr )
```

 **Description:**

Configures a UART device. 

This function configures a UART device with the port number specified by  **id**  based on the basic and extended attributes.

**Parameters:**

<a name="table660154811090252"></a>
<table><thead align="left"><tr id="row1251728008090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p824658822090252"><a name="p824658822090252"></a><a name="p824658822090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p741716254090252"><a name="p741716254090252"></a><a name="p741716254090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1832937968090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the UART port number. </td>
</tr>
<tr id="row1318209563090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">param</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the basic UART attributes. </td>
</tr>
<tr id="row2064762848090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">extraAttr</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the extended UART attributes. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## UartIsBufEmpty\(\)<a name="gafcea2c43c0f614ec9a02bcc1eaf81da1"></a>

```
unsigned int UartIsBufEmpty ([WifiIotUartIdx](wifiiot.md#ga2699252424e5469ef243ae279a263c44) id, unsigned char * empty )
```

 **Description:**

Checks whether the buffer on a UART device is empty. 

The query result will be stored in  **empty**.

**Parameters:**

<a name="table1357466248090252"></a>
<table><thead align="left"><tr id="row1775631386090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p107477854090252"><a name="p107477854090252"></a><a name="p107477854090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1194626499090252"><a name="p1194626499090252"></a><a name="p1194626499090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row545082088090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the UART port number. </td>
</tr>
<tr id="row1280371040090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">empty</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the address whether the query result is to be stored. If the buffer is empty, the query result is <strong id="b27392534090252"><a name="b27392534090252"></a><a name="b27392534090252"></a>1</strong>. If the buffer is not empty, the query result is <strong id="b1813833622090252"><a name="b1813833622090252"></a><a name="b1813833622090252"></a>0</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## UartIsBusy\(\)<a name="ga67d7b274aaddc162c0140e32f6bc4486"></a>

```
unsigned int UartIsBusy ([WifiIotUartIdx](wifiiot.md#ga2699252424e5469ef243ae279a263c44) id, unsigned char * busy )
```

 **Description:**

Checks whether the buffer on a UART device is busy. 

The query result will be stored in  **busy**.

**Parameters:**

<a name="table1702220729090252"></a>
<table><thead align="left"><tr id="row1309723564090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p399858731090252"><a name="p399858731090252"></a><a name="p399858731090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2129181030090252"><a name="p2129181030090252"></a><a name="p2129181030090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row610680136090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the UART port number. </td>
</tr>
<tr id="row1836657857090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">busy</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the address whether the query result is to be stored. If the buffer is busy, the query result is <strong id="b1922978524090252"><a name="b1922978524090252"></a><a name="b1922978524090252"></a>1</strong>. If the buffer is not busy, the query result is <strong id="b1088413935090252"><a name="b1088413935090252"></a><a name="b1088413935090252"></a>0</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## UartRead\(\)<a name="ga048ac867ce0e1cac9b588840e8a50d1d"></a>

```
int UartRead ([WifiIotUartIdx](wifiiot.md#ga2699252424e5469ef243ae279a263c44) id, unsigned char * data, unsigned int dataLen )
```

 **Description:**

Reads data from a UART device. 

This function reads a specified length of data from a UART device with the port number specified by  **id**.

**Parameters:**

<a name="table1033653813090252"></a>
<table><thead align="left"><tr id="row427903198090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p266980841090252"><a name="p266980841090252"></a><a name="p266980841090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2022728017090252"><a name="p2022728017090252"></a><a name="p2022728017090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row158512887090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the UART port number. </td>
</tr>
<tr id="row977465267090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">data</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the start address of the data to read. </td>
</tr>
<tr id="row209502654090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dataLen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of bytes to read. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of bytes read if the operation is successful; returns  **-1**  otherwise. 



## UartSetFlowCtrl\(\)<a name="ga5ae5acc039c3446225daf8b1b60a89d1"></a>

```
unsigned int UartSetFlowCtrl ([WifiIotUartIdx](wifiiot.md#ga2699252424e5469ef243ae279a263c44) id, [WifiIotFlowCtrl](wifiiot.md#gacf7ec5d973706e8239c7c6e4a470d8ab) flowCtrl )
```

 **Description:**

Sets UART hardware flow control. 

This function configures flow control for a UART device with the port number specified by  **id**.

**Parameters:**

<a name="table599747805090252"></a>
<table><thead align="left"><tr id="row1521367610090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1845404039090252"><a name="p1845404039090252"></a><a name="p1845404039090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p665860378090252"><a name="p665860378090252"></a><a name="p665860378090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row816372286090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the UART port number. </td>
</tr>
<tr id="row1042697447090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">flowCtrl</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the parameter used for hardware flow control. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  [WIFI\_IOT\_SUCCESS](wifiiot.md#gae70eaf627c0370cc271dcb8060aee861)  if the operation is successful; returns an error code defined in  [wifiiot\_errno.h](wifiiot_errno-h.md)  otherwise. 



## UartWrite\(\)<a name="gaac619810d8212e36ac8fbbc133d6308c"></a>

```
int UartWrite ([WifiIotUartIdx](wifiiot.md#ga2699252424e5469ef243ae279a263c44) id, const unsigned char * data, unsigned int dataLen )
```

 **Description:**

Writes data to a UART device. 

This function writes a specified length of data to a UART device with the port number specified by  **id**.

**Parameters:**

<a name="table843507056090252"></a>
<table><thead align="left"><tr id="row1134183070090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p815634100090252"><a name="p815634100090252"></a><a name="p815634100090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1284448229090252"><a name="p1284448229090252"></a><a name="p1284448229090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2020113530090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the UART port number. </td>
</tr>
<tr id="row1103007753090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">data</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the start address of the data to write. </td>
</tr>
<tr id="row1236941868090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dataLen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of bytes to write. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of bytes written if the operation is successful; returns  **-1**  otherwise. 



## UartWriteImmediately\(\)<a name="gab6630d50726f5c57e726c3465fc0eb96"></a>

```
int UartWriteImmediately ([WifiIotUartIdx](wifiiot.md#ga2699252424e5469ef243ae279a263c44) id, const unsigned char * data, unsigned int dataLen )
```

 **Description:**

Writes data to be sent to a UART device in polling mode. 

**Parameters:**

<a name="table187953343090252"></a>
<table><thead align="left"><tr id="row738763788090252"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p780395384090252"><a name="p780395384090252"></a><a name="p780395384090252"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1524537882090252"><a name="p1524537882090252"></a><a name="p1524537882090252"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row232244981090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the UART port number. </td>
</tr>
<tr id="row533866019090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">data</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the start address of the data to write. </td>
</tr>
<tr id="row1010521271090252"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dataLen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of bytes to write. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of bytes written if the operation is successful; returns  **-1**  otherwise. 



## WatchDogDisable\(\)<a name="ga37e8662b7a4f2ad084a43c6309c83a14"></a>

```
void WatchDogDisable (void )
```

 **Description:**

Disables the watchdog. 

## WatchDogEnable\(\)<a name="ga33305a45dcc141336c8dcdb10e0b71b1"></a>

```
void WatchDogEnable (void )
```

 **Description:**

Enables the watchdog. 

## WatchDogKick\(\)<a name="gadded4aa52fb304e815811edc4bc1ce41"></a>

```
void WatchDogKick (void )
```

 **Description:**

Feeds the watchdog. 

