# 组件构成<a name="ZH-CN_TOPIC_0000001051930853"></a>

一个组件包一般包含如下内容：

-   组件包的代码或库（src目录下的代码文件）
-   ohos\_bundles文件夹（存放依赖的组件，安装组件时自动生成，无需提交到代码库）
-   组件包的说明文件\(README.md\)
-   组件包元数据声明文件\(bundle.json\)
-   开源许可文件\(LICENSE\)

    ```
    my-bundle
       |_ohos_bundles
       |_src
       |_bundle.json
       |_README.md
       |_LICENSE
    ```


## 代码文件<a name="section101483489110"></a>

组件的代码文件和普通的代码目录没有差异。但要注意的是，组件中对外暴露的接口（头文件），会被其他组件所引用，需要单独在bundle.json的dirs中声明。

## 说明文件<a name="section10519101221211"></a>

README.md，为markdown格式的描述关于组件自述说明文件。（[语法参考](https://www.markdownguide.org/getting-started/)\)

为了帮助他人在hpm上找到该组件，并更方便的使用它，在组件的根目录中包含一个README文件。

README文件可能包括如何安装，配置和使用组件包中的实例代码说明，以及可能会对用户有所帮助的任何其他信息。

每个组件的自述文件将显示在hpm系统的组件详情页面的描述中。

## 元数据描述文件<a name="section45511827111211"></a>

bundle.json文件是对当前组件的元数据描述，每个组件中必须包含一个bundle.json文件。

```
{
  "name": "@myorg/demo-bundle",
  "version": "1.0.0",
  "license": "MIT",
  "description": "bundle description",
  "keywords": ["hos"],
  "tags": ["applications", "drivers"],
  "author": {"name":"","email":"","url":""},
  "contributors":[{"name":"","email":"","url":""},{"name":"","email":"","url":""}],
  "homepage": "http://www.foo.bar.com",
  "repository": "https://git@gitee.com:foo/bar.git",
  "publishAs": "source",
  "dirs": {
    "src": ["src/**/*.c"],
    "headers": ["headers/**/*.h"],
    "bin": ["bin/**/*.o"]
  },
  "scripts": {
    "build": "make"
  },
  "envs": {},
  "ohos": {
    "os": "2.0.0",
    "board": "hi3516",
    "kernel": "liteos-a"
  },
 "rom": "10240",
 "ram": "1024",
 "dependencies": {
    "@myorg/net":"1.0.0"
 }
}
```

bundle.json文件具有如下功能：

-   name：定义组件的名称，放到组织下， 以@开头，/分割，如：@myorg/mybundle

-   version：定义组件版本号，如1.0.0，需满足semver的标准。

-   description：一句话对组件进行简要的描述。
-   dependencies：定义组件的依赖组件。

-   envs： 定义组件编译时所需要的参数，包括全局参数以及依赖所需的参数。

-   scripts：定义在当前组件下能够执行的命令（如编译，构建，测试，烧录等）。

-   publishAs：定义组件的发布类型（source：源码，binary：二进制，distribution：发行版，code-segment：代码片段）。

-   dirs：定义发布时打包的目录结构（如头文件）。

-   ram&rom：统计相关信息：预计占用ROM和RAM信息。
-   ohos：描述OpenHarmony系统版本、开发板及内核的匹配关系（多个请用英文逗号的“,”分割）。
-   定义其他扩展信息：作者，主页，代码仓库，许可协议，标签，关键字。
-   对于发行版类型，还有个base，可以定义继承自的发行版。

