# 环境变量说明<a name="ZH-CN_TOPIC_0000001054807267"></a>

组件在编译的过程中需要依赖系统提供的环境变量来自定义输出，链接所需二进制文件等等。这里提出的环境变量均指根据需求把所需变量注入脚本执行的上下文中。所以在脚本中可以直接获取到变量的值。下面介绍当前系统存在的几种环境变量。全局变量

全局变量由bundle.json中的envs属性来定义。整个组件中的依赖都可以获取到全局变量定义的值。

```
{
    "envs": {
        "compileEnv": "arm"
    }
}
```

不同组件在引入依赖的过程中可以传入不同的参数，从而使依赖的编译可以满足当前组件的需求。依赖中定义的参数可以在对应依赖脚本执行的上下文中获取到。

```
{
    "dependencies": {
        "my-bundle": {
            "version": "1.0.0",
            "mode": "debug"
        }
    }
}
```

组件在链接二进制文件的时候，需要知道二进制文件在依赖中的路径，所以依赖的路径会作为环境变量传入编译组件中。

传入的环境变量的格式为DEP\_BundleName，BundleName为依赖的名称，例如 DEP\_first\_bundle。

依赖中可以定义标签，对引入的依赖进行分组。在脚本中可以根据标签，获得这一组依赖的路径。定义的标签以\#开头，具体定义的方式为：

```
{
    "dependencies": {
        "#tool": {
            "first-bundle": "1.0.0",
            "second-bundle": "1.0.0"
        },
        "#drivers": {
            "xx-bundle": "1.0.0",
            "yy-bundle": "1.0.0"
        }
    }
}
```

系统中存在两个固定环境变量：

-   DEP\_OHOS\_BUNDLES：表示ohos\_bundles文件夹所在的路径。
-   DEP\_BUNDLE\_BASE：表示最外层组件的路径。

