# 概述<a name="ZH-CN_TOPIC_0000001051452141"></a>

本文档将介绍组件的基本概念以及如何按照规范定义组件。

## 定义<a name="section177563344911"></a>

OpenHarmony软件以组件\(bundle\)作为基本单元，从系统角度看，凡是运行在OpenHarmony上的软件都可以定义为组件；一般来讲，根据组件的应用范围，可以分为：

-   板级组件：如board、arch、mcu这些与设备硬件相关的组件。
-   系统组件：一组独立功能的集合，如内核、文件系统、框架等。
-   应用组件：直接面向用户提供服务的应用\(如wifi\_iot，ip\_camera\)。

从形式上看，组件是为复用而生，一切可以复用的模块都可以定义为组件，可以分为：

-   源代码
-   二进制
-   代码片段
-   发行版

## 组件划分原则<a name="section2487162541016"></a>

原则上应尽可能划分为细颗粒度的组件，以满足最大限度的复用。主要考虑以下几点：

-   独立性：组件的功能应该相对独立，支持独立编译，可以单独对外提供接口和服务；
-   耦合性：如果组件必须依赖其他的组件，才能对外提供服务，应考虑和被依赖的组件合并为一个组件。
-   相关性：如果一组组件共同完成一项功能，且没有被其他组件依赖，未来也没有被依赖的可能，则可以考虑合并为一个组件。

## 组件依赖<a name="section185955409107"></a>

组件的依赖关系分为两种：必选依赖和可选依赖。

-   必选依赖：是指组件A在完成某个功能时，必须引入组件B，调用B的接口或服务配合才能完成。称B为A的必选依赖。
-   可选依赖：是在组件A在完成某个功能时，可以引入组件C，也可以引入组件D。C和D可以相互替换，称C和D为A的可选依赖。

