# wifi\_module.h<a name="ZH-CN_TOPIC_0000001055198118"></a>

## **Overview**<a name="section124199565093528"></a>

**Related Modules:**

[WLAN](WLAN.md)

**Description:**

Provides features of the WLAN module and functions to create and delete modules. 

The  **[WifiModule](WifiModule.md)**  object is a core abstraction of the WLAN driver. It contains a module that communicates with user-level processes and also contains features.

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section1747495292093528"></a>

## Data Structures<a name="nested-classes"></a>

<a name="table38608673093528"></a>
<table><thead align="left"><tr id="row43224200093528"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p235852310093528"><a name="p235852310093528"></a><a name="p235852310093528"></a>Data Structure Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1539612436093528"><a name="p1539612436093528"></a><a name="p1539612436093528"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1949128908093528"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1002184383093528"><a name="p1002184383093528"></a><a name="p1002184383093528"></a><a href="WifiModuleIface.md">WifiModuleIface</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1858383641093528"><a name="p1858383641093528"></a><a name="p1858383641093528"></a>Defines WLAN module APIs. </p>
</td>
</tr>
<tr id="row1590485967093528"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p274669361093528"><a name="p274669361093528"></a><a name="p274669361093528"></a><a href="WifiModule.md">WifiModule</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1035296915093528"><a name="p1035296915093528"></a><a name="p1035296915093528"></a>Defines the WLAN module. </p>
</td>
</tr>
<tr id="row1585880353093528"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1200220606093528"><a name="p1200220606093528"></a><a name="p1200220606093528"></a><a href="WifiFeature.md">WifiFeature</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p264476385093528"><a name="p264476385093528"></a><a name="p264476385093528"></a>Defines a WLAN feature. </p>
</td>
</tr>
<tr id="row1243583143093528"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p618124985093528"><a name="p618124985093528"></a><a name="p618124985093528"></a><a href="WifiFeatureList.md">WifiFeatureList</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p858654446093528"><a name="p858654446093528"></a><a name="p858654446093528"></a>Defines the WLAN feature list. </p>
</td>
</tr>
<tr id="row1684831900093528"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1031882838093528"><a name="p1031882838093528"></a><a name="p1031882838093528"></a><a href="HdfWifiChipData.md">HdfWifiChipData</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1105953647093528"><a name="p1105953647093528"></a><a name="p1105953647093528"></a>Defines a WLAN chip. </p>
</td>
</tr>
</tbody>
</table>

## Functions<a name="func-members"></a>

<a name="table785643696093528"></a>
<table><thead align="left"><tr id="row892400213093528"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1754879594093528"><a name="p1754879594093528"></a><a name="p1754879594093528"></a>Function Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p304893670093528"><a name="p304893670093528"></a><a name="p304893670093528"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row88952021093528"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1725390239093528"><a name="p1725390239093528"></a><a name="p1725390239093528"></a><a href="WLAN.md#gaf5d1df53f08cae98ecfd440f9b425709">WifiModuleCreate</a> (const struct HdfConfigWifiModuleConfig *config)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1407063685093528"><a name="p1407063685093528"></a><a name="p1407063685093528"></a>struct <a href="WifiModule.md">WifiModule</a> *&nbsp;</p>
<p id="p1807880796093528"><a name="p1807880796093528"></a><a name="p1807880796093528"></a>Creates a <a href="WifiModule.md">WifiModule</a> object based on a specified configuration generated by the HCS. </p>
</td>
</tr>
<tr id="row1398368027093528"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p771013500093528"><a name="p771013500093528"></a><a name="p771013500093528"></a><a href="WLAN.md#gae14e3786e60f16a100197d28bae5a362">WifiModuleDelete</a> (struct <a href="WifiModule.md">WifiModule</a> *module)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1222436530093528"><a name="p1222436530093528"></a><a name="p1222436530093528"></a>void&nbsp;</p>
<p id="p677270318093528"><a name="p677270318093528"></a><a name="p677270318093528"></a>Deletes a specified <a href="WifiModule.md">WifiModule</a> object. </p>
</td>
</tr>
<tr id="row332175267093528"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1893586689093528"><a name="p1893586689093528"></a><a name="p1893586689093528"></a><a href="WLAN.md#ga395848b77fc10f2213d5b12793861292">DelFeature</a> (struct <a href="WifiModule.md">WifiModule</a> *module, uint16_t featureType)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p997730068093528"><a name="p997730068093528"></a><a name="p997730068093528"></a>int32_t&nbsp;</p>
<p id="p247416606093528"><a name="p247416606093528"></a><a name="p247416606093528"></a>Deletes a specified feature from a specified module. </p>
</td>
</tr>
<tr id="row1204988603093528"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p321955966093528"><a name="p321955966093528"></a><a name="p321955966093528"></a><a href="WLAN.md#gae928a69366143780650b73c6b030c3a7">AddFeature</a> (struct <a href="WifiModule.md">WifiModule</a> *module, uint16_t featureType, struct <a href="WifiFeature.md">WifiFeature</a> *featureData)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p365990380093528"><a name="p365990380093528"></a><a name="p365990380093528"></a>int32_t&nbsp;</p>
<p id="p1331858135093528"><a name="p1331858135093528"></a><a name="p1331858135093528"></a>Adds a specified feature to a specified module. </p>
</td>
</tr>
</tbody>
</table>

