# samgr\_lite.h<a name="ZH-CN_TOPIC_0000001055518068"></a>

## **Overview**<a name="section1465209326084832"></a>

**Related Modules:**

[Samgr](Samgr.md)

**Description:**

Manages system capabilities. 

This is used when services, features, and functions are registered with and discovered by Samgr. 

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section1174344881084832"></a>

## Data Structures<a name="nested-classes"></a>

<a name="table1888670940084832"></a>
<table><thead align="left"><tr id="row392161710084832"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p689125055084832"><a name="p689125055084832"></a><a name="p689125055084832"></a>Data Structure Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1972091090084832"><a name="p1972091090084832"></a><a name="p1972091090084832"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2035764495084832"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2062814885084832"><a name="p2062814885084832"></a><a name="p2062814885084832"></a><a href="SamgrLite.md">SamgrLite</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p783764153084832"><a name="p783764153084832"></a><a name="p783764153084832"></a>Represents the system ability management class. </p>
</td>
</tr>
</tbody>
</table>

## Macros<a name="define-members"></a>

<a name="table1173780048084832"></a>
<table><thead align="left"><tr id="row448570920084832"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p847245542084832"><a name="p847245542084832"></a><a name="p847245542084832"></a>Macro Name and Value</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1893381874084832"><a name="p1893381874084832"></a><a name="p1893381874084832"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1370141976084832"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p894106434084832"><a name="p894106434084832"></a><a name="p894106434084832"></a><a href="Samgr.md#gadc00f0568236d4538c867ed7194d8960">BOOTSTRAP_SERVICE</a>&nbsp;&nbsp;&nbsp;"Bootstrap"</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1257954897084832"><a name="p1257954897084832"></a><a name="p1257954897084832"></a>Starts a bootstrap service, which is used by samgr and implemented by system service developers. </p>
</td>
</tr>
</tbody>
</table>

## Typedefs<a name="typedef-members"></a>

<a name="table402739233084832"></a>
<table><thead align="left"><tr id="row1364266230084832"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p164300724084832"><a name="p164300724084832"></a><a name="p164300724084832"></a>Typedef Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p148551043084832"><a name="p148551043084832"></a><a name="p148551043084832"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2091000946084832"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p401508575084832"><a name="p401508575084832"></a><a name="p401508575084832"></a><a href="Samgr.md#gadc486c8d2698eab8a9f26f0eb6cc63c8">BootMessage</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2034686413084832"><a name="p2034686413084832"></a><a name="p2034686413084832"></a>typedef enum <a href="Samgr.md#gaf39e482610dca95f0dba85613755eb40">BootMessage</a>&nbsp;</p>
<p id="p997155246084832"><a name="p997155246084832"></a><a name="p997155246084832"></a>Enumerates the IDs of the message to be processed for starting the bootstrap service. </p>
</td>
</tr>
<tr id="row1036456143084832"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1952469229084832"><a name="p1952469229084832"></a><a name="p1952469229084832"></a><a href="Samgr.md#gaad729fe4f36b7b42a122349af334fb28">SamgrLite</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p410857462084832"><a name="p410857462084832"></a><a name="p410857462084832"></a>typedef struct <a href="SamgrLite.md">SamgrLite</a>&nbsp;</p>
<p id="p676170271084832"><a name="p676170271084832"></a><a name="p676170271084832"></a>Represents the system ability management class. </p>
</td>
</tr>
</tbody>
</table>

## Enumerations<a name="enum-members"></a>

<a name="table1484511793084832"></a>
<table><thead align="left"><tr id="row948305756084832"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p833335095084832"><a name="p833335095084832"></a><a name="p833335095084832"></a>Enumeration Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1620305172084832"><a name="p1620305172084832"></a><a name="p1620305172084832"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1481348796084832"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1118218047084832"><a name="p1118218047084832"></a><a name="p1118218047084832"></a><a href="Samgr.md#gaf39e482610dca95f0dba85613755eb40">BootMessage</a> { <a href="Samgr.md#ggaf39e482610dca95f0dba85613755eb40aee5f1e07de9a8e2e167f97dd2cc0c2d7">BOOT_SYS_COMPLETED</a>, <a href="Samgr.md#ggaf39e482610dca95f0dba85613755eb40a8b0613200e2b05f9309175fe9bd30ca1">BOOT_APP_COMPLETED</a>, <a href="Samgr.md#ggaf39e482610dca95f0dba85613755eb40a9aff5f5b8378e898076ee326da5cd572">BOOT_REG_SERVICE</a>, <a href="Samgr.md#ggaf39e482610dca95f0dba85613755eb40a515e06399df48a6d93435e7c30745eec">BOOTSTRAP_BUTT</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1456233837084832"><a name="p1456233837084832"></a><a name="p1456233837084832"></a>Enumerates the IDs of the message to be processed for starting the bootstrap service. </p>
</td>
</tr>
</tbody>
</table>

## Functions<a name="func-members"></a>

<a name="table1795829636084832"></a>
<table><thead align="left"><tr id="row1906792759084832"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p989304193084832"><a name="p989304193084832"></a><a name="p989304193084832"></a>Function Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1714031200084832"><a name="p1714031200084832"></a><a name="p1714031200084832"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row132990853084832"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1863207063084832"><a name="p1863207063084832"></a><a name="p1863207063084832"></a><a href="Samgr.md#ga21f168d6f97d6991115ae1cf8bbd8deb">SAMGR_GetInstance</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1497697281084832"><a name="p1497697281084832"></a><a name="p1497697281084832"></a><a href="SamgrLite.md">SamgrLite</a> *&nbsp;</p>
<p id="p1970691957084832"><a name="p1970691957084832"></a><a name="p1970691957084832"></a>Obtains the singleton Samgr instance. </p>
</td>
</tr>
<tr id="row852095759084832"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1656815823084832"><a name="p1656815823084832"></a><a name="p1656815823084832"></a><a href="Samgr.md#ga756ac1f5376c72aa5d14b855a302d7b6">SAMGR_Bootstrap</a> (void)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p375064962084832"><a name="p375064962084832"></a><a name="p375064962084832"></a>void&nbsp;</p>
<p id="p2066110495084832"><a name="p2066110495084832"></a><a name="p2066110495084832"></a>Starts system services and features. </p>
</td>
</tr>
</tbody>
</table>

