# limits.h<a name="ZH-CN_TOPIC_0000001055308035"></a>

## **Overview**<a name="section314885208084831"></a>

**Related Modules:**

[UTILS](UTILS.md)

**Description:**

Declares commonly used macro values. 

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section1170922314084831"></a>

## Macros<a name="define-members"></a>

<a name="table1116900573084831"></a>
<table><thead align="left"><tr id="row908361867084831"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1704398033084831"><a name="p1704398033084831"></a><a name="p1704398033084831"></a>Macro Name and Value</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p704991869084831"><a name="p704991869084831"></a><a name="p704991869084831"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1927028839084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1280201912084831"><a name="p1280201912084831"></a><a name="p1280201912084831"></a><a href="UTILS.md#ga5d707bd32338557ced18c6ac76ca1b3a">CHAR_MIN</a>&nbsp;&nbsp;&nbsp;0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1212714594084831"><a name="p1212714594084831"></a><a name="p1212714594084831"></a>Minimum value of type char. </p>
</td>
</tr>
<tr id="row372676050084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p372476198084831"><a name="p372476198084831"></a><a name="p372476198084831"></a><a href="UTILS.md#ga778eefd6535a9d4b752fca5dd0af58db">CHAR_MAX</a>&nbsp;&nbsp;&nbsp;255</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p138190987084831"><a name="p138190987084831"></a><a name="p138190987084831"></a>Maximum value of type char. </p>
</td>
</tr>
<tr id="row722498008084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1439965773084831"><a name="p1439965773084831"></a><a name="p1439965773084831"></a><a href="UTILS.md#ga308d9dd2c0028ddb184b455bbd7865de">CHAR_BIT</a>&nbsp;&nbsp;&nbsp;8</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1694735730084831"><a name="p1694735730084831"></a><a name="p1694735730084831"></a>Number of bits in type char. </p>
</td>
</tr>
<tr id="row800620198084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1144150576084831"><a name="p1144150576084831"></a><a name="p1144150576084831"></a><a href="UTILS.md#gaa05d197000ad5c143ada0fcd9379b236">SCHAR_MIN</a>&nbsp;&nbsp;&nbsp;(-128)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p874215557084831"><a name="p874215557084831"></a><a name="p874215557084831"></a>Minimum value of type signed char. </p>
</td>
</tr>
<tr id="row881212681084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2143693883084831"><a name="p2143693883084831"></a><a name="p2143693883084831"></a><a href="UTILS.md#ga8c13fdd8c2840edf0cb04a65297037bb">SCHAR_MAX</a>&nbsp;&nbsp;&nbsp;127</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p24983023084831"><a name="p24983023084831"></a><a name="p24983023084831"></a>Maximum value of type signed char. </p>
</td>
</tr>
<tr id="row1187311082084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p987228195084831"><a name="p987228195084831"></a><a name="p987228195084831"></a><a href="UTILS.md#ga4066e640ee269d5d8f83ff6643b7af5f">UCHAR_MAX</a>&nbsp;&nbsp;&nbsp;255</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1885848821084831"><a name="p1885848821084831"></a><a name="p1885848821084831"></a>Maximum value of type unsigned char. </p>
</td>
</tr>
<tr id="row487665270084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p250797425084831"><a name="p250797425084831"></a><a name="p250797425084831"></a><a href="UTILS.md#gae59de266aceffa1c258ac13f45fe0d18">SHRT_MIN</a>&nbsp;&nbsp;&nbsp;(-1-0x7fff)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p762784225084831"><a name="p762784225084831"></a><a name="p762784225084831"></a>Minimum value of type short. </p>
</td>
</tr>
<tr id="row702455885084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p918350130084831"><a name="p918350130084831"></a><a name="p918350130084831"></a><a href="UTILS.md#ga1f758438cb1c7bcf55da2431f5e319e6">SHRT_MAX</a>&nbsp;&nbsp;&nbsp;0x7fff</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p888085207084831"><a name="p888085207084831"></a><a name="p888085207084831"></a>Maximum value of type short. </p>
</td>
</tr>
<tr id="row323241181084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p63976618084831"><a name="p63976618084831"></a><a name="p63976618084831"></a><a href="UTILS.md#ga689b119da994dece91d44b5aeac643ed">USHRT_MAX</a>&nbsp;&nbsp;&nbsp;0xffff</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1927194685084831"><a name="p1927194685084831"></a><a name="p1927194685084831"></a>Maximum value of type unsigned short. </p>
</td>
</tr>
<tr id="row598658182084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1930499383084831"><a name="p1930499383084831"></a><a name="p1930499383084831"></a><a href="UTILS.md#ga21658776274b3d146c674318b635a334">INT_MIN</a>&nbsp;&nbsp;&nbsp;(-1-0x7fffffff)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1706836154084831"><a name="p1706836154084831"></a><a name="p1706836154084831"></a>Minimum value of type int. </p>
</td>
</tr>
<tr id="row1988278049084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p735712779084831"><a name="p735712779084831"></a><a name="p735712779084831"></a><a href="UTILS.md#ga9ec306f36d50c7375e74f0d1c55a3a67">INT_MAX</a>&nbsp;&nbsp;&nbsp;0x7fffffff</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p714105794084831"><a name="p714105794084831"></a><a name="p714105794084831"></a>Maximum value of type int. </p>
</td>
</tr>
<tr id="row1146620318084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p253848989084831"><a name="p253848989084831"></a><a name="p253848989084831"></a><a href="UTILS.md#gac998ea02fbd821fc123d60445ce76f38">UINT_MAX</a>&nbsp;&nbsp;&nbsp;0xffffffffU</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p57902929084831"><a name="p57902929084831"></a><a name="p57902929084831"></a>Maximum value of type unsigned int. </p>
</td>
</tr>
<tr id="row256244434084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1632862237084831"><a name="p1632862237084831"></a><a name="p1632862237084831"></a><a href="UTILS.md#gad896ef973a3b47ebdc61650fa08e09fe">__LONG_MAX</a>&nbsp;&nbsp;&nbsp;0x7fffffffL</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1138101552084831"><a name="p1138101552084831"></a><a name="p1138101552084831"></a>Maximum value of type long. </p>
</td>
</tr>
<tr id="row1598865682084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p887741154084831"><a name="p887741154084831"></a><a name="p887741154084831"></a><a href="UTILS.md#gae8a44c5a7436466221e0f3859d02420f">LONG_MIN</a>&nbsp;&nbsp;&nbsp;(-<a href="UTILS.md#ga50fece4db74f09568b2938db583c5655">LONG_MAX</a>-1)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1923255559084831"><a name="p1923255559084831"></a><a name="p1923255559084831"></a>Minimum value of type long. </p>
</td>
</tr>
<tr id="row1320044577084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p546201437084831"><a name="p546201437084831"></a><a name="p546201437084831"></a><a href="UTILS.md#ga50fece4db74f09568b2938db583c5655">LONG_MAX</a>&nbsp;&nbsp;&nbsp;<a href="UTILS.md#gad896ef973a3b47ebdc61650fa08e09fe">__LONG_MAX</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p475406987084831"><a name="p475406987084831"></a><a name="p475406987084831"></a>Maximum value of type long. </p>
</td>
</tr>
<tr id="row1156489045084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p782319069084831"><a name="p782319069084831"></a><a name="p782319069084831"></a><a href="UTILS.md#ga41c51926a1997aab3503f9083935e06c">ULONG_MAX</a>&nbsp;&nbsp;&nbsp;(2UL*<a href="UTILS.md#ga50fece4db74f09568b2938db583c5655">LONG_MAX</a>+1)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2117218038084831"><a name="p2117218038084831"></a><a name="p2117218038084831"></a>Maximum value of type unsigned long. </p>
</td>
</tr>
<tr id="row1951374616084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p452259636084831"><a name="p452259636084831"></a><a name="p452259636084831"></a><a href="UTILS.md#gaf17a13b2ae0e9c24c020ac1f044f30c2">LLONG_MIN</a>&nbsp;&nbsp;&nbsp;(-<a href="UTILS.md#ga23ec2cf7fc07ea8f817bbac758402baf">LLONG_MAX</a>-1)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1667643070084831"><a name="p1667643070084831"></a><a name="p1667643070084831"></a>Minimum value of type long long. </p>
</td>
</tr>
<tr id="row1472484208084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p575428918084831"><a name="p575428918084831"></a><a name="p575428918084831"></a><a href="UTILS.md#ga23ec2cf7fc07ea8f817bbac758402baf">LLONG_MAX</a>&nbsp;&nbsp;&nbsp;0x7fffffffffffffffLL</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p376163310084831"><a name="p376163310084831"></a><a name="p376163310084831"></a>Maximum value of type long long. </p>
</td>
</tr>
<tr id="row569303528084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p40409897084831"><a name="p40409897084831"></a><a name="p40409897084831"></a><a href="UTILS.md#gaa1dd7166a75b73ad62b111ae6fc17c59">ULLONG_MAX</a>&nbsp;&nbsp;&nbsp;(2ULL*<a href="UTILS.md#ga23ec2cf7fc07ea8f817bbac758402baf">LLONG_MAX</a>+1)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p793423467084831"><a name="p793423467084831"></a><a name="p793423467084831"></a>Maximum value of type unsigned long long. </p>
</td>
</tr>
<tr id="row531834192084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p627344243084831"><a name="p627344243084831"></a><a name="p627344243084831"></a><a href="UTILS.md#gad2c1c798d36bdba42d5f4d50da5ae200">PIPE_BUF</a>&nbsp;&nbsp;&nbsp;4096</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1954363358084831"><a name="p1954363358084831"></a><a name="p1954363358084831"></a>Buffer length of pipe. </p>
</td>
</tr>
<tr id="row1158782788084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p386667532084831"><a name="p386667532084831"></a><a name="p386667532084831"></a><a href="UTILS.md#gac64541bdd81c961304b9babef1402640">NAME_MAX</a>&nbsp;&nbsp;&nbsp;255</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2033611494084831"><a name="p2033611494084831"></a><a name="p2033611494084831"></a>Maximum length of file or directory name. </p>
</td>
</tr>
<tr id="row1988686606084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p796348788084831"><a name="p796348788084831"></a><a name="p796348788084831"></a><a href="UTILS.md#gae688d728e1acdfe5988c7db45d6f0166">PATH_MAX</a>&nbsp;&nbsp;&nbsp;256</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p316101925084831"><a name="p316101925084831"></a><a name="p316101925084831"></a>Maximum length of the whole file or directory path. </p>
</td>
</tr>
<tr id="row1756854541084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1659765962084831"><a name="p1659765962084831"></a><a name="p1659765962084831"></a><a href="UTILS.md#ga7dd33d4d7fdd2221a03ce948d7419424">ARG_MAX</a>&nbsp;&nbsp;&nbsp;4096</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1146523779084831"><a name="p1146523779084831"></a><a name="p1146523779084831"></a>Maximum length of parameter arg. </p>
</td>
</tr>
<tr id="row1831029222084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1166836599084831"><a name="p1166836599084831"></a><a name="p1166836599084831"></a><a href="UTILS.md#ga25080e819a36fcf9aede01a6e7298ea4">IOV_MAX</a>&nbsp;&nbsp;&nbsp;1024</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1401237662084831"><a name="p1401237662084831"></a><a name="p1401237662084831"></a>Maximum vector number. </p>
</td>
</tr>
<tr id="row235926430084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1560386260084831"><a name="p1560386260084831"></a><a name="p1560386260084831"></a><a href="UTILS.md#gaf95e2cdeed2bb68c59e2c3d07b6c3d04">WORD_BIT</a>&nbsp;&nbsp;&nbsp;32</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1016822995084831"><a name="p1016822995084831"></a><a name="p1016822995084831"></a>Number of bits in word. </p>
</td>
</tr>
<tr id="row1848432812084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1700743298084831"><a name="p1700743298084831"></a><a name="p1700743298084831"></a><a href="UTILS.md#ga2d6569aa794c2f23e90691e60d2f3ad2">SSIZE_MAX</a>&nbsp;&nbsp;&nbsp;<a href="UTILS.md#ga50fece4db74f09568b2938db583c5655">LONG_MAX</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p116289855084831"><a name="p116289855084831"></a><a name="p116289855084831"></a>Maximum value of type ssize_t. </p>
</td>
</tr>
<tr id="row1618136226084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p488847021084831"><a name="p488847021084831"></a><a name="p488847021084831"></a><a href="UTILS.md#gac956117a90023ec0971b8f9fce9dec75">HOST_NAME_MAX</a>&nbsp;&nbsp;&nbsp;255</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p313509289084831"><a name="p313509289084831"></a><a name="p313509289084831"></a>Maximum length of host name. </p>
</td>
</tr>
<tr id="row220817715084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p588774167084831"><a name="p588774167084831"></a><a name="p588774167084831"></a><a href="UTILS.md#ga88c78a5170af546a3417d28875fd3710">LONG_BIT</a>&nbsp;&nbsp;&nbsp;32</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1971058799084831"><a name="p1971058799084831"></a><a name="p1971058799084831"></a>Number of bits in long. </p>
</td>
</tr>
<tr id="row1229429176084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p84414362084831"><a name="p84414362084831"></a><a name="p84414362084831"></a><a href="UTILS.md#gad1516b4f64b6dc890b1fa3bf576bfef9">MQ_PRIO_MAX</a>&nbsp;&nbsp;&nbsp;1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p951261657084831"><a name="p951261657084831"></a><a name="p951261657084831"></a>Maximum priority number of message queue. </p>
</td>
</tr>
<tr id="row1188433868084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1399773653084831"><a name="p1399773653084831"></a><a name="p1399773653084831"></a><a href="UTILS.md#ga519adc2af3ba06a8f0548b6690050a89">PAGESIZE</a>&nbsp;&nbsp;&nbsp;4096</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p488146784084831"><a name="p488146784084831"></a><a name="p488146784084831"></a>Page size. </p>
</td>
</tr>
<tr id="row1125852428084831"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p679328731084831"><a name="p679328731084831"></a><a name="p679328731084831"></a><a href="UTILS.md#ga7d467c1d283fdfa1f2081ba1e0d01b6e">PAGE_SIZE</a>&nbsp;&nbsp;&nbsp;<a href="UTILS.md#ga519adc2af3ba06a8f0548b6690050a89">PAGESIZE</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p104514525084831"><a name="p104514525084831"></a><a name="p104514525084831"></a>Page size. </p>
</td>
</tr>
</tbody>
</table>

