# TIME<a name="ZH-CN_TOPIC_0000001055108017"></a>

## **Overview**<a name="section1963592394084824"></a>

Provides time-related structures and functions. 

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section1134973493084824"></a>

## Files<a name="files"></a>

<a name="table1430885252084824"></a>
<table><thead align="left"><tr id="row1956202761084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p24062584084824"><a name="p24062584084824"></a><a name="p24062584084824"></a>File Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p578285269084824"><a name="p578285269084824"></a><a name="p578285269084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row445786774084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1142839755084824"><a name="p1142839755084824"></a><a name="p1142839755084824"></a><a href="timeb-h.md">timeb.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1299931879084824"><a name="p1299931879084824"></a><a name="p1299931879084824"></a>Provides structures and functions related to the curren time. </p>
</td>
</tr>
<tr id="row741586892084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p740335806084824"><a name="p740335806084824"></a><a name="p740335806084824"></a><a href="times-h.md">times.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p318055498084824"><a name="p318055498084824"></a><a name="p318055498084824"></a>Provides structures and functions related to the process time. </p>
</td>
</tr>
<tr id="row1101942203084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p192688487084824"><a name="p192688487084824"></a><a name="p192688487084824"></a><a href="time-h-0.md">time.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p603138412084824"><a name="p603138412084824"></a><a name="p603138412084824"></a>Provides time-related structures and functions. </p>
</td>
</tr>
</tbody>
</table>

## Data Structures<a name="nested-classes"></a>

<a name="table794735236084824"></a>
<table><thead align="left"><tr id="row195328430084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p313841845084824"><a name="p313841845084824"></a><a name="p313841845084824"></a>Data Structure Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1662164947084824"><a name="p1662164947084824"></a><a name="p1662164947084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1956127554084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1756110899084824"><a name="p1756110899084824"></a><a name="p1756110899084824"></a><a href="timeb.md">timeb</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1070030332084824"><a name="p1070030332084824"></a><a name="p1070030332084824"></a>Describes the time, accurate to millisecond. </p>
</td>
</tr>
<tr id="row929932386084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p511358089084824"><a name="p511358089084824"></a><a name="p511358089084824"></a><a href="tms.md">tms</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1231939079084824"><a name="p1231939079084824"></a><a name="p1231939079084824"></a>Describes CPU time of a process and its child processes. </p>
</td>
</tr>
<tr id="row875073610084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1456406017084824"><a name="p1456406017084824"></a><a name="p1456406017084824"></a><a href="tm.md">tm</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p264519185084824"><a name="p264519185084824"></a><a name="p264519185084824"></a>Describes date and time information. </p>
</td>
</tr>
<tr id="row753725039084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1942334280084824"><a name="p1942334280084824"></a><a name="p1942334280084824"></a><a href="itimerspec.md">itimerspec</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1366894308084824"><a name="p1366894308084824"></a><a name="p1366894308084824"></a>Sets a timer. </p>
</td>
</tr>
</tbody>
</table>

## Macros<a name="define-members"></a>

<a name="table1664705734084824"></a>
<table><thead align="left"><tr id="row805006272084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1464616077084824"><a name="p1464616077084824"></a><a name="p1464616077084824"></a>Macro Name and Value</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1388684032084824"><a name="p1388684032084824"></a><a name="p1388684032084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row490620770084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1120625897084824"><a name="p1120625897084824"></a><a name="p1120625897084824"></a><a href="TIME.md#ga922ce1ae64374c9410c8a999e25e82af">CLOCK_REALTIME</a>&nbsp;&nbsp;&nbsp;0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p506624278084824"><a name="p506624278084824"></a><a name="p506624278084824"></a>Defines the clock that runs in real time. </p>
</td>
</tr>
</tbody>
</table>

## Functions<a name="func-members"></a>

<a name="table1653361904084824"></a>
<table><thead align="left"><tr id="row296114552084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p741586886084824"><a name="p741586886084824"></a><a name="p741586886084824"></a>Function Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1946666447084824"><a name="p1946666447084824"></a><a name="p1946666447084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row299436112084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1083348945084824"><a name="p1083348945084824"></a><a name="p1083348945084824"></a><a href="TIME.md#gad225ab16a149ff9aab8fb5c36f29ca0c">ftime</a> (struct <a href="timeb.md">timeb</a> *tp)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1945568650084824"><a name="p1945568650084824"></a><a name="p1945568650084824"></a>int&nbsp;</p>
<p id="p234549100084824"><a name="p234549100084824"></a><a name="p234549100084824"></a>Obtains the current time, accurate to milliseconds. </p>
</td>
</tr>
<tr id="row69155440084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p840493204084824"><a name="p840493204084824"></a><a name="p840493204084824"></a><a href="TIME.md#gad8751576e987b576f4e6e42f9b42fec9">times</a> (struct <a href="tms.md">tms</a> *<a href="tm.md">tm</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1847275027084824"><a name="p1847275027084824"></a><a name="p1847275027084824"></a>clock_t&nbsp;</p>
<p id="p1838484573084824"><a name="p1838484573084824"></a><a name="p1838484573084824"></a>Obtains the number of clock ticks of the current process. </p>
</td>
</tr>
<tr id="row459836500084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2035504497084824"><a name="p2035504497084824"></a><a name="p2035504497084824"></a><a href="TIME.md#gae7841e681c8c9d59818568d39553642c">time</a> (time_t *t)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1539033673084824"><a name="p1539033673084824"></a><a name="p1539033673084824"></a>time_t&nbsp;</p>
<p id="p29743952084824"><a name="p29743952084824"></a><a name="p29743952084824"></a>Obtains the time. </p>
</td>
</tr>
<tr id="row876660525084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1688139856084824"><a name="p1688139856084824"></a><a name="p1688139856084824"></a><a href="TIME.md#ga1901c00eb89e8e35ea193c6a4676679c">difftime</a> (time_t time1, time_t time2)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p510259661084824"><a name="p510259661084824"></a><a name="p510259661084824"></a>double&nbsp;</p>
<p id="p1849009203084824"><a name="p1849009203084824"></a><a name="p1849009203084824"></a>Calculates the difference between two times, in seconds. </p>
</td>
</tr>
<tr id="row2023762860084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p164423930084824"><a name="p164423930084824"></a><a name="p164423930084824"></a><a href="TIME.md#gafc0e3f373a3ea00b37714f1b621ae0b1">mktime</a> (struct <a href="tm.md">tm</a> *<a href="tm.md">tm</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p432143522084824"><a name="p432143522084824"></a><a name="p432143522084824"></a>time_t&nbsp;</p>
<p id="p825527269084824"><a name="p825527269084824"></a><a name="p825527269084824"></a>Converts the broken-down time in the <a href="tm.md">tm</a> structure into seconds. </p>
</td>
</tr>
<tr id="row861780986084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p581696101084824"><a name="p581696101084824"></a><a name="p581696101084824"></a><a href="TIME.md#gab94643a711fc91727b668553d4a8806b">strftime</a> (char *restrict s, size_t n, const char *restrict f, const struct <a href="tm.md">tm</a> *restrict <a href="tm.md">tm</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1124569523084824"><a name="p1124569523084824"></a><a name="p1124569523084824"></a>size_t&nbsp;</p>
<p id="p256448792084824"><a name="p256448792084824"></a><a name="p256448792084824"></a>Converts the broken-down time in the <a href="tm.md">tm</a> structure to a string in the required format. </p>
</td>
</tr>
<tr id="row41545271084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1853825315084824"><a name="p1853825315084824"></a><a name="p1853825315084824"></a><a href="TIME.md#ga30d9732f32117a94652e28512905bfb9">gmtime</a> (const time_t *t)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1574259403084824"><a name="p1574259403084824"></a><a name="p1574259403084824"></a>struct <a href="tm.md">tm</a> *&nbsp;</p>
<p id="p1765006668084824"><a name="p1765006668084824"></a><a name="p1765006668084824"></a>Converts the number of seconds to the UTC time in the <a href="tm.md">tm</a> structure. </p>
</td>
</tr>
<tr id="row1009144110084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2028460635084824"><a name="p2028460635084824"></a><a name="p2028460635084824"></a><a href="TIME.md#ga70311f8aa60fc5ebbd76c55ea10bc899">localtime</a> (const time_t *t)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p450165135084824"><a name="p450165135084824"></a><a name="p450165135084824"></a>struct <a href="tm.md">tm</a> *&nbsp;</p>
<p id="p481108148084824"><a name="p481108148084824"></a><a name="p481108148084824"></a>Converts the number of seconds to the local time in the <a href="tm.md">tm</a> structure. </p>
</td>
</tr>
<tr id="row1435861200084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p92870193084824"><a name="p92870193084824"></a><a name="p92870193084824"></a><a href="TIME.md#ga416a0a99a5bab4c030e93d21152727f4">asctime</a> (const struct <a href="tm.md">tm</a> *<a href="tm.md">tm</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1044131129084824"><a name="p1044131129084824"></a><a name="p1044131129084824"></a>char *&nbsp;</p>
<p id="p283443151084824"><a name="p283443151084824"></a><a name="p283443151084824"></a>Converts the broken-down time in the <a href="tm.md">tm</a> structure into a string. </p>
</td>
</tr>
<tr id="row2136287011084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p267700151084824"><a name="p267700151084824"></a><a name="p267700151084824"></a><a href="TIME.md#ga6e58d33339fabd469b2f4790b0f2b843">ctime</a> (const time_t *timep)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1303313673084824"><a name="p1303313673084824"></a><a name="p1303313673084824"></a>char *&nbsp;</p>
<p id="p384211503084824"><a name="p384211503084824"></a><a name="p384211503084824"></a>Converts the date and time into a string. </p>
</td>
</tr>
<tr id="row2096634855084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2096121103084824"><a name="p2096121103084824"></a><a name="p2096121103084824"></a><a href="TIME.md#ga74c011f36d0ad959f0312dec8a5c8dc8">strftime_l</a> (char *__restrict s, size_t n, const char *__restrict f, const struct <a href="tm.md">tm</a> *__restrict <a href="tm.md">tm</a>, locale_t loc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1389616232084824"><a name="p1389616232084824"></a><a name="p1389616232084824"></a>size_t&nbsp;</p>
<p id="p272011913084824"><a name="p272011913084824"></a><a name="p272011913084824"></a>Converts the broken-down time in the <a href="tm.md">tm</a> structure to a string in a specified programming language and format. </p>
</td>
</tr>
<tr id="row1951247045084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1091377841084824"><a name="p1091377841084824"></a><a name="p1091377841084824"></a><a href="TIME.md#ga91bb7adea9b0b36acde8dba3012c01a5">gmtime_r</a> (const time_t *__restrict t, struct <a href="tm.md">tm</a> *__restrict <a href="tm.md">tm</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1608911780084824"><a name="p1608911780084824"></a><a name="p1608911780084824"></a>struct <a href="tm.md">tm</a> *&nbsp;</p>
<p id="p865513991084824"><a name="p865513991084824"></a><a name="p865513991084824"></a>Converts the number of seconds to the UTC time in the <a href="tm.md">tm</a> structure. (This function is reentrant.) </p>
</td>
</tr>
<tr id="row381346796084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1616601940084824"><a name="p1616601940084824"></a><a name="p1616601940084824"></a><a href="TIME.md#gad8c4ed240ddbd645502ac2f0a306aee0">localtime_r</a> (const time_t *__restrict t, struct <a href="tm.md">tm</a> *__restrict <a href="tm.md">tm</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1123077195084824"><a name="p1123077195084824"></a><a name="p1123077195084824"></a>struct <a href="tm.md">tm</a> *&nbsp;</p>
<p id="p796793414084824"><a name="p796793414084824"></a><a name="p796793414084824"></a>Converts the number of seconds to the local time in the <a href="tm.md">tm</a> structure. (This function is reentrant.) </p>
</td>
</tr>
<tr id="row706643812084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p338102290084824"><a name="p338102290084824"></a><a name="p338102290084824"></a><a href="TIME.md#ga8eb1bca8a6fdc63173a83f1c8cb28e15">asctime_r</a> (const struct <a href="tm.md">tm</a> *__restrict <a href="tm.md">tm</a>, char *__restrict buf)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p672696159084824"><a name="p672696159084824"></a><a name="p672696159084824"></a>char *&nbsp;</p>
<p id="p1277888522084824"><a name="p1277888522084824"></a><a name="p1277888522084824"></a>Converts the broken-down time in the <a href="tm.md">tm</a> structure into a string. (This function is reentrant.) </p>
</td>
</tr>
<tr id="row538248687084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1317102665084824"><a name="p1317102665084824"></a><a name="p1317102665084824"></a><a href="TIME.md#gae6eed522503f70a5cf05be0be558b125">ctime_r</a> (const time_t *t, char *buf)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p297588832084824"><a name="p297588832084824"></a><a name="p297588832084824"></a>char *&nbsp;</p>
<p id="p1690829848084824"><a name="p1690829848084824"></a><a name="p1690829848084824"></a>Converts the date and time into a string. (This function is reentrant.) </p>
</td>
</tr>
<tr id="row153062675084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2079028617084824"><a name="p2079028617084824"></a><a name="p2079028617084824"></a><a href="TIME.md#gafbe0e411e8bf89275e7cd46d0aeedc4b">nanosleep</a> (const struct <a href="timespec.md">timespec</a> *tspec1, struct <a href="timespec.md">timespec</a> *tspec2)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p191093075084824"><a name="p191093075084824"></a><a name="p191093075084824"></a>int&nbsp;</p>
<p id="p1331993329084824"><a name="p1331993329084824"></a><a name="p1331993329084824"></a>Pauses the current thread until a specified time arrives. </p>
</td>
</tr>
<tr id="row998261267084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p241233790084824"><a name="p241233790084824"></a><a name="p241233790084824"></a><a href="TIME.md#ga822b364014350d2d70bbd0ccaab1f476">clock_getres</a> (clockid_t id, struct <a href="timespec.md">timespec</a> *tspec)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p946221888084824"><a name="p946221888084824"></a><a name="p946221888084824"></a>int&nbsp;</p>
<p id="p2042762716084824"><a name="p2042762716084824"></a><a name="p2042762716084824"></a>Obtains the precision of a clock. </p>
</td>
</tr>
<tr id="row584206928084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p6006201084824"><a name="p6006201084824"></a><a name="p6006201084824"></a><a href="TIME.md#ga28ec1219021575a4b9a7c502b2e9a72c">clock_gettime</a> (clockid_t id, struct <a href="timespec.md">timespec</a> *tspec)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1429682527084824"><a name="p1429682527084824"></a><a name="p1429682527084824"></a>int&nbsp;</p>
<p id="p982818200084824"><a name="p982818200084824"></a><a name="p982818200084824"></a>Obtains the time of a clock. </p>
</td>
</tr>
<tr id="row821391162084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1854981361084824"><a name="p1854981361084824"></a><a name="p1854981361084824"></a><a href="TIME.md#ga04dbb6f7216d70a1b206741564d4d0fb">clock_settime</a> (clockid_t id, const struct <a href="timespec.md">timespec</a> *tspec)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p296455209084824"><a name="p296455209084824"></a><a name="p296455209084824"></a>int&nbsp;</p>
<p id="p917702960084824"><a name="p917702960084824"></a><a name="p917702960084824"></a>Sets the time for a clock. </p>
</td>
</tr>
<tr id="row1121347051084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p459278414084824"><a name="p459278414084824"></a><a name="p459278414084824"></a><a href="TIME.md#ga23d3356807a1cb25b5f64651c4aa7d33">clock_nanosleep</a> (clockid_t id, int flag, const struct <a href="timespec.md">timespec</a> *tspec1, struct <a href="timespec.md">timespec</a> *tspec2)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p710219732084824"><a name="p710219732084824"></a><a name="p710219732084824"></a>int&nbsp;</p>
<p id="p487482968084824"><a name="p487482968084824"></a><a name="p487482968084824"></a>Pauses the current thread until a specified time of a clock arrives. </p>
</td>
</tr>
<tr id="row1177780786084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p208100177084824"><a name="p208100177084824"></a><a name="p208100177084824"></a><a href="TIME.md#gaf7dce9c851a2e1a65aaf818b95487431">timer_create</a> (clockid_t id, struct <a href="sigevent.md">sigevent</a> *__restrict evp, timer_t *__restrict t)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1218085728084824"><a name="p1218085728084824"></a><a name="p1218085728084824"></a>int&nbsp;</p>
<p id="p324091979084824"><a name="p324091979084824"></a><a name="p324091979084824"></a>Creates a timer for the process. </p>
</td>
</tr>
<tr id="row927421522084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1780827496084824"><a name="p1780827496084824"></a><a name="p1780827496084824"></a><a href="TIME.md#ga61fa078bdadbd957cfcdfb12d0592ac1">timer_delete</a> (timer_t t)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p115914142084824"><a name="p115914142084824"></a><a name="p115914142084824"></a>int&nbsp;</p>
<p id="p1069693913084824"><a name="p1069693913084824"></a><a name="p1069693913084824"></a>Deletes a timer for the process. </p>
</td>
</tr>
<tr id="row1792306420084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1164704485084824"><a name="p1164704485084824"></a><a name="p1164704485084824"></a><a href="TIME.md#gade973e87fffe05aed7f1e97c1d15178e">timer_settime</a> (timer_t t, int flags, const struct <a href="itimerspec.md">itimerspec</a> *__restrict val, struct <a href="itimerspec.md">itimerspec</a> *__restrict old)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p833566244084824"><a name="p833566244084824"></a><a name="p833566244084824"></a>int&nbsp;</p>
<p id="p863854381084824"><a name="p863854381084824"></a><a name="p863854381084824"></a>Sets a timer for the process. </p>
</td>
</tr>
<tr id="row37485257084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p969396516084824"><a name="p969396516084824"></a><a name="p969396516084824"></a><a href="TIME.md#ga8f65c6a88588c951e0b11629e56714a4">timer_gettime</a> (timer_t t, struct <a href="itimerspec.md">itimerspec</a> *tspec)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1618237282084824"><a name="p1618237282084824"></a><a name="p1618237282084824"></a>int&nbsp;</p>
<p id="p1918450800084824"><a name="p1918450800084824"></a><a name="p1918450800084824"></a>Obtains a timer of the process. </p>
</td>
</tr>
<tr id="row604271149084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1910570605084824"><a name="p1910570605084824"></a><a name="p1910570605084824"></a><a href="TIME.md#ga6ecdedfd7f417a3d93aa7a18ff0ac582">timer_getoverrun</a> (timer_t t)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p54176839084824"><a name="p54176839084824"></a><a name="p54176839084824"></a>int&nbsp;</p>
<p id="p426754293084824"><a name="p426754293084824"></a><a name="p426754293084824"></a>Obtains the number of times that a timer overruns. </p>
</td>
</tr>
<tr id="row1938751289084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1020158066084824"><a name="p1020158066084824"></a><a name="p1020158066084824"></a><a href="TIME.md#ga8454b83c5b4fb93a9dcdd72ab586de22">strptime</a> (const char *s, const char *format, struct <a href="tm.md">tm</a> *<a href="tm.md">tm</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1139556586084824"><a name="p1139556586084824"></a><a name="p1139556586084824"></a>char *&nbsp;</p>
<p id="p1648904919084824"><a name="p1648904919084824"></a><a name="p1648904919084824"></a>Converts a time string to the broken-down time in the <a href="tm.md">tm</a> structure. </p>
</td>
</tr>
<tr id="row1019622074084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1264391982084824"><a name="p1264391982084824"></a><a name="p1264391982084824"></a><a href="TIME.md#gae85b268128fa533b20949464ce34165a">getdate</a> (const char *buf)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1174037081084824"><a name="p1174037081084824"></a><a name="p1174037081084824"></a>struct <a href="tm.md">tm</a> *&nbsp;</p>
<p id="p1308773743084824"><a name="p1308773743084824"></a><a name="p1308773743084824"></a>Converts a time string to the broken-down time in the <a href="tm.md">tm</a> structure. </p>
</td>
</tr>
<tr id="row377935866084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1211243134084824"><a name="p1211243134084824"></a><a name="p1211243134084824"></a><a href="TIME.md#ga69f8377385b2eeee376712dc9f0e3f71">stime</a> (const time_t *t)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1158779036084824"><a name="p1158779036084824"></a><a name="p1158779036084824"></a>int&nbsp;</p>
<p id="p699719208084824"><a name="p699719208084824"></a><a name="p699719208084824"></a>Sets the system time. </p>
</td>
</tr>
<tr id="row1065525497084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p859523838084824"><a name="p859523838084824"></a><a name="p859523838084824"></a><a href="TIME.md#ga4fd5240e99b2a9bf19bc0fe39f6ffc07">timegm</a> (struct <a href="tm.md">tm</a> *<a href="tm.md">tm</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p549035280084824"><a name="p549035280084824"></a><a name="p549035280084824"></a>time_t&nbsp;</p>
<p id="p1357702145084824"><a name="p1357702145084824"></a><a name="p1357702145084824"></a>Converts the broken-down time in the <a href="tm.md">tm</a> structure to the number of seconds. </p>
</td>
</tr>
</tbody>
</table>

## **Details**<a name="section2034713759084824"></a>

## **Macro Definition Documentation**<a name="section1865492094084824"></a>

## CLOCK\_REALTIME<a name="ga922ce1ae64374c9410c8a999e25e82af"></a>

```
#define CLOCK_REALTIME   0
```

 **Description:**

Defines the clock that runs in real time. 

## **Function Documentation**<a name="section1842247522084824"></a>

## asctime\(\)<a name="ga416a0a99a5bab4c030e93d21152727f4"></a>

```
char* asctime (const struct [tm](tm.md) * tm)
```

 **Description:**

Converts the broken-down time in the  [tm](tm.md)  structure into a string. 

**Parameters:**

<a name="table1782311988084824"></a>
<table><thead align="left"><tr id="row1474021809084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1553766021084824"><a name="p1553766021084824"></a><a name="p1553766021084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p357576004084824"><a name="p357576004084824"></a><a name="p357576004084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1515436945084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tm</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the broken-down time in the <a href="tm.md">tm</a> structure. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the string in the format of  **week month day hour:minute:second year**, for example,  **Thu Jan 1 08:00:00 1970**. If the conversion fails, the program ends. 



## asctime\_r\(\)<a name="ga8eb1bca8a6fdc63173a83f1c8cb28e15"></a>

```
char* asctime_r (const struct [tm](tm.md) *__restrict tm, char *__restrict buf )
```

 **Description:**

Converts the broken-down time in the  [tm](tm.md)  structure into a string. \(This function is reentrant.\) 

**Parameters:**

<a name="table119011330084824"></a>
<table><thead align="left"><tr id="row1775218222084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p680347180084824"><a name="p680347180084824"></a><a name="p680347180084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1730760825084824"><a name="p1730760825084824"></a><a name="p1730760825084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1648621247084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tm</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the broken-down time in the <a href="tm.md">tm</a> structure. </td>
</tr>
<tr id="row319520549084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the buffer for storing the string. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the string in the format of  **week month day hour:minute:second year**, for example,  **Thu Jan 1 08:00:00 1970**. If the conversion fails, the program ends. 



## clock\_getres\(\)<a name="ga822b364014350d2d70bbd0ccaab1f476"></a>

```
int clock_getres (clockid_t id, struct [timespec](timespec.md) * tspec )
```

 **Description:**

Obtains the precision of a clock. 

**Parameters:**

<a name="table1720919659084824"></a>
<table><thead align="left"><tr id="row453109487084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1582271739084824"><a name="p1582271739084824"></a><a name="p1582271739084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p468877326084824"><a name="p468877326084824"></a><a name="p468877326084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row942570301084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the clock ID. Currently, the following values are supported: <strong id="b1008945661084824"><a name="b1008945661084824"></a><a name="b1008945661084824"></a>CLOCK_REALTIME</strong>, <strong id="b113226679084824"><a name="b113226679084824"></a><a name="b113226679084824"></a>CLOCK_REALTIME_COARSE</strong>, <strong id="b2132996037084824"><a name="b2132996037084824"></a><a name="b2132996037084824"></a>CLOCK_MONOTONIC</strong>, <strong id="b1904480821084824"><a name="b1904480821084824"></a><a name="b1904480821084824"></a>CLOCK_MONOTONIC_COARSE</strong>, and <strong id="b1855533061084824"><a name="b1855533061084824"></a><a name="b1855533061084824"></a>CLOCK_MONOTONIC_RAW</strong>. </td>
</tr>
<tr id="row162141620084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tspec</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the data obtained. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  otherwise. 



## clock\_gettime\(\)<a name="ga28ec1219021575a4b9a7c502b2e9a72c"></a>

```
int clock_gettime (clockid_t id, struct [timespec](timespec.md) * tspec )
```

 **Description:**

Obtains the time of a clock. 

**Parameters:**

<a name="table1978554922084824"></a>
<table><thead align="left"><tr id="row1761874866084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p550415153084824"><a name="p550415153084824"></a><a name="p550415153084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1545338037084824"><a name="p1545338037084824"></a><a name="p1545338037084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1086371715084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the clock ID. Currently, the following values are supported: <strong id="b2004028750084824"><a name="b2004028750084824"></a><a name="b2004028750084824"></a>CLOCK_REALTIME</strong>, <strong id="b234638569084824"><a name="b234638569084824"></a><a name="b234638569084824"></a>CLOCK_REALTIME_COARSE</strong>, <strong id="b256981212084824"><a name="b256981212084824"></a><a name="b256981212084824"></a>CLOCK_MONOTONIC</strong>, <strong id="b1027051678084824"><a name="b1027051678084824"></a><a name="b1027051678084824"></a>CLOCK_MONOTONIC_COARSE</strong>, and <strong id="b437656747084824"><a name="b437656747084824"></a><a name="b437656747084824"></a>CLOCK_MONOTONIC_RAW</strong>. </td>
</tr>
<tr id="row621983497084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tspec</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the time obtained. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table141326272084824"></a>
<table><thead align="left"><tr id="row1674684007084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p588381648084824"><a name="p588381648084824"></a><a name="p588381648084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p951223188084824"><a name="p951223188084824"></a><a name="p951223188084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row429390956084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p693750282084824"><a name="p693750282084824"></a><a name="p693750282084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p15838337084824"><a name="p15838337084824"></a><a name="p15838337084824"></a>Invalid input. </p>
</td>
</tr>
</tbody>
</table>

## clock\_nanosleep\(\)<a name="ga23d3356807a1cb25b5f64651c4aa7d33"></a>

```
int clock_nanosleep (clockid_t id, int flag, const struct [timespec](timespec.md) * tspec1, struct [timespec](timespec.md) * tspec2 )
```

 **Description:**

Pauses the current thread until a specified time of a clock arrives. 

A sleeping thread cannot be woken up by a signal. 

**Parameters:**

<a name="table800532873084824"></a>
<table><thead align="left"><tr id="row2065323852084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p999469256084824"><a name="p999469256084824"></a><a name="p999469256084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p252646322084824"><a name="p252646322084824"></a><a name="p252646322084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1142740912084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the clock ID. Only <strong id="b533660231084824"><a name="b533660231084824"></a><a name="b533660231084824"></a>CLOCK_REALTIME</strong> is supported. </td>
</tr>
<tr id="row340025240084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">flag</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the clock type. This parameter must be set to <strong id="b1684169121084824"><a name="b1684169121084824"></a><a name="b1684169121084824"></a>0</strong> </td>
</tr>
<tr id="row2014264677084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tspec1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the minimum duration that the current thread is paused. Currently, the unit of precision is tick, and the discrepancy is fewer than 2 ticks. </td>
</tr>
<tr id="row1472668020084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tspec2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">This parameter is not used yet. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1720461105084824"></a>
<table><thead align="left"><tr id="row635463337084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1949755893084824"><a name="p1949755893084824"></a><a name="p1949755893084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p911771422084824"><a name="p911771422084824"></a><a name="p911771422084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1277934549084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1592797758084824"><a name="p1592797758084824"></a><a name="p1592797758084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1755826170084824"><a name="p1755826170084824"></a><a name="p1755826170084824"></a>Invalid input. </p>
</td>
</tr>
</tbody>
</table>

## clock\_settime\(\)<a name="ga04dbb6f7216d70a1b206741564d4d0fb"></a>

```
int clock_settime (clockid_t id, const struct [timespec](timespec.md) * tspec )
```

 **Description:**

Sets the time for a clock. 

**Parameters:**

<a name="table1766100570084824"></a>
<table><thead align="left"><tr id="row1486265444084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p137629464084824"><a name="p137629464084824"></a><a name="p137629464084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1595321601084824"><a name="p1595321601084824"></a><a name="p1595321601084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1439833358084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the clock ID. Only <strong id="b1662647373084824"><a name="b1662647373084824"></a><a name="b1662647373084824"></a>CLOCK_REALTIME</strong> is supported. </td>
</tr>
<tr id="row1570572574084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tspec</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the time to set. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table412854725084824"></a>
<table><thead align="left"><tr id="row721533086084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1722908803084824"><a name="p1722908803084824"></a><a name="p1722908803084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p314517411084824"><a name="p314517411084824"></a><a name="p314517411084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1119284190084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1358994608084824"><a name="p1358994608084824"></a><a name="p1358994608084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1720404872084824"><a name="p1720404872084824"></a><a name="p1720404872084824"></a>Invalid input. </p>
</td>
</tr>
</tbody>
</table>

## ctime\(\)<a name="ga6e58d33339fabd469b2f4790b0f2b843"></a>

```
char* ctime (const time_t * timep)
```

 **Description:**

Converts the date and time into a string. 

**Parameters:**

<a name="table98006003084824"></a>
<table><thead align="left"><tr id="row1032462746084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2104448808084824"><a name="p2104448808084824"></a><a name="p2104448808084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1080368817084824"><a name="p1080368817084824"></a><a name="p1080368817084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2029526972084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">timep</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of seconds to convert. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the string in the format of  **week month day hour:minute:second year**, for example,  **Thu Jan 1 08:00:00 1970**. If the conversion fails, the program ends. 



## ctime\_r\(\)<a name="gae6eed522503f70a5cf05be0be558b125"></a>

```
char* ctime_r (const time_t * t, char * buf )
```

 **Description:**

Converts the date and time into a string. \(This function is reentrant.\) 

**Parameters:**

<a name="table1577876969084824"></a>
<table><thead align="left"><tr id="row2123624509084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p653472835084824"><a name="p653472835084824"></a><a name="p653472835084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1160490097084824"><a name="p1160490097084824"></a><a name="p1160490097084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row56369098084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">t</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the number of seconds to convert. </td>
</tr>
<tr id="row1422181405084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the buffer for storing the string. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the string in the format of  **week month day hour:minute:second year**, for example,  **Thu Jan 1 08:00:00 1970**. If the conversion fails, the program ends. 



## difftime\(\)<a name="ga1901c00eb89e8e35ea193c6a4676679c"></a>

```
double difftime (time_t time1, time_t time2 )
```

 **Description:**

Calculates the difference between two times, in seconds. 

**Parameters:**

<a name="table1281035549084824"></a>
<table><thead align="left"><tr id="row419252678084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1910341813084824"><a name="p1910341813084824"></a><a name="p1910341813084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1975127418084824"><a name="p1975127418084824"></a><a name="p1975127418084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row337464071084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">time1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the first time. </td>
</tr>
<tr id="row1533716542084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">time2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the second time. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the difference, represented using a double. 



## ftime\(\)<a name="gad225ab16a149ff9aab8fb5c36f29ca0c"></a>

```
int ftime (struct [timeb](timeb.md) * tp)
```

 **Description:**

Obtains the current time, accurate to milliseconds. 

The time obtained is the total number of milliseconds elapsed since January 1, 1970 00:00:00 \(UTC\). 

**Parameters:**

<a name="table9333859084824"></a>
<table><thead align="left"><tr id="row1347907169084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1049541425084824"><a name="p1049541425084824"></a><a name="p1049541425084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p769850235084824"><a name="p769850235084824"></a><a name="p769850235084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2009144678084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the number of milliseconds. <strong id="b14560708084824"><a name="b14560708084824"></a><a name="b14560708084824"></a>timezone</strong> and <strong id="b1291294530084824"><a name="b1291294530084824"></a><a name="b1291294530084824"></a>dstflag</strong> are set to <strong id="b794909987084824"><a name="b794909987084824"></a><a name="b794909987084824"></a>0</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  otherwise. 



## getdate\(\)<a name="gae85b268128fa533b20949464ce34165a"></a>

```
struct [tm](tm.md)* getdate (const char * buf)
```

 **Description:**

Converts a time string to the broken-down time in the  [tm](tm.md)  structure. 

**Parameters:**

<a name="table164270560084824"></a>
<table><thead align="left"><tr id="row901574165084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p63777937084824"><a name="p63777937084824"></a><a name="p63777937084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p17629654084824"><a name="p17629654084824"></a><a name="p17629654084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1301854978084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">buf</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the time string. The format is specified by the file defined by the environment variable <strong id="b977758090084824"><a name="b977758090084824"></a><a name="b977758090084824"></a>DATEMSK</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the time in the  [tm](tm.md)  structure if the operation is successful; returns  **NULL**  otherwise. 



## gmtime\(\)<a name="ga30d9732f32117a94652e28512905bfb9"></a>

```
struct [tm](tm.md)* gmtime (const time_t * t)
```

 **Description:**

Converts the number of seconds to the UTC time in the  [tm](tm.md)  structure. 

**Parameters:**

<a name="table760344734084824"></a>
<table><thead align="left"><tr id="row1611764360084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p518691615084824"><a name="p518691615084824"></a><a name="p518691615084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1552610870084824"><a name="p1552610870084824"></a><a name="p1552610870084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row807701216084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">t</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the number of seconds to convert. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the UTC time in the  [tm](tm.md)  structure if the conversion is successful; returns  **NULL**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1700556573084824"></a>
<table><thead align="left"><tr id="row1922735748084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1713053456084824"><a name="p1713053456084824"></a><a name="p1713053456084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p815194376084824"><a name="p815194376084824"></a><a name="p815194376084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1849798829084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1000160065084824"><a name="p1000160065084824"></a><a name="p1000160065084824"></a>EOVERFLOW </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p906062871084824"><a name="p906062871084824"></a><a name="p906062871084824"></a>Inappropriate input parameter. </p>
</td>
</tr>
</tbody>
</table>

## gmtime\_r\(\)<a name="ga91bb7adea9b0b36acde8dba3012c01a5"></a>

```
struct [tm](tm.md)* gmtime_r (const time_t *__restrict t, struct [tm](tm.md) *__restrict tm )
```

 **Description:**

Converts the number of seconds to the UTC time in the  [tm](tm.md)  structure. \(This function is reentrant.\) 

This function is used in the multi-task environment. 

**Parameters:**

<a name="table305295913084824"></a>
<table><thead align="left"><tr id="row1474303808084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p673359540084824"><a name="p673359540084824"></a><a name="p673359540084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2001933819084824"><a name="p2001933819084824"></a><a name="p2001933819084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2005052228084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">t</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the number of seconds to convert. </td>
</tr>
<tr id="row247688222084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tm</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the <a href="tm.md">tm</a> structure. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the UTC time in the  [tm](tm.md)  structure if the conversion is successful; returns  **NULL**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1639747689084824"></a>
<table><thead align="left"><tr id="row1586163086084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1629182377084824"><a name="p1629182377084824"></a><a name="p1629182377084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1543769475084824"><a name="p1543769475084824"></a><a name="p1543769475084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row352878741084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1079086883084824"><a name="p1079086883084824"></a><a name="p1079086883084824"></a>EOVERFLOW </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p286424249084824"><a name="p286424249084824"></a><a name="p286424249084824"></a>Inappropriate input parameter. </p>
</td>
</tr>
</tbody>
</table>

## localtime\(\)<a name="ga70311f8aa60fc5ebbd76c55ea10bc899"></a>

```
struct [tm](tm.md)* localtime (const time_t * t)
```

 **Description:**

Converts the number of seconds to the local time in the  [tm](tm.md)  structure. 

**Parameters:**

<a name="table947666562084824"></a>
<table><thead align="left"><tr id="row46135604084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1784394570084824"><a name="p1784394570084824"></a><a name="p1784394570084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p685084798084824"><a name="p685084798084824"></a><a name="p685084798084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row991787589084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">t</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the number of seconds to convert. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the local time in the  [tm](tm.md)  structure if the conversion is successful; returns  **NULL**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1345630520084824"></a>
<table><thead align="left"><tr id="row859308198084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p418633328084824"><a name="p418633328084824"></a><a name="p418633328084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p224955645084824"><a name="p224955645084824"></a><a name="p224955645084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row150256310084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1043859034084824"><a name="p1043859034084824"></a><a name="p1043859034084824"></a>EOVERFLOW </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1606510239084824"><a name="p1606510239084824"></a><a name="p1606510239084824"></a>Inappropriate input parameter. </p>
</td>
</tr>
</tbody>
</table>

## localtime\_r\(\)<a name="gad8c4ed240ddbd645502ac2f0a306aee0"></a>

```
struct [tm](tm.md)* localtime_r (const time_t *__restrict t, struct [tm](tm.md) *__restrict tm )
```

 **Description:**

Converts the number of seconds to the local time in the  [tm](tm.md)  structure. \(This function is reentrant.\) 

**Parameters:**

<a name="table2047493595084824"></a>
<table><thead align="left"><tr id="row1733838264084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1411506994084824"><a name="p1411506994084824"></a><a name="p1411506994084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1172509644084824"><a name="p1172509644084824"></a><a name="p1172509644084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1019420237084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">t</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the number of seconds to convert. </td>
</tr>
<tr id="row1580730034084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tm</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the <a href="tm.md">tm</a> structure. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the local time in the  [tm](tm.md)  structure if the conversion is successful; returns  **NULL**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1419508540084824"></a>
<table><thead align="left"><tr id="row1615909047084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1240568037084824"><a name="p1240568037084824"></a><a name="p1240568037084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p593221267084824"><a name="p593221267084824"></a><a name="p593221267084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row489807387084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1183373813084824"><a name="p1183373813084824"></a><a name="p1183373813084824"></a>EOVERFLOW </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p318251634084824"><a name="p318251634084824"></a><a name="p318251634084824"></a>Inappropriate input parameter. </p>
</td>
</tr>
</tbody>
</table>

## mktime\(\)<a name="gafc0e3f373a3ea00b37714f1b621ae0b1"></a>

```
time_t mktime (struct [tm](tm.md) * tm)
```

 **Description:**

Converts the broken-down time in the  [tm](tm.md)  structure into seconds. 

**Parameters:**

<a name="table1264940189084824"></a>
<table><thead align="left"><tr id="row480799463084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p628414347084824"><a name="p628414347084824"></a><a name="p628414347084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p64327577084824"><a name="p64327577084824"></a><a name="p64327577084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1520211382084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tm</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the broken-down time in the <a href="tm.md">tm</a> structure. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the total number of seconds elapsed since January 1, 1970 00:00:00 \(UTC\) if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1352531717084824"></a>
<table><thead align="left"><tr id="row1644621419084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p638542759084824"><a name="p638542759084824"></a><a name="p638542759084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p376952940084824"><a name="p376952940084824"></a><a name="p376952940084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row414869882084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1066086800084824"><a name="p1066086800084824"></a><a name="p1066086800084824"></a>EOVERFLOW </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1719097007084824"><a name="p1719097007084824"></a><a name="p1719097007084824"></a>Inappropriate input parameter. </p>
</td>
</tr>
</tbody>
</table>

## nanosleep\(\)<a name="gafbe0e411e8bf89275e7cd46d0aeedc4b"></a>

```
int nanosleep (const struct [timespec](timespec.md) * tspec1, struct [timespec](timespec.md) * tspec2 )
```

 **Description:**

Pauses the current thread until a specified time arrives. 

A sleeping thread cannot be woken up by a signal. 

**Parameters:**

<a name="table231522884084824"></a>
<table><thead align="left"><tr id="row41265802084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p515082980084824"><a name="p515082980084824"></a><a name="p515082980084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2085928703084824"><a name="p2085928703084824"></a><a name="p2085928703084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row667452380084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tspec1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the minimum duration that the current thread is paused. Currently, the unit of precision is tick, and the discrepancy is fewer than 2 ticks. </td>
</tr>
<tr id="row79736159084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tspec2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">This parameter is not used yet. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table682762371084824"></a>
<table><thead align="left"><tr id="row745975800084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p636402160084824"><a name="p636402160084824"></a><a name="p636402160084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p486285252084824"><a name="p486285252084824"></a><a name="p486285252084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1449930910084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p245346300084824"><a name="p245346300084824"></a><a name="p245346300084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1402515886084824"><a name="p1402515886084824"></a><a name="p1402515886084824"></a>Invalid input. </p>
</td>
</tr>
</tbody>
</table>

## stime\(\)<a name="ga69f8377385b2eeee376712dc9f0e3f71"></a>

```
int stime (const time_t * t)
```

 **Description:**

Sets the system time. 

**Parameters:**

<a name="table1691110862084824"></a>
<table><thead align="left"><tr id="row1960905160084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p776341357084824"><a name="p776341357084824"></a><a name="p776341357084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p202048871084824"><a name="p202048871084824"></a><a name="p202048871084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1911478839084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">t</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the number of seconds to set. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1250425617084824"></a>
<table><thead align="left"><tr id="row1894422445084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p697339315084824"><a name="p697339315084824"></a><a name="p697339315084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p3578348084824"><a name="p3578348084824"></a><a name="p3578348084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row350097398084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1054991415084824"><a name="p1054991415084824"></a><a name="p1054991415084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2068546773084824"><a name="p2068546773084824"></a><a name="p2068546773084824"></a>Invalid input. </p>
</td>
</tr>
</tbody>
</table>

## strftime\(\)<a name="gab94643a711fc91727b668553d4a8806b"></a>

```
size_t strftime (char *restrict s, size_t n, const char *restrict f, const struct [tm](tm.md) *restrict tm )
```

 **Description:**

Converts the broken-down time in the  [tm](tm.md)  structure to a string in the required format. 

**Parameters:**

<a name="table744848242084824"></a>
<table><thead align="left"><tr id="row1349078277084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p541922491084824"><a name="p541922491084824"></a><a name="p541922491084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p594984720084824"><a name="p594984720084824"></a><a name="p594984720084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row719115599084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string. </td>
</tr>
<tr id="row751106218084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the buffer for storing the string. </td>
</tr>
<tr id="row457374004084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">f</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the required format. </td>
</tr>
<tr id="row644536907084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tm</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the broken-down time in the <a href="tm.md">tm</a> structure. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of bytes in the string if the conversion is successful; returns  **0**  otherwise. 



## strftime\_l\(\)<a name="ga74c011f36d0ad959f0312dec8a5c8dc8"></a>

```
size_t strftime_l (char *__restrict s, size_t n, const char *__restrict f, const struct [tm](tm.md) *__restrict tm, locale_t loc )
```

 **Description:**

Converts the broken-down time in the  [tm](tm.md)  structure to a string in a specified programming language and format. 

**Parameters:**

<a name="table1297210038084824"></a>
<table><thead align="left"><tr id="row69928697084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1622913730084824"><a name="p1622913730084824"></a><a name="p1622913730084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1037289135084824"><a name="p1037289135084824"></a><a name="p1037289135084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1525918357084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string. </td>
</tr>
<tr id="row1847451095084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">n</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the size of the buffer for storing the string. </td>
</tr>
<tr id="row1187989211084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">f</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the required format. </td>
</tr>
<tr id="row2020960284084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tm</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the broken-down time in the <a href="tm.md">tm</a> structure. </td>
</tr>
<tr id="row74053274084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">loc</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the required programming language. Currently, only C programming language is supported. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of bytes in the string if the conversion is successful; returns  **0**  otherwise. 



## strptime\(\)<a name="ga8454b83c5b4fb93a9dcdd72ab586de22"></a>

```
char* strptime (const char * s, const char * format, struct [tm](tm.md) * tm )
```

 **Description:**

Converts a time string to the broken-down time in the  [tm](tm.md)  structure. 

This function parses the input string  **s**  based on  **format**  and stores the result in the  [tm](tm.md)  structure. 

**Parameters:**

<a name="table81566254084824"></a>
<table><thead align="left"><tr id="row1427460928084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p53038060084824"><a name="p53038060084824"></a><a name="p53038060084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1398234533084824"><a name="p1398234533084824"></a><a name="p1398234533084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1674417344084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">s</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the string that contains only time data. </td>
</tr>
<tr id="row963474210084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">format</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the required format. </td>
</tr>
<tr id="row1689563434084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tm</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the <a href="tm.md">tm</a> structure. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the pointer to the position to which the string has been processed \(the next character to be processed\) upon the conversion completion if the operation is successful; returns  **NULL**  otherwise. 



## time\(\)<a name="gae7841e681c8c9d59818568d39553642c"></a>

```
time_t time (time_t * t)
```

 **Description:**

Obtains the time. 

The time obtained is the total number of seconds elapsed since January 1, 1970 00:00:00 \(UTC\). 

**Parameters:**

<a name="table739369056084824"></a>
<table><thead align="left"><tr id="row511678271084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2038335413084824"><a name="p2038335413084824"></a><a name="p2038335413084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1631405290084824"><a name="p1631405290084824"></a><a name="p1631405290084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row723464453084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">t</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the number of seconds. You can also pass <strong id="b336096209084824"><a name="b336096209084824"></a><a name="b336096209084824"></a>NULL</strong> to use the return value. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of seconds. 



## timegm\(\)<a name="ga4fd5240e99b2a9bf19bc0fe39f6ffc07"></a>

```
time_t timegm (struct [tm](tm.md) * tm)
```

 **Description:**

Converts the broken-down time in the  [tm](tm.md)  structure to the number of seconds. 

**Parameters:**

<a name="table98354316084824"></a>
<table><thead align="left"><tr id="row1327279521084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1829197831084824"><a name="p1829197831084824"></a><a name="p1829197831084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p115846578084824"><a name="p115846578084824"></a><a name="p115846578084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row626571214084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tm</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the broken-down time in the <a href="tm.md">tm</a> structure to convert. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of seconds if the operation is successful; returns  **NULL**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table928440767084824"></a>
<table><thead align="left"><tr id="row1483539985084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1329672606084824"><a name="p1329672606084824"></a><a name="p1329672606084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2060345085084824"><a name="p2060345085084824"></a><a name="p2060345085084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1645617064084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2090581659084824"><a name="p2090581659084824"></a><a name="p2090581659084824"></a>EOVERFLOW </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p228179249084824"><a name="p228179249084824"></a><a name="p228179249084824"></a>The input parameter is too long. </p>
</td>
</tr>
</tbody>
</table>

## timer\_create\(\)<a name="gaf7dce9c851a2e1a65aaf818b95487431"></a>

```
int timer_create (clockid_t id, struct [sigevent](sigevent.md) *__restrict evp, timer_t *__restrict t )
```

 **Description:**

Creates a timer for the process. 

**Parameters:**

<a name="table2063299715084824"></a>
<table><thead align="left"><tr id="row538833251084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2147358052084824"><a name="p2147358052084824"></a><a name="p2147358052084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1385671208084824"><a name="p1385671208084824"></a><a name="p1385671208084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1494676533084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the clock ID. Only <strong id="b1630244879084824"><a name="b1630244879084824"></a><a name="b1630244879084824"></a>CLOCK_REALTIME</strong> is supported. </td>
</tr>
<tr id="row1090731495084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">evp</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the asynchronous notification signal and action, which can be <strong id="b1134475901084824"><a name="b1134475901084824"></a><a name="b1134475901084824"></a>NULL</strong>. </td>
</tr>
<tr id="row1525391584084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">t</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the timer ID. </td>
</tr>
</tbody>
</table>

**Attention:**

**sigev\_notify**  in the  **sigevent**  structure must be  **SIGEV\_SIGNAL**. 

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table573020191084824"></a>
<table><thead align="left"><tr id="row912504685084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1735055245084824"><a name="p1735055245084824"></a><a name="p1735055245084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p502460157084824"><a name="p502460157084824"></a><a name="p502460157084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row520300495084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p356126472084824"><a name="p356126472084824"></a><a name="p356126472084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p528356441084824"><a name="p528356441084824"></a><a name="p528356441084824"></a>Invalid input. </p>
</td>
</tr>
<tr id="row154379208084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1758542270084824"><a name="p1758542270084824"></a><a name="p1758542270084824"></a>ENOTSUP </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2020534717084824"><a name="p2020534717084824"></a><a name="p2020534717084824"></a>The value of <strong id="b187316994084824"><a name="b187316994084824"></a><a name="b187316994084824"></a>evp</strong> is not <strong id="b1281017618084824"><a name="b1281017618084824"></a><a name="b1281017618084824"></a>NULL</strong> and <strong id="b2028358863084824"><a name="b2028358863084824"></a><a name="b2028358863084824"></a>sigev_notify</strong> is not <strong id="b1733559907084824"><a name="b1733559907084824"></a><a name="b1733559907084824"></a>SIGEV_SIGNAL</strong>. </p>
</td>
</tr>
</tbody>
</table>

## timer\_delete\(\)<a name="ga61fa078bdadbd957cfcdfb12d0592ac1"></a>

```
int timer_delete (timer_t t)
```

 **Description:**

Deletes a timer for the process. 

**Parameters:**

<a name="table1189383066084824"></a>
<table><thead align="left"><tr id="row989375457084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2037656503084824"><a name="p2037656503084824"></a><a name="p2037656503084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p214630718084824"><a name="p214630718084824"></a><a name="p214630718084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1801093536084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">t</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the ID of the timer to delete. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table660820168084824"></a>
<table><thead align="left"><tr id="row1698615934084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1506525518084824"><a name="p1506525518084824"></a><a name="p1506525518084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p317687638084824"><a name="p317687638084824"></a><a name="p317687638084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1914041592084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1190316271084824"><a name="p1190316271084824"></a><a name="p1190316271084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p547005466084824"><a name="p547005466084824"></a><a name="p547005466084824"></a>Invalid input. </p>
</td>
</tr>
</tbody>
</table>

## timer\_getoverrun\(\)<a name="ga6ecdedfd7f417a3d93aa7a18ff0ac582"></a>

```
int timer_getoverrun (timer_t t)
```

 **Description:**

Obtains the number of times that a timer overruns. 

**Parameters:**

<a name="table1493309515084824"></a>
<table><thead align="left"><tr id="row1782729332084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p407926896084824"><a name="p407926896084824"></a><a name="p407926896084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1637677682084824"><a name="p1637677682084824"></a><a name="p1637677682084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1297499565084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">t</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the ID of the timer to obtain. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of times if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table282359029084824"></a>
<table><thead align="left"><tr id="row504878084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p514138429084824"><a name="p514138429084824"></a><a name="p514138429084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1717006285084824"><a name="p1717006285084824"></a><a name="p1717006285084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row935659721084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1534810320084824"><a name="p1534810320084824"></a><a name="p1534810320084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1922046587084824"><a name="p1922046587084824"></a><a name="p1922046587084824"></a>Invalid input. </p>
</td>
</tr>
</tbody>
</table>

## timer\_gettime\(\)<a name="ga8f65c6a88588c951e0b11629e56714a4"></a>

```
int timer_gettime (timer_t t, struct [itimerspec](itimerspec.md) * tspec )
```

 **Description:**

Obtains a timer of the process. 

**Parameters:**

<a name="table1030936190084824"></a>
<table><thead align="left"><tr id="row2003396438084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1382186233084824"><a name="p1382186233084824"></a><a name="p1382186233084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1323684493084824"><a name="p1323684493084824"></a><a name="p1323684493084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1341440524084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">t</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the ID of the timer to obtain. </td>
</tr>
<tr id="row713836160084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tspec</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the timer duration and interval. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table259157848084824"></a>
<table><thead align="left"><tr id="row51551299084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p484313910084824"><a name="p484313910084824"></a><a name="p484313910084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p837583460084824"><a name="p837583460084824"></a><a name="p837583460084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1905339305084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1150952726084824"><a name="p1150952726084824"></a><a name="p1150952726084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p610193459084824"><a name="p610193459084824"></a><a name="p610193459084824"></a>Incorrect parameter or timer operation failure. </p>
</td>
</tr>
</tbody>
</table>

## timer\_settime\(\)<a name="gade973e87fffe05aed7f1e97c1d15178e"></a>

```
int timer_settime (timer_t t, int flags, const struct [itimerspec](itimerspec.md) *__restrict val, struct [itimerspec](itimerspec.md) *__restrict old )
```

 **Description:**

Sets a timer for the process. 

**Parameters:**

<a name="table927471398084824"></a>
<table><thead align="left"><tr id="row13170266084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1042149871084824"><a name="p1042149871084824"></a><a name="p1042149871084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p18079133084824"><a name="p18079133084824"></a><a name="p18079133084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2097477522084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">t</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the ID of the timer to set. </td>
</tr>
<tr id="row321241698084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">flags</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the type of the timer to set. This parameter is not supported and must be set to <strong id="b1855502929084824"><a name="b1855502929084824"></a><a name="b1855502929084824"></a>0</strong>. </td>
</tr>
<tr id="row1119969587084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">val</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the timer duration and interval to set. </td>
</tr>
<tr id="row1507821623084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">old</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the timer duration and interval before the current setting. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **0**  if the operation is successful; returns  **-1**  and sets  **errno**  to a value in the following table if the operation fails. 

<a name="table1250383309084824"></a>
<table><thead align="left"><tr id="row862315686084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1321825080084824"><a name="p1321825080084824"></a><a name="p1321825080084824"></a>errno </p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p236918888084824"><a name="p236918888084824"></a><a name="p236918888084824"></a>Description  </p>
</th>
</tr>
</thead>
<tbody><tr id="row1944729571084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1502072012084824"><a name="p1502072012084824"></a><a name="p1502072012084824"></a>ENOSYS </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1385524817084824"><a name="p1385524817084824"></a><a name="p1385524817084824"></a>The value of <strong id="b978715921084824"><a name="b978715921084824"></a><a name="b978715921084824"></a>flags</strong> is not <strong id="b2033271364084824"><a name="b2033271364084824"></a><a name="b2033271364084824"></a>0</strong>. </p>
</td>
</tr>
<tr id="row2054417286084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1473235050084824"><a name="p1473235050084824"></a><a name="p1473235050084824"></a>EINVAL </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p460742551084824"><a name="p460742551084824"></a><a name="p460742551084824"></a>Incorrect parameter or timer operation failure. </p>
</td>
</tr>
</tbody>
</table>

## times\(\)<a name="gad8751576e987b576f4e6e42f9b42fec9"></a>

```
clock_t times (struct [tms](tms.md) * tm)
```

 **Description:**

Obtains the number of clock ticks of the current process. 

**Parameters:**

<a name="table1937992612084824"></a>
<table><thead align="left"><tr id="row409631042084824"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1340136365084824"><a name="p1340136365084824"></a><a name="p1340136365084824"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1988264526084824"><a name="p1988264526084824"></a><a name="p1988264526084824"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row712434983084824"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">tm</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the <strong id="b1106031987084824"><a name="b1106031987084824"></a><a name="b1106031987084824"></a>tms</strong> structure that contains the clock ticks, which can be <strong id="b1077656110084824"><a name="b1077656110084824"></a><a name="b1077656110084824"></a>NULL</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the number of clock ticks of CPU 0. 



