# OHOS::UIToggleButton<a name="ZH-CN_TOPIC_0000001055198158"></a>

## **Overview**<a name="section322736251093535"></a>

**Related Modules:**

[Graphic](Graphic.md)

**Description:**

Represents a toggle button. 

Each toggle button contains two images, one for pressing and the other for releasing.

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section2000098105093535"></a>

## Public Member Functions<a name="pub-methods"></a>

<a name="table882072866093535"></a>
<table><thead align="left"><tr id="row270724363093535"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1057489158093535"><a name="p1057489158093535"></a><a name="p1057489158093535"></a>Public Member Function Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1317323060093535"><a name="p1317323060093535"></a><a name="p1317323060093535"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1506684856093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1609603651093535"><a name="p1609603651093535"></a><a name="p1609603651093535"></a><a href="Graphic.md#ga98d6bb49e21d7748020b75a9f5f1c61d">UIToggleButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1356143335093535"><a name="p1356143335093535"></a><a name="p1356143335093535"></a>&nbsp;</p>
<p id="p731668351093535"><a name="p731668351093535"></a><a name="p731668351093535"></a>A constructor used to create a <strong id="b891735685093535"><a name="b891735685093535"></a><a name="b891735685093535"></a><a href="OHOS-UIToggleButton.md">UIToggleButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row874566712093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p199470613093535"><a name="p199470613093535"></a><a name="p199470613093535"></a><a href="Graphic.md#ga4946fb71fed32a4f328ecdd1da3141c5">~UIToggleButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1146974444093535"><a name="p1146974444093535"></a><a name="p1146974444093535"></a>virtual&nbsp;</p>
<p id="p932787273093535"><a name="p932787273093535"></a><a name="p932787273093535"></a>A destructor used to delete the <strong id="b291077175093535"><a name="b291077175093535"></a><a name="b291077175093535"></a><a href="OHOS-UIToggleButton.md">UIToggleButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row1474057730093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p64776538093535"><a name="p64776538093535"></a><a name="p64776538093535"></a><a href="Graphic.md#gaeb2bf2bfa7b5f229a151bec4fd046b40">GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p814516042093535"><a name="p814516042093535"></a><a name="p814516042093535"></a>UIViewType&nbsp;</p>
<p id="p158183849093535"><a name="p158183849093535"></a><a name="p158183849093535"></a>Obtains the component type. </p>
</td>
</tr>
<tr id="row303901533093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p82495646093535"><a name="p82495646093535"></a><a name="p82495646093535"></a><a href="Graphic.md#ga73354e99d22f2fe8b44f1c11c8d62fd0">SetState</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2009806523093535"><a name="p2009806523093535"></a><a name="p2009806523093535"></a>void&nbsp;</p>
<p id="p1402092483093535"><a name="p1402092483093535"></a><a name="p1402092483093535"></a>Sets the state for this toggle button. </p>
</td>
</tr>
<tr id="row2786881093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1605966075093535"><a name="p1605966075093535"></a><a name="p1605966075093535"></a><a href="Graphic.md#gad46154853ea44173988a82fa366f16db">GetState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2085427709093535"><a name="p2085427709093535"></a><a name="p2085427709093535"></a>bool&nbsp;</p>
<p id="p2122274947093535"><a name="p2122274947093535"></a><a name="p2122274947093535"></a>Obtains the state of this toggle button. </p>
</td>
</tr>
<tr id="row979240176093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p107278738093535"><a name="p107278738093535"></a><a name="p107278738093535"></a><a href="Graphic.md#ga811085fbe237690f21a95e7df2a7c45f">UICheckBox</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p852648258093535"><a name="p852648258093535"></a><a name="p852648258093535"></a>&nbsp;</p>
<p id="p1727801762093535"><a name="p1727801762093535"></a><a name="p1727801762093535"></a>A constructor used to create a <strong id="b1140102184093535"><a name="b1140102184093535"></a><a name="b1140102184093535"></a><a href="OHOS-UICheckBox.md">UICheckBox</a></strong> instance. </p>
</td>
</tr>
<tr id="row1216320095093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2065527819093535"><a name="p2065527819093535"></a><a name="p2065527819093535"></a><a href="Graphic.md#ga061c90b24caa6595b70a9da9f96c5c4e">~UICheckBox</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1532392126093535"><a name="p1532392126093535"></a><a name="p1532392126093535"></a>virtual&nbsp;</p>
<p id="p830560698093535"><a name="p830560698093535"></a><a name="p830560698093535"></a>A destructor used to delete the <strong id="b628662801093535"><a name="b628662801093535"></a><a name="b628662801093535"></a><a href="OHOS-UICheckBox.md">UICheckBox</a></strong> instance. </p>
</td>
</tr>
<tr id="row181003931093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p261195048093535"><a name="p261195048093535"></a><a name="p261195048093535"></a><a href="Graphic.md#gad72c8f6a67fc3fb86da8eabffcf5315d">SetOnChangeListener</a> (<a href="OHOS-UICheckBox-OnChangeListener.md">OnChangeListener</a> *onStateChangeListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2141159943093535"><a name="p2141159943093535"></a><a name="p2141159943093535"></a>void&nbsp;</p>
<p id="p1333089632093535"><a name="p1333089632093535"></a><a name="p1333089632093535"></a>Sets the listener for this check box. </p>
</td>
</tr>
<tr id="row719078964093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1949664055093535"><a name="p1949664055093535"></a><a name="p1949664055093535"></a><a href="Graphic.md#ga53cc6c8f18b90c3abd96a791c8921010">OnPreDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1322928600093535"><a name="p1322928600093535"></a><a name="p1322928600093535"></a>bool&nbsp;</p>
<p id="p1463102740093535"><a name="p1463102740093535"></a><a name="p1463102740093535"></a>Do something before draw, this function will be invoked mainly to check if this view need to cover invalidate area so render manager can decide which layer to draw firstly. </p>
</td>
</tr>
<tr id="row1352265684093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1984394638093535"><a name="p1984394638093535"></a><a name="p1984394638093535"></a><a href="Graphic.md#ga8e75f8411fb25e564c82573a12773189">OnDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p780524129093535"><a name="p780524129093535"></a><a name="p780524129093535"></a>void&nbsp;</p>
<p id="p136300084093535"><a name="p136300084093535"></a><a name="p136300084093535"></a>Executes the draw action Ondraw invokes the rendering function provided by the underlying layer to draw pictures based on the selected status of the checkbox. </p>
</td>
</tr>
<tr id="row2056047518093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p751434350093535"><a name="p751434350093535"></a><a name="p751434350093535"></a><a href="Graphic.md#ga31d4f10f4c32b0fb284645450875ae0c">OnClickEvent</a> (const <a href="OHOS-ClickEvent.md">ClickEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1480781349093535"><a name="p1480781349093535"></a><a name="p1480781349093535"></a>void&nbsp;</p>
<p id="p29252302093535"><a name="p29252302093535"></a><a name="p29252302093535"></a>Executes the click event action OnClickEvent will reverse the selected state of checkbox. Example: If the check box is selected, the checkbox status is changed to Unselected after the click action is taken. </p>
</td>
</tr>
<tr id="row1095110618093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1212232740093535"><a name="p1212232740093535"></a><a name="p1212232740093535"></a><a href="Graphic.md#ga2e1ac9e3084d018febf5ac0912a27c72">SetImages</a> (const char *selectedImageSrc, const char *unselectedImageSrc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p909264033093535"><a name="p909264033093535"></a><a name="p909264033093535"></a>virtual void&nbsp;</p>
<p id="p621720031093535"><a name="p621720031093535"></a><a name="p621720031093535"></a>Sets the images for this check box. </p>
</td>
</tr>
<tr id="row486623474093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p489163114093535"><a name="p489163114093535"></a><a name="p489163114093535"></a><a href="Graphic.md#ga89eb87d02e7b31fc6517b8744751f021">SetImages</a> (const <a href="OHOS-ImageInfo.md">ImageInfo</a> *selectedImageSrc, const <a href="OHOS-ImageInfo.md">ImageInfo</a> *unselectedImageSrc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p590350927093535"><a name="p590350927093535"></a><a name="p590350927093535"></a>virtual void&nbsp;</p>
<p id="p1981676641093535"><a name="p1981676641093535"></a><a name="p1981676641093535"></a>Sets the images for this check box. </p>
</td>
</tr>
<tr id="row1916152752093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p573847817093535"><a name="p573847817093535"></a><a name="p573847817093535"></a><a href="Graphic.md#gab3cddc176a6834fabc7c53912c97237c">GetState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1368054109093535"><a name="p1368054109093535"></a><a name="p1368054109093535"></a><a href="Graphic.md#ga15a3f0302aded0e4d1584ddc6002335d">UICheckBoxState</a>&nbsp;</p>
<p id="p1439161102093535"><a name="p1439161102093535"></a><a name="p1439161102093535"></a>Obtains the state of this check box. </p>
</td>
</tr>
<tr id="row60378951093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1069269002093535"><a name="p1069269002093535"></a><a name="p1069269002093535"></a><a href="Graphic.md#ga32217050815d4d9129ace5ab410fb82d">SetState</a> (<a href="Graphic.md#ga15a3f0302aded0e4d1584ddc6002335d">UICheckBoxState</a> state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p964106486093535"><a name="p964106486093535"></a><a name="p964106486093535"></a>void&nbsp;</p>
<p id="p2007112453093535"><a name="p2007112453093535"></a><a name="p2007112453093535"></a>Sets the state for this check box. </p>
</td>
</tr>
<tr id="row1914292423093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1973523573093535"><a name="p1973523573093535"></a><a name="p1973523573093535"></a><a href="Graphic.md#ga7aad5b50d945efe5f9304bc978b2001c">UIView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1852811605093535"><a name="p1852811605093535"></a><a name="p1852811605093535"></a>&nbsp;</p>
<p id="p529394097093535"><a name="p529394097093535"></a><a name="p529394097093535"></a>A default constructor used to create an <strong id="b1670354069093535"><a name="b1670354069093535"></a><a name="b1670354069093535"></a><a href="OHOS-UIView.md">UIView</a></strong> instance. </p>
</td>
</tr>
<tr id="row666624898093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1376079019093535"><a name="p1376079019093535"></a><a name="p1376079019093535"></a><a href="Graphic.md#ga57d429bb1cd71782f3b825f1bc6b9362">UIView</a> (const char *id)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p783721683093535"><a name="p783721683093535"></a><a name="p783721683093535"></a>&nbsp;</p>
<p id="p1169663608093535"><a name="p1169663608093535"></a><a name="p1169663608093535"></a>A constructor used to create an <strong id="b977880209093535"><a name="b977880209093535"></a><a name="b977880209093535"></a><a href="OHOS-UIView.md">UIView</a></strong> instance. </p>
</td>
</tr>
<tr id="row963766800093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p646288729093535"><a name="p646288729093535"></a><a name="p646288729093535"></a><a href="Graphic.md#ga17f0ffc1090bdcce0f88288da5962012">~UIView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1983086285093535"><a name="p1983086285093535"></a><a name="p1983086285093535"></a>virtual&nbsp;</p>
<p id="p342373768093535"><a name="p342373768093535"></a><a name="p342373768093535"></a>A destructor used to delete the <strong id="b915032648093535"><a name="b915032648093535"></a><a name="b915032648093535"></a><a href="OHOS-UIView.md">UIView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1734767911093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1060735665093535"><a name="p1060735665093535"></a><a name="p1060735665093535"></a><a href="Graphic.md#gab70473cd0d8fe7c9d4bb817caeee9153">OnPostDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1625476919093535"><a name="p1625476919093535"></a><a name="p1625476919093535"></a>virtual void&nbsp;</p>
<p id="p1263238525093535"><a name="p1263238525093535"></a><a name="p1263238525093535"></a>Called after a view is drawn. </p>
</td>
</tr>
<tr id="row1135197807093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p6836117093535"><a name="p6836117093535"></a><a name="p6836117093535"></a><a href="Graphic.md#ga81726238adeda1efa989be6ed4f4fe5b">ReMeasure</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1639496110093535"><a name="p1639496110093535"></a><a name="p1639496110093535"></a>virtual void&nbsp;</p>
<p id="p1960936749093535"><a name="p1960936749093535"></a><a name="p1960936749093535"></a>Remeasures the view size. </p>
</td>
</tr>
<tr id="row1945781048093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1709743395093535"><a name="p1709743395093535"></a><a name="p1709743395093535"></a><a href="Graphic.md#ga2a9a38b8450fbb196277238a51fbbf99">Invalidate</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1777395592093535"><a name="p1777395592093535"></a><a name="p1777395592093535"></a>void&nbsp;</p>
<p id="p1654947121093535"><a name="p1654947121093535"></a><a name="p1654947121093535"></a>Refreshes the invalidated area of the view. </p>
</td>
</tr>
<tr id="row1288757749093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p943837800093535"><a name="p943837800093535"></a><a name="p943837800093535"></a><a href="Graphic.md#gaf0e6b65ced8b931642f2a80c195962d2">InvalidateRect</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p15081190093535"><a name="p15081190093535"></a><a name="p15081190093535"></a>void&nbsp;</p>
<p id="p1582380210093535"><a name="p1582380210093535"></a><a name="p1582380210093535"></a>Refreshes a view in a specified invalidated area. </p>
</td>
</tr>
<tr id="row243436230093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1798824834093535"><a name="p1798824834093535"></a><a name="p1798824834093535"></a><a href="Graphic.md#gac311aa47301d727c35fc31f8630d016e">OnLongPressEvent</a> (const <a href="OHOS-LongPressEvent.md">LongPressEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1739180002093535"><a name="p1739180002093535"></a><a name="p1739180002093535"></a>virtual bool&nbsp;</p>
<p id="p336464918093535"><a name="p336464918093535"></a><a name="p336464918093535"></a>Called when the view is long pressed. </p>
</td>
</tr>
<tr id="row1323293784093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1343109078093535"><a name="p1343109078093535"></a><a name="p1343109078093535"></a><a href="Graphic.md#gac0e10556ff99b8a92bfb11df6456d605">OnDragStartEvent</a> (const <a href="OHOS-DragEvent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p512494617093535"><a name="p512494617093535"></a><a name="p512494617093535"></a>virtual bool&nbsp;</p>
<p id="p1581140082093535"><a name="p1581140082093535"></a><a name="p1581140082093535"></a>Called when the view starts to drag. </p>
</td>
</tr>
<tr id="row1116539620093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1966682852093535"><a name="p1966682852093535"></a><a name="p1966682852093535"></a><a href="Graphic.md#ga46249c8caf06b81590d9450e30a31147">OnDragEvent</a> (const <a href="OHOS-DragEvent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p637444075093535"><a name="p637444075093535"></a><a name="p637444075093535"></a>virtual bool&nbsp;</p>
<p id="p912498698093535"><a name="p912498698093535"></a><a name="p912498698093535"></a>Called when the view is being dragged. </p>
</td>
</tr>
<tr id="row529630044093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p346145883093535"><a name="p346145883093535"></a><a name="p346145883093535"></a><a href="Graphic.md#ga1799d33be73f64ed2066f50d7e65468d">OnDragEndEvent</a> (const <a href="OHOS-DragEvent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p601293247093535"><a name="p601293247093535"></a><a name="p601293247093535"></a>virtual bool&nbsp;</p>
<p id="p1837804058093535"><a name="p1837804058093535"></a><a name="p1837804058093535"></a>Called when the view stops dragging. </p>
</td>
</tr>
<tr id="row592312939093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p483496806093535"><a name="p483496806093535"></a><a name="p483496806093535"></a><a href="Graphic.md#gafa544ff2d27785a9410a80689f1ad3b1">OnPressEvent</a> (const <a href="OHOS-PressEvent.md">PressEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p100403109093535"><a name="p100403109093535"></a><a name="p100403109093535"></a>virtual void&nbsp;</p>
<p id="p2141032687093535"><a name="p2141032687093535"></a><a name="p2141032687093535"></a>Called when the view is pressed. </p>
</td>
</tr>
<tr id="row1851277742093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p214261380093535"><a name="p214261380093535"></a><a name="p214261380093535"></a><a href="Graphic.md#ga7bd1a74563b059b03fbf66f9add53ee3">OnReleaseEvent</a> (const <a href="OHOS-ReleaseEvent.md">ReleaseEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p477808501093535"><a name="p477808501093535"></a><a name="p477808501093535"></a>virtual void&nbsp;</p>
<p id="p1486108894093535"><a name="p1486108894093535"></a><a name="p1486108894093535"></a>Called when the view is released. </p>
</td>
</tr>
<tr id="row1074746367093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p209495589093535"><a name="p209495589093535"></a><a name="p209495589093535"></a><a href="Graphic.md#ga8f01ff25a33b20df0758f564148e579d">OnCancelEvent</a> (const <a href="OHOS-CancelEvent.md">CancelEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1010603058093535"><a name="p1010603058093535"></a><a name="p1010603058093535"></a>virtual void&nbsp;</p>
<p id="p472199625093535"><a name="p472199625093535"></a><a name="p472199625093535"></a>Called when a click event on the view is canceled. </p>
</td>
</tr>
<tr id="row169570561093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2076255075093535"><a name="p2076255075093535"></a><a name="p2076255075093535"></a><a href="Graphic.md#gad8e3cf5f0dd003a6aa932ef04e7b59f2">SetOnDragListener</a> (<a href="OHOS-UIView-OnDragListener.md">OnDragListener</a> *onDragListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1070464525093535"><a name="p1070464525093535"></a><a name="p1070464525093535"></a>void&nbsp;</p>
<p id="p501499928093535"><a name="p501499928093535"></a><a name="p501499928093535"></a>Sets a drag event listener for the view. </p>
</td>
</tr>
<tr id="row1128749280093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p503472335093535"><a name="p503472335093535"></a><a name="p503472335093535"></a><a href="Graphic.md#ga45a02cba4887c5c0b8e243941bcdc5cb">GetOnDragListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1035847925093535"><a name="p1035847925093535"></a><a name="p1035847925093535"></a><a href="OHOS-UIView-OnDragListener.md">OnDragListener</a> *&amp;&nbsp;</p>
<p id="p75074815093535"><a name="p75074815093535"></a><a name="p75074815093535"></a>Obtains the drag event listener for the view. </p>
</td>
</tr>
<tr id="row455897603093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p327981497093535"><a name="p327981497093535"></a><a name="p327981497093535"></a><a href="Graphic.md#ga4564bf8d8c7184e9c02bf33c9e171fa3">SetOnClickListener</a> (<a href="OHOS-UIView-OnClickListener.md">OnClickListener</a> *onClickListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p812309928093535"><a name="p812309928093535"></a><a name="p812309928093535"></a>void&nbsp;</p>
<p id="p372500496093535"><a name="p372500496093535"></a><a name="p372500496093535"></a>Sets a click event listener for the view. </p>
</td>
</tr>
<tr id="row2086060787093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1939743811093535"><a name="p1939743811093535"></a><a name="p1939743811093535"></a><a href="Graphic.md#ga35e885cb380c37245fa4305bba10cd4a">GetOnClickListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p453092205093535"><a name="p453092205093535"></a><a name="p453092205093535"></a><a href="OHOS-UIView-OnClickListener.md">OnClickListener</a> *&amp;&nbsp;</p>
<p id="p22028288093535"><a name="p22028288093535"></a><a name="p22028288093535"></a>Obtains the click event listener for the view. </p>
</td>
</tr>
<tr id="row1904289288093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p890060888093535"><a name="p890060888093535"></a><a name="p890060888093535"></a><a href="Graphic.md#gabcbe7a0adce600424f7f0d5a7396eb5b">SetOnLongPressListener</a> (<a href="OHOS-UIView-OnLongPressListener.md">OnLongPressListener</a> *onLongPressListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1493519957093535"><a name="p1493519957093535"></a><a name="p1493519957093535"></a>void&nbsp;</p>
<p id="p1543096896093535"><a name="p1543096896093535"></a><a name="p1543096896093535"></a>Sets a long-press event listener for the view. </p>
</td>
</tr>
<tr id="row1561031400093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p81845039093535"><a name="p81845039093535"></a><a name="p81845039093535"></a><a href="Graphic.md#gaafd4d354f5f111e758d046109fd7f656">GetOnLongPressListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p912830506093535"><a name="p912830506093535"></a><a name="p912830506093535"></a><a href="OHOS-UIView-OnLongPressListener.md">OnLongPressListener</a> *&amp;&nbsp;</p>
<p id="p1497285578093535"><a name="p1497285578093535"></a><a name="p1497285578093535"></a>Obtains the long-press event listener for the view. </p>
</td>
</tr>
<tr id="row2062669663093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1488946028093535"><a name="p1488946028093535"></a><a name="p1488946028093535"></a><a href="Graphic.md#gadd697fbf481f98d9d6ca8b67390071af">SetOnTouchListener</a> (<a href="OHOS-UIView-OnTouchListener.md">OnTouchListener</a> *onTouchListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p303839161093535"><a name="p303839161093535"></a><a name="p303839161093535"></a>void&nbsp;</p>
<p id="p1707616032093535"><a name="p1707616032093535"></a><a name="p1707616032093535"></a>Sets a touch event listener for the view. </p>
</td>
</tr>
<tr id="row878888130093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1330421817093535"><a name="p1330421817093535"></a><a name="p1330421817093535"></a><a href="Graphic.md#gae7c65c68653103dae85acdcef78777a6">GetTouchListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1221270929093535"><a name="p1221270929093535"></a><a name="p1221270929093535"></a><a href="OHOS-UIView-OnTouchListener.md">OnTouchListener</a> *&amp;&nbsp;</p>
<p id="p273191199093535"><a name="p273191199093535"></a><a name="p273191199093535"></a>Obtains the touch event listener for the view. </p>
</td>
</tr>
<tr id="row1038313378093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2144827989093535"><a name="p2144827989093535"></a><a name="p2144827989093535"></a><a href="Graphic.md#gaea9f334f2481e1c03a2cd8f3078d7c72">GetTargetView</a> (const <a href="OHOS-Point.md">Point</a> &amp;point, <a href="OHOS-UIView.md">UIView</a> **last)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p174005551093535"><a name="p174005551093535"></a><a name="p174005551093535"></a>virtual void&nbsp;</p>
<p id="p1837406159093535"><a name="p1837406159093535"></a><a name="p1837406159093535"></a>Obtains the top-level view based on specified coordinates. </p>
</td>
</tr>
<tr id="row286900961093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1269620377093535"><a name="p1269620377093535"></a><a name="p1269620377093535"></a><a href="Graphic.md#gaeea67a3a84b4ffe9bfeda418b82184cc">SetParent</a> (<a href="OHOS-UIView.md">UIView</a> *parent)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p516469464093535"><a name="p516469464093535"></a><a name="p516469464093535"></a>void&nbsp;</p>
<p id="p1418797435093535"><a name="p1418797435093535"></a><a name="p1418797435093535"></a>Sets the parent view for the view. </p>
</td>
</tr>
<tr id="row769862219093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1445198074093535"><a name="p1445198074093535"></a><a name="p1445198074093535"></a><a href="Graphic.md#ga706530e4a38108615d5e0c918685ec96">GetParent</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1134394333093535"><a name="p1134394333093535"></a><a name="p1134394333093535"></a><a href="OHOS-UIView.md">UIView</a> *&nbsp;</p>
<p id="p1466691970093535"><a name="p1466691970093535"></a><a name="p1466691970093535"></a>Obtains the parent view of the view. </p>
</td>
</tr>
<tr id="row537834904093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1458471896093535"><a name="p1458471896093535"></a><a name="p1458471896093535"></a><a href="Graphic.md#ga02bec5de07d93cabc45affba79eba4ad">SetNextSibling</a> (<a href="OHOS-UIView.md">UIView</a> *sibling)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1676925184093535"><a name="p1676925184093535"></a><a name="p1676925184093535"></a>void&nbsp;</p>
<p id="p1488838871093535"><a name="p1488838871093535"></a><a name="p1488838871093535"></a>Sets the next sibling view for the view. </p>
</td>
</tr>
<tr id="row1339211092093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p24405457093535"><a name="p24405457093535"></a><a name="p24405457093535"></a><a href="Graphic.md#gab0030977b30ddc9f2e15dbc2f58937e6">GetNextSibling</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2122689513093535"><a name="p2122689513093535"></a><a name="p2122689513093535"></a><a href="OHOS-UIView.md">UIView</a> *&nbsp;</p>
<p id="p1680745620093535"><a name="p1680745620093535"></a><a name="p1680745620093535"></a>Obtains the next sibling view of the view. </p>
</td>
</tr>
<tr id="row93559345093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p528458494093535"><a name="p528458494093535"></a><a name="p528458494093535"></a><a href="Graphic.md#ga07e7e1f268bd6ce975f4f0f8487af5d0">SetVisible</a> (bool visible)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1408293514093535"><a name="p1408293514093535"></a><a name="p1408293514093535"></a>virtual void&nbsp;</p>
<p id="p1830182266093535"><a name="p1830182266093535"></a><a name="p1830182266093535"></a>Sets whether the view is visible. </p>
</td>
</tr>
<tr id="row302341566093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1411541135093535"><a name="p1411541135093535"></a><a name="p1411541135093535"></a><a href="Graphic.md#gaee178fc0a86ac03a6bdf2ade0c1914c8">IsVisible</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p291137556093535"><a name="p291137556093535"></a><a name="p291137556093535"></a>bool&nbsp;</p>
<p id="p109872268093535"><a name="p109872268093535"></a><a name="p109872268093535"></a>Checks whether the view is visible. </p>
</td>
</tr>
<tr id="row1949190277093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p726489234093535"><a name="p726489234093535"></a><a name="p726489234093535"></a><a href="Graphic.md#gaf9fb55fd9aa397f7158f1515e90bce02">SetTouchable</a> (bool touch)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1562652775093535"><a name="p1562652775093535"></a><a name="p1562652775093535"></a>void&nbsp;</p>
<p id="p1829183017093535"><a name="p1829183017093535"></a><a name="p1829183017093535"></a>Sets whether the view is touchable. </p>
</td>
</tr>
<tr id="row114386576093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p90570702093535"><a name="p90570702093535"></a><a name="p90570702093535"></a><a href="Graphic.md#ga502a53fb77b260fa36b5b3adf82e2340">IsTouchable</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1920562270093535"><a name="p1920562270093535"></a><a name="p1920562270093535"></a>bool&nbsp;</p>
<p id="p1606953178093535"><a name="p1606953178093535"></a><a name="p1606953178093535"></a>Checks whether the view is touchable. </p>
</td>
</tr>
<tr id="row983826601093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p153535843093535"><a name="p153535843093535"></a><a name="p153535843093535"></a><a href="Graphic.md#gab06abe0fe824c048f3b72974f9a8f0d0">SetDraggable</a> (bool draggable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1216974965093535"><a name="p1216974965093535"></a><a name="p1216974965093535"></a>void&nbsp;</p>
<p id="p600604184093535"><a name="p600604184093535"></a><a name="p600604184093535"></a>Sets whether the view is draggable. </p>
</td>
</tr>
<tr id="row1470158128093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1851578623093535"><a name="p1851578623093535"></a><a name="p1851578623093535"></a><a href="Graphic.md#ga25bb796ff400c767d622cbed280fc500">IsDraggable</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p74498463093535"><a name="p74498463093535"></a><a name="p74498463093535"></a>bool&nbsp;</p>
<p id="p795687571093535"><a name="p795687571093535"></a><a name="p795687571093535"></a>Checks whether the view is draggable. </p>
</td>
</tr>
<tr id="row997646415093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1762944441093535"><a name="p1762944441093535"></a><a name="p1762944441093535"></a><a href="Graphic.md#ga6c08e49bf7a82a7ebaef0f251e7a6f85">SetDragParentInstead</a> (bool dragParentInstead)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p105601064093535"><a name="p105601064093535"></a><a name="p105601064093535"></a>void&nbsp;</p>
<p id="p1440500145093535"><a name="p1440500145093535"></a><a name="p1440500145093535"></a>Sets whether to transfer the drag event to the parent view for processing when the view is being dragged. </p>
</td>
</tr>
<tr id="row1724348313093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1961703673093535"><a name="p1961703673093535"></a><a name="p1961703673093535"></a><a href="Graphic.md#gaf0c462bc31e779b1898ad4cdfdad6faf">IsDragParentInstead</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p681909535093535"><a name="p681909535093535"></a><a name="p681909535093535"></a>bool&nbsp;</p>
<p id="p297073045093535"><a name="p297073045093535"></a><a name="p297073045093535"></a>Obtains whether the view transfers a drag event to the parent view for processing. </p>
</td>
</tr>
<tr id="row1371250727093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p591029664093535"><a name="p591029664093535"></a><a name="p591029664093535"></a><a href="Graphic.md#ga86cb8d364f18494d67636c55babced5c">GetRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p522706014093535"><a name="p522706014093535"></a><a name="p522706014093535"></a><a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p1587926269093535"><a name="p1587926269093535"></a><a name="p1587926269093535"></a>Obtains the absolute rectangle area of the view. When the view has deformation such as rotation, the rectangle area is the intersection set of the absolute rectangle area and deformation matrix. </p>
</td>
</tr>
<tr id="row1942804634093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1964650722093535"><a name="p1964650722093535"></a><a name="p1964650722093535"></a><a href="Graphic.md#ga06e79704a19f2a238982076cac3d059b">GetVisibleRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1388747468093535"><a name="p1388747468093535"></a><a name="p1388747468093535"></a><a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p1552223880093535"><a name="p1552223880093535"></a><a name="p1552223880093535"></a>Obtains the visible absolute rectangle area of the view. </p>
</td>
</tr>
<tr id="row640296374093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2011595098093535"><a name="p2011595098093535"></a><a name="p2011595098093535"></a><a href="Graphic.md#gab3f8993b3953f27bfc61d53429916cba">GetMaskedRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1061828816093535"><a name="p1061828816093535"></a><a name="p1061828816093535"></a><a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p1852297602093535"><a name="p1852297602093535"></a><a name="p1852297602093535"></a>Obtains the valid absolute rectangle area of the view. The valid area refers to the area where the view can be displayed. Generally, the valid area is the same as the visible view area, but they may be different in the grid layout. </p>
</td>
</tr>
<tr id="row2145801547093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p14214583093535"><a name="p14214583093535"></a><a name="p14214583093535"></a><a href="Graphic.md#ga64cf308a09999def1192f9c4e0f17f0a">GetOrigRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2059896375093535"><a name="p2059896375093535"></a><a name="p2059896375093535"></a><a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p1606311066093535"><a name="p1606311066093535"></a><a name="p1606311066093535"></a>Obtains the absolute rectangle area of the view. </p>
</td>
</tr>
<tr id="row454003280093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1529275848093535"><a name="p1529275848093535"></a><a name="p1529275848093535"></a><a href="Graphic.md#ga9db88eae712676359d02a92be14fa316">GetContentRect</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1647459079093535"><a name="p1647459079093535"></a><a name="p1647459079093535"></a>virtual <a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p283220373093535"><a name="p283220373093535"></a><a name="p283220373093535"></a>Obtains the content of the absolute rectangle area of the view. This area excludes padding. </p>
</td>
</tr>
<tr id="row240225818093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p95978877093535"><a name="p95978877093535"></a><a name="p95978877093535"></a><a href="Graphic.md#gae9b96837fa1d45648a2a6fbbfcc5eb4a">GetRelativeRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p21977198093535"><a name="p21977198093535"></a><a name="p21977198093535"></a><a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p931982188093535"><a name="p931982188093535"></a><a name="p931982188093535"></a>Obtains the rectangular area of the view relative to the parent view, that is, the rectangular area relative to the coordinates of the parent view. </p>
</td>
</tr>
<tr id="row281909677093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1444050762093535"><a name="p1444050762093535"></a><a name="p1444050762093535"></a><a href="Graphic.md#gae6c5f3bcf99dc837bcecd60c38d3df5a">ResizeVisibleArea</a> (int16_t x, int16_t y, int16_t width, int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1783270522093535"><a name="p1783270522093535"></a><a name="p1783270522093535"></a>void&nbsp;</p>
<p id="p1228185457093535"><a name="p1228185457093535"></a><a name="p1228185457093535"></a>Adjusts the size of the visible area. This operation may affect the final display size. </p>
</td>
</tr>
<tr id="row867781137093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p556960881093535"><a name="p556960881093535"></a><a name="p556960881093535"></a><a href="Graphic.md#ga3375ec5ef059fd88c657af4552d2fa4f">SetWidth</a> (int16_t width)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p559632764093535"><a name="p559632764093535"></a><a name="p559632764093535"></a>virtual void&nbsp;</p>
<p id="p2145158621093535"><a name="p2145158621093535"></a><a name="p2145158621093535"></a>Sets the width for the view. </p>
</td>
</tr>
<tr id="row1260434674093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p980702321093535"><a name="p980702321093535"></a><a name="p980702321093535"></a><a href="Graphic.md#ga90cf8cffb98d71c30d6fc1d118442dbd">GetWidth</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1512904292093535"><a name="p1512904292093535"></a><a name="p1512904292093535"></a>virtual int16_t&nbsp;</p>
<p id="p2085964934093535"><a name="p2085964934093535"></a><a name="p2085964934093535"></a>Obtains the width for the view. </p>
</td>
</tr>
<tr id="row480807274093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p530055361093535"><a name="p530055361093535"></a><a name="p530055361093535"></a><a href="Graphic.md#ga9c7110620d5dc3a7bd3efe1fc2edd125">SetHeight</a> (int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p369223361093535"><a name="p369223361093535"></a><a name="p369223361093535"></a>virtual void&nbsp;</p>
<p id="p1084794337093535"><a name="p1084794337093535"></a><a name="p1084794337093535"></a>Sets the height for the view. </p>
</td>
</tr>
<tr id="row1865173355093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p641897931093535"><a name="p641897931093535"></a><a name="p641897931093535"></a><a href="Graphic.md#ga9b35f4603a561c7a9a29b023a022ac97">GetHeight</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p725016487093535"><a name="p725016487093535"></a><a name="p725016487093535"></a>virtual int16_t&nbsp;</p>
<p id="p1129005732093535"><a name="p1129005732093535"></a><a name="p1129005732093535"></a>Obtains the height for the view. </p>
</td>
</tr>
<tr id="row1572088411093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p36835881093535"><a name="p36835881093535"></a><a name="p36835881093535"></a><a href="Graphic.md#gae985b607d2f0701911778bf20d640ccd">Resize</a> (int16_t width, int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1499593469093535"><a name="p1499593469093535"></a><a name="p1499593469093535"></a>virtual void&nbsp;</p>
<p id="p921366687093535"><a name="p921366687093535"></a><a name="p921366687093535"></a>Adjusts the size of the view. </p>
</td>
</tr>
<tr id="row1772801868093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p594523968093535"><a name="p594523968093535"></a><a name="p594523968093535"></a><a href="Graphic.md#gaded403626558d28e62bf5632ccbb24b5">SetX</a> (int16_t x)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2015424989093535"><a name="p2015424989093535"></a><a name="p2015424989093535"></a>virtual void&nbsp;</p>
<p id="p2035398719093535"><a name="p2035398719093535"></a><a name="p2035398719093535"></a>Sets the x-coordinate for the view. </p>
</td>
</tr>
<tr id="row1413511536093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1790672900093535"><a name="p1790672900093535"></a><a name="p1790672900093535"></a><a href="Graphic.md#ga89dc5f8fb1cb4b2259dc0439185359f1">GetX</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p217746989093535"><a name="p217746989093535"></a><a name="p217746989093535"></a>int16_t&nbsp;</p>
<p id="p1478472576093535"><a name="p1478472576093535"></a><a name="p1478472576093535"></a>Obtains the x-coordinate for the view. </p>
</td>
</tr>
<tr id="row2025092542093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p244354808093535"><a name="p244354808093535"></a><a name="p244354808093535"></a><a href="Graphic.md#gaaa8edc224cf1c7deb2724fb225960877">SetY</a> (int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p760369057093535"><a name="p760369057093535"></a><a name="p760369057093535"></a>virtual void&nbsp;</p>
<p id="p513683072093535"><a name="p513683072093535"></a><a name="p513683072093535"></a>Sets the y-coordinate for the view. </p>
</td>
</tr>
<tr id="row1319668066093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1388615584093535"><a name="p1388615584093535"></a><a name="p1388615584093535"></a><a href="Graphic.md#ga193619d649204b0e9bb854d3b30275c3">GetY</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1981134301093535"><a name="p1981134301093535"></a><a name="p1981134301093535"></a>int16_t&nbsp;</p>
<p id="p1493519504093535"><a name="p1493519504093535"></a><a name="p1493519504093535"></a>Obtains the y-coordinate for the view. </p>
</td>
</tr>
<tr id="row1012396233093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1854485029093535"><a name="p1854485029093535"></a><a name="p1854485029093535"></a><a href="Graphic.md#gab34233f6aeae330b025969137d03e67a">SetPosition</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1144836018093535"><a name="p1144836018093535"></a><a name="p1144836018093535"></a>virtual void&nbsp;</p>
<p id="p1688091267093535"><a name="p1688091267093535"></a><a name="p1688091267093535"></a>Sets the position for the view. </p>
</td>
</tr>
<tr id="row960265741093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2467713093535"><a name="p2467713093535"></a><a name="p2467713093535"></a><a href="Graphic.md#gaf8ce4c009f23b7175b2b34bac4a74262">SetPosition</a> (int16_t x, int16_t y, int16_t width, int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p47748620093535"><a name="p47748620093535"></a><a name="p47748620093535"></a>virtual void&nbsp;</p>
<p id="p1816401868093535"><a name="p1816401868093535"></a><a name="p1816401868093535"></a>Adjusts the position and size of the view. </p>
</td>
</tr>
<tr id="row1994506723093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1538881987093535"><a name="p1538881987093535"></a><a name="p1538881987093535"></a><a href="Graphic.md#gab2ce8c11abbd55f40687f38a52511b11">IsViewGroup</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p628212469093535"><a name="p628212469093535"></a><a name="p628212469093535"></a>bool&nbsp;</p>
<p id="p1435672196093535"><a name="p1435672196093535"></a><a name="p1435672196093535"></a>Checks whether the view is a container view. </p>
</td>
</tr>
<tr id="row1536679139093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1335089852093535"><a name="p1335089852093535"></a><a name="p1335089852093535"></a><a href="Graphic.md#ga980fc6824c64cfae6af8657aee17af88">SetIntercept</a> (bool isIntercept)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2129524118093535"><a name="p2129524118093535"></a><a name="p2129524118093535"></a>void&nbsp;</p>
<p id="p1369712596093535"><a name="p1369712596093535"></a><a name="p1369712596093535"></a>Sets whether to intercept the drag event. If intercepted, the view does not transfer the drag event to the parent view after local processing. </p>
</td>
</tr>
<tr id="row1080047178093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1447057265093535"><a name="p1447057265093535"></a><a name="p1447057265093535"></a><a href="Graphic.md#ga8623abbbeff458c0cb2d7dc0d1f21e4a">SetTransformMap</a> (const <a href="OHOS-TransformMap.md">TransformMap</a> &amp;transMap)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1950149890093535"><a name="p1950149890093535"></a><a name="p1950149890093535"></a>void&nbsp;</p>
<p id="p2016916006093535"><a name="p2016916006093535"></a><a name="p2016916006093535"></a>Sets the affine transformation matrix. </p>
</td>
</tr>
<tr id="row386429933093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p132211204093535"><a name="p132211204093535"></a><a name="p132211204093535"></a><a href="Graphic.md#gab8cee5a7052a88722768c8ed1324abc1">GetTransformMap</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p263904490093535"><a name="p263904490093535"></a><a name="p263904490093535"></a><a href="OHOS-TransformMap.md">TransformMap</a> &amp;&nbsp;</p>
<p id="p171213808093535"><a name="p171213808093535"></a><a name="p171213808093535"></a>Obtains an affine transformation matrix. </p>
</td>
</tr>
<tr id="row1964561526093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2138293760093535"><a name="p2138293760093535"></a><a name="p2138293760093535"></a><a href="Graphic.md#ga0573aa25307c22319db4629781b5cad2">GetChildById</a> (const char *id) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p708818533093535"><a name="p708818533093535"></a><a name="p708818533093535"></a>virtual <a href="OHOS-UIView.md">UIView</a> *&nbsp;</p>
<p id="p1458189107093535"><a name="p1458189107093535"></a><a name="p1458189107093535"></a>Obtains the child view of a specified ID. </p>
</td>
</tr>
<tr id="row1590688660093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1137221403093535"><a name="p1137221403093535"></a><a name="p1137221403093535"></a><a href="Graphic.md#ga0caaa15c9b304673331e778a266be77f">SetViewId</a> (const char *id)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2126648605093535"><a name="p2126648605093535"></a><a name="p2126648605093535"></a>void&nbsp;</p>
<p id="p1226631795093535"><a name="p1226631795093535"></a><a name="p1226631795093535"></a>Sets the view ID. </p>
</td>
</tr>
<tr id="row273500795093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p232321009093535"><a name="p232321009093535"></a><a name="p232321009093535"></a><a href="Graphic.md#gad6c7644bd2abfa3c92d80776b0bd1936">GetViewId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1114763440093535"><a name="p1114763440093535"></a><a name="p1114763440093535"></a>const char *&nbsp;</p>
<p id="p673652937093535"><a name="p673652937093535"></a><a name="p673652937093535"></a>Obtains the view ID. </p>
</td>
</tr>
<tr id="row1474594914093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p744048846093535"><a name="p744048846093535"></a><a name="p744048846093535"></a><a href="Graphic.md#ga77a961aa53567c5214508b4569801c16">SetViewIndex</a> (int16_t <a href="zh-cn_topic_0000001055198076.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1125652797093535"><a name="p1125652797093535"></a><a name="p1125652797093535"></a>void&nbsp;</p>
<p id="p1472544944093535"><a name="p1472544944093535"></a><a name="p1472544944093535"></a>Sets the view index. </p>
</td>
</tr>
<tr id="row927640214093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1039104220093535"><a name="p1039104220093535"></a><a name="p1039104220093535"></a><a href="Graphic.md#ga62f51715b6d420a296ebe0296717b906">GetViewIndex</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2038138889093535"><a name="p2038138889093535"></a><a name="p2038138889093535"></a>int16_t&nbsp;</p>
<p id="p178040469093535"><a name="p178040469093535"></a><a name="p178040469093535"></a>Obtains the view index. </p>
</td>
</tr>
<tr id="row652019453093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2125388198093535"><a name="p2125388198093535"></a><a name="p2125388198093535"></a><a href="Graphic.md#gaca871fa2f8219e7ea9388e212d1f1e69">LayoutChildren</a> (bool neeInvalidate=false)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1169833042093535"><a name="p1169833042093535"></a><a name="p1169833042093535"></a>virtual void&nbsp;</p>
<p id="p1350518566093535"><a name="p1350518566093535"></a><a name="p1350518566093535"></a>Lays out all child views according to the preset arrangement mode. </p>
</td>
</tr>
<tr id="row1389396816093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1194679763093535"><a name="p1194679763093535"></a><a name="p1194679763093535"></a><a href="Graphic.md#ga443b86ee9275b0421b37a47bad3264dc">LayoutCenterOfParent</a> (int16_t xOffSet=0, int16_t yOffset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p539561085093535"><a name="p539561085093535"></a><a name="p539561085093535"></a>void&nbsp;</p>
<p id="p900896903093535"><a name="p900896903093535"></a><a name="p900896903093535"></a>Lays out the view in the center of the parent view. </p>
</td>
</tr>
<tr id="row2047132197093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1757536891093535"><a name="p1757536891093535"></a><a name="p1757536891093535"></a><a href="Graphic.md#ga94999b271f27cd5d6bfaf303f7d5c708">LayoutLeftOfParent</a> (int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1329412330093535"><a name="p1329412330093535"></a><a name="p1329412330093535"></a>void&nbsp;</p>
<p id="p444462583093535"><a name="p444462583093535"></a><a name="p444462583093535"></a>Lays out the view on the left of the parent view. </p>
</td>
</tr>
<tr id="row2007727851093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p878041500093535"><a name="p878041500093535"></a><a name="p878041500093535"></a><a href="Graphic.md#ga479528ed259b5539e423955f2b60517d">LayoutRightOfParent</a> (int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p397075980093535"><a name="p397075980093535"></a><a name="p397075980093535"></a>void&nbsp;</p>
<p id="p1287003029093535"><a name="p1287003029093535"></a><a name="p1287003029093535"></a>Lays out the view on the right of the parent view. </p>
</td>
</tr>
<tr id="row1467083163093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1197063232093535"><a name="p1197063232093535"></a><a name="p1197063232093535"></a><a href="Graphic.md#ga859288ea61ad23ba7e381bbc07769e83">LayoutTopOfParent</a> (int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p962013486093535"><a name="p962013486093535"></a><a name="p962013486093535"></a>void&nbsp;</p>
<p id="p118051916093535"><a name="p118051916093535"></a><a name="p118051916093535"></a>Lays out the view on the top of the parent view. </p>
</td>
</tr>
<tr id="row1874077047093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1085547769093535"><a name="p1085547769093535"></a><a name="p1085547769093535"></a><a href="Graphic.md#ga809aeee4792ae58218a0bcfcb94d5cdc">LayoutBottomOfParent</a> (int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1524619924093535"><a name="p1524619924093535"></a><a name="p1524619924093535"></a>void&nbsp;</p>
<p id="p423580755093535"><a name="p423580755093535"></a><a name="p423580755093535"></a>Lays out the view on the bottom of the parent view. </p>
</td>
</tr>
<tr id="row1533283766093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2111558578093535"><a name="p2111558578093535"></a><a name="p2111558578093535"></a><a href="Graphic.md#gac7f5f2584c716a56fee3783f8dea6246">AlignLeftToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p563308081093535"><a name="p563308081093535"></a><a name="p563308081093535"></a>void&nbsp;</p>
<p id="p1346728431093535"><a name="p1346728431093535"></a><a name="p1346728431093535"></a>Aligns the view with the left of a sibling view. </p>
</td>
</tr>
<tr id="row1812638291093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1442597901093535"><a name="p1442597901093535"></a><a name="p1442597901093535"></a><a href="Graphic.md#gabb1ac454cdf95593c1e387d5e272433c">AlignRightToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p632970115093535"><a name="p632970115093535"></a><a name="p632970115093535"></a>void&nbsp;</p>
<p id="p323649291093535"><a name="p323649291093535"></a><a name="p323649291093535"></a>Aligns the view with the right of a sibling view. </p>
</td>
</tr>
<tr id="row1999853456093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p908337963093535"><a name="p908337963093535"></a><a name="p908337963093535"></a><a href="Graphic.md#ga903d7cbc59bac06d728b7f6435c9a504">AlignTopToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p54506956093535"><a name="p54506956093535"></a><a name="p54506956093535"></a>void&nbsp;</p>
<p id="p1593669527093535"><a name="p1593669527093535"></a><a name="p1593669527093535"></a>Aligns the view with the top of a sibling view. </p>
</td>
</tr>
<tr id="row1482638451093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1025707875093535"><a name="p1025707875093535"></a><a name="p1025707875093535"></a><a href="Graphic.md#ga7607c3f9661932c495d080e9d92fb1a3">AlignBottomToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p882213127093535"><a name="p882213127093535"></a><a name="p882213127093535"></a>void&nbsp;</p>
<p id="p312081316093535"><a name="p312081316093535"></a><a name="p312081316093535"></a>Aligns the view with the bottom of a sibling view. </p>
</td>
</tr>
<tr id="row671590303093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1010393700093535"><a name="p1010393700093535"></a><a name="p1010393700093535"></a><a href="Graphic.md#gac23776dbc2fce7ff30d57438abfa5230">AlignHorCenterToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p914907189093535"><a name="p914907189093535"></a><a name="p914907189093535"></a>void&nbsp;</p>
<p id="p701507367093535"><a name="p701507367093535"></a><a name="p701507367093535"></a>Aligns the view with the center of a sibling view in the x-axis. </p>
</td>
</tr>
<tr id="row334202626093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p618243311093535"><a name="p618243311093535"></a><a name="p618243311093535"></a><a href="Graphic.md#gad3caa27aa0cb73ec4656e7d23aa222de">AlignVerCenterToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1377972060093535"><a name="p1377972060093535"></a><a name="p1377972060093535"></a>void&nbsp;</p>
<p id="p2071545838093535"><a name="p2071545838093535"></a><a name="p2071545838093535"></a>Aligns the view with the center of a sibling view in the y-axis. </p>
</td>
</tr>
<tr id="row718894748093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1868660927093535"><a name="p1868660927093535"></a><a name="p1868660927093535"></a><a href="Graphic.md#ga58f1a34a943c4492970f901d63bbc3d8">LayoutLeftToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p209848200093535"><a name="p209848200093535"></a><a name="p209848200093535"></a>void&nbsp;</p>
<p id="p900390844093535"><a name="p900390844093535"></a><a name="p900390844093535"></a>Lays out the view on the left of a sibling view. </p>
</td>
</tr>
<tr id="row1004499499093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1446018876093535"><a name="p1446018876093535"></a><a name="p1446018876093535"></a><a href="Graphic.md#gac4cd64de5291759add164825a323a0d6">LayoutRightToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1977530081093535"><a name="p1977530081093535"></a><a name="p1977530081093535"></a>void&nbsp;</p>
<p id="p728459378093535"><a name="p728459378093535"></a><a name="p728459378093535"></a>Lays out the view on the right of a sibling view. </p>
</td>
</tr>
<tr id="row432685707093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1830944029093535"><a name="p1830944029093535"></a><a name="p1830944029093535"></a><a href="Graphic.md#gaaa8385807e3a9bea46f8dcc326252a70">LayoutTopToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2115740002093535"><a name="p2115740002093535"></a><a name="p2115740002093535"></a>void&nbsp;</p>
<p id="p1298505708093535"><a name="p1298505708093535"></a><a name="p1298505708093535"></a>Lays out the view on the above of a sibling view. </p>
</td>
</tr>
<tr id="row1868388192093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p196973164093535"><a name="p196973164093535"></a><a name="p196973164093535"></a><a href="Graphic.md#gaa23a68e8ef0fb13b362218e71cf67ace">LayoutBottomToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p864135234093535"><a name="p864135234093535"></a><a name="p864135234093535"></a>void&nbsp;</p>
<p id="p954098580093535"><a name="p954098580093535"></a><a name="p954098580093535"></a>Lays out the view on the below of a sibling view. </p>
</td>
</tr>
<tr id="row10668453093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1140304180093535"><a name="p1140304180093535"></a><a name="p1140304180093535"></a><a href="Graphic.md#ga9c1a3db000fdcd200fec8d2c49f5a0a8">SetStyle</a> (<a href="OHOS-Style.md">Style</a> &amp;style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1692173478093535"><a name="p1692173478093535"></a><a name="p1692173478093535"></a>virtual void&nbsp;</p>
<p id="p315696595093535"><a name="p315696595093535"></a><a name="p315696595093535"></a>Sets the view style. </p>
</td>
</tr>
<tr id="row780584203093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p881680253093535"><a name="p881680253093535"></a><a name="p881680253093535"></a><a href="Graphic.md#ga0945c2f05815dc2e466ef9ceaca2f700">SetStyle</a> (uint8_t key, int64_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1391129172093535"><a name="p1391129172093535"></a><a name="p1391129172093535"></a>virtual void&nbsp;</p>
<p id="p2067822366093535"><a name="p2067822366093535"></a><a name="p2067822366093535"></a>Sets a style. </p>
</td>
</tr>
<tr id="row1931895679093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p126887851093535"><a name="p126887851093535"></a><a name="p126887851093535"></a><a href="Graphic.md#ga4ea19bc9f4b487946c9e29e63b54a0e6">GetStyle</a> (uint8_t key) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1808472603093535"><a name="p1808472603093535"></a><a name="p1808472603093535"></a>virtual int64_t&nbsp;</p>
<p id="p224201823093535"><a name="p224201823093535"></a><a name="p224201823093535"></a>Obtains the value of a style. </p>
</td>
</tr>
<tr id="row1447582730093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p394457883093535"><a name="p394457883093535"></a><a name="p394457883093535"></a><a href="Graphic.md#ga1b28213d4c2cd0f8324bce3fe56eb7bb">GetStyleConst</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1645362468093535"><a name="p1645362468093535"></a><a name="p1645362468093535"></a>const <a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p1184390356093535"><a name="p1184390356093535"></a><a name="p1184390356093535"></a>Obtains the view style. This function applies to scenarios where the style does not need to be modified, which saves memory. </p>
</td>
</tr>
<tr id="row1175488200093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p611628514093535"><a name="p611628514093535"></a><a name="p611628514093535"></a><a href="Graphic.md#ga4854963aa969ee20a6cd174a70f5cd23">operator new</a> (size_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p219088129093535"><a name="p219088129093535"></a><a name="p219088129093535"></a>void *&nbsp;</p>
<p id="p1402713040093535"><a name="p1402713040093535"></a><a name="p1402713040093535"></a>Overrides the <strong id="b1143378600093535"><a name="b1143378600093535"></a><a name="b1143378600093535"></a>new</strong> function. </p>
</td>
</tr>
<tr id="row1897323202093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p585306903093535"><a name="p585306903093535"></a><a name="p585306903093535"></a><a href="Graphic.md#gadf1997a0f56ac2b220e7f0f8e8e0a6ef">operator delete</a> (void *p)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2072070678093535"><a name="p2072070678093535"></a><a name="p2072070678093535"></a>void&nbsp;</p>
<p id="p2141609858093535"><a name="p2141609858093535"></a><a name="p2141609858093535"></a>Overrides the <strong id="b1037395502093535"><a name="b1037395502093535"></a><a name="b1037395502093535"></a>delete</strong> function. </p>
</td>
</tr>
</tbody>
</table>

## Additional Inherited Members<a name="inherited"></a>

<a name="table1280615330093535"></a>
<table><thead align="left"><tr id="row1390779057093535"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2145187041093535"><a name="p2145187041093535"></a><a name="p2145187041093535"></a>Additional Inherited Member Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p65638338093535"><a name="p65638338093535"></a><a name="p65638338093535"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row348378399093535"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p278856451093535"><a name="p278856451093535"></a><a name="p278856451093535"></a><a href="Graphic.md#ga15a3f0302aded0e4d1584ddc6002335d">UICheckBoxState</a> : uint8_t </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1878027338093535"><a name="p1878027338093535"></a><a name="p1878027338093535"></a>Enumerates the states of a check box. </p>
</td>
</tr>
</tbody>
</table>

