# Graphic<a name="ZH-CN_TOPIC_0000001054799551"></a>

## **Overview**<a name="section240390086084826"></a>

Defines a lightweight graphics system that provides basic UI and container views, including buttons, images, labels, lists, animators, scroll views, swipe views, and layouts. This system also provides the Design for X \(DFX\) capability to implement features such as view rendering, animation, and input event distribution. 

**Since:**

1.0

**Version:**

1.0

## **Summary**<a name="section1386283935084826"></a>

## Files<a name="files"></a>

<a name="table866690712084826"></a>
<table><thead align="left"><tr id="row1329099201084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1159108870084826"><a name="p1159108870084826"></a><a name="p1159108870084826"></a>File Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1365165065084826"><a name="p1365165065084826"></a><a name="p1365165065084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2059631182084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1888153708084826"><a name="p1888153708084826"></a><a name="p1888153708084826"></a><a href="animator-h.md">animator.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1792719527084826"><a name="p1792719527084826"></a><a name="p1792719527084826"></a>Defines the attributes and common functions of the animator module. </p>
</td>
</tr>
<tr id="row187968879084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1481350196084826"><a name="p1481350196084826"></a><a name="p1481350196084826"></a><a href="easing_equation-h.md">easing_equation.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p533100404084826"><a name="p533100404084826"></a><a name="p533100404084826"></a>Defines the attributes and functions of the animation easing module. </p>
</td>
</tr>
<tr id="row502178086084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1830523626084826"><a name="p1830523626084826"></a><a name="p1830523626084826"></a><a href="interpolation-h.md">interpolation.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1803070116084826"><a name="p1803070116084826"></a><a name="p1803070116084826"></a>Defines the functions for calculating the interpolation in computer graphics. </p>
</td>
</tr>
<tr id="row2020835123084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p599696047084826"><a name="p599696047084826"></a><a name="p599696047084826"></a><a href="color-h.md">color.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2020029649084826"><a name="p2020029649084826"></a><a name="p2020029649084826"></a>Defines color attributes for the graphics system and implements common color functions. </p>
</td>
</tr>
<tr id="row1348490307084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1837455149084826"><a name="p1837455149084826"></a><a name="p1837455149084826"></a><a href="image-h.md">image.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p556055512084826"><a name="p556055512084826"></a><a name="p556055512084826"></a>Declares basic image attributes, including the image type and path. </p>
</td>
</tr>
<tr id="row2007186932084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1748626438084826"><a name="p1748626438084826"></a><a name="p1748626438084826"></a><a href="screen-h.md">screen.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p456006069084826"><a name="p456006069084826"></a><a name="p456006069084826"></a>Declares the screen information. </p>
</td>
</tr>
<tr id="row1668960063084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p818231019084826"><a name="p818231019084826"></a><a name="p818231019084826"></a><a href="task-h.md">task.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1415864287084826"><a name="p1415864287084826"></a><a name="p1415864287084826"></a>Declares the <strong id="b1880773905084826"><a name="b1880773905084826"></a><a name="b1880773905084826"></a>Task</strong> class of the graphics module, which provides functions for setting the running period and time of a task. </p>
</td>
</tr>
<tr id="row1280931968084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p98086956084826"><a name="p98086956084826"></a><a name="p98086956084826"></a><a href="text-h.md">text.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p411346979084826"><a name="p411346979084826"></a><a name="p411346979084826"></a>Declares the <strong id="b1209583406084826"><a name="b1209583406084826"></a><a name="b1209583406084826"></a>Text</strong> class that provides functions to set basic text attributes, such as the text direction and alignment mode. </p>
</td>
</tr>
<tr id="row1880711310084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p289832830084826"><a name="p289832830084826"></a><a name="p289832830084826"></a><a href="abstract_adapter-h.md">abstract_adapter.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1357107935084826"><a name="p1357107935084826"></a><a name="p1357107935084826"></a>Defines the base class for adapters. </p>
</td>
</tr>
<tr id="row1528954883084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p8627266084826"><a name="p8627266084826"></a><a name="p8627266084826"></a><a href="root_view-h.md">root_view.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1372540561084826"><a name="p1372540561084826"></a><a name="p1372540561084826"></a>Manages a root view. </p>
</td>
</tr>
<tr id="row1408940912084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p785949186084826"><a name="p785949186084826"></a><a name="p785949186084826"></a><a href="text_adapter-h.md">text_adapter.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2037261001084826"><a name="p2037261001084826"></a><a name="p2037261001084826"></a>Defines a text adapter that is used to construct UILabel instances. </p>
</td>
</tr>
<tr id="row1207092366084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p929439691084826"><a name="p929439691084826"></a><a name="p929439691084826"></a><a href="ui_abstract_clock-h.md">ui_abstract_clock.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p613288431084826"><a name="p613288431084826"></a><a name="p613288431084826"></a>Declares the <strong id="b1317999366084826"><a name="b1317999366084826"></a><a name="b1317999366084826"></a>UIAbstractClock</strong> class that provides the functions related to clocks. </p>
</td>
</tr>
<tr id="row238946333084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1103738049084826"><a name="p1103738049084826"></a><a name="p1103738049084826"></a><a href="ui_abstract_progress-h.md">ui_abstract_progress.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1917240557084826"><a name="p1917240557084826"></a><a name="p1917240557084826"></a>Defines the base class attributes and common functions of a progress bar. </p>
</td>
</tr>
<tr id="row134905950084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p438212661084826"><a name="p438212661084826"></a><a name="p438212661084826"></a><a href="ui_abstract_scroll-h.md">ui_abstract_scroll.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1043700712084826"><a name="p1043700712084826"></a><a name="p1043700712084826"></a>Declares the base class used to define the attributes of a scroll. The <strong id="b1104645193084826"><a name="b1104645193084826"></a><a name="b1104645193084826"></a>UIList</strong>, <strong id="b339122661084826"><a name="b339122661084826"></a><a name="b339122661084826"></a>UIScrollView</strong>, and <strong id="b980338514084826"><a name="b980338514084826"></a><a name="b980338514084826"></a>UISwipeView</strong> inherit from this class. </p>
</td>
</tr>
<tr id="row82282200084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1848420805084826"><a name="p1848420805084826"></a><a name="p1848420805084826"></a><a href="ui_analog_clock-h.md">ui_analog_clock.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1745825918084826"><a name="p1745825918084826"></a><a name="p1745825918084826"></a>Declares an analog clock. </p>
</td>
</tr>
<tr id="row482413542084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1477787336084826"><a name="p1477787336084826"></a><a name="p1477787336084826"></a><a href="ui_arc_label-h.md">ui_arc_label.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1372587369084826"><a name="p1372587369084826"></a><a name="p1372587369084826"></a>Defines the attributes of an arc label. </p>
</td>
</tr>
<tr id="row277566019084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1966170630084826"><a name="p1966170630084826"></a><a name="p1966170630084826"></a><a href="ui_axis-h.md">ui_axis.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p696821591084826"><a name="p696821591084826"></a><a name="p696821591084826"></a>Defines the attributes and functions of the x- and y-axises. This class is used in <strong id="b2046062839084826"><a name="b2046062839084826"></a><a name="b2046062839084826"></a>UIChart</strong>. </p>
</td>
</tr>
<tr id="row1755314156084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1287179977084826"><a name="p1287179977084826"></a><a name="p1287179977084826"></a><a href="ui_box_progress-h.md">ui_box_progress.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p918597338084826"><a name="p918597338084826"></a><a name="p918597338084826"></a>Defines the attributes and common functions of a linear progress bar. </p>
</td>
</tr>
<tr id="row474867056084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p887057386084826"><a name="p887057386084826"></a><a name="p887057386084826"></a><a href="ui_button-h.md">ui_button.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p861921355084826"><a name="p861921355084826"></a><a name="p861921355084826"></a>Defines the attributes and common functions of a button. </p>
</td>
</tr>
<tr id="row1750375264084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1510688086084826"><a name="p1510688086084826"></a><a name="p1510688086084826"></a><a href="ui_canvas-h.md">ui_canvas.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2042135885084826"><a name="p2042135885084826"></a><a name="p2042135885084826"></a>Defines the attributes of the canvas component and provides functions for drawing rectangles, circles, and others. </p>
</td>
</tr>
<tr id="row763288482084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p596470546084826"><a name="p596470546084826"></a><a name="p596470546084826"></a><a href="ui_chart-h.md">ui_chart.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1637557969084826"><a name="p1637557969084826"></a><a name="p1637557969084826"></a>Defines the attributes of the chart component and provides functions for adding and deleting data sets to display a chart. </p>
</td>
</tr>
<tr id="row2042929321084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1487274925084826"><a name="p1487274925084826"></a><a name="p1487274925084826"></a><a href="ui_checkbox-h.md">ui_checkbox.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1882152718084826"><a name="p1882152718084826"></a><a name="p1882152718084826"></a>Defines the attributes and common functions of a check box. </p>
</td>
</tr>
<tr id="row1173475837084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p860526771084826"><a name="p860526771084826"></a><a name="p860526771084826"></a><a href="ui_circle_progress-h.md">ui_circle_progress.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p124585732084826"><a name="p124585732084826"></a><a name="p124585732084826"></a>Defines the attributes and common functions of a circular progress bar. </p>
</td>
</tr>
<tr id="row1714307616084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1173890437084826"><a name="p1173890437084826"></a><a name="p1173890437084826"></a><a href="ui_dialog-h.md">ui_dialog.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p377928489084826"><a name="p377928489084826"></a><a name="p377928489084826"></a>Declares the UIDialog class that defines the dialog box component. </p>
</td>
</tr>
<tr id="row1505208542084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1539045881084826"><a name="p1539045881084826"></a><a name="p1539045881084826"></a><a href="ui_digital_clock-h.md">ui_digital_clock.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p437972348084826"><a name="p437972348084826"></a><a name="p437972348084826"></a>Declares a digital clock. </p>
</td>
</tr>
<tr id="row1395832410084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1433669966084826"><a name="p1433669966084826"></a><a name="p1433669966084826"></a><a href="ui_image_animator-h.md">ui_image_animator.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2130003160084826"><a name="p2130003160084826"></a><a name="p2130003160084826"></a>Defines the attributes and functions of an image animator. </p>
</td>
</tr>
<tr id="row266690915084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p641014151084826"><a name="p641014151084826"></a><a name="p641014151084826"></a><a href="ui_image_view-h.md">ui_image_view.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1308599991084826"><a name="p1308599991084826"></a><a name="p1308599991084826"></a>Declares an image view. </p>
</td>
</tr>
<tr id="row1039831173084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p230394285084826"><a name="p230394285084826"></a><a name="p230394285084826"></a><a href="ui_label-h.md">ui_label.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1722388413084826"><a name="p1722388413084826"></a><a name="p1722388413084826"></a>Declares a <strong id="b833703015084826"><a name="b833703015084826"></a><a name="b833703015084826"></a>UILabel</strong> class that represents a label. </p>
</td>
</tr>
<tr id="row174262606084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p574857261084826"><a name="p574857261084826"></a><a name="p574857261084826"></a><a href="ui_label_button-h.md">ui_label_button.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p664784040084826"><a name="p664784040084826"></a><a name="p664784040084826"></a>Declares a label button. </p>
</td>
</tr>
<tr id="row1870870395084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1013073179084826"><a name="p1013073179084826"></a><a name="p1013073179084826"></a><a href="ui_list-h.md">ui_list.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1585070453084826"><a name="p1585070453084826"></a><a name="p1585070453084826"></a>Declares a scrollable list in the vertical or horizontal direction. * This scrollable list can be used with the adapter <strong id="b1583525756084826"><a name="b1583525756084826"></a><a name="b1583525756084826"></a>AbstractAdapter</strong> to implement scrolling, inertial scrolling, automatic alignment, and invoking of a callback when a child view at the preset position is selected as this list scrolls. It is used when there is a large number of child views with a fixed format. </p>
</td>
</tr>
<tr id="row1435113070084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1005383130084826"><a name="p1005383130084826"></a><a name="p1005383130084826"></a><a href="ui_picker-h.md">ui_picker.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2078943010084826"><a name="p2078943010084826"></a><a name="p2078943010084826"></a>Defines the attributes and functions of the <strong id="b481804688084826"><a name="b481804688084826"></a><a name="b481804688084826"></a>UIPicker</strong> class. </p>
</td>
</tr>
<tr id="row1559134759084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1830325135084826"><a name="p1830325135084826"></a><a name="p1830325135084826"></a><a href="ui_radiobutton-h.md">ui_radiobutton.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1598498350084826"><a name="p1598498350084826"></a><a name="p1598498350084826"></a>Defines the attributes and common functions of a radio button. </p>
</td>
</tr>
<tr id="row1295331266084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p164756180084826"><a name="p164756180084826"></a><a name="p164756180084826"></a><a href="ui_scroll_view-h.md">ui_scroll_view.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p453174470084826"><a name="p453174470084826"></a><a name="p453174470084826"></a>Declares a view group that allows its child views to be displayed as scroll events occur. </p>
</td>
</tr>
<tr id="row68013663084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p150016069084826"><a name="p150016069084826"></a><a name="p150016069084826"></a><a href="ui_slider-h.md">ui_slider.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1202780820084826"><a name="p1202780820084826"></a><a name="p1202780820084826"></a>Defines the attributes and common functions of a slider. </p>
</td>
</tr>
<tr id="row130580892084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p490573368084826"><a name="p490573368084826"></a><a name="p490573368084826"></a><a href="ui_surface_view-h.md">ui_surface_view.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1053782219084826"><a name="p1053782219084826"></a><a name="p1053782219084826"></a>Declares the surface view that interacts with the multimedia to achieve camera preview and video playback. </p>
</td>
</tr>
<tr id="row1082503131084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1501404806084826"><a name="p1501404806084826"></a><a name="p1501404806084826"></a><a href="ui_swipe_view-h.md">ui_swipe_view.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p698490568084826"><a name="p698490568084826"></a><a name="p698490568084826"></a>Defines the attributes and common functions of a swipe view. </p>
</td>
</tr>
<tr id="row1886021124084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p614932071084826"><a name="p614932071084826"></a><a name="p614932071084826"></a><a href="ui_texture_mapper-h.md">ui_texture_mapper.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p330621654084826"><a name="p330621654084826"></a><a name="p330621654084826"></a>Defines the attributes and functions of a texture mapper. </p>
</td>
</tr>
<tr id="row2015704198084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p657456984084826"><a name="p657456984084826"></a><a name="p657456984084826"></a><a href="ui_time_picker-h.md">ui_time_picker.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p878849253084826"><a name="p878849253084826"></a><a name="p878849253084826"></a>Defines the attributes and functions of the <strong id="b1638728599084826"><a name="b1638728599084826"></a><a name="b1638728599084826"></a>UITimePicker</strong> class. </p>
</td>
</tr>
<tr id="row1198262839084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2042080857084826"><a name="p2042080857084826"></a><a name="p2042080857084826"></a><a href="ui_toggle_button-h.md">ui_toggle_button.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1724631755084826"><a name="p1724631755084826"></a><a name="p1724631755084826"></a>Defines the attributes and common functions of a toggle button. </p>
</td>
</tr>
<tr id="row364233985084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1548117578084826"><a name="p1548117578084826"></a><a name="p1548117578084826"></a><a href="ui_view-h.md">ui_view.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1340855306084826"><a name="p1340855306084826"></a><a name="p1340855306084826"></a>Declares the base class of a view, providing basic view attributes and operations. All views are derived from this class. </p>
</td>
</tr>
<tr id="row1176946327084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1941679163084826"><a name="p1941679163084826"></a><a name="p1941679163084826"></a><a href="ui_view_group-h.md">ui_view_group.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1200332467084826"><a name="p1200332467084826"></a><a name="p1200332467084826"></a>Declares a view group. </p>
</td>
</tr>
<tr id="row605891946084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p796488489084826"><a name="p796488489084826"></a><a name="p796488489084826"></a><a href="event_injector-h.md">event_injector.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1024734525084826"><a name="p1024734525084826"></a><a name="p1024734525084826"></a>Declares the function for simulating input events. </p>
</td>
</tr>
<tr id="row673326844084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1785063488084826"><a name="p1785063488084826"></a><a name="p1785063488084826"></a><a href="ui_dump_dom_tree-h.md">ui_dump_dom_tree.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1420039770084826"><a name="p1420039770084826"></a><a name="p1420039770084826"></a>Declares a function for exporting information about a Document Object Model (DOM) tree or DOM node. </p>
</td>
</tr>
<tr id="row196353290084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1491687984084826"><a name="p1491687984084826"></a><a name="p1491687984084826"></a><a href="ui_screenshot-h.md">ui_screenshot.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p481456366084826"><a name="p481456366084826"></a><a name="p481456366084826"></a>Declares the screenshot function. </p>
</td>
</tr>
<tr id="row252286183084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1249875244084826"><a name="p1249875244084826"></a><a name="p1249875244084826"></a><a href="aod_callback-h.md">aod_callback.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1805132054084826"><a name="p1805132054084826"></a><a name="p1805132054084826"></a>Defines the callback for the touch event notification in screen-off mode. </p>
</td>
</tr>
<tr id="row1077547417084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1999550930084826"><a name="p1999550930084826"></a><a name="p1999550930084826"></a><a href="cancel_event-h.md">cancel_event.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1557864395084826"><a name="p1557864395084826"></a><a name="p1557864395084826"></a>Declares a cancel event, which usually occurs when the target view changes due to user sliding. For example, this event is triggered if you, after pressing a button, does not release the button but slides. </p>
</td>
</tr>
<tr id="row2140339888084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1811266870084826"><a name="p1811266870084826"></a><a name="p1811266870084826"></a><a href="click_event-h.md">click_event.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p375780848084826"><a name="p375780848084826"></a><a name="p375780848084826"></a>Declares a click event, which indicates that a finger is pressed on the screen and then lifted within 1 second. </p>
</td>
</tr>
<tr id="row113576846084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p282093237084826"><a name="p282093237084826"></a><a name="p282093237084826"></a><a href="drag_event-h.md">drag_event.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p70075689084826"><a name="p70075689084826"></a><a name="p70075689084826"></a>Declares a drag event, which indicates a certain movement (more than 10 pixels) after a view is pressed. </p>
</td>
</tr>
<tr id="row361898290084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p931834773084826"><a name="p931834773084826"></a><a name="p931834773084826"></a><a href="event-h.md">event.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p676992519084826"><a name="p676992519084826"></a><a name="p676992519084826"></a>Declares the base class of a user input event and provides functions to record information such as the event position and timestamp. </p>
</td>
</tr>
<tr id="row1442774186084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p300461541084826"><a name="p300461541084826"></a><a name="p300461541084826"></a><a href="key_event-h.md">key_event.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p11390727084826"><a name="p11390727084826"></a><a name="p11390727084826"></a>Declares a key event, which indicates that a physical button is pressed or released. </p>
</td>
</tr>
<tr id="row1871652195084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p592926000084826"><a name="p592926000084826"></a><a name="p592926000084826"></a><a href="long_press_event-h.md">long_press_event.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p962332581084826"><a name="p962332581084826"></a><a name="p962332581084826"></a>Declares a long-press event, which indicates that the finger is not raised or moved within 1 second after a view is pressed. </p>
</td>
</tr>
<tr id="row993963672084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p453383909084826"><a name="p453383909084826"></a><a name="p453383909084826"></a><a href="press_event-h.md">press_event.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1841403480084826"><a name="p1841403480084826"></a><a name="p1841403480084826"></a>Declares a touch event, which indicates that the touchscreen or mouse is pressed. </p>
</td>
</tr>
<tr id="row45472249084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2112384935084826"><a name="p2112384935084826"></a><a name="p2112384935084826"></a><a href="release_event-h.md">release_event.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1870754221084826"><a name="p1870754221084826"></a><a name="p1870754221084826"></a>Declares a release event, which indicates that the touchscreen or mouse is released. </p>
</td>
</tr>
<tr id="row1881432546084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p271150171084826"><a name="p271150171084826"></a><a name="p271150171084826"></a><a href="virtual_device_event-h.md">virtual_device_event.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p519664319084826"><a name="p519664319084826"></a><a name="p519664319084826"></a>Declares a virtual device event, which is used to receive a customized input event and call back the listening function registered. </p>
</td>
</tr>
<tr id="row254669082084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1398488342084826"><a name="p1398488342084826"></a><a name="p1398488342084826"></a><a href="geometry2d-h.md">geometry2d.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1328088590084826"><a name="p1328088590084826"></a><a name="p1328088590084826"></a>Defines attributes of 2D geometries (including points, lines, rectangles, and polygons) of the lightweight graphics system and provides functions for performing operations on the geometries. </p>
</td>
</tr>
<tr id="row53767103084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1082099042084826"><a name="p1082099042084826"></a><a name="p1082099042084826"></a><a href="graphic_assert-h.md">graphic_assert.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p382677269084826"><a name="p382677269084826"></a><a name="p382677269084826"></a>Declares the assertion utility for the graphics module. </p>
</td>
</tr>
<tr id="row2038084044084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p63808128084826"><a name="p63808128084826"></a><a name="p63808128084826"></a><a href="graphic_config-h.md">graphic_config.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2141188124084826"><a name="p2141188124084826"></a><a name="p2141188124084826"></a>Provides configuration items required for graphics. </p>
</td>
</tr>
<tr id="row318304699084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1196606939084826"><a name="p1196606939084826"></a><a name="p1196606939084826"></a><a href="graphic_math-h.md">graphic_math.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p292478200084826"><a name="p292478200084826"></a><a name="p292478200084826"></a>Defines mathematical operation functions and types, including trigonometric functions, two-dimensional vectors, three-dimensional vectors, and matrices. </p>
</td>
</tr>
<tr id="row1178693309084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2081955804084826"><a name="p2081955804084826"></a><a name="p2081955804084826"></a><a href="graphic_types-h.md">graphic_types.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1504097249084826"><a name="p1504097249084826"></a><a name="p1504097249084826"></a>Defines the common data types for the graphics system. </p>
</td>
</tr>
<tr id="row1497968686084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p903029582084826"><a name="p903029582084826"></a><a name="p903029582084826"></a><a href="heap_base-h.md">heap_base.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p838173029084826"><a name="p838173029084826"></a><a name="p838173029084826"></a>Declares the functions for overriding the <strong id="b1700487375084826"><a name="b1700487375084826"></a><a name="b1700487375084826"></a>new</strong> and <strong id="b567179436084826"><a name="b567179436084826"></a><a name="b567179436084826"></a>delete</strong> functions. </p>
</td>
</tr>
<tr id="row412035915084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1019739359084826"><a name="p1019739359084826"></a><a name="p1019739359084826"></a><a href="image_info-h.md">image_info.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1248194923084826"><a name="p1248194923084826"></a><a name="p1248194923084826"></a>Defines image information. </p>
</td>
</tr>
<tr id="row242696209084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p480264125084826"><a name="p480264125084826"></a><a name="p480264125084826"></a><a href="flex_layout-h.md">flex_layout.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p409302743084826"><a name="p409302743084826"></a><a name="p409302743084826"></a>Declares a flexible layout container. You can perform simple adaptive layout on child views that the container holds, for example, to evenly arrange all child views in the same row or column. </p>
</td>
</tr>
<tr id="row828566239084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p686654246084826"><a name="p686654246084826"></a><a name="p686654246084826"></a><a href="grid_layout-h.md">grid_layout.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p385132965084826"><a name="p385132965084826"></a><a name="p385132965084826"></a>Declares a grid layout container. You can perform simple grid layout on child views that the container holds. </p>
</td>
</tr>
<tr id="row560236204084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1744597990084826"><a name="p1744597990084826"></a><a name="p1744597990084826"></a><a href="layout-h.md">layout.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p145138689084826"><a name="p145138689084826"></a><a name="p145138689084826"></a>Declares the base class of the layout, which indicates the basic data types and operations that may be used in the layout. </p>
</td>
</tr>
<tr id="row671598020084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p366273085084826"><a name="p366273085084826"></a><a name="p366273085084826"></a><a href="list-h.md">list.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1511429261084826"><a name="p1511429261084826"></a><a name="p1511429261084826"></a>Defines a linked list template class, which implements the data structure of bidirectional linked list and provides basic functions such as adding, deleting, inserting, clearing, popping up, and obtaining the size of the linked list. </p>
</td>
</tr>
<tr id="row839427397084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1046664626084826"><a name="p1046664626084826"></a><a name="p1046664626084826"></a><a href="mem_api-h.md">mem_api.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p845578118084826"><a name="p845578118084826"></a><a name="p845578118084826"></a>Defines the functions for memory application and release. You can implement the <strong id="b1751003831084826"><a name="b1751003831084826"></a><a name="b1751003831084826"></a>malloc</strong> and <strong id="b1926635647084826"><a name="b1926635647084826"></a><a name="b1926635647084826"></a>free</strong> functions to manage the memory. </p>
</td>
</tr>
<tr id="row873716062084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1060216620084826"><a name="p1060216620084826"></a><a name="p1060216620084826"></a><a href="rect-h.md">rect.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p629249683084826"><a name="p629249683084826"></a><a name="p629249683084826"></a>Defines a rectangle, including the position data of the four boundaries of the rectangle, and provides functions for rectangle inclusion, intersection, and aggregation. </p>
</td>
</tr>
<tr id="row270601520084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2056819597084826"><a name="p2056819597084826"></a><a name="p2056819597084826"></a><a href="style-h.md">style.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1872005310084826"><a name="p1872005310084826"></a><a name="p1872005310084826"></a>Defines the attributes and common functions of style. </p>
</td>
</tr>
<tr id="row1900568743084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p414292437084826"><a name="p414292437084826"></a><a name="p414292437084826"></a><a href="sys_info-h.md">sys_info.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2032563240084826"><a name="p2032563240084826"></a><a name="p2032563240084826"></a>Declares the system information about the graphics module, including the function to obtain the information about FPS, which needs to be enabled by the <strong id="b862575660084826"><a name="b862575660084826"></a><a name="b862575660084826"></a>ENABLE_FPS_SUPPORT</strong> macro. </p>
</td>
</tr>
<tr id="row1467597853084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1080034035084826"><a name="p1080034035084826"></a><a name="p1080034035084826"></a><a href="theme-h.md">theme.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p430730566084826"><a name="p430730566084826"></a><a name="p430730566084826"></a>Declares the base class used to define the functions related to the styles of different components. </p>
</td>
</tr>
<tr id="row64107779084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2091423447084826"><a name="p2091423447084826"></a><a name="p2091423447084826"></a><a href="theme_manager-h.md">theme_manager.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p940061395084826"><a name="p940061395084826"></a><a name="p940061395084826"></a>Declares the singleton class used to manage the current screen theme of an application. </p>
</td>
</tr>
<tr id="row1748890760084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1628769085084826"><a name="p1628769085084826"></a><a name="p1628769085084826"></a><a href="transform-h.md">transform.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1965109589084826"><a name="p1965109589084826"></a><a name="p1965109589084826"></a>Provides functions to transform components, points, and line segments, including rotation and scaling. </p>
</td>
</tr>
<tr id="row59906639084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1739663091084826"><a name="p1739663091084826"></a><a name="p1739663091084826"></a><a href="version-h.md">version.h</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p557543817084826"><a name="p557543817084826"></a><a name="p557543817084826"></a>Declares the version number control for the graphics module. This file defines functions to obtain the version number and library description. </p>
</td>
</tr>
</tbody>
</table>

## Data Structures<a name="nested-classes"></a>

<a name="table1571831516084826"></a>
<table><thead align="left"><tr id="row1653927721084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1771650542084826"><a name="p1771650542084826"></a><a name="p1771650542084826"></a>Data Structure Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p750274669084826"><a name="p750274669084826"></a><a name="p750274669084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row197696968084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p444512672084826"><a name="p444512672084826"></a><a name="p444512672084826"></a><a href="OHOS-AnimatorCallback.md">OHOS::AnimatorCallback</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1063744100084826"><a name="p1063744100084826"></a><a name="p1063744100084826"></a>Represents the animator callback. </p>
</td>
</tr>
<tr id="row1069983568084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p806722122084826"><a name="p806722122084826"></a><a name="p806722122084826"></a><a href="OHOS-Animator.md">OHOS::Animator</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p769100383084826"><a name="p769100383084826"></a><a name="p769100383084826"></a>Represents an animator. </p>
</td>
</tr>
<tr id="row291546973084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1428301909084826"><a name="p1428301909084826"></a><a name="p1428301909084826"></a><a href="OHOS-AnimatorManager.md">OHOS::AnimatorManager</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1106866939084826"><a name="p1106866939084826"></a><a name="p1106866939084826"></a>Represents the animator manager. </p>
</td>
</tr>
<tr id="row622367415084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1188870253084826"><a name="p1188870253084826"></a><a name="p1188870253084826"></a><a href="OHOS-EasingEquation.md">OHOS::EasingEquation</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p581837392084826"><a name="p581837392084826"></a><a name="p581837392084826"></a>Defines functions for specifying the velocity of an animation. </p>
</td>
</tr>
<tr id="row647312920084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1670402941084826"><a name="p1670402941084826"></a><a name="p1670402941084826"></a><a href="OHOS-Interpolation.md">OHOS::Interpolation</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p623932683084826"><a name="p623932683084826"></a><a name="p623932683084826"></a>Calculates the Bezier interpolation. </p>
</td>
</tr>
<tr id="row2086495024084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1212254697084826"><a name="p1212254697084826"></a><a name="p1212254697084826"></a><a href="OHOS-Color16.md">OHOS::Color16</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1061884078084826"><a name="p1061884078084826"></a><a name="p1061884078084826"></a>Defines the color attribute when the color depth is <strong id="b894933843084826"><a name="b894933843084826"></a><a name="b894933843084826"></a>16</strong>. </p>
</td>
</tr>
<tr id="row838603539084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1541726351084826"><a name="p1541726351084826"></a><a name="p1541726351084826"></a><a href="OHOS-Color24.md">OHOS::Color24</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1136372841084826"><a name="p1136372841084826"></a><a name="p1136372841084826"></a>Defines the color attribute when the color depth is <strong id="b1025416677084826"><a name="b1025416677084826"></a><a name="b1025416677084826"></a>24</strong>. </p>
</td>
</tr>
<tr id="row1258529655084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p529831429084826"><a name="p529831429084826"></a><a name="p529831429084826"></a><a href="OHOS-Color32.md">OHOS::Color32</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p491751517084826"><a name="p491751517084826"></a><a name="p491751517084826"></a>Defines the color attribute when the color depth is <strong id="b991007184084826"><a name="b991007184084826"></a><a name="b991007184084826"></a>32</strong>. </p>
</td>
</tr>
<tr id="row2122969333084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1691709560084826"><a name="p1691709560084826"></a><a name="p1691709560084826"></a><a href="OHOS-Color.md">OHOS::Color</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2012343545084826"><a name="p2012343545084826"></a><a name="p2012343545084826"></a>Converts colors in different formats and defines common colors. </p>
</td>
</tr>
<tr id="row1014739043084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1022157280084826"><a name="p1022157280084826"></a><a name="p1022157280084826"></a><a href="OHOS-Image.md">OHOS::Image</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1995771151084826"><a name="p1995771151084826"></a><a name="p1995771151084826"></a>Represents basic image attributes, including the image type and path. </p>
</td>
</tr>
<tr id="row1566295475084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1187352551084826"><a name="p1187352551084826"></a><a name="p1187352551084826"></a><a href="OHOS-Screen.md">OHOS::Screen</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1283025331084826"><a name="p1283025331084826"></a><a name="p1283025331084826"></a>Represents the screen info of the device. </p>
</td>
</tr>
<tr id="row1719129014084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p209838906084826"><a name="p209838906084826"></a><a name="p209838906084826"></a><a href="OHOS-Task.md">OHOS::Task</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p41545014084826"><a name="p41545014084826"></a><a name="p41545014084826"></a>Represents the <strong id="b1309324043084826"><a name="b1309324043084826"></a><a name="b1309324043084826"></a><a href="OHOS-Task.md">Task</a></strong> class of the graphics module. This class provides functions for setting the running period and time of a task. </p>
</td>
</tr>
<tr id="row2138613796084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1488196911084826"><a name="p1488196911084826"></a><a name="p1488196911084826"></a><a href="OHOS-Text.md">OHOS::Text</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p903323746084826"><a name="p903323746084826"></a><a name="p903323746084826"></a>Represents the base class of <strong id="b315394258084826"><a name="b315394258084826"></a><a name="b315394258084826"></a><a href="OHOS-Text.md">Text</a></strong>, providing the text attribute setting and text drawing capabilities for components that require font display. </p>
</td>
</tr>
<tr id="row1722936604084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p233392982084826"><a name="p233392982084826"></a><a name="p233392982084826"></a><a href="OHOS-AbstractAdapter.md">OHOS::AbstractAdapter</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p761713848084826"><a name="p761713848084826"></a><a name="p761713848084826"></a>Defines the base class for adapters. You can derive <strong id="b1122979640084826"><a name="b1122979640084826"></a><a name="b1122979640084826"></a><a href="OHOS-AbstractAdapter.md">AbstractAdapter</a></strong> based on actual requirements and use the <strong id="b336966352084826"><a name="b336966352084826"></a><a name="b336966352084826"></a><a href="Graphic.md#gab155b2f4a6d8fd97755dcd1e6d3d8361">GetView()</a></strong> and <strong id="b18256039084826"><a name="b18256039084826"></a><a name="b18256039084826"></a><a href="Graphic.md#ga67021b360d4097c475d5e24519b5276d">GetCount()</a></strong> functions to implement adapters of different data types. For details, see <a href="OHOS-TextAdapter.md">TextAdapter</a>. </p>
</td>
</tr>
<tr id="row157586588084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p556875697084826"><a name="p556875697084826"></a><a name="p556875697084826"></a><a href="OHOS-RootView-OnKeyActListener.md">OHOS::RootView::OnKeyActListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1559784349084826"><a name="p1559784349084826"></a><a name="p1559784349084826"></a>Represents the listener for monitoring physical key events. </p>
</td>
</tr>
<tr id="row484853542084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p388350177084826"><a name="p388350177084826"></a><a name="p388350177084826"></a><a href="OHOS-RootView-OnVirtualDeviceEventListener.md">OHOS::RootView::OnVirtualDeviceEventListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p401636409084826"><a name="p401636409084826"></a><a name="p401636409084826"></a>Listens for the input events triggered by a virtual device other than human touching or physical pressing. </p>
</td>
</tr>
<tr id="row874501277084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1386082662084826"><a name="p1386082662084826"></a><a name="p1386082662084826"></a><a href="OHOS-RootView.md">OHOS::RootView</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2059012619084826"><a name="p2059012619084826"></a><a name="p2059012619084826"></a>Defines the functions related to a root view which contains its child views and represents the root node in a tree structure. </p>
</td>
</tr>
<tr id="row1018774798084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1594620434084826"><a name="p1594620434084826"></a><a name="p1594620434084826"></a><a href="OHOS-TextFormatter.md">OHOS::TextFormatter</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p594831722084826"><a name="p594831722084826"></a><a name="p594831722084826"></a>Defines a text formatter. You can inherit this class and implement the <strong id="b1753475688084826"><a name="b1753475688084826"></a><a name="b1753475688084826"></a><a href="Graphic.md#ga183cac282667493fa2a008f9a7f4f9d2">Format()</a></strong> function. </p>
</td>
</tr>
<tr id="row15343177084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2024421977084826"><a name="p2024421977084826"></a><a name="p2024421977084826"></a><a href="OHOS-TextAdapter.md">OHOS::TextAdapter</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1024501885084826"><a name="p1024501885084826"></a><a name="p1024501885084826"></a>Defines a text adapter, which implements <a href="OHOS-UILabel.md">UILabel</a> instance construction and supports text data and continuous integer data. </p>
</td>
</tr>
<tr id="row371497762084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2065713147084826"><a name="p2065713147084826"></a><a name="p2065713147084826"></a><a href="OHOS-UIAbstractClock.md">OHOS::UIAbstractClock</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p924548521084826"><a name="p924548521084826"></a><a name="p924548521084826"></a>An abstract class that contains functions for converting units of time (hour, minute, and second), setting and obtaining the time. </p>
</td>
</tr>
<tr id="row2114097166084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p870645451084826"><a name="p870645451084826"></a><a name="p870645451084826"></a><a href="OHOS-UIAbstractProgress.md">OHOS::UIAbstractProgress</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1930275478084826"><a name="p1930275478084826"></a><a name="p1930275478084826"></a>Represents the abstract base class which provides functions related to the progress bar. </p>
</td>
</tr>
<tr id="row1517871660084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2073821068084826"><a name="p2073821068084826"></a><a name="p2073821068084826"></a><a href="OHOS-UIAbstractScroll.md">OHOS::UIAbstractScroll</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1319831315084826"><a name="p1319831315084826"></a><a name="p1319831315084826"></a>Defines the attributes of a scroll, including the scroll direction, blank size of a scroll view, velocity and effects of a scroll animation. </p>
</td>
</tr>
<tr id="row1959725000084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1335750329084826"><a name="p1335750329084826"></a><a name="p1335750329084826"></a><a href="OHOS-UIAnalogClock-Hand.md">OHOS::UIAnalogClock::Hand</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p733530675084826"><a name="p733530675084826"></a><a name="p733530675084826"></a>Defines the basic attributes of the analog clock hands. This is an inner class of <strong id="b1242109722084826"><a name="b1242109722084826"></a><a name="b1242109722084826"></a><a href="OHOS-UIAbstractClock.md">UIAbstractClock</a></strong>. </p>
</td>
</tr>
<tr id="row424139443084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1368503152084826"><a name="p1368503152084826"></a><a name="p1368503152084826"></a><a href="OHOS-UIAnalogClock.md">OHOS::UIAnalogClock</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p707764444084826"><a name="p707764444084826"></a><a name="p707764444084826"></a>Provides the functions related to an analog clock. </p>
</td>
</tr>
<tr id="row595297996084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1316760792084826"><a name="p1316760792084826"></a><a name="p1316760792084826"></a><a href="OHOS-UIArcLabel-ArcTextInfo.md">OHOS::UIArcLabel::ArcTextInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p164442915084826"><a name="p164442915084826"></a><a name="p164442915084826"></a>Stores the attribute information about this arc text to draw. </p>
</td>
</tr>
<tr id="row1662914848084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1664878051084826"><a name="p1664878051084826"></a><a name="p1664878051084826"></a><a href="OHOS-UIArcLabel.md">OHOS::UIArcLabel</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p533072955084826"><a name="p533072955084826"></a><a name="p533072955084826"></a>Defines functions related to an arc label. </p>
</td>
</tr>
<tr id="row671858225084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p737410550084826"><a name="p737410550084826"></a><a name="p737410550084826"></a><a href="OHOS-UIAxis.md">OHOS::UIAxis</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2134678042084826"><a name="p2134678042084826"></a><a name="p2134678042084826"></a>Represents the coordinate axis base class, which defines the basic attributes of coordinate axis, sets whether a coordinate axis is visible, and sets the number of scales on a coordinate axis. This class is used in <a href="OHOS-UIChart.md">UIChart</a>. </p>
</td>
</tr>
<tr id="row305958019084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p91287951084826"><a name="p91287951084826"></a><a name="p91287951084826"></a><a href="OHOS-UIXAxis.md">OHOS::UIXAxis</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p698259145084826"><a name="p698259145084826"></a><a name="p698259145084826"></a>Defines the unique attributes and functions for the x-axis. This class is used in <a href="OHOS-UIChart.md">UIChart</a>. </p>
</td>
</tr>
<tr id="row2045749452084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p470062299084826"><a name="p470062299084826"></a><a name="p470062299084826"></a><a href="OHOS-UIYAxis.md">OHOS::UIYAxis</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p177047609084826"><a name="p177047609084826"></a><a name="p177047609084826"></a>Defines the unique attributes and functions for the y-axis. This class is used in <a href="OHOS-UIChart.md">UIChart</a>. </p>
</td>
</tr>
<tr id="row271198750084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1360054115084826"><a name="p1360054115084826"></a><a name="p1360054115084826"></a><a href="OHOS-UIBoxProgress.md">OHOS::UIBoxProgress</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1205314967084826"><a name="p1205314967084826"></a><a name="p1205314967084826"></a>Represents a linear progress bar. </p>
</td>
</tr>
<tr id="row1539427402084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1798844930084826"><a name="p1798844930084826"></a><a name="p1798844930084826"></a><a href="OHOS-UIButton.md">OHOS::UIButton</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2021851387084826"><a name="p2021851387084826"></a><a name="p2021851387084826"></a>Represents a button. </p>
</td>
</tr>
<tr id="row473398017084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p579367338084826"><a name="p579367338084826"></a><a name="p579367338084826"></a><a href="OHOS-Paint.md">OHOS::Paint</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1193092364084826"><a name="p1193092364084826"></a><a name="p1193092364084826"></a>Defines the basic styles of graphs drawn on canvases. </p>
</td>
</tr>
<tr id="row620224632084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1691458539084826"><a name="p1691458539084826"></a><a name="p1691458539084826"></a><a href="OHOS-UICanvas-FontStyle.md">OHOS::UICanvas::FontStyle</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p638883855084826"><a name="p638883855084826"></a><a name="p638883855084826"></a>Defines the font style. </p>
</td>
</tr>
<tr id="row1140083834084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p493576817084826"><a name="p493576817084826"></a><a name="p493576817084826"></a><a href="OHOS-UICanvas.md">OHOS::UICanvas</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p521433355084826"><a name="p521433355084826"></a><a name="p521433355084826"></a>Defines a canvas, which is used to draw multiple types of 2D graphs. </p>
</td>
</tr>
<tr id="row1310787845084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2086703646084826"><a name="p2086703646084826"></a><a name="p2086703646084826"></a><a href="OHOS-UIChartDataSerial-PointStyle.md">OHOS::UIChartDataSerial::PointStyle</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1682954325084826"><a name="p1682954325084826"></a><a name="p1682954325084826"></a>Defines the style for the top, bottom, and frontmost points in a line chart. </p>
</td>
</tr>
<tr id="row1476805926084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1681782694084826"><a name="p1681782694084826"></a><a name="p1681782694084826"></a><a href="OHOS-UIChartDataSerial.md">OHOS::UIChartDataSerial</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p120150944084826"><a name="p120150944084826"></a><a name="p120150944084826"></a>Defines a data set and provides functions such as adding and deleting data points. </p>
</td>
</tr>
<tr id="row1194755871084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p375084702084826"><a name="p375084702084826"></a><a name="p375084702084826"></a><a href="OHOS-UIChart.md">OHOS::UIChart</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p909208828084826"><a name="p909208828084826"></a><a name="p909208828084826"></a>Defines the chart class and provides functions such as adding and deleting data sets to display a chart. </p>
</td>
</tr>
<tr id="row781905697084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2027746472084826"><a name="p2027746472084826"></a><a name="p2027746472084826"></a><a href="OHOS-UIChartPillar.md">OHOS::UIChartPillar</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p488448535084826"><a name="p488448535084826"></a><a name="p488448535084826"></a>Provides special functions for implementing a bar chart. </p>
</td>
</tr>
<tr id="row881798226084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p489352959084826"><a name="p489352959084826"></a><a name="p489352959084826"></a><a href="OHOS-UIChartPolyline.md">OHOS::UIChartPolyline</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1758600688084826"><a name="p1758600688084826"></a><a name="p1758600688084826"></a>Provides special functions for implementing a polyline. </p>
</td>
</tr>
<tr id="row657418390084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1471530091084826"><a name="p1471530091084826"></a><a name="p1471530091084826"></a><a href="OHOS-UICheckBox-OnChangeListener.md">OHOS::UICheckBox::OnChangeListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p451745615084826"><a name="p451745615084826"></a><a name="p451745615084826"></a>Represents a listener for changes of a check box. </p>
</td>
</tr>
<tr id="row2075299011084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2062051077084826"><a name="p2062051077084826"></a><a name="p2062051077084826"></a><a href="OHOS-UICheckBox.md">OHOS::UICheckBox</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1599851845084826"><a name="p1599851845084826"></a><a name="p1599851845084826"></a>Represents a check box. </p>
</td>
</tr>
<tr id="row1790713900084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p524073029084826"><a name="p524073029084826"></a><a name="p524073029084826"></a><a href="OHOS-UICircleProgress.md">OHOS::UICircleProgress</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1036271701084826"><a name="p1036271701084826"></a><a name="p1036271701084826"></a>Represents a circular progress bar. </p>
</td>
</tr>
<tr id="row18143138084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1484284999084826"><a name="p1484284999084826"></a><a name="p1484284999084826"></a><a href="OHOS-UIDialog.md">OHOS::UIDialog</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p916850410084826"><a name="p916850410084826"></a><a name="p916850410084826"></a>Represents a dialog box. </p>
</td>
</tr>
<tr id="row1657339824084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1896290951084826"><a name="p1896290951084826"></a><a name="p1896290951084826"></a><a href="OHOS-UIDigitalClock.md">OHOS::UIDigitalClock</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1935797155084826"><a name="p1935797155084826"></a><a name="p1935797155084826"></a>Displays time digitally. </p>
</td>
</tr>
<tr id="row1424913804084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1247633934084826"><a name="p1247633934084826"></a><a name="p1247633934084826"></a><a href="OHOS-ImageAnimatorInfo.md">OHOS::ImageAnimatorInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1569210105084826"><a name="p1569210105084826"></a><a name="p1569210105084826"></a>Provides information about the images. </p>
</td>
</tr>
<tr id="row1356626883084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p334973050084826"><a name="p334973050084826"></a><a name="p334973050084826"></a><a href="OHOS-UIImageAnimatorView-AnimatorStopListener.md">OHOS::UIImageAnimatorView::AnimatorStopListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p126383727084826"><a name="p126383727084826"></a><a name="p126383727084826"></a>Represents a listener that contains a callback to be invoked when this animator stops. </p>
</td>
</tr>
<tr id="row1069030011084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2142041983084826"><a name="p2142041983084826"></a><a name="p2142041983084826"></a><a href="OHOS-UIImageAnimatorView.md">OHOS::UIImageAnimatorView</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p75442426084826"><a name="p75442426084826"></a><a name="p75442426084826"></a>Represents an image animator. </p>
</td>
</tr>
<tr id="row1580889867084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1049255856084826"><a name="p1049255856084826"></a><a name="p1049255856084826"></a><a href="OHOS-UIImageView.md">OHOS::UIImageView</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p995822487084826"><a name="p995822487084826"></a><a name="p995822487084826"></a>Defines the functions related to an image view. </p>
</td>
</tr>
<tr id="row1269302404084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2048302034084826"><a name="p2048302034084826"></a><a name="p2048302034084826"></a><a href="OHOS-UILabel.md">OHOS::UILabel</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p393729883084826"><a name="p393729883084826"></a><a name="p393729883084826"></a>Defines the functions for presenting a label in a specified area, setting the style and background color of a label, and setting the display mode of a long label text. </p>
</td>
</tr>
<tr id="row567870959084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1507896915084826"><a name="p1507896915084826"></a><a name="p1507896915084826"></a><a href="OHOS-UILabelButton.md">OHOS::UILabelButton</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p504091282084826"><a name="p504091282084826"></a><a name="p504091282084826"></a>Provides the functions related to a label button. </p>
</td>
</tr>
<tr id="row187037608084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p572756458084826"><a name="p572756458084826"></a><a name="p572756458084826"></a><a href="OHOS-ListScrollListener.md">OHOS::ListScrollListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1038573812084826"><a name="p1038573812084826"></a><a name="p1038573812084826"></a>Represents a listener that contains a callback to be invoked when the scroll state changes or when a new child view is selected at the preset position as this list scrolls. The scroll state can be {<strong id="b2017587755084826"><a name="b2017587755084826"></a><a name="b2017587755084826"></a>} or SCROLL_STATE_MOVE}. </strong> </p>
</td>
</tr>
<tr id="row751588519084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p534616605084826"><a name="p534616605084826"></a><a name="p534616605084826"></a><a href="OHOS-UIList.md">OHOS::UIList</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1401290506084826"><a name="p1401290506084826"></a><a name="p1401290506084826"></a>Represents a scrollable list which is used with the adapter <a href="OHOS-AbstractAdapter.md">AbstractAdapter</a> to implement scrolling, inertial scrolling, automatic alignment, and invoking of a callback when a child view is selected at the preset position as this list scrolls. </p>
</td>
</tr>
<tr id="row187772574084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1460511981084826"><a name="p1460511981084826"></a><a name="p1460511981084826"></a><a href="OHOS-UIPicker-SelectedListener.md">OHOS::UIPicker::SelectedListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p939308104084826"><a name="p939308104084826"></a><a name="p939308104084826"></a>Defines the listener used by a picker. This listener is triggered when an item is selected after sliding stops. </p>
</td>
</tr>
<tr id="row162986760084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p875027824084826"><a name="p875027824084826"></a><a name="p875027824084826"></a><a href="OHOS-UIPicker.md">OHOS::UIPicker</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1252717084826"><a name="p1252717084826"></a><a name="p1252717084826"></a>Defines a picker. Multiple texts or numbers can be put into a sliding list for selection. The selected text or numbers are highlighted. </p>
</td>
</tr>
<tr id="row954197855084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p111451843084826"><a name="p111451843084826"></a><a name="p111451843084826"></a><a href="OHOS-UIRadioButton.md">OHOS::UIRadioButton</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p938089944084826"><a name="p938089944084826"></a><a name="p938089944084826"></a>Represents a radio button. </p>
</td>
</tr>
<tr id="row1730591173084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1137016997084826"><a name="p1137016997084826"></a><a name="p1137016997084826"></a><a href="OHOS-UIRepeatButton.md">OHOS::UIRepeatButton</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2090913378084826"><a name="p2090913378084826"></a><a name="p2090913378084826"></a>Represents a repeat button. </p>
</td>
</tr>
<tr id="row2097599598084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1777217472084826"><a name="p1777217472084826"></a><a name="p1777217472084826"></a><a href="OHOS-UIScrollView-OnScrollListener.md">OHOS::UIScrollView::OnScrollListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1786402806084826"><a name="p1786402806084826"></a><a name="p1786402806084826"></a>Represents a listener that contains a callback to be invoked upon scroll state changes. The state can either be <strong id="b1370625189084826"><a name="b1370625189084826"></a><a name="b1370625189084826"></a>SCROLL_STATE_STOP</strong> or <strong id="b192769033084826"><a name="b192769033084826"></a><a name="b192769033084826"></a>SCROLL_STATE_MOVE</strong>. </p>
</td>
</tr>
<tr id="row455324227084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1808971056084826"><a name="p1808971056084826"></a><a name="p1808971056084826"></a><a href="OHOS-UIScrollView.md">OHOS::UIScrollView</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2118149318084826"><a name="p2118149318084826"></a><a name="p2118149318084826"></a>Supports horizontal or vertical scroll of child views. This class is inherited from <a href="OHOS-UIAbstractScroll.md">UIAbstractScroll</a>. </p>
</td>
</tr>
<tr id="row1059770386084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1159957792084826"><a name="p1159957792084826"></a><a name="p1159957792084826"></a><a href="OHOS-UISlider-UISliderEventListener.md">OHOS::UISlider::UISliderEventListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p742371321084826"><a name="p742371321084826"></a><a name="p742371321084826"></a>Represents the listener for a slider change. </p>
</td>
</tr>
<tr id="row1518208967084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p501405447084826"><a name="p501405447084826"></a><a name="p501405447084826"></a><a href="OHOS-UISlider.md">OHOS::UISlider</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p459426061084826"><a name="p459426061084826"></a><a name="p459426061084826"></a>Represents a slider. </p>
</td>
</tr>
<tr id="row1650961301084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1687098309084826"><a name="p1687098309084826"></a><a name="p1687098309084826"></a><a href="OHOS-UISurfaceView.md">OHOS::UISurfaceView</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1490172388084826"><a name="p1490172388084826"></a><a name="p1490172388084826"></a>Represents a surface view that interacts with the multimedia to achieve camera preview and video playback. </p>
</td>
</tr>
<tr id="row639281025084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1399956601084826"><a name="p1399956601084826"></a><a name="p1399956601084826"></a><a href="OHOS-UISwipeView-OnSwipeListener.md">OHOS::UISwipeView::OnSwipeListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1100710043084826"><a name="p1100710043084826"></a><a name="p1100710043084826"></a>Represents a listener for changes of the swipe view. </p>
</td>
</tr>
<tr id="row511932472084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p568265233084826"><a name="p568265233084826"></a><a name="p568265233084826"></a><a href="OHOS-UISwipeView.md">OHOS::UISwipeView</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p159953338084826"><a name="p159953338084826"></a><a name="p159953338084826"></a>Represents a swipe view. </p>
</td>
</tr>
<tr id="row858168277084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1520771635084826"><a name="p1520771635084826"></a><a name="p1520771635084826"></a><a href="OHOS-UITextureMapper-AnimatorStopListener.md">OHOS::UITextureMapper::AnimatorStopListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1330515607084826"><a name="p1330515607084826"></a><a name="p1330515607084826"></a>Represents a listener that contains a callback to be invoked when this animator stops. </p>
</td>
</tr>
<tr id="row920182064084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2107381097084826"><a name="p2107381097084826"></a><a name="p2107381097084826"></a><a href="OHOS-UITextureMapper.md">OHOS::UITextureMapper</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p940351322084826"><a name="p940351322084826"></a><a name="p940351322084826"></a>Rotates and scales images. </p>
</td>
</tr>
<tr id="row1125024392084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p228503729084826"><a name="p228503729084826"></a><a name="p228503729084826"></a><a href="OHOS-UITimePicker-SelectedListener.md">OHOS::UITimePicker::SelectedListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p38682181084826"><a name="p38682181084826"></a><a name="p38682181084826"></a>Defines the listener used by the time picker. This listener is triggered when an item is selected after sliding stops. </p>
</td>
</tr>
<tr id="row1539581089084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p983592820084826"><a name="p983592820084826"></a><a name="p983592820084826"></a><a href="OHOS-UITimePicker.md">OHOS::UITimePicker</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1403672399084826"><a name="p1403672399084826"></a><a name="p1403672399084826"></a>Defines the time picker. The time is in the format of "hour:minute" or "hour:minute:second". The selected time is highlighted. </p>
</td>
</tr>
<tr id="row2002698507084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1591402722084826"><a name="p1591402722084826"></a><a name="p1591402722084826"></a><a href="OHOS-UIToggleButton.md">OHOS::UIToggleButton</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1418063512084826"><a name="p1418063512084826"></a><a name="p1418063512084826"></a>Represents a toggle button. </p>
</td>
</tr>
<tr id="row1800183889084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1124449655084826"><a name="p1124449655084826"></a><a name="p1124449655084826"></a><a href="OHOS-UIView-OnClickListener.md">OHOS::UIView::OnClickListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p708945514084826"><a name="p708945514084826"></a><a name="p708945514084826"></a>Defines a click event listener. You need to register this listener with the view to listen to click events. </p>
</td>
</tr>
<tr id="row657887672084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1312830629084826"><a name="p1312830629084826"></a><a name="p1312830629084826"></a><a href="OHOS-UIView-OnLongPressListener.md">OHOS::UIView::OnLongPressListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1330749807084826"><a name="p1330749807084826"></a><a name="p1330749807084826"></a>Defines a long-press event listener. You need to register this listener with the view to listen to long-press events. </p>
</td>
</tr>
<tr id="row455985646084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p55737437084826"><a name="p55737437084826"></a><a name="p55737437084826"></a><a href="OHOS-UIView-OnDragListener.md">OHOS::UIView::OnDragListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2053862970084826"><a name="p2053862970084826"></a><a name="p2053862970084826"></a>Defines a drag event listener. You need to register this listener with the view to listen to drag events. </p>
</td>
</tr>
<tr id="row828700465084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p538522648084826"><a name="p538522648084826"></a><a name="p538522648084826"></a><a href="OHOS-UIView-OnTouchListener.md">OHOS::UIView::OnTouchListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1900464627084826"><a name="p1900464627084826"></a><a name="p1900464627084826"></a>Defines a touch event listener. You need to register this listener with the view to listen to touch events. </p>
</td>
</tr>
<tr id="row986267142084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1359327830084826"><a name="p1359327830084826"></a><a name="p1359327830084826"></a><a href="OHOS-UIView.md">OHOS::UIView</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1312617826084826"><a name="p1312617826084826"></a><a name="p1312617826084826"></a>Defines the base class of a view, providing basic view attributes and operations. All views are derived from this class. </p>
</td>
</tr>
<tr id="row1818508958084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1287077710084826"><a name="p1287077710084826"></a><a name="p1287077710084826"></a><a href="OHOS-UIViewGroup.md">OHOS::UIViewGroup</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1636237250084826"><a name="p1636237250084826"></a><a name="p1636237250084826"></a>Represents a view group that consists of its child views. </p>
</td>
</tr>
<tr id="row1190706865084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1945218803084826"><a name="p1945218803084826"></a><a name="p1945218803084826"></a><a href="OHOS-UIDumpDomTree.md">OHOS::UIDumpDomTree</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1071011524084826"><a name="p1071011524084826"></a><a name="p1071011524084826"></a>Provides functions for exporting information about a specified DOM node or information about the DOM tree starting from a specified DOM node. </p>
</td>
</tr>
<tr id="row1307105780084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1995233521084826"><a name="p1995233521084826"></a><a name="p1995233521084826"></a><a href="OHOS-CancelEvent.md">OHOS::CancelEvent</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1761059186084826"><a name="p1761059186084826"></a><a name="p1761059186084826"></a>Defines a cancel event, which usually occurs when the target view changes due to user sliding. For example, this event is triggered if you, after pressing a button, does not release the button but slides. </p>
</td>
</tr>
<tr id="row29379719084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1251304772084826"><a name="p1251304772084826"></a><a name="p1251304772084826"></a><a href="OHOS-ClickEvent.md">OHOS::ClickEvent</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p896492910084826"><a name="p896492910084826"></a><a name="p896492910084826"></a>Defines a click event, which indicates that a finger is pressed on the screen and then lifted within 1 second. </p>
</td>
</tr>
<tr id="row140453711084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p504606360084826"><a name="p504606360084826"></a><a name="p504606360084826"></a><a href="OHOS-DragEvent.md">OHOS::DragEvent</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1991576526084826"><a name="p1991576526084826"></a><a name="p1991576526084826"></a>Defines a drag event, which indicates a certain movement (more than 10 pixels) after a view is pressed. </p>
</td>
</tr>
<tr id="row649759339084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p96971881084826"><a name="p96971881084826"></a><a name="p96971881084826"></a><a href="OHOS-Event.md">OHOS::Event</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1758453572084826"><a name="p1758453572084826"></a><a name="p1758453572084826"></a>Defines the base class of a user input event and provides functions to record information such as the event position and timestamp. </p>
</td>
</tr>
<tr id="row1137362819084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p433611888084826"><a name="p433611888084826"></a><a name="p433611888084826"></a><a href="OHOS-KeyEvent.md">OHOS::KeyEvent</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1700304012084826"><a name="p1700304012084826"></a><a name="p1700304012084826"></a>Defines a key event, which indicates that a physical button is pressed or released. </p>
</td>
</tr>
<tr id="row1761988209084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1001746983084826"><a name="p1001746983084826"></a><a name="p1001746983084826"></a><a href="OHOS-LongPressEvent.md">OHOS::LongPressEvent</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p200521978084826"><a name="p200521978084826"></a><a name="p200521978084826"></a>Defines a long-press event, which indicates that the finger is not raised or moved within 1 second after a view is pressed. </p>
</td>
</tr>
<tr id="row1166541414084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1986502559084826"><a name="p1986502559084826"></a><a name="p1986502559084826"></a><a href="OHOS-PressEvent.md">OHOS::PressEvent</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p351838674084826"><a name="p351838674084826"></a><a name="p351838674084826"></a>Defines a touch event, which indicates that the touchscreen or mouse is pressed. </p>
</td>
</tr>
<tr id="row1682517374084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p560257245084826"><a name="p560257245084826"></a><a name="p560257245084826"></a><a href="OHOS-ReleaseEvent.md">OHOS::ReleaseEvent</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2126001237084826"><a name="p2126001237084826"></a><a name="p2126001237084826"></a>Defines a release event, which indicates that the touchscreen or mouse is released. </p>
</td>
</tr>
<tr id="row748961049084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p130320674084826"><a name="p130320674084826"></a><a name="p130320674084826"></a><a href="OHOS-VirtualDeviceEvent.md">OHOS::VirtualDeviceEvent</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1914294695084826"><a name="p1914294695084826"></a><a name="p1914294695084826"></a>Defines a virtual device event, which is used to receive a customized input event and call back the listening function registered. </p>
</td>
</tr>
<tr id="row1929087507084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p561134364084826"><a name="p561134364084826"></a><a name="p561134364084826"></a><a href="OHOS-Line.md">OHOS::Line</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p299029938084826"><a name="p299029938084826"></a><a name="p299029938084826"></a>Defines a line, which consists of the start and end points. </p>
</td>
</tr>
<tr id="row316411409084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1896493823084826"><a name="p1896493823084826"></a><a name="p1896493823084826"></a><a href="OHOS-Polygon.md">OHOS::Polygon</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1659891991084826"><a name="p1659891991084826"></a><a name="p1659891991084826"></a>Defines a polygon, including vertex coordinates and the maximum number of vertices (defined by <a href="Graphic.md#gafff78acb69e2b147b6f33d68e570ef54">MAX_VERTEX_NUM</a>). </p>
</td>
</tr>
<tr id="row2055299618084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p529483362084826"><a name="p529483362084826"></a><a name="p529483362084826"></a><a href="OHOS-Vector2-T.md">OHOS::Vector2&lt; T &gt;</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2010158964084826"><a name="p2010158964084826"></a><a name="p2010158964084826"></a>Defines the two-dimensional vector, and provides basic mathematical operations such as vector assignment, scalar product, cross product, addition, and subtraction. </p>
</td>
</tr>
<tr id="row1073641300084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1259699207084826"><a name="p1259699207084826"></a><a name="p1259699207084826"></a><a href="OHOS-Vector3-T.md">OHOS::Vector3&lt; T &gt;</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1838007154084826"><a name="p1838007154084826"></a><a name="p1838007154084826"></a>Defines the 3-dimensional vector, and provides basic operators such as [] and ==. </p>
</td>
</tr>
<tr id="row766316541084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p631789115084826"><a name="p631789115084826"></a><a name="p631789115084826"></a><a href="OHOS-Matrix3-T.md">OHOS::Matrix3&lt; T &gt;</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p516405523084826"><a name="p516405523084826"></a><a name="p516405523084826"></a>Defines a 3 x 3 matrix. </p>
</td>
</tr>
<tr id="row17721561084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p430645168084826"><a name="p430645168084826"></a><a name="p430645168084826"></a><a href="OHOS-Point.md">OHOS::Point</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p823806629084826"><a name="p823806629084826"></a><a name="p823806629084826"></a>Defines a point. </p>
</td>
</tr>
<tr id="row340203413084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1796607251084826"><a name="p1796607251084826"></a><a name="p1796607251084826"></a><a href="OHOS-HeapBase.md">OHOS::HeapBase</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1082288425084826"><a name="p1082288425084826"></a><a name="p1082288425084826"></a>Defines the base class, overriding the <strong id="b1452040271084826"><a name="b1452040271084826"></a><a name="b1452040271084826"></a>new</strong> and <strong id="b2023492519084826"><a name="b2023492519084826"></a><a name="b2023492519084826"></a>delete</strong> functions. </p>
</td>
</tr>
<tr id="row1493861209084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p814897327084826"><a name="p814897327084826"></a><a name="p814897327084826"></a><a href="OHOS-ImageHeader.md">OHOS::ImageHeader</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1275126325084826"><a name="p1275126325084826"></a><a name="p1275126325084826"></a>Defines image head node information. </p>
</td>
</tr>
<tr id="row723219222084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p573947499084826"><a name="p573947499084826"></a><a name="p573947499084826"></a><a href="OHOS-ImageInfo.md">OHOS::ImageInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1871552576084826"><a name="p1871552576084826"></a><a name="p1871552576084826"></a>Defines image information. </p>
</td>
</tr>
<tr id="row93633718084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1132404027084826"><a name="p1132404027084826"></a><a name="p1132404027084826"></a><a href="OHOS-FlexLayout.md">OHOS::FlexLayout</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1318619327084826"><a name="p1318619327084826"></a><a name="p1318619327084826"></a>Defines a flexible layout container. You can perform simple adaptive layout on child views that the container holds, for example, to evenly arrange all child views in the same row or column. </p>
</td>
</tr>
<tr id="row1695161778084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p882662415084826"><a name="p882662415084826"></a><a name="p882662415084826"></a><a href="OHOS-GridLayout.md">OHOS::GridLayout</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1002214170084826"><a name="p1002214170084826"></a><a name="p1002214170084826"></a>Defines a grid layout container. You can perform simple grid layout on child views that the container holds. </p>
</td>
</tr>
<tr id="row488701326084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p421690869084826"><a name="p421690869084826"></a><a name="p421690869084826"></a><a href="OHOS-Layout.md">OHOS::Layout</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1492910609084826"><a name="p1492910609084826"></a><a name="p1492910609084826"></a>Defines the base class of the layout, which indicates the basic data types and operations that may be used in the layout. </p>
</td>
</tr>
<tr id="row1884054232084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1110052179084826"><a name="p1110052179084826"></a><a name="p1110052179084826"></a><a href="OHOS-ListNode-T.md">OHOS::ListNode&lt; T &gt;</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p671566413084826"><a name="p671566413084826"></a><a name="p671566413084826"></a>Stores linked list data and contains pointers to the previous node and the next node. </p>
</td>
</tr>
<tr id="row1478966443084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1328478023084826"><a name="p1328478023084826"></a><a name="p1328478023084826"></a><a href="OHOS-List-T.md">OHOS::List&lt; T &gt;</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1791412693084826"><a name="p1791412693084826"></a><a name="p1791412693084826"></a>Defines a linked list template class, which implements the data structure of bidirectional linked list and provides basic functions such as adding, deleting, inserting, clearing, popping up, and obtaining the size of the linked list. </p>
</td>
</tr>
<tr id="row609050611084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1186105965084826"><a name="p1186105965084826"></a><a name="p1186105965084826"></a><a href="OHOS-Rect.md">OHOS::Rect</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1546442886084826"><a name="p1546442886084826"></a><a name="p1546442886084826"></a>Defines a rectangle, including the position data of the four boundaries of the rectangle, and provides functions for rectangle inclusion, intersection, and aggregation. </p>
</td>
</tr>
<tr id="row1899827675084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1003932898084826"><a name="p1003932898084826"></a><a name="p1003932898084826"></a><a href="OHOS-Style.md">OHOS::Style</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p250221572084826"><a name="p250221572084826"></a><a name="p250221572084826"></a>Defines the basic attributes and functions of a style. You can use this class to set different styles. </p>
</td>
</tr>
<tr id="row1155996435084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p710907551084826"><a name="p710907551084826"></a><a name="p710907551084826"></a><a href="OHOS-StyleDefault.md">OHOS::StyleDefault</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1869528389084826"><a name="p1869528389084826"></a><a name="p1869528389084826"></a>Define some default style for <a href="OHOS-UIView.md">UIView</a>. </p>
</td>
</tr>
<tr id="row1744404826084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p950353068084826"><a name="p950353068084826"></a><a name="p950353068084826"></a><a href="OHOS-SysInfo-OnFPSChangedListener.md">OHOS::SysInfo::OnFPSChangedListener</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p446529259084826"><a name="p446529259084826"></a><a name="p446529259084826"></a>Called when the FPS changes. </p>
</td>
</tr>
<tr id="row1955134011084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1839996912084826"><a name="p1839996912084826"></a><a name="p1839996912084826"></a><a href="OHOS-SysInfo.md">OHOS::SysInfo</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1094810014084826"><a name="p1094810014084826"></a><a name="p1094810014084826"></a>Obtains the system information. Currently, the FPS information can be obtained. To enable the FPS feature, enable the <strong id="b558514222084826"><a name="b558514222084826"></a><a name="b558514222084826"></a>ENABLE_FPS_SUPPORT</strong> macro. </p>
</td>
</tr>
<tr id="row827780700084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1852040752084826"><a name="p1852040752084826"></a><a name="p1852040752084826"></a><a href="OHOS-ButtonStyle.md">OHOS::ButtonStyle</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1906964410084826"><a name="p1906964410084826"></a><a name="p1906964410084826"></a>Stores styles of a button in its different states. </p>
</td>
</tr>
<tr id="row1719594750084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p236448125084826"><a name="p236448125084826"></a><a name="p236448125084826"></a><a href="OHOS-Theme.md">OHOS::Theme</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2124835545084826"><a name="p2124835545084826"></a><a name="p2124835545084826"></a>Defines the theme class used to define the functions related to the styles of different components. </p>
</td>
</tr>
<tr id="row802200940084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1958914624084826"><a name="p1958914624084826"></a><a name="p1958914624084826"></a><a href="OHOS-ThemeManager.md">OHOS::ThemeManager</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p892684969084826"><a name="p892684969084826"></a><a name="p892684969084826"></a>Declares the singleton class used to manage the current screen theme of an application. </p>
</td>
</tr>
<tr id="row411376642084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1889484844084826"><a name="p1889484844084826"></a><a name="p1889484844084826"></a><a href="OHOS-TransformMap.md">OHOS::TransformMap</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1317316907084826"><a name="p1317316907084826"></a><a name="p1317316907084826"></a>Transforms a rectangle, including rotation and scaling. </p>
</td>
</tr>
</tbody>
</table>

## Macros<a name="define-members"></a>

<a name="table1560274919084826"></a>
<table><thead align="left"><tr id="row639977612084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1308299040084826"><a name="p1308299040084826"></a><a name="p1308299040084826"></a>Macro Name and Value</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1038848283084826"><a name="p1038848283084826"></a><a name="p1038848283084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1324213421084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1736913157084826"><a name="p1736913157084826"></a><a name="p1736913157084826"></a><a href="Graphic.md#ga2017774de578acba5afd77793c00205b">VERSION_STANDARD</a></p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">&nbsp;</td>
</tr>
<tr id="row926192079084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1544458106084826"><a name="p1544458106084826"></a><a name="p1544458106084826"></a><em id="ga3d83acf19f4d5c59f7a29b6b29440dd2"><a name="ga3d83acf19f4d5c59f7a29b6b29440dd2"></a><a name="ga3d83acf19f4d5c59f7a29b6b29440dd2"></a></em>ENABLE_DMA2D &nbsp;&nbsp;&nbsp;0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2005070240084826"><a name="p2005070240084826"></a><a name="p2005070240084826"></a>DMA2D hardware acceleration, which does not take effect on other platforms. </p>
</td>
</tr>
<tr id="row779246288084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1868582128084826"><a name="p1868582128084826"></a><a name="p1868582128084826"></a><em id="gaef5d32e398c657450011db566a5fad04"><a name="gaef5d32e398c657450011db566a5fad04"></a><a name="gaef5d32e398c657450011db566a5fad04"></a></em>ENABLE_DMA2D_TEXT &nbsp;&nbsp;&nbsp;0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p847908517084826"><a name="p847908517084826"></a><a name="p847908517084826"></a>DMA2D hardware acceleration for font rendering, which does not take effect on other platforms. </p>
</td>
</tr>
<tr id="row1301077639084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1994095038084826"><a name="p1994095038084826"></a><a name="p1994095038084826"></a><em id="ga1a28113245f31cacd0afacc80c7d12c1"><a name="ga1a28113245f31cacd0afacc80c7d12c1"></a><a name="ga1a28113245f31cacd0afacc80c7d12c1"></a></em>ENABLE_ICU &nbsp;&nbsp;&nbsp;0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p158936094084826"><a name="p158936094084826"></a><a name="p158936094084826"></a>Advanced algorithm for line breaks, which is disabled by default on other platforms. </p>
</td>
</tr>
<tr id="row1044404223084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1331155994084826"><a name="p1331155994084826"></a><a name="p1331155994084826"></a><em id="ga8fffdbb807e226013ce790500b5c88e2"><a name="ga8fffdbb807e226013ce790500b5c88e2"></a><a name="ga8fffdbb807e226013ce790500b5c88e2"></a></em>ENABLE_WINDOW &nbsp;&nbsp;&nbsp;1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1553662078084826"><a name="p1553662078084826"></a><a name="p1553662078084826"></a>Multi-window, which is enabled by default on other platforms. </p>
</td>
</tr>
<tr id="row2048055742084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1021799488084826"><a name="p1021799488084826"></a><a name="p1021799488084826"></a><em id="gaf319cb3be43a211a63f2ea97a1c3ae6d"><a name="gaf319cb3be43a211a63f2ea97a1c3ae6d"></a><a name="gaf319cb3be43a211a63f2ea97a1c3ae6d"></a></em>ENABLE_FRAME_BUFFER &nbsp;&nbsp;&nbsp;0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p259077180084826"><a name="p259077180084826"></a><a name="p259077180084826"></a>Display buffer for rendering data refresh, which is disabled by default on other platforms. </p>
</td>
</tr>
<tr id="row2088844409084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1817351523084826"><a name="p1817351523084826"></a><a name="p1817351523084826"></a><em id="ga2c3acabc94a483bd191a250f67c1f43b"><a name="ga2c3acabc94a483bd191a250f67c1f43b"></a><a name="ga2c3acabc94a483bd191a250f67c1f43b"></a></em>ENABLE_VECTOR_FONT &nbsp;&nbsp;&nbsp;1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p148937762084826"><a name="p148937762084826"></a><a name="p148937762084826"></a>Vector type font，which is enabled by default on other platforms. </p>
</td>
</tr>
<tr id="row1094797531084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p845446070084826"><a name="p845446070084826"></a><a name="p845446070084826"></a><em id="ga8f198e8500b353e58b618b331f768f27"><a name="ga8f198e8500b353e58b618b331f768f27"></a><a name="ga8f198e8500b353e58b618b331f768f27"></a></em>ENABLE_BUFFER_RGBA &nbsp;&nbsp;&nbsp;1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p782357682084826"><a name="p782357682084826"></a><a name="p782357682084826"></a>Graphics bottom-layer RGBA, which is enabled by default. </p>
</td>
</tr>
<tr id="row33369060084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1395340339084826"><a name="p1395340339084826"></a><a name="p1395340339084826"></a><em id="ga8508eb8cc5346dbdc552a9fbc11dbb06"><a name="ga8508eb8cc5346dbdc552a9fbc11dbb06"></a><a name="ga8508eb8cc5346dbdc552a9fbc11dbb06"></a></em>ENABLE_HARDWARE_ACCELERATION &nbsp;&nbsp;&nbsp;1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p310378625084826"><a name="p310378625084826"></a><a name="p310378625084826"></a>Graphics rendering hardware acceleration, which is enabled by default. </p>
</td>
</tr>
<tr id="row792734910084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p619142874084826"><a name="p619142874084826"></a><a name="p619142874084826"></a><em id="ga432138093c53d7580af9ec5c5dca387f"><a name="ga432138093c53d7580af9ec5c5dca387f"></a><a name="ga432138093c53d7580af9ec5c5dca387f"></a></em>ENABLE_DEBUG &nbsp;&nbsp;&nbsp;1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1129511902084826"><a name="p1129511902084826"></a><a name="p1129511902084826"></a>Debug mode, which is disabled by default. </p>
</td>
</tr>
<tr id="row841497100084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1357047885084826"><a name="p1357047885084826"></a><a name="p1357047885084826"></a><em id="gaa492b15de59b36af68c10a65952dc870"><a name="gaa492b15de59b36af68c10a65952dc870"></a><a name="gaa492b15de59b36af68c10a65952dc870"></a></em>ENABLE_MEMORY_HOOKS &nbsp;&nbsp;&nbsp;0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p603751190084826"><a name="p603751190084826"></a><a name="p603751190084826"></a>Memory hook, which is enabled by default. The system memory allocation is taken over after it is enabled. </p>
</td>
</tr>
<tr id="row218877329084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1945109432084826"><a name="p1945109432084826"></a><a name="p1945109432084826"></a><em id="ga4c1dffa1615941394d376b12a8fbdf24"><a name="ga4c1dffa1615941394d376b12a8fbdf24"></a><a name="ga4c1dffa1615941394d376b12a8fbdf24"></a></em>ENABLE_FPS_SUPPORT &nbsp;&nbsp;&nbsp;0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p908307066084826"><a name="p908307066084826"></a><a name="p908307066084826"></a>Function for monitoring the image refresh frame rate, which is disabled by default. </p>
</td>
</tr>
<tr id="row1154471505084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1189424501084826"><a name="p1189424501084826"></a><a name="p1189424501084826"></a><em id="ga2e63917ecfb73182bcea30104c497bc9"><a name="ga2e63917ecfb73182bcea30104c497bc9"></a><a name="ga2e63917ecfb73182bcea30104c497bc9"></a></em>ENABLE_ANTIALIAS &nbsp;&nbsp;&nbsp;1</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p582620985084826"><a name="p582620985084826"></a><a name="p582620985084826"></a>Anti-aliasing, which is enabled by default. </p>
</td>
</tr>
<tr id="row562927870084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1176085459084826"><a name="p1176085459084826"></a><a name="p1176085459084826"></a><em id="gaade33b264d4ea661ff8f36976908b4ba"><a name="gaade33b264d4ea661ff8f36976908b4ba"></a><a name="gaade33b264d4ea661ff8f36976908b4ba"></a></em>ENABLE_RECT_ANTIALIAS &nbsp;&nbsp;&nbsp;0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2063114611084826"><a name="p2063114611084826"></a><a name="p2063114611084826"></a><a href="Rectangle.md">Rectangle</a> anti-aliasing, which is disabled by default. </p>
</td>
</tr>
<tr id="row1688520705084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p738763112084826"><a name="p738763112084826"></a><a name="p738763112084826"></a><em id="ga733acdcb7c5872a7b864ae108cd86413"><a name="ga733acdcb7c5872a7b864ae108cd86413"></a><a name="ga733acdcb7c5872a7b864ae108cd86413"></a></em>ENABLE_SPEC_FONT &nbsp;&nbsp;&nbsp;0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p61105723084826"><a name="p61105723084826"></a><a name="p61105723084826"></a>Font color mode, which is disabled by default. After it is enabled, the font color mode is set to <strong id="b1893752792084826"><a name="b1893752792084826"></a><a name="b1893752792084826"></a>4</strong> to accelerate font rendering. </p>
</td>
</tr>
<tr id="row1448617931084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p844508638084826"><a name="p844508638084826"></a><a name="p844508638084826"></a><em id="ga703e1a14b7cccc8074986836c5c1de02"><a name="ga703e1a14b7cccc8074986836c5c1de02"></a><a name="ga703e1a14b7cccc8074986836c5c1de02"></a></em>ENABLE_GRAPHIC_LOG &nbsp;&nbsp;&nbsp;0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p942138574084826"><a name="p942138574084826"></a><a name="p942138574084826"></a>Log function of a graphics subsystem, which is disabled by default. </p>
</td>
</tr>
<tr id="row665415358084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2078097362084826"><a name="p2078097362084826"></a><a name="p2078097362084826"></a><em id="ga31b6586b78d550c8b08abb87c8ae8d0b"><a name="ga31b6586b78d550c8b08abb87c8ae8d0b"></a><a name="ga31b6586b78d550c8b08abb87c8ae8d0b"></a></em>ENABLE_AOD &nbsp;&nbsp;&nbsp;0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p968100001084826"><a name="p968100001084826"></a><a name="p968100001084826"></a>Function for receiving input events in screen-off mode, which is disabled by default. </p>
</td>
</tr>
<tr id="row1469967028084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1241182905084826"><a name="p1241182905084826"></a><a name="p1241182905084826"></a><em id="gaca8a42c138892758d4d3252dddbd1373"><a name="gaca8a42c138892758d4d3252dddbd1373"></a><a name="gaca8a42c138892758d4d3252dddbd1373"></a></em>GRAPHIC_LOG_LEVEL &nbsp;&nbsp;&nbsp;5</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p235192186084826"><a name="p235192186084826"></a><a name="p235192186084826"></a>Defines the log level. A smaller value indicates a higher priority. Logs whose priorities are higher than a specified level can be recorded. Log levels: NONE: disabling logs FATAL: fatal level ERROR: error level WARN: warning level INFO: info level DEBUG: debugging level. </p>
</td>
</tr>
<tr id="row850871711084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p653172828084826"><a name="p653172828084826"></a><a name="p653172828084826"></a><em id="ga70d330906276a996f7dab090a03ce2a5"><a name="ga70d330906276a996f7dab090a03ce2a5"></a><a name="ga70d330906276a996f7dab090a03ce2a5"></a></em>COLOR_DEPTH &nbsp;&nbsp;&nbsp;32</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1817309910084826"><a name="p1817309910084826"></a><a name="p1817309910084826"></a>Defines the color depth of graphics rendering. The default value is <strong id="b2097777116084826"><a name="b2097777116084826"></a><a name="b2097777116084826"></a>32</strong> bits. The value can be <strong id="b197497829084826"><a name="b197497829084826"></a><a name="b197497829084826"></a>16</strong> or <strong id="b2110542394084826"><a name="b2110542394084826"></a><a name="b2110542394084826"></a>32</strong>. </p>
</td>
</tr>
<tr id="row937131671084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2132353358084826"><a name="p2132353358084826"></a><a name="p2132353358084826"></a><em id="ga78a7a5cd4bd7deb45047b3ca9f088fb6"><a name="ga78a7a5cd4bd7deb45047b3ca9f088fb6"></a><a name="ga78a7a5cd4bd7deb45047b3ca9f088fb6"></a></em>DEFAULT_VECTOR_FONT_FILENAME &nbsp;&nbsp;&nbsp;"SourceHanSansSC-Regular.otf"</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p493769343084826"><a name="p493769343084826"></a><a name="p493769343084826"></a>Defines the file name of default vector font. </p>
</td>
</tr>
<tr id="row1857477340084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1916058943084826"><a name="p1916058943084826"></a><a name="p1916058943084826"></a><em id="ga3e18a38ff2f4dbf813d85d14ae7cc7f6"><a name="ga3e18a38ff2f4dbf813d85d14ae7cc7f6"></a><a name="ga3e18a38ff2f4dbf813d85d14ae7cc7f6"></a></em>MATH_MAX (a, b)&nbsp;&nbsp;&nbsp;((a) &gt; (b) ? (a) : (b))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1649099748084826"><a name="p1649099748084826"></a><a name="p1649099748084826"></a>Larger of a and b. </p>
</td>
</tr>
<tr id="row1630440630084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p523061502084826"><a name="p523061502084826"></a><a name="p523061502084826"></a><em id="ga0707ec809a1938e6b07386ce8e403313"><a name="ga0707ec809a1938e6b07386ce8e403313"></a><a name="ga0707ec809a1938e6b07386ce8e403313"></a></em>MATH_MIN (a, b)&nbsp;&nbsp;&nbsp;((a) &lt; (b) ? (a) : (b))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1856333608084826"><a name="p1856333608084826"></a><a name="p1856333608084826"></a>Smaller of a and b. </p>
</td>
</tr>
<tr id="row1700697920084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1835850051084826"><a name="p1835850051084826"></a><a name="p1835850051084826"></a><em id="ga1336a0214be7acc7fb308f2f88542e39"><a name="ga1336a0214be7acc7fb308f2f88542e39"></a><a name="ga1336a0214be7acc7fb308f2f88542e39"></a></em>MATH_ABS (x)&nbsp;&nbsp;&nbsp;((x) &gt; 0 ? (x) : (-(x)))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p29758974084826"><a name="p29758974084826"></a><a name="p29758974084826"></a>Absolute value of x. </p>
</td>
</tr>
<tr id="row1627866012084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p813042415084826"><a name="p813042415084826"></a><a name="p813042415084826"></a><em id="ga16f420abdb8bee5c5323d203fa1ca43b"><a name="ga16f420abdb8bee5c5323d203fa1ca43b"></a><a name="ga16f420abdb8bee5c5323d203fa1ca43b"></a></em>MATH_MINUS (a, b)&nbsp;&nbsp;&nbsp;((a) &lt; (b) ? ((b) - (a)) : ((a) - (b)))</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p931547340084826"><a name="p931547340084826"></a><a name="p931547340084826"></a>Difference between a and b. </p>
</td>
</tr>
</tbody>
</table>

## Typedefs<a name="typedef-members"></a>

<a name="table680066962084826"></a>
<table><thead align="left"><tr id="row728802377084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1859283131084826"><a name="p1859283131084826"></a><a name="p1859283131084826"></a>Typedef Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1335044665084826"><a name="p1335044665084826"></a><a name="p1335044665084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2032289393084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1435707308084826"><a name="p1435707308084826"></a><a name="p1435707308084826"></a><a href="Graphic.md#gaf04c41bb7b151a6e8be2012cc9e6475b">OHOS::EasingFunc</a>) (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p569097695084826"><a name="p569097695084826"></a><a name="p569097695084826"></a>typedef int16_t(*&nbsp;</p>
<p id="p169956940084826"><a name="p169956940084826"></a><a name="p169956940084826"></a>Calculates the value for the current time of an animation. </p>
</td>
</tr>
</tbody>
</table>

## Enumerations<a name="enum-members"></a>

<a name="table715450202084826"></a>
<table><thead align="left"><tr id="row299517905084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1473421713084826"><a name="p1473421713084826"></a><a name="p1473421713084826"></a>Enumeration Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p333962645084826"><a name="p333962645084826"></a><a name="p333962645084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row724150614084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p238963683084826"><a name="p238963683084826"></a><a name="p238963683084826"></a>: uint8_t { <a href="Graphic.md#gga7b892afa4e88ab11bf96dbd67653f134a6618a5c1c0e9e4be3acba1aaee15cb8d">OHOS::Animator::STOP</a>, <a href="Graphic.md#gga7b892afa4e88ab11bf96dbd67653f134a49f9e652157f467df5de3be9e8758f91">OHOS::Animator::START</a>, <a href="Graphic.md#gga7b892afa4e88ab11bf96dbd67653f134ae5db6c9a921eec21a2990d73400ff507">OHOS::Animator::PAUSE</a>, <a href="Graphic.md#gga7b892afa4e88ab11bf96dbd67653f134a6ef6036766e105b2cd6bf2fb94e92e1b">OHOS::Animator::RUNNING</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1256374409084826"><a name="p1256374409084826"></a><a name="p1256374409084826"></a>Enumerates the states of this animator. </p>
</td>
</tr>
<tr id="row658898972084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p27226963084826"><a name="p27226963084826"></a><a name="p27226963084826"></a>{ <a href="Graphic.md#gga15e4f5bc0221d99ea7d46dc54328566ead4bd10bef3f1df05fd29e023050b9cca">OHOS::OPA_TRANSPARENT</a> = 0, <a href="Graphic.md#gga15e4f5bc0221d99ea7d46dc54328566eaebcfc69c18e2c29c89f800d95f32754f">OHOS::OPA_OPAQUE</a> = 255 }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1968285152084826"><a name="p1968285152084826"></a><a name="p1968285152084826"></a>Enumerates opacity values. </p>
</td>
</tr>
<tr id="row1185454037084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p624551557084826"><a name="p624551557084826"></a><a name="p624551557084826"></a><a href="Graphic.md#ga3f99b58f731a37cacde72d5e0c934593">OHOS::UITextLanguageAlignment</a> : uint8_t { &nbsp;&nbsp;<a href="Graphic.md#gga3f99b58f731a37cacde72d5e0c934593a37453e521c390e6157ac2efff1197a43">OHOS::TEXT_ALIGNMENT_LEFT</a> = 0, <a href="Graphic.md#gga3f99b58f731a37cacde72d5e0c934593af6fdcea7d95056a0bab016ba7bee66bd">OHOS::TEXT_ALIGNMENT_RIGHT</a>, <a href="Graphic.md#gga3f99b58f731a37cacde72d5e0c934593a1dd445f9b6987a84a7022885ea13c81c">OHOS::TEXT_ALIGNMENT_CENTER</a>, <a href="Graphic.md#gga3f99b58f731a37cacde72d5e0c934593a33dfd4e235bcc2f6f42f4efc8c8264a2">OHOS::TEXT_ALIGNMENT_TOP</a>, &nbsp;&nbsp;<a href="Graphic.md#gga3f99b58f731a37cacde72d5e0c934593aa7798629aa2199c86cb668e94115186c">OHOS::TEXT_ALIGNMENT_BOTTOM</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p327941997084826"><a name="p327941997084826"></a><a name="p327941997084826"></a>Enumerates text alignment modes. </p>
</td>
</tr>
<tr id="row1124905412084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p907835235084826"><a name="p907835235084826"></a><a name="p907835235084826"></a><a href="Graphic.md#ga0c108f97781843f67c101b47b6c00cf0">OHOS::UITextLanguageDirect</a> : uint8_t { <a href="Graphic.md#gga0c108f97781843f67c101b47b6c00cf0a387cedfce95a736f28a1c2748086b1a9">OHOS::TEXT_DIRECT_LTR</a> = 0, <a href="Graphic.md#gga0c108f97781843f67c101b47b6c00cf0a76658b82f45d4136910ded0c22afe7f8">OHOS::TEXT_DIRECT_RTL</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1030582751084826"><a name="p1030582751084826"></a><a name="p1030582751084826"></a>Enumerates text directions. </p>
</td>
</tr>
<tr id="row2047930914084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p670283159084826"><a name="p670283159084826"></a><a name="p670283159084826"></a><a href="Graphic.md#ga19db90932bc71e6bbced6ccf2935ac98">OHOS::UIAbstractClock::WorkMode</a> { <a href="Graphic.md#gga19db90932bc71e6bbced6ccf2935ac98a2025ac1a1f63409f0b37f444547ec859">OHOS::UIAbstractClock::ALWAYS_ON</a>, <a href="Graphic.md#gga19db90932bc71e6bbced6ccf2935ac98a8d32f103a422c6675618f5e9773b2eaa">OHOS::UIAbstractClock::NORMAL</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2101933489084826"><a name="p2101933489084826"></a><a name="p2101933489084826"></a>Enumerates the working modes of this clock. </p>
</td>
</tr>
<tr id="row1789332309084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1860435788084826"><a name="p1860435788084826"></a><a name="p1860435788084826"></a><a href="Graphic.md#ga13cf64ea5bd39550976aaf65b1381edf">OHOS::UIAnalogClock::HandType</a> { <a href="Graphic.md#gga13cf64ea5bd39550976aaf65b1381edfa2b8ab55559dff5a849bf7445f6865958">OHOS::UIAnalogClock::HandType::HOUR_HAND</a>, <a href="Graphic.md#gga13cf64ea5bd39550976aaf65b1381edfa50ddc7aea61ec54878c173e1423af447">OHOS::UIAnalogClock::HandType::MINUTE_HAND</a>, <a href="Graphic.md#gga13cf64ea5bd39550976aaf65b1381edfa620c615d18fdb1b23ed04df57842909d">OHOS::UIAnalogClock::HandType::SECOND_HAND</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1497327124084826"><a name="p1497327124084826"></a><a name="p1497327124084826"></a>Enumerates the clock hand types. </p>
</td>
</tr>
<tr id="row1184187205084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p133519288084826"><a name="p133519288084826"></a><a name="p133519288084826"></a><a href="Graphic.md#ga0a595eeb50ce4e7dfff9ede16098d2db">OHOS::UIAnalogClock::DrawType</a> { <a href="Graphic.md#gga0a595eeb50ce4e7dfff9ede16098d2dba6ddf16010fbdac5db23575583cb8a388">OHOS::UIAnalogClock::DrawType::DRAW_LINE</a>, <a href="Graphic.md#gga0a595eeb50ce4e7dfff9ede16098d2dba5cb6a362b1dec2b19422e9e9a6bbda3c">OHOS::UIAnalogClock::DrawType::DRAW_IMAGE</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1839516535084826"><a name="p1839516535084826"></a><a name="p1839516535084826"></a>Enumerates the drawing types of a clock hand. </p>
</td>
</tr>
<tr id="row1406418340084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p61013825084826"><a name="p61013825084826"></a><a name="p61013825084826"></a><a href="Graphic.md#ga0778527bee4a7ddd8d46395585a5cfb9">OHOS::UIArcLabel::TextOrientation</a> : uint8_t { <a href="Graphic.md#gga0778527bee4a7ddd8d46395585a5cfb9a554a7418c4c0dafd902ebd377b87c80c">OHOS::UIArcLabel::TextOrientation::INSIDE</a>, <a href="Graphic.md#gga0778527bee4a7ddd8d46395585a5cfb9a93da25bafef6761717afc6b25c17ea16">OHOS::UIArcLabel::TextOrientation::OUTSIDE</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1845916592084826"><a name="p1845916592084826"></a><a name="p1845916592084826"></a>Enumerates text orientations. </p>
</td>
</tr>
<tr id="row1336421311084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1310076860084826"><a name="p1310076860084826"></a><a name="p1310076860084826"></a><a href="Graphic.md#ga4a7a2c192206c8b18379f42a5fd176eb">OHOS::UIBoxProgress::Direction</a> : uint8_t { <a href="Graphic.md#gga4a7a2c192206c8b18379f42a5fd176eba43cb7d46f0e18f315d43b82024093b51">OHOS::UIBoxProgress::Direction::DIR_LEFT_TO_RIGHT</a>, <a href="Graphic.md#gga4a7a2c192206c8b18379f42a5fd176eba49e31df5a7fc02ee8c2f85b5e15f0145">OHOS::UIBoxProgress::Direction::DIR_RIGHT_TO_LEFT</a>, <a href="Graphic.md#gga4a7a2c192206c8b18379f42a5fd176eba68baeaa89ae4576fc3d9ac732f87a116">OHOS::UIBoxProgress::Direction::DIR_TOP_TO_BOTTOM</a>, <a href="Graphic.md#gga4a7a2c192206c8b18379f42a5fd176eba78b28982b481790c740bc9b2c1292baa">OHOS::UIBoxProgress::Direction::DIR_BOTTOM_TO_TOP</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p274862619084826"><a name="p274862619084826"></a><a name="p274862619084826"></a>Enumerates the directions of the progress bar. </p>
</td>
</tr>
<tr id="row1343203432084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p437318004084826"><a name="p437318004084826"></a><a name="p437318004084826"></a><a href="Graphic.md#gaf9f6c0c373f090e79b9e8d847e186e92">OHOS::UIButton::ButtonImageSrc</a> : uint8_t </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2074818934084826"><a name="p2074818934084826"></a><a name="p2074818934084826"></a>Enumerates the images for different button states. </p>
</td>
</tr>
<tr id="row982845441084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1107095204084826"><a name="p1107095204084826"></a><a name="p1107095204084826"></a><a href="Graphic.md#ga188dd55c17ee44be27fa80543f13f729">OHOS::UIButton::ButtonState</a> : uint8_t </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p762802995084826"><a name="p762802995084826"></a><a name="p762802995084826"></a>Enumerates the states of this button. </p>
</td>
</tr>
<tr id="row452154095084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1913608936084826"><a name="p1913608936084826"></a><a name="p1913608936084826"></a><a href="Graphic.md#ga548320a469b7862fa416af062cad5d7a">OHOS::Paint::PaintStyle</a> { <a href="Graphic.md#gga548320a469b7862fa416af062cad5d7aa16a9f85a0cca54cb2e20bb58a6a41a41">OHOS::Paint::STROKE_STYLE</a> = 1, <a href="Graphic.md#gga548320a469b7862fa416af062cad5d7aa706e9d250b4f9ef43008dcd61eb67bb6">OHOS::Paint::FILL_STYLE</a>, <a href="Graphic.md#gga548320a469b7862fa416af062cad5d7aa30415cae54bf38e3275e847b5ab3ef1c">OHOS::Paint::STROKE_FILL_STYLE</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p930979367084826"><a name="p930979367084826"></a><a name="p930979367084826"></a>Enumerates paint styles of a closed graph. The styles are invalid for non-closed graphs. </p>
</td>
</tr>
<tr id="row98377781084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p817611959084826"><a name="p817611959084826"></a><a name="p817611959084826"></a><a href="Graphic.md#ga15a3f0302aded0e4d1584ddc6002335d">OHOS::UICheckBox::UICheckBoxState</a> : uint8_t </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2014760583084826"><a name="p2014760583084826"></a><a name="p2014760583084826"></a>Enumerates the states of a check box. </p>
</td>
</tr>
<tr id="row580958691084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1459417481084826"><a name="p1459417481084826"></a><a name="p1459417481084826"></a><a href="Graphic.md#ga1bfefa0b46fd5a79a28d0c9a75114295">OHOS::UIDialog::DialogButtonType</a> { <a href="Graphic.md#gga1bfefa0b46fd5a79a28d0c9a75114295a39ef626649e9e14c6561411867e50f00">OHOS::UIDialog::DialogButtonType::BUTTON1</a>, <a href="Graphic.md#gga1bfefa0b46fd5a79a28d0c9a75114295a752441e0500e1807164a5f758ed93a8c">OHOS::UIDialog::DialogButtonType::BUTTON2</a>, <a href="Graphic.md#gga1bfefa0b46fd5a79a28d0c9a75114295a86707c1d7552f48007cc25b77a2db21b">OHOS::UIDialog::DialogButtonType::BUTTON3</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p767871223084826"><a name="p767871223084826"></a><a name="p767871223084826"></a>Enumerates buttons in a dialog box. </p>
</td>
</tr>
<tr id="row1538289734084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1173716312084826"><a name="p1173716312084826"></a><a name="p1173716312084826"></a><a href="Graphic.md#gabe3b64b11e5bf5d7b54e1039e40f306b">OHOS::UIDigitalClock::DisplayMode</a> { <a href="Graphic.md#ggabe3b64b11e5bf5d7b54e1039e40f306bafc93e631e582de9e4128be8e6d41dbfe">OHOS::UIDigitalClock::DISPLAY_12_HOUR_NO_SECONDS</a>, <a href="Graphic.md#ggabe3b64b11e5bf5d7b54e1039e40f306ba0c5adc8c80a47a33eb7bfcbcad0b4163">OHOS::UIDigitalClock::DISPLAY_24_HOUR_NO_SECONDS</a>, <a href="Graphic.md#ggabe3b64b11e5bf5d7b54e1039e40f306baa5cbeab2c7366db7f33b2e95da20615b">OHOS::UIDigitalClock::DISPLAY_12_HOUR</a>, <a href="Graphic.md#ggabe3b64b11e5bf5d7b54e1039e40f306ba833c0664bba32e6fe4a53a1c471d0eb8">OHOS::UIDigitalClock::DISPLAY_24_HOUR</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1489996174084826"><a name="p1489996174084826"></a><a name="p1489996174084826"></a>Enumerates the display modes of this digital clock. </p>
</td>
</tr>
<tr id="row1248488969084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p417699490084826"><a name="p417699490084826"></a><a name="p417699490084826"></a><a href="Graphic.md#gaa6aacc9ecbf5e20f22e50e542a69f472">OHOS::UIDigitalClock::TimeElement</a> { <a href="Graphic.md#ggaa6aacc9ecbf5e20f22e50e542a69f472a8c15c8462a73ec9c9d9d3ad542ba4946">OHOS::UIDigitalClock::HOUR_ELEMENT</a>, <a href="Graphic.md#ggaa6aacc9ecbf5e20f22e50e542a69f472ae60c24ee0bb6908798a770cb39034de2">OHOS::UIDigitalClock::MINUTE_ELEMENT</a>, <a href="Graphic.md#ggaa6aacc9ecbf5e20f22e50e542a69f472a0299da12b65446f25e530d8d20881a1a">OHOS::UIDigitalClock::SECOND_ELEMENT</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p743991003084826"><a name="p743991003084826"></a><a name="p743991003084826"></a>Enumerates the time elements of this digital clock. </p>
</td>
</tr>
<tr id="row1893251936084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1085618671084826"><a name="p1085618671084826"></a><a name="p1085618671084826"></a><a href="Graphic.md#gaf2ba9acac6cafffc549781ace0475cd5">OHOS::UILabel::LineBreakMode</a> : uint8_t { &nbsp;&nbsp;<a href="Graphic.md#ggaf2ba9acac6cafffc549781ace0475cd5a03a7da624ae08162b5e74ad67e50467f">OHOS::UILabel::LINE_BREAK_ADAPT</a> = 0, <a href="Graphic.md#ggaf2ba9acac6cafffc549781ace0475cd5abc49de1d3936e957882efbb3259dc5be">OHOS::UILabel::LINE_BREAK_STRETCH</a>, <a href="Graphic.md#ggaf2ba9acac6cafffc549781ace0475cd5a2d55ab62d9cead746eb1eaaad1e4e621">OHOS::UILabel::LINE_BREAK_WRAP</a>, <a href="Graphic.md#ggaf2ba9acac6cafffc549781ace0475cd5ac15f8bb00b735e743b621f24a864b0ed">OHOS::UILabel::LINE_BREAK_ELLIPSIS</a>, &nbsp;&nbsp;<a href="Graphic.md#ggaf2ba9acac6cafffc549781ace0475cd5a6d3e13d5e53904899020e2c44f6ca82d">OHOS::UILabel::LINE_BREAK_MARQUEE</a>, <a href="Graphic.md#ggaf2ba9acac6cafffc549781ace0475cd5a4111b08e919f919c314556753aa3ff46">OHOS::UILabel::LINE_BREAK_CLIP</a>, <a href="Graphic.md#ggaf2ba9acac6cafffc549781ace0475cd5afb101ae817692c5bada96ba35f9a636d">OHOS::UILabel::LINE_BREAK_MAX</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1154502741084826"><a name="p1154502741084826"></a><a name="p1154502741084826"></a>Enumerates the display modes of a long text. </p>
</td>
</tr>
<tr id="row83079955084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1201286813084826"><a name="p1201286813084826"></a><a name="p1201286813084826"></a><a href="Graphic.md#gaf8133740d5a3cb2f88a7f33cb11c6dbd">OHOS::VirtualDeviceEvent::DeviceType</a> </p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p175562559084826"><a name="p175562559084826"></a><a name="p175562559084826"></a>Enumerates virtual device types. </p>
</td>
</tr>
<tr id="row639456806084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p258278414084826"><a name="p258278414084826"></a><a name="p258278414084826"></a><a href="Graphic.md#ga3a3fb04ed2cda4017e6771c66b692141">OHOS::ColorMode</a> : uint8_t { &nbsp;&nbsp;<a href="Graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a2f9573d43aecf2449480f8574b907683">OHOS::ARGB8888</a> = 0, <a href="Graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a5a962b82aadba3263c4f0de98262e30e">OHOS::RGB888</a>, <a href="Graphic.md#gga3a3fb04ed2cda4017e6771c66b692141aecb2d8fad7e9b4cfcf53e5490c80651f">OHOS::RGB565</a>, <a href="Graphic.md#gga3a3fb04ed2cda4017e6771c66b692141add58b331447c6b0e8963fc0f21b78033">OHOS::ARGB1555</a>, &nbsp;&nbsp;<a href="Graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a21266607b0e5987609d37b52e63f5277">OHOS::ARGB4444</a>, <a href="Graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a6fbe6b11f436174cc18a931ae9fb85d3">OHOS::AL44</a>, <a href="Graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a7cc06e38b82b0bda251bfc8f0fc953b6">OHOS::AL88</a>, <a href="Graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a734f6e329eed35e1fe3f2f6d753665ac">OHOS::L1</a>, &nbsp;&nbsp;<a href="Graphic.md#gga3a3fb04ed2cda4017e6771c66b692141abe9263055f6c06124c0c8b513e1d87df">OHOS::L2</a>, <a href="Graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a493a9a5cd759369b982ad7e6ac0de13f">OHOS::L4</a>, <a href="Graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a8417494b1a72ed840b16752f32e7554c">OHOS::L8</a>, <a href="Graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a106ce1ddec51f2cb302686252d3c9560">OHOS::A1</a>, &nbsp;&nbsp;<a href="Graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a365d0df177aa6e1b73fe0cddf72e88c7">OHOS::A2</a>, <a href="Graphic.md#gga3a3fb04ed2cda4017e6771c66b692141ae49cb0538532ad895017e6f0d236d9da">OHOS::A4</a>, <a href="Graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a3b6524df7a87ae2800f8ac5b7417d5bc">OHOS::A8</a>, <a href="Graphic.md#gga3a3fb04ed2cda4017e6771c66b692141a892afdfffaf015240b16b563599b0244">OHOS::UNKNOW</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p229393662084826"><a name="p229393662084826"></a><a name="p229393662084826"></a>colormode of image and font. </p>
</td>
</tr>
<tr id="row538776189084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p920447896084826"><a name="p920447896084826"></a><a name="p920447896084826"></a>: uint8_t { &nbsp;&nbsp;<a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfa81f161546d7e1853d1c273e3810fe08b">OHOS::STYLE_BACKGROUND_COLOR</a>, <a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfa639cb87312225b97bde6e4d2be950b7f">OHOS::STYLE_BACKGROUND_OPA</a>, <a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfa4e61810ea3d5f385908eb8a4139027a5">OHOS::STYLE_BORDER_RADIUS</a>, <a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfa8fc5a572665a64ad6d27f70480de3b9a">OHOS::STYLE_BORDER_COLOR</a>, &nbsp;&nbsp;<a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfa13df567903c15b369bf612bd97a9b886">OHOS::STYLE_BORDER_OPA</a>, <a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfae9bd454f8703c13e8385668b3ac19e41">OHOS::STYLE_BORDER_WIDTH</a>, <a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfa3231d33e8bb12cd0cf6911076c877892">OHOS::STYLE_PADDING_LEFT</a>, <a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfa8cc34b7c9774ce7dc940b7deeb64de1f">OHOS::STYLE_PADDING_RIGHT</a>, &nbsp;&nbsp;<a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfa5225ed05b95d4a95a2c48250518c7c7f">OHOS::STYLE_PADDING_TOP</a>, <a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfa65e4dd92a76dc374b487cd24fa37199b">OHOS::STYLE_PADDING_BOTTOM</a>, <a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfa251e2a6ea777b9b6af8f6ccf79d060cc">OHOS::STYLE_MARGIN_LEFT</a>, <a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfa59ab9a49b6fe3f1fd42a79bf70398c70">OHOS::STYLE_MARGIN_RIGHT</a>, &nbsp;&nbsp;<a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfad5dbc07ebf86daf81e30fcbf9051c3b6">OHOS::STYLE_MARGIN_TOP</a>, <a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfa05fa788c60b80429efd0e42fc5d3d4af">OHOS::STYLE_MARGIN_BOTTOM</a>, <a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfae63c7c001e11994f2ec952559c3a0d5f">OHOS::STYLE_IMAGE_OPA</a>, <a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfa21142f37831ece4dc6fe12a3474029a5">OHOS::STYLE_TEXT_COLOR</a>, &nbsp;&nbsp;<a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfa7288938187d2b5c74d0d1789d73784a3">OHOS::STYLE_TEXT_FONT</a>, <a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfaf705c0b077d93c8e5ee3cb4583c8ea87">OHOS::STYLE_LETTER_SPACE</a>, <a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfa06ab7c8b467da98902fe19f2b21595ba">OHOS::STYLE_LINE_SPACE</a>, <a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfa8889542f8ea0fc454895c6e245d9cfdf">OHOS::STYLE_TEXT_OPA</a>, &nbsp;&nbsp;<a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfa59ce09cf70ef205a7ff081f10d6c1380">OHOS::STYLE_LINE_COLOR</a>, <a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfadb7984bac1deeffafc3f04169480937e">OHOS::STYLE_LINE_WIDTH</a>, <a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfa7aa7e8dfa8b88cc3ef77c4c3b23a5ea2">OHOS::STYLE_LINE_OPA</a>, <a href="Graphic.md#gga2933ed17ce67e3e9c997aa2cf6bd04bfa420aa5184ddfd2e95632095c92dfbee5">OHOS::STYLE_LINE_CAP</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1327357007084826"><a name="p1327357007084826"></a><a name="p1327357007084826"></a>Enumerates keys of styles. </p>
</td>
</tr>
<tr id="row368392021084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1230451017084826"><a name="p1230451017084826"></a><a name="p1230451017084826"></a><a href="Graphic.md#ga2db3928cdf793f4950245a6841dd43d6">OHOS::CapType</a> : uint8_t { <a href="Graphic.md#gga2db3928cdf793f4950245a6841dd43d6a7692381654eff26893e03ac1983c8f45">OHOS::CAP_NONE</a>, <a href="Graphic.md#gga2db3928cdf793f4950245a6841dd43d6ada0a5a2f0100d929e9e1d1d31ef26cce">OHOS::CAP_ROUND</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p709736519084826"><a name="p709736519084826"></a><a name="p709736519084826"></a>Enumerates cap styles. </p>
</td>
</tr>
<tr id="row2014097771084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1505381876084826"><a name="p1505381876084826"></a><a name="p1505381876084826"></a><a href="Graphic.md#ga75d850e3abff6c2f617b689a0cb9a3d1">OHOS::SysInfo::FPSCalculateType</a> { <a href="Graphic.md#gga75d850e3abff6c2f617b689a0cb9a3d1a26a841fb9a10881591dc79dae38e2d7f">OHOS::SysInfo::FPS_CT_FIXED_TIME</a>, <a href="Graphic.md#gga75d850e3abff6c2f617b689a0cb9a3d1a17fdb75ff7e9afb4165349a3d8300f3c">OHOS::SysInfo::FPS_CT_AVERAGE_SAMPLING</a>, <a href="Graphic.md#gga75d850e3abff6c2f617b689a0cb9a3d1afcc7226b2c9012f2993b7044a80cbed5">OHOS::SysInfo::FPS_CT_PRECISE_SAMPLING</a> }</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p603531525084826"><a name="p603531525084826"></a><a name="p603531525084826"></a>Enumerates the FPS capture types. </p>
</td>
</tr>
</tbody>
</table>

## Functions<a name="func-members"></a>

<a name="table846708441084826"></a>
<table><thead align="left"><tr id="row1876229311084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1863951528084826"><a name="p1863951528084826"></a><a name="p1863951528084826"></a>Function Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p845745508084826"><a name="p845745508084826"></a><a name="p845745508084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row300455138084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1163043706084826"><a name="p1163043706084826"></a><a name="p1163043706084826"></a><a href="Graphic.md#gace3debcfa4200de1951a8eae6421e5aa">OHOS::AnimatorCallback::Callback</a> (<a href="OHOS-UIView.md">UIView</a> *view)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1482954573084826"><a name="p1482954573084826"></a><a name="p1482954573084826"></a>virtual void&nbsp;</p>
<p id="p789854815084826"><a name="p789854815084826"></a><a name="p789854815084826"></a>Called when each frame starts. This is a pure virtual function, which needs your inheritance and implementation. </p>
</td>
</tr>
<tr id="row2143167247084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p405950469084826"><a name="p405950469084826"></a><a name="p405950469084826"></a><a href="Graphic.md#ga33875ecdc72e4d8076be696a35667a8f">OHOS::AnimatorCallback::OnStop</a> (<a href="OHOS-UIView.md">UIView</a> &amp;view)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1454843426084826"><a name="p1454843426084826"></a><a name="p1454843426084826"></a>virtual void&nbsp;</p>
<p id="p698116210084826"><a name="p698116210084826"></a><a name="p698116210084826"></a>Called when an animator stops. This is a pure virtual function, which needs your inheritance and implementation. </p>
</td>
</tr>
<tr id="row692403743084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2014242672084826"><a name="p2014242672084826"></a><a name="p2014242672084826"></a><a href="Graphic.md#ga783aca5777750141552a5aba974ffdff">OHOS::AnimatorCallback::~AnimatorCallback</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1392856148084826"><a name="p1392856148084826"></a><a name="p1392856148084826"></a>virtual&nbsp;</p>
<p id="p719707668084826"><a name="p719707668084826"></a><a name="p719707668084826"></a>A default destructor used to delete an <strong id="b914250257084826"><a name="b914250257084826"></a><a name="b914250257084826"></a><a href="OHOS-AnimatorCallback.md">AnimatorCallback</a></strong> instance. </p>
</td>
</tr>
<tr id="row640668345084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p692398916084826"><a name="p692398916084826"></a><a name="p692398916084826"></a><a href="Graphic.md#gabcc3afbe99010e70e3e6dbd780cb5974">OHOS::Animator::Animator</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p422196478084826"><a name="p422196478084826"></a><a name="p422196478084826"></a>&nbsp;</p>
<p id="p162645333084826"><a name="p162645333084826"></a><a name="p162645333084826"></a>A default constructor used to create an <strong id="b1952598435084826"><a name="b1952598435084826"></a><a name="b1952598435084826"></a><a href="OHOS-Animator.md">Animator</a></strong> instance. </p>
</td>
</tr>
<tr id="row236983877084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1845887070084826"><a name="p1845887070084826"></a><a name="p1845887070084826"></a><a href="Graphic.md#ga79be500c40ba8743dd58dc633a732b53">OHOS::Animator::Animator</a> (<a href="OHOS-AnimatorCallback.md">AnimatorCallback</a> *callback, <a href="OHOS-UIView.md">UIView</a> *view, uint32_t <a href="TIME.md#gae7841e681c8c9d59818568d39553642c">time</a>, bool repeat)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1514697989084826"><a name="p1514697989084826"></a><a name="p1514697989084826"></a>&nbsp;</p>
<p id="p1873201452084826"><a name="p1873201452084826"></a><a name="p1873201452084826"></a>A constructor used to create an <strong id="b1650008499084826"><a name="b1650008499084826"></a><a name="b1650008499084826"></a><a href="OHOS-Animator.md">Animator</a></strong> instance. </p>
</td>
</tr>
<tr id="row1869672425084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p75203440084826"><a name="p75203440084826"></a><a name="p75203440084826"></a><a href="Graphic.md#gaee2a71f97b102654ca3b7ded4b5ce350">OHOS::Animator::~Animator</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1586497056084826"><a name="p1586497056084826"></a><a name="p1586497056084826"></a>virtual&nbsp;</p>
<p id="p1692145865084826"><a name="p1692145865084826"></a><a name="p1692145865084826"></a>A destructor used to delete the <strong id="b749628727084826"><a name="b749628727084826"></a><a name="b749628727084826"></a><a href="OHOS-Animator.md">Animator</a></strong> instance. </p>
</td>
</tr>
<tr id="row180596009084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2085751536084826"><a name="p2085751536084826"></a><a name="p2085751536084826"></a><a href="Graphic.md#gad56477fe4b6d0158082e841e327c1bf6">OHOS::Animator::Start</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1914974191084826"><a name="p1914974191084826"></a><a name="p1914974191084826"></a>void&nbsp;</p>
<p id="p818610073084826"><a name="p818610073084826"></a><a name="p818610073084826"></a>Starts this animator. </p>
</td>
</tr>
<tr id="row1591813158084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p681691946084826"><a name="p681691946084826"></a><a name="p681691946084826"></a><a href="Graphic.md#gad670cee429a5535149db0f8b3828e951">OHOS::Animator::Stop</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p307535340084826"><a name="p307535340084826"></a><a name="p307535340084826"></a>void&nbsp;</p>
<p id="p1221862769084826"><a name="p1221862769084826"></a><a name="p1221862769084826"></a>Stops this animator. </p>
</td>
</tr>
<tr id="row1593097819084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1615916040084826"><a name="p1615916040084826"></a><a name="p1615916040084826"></a><a href="Graphic.md#ga4dd9d23ebff1359bd1145fd2f26e1be2">OHOS::Animator::Pause</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p62884097084826"><a name="p62884097084826"></a><a name="p62884097084826"></a>void&nbsp;</p>
<p id="p337686043084826"><a name="p337686043084826"></a><a name="p337686043084826"></a>Pauses this animator. </p>
</td>
</tr>
<tr id="row1405207945084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p850762989084826"><a name="p850762989084826"></a><a name="p850762989084826"></a><a href="Graphic.md#ga645bbd33356bd708636a94c3d95c282d">OHOS::Animator::Resume</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p199777899084826"><a name="p199777899084826"></a><a name="p199777899084826"></a>void&nbsp;</p>
<p id="p589751340084826"><a name="p589751340084826"></a><a name="p589751340084826"></a>Resumes this animator from where it was paused. </p>
</td>
</tr>
<tr id="row2049984292084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1224341180084826"><a name="p1224341180084826"></a><a name="p1224341180084826"></a><a href="Graphic.md#gafd0166df63bed582022ed93175dd3179">OHOS::Animator::GetState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p685612841084826"><a name="p685612841084826"></a><a name="p685612841084826"></a>uint8_t&nbsp;</p>
<p id="p782117007084826"><a name="p782117007084826"></a><a name="p782117007084826"></a>Obtains the current state of this animator. </p>
</td>
</tr>
<tr id="row1943276361084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p136579908084826"><a name="p136579908084826"></a><a name="p136579908084826"></a><a href="Graphic.md#gab8ec3815f5e42605a51a328c1b0857dd">OHOS::Animator::SetState</a> (uint8_t state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p829723418084826"><a name="p829723418084826"></a><a name="p829723418084826"></a>void&nbsp;</p>
<p id="p1711370172084826"><a name="p1711370172084826"></a><a name="p1711370172084826"></a>Sets the current state for this animator. </p>
</td>
</tr>
<tr id="row180755237084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p626040020084826"><a name="p626040020084826"></a><a name="p626040020084826"></a><a href="Graphic.md#gac05ba70bafa9887dc23ea4ba69da632d">OHOS::Animator::GetTime</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1475316813084826"><a name="p1475316813084826"></a><a name="p1475316813084826"></a>uint32_t&nbsp;</p>
<p id="p1057776392084826"><a name="p1057776392084826"></a><a name="p1057776392084826"></a>Obtains the total duration of this animator. </p>
</td>
</tr>
<tr id="row987917295084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1452476108084826"><a name="p1452476108084826"></a><a name="p1452476108084826"></a><a href="Graphic.md#ga5a2bfa5fb257b2116d08ad5ae254327c">OHOS::Animator::SetTime</a> (uint32_t <a href="TIME.md#gae7841e681c8c9d59818568d39553642c">time</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1332018440084826"><a name="p1332018440084826"></a><a name="p1332018440084826"></a>void&nbsp;</p>
<p id="p1956459339084826"><a name="p1956459339084826"></a><a name="p1956459339084826"></a>Sets the total duration for this animator. </p>
</td>
</tr>
<tr id="row1166501660084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1745410531084826"><a name="p1745410531084826"></a><a name="p1745410531084826"></a><a href="Graphic.md#ga18a8b8b9ceb344e6660a5c0de5a9ce1f">OHOS::Animator::GetRunTime</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p375185114084826"><a name="p375185114084826"></a><a name="p375185114084826"></a>uint32_t&nbsp;</p>
<p id="p1026125696084826"><a name="p1026125696084826"></a><a name="p1026125696084826"></a>Obtains the running time of this animator. </p>
</td>
</tr>
<tr id="row248379758084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p655497982084826"><a name="p655497982084826"></a><a name="p655497982084826"></a><a href="Graphic.md#ga4d5ff5057df28da1bc99d08070312f24">OHOS::Animator::SetRunTime</a> (uint32_t runTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p513632572084826"><a name="p513632572084826"></a><a name="p513632572084826"></a>void&nbsp;</p>
<p id="p86846957084826"><a name="p86846957084826"></a><a name="p86846957084826"></a>Sets the running time for this animator. </p>
</td>
</tr>
<tr id="row1661883984084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1906140691084826"><a name="p1906140691084826"></a><a name="p1906140691084826"></a><a href="Graphic.md#gacd3c360c8a3f6b5aeffcf10c1a1588da">OHOS::Animator::IsRepeat</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p632578240084826"><a name="p632578240084826"></a><a name="p632578240084826"></a>bool&nbsp;</p>
<p id="p184033944084826"><a name="p184033944084826"></a><a name="p184033944084826"></a>Checks whether this animator is repeated. </p>
</td>
</tr>
<tr id="row1317206206084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1554151084084826"><a name="p1554151084084826"></a><a name="p1554151084084826"></a><a href="Graphic.md#ga3ed818079b3501922f422b150f891d13">OHOS::AnimatorManager::GetInstance</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p119585168084826"><a name="p119585168084826"></a><a name="p119585168084826"></a>static <a href="OHOS-AnimatorManager.md">AnimatorManager</a> *&nbsp;</p>
<p id="p949561513084826"><a name="p949561513084826"></a><a name="p949561513084826"></a>Obtains the <strong id="b1966852114084826"><a name="b1966852114084826"></a><a name="b1966852114084826"></a><a href="OHOS-AnimatorManager.md">AnimatorManager</a></strong> instance. </p>
</td>
</tr>
<tr id="row1945900380084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1877107736084826"><a name="p1877107736084826"></a><a name="p1877107736084826"></a><em id="gadfc9e9cf812f172fb1b6ca7efb7ba099"><a name="gadfc9e9cf812f172fb1b6ca7efb7ba099"></a><a name="gadfc9e9cf812f172fb1b6ca7efb7ba099"></a></em>OHOS::AnimatorManager::Init () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1126586510084826"><a name="p1126586510084826"></a><a name="p1126586510084826"></a><strong id="gadfc9e9cf812f172fb1b6ca7efb7ba099_1"><a name="gadfc9e9cf812f172fb1b6ca7efb7ba099_1"></a><a name="gadfc9e9cf812f172fb1b6ca7efb7ba099_1"></a></strong> void&nbsp;</p>
<p id="p62833169084826"><a name="p62833169084826"></a><a name="p62833169084826"></a>Initializes this task. </p>
</td>
</tr>
<tr id="row924090160084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p247685259084826"><a name="p247685259084826"></a><a name="p247685259084826"></a><a href="Graphic.md#ga8b60ed045dc2a3370498a3e6922d5400">OHOS::AnimatorManager::Add</a> (<a href="OHOS-Animator.md">Animator</a> *animator)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1960200474084826"><a name="p1960200474084826"></a><a name="p1960200474084826"></a>void&nbsp;</p>
<p id="p41255441084826"><a name="p41255441084826"></a><a name="p41255441084826"></a>Adds the <strong id="b1005391557084826"><a name="b1005391557084826"></a><a name="b1005391557084826"></a><a href="OHOS-Animator.md">Animator</a></strong> instance to the <strong id="b808712696084826"><a name="b808712696084826"></a><a name="b808712696084826"></a><a href="OHOS-AnimatorManager.md">AnimatorManager</a></strong> linked list for management, so that the <strong id="b1405059192084826"><a name="b1405059192084826"></a><a name="b1405059192084826"></a>Run</strong> function of the <strong id="b1841741844084826"><a name="b1841741844084826"></a><a name="b1841741844084826"></a><a href="OHOS-Animator.md">Animator</a></strong> class is called once for each frame. </p>
</td>
</tr>
<tr id="row376485673084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p467914397084826"><a name="p467914397084826"></a><a name="p467914397084826"></a><a href="Graphic.md#ga493d53a9e4a47b79d30c0d37f96a69da">OHOS::AnimatorManager::Remove</a> (const <a href="OHOS-Animator.md">Animator</a> *animator)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p280711837084826"><a name="p280711837084826"></a><a name="p280711837084826"></a>void&nbsp;</p>
<p id="p1195911186084826"><a name="p1195911186084826"></a><a name="p1195911186084826"></a>Removes the <strong id="b1168092037084826"><a name="b1168092037084826"></a><a name="b1168092037084826"></a><a href="OHOS-Animator.md">Animator</a></strong> instance from the <strong id="b1763037236084826"><a name="b1763037236084826"></a><a name="b1763037236084826"></a><a href="OHOS-AnimatorManager.md">AnimatorManager</a></strong> linked list. </p>
</td>
</tr>
<tr id="row2024581311084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p83980548084826"><a name="p83980548084826"></a><a name="p83980548084826"></a><em id="ga8a7c3d733fc2112171a2e075dd425a5c"><a name="ga8a7c3d733fc2112171a2e075dd425a5c"></a><a name="ga8a7c3d733fc2112171a2e075dd425a5c"></a></em>OHOS::AnimatorManager::Callback () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p416990057084826"><a name="p416990057084826"></a><a name="p416990057084826"></a><strong id="ga8a7c3d733fc2112171a2e075dd425a5c_1"><a name="ga8a7c3d733fc2112171a2e075dd425a5c_1"></a><a name="ga8a7c3d733fc2112171a2e075dd425a5c_1"></a></strong> void&nbsp;</p>
<p id="p1584737756084826"><a name="p1584737756084826"></a><a name="p1584737756084826"></a>Called when this task is executed. </p>
</td>
</tr>
<tr id="row604142203084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1061927589084826"><a name="p1061927589084826"></a><a name="p1061927589084826"></a><a href="Graphic.md#gab7cf0e64a0d363d8b448262d719ac97a">OHOS::EasingEquation::SetBackOvershoot</a> (double overshoot)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p148078020084826"><a name="p148078020084826"></a><a name="p148078020084826"></a>static void&nbsp;</p>
<p id="p815988997084826"><a name="p815988997084826"></a><a name="p815988997084826"></a>Sets the parameter <strong id="b1342119913084826"><a name="b1342119913084826"></a><a name="b1342119913084826"></a>s</strong> in the equation <strong id="b1509889878084826"><a name="b1509889878084826"></a><a name="b1509889878084826"></a>(s+1)*t^3 - s*t^2</strong> for a back easing. </p>
</td>
</tr>
<tr id="row1514686622084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1469471607084826"><a name="p1469471607084826"></a><a name="p1469471607084826"></a><a href="Graphic.md#ga4598524b16a33de497fa9321d887d3b1">OHOS::EasingEquation::BackEaseIn</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p205651949084826"><a name="p205651949084826"></a><a name="p205651949084826"></a>static int16_t&nbsp;</p>
<p id="p1267873366084826"><a name="p1267873366084826"></a><a name="p1267873366084826"></a>Eases in with an overshoot. </p>
</td>
</tr>
<tr id="row1863663119084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2081778770084826"><a name="p2081778770084826"></a><a name="p2081778770084826"></a><a href="Graphic.md#ga7399f01f7abc33413bf25aa17a99c2f2">OHOS::EasingEquation::BackEaseOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2031564536084826"><a name="p2031564536084826"></a><a name="p2031564536084826"></a>static int16_t&nbsp;</p>
<p id="p141437112084826"><a name="p141437112084826"></a><a name="p141437112084826"></a>Eases out with an overshoot. </p>
</td>
</tr>
<tr id="row1362258945084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2080699755084826"><a name="p2080699755084826"></a><a name="p2080699755084826"></a><a href="Graphic.md#gac7c2a9a1dfce384438a3bd9d6c0c2525">OHOS::EasingEquation::BackEaseInOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p305874601084826"><a name="p305874601084826"></a><a name="p305874601084826"></a>static int16_t&nbsp;</p>
<p id="p347368693084826"><a name="p347368693084826"></a><a name="p347368693084826"></a>Eases in and then out with an overshoot. </p>
</td>
</tr>
<tr id="row560748787084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1243332025084826"><a name="p1243332025084826"></a><a name="p1243332025084826"></a><a href="Graphic.md#ga446c958f14b3d6de24e2c1bab171bba2">OHOS::EasingEquation::CircEaseIn</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1600388620084826"><a name="p1600388620084826"></a><a name="p1600388620084826"></a>static int16_t&nbsp;</p>
<p id="p1835568481084826"><a name="p1835568481084826"></a><a name="p1835568481084826"></a>Eases in shaping like a circular curve. </p>
</td>
</tr>
<tr id="row2117825555084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p12683342084826"><a name="p12683342084826"></a><a name="p12683342084826"></a><a href="Graphic.md#gaab8fad8664d648df7e5e224b68ee54ad">OHOS::EasingEquation::CircEaseOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1826519927084826"><a name="p1826519927084826"></a><a name="p1826519927084826"></a>static int16_t&nbsp;</p>
<p id="p698675331084826"><a name="p698675331084826"></a><a name="p698675331084826"></a>Eases out shaping like a circular curve. </p>
</td>
</tr>
<tr id="row460153045084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1016102787084826"><a name="p1016102787084826"></a><a name="p1016102787084826"></a><a href="Graphic.md#ga68c392dad14e1bef192b085aeec6ca9b">OHOS::EasingEquation::CircEaseInOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1204261648084826"><a name="p1204261648084826"></a><a name="p1204261648084826"></a>static int16_t&nbsp;</p>
<p id="p594930971084826"><a name="p594930971084826"></a><a name="p594930971084826"></a>Eases in and then out shaping like a circular curve. </p>
</td>
</tr>
<tr id="row2093207338084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p612237012084826"><a name="p612237012084826"></a><a name="p612237012084826"></a><a href="Graphic.md#ga5c91a83cc424fb7e4e1f40cae6b3be66">OHOS::EasingEquation::CubicEaseIn</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p503725840084826"><a name="p503725840084826"></a><a name="p503725840084826"></a>static int16_t&nbsp;</p>
<p id="p941666445084826"><a name="p941666445084826"></a><a name="p941666445084826"></a>Eases in shaping like a cubic curve. </p>
</td>
</tr>
<tr id="row965792050084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1204397068084826"><a name="p1204397068084826"></a><a name="p1204397068084826"></a><a href="Graphic.md#ga529a948d9f6711a5f2726af5f10d7a48">OHOS::EasingEquation::CubicEaseOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1260829898084826"><a name="p1260829898084826"></a><a name="p1260829898084826"></a>static int16_t&nbsp;</p>
<p id="p380863857084826"><a name="p380863857084826"></a><a name="p380863857084826"></a>Eases out shaping like a cubic curve. </p>
</td>
</tr>
<tr id="row1952058089084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1078662735084826"><a name="p1078662735084826"></a><a name="p1078662735084826"></a><a href="Graphic.md#gad99ea4ed828f274f111f492eea123cb4">OHOS::EasingEquation::CubicEaseInOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2032643208084826"><a name="p2032643208084826"></a><a name="p2032643208084826"></a>static int16_t&nbsp;</p>
<p id="p486882112084826"><a name="p486882112084826"></a><a name="p486882112084826"></a>Eases in and then out shaping like a cubic curve. </p>
</td>
</tr>
<tr id="row1865401689084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p186470100084826"><a name="p186470100084826"></a><a name="p186470100084826"></a><a href="Graphic.md#ga8af9a1f527ffaa5006cf0ee867f7d7d0">OHOS::EasingEquation::LinearEaseNone</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1136958267084826"><a name="p1136958267084826"></a><a name="p1136958267084826"></a>static int16_t&nbsp;</p>
<p id="p2018516675084826"><a name="p2018516675084826"></a><a name="p2018516675084826"></a>Displays no linear easing effects. </p>
</td>
</tr>
<tr id="row2050967454084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1999886205084826"><a name="p1999886205084826"></a><a name="p1999886205084826"></a><a href="Graphic.md#ga72a9b93086c8466767942863a7d5cb78">OHOS::EasingEquation::QuadEaseIn</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p11752336084826"><a name="p11752336084826"></a><a name="p11752336084826"></a>static int16_t&nbsp;</p>
<p id="p1023343048084826"><a name="p1023343048084826"></a><a name="p1023343048084826"></a>Eases in shaping like a quadratic curve. </p>
</td>
</tr>
<tr id="row748236329084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p408362411084826"><a name="p408362411084826"></a><a name="p408362411084826"></a><a href="Graphic.md#ga0c9cd2781e17f7077b4c9d5847eb90c8">OHOS::EasingEquation::QuadEaseOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p127501809084826"><a name="p127501809084826"></a><a name="p127501809084826"></a>static int16_t&nbsp;</p>
<p id="p1096965344084826"><a name="p1096965344084826"></a><a name="p1096965344084826"></a>Eases out shaping like a quadratic curve. </p>
</td>
</tr>
<tr id="row264018900084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p582014012084826"><a name="p582014012084826"></a><a name="p582014012084826"></a><a href="Graphic.md#ga8f62ddc3f1b2b33904845601108d6f64">OHOS::EasingEquation::QuadEaseInOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1103488803084826"><a name="p1103488803084826"></a><a name="p1103488803084826"></a>static int16_t&nbsp;</p>
<p id="p1353227092084826"><a name="p1353227092084826"></a><a name="p1353227092084826"></a>Eases in and then out shaping like a quadratic curve. </p>
</td>
</tr>
<tr id="row598769974084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1224535697084826"><a name="p1224535697084826"></a><a name="p1224535697084826"></a><a href="Graphic.md#ga9ddf5221cdde5f6a37096300847a50ac">OHOS::EasingEquation::QuintEaseIn</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1788242530084826"><a name="p1788242530084826"></a><a name="p1788242530084826"></a>static int16_t&nbsp;</p>
<p id="p1722902419084826"><a name="p1722902419084826"></a><a name="p1722902419084826"></a>Eases in shaping like a quintic curve. </p>
</td>
</tr>
<tr id="row174799184084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1681092132084826"><a name="p1681092132084826"></a><a name="p1681092132084826"></a><a href="Graphic.md#gaa61e26b2bff3f69edced36d0c0d17a45">OHOS::EasingEquation::QuintEaseOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1803447277084826"><a name="p1803447277084826"></a><a name="p1803447277084826"></a>static int16_t&nbsp;</p>
<p id="p930667566084826"><a name="p930667566084826"></a><a name="p930667566084826"></a>Eases out shaping like a quintic curve. </p>
</td>
</tr>
<tr id="row2053648967084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1956603395084826"><a name="p1956603395084826"></a><a name="p1956603395084826"></a><a href="Graphic.md#ga8bea02f98d26a97072f32369370a421b">OHOS::EasingEquation::QuintEaseInOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p292018778084826"><a name="p292018778084826"></a><a name="p292018778084826"></a>static int16_t&nbsp;</p>
<p id="p546235792084826"><a name="p546235792084826"></a><a name="p546235792084826"></a>Eases in and then out shaping like a quintic curve. </p>
</td>
</tr>
<tr id="row121163158084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p616972187084826"><a name="p616972187084826"></a><a name="p616972187084826"></a><a href="Graphic.md#ga89ee91a569b73c6ebb29ae4dfd2777f9">OHOS::EasingEquation::SineEaseIn</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p910527454084826"><a name="p910527454084826"></a><a name="p910527454084826"></a>static int16_t&nbsp;</p>
<p id="p659039787084826"><a name="p659039787084826"></a><a name="p659039787084826"></a>Eases in shaping like a sinusoidal curve. </p>
</td>
</tr>
<tr id="row1040541430084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1573932077084826"><a name="p1573932077084826"></a><a name="p1573932077084826"></a><a href="Graphic.md#ga34018757e69d7920557030f33393048d">OHOS::EasingEquation::SineEaseOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1035389722084826"><a name="p1035389722084826"></a><a name="p1035389722084826"></a>static int16_t&nbsp;</p>
<p id="p192418141084826"><a name="p192418141084826"></a><a name="p192418141084826"></a>Eases out shaping like a sinusoidal curve. </p>
</td>
</tr>
<tr id="row1485948164084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1245606147084826"><a name="p1245606147084826"></a><a name="p1245606147084826"></a><a href="Graphic.md#ga2c3b14232a67095b0b941bae3a7b2e54">OHOS::EasingEquation::SineEaseInOut</a> (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p134674151084826"><a name="p134674151084826"></a><a name="p134674151084826"></a>static int16_t&nbsp;</p>
<p id="p2130527865084826"><a name="p2130527865084826"></a><a name="p2130527865084826"></a>Eases in and then out shaping like a sinusoidal curve. </p>
</td>
</tr>
<tr id="row957849000084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p432179214084826"><a name="p432179214084826"></a><a name="p432179214084826"></a><a href="Graphic.md#ga9d6eaf28db711bc05e1cd03c5df293eb">OHOS::Interpolation::GetBezierInterpolation</a> (int16_t t, int16_t u0, int16_t u1, int16_t u2, int16_t u3)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1152264076084826"><a name="p1152264076084826"></a><a name="p1152264076084826"></a>static int16_t&nbsp;</p>
<p id="p1161625892084826"><a name="p1161625892084826"></a><a name="p1161625892084826"></a>Obtains the value calculated by the cubic Bezier equation. </p>
</td>
</tr>
<tr id="row739659924084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1636546984084826"><a name="p1636546984084826"></a><a name="p1636546984084826"></a><a href="Graphic.md#gae12573eec4d4db025e96b5d9679e4b3f">OHOS::Color::GetMixColor</a> (<a href="OHOS-Color32.md">ColorType</a> c1, <a href="OHOS-Color32.md">ColorType</a> c2, uint8_t mix)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2127704057084826"><a name="p2127704057084826"></a><a name="p2127704057084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p1173289059084826"><a name="p1173289059084826"></a><a name="p1173289059084826"></a>Mixes two colors (color 1 and color 2) based on a specified opacity. </p>
</td>
</tr>
<tr id="row762436372084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p843625498084826"><a name="p843625498084826"></a><a name="p843625498084826"></a><a href="Graphic.md#ga0c3bb99c625896eeab6eb0acbe14f437">OHOS::Color::GetColorFromRGB</a> (uint8_t r8, uint8_t g8, uint8_t b8)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1917037971084826"><a name="p1917037971084826"></a><a name="p1917037971084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p1821853230084826"><a name="p1821853230084826"></a><a name="p1821853230084826"></a>Obtains the color based on the RGB color value. </p>
</td>
</tr>
<tr id="row1107290157084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1040317040084826"><a name="p1040317040084826"></a><a name="p1040317040084826"></a><a href="Graphic.md#ga0a7e632d54e39d1d46e64c6cf20690cc">OHOS::Color::GetColorFromRGBA</a> (uint8_t r8, uint8_t g8, uint8_t b8, uint8_t alpha)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1634319009084826"><a name="p1634319009084826"></a><a name="p1634319009084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p924810523084826"><a name="p924810523084826"></a><a name="p924810523084826"></a>Obtains the color based on the RGBA color value. </p>
</td>
</tr>
<tr id="row1977537971084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1082326897084826"><a name="p1082326897084826"></a><a name="p1082326897084826"></a><a href="Graphic.md#ga461b46dd76842ad4b0ffdc88202223a7">OHOS::Color::ColorTo32</a> (<a href="OHOS-Color32.md">ColorType</a> color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p948340555084826"><a name="p948340555084826"></a><a name="p948340555084826"></a>static uint32_t&nbsp;</p>
<p id="p172800998084826"><a name="p172800998084826"></a><a name="p172800998084826"></a>Converts color data into the RGBA8888 format. </p>
</td>
</tr>
<tr id="row2010898489084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p543526938084826"><a name="p543526938084826"></a><a name="p543526938084826"></a><a href="Graphic.md#gaaca42d51bc5f28d5dbd5b1635be50224">OHOS::Color::ColorTo32</a> (<a href="OHOS-Color16.md">Color16</a> color, uint8_t alpha)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1580599260084826"><a name="p1580599260084826"></a><a name="p1580599260084826"></a>static uint32_t&nbsp;</p>
<p id="p961813824084826"><a name="p961813824084826"></a><a name="p961813824084826"></a>Converts color data with the 16-bit color depth into the RGBA8888 format. </p>
</td>
</tr>
<tr id="row688151057084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1076387754084826"><a name="p1076387754084826"></a><a name="p1076387754084826"></a><a href="Graphic.md#ga2a6a0bd067a05ee35793fefc8f9f4d1e">OHOS::Color::ColorTo16</a> (<a href="OHOS-Color32.md">Color32</a> color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1927286836084826"><a name="p1927286836084826"></a><a name="p1927286836084826"></a>static uint16_t&nbsp;</p>
<p id="p1755938725084826"><a name="p1755938725084826"></a><a name="p1755938725084826"></a>Converts color data from the RGBA8888 format into the RGB565 format. </p>
</td>
</tr>
<tr id="row1125488867084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2029297548084826"><a name="p2029297548084826"></a><a name="p2029297548084826"></a><a href="Graphic.md#gad98c45688cd59b11e9e766e62e24252f">OHOS::Color::White</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p745220383084826"><a name="p745220383084826"></a><a name="p745220383084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p2107857147084826"><a name="p2107857147084826"></a><a name="p2107857147084826"></a>Obtains the color data of white. </p>
</td>
</tr>
<tr id="row1119194507084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1572299729084826"><a name="p1572299729084826"></a><a name="p1572299729084826"></a><a href="Graphic.md#ga6dcfcd450637398b7b7d28ce7464d153">OHOS::Color::Silver</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p214532372084826"><a name="p214532372084826"></a><a name="p214532372084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p847022473084826"><a name="p847022473084826"></a><a name="p847022473084826"></a>Obtains the color data of silver. </p>
</td>
</tr>
<tr id="row1742105390084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p5219234084826"><a name="p5219234084826"></a><a name="p5219234084826"></a><a href="Graphic.md#ga920421d6dc1d9fbc21d5002948eb43c6">OHOS::Color::Gray</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1723470537084826"><a name="p1723470537084826"></a><a name="p1723470537084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p1001461617084826"><a name="p1001461617084826"></a><a name="p1001461617084826"></a>Obtains the color data of gray. </p>
</td>
</tr>
<tr id="row859845242084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2061412685084826"><a name="p2061412685084826"></a><a name="p2061412685084826"></a><a href="Graphic.md#gac821c879969c94ec048117738e4bbef2">OHOS::Color::Black</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p211795346084826"><a name="p211795346084826"></a><a name="p211795346084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p1714775738084826"><a name="p1714775738084826"></a><a name="p1714775738084826"></a>Obtains the color data of black. </p>
</td>
</tr>
<tr id="row1673375652084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p329867704084826"><a name="p329867704084826"></a><a name="p329867704084826"></a><a href="Graphic.md#gac7d29e91471253cbef9d709d74bc0d78">OHOS::Color::Red</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p164598917084826"><a name="p164598917084826"></a><a name="p164598917084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p758371339084826"><a name="p758371339084826"></a><a name="p758371339084826"></a>Obtains the color data of red. </p>
</td>
</tr>
<tr id="row2093956708084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1780928142084826"><a name="p1780928142084826"></a><a name="p1780928142084826"></a><a href="Graphic.md#gaf8342e9323109066e57434445de4423e">OHOS::Color::Maroon</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1359130194084826"><a name="p1359130194084826"></a><a name="p1359130194084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p1140100982084826"><a name="p1140100982084826"></a><a name="p1140100982084826"></a>Obtains the color data of maroon. </p>
</td>
</tr>
<tr id="row1842407548084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1676117078084826"><a name="p1676117078084826"></a><a name="p1676117078084826"></a><a href="Graphic.md#gadd545c06bdd497b259179379e6910e15">OHOS::Color::Yellow</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1050798379084826"><a name="p1050798379084826"></a><a name="p1050798379084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p931727390084826"><a name="p931727390084826"></a><a name="p931727390084826"></a>Obtains the color data of yellow. </p>
</td>
</tr>
<tr id="row1825952790084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2025409718084826"><a name="p2025409718084826"></a><a name="p2025409718084826"></a><a href="Graphic.md#ga8c8d03f5579dbb976119cee384856e3b">OHOS::Color::Olive</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1035185790084826"><a name="p1035185790084826"></a><a name="p1035185790084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p837607721084826"><a name="p837607721084826"></a><a name="p837607721084826"></a>Obtains the color data of olive. </p>
</td>
</tr>
<tr id="row1749284177084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1462721722084826"><a name="p1462721722084826"></a><a name="p1462721722084826"></a><a href="Graphic.md#ga629dc5c95263df097a06b207a36b1dca">OHOS::Color::Lime</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2118365099084826"><a name="p2118365099084826"></a><a name="p2118365099084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p842574892084826"><a name="p842574892084826"></a><a name="p842574892084826"></a>Obtains the color data of lime. </p>
</td>
</tr>
<tr id="row1793166867084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2055157570084826"><a name="p2055157570084826"></a><a name="p2055157570084826"></a><a href="Graphic.md#ga672e4e015f76e7cef0a4b819ee95f082">OHOS::Color::Green</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p464055051084826"><a name="p464055051084826"></a><a name="p464055051084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p812519536084826"><a name="p812519536084826"></a><a name="p812519536084826"></a>Obtains the color data of green. </p>
</td>
</tr>
<tr id="row2129465872084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1070189398084826"><a name="p1070189398084826"></a><a name="p1070189398084826"></a><a href="Graphic.md#ga9d6b730a0799da3254543613acb0a3fa">OHOS::Color::Cyan</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1670307070084826"><a name="p1670307070084826"></a><a name="p1670307070084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p124381342084826"><a name="p124381342084826"></a><a name="p124381342084826"></a>Obtains the color data of cyan. </p>
</td>
</tr>
<tr id="row1315621449084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1571015719084826"><a name="p1571015719084826"></a><a name="p1571015719084826"></a><a href="Graphic.md#ga24da6b938c938b3defeb56ff79a4c4f5">OHOS::Color::Aqua</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2118779060084826"><a name="p2118779060084826"></a><a name="p2118779060084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p1093254622084826"><a name="p1093254622084826"></a><a name="p1093254622084826"></a>Obtains the color data of aqua. </p>
</td>
</tr>
<tr id="row1750408124084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1645019723084826"><a name="p1645019723084826"></a><a name="p1645019723084826"></a><a href="Graphic.md#ga9f4afc8d27c8e90d5295b281a7198fe5">OHOS::Color::Teal</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p634063277084826"><a name="p634063277084826"></a><a name="p634063277084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p1279772447084826"><a name="p1279772447084826"></a><a name="p1279772447084826"></a>Obtains the color data of teal. </p>
</td>
</tr>
<tr id="row1667067068084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1940651118084826"><a name="p1940651118084826"></a><a name="p1940651118084826"></a><a href="Graphic.md#ga3b02160a068039d3801580c8e35008b4">OHOS::Color::Blue</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p683240414084826"><a name="p683240414084826"></a><a name="p683240414084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p852503789084826"><a name="p852503789084826"></a><a name="p852503789084826"></a>Obtains the color data of blue. </p>
</td>
</tr>
<tr id="row1323935268084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1472817238084826"><a name="p1472817238084826"></a><a name="p1472817238084826"></a><a href="Graphic.md#ga327d185847eab86cbe297a1e35f0d5d7">OHOS::Color::Navy</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1278195251084826"><a name="p1278195251084826"></a><a name="p1278195251084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p100772393084826"><a name="p100772393084826"></a><a name="p100772393084826"></a>Obtains the color data of navy. </p>
</td>
</tr>
<tr id="row1942773201084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p571492584084826"><a name="p571492584084826"></a><a name="p571492584084826"></a><a href="Graphic.md#ga4cbaf5650de24fc1ae45f93571b92f37">OHOS::Color::Magenta</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p431432048084826"><a name="p431432048084826"></a><a name="p431432048084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p1108921336084826"><a name="p1108921336084826"></a><a name="p1108921336084826"></a>Obtains the color data of magenta. </p>
</td>
</tr>
<tr id="row1081355444084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p549940736084826"><a name="p549940736084826"></a><a name="p549940736084826"></a><a href="Graphic.md#ga7ec7f44a7a7d828641b739616b01dadb">OHOS::Color::Purple</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p915987178084826"><a name="p915987178084826"></a><a name="p915987178084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p637137856084826"><a name="p637137856084826"></a><a name="p637137856084826"></a>Obtains the color data of purple. </p>
</td>
</tr>
<tr id="row1378807434084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p352789559084826"><a name="p352789559084826"></a><a name="p352789559084826"></a><a href="Graphic.md#gae127df687f7b04f9debc853498678aeb">OHOS::Color::Orange</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p77622867084826"><a name="p77622867084826"></a><a name="p77622867084826"></a>static <a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p2084968952084826"><a name="p2084968952084826"></a><a name="p2084968952084826"></a>Obtains the color data of orange. </p>
</td>
</tr>
<tr id="row223780006084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1539622782084826"><a name="p1539622782084826"></a><a name="p1539622782084826"></a><a href="Graphic.md#ga17210a2d5bb0be6d4b58efe249563d1b">OHOS::Image::Image</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2042937898084826"><a name="p2042937898084826"></a><a name="p2042937898084826"></a>&nbsp;</p>
<p id="p1487727835084826"><a name="p1487727835084826"></a><a name="p1487727835084826"></a>A constructor used to create an <strong id="b1325625605084826"><a name="b1325625605084826"></a><a name="b1325625605084826"></a><a href="OHOS-Image.md">Image</a></strong> instance. You can use this constructor when a component requires a map. </p>
</td>
</tr>
<tr id="row1792364572084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2057277027084826"><a name="p2057277027084826"></a><a name="p2057277027084826"></a><a href="Graphic.md#gaf3794ceb5acb543f8c526b5d9f6a1e4e">OHOS::Image::~Image</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1016284882084826"><a name="p1016284882084826"></a><a name="p1016284882084826"></a>virtual&nbsp;</p>
<p id="p1579786000084826"><a name="p1579786000084826"></a><a name="p1579786000084826"></a>A destructor used to delete the <strong id="b688106002084826"><a name="b688106002084826"></a><a name="b688106002084826"></a><a href="OHOS-Image.md">Image</a></strong> instance. </p>
</td>
</tr>
<tr id="row60925094084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p254955252084826"><a name="p254955252084826"></a><a name="p254955252084826"></a><a href="Graphic.md#ga592cbeb359a9d13274a6f4972aad3d79">OHOS::Image::GetImageInfo</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1196113468084826"><a name="p1196113468084826"></a><a name="p1196113468084826"></a>const <a href="OHOS-ImageInfo.md">ImageInfo</a> *&nbsp;</p>
<p id="p261906673084826"><a name="p261906673084826"></a><a name="p261906673084826"></a>Obtains the image information in an array. </p>
</td>
</tr>
<tr id="row1220388981084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p70205441084826"><a name="p70205441084826"></a><a name="p70205441084826"></a><a href="Graphic.md#gaa1552ae9813d324260a580c4ef5b0c9c">OHOS::Image::GetPath</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p576111299084826"><a name="p576111299084826"></a><a name="p576111299084826"></a>const char *&nbsp;</p>
<p id="p129176990084826"><a name="p129176990084826"></a><a name="p129176990084826"></a>Obtains the image path in binary. </p>
</td>
</tr>
<tr id="row2028331245084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1789708650084826"><a name="p1789708650084826"></a><a name="p1789708650084826"></a><a href="Graphic.md#gadf426b0d958898df8ef2f9b7b1d278f1">OHOS::Image::GetHeader</a> (<a href="OHOS-ImageHeader.md">ImageHeader</a> &amp;header) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1835866476084826"><a name="p1835866476084826"></a><a name="p1835866476084826"></a>void&nbsp;</p>
<p id="p213245807084826"><a name="p213245807084826"></a><a name="p213245807084826"></a>Obtains the basic image information, including the image format, width, and height. </p>
</td>
</tr>
<tr id="row482565350084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1244875105084826"><a name="p1244875105084826"></a><a name="p1244875105084826"></a><a href="Graphic.md#ga7dc8490594e2bc7c9cf50c1237507239">OHOS::Image::GetSrcType</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p88623162084826"><a name="p88623162084826"></a><a name="p88623162084826"></a>uint8_t&nbsp;</p>
<p id="p745493292084826"><a name="p745493292084826"></a><a name="p745493292084826"></a>Obtains the image type. </p>
</td>
</tr>
<tr id="row1455037357084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p39023854084826"><a name="p39023854084826"></a><a name="p39023854084826"></a><a href="Graphic.md#ga4fe78bf99b160fc55770ba1979412c8e">OHOS::Image::SetSrc</a> (const char *src)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1221390224084826"><a name="p1221390224084826"></a><a name="p1221390224084826"></a>bool&nbsp;</p>
<p id="p235391958084826"><a name="p235391958084826"></a><a name="p235391958084826"></a>Sets the image path. </p>
</td>
</tr>
<tr id="row909851535084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1833597356084826"><a name="p1833597356084826"></a><a name="p1833597356084826"></a><a href="Graphic.md#ga9471d489ab4d5b6848c1e50b4b7aac23">OHOS::Image::SetSrc</a> (const <a href="OHOS-ImageInfo.md">ImageInfo</a> *src)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p497586878084826"><a name="p497586878084826"></a><a name="p497586878084826"></a>bool&nbsp;</p>
<p id="p193601640084826"><a name="p193601640084826"></a><a name="p193601640084826"></a>Sets the image information. </p>
</td>
</tr>
<tr id="row425830731084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1880826745084826"><a name="p1880826745084826"></a><a name="p1880826745084826"></a><a href="Graphic.md#ga25c8efee1241f371b5d30df9817830a6">OHOS::Screen::GetInstance</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2041386095084826"><a name="p2041386095084826"></a><a name="p2041386095084826"></a>static <a href="OHOS-Screen.md">Screen</a> &amp;&nbsp;</p>
<p id="p826900236084826"><a name="p826900236084826"></a><a name="p826900236084826"></a>Obtains a singleton <strong id="b859148441084826"><a name="b859148441084826"></a><a name="b859148441084826"></a><a href="OHOS-Screen.md">Screen</a></strong> instance. </p>
</td>
</tr>
<tr id="row3466558084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p665423024084826"><a name="p665423024084826"></a><a name="p665423024084826"></a><a href="Graphic.md#ga2ce903f605e04f8d42d561b72944b30b">OHOS::Screen::GetWidth</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p974365355084826"><a name="p974365355084826"></a><a name="p974365355084826"></a>uint16_t&nbsp;</p>
<p id="p332029485084826"><a name="p332029485084826"></a><a name="p332029485084826"></a>Obtains the width of this screen. </p>
</td>
</tr>
<tr id="row1943621628084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p538929579084826"><a name="p538929579084826"></a><a name="p538929579084826"></a><a href="Graphic.md#ga65e3a923208b28f5a5f3a4be57d12996">OHOS::Screen::GetHeight</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1394495970084826"><a name="p1394495970084826"></a><a name="p1394495970084826"></a>uint16_t&nbsp;</p>
<p id="p1076249397084826"><a name="p1076249397084826"></a><a name="p1076249397084826"></a>Obtains the height of this screen. </p>
</td>
</tr>
<tr id="row1762657563084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2021767665084826"><a name="p2021767665084826"></a><a name="p2021767665084826"></a><em id="gad94964a9139150b967ad640ea2076312"><a name="gad94964a9139150b967ad640ea2076312"></a><a name="gad94964a9139150b967ad640ea2076312"></a></em>OHOS::Task::Task ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1126575524084826"><a name="p1126575524084826"></a><a name="p1126575524084826"></a><strong id="gad94964a9139150b967ad640ea2076312_1"><a name="gad94964a9139150b967ad640ea2076312_1"></a><a name="gad94964a9139150b967ad640ea2076312_1"></a></strong> &nbsp;</p>
<p id="p2045637520084826"><a name="p2045637520084826"></a><a name="p2045637520084826"></a>A constructor used to create a <strong id="b877114555084826"><a name="b877114555084826"></a><a name="b877114555084826"></a><a href="OHOS-Task.md">Task</a></strong> instance. </p>
</td>
</tr>
<tr id="row1839160146084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1126026333084826"><a name="p1126026333084826"></a><a name="p1126026333084826"></a><a href="Graphic.md#gaa7c50eb360b6a4478b5332b8bf565940">OHOS::Task::Task</a> (uint32_t period)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p348211856084826"><a name="p348211856084826"></a><a name="p348211856084826"></a>&nbsp;</p>
<p id="p905159413084826"><a name="p905159413084826"></a><a name="p905159413084826"></a>A constructor used to create a <strong id="b751561162084826"><a name="b751561162084826"></a><a name="b751561162084826"></a><a href="OHOS-Task.md">Task</a></strong> instance with the specified running period. </p>
</td>
</tr>
<tr id="row1680246776084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p727336704084826"><a name="p727336704084826"></a><a name="p727336704084826"></a><em id="ga293d4e1533ea98cdebbbffe1afed38ef"><a name="ga293d4e1533ea98cdebbbffe1afed38ef"></a><a name="ga293d4e1533ea98cdebbbffe1afed38ef"></a></em>OHOS::Task::~Task ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2101050802084826"><a name="p2101050802084826"></a><a name="p2101050802084826"></a><strong id="ga293d4e1533ea98cdebbbffe1afed38ef_1"><a name="ga293d4e1533ea98cdebbbffe1afed38ef_1"></a><a name="ga293d4e1533ea98cdebbbffe1afed38ef_1"></a></strong> virtual&nbsp;</p>
<p id="p1640084165084826"><a name="p1640084165084826"></a><a name="p1640084165084826"></a>A destructor used to delete the <strong id="b1654370922084826"><a name="b1654370922084826"></a><a name="b1654370922084826"></a><a href="OHOS-Task.md">Task</a></strong> instance. </p>
</td>
</tr>
<tr id="row961239196084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p185179549084826"><a name="p185179549084826"></a><a name="p185179549084826"></a><a href="Graphic.md#gac6e9fe7bde72bf506558a6f0d0287a92">OHOS::Task::SetPeriod</a> (uint32_t period)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p490204790084826"><a name="p490204790084826"></a><a name="p490204790084826"></a>void&nbsp;</p>
<p id="p1056085768084826"><a name="p1056085768084826"></a><a name="p1056085768084826"></a>Sets the running period for this task. </p>
</td>
</tr>
<tr id="row35951148084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1239757664084826"><a name="p1239757664084826"></a><a name="p1239757664084826"></a><a href="Graphic.md#gabdbfe69d5f5da3cc5bbb1749d281af62">OHOS::Task::SetLastRun</a> (uint32_t lastRun)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p387181021084826"><a name="p387181021084826"></a><a name="p387181021084826"></a>void&nbsp;</p>
<p id="p930952949084826"><a name="p930952949084826"></a><a name="p930952949084826"></a>Sets the end time for this task. </p>
</td>
</tr>
<tr id="row1399419865084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1026263626084826"><a name="p1026263626084826"></a><a name="p1026263626084826"></a><a href="Graphic.md#gabd53b86c63b41172af155b8a7f86b84c">OHOS::Task::GetPeriod</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p293886086084826"><a name="p293886086084826"></a><a name="p293886086084826"></a>uint32_t&nbsp;</p>
<p id="p181245142084826"><a name="p181245142084826"></a><a name="p181245142084826"></a>Obtains the running period of this task. </p>
</td>
</tr>
<tr id="row376511548084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1937384188084826"><a name="p1937384188084826"></a><a name="p1937384188084826"></a><a href="Graphic.md#ga2d4c9fbb026686623ff4d6e0b19d4960">OHOS::Task::GetLastRun</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1790187580084826"><a name="p1790187580084826"></a><a name="p1790187580084826"></a>uint32_t&nbsp;</p>
<p id="p1743394630084826"><a name="p1743394630084826"></a><a name="p1743394630084826"></a>Obtains the end time of this task. </p>
</td>
</tr>
<tr id="row759814146084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1664004994084826"><a name="p1664004994084826"></a><a name="p1664004994084826"></a><em id="ga96ed6680b2b9ad667e51d60554013020"><a name="ga96ed6680b2b9ad667e51d60554013020"></a><a name="ga96ed6680b2b9ad667e51d60554013020"></a></em>OHOS::Task::TaskExecute ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1504344149084826"><a name="p1504344149084826"></a><a name="p1504344149084826"></a><strong id="ga96ed6680b2b9ad667e51d60554013020_1"><a name="ga96ed6680b2b9ad667e51d60554013020_1"></a><a name="ga96ed6680b2b9ad667e51d60554013020_1"></a></strong> void&nbsp;</p>
<p id="p1417650199084826"><a name="p1417650199084826"></a><a name="p1417650199084826"></a>Executes this task. </p>
</td>
</tr>
<tr id="row670180205084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p699666484084826"><a name="p699666484084826"></a><a name="p699666484084826"></a><em id="gad1ddf68898304dad1f912f750ace8281"><a name="gad1ddf68898304dad1f912f750ace8281"></a><a name="gad1ddf68898304dad1f912f750ace8281"></a></em>OHOS::Task::Callback ()=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p858013879084826"><a name="p858013879084826"></a><a name="p858013879084826"></a><strong id="gad1ddf68898304dad1f912f750ace8281_1"><a name="gad1ddf68898304dad1f912f750ace8281_1"></a><a name="gad1ddf68898304dad1f912f750ace8281_1"></a></strong> virtual void&nbsp;</p>
<p id="p71914051084826"><a name="p71914051084826"></a><a name="p71914051084826"></a>Called when this task is executed. </p>
</td>
</tr>
<tr id="row582058674084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1689369595084826"><a name="p1689369595084826"></a><a name="p1689369595084826"></a><em id="gab9968727a3d5e8b6270f5efd0eb1cff6"><a name="gab9968727a3d5e8b6270f5efd0eb1cff6"></a><a name="gab9968727a3d5e8b6270f5efd0eb1cff6"></a></em>OHOS::Task::Init ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1905416857084826"><a name="p1905416857084826"></a><a name="p1905416857084826"></a><strong id="gab9968727a3d5e8b6270f5efd0eb1cff6_1"><a name="gab9968727a3d5e8b6270f5efd0eb1cff6_1"></a><a name="gab9968727a3d5e8b6270f5efd0eb1cff6_1"></a></strong> virtual void&nbsp;</p>
<p id="p946623481084826"><a name="p946623481084826"></a><a name="p946623481084826"></a>Initializes this task. </p>
</td>
</tr>
<tr id="row1907817661084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2096945595084826"><a name="p2096945595084826"></a><a name="p2096945595084826"></a><a href="Graphic.md#ga7ea8e1b0f5e199317c3134b575431ce6">OHOS::Text::Text</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2081264850084826"><a name="p2081264850084826"></a><a name="p2081264850084826"></a>&nbsp;</p>
<p id="p1173019222084826"><a name="p1173019222084826"></a><a name="p1173019222084826"></a>A constructor used to create a <strong id="b62042531084826"><a name="b62042531084826"></a><a name="b62042531084826"></a><a href="OHOS-Text.md">Text</a></strong> instance. </p>
</td>
</tr>
<tr id="row470968468084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1436745922084826"><a name="p1436745922084826"></a><a name="p1436745922084826"></a><a href="Graphic.md#gae15585b395b286ee404a57a61baa81f1">OHOS::Text::~Text</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p295831138084826"><a name="p295831138084826"></a><a name="p295831138084826"></a>virtual&nbsp;</p>
<p id="p427369974084826"><a name="p427369974084826"></a><a name="p427369974084826"></a>A destructor used to delete the <strong id="b1153381251084826"><a name="b1153381251084826"></a><a name="b1153381251084826"></a><a href="OHOS-Text.md">Text</a></strong> instance. </p>
</td>
</tr>
<tr id="row1298131573084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p733746875084826"><a name="p733746875084826"></a><a name="p733746875084826"></a><a href="Graphic.md#gaf4c592a07fe20af21e0ddae2d8203d96">OHOS::Text::SetText</a> (const char *text)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p849089168084826"><a name="p849089168084826"></a><a name="p849089168084826"></a>void&nbsp;</p>
<p id="p1918431797084826"><a name="p1918431797084826"></a><a name="p1918431797084826"></a>Sets the content for this text. </p>
</td>
</tr>
<tr id="row237151191084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p225958061084826"><a name="p225958061084826"></a><a name="p225958061084826"></a><a href="Graphic.md#gafcc64349913763e8d7feaf7bd9cbd639">OHOS::Text::GetText</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1219943515084826"><a name="p1219943515084826"></a><a name="p1219943515084826"></a>const char *&nbsp;</p>
<p id="p1474372238084826"><a name="p1474372238084826"></a><a name="p1474372238084826"></a>Obtains the content of this text. </p>
</td>
</tr>
<tr id="row1030449098084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p197200333084826"><a name="p197200333084826"></a><a name="p197200333084826"></a><a href="Graphic.md#ga1c1a26e57098662f787a1bb44bb9da8c">OHOS::Text::SetFont</a> (const char *name, uint8_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1242716823084826"><a name="p1242716823084826"></a><a name="p1242716823084826"></a>void&nbsp;</p>
<p id="p920203433084826"><a name="p920203433084826"></a><a name="p920203433084826"></a>Sets the font name and size. </p>
</td>
</tr>
<tr id="row1710855812084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p781596802084826"><a name="p781596802084826"></a><a name="p781596802084826"></a><a href="Graphic.md#gac27135182c89eabec65e22df079dc413">OHOS::Text::SetFontId</a> (uint8_t fontId)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p306911915084826"><a name="p306911915084826"></a><a name="p306911915084826"></a>void&nbsp;</p>
<p id="p385185764084826"><a name="p385185764084826"></a><a name="p385185764084826"></a>Sets the font ID. </p>
</td>
</tr>
<tr id="row1364653682084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p41020798084826"><a name="p41020798084826"></a><a name="p41020798084826"></a><a href="Graphic.md#ga32ba629806e9d8553bbcd441b4e66d55">OHOS::Text::GetFontId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1427396278084826"><a name="p1427396278084826"></a><a name="p1427396278084826"></a>uint8_t&nbsp;</p>
<p id="p1685953490084826"><a name="p1685953490084826"></a><a name="p1685953490084826"></a>Obtains the font ID. </p>
</td>
</tr>
<tr id="row1406527343084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p695020496084826"><a name="p695020496084826"></a><a name="p695020496084826"></a><a href="Graphic.md#ga96801aa6350a8533496b0718d67f0b9c">OHOS::Text::SetDirect</a> (<a href="Graphic.md#ga0c108f97781843f67c101b47b6c00cf0">UITextLanguageDirect</a> direct)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p168745036084826"><a name="p168745036084826"></a><a name="p168745036084826"></a>void&nbsp;</p>
<p id="p1956598358084826"><a name="p1956598358084826"></a><a name="p1956598358084826"></a>Sets the direction for this text. </p>
</td>
</tr>
<tr id="row923000268084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1314966436084826"><a name="p1314966436084826"></a><a name="p1314966436084826"></a><a href="Graphic.md#gacd469d16b0f3a8e7406d736f5e857996">OHOS::Text::GetDirect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p89520459084826"><a name="p89520459084826"></a><a name="p89520459084826"></a><a href="Graphic.md#ga0c108f97781843f67c101b47b6c00cf0">UITextLanguageDirect</a>&nbsp;</p>
<p id="p1740948915084826"><a name="p1740948915084826"></a><a name="p1740948915084826"></a>Obtains the direction of this text. </p>
</td>
</tr>
<tr id="row1587050296084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1561622319084826"><a name="p1561622319084826"></a><a name="p1561622319084826"></a><a href="Graphic.md#gad4721f5014971f6017aaaa5cc0af6845">OHOS::Text::SetAlign</a> (<a href="Graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a> horizontalAlign, <a href="Graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a> verticalAlign=TEXT_ALIGNMENT_TOP)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1564723852084826"><a name="p1564723852084826"></a><a name="p1564723852084826"></a>void&nbsp;</p>
<p id="p1454153205084826"><a name="p1454153205084826"></a><a name="p1454153205084826"></a>Sets the alignment mode for this text. </p>
</td>
</tr>
<tr id="row2047448105084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1903013137084826"><a name="p1903013137084826"></a><a name="p1903013137084826"></a><a href="Graphic.md#ga3c17868fb06a77f43587c67de4ca5ab6">OHOS::Text::GetHorAlign</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p126234193084826"><a name="p126234193084826"></a><a name="p126234193084826"></a><a href="Graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a>&nbsp;</p>
<p id="p139628186084826"><a name="p139628186084826"></a><a name="p139628186084826"></a>Obtains the horizontal alignment mode. </p>
</td>
</tr>
<tr id="row858780571084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p392229469084826"><a name="p392229469084826"></a><a name="p392229469084826"></a><a href="Graphic.md#gac312f642e12cfad8d974f8159984864e">OHOS::Text::GetVerAlign</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p829354355084826"><a name="p829354355084826"></a><a name="p829354355084826"></a><a href="Graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a>&nbsp;</p>
<p id="p462210337084826"><a name="p462210337084826"></a><a name="p462210337084826"></a>Obtains the vertical alignment mode. </p>
</td>
</tr>
<tr id="row570827277084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2026031022084826"><a name="p2026031022084826"></a><a name="p2026031022084826"></a><a href="Graphic.md#ga2ec83b586a0a7ebe402bb70a31be2ca6">OHOS::Text::SetTextRotation</a> (LabelRotateDegree angle)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2093695008084826"><a name="p2093695008084826"></a><a name="p2093695008084826"></a>void&nbsp;</p>
<p id="p107552136084826"><a name="p107552136084826"></a><a name="p107552136084826"></a>Sets the clockwise rotation angle for this text. </p>
</td>
</tr>
<tr id="row1049613213084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1664804393084826"><a name="p1664804393084826"></a><a name="p1664804393084826"></a><a href="Graphic.md#ga2dcc364f56ffa8bada573c7f96c92b0e">OHOS::Text::GetTextRotation</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p814026929084826"><a name="p814026929084826"></a><a name="p814026929084826"></a>LabelRotateDegree&nbsp;</p>
<p id="p1760568063084826"><a name="p1760568063084826"></a><a name="p1760568063084826"></a>Obtains the clockwise rotation degree of this text. </p>
</td>
</tr>
<tr id="row965125583084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p868203221084826"><a name="p868203221084826"></a><a name="p868203221084826"></a><a href="Graphic.md#gae36f3e226f23d8d7dff174054f60a741">OHOS::Text::GetTextRotateDegree</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1878396626084826"><a name="p1878396626084826"></a><a name="p1878396626084826"></a>uint16_t&nbsp;</p>
<p id="p781846759084826"><a name="p781846759084826"></a><a name="p781846759084826"></a>Obtains the number of text rotation degrees. </p>
</td>
</tr>
<tr id="row1922349362084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p560272964084826"><a name="p560272964084826"></a><a name="p560272964084826"></a><a href="Graphic.md#ga7e3e2deccb36992428d7984681329f09">OHOS::Text::GetTextSize</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1883716109084826"><a name="p1883716109084826"></a><a name="p1883716109084826"></a><a href="OHOS-Point.md">Point</a>&nbsp;</p>
<p id="p1414907469084826"><a name="p1414907469084826"></a><a name="p1414907469084826"></a>Obtains the size of this text. </p>
</td>
</tr>
<tr id="row458980529084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p613264192084826"><a name="p613264192084826"></a><a name="p613264192084826"></a><a href="Graphic.md#ga7aa8b64ece3c4b3bf592dc88fc7c11d2">OHOS::Text::SetExpandWidth</a> (bool expand)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p776461660084826"><a name="p776461660084826"></a><a name="p776461660084826"></a>void&nbsp;</p>
<p id="p1188104422084826"><a name="p1188104422084826"></a><a name="p1188104422084826"></a>Sets whether to adapt the component width to this text. </p>
</td>
</tr>
<tr id="row551826682084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1020135717084826"><a name="p1020135717084826"></a><a name="p1020135717084826"></a><a href="Graphic.md#gaab55ac2d3f8e45b4bfb5fd5ae07d1edd">OHOS::Text::IsExpandWidth</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2032869602084826"><a name="p2032869602084826"></a><a name="p2032869602084826"></a>bool&nbsp;</p>
<p id="p1535370298084826"><a name="p1535370298084826"></a><a name="p1535370298084826"></a>Checks whether the component width adapts to this text. </p>
</td>
</tr>
<tr id="row1847926551084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1400696912084826"><a name="p1400696912084826"></a><a name="p1400696912084826"></a><a href="Graphic.md#gac08f297a1593424d754450c75bc47045">OHOS::Text::SetExpandHeight</a> (bool expand)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p707702746084826"><a name="p707702746084826"></a><a name="p707702746084826"></a>void&nbsp;</p>
<p id="p860021177084826"><a name="p860021177084826"></a><a name="p860021177084826"></a>Sets whether to adapt the component height to this text. </p>
</td>
</tr>
<tr id="row1093407631084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1654184825084826"><a name="p1654184825084826"></a><a name="p1654184825084826"></a><a href="Graphic.md#ga09475a9cd4e86b19d4c3d4206ea5ffc6">OHOS::Text::IsExpandHeight</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1143502598084826"><a name="p1143502598084826"></a><a name="p1143502598084826"></a>bool&nbsp;</p>
<p id="p352406266084826"><a name="p352406266084826"></a><a name="p352406266084826"></a>Checks whether the component height adapts to this text. </p>
</td>
</tr>
<tr id="row222487057084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p46701554084826"><a name="p46701554084826"></a><a name="p46701554084826"></a><a href="Graphic.md#ga302dc8ff172b67c104363710f4b53cb0">OHOS::Text::GetEllipsisIndex</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;textRect, const <a href="OHOS-Style.md">Style</a> &amp;style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p91277090084826"><a name="p91277090084826"></a><a name="p91277090084826"></a>uint16_t&nbsp;</p>
<p id="p1673370686084826"><a name="p1673370686084826"></a><a name="p1673370686084826"></a>Obtains the index of the character from where text will be replaced by ellipses based on the text rectangle and style. </p>
</td>
</tr>
<tr id="row1183987863084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1452098927084826"><a name="p1452098927084826"></a><a name="p1452098927084826"></a><a href="Graphic.md#gab60e1c77fb98352bd62e56b550d75d88">OHOS::AbstractAdapter::AbstractAdapter</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1508747105084826"><a name="p1508747105084826"></a><a name="p1508747105084826"></a>&nbsp;</p>
<p id="p1424437856084826"><a name="p1424437856084826"></a><a name="p1424437856084826"></a>A constructor used to create an <strong id="b308524047084826"><a name="b308524047084826"></a><a name="b308524047084826"></a><a href="OHOS-AbstractAdapter.md">AbstractAdapter</a></strong> instance. </p>
</td>
</tr>
<tr id="row108111076084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p565268556084826"><a name="p565268556084826"></a><a name="p565268556084826"></a><a href="Graphic.md#ga86fbbc62904d459ec4fa39bab7703af7">OHOS::AbstractAdapter::~AbstractAdapter</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2008584032084826"><a name="p2008584032084826"></a><a name="p2008584032084826"></a>virtual&nbsp;</p>
<p id="p1400067435084826"><a name="p1400067435084826"></a><a name="p1400067435084826"></a>A destructor used to delete the <strong id="b1269871794084826"><a name="b1269871794084826"></a><a name="b1269871794084826"></a><a href="OHOS-AbstractAdapter.md">AbstractAdapter</a></strong> instance. </p>
</td>
</tr>
<tr id="row251168296084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1232308426084826"><a name="p1232308426084826"></a><a name="p1232308426084826"></a><a href="Graphic.md#ga67021b360d4097c475d5e24519b5276d">OHOS::AbstractAdapter::GetCount</a> ()=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2141810324084826"><a name="p2141810324084826"></a><a name="p2141810324084826"></a>virtual uint16_t&nbsp;</p>
<p id="p1292504692084826"><a name="p1292504692084826"></a><a name="p1292504692084826"></a>Obtains the number of adapter data items. </p>
</td>
</tr>
<tr id="row1593814151084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1694675306084826"><a name="p1694675306084826"></a><a name="p1694675306084826"></a><a href="Graphic.md#gab155b2f4a6d8fd97755dcd1e6d3d8361">OHOS::AbstractAdapter::GetView</a> (<a href="OHOS-UIView.md">UIView</a> *inView, int16_t <a href="UTILS.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1499279509084826"><a name="p1499279509084826"></a><a name="p1499279509084826"></a>virtual <a href="OHOS-UIView.md">UIView</a> *&nbsp;</p>
<p id="p1391608086084826"><a name="p1391608086084826"></a><a name="p1391608086084826"></a>Obtains a <strong id="b1050401786084826"><a name="b1050401786084826"></a><a name="b1050401786084826"></a><a href="OHOS-UIView.md">UIView</a></strong> instance to convert adapter data into another <strong id="b1693576452084826"><a name="b1693576452084826"></a><a name="b1693576452084826"></a><a href="OHOS-UIView.md">UIView</a></strong> instance. </p>
</td>
</tr>
<tr id="row907381795084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p205971915084826"><a name="p205971915084826"></a><a name="p205971915084826"></a><a href="Graphic.md#ga924ce70adcad92d852ba1d1faa441ac8">OHOS::RootView::GetInstance</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1630792846084826"><a name="p1630792846084826"></a><a name="p1630792846084826"></a>static <a href="OHOS-RootView.md">RootView</a> *&nbsp;</p>
<p id="p915238760084826"><a name="p915238760084826"></a><a name="p915238760084826"></a>Obtains a singleton <strong id="b935099875084826"><a name="b935099875084826"></a><a name="b935099875084826"></a><a href="OHOS-RootView.md">RootView</a></strong> instance. </p>
</td>
</tr>
<tr id="row369887359084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p359674584084826"><a name="p359674584084826"></a><a name="p359674584084826"></a><a href="Graphic.md#gab21e31a784cc709b1f075ae53ad81818">OHOS::RootView::OnKeyActListener::OnKeyAct</a> (<a href="OHOS-UIView.md">UIView</a> &amp;view, const <a href="OHOS-KeyEvent.md">KeyEvent</a> &amp;event)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1175080567084826"><a name="p1175080567084826"></a><a name="p1175080567084826"></a>virtual bool&nbsp;</p>
<p id="p841918320084826"><a name="p841918320084826"></a><a name="p841918320084826"></a>Responds to a physical key event. </p>
</td>
</tr>
<tr id="row438576079084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2018272873084826"><a name="p2018272873084826"></a><a name="p2018272873084826"></a><a href="Graphic.md#ga7b96c15cdbe0edd5045e479b3b2fe1eb">OHOS::RootView::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1066073712084826"><a name="p1066073712084826"></a><a name="p1066073712084826"></a>UIViewType&nbsp;</p>
<p id="p523785361084826"><a name="p523785361084826"></a><a name="p523785361084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row932161924084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p750848284084826"><a name="p750848284084826"></a><a name="p750848284084826"></a><a href="Graphic.md#gaffcd945698a2df5f3fde5342c74719a9">OHOS::RootView::OnKeyEvent</a> (const <a href="OHOS-KeyEvent.md">KeyEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p137022250084826"><a name="p137022250084826"></a><a name="p137022250084826"></a>virtual void&nbsp;</p>
<p id="p1923023909084826"><a name="p1923023909084826"></a><a name="p1923023909084826"></a>Executes a physical key event. </p>
</td>
</tr>
<tr id="row198998380084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1728734801084826"><a name="p1728734801084826"></a><a name="p1728734801084826"></a><a href="Graphic.md#ga3c0fce0e3a6c1b83324e54468d077bb0">OHOS::RootView::SetOnKeyActListener</a> (<a href="OHOS-RootView-OnKeyActListener.md">OnKeyActListener</a> *onKeyActListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p979674307084826"><a name="p979674307084826"></a><a name="p979674307084826"></a>void&nbsp;</p>
<p id="p1953291230084826"><a name="p1953291230084826"></a><a name="p1953291230084826"></a>Sets the listener that contains a callback to be invoked upon a physical key event. </p>
</td>
</tr>
<tr id="row1845255827084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p83831378084826"><a name="p83831378084826"></a><a name="p83831378084826"></a><a href="Graphic.md#ga00303597af333088c06a45346f4a77f2">OHOS::RootView::ClearOnKeyActListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p968056466084826"><a name="p968056466084826"></a><a name="p968056466084826"></a>void&nbsp;</p>
<p id="p784761408084826"><a name="p784761408084826"></a><a name="p784761408084826"></a>Clears the listener for monitoring physical key events. </p>
</td>
</tr>
<tr id="row233487741084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1534889023084826"><a name="p1534889023084826"></a><a name="p1534889023084826"></a><a href="Graphic.md#ga548d8e9577a986223ff134c32eece547">OHOS::RootView::OnVirtualDeviceEventListener::OnVirtualDeviceEvent</a> (<a href="OHOS-UIView.md">UIView</a> &amp;view, <a href="OHOS-VirtualDeviceEvent.md">VirtualDeviceEvent</a> event)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1259276803084826"><a name="p1259276803084826"></a><a name="p1259276803084826"></a>virtual bool&nbsp;</p>
<p id="p958862761084826"><a name="p958862761084826"></a><a name="p958862761084826"></a>Responds to an input event triggered by a virtual device. </p>
</td>
</tr>
<tr id="row147510177084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2055768816084826"><a name="p2055768816084826"></a><a name="p2055768816084826"></a><a href="Graphic.md#gae86a0b7fa1a2c4fee021cb7bed2d418c">OHOS::RootView::OnVirtualDeviceEvent</a> (const <a href="OHOS-VirtualDeviceEvent.md">VirtualDeviceEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p299387742084826"><a name="p299387742084826"></a><a name="p299387742084826"></a>virtual void&nbsp;</p>
<p id="p734507791084826"><a name="p734507791084826"></a><a name="p734507791084826"></a>Executes an input event triggered by a virtual device. </p>
</td>
</tr>
<tr id="row2138088905084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p700300888084826"><a name="p700300888084826"></a><a name="p700300888084826"></a><a href="Graphic.md#gac12473c0dc9b293f6be9553afbb7c5d6">OHOS::RootView::SetOnVirtualDeviceEventListener</a> (<a href="OHOS-RootView-OnVirtualDeviceEventListener.md">OnVirtualDeviceEventListener</a> *onVirtualDeviceEventListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1799803014084826"><a name="p1799803014084826"></a><a name="p1799803014084826"></a>void&nbsp;</p>
<p id="p1223325170084826"><a name="p1223325170084826"></a><a name="p1223325170084826"></a>Sets a listener for monitoring the input events of a virtual device. </p>
</td>
</tr>
<tr id="row1800107300084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p797523469084826"><a name="p797523469084826"></a><a name="p797523469084826"></a><a href="Graphic.md#ga0b550a305c0cda1dc510b2446c56ed82">OHOS::RootView::ClearOnVirtualDeviceEventListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1968300849084826"><a name="p1968300849084826"></a><a name="p1968300849084826"></a>void&nbsp;</p>
<p id="p634221479084826"><a name="p634221479084826"></a><a name="p634221479084826"></a>Clears the listener for monitoring the input events of a virtual device. </p>
</td>
</tr>
<tr id="row632255116084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p164433053084826"><a name="p164433053084826"></a><a name="p164433053084826"></a><a href="Graphic.md#gabb3c193eea516b09f9ed6932b298ab9a">OHOS::RootView::FindSubView</a> (const <a href="OHOS-UIView.md">UIView</a> &amp;parentView, const <a href="OHOS-UIView.md">UIView</a> *subView)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1561858462084826"><a name="p1561858462084826"></a><a name="p1561858462084826"></a>static bool&nbsp;</p>
<p id="p1019815773084826"><a name="p1019815773084826"></a><a name="p1019815773084826"></a>Checks whether the target view is one of the child views of the specified parent view. </p>
</td>
</tr>
<tr id="row1054526844084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p82785422084826"><a name="p82785422084826"></a><a name="p82785422084826"></a><a href="Graphic.md#ga183cac282667493fa2a008f9a7f4f9d2">OHOS::TextFormatter::Format</a> (int16_t value, char *outText, uint16_t textLen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p599741065084826"><a name="p599741065084826"></a><a name="p599741065084826"></a>virtual bool&nbsp;</p>
<p id="p336517699084826"><a name="p336517699084826"></a><a name="p336517699084826"></a>Converts the input integer into a character string for output. </p>
</td>
</tr>
<tr id="row651580042084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p617494448084826"><a name="p617494448084826"></a><a name="p617494448084826"></a><a href="Graphic.md#ga38bde4aa4a0952341ad74284ff686832">OHOS::TextAdapter::TextAdapter</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p161339891084826"><a name="p161339891084826"></a><a name="p161339891084826"></a>&nbsp;</p>
<p id="p192556415084826"><a name="p192556415084826"></a><a name="p192556415084826"></a>A constructor used to create a <strong id="b1559120060084826"><a name="b1559120060084826"></a><a name="b1559120060084826"></a><a href="OHOS-UILabel.md">UILabel</a></strong> instance. </p>
</td>
</tr>
<tr id="row944301013084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1007645661084826"><a name="p1007645661084826"></a><a name="p1007645661084826"></a><a href="Graphic.md#ga1e868c845df224beff2f3c6f49593d3b">OHOS::TextAdapter::~TextAdapter</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1592106950084826"><a name="p1592106950084826"></a><a name="p1592106950084826"></a>virtual&nbsp;</p>
<p id="p109226491084826"><a name="p109226491084826"></a><a name="p109226491084826"></a>A destructor used to delete the <strong id="b1965415001084826"><a name="b1965415001084826"></a><a name="b1965415001084826"></a><a href="OHOS-UILabel.md">UILabel</a></strong> instance. </p>
</td>
</tr>
<tr id="row1359971011084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p925764306084826"><a name="p925764306084826"></a><a name="p925764306084826"></a><a href="Graphic.md#ga733211ca13eccff628bb2712c27b885e">OHOS::TextAdapter::GetView</a> (<a href="OHOS-UIView.md">UIView</a> *inView, int16_t <a href="UTILS.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2107919717084826"><a name="p2107919717084826"></a><a name="p2107919717084826"></a><a href="OHOS-UIView.md">UIView</a> *&nbsp;</p>
<p id="p1643400587084826"><a name="p1643400587084826"></a><a name="p1643400587084826"></a>Obtains a <strong id="b817970845084826"><a name="b817970845084826"></a><a name="b817970845084826"></a><a href="OHOS-UILabel.md">UILabel</a></strong> instance to convert adapter data into another <strong id="b639416577084826"><a name="b639416577084826"></a><a name="b639416577084826"></a><a href="OHOS-UILabel.md">UILabel</a></strong> instance. </p>
</td>
</tr>
<tr id="row1732922987084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p891296722084826"><a name="p891296722084826"></a><a name="p891296722084826"></a><a href="Graphic.md#gabe6f62c7e3284e04b37451963e803a96">OHOS::TextAdapter::SetData</a> (<a href="OHOS-List-T.md">List</a>&lt; const char * &gt; *data)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p281064588084826"><a name="p281064588084826"></a><a name="p281064588084826"></a>void&nbsp;</p>
<p id="p829900716084826"><a name="p829900716084826"></a><a name="p829900716084826"></a>Sets the <a href="OHOS-UILabel.md">UILabel</a> adapter data, which is a string linked list. </p>
</td>
</tr>
<tr id="row2040050860084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1917776805084826"><a name="p1917776805084826"></a><a name="p1917776805084826"></a><a href="Graphic.md#ga9521d17dfaf251b42deafc182aea8a1e">OHOS::TextAdapter::SetData</a> (int16_t start, int16_t end)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1362918536084826"><a name="p1362918536084826"></a><a name="p1362918536084826"></a>void&nbsp;</p>
<p id="p869111798084826"><a name="p869111798084826"></a><a name="p869111798084826"></a>Sets continuously increasing data. For example, if you need to set data <strong id="b55537249084826"><a name="b55537249084826"></a><a name="b55537249084826"></a>0</strong>, <strong id="b2100194044084826"><a name="b2100194044084826"></a><a name="b2100194044084826"></a>1</strong>, <strong id="b811801204084826"><a name="b811801204084826"></a><a name="b811801204084826"></a>2</strong>, <strong id="b1290792735084826"><a name="b1290792735084826"></a><a name="b1290792735084826"></a>3</strong>, <strong id="b302496241084826"><a name="b302496241084826"></a><a name="b302496241084826"></a>4</strong>, use this function to set <strong id="b320645720084826"><a name="b320645720084826"></a><a name="b320645720084826"></a>start</strong> to 0 and <strong id="b401689258084826"><a name="b401689258084826"></a><a name="b401689258084826"></a>end</strong> to 4. </p>
</td>
</tr>
<tr id="row1775354563084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1592302062084826"><a name="p1592302062084826"></a><a name="p1592302062084826"></a><a href="Graphic.md#gaf0ec9f4036ed071ab95081bb3237f89a">OHOS::TextAdapter::SetFontId</a> (uint8_t fontId)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1682502992084826"><a name="p1682502992084826"></a><a name="p1682502992084826"></a>void&nbsp;</p>
<p id="p2042459030084826"><a name="p2042459030084826"></a><a name="p2042459030084826"></a>Sets font ID. </p>
</td>
</tr>
<tr id="row2076890233084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1597644669084826"><a name="p1597644669084826"></a><a name="p1597644669084826"></a><a href="Graphic.md#ga077ac9bece7019abc2a755031ddc5575">OHOS::TextAdapter::GetFontId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p798782670084826"><a name="p798782670084826"></a><a name="p798782670084826"></a>uint8_t&nbsp;</p>
<p id="p1437874932084826"><a name="p1437874932084826"></a><a name="p1437874932084826"></a>Obtains font ID. </p>
</td>
</tr>
<tr id="row1097361785084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p57804702084826"><a name="p57804702084826"></a><a name="p57804702084826"></a><a href="Graphic.md#ga28d957b0aa0324e876a871eae1b80d3f">OHOS::TextAdapter::SetFont</a> (const char *name, uint8_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1457235533084826"><a name="p1457235533084826"></a><a name="p1457235533084826"></a>void&nbsp;</p>
<p id="p1636260404084826"><a name="p1636260404084826"></a><a name="p1636260404084826"></a>Sets the font. </p>
</td>
</tr>
<tr id="row1309398599084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p316459075084826"><a name="p316459075084826"></a><a name="p316459075084826"></a><a href="Graphic.md#gacba8806f0f63a2b0436dbe4ec1b4d01c">OHOS::TextAdapter::GetStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p71911049084826"><a name="p71911049084826"></a><a name="p71911049084826"></a><a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p229745664084826"><a name="p229745664084826"></a><a name="p229745664084826"></a>Obtains the <a href="OHOS-UILabel.md">UILabel</a> adapter style. </p>
</td>
</tr>
<tr id="row1507824506084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p123699974084826"><a name="p123699974084826"></a><a name="p123699974084826"></a><a href="Graphic.md#gaa8d1098628c391a687b08f4ccdba0a4d">OHOS::TextAdapter::GetCount</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p381787345084826"><a name="p381787345084826"></a><a name="p381787345084826"></a>virtual uint16_t&nbsp;</p>
<p id="p1646686821084826"><a name="p1646686821084826"></a><a name="p1646686821084826"></a>Obtains the <strong id="b23434983084826"><a name="b23434983084826"></a><a name="b23434983084826"></a>data</strong> size of the <a href="OHOS-UILabel.md">UILabel</a> adapter. </p>
</td>
</tr>
<tr id="row864926899084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1705909182084826"><a name="p1705909182084826"></a><a name="p1705909182084826"></a><a href="Graphic.md#gaed7f27b1dbf4f50ae8eda00cc6cb6a27">OHOS::TextAdapter::SetWidth</a> (int16_t width)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p486991255084826"><a name="p486991255084826"></a><a name="p486991255084826"></a>void&nbsp;</p>
<p id="p589203794084826"><a name="p589203794084826"></a><a name="p589203794084826"></a>Sets the width of <a href="OHOS-UILabel.md">UILabel</a> constructed by the adapter. </p>
</td>
</tr>
<tr id="row2146895091084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1040378466084826"><a name="p1040378466084826"></a><a name="p1040378466084826"></a><a href="Graphic.md#ga618021df16f2156ddeeb12d5a8fa14f9">OHOS::TextAdapter::SetDirect</a> (<a href="Graphic.md#ga0c108f97781843f67c101b47b6c00cf0">UITextLanguageDirect</a> direct)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1751993870084826"><a name="p1751993870084826"></a><a name="p1751993870084826"></a>void&nbsp;</p>
<p id="p480035827084826"><a name="p480035827084826"></a><a name="p480035827084826"></a>Sets the direction of the <a href="OHOS-UILabel.md">UILabel</a> constructed by the adapter. </p>
</td>
</tr>
<tr id="row922181457084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2063978274084826"><a name="p2063978274084826"></a><a name="p2063978274084826"></a><a href="Graphic.md#ga2c83259c064091d74deac1e4a69f834c">OHOS::TextAdapter::SetHeight</a> (int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p855191135084826"><a name="p855191135084826"></a><a name="p855191135084826"></a>void&nbsp;</p>
<p id="p1857375634084826"><a name="p1857375634084826"></a><a name="p1857375634084826"></a>Sets the height of the <a href="OHOS-UILabel.md">UILabel</a> constructed by the adapter. </p>
</td>
</tr>
<tr id="row1616297654084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p587726870084826"><a name="p587726870084826"></a><a name="p587726870084826"></a><a href="Graphic.md#gafc5f3b2c909753f4a7ef53daa80b530b">OHOS::TextAdapter::SetLineBreakMode</a> (const uint8_t lineBreakMode)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1441459437084826"><a name="p1441459437084826"></a><a name="p1441459437084826"></a>void&nbsp;</p>
<p id="p59372406084826"><a name="p59372406084826"></a><a name="p59372406084826"></a>Sets the <strong id="b1334363347084826"><a name="b1334363347084826"></a><a name="b1334363347084826"></a>LineBreakMode</strong> attribute of <a href="OHOS-UILabel.md">UILabel</a> constructed by the adapter. For details about the values of <strong id="b141623449084826"><a name="b141623449084826"></a><a name="b141623449084826"></a>LineBreakMode</strong>, see <strong id="b1736249778084826"><a name="b1736249778084826"></a><a name="b1736249778084826"></a>LINE_BREAK_ADAPT</strong>, <strong id="b982440228084826"><a name="b982440228084826"></a><a name="b982440228084826"></a>LINE_BREAK_WRAP</strong>, <strong id="b784092004084826"><a name="b784092004084826"></a><a name="b784092004084826"></a>LINE_BREAK_ELLIPSIS</strong>, and <strong id="b370860116084826"><a name="b370860116084826"></a><a name="b370860116084826"></a>LINE_BREAK_MARQUEE</strong>. </p>
</td>
</tr>
<tr id="row2061955802084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1781258691084826"><a name="p1781258691084826"></a><a name="p1781258691084826"></a><a href="Graphic.md#ga9aa8cecae666906c7fa3d292d6c1c842">OHOS::TextAdapter::SetOnClickListener</a> (<a href="OHOS-UIView-OnClickListener.md">UIView::OnClickListener</a> *clickListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p247992150084826"><a name="p247992150084826"></a><a name="p247992150084826"></a>void&nbsp;</p>
<p id="p582951283084826"><a name="p582951283084826"></a><a name="p582951283084826"></a>Sets the callback function to be invoked upon a click event. </p>
</td>
</tr>
<tr id="row1372972541084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p332557428084826"><a name="p332557428084826"></a><a name="p332557428084826"></a><a href="Graphic.md#gadad75361a42fd390b5f9c5edad2f2f0b">OHOS::TextAdapter::SetTextFormatter</a> (<a href="OHOS-TextFormatter.md">TextFormatter</a> *formatter)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1290928829084826"><a name="p1290928829084826"></a><a name="p1290928829084826"></a>void&nbsp;</p>
<p id="p1001554824084826"><a name="p1001554824084826"></a><a name="p1001554824084826"></a>Sets the text formatter. </p>
</td>
</tr>
<tr id="row173473354084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p394606033084826"><a name="p394606033084826"></a><a name="p394606033084826"></a><a href="Graphic.md#ga160a40d9f81c72b606b3c5b05168bacf">OHOS::UIAbstractClock::UIAbstractClock</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1658014785084826"><a name="p1658014785084826"></a><a name="p1658014785084826"></a>&nbsp;</p>
<p id="p1796724991084826"><a name="p1796724991084826"></a><a name="p1796724991084826"></a>A default constructor used to create a <strong id="b680562505084826"><a name="b680562505084826"></a><a name="b680562505084826"></a><a href="OHOS-UIAbstractClock.md">UIAbstractClock</a></strong> instance. </p>
</td>
</tr>
<tr id="row780036833084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1422608509084826"><a name="p1422608509084826"></a><a name="p1422608509084826"></a><a href="Graphic.md#ga93d3d68e48a79ee7fc4b42a9c0c0ccc1">OHOS::UIAbstractClock::UIAbstractClock</a> (uint8_t hour, uint8_t minute, uint8_t second)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p178111470084826"><a name="p178111470084826"></a><a name="p178111470084826"></a>&nbsp;</p>
<p id="p2079914781084826"><a name="p2079914781084826"></a><a name="p2079914781084826"></a>A constructor used to create a <strong id="b1827374287084826"><a name="b1827374287084826"></a><a name="b1827374287084826"></a><a href="OHOS-UIAbstractClock.md">UIAbstractClock</a></strong> instance with time elements (hour, minute and second). </p>
</td>
</tr>
<tr id="row385658809084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1272600222084826"><a name="p1272600222084826"></a><a name="p1272600222084826"></a><a href="Graphic.md#ga0fb0c108b319f02b9d42b34c1d2c8708">OHOS::UIAbstractClock::~UIAbstractClock</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p317470813084826"><a name="p317470813084826"></a><a name="p317470813084826"></a>virtual&nbsp;</p>
<p id="p2041109822084826"><a name="p2041109822084826"></a><a name="p2041109822084826"></a>A destructor used to delete the <strong id="b1509560015084826"><a name="b1509560015084826"></a><a name="b1509560015084826"></a><a href="OHOS-UIAbstractClock.md">UIAbstractClock</a></strong> instance. </p>
</td>
</tr>
<tr id="row1161612345084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p151520661084826"><a name="p151520661084826"></a><a name="p151520661084826"></a><a href="Graphic.md#ga8f7edc9e099688b4fd2b3ed3171eac58">OHOS::UIAbstractClock::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p383744811084826"><a name="p383744811084826"></a><a name="p383744811084826"></a>UIViewType&nbsp;</p>
<p id="p372970146084826"><a name="p372970146084826"></a><a name="p372970146084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row1708747972084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p841846653084826"><a name="p841846653084826"></a><a name="p841846653084826"></a><a href="Graphic.md#ga44a7312163a4192670c00bb8f9916e51">OHOS::UIAbstractClock::SetTime24Hour</a> (uint8_t hour, uint8_t minute, uint8_t second)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2050741100084826"><a name="p2050741100084826"></a><a name="p2050741100084826"></a>void&nbsp;</p>
<p id="p1046037638084826"><a name="p1046037638084826"></a><a name="p1046037638084826"></a>Sets the time in 24-hour format. </p>
</td>
</tr>
<tr id="row1475135755084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1836802030084826"><a name="p1836802030084826"></a><a name="p1836802030084826"></a><a href="Graphic.md#ga37750dfa0b5a47c8dcb61547dd991a6a">OHOS::UIAbstractClock::SetTime12Hour</a> (uint8_t hour, uint8_t minute, uint8_t second, bool am)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p287942875084826"><a name="p287942875084826"></a><a name="p287942875084826"></a>void&nbsp;</p>
<p id="p443073057084826"><a name="p443073057084826"></a><a name="p443073057084826"></a>Sets the time in 12-hour format. </p>
</td>
</tr>
<tr id="row1000007561084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1324142051084826"><a name="p1324142051084826"></a><a name="p1324142051084826"></a><a href="Graphic.md#ga8cf863dfcd63410f2f20572a51f2516b">OHOS::UIAbstractClock::GetCurrentHour</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1091847830084826"><a name="p1091847830084826"></a><a name="p1091847830084826"></a>uint8_t&nbsp;</p>
<p id="p173680071084826"><a name="p173680071084826"></a><a name="p173680071084826"></a>Obtains the current number of hours. </p>
</td>
</tr>
<tr id="row1450771332084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1189179627084826"><a name="p1189179627084826"></a><a name="p1189179627084826"></a><a href="Graphic.md#ga5f0eea09577104d9126a07bfbc0b780a">OHOS::UIAbstractClock::GetCurrentMinute</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p772773175084826"><a name="p772773175084826"></a><a name="p772773175084826"></a>uint8_t&nbsp;</p>
<p id="p2098617909084826"><a name="p2098617909084826"></a><a name="p2098617909084826"></a>Obtains the current number of minutes. </p>
</td>
</tr>
<tr id="row440568914084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1575166150084826"><a name="p1575166150084826"></a><a name="p1575166150084826"></a><a href="Graphic.md#ga7bd4d2d4631d9ea373d008ec7a5d18ff">OHOS::UIAbstractClock::GetCurrentSecond</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2034423687084826"><a name="p2034423687084826"></a><a name="p2034423687084826"></a>uint8_t&nbsp;</p>
<p id="p1719463226084826"><a name="p1719463226084826"></a><a name="p1719463226084826"></a>Obtains the current number of seconds. </p>
</td>
</tr>
<tr id="row2137649016084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1085643594084826"><a name="p1085643594084826"></a><a name="p1085643594084826"></a><a href="Graphic.md#gaf4c05e6acf6700d7edb69dc49cd6fef8">OHOS::UIAbstractClock::IncOneSecond</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1152002031084826"><a name="p1152002031084826"></a><a name="p1152002031084826"></a>void&nbsp;</p>
<p id="p1007384540084826"><a name="p1007384540084826"></a><a name="p1007384540084826"></a>Increases the time by one second. </p>
</td>
</tr>
<tr id="row1110375166084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p515304133084826"><a name="p515304133084826"></a><a name="p515304133084826"></a><a href="Graphic.md#gad7c0fba1eac5d10998954e9c1e097197">OHOS::UIAbstractClock::UpdateClock</a> (bool clockInit)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p417788214084826"><a name="p417788214084826"></a><a name="p417788214084826"></a>virtual void&nbsp;</p>
<p id="p1936821462084826"><a name="p1936821462084826"></a><a name="p1936821462084826"></a>Updates this clock. </p>
</td>
</tr>
<tr id="row1727692658084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1000707483084826"><a name="p1000707483084826"></a><a name="p1000707483084826"></a><a href="Graphic.md#gaafa5df66c896268de27bf335c1b72b92">OHOS::UIAbstractClock::SetWorkMode</a> (<a href="Graphic.md#ga19db90932bc71e6bbced6ccf2935ac98">WorkMode</a> newMode)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1555032024084826"><a name="p1555032024084826"></a><a name="p1555032024084826"></a>virtual void&nbsp;</p>
<p id="p1887775626084826"><a name="p1887775626084826"></a><a name="p1887775626084826"></a>Sets the working mode for this clock. </p>
</td>
</tr>
<tr id="row458677592084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p109546771084826"><a name="p109546771084826"></a><a name="p109546771084826"></a><a href="Graphic.md#gad2d78422d212ef1e93bb4a23e1ee3859">OHOS::UIAbstractClock::GetWorkMode</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p414671317084826"><a name="p414671317084826"></a><a name="p414671317084826"></a>virtual <a href="Graphic.md#ga19db90932bc71e6bbced6ccf2935ac98">WorkMode</a>&nbsp;</p>
<p id="p1162785556084826"><a name="p1162785556084826"></a><a name="p1162785556084826"></a>Obtains the working mode of this clock. </p>
</td>
</tr>
<tr id="row654255447084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2047339959084826"><a name="p2047339959084826"></a><a name="p2047339959084826"></a><a href="Graphic.md#ga8f9bfb4f42ee0e094501ff776e3336da">OHOS::UIAbstractProgress::UIAbstractProgress</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p173264138084826"><a name="p173264138084826"></a><a name="p173264138084826"></a>&nbsp;</p>
<p id="p547759545084826"><a name="p547759545084826"></a><a name="p547759545084826"></a>A constructor used to create a <strong id="b679219232084826"><a name="b679219232084826"></a><a name="b679219232084826"></a><a href="OHOS-UIAbstractProgress.md">UIAbstractProgress</a></strong> instance. </p>
</td>
</tr>
<tr id="row1853400740084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p738523818084826"><a name="p738523818084826"></a><a name="p738523818084826"></a><a href="Graphic.md#ga5c1cf7239bf0c0f7d331e63df805b518">OHOS::UIAbstractProgress::~UIAbstractProgress</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1791160022084826"><a name="p1791160022084826"></a><a name="p1791160022084826"></a>virtual&nbsp;</p>
<p id="p554027224084826"><a name="p554027224084826"></a><a name="p554027224084826"></a>A destructor used to delete the <strong id="b1307775163084826"><a name="b1307775163084826"></a><a name="b1307775163084826"></a><a href="OHOS-UIAbstractProgress.md">UIAbstractProgress</a></strong> instance. </p>
</td>
</tr>
<tr id="row1808560060084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p115730219084826"><a name="p115730219084826"></a><a name="p115730219084826"></a><a href="Graphic.md#ga79885b87d1935947f6980ae56f139083">OHOS::UIAbstractProgress::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p240637281084826"><a name="p240637281084826"></a><a name="p240637281084826"></a>UIViewType&nbsp;</p>
<p id="p716871732084826"><a name="p716871732084826"></a><a name="p716871732084826"></a>Obtains the component type. </p>
</td>
</tr>
<tr id="row1813215050084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1599561979084826"><a name="p1599561979084826"></a><a name="p1599561979084826"></a><a href="Graphic.md#gacb680c1ddc9135371676df504dc6c8f2">OHOS::UIAbstractProgress::EnableBackground</a> (bool enable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p137497843084826"><a name="p137497843084826"></a><a name="p137497843084826"></a>void&nbsp;</p>
<p id="p1563293354084826"><a name="p1563293354084826"></a><a name="p1563293354084826"></a>Sets whether the background of the progress bar is visible. </p>
</td>
</tr>
<tr id="row40037629084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1260172088084826"><a name="p1260172088084826"></a><a name="p1260172088084826"></a><a href="Graphic.md#ga5f65014431a6489ffa1d4949f9c4449b">OHOS::UIAbstractProgress::SetValue</a> (int16_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1206377568084826"><a name="p1206377568084826"></a><a name="p1206377568084826"></a>void&nbsp;</p>
<p id="p1468345427084826"><a name="p1468345427084826"></a><a name="p1468345427084826"></a>Sets the current value for this progress bar. </p>
</td>
</tr>
<tr id="row1127313197084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1468104839084826"><a name="p1468104839084826"></a><a name="p1468104839084826"></a><a href="Graphic.md#ga6face76aa7972efeb6cbb8f525f23135">OHOS::UIAbstractProgress::GetValue</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1571875387084826"><a name="p1571875387084826"></a><a name="p1571875387084826"></a>int16_t&nbsp;</p>
<p id="p424789840084826"><a name="p424789840084826"></a><a name="p424789840084826"></a>Obtains the current value of this progress bar. </p>
</td>
</tr>
<tr id="row1321045260084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1164453650084826"><a name="p1164453650084826"></a><a name="p1164453650084826"></a><a href="Graphic.md#ga089e3875453011499ad33ed89a44a699">OHOS::UIAbstractProgress::SetRange</a> (int16_t rangeMax, int16_t rangeMin)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p889682615084826"><a name="p889682615084826"></a><a name="p889682615084826"></a>void&nbsp;</p>
<p id="p570584128084826"><a name="p570584128084826"></a><a name="p570584128084826"></a>Sets the range for this progress bar. </p>
</td>
</tr>
<tr id="row26093552084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1143258839084826"><a name="p1143258839084826"></a><a name="p1143258839084826"></a><a href="Graphic.md#ga68ab733afcf4224a799ccad2092d1d23">OHOS::UIAbstractProgress::GetRangeMin</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p368071536084826"><a name="p368071536084826"></a><a name="p368071536084826"></a>int16_t&nbsp;</p>
<p id="p892286252084826"><a name="p892286252084826"></a><a name="p892286252084826"></a>Obtains the minimum value of this progress bar. </p>
</td>
</tr>
<tr id="row55826616084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p413105369084826"><a name="p413105369084826"></a><a name="p413105369084826"></a><a href="Graphic.md#ga1840199f22d5d3e4ef58e41ac8f4febc">OHOS::UIAbstractProgress::GetRangeMax</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1493899430084826"><a name="p1493899430084826"></a><a name="p1493899430084826"></a>int16_t&nbsp;</p>
<p id="p142548110084826"><a name="p142548110084826"></a><a name="p142548110084826"></a>Obtains the maximum value of this progress bar. </p>
</td>
</tr>
<tr id="row84884991084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2058446888084826"><a name="p2058446888084826"></a><a name="p2058446888084826"></a><a href="Graphic.md#ga5b3ec363e391f601e12bf937b9cf77db">OHOS::UIAbstractProgress::SetImage</a> (const char *foregroundImage, const char *backgroundImage=nullptr)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p816742613084826"><a name="p816742613084826"></a><a name="p816742613084826"></a>void&nbsp;</p>
<p id="p1808105651084826"><a name="p1808105651084826"></a><a name="p1808105651084826"></a>Sets the image for this progress bar. </p>
</td>
</tr>
<tr id="row219753680084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1904732124084826"><a name="p1904732124084826"></a><a name="p1904732124084826"></a><a href="Graphic.md#ga10723293ab9e384907dd9dacbc9ad448">OHOS::UIAbstractProgress::SetImage</a> (const <a href="OHOS-ImageInfo.md">ImageInfo</a> *foregroundImage, const <a href="OHOS-ImageInfo.md">ImageInfo</a> *backgroundImage=nullptr)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2010279783084826"><a name="p2010279783084826"></a><a name="p2010279783084826"></a>void&nbsp;</p>
<p id="p309499576084826"><a name="p309499576084826"></a><a name="p309499576084826"></a>Sets the image as a pixel map for this progress bar. </p>
</td>
</tr>
<tr id="row332706578084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1286332282084826"><a name="p1286332282084826"></a><a name="p1286332282084826"></a><a href="Graphic.md#ga747a29652b441a06d09a97a297aae9bb">OHOS::UIAbstractProgress::SetStep</a> (uint16_t step)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p811238823084826"><a name="p811238823084826"></a><a name="p811238823084826"></a>void&nbsp;</p>
<p id="p1324439682084826"><a name="p1324439682084826"></a><a name="p1324439682084826"></a>Sets the step for this progress bar. </p>
</td>
</tr>
<tr id="row1275564308084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p863714638084826"><a name="p863714638084826"></a><a name="p863714638084826"></a><a href="Graphic.md#ga9c1678604605a54c2e338d283c46866d">OHOS::UIAbstractProgress::GetStep</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p339933964084826"><a name="p339933964084826"></a><a name="p339933964084826"></a>uint16_t&nbsp;</p>
<p id="p1374352290084826"><a name="p1374352290084826"></a><a name="p1374352290084826"></a>Obtains the current step of this progress bar. </p>
</td>
</tr>
<tr id="row1018017830084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p146996519084826"><a name="p146996519084826"></a><a name="p146996519084826"></a><a href="Graphic.md#ga6817b5178e93e5f16f2b420cf5a171c1">OHOS::UIAbstractProgress::SetBackgroundStyle</a> (const <a href="OHOS-Style.md">Style</a> &amp;style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1741413007084826"><a name="p1741413007084826"></a><a name="p1741413007084826"></a>void&nbsp;</p>
<p id="p1780300956084826"><a name="p1780300956084826"></a><a name="p1780300956084826"></a>Sets the background style for this progress bar. </p>
</td>
</tr>
<tr id="row245009984084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p969134564084826"><a name="p969134564084826"></a><a name="p969134564084826"></a><a href="Graphic.md#ga23acea0a42587746e35ec5f3a74af59f">OHOS::UIAbstractProgress::SetBackgroundStyle</a> (uint8_t key, int64_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p626366787084826"><a name="p626366787084826"></a><a name="p626366787084826"></a>void&nbsp;</p>
<p id="p1244937529084826"><a name="p1244937529084826"></a><a name="p1244937529084826"></a>Sets a background style for this progress bar. </p>
</td>
</tr>
<tr id="row1560438883084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1982560534084826"><a name="p1982560534084826"></a><a name="p1982560534084826"></a><a href="Graphic.md#gac2ca1212c23c11405b12ae0a46c7eff1">OHOS::UIAbstractProgress::GetBackgroundStyle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1539750401084826"><a name="p1539750401084826"></a><a name="p1539750401084826"></a>const <a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p697150767084826"><a name="p697150767084826"></a><a name="p697150767084826"></a>Obtains the background style of this progress bar. </p>
</td>
</tr>
<tr id="row1200764340084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2134508686084826"><a name="p2134508686084826"></a><a name="p2134508686084826"></a><a href="Graphic.md#ga946d3f2c39a79d45149118536b2557a9">OHOS::UIAbstractProgress::GetBackgroundStyle</a> (uint8_t key) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1779767866084826"><a name="p1779767866084826"></a><a name="p1779767866084826"></a>int64_t&nbsp;</p>
<p id="p78108729084826"><a name="p78108729084826"></a><a name="p78108729084826"></a>Obtains the value of a background style of this progress bar. </p>
</td>
</tr>
<tr id="row7113432084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p207196460084826"><a name="p207196460084826"></a><a name="p207196460084826"></a><a href="Graphic.md#gaccebcfa35f98f9bc6be4bb8cc53eb11c">OHOS::UIAbstractProgress::SetForegroundStyle</a> (const <a href="OHOS-Style.md">Style</a> &amp;style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1202113564084826"><a name="p1202113564084826"></a><a name="p1202113564084826"></a>void&nbsp;</p>
<p id="p1692971072084826"><a name="p1692971072084826"></a><a name="p1692971072084826"></a>Sets the foreground style for this progress bar. </p>
</td>
</tr>
<tr id="row300425650084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p93751213084826"><a name="p93751213084826"></a><a name="p93751213084826"></a><a href="Graphic.md#gae6386ca25603e42f06087f6b2ef65bae">OHOS::UIAbstractProgress::SetForegroundStyle</a> (uint8_t key, int64_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1894686056084826"><a name="p1894686056084826"></a><a name="p1894686056084826"></a>void&nbsp;</p>
<p id="p1368132143084826"><a name="p1368132143084826"></a><a name="p1368132143084826"></a>Sets a foreground style for this progress bar. </p>
</td>
</tr>
<tr id="row699567439084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1061160301084826"><a name="p1061160301084826"></a><a name="p1061160301084826"></a><a href="Graphic.md#gac77f945f375f333f80bd70254b5c1f96">OHOS::UIAbstractProgress::GetForegroundStyle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1561222849084826"><a name="p1561222849084826"></a><a name="p1561222849084826"></a>const <a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p1136796874084826"><a name="p1136796874084826"></a><a name="p1136796874084826"></a>Obtains the foreground style of this progress bar. </p>
</td>
</tr>
<tr id="row294173517084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1036411558084826"><a name="p1036411558084826"></a><a name="p1036411558084826"></a><a href="Graphic.md#ga74cd121dd1794d7e8d905b233bd98217">OHOS::UIAbstractProgress::GetForegroundStyle</a> (uint8_t key) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p102828444084826"><a name="p102828444084826"></a><a name="p102828444084826"></a>int64_t&nbsp;</p>
<p id="p1414319705084826"><a name="p1414319705084826"></a><a name="p1414319705084826"></a>Obtains the value of a foreground style of this progress bar. </p>
</td>
</tr>
<tr id="row861871795084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p815588881084826"><a name="p815588881084826"></a><a name="p815588881084826"></a><a href="Graphic.md#gabdc0eb4d279212ea7c3ea7a1f9a85e13">OHOS::UIAbstractProgress::SetCapType</a> (<a href="Graphic.md#ga2db3928cdf793f4950245a6841dd43d6">CapType</a> cap)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p981468074084826"><a name="p981468074084826"></a><a name="p981468074084826"></a>void&nbsp;</p>
<p id="p938296800084826"><a name="p938296800084826"></a><a name="p938296800084826"></a>Sets the type of caps on the background and foreground of the progress bar. </p>
</td>
</tr>
<tr id="row646368545084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1543019473084826"><a name="p1543019473084826"></a><a name="p1543019473084826"></a><a href="Graphic.md#ga93a169fba7c98f6534692cba9e8d539b">OHOS::UIAbstractScroll::UIAbstractScroll</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1264031593084826"><a name="p1264031593084826"></a><a name="p1264031593084826"></a>&nbsp;</p>
<p id="p396089635084826"><a name="p396089635084826"></a><a name="p396089635084826"></a>A constructor used to create a <strong id="b914414295084826"><a name="b914414295084826"></a><a name="b914414295084826"></a><a href="OHOS-UIAbstractScroll.md">UIAbstractScroll</a></strong> instance. </p>
</td>
</tr>
<tr id="row532089400084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p173977821084826"><a name="p173977821084826"></a><a name="p173977821084826"></a><a href="Graphic.md#ga414798ec7357edc85409128fba0a813c">OHOS::UIAbstractScroll::~UIAbstractScroll</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1104276172084826"><a name="p1104276172084826"></a><a name="p1104276172084826"></a>virtual&nbsp;</p>
<p id="p571506661084826"><a name="p571506661084826"></a><a name="p571506661084826"></a>A destructor used to delete the <strong id="b1532185947084826"><a name="b1532185947084826"></a><a name="b1532185947084826"></a><a href="OHOS-UIAbstractScroll.md">UIAbstractScroll</a></strong> instance. </p>
</td>
</tr>
<tr id="row1202664139084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p319860751084826"><a name="p319860751084826"></a><a name="p319860751084826"></a><a href="Graphic.md#gaeb9e84901b38ef75fa650fc5a27ffc65">OHOS::UIAbstractScroll::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p503918744084826"><a name="p503918744084826"></a><a name="p503918744084826"></a>UIViewType&nbsp;</p>
<p id="p1381718391084826"><a name="p1381718391084826"></a><a name="p1381718391084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row464377989084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p852047460084826"><a name="p852047460084826"></a><a name="p852047460084826"></a><a href="Graphic.md#ga443783170697bea9a933843ad2a92283">OHOS::UIAbstractScroll::GetDirection</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1524190124084826"><a name="p1524190124084826"></a><a name="p1524190124084826"></a>uint8_t&nbsp;</p>
<p id="p1287129249084826"><a name="p1287129249084826"></a><a name="p1287129249084826"></a>Obtains the scroll direction. </p>
</td>
</tr>
<tr id="row206589642084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1844102736084826"><a name="p1844102736084826"></a><a name="p1844102736084826"></a><a href="Graphic.md#gab37cea97d63ee9ca609c9a1ed0f1e281">OHOS::UIAbstractScroll::SetScrollBlankSize</a> (uint16_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p394636893084826"><a name="p394636893084826"></a><a name="p394636893084826"></a>void&nbsp;</p>
<p id="p1124589888084826"><a name="p1124589888084826"></a><a name="p1124589888084826"></a>Sets the blank size for this scroll view. </p>
</td>
</tr>
<tr id="row154866969084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1940294374084826"><a name="p1940294374084826"></a><a name="p1940294374084826"></a><a href="Graphic.md#gae2d6f5c97a316ecd3b41fecfa35a351f">OHOS::UIAbstractScroll::SetMaxScrollDistance</a> (uint16_t distance)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p258723495084826"><a name="p258723495084826"></a><a name="p258723495084826"></a>void&nbsp;</p>
<p id="p1224732564084826"><a name="p1224732564084826"></a><a name="p1224732564084826"></a>Sets the maximum scroll distance after a finger lifts the screen. </p>
</td>
</tr>
<tr id="row808145840084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2122615752084826"><a name="p2122615752084826"></a><a name="p2122615752084826"></a><a href="Graphic.md#ga5d7fefcd2057e868a8f6c6a6000aa7ef">OHOS::UIAbstractScroll::SetReboundSize</a> (uint16_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p800065513084826"><a name="p800065513084826"></a><a name="p800065513084826"></a>void&nbsp;</p>
<p id="p894078512084826"><a name="p894078512084826"></a><a name="p894078512084826"></a>Sets the rebound size, which is the distance a knob moves after being released when it reaches the end of a scrollbar. </p>
</td>
</tr>
<tr id="row1038185080084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1464657120084826"><a name="p1464657120084826"></a><a name="p1464657120084826"></a><a href="Graphic.md#ga71a2b17d4145479ed2e2ca000eb7e86e">OHOS::UIAbstractScroll::GetMaxScrollDistance</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p856712293084826"><a name="p856712293084826"></a><a name="p856712293084826"></a>uint16_t&nbsp;</p>
<p id="p1199176383084826"><a name="p1199176383084826"></a><a name="p1199176383084826"></a>Obtains the maximum scroll distance after a finger lifts the screen. </p>
</td>
</tr>
<tr id="row34543449084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1004797679084826"><a name="p1004797679084826"></a><a name="p1004797679084826"></a><a href="Graphic.md#ga957ec65a7efad6818be6df5169158aad">OHOS::UIAbstractScroll::SetDragFunc</a> (EasingFunc func)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p747072094084826"><a name="p747072094084826"></a><a name="p747072094084826"></a>void&nbsp;</p>
<p id="p1587482743084826"><a name="p1587482743084826"></a><a name="p1587482743084826"></a>Sets the easing function that specifies a scroll animation after a finger lifts the screen. </p>
</td>
</tr>
<tr id="row199741803084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1844631651084826"><a name="p1844631651084826"></a><a name="p1844631651084826"></a><a href="Graphic.md#ga4dde5f89d70304e77a96d4f4679438c2">OHOS::UIAbstractScroll::SetThrowDrag</a> (bool throwDrag)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p876037455084826"><a name="p876037455084826"></a><a name="p876037455084826"></a>void&nbsp;</p>
<p id="p1301325641084826"><a name="p1301325641084826"></a><a name="p1301325641084826"></a>Sets whether to continue scrolling after a finger lifts the screen. </p>
</td>
</tr>
<tr id="row1127933731084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2130865132084826"><a name="p2130865132084826"></a><a name="p2130865132084826"></a><a href="Graphic.md#ga5013215d3075616ae081849ef52bb57a">OHOS::UIAbstractScroll::MoveChildByOffset</a> (int16_t offsetX, int16_t offsetY) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p806864757084826"><a name="p806864757084826"></a><a name="p806864757084826"></a>void&nbsp;</p>
<p id="p531290225084826"><a name="p531290225084826"></a><a name="p531290225084826"></a>Moves the position of all child views. </p>
</td>
</tr>
<tr id="row1909470496084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1101135846084826"><a name="p1101135846084826"></a><a name="p1101135846084826"></a><a href="Graphic.md#gad344babd5b251ed908cdf628fae55093">OHOS::UIAbstractScroll::SetDragACCLevel</a> (uint16_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p814941613084826"><a name="p814941613084826"></a><a name="p814941613084826"></a>void&nbsp;</p>
<p id="p2017329342084826"><a name="p2017329342084826"></a><a name="p2017329342084826"></a>Sets the drag acceleration. </p>
</td>
</tr>
<tr id="row1303469797084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p279295604084826"><a name="p279295604084826"></a><a name="p279295604084826"></a><a href="Graphic.md#ga29e68195b56783f265d85506f130c664">OHOS::UIAbstractScroll::GetDragACCLevel</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1764016756084826"><a name="p1764016756084826"></a><a name="p1764016756084826"></a>uint8_t&nbsp;</p>
<p id="p543384562084826"><a name="p543384562084826"></a><a name="p543384562084826"></a>Obtains the drag acceleration. </p>
</td>
</tr>
<tr id="row2082704588084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p253414420084826"><a name="p253414420084826"></a><a name="p253414420084826"></a><a href="Graphic.md#gafab9d1a8f5987b50f9111c733ada6341">OHOS::UIAbstractScroll::SetSwipeACCLevel</a> (uint16_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1856161127084826"><a name="p1856161127084826"></a><a name="p1856161127084826"></a>void&nbsp;</p>
<p id="p1309324589084826"><a name="p1309324589084826"></a><a name="p1309324589084826"></a>Sets the compensation distance after a finger lifts the screen. </p>
</td>
</tr>
<tr id="row1908873861084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2145716001084826"><a name="p2145716001084826"></a><a name="p2145716001084826"></a><a href="Graphic.md#ga25dad3242949f0fbeff47d6df06053f6">OHOS::UIAbstractScroll::GetSwipeACCLevel</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p317532612084826"><a name="p317532612084826"></a><a name="p317532612084826"></a>uint8_t&nbsp;</p>
<p id="p1531164186084826"><a name="p1531164186084826"></a><a name="p1531164186084826"></a>Obtains the compensation distance after a finger lifts the screen. </p>
</td>
</tr>
<tr id="row1047781611084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p775334685084826"><a name="p775334685084826"></a><a name="p775334685084826"></a><a href="Graphic.md#ga2e986cb53c62dd015edced59450b9fff">OHOS::UIAnalogClock::UIAnalogClock</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2039914328084826"><a name="p2039914328084826"></a><a name="p2039914328084826"></a>&nbsp;</p>
<p id="p1104010291084826"><a name="p1104010291084826"></a><a name="p1104010291084826"></a>A default constructor used to create a <strong id="b171700213084826"><a name="b171700213084826"></a><a name="b171700213084826"></a><a href="OHOS-UIAnalogClock.md">UIAnalogClock</a></strong> instance. </p>
</td>
</tr>
<tr id="row574571370084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p377658510084826"><a name="p377658510084826"></a><a name="p377658510084826"></a><a href="Graphic.md#ga4b06e05f003e25206d5fa772b303dcc5">OHOS::UIAnalogClock::~UIAnalogClock</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p135734155084826"><a name="p135734155084826"></a><a name="p135734155084826"></a>virtual&nbsp;</p>
<p id="p939458254084826"><a name="p939458254084826"></a><a name="p939458254084826"></a>A destructor used to delete the <strong id="b1983459481084826"><a name="b1983459481084826"></a><a name="b1983459481084826"></a><a href="OHOS-UIAnalogClock.md">UIAnalogClock</a></strong> instance. </p>
</td>
</tr>
<tr id="row1928513707084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1994180098084826"><a name="p1994180098084826"></a><a name="p1994180098084826"></a><a href="Graphic.md#gac075169429f99f60ed660a44db7f4031">OHOS::UIAnalogClock::Hand::Hand</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p785128241084826"><a name="p785128241084826"></a><a name="p785128241084826"></a>&nbsp;</p>
<p id="p1243066265084826"><a name="p1243066265084826"></a><a name="p1243066265084826"></a>A default constructor used to create a <strong id="b1726265832084826"><a name="b1726265832084826"></a><a name="b1726265832084826"></a><a href="OHOS-UIAnalogClock-Hand.md">Hand</a></strong> instance. </p>
</td>
</tr>
<tr id="row1601374235084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1218778702084826"><a name="p1218778702084826"></a><a name="p1218778702084826"></a><a href="Graphic.md#ga1e433482830dd12b9b40430dab92505f">OHOS::UIAnalogClock::Hand::~Hand</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1981372328084826"><a name="p1981372328084826"></a><a name="p1981372328084826"></a>virtual&nbsp;</p>
<p id="p1145165322084826"><a name="p1145165322084826"></a><a name="p1145165322084826"></a>A destructor used to delete the <strong id="b2035089142084826"><a name="b2035089142084826"></a><a name="b2035089142084826"></a><a href="OHOS-UIAnalogClock-Hand.md">Hand</a></strong> instance. </p>
</td>
</tr>
<tr id="row744794641084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1030570861084826"><a name="p1030570861084826"></a><a name="p1030570861084826"></a><a href="Graphic.md#ga2f5123df8cbcc4f55c5192acbe30ba0d">OHOS::UIAnalogClock::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p177365169084826"><a name="p177365169084826"></a><a name="p177365169084826"></a>UIViewType&nbsp;</p>
<p id="p1130316438084826"><a name="p1130316438084826"></a><a name="p1130316438084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row1916733320084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1078703967084826"><a name="p1078703967084826"></a><a name="p1078703967084826"></a><a href="Graphic.md#ga18816e5dae6a7b79cbc408b1bc70c584">OHOS::UIAnalogClock::SetHandImage</a> (<a href="Graphic.md#ga13cf64ea5bd39550976aaf65b1381edf">HandType</a> type, const <a href="OHOS-UIImageView.md">UIImageView</a> &amp;img, <a href="OHOS-Point.md">Point</a> position, <a href="OHOS-Point.md">Point</a> center)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p796400667084826"><a name="p796400667084826"></a><a name="p796400667084826"></a>void&nbsp;</p>
<p id="p261011404084826"><a name="p261011404084826"></a><a name="p261011404084826"></a>Sets the image used to draw a clock hand. </p>
</td>
</tr>
<tr id="row869050403084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1811781151084826"><a name="p1811781151084826"></a><a name="p1811781151084826"></a><a href="Graphic.md#ga271358e8076b55ed48de19350b3e55de">OHOS::UIAnalogClock::SetHandLine</a> (<a href="Graphic.md#ga13cf64ea5bd39550976aaf65b1381edf">HandType</a> type, <a href="OHOS-Point.md">Point</a> position, <a href="OHOS-Point.md">Point</a> center, <a href="OHOS-Color32.md">ColorType</a> color, uint16_t width, uint16_t height, OpacityType opacity)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1927803367084826"><a name="p1927803367084826"></a><a name="p1927803367084826"></a>void&nbsp;</p>
<p id="p731387871084826"><a name="p731387871084826"></a><a name="p731387871084826"></a>Sets the line used to draw a clock hand. </p>
</td>
</tr>
<tr id="row1262806397084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1261872416084826"><a name="p1261872416084826"></a><a name="p1261872416084826"></a><a href="Graphic.md#ga4943396addd8f88fb131aa03319e3d8a">OHOS::UIAnalogClock::GetHandRotateCenter</a> (<a href="Graphic.md#ga13cf64ea5bd39550976aaf65b1381edf">HandType</a> type) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p720056474084826"><a name="p720056474084826"></a><a name="p720056474084826"></a><a href="OHOS-Point.md">Point</a>&nbsp;</p>
<p id="p2046697247084826"><a name="p2046697247084826"></a><a name="p2046697247084826"></a>Obtains the rotation center of a specified clock hand. </p>
</td>
</tr>
<tr id="row1494077699084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1316454853084826"><a name="p1316454853084826"></a><a name="p1316454853084826"></a><a href="Graphic.md#ga56b260401694fce13dc5f744cb8bf471">OHOS::UIAnalogClock::GetHandPosition</a> (<a href="Graphic.md#ga13cf64ea5bd39550976aaf65b1381edf">HandType</a> type) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1263290406084826"><a name="p1263290406084826"></a><a name="p1263290406084826"></a><a href="OHOS-Point.md">Point</a>&nbsp;</p>
<p id="p1503599939084826"><a name="p1503599939084826"></a><a name="p1503599939084826"></a>Obtains the position of a specified clock hand. </p>
</td>
</tr>
<tr id="row2040643042084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1943397740084826"><a name="p1943397740084826"></a><a name="p1943397740084826"></a><a href="Graphic.md#ga3fdfc7872768c5f5cea6627958f53ff8">OHOS::UIAnalogClock::GetHandInitAngle</a> (<a href="Graphic.md#ga13cf64ea5bd39550976aaf65b1381edf">HandType</a> type) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1537650552084826"><a name="p1537650552084826"></a><a name="p1537650552084826"></a>uint16_t&nbsp;</p>
<p id="p1201707456084826"><a name="p1201707456084826"></a><a name="p1201707456084826"></a>Obtains the initial rotation angle of the specified clock hand. </p>
</td>
</tr>
<tr id="row511619687084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p665759417084826"><a name="p665759417084826"></a><a name="p665759417084826"></a><a href="Graphic.md#ga4092ecd3068a58937b750d308e8eca5f">OHOS::UIAnalogClock::GetHandCurrentAngle</a> (<a href="Graphic.md#ga13cf64ea5bd39550976aaf65b1381edf">HandType</a> type) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1063075056084826"><a name="p1063075056084826"></a><a name="p1063075056084826"></a>uint16_t&nbsp;</p>
<p id="p1553646638084826"><a name="p1553646638084826"></a><a name="p1553646638084826"></a>Obtains the current rotation angle of the specified clock hand. </p>
</td>
</tr>
<tr id="row1258183040084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p743397322084826"><a name="p743397322084826"></a><a name="p743397322084826"></a><a href="Graphic.md#ga3099f37f0ff8cd1229c0734098649173">OHOS::UIAnalogClock::SetInitTime24Hour</a> (uint8_t hour, uint8_t minute, uint8_t second)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p842561132084826"><a name="p842561132084826"></a><a name="p842561132084826"></a>void&nbsp;</p>
<p id="p397973219084826"><a name="p397973219084826"></a><a name="p397973219084826"></a>Sets the initial time in the 24-hour format. </p>
</td>
</tr>
<tr id="row1795386827084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p891386218084826"><a name="p891386218084826"></a><a name="p891386218084826"></a><a href="Graphic.md#gaa118c65942244bb0948b626944c0eaf9">OHOS::UIAnalogClock::SetInitTime12Hour</a> (uint8_t hour, uint8_t minute, uint8_t second, bool am)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1404711450084826"><a name="p1404711450084826"></a><a name="p1404711450084826"></a>void&nbsp;</p>
<p id="p1301878688084826"><a name="p1301878688084826"></a><a name="p1301878688084826"></a>Sets the initial time in the 12-hour format. </p>
</td>
</tr>
<tr id="row667870766084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1353235862084826"><a name="p1353235862084826"></a><a name="p1353235862084826"></a><a href="Graphic.md#ga6c943119bd89a863ec5f05722a1fd146">OHOS::UIAnalogClock::OnDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1374914393084826"><a name="p1374914393084826"></a><a name="p1374914393084826"></a>void&nbsp;</p>
<p id="p1902579479084826"><a name="p1902579479084826"></a><a name="p1902579479084826"></a>Draws an analog clock. </p>
</td>
</tr>
<tr id="row1599809211084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1008196311084826"><a name="p1008196311084826"></a><a name="p1008196311084826"></a><a href="Graphic.md#ga1366a4ca45babb67f3103279a2bbc0bf">OHOS::UIAnalogClock::OnPostDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1750900285084826"><a name="p1750900285084826"></a><a name="p1750900285084826"></a>virtual void&nbsp;</p>
<p id="p586798504084826"><a name="p586798504084826"></a><a name="p586798504084826"></a>Performs the operations needed after the drawing. </p>
</td>
</tr>
<tr id="row132107261084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1001501272084826"><a name="p1001501272084826"></a><a name="p1001501272084826"></a><a href="Graphic.md#ga01d3098090d17bdd720df6e861784e13">OHOS::UIAnalogClock::SetPosition</a> (int16_t x, int16_t y) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p121691192084826"><a name="p121691192084826"></a><a name="p121691192084826"></a>void&nbsp;</p>
<p id="p1461120373084826"><a name="p1461120373084826"></a><a name="p1461120373084826"></a>Sets the position for this analog clock. </p>
</td>
</tr>
<tr id="row974766078084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p480712013084826"><a name="p480712013084826"></a><a name="p480712013084826"></a><a href="Graphic.md#gaa7fad079e41c8efd137781350b60687b">OHOS::UIAnalogClock::SetPosition</a> (int16_t x, int16_t y, int16_t width, int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2041080921084826"><a name="p2041080921084826"></a><a name="p2041080921084826"></a>void&nbsp;</p>
<p id="p1390892612084826"><a name="p1390892612084826"></a><a name="p1390892612084826"></a>Sets the position and size for this analog clock. </p>
</td>
</tr>
<tr id="row1051975956084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p818342803084826"><a name="p818342803084826"></a><a name="p818342803084826"></a><a href="Graphic.md#ga1714e171ff1e9248932a9f2c14c82d12">OHOS::UIAnalogClock::SetWorkMode</a> (<a href="Graphic.md#ga19db90932bc71e6bbced6ccf2935ac98">WorkMode</a> newMode) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p379774418084826"><a name="p379774418084826"></a><a name="p379774418084826"></a>void&nbsp;</p>
<p id="p310933782084826"><a name="p310933782084826"></a><a name="p310933782084826"></a>Sets the working mode for this analog clock. </p>
</td>
</tr>
<tr id="row2080048154084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1237046084084826"><a name="p1237046084084826"></a><a name="p1237046084084826"></a><a href="Graphic.md#ga5274a3e5b66e5f80aab899ef4e61edb2">OHOS::UIAnalogClock::UpdateClock</a> (bool clockInit) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1146603718084826"><a name="p1146603718084826"></a><a name="p1146603718084826"></a>void&nbsp;</p>
<p id="p1745731263084826"><a name="p1745731263084826"></a><a name="p1745731263084826"></a>Updates the time of this analog clock. </p>
</td>
</tr>
<tr id="row1116780862084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2076246086084826"><a name="p2076246086084826"></a><a name="p2076246086084826"></a><a href="Graphic.md#gaeb650e68c370ef4d09d0eb0b30e4346e">OHOS::UIArcLabel::UIArcLabel</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p738241294084826"><a name="p738241294084826"></a><a name="p738241294084826"></a>&nbsp;</p>
<p id="p1438586271084826"><a name="p1438586271084826"></a><a name="p1438586271084826"></a>A default constructor used to create a <strong id="b1555720229084826"><a name="b1555720229084826"></a><a name="b1555720229084826"></a><a href="OHOS-UIArcLabel.md">UIArcLabel</a></strong> instance. </p>
</td>
</tr>
<tr id="row1496576703084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p66396901084826"><a name="p66396901084826"></a><a name="p66396901084826"></a><a href="Graphic.md#ga89c52725ea96d25f451c2cd29f9cee22">OHOS::UIArcLabel::~UIArcLabel</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1459584853084826"><a name="p1459584853084826"></a><a name="p1459584853084826"></a>virtual&nbsp;</p>
<p id="p661379822084826"><a name="p661379822084826"></a><a name="p661379822084826"></a>A destructor used to delete the <strong id="b198226581084826"><a name="b198226581084826"></a><a name="b198226581084826"></a><a href="OHOS-UIArcLabel.md">UIArcLabel</a></strong> instance. </p>
</td>
</tr>
<tr id="row311601289084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1127534411084826"><a name="p1127534411084826"></a><a name="p1127534411084826"></a><a href="Graphic.md#ga2ebe9b09e69cd04b00db686dbec8c32c">OHOS::UIArcLabel::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p535815698084826"><a name="p535815698084826"></a><a name="p535815698084826"></a>UIViewType&nbsp;</p>
<p id="p331379734084826"><a name="p331379734084826"></a><a name="p331379734084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row267285148084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1239971473084826"><a name="p1239971473084826"></a><a name="p1239971473084826"></a><a href="Graphic.md#gae2348ef2f06893325ca3366856657199">OHOS::UIArcLabel::GetWidth</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p800138634084826"><a name="p800138634084826"></a><a name="p800138634084826"></a>int16_t&nbsp;</p>
<p id="p1409801266084826"><a name="p1409801266084826"></a><a name="p1409801266084826"></a>Obtains the width of this arc text. </p>
</td>
</tr>
<tr id="row324735115084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2135126149084826"><a name="p2135126149084826"></a><a name="p2135126149084826"></a><a href="Graphic.md#ga37dbe21b6a8206460136b18a2d0e3f65">OHOS::UIArcLabel::GetHeight</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2048544765084826"><a name="p2048544765084826"></a><a name="p2048544765084826"></a>int16_t&nbsp;</p>
<p id="p663744984084826"><a name="p663744984084826"></a><a name="p663744984084826"></a>Obtains the height of this arc text. </p>
</td>
</tr>
<tr id="row909840900084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2085068291084826"><a name="p2085068291084826"></a><a name="p2085068291084826"></a><a href="Graphic.md#ga6085d982d8ec3d570b2eabc7d1a58b67">OHOS::UIArcLabel::SetText</a> (const char *text)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1452605702084826"><a name="p1452605702084826"></a><a name="p1452605702084826"></a>void&nbsp;</p>
<p id="p1719663761084826"><a name="p1719663761084826"></a><a name="p1719663761084826"></a>Sets the text content for this arc label. </p>
</td>
</tr>
<tr id="row1857792006084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p347403936084826"><a name="p347403936084826"></a><a name="p347403936084826"></a><a href="Graphic.md#gaf6541786a44218c7561a9e0f38dea985">OHOS::UIArcLabel::GetText</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1396860463084826"><a name="p1396860463084826"></a><a name="p1396860463084826"></a>const char *&nbsp;</p>
<p id="p229403200084826"><a name="p229403200084826"></a><a name="p229403200084826"></a>Obtains the text of this arc label. </p>
</td>
</tr>
<tr id="row1838046163084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1403639042084826"><a name="p1403639042084826"></a><a name="p1403639042084826"></a><a href="Graphic.md#gad379123d69ceb0dbb49d4055f9abac82">OHOS::UIArcLabel::SetAlign</a> (<a href="Graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a> horizontalAlign)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2063516775084826"><a name="p2063516775084826"></a><a name="p2063516775084826"></a>void&nbsp;</p>
<p id="p1514528443084826"><a name="p1514528443084826"></a><a name="p1514528443084826"></a>Sets the alignment mode for this text. </p>
</td>
</tr>
<tr id="row1066624528084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p205806711084826"><a name="p205806711084826"></a><a name="p205806711084826"></a><a href="Graphic.md#ga81db66fbe12615d85c68971e58201939">OHOS::UIArcLabel::GetHorAlign</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p939152954084826"><a name="p939152954084826"></a><a name="p939152954084826"></a><a href="Graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a>&nbsp;</p>
<p id="p1195706806084826"><a name="p1195706806084826"></a><a name="p1195706806084826"></a>Obtains the horizontal alignment mode. </p>
</td>
</tr>
<tr id="row1372199836084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1111012414084826"><a name="p1111012414084826"></a><a name="p1111012414084826"></a><a href="Graphic.md#ga337ba2ef9996c1b55a99408e63f0153e">OHOS::UIArcLabel::GetDirect</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1977147213084826"><a name="p1977147213084826"></a><a name="p1977147213084826"></a><a href="Graphic.md#ga0c108f97781843f67c101b47b6c00cf0">UITextLanguageDirect</a>&nbsp;</p>
<p id="p1323331631084826"><a name="p1323331631084826"></a><a name="p1323331631084826"></a>Obtains the direction of this text. </p>
</td>
</tr>
<tr id="row2052549564084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1168870424084826"><a name="p1168870424084826"></a><a name="p1168870424084826"></a><a href="Graphic.md#gad77dde925091bf68bb39316208a304ce">OHOS::UIArcLabel::SetFontId</a> (uint8_t fontId)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p390032090084826"><a name="p390032090084826"></a><a name="p390032090084826"></a>void&nbsp;</p>
<p id="p700778583084826"><a name="p700778583084826"></a><a name="p700778583084826"></a>Sets the font ID for this arc label. </p>
</td>
</tr>
<tr id="row1453225831084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p182192370084826"><a name="p182192370084826"></a><a name="p182192370084826"></a><a href="Graphic.md#gadbd5e4fae21ad3fb7dedf16b414c149d">OHOS::UIArcLabel::GetFontId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1163919991084826"><a name="p1163919991084826"></a><a name="p1163919991084826"></a>uint8_t&nbsp;</p>
<p id="p69681662084826"><a name="p69681662084826"></a><a name="p69681662084826"></a>Obtains the font ID composed of font name and size. </p>
</td>
</tr>
<tr id="row2039354366084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p206298306084826"><a name="p206298306084826"></a><a name="p206298306084826"></a><a href="Graphic.md#gaa45fef56dbe7296f3273586cbc29c7ed">OHOS::UIArcLabel::SetFont</a> (const char *name, uint8_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p537260079084826"><a name="p537260079084826"></a><a name="p537260079084826"></a>void&nbsp;</p>
<p id="p635795823084826"><a name="p635795823084826"></a><a name="p635795823084826"></a>Sets the font for this arc label. </p>
</td>
</tr>
<tr id="row500886350084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1857340367084826"><a name="p1857340367084826"></a><a name="p1857340367084826"></a><a href="Graphic.md#ga0679d838c86fbf540574a41ce0cfbdaf">OHOS::UIArcLabel::SetArcTextCenter</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1801318600084826"><a name="p1801318600084826"></a><a name="p1801318600084826"></a>void&nbsp;</p>
<p id="p462186495084826"><a name="p462186495084826"></a><a name="p462186495084826"></a>Sets the center position for this arc text. </p>
</td>
</tr>
<tr id="row1892034970084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p295217466084826"><a name="p295217466084826"></a><a name="p295217466084826"></a><a href="Graphic.md#ga761fd2ed6abed4489c5dff744c03c8e7">OHOS::UIArcLabel::GetArcTextCenter</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p4800660084826"><a name="p4800660084826"></a><a name="p4800660084826"></a><a href="OHOS-Point.md">Point</a>&nbsp;</p>
<p id="p1714469743084826"><a name="p1714469743084826"></a><a name="p1714469743084826"></a>Obtains the center position of this arc text. </p>
</td>
</tr>
<tr id="row1022440184084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1262934053084826"><a name="p1262934053084826"></a><a name="p1262934053084826"></a><a href="Graphic.md#ga304513546d8c396e89719725acf0a086">OHOS::UIArcLabel::SetArcTextRadius</a> (uint16_t radius)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1048862089084826"><a name="p1048862089084826"></a><a name="p1048862089084826"></a>void&nbsp;</p>
<p id="p151788342084826"><a name="p151788342084826"></a><a name="p151788342084826"></a>Sets the radius for this arc text. </p>
</td>
</tr>
<tr id="row11507295084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1694366731084826"><a name="p1694366731084826"></a><a name="p1694366731084826"></a><a href="Graphic.md#ga19ef3f705a2a486b8da7688ccff6f09d">OHOS::UIArcLabel::GetArcTextRadius</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1211921372084826"><a name="p1211921372084826"></a><a name="p1211921372084826"></a>uint16_t&nbsp;</p>
<p id="p11284018084826"><a name="p11284018084826"></a><a name="p11284018084826"></a>Obtains the radius of this arc text. </p>
</td>
</tr>
<tr id="row865587943084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2099194078084826"><a name="p2099194078084826"></a><a name="p2099194078084826"></a><a href="Graphic.md#gaea37f7ce223d76e5b74dc098fc74cbf9">OHOS::UIArcLabel::SetArcTextAngle</a> (int16_t startAngle, int16_t endAngle)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1473929067084826"><a name="p1473929067084826"></a><a name="p1473929067084826"></a>void&nbsp;</p>
<p id="p1305593250084826"><a name="p1305593250084826"></a><a name="p1305593250084826"></a>Sets the start angle and end angle for this arc text. </p>
</td>
</tr>
<tr id="row309690980084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2063173084826"><a name="p2063173084826"></a><a name="p2063173084826"></a><a href="Graphic.md#ga6f60f48c3fe4571d09bfa74cb46837fa">OHOS::UIArcLabel::GetArcTextStartAngle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p487487851084826"><a name="p487487851084826"></a><a name="p487487851084826"></a>int16_t&nbsp;</p>
<p id="p1082483808084826"><a name="p1082483808084826"></a><a name="p1082483808084826"></a>Obtains the start angle of this arc text. </p>
</td>
</tr>
<tr id="row132459981084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1518330116084826"><a name="p1518330116084826"></a><a name="p1518330116084826"></a><a href="Graphic.md#ga3ed7572ec5135e169ae1b6230dcfe7d2">OHOS::UIArcLabel::GetArcTextEndAngle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1920911933084826"><a name="p1920911933084826"></a><a name="p1920911933084826"></a>int16_t&nbsp;</p>
<p id="p178740173084826"><a name="p178740173084826"></a><a name="p178740173084826"></a>Obtains the end angle of this arc text. </p>
</td>
</tr>
<tr id="row1516725457084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p448288906084826"><a name="p448288906084826"></a><a name="p448288906084826"></a><a href="Graphic.md#gad24333f7363f2d73988f479e73b62b92">OHOS::UIArcLabel::SetArcTextOrientation</a> (<a href="Graphic.md#ga0778527bee4a7ddd8d46395585a5cfb9">TextOrientation</a> orientation)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p589492758084826"><a name="p589492758084826"></a><a name="p589492758084826"></a>void&nbsp;</p>
<p id="p1046528408084826"><a name="p1046528408084826"></a><a name="p1046528408084826"></a>Sets the orientation for this arc text. </p>
</td>
</tr>
<tr id="row1551359375084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1509587792084826"><a name="p1509587792084826"></a><a name="p1509587792084826"></a><a href="Graphic.md#ga34fe8930d4ff654327e45c0abaafc037">OHOS::UIArcLabel::GetArcTextOrientation</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p429849090084826"><a name="p429849090084826"></a><a name="p429849090084826"></a><a href="Graphic.md#ga0778527bee4a7ddd8d46395585a5cfb9">TextOrientation</a>&nbsp;</p>
<p id="p1485614692084826"><a name="p1485614692084826"></a><a name="p1485614692084826"></a>Obtains the orientation of this arc text. </p>
</td>
</tr>
<tr id="row334222100084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2016486048084826"><a name="p2016486048084826"></a><a name="p2016486048084826"></a><a href="Graphic.md#ga9f3b69ad5511a4bd8f3aede212f3f374">OHOS::UIArcLabel::OnDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p640766515084826"><a name="p640766515084826"></a><a name="p640766515084826"></a>virtual void&nbsp;</p>
<p id="p351455275084826"><a name="p351455275084826"></a><a name="p351455275084826"></a>Draws an arc text. </p>
</td>
</tr>
<tr id="row1040838830084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p271121449084826"><a name="p271121449084826"></a><a name="p271121449084826"></a><a href="Graphic.md#gad79f1c694abce57af451b8f7b0b17c35">OHOS::UIAxis::UIAxis</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1722159160084826"><a name="p1722159160084826"></a><a name="p1722159160084826"></a>&nbsp;</p>
<p id="p1665646746084826"><a name="p1665646746084826"></a><a name="p1665646746084826"></a>A constructor used to create a <strong id="b1058291739084826"><a name="b1058291739084826"></a><a name="b1058291739084826"></a><a href="OHOS-UIAxis.md">UIAxis</a></strong> instance. </p>
</td>
</tr>
<tr id="row1884291855084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1594480141084826"><a name="p1594480141084826"></a><a name="p1594480141084826"></a><a href="Graphic.md#gaacc9ac178b3b235f1186297021eb98d8">OHOS::UIAxis::~UIAxis</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p193441161084826"><a name="p193441161084826"></a><a name="p193441161084826"></a>virtual&nbsp;</p>
<p id="p1551830095084826"><a name="p1551830095084826"></a><a name="p1551830095084826"></a>A destructor used to delete the <strong id="b645075453084826"><a name="b645075453084826"></a><a name="b645075453084826"></a><a href="OHOS-UIAxis.md">UIAxis</a></strong> instance. </p>
</td>
</tr>
<tr id="row1085468910084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p790096111084826"><a name="p790096111084826"></a><a name="p790096111084826"></a><a href="Graphic.md#ga2f46b702f1543c5076a8957a94a780d3">OHOS::UIAxis::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1402716076084826"><a name="p1402716076084826"></a><a name="p1402716076084826"></a>UIViewType&nbsp;</p>
<p id="p1053111293084826"><a name="p1053111293084826"></a><a name="p1053111293084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row666924061084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p159179228084826"><a name="p159179228084826"></a><a name="p159179228084826"></a><a href="Graphic.md#gabb486419e729add9ff85a24371253bf8">OHOS::UIAxis::SetDataRange</a> (uint16_t min, uint16_t max)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p320787954084826"><a name="p320787954084826"></a><a name="p320787954084826"></a>virtual bool&nbsp;</p>
<p id="p1799651665084826"><a name="p1799651665084826"></a><a name="p1799651665084826"></a>Sets the value range of a coordinate axis. </p>
</td>
</tr>
<tr id="row1389748085084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1826999741084826"><a name="p1826999741084826"></a><a name="p1826999741084826"></a><a href="Graphic.md#gaebe68b636d2147f2e69bd658696dc4ee">OHOS::UIAxis::SetMarkNum</a> (uint16_t count)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p569139043084826"><a name="p569139043084826"></a><a name="p569139043084826"></a>virtual void&nbsp;</p>
<p id="p475695909084826"><a name="p475695909084826"></a><a name="p475695909084826"></a>Sets the number of scales on a coordinate axis. </p>
</td>
</tr>
<tr id="row1364613584084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1286544333084826"><a name="p1286544333084826"></a><a name="p1286544333084826"></a><a href="Graphic.md#ga8ceec5e67fa2c4f161bd9af1f0788bbe">OHOS::UIAxis::SetLineColor</a> (const <a href="OHOS-Color32.md">ColorType</a> &amp;color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p861727686084826"><a name="p861727686084826"></a><a name="p861727686084826"></a>void&nbsp;</p>
<p id="p2146487660084826"><a name="p2146487660084826"></a><a name="p2146487660084826"></a>Sets the line color of the coordinate axis. </p>
</td>
</tr>
<tr id="row1452307522084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p487078611084826"><a name="p487078611084826"></a><a name="p487078611084826"></a><a href="Graphic.md#ga5360803f425055de52af5f7fa1081cfe">OHOS::UIAxis::OnDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1114907868084826"><a name="p1114907868084826"></a><a name="p1114907868084826"></a>void&nbsp;</p>
<p id="p567926246084826"><a name="p567926246084826"></a><a name="p567926246084826"></a>Called when a view is drawn. </p>
</td>
</tr>
<tr id="row1195057782084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1375647099084826"><a name="p1375647099084826"></a><a name="p1375647099084826"></a><a href="Graphic.md#gad1bf4d83270c0a4ba04f3cffbc67bb97">OHOS::UIAxis::OnPreDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1650455710084826"><a name="p1650455710084826"></a><a name="p1650455710084826"></a>bool&nbsp;</p>
<p id="p1731154051084826"><a name="p1731154051084826"></a><a name="p1731154051084826"></a>Called before a view is drawn. This function is used to check whether the parent view of this view needs to be redrawn so as to optimize the drawing process. </p>
</td>
</tr>
<tr id="row1702757085084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1019707856084826"><a name="p1019707856084826"></a><a name="p1019707856084826"></a><a href="Graphic.md#ga8ff3fd2953897245e4f6e3cb6bd71495">OHOS::UIAxis::TranslateToPixel</a> (int16_t &amp;value)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1464663139084826"><a name="p1464663139084826"></a><a name="p1464663139084826"></a>virtual void&nbsp;</p>
<p id="p1336809602084826"><a name="p1336809602084826"></a><a name="p1336809602084826"></a>Translates data into pixel coordinates. </p>
</td>
</tr>
<tr id="row1868138985084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1720339280084826"><a name="p1720339280084826"></a><a name="p1720339280084826"></a><a href="Graphic.md#ga8cc8e2c8249360ccfc89462fff33ca4a">OHOS::UIXAxis::UIXAxis</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2061010518084826"><a name="p2061010518084826"></a><a name="p2061010518084826"></a>&nbsp;</p>
<p id="p502082177084826"><a name="p502082177084826"></a><a name="p502082177084826"></a>A constructor used to create a <strong id="b522908090084826"><a name="b522908090084826"></a><a name="b522908090084826"></a><a href="OHOS-UIXAxis.md">UIXAxis</a></strong> instance. </p>
</td>
</tr>
<tr id="row900025893084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p770990737084826"><a name="p770990737084826"></a><a name="p770990737084826"></a><a href="Graphic.md#gaa4e8939fb25fc20dd93ed030044b019f">OHOS::UIXAxis::~UIXAxis</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1571944250084826"><a name="p1571944250084826"></a><a name="p1571944250084826"></a>virtual&nbsp;</p>
<p id="p111935070084826"><a name="p111935070084826"></a><a name="p111935070084826"></a>A destructor used to delete the <strong id="b1579005477084826"><a name="b1579005477084826"></a><a name="b1579005477084826"></a><a href="OHOS-UIXAxis.md">UIXAxis</a></strong> instance. </p>
</td>
</tr>
<tr id="row644666694084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2104591667084826"><a name="p2104591667084826"></a><a name="p2104591667084826"></a><a href="Graphic.md#ga9407ddab6d7e65fc075ca37b86163e6f">OHOS::UIXAxis::TranslateToPixel</a> (int16_t &amp;value) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2133197277084826"><a name="p2133197277084826"></a><a name="p2133197277084826"></a>void&nbsp;</p>
<p id="p920928571084826"><a name="p920928571084826"></a><a name="p920928571084826"></a>Translates data into the x coordinate of a pixel. </p>
</td>
</tr>
<tr id="row1086935324084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p357868780084826"><a name="p357868780084826"></a><a name="p357868780084826"></a><a href="Graphic.md#ga2181796eef584a71a5db9186399720aa">OHOS::UIXAxis::SetDataRange</a> (uint16_t min, uint16_t max) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p782697048084826"><a name="p782697048084826"></a><a name="p782697048084826"></a>bool&nbsp;</p>
<p id="p1289190083084826"><a name="p1289190083084826"></a><a name="p1289190083084826"></a>Sets the value range of the X axis. </p>
</td>
</tr>
<tr id="row1439456741084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1366633852084826"><a name="p1366633852084826"></a><a name="p1366633852084826"></a><a href="Graphic.md#ga46f4151f1379809749ab2ba364d55170">OHOS::UIXAxis::SetMarkNum</a> (uint16_t count) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1948686874084826"><a name="p1948686874084826"></a><a name="p1948686874084826"></a>void&nbsp;</p>
<p id="p937101625084826"><a name="p937101625084826"></a><a name="p937101625084826"></a>Sets the number of scales on the x-axis. </p>
</td>
</tr>
<tr id="row59772637084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2093352410084826"><a name="p2093352410084826"></a><a name="p2093352410084826"></a><a href="Graphic.md#ga0f9a52b48bcd8170b4a64a891a88fb5c">OHOS::UIYAxis::UIYAxis</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p173900452084826"><a name="p173900452084826"></a><a name="p173900452084826"></a>&nbsp;</p>
<p id="p1156022156084826"><a name="p1156022156084826"></a><a name="p1156022156084826"></a>A constructor used to create a <strong id="b752541831084826"><a name="b752541831084826"></a><a name="b752541831084826"></a><a href="OHOS-UIYAxis.md">UIYAxis</a></strong> instance. </p>
</td>
</tr>
<tr id="row1291077817084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p323556161084826"><a name="p323556161084826"></a><a name="p323556161084826"></a><a href="Graphic.md#ga0dc204e8a15fa66762af58142552557c">OHOS::UIYAxis::~UIYAxis</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p9661779084826"><a name="p9661779084826"></a><a name="p9661779084826"></a>virtual&nbsp;</p>
<p id="p38323580084826"><a name="p38323580084826"></a><a name="p38323580084826"></a>A destructor used to delete the <strong id="b305354436084826"><a name="b305354436084826"></a><a name="b305354436084826"></a><a href="OHOS-UIYAxis.md">UIYAxis</a></strong> instance. </p>
</td>
</tr>
<tr id="row984330758084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1152736729084826"><a name="p1152736729084826"></a><a name="p1152736729084826"></a><a href="Graphic.md#gae70c8c411116746a2ab73a6f9bbd1233">OHOS::UIYAxis::TranslateToPixel</a> (int16_t &amp;value) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1635332284084826"><a name="p1635332284084826"></a><a name="p1635332284084826"></a>void&nbsp;</p>
<p id="p2023529635084826"><a name="p2023529635084826"></a><a name="p2023529635084826"></a>Translates data into the y coordinate of a pixel. </p>
</td>
</tr>
<tr id="row135194755084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p271725002084826"><a name="p271725002084826"></a><a name="p271725002084826"></a><a href="Graphic.md#gae635d27e0a4eba30002e3607c42b914a">OHOS::UIYAxis::SetDataRange</a> (uint16_t min, uint16_t max) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p5938885084826"><a name="p5938885084826"></a><a name="p5938885084826"></a>bool&nbsp;</p>
<p id="p1145158674084826"><a name="p1145158674084826"></a><a name="p1145158674084826"></a>Sets the value range of the y-axis. </p>
</td>
</tr>
<tr id="row1134648744084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p517908531084826"><a name="p517908531084826"></a><a name="p517908531084826"></a><a href="Graphic.md#gaf67c1b25c1d1a3ba694cb47f7e9fda85">OHOS::UIYAxis::SetMarkNum</a> (uint16_t count) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1483845506084826"><a name="p1483845506084826"></a><a name="p1483845506084826"></a>void&nbsp;</p>
<p id="p1136350961084826"><a name="p1136350961084826"></a><a name="p1136350961084826"></a>Sets the number of scales on the Y axis. </p>
</td>
</tr>
<tr id="row2138254040084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p787635883084826"><a name="p787635883084826"></a><a name="p787635883084826"></a><a href="Graphic.md#ga315a532a3e0aa658a64d2f7739483f35">OHOS::UIBoxProgress::UIBoxProgress</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1091157922084826"><a name="p1091157922084826"></a><a name="p1091157922084826"></a>&nbsp;</p>
<p id="p898213035084826"><a name="p898213035084826"></a><a name="p898213035084826"></a>A constructor used to create a <strong id="b427839688084826"><a name="b427839688084826"></a><a name="b427839688084826"></a><a href="OHOS-UIBoxProgress.md">UIBoxProgress</a></strong> instance. </p>
</td>
</tr>
<tr id="row605175015084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2123150837084826"><a name="p2123150837084826"></a><a name="p2123150837084826"></a><a href="Graphic.md#ga7a5eefc7d4ad253a286444e76146af7f">OHOS::UIBoxProgress::~UIBoxProgress</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p707234311084826"><a name="p707234311084826"></a><a name="p707234311084826"></a>virtual&nbsp;</p>
<p id="p18376691084826"><a name="p18376691084826"></a><a name="p18376691084826"></a>A destructor used to delete the <strong id="b884858484084826"><a name="b884858484084826"></a><a name="b884858484084826"></a><a href="OHOS-UIBoxProgress.md">UIBoxProgress</a></strong> instance. </p>
</td>
</tr>
<tr id="row1381843797084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1042026730084826"><a name="p1042026730084826"></a><a name="p1042026730084826"></a><a href="Graphic.md#gaa2d380d48776748583f51297715af0b5">OHOS::UIBoxProgress::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1942289745084826"><a name="p1942289745084826"></a><a name="p1942289745084826"></a>UIViewType&nbsp;</p>
<p id="p1980590528084826"><a name="p1980590528084826"></a><a name="p1980590528084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row1269583563084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1805923419084826"><a name="p1805923419084826"></a><a name="p1805923419084826"></a><a href="Graphic.md#ga4b3eeb9de2443182480a71cadb23178c">OHOS::UIBoxProgress::SetWidth</a> (int16_t width) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p784727177084826"><a name="p784727177084826"></a><a name="p784727177084826"></a>void&nbsp;</p>
<p id="p1613070292084826"><a name="p1613070292084826"></a><a name="p1613070292084826"></a>Sets the width for the view holding this progress bar. </p>
</td>
</tr>
<tr id="row439786962084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p695460763084826"><a name="p695460763084826"></a><a name="p695460763084826"></a><a href="Graphic.md#ga54299cb7561cee9a03d0fc9d0ddda784">OHOS::UIBoxProgress::SetHeight</a> (int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1996854314084826"><a name="p1996854314084826"></a><a name="p1996854314084826"></a>void&nbsp;</p>
<p id="p262385805084826"><a name="p262385805084826"></a><a name="p262385805084826"></a>Sets the height for this view. </p>
</td>
</tr>
<tr id="row1477521228084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1300846824084826"><a name="p1300846824084826"></a><a name="p1300846824084826"></a><a href="Graphic.md#ga3e2e7d0c37b4945a3f4f456c20cb0177">OHOS::UIBoxProgress::SetDirection</a> (const <a href="Graphic.md#ga4a7a2c192206c8b18379f42a5fd176eb">Direction</a> &amp;direction)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1694214636084826"><a name="p1694214636084826"></a><a name="p1694214636084826"></a>void&nbsp;</p>
<p id="p1933194574084826"><a name="p1933194574084826"></a><a name="p1933194574084826"></a>Sets the direction for this progress bar. </p>
</td>
</tr>
<tr id="row1976046616084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p500892983084826"><a name="p500892983084826"></a><a name="p500892983084826"></a><a href="Graphic.md#ga493699e8d0e934d7fb3d5502529a1c5e">OHOS::UIBoxProgress::GetDirection</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1629839955084826"><a name="p1629839955084826"></a><a name="p1629839955084826"></a><a href="Graphic.md#ga4a7a2c192206c8b18379f42a5fd176eb">Direction</a>&nbsp;</p>
<p id="p383661739084826"><a name="p383661739084826"></a><a name="p383661739084826"></a>Obtains the direction of this progress bar. </p>
</td>
</tr>
<tr id="row834995420084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p363720371084826"><a name="p363720371084826"></a><a name="p363720371084826"></a><a href="Graphic.md#gada3cf1819e826ee0aed4a40ef00b91a6">OHOS::UIBoxProgress::SetValidWidth</a> (int16_t width)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p963357717084826"><a name="p963357717084826"></a><a name="p963357717084826"></a>void&nbsp;</p>
<p id="p1811561578084826"><a name="p1811561578084826"></a><a name="p1811561578084826"></a>Sets the actual width for this progress bar. </p>
</td>
</tr>
<tr id="row494109406084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p635882945084826"><a name="p635882945084826"></a><a name="p635882945084826"></a><a href="Graphic.md#ga6577d38d85234e08f709dd0ae131b255">OHOS::UIBoxProgress::GetValidWidth</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p569076899084826"><a name="p569076899084826"></a><a name="p569076899084826"></a>int16_t&nbsp;</p>
<p id="p1707552724084826"><a name="p1707552724084826"></a><a name="p1707552724084826"></a>Obtains the actual width of this progress bar. </p>
</td>
</tr>
<tr id="row170168729084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1694772519084826"><a name="p1694772519084826"></a><a name="p1694772519084826"></a><a href="Graphic.md#ga6958b8273ad7a5563dfa19267cc3a13c">OHOS::UIBoxProgress::SetValidHeight</a> (int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p932434629084826"><a name="p932434629084826"></a><a name="p932434629084826"></a>void&nbsp;</p>
<p id="p381869592084826"><a name="p381869592084826"></a><a name="p381869592084826"></a>Sets the actual height for this progress bar. </p>
</td>
</tr>
<tr id="row1918216747084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p497608175084826"><a name="p497608175084826"></a><a name="p497608175084826"></a><a href="Graphic.md#ga1e6c92b20c4931a058c0b7775bf180c9">OHOS::UIBoxProgress::GetValidHeight</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1372026009084826"><a name="p1372026009084826"></a><a name="p1372026009084826"></a>int16_t&nbsp;</p>
<p id="p72614006084826"><a name="p72614006084826"></a><a name="p72614006084826"></a>Obtains the actual height of this progress bar. </p>
</td>
</tr>
<tr id="row444243569084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1159832902084826"><a name="p1159832902084826"></a><a name="p1159832902084826"></a><a href="Graphic.md#ga3321d9b9b156423bdc0abcb8e99efb0d">OHOS::UIBoxProgress::OnDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p329368136084826"><a name="p329368136084826"></a><a name="p329368136084826"></a>void&nbsp;</p>
<p id="p314018812084826"><a name="p314018812084826"></a><a name="p314018812084826"></a>Called when a view is drawn. </p>
</td>
</tr>
<tr id="row91807549084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p970323950084826"><a name="p970323950084826"></a><a name="p970323950084826"></a><a href="Graphic.md#ga3aee093d4c583223850a7ad80d5bed79">OHOS::UIButton::UIButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1140629085084826"><a name="p1140629085084826"></a><a name="p1140629085084826"></a>&nbsp;</p>
<p id="p387681584084826"><a name="p387681584084826"></a><a name="p387681584084826"></a>A constructor used to create a <strong id="b1341321441084826"><a name="b1341321441084826"></a><a name="b1341321441084826"></a><a href="OHOS-UIButton.md">UIButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row1469977038084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1462662580084826"><a name="p1462662580084826"></a><a name="p1462662580084826"></a><a href="Graphic.md#ga33e30931e9b3557634b2b2be93bc41f6">OHOS::UIButton::UIButton</a> (const char *id)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1717781739084826"><a name="p1717781739084826"></a><a name="p1717781739084826"></a>&nbsp;</p>
<p id="p1466070894084826"><a name="p1466070894084826"></a><a name="p1466070894084826"></a>A constructor used to create a <strong id="b1636909134084826"><a name="b1636909134084826"></a><a name="b1636909134084826"></a><a href="OHOS-UIButton.md">UIButton</a></strong> instance based on the button ID. </p>
</td>
</tr>
<tr id="row1576152745084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2006045362084826"><a name="p2006045362084826"></a><a name="p2006045362084826"></a><a href="Graphic.md#ga0c5fbcf319fc6df8170d407a337b9d8b">OHOS::UIButton::~UIButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2032932474084826"><a name="p2032932474084826"></a><a name="p2032932474084826"></a>virtual&nbsp;</p>
<p id="p1449036997084826"><a name="p1449036997084826"></a><a name="p1449036997084826"></a>A destructor used to delete the <strong id="b2092578637084826"><a name="b2092578637084826"></a><a name="b2092578637084826"></a><a href="OHOS-UIButton.md">UIButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row1246660208084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1015179765084826"><a name="p1015179765084826"></a><a name="p1015179765084826"></a><a href="Graphic.md#gad19f55fb0de64f3f39485292d0629dc7">OHOS::UIButton::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1355312720084826"><a name="p1355312720084826"></a><a name="p1355312720084826"></a>UIViewType&nbsp;</p>
<p id="p1648451455084826"><a name="p1648451455084826"></a><a name="p1648451455084826"></a>Obtains the component type. </p>
</td>
</tr>
<tr id="row952933706084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2033330271084826"><a name="p2033330271084826"></a><a name="p2033330271084826"></a><a href="Graphic.md#gaf64d9ec1744ab9c7385dd64d30a786e4">OHOS::UIButton::OnPreDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1948337880084826"><a name="p1948337880084826"></a><a name="p1948337880084826"></a>bool&nbsp;</p>
<p id="p283345254084826"><a name="p283345254084826"></a><a name="p283345254084826"></a>Do something before draw, this function will be invoked mainly to check if this view need to cover invalidate area so render manager can decide which layer to draw firstly. </p>
</td>
</tr>
<tr id="row476666689084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1729213706084826"><a name="p1729213706084826"></a><a name="p1729213706084826"></a><a href="Graphic.md#gae69843b87be9fcdab3e4ac776547f3bc">OHOS::UIButton::OnDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1127775297084826"><a name="p1127775297084826"></a><a name="p1127775297084826"></a>void&nbsp;</p>
<p id="p307103581084826"><a name="p307103581084826"></a><a name="p307103581084826"></a>Executes the draw action. </p>
</td>
</tr>
<tr id="row1712128263084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1698029192084826"><a name="p1698029192084826"></a><a name="p1698029192084826"></a><a href="Graphic.md#ga1d887720c89170abd3c8a400a791765d">OHOS::UIButton::OnPressEvent</a> (const <a href="OHOS-PressEvent.md">PressEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2047197184084826"><a name="p2047197184084826"></a><a name="p2047197184084826"></a>void&nbsp;</p>
<p id="p1612276007084826"><a name="p1612276007084826"></a><a name="p1612276007084826"></a>Executes the press event action. </p>
</td>
</tr>
<tr id="row1906923562084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1510429003084826"><a name="p1510429003084826"></a><a name="p1510429003084826"></a><a href="Graphic.md#gadb9492eb82ff23f91f9263fc748f24de">OHOS::UIButton::OnReleaseEvent</a> (const <a href="OHOS-ReleaseEvent.md">ReleaseEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p529304791084826"><a name="p529304791084826"></a><a name="p529304791084826"></a>void&nbsp;</p>
<p id="p967642563084826"><a name="p967642563084826"></a><a name="p967642563084826"></a>Executes the press release event action. </p>
</td>
</tr>
<tr id="row427297126084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2039728143084826"><a name="p2039728143084826"></a><a name="p2039728143084826"></a><a href="Graphic.md#ga4f481e0ce91f87c6b70f6e0190e4f34f">OHOS::UIButton::OnCancelEvent</a> (const <a href="OHOS-CancelEvent.md">CancelEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p391003752084826"><a name="p391003752084826"></a><a name="p391003752084826"></a>void&nbsp;</p>
<p id="p1339783265084826"><a name="p1339783265084826"></a><a name="p1339783265084826"></a>Executes the cancel event action. </p>
</td>
</tr>
<tr id="row66978449084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p512402999084826"><a name="p512402999084826"></a><a name="p512402999084826"></a><a href="Graphic.md#ga60194db1c1bba6a0ef963bdbbe9f972f">OHOS::UIButton::SetImageSrc</a> (const char *defaultImgSrc, const char *triggeredImgSrc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1836099850084826"><a name="p1836099850084826"></a><a name="p1836099850084826"></a>void&nbsp;</p>
<p id="p1572278299084826"><a name="p1572278299084826"></a><a name="p1572278299084826"></a>Sets the image for this button. </p>
</td>
</tr>
<tr id="row1326229825084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1263957116084826"><a name="p1263957116084826"></a><a name="p1263957116084826"></a><a href="Graphic.md#gab751bc5941edb403022d65d2c605a241">OHOS::UIButton::SetImageSrc</a> (const <a href="OHOS-ImageInfo.md">ImageInfo</a> *defaultImgSrc, const <a href="OHOS-ImageInfo.md">ImageInfo</a> *triggeredImgSrc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1817802989084826"><a name="p1817802989084826"></a><a name="p1817802989084826"></a>void&nbsp;</p>
<p id="p1698006146084826"><a name="p1698006146084826"></a><a name="p1698006146084826"></a>Sets the image for this button. </p>
</td>
</tr>
<tr id="row1241023187084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p209147624084826"><a name="p209147624084826"></a><a name="p209147624084826"></a><a href="Graphic.md#ga952fcbc88905cf35ec3e09bdf01375f2">OHOS::UIButton::SetImagePosition</a> (const int16_t x, const int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2039072173084826"><a name="p2039072173084826"></a><a name="p2039072173084826"></a>void&nbsp;</p>
<p id="p903497766084826"><a name="p903497766084826"></a><a name="p903497766084826"></a>Sets the position for this image. </p>
</td>
</tr>
<tr id="row1329069539084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p433070314084826"><a name="p433070314084826"></a><a name="p433070314084826"></a><a href="Graphic.md#ga4d8abf189ddcbf325c60402084d7e3c3">OHOS::UIButton::GetImageX</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1342801694084826"><a name="p1342801694084826"></a><a name="p1342801694084826"></a>int16_t&nbsp;</p>
<p id="p1947584610084826"><a name="p1947584610084826"></a><a name="p1947584610084826"></a>Obtains the x-coordinate of this image. </p>
</td>
</tr>
<tr id="row2120649984084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1022759634084826"><a name="p1022759634084826"></a><a name="p1022759634084826"></a><a href="Graphic.md#ga25a02afb52cc15212084fb6bc8f27afd">OHOS::UIButton::GetImageY</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p824531951084826"><a name="p824531951084826"></a><a name="p824531951084826"></a>int16_t&nbsp;</p>
<p id="p1833352968084826"><a name="p1833352968084826"></a><a name="p1833352968084826"></a>Obtains the y-coordinate of this image. </p>
</td>
</tr>
<tr id="row1793556931084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1882370744084826"><a name="p1882370744084826"></a><a name="p1882370744084826"></a><a href="Graphic.md#gaf6496e4858473ab2acb80a2be6264a01">OHOS::UIButton::GetCurImageSrc</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p230397993084826"><a name="p230397993084826"></a><a name="p230397993084826"></a>const <a href="OHOS-Image.md">Image</a> *&nbsp;</p>
<p id="p751812579084826"><a name="p751812579084826"></a><a name="p751812579084826"></a>Obtains the image for the current button state. </p>
</td>
</tr>
<tr id="row1046682797084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p284210530084826"><a name="p284210530084826"></a><a name="p284210530084826"></a><a href="Graphic.md#ga8cb74b23f740091e59ad350a8dea436b">OHOS::UIButton::GetWidth</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1530442937084826"><a name="p1530442937084826"></a><a name="p1530442937084826"></a>int16_t&nbsp;</p>
<p id="p1494713941084826"><a name="p1494713941084826"></a><a name="p1494713941084826"></a>Obtains the width of this image. </p>
</td>
</tr>
<tr id="row2026078472084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1296417204084826"><a name="p1296417204084826"></a><a name="p1296417204084826"></a><a href="Graphic.md#ga1f8015706cfc73728696bf2bbd3e833b">OHOS::UIButton::GetHeight</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p11724112084826"><a name="p11724112084826"></a><a name="p11724112084826"></a>int16_t&nbsp;</p>
<p id="p1820854320084826"><a name="p1820854320084826"></a><a name="p1820854320084826"></a>Obtains the height of this image. </p>
</td>
</tr>
<tr id="row405718512084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p658657573084826"><a name="p658657573084826"></a><a name="p658657573084826"></a><a href="Graphic.md#ga420f927c473cec8c6f3265ff7c35336f">OHOS::UIButton::SetWidth</a> (int16_t width) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p204062303084826"><a name="p204062303084826"></a><a name="p204062303084826"></a>void&nbsp;</p>
<p id="p1687704977084826"><a name="p1687704977084826"></a><a name="p1687704977084826"></a>Sets the width for this image. </p>
</td>
</tr>
<tr id="row1553180385084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1780310975084826"><a name="p1780310975084826"></a><a name="p1780310975084826"></a><a href="Graphic.md#ga8b6dbfcd0328753c2c3cef4d14b0ff30">OHOS::UIButton::SetHeight</a> (int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1724287739084826"><a name="p1724287739084826"></a><a name="p1724287739084826"></a>void&nbsp;</p>
<p id="p1916147258084826"><a name="p1916147258084826"></a><a name="p1916147258084826"></a>Sets the height for this image. </p>
</td>
</tr>
<tr id="row2021331587084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p208736116084826"><a name="p208736116084826"></a><a name="p208736116084826"></a><a href="Graphic.md#ga93994f4d735e4f9a7d3e7d737e2c620c">OHOS::UIButton::GetContentRect</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2042358482084826"><a name="p2042358482084826"></a><a name="p2042358482084826"></a>virtual <a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p482757716084826"><a name="p482757716084826"></a><a name="p482757716084826"></a>Obtains a rectangular area that contains coordinate information. </p>
</td>
</tr>
<tr id="row1190327709084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p831158772084826"><a name="p831158772084826"></a><a name="p831158772084826"></a><a href="Graphic.md#ga37736a82bec6a01bc5a880e1d01ccccd">OHOS::UIButton::GetStyle</a> (uint8_t key) const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1562975993084826"><a name="p1562975993084826"></a><a name="p1562975993084826"></a>int64_t&nbsp;</p>
<p id="p420019661084826"><a name="p420019661084826"></a><a name="p420019661084826"></a>Obtains the value of a style. </p>
</td>
</tr>
<tr id="row1228521068084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p446170862084826"><a name="p446170862084826"></a><a name="p446170862084826"></a><a href="Graphic.md#gaa5fdd9b28b8c919dbde0e34d8ae38caf">OHOS::UIButton::SetStyle</a> (uint8_t key, int64_t value) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1936290390084826"><a name="p1936290390084826"></a><a name="p1936290390084826"></a>void&nbsp;</p>
<p id="p1101316628084826"><a name="p1101316628084826"></a><a name="p1101316628084826"></a>Sets a style. </p>
</td>
</tr>
<tr id="row1915374406084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p161656746084826"><a name="p161656746084826"></a><a name="p161656746084826"></a><a href="Graphic.md#gaa3f74af93c91a24e58fdd06ad7d0bdf9">OHOS::UIButton::GetStyleForState</a> (uint8_t key, <a href="Graphic.md#ga188dd55c17ee44be27fa80543f13f729">ButtonState</a> state) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1947834869084826"><a name="p1947834869084826"></a><a name="p1947834869084826"></a>int64_t&nbsp;</p>
<p id="p294691631084826"><a name="p294691631084826"></a><a name="p294691631084826"></a>Obtains the style of a button in a specific state. </p>
</td>
</tr>
<tr id="row1640468476084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1568906797084826"><a name="p1568906797084826"></a><a name="p1568906797084826"></a><a href="Graphic.md#ga7ece04980fa99a277bfbb591771f47f1">OHOS::UIButton::SetStyleForState</a> (uint8_t key, int64_t value, <a href="Graphic.md#ga188dd55c17ee44be27fa80543f13f729">ButtonState</a> state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1115199737084826"><a name="p1115199737084826"></a><a name="p1115199737084826"></a>void&nbsp;</p>
<p id="p1165051685084826"><a name="p1165051685084826"></a><a name="p1165051685084826"></a>Sets the style for a button in a specific state. </p>
</td>
</tr>
<tr id="row1441999272084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p669680293084826"><a name="p669680293084826"></a><a name="p669680293084826"></a><a href="Graphic.md#ga283131701e907e586964189818d04411">OHOS::UIButton::Disable</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p257633320084826"><a name="p257633320084826"></a><a name="p257633320084826"></a>void&nbsp;</p>
<p id="p1920011636084826"><a name="p1920011636084826"></a><a name="p1920011636084826"></a>Disables this button. </p>
</td>
</tr>
<tr id="row85065163084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p663438099084826"><a name="p663438099084826"></a><a name="p663438099084826"></a><a href="Graphic.md#ga3185df8b60a609564f978ed9576fb813">OHOS::UIButton::Enable</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1225635193084826"><a name="p1225635193084826"></a><a name="p1225635193084826"></a>void&nbsp;</p>
<p id="p1504016481084826"><a name="p1504016481084826"></a><a name="p1504016481084826"></a>Enables this button. </p>
</td>
</tr>
<tr id="row1734693576084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1432804307084826"><a name="p1432804307084826"></a><a name="p1432804307084826"></a><a href="Graphic.md#ga737d850b2adf8a2977369e611764b1ae">OHOS::UIButton::SetStateForStyle</a> (<a href="Graphic.md#ga188dd55c17ee44be27fa80543f13f729">ButtonState</a> state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p860947632084826"><a name="p860947632084826"></a><a name="p860947632084826"></a>void&nbsp;</p>
<p id="p190294319084826"><a name="p190294319084826"></a><a name="p190294319084826"></a>Sets the state for a button. After the setting, calling <a href="Graphic.md#gaa5fdd9b28b8c919dbde0e34d8ae38caf">SetStyle</a> will change the style of this button, but not its state. </p>
</td>
</tr>
<tr id="row510634540084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p275702410084826"><a name="p275702410084826"></a><a name="p275702410084826"></a><a href="Graphic.md#ga68ecc0cb6bc379284fd1fbaebb8dcfcd">OHOS::Paint::Paint</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1124692337084826"><a name="p1124692337084826"></a><a name="p1124692337084826"></a>&nbsp;</p>
<p id="p729192147084826"><a name="p729192147084826"></a><a name="p729192147084826"></a>A constructor used to create a <strong id="b2102476666084826"><a name="b2102476666084826"></a><a name="b2102476666084826"></a><a href="OHOS-Paint.md">Paint</a></strong> instance. </p>
</td>
</tr>
<tr id="row202382873084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1829797575084826"><a name="p1829797575084826"></a><a name="p1829797575084826"></a><a href="Graphic.md#ga53f5ef8053f9e468a2fcf6c81449d16d">OHOS::Paint::~Paint</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p511602259084826"><a name="p511602259084826"></a><a name="p511602259084826"></a>virtual&nbsp;</p>
<p id="p1472757156084826"><a name="p1472757156084826"></a><a name="p1472757156084826"></a>A destructor used to delete the <strong id="b1438953558084826"><a name="b1438953558084826"></a><a name="b1438953558084826"></a><a href="OHOS-Paint.md">Paint</a></strong> instance. </p>
</td>
</tr>
<tr id="row559376100084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1055520722084826"><a name="p1055520722084826"></a><a name="p1055520722084826"></a><a href="Graphic.md#gab93dc15f466a656150e62d7620d34333">OHOS::Paint::SetStyle</a> (<a href="Graphic.md#ga548320a469b7862fa416af062cad5d7a">PaintStyle</a> style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p807899096084826"><a name="p807899096084826"></a><a name="p807899096084826"></a>void&nbsp;</p>
<p id="p1284116575084826"><a name="p1284116575084826"></a><a name="p1284116575084826"></a>Sets the paint style of a closed graph. </p>
</td>
</tr>
<tr id="row1291717312084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1037484056084826"><a name="p1037484056084826"></a><a name="p1037484056084826"></a><a href="Graphic.md#ga18429dcf1a0dfbe0bf3e5718efa65128">OHOS::Paint::GetStyle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1037543626084826"><a name="p1037543626084826"></a><a name="p1037543626084826"></a><a href="Graphic.md#ga548320a469b7862fa416af062cad5d7a">PaintStyle</a>&nbsp;</p>
<p id="p1591112030084826"><a name="p1591112030084826"></a><a name="p1591112030084826"></a>Obtains the paint style of a closed graph. </p>
</td>
</tr>
<tr id="row396748835084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p472404140084826"><a name="p472404140084826"></a><a name="p472404140084826"></a><a href="Graphic.md#gad56b6b014e1d061ba93ba8e6c135b90a">OHOS::Paint::SetStrokeWidth</a> (uint16_t width)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p614187494084826"><a name="p614187494084826"></a><a name="p614187494084826"></a>void&nbsp;</p>
<p id="p1842896996084826"><a name="p1842896996084826"></a><a name="p1842896996084826"></a>Sets the width of a line or border. </p>
</td>
</tr>
<tr id="row904589220084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p19528746084826"><a name="p19528746084826"></a><a name="p19528746084826"></a><a href="Graphic.md#gaf8420a460f4a21c9208674e07893c3f0">OHOS::Paint::GetStrokeWidth</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p53941789084826"><a name="p53941789084826"></a><a name="p53941789084826"></a>uint16_t&nbsp;</p>
<p id="p1933925574084826"><a name="p1933925574084826"></a><a name="p1933925574084826"></a>Obtains the width of a line or border. </p>
</td>
</tr>
<tr id="row77308487084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2042431974084826"><a name="p2042431974084826"></a><a name="p2042431974084826"></a><a href="Graphic.md#gaff7464c7456b1e7caf9464ff61ab2527">OHOS::Paint::SetStrokeColor</a> (<a href="OHOS-Color32.md">ColorType</a> color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2019754825084826"><a name="p2019754825084826"></a><a name="p2019754825084826"></a>void&nbsp;</p>
<p id="p1474125432084826"><a name="p1474125432084826"></a><a name="p1474125432084826"></a>Sets the color of a line or border. </p>
</td>
</tr>
<tr id="row2104417697084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1010373431084826"><a name="p1010373431084826"></a><a name="p1010373431084826"></a><a href="Graphic.md#gaf9dba05cf9c9f91853a523d961e76fb1">OHOS::Paint::GetStrokeColor</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1341820331084826"><a name="p1341820331084826"></a><a name="p1341820331084826"></a><a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p860664440084826"><a name="p860664440084826"></a><a name="p860664440084826"></a>Obtains the color of a line or border. </p>
</td>
</tr>
<tr id="row845356223084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1261263190084826"><a name="p1261263190084826"></a><a name="p1261263190084826"></a><a href="Graphic.md#gab1b0e3a5e21ce2ec8454311ed31956ae">OHOS::Paint::SetFillColor</a> (<a href="OHOS-Color32.md">ColorType</a> color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p416209499084826"><a name="p416209499084826"></a><a name="p416209499084826"></a>void&nbsp;</p>
<p id="p1954838747084826"><a name="p1954838747084826"></a><a name="p1954838747084826"></a>Sets fill color. </p>
</td>
</tr>
<tr id="row2083043510084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p626478471084826"><a name="p626478471084826"></a><a name="p626478471084826"></a><a href="Graphic.md#gadc1b88c39670f103e0c84a089e2178cf">OHOS::Paint::GetFillColor</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p953378429084826"><a name="p953378429084826"></a><a name="p953378429084826"></a><a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p589525740084826"><a name="p589525740084826"></a><a name="p589525740084826"></a>Obtains the fill color. </p>
</td>
</tr>
<tr id="row923726138084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p260199363084826"><a name="p260199363084826"></a><a name="p260199363084826"></a><a href="Graphic.md#gacd329fb89bbf6f0e3fd4f9a61f4ce60f">OHOS::Paint::SetOpacity</a> (uint8_t opacity)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1398020201084826"><a name="p1398020201084826"></a><a name="p1398020201084826"></a>void&nbsp;</p>
<p id="p335421228084826"><a name="p335421228084826"></a><a name="p335421228084826"></a>Sets the opacity. </p>
</td>
</tr>
<tr id="row1611356753084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p259775707084826"><a name="p259775707084826"></a><a name="p259775707084826"></a><a href="Graphic.md#ga3a47fccd734ec0e79af89bedacdd4357">OHOS::Paint::GetOpacity</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1644095134084826"><a name="p1644095134084826"></a><a name="p1644095134084826"></a>uint8_t&nbsp;</p>
<p id="p1165319960084826"><a name="p1165319960084826"></a><a name="p1165319960084826"></a>Obtains the opacity. </p>
</td>
</tr>
<tr id="row456612748084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1954885967084826"><a name="p1954885967084826"></a><a name="p1954885967084826"></a><a href="Graphic.md#ga60d2ed5d49ef68ae8d6f2a8b58322ed3">OHOS::UICanvas::UICanvas</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p257251577084826"><a name="p257251577084826"></a><a name="p257251577084826"></a>&nbsp;</p>
<p id="p707108660084826"><a name="p707108660084826"></a><a name="p707108660084826"></a>A constructor used to create a <strong id="b1727263710084826"><a name="b1727263710084826"></a><a name="b1727263710084826"></a><a href="OHOS-UICanvas.md">UICanvas</a></strong> instance. </p>
</td>
</tr>
<tr id="row263392970084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1580490863084826"><a name="p1580490863084826"></a><a name="p1580490863084826"></a><a href="Graphic.md#gaf099d1872cdb070f038c5135309b9b6b">OHOS::UICanvas::~UICanvas</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1508022191084826"><a name="p1508022191084826"></a><a name="p1508022191084826"></a>virtual&nbsp;</p>
<p id="p1343291685084826"><a name="p1343291685084826"></a><a name="p1343291685084826"></a>A destructor used to delete the <strong id="b1855955684084826"><a name="b1855955684084826"></a><a name="b1855955684084826"></a><a href="OHOS-UICanvas.md">UICanvas</a></strong> instance. </p>
</td>
</tr>
<tr id="row1786228268084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p864852257084826"><a name="p864852257084826"></a><a name="p864852257084826"></a><a href="Graphic.md#ga467faebb78b4c4a753eaa44b772f0905">OHOS::UICanvas::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1897685380084826"><a name="p1897685380084826"></a><a name="p1897685380084826"></a>UIViewType&nbsp;</p>
<p id="p402909914084826"><a name="p402909914084826"></a><a name="p402909914084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row1766896896084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1381624910084826"><a name="p1381624910084826"></a><a name="p1381624910084826"></a><a href="Graphic.md#ga7e20822a6c448bee724f20afad1c69d4">OHOS::UICanvas::Clear</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p734328077084826"><a name="p734328077084826"></a><a name="p734328077084826"></a>void&nbsp;</p>
<p id="p1939050039084826"><a name="p1939050039084826"></a><a name="p1939050039084826"></a>Clears the entire canvas. </p>
</td>
</tr>
<tr id="row742445387084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p376792639084826"><a name="p376792639084826"></a><a name="p376792639084826"></a><a href="Graphic.md#gaca35fe1a1d344eab80ecb1425a74a91a">OHOS::UICanvas::SetStartPosition</a> (const <a href="OHOS-Point.md">Point</a> &amp;startPoint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1604844110084826"><a name="p1604844110084826"></a><a name="p1604844110084826"></a>void&nbsp;</p>
<p id="p914646944084826"><a name="p914646944084826"></a><a name="p914646944084826"></a>Sets the coordinates of the start point for drawing a line. For example, if <strong id="b2106150723084826"><a name="b2106150723084826"></a><a name="b2106150723084826"></a>startPoint</strong> is set to {50, 50}, the line is drawn from this set of coordinates on the canvas. </p>
</td>
</tr>
<tr id="row1581443560084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1193417314084826"><a name="p1193417314084826"></a><a name="p1193417314084826"></a><a href="Graphic.md#gad23f7db18bfa5f91e3cb814193e6932d">OHOS::UICanvas::GetStartPosition</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p656930901084826"><a name="p656930901084826"></a><a name="p656930901084826"></a>const <a href="OHOS-Point.md">Point</a> &amp;&nbsp;</p>
<p id="p1625952593084826"><a name="p1625952593084826"></a><a name="p1625952593084826"></a>Obtains the coordinates of the start point of a line. </p>
</td>
</tr>
<tr id="row2038243825084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1244047744084826"><a name="p1244047744084826"></a><a name="p1244047744084826"></a><a href="Graphic.md#gac97d9d39484e5a1e36273510ae47327e">OHOS::UICanvas::DrawLine</a> (const <a href="OHOS-Point.md">Point</a> &amp;endPoint, const <a href="OHOS-Paint.md">Paint</a> &amp;paint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1490022241084826"><a name="p1490022241084826"></a><a name="p1490022241084826"></a>void&nbsp;</p>
<p id="p835475425084826"><a name="p835475425084826"></a><a name="p835475425084826"></a>Draws a straight line. </p>
</td>
</tr>
<tr id="row999345025084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p513472981084826"><a name="p513472981084826"></a><a name="p513472981084826"></a><a href="Graphic.md#ga0c5e94526dab6a62d6db0a67385104db">OHOS::UICanvas::DrawLine</a> (const <a href="OHOS-Point.md">Point</a> &amp;startPoint, const <a href="OHOS-Point.md">Point</a> &amp;endPoint, const <a href="OHOS-Paint.md">Paint</a> &amp;paint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1091487120084826"><a name="p1091487120084826"></a><a name="p1091487120084826"></a>void&nbsp;</p>
<p id="p1329951491084826"><a name="p1329951491084826"></a><a name="p1329951491084826"></a>Draws a straight line from the coordinates of the start point. </p>
</td>
</tr>
<tr id="row1866747556084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p396295701084826"><a name="p396295701084826"></a><a name="p396295701084826"></a><a href="Graphic.md#gab6557ddb74b721e4eba6cdabab954a3b">OHOS::UICanvas::DrawCurve</a> (const <a href="OHOS-Point.md">Point</a> &amp;control1, const <a href="OHOS-Point.md">Point</a> &amp;control2, const <a href="OHOS-Point.md">Point</a> &amp;endPoint, const <a href="OHOS-Paint.md">Paint</a> &amp;paint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p125215296084826"><a name="p125215296084826"></a><a name="p125215296084826"></a>void&nbsp;</p>
<p id="p77160254084826"><a name="p77160254084826"></a><a name="p77160254084826"></a>Draws a cubic Bezier curve. </p>
</td>
</tr>
<tr id="row1577772888084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1035135708084826"><a name="p1035135708084826"></a><a name="p1035135708084826"></a><a href="Graphic.md#gad186e8eab51e97a4854d3a757a3becfb">OHOS::UICanvas::DrawCurve</a> (const <a href="OHOS-Point.md">Point</a> &amp;startPoint, const <a href="OHOS-Point.md">Point</a> &amp;control1, const <a href="OHOS-Point.md">Point</a> &amp;control2, const <a href="OHOS-Point.md">Point</a> &amp;endPoint, const <a href="OHOS-Paint.md">Paint</a> &amp;paint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p752146588084826"><a name="p752146588084826"></a><a name="p752146588084826"></a>void&nbsp;</p>
<p id="p104604915084826"><a name="p104604915084826"></a><a name="p104604915084826"></a>Draws a cubic Bezier curve from the start point coordinates. </p>
</td>
</tr>
<tr id="row59117562084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p598175778084826"><a name="p598175778084826"></a><a name="p598175778084826"></a><a href="Graphic.md#ga1cc0bc88810cdd5554e2b1b14e68c279">OHOS::UICanvas::DrawRect</a> (const <a href="OHOS-Point.md">Point</a> &amp;startPoint, int16_t height, int16_t width, const <a href="OHOS-Paint.md">Paint</a> &amp;paint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p903350307084826"><a name="p903350307084826"></a><a name="p903350307084826"></a>void&nbsp;</p>
<p id="p965334546084826"><a name="p965334546084826"></a><a name="p965334546084826"></a>Draws a rectangle. </p>
</td>
</tr>
<tr id="row1234673801084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1044268920084826"><a name="p1044268920084826"></a><a name="p1044268920084826"></a><a href="Graphic.md#ga974544e34560d0f9d6e162c528fcd7af">OHOS::UICanvas::DrawCircle</a> (const <a href="OHOS-Point.md">Point</a> &amp;center, uint16_t radius, const <a href="OHOS-Paint.md">Paint</a> &amp;paint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1578771804084826"><a name="p1578771804084826"></a><a name="p1578771804084826"></a>void&nbsp;</p>
<p id="p1106969031084826"><a name="p1106969031084826"></a><a name="p1106969031084826"></a>Draws a circle. </p>
</td>
</tr>
<tr id="row942885167084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p265937356084826"><a name="p265937356084826"></a><a name="p265937356084826"></a><a href="Graphic.md#gaf14bc2633c51a16097c3ad35e8bcb314">OHOS::UICanvas::DrawSector</a> (const <a href="OHOS-Point.md">Point</a> &amp;center, uint16_t radius, int16_t startAngle, int16_t endAngle, const <a href="OHOS-Paint.md">Paint</a> &amp;paint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p157669298084826"><a name="p157669298084826"></a><a name="p157669298084826"></a>void&nbsp;</p>
<p id="p1152533959084826"><a name="p1152533959084826"></a><a name="p1152533959084826"></a>Draws a sector. </p>
</td>
</tr>
<tr id="row1455675451084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1196643376084826"><a name="p1196643376084826"></a><a name="p1196643376084826"></a><a href="Graphic.md#ga620028da5c71f96416becc877331ba6c">OHOS::UICanvas::DrawArc</a> (const <a href="OHOS-Point.md">Point</a> &amp;center, uint16_t radius, int16_t startAngle, int16_t endAngle, const <a href="OHOS-Paint.md">Paint</a> &amp;paint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p802328407084826"><a name="p802328407084826"></a><a name="p802328407084826"></a>void&nbsp;</p>
<p id="p70848244084826"><a name="p70848244084826"></a><a name="p70848244084826"></a>Draws an arc. </p>
</td>
</tr>
<tr id="row1170343235084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1766096601084826"><a name="p1766096601084826"></a><a name="p1766096601084826"></a><a href="Graphic.md#gad5810166b3e02f41319dd4f4229c516c">OHOS::UICanvas::DrawImage</a> (const <a href="OHOS-Point.md">Point</a> &amp;startPoint, const char *image, const <a href="OHOS-Paint.md">Paint</a> &amp;paint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p382109625084826"><a name="p382109625084826"></a><a name="p382109625084826"></a>void&nbsp;</p>
<p id="p864147466084826"><a name="p864147466084826"></a><a name="p864147466084826"></a>Draws an image. </p>
</td>
</tr>
<tr id="row1538657607084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p275114519084826"><a name="p275114519084826"></a><a name="p275114519084826"></a><a href="Graphic.md#ga32d815e5a459b4a866217a7c5c4bb425">OHOS::UICanvas::DrawLabel</a> (const <a href="OHOS-Point.md">Point</a> &amp;startPoint, const char *text, uint16_t maxWidth, const <a href="OHOS-UICanvas-FontStyle.md">FontStyle</a> &amp;fontStyle, const <a href="OHOS-Paint.md">Paint</a> &amp;paint)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p85938083084826"><a name="p85938083084826"></a><a name="p85938083084826"></a>void&nbsp;</p>
<p id="p1274072230084826"><a name="p1274072230084826"></a><a name="p1274072230084826"></a>Draws text. </p>
</td>
</tr>
<tr id="row1578297167084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p898878048084826"><a name="p898878048084826"></a><a name="p898878048084826"></a><a href="Graphic.md#gac6122967d3e1f0d312eebed2f93a1369">OHOS::UICanvas::OnDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1135376829084826"><a name="p1135376829084826"></a><a name="p1135376829084826"></a>virtual void&nbsp;</p>
<p id="p1076238444084826"><a name="p1076238444084826"></a><a name="p1076238444084826"></a>Called when a view is drawn. </p>
</td>
</tr>
<tr id="row97644690084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1032097459084826"><a name="p1032097459084826"></a><a name="p1032097459084826"></a><a href="Graphic.md#ga8f1555cd3433927a650e7800a8746779">OHOS::UIChartDataSerial::UIChartDataSerial</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1557005699084826"><a name="p1557005699084826"></a><a name="p1557005699084826"></a>&nbsp;</p>
<p id="p984029122084826"><a name="p984029122084826"></a><a name="p984029122084826"></a>A constructor used to create a <strong id="b1328273378084826"><a name="b1328273378084826"></a><a name="b1328273378084826"></a><a href="OHOS-UIChartDataSerial.md">UIChartDataSerial</a></strong> instance. </p>
</td>
</tr>
<tr id="row1722427260084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1017307305084826"><a name="p1017307305084826"></a><a name="p1017307305084826"></a><a href="Graphic.md#gaaf2cda0d138bb4b3a752f875f146a5bc">OHOS::UIChartDataSerial::~UIChartDataSerial</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1262850927084826"><a name="p1262850927084826"></a><a name="p1262850927084826"></a>virtual&nbsp;</p>
<p id="p589686996084826"><a name="p589686996084826"></a><a name="p589686996084826"></a>A destructor used to delete the <strong id="b1919795997084826"><a name="b1919795997084826"></a><a name="b1919795997084826"></a><a href="OHOS-UIChartDataSerial.md">UIChartDataSerial</a></strong> instance. </p>
</td>
</tr>
<tr id="row1342345609084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p624351352084826"><a name="p624351352084826"></a><a name="p624351352084826"></a><a href="Graphic.md#ga81133f20156b6dc269927a5be9caf653">OHOS::UIChartDataSerial::SetMaxDataCount</a> (uint16_t maxCount)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p670760391084826"><a name="p670760391084826"></a><a name="p670760391084826"></a>bool&nbsp;</p>
<p id="p312109574084826"><a name="p312109574084826"></a><a name="p312109574084826"></a>Sets the maximum number of data points that can be stored in a data set. </p>
</td>
</tr>
<tr id="row539591881084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1049375400084826"><a name="p1049375400084826"></a><a name="p1049375400084826"></a><a href="Graphic.md#gaa4e5a9c7d456a3753020a3fb88159c83">OHOS::UIChartDataSerial::ModifyPoint</a> (uint16_t <a href="UTILS.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>, const <a href="OHOS-Point.md">Point</a> &amp;point)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2055478000084826"><a name="p2055478000084826"></a><a name="p2055478000084826"></a>bool&nbsp;</p>
<p id="p915417616084826"><a name="p915417616084826"></a><a name="p915417616084826"></a>Modifies the value of a data point in the data set. </p>
</td>
</tr>
<tr id="row1260945742084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1224273426084826"><a name="p1224273426084826"></a><a name="p1224273426084826"></a><a href="Graphic.md#ga32f85e7d3d9c67d491caa4105c6fa379">OHOS::UIChartDataSerial::GetPoint</a> (uint16_t <a href="UTILS.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>, <a href="OHOS-Point.md">Point</a> &amp;point)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p124787217084826"><a name="p124787217084826"></a><a name="p124787217084826"></a>bool&nbsp;</p>
<p id="p780632520084826"><a name="p780632520084826"></a><a name="p780632520084826"></a>Obtains the coordinates in the chart for a data point in the data set. </p>
</td>
</tr>
<tr id="row1718950563084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1190982126084826"><a name="p1190982126084826"></a><a name="p1190982126084826"></a><a href="Graphic.md#ga88d554725405cf9c501f145a25448238">OHOS::UIChartDataSerial::AddPoints</a> (const <a href="OHOS-Point.md">Point</a> *data, uint16_t count)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1036483933084826"><a name="p1036483933084826"></a><a name="p1036483933084826"></a>bool&nbsp;</p>
<p id="p2075186181084826"><a name="p2075186181084826"></a><a name="p2075186181084826"></a>Adds data points. </p>
</td>
</tr>
<tr id="row2056849839084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2138367416084826"><a name="p2138367416084826"></a><a name="p2138367416084826"></a><a href="Graphic.md#ga148d9b3933a733433a96a48b95cff844">OHOS::UIChartDataSerial::ClearData</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1625425029084826"><a name="p1625425029084826"></a><a name="p1625425029084826"></a>void&nbsp;</p>
<p id="p1888341382084826"><a name="p1888341382084826"></a><a name="p1888341382084826"></a>Clears all data points. </p>
</td>
</tr>
<tr id="row311624864084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1393487476084826"><a name="p1393487476084826"></a><a name="p1393487476084826"></a><a href="Graphic.md#ga42b69b4725ed1d61bb8da019562c3fb2">OHOS::UIChartDataSerial::GetDataCount</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1249767769084826"><a name="p1249767769084826"></a><a name="p1249767769084826"></a>uint16_t&nbsp;</p>
<p id="p2051668604084826"><a name="p2051668604084826"></a><a name="p2051668604084826"></a>Obtains the number of data points available in the data set. </p>
</td>
</tr>
<tr id="row1427033639084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1196260567084826"><a name="p1196260567084826"></a><a name="p1196260567084826"></a><a href="Graphic.md#ga9a3d5d81adbef7f847b631d03a472fbd">OHOS::UIChartDataSerial::EnableSmooth</a> (bool smooth)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1940208410084826"><a name="p1940208410084826"></a><a name="p1940208410084826"></a>void&nbsp;</p>
<p id="p291295402084826"><a name="p291295402084826"></a><a name="p291295402084826"></a>Sets whether to smooth a polyline. </p>
</td>
</tr>
<tr id="row937703726084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1782132772084826"><a name="p1782132772084826"></a><a name="p1782132772084826"></a><a href="Graphic.md#ga5d9211f3eaee4e1c9455709a228087fe">OHOS::UIChartDataSerial::IsSmooth</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1554633558084826"><a name="p1554633558084826"></a><a name="p1554633558084826"></a>bool&nbsp;</p>
<p id="p1543779386084826"><a name="p1543779386084826"></a><a name="p1543779386084826"></a>Checks whether smoothing is performed on a polyline. </p>
</td>
</tr>
<tr id="row675103340084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p16758107084826"><a name="p16758107084826"></a><a name="p16758107084826"></a><a href="Graphic.md#gaa4635e5332809fc7a275c4077f9d140d">OHOS::UIChartDataSerial::EnableGradient</a> (bool enable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2005680974084826"><a name="p2005680974084826"></a><a name="p2005680974084826"></a>void&nbsp;</p>
<p id="p1365303735084826"><a name="p1365303735084826"></a><a name="p1365303735084826"></a>Enables the fill color of a line chart. </p>
</td>
</tr>
<tr id="row747839422084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p32655911084826"><a name="p32655911084826"></a><a name="p32655911084826"></a><a href="Graphic.md#ga6188c14ea249a34db4819499f4e38133">OHOS::UIChartDataSerial::IsGradient</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p858329925084826"><a name="p858329925084826"></a><a name="p858329925084826"></a>bool&nbsp;</p>
<p id="p260982728084826"><a name="p260982728084826"></a><a name="p260982728084826"></a>Checks whether a polyline has a fill color. </p>
</td>
</tr>
<tr id="row147905249084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p52680392084826"><a name="p52680392084826"></a><a name="p52680392084826"></a><a href="Graphic.md#ga60c2b77e89d616a416a05f18b5c5c055">OHOS::UIChartDataSerial::GetPeakIndex</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1994773660084826"><a name="p1994773660084826"></a><a name="p1994773660084826"></a>uint16_t&nbsp;</p>
<p id="p1381967964084826"><a name="p1381967964084826"></a><a name="p1381967964084826"></a>Obtains the index of the top point in the data set. </p>
</td>
</tr>
<tr id="row1774983725084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1890012830084826"><a name="p1890012830084826"></a><a name="p1890012830084826"></a><a href="Graphic.md#ga390d7cfb4e3ced676ec6c7ac22c1ccc5">OHOS::UIChartDataSerial::GetLatestIndex</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p985763935084826"><a name="p985763935084826"></a><a name="p985763935084826"></a>uint16_t&nbsp;</p>
<p id="p1133483247084826"><a name="p1133483247084826"></a><a name="p1133483247084826"></a>Obtains the index of the frontmost point (the latest added or modified data point in a data set). </p>
</td>
</tr>
<tr id="row1676919984084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p288226577084826"><a name="p288226577084826"></a><a name="p288226577084826"></a><a href="Graphic.md#ga630a7356e3dbcb212a2e88ef0c6b857d">OHOS::UIChartDataSerial::GetValleyIndex</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2016284766084826"><a name="p2016284766084826"></a><a name="p2016284766084826"></a>uint16_t&nbsp;</p>
<p id="p488963085084826"><a name="p488963085084826"></a><a name="p488963085084826"></a>Obtains the index of the bottom point in a data set. </p>
</td>
</tr>
<tr id="row99815268084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2125212798084826"><a name="p2125212798084826"></a><a name="p2125212798084826"></a><a href="Graphic.md#gaf6c796fbd08cab47cf4fc0d41185a591">OHOS::UIChartDataSerial::GetPeakData</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p746582573084826"><a name="p746582573084826"></a><a name="p746582573084826"></a>int16_t&nbsp;</p>
<p id="p1216535648084826"><a name="p1216535648084826"></a><a name="p1216535648084826"></a>Obtains the Y value of the top point in a data set. </p>
</td>
</tr>
<tr id="row1611033329084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1126322055084826"><a name="p1126322055084826"></a><a name="p1126322055084826"></a><a href="Graphic.md#gae75c525df3451cb5e863d15fd36db07e">OHOS::UIChartDataSerial::GetValleyData</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1773499174084826"><a name="p1773499174084826"></a><a name="p1773499174084826"></a>int16_t&nbsp;</p>
<p id="p113484765084826"><a name="p113484765084826"></a><a name="p113484765084826"></a>Obtains the Y value of the bottom point in a data set. </p>
</td>
</tr>
<tr id="row1948675447084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p950894058084826"><a name="p950894058084826"></a><a name="p950894058084826"></a><a href="Graphic.md#gaa35d69c841a74505735d1acb60476f13">OHOS::UIChartDataSerial::GetLineColor</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1180120984084826"><a name="p1180120984084826"></a><a name="p1180120984084826"></a><a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p310771030084826"><a name="p310771030084826"></a><a name="p310771030084826"></a>Obtains the polyline color of the data set in a line chart. </p>
</td>
</tr>
<tr id="row1895916503084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p784604209084826"><a name="p784604209084826"></a><a name="p784604209084826"></a><a href="Graphic.md#ga3b20df3a339aa0f41d404eb3dc1d12ca">OHOS::UIChartDataSerial::GetFillColor</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1530351945084826"><a name="p1530351945084826"></a><a name="p1530351945084826"></a><a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p957994936084826"><a name="p957994936084826"></a><a name="p957994936084826"></a>Obtains the fill color of the data set. </p>
</td>
</tr>
<tr id="row2108930248084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2031189905084826"><a name="p2031189905084826"></a><a name="p2031189905084826"></a><a href="Graphic.md#gac620b9878a5e28d066dffbcd6145539c">OHOS::UIChartDataSerial::SetFillColor</a> (const <a href="OHOS-Color32.md">ColorType</a> &amp;color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2109858066084826"><a name="p2109858066084826"></a><a name="p2109858066084826"></a>void&nbsp;</p>
<p id="p169480406084826"><a name="p169480406084826"></a><a name="p169480406084826"></a>Sets the fill color of the data set. </p>
</td>
</tr>
<tr id="row112626440084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1948464424084826"><a name="p1948464424084826"></a><a name="p1948464424084826"></a><a href="Graphic.md#ga94beac0c71885b8546996271c876f999">OHOS::UIChartDataSerial::SetLineColor</a> (const <a href="OHOS-Color32.md">ColorType</a> &amp;color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p622665980084826"><a name="p622665980084826"></a><a name="p622665980084826"></a>void&nbsp;</p>
<p id="p1029921273084826"><a name="p1029921273084826"></a><a name="p1029921273084826"></a>Sets the polyline color of the data set in the line chart. </p>
</td>
</tr>
<tr id="row1465078031084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1516868206084826"><a name="p1516868206084826"></a><a name="p1516868206084826"></a><a href="Graphic.md#ga02cb658da66c73863ac2a49849e23b24">OHOS::UIChartDataSerial::HidePoint</a> (uint16_t <a href="UTILS.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>, uint16_t count)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1382679135084826"><a name="p1382679135084826"></a><a name="p1382679135084826"></a>void&nbsp;</p>
<p id="p1731506663084826"><a name="p1731506663084826"></a><a name="p1731506663084826"></a>Hides some points in the data set. </p>
</td>
</tr>
<tr id="row720297157084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p695215911084826"><a name="p695215911084826"></a><a name="p695215911084826"></a><a href="Graphic.md#ga607716e734fba2eef917fdee372e43b1">OHOS::UIChartDataSerial::GetHideIndex</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2061578457084826"><a name="p2061578457084826"></a><a name="p2061578457084826"></a>uint16_t&nbsp;</p>
<p id="p25805318084826"><a name="p25805318084826"></a><a name="p25805318084826"></a>Obtains the index from which the data set starts to hide. </p>
</td>
</tr>
<tr id="row1589398013084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p747213018084826"><a name="p747213018084826"></a><a name="p747213018084826"></a><a href="Graphic.md#ga736907dd9f33b5335f0df5599f5cb006">OHOS::UIChartDataSerial::GetHideCount</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1233050797084826"><a name="p1233050797084826"></a><a name="p1233050797084826"></a>uint16_t&nbsp;</p>
<p id="p410613308084826"><a name="p410613308084826"></a><a name="p410613308084826"></a>Obtains the number of hidden points in the data set. </p>
</td>
</tr>
<tr id="row1679741132084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1374943954084826"><a name="p1374943954084826"></a><a name="p1374943954084826"></a><a href="Graphic.md#ga8fcb9d0640963ff30ff010ca5d387ff2">OHOS::UIChartDataSerial::SetHeadPointStyle</a> (const <a href="OHOS-UIChartDataSerial-PointStyle.md">PointStyle</a> &amp;style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p905331074084826"><a name="p905331074084826"></a><a name="p905331074084826"></a>void&nbsp;</p>
<p id="p799872946084826"><a name="p799872946084826"></a><a name="p799872946084826"></a>Sets the style of the frontmost point on a polyline. </p>
</td>
</tr>
<tr id="row877573771084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1327980786084826"><a name="p1327980786084826"></a><a name="p1327980786084826"></a><a href="Graphic.md#ga91b0d5442e708e2d2bd39436b5d46baa">OHOS::UIChartDataSerial::SetTopPointStyle</a> (const <a href="OHOS-UIChartDataSerial-PointStyle.md">PointStyle</a> &amp;style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1208943016084826"><a name="p1208943016084826"></a><a name="p1208943016084826"></a>void&nbsp;</p>
<p id="p1063699207084826"><a name="p1063699207084826"></a><a name="p1063699207084826"></a>Sets the style of the top point of a polyline. </p>
</td>
</tr>
<tr id="row1178706177084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1614117833084826"><a name="p1614117833084826"></a><a name="p1614117833084826"></a><a href="Graphic.md#gab99eef3cd222625e8d3a30cca815ced2">OHOS::UIChartDataSerial::SetBottomPointStyle</a> (const <a href="OHOS-UIChartDataSerial-PointStyle.md">PointStyle</a> &amp;style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p164596672084826"><a name="p164596672084826"></a><a name="p164596672084826"></a>void&nbsp;</p>
<p id="p1884911464084826"><a name="p1884911464084826"></a><a name="p1884911464084826"></a>Sets the style of the bottom point of a polyline. </p>
</td>
</tr>
<tr id="row346391764084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p502181016084826"><a name="p502181016084826"></a><a name="p502181016084826"></a><a href="Graphic.md#ga37a267a68383b41ce1d5c9072c2f7e83">OHOS::UIChartDataSerial::GetHeadPointStyle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2010677226084826"><a name="p2010677226084826"></a><a name="p2010677226084826"></a>const <a href="OHOS-UIChartDataSerial-PointStyle.md">PointStyle</a> &amp;&nbsp;</p>
<p id="p36723535084826"><a name="p36723535084826"></a><a name="p36723535084826"></a>Obtains the style of the frontmost point on a polyline. </p>
</td>
</tr>
<tr id="row1049906654084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1302909980084826"><a name="p1302909980084826"></a><a name="p1302909980084826"></a><a href="Graphic.md#ga215f5c5f8de923f0aa399a6bbdf78e18">OHOS::UIChartDataSerial::GetTopPointStyle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p302519150084826"><a name="p302519150084826"></a><a name="p302519150084826"></a>const <a href="OHOS-UIChartDataSerial-PointStyle.md">PointStyle</a> &amp;&nbsp;</p>
<p id="p364882457084826"><a name="p364882457084826"></a><a name="p364882457084826"></a>Obtains the style of the top point of a polyline. </p>
</td>
</tr>
<tr id="row632804144084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p821513027084826"><a name="p821513027084826"></a><a name="p821513027084826"></a><a href="Graphic.md#gaca803ecb139a0dae90825748bdbbf12b">OHOS::UIChartDataSerial::GetBottomPointStyle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2032111312084826"><a name="p2032111312084826"></a><a name="p2032111312084826"></a>const <a href="OHOS-UIChartDataSerial-PointStyle.md">PointStyle</a> &amp;&nbsp;</p>
<p id="p815314012084826"><a name="p815314012084826"></a><a name="p815314012084826"></a>Obtains the style of the bottom point of a polyline. </p>
</td>
</tr>
<tr id="row1633572078084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1729988847084826"><a name="p1729988847084826"></a><a name="p1729988847084826"></a><a href="Graphic.md#gaa90973e2315035570ffae0d4c3c2e976">OHOS::UIChartDataSerial::EnableHeadPoint</a> (bool enable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1390268217084826"><a name="p1390268217084826"></a><a name="p1390268217084826"></a>void&nbsp;</p>
<p id="p1144871246084826"><a name="p1144871246084826"></a><a name="p1144871246084826"></a>Enables the feature of drawing the frontmost point on a polyline. </p>
</td>
</tr>
<tr id="row687376956084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1324988497084826"><a name="p1324988497084826"></a><a name="p1324988497084826"></a><a href="Graphic.md#gab97d84ead6aa301d2ae23fc68aa98a9f">OHOS::UIChartDataSerial::EnableTopPoint</a> (bool enable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p243331230084826"><a name="p243331230084826"></a><a name="p243331230084826"></a>void&nbsp;</p>
<p id="p2030847238084826"><a name="p2030847238084826"></a><a name="p2030847238084826"></a>Enables the feature of drawing the top point of a polyline. If there are multiple top points, only the first one is drawn. </p>
</td>
</tr>
<tr id="row1602230310084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p481713798084826"><a name="p481713798084826"></a><a name="p481713798084826"></a><a href="Graphic.md#ga2c0d693d31efd256cc6529255699ddd3">OHOS::UIChartDataSerial::EnableBottomPoint</a> (bool enable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p263386726084826"><a name="p263386726084826"></a><a name="p263386726084826"></a>void&nbsp;</p>
<p id="p918118971084826"><a name="p918118971084826"></a><a name="p918118971084826"></a>Enables the feature of drawing the bottom point of a polyline. If there are multiple bottom points, only the first one is drawn. </p>
</td>
</tr>
<tr id="row1741548430084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p966754800084826"><a name="p966754800084826"></a><a name="p966754800084826"></a><a href="Graphic.md#ga3ab02ed367123e4f84e5ab145f5ed949">OHOS::UIChart::UIChart</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p126393105084826"><a name="p126393105084826"></a><a name="p126393105084826"></a>&nbsp;</p>
<p id="p1026114735084826"><a name="p1026114735084826"></a><a name="p1026114735084826"></a>A constructor used to create a <strong id="b1358160322084826"><a name="b1358160322084826"></a><a name="b1358160322084826"></a><a href="OHOS-UIChart.md">UIChart</a></strong> instance. </p>
</td>
</tr>
<tr id="row1621448839084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1312441953084826"><a name="p1312441953084826"></a><a name="p1312441953084826"></a><a href="Graphic.md#gab5d79c4736d822116dcdd7ed6e45294e">OHOS::UIChart::~UIChart</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1881026576084826"><a name="p1881026576084826"></a><a name="p1881026576084826"></a>virtual&nbsp;</p>
<p id="p1974304102084826"><a name="p1974304102084826"></a><a name="p1974304102084826"></a>A destructor used to delete the <strong id="b531933513084826"><a name="b531933513084826"></a><a name="b531933513084826"></a><a href="OHOS-UIChart.md">UIChart</a></strong> instance. </p>
</td>
</tr>
<tr id="row1867836849084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p822228679084826"><a name="p822228679084826"></a><a name="p822228679084826"></a><a href="Graphic.md#gaea65298b6e4a71a2de65c13e1b14ed7b">OHOS::UIChart::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1813179528084826"><a name="p1813179528084826"></a><a name="p1813179528084826"></a>UIViewType&nbsp;</p>
<p id="p1751470828084826"><a name="p1751470828084826"></a><a name="p1751470828084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row420244704084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p595052150084826"><a name="p595052150084826"></a><a name="p595052150084826"></a><a href="Graphic.md#ga54b3c4122ebaeefe74587ca69aa98600">OHOS::UIChart::SetHeight</a> (int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1380595010084826"><a name="p1380595010084826"></a><a name="p1380595010084826"></a>void&nbsp;</p>
<p id="p1534298310084826"><a name="p1534298310084826"></a><a name="p1534298310084826"></a>Sets the height for this component. </p>
</td>
</tr>
<tr id="row1473097177084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1996757179084826"><a name="p1996757179084826"></a><a name="p1996757179084826"></a><a href="Graphic.md#ga2ae317808111cd58e6ba93e030f23111">OHOS::UIChart::SetWidth</a> (int16_t width) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p164445109084826"><a name="p164445109084826"></a><a name="p164445109084826"></a>void&nbsp;</p>
<p id="p1815250780084826"><a name="p1815250780084826"></a><a name="p1815250780084826"></a>Sets the width for this component. </p>
</td>
</tr>
<tr id="row1251176022084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1123591971084826"><a name="p1123591971084826"></a><a name="p1123591971084826"></a><a href="Graphic.md#ga9a8287a522f00bb3dbe60af8f242054a">OHOS::UIChart::OnPreDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1326877516084826"><a name="p1326877516084826"></a><a name="p1326877516084826"></a>bool&nbsp;</p>
<p id="p223897577084826"><a name="p223897577084826"></a><a name="p223897577084826"></a>Called before a view is drawn. This function is used to check whether the parent view of this view needs to be redrawn so as to optimize the drawing process. </p>
</td>
</tr>
<tr id="row898442818084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2008576381084826"><a name="p2008576381084826"></a><a name="p2008576381084826"></a><a href="Graphic.md#ga5c101948cb2cfb8394af0bcb56f65efb">OHOS::UIChart::OnDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2112938724084826"><a name="p2112938724084826"></a><a name="p2112938724084826"></a>void&nbsp;</p>
<p id="p831947296084826"><a name="p831947296084826"></a><a name="p831947296084826"></a>Called when a view is drawn. </p>
</td>
</tr>
<tr id="row913719977084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1544228874084826"><a name="p1544228874084826"></a><a name="p1544228874084826"></a><a href="Graphic.md#gafc510047aac4e7eebd5b229e726ef762">OHOS::UIChart::AddDataSerial</a> (<a href="OHOS-UIChartDataSerial.md">UIChartDataSerial</a> *dataSerial)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p531431374084826"><a name="p531431374084826"></a><a name="p531431374084826"></a>virtual bool&nbsp;</p>
<p id="p18525037084826"><a name="p18525037084826"></a><a name="p18525037084826"></a>Adds a data set. </p>
</td>
</tr>
<tr id="row2001531531084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p195731313084826"><a name="p195731313084826"></a><a name="p195731313084826"></a><a href="Graphic.md#ga2af81fbcd6a17ef250bf07e2d7606b8d">OHOS::UIChart::DeleteDataSerial</a> (<a href="OHOS-UIChartDataSerial.md">UIChartDataSerial</a> *dataSerial)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p591517506084826"><a name="p591517506084826"></a><a name="p591517506084826"></a>virtual bool&nbsp;</p>
<p id="p533489733084826"><a name="p533489733084826"></a><a name="p533489733084826"></a>Deletes a data set. </p>
</td>
</tr>
<tr id="row1735193121084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1138290553084826"><a name="p1138290553084826"></a><a name="p1138290553084826"></a><a href="Graphic.md#gae2752857fbcb9f1541cd811321bfc2c6">OHOS::UIChart::ClearDataSerial</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1729211188084826"><a name="p1729211188084826"></a><a name="p1729211188084826"></a>virtual void&nbsp;</p>
<p id="p181698334084826"><a name="p181698334084826"></a><a name="p181698334084826"></a>Clears all data sets. </p>
</td>
</tr>
<tr id="row263295419084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p30979871084826"><a name="p30979871084826"></a><a name="p30979871084826"></a><a href="Graphic.md#gaaab35011c82308c770cf5c15641fe21c">OHOS::UIChart::RefreshChart</a> ()=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p178406438084826"><a name="p178406438084826"></a><a name="p178406438084826"></a>virtual void&nbsp;</p>
<p id="p1095014309084826"><a name="p1095014309084826"></a><a name="p1095014309084826"></a>Refreshes a chart and redraws the dirty region. </p>
</td>
</tr>
<tr id="row2017465378084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1447619831084826"><a name="p1447619831084826"></a><a name="p1447619831084826"></a><a href="Graphic.md#ga010c178e2c1dec79e4af10cbf4545257">OHOS::UIChart::GetXAxis</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1079831379084826"><a name="p1079831379084826"></a><a name="p1079831379084826"></a><a href="OHOS-UIXAxis.md">UIXAxis</a> &amp;&nbsp;</p>
<p id="p643975986084826"><a name="p643975986084826"></a><a name="p643975986084826"></a>Obtains the x-axis instance. </p>
</td>
</tr>
<tr id="row176509865084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1521953463084826"><a name="p1521953463084826"></a><a name="p1521953463084826"></a><a href="Graphic.md#ga696227300be45585be102f6a7f66b7b1">OHOS::UIChart::GetYAxis</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1447097772084826"><a name="p1447097772084826"></a><a name="p1447097772084826"></a><a href="OHOS-UIYAxis.md">UIYAxis</a> &amp;&nbsp;</p>
<p id="p2031193486084826"><a name="p2031193486084826"></a><a name="p2031193486084826"></a>Obtains the y-axis instance. </p>
</td>
</tr>
<tr id="row1258757794084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1642725363084826"><a name="p1642725363084826"></a><a name="p1642725363084826"></a><a href="Graphic.md#ga7c99edd3adfb60796be92e98fd71a705">OHOS::UIChart::EnableReverse</a> (bool enable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p408552732084826"><a name="p408552732084826"></a><a name="p408552732084826"></a>void&nbsp;</p>
<p id="p860824874084826"><a name="p860824874084826"></a><a name="p860824874084826"></a>Enables chart reverse. </p>
</td>
</tr>
<tr id="row1622354767084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1373475117084826"><a name="p1373475117084826"></a><a name="p1373475117084826"></a><a href="Graphic.md#ga5c26ce24f640f795404c8375b4043186">OHOS::UIChartPillar::UIChartPillar</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p892345972084826"><a name="p892345972084826"></a><a name="p892345972084826"></a>&nbsp;</p>
<p id="p1454603007084826"><a name="p1454603007084826"></a><a name="p1454603007084826"></a>A constructor used to create a <strong id="b1589128592084826"><a name="b1589128592084826"></a><a name="b1589128592084826"></a><a href="OHOS-UIChartPillar.md">UIChartPillar</a></strong> instance. </p>
</td>
</tr>
<tr id="row385387454084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p339568263084826"><a name="p339568263084826"></a><a name="p339568263084826"></a><a href="Graphic.md#ga0f1e413e8eb026f2b5746b05b48d7ca7">OHOS::UIChartPillar::~UIChartPillar</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1524094366084826"><a name="p1524094366084826"></a><a name="p1524094366084826"></a>virtual&nbsp;</p>
<p id="p948482395084826"><a name="p948482395084826"></a><a name="p948482395084826"></a>A destructor used to delete the <strong id="b831347988084826"><a name="b831347988084826"></a><a name="b831347988084826"></a><a href="OHOS-UIChartPillar.md">UIChartPillar</a></strong> instance. </p>
</td>
</tr>
<tr id="row750001140084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p710634397084826"><a name="p710634397084826"></a><a name="p710634397084826"></a><a href="Graphic.md#ga0c6028474577ce99caa6d3eafaef1573">OHOS::UIChartPillar::RefreshChart</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p434839326084826"><a name="p434839326084826"></a><a name="p434839326084826"></a>void&nbsp;</p>
<p id="p1082164387084826"><a name="p1082164387084826"></a><a name="p1082164387084826"></a>Refreshes a bar chart and redraws the dirty region. </p>
</td>
</tr>
<tr id="row1303590340084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p27617802084826"><a name="p27617802084826"></a><a name="p27617802084826"></a><a href="Graphic.md#gaf32e6833f395ca6ac8620277531d5ea7">OHOS::UIChartPolyline::UIChartPolyline</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p59030763084826"><a name="p59030763084826"></a><a name="p59030763084826"></a>&nbsp;</p>
<p id="p426459146084826"><a name="p426459146084826"></a><a name="p426459146084826"></a>A constructor used to create a <strong id="b1954369726084826"><a name="b1954369726084826"></a><a name="b1954369726084826"></a><a href="OHOS-UIChartPolyline.md">UIChartPolyline</a></strong> instance. </p>
</td>
</tr>
<tr id="row1792269439084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1786831563084826"><a name="p1786831563084826"></a><a name="p1786831563084826"></a><a href="Graphic.md#ga620a90ab246ec8c5c55aed8985329cb9">OHOS::UIChartPolyline::~UIChartPolyline</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1906096271084826"><a name="p1906096271084826"></a><a name="p1906096271084826"></a>virtual&nbsp;</p>
<p id="p498254790084826"><a name="p498254790084826"></a><a name="p498254790084826"></a>A destructor used to delete the <strong id="b1654922946084826"><a name="b1654922946084826"></a><a name="b1654922946084826"></a><a href="OHOS-UIChartPolyline.md">UIChartPolyline</a></strong> instance. </p>
</td>
</tr>
<tr id="row668224683084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p375905018084826"><a name="p375905018084826"></a><a name="p375905018084826"></a><a href="Graphic.md#ga53594e65076b8588bcc48d4c69fbe8fd">OHOS::UIChartPolyline::RefreshChart</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2122087298084826"><a name="p2122087298084826"></a><a name="p2122087298084826"></a>void&nbsp;</p>
<p id="p308092804084826"><a name="p308092804084826"></a><a name="p308092804084826"></a>Refreshes a line chart and redraws the dirty region. </p>
</td>
</tr>
<tr id="row2108366746084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p85619289084826"><a name="p85619289084826"></a><a name="p85619289084826"></a><a href="Graphic.md#gacf4303bade3933dcac90459fa38d6e1f">OHOS::UIChartPolyline::SetGradientOpacity</a> (uint8_t minOpa, uint8_t maxOpa)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1218654677084826"><a name="p1218654677084826"></a><a name="p1218654677084826"></a>void&nbsp;</p>
<p id="p2006089288084826"><a name="p2006089288084826"></a><a name="p2006089288084826"></a>Sets the opacity range of the fill color gradient. </p>
</td>
</tr>
<tr id="row400222755084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1628112983084826"><a name="p1628112983084826"></a><a name="p1628112983084826"></a><a href="Graphic.md#gafdab5b0f7f8563d475c5aba2aeb1e828">OHOS::UIChartPolyline::SetGradientBottom</a> (uint16_t bottom)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1648416966084826"><a name="p1648416966084826"></a><a name="p1648416966084826"></a>void&nbsp;</p>
<p id="p1046695304084826"><a name="p1046695304084826"></a><a name="p1046695304084826"></a>Sets the distance between the bottom edge of the fill color range and the x-axis. </p>
</td>
</tr>
<tr id="row1381086099084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p969696639084826"><a name="p969696639084826"></a><a name="p969696639084826"></a><a href="Graphic.md#ga811085fbe237690f21a95e7df2a7c45f">OHOS::UICheckBox::UICheckBox</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1139846276084826"><a name="p1139846276084826"></a><a name="p1139846276084826"></a>&nbsp;</p>
<p id="p2104466172084826"><a name="p2104466172084826"></a><a name="p2104466172084826"></a>A constructor used to create a <strong id="b232721129084826"><a name="b232721129084826"></a><a name="b232721129084826"></a><a href="OHOS-UICheckBox.md">UICheckBox</a></strong> instance. </p>
</td>
</tr>
<tr id="row1357747647084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p529043035084826"><a name="p529043035084826"></a><a name="p529043035084826"></a><a href="Graphic.md#ga061c90b24caa6595b70a9da9f96c5c4e">OHOS::UICheckBox::~UICheckBox</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1611834553084826"><a name="p1611834553084826"></a><a name="p1611834553084826"></a>virtual&nbsp;</p>
<p id="p1066678124084826"><a name="p1066678124084826"></a><a name="p1066678124084826"></a>A destructor used to delete the <strong id="b934708483084826"><a name="b934708483084826"></a><a name="b934708483084826"></a><a href="OHOS-UICheckBox.md">UICheckBox</a></strong> instance. </p>
</td>
</tr>
<tr id="row1374084786084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1152106661084826"><a name="p1152106661084826"></a><a name="p1152106661084826"></a><a href="Graphic.md#ga373b76d4ce1aea6380f42ce78ecd59c3">OHOS::UICheckBox::OnChangeListener::OnChange</a> (<a href="Graphic.md#ga15a3f0302aded0e4d1584ddc6002335d">UICheckBoxState</a> state)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1512340098084826"><a name="p1512340098084826"></a><a name="p1512340098084826"></a>virtual bool&nbsp;</p>
<p id="p914022273084826"><a name="p914022273084826"></a><a name="p914022273084826"></a>Called when the state of this check box is switched. This is a virtual function, which needs your implementation. </p>
</td>
</tr>
<tr id="row1027121481084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p94058417084826"><a name="p94058417084826"></a><a name="p94058417084826"></a><a href="Graphic.md#gab2e7f64e07e70975baa571660687f6a1">OHOS::UICheckBox::OnChangeListener::~OnChangeListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1518926910084826"><a name="p1518926910084826"></a><a name="p1518926910084826"></a>virtual&nbsp;</p>
<p id="p1488217003084826"><a name="p1488217003084826"></a><a name="p1488217003084826"></a>A destructor used to delete the <strong id="b1500423206084826"><a name="b1500423206084826"></a><a name="b1500423206084826"></a><a href="OHOS-UICheckBox-OnChangeListener.md">OnChangeListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row628470046084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1253836125084826"><a name="p1253836125084826"></a><a name="p1253836125084826"></a><a href="Graphic.md#ga6820cef1fb685db5796670ca56b6aace">OHOS::UICheckBox::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2096334740084826"><a name="p2096334740084826"></a><a name="p2096334740084826"></a>UIViewType&nbsp;</p>
<p id="p1689471721084826"><a name="p1689471721084826"></a><a name="p1689471721084826"></a>Obtains the component type. </p>
</td>
</tr>
<tr id="row1656798168084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1221513101084826"><a name="p1221513101084826"></a><a name="p1221513101084826"></a><a href="Graphic.md#gad72c8f6a67fc3fb86da8eabffcf5315d">OHOS::UICheckBox::SetOnChangeListener</a> (<a href="OHOS-UICheckBox-OnChangeListener.md">OnChangeListener</a> *onStateChangeListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p217624493084826"><a name="p217624493084826"></a><a name="p217624493084826"></a>void&nbsp;</p>
<p id="p819518081084826"><a name="p819518081084826"></a><a name="p819518081084826"></a>Sets the listener for this check box. </p>
</td>
</tr>
<tr id="row1006595955084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p527879330084826"><a name="p527879330084826"></a><a name="p527879330084826"></a><a href="Graphic.md#ga53cc6c8f18b90c3abd96a791c8921010">OHOS::UICheckBox::OnPreDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p434069499084826"><a name="p434069499084826"></a><a name="p434069499084826"></a>bool&nbsp;</p>
<p id="p25468267084826"><a name="p25468267084826"></a><a name="p25468267084826"></a>Do something before draw, this function will be invoked mainly to check if this view need to cover invalidate area so render manager can decide which layer to draw firstly. </p>
</td>
</tr>
<tr id="row1634745510084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1284957289084826"><a name="p1284957289084826"></a><a name="p1284957289084826"></a><a href="Graphic.md#ga8e75f8411fb25e564c82573a12773189">OHOS::UICheckBox::OnDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p657663007084826"><a name="p657663007084826"></a><a name="p657663007084826"></a>void&nbsp;</p>
<p id="p1939142450084826"><a name="p1939142450084826"></a><a name="p1939142450084826"></a>Executes the draw action Ondraw invokes the rendering function provided by the underlying layer to draw pictures based on the selected status of the checkbox. </p>
</td>
</tr>
<tr id="row73239589084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1034171789084826"><a name="p1034171789084826"></a><a name="p1034171789084826"></a><a href="Graphic.md#ga31d4f10f4c32b0fb284645450875ae0c">OHOS::UICheckBox::OnClickEvent</a> (const <a href="OHOS-ClickEvent.md">ClickEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p889535709084826"><a name="p889535709084826"></a><a name="p889535709084826"></a>void&nbsp;</p>
<p id="p807645674084826"><a name="p807645674084826"></a><a name="p807645674084826"></a>Executes the click event action OnClickEvent will reverse the selected state of checkbox. Example: If the check box is selected, the checkbox status is changed to Unselected after the click action is taken. </p>
</td>
</tr>
<tr id="row1645849595084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1225739013084826"><a name="p1225739013084826"></a><a name="p1225739013084826"></a><a href="Graphic.md#ga2e1ac9e3084d018febf5ac0912a27c72">OHOS::UICheckBox::SetImages</a> (const char *selectedImageSrc, const char *unselectedImageSrc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1524742916084826"><a name="p1524742916084826"></a><a name="p1524742916084826"></a>virtual void&nbsp;</p>
<p id="p1000409345084826"><a name="p1000409345084826"></a><a name="p1000409345084826"></a>Sets the images for this check box. </p>
</td>
</tr>
<tr id="row676996941084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1029697119084826"><a name="p1029697119084826"></a><a name="p1029697119084826"></a><a href="Graphic.md#ga89eb87d02e7b31fc6517b8744751f021">OHOS::UICheckBox::SetImages</a> (const <a href="OHOS-ImageInfo.md">ImageInfo</a> *selectedImageSrc, const <a href="OHOS-ImageInfo.md">ImageInfo</a> *unselectedImageSrc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1114503827084826"><a name="p1114503827084826"></a><a name="p1114503827084826"></a>virtual void&nbsp;</p>
<p id="p1807557729084826"><a name="p1807557729084826"></a><a name="p1807557729084826"></a>Sets the images for this check box. </p>
</td>
</tr>
<tr id="row1758251904084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1916896683084826"><a name="p1916896683084826"></a><a name="p1916896683084826"></a><a href="Graphic.md#gab3cddc176a6834fabc7c53912c97237c">OHOS::UICheckBox::GetState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p994941637084826"><a name="p994941637084826"></a><a name="p994941637084826"></a><a href="Graphic.md#ga15a3f0302aded0e4d1584ddc6002335d">UICheckBoxState</a>&nbsp;</p>
<p id="p1590467662084826"><a name="p1590467662084826"></a><a name="p1590467662084826"></a>Obtains the state of this check box. </p>
</td>
</tr>
<tr id="row2086042547084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1257137377084826"><a name="p1257137377084826"></a><a name="p1257137377084826"></a><a href="Graphic.md#ga32217050815d4d9129ace5ab410fb82d">OHOS::UICheckBox::SetState</a> (<a href="Graphic.md#ga15a3f0302aded0e4d1584ddc6002335d">UICheckBoxState</a> state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2024362474084826"><a name="p2024362474084826"></a><a name="p2024362474084826"></a>void&nbsp;</p>
<p id="p1657768925084826"><a name="p1657768925084826"></a><a name="p1657768925084826"></a>Sets the state for this check box. </p>
</td>
</tr>
<tr id="row490334930084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1239036361084826"><a name="p1239036361084826"></a><a name="p1239036361084826"></a><a href="Graphic.md#gae6d547653f0448f9151fa257cbf9c3ac">OHOS::UICircleProgress::UICircleProgress</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p809636273084826"><a name="p809636273084826"></a><a name="p809636273084826"></a>&nbsp;</p>
<p id="p1287742463084826"><a name="p1287742463084826"></a><a name="p1287742463084826"></a>A constructor used to create a <strong id="b1490525117084826"><a name="b1490525117084826"></a><a name="b1490525117084826"></a><a href="OHOS-UICircleProgress.md">UICircleProgress</a></strong> instance. </p>
</td>
</tr>
<tr id="row1512649208084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1464952145084826"><a name="p1464952145084826"></a><a name="p1464952145084826"></a><a href="Graphic.md#ga10a9da813e933b3513e22a95bb81af98">OHOS::UICircleProgress::~UICircleProgress</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2075105384084826"><a name="p2075105384084826"></a><a name="p2075105384084826"></a>virtual&nbsp;</p>
<p id="p364067868084826"><a name="p364067868084826"></a><a name="p364067868084826"></a>A destructor used to delete the <strong id="b492337279084826"><a name="b492337279084826"></a><a name="b492337279084826"></a><a href="OHOS-UICircleProgress.md">UICircleProgress</a></strong> instance. </p>
</td>
</tr>
<tr id="row1078913915084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p805950598084826"><a name="p805950598084826"></a><a name="p805950598084826"></a><a href="Graphic.md#gab1d8fc06d4a73db344efd271d68a62e6">OHOS::UICircleProgress::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p420246218084826"><a name="p420246218084826"></a><a name="p420246218084826"></a>UIViewType&nbsp;</p>
<p id="p595356326084826"><a name="p595356326084826"></a><a name="p595356326084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row472720757084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p93924406084826"><a name="p93924406084826"></a><a name="p93924406084826"></a><a href="Graphic.md#ga98bc4ea99629e4d5c7ca5ca4b43e8e96">OHOS::UICircleProgress::OnPreDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p283659261084826"><a name="p283659261084826"></a><a name="p283659261084826"></a>bool&nbsp;</p>
<p id="p121731658084826"><a name="p121731658084826"></a><a name="p121731658084826"></a>Called before a view is drawn. This function is used to check whether the parent view of this view needs to be redrawn so as to optimize the drawing process. </p>
</td>
</tr>
<tr id="row394041962084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p802389128084826"><a name="p802389128084826"></a><a name="p802389128084826"></a><a href="Graphic.md#ga611f2f03c22499c428d1de3392ee4861">OHOS::UICircleProgress::OnDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1798388080084826"><a name="p1798388080084826"></a><a name="p1798388080084826"></a>void&nbsp;</p>
<p id="p1349076779084826"><a name="p1349076779084826"></a><a name="p1349076779084826"></a>Called when a view is drawn. </p>
</td>
</tr>
<tr id="row2054951814084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1738368494084826"><a name="p1738368494084826"></a><a name="p1738368494084826"></a><a href="Graphic.md#ga6cf6b8ab0934ce8c0ea1821da0791317">OHOS::UICircleProgress::SetCenterPosition</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p411807399084826"><a name="p411807399084826"></a><a name="p411807399084826"></a>void&nbsp;</p>
<p id="p515430820084826"><a name="p515430820084826"></a><a name="p515430820084826"></a>Sets the coordinates of the center point for this circular progress bar. </p>
</td>
</tr>
<tr id="row2140402503084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2065882770084826"><a name="p2065882770084826"></a><a name="p2065882770084826"></a><a href="Graphic.md#ga706ac374a1383cef01dfc59c5257e480">OHOS::UICircleProgress::GetCenterPosition</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2096802918084826"><a name="p2096802918084826"></a><a name="p2096802918084826"></a><a href="OHOS-Point.md">Point</a>&nbsp;</p>
<p id="p1731341415084826"><a name="p1731341415084826"></a><a name="p1731341415084826"></a>Obtains the coordinates of the center point for this circular progress bar. </p>
</td>
</tr>
<tr id="row1591829386084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1998153111084826"><a name="p1998153111084826"></a><a name="p1998153111084826"></a><a href="Graphic.md#ga80377fb579f6698cefd5fcf74d0cde46">OHOS::UICircleProgress::SetRadius</a> (uint16_t radius)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p93807697084826"><a name="p93807697084826"></a><a name="p93807697084826"></a>void&nbsp;</p>
<p id="p825483075084826"><a name="p825483075084826"></a><a name="p825483075084826"></a>Sets the outer radius for this circular progress bar. </p>
</td>
</tr>
<tr id="row1231163004084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p859464569084826"><a name="p859464569084826"></a><a name="p859464569084826"></a><a href="Graphic.md#gabb2869e683ccd799891a8869613ec8c7">OHOS::UICircleProgress::GetRadius</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2030570621084826"><a name="p2030570621084826"></a><a name="p2030570621084826"></a>uint16_t&nbsp;</p>
<p id="p100581377084826"><a name="p100581377084826"></a><a name="p100581377084826"></a>Obtains the outer radius of this circular progress bar. </p>
</td>
</tr>
<tr id="row56303285084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1990827268084826"><a name="p1990827268084826"></a><a name="p1990827268084826"></a><a href="Graphic.md#gae27e30bd77b83bc55ecc9f2a5643943a">OHOS::UICircleProgress::SetStartAngle</a> (int16_t startAngle)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1875225558084826"><a name="p1875225558084826"></a><a name="p1875225558084826"></a>void&nbsp;</p>
<p id="p863569759084826"><a name="p863569759084826"></a><a name="p863569759084826"></a>Sets the start angle. </p>
</td>
</tr>
<tr id="row355198821084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1335765115084826"><a name="p1335765115084826"></a><a name="p1335765115084826"></a><a href="Graphic.md#ga37a3e63da7a8658e48a25ae9ec73abea">OHOS::UICircleProgress::GetStartAngle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1739672687084826"><a name="p1739672687084826"></a><a name="p1739672687084826"></a>int16_t&nbsp;</p>
<p id="p1159147014084826"><a name="p1159147014084826"></a><a name="p1159147014084826"></a>Obtains the start angle. </p>
</td>
</tr>
<tr id="row690608405084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1268016091084826"><a name="p1268016091084826"></a><a name="p1268016091084826"></a><a href="Graphic.md#ga831186bf208f8236b006b13cc122c82c">OHOS::UICircleProgress::SetEndAngle</a> (int16_t endAngle)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p136230595084826"><a name="p136230595084826"></a><a name="p136230595084826"></a>void&nbsp;</p>
<p id="p1219694266084826"><a name="p1219694266084826"></a><a name="p1219694266084826"></a>Sets the end angle. </p>
</td>
</tr>
<tr id="row699868696084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1952314588084826"><a name="p1952314588084826"></a><a name="p1952314588084826"></a><a href="Graphic.md#gacab2327bfc24ee985818a95d468af181">OHOS::UICircleProgress::GetEndAngle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p422594260084826"><a name="p422594260084826"></a><a name="p422594260084826"></a>int16_t&nbsp;</p>
<p id="p1765934095084826"><a name="p1765934095084826"></a><a name="p1765934095084826"></a>Obtains the end angle. </p>
</td>
</tr>
<tr id="row1844222971084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p814884198084826"><a name="p814884198084826"></a><a name="p814884198084826"></a><a href="Graphic.md#ga62b71500ccc75673be297d2e114c0c1b">OHOS::UICircleProgress::SetProgressImagePosition</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p503036974084826"><a name="p503036974084826"></a><a name="p503036974084826"></a>void&nbsp;</p>
<p id="p1505139560084826"><a name="p1505139560084826"></a><a name="p1505139560084826"></a>Sets the coordinates of the foreground image for this progress bar relative to the view. </p>
</td>
</tr>
<tr id="row455462637084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1769561278084826"><a name="p1769561278084826"></a><a name="p1769561278084826"></a><a href="Graphic.md#ga66b95a4793bc60596a56be00849b8296">OHOS::UICircleProgress::SetBackgroundImagePosition</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p682794060084826"><a name="p682794060084826"></a><a name="p682794060084826"></a>void&nbsp;</p>
<p id="p1374518329084826"><a name="p1374518329084826"></a><a name="p1374518329084826"></a>Sets the coordinates of the background image for this progress bar relative to the view. </p>
</td>
</tr>
<tr id="row2075662547084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1908140943084826"><a name="p1908140943084826"></a><a name="p1908140943084826"></a><a href="Graphic.md#gad0453bc291f75f4864c112f9f2f474db">OHOS::UICircleProgress::SetLineColor</a> (<a href="OHOS-Color32.md">ColorType</a> color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1454355843084826"><a name="p1454355843084826"></a><a name="p1454355843084826"></a>void&nbsp;</p>
<p id="p1919735735084826"><a name="p1919735735084826"></a><a name="p1919735735084826"></a>Sets the foreground color for this progress bar. </p>
</td>
</tr>
<tr id="row453437634084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p847269436084826"><a name="p847269436084826"></a><a name="p847269436084826"></a><a href="Graphic.md#gaeaaddc56316206d4465ce8c927a686b7">OHOS::UIDialog::UIDialog</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1243863812084826"><a name="p1243863812084826"></a><a name="p1243863812084826"></a>&nbsp;</p>
<p id="p754306116084826"><a name="p754306116084826"></a><a name="p754306116084826"></a>A constructor used to create a <strong id="b1120067788084826"><a name="b1120067788084826"></a><a name="b1120067788084826"></a><a href="OHOS-UIDialog.md">UIDialog</a></strong> instance. </p>
</td>
</tr>
<tr id="row1032858036084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p350375619084826"><a name="p350375619084826"></a><a name="p350375619084826"></a><a href="Graphic.md#gae5b58ec7225efdbfaf9947e46bfd2616">OHOS::UIDialog::~UIDialog</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p291511458084826"><a name="p291511458084826"></a><a name="p291511458084826"></a>virtual&nbsp;</p>
<p id="p2061236256084826"><a name="p2061236256084826"></a><a name="p2061236256084826"></a>A destructor used to delete the <strong id="b1780731577084826"><a name="b1780731577084826"></a><a name="b1780731577084826"></a><a href="OHOS-UIDialog.md">UIDialog</a></strong> instance. </p>
</td>
</tr>
<tr id="row1094706853084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p463321898084826"><a name="p463321898084826"></a><a name="p463321898084826"></a><a href="Graphic.md#gac0b18fe28ee4ad44814d3897d3cd5c05">OHOS::UIDialog::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p3741521084826"><a name="p3741521084826"></a><a name="p3741521084826"></a>UIViewType&nbsp;</p>
<p id="p927075939084826"><a name="p927075939084826"></a><a name="p927075939084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row444473184084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p549470436084826"><a name="p549470436084826"></a><a name="p549470436084826"></a><a href="Graphic.md#ga5629d5a1e19bc38087e8b35d65292714">OHOS::UIDialog::SetTitle</a> (const char *title)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2066804897084826"><a name="p2066804897084826"></a><a name="p2066804897084826"></a>void&nbsp;</p>
<p id="p28401366084826"><a name="p28401366084826"></a><a name="p28401366084826"></a>Sets the title for this dialog box. </p>
</td>
</tr>
<tr id="row1131952115084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1727393153084826"><a name="p1727393153084826"></a><a name="p1727393153084826"></a><a href="Graphic.md#ga597e95748fba71238a99c8c17ed848a5">OHOS::UIDialog::SetText</a> (const char *text)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p972559290084826"><a name="p972559290084826"></a><a name="p972559290084826"></a>void&nbsp;</p>
<p id="p682550255084826"><a name="p682550255084826"></a><a name="p682550255084826"></a>Sets the text for this dialog box. </p>
</td>
</tr>
<tr id="row607591995084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1158686381084826"><a name="p1158686381084826"></a><a name="p1158686381084826"></a><a href="Graphic.md#ga6b3cf14760fc07e38f51d366a8e5fdb9">OHOS::UIDialog::OnPreDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p776258158084826"><a name="p776258158084826"></a><a name="p776258158084826"></a>bool&nbsp;</p>
<p id="p964768506084826"><a name="p964768506084826"></a><a name="p964768506084826"></a>Checks whether this label needs to be covered before drawing it. </p>
</td>
</tr>
<tr id="row494101798084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p948716484084826"><a name="p948716484084826"></a><a name="p948716484084826"></a><a href="Graphic.md#gaa8bcf4d2d60becd105d0b87ee2ec18af">OHOS::UIDialog::SetButton</a> (<a href="Graphic.md#ga1bfefa0b46fd5a79a28d0c9a75114295">DialogButtonType</a> buttonType, const char *text, <a href="OHOS-UIView-OnClickListener.md">OnClickListener</a> *listener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1425183389084826"><a name="p1425183389084826"></a><a name="p1425183389084826"></a>void&nbsp;</p>
<p id="p146751516084826"><a name="p146751516084826"></a><a name="p146751516084826"></a>Sets a button for this dialog box. </p>
</td>
</tr>
<tr id="row1585746288084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1116389757084826"><a name="p1116389757084826"></a><a name="p1116389757084826"></a><a href="Graphic.md#gaf836d530b3fa9d50f70053c2b0b528d6">OHOS::UIDialog::SetVisible</a> (bool visible) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1691929063084826"><a name="p1691929063084826"></a><a name="p1691929063084826"></a>void&nbsp;</p>
<p id="p379131594084826"><a name="p379131594084826"></a><a name="p379131594084826"></a>Sets whether a dialog box is visible. </p>
</td>
</tr>
<tr id="row1631881087084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1555467005084826"><a name="p1555467005084826"></a><a name="p1555467005084826"></a><a href="Graphic.md#gac89c3f554cea687e0b7d7338319c8d0b">OHOS::UIDigitalClock::UIDigitalClock</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p253133114084826"><a name="p253133114084826"></a><a name="p253133114084826"></a>&nbsp;</p>
<p id="p757762903084826"><a name="p757762903084826"></a><a name="p757762903084826"></a>A default constructor used to create a <strong id="b173125513084826"><a name="b173125513084826"></a><a name="b173125513084826"></a><a href="OHOS-UIDigitalClock.md">UIDigitalClock</a></strong> instance. </p>
</td>
</tr>
<tr id="row408994279084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p733564526084826"><a name="p733564526084826"></a><a name="p733564526084826"></a><a href="Graphic.md#gaf4daabe77c9ab8264618a4f970b0a15e">OHOS::UIDigitalClock::~UIDigitalClock</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p504286349084826"><a name="p504286349084826"></a><a name="p504286349084826"></a>virtual&nbsp;</p>
<p id="p1838278496084826"><a name="p1838278496084826"></a><a name="p1838278496084826"></a>A destructor used to delete the <strong id="b1146832423084826"><a name="b1146832423084826"></a><a name="b1146832423084826"></a><a href="OHOS-UIDigitalClock.md">UIDigitalClock</a></strong> instance. </p>
</td>
</tr>
<tr id="row910225539084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p384740080084826"><a name="p384740080084826"></a><a name="p384740080084826"></a><a href="Graphic.md#ga567a8195e8520b74b682de697cfe1d90">OHOS::UIDigitalClock::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p175640084826"><a name="p175640084826"></a><a name="p175640084826"></a>UIViewType&nbsp;</p>
<p id="p817278814084826"><a name="p817278814084826"></a><a name="p817278814084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row2065836176084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p31995144084826"><a name="p31995144084826"></a><a name="p31995144084826"></a><a href="Graphic.md#ga9013bc4fa8bfc77cf75b898db1a0fbf6">OHOS::UIDigitalClock::SetFontId</a> (uint8_t fontId)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1020235831084826"><a name="p1020235831084826"></a><a name="p1020235831084826"></a>void&nbsp;</p>
<p id="p1472891574084826"><a name="p1472891574084826"></a><a name="p1472891574084826"></a>Sets the dynamic font ID for this digital clock. </p>
</td>
</tr>
<tr id="row1749404859084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p552138216084826"><a name="p552138216084826"></a><a name="p552138216084826"></a><a href="Graphic.md#gaa41d0c6ab53a4451e9e90199dbaa3895">OHOS::UIDigitalClock::SetFont</a> (const char *name, uint8_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2090751276084826"><a name="p2090751276084826"></a><a name="p2090751276084826"></a>void&nbsp;</p>
<p id="p1400338041084826"><a name="p1400338041084826"></a><a name="p1400338041084826"></a>Sets the dynamic font for this digital clock. </p>
</td>
</tr>
<tr id="row1822474573084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1236354820084826"><a name="p1236354820084826"></a><a name="p1236354820084826"></a><a href="Graphic.md#gaabdefd6f104682c755886594e259e810">OHOS::UIDigitalClock::SetColor</a> (<a href="OHOS-Color32.md">ColorType</a> color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2052491333084826"><a name="p2052491333084826"></a><a name="p2052491333084826"></a>void&nbsp;</p>
<p id="p1539424400084826"><a name="p1539424400084826"></a><a name="p1539424400084826"></a>Sets the font color for this digital clock. </p>
</td>
</tr>
<tr id="row570707757084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p47227822084826"><a name="p47227822084826"></a><a name="p47227822084826"></a><a href="Graphic.md#ga2ac4d800eb47c4238d160819e165a30a">OHOS::UIDigitalClock::SetDisplayMode</a> (<a href="Graphic.md#gabe3b64b11e5bf5d7b54e1039e40f306b">DisplayMode</a> dm)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1973255472084826"><a name="p1973255472084826"></a><a name="p1973255472084826"></a>void&nbsp;</p>
<p id="p27203852084826"><a name="p27203852084826"></a><a name="p27203852084826"></a>Sets the display mode for this digital clock. </p>
</td>
</tr>
<tr id="row681847901084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1524351904084826"><a name="p1524351904084826"></a><a name="p1524351904084826"></a><a href="Graphic.md#ga14a5b4ca3e2eda9ff0f6a7ad2bc11f48">OHOS::UIDigitalClock::GetDisplayMode</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1727902190084826"><a name="p1727902190084826"></a><a name="p1727902190084826"></a><a href="Graphic.md#gabe3b64b11e5bf5d7b54e1039e40f306b">DisplayMode</a>&nbsp;</p>
<p id="p1985926361084826"><a name="p1985926361084826"></a><a name="p1985926361084826"></a>Obtains the display mode of this digital clock. </p>
</td>
</tr>
<tr id="row142266807084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1310826524084826"><a name="p1310826524084826"></a><a name="p1310826524084826"></a><a href="Graphic.md#gaf45e9196d307551e693807cae2f8b4d2">OHOS::UIDigitalClock::DisplayLeadingZero</a> (bool displayLeadingZero)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1794664965084826"><a name="p1794664965084826"></a><a name="p1794664965084826"></a>void&nbsp;</p>
<p id="p1097321785084826"><a name="p1097321785084826"></a><a name="p1097321785084826"></a>Sets whether to add <strong id="b1266589157084826"><a name="b1266589157084826"></a><a name="b1266589157084826"></a>0</strong> before the hour of this digital clock. </p>
</td>
</tr>
<tr id="row958287079084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1851048106084826"><a name="p1851048106084826"></a><a name="p1851048106084826"></a><a href="Graphic.md#ga1565dcdb5ab0403fa477fd74c5920b99">OHOS::UIDigitalClock::SetOpacity</a> (uint8_t opacity)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p54108226084826"><a name="p54108226084826"></a><a name="p54108226084826"></a>void&nbsp;</p>
<p id="p1310523622084826"><a name="p1310523622084826"></a><a name="p1310523622084826"></a>Sets the opacity for this digital clock. </p>
</td>
</tr>
<tr id="row1685724521084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1502284840084826"><a name="p1502284840084826"></a><a name="p1502284840084826"></a><a href="Graphic.md#ga713ec508a94eb05eab0aa5ab1c7f41ca">OHOS::UIDigitalClock::GetOpacity</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p297173701084826"><a name="p297173701084826"></a><a name="p297173701084826"></a>uint8_t&nbsp;</p>
<p id="p461981787084826"><a name="p461981787084826"></a><a name="p461981787084826"></a>Obtains the opacity of this digital clock. </p>
</td>
</tr>
<tr id="row534130072084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2051695102084826"><a name="p2051695102084826"></a><a name="p2051695102084826"></a><a href="Graphic.md#ga386c03c483ef38cb5310563b6ba9bc02">OHOS::UIDigitalClock::UpdateClock</a> (bool clockInit) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1448661901084826"><a name="p1448661901084826"></a><a name="p1448661901084826"></a>void&nbsp;</p>
<p id="p2146353847084826"><a name="p2146353847084826"></a><a name="p2146353847084826"></a>Updates this digital clock. </p>
</td>
</tr>
<tr id="row657742351084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p999943533084826"><a name="p999943533084826"></a><a name="p999943533084826"></a><a href="Graphic.md#ga0506b7e6730f07b6e78371b479326b54">OHOS::UIImageAnimatorView::UIImageAnimatorView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p281652873084826"><a name="p281652873084826"></a><a name="p281652873084826"></a>&nbsp;</p>
<p id="p1420292824084826"><a name="p1420292824084826"></a><a name="p1420292824084826"></a>A constructor used to create a <strong id="b72021024084826"><a name="b72021024084826"></a><a name="b72021024084826"></a><a href="OHOS-UIImageAnimatorView.md">UIImageAnimatorView</a></strong> instance. </p>
</td>
</tr>
<tr id="row131781727084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1008162033084826"><a name="p1008162033084826"></a><a name="p1008162033084826"></a><a href="Graphic.md#ga72c8450b3c27dd0429691667a6d66dd1">OHOS::UIImageAnimatorView::~UIImageAnimatorView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p475883808084826"><a name="p475883808084826"></a><a name="p475883808084826"></a>virtual&nbsp;</p>
<p id="p500221740084826"><a name="p500221740084826"></a><a name="p500221740084826"></a>A destructor used to delete the <strong id="b1091966141084826"><a name="b1091966141084826"></a><a name="b1091966141084826"></a><a href="OHOS-UIImageAnimatorView.md">UIImageAnimatorView</a></strong> instance. </p>
</td>
</tr>
<tr id="row2061553009084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1935839568084826"><a name="p1935839568084826"></a><a name="p1935839568084826"></a><a href="Graphic.md#ga831167c9f5000af808638eac56d6ec19">OHOS::UIImageAnimatorView::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p977525889084826"><a name="p977525889084826"></a><a name="p977525889084826"></a>UIViewType&nbsp;</p>
<p id="p2044187208084826"><a name="p2044187208084826"></a><a name="p2044187208084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row9114704084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p443734993084826"><a name="p443734993084826"></a><a name="p443734993084826"></a><a href="Graphic.md#ga6d585adbcbd0d236df848b48ff1b7ece">OHOS::UIImageAnimatorView::SetImageAnimatorSrc</a> (const char *imageSrc, uint8_t imageNum, uint16_t timeOfUpdate)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p88740233084826"><a name="p88740233084826"></a><a name="p88740233084826"></a>void&nbsp;</p>
<p id="p1597339260084826"><a name="p1597339260084826"></a><a name="p1597339260084826"></a>Sets the images and speed for this animator. </p>
</td>
</tr>
<tr id="row2135680156084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p284947330084826"><a name="p284947330084826"></a><a name="p284947330084826"></a><a href="Graphic.md#ga4b2c4bc9d0ab881439d5ec728adc0b1a">OHOS::UIImageAnimatorView::SetImageAnimatorSrc</a> (const char *imageSrc, uint8_t imageNum)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p283711268084826"><a name="p283711268084826"></a><a name="p283711268084826"></a>void&nbsp;</p>
<p id="p1361201621084826"><a name="p1361201621084826"></a><a name="p1361201621084826"></a>Sets the images for this animator. </p>
</td>
</tr>
<tr id="row902559614084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p452723552084826"><a name="p452723552084826"></a><a name="p452723552084826"></a><a href="Graphic.md#ga0ee52a2ca252957199034c1234dc4f64">OHOS::UIImageAnimatorView::SetTimeOfUpdate</a> (uint16_t timeOfUpdate)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1360496241084826"><a name="p1360496241084826"></a><a name="p1360496241084826"></a>void&nbsp;</p>
<p id="p2020226543084826"><a name="p2020226543084826"></a><a name="p2020226543084826"></a>Sets the speed for this animator. </p>
</td>
</tr>
<tr id="row2144337851084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p464547350084826"><a name="p464547350084826"></a><a name="p464547350084826"></a><a href="Graphic.md#ga24411b0b4d9f619532aa879ee6ee7af1">OHOS::UIImageAnimatorView::GetTimeOfUpdate</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p942340486084826"><a name="p942340486084826"></a><a name="p942340486084826"></a>uint16_t&nbsp;</p>
<p id="p522397868084826"><a name="p522397868084826"></a><a name="p522397868084826"></a>Obtains the speed of this animator. </p>
</td>
</tr>
<tr id="row1433319418084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1777799813084826"><a name="p1777799813084826"></a><a name="p1777799813084826"></a><a href="Graphic.md#gad4bd7aaf1100aac86a2cde8728ae8ee0">OHOS::UIImageAnimatorView::SetTimeOfPause</a> (uint16_t timeOfPause)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1773081176084826"><a name="p1773081176084826"></a><a name="p1773081176084826"></a>void&nbsp;</p>
<p id="p1384637291084826"><a name="p1384637291084826"></a><a name="p1384637291084826"></a>Sets the interval between two playbacks of an infinitely repeated animator. </p>
</td>
</tr>
<tr id="row929691138084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1072103521084826"><a name="p1072103521084826"></a><a name="p1072103521084826"></a><a href="Graphic.md#ga8bd6ba744209193fd1f3e630e6cf1c5a">OHOS::UIImageAnimatorView::GetTimeOfPause</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p770898966084826"><a name="p770898966084826"></a><a name="p770898966084826"></a>uint16_t&nbsp;</p>
<p id="p477251271084826"><a name="p477251271084826"></a><a name="p477251271084826"></a>Obtains the interval between two playbacks of an infinitely repeated animator. </p>
</td>
</tr>
<tr id="row2115648373084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p750414431084826"><a name="p750414431084826"></a><a name="p750414431084826"></a><a href="Graphic.md#gadc1064a27f9b95a2797c33793b2110ee">OHOS::UIImageAnimatorView::GetImageAnimatorSrc</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1624099773084826"><a name="p1624099773084826"></a><a name="p1624099773084826"></a>const <a href="OHOS-ImageAnimatorInfo.md">ImageAnimatorInfo</a> *&nbsp;</p>
<p id="p1125690709084826"><a name="p1125690709084826"></a><a name="p1125690709084826"></a>Obtains the image array of this frame animator. </p>
</td>
</tr>
<tr id="row1716008876084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p214927505084826"><a name="p214927505084826"></a><a name="p214927505084826"></a><a href="Graphic.md#ga1da191cab1e6b4ffb3a87b50fbe4f7ed">OHOS::UIImageAnimatorView::GetImageAnimatorImageNum</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p68227812084826"><a name="p68227812084826"></a><a name="p68227812084826"></a>uint8_t&nbsp;</p>
<p id="p90164825084826"><a name="p90164825084826"></a><a name="p90164825084826"></a>Obtains the number of images. </p>
</td>
</tr>
<tr id="row1823962921084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p444222998084826"><a name="p444222998084826"></a><a name="p444222998084826"></a><a href="Graphic.md#ga0e41547fd9d55ff85d6b800e59957370">OHOS::UIImageAnimatorView::SetSizeFixed</a> (bool fixed)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p693889928084826"><a name="p693889928084826"></a><a name="p693889928084826"></a>void&nbsp;</p>
<p id="p78089215084826"><a name="p78089215084826"></a><a name="p78089215084826"></a>Sets whether the image size is fixed to the view size. </p>
</td>
</tr>
<tr id="row1050275067084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p186187834084826"><a name="p186187834084826"></a><a name="p186187834084826"></a><a href="Graphic.md#gabf4bad201ee9ef8aa484677b1daa3ba4">OHOS::UIImageAnimatorView::IsSizeFixed</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1661222009084826"><a name="p1661222009084826"></a><a name="p1661222009084826"></a>bool&nbsp;</p>
<p id="p1586537965084826"><a name="p1586537965084826"></a><a name="p1586537965084826"></a>Checks whether the image size is fixed to the view size. </p>
</td>
</tr>
<tr id="row483735458084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1917571666084826"><a name="p1917571666084826"></a><a name="p1917571666084826"></a><a href="Graphic.md#ga0368d596c01e1a6093d7476fce548a38">OHOS::UIImageAnimatorView::SetRepeat</a> (bool repeat)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p313330278084826"><a name="p313330278084826"></a><a name="p313330278084826"></a>void&nbsp;</p>
<p id="p1257937820084826"><a name="p1257937820084826"></a><a name="p1257937820084826"></a>Sets whether to play this animator for infinite times. </p>
</td>
</tr>
<tr id="row1163157809084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1788202344084826"><a name="p1788202344084826"></a><a name="p1788202344084826"></a><a href="Graphic.md#ga5e3700fe3d572ed6329237480bd4b5d2">OHOS::UIImageAnimatorView::IsRepeat</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1723725343084826"><a name="p1723725343084826"></a><a name="p1723725343084826"></a>bool&nbsp;</p>
<p id="p1390737432084826"><a name="p1390737432084826"></a><a name="p1390737432084826"></a>Checks whether this animator is played for infinite times. </p>
</td>
</tr>
<tr id="row1338099549084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p655889551084826"><a name="p655889551084826"></a><a name="p655889551084826"></a><a href="Graphic.md#ga8d0a02c46af6bea17323c715620b6212">OHOS::UIImageAnimatorView::SetRepeatTimes</a> (uint32_t <a href="TIME.md#gad8751576e987b576f4e6e42f9b42fec9">times</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1573178296084826"><a name="p1573178296084826"></a><a name="p1573178296084826"></a>void&nbsp;</p>
<p id="p1728992334084826"><a name="p1728992334084826"></a><a name="p1728992334084826"></a>Sets the playback times for this animator. </p>
</td>
</tr>
<tr id="row1478838753084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1350728627084826"><a name="p1350728627084826"></a><a name="p1350728627084826"></a><a href="Graphic.md#gae900ab627983fb255dc0d1672c1f3a03">OHOS::UIImageAnimatorView::GetRepeatTimes</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p557411285084826"><a name="p557411285084826"></a><a name="p557411285084826"></a>uint32_t&nbsp;</p>
<p id="p1760199600084826"><a name="p1760199600084826"></a><a name="p1760199600084826"></a>Obtains the playback times. </p>
</td>
</tr>
<tr id="row429177430084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1374401733084826"><a name="p1374401733084826"></a><a name="p1374401733084826"></a><a href="Graphic.md#gaad46659a26146d0edccad42f45f85d6c">OHOS::UIImageAnimatorView::GetState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p440871483084826"><a name="p440871483084826"></a><a name="p440871483084826"></a>uint8_t&nbsp;</p>
<p id="p2102336514084826"><a name="p2102336514084826"></a><a name="p2102336514084826"></a>Obtains the current state of this animator. </p>
</td>
</tr>
<tr id="row2047588785084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1437751529084826"><a name="p1437751529084826"></a><a name="p1437751529084826"></a><a href="Graphic.md#ga38a53936c930f4d75ccd9d9c6a5b9afa">OHOS::UIImageAnimatorView::SetReverse</a> (bool reverse)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1485252806084826"><a name="p1485252806084826"></a><a name="p1485252806084826"></a>void&nbsp;</p>
<p id="p1232756465084826"><a name="p1232756465084826"></a><a name="p1232756465084826"></a>Sets the playback sequence for this animator. </p>
</td>
</tr>
<tr id="row350889408084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1169752213084826"><a name="p1169752213084826"></a><a name="p1169752213084826"></a><a href="Graphic.md#ga35b508048046b7adf938de5cc4004724">OHOS::UIImageAnimatorView::IsReverse</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1276444596084826"><a name="p1276444596084826"></a><a name="p1276444596084826"></a>bool&nbsp;</p>
<p id="p788011042084826"><a name="p788011042084826"></a><a name="p788011042084826"></a>Obtains the playback sequence of this animator. </p>
</td>
</tr>
<tr id="row659478979084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2122079712084826"><a name="p2122079712084826"></a><a name="p2122079712084826"></a><a href="Graphic.md#ga99fb1b9b27ee65f812085f93e05330a6">OHOS::UIImageAnimatorView::Start</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1423985800084826"><a name="p1423985800084826"></a><a name="p1423985800084826"></a>void&nbsp;</p>
<p id="p760570031084826"><a name="p760570031084826"></a><a name="p760570031084826"></a>Starts this animator. </p>
</td>
</tr>
<tr id="row942673430084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p966491498084826"><a name="p966491498084826"></a><a name="p966491498084826"></a><a href="Graphic.md#ga1887f1afd8e85c0a9c781e182fe5afc3">OHOS::UIImageAnimatorView::Stop</a> (bool needReset=true)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1168445661084826"><a name="p1168445661084826"></a><a name="p1168445661084826"></a>void&nbsp;</p>
<p id="p1168498555084826"><a name="p1168498555084826"></a><a name="p1168498555084826"></a>Stops this animator. </p>
</td>
</tr>
<tr id="row761472862084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p898807876084826"><a name="p898807876084826"></a><a name="p898807876084826"></a><a href="Graphic.md#gab8af32245cdf31fcc0a9d0a5d681774c">OHOS::UIImageAnimatorView::Pause</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1823460708084826"><a name="p1823460708084826"></a><a name="p1823460708084826"></a>void&nbsp;</p>
<p id="p111750583084826"><a name="p111750583084826"></a><a name="p111750583084826"></a>Pauses this animator at the current image. </p>
</td>
</tr>
<tr id="row57494744084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1545477647084826"><a name="p1545477647084826"></a><a name="p1545477647084826"></a><a href="Graphic.md#ga051f03136d8c00295162f53acbe6da97">OHOS::UIImageAnimatorView::Resume</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1589899481084826"><a name="p1589899481084826"></a><a name="p1589899481084826"></a>void&nbsp;</p>
<p id="p1369584216084826"><a name="p1369584216084826"></a><a name="p1369584216084826"></a>Resumes this animator from the current image. </p>
</td>
</tr>
<tr id="row1853530296084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p888064228084826"><a name="p888064228084826"></a><a name="p888064228084826"></a><a href="Graphic.md#gaafa8a44fe38db14ab7e8f72e4d3c8581">OHOS::UIImageAnimatorView::AnimatorStopListener::~AnimatorStopListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p435411189084826"><a name="p435411189084826"></a><a name="p435411189084826"></a>virtual&nbsp;</p>
<p id="p2069764951084826"><a name="p2069764951084826"></a><a name="p2069764951084826"></a>A destructor used to delete an <strong id="b340370456084826"><a name="b340370456084826"></a><a name="b340370456084826"></a><a href="OHOS-UIImageAnimatorView-AnimatorStopListener.md">AnimatorStopListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row363608535084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1743597442084826"><a name="p1743597442084826"></a><a name="p1743597442084826"></a><a href="Graphic.md#gac5f2c1471f83ebf2a47d86b8f58da094">OHOS::UIImageAnimatorView::AnimatorStopListener::OnAnimatorStop</a> (<a href="OHOS-UIView.md">UIView</a> &amp;view)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p898520056084826"><a name="p898520056084826"></a><a name="p898520056084826"></a>virtual void&nbsp;</p>
<p id="p820289663084826"><a name="p820289663084826"></a><a name="p820289663084826"></a>Called when this animator stops. </p>
</td>
</tr>
<tr id="row327575084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1002136669084826"><a name="p1002136669084826"></a><a name="p1002136669084826"></a><a href="Graphic.md#ga80b4b917c30226c1b1f7169e3eb8ed8d">OHOS::UIImageAnimatorView::SetAnimatorStopListener</a> (<a href="OHOS-UIImageAnimatorView-AnimatorStopListener.md">AnimatorStopListener</a> *listener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p984386949084826"><a name="p984386949084826"></a><a name="p984386949084826"></a>void&nbsp;</p>
<p id="p970376888084826"><a name="p970376888084826"></a><a name="p970376888084826"></a>Sets the listener for the stop of this animator. </p>
</td>
</tr>
<tr id="row672360245084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p55950380084826"><a name="p55950380084826"></a><a name="p55950380084826"></a><a href="Graphic.md#ga3db47186dbc7a0cb996c23abcdaf2c38">OHOS::UIImageView::UIImageView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1492885060084826"><a name="p1492885060084826"></a><a name="p1492885060084826"></a>&nbsp;</p>
<p id="p1654379564084826"><a name="p1654379564084826"></a><a name="p1654379564084826"></a>A default constructor used to create a <strong id="b1125002787084826"><a name="b1125002787084826"></a><a name="b1125002787084826"></a><a href="OHOS-UIImageView.md">UIImageView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1928251895084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2058565271084826"><a name="p2058565271084826"></a><a name="p2058565271084826"></a><a href="Graphic.md#ga8be6fe17af73ab21f97effa26dbacaca">OHOS::UIImageView::~UIImageView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p933018829084826"><a name="p933018829084826"></a><a name="p933018829084826"></a>virtual&nbsp;</p>
<p id="p2112732007084826"><a name="p2112732007084826"></a><a name="p2112732007084826"></a>A destructor used to delete the <strong id="b1963308946084826"><a name="b1963308946084826"></a><a name="b1963308946084826"></a><a href="OHOS-UIImageView.md">UIImageView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1774710144084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1275403929084826"><a name="p1275403929084826"></a><a name="p1275403929084826"></a><a href="Graphic.md#ga5dc99855271c582e960e0952cca8227c">OHOS::UIImageView::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p402226007084826"><a name="p402226007084826"></a><a name="p402226007084826"></a>UIViewType&nbsp;</p>
<p id="p1171475782084826"><a name="p1171475782084826"></a><a name="p1171475782084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row998611352084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p458369251084826"><a name="p458369251084826"></a><a name="p458369251084826"></a><a href="Graphic.md#ga20ea7dd2d8ddb16cf9750ccdcc2a2803">OHOS::UIImageView::GetWidth</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1654601563084826"><a name="p1654601563084826"></a><a name="p1654601563084826"></a>int16_t&nbsp;</p>
<p id="p697032496084826"><a name="p697032496084826"></a><a name="p697032496084826"></a>Obtains the width of this image view. </p>
</td>
</tr>
<tr id="row1588651094084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p547804068084826"><a name="p547804068084826"></a><a name="p547804068084826"></a><a href="Graphic.md#gaddc6e68c67782eaad40977c6c2256cdd">OHOS::UIImageView::GetHeight</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1969288487084826"><a name="p1969288487084826"></a><a name="p1969288487084826"></a>int16_t&nbsp;</p>
<p id="p1837823206084826"><a name="p1837823206084826"></a><a name="p1837823206084826"></a>Obtains the height of this image view. </p>
</td>
</tr>
<tr id="row507770227084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1651778372084826"><a name="p1651778372084826"></a><a name="p1651778372084826"></a><a href="Graphic.md#ga5d79816831f61406c1c8bd300da9973e">OHOS::UIImageView::OnPreDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1631901156084826"><a name="p1631901156084826"></a><a name="p1631901156084826"></a>bool&nbsp;</p>
<p id="p1487980566084826"><a name="p1487980566084826"></a><a name="p1487980566084826"></a>Checks whether this image view needs to be covered to optimize the drawing process. </p>
</td>
</tr>
<tr id="row1028430374084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1963468132084826"><a name="p1963468132084826"></a><a name="p1963468132084826"></a><a href="Graphic.md#ga565cecb8ac66f2009dc4783da9bdc699">OHOS::UIImageView::OnDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1356206654084826"><a name="p1356206654084826"></a><a name="p1356206654084826"></a>void&nbsp;</p>
<p id="p1358265545084826"><a name="p1358265545084826"></a><a name="p1358265545084826"></a>Draws this image view. </p>
</td>
</tr>
<tr id="row1199563532084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1626475593084826"><a name="p1626475593084826"></a><a name="p1626475593084826"></a><a href="Graphic.md#ga4e2dac4fd52a54a828f13db5ab51d110">OHOS::UIImageView::SetSrc</a> (const char *src)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1950453921084826"><a name="p1950453921084826"></a><a name="p1950453921084826"></a>void&nbsp;</p>
<p id="p208976036084826"><a name="p208976036084826"></a><a name="p208976036084826"></a>Sets the image path. </p>
</td>
</tr>
<tr id="row1320404078084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1405600241084826"><a name="p1405600241084826"></a><a name="p1405600241084826"></a><a href="Graphic.md#ga18a9eed434132ac60c127ca1fc03e663">OHOS::UIImageView::SetSrc</a> (const <a href="OHOS-ImageInfo.md">ImageInfo</a> *src)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p838767739084826"><a name="p838767739084826"></a><a name="p838767739084826"></a>void&nbsp;</p>
<p id="p1323826220084826"><a name="p1323826220084826"></a><a name="p1323826220084826"></a>Sets the image information. </p>
</td>
</tr>
<tr id="row132529973084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2082613743084826"><a name="p2082613743084826"></a><a name="p2082613743084826"></a><a href="Graphic.md#gab3f60d7eff9b467c64edc90293dbb21d">OHOS::UIImageView::SetAutoEnable</a> (bool enable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p315284834084826"><a name="p315284834084826"></a><a name="p315284834084826"></a>void&nbsp;</p>
<p id="p547640828084826"><a name="p547640828084826"></a><a name="p547640828084826"></a>Sets whether the image view size needs to be adaptive to the image size. </p>
</td>
</tr>
<tr id="row1719281117084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1406540884084826"><a name="p1406540884084826"></a><a name="p1406540884084826"></a><a href="Graphic.md#ga339c80c2f8f05ff0d79638dc61c71d5a">OHOS::UIImageView::SetBlurLevel</a> (BlurLevel level)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p432184101084826"><a name="p432184101084826"></a><a name="p432184101084826"></a>void&nbsp;</p>
<p id="p558220615084826"><a name="p558220615084826"></a><a name="p558220615084826"></a>Sets the blur level for this image when it is rotated or scaled. </p>
</td>
</tr>
<tr id="row238599783084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1915173272084826"><a name="p1915173272084826"></a><a name="p1915173272084826"></a><a href="Graphic.md#ga8c891ce7719b97f6d49b0554caa371cb">OHOS::UIImageView::GetBlurLevel</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p883538321084826"><a name="p883538321084826"></a><a name="p883538321084826"></a>BlurLevel&nbsp;</p>
<p id="p1755532808084826"><a name="p1755532808084826"></a><a name="p1755532808084826"></a>Obtains the blur level of this image when it is rotated or scaled. </p>
</td>
</tr>
<tr id="row981740609084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p296002725084826"><a name="p296002725084826"></a><a name="p296002725084826"></a><a href="Graphic.md#gacd3bafd7cd7dfb83d46d4fae36eae612">OHOS::UIImageView::SetTransformAlgorithm</a> (TransformAlgorithm algorithm)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p631996233084826"><a name="p631996233084826"></a><a name="p631996233084826"></a>void&nbsp;</p>
<p id="p1931826190084826"><a name="p1931826190084826"></a><a name="p1931826190084826"></a>Sets the algorithm used for image rotation and scaling. </p>
</td>
</tr>
<tr id="row1639212373084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1884498866084826"><a name="p1884498866084826"></a><a name="p1884498866084826"></a><a href="Graphic.md#gac7b75c6fa653d3ac0c8bc9062939d293">OHOS::UIImageView::GetTransformAlgorithm</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p899784432084826"><a name="p899784432084826"></a><a name="p899784432084826"></a>TransformAlgorithm&nbsp;</p>
<p id="p1496376243084826"><a name="p1496376243084826"></a><a name="p1496376243084826"></a>Obtains the algorithm used for image rotation and scaling. </p>
</td>
</tr>
<tr id="row68615481084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p625963902084826"><a name="p625963902084826"></a><a name="p625963902084826"></a><a href="Graphic.md#ga3824befafd4f4dda003195ca2bbef399">OHOS::UIImageView::GetPath</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1555434413084826"><a name="p1555434413084826"></a><a name="p1555434413084826"></a>const char *&nbsp;</p>
<p id="p1081838496084826"><a name="p1081838496084826"></a><a name="p1081838496084826"></a>获取图片路径 </p>
</td>
</tr>
<tr id="row389907910084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p6182428084826"><a name="p6182428084826"></a><a name="p6182428084826"></a><a href="Graphic.md#gaa9fbde27be3e3ea2fc6b4dabbf588af8">OHOS::UIImageView::GetImageInfo</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1376362217084826"><a name="p1376362217084826"></a><a name="p1376362217084826"></a>const <a href="OHOS-ImageInfo.md">ImageInfo</a> *&nbsp;</p>
<p id="p1829793032084826"><a name="p1829793032084826"></a><a name="p1829793032084826"></a>获取图片信息 </p>
</td>
</tr>
<tr id="row357348657084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p608094425084826"><a name="p608094425084826"></a><a name="p608094425084826"></a><a href="Graphic.md#ga07da08c8507a3dbee5c21ea0de170a16">OHOS::UIImageView::GetSrcType</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p85906041084826"><a name="p85906041084826"></a><a name="p85906041084826"></a>uint8_t&nbsp;</p>
<p id="p285956860084826"><a name="p285956860084826"></a><a name="p285956860084826"></a>获取图片类型 </p>
</td>
</tr>
<tr id="row2034212463084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1691534985084826"><a name="p1691534985084826"></a><a name="p1691534985084826"></a><a href="Graphic.md#ga7e145ba3fb7b78ecefa1018a9540be32">OHOS::UILabel::UILabel</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1782946134084826"><a name="p1782946134084826"></a><a name="p1782946134084826"></a>&nbsp;</p>
<p id="p464824840084826"><a name="p464824840084826"></a><a name="p464824840084826"></a>A constructor used to create a <strong id="b1216000565084826"><a name="b1216000565084826"></a><a name="b1216000565084826"></a><a href="OHOS-UILabel.md">UILabel</a></strong> instance. </p>
</td>
</tr>
<tr id="row441414283084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1956875509084826"><a name="p1956875509084826"></a><a name="p1956875509084826"></a><a href="Graphic.md#ga8509fa2391e0ddd37faed27e35845fc5">OHOS::UILabel::~UILabel</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2112658742084826"><a name="p2112658742084826"></a><a name="p2112658742084826"></a>virtual&nbsp;</p>
<p id="p448814182084826"><a name="p448814182084826"></a><a name="p448814182084826"></a>A destructor used to delete the <strong id="b996212207084826"><a name="b996212207084826"></a><a name="b996212207084826"></a><a href="OHOS-UILabel.md">UILabel</a></strong> instance. </p>
</td>
</tr>
<tr id="row604593375084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1724702879084826"><a name="p1724702879084826"></a><a name="p1724702879084826"></a><a href="Graphic.md#gaebb514dc68a761c444af0e0e89dfcb6f">OHOS::UILabel::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p844389184084826"><a name="p844389184084826"></a><a name="p844389184084826"></a>UIViewType&nbsp;</p>
<p id="p593778558084826"><a name="p593778558084826"></a><a name="p593778558084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row747199113084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1164118223084826"><a name="p1164118223084826"></a><a name="p1164118223084826"></a><a href="Graphic.md#ga95bc777cda044ada4401d9c5900226c6">OHOS::UILabel::GetWidth</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p839485354084826"><a name="p839485354084826"></a><a name="p839485354084826"></a>int16_t&nbsp;</p>
<p id="p766294869084826"><a name="p766294869084826"></a><a name="p766294869084826"></a>Obtains the width of this label. </p>
</td>
</tr>
<tr id="row211007717084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1386253359084826"><a name="p1386253359084826"></a><a name="p1386253359084826"></a><a href="Graphic.md#ga148f6d32ed06364dbee0190f6ff77b59">OHOS::UILabel::GetHeight</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1401171024084826"><a name="p1401171024084826"></a><a name="p1401171024084826"></a>int16_t&nbsp;</p>
<p id="p697240162084826"><a name="p697240162084826"></a><a name="p697240162084826"></a>Obtains the height of this label. </p>
</td>
</tr>
<tr id="row1660433720084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p767036630084826"><a name="p767036630084826"></a><a name="p767036630084826"></a><a href="Graphic.md#gaac293fb7f318e1855fba21b740147061">OHOS::UILabel::OnPreDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p276836378084826"><a name="p276836378084826"></a><a name="p276836378084826"></a>bool&nbsp;</p>
<p id="p1566569656084826"><a name="p1566569656084826"></a><a name="p1566569656084826"></a>Checks whether this label needs to be covered before drawing it. </p>
</td>
</tr>
<tr id="row1296849806084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1150437139084826"><a name="p1150437139084826"></a><a name="p1150437139084826"></a><a href="Graphic.md#ga911199741bf792b5de00789b4c8d780d">OHOS::UILabel::OnDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1150147284084826"><a name="p1150147284084826"></a><a name="p1150147284084826"></a>void&nbsp;</p>
<p id="p214200115084826"><a name="p214200115084826"></a><a name="p214200115084826"></a>Draws this label. </p>
</td>
</tr>
<tr id="row535292022084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p558460187084826"><a name="p558460187084826"></a><a name="p558460187084826"></a><a href="Graphic.md#gab1f3eafda465d09aaa886f09db7e47c1">OHOS::UILabel::SetText</a> (const char *text)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p632806760084826"><a name="p632806760084826"></a><a name="p632806760084826"></a>void&nbsp;</p>
<p id="p357945815084826"><a name="p357945815084826"></a><a name="p357945815084826"></a>Sets the text content for this label. </p>
</td>
</tr>
<tr id="row358544541084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p903223946084826"><a name="p903223946084826"></a><a name="p903223946084826"></a><a href="Graphic.md#gafa76232f16f5aad2a84fedbb31c4f0f7">OHOS::UILabel::GetText</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p908461085084826"><a name="p908461085084826"></a><a name="p908461085084826"></a>const char *&nbsp;</p>
<p id="p459012431084826"><a name="p459012431084826"></a><a name="p459012431084826"></a>Obtains the text of this label. </p>
</td>
</tr>
<tr id="row845023141084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p539290214084826"><a name="p539290214084826"></a><a name="p539290214084826"></a><a href="Graphic.md#ga406c7972fbf4950aaa8c4cef8c86acc5">OHOS::UILabel::SetLineBreakMode</a> (const uint8_t lineBreakMode)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p357500401084826"><a name="p357500401084826"></a><a name="p357500401084826"></a>void&nbsp;</p>
<p id="p583362812084826"><a name="p583362812084826"></a><a name="p583362812084826"></a>Sets the line break mode for this text. </p>
</td>
</tr>
<tr id="row1781253198084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2029728514084826"><a name="p2029728514084826"></a><a name="p2029728514084826"></a><a href="Graphic.md#gab8924e40668b2c882d5dac624b49c6e8">OHOS::UILabel::GetLineBreakMode</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1330355606084826"><a name="p1330355606084826"></a><a name="p1330355606084826"></a>uint8_t&nbsp;</p>
<p id="p1858565509084826"><a name="p1858565509084826"></a><a name="p1858565509084826"></a>Obtains the line break mode of this text. </p>
</td>
</tr>
<tr id="row1391165322084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1532530119084826"><a name="p1532530119084826"></a><a name="p1532530119084826"></a><a href="Graphic.md#ga07e45127ac9569064beb2a63753d2673">OHOS::UILabel::SetTextColor</a> (<a href="OHOS-Color32.md">ColorType</a> color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1671262988084826"><a name="p1671262988084826"></a><a name="p1671262988084826"></a>void&nbsp;</p>
<p id="p108733056084826"><a name="p108733056084826"></a><a name="p108733056084826"></a>Sets the color for this text. </p>
</td>
</tr>
<tr id="row2147269221084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2037047867084826"><a name="p2037047867084826"></a><a name="p2037047867084826"></a><a href="Graphic.md#ga963236ec609ea50610f7ef2bf85ea6df">OHOS::UILabel::GetTextColor</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1877794841084826"><a name="p1877794841084826"></a><a name="p1877794841084826"></a><a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p2145381680084826"><a name="p2145381680084826"></a><a name="p2145381680084826"></a>Obtains the color of this text. </p>
</td>
</tr>
<tr id="row1971919847084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1528153758084826"><a name="p1528153758084826"></a><a name="p1528153758084826"></a><a href="Graphic.md#ga889e1adc1a74db59dc161cb7031b1f23">OHOS::UILabel::SetAlign</a> (<a href="Graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a> horizontalAlign, <a href="Graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a> verticalAlign=TEXT_ALIGNMENT_TOP)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1881120482084826"><a name="p1881120482084826"></a><a name="p1881120482084826"></a>void&nbsp;</p>
<p id="p1876564895084826"><a name="p1876564895084826"></a><a name="p1876564895084826"></a>Sets the alignment mode for this text. </p>
</td>
</tr>
<tr id="row323867491084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1550294623084826"><a name="p1550294623084826"></a><a name="p1550294623084826"></a><a href="Graphic.md#ga97a9af1537884de541336633edc54c72">OHOS::UILabel::GetHorAlign</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1444251472084826"><a name="p1444251472084826"></a><a name="p1444251472084826"></a><a href="Graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a>&nbsp;</p>
<p id="p326697193084826"><a name="p326697193084826"></a><a name="p326697193084826"></a>Obtains the horizontal alignment mode. </p>
</td>
</tr>
<tr id="row1266365324084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p416741706084826"><a name="p416741706084826"></a><a name="p416741706084826"></a><a href="Graphic.md#gaf4acdd488481fe6ce0e79eb6a9d35d78">OHOS::UILabel::GetVerAlign</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1442760786084826"><a name="p1442760786084826"></a><a name="p1442760786084826"></a><a href="Graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a>&nbsp;</p>
<p id="p1904275834084826"><a name="p1904275834084826"></a><a name="p1904275834084826"></a>Obtains the vertical alignment mode. </p>
</td>
</tr>
<tr id="row1387047898084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p245233148084826"><a name="p245233148084826"></a><a name="p245233148084826"></a><a href="Graphic.md#ga51d43cfa57f438939627066d66a3f6cb">OHOS::UILabel::SetDirect</a> (<a href="Graphic.md#ga0c108f97781843f67c101b47b6c00cf0">UITextLanguageDirect</a> direct)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1366166637084826"><a name="p1366166637084826"></a><a name="p1366166637084826"></a>void&nbsp;</p>
<p id="p488165573084826"><a name="p488165573084826"></a><a name="p488165573084826"></a>Sets the direction for this text. </p>
</td>
</tr>
<tr id="row1200378776084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p671019548084826"><a name="p671019548084826"></a><a name="p671019548084826"></a><a href="Graphic.md#gab7bbf711b9cd21935a29c4183c249d80">OHOS::UILabel::GetDirect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p243771027084826"><a name="p243771027084826"></a><a name="p243771027084826"></a><a href="Graphic.md#ga0c108f97781843f67c101b47b6c00cf0">UITextLanguageDirect</a>&nbsp;</p>
<p id="p211455132084826"><a name="p211455132084826"></a><a name="p211455132084826"></a>Obtains the direction of this text. </p>
</td>
</tr>
<tr id="row1826472447084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1538815011084826"><a name="p1538815011084826"></a><a name="p1538815011084826"></a><a href="Graphic.md#gaf8b585ae9aa99d4876e1d81c8b193300">OHOS::UILabel::SetFontId</a> (uint8_t fontId)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p543846836084826"><a name="p543846836084826"></a><a name="p543846836084826"></a>void&nbsp;</p>
<p id="p712345760084826"><a name="p712345760084826"></a><a name="p712345760084826"></a>Sets the font ID for this label. </p>
</td>
</tr>
<tr id="row689317850084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p394713252084826"><a name="p394713252084826"></a><a name="p394713252084826"></a><a href="Graphic.md#ga8484c4167b7638b2bbaa10ba447c9a2f">OHOS::UILabel::GetFontId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1612304230084826"><a name="p1612304230084826"></a><a name="p1612304230084826"></a>uint8_t&nbsp;</p>
<p id="p1258125105084826"><a name="p1258125105084826"></a><a name="p1258125105084826"></a>Obtains the font ID composed of font name and size. </p>
</td>
</tr>
<tr id="row1927348504084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p243423208084826"><a name="p243423208084826"></a><a name="p243423208084826"></a><a href="Graphic.md#gad4b6741054c0041c6df365b1d41d49ec">OHOS::UILabel::SetFont</a> (const char *name, uint8_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1303037359084826"><a name="p1303037359084826"></a><a name="p1303037359084826"></a>void&nbsp;</p>
<p id="p353109931084826"><a name="p353109931084826"></a><a name="p353109931084826"></a>Sets the font for this label. </p>
</td>
</tr>
<tr id="row630130652084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1570357266084826"><a name="p1570357266084826"></a><a name="p1570357266084826"></a><a href="Graphic.md#gaf95611590551b86e5e49efce1cab5069">OHOS::UILabel::SetRollSpeed</a> (uint16_t speed)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1629918705084826"><a name="p1629918705084826"></a><a name="p1629918705084826"></a>void&nbsp;</p>
<p id="p439371876084826"><a name="p439371876084826"></a><a name="p439371876084826"></a>Sets the scroll speed for this text. </p>
</td>
</tr>
<tr id="row1585442654084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p780598394084826"><a name="p780598394084826"></a><a name="p780598394084826"></a><a href="Graphic.md#gaff1afb0c1079bbab70c0f012ba62ea88">OHOS::UILabel::GetTextWidth</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2146728936084826"><a name="p2146728936084826"></a><a name="p2146728936084826"></a>uint16_t&nbsp;</p>
<p id="p1812799423084826"><a name="p1812799423084826"></a><a name="p1812799423084826"></a>Obtains the width of this text. </p>
</td>
</tr>
<tr id="row2042036765084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2084609730084826"><a name="p2084609730084826"></a><a name="p2084609730084826"></a><a href="Graphic.md#gaecbce6ea5599f99b1a2b150608cfc9e3">OHOS::UILabel::GetTextHeight</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1463543408084826"><a name="p1463543408084826"></a><a name="p1463543408084826"></a>uint16_t&nbsp;</p>
<p id="p1760773966084826"><a name="p1760773966084826"></a><a name="p1760773966084826"></a>Obtains the height of this text. </p>
</td>
</tr>
<tr id="row1308665395084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2082459656084826"><a name="p2082459656084826"></a><a name="p2082459656084826"></a><a href="Graphic.md#gaeb4eb6f2b82574eb005fdbf17b0b926b">OHOS::UILabel::SetRollStartPos</a> (int16_t pos)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p594295579084826"><a name="p594295579084826"></a><a name="p594295579084826"></a>void&nbsp;</p>
<p id="p981541741084826"><a name="p981541741084826"></a><a name="p981541741084826"></a>Sets the position where this text starts to roll. </p>
</td>
</tr>
<tr id="row1766426042084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2021917451084826"><a name="p2021917451084826"></a><a name="p2021917451084826"></a><a href="Graphic.md#gaa2bb611ed34bcb9fc5eb2d208409ab7a">OHOS::UILabel::GetRollStartPos</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1735124129084826"><a name="p1735124129084826"></a><a name="p1735124129084826"></a>int16_t&nbsp;</p>
<p id="p1441086161084826"><a name="p1441086161084826"></a><a name="p1441086161084826"></a>Obtains the position where this text starts to roll. </p>
</td>
</tr>
<tr id="row521463271084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1118600520084826"><a name="p1118600520084826"></a><a name="p1118600520084826"></a><a href="Graphic.md#ga4000481fca247d526961d9da6809a806">OHOS::UILabel::SetWidth</a> (int16_t width) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p871376377084826"><a name="p871376377084826"></a><a name="p871376377084826"></a>void&nbsp;</p>
<p id="p2039591798084826"><a name="p2039591798084826"></a><a name="p2039591798084826"></a>Sets the width for this label. </p>
</td>
</tr>
<tr id="row1080020732084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p214136566084826"><a name="p214136566084826"></a><a name="p214136566084826"></a><a href="Graphic.md#ga9998ddd0dfc0863d31f931a76f1da033">OHOS::UILabel::SetHeight</a> (int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p883871690084826"><a name="p883871690084826"></a><a name="p883871690084826"></a>void&nbsp;</p>
<p id="p1893282457084826"><a name="p1893282457084826"></a><a name="p1893282457084826"></a>Sets the height for this label. </p>
</td>
</tr>
<tr id="row364358282084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1060669790084826"><a name="p1060669790084826"></a><a name="p1060669790084826"></a><a href="Graphic.md#ga3c8eb22a51f4ec16640f5003c32d0341">OHOS::UILabel::SetTextRotation</a> (LabelRotateDegree angle)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1461171208084826"><a name="p1461171208084826"></a><a name="p1461171208084826"></a>void&nbsp;</p>
<p id="p1367940772084826"><a name="p1367940772084826"></a><a name="p1367940772084826"></a>Sets the clockwise rotation angle for this text. </p>
</td>
</tr>
<tr id="row1518547364084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1754857365084826"><a name="p1754857365084826"></a><a name="p1754857365084826"></a><a href="Graphic.md#ga610cb09fe19aafbb65899b060ee3cac7">OHOS::UILabel::GetTextRotation</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1266388190084826"><a name="p1266388190084826"></a><a name="p1266388190084826"></a>LabelRotateDegree&nbsp;</p>
<p id="p294460808084826"><a name="p294460808084826"></a><a name="p294460808084826"></a>Obtains the clockwise rotation degree of this text. </p>
</td>
</tr>
<tr id="row297072069084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1423838323084826"><a name="p1423838323084826"></a><a name="p1423838323084826"></a><a href="Graphic.md#gaef9e2e7f3a8849875e2a29e961a7e590">OHOS::UILabel::GetTextRotateDegree</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p907237899084826"><a name="p907237899084826"></a><a name="p907237899084826"></a>uint16_t&nbsp;</p>
<p id="p992118522084826"><a name="p992118522084826"></a><a name="p992118522084826"></a>Obtains the number of text rotation degrees. </p>
</td>
</tr>
<tr id="row969580632084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2084599138084826"><a name="p2084599138084826"></a><a name="p2084599138084826"></a><a href="Graphic.md#gadf3e53072501ed36700dea74a3ddbd8f">OHOS::UILabelButton::UILabelButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p890611063084826"><a name="p890611063084826"></a><a name="p890611063084826"></a>&nbsp;</p>
<p id="p1511107898084826"><a name="p1511107898084826"></a><a name="p1511107898084826"></a>A constructor used to create a <strong id="b1504884083084826"><a name="b1504884083084826"></a><a name="b1504884083084826"></a><a href="OHOS-UILabelButton.md">UILabelButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row96912985084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p706158928084826"><a name="p706158928084826"></a><a name="p706158928084826"></a><a href="Graphic.md#ga9c585e4c556a62f44c71d538608544ee">OHOS::UILabelButton::~UILabelButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p664140940084826"><a name="p664140940084826"></a><a name="p664140940084826"></a>virtual&nbsp;</p>
<p id="p1257257524084826"><a name="p1257257524084826"></a><a name="p1257257524084826"></a>A destructor used to delete the <strong id="b1616298797084826"><a name="b1616298797084826"></a><a name="b1616298797084826"></a><a href="OHOS-UILabelButton.md">UILabelButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row1801199512084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1964147958084826"><a name="p1964147958084826"></a><a name="p1964147958084826"></a><a href="Graphic.md#ga159c536c3f826165c26fdabdc87f498a">OHOS::UILabelButton::OnDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p801062987084826"><a name="p801062987084826"></a><a name="p801062987084826"></a>void&nbsp;</p>
<p id="p1886690996084826"><a name="p1886690996084826"></a><a name="p1886690996084826"></a>Draws a label button. </p>
</td>
</tr>
<tr id="row430365287084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1594775737084826"><a name="p1594775737084826"></a><a name="p1594775737084826"></a><a href="Graphic.md#ga7064f161dbf0e539bd089db62339cad8">OHOS::UILabelButton::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p50575099084826"><a name="p50575099084826"></a><a name="p50575099084826"></a>UIViewType&nbsp;</p>
<p id="p1035239447084826"><a name="p1035239447084826"></a><a name="p1035239447084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row1286019673084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p713063550084826"><a name="p713063550084826"></a><a name="p713063550084826"></a><a href="Graphic.md#ga6b5b491c9240a061fc21cf6b98bdaefc">OHOS::UILabelButton::SetText</a> (const char *text)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p765584552084826"><a name="p765584552084826"></a><a name="p765584552084826"></a>void&nbsp;</p>
<p id="p1997451203084826"><a name="p1997451203084826"></a><a name="p1997451203084826"></a>Sets the text for this label button. </p>
</td>
</tr>
<tr id="row846158336084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p996976263084826"><a name="p996976263084826"></a><a name="p996976263084826"></a><a href="Graphic.md#ga8d04dd052b36017d89e52be905b50d62">OHOS::UILabelButton::GetText</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p734133435084826"><a name="p734133435084826"></a><a name="p734133435084826"></a>const char *&nbsp;</p>
<p id="p1940286643084826"><a name="p1940286643084826"></a><a name="p1940286643084826"></a>Obtains the text of this label button. </p>
</td>
</tr>
<tr id="row131847098084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p893145775084826"><a name="p893145775084826"></a><a name="p893145775084826"></a><a href="Graphic.md#gaf97dc0d36701691a001ef3fd9e6e8b4f">OHOS::UILabelButton::SetLablePosition</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p13995686084826"><a name="p13995686084826"></a><a name="p13995686084826"></a>void&nbsp;</p>
<p id="p1372350213084826"><a name="p1372350213084826"></a><a name="p1372350213084826"></a>Sets the position for this label relative to the button holding it. </p>
</td>
</tr>
<tr id="row1688332291084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p646859015084826"><a name="p646859015084826"></a><a name="p646859015084826"></a><a href="Graphic.md#gaf98616000ecd2cbb458d59fa77b7fe60">OHOS::UILabelButton::GetLabelPosition</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p215663965084826"><a name="p215663965084826"></a><a name="p215663965084826"></a><a href="OHOS-Point.md">Point</a>&nbsp;</p>
<p id="p1304295318084826"><a name="p1304295318084826"></a><a name="p1304295318084826"></a>Obtains the position of this label relative to the button holding it. </p>
</td>
</tr>
<tr id="row720021864084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p640689530084826"><a name="p640689530084826"></a><a name="p640689530084826"></a><a href="Graphic.md#gab5625481e1a9cb77f30102c76ec76bdd">OHOS::UILabelButton::SetAlign</a> (<a href="Graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a> align)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2110852122084826"><a name="p2110852122084826"></a><a name="p2110852122084826"></a>void&nbsp;</p>
<p id="p711285209084826"><a name="p711285209084826"></a><a name="p711285209084826"></a>Sets the alignment mode for this text. </p>
</td>
</tr>
<tr id="row1824023031084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2076757837084826"><a name="p2076757837084826"></a><a name="p2076757837084826"></a><a href="Graphic.md#ga94001af31d34b575be3678f06b77f432">OHOS::UILabelButton::GetAlign</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1597421662084826"><a name="p1597421662084826"></a><a name="p1597421662084826"></a><a href="Graphic.md#ga3f99b58f731a37cacde72d5e0c934593">UITextLanguageAlignment</a>&nbsp;</p>
<p id="p927163417084826"><a name="p927163417084826"></a><a name="p927163417084826"></a>Obtains the alignment mode of this text. </p>
</td>
</tr>
<tr id="row1365054614084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1315012234084826"><a name="p1315012234084826"></a><a name="p1315012234084826"></a><a href="Graphic.md#gabdea4ed71d6a22492ff423339cc08d5e">OHOS::UILabelButton::SetDirect</a> (<a href="Graphic.md#ga0c108f97781843f67c101b47b6c00cf0">UITextLanguageDirect</a> direct)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1088157703084826"><a name="p1088157703084826"></a><a name="p1088157703084826"></a>void&nbsp;</p>
<p id="p312455510084826"><a name="p312455510084826"></a><a name="p312455510084826"></a>Sets the direction for this text. </p>
</td>
</tr>
<tr id="row1412377708084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2041167311084826"><a name="p2041167311084826"></a><a name="p2041167311084826"></a><a href="Graphic.md#gac39c029ba83cc256fded96108e299ff5">OHOS::UILabelButton::GetDirect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p359864896084826"><a name="p359864896084826"></a><a name="p359864896084826"></a><a href="Graphic.md#ga0c108f97781843f67c101b47b6c00cf0">UITextLanguageDirect</a>&nbsp;</p>
<p id="p2146757784084826"><a name="p2146757784084826"></a><a name="p2146757784084826"></a>Obtains the direction of this text. </p>
</td>
</tr>
<tr id="row719613598084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1116225846084826"><a name="p1116225846084826"></a><a name="p1116225846084826"></a><a href="Graphic.md#ga66e316e344c0165a6fd3c5083ea523f4">OHOS::UILabelButton::SetLabelStyle</a> (<a href="OHOS-Style.md">Style</a> &amp;labelStyle)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p269700726084826"><a name="p269700726084826"></a><a name="p269700726084826"></a>void&nbsp;</p>
<p id="p1847732134084826"><a name="p1847732134084826"></a><a name="p1847732134084826"></a>Sets the style for this label. </p>
</td>
</tr>
<tr id="row1200697407084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p673440767084826"><a name="p673440767084826"></a><a name="p673440767084826"></a><a href="Graphic.md#gad1d6be2a8aec65bef4c1f598bfde7666">OHOS::UILabelButton::SetLabelStyle</a> (uint8_t key, int64_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p930691900084826"><a name="p930691900084826"></a><a name="p930691900084826"></a>void&nbsp;</p>
<p id="p1258960343084826"><a name="p1258960343084826"></a><a name="p1258960343084826"></a>Sets a style for this label. </p>
</td>
</tr>
<tr id="row562057368084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1586459882084826"><a name="p1586459882084826"></a><a name="p1586459882084826"></a><a href="Graphic.md#gaefaa6ceaa04329594f1539d48fa121f2">OHOS::UILabelButton::GetLabelStyle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p301517709084826"><a name="p301517709084826"></a><a name="p301517709084826"></a>const <a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p345129015084826"><a name="p345129015084826"></a><a name="p345129015084826"></a>Obtains the style of this label. </p>
</td>
</tr>
<tr id="row276439140084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1279343845084826"><a name="p1279343845084826"></a><a name="p1279343845084826"></a><a href="Graphic.md#ga21c71c654974ddb388a1890576966524">OHOS::UILabelButton::GetLabelStyle</a> (uint8_t key) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p287787573084826"><a name="p287787573084826"></a><a name="p287787573084826"></a>int64_t&nbsp;</p>
<p id="p39204437084826"><a name="p39204437084826"></a><a name="p39204437084826"></a>Obtains the value of a style of this label. </p>
</td>
</tr>
<tr id="row1016212183084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p501906844084826"><a name="p501906844084826"></a><a name="p501906844084826"></a><a href="Graphic.md#ga55592f14dc16b1e1ae3fc9ab7ee9a976">OHOS::UILabelButton::SetTextColor</a> (<a href="OHOS-Color32.md">ColorType</a> color)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1059821829084826"><a name="p1059821829084826"></a><a name="p1059821829084826"></a>void&nbsp;</p>
<p id="p1250336622084826"><a name="p1250336622084826"></a><a name="p1250336622084826"></a>Sets the color for this text. </p>
</td>
</tr>
<tr id="row188281291084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1159860153084826"><a name="p1159860153084826"></a><a name="p1159860153084826"></a><a href="Graphic.md#gad84d1829e94b7ec45ab6576bc14c62d0">OHOS::UILabelButton::SetFont</a> (const char *name, uint8_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p267194862084826"><a name="p267194862084826"></a><a name="p267194862084826"></a>void&nbsp;</p>
<p id="p483599207084826"><a name="p483599207084826"></a><a name="p483599207084826"></a>Sets the font for this text. </p>
</td>
</tr>
<tr id="row1012653543084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1330343503084826"><a name="p1330343503084826"></a><a name="p1330343503084826"></a><a href="Graphic.md#ga89cde9550d1bd443dad10d11c5c2fbfc">OHOS::UILabelButton::SetFontId</a> (uint8_t fontId)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p262299351084826"><a name="p262299351084826"></a><a name="p262299351084826"></a>void&nbsp;</p>
<p id="p614333886084826"><a name="p614333886084826"></a><a name="p614333886084826"></a>Sets the font ID. </p>
</td>
</tr>
<tr id="row1539384344084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1104688464084826"><a name="p1104688464084826"></a><a name="p1104688464084826"></a><a href="Graphic.md#ga826c13b3721c17ea43a7ca386a03253c">OHOS::UILabelButton::GetFontId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1853291579084826"><a name="p1853291579084826"></a><a name="p1853291579084826"></a>uint8_t&nbsp;</p>
<p id="p172315213084826"><a name="p172315213084826"></a><a name="p172315213084826"></a>Obtains the font ID. </p>
</td>
</tr>
<tr id="row81526546084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p301130587084826"><a name="p301130587084826"></a><a name="p301130587084826"></a><a href="Graphic.md#gabed0d1b84d44874c94487796be82748f">OHOS::ListScrollListener::ListScrollListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p804556549084826"><a name="p804556549084826"></a><a name="p804556549084826"></a>&nbsp;</p>
<p id="p1468419343084826"><a name="p1468419343084826"></a><a name="p1468419343084826"></a>A constructor used to create a <strong id="b1076205184084826"><a name="b1076205184084826"></a><a name="b1076205184084826"></a><a href="OHOS-ListScrollListener.md">ListScrollListener</a></strong> instance with the default state <strong id="b898833017084826"><a name="b898833017084826"></a><a name="b898833017084826"></a>SCROLL_STATE_STOP</strong>. </p>
</td>
</tr>
<tr id="row661506361084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1139219080084826"><a name="p1139219080084826"></a><a name="p1139219080084826"></a><a href="Graphic.md#gace5864b41e1f07feecb33b3f897fe02d">OHOS::ListScrollListener::~ListScrollListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p487922651084826"><a name="p487922651084826"></a><a name="p487922651084826"></a>virtual&nbsp;</p>
<p id="p265717527084826"><a name="p265717527084826"></a><a name="p265717527084826"></a>A destructor used to delete the <strong id="b437778901084826"><a name="b437778901084826"></a><a name="b437778901084826"></a><a href="OHOS-ListScrollListener.md">ListScrollListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row753433158084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p972227607084826"><a name="p972227607084826"></a><a name="p972227607084826"></a><a href="Graphic.md#gae802e8b4c48f7d416d6809ba8fa89428">OHOS::ListScrollListener::OnScrollStart</a> (int16_t <a href="UTILS.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>, <a href="OHOS-UIView.md">UIView</a> *view)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p748846535084826"><a name="p748846535084826"></a><a name="p748846535084826"></a>virtual void&nbsp;</p>
<p id="p884234145084826"><a name="p884234145084826"></a><a name="p884234145084826"></a>Called when a scroll starts. </p>
</td>
</tr>
<tr id="row1095109750084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1076584290084826"><a name="p1076584290084826"></a><a name="p1076584290084826"></a><a href="Graphic.md#ga74cc55be27bfd4c21f10d859bc1fbd3d">OHOS::ListScrollListener::OnScrollEnd</a> (int16_t <a href="UTILS.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>, <a href="OHOS-UIView.md">UIView</a> *view)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2049874668084826"><a name="p2049874668084826"></a><a name="p2049874668084826"></a>virtual void&nbsp;</p>
<p id="p211562553084826"><a name="p211562553084826"></a><a name="p211562553084826"></a>Called when a scroll ends. </p>
</td>
</tr>
<tr id="row976194381084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1594711154084826"><a name="p1594711154084826"></a><a name="p1594711154084826"></a><a href="Graphic.md#gab6b77fec222bb03439d2d0a37538f1f0">OHOS::ListScrollListener::OnItemSelected</a> (int16_t <a href="UTILS.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>, <a href="OHOS-UIView.md">UIView</a> *view)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p853064035084826"><a name="p853064035084826"></a><a name="p853064035084826"></a>virtual void&nbsp;</p>
<p id="p1892940497084826"><a name="p1892940497084826"></a><a name="p1892940497084826"></a>Called when a new child view is selected at the preset position as this list scrolls. For details about how to set the position, see <strong id="b180093744084826"><a name="b180093744084826"></a><a name="b180093744084826"></a>SetSelectPosition</strong>. </p>
</td>
</tr>
<tr id="row150974665084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p23423949084826"><a name="p23423949084826"></a><a name="p23423949084826"></a><a href="Graphic.md#ga3710c81b7fe02708da391d23cf08ddad">OHOS::ListScrollListener::GetScrollState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p439675873084826"><a name="p439675873084826"></a><a name="p439675873084826"></a>uint8_t&nbsp;</p>
<p id="p366702370084826"><a name="p366702370084826"></a><a name="p366702370084826"></a>Obtains the scroll state of this list. </p>
</td>
</tr>
<tr id="row1758563910084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p635359455084826"><a name="p635359455084826"></a><a name="p635359455084826"></a><a href="Graphic.md#ga56c15f8c21c433c8a08a151e33b521cf">OHOS::UIList::UIList</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1343428810084826"><a name="p1343428810084826"></a><a name="p1343428810084826"></a>&nbsp;</p>
<p id="p1599108531084826"><a name="p1599108531084826"></a><a name="p1599108531084826"></a>A constructor used to create a <strong id="b413359646084826"><a name="b413359646084826"></a><a name="b413359646084826"></a><a href="OHOS-UIList.md">UIList</a></strong> instance in the vertical direction. </p>
</td>
</tr>
<tr id="row1419584513084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p13036197084826"><a name="p13036197084826"></a><a name="p13036197084826"></a><a href="Graphic.md#ga2da1983fedabd5ea06a8a544aeb2cf04">OHOS::UIList::UIList</a> (uint8_t direction)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2007608828084826"><a name="p2007608828084826"></a><a name="p2007608828084826"></a>&nbsp;</p>
<p id="p324625395084826"><a name="p324625395084826"></a><a name="p324625395084826"></a>A constructor used to create a <strong id="b1492670232084826"><a name="b1492670232084826"></a><a name="b1492670232084826"></a><a href="OHOS-UIList.md">UIList</a></strong> instance in the specified direction. </p>
</td>
</tr>
<tr id="row353509768084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p953858102084826"><a name="p953858102084826"></a><a name="p953858102084826"></a><a href="Graphic.md#ga84de0a8214747d118abfd3d1185ffa63">OHOS::UIList::~UIList</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1067241069084826"><a name="p1067241069084826"></a><a name="p1067241069084826"></a>virtual&nbsp;</p>
<p id="p1674013336084826"><a name="p1674013336084826"></a><a name="p1674013336084826"></a>A destructor used to delete the <strong id="b907215612084826"><a name="b907215612084826"></a><a name="b907215612084826"></a><a href="OHOS-UIList.md">UIList</a></strong> instance. </p>
</td>
</tr>
<tr id="row1224617836084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1233567372084826"><a name="p1233567372084826"></a><a name="p1233567372084826"></a><a href="Graphic.md#ga6e11e5de67f87ed6cf6c44f60b7d4096">OHOS::UIList::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1848946798084826"><a name="p1848946798084826"></a><a name="p1848946798084826"></a>UIViewType&nbsp;</p>
<p id="p1916424422084826"><a name="p1916424422084826"></a><a name="p1916424422084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row73662243084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p518991948084826"><a name="p518991948084826"></a><a name="p518991948084826"></a><a href="Graphic.md#ga7e99d1fb891879195c19c211c6de6600">OHOS::UIList::OnDragEvent</a> (const <a href="OHOS-DragEvent.md">DragEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p230065221084826"><a name="p230065221084826"></a><a name="p230065221084826"></a>bool&nbsp;</p>
<p id="p750921030084826"><a name="p750921030084826"></a><a name="p750921030084826"></a>Called when the view is being dragged. </p>
</td>
</tr>
<tr id="row1876965923084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1154477915084826"><a name="p1154477915084826"></a><a name="p1154477915084826"></a><a href="Graphic.md#ga225e59d60271c9012a017136d2aab0d6">OHOS::UIList::OnDragEndEvent</a> (const <a href="OHOS-DragEvent.md">DragEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p337086532084826"><a name="p337086532084826"></a><a name="p337086532084826"></a>bool&nbsp;</p>
<p id="p971351910084826"><a name="p971351910084826"></a><a name="p971351910084826"></a>Called when the view stops dragging. </p>
</td>
</tr>
<tr id="row1652178303084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p719722554084826"><a name="p719722554084826"></a><a name="p719722554084826"></a><a href="Graphic.md#gaa6ba86e78d4a12ea47b6aaa8dd88f882">OHOS::UIList::OnPressEvent</a> (const <a href="OHOS-PressEvent.md">PressEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p181923544084826"><a name="p181923544084826"></a><a name="p181923544084826"></a>void&nbsp;</p>
<p id="p1763591429084826"><a name="p1763591429084826"></a><a name="p1763591429084826"></a>Called when the view is pressed. </p>
</td>
</tr>
<tr id="row431209302084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1264364955084826"><a name="p1264364955084826"></a><a name="p1264364955084826"></a><a href="Graphic.md#gaa44fd515481de0f1de5d20a62be63267">OHOS::UIList::SetAdapter</a> (<a href="OHOS-AbstractAdapter.md">AbstractAdapter</a> *adapter)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p419143906084826"><a name="p419143906084826"></a><a name="p419143906084826"></a>void&nbsp;</p>
<p id="p525398077084826"><a name="p525398077084826"></a><a name="p525398077084826"></a>Sets the adapter for this list. The content of this list is initialized when the adapter is set. </p>
</td>
</tr>
<tr id="row728105319084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p864896956084826"><a name="p864896956084826"></a><a name="p864896956084826"></a><a href="Graphic.md#gafe121e0cc150122486049dcaf83f3c26">OHOS::UIList::MoveChildByOffset</a> (int16_t x, int16_t y) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1080907349084826"><a name="p1080907349084826"></a><a name="p1080907349084826"></a>virtual void&nbsp;</p>
<p id="p1806272097084826"><a name="p1806272097084826"></a><a name="p1806272097084826"></a>Moves the position of all child views. </p>
</td>
</tr>
<tr id="row2023118042084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p469155843084826"><a name="p469155843084826"></a><a name="p469155843084826"></a><a href="Graphic.md#ga9a760e34ff783d738d414d26af3903e5">OHOS::UIList::ScrollTo</a> (uint16_t <a href="UTILS.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1006655167084826"><a name="p1006655167084826"></a><a name="p1006655167084826"></a>void&nbsp;</p>
<p id="p766378448084826"><a name="p766378448084826"></a><a name="p766378448084826"></a>Scrolls to change the index of the first row or column of the current view. </p>
</td>
</tr>
<tr id="row180815474084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1283246917084826"><a name="p1283246917084826"></a><a name="p1283246917084826"></a><a href="Graphic.md#gaf97d599fe1147a71e44a5a107edeac77">OHOS::UIList::ScrollBy</a> (int16_t distance)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1585645813084826"><a name="p1585645813084826"></a><a name="p1585645813084826"></a>void&nbsp;</p>
<p id="p887005823084826"><a name="p887005823084826"></a><a name="p887005823084826"></a>Scrolls the content in this list. </p>
</td>
</tr>
<tr id="row364650546084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1931220297084826"><a name="p1931220297084826"></a><a name="p1931220297084826"></a><a href="Graphic.md#gaa8023e5c4e0688841263d0f576e76218">OHOS::UIList::SetStartIndex</a> (uint16_t <a href="UTILS.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p58900086084826"><a name="p58900086084826"></a><a name="p58900086084826"></a>void&nbsp;</p>
<p id="p493326560084826"><a name="p493326560084826"></a><a name="p493326560084826"></a>Sets the start index for this list. </p>
</td>
</tr>
<tr id="row640659201084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2024939682084826"><a name="p2024939682084826"></a><a name="p2024939682084826"></a><a href="Graphic.md#ga0ce3080df2c5226d20d446bc9c28b694">OHOS::UIList::GetStartIndex</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p232480187084826"><a name="p232480187084826"></a><a name="p232480187084826"></a>uint16_t&nbsp;</p>
<p id="p920933779084826"><a name="p920933779084826"></a><a name="p920933779084826"></a>Obtains the start index of this list. The default value is <strong id="b162632915084826"><a name="b162632915084826"></a><a name="b162632915084826"></a>0</strong>. </p>
</td>
</tr>
<tr id="row1240042944084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p327596820084826"><a name="p327596820084826"></a><a name="p327596820084826"></a><a href="Graphic.md#gaa07b156ab757cd20486ec0bcbf4c17ac">OHOS::UIList::SetLoopState</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1229318901084826"><a name="p1229318901084826"></a><a name="p1229318901084826"></a>void&nbsp;</p>
<p id="p1233333400084826"><a name="p1233333400084826"></a><a name="p1233333400084826"></a>Sets the loop state for this list, in which a loop scroll is possible since the top and bottom of the list are connected together. </p>
</td>
</tr>
<tr id="row411508580084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p556768338084826"><a name="p556768338084826"></a><a name="p556768338084826"></a><a href="Graphic.md#ga78d73f33cc63d0121342f52a818881d5">OHOS::UIList::GetLoopState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p171232987084826"><a name="p171232987084826"></a><a name="p171232987084826"></a>bool&nbsp;</p>
<p id="p346515154084826"><a name="p346515154084826"></a><a name="p346515154084826"></a>Checks whether this list is in a loop state. </p>
</td>
</tr>
<tr id="row942647813084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1488742481084826"><a name="p1488742481084826"></a><a name="p1488742481084826"></a><a href="Graphic.md#ga919b4f3116ca0d0971a48b7a14921954">OHOS::UIList::SetSelectPosition</a> (uint16_t position)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1016559673084826"><a name="p1016559673084826"></a><a name="p1016559673084826"></a>void&nbsp;</p>
<p id="p309321645084826"><a name="p309321645084826"></a><a name="p309321645084826"></a>Sets the position where a child view is selected as this list scrolls. </p>
</td>
</tr>
<tr id="row1552303594084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1431092561084826"><a name="p1431092561084826"></a><a name="p1431092561084826"></a><a href="Graphic.md#ga199fdcf3ef797e5f61073a4be3b06642">OHOS::UIList::GetSelectView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p426553107084826"><a name="p426553107084826"></a><a name="p426553107084826"></a><a href="OHOS-UIView.md">UIView</a> *&nbsp;</p>
<p id="p1801046489084826"><a name="p1801046489084826"></a><a name="p1801046489084826"></a>Obtains the child view being selected at the preset position. </p>
</td>
</tr>
<tr id="row1138970622084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2125990672084826"><a name="p2125990672084826"></a><a name="p2125990672084826"></a><a href="Graphic.md#gad6b2f7598033f4e1d0d73e30b0e41f02">OHOS::UIList::SetScrollStateListener</a> (<a href="OHOS-ListScrollListener.md">ListScrollListener</a> *scrollListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p778234830084826"><a name="p778234830084826"></a><a name="p778234830084826"></a>void&nbsp;</p>
<p id="p393806164084826"><a name="p393806164084826"></a><a name="p393806164084826"></a>Sets the listener that contains a callback to be invoked when a child view is selected as this list scrolls. </p>
</td>
</tr>
<tr id="row1412242985084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1461591705084826"><a name="p1461591705084826"></a><a name="p1461591705084826"></a><a href="Graphic.md#gaf2aabfa8e8edd803d034c23efe45f57b">OHOS::UIList::RefreshList</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1189123884084826"><a name="p1189123884084826"></a><a name="p1189123884084826"></a>void&nbsp;</p>
<p id="p1650662548084826"><a name="p1650662548084826"></a><a name="p1650662548084826"></a>Refreshes this list. The number of child views in the current view is fixed and the positions of those reserved child views as this list scrolls remain unchanged. </p>
</td>
</tr>
<tr id="row1308694551084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1109380713084826"><a name="p1109380713084826"></a><a name="p1109380713084826"></a><a href="Graphic.md#ga034799920648552008146a0d9aca3424">OHOS::UIList::EnableAutoAlign</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1693127084084826"><a name="p1693127084084826"></a><a name="p1693127084084826"></a>void&nbsp;</p>
<p id="p812381843084826"><a name="p812381843084826"></a><a name="p812381843084826"></a>Sets the automatic alignment state for this list. When a scroll stops, a child view is selected and its position is automatically aligned with the preset position. </p>
</td>
</tr>
<tr id="row882255798084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2130996404084826"><a name="p2130996404084826"></a><a name="p2130996404084826"></a><a href="Graphic.md#gaa55aae2e8066fecc5941e021a7f30d7e">OHOS::UIList::RemoveAll</a> () override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p990203198084826"><a name="p990203198084826"></a><a name="p990203198084826"></a>void&nbsp;</p>
<p id="p1255167040084826"><a name="p1255167040084826"></a><a name="p1255167040084826"></a>Removes all child views. </p>
</td>
</tr>
<tr id="row768809657084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p157138787084826"><a name="p157138787084826"></a><a name="p157138787084826"></a><a href="Graphic.md#ga527215b87f48c8e4a76c1d1d7979b739">OHOS::UIPicker::UIPicker</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1322164698084826"><a name="p1322164698084826"></a><a name="p1322164698084826"></a>&nbsp;</p>
<p id="p921972886084826"><a name="p921972886084826"></a><a name="p921972886084826"></a>A constructor used to create a <strong id="b193825365084826"><a name="b193825365084826"></a><a name="b193825365084826"></a><a href="OHOS-UIPicker.md">UIPicker</a></strong> instance. </p>
</td>
</tr>
<tr id="row318769570084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1001229071084826"><a name="p1001229071084826"></a><a name="p1001229071084826"></a><a href="Graphic.md#ga7aa364d1c552eaf8b8be587e03049f59">OHOS::UIPicker::~UIPicker</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1426156864084826"><a name="p1426156864084826"></a><a name="p1426156864084826"></a>virtual&nbsp;</p>
<p id="p1563000366084826"><a name="p1563000366084826"></a><a name="p1563000366084826"></a>A destructor used to delete the <strong id="b90219221084826"><a name="b90219221084826"></a><a name="b90219221084826"></a><a href="OHOS-UIPicker.md">UIPicker</a></strong> instance. </p>
</td>
</tr>
<tr id="row306637713084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1915457793084826"><a name="p1915457793084826"></a><a name="p1915457793084826"></a><a href="Graphic.md#ga926337be55785de0b32ad57d7ee85c5c">OHOS::UIPicker::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1636062821084826"><a name="p1636062821084826"></a><a name="p1636062821084826"></a>UIViewType&nbsp;</p>
<p id="p1715594182084826"><a name="p1715594182084826"></a><a name="p1715594182084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row1910127609084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1149665932084826"><a name="p1149665932084826"></a><a name="p1149665932084826"></a><a href="Graphic.md#ga3e2a703a10017c789366029b297969ab">OHOS::UIPicker::OnPreDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p23662480084826"><a name="p23662480084826"></a><a name="p23662480084826"></a>bool&nbsp;</p>
<p id="p1569166835084826"><a name="p1569166835084826"></a><a name="p1569166835084826"></a>Called before a view is drawn. This function is used to check whether the parent view of this view needs to be redrawn so as to optimize the drawing process. </p>
</td>
</tr>
<tr id="row123199147084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p718261648084826"><a name="p718261648084826"></a><a name="p718261648084826"></a><a href="Graphic.md#ga419bb15f72b02f009a76a84e1242b37a">OHOS::UIPicker::SetValues</a> (const char *value[], uint16_t count)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1326764375084826"><a name="p1326764375084826"></a><a name="p1326764375084826"></a>bool&nbsp;</p>
<p id="p661987169084826"><a name="p661987169084826"></a><a name="p661987169084826"></a>Sets dynamic text data in the picker by using a string array. </p>
</td>
</tr>
<tr id="row1294415404084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p41698890084826"><a name="p41698890084826"></a><a name="p41698890084826"></a><a href="Graphic.md#gadc27ad0369bad90526a59d0cefdb9697">OHOS::UIPicker::SetValues</a> (int16_t start, int16_t end)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1726728981084826"><a name="p1726728981084826"></a><a name="p1726728981084826"></a>bool&nbsp;</p>
<p id="p1461598364084826"><a name="p1461598364084826"></a><a name="p1461598364084826"></a>Sets the numeric data in the picker by using a given numeric range. </p>
</td>
</tr>
<tr id="row535103110084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p875037242084826"><a name="p875037242084826"></a><a name="p875037242084826"></a><a href="Graphic.md#ga81e69c460191bbe3606ac540433178a1">OHOS::UIPicker::ClearValues</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1334293675084826"><a name="p1334293675084826"></a><a name="p1334293675084826"></a>virtual void&nbsp;</p>
<p id="p1184075568084826"><a name="p1184075568084826"></a><a name="p1184075568084826"></a>Clears all values in the picker. </p>
</td>
</tr>
<tr id="row2111631117084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p416004673084826"><a name="p416004673084826"></a><a name="p416004673084826"></a><a href="Graphic.md#ga11a0d71430e826f1971744e5ce1c9048">OHOS::UIPicker::SetFontId</a> (uint8_t backgroundFontId, uint8_t highlightFontId)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p627845755084826"><a name="p627845755084826"></a><a name="p627845755084826"></a>void&nbsp;</p>
<p id="p1777962015084826"><a name="p1777962015084826"></a><a name="p1777962015084826"></a>Sets the font IDs of dynamic text, which is the string array set through <a href="Graphic.md#ga419bb15f72b02f009a76a84e1242b37a">SetValues</a>. </p>
</td>
</tr>
<tr id="row55785249084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p220718241084826"><a name="p220718241084826"></a><a name="p220718241084826"></a><a href="Graphic.md#gaaf111e4de815c455ddc35d200c1de7af">OHOS::UIPicker::GetBackgroundFontId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1458663071084826"><a name="p1458663071084826"></a><a name="p1458663071084826"></a>uint16_t&nbsp;</p>
<p id="p347346967084826"><a name="p347346967084826"></a><a name="p347346967084826"></a>Obtains the font ID of the background text. </p>
</td>
</tr>
<tr id="row2001356276084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2053741932084826"><a name="p2053741932084826"></a><a name="p2053741932084826"></a><a href="Graphic.md#ga3a03222a252380aa738186e9c004dc1a">OHOS::UIPicker::GetHighlightFontId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1725637454084826"><a name="p1725637454084826"></a><a name="p1725637454084826"></a>uint16_t&nbsp;</p>
<p id="p179329953084826"><a name="p179329953084826"></a><a name="p179329953084826"></a>Obtains the font ID of the highlighted text. </p>
</td>
</tr>
<tr id="row1592063356084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p39105628084826"><a name="p39105628084826"></a><a name="p39105628084826"></a><a href="Graphic.md#ga281508b16585cdf4531e29872486e6c8">OHOS::UIPicker::SetTextColor</a> (<a href="OHOS-Color32.md">ColorType</a> backgroundColor, <a href="OHOS-Color32.md">ColorType</a> highlightColor)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p703217302084826"><a name="p703217302084826"></a><a name="p703217302084826"></a>void&nbsp;</p>
<p id="p1686814908084826"><a name="p1686814908084826"></a><a name="p1686814908084826"></a>Sets the text color. </p>
</td>
</tr>
<tr id="row1266079820084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1249206707084826"><a name="p1249206707084826"></a><a name="p1249206707084826"></a><a href="Graphic.md#ga2acbf79147239f60aafa2c78ccc2ff6d">OHOS::UIPicker::GetBackgroundTextColor</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p222731964084826"><a name="p222731964084826"></a><a name="p222731964084826"></a><a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p2028384974084826"><a name="p2028384974084826"></a><a name="p2028384974084826"></a>Obtains the color of the background text. </p>
</td>
</tr>
<tr id="row1592322739084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p824374847084826"><a name="p824374847084826"></a><a name="p824374847084826"></a><a href="Graphic.md#gaf51c8e0d1defb52191bc5f0b2c960695">OHOS::UIPicker::GetHighlightTextColor</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1879662342084826"><a name="p1879662342084826"></a><a name="p1879662342084826"></a><a href="OHOS-Color32.md">ColorType</a>&nbsp;</p>
<p id="p1503383786084826"><a name="p1503383786084826"></a><a name="p1503383786084826"></a>Obtains the color of the highlighted text. </p>
</td>
</tr>
<tr id="row1692882459084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p39459766084826"><a name="p39459766084826"></a><a name="p39459766084826"></a><a href="Graphic.md#ga07eb2080a6052c19dba2873fcfae2c34">OHOS::UIPicker::SetSelected</a> (uint16_t <a href="UTILS.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1590184756084826"><a name="p1590184756084826"></a><a name="p1590184756084826"></a>bool&nbsp;</p>
<p id="p852800967084826"><a name="p852800967084826"></a><a name="p852800967084826"></a>Sets the index of the item currently selected in the picker. </p>
</td>
</tr>
<tr id="row2014873601084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p946529245084826"><a name="p946529245084826"></a><a name="p946529245084826"></a><a href="Graphic.md#ga7c9d757790dfaae67fad110577b57ee9">OHOS::UIPicker::GetSelected</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1892398843084826"><a name="p1892398843084826"></a><a name="p1892398843084826"></a>uint16_t&nbsp;</p>
<p id="p1056914185084826"><a name="p1056914185084826"></a><a name="p1056914185084826"></a>Obtains the index of the item currently selected in the picker. </p>
</td>
</tr>
<tr id="row884184300084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p8094591084826"><a name="p8094591084826"></a><a name="p8094591084826"></a><a href="Graphic.md#ga6a6d9ca48f543f4f6cf6073d6cca359a">OHOS::UIPicker::SetItemHeight</a> (int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p515351715084826"><a name="p515351715084826"></a><a name="p515351715084826"></a>void&nbsp;</p>
<p id="p1807939052084826"><a name="p1807939052084826"></a><a name="p1807939052084826"></a>Sets the height of each item in the picker. </p>
</td>
</tr>
<tr id="row820550489084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p236524106084826"><a name="p236524106084826"></a><a name="p236524106084826"></a><a href="Graphic.md#ga792a345948af532f9c06cd40c05d1a2d">OHOS::UIPicker::SetWidth</a> (int16_t width) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1050639793084826"><a name="p1050639793084826"></a><a name="p1050639793084826"></a>void&nbsp;</p>
<p id="p2031759854084826"><a name="p2031759854084826"></a><a name="p2031759854084826"></a>Sets the width for this component. </p>
</td>
</tr>
<tr id="row2111874380084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p520348511084826"><a name="p520348511084826"></a><a name="p520348511084826"></a><a href="Graphic.md#ga167979fe09694b0f0c09e9c676189bea">OHOS::UIPicker::SetHeight</a> (int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1467764796084826"><a name="p1467764796084826"></a><a name="p1467764796084826"></a>void&nbsp;</p>
<p id="p341123612084826"><a name="p341123612084826"></a><a name="p341123612084826"></a>Sets the height for this component. </p>
</td>
</tr>
<tr id="row892666524084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p929213253084826"><a name="p929213253084826"></a><a name="p929213253084826"></a><a href="Graphic.md#ga742f27b59ae3c19dfb5d99e84ca19554">OHOS::UIPicker::SetLoopState</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p205822830084826"><a name="p205822830084826"></a><a name="p205822830084826"></a>void&nbsp;</p>
<p id="p801225996084826"><a name="p801225996084826"></a><a name="p801225996084826"></a>Sets whether a picker can slide cyclically. </p>
</td>
</tr>
<tr id="row488247858084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1349464265084826"><a name="p1349464265084826"></a><a name="p1349464265084826"></a><a href="Graphic.md#gae386080bbc3bb3ae2bb4572b8bfbb6b0">OHOS::UIPicker::SelectedListener::SelectedListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1463045608084826"><a name="p1463045608084826"></a><a name="p1463045608084826"></a>&nbsp;</p>
<p id="p355628871084826"><a name="p355628871084826"></a><a name="p355628871084826"></a>A constructor used to create a <strong id="b458819716084826"><a name="b458819716084826"></a><a name="b458819716084826"></a><a href="OHOS-UIPicker-SelectedListener.md">SelectedListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row1549924663084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p746230388084826"><a name="p746230388084826"></a><a name="p746230388084826"></a><a href="Graphic.md#ga6aa15c4365ba33bc21c67cfc3e5cf06f">OHOS::UIPicker::SelectedListener::~SelectedListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p209418259084826"><a name="p209418259084826"></a><a name="p209418259084826"></a>virtual&nbsp;</p>
<p id="p1700117242084826"><a name="p1700117242084826"></a><a name="p1700117242084826"></a>A destructor used to delete the <strong id="b125919186084826"><a name="b125919186084826"></a><a name="b125919186084826"></a><a href="OHOS-UIPicker-SelectedListener.md">SelectedListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row1281057400084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1409020430084826"><a name="p1409020430084826"></a><a name="p1409020430084826"></a><a href="Graphic.md#ga9cd5ee866fe730a6ae6c66344284b5e2">OHOS::UIPicker::SelectedListener::OnPickerStoped</a> (<a href="OHOS-UIPicker.md">UIPicker</a> &amp;picker)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p401649795084826"><a name="p401649795084826"></a><a name="p401649795084826"></a>virtual void&nbsp;</p>
<p id="p628898512084826"><a name="p628898512084826"></a><a name="p628898512084826"></a>Called when an item is selected after sliding stops. This function is implemented by applications. </p>
</td>
</tr>
<tr id="row1338411031084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p198074293084826"><a name="p198074293084826"></a><a name="p198074293084826"></a><a href="Graphic.md#ga70a514c87a883999a93b6c9d3713be61">OHOS::UIPicker::RegisterSelectedListener</a> (<a href="OHOS-UIPicker-SelectedListener.md">SelectedListener</a> *pickerListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p579668609084826"><a name="p579668609084826"></a><a name="p579668609084826"></a>void&nbsp;</p>
<p id="p86735880084826"><a name="p86735880084826"></a><a name="p86735880084826"></a>Registers a listener for a selected event. </p>
</td>
</tr>
<tr id="row352469779084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1864516187084826"><a name="p1864516187084826"></a><a name="p1864516187084826"></a><a href="Graphic.md#gad0c36e1430f8db5571fd92b82d6d6bc1">OHOS::UIPicker::SetDirect</a> (<a href="Graphic.md#ga0c108f97781843f67c101b47b6c00cf0">UITextLanguageDirect</a> direct)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p871430647084826"><a name="p871430647084826"></a><a name="p871430647084826"></a>void&nbsp;</p>
<p id="p1906669870084826"><a name="p1906669870084826"></a><a name="p1906669870084826"></a>Sets the text direction. </p>
</td>
</tr>
<tr id="row198057149084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p975641539084826"><a name="p975641539084826"></a><a name="p975641539084826"></a><a href="Graphic.md#ga564153af81a4a41ceab63622506d25eb">OHOS::UIPicker::SetTextFormatter</a> (<a href="OHOS-TextFormatter.md">TextFormatter</a> *formatter)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p472395207084826"><a name="p472395207084826"></a><a name="p472395207084826"></a>void&nbsp;</p>
<p id="p2009289998084826"><a name="p2009289998084826"></a><a name="p2009289998084826"></a>Sets the text formatter. </p>
</td>
</tr>
<tr id="row1402971308084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p282699418084826"><a name="p282699418084826"></a><a name="p282699418084826"></a><a href="Graphic.md#gaae79b6ffd2b156a8d42263a322985284">OHOS::UIRadioButton::UIRadioButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2104082182084826"><a name="p2104082182084826"></a><a name="p2104082182084826"></a>&nbsp;</p>
<p id="p1438004652084826"><a name="p1438004652084826"></a><a name="p1438004652084826"></a>A constructor used to create a <strong id="b743517288084826"><a name="b743517288084826"></a><a name="b743517288084826"></a><a href="OHOS-UIRadioButton.md">UIRadioButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row760627918084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p858881308084826"><a name="p858881308084826"></a><a name="p858881308084826"></a><em id="ga9b48f8664f04f08b94dca2e0b3821595"><a name="ga9b48f8664f04f08b94dca2e0b3821595"></a><a name="ga9b48f8664f04f08b94dca2e0b3821595"></a></em>OHOS::UIRadioButton::UIRadioButton (const char *name)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p263923713084826"><a name="p263923713084826"></a><a name="p263923713084826"></a><strong id="ga9b48f8664f04f08b94dca2e0b3821595_1"><a name="ga9b48f8664f04f08b94dca2e0b3821595_1"></a><a name="ga9b48f8664f04f08b94dca2e0b3821595_1"></a></strong> &nbsp;</p>
<p id="p264859917084826"><a name="p264859917084826"></a><a name="p264859917084826"></a>Default constructor. </p>
</td>
</tr>
<tr id="row1530331092084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1449390221084826"><a name="p1449390221084826"></a><a name="p1449390221084826"></a><a href="Graphic.md#ga1b9fbd5840829e912aa4013a343e7b36">OHOS::UIRadioButton::~UIRadioButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p679595779084826"><a name="p679595779084826"></a><a name="p679595779084826"></a>virtual&nbsp;</p>
<p id="p853022494084826"><a name="p853022494084826"></a><a name="p853022494084826"></a>A destructor used to delete the <strong id="b2081457144084826"><a name="b2081457144084826"></a><a name="b2081457144084826"></a><a href="OHOS-UIRadioButton.md">UIRadioButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row588833830084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1163734654084826"><a name="p1163734654084826"></a><a name="p1163734654084826"></a><a href="Graphic.md#ga2efe6a87345903726c721fc7a9ed4365">OHOS::UIRadioButton::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p374390274084826"><a name="p374390274084826"></a><a name="p374390274084826"></a>UIViewType&nbsp;</p>
<p id="p1314715031084826"><a name="p1314715031084826"></a><a name="p1314715031084826"></a>Obtains the component type. </p>
</td>
</tr>
<tr id="row152853424084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p717851552084826"><a name="p717851552084826"></a><a name="p717851552084826"></a><a href="Graphic.md#gade9069f6e553c6c43f7684e835b584e5">OHOS::UIRadioButton::OnPreDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p642124877084826"><a name="p642124877084826"></a><a name="p642124877084826"></a>bool&nbsp;</p>
<p id="p480777263084826"><a name="p480777263084826"></a><a name="p480777263084826"></a>Do something before draw, this function will be invoked mainly to check if this view need to cover invalidate area so render manager can decide which layer to draw firstly. </p>
</td>
</tr>
<tr id="row821360236084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p728240855084826"><a name="p728240855084826"></a><a name="p728240855084826"></a><a href="Graphic.md#ga7b6849c94b9d8b90cbbe890790fedf1e">OHOS::UIRadioButton::OnClickEvent</a> (const <a href="OHOS-ClickEvent.md">ClickEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1785252548084826"><a name="p1785252548084826"></a><a name="p1785252548084826"></a>void&nbsp;</p>
<p id="p214734088084826"><a name="p214734088084826"></a><a name="p214734088084826"></a>Executes the click event action OnClickEvent will reverse the selected state of checkbox. Example: If the check box is selected, the checkbox status is changed to Unselected after the click action is taken. </p>
</td>
</tr>
<tr id="row805678523084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1340770980084826"><a name="p1340770980084826"></a><a name="p1340770980084826"></a><a href="Graphic.md#gad56eb918dbfec65f8f596572a9911286">OHOS::UIRadioButton::SetName</a> (const char *name)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1146477422084826"><a name="p1146477422084826"></a><a name="p1146477422084826"></a>void&nbsp;</p>
<p id="p850801664084826"><a name="p850801664084826"></a><a name="p850801664084826"></a>Sets the name for this radio button. </p>
</td>
</tr>
<tr id="row471941817084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1524999366084826"><a name="p1524999366084826"></a><a name="p1524999366084826"></a><a href="Graphic.md#ga7d2125ee509f1555888549277f31a7a7">OHOS::UIRadioButton::GetName</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1067903396084826"><a name="p1067903396084826"></a><a name="p1067903396084826"></a>const char *&nbsp;</p>
<p id="p2033147708084826"><a name="p2033147708084826"></a><a name="p2033147708084826"></a>Obtains the name of this radio button. </p>
</td>
</tr>
<tr id="row1699137182084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1264703532084826"><a name="p1264703532084826"></a><a name="p1264703532084826"></a><a href="Graphic.md#gac43cbe638a874231842ad80c23c00b0a">OHOS::UIRepeatButton::UIRepeatButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p407690738084826"><a name="p407690738084826"></a><a name="p407690738084826"></a>&nbsp;</p>
<p id="p285846829084826"><a name="p285846829084826"></a><a name="p285846829084826"></a>A constructor used to create a <strong id="b946231995084826"><a name="b946231995084826"></a><a name="b946231995084826"></a><a href="OHOS-UIRepeatButton.md">UIRepeatButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row1565850566084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1684937435084826"><a name="p1684937435084826"></a><a name="p1684937435084826"></a><a href="Graphic.md#ga2e2a8bc2b9aa21899356dbad7a242900">OHOS::UIRepeatButton::~UIRepeatButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1993598709084826"><a name="p1993598709084826"></a><a name="p1993598709084826"></a>virtual&nbsp;</p>
<p id="p1661695993084826"><a name="p1661695993084826"></a><a name="p1661695993084826"></a>A destructor used to delete the <strong id="b403483474084826"><a name="b403483474084826"></a><a name="b403483474084826"></a><a href="OHOS-UIRepeatButton.md">UIRepeatButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row589194383084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2073014755084826"><a name="p2073014755084826"></a><a name="p2073014755084826"></a><a href="Graphic.md#gac391336aedd68659b7f76bee59eba521">OHOS::UIRepeatButton::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1539974317084826"><a name="p1539974317084826"></a><a name="p1539974317084826"></a>UIViewType&nbsp;</p>
<p id="p791425077084826"><a name="p791425077084826"></a><a name="p791425077084826"></a>Obtains the component type. </p>
</td>
</tr>
<tr id="row38213085084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2141919537084826"><a name="p2141919537084826"></a><a name="p2141919537084826"></a><a href="Graphic.md#ga88637ae5acd7701ded0d0e88fb28227d">OHOS::UIRepeatButton::SetInterval</a> (uint16_t interval)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p111332903084826"><a name="p111332903084826"></a><a name="p111332903084826"></a>virtual void&nbsp;</p>
<p id="p443728819084826"><a name="p443728819084826"></a><a name="p443728819084826"></a>Sets the interval between two consecutive click events. </p>
</td>
</tr>
<tr id="row895418443084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p836272377084826"><a name="p836272377084826"></a><a name="p836272377084826"></a><a href="Graphic.md#gad772c84a309dbaa150b66f697e5b8ed8">OHOS::UIRepeatButton::GetInterval</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p319973754084826"><a name="p319973754084826"></a><a name="p319973754084826"></a>virtual uint16_t&nbsp;</p>
<p id="p1108648626084826"><a name="p1108648626084826"></a><a name="p1108648626084826"></a>Obtains the interval between two consecutive click events. </p>
</td>
</tr>
<tr id="row1094873363084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1861197461084826"><a name="p1861197461084826"></a><a name="p1861197461084826"></a><a href="Graphic.md#gaca17d1cfa9daa35a88d387ebc1d9352c">OHOS::UIRepeatButton::OnClickEvent</a> (const <a href="OHOS-ClickEvent.md">ClickEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1150904455084826"><a name="p1150904455084826"></a><a name="p1150904455084826"></a>virtual void&nbsp;</p>
<p id="p1270995242084826"><a name="p1270995242084826"></a><a name="p1270995242084826"></a>The action of click event. </p>
</td>
</tr>
<tr id="row1511822249084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1143584498084826"><a name="p1143584498084826"></a><a name="p1143584498084826"></a><a href="Graphic.md#gadd5891c03d95d07d127558b5bc9a7bd7">OHOS::UIRepeatButton::OnReleaseEvent</a> (const <a href="OHOS-ReleaseEvent.md">ReleaseEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2023362876084826"><a name="p2023362876084826"></a><a name="p2023362876084826"></a>virtual void&nbsp;</p>
<p id="p1366593739084826"><a name="p1366593739084826"></a><a name="p1366593739084826"></a>The action of release event. </p>
</td>
</tr>
<tr id="row458156584084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1984384200084826"><a name="p1984384200084826"></a><a name="p1984384200084826"></a><a href="Graphic.md#ga33de0d99700bd1c289d967458477606f">OHOS::UIRepeatButton::OnLongPressEvent</a> (const <a href="OHOS-LongPressEvent.md">LongPressEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1133960985084826"><a name="p1133960985084826"></a><a name="p1133960985084826"></a>virtual bool&nbsp;</p>
<p id="p1036764210084826"><a name="p1036764210084826"></a><a name="p1036764210084826"></a>The action of long press event. </p>
</td>
</tr>
<tr id="row1434358867084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1769456161084826"><a name="p1769456161084826"></a><a name="p1769456161084826"></a><em id="gaba3c785f0e636cd1ac1317b9d3fcf430"><a name="gaba3c785f0e636cd1ac1317b9d3fcf430"></a><a name="gaba3c785f0e636cd1ac1317b9d3fcf430"></a></em>OHOS::UIRepeatButton::HandleTickEvent ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1769227609084826"><a name="p1769227609084826"></a><a name="p1769227609084826"></a><strong id="gaba3c785f0e636cd1ac1317b9d3fcf430_1"><a name="gaba3c785f0e636cd1ac1317b9d3fcf430_1"></a><a name="gaba3c785f0e636cd1ac1317b9d3fcf430_1"></a></strong> void&nbsp;</p>
<p id="p931479416084826"><a name="p931479416084826"></a><a name="p931479416084826"></a>handle the event of long pressing. </p>
</td>
</tr>
<tr id="row1821216664084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1105711733084826"><a name="p1105711733084826"></a><a name="p1105711733084826"></a><a href="Graphic.md#gad065bfe4e322d036b5bd9e30667754a6">OHOS::UIScrollView::OnScrollListener::OnScrollListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1845888535084826"><a name="p1845888535084826"></a><a name="p1845888535084826"></a>&nbsp;</p>
<p id="p529861646084826"><a name="p529861646084826"></a><a name="p529861646084826"></a>A constructor used to create an <strong id="b1415419351084826"><a name="b1415419351084826"></a><a name="b1415419351084826"></a><a href="OHOS-UIScrollView-OnScrollListener.md">OnScrollListener</a></strong> instance with the default scroll state <strong id="b1649428367084826"><a name="b1649428367084826"></a><a name="b1649428367084826"></a>SCROLL_STATE_STOP</strong>. </p>
</td>
</tr>
<tr id="row1194958820084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1659638722084826"><a name="p1659638722084826"></a><a name="p1659638722084826"></a><a href="Graphic.md#ga14fe076dffea62fdd281cd13e846de2d">OHOS::UIScrollView::OnScrollListener::~OnScrollListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2055889977084826"><a name="p2055889977084826"></a><a name="p2055889977084826"></a>virtual&nbsp;</p>
<p id="p1026702803084826"><a name="p1026702803084826"></a><a name="p1026702803084826"></a>A destructor used to delete the <strong id="b1114858128084826"><a name="b1114858128084826"></a><a name="b1114858128084826"></a><a href="OHOS-UIScrollView-OnScrollListener.md">OnScrollListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row168932569084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p622484646084826"><a name="p622484646084826"></a><a name="p622484646084826"></a><a href="Graphic.md#ga8000c484a999483edc66e8dd1b7ceaf6">OHOS::UIScrollView::OnScrollListener::OnScrollStart</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p903234999084826"><a name="p903234999084826"></a><a name="p903234999084826"></a>virtual void&nbsp;</p>
<p id="p219016697084826"><a name="p219016697084826"></a><a name="p219016697084826"></a>Called when a scroll starts. </p>
</td>
</tr>
<tr id="row16721503084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2005545757084826"><a name="p2005545757084826"></a><a name="p2005545757084826"></a><a href="Graphic.md#ga958c02ddc348eadaaf08f917f55aba63">OHOS::UIScrollView::OnScrollListener::OnScrollEnd</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p471539208084826"><a name="p471539208084826"></a><a name="p471539208084826"></a>virtual void&nbsp;</p>
<p id="p540066410084826"><a name="p540066410084826"></a><a name="p540066410084826"></a>Called when a scroll ends. </p>
</td>
</tr>
<tr id="row1844759925084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1506315911084826"><a name="p1506315911084826"></a><a name="p1506315911084826"></a><a href="Graphic.md#ga15a8abaeb958bfa972b541b59fabd8a7">OHOS::UIScrollView::OnScrollListener::GetScrollState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p211139130084826"><a name="p211139130084826"></a><a name="p211139130084826"></a>uint8_t&nbsp;</p>
<p id="p1678434804084826"><a name="p1678434804084826"></a><a name="p1678434804084826"></a>Obtains the scroll state of this view. </p>
</td>
</tr>
<tr id="row865524712084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p80721399084826"><a name="p80721399084826"></a><a name="p80721399084826"></a><a href="Graphic.md#ga83285fe2d337f5d2242204e739e130ab">OHOS::UIScrollView::UIScrollView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1969711991084826"><a name="p1969711991084826"></a><a name="p1969711991084826"></a>&nbsp;</p>
<p id="p1796480929084826"><a name="p1796480929084826"></a><a name="p1796480929084826"></a>A constructor used to create a <strong id="b303096701084826"><a name="b303096701084826"></a><a name="b303096701084826"></a><a href="OHOS-UIScrollView.md">UIScrollView</a></strong> instance, with both horizontal and vertical scrolls supported. </p>
</td>
</tr>
<tr id="row2086967899084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p536947184084826"><a name="p536947184084826"></a><a name="p536947184084826"></a><a href="Graphic.md#ga1b5f674824f5c27038329aa1223b137b">OHOS::UIScrollView::~UIScrollView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p755595624084826"><a name="p755595624084826"></a><a name="p755595624084826"></a>virtual&nbsp;</p>
<p id="p1294930563084826"><a name="p1294930563084826"></a><a name="p1294930563084826"></a>A destructor used to delete the <strong id="b480730297084826"><a name="b480730297084826"></a><a name="b480730297084826"></a><a href="OHOS-UIScrollView.md">UIScrollView</a></strong> instance. </p>
</td>
</tr>
<tr id="row339396039084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1410875226084826"><a name="p1410875226084826"></a><a name="p1410875226084826"></a><a href="Graphic.md#ga1feefd393c568a12ec4e877e207d598c">OHOS::UIScrollView::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1764830137084826"><a name="p1764830137084826"></a><a name="p1764830137084826"></a>UIViewType&nbsp;</p>
<p id="p96978380084826"><a name="p96978380084826"></a><a name="p96978380084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row226250948084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1266630387084826"><a name="p1266630387084826"></a><a name="p1266630387084826"></a><a href="Graphic.md#ga8a7764e5a85e40b497a67fdf54a1b4c8">OHOS::UIScrollView::OnPostDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1166246836084826"><a name="p1166246836084826"></a><a name="p1166246836084826"></a>void&nbsp;</p>
<p id="p828786105084826"><a name="p828786105084826"></a><a name="p828786105084826"></a>Called after a view is drawn. </p>
</td>
</tr>
<tr id="row804196200084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p750960432084826"><a name="p750960432084826"></a><a name="p750960432084826"></a><a href="Graphic.md#ga2fde4511d743ccc257308d9a0c035076">OHOS::UIScrollView::OnDragEvent</a> (const <a href="OHOS-DragEvent.md">DragEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1545923607084826"><a name="p1545923607084826"></a><a name="p1545923607084826"></a>bool&nbsp;</p>
<p id="p1732072162084826"><a name="p1732072162084826"></a><a name="p1732072162084826"></a>Called when the view is being dragged. </p>
</td>
</tr>
<tr id="row1894328169084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1558390731084826"><a name="p1558390731084826"></a><a name="p1558390731084826"></a><a href="Graphic.md#ga05e30354bc97373fbd30f8c045dbbeea">OHOS::UIScrollView::OnDragEndEvent</a> (const <a href="OHOS-DragEvent.md">DragEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1124652075084826"><a name="p1124652075084826"></a><a name="p1124652075084826"></a>bool&nbsp;</p>
<p id="p989555218084826"><a name="p989555218084826"></a><a name="p989555218084826"></a>Called when the view stops dragging. </p>
</td>
</tr>
<tr id="row83806597084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1182088369084826"><a name="p1182088369084826"></a><a name="p1182088369084826"></a><a href="Graphic.md#ga54572308575db6d19997343c65d72fbb">OHOS::UIScrollView::OnPressEvent</a> (const <a href="OHOS-PressEvent.md">PressEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1885201363084826"><a name="p1885201363084826"></a><a name="p1885201363084826"></a>void&nbsp;</p>
<p id="p108601910084826"><a name="p108601910084826"></a><a name="p108601910084826"></a>Called when the view is pressed. </p>
</td>
</tr>
<tr id="row910243944084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1877019632084826"><a name="p1877019632084826"></a><a name="p1877019632084826"></a><a href="Graphic.md#ga233e426fee2ff5b0973637bb3bf545ee">OHOS::UIScrollView::ScrollBy</a> (int16_t xDistance, int16_t yDistance)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1525675143084826"><a name="p1525675143084826"></a><a name="p1525675143084826"></a>void&nbsp;</p>
<p id="p369579534084826"><a name="p369579534084826"></a><a name="p369579534084826"></a>Scrolls the content of this view. </p>
</td>
</tr>
<tr id="row975891184084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1450357551084826"><a name="p1450357551084826"></a><a name="p1450357551084826"></a><a href="Graphic.md#ga992fe30e6840d966688154ea96c362f4">OHOS::UIScrollView::SetScrollbarWidth</a> (uint8_t width)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1584351815084826"><a name="p1584351815084826"></a><a name="p1584351815084826"></a>void&nbsp;</p>
<p id="p1847143093084826"><a name="p1847143093084826"></a><a name="p1847143093084826"></a>Sets the width for this scroll bar. </p>
</td>
</tr>
<tr id="row1021005284084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1610369392084826"><a name="p1610369392084826"></a><a name="p1610369392084826"></a><a href="Graphic.md#ga53a40f1c665fc7333e6aac156a1f5b81">OHOS::UIScrollView::SetHorizontalScrollState</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1499472257084826"><a name="p1499472257084826"></a><a name="p1499472257084826"></a>void&nbsp;</p>
<p id="p379848159084826"><a name="p379848159084826"></a><a name="p379848159084826"></a>Sets whether a horizontal scroll is enabled. </p>
</td>
</tr>
<tr id="row244871094084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1206738642084826"><a name="p1206738642084826"></a><a name="p1206738642084826"></a><a href="Graphic.md#ga0549786419ae52253f832a44cad91afe">OHOS::UIScrollView::GetHorizontalScrollState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p475615151084826"><a name="p475615151084826"></a><a name="p475615151084826"></a>bool&nbsp;</p>
<p id="p1492291730084826"><a name="p1492291730084826"></a><a name="p1492291730084826"></a>Checks whether a horizontal scroll is enabled. </p>
</td>
</tr>
<tr id="row692870809084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1984350857084826"><a name="p1984350857084826"></a><a name="p1984350857084826"></a><a href="Graphic.md#ga8a6839614c863229666675c289a5cff4">OHOS::UIScrollView::SetVerticalScrollState</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1154032136084826"><a name="p1154032136084826"></a><a name="p1154032136084826"></a>void&nbsp;</p>
<p id="p1450983741084826"><a name="p1450983741084826"></a><a name="p1450983741084826"></a>Sets whether a vertical scroll is enabled. </p>
</td>
</tr>
<tr id="row615350106084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1864536450084826"><a name="p1864536450084826"></a><a name="p1864536450084826"></a><a href="Graphic.md#gac2095a64edba0fe0483a5475b11b45b2">OHOS::UIScrollView::GetVerticalScrollState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1406177751084826"><a name="p1406177751084826"></a><a name="p1406177751084826"></a>bool&nbsp;</p>
<p id="p410969620084826"><a name="p410969620084826"></a><a name="p410969620084826"></a>Checks whether a vertical scroll is enabled. </p>
</td>
</tr>
<tr id="row1892103518084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1440898512084826"><a name="p1440898512084826"></a><a name="p1440898512084826"></a><a href="Graphic.md#ga011dae1414a147441e1d32d548545f24">OHOS::UIScrollView::SetXScrollBarVisible</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2003473902084826"><a name="p2003473902084826"></a><a name="p2003473902084826"></a>void&nbsp;</p>
<p id="p2103605083084826"><a name="p2103605083084826"></a><a name="p2103605083084826"></a>Sets whether the horizontal scroll bar is visible. </p>
</td>
</tr>
<tr id="row2022242028084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1042849361084826"><a name="p1042849361084826"></a><a name="p1042849361084826"></a><a href="Graphic.md#ga36fcdfce31fab72f54a37062d3f4a6f1">OHOS::UIScrollView::SetYScrollBarVisible</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1511720562084826"><a name="p1511720562084826"></a><a name="p1511720562084826"></a>void&nbsp;</p>
<p id="p1603364565084826"><a name="p1603364565084826"></a><a name="p1603364565084826"></a>Sets whether the vertical scroll bar is visible. </p>
</td>
</tr>
<tr id="row905884987084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p582304881084826"><a name="p582304881084826"></a><a name="p582304881084826"></a><a href="Graphic.md#gad66c58c77db0dd0c507e45290ad5cd24">OHOS::UIScrollView::RegisterScrollListener</a> (<a href="OHOS-UIScrollView-OnScrollListener.md">OnScrollListener</a> *scrollListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p964754439084826"><a name="p964754439084826"></a><a name="p964754439084826"></a>void&nbsp;</p>
<p id="p1231822271084826"><a name="p1231822271084826"></a><a name="p1231822271084826"></a>Registers a listener that contains a callback to be invoked upon scroll state changes. </p>
</td>
</tr>
<tr id="row319863100084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1668298935084826"><a name="p1668298935084826"></a><a name="p1668298935084826"></a><a href="Graphic.md#ga67f8d874edcd65b1610117052ceed0a6">OHOS::UISlider::UISlider</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1951572794084826"><a name="p1951572794084826"></a><a name="p1951572794084826"></a>&nbsp;</p>
<p id="p283450880084826"><a name="p283450880084826"></a><a name="p283450880084826"></a>A constructor used to create a <strong id="b317926936084826"><a name="b317926936084826"></a><a name="b317926936084826"></a><a href="OHOS-UISlider.md">UISlider</a></strong> instance. </p>
</td>
</tr>
<tr id="row1420286573084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p73279817084826"><a name="p73279817084826"></a><a name="p73279817084826"></a><a href="Graphic.md#ga024c4f15347a0b70920ab745efe8d250">OHOS::UISlider::~UISlider</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p814054938084826"><a name="p814054938084826"></a><a name="p814054938084826"></a>virtual&nbsp;</p>
<p id="p728355457084826"><a name="p728355457084826"></a><a name="p728355457084826"></a>A destructor used to delete the <strong id="b1852916797084826"><a name="b1852916797084826"></a><a name="b1852916797084826"></a><a href="OHOS-UISlider.md">UISlider</a></strong> instance. </p>
</td>
</tr>
<tr id="row808013964084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p345487216084826"><a name="p345487216084826"></a><a name="p345487216084826"></a><a href="Graphic.md#gac2070526833718284148689678c542a9">OHOS::UISlider::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2128600231084826"><a name="p2128600231084826"></a><a name="p2128600231084826"></a>UIViewType&nbsp;</p>
<p id="p331036603084826"><a name="p331036603084826"></a><a name="p331036603084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row787448920084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p272481667084826"><a name="p272481667084826"></a><a name="p272481667084826"></a><a href="Graphic.md#gaf0de71e2d767ccfc3cb41679185a5529">OHOS::UISlider::SetKnobWidth</a> (int16_t width)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1844508801084826"><a name="p1844508801084826"></a><a name="p1844508801084826"></a>void&nbsp;</p>
<p id="p1359432888084826"><a name="p1359432888084826"></a><a name="p1359432888084826"></a>Sets the width for this knob. </p>
</td>
</tr>
<tr id="row826954992084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p398413372084826"><a name="p398413372084826"></a><a name="p398413372084826"></a><a href="Graphic.md#ga9bac904abdf8b097778fea5febc1ec00">OHOS::UISlider::GetKnobWidth</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p532656126084826"><a name="p532656126084826"></a><a name="p532656126084826"></a>int16_t&nbsp;</p>
<p id="p1254626711084826"><a name="p1254626711084826"></a><a name="p1254626711084826"></a>Obtains the knob width. </p>
</td>
</tr>
<tr id="row698969175084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1575959870084826"><a name="p1575959870084826"></a><a name="p1575959870084826"></a><a href="Graphic.md#ga0685ff139a48f556a2323d06470ad301">OHOS::UISlider::SetImage</a> (const <a href="OHOS-ImageInfo.md">ImageInfo</a> *backgroundImage, const <a href="OHOS-ImageInfo.md">ImageInfo</a> *foregroundImage, const <a href="OHOS-ImageInfo.md">ImageInfo</a> *knobImage)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1025338857084826"><a name="p1025338857084826"></a><a name="p1025338857084826"></a>void&nbsp;</p>
<p id="p1721898505084826"><a name="p1721898505084826"></a><a name="p1721898505084826"></a>Sets the images as pixel maps for this slider, including the background, foreground, and knob images. </p>
</td>
</tr>
<tr id="row1613747660084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p634158342084826"><a name="p634158342084826"></a><a name="p634158342084826"></a><a href="Graphic.md#gaea596b36fd10c26361666aeda1aca01e">OHOS::UISlider::SetImage</a> (const char *backgroundImage, const char *foregroundImage, const char *knobImage)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p273183834084826"><a name="p273183834084826"></a><a name="p273183834084826"></a>void&nbsp;</p>
<p id="p430310662084826"><a name="p430310662084826"></a><a name="p430310662084826"></a>Sets the images for this slider, including the background, foreground, and knob images. </p>
</td>
</tr>
<tr id="row1678118285084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p537490975084826"><a name="p537490975084826"></a><a name="p537490975084826"></a><a href="Graphic.md#ga8369feb4c08ec7a01e7200a881acb94b">OHOS::UISlider::SetSliderColor</a> (const <a href="OHOS-Color32.md">ColorType</a> backgroundColor, const <a href="OHOS-Color32.md">ColorType</a> foregroundColor, const <a href="OHOS-Color32.md">ColorType</a> knobColor)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1610066721084826"><a name="p1610066721084826"></a><a name="p1610066721084826"></a>void&nbsp;</p>
<p id="p1928157468084826"><a name="p1928157468084826"></a><a name="p1928157468084826"></a>Sets the colors for this slider, including the background, foreground, and knob colors. </p>
</td>
</tr>
<tr id="row1934327003084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p505259130084826"><a name="p505259130084826"></a><a name="p505259130084826"></a><a href="Graphic.md#ga977ead9a79667465b107ca0776868712">OHOS::UISlider::SetSliderRadius</a> (int16_t backgroundRadius, int16_t foregroundRadius, int16_t knobRadius)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p71580731084826"><a name="p71580731084826"></a><a name="p71580731084826"></a>void&nbsp;</p>
<p id="p998719025084826"><a name="p998719025084826"></a><a name="p998719025084826"></a>Sets the corner radiuses for this slider, including the background, foreground, and knob corner radiuses. </p>
</td>
</tr>
<tr id="row1424052159084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1293765177084826"><a name="p1293765177084826"></a><a name="p1293765177084826"></a><a href="Graphic.md#gac78f9aa2fe12353627a74f87fe49ef4b">OHOS::UISlider::SetKnobStyle</a> (const <a href="OHOS-Style.md">Style</a> &amp;style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1880687211084826"><a name="p1880687211084826"></a><a name="p1880687211084826"></a>void&nbsp;</p>
<p id="p908569688084826"><a name="p908569688084826"></a><a name="p908569688084826"></a>Sets the knob style. </p>
</td>
</tr>
<tr id="row431647582084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p907632540084826"><a name="p907632540084826"></a><a name="p907632540084826"></a><a href="Graphic.md#ga80c30c69e9f565269b09fc9d7ded432e">OHOS::UISlider::SetKnobStyle</a> (uint8_t key, int64_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1799476423084826"><a name="p1799476423084826"></a><a name="p1799476423084826"></a>void&nbsp;</p>
<p id="p616101302084826"><a name="p616101302084826"></a><a name="p616101302084826"></a>Sets a knob style. </p>
</td>
</tr>
<tr id="row742191381084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1612898344084826"><a name="p1612898344084826"></a><a name="p1612898344084826"></a><a href="Graphic.md#gaecf92fe00a7565d034937e89fe2cf1e6">OHOS::UISlider::GetKnobStyle</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1297696329084826"><a name="p1297696329084826"></a><a name="p1297696329084826"></a>const <a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p396206946084826"><a name="p396206946084826"></a><a name="p396206946084826"></a>Obtains the knob style. </p>
</td>
</tr>
<tr id="row1447558098084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2062955489084826"><a name="p2062955489084826"></a><a name="p2062955489084826"></a><a href="Graphic.md#ga1fef57bd5d9a11a9c1946e8efec71b61">OHOS::UISlider::GetKnobStyle</a> (uint8_t key) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p701785184084826"><a name="p701785184084826"></a><a name="p701785184084826"></a>int64_t&nbsp;</p>
<p id="p615949797084826"><a name="p615949797084826"></a><a name="p615949797084826"></a>Obtains the value of a knob style. </p>
</td>
</tr>
<tr id="row251705786084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p232649816084826"><a name="p232649816084826"></a><a name="p232649816084826"></a><a href="Graphic.md#ga05029e55d4ccb50cd45f1cd2a53917e4">OHOS::UISlider::OnClickEvent</a> (const <a href="OHOS-ClickEvent.md">ClickEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1817515168084826"><a name="p1817515168084826"></a><a name="p1817515168084826"></a>void&nbsp;</p>
<p id="p1351675980084826"><a name="p1351675980084826"></a><a name="p1351675980084826"></a>Called when the view is clicked. </p>
</td>
</tr>
<tr id="row137788540084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1770216131084826"><a name="p1770216131084826"></a><a name="p1770216131084826"></a><a href="Graphic.md#ga4481d4453dbf06cc808e4848a814ed7e">OHOS::UISlider::OnDragEvent</a> (const <a href="OHOS-DragEvent.md">DragEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1011444785084826"><a name="p1011444785084826"></a><a name="p1011444785084826"></a>bool&nbsp;</p>
<p id="p54239687084826"><a name="p54239687084826"></a><a name="p54239687084826"></a>Called when the view is being dragged. </p>
</td>
</tr>
<tr id="row1148846108084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p532563754084826"><a name="p532563754084826"></a><a name="p532563754084826"></a><a href="Graphic.md#gae9136559779057065708312fb62304bb">OHOS::UISlider::OnDragEndEvent</a> (const <a href="OHOS-DragEvent.md">DragEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p901987027084826"><a name="p901987027084826"></a><a name="p901987027084826"></a>bool&nbsp;</p>
<p id="p1759956907084826"><a name="p1759956907084826"></a><a name="p1759956907084826"></a>Called when the view stops dragging. </p>
</td>
</tr>
<tr id="row125504245084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1665789709084826"><a name="p1665789709084826"></a><a name="p1665789709084826"></a><a href="Graphic.md#gaf0483e605613ee1789332e67f00f5e2d">OHOS::UISlider::OnPreDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1690466849084826"><a name="p1690466849084826"></a><a name="p1690466849084826"></a>bool&nbsp;</p>
<p id="p665670587084826"><a name="p665670587084826"></a><a name="p665670587084826"></a>Called before a view is drawn. This function is used to check whether the parent view of this view needs to be redrawn so as to optimize the drawing process. </p>
</td>
</tr>
<tr id="row1450103855084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1814591496084826"><a name="p1814591496084826"></a><a name="p1814591496084826"></a><a href="Graphic.md#gad6bd59e05d77868e595d087fd2de5d00">OHOS::UISlider::OnDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2095215901084826"><a name="p2095215901084826"></a><a name="p2095215901084826"></a>void&nbsp;</p>
<p id="p1868694103084826"><a name="p1868694103084826"></a><a name="p1868694103084826"></a>Called when a view is drawn. </p>
</td>
</tr>
<tr id="row1802333428084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1563460852084826"><a name="p1563460852084826"></a><a name="p1563460852084826"></a><a href="Graphic.md#gaf7923989ab1a8cb8a0b643ef65d02134">OHOS::UISlider::UISliderEventListener::~UISliderEventListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p855958671084826"><a name="p855958671084826"></a><a name="p855958671084826"></a>virtual&nbsp;</p>
<p id="p1097135590084826"><a name="p1097135590084826"></a><a name="p1097135590084826"></a>A destructor used to delete the <strong id="b2003722361084826"><a name="b2003722361084826"></a><a name="b2003722361084826"></a> <a href="OHOS-UISlider-UISliderEventListener.md">UISliderEventListener</a> </strong> instance. </p>
</td>
</tr>
<tr id="row1412762892084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p518445766084826"><a name="p518445766084826"></a><a name="p518445766084826"></a><a href="Graphic.md#ga6044e7ac9a27c7a85cc855dd32e4df5e">OHOS::UISlider::UISliderEventListener::OnChange</a> (int16_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1169602405084826"><a name="p1169602405084826"></a><a name="p1169602405084826"></a>virtual void&nbsp;</p>
<p id="p366445539084826"><a name="p366445539084826"></a><a name="p366445539084826"></a>Called when the slider is dragged or clicked. This is a virtual function, which needs your implementation. </p>
</td>
</tr>
<tr id="row300738998084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p335530426084826"><a name="p335530426084826"></a><a name="p335530426084826"></a><a href="Graphic.md#gaf8982c429bfa52c1a8a01d1115b596e6">OHOS::UISlider::UISliderEventListener::OnRelease</a> (int16_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p713542975084826"><a name="p713542975084826"></a><a name="p713542975084826"></a>virtual void&nbsp;</p>
<p id="p128016781084826"><a name="p128016781084826"></a><a name="p128016781084826"></a>Called when the slider is released. This is a virtual function, which needs your implementation. </p>
</td>
</tr>
<tr id="row1627548604084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1423993056084826"><a name="p1423993056084826"></a><a name="p1423993056084826"></a><a href="Graphic.md#ga1319a5ea74ad822cb12b0f48c19ccb5d">OHOS::UISlider::SetSliderEventListener</a> (<a href="OHOS-UISlider-UISliderEventListener.md">UISliderEventListener</a> *listener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1522567923084826"><a name="p1522567923084826"></a><a name="p1522567923084826"></a>void&nbsp;</p>
<p id="p621080643084826"><a name="p621080643084826"></a><a name="p621080643084826"></a>Sets the listener for a slider change. </p>
</td>
</tr>
<tr id="row1921271501084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1787259552084826"><a name="p1787259552084826"></a><a name="p1787259552084826"></a><a href="Graphic.md#gab8acc0b7172486e8e5d48c09fcd4c878">OHOS::UISurfaceView::UISurfaceView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p437540598084826"><a name="p437540598084826"></a><a name="p437540598084826"></a>&nbsp;</p>
<p id="p917331545084826"><a name="p917331545084826"></a><a name="p917331545084826"></a>A constructor used to create a <strong id="b1762969329084826"><a name="b1762969329084826"></a><a name="b1762969329084826"></a><a href="OHOS-UISurfaceView.md">UISurfaceView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1018559338084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2126029728084826"><a name="p2126029728084826"></a><a name="p2126029728084826"></a><a href="Graphic.md#gabf32743913a2a061ace3a5a3c88fe6fa">OHOS::UISurfaceView::~UISurfaceView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1559974321084826"><a name="p1559974321084826"></a><a name="p1559974321084826"></a>&nbsp;</p>
<p id="p1692043220084826"><a name="p1692043220084826"></a><a name="p1692043220084826"></a>A destructor used to delete the <strong id="b1933104854084826"><a name="b1933104854084826"></a><a name="b1933104854084826"></a><a href="OHOS-UISurfaceView.md">UISurfaceView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1451840445084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1085343352084826"><a name="p1085343352084826"></a><a name="p1085343352084826"></a><a href="Graphic.md#ga0d19e491e590bdfeeb2a6b3fa1a6b090">OHOS::UISurfaceView::GetSurface</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p906243045084826"><a name="p906243045084826"></a><a name="p906243045084826"></a><a href="OHOS-Surface.md">Surface</a> *&nbsp;</p>
<p id="p600946503084826"><a name="p600946503084826"></a><a name="p600946503084826"></a>Obtains the surface, which should be used together with the camera and video modules. </p>
</td>
</tr>
<tr id="row278221465084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1700724987084826"><a name="p1700724987084826"></a><a name="p1700724987084826"></a><a href="Graphic.md#ga5d9af67ba074697876ff97f8ece305b7">OHOS::UISurfaceView::SetPosition</a> (int16_t x, int16_t y) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1643789709084826"><a name="p1643789709084826"></a><a name="p1643789709084826"></a>void&nbsp;</p>
<p id="p431221144084826"><a name="p431221144084826"></a><a name="p431221144084826"></a>Sets the position for this view. </p>
</td>
</tr>
<tr id="row1389973802084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p321943155084826"><a name="p321943155084826"></a><a name="p321943155084826"></a><a href="Graphic.md#ga4a505b3b207653c60161d90750f88a9d">OHOS::UISurfaceView::SetPosition</a> (int16_t x, int16_t y, int16_t width, int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1410768836084826"><a name="p1410768836084826"></a><a name="p1410768836084826"></a>void&nbsp;</p>
<p id="p499667029084826"><a name="p499667029084826"></a><a name="p499667029084826"></a>Sets the position and size for this view. </p>
</td>
</tr>
<tr id="row1759439014084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1803719570084826"><a name="p1803719570084826"></a><a name="p1803719570084826"></a><a href="Graphic.md#gaa860971513d96f553be4e251f25c0262">OHOS::UISurfaceView::Resize</a> (int16_t width, int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p346841505084826"><a name="p346841505084826"></a><a name="p346841505084826"></a>void&nbsp;</p>
<p id="p643782228084826"><a name="p643782228084826"></a><a name="p643782228084826"></a>Adjusts the size of this view. </p>
</td>
</tr>
<tr id="row113363948084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p398292081084826"><a name="p398292081084826"></a><a name="p398292081084826"></a><a href="Graphic.md#ga87457cce8ab3daa62852815ad36e9692">OHOS::UISurfaceView::SetX</a> (int16_t x) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p88327372084826"><a name="p88327372084826"></a><a name="p88327372084826"></a>void&nbsp;</p>
<p id="p660080616084826"><a name="p660080616084826"></a><a name="p660080616084826"></a>Sets the x-coordinate for this view. </p>
</td>
</tr>
<tr id="row1269302067084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1031586317084826"><a name="p1031586317084826"></a><a name="p1031586317084826"></a><a href="Graphic.md#gad7e27c2508753b6752594c3615b5d2fe">OHOS::UISurfaceView::SetY</a> (int16_t y) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p489021291084826"><a name="p489021291084826"></a><a name="p489021291084826"></a>void&nbsp;</p>
<p id="p1361343697084826"><a name="p1361343697084826"></a><a name="p1361343697084826"></a>Sets the y-coordinate for this view. </p>
</td>
</tr>
<tr id="row981786727084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1018763941084826"><a name="p1018763941084826"></a><a name="p1018763941084826"></a><a href="Graphic.md#ga54c350b75cf87ca112b3c21791f9c559">OHOS::UISurfaceView::SetWidth</a> (int16_t width) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1629041637084826"><a name="p1629041637084826"></a><a name="p1629041637084826"></a>void&nbsp;</p>
<p id="p1389917197084826"><a name="p1389917197084826"></a><a name="p1389917197084826"></a>Sets the width for this view. </p>
</td>
</tr>
<tr id="row1160873764084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p659354337084826"><a name="p659354337084826"></a><a name="p659354337084826"></a><a href="Graphic.md#gaf90ada30a3336b947951d408b685787e">OHOS::UISurfaceView::SetHeight</a> (int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2077749066084826"><a name="p2077749066084826"></a><a name="p2077749066084826"></a>void&nbsp;</p>
<p id="p299634426084826"><a name="p299634426084826"></a><a name="p299634426084826"></a>Sets the height for this view. </p>
</td>
</tr>
<tr id="row953207643084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p978645517084826"><a name="p978645517084826"></a><a name="p978645517084826"></a><a href="Graphic.md#gaa6b5efec0684a2800dba70c697d3902e">OHOS::UISurfaceView::SetVisible</a> (bool visible) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1800013015084826"><a name="p1800013015084826"></a><a name="p1800013015084826"></a>void&nbsp;</p>
<p id="p1292711418084826"><a name="p1292711418084826"></a><a name="p1292711418084826"></a>Sets whether this view is visible. </p>
</td>
</tr>
<tr id="row1653100855084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p780203240084826"><a name="p780203240084826"></a><a name="p780203240084826"></a><a href="Graphic.md#gaeb15d1fb86ad2e2aabddc9c36676894a">OHOS::UISurfaceView::OnPreDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p605384411084826"><a name="p605384411084826"></a><a name="p605384411084826"></a>bool&nbsp;</p>
<p id="p175840739084826"><a name="p175840739084826"></a><a name="p175840739084826"></a>Called before this view is drawn. This function is used to check whether the parent view of this view needs to be redrawn so that the drawing process is optimized. </p>
</td>
</tr>
<tr id="row1778598708084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p73458364084826"><a name="p73458364084826"></a><a name="p73458364084826"></a><a href="Graphic.md#ga30a99c506c6d8d8fc0e0bd81d52e2d52">OHOS::UISurfaceView::OnDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1581388662084826"><a name="p1581388662084826"></a><a name="p1581388662084826"></a>void&nbsp;</p>
<p id="p690846100084826"><a name="p690846100084826"></a><a name="p690846100084826"></a>Called when this view is drawn. </p>
</td>
</tr>
<tr id="row104477134084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2017282076084826"><a name="p2017282076084826"></a><a name="p2017282076084826"></a><a href="Graphic.md#ga3a460525251fde8e30c35be808151509">OHOS::UISwipeView::UISwipeView</a> (uint8_t direction=<a href="Graphic.md#ga34dfbde0fad8baade31c02d9e8dd5026">HORIZONTAL</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1928746217084826"><a name="p1928746217084826"></a><a name="p1928746217084826"></a>&nbsp;</p>
<p id="p1672384359084826"><a name="p1672384359084826"></a><a name="p1672384359084826"></a>A constructor used to create a <strong id="b698231649084826"><a name="b698231649084826"></a><a name="b698231649084826"></a><a href="OHOS-UISwipeView.md">UISwipeView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1471300151084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1399348212084826"><a name="p1399348212084826"></a><a name="p1399348212084826"></a><a href="Graphic.md#gaf51c21b72dcbe790c3bb7b83b53b3cef">OHOS::UISwipeView::~UISwipeView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1664066637084826"><a name="p1664066637084826"></a><a name="p1664066637084826"></a>virtual&nbsp;</p>
<p id="p1544826091084826"><a name="p1544826091084826"></a><a name="p1544826091084826"></a>A destructor used to delete the <strong id="b1207294028084826"><a name="b1207294028084826"></a><a name="b1207294028084826"></a><a href="OHOS-UISwipeView.md">UISwipeView</a></strong> instance. </p>
</td>
</tr>
<tr id="row973032684084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p881123969084826"><a name="p881123969084826"></a><a name="p881123969084826"></a><a href="Graphic.md#ga71ae0dd892d8d9b8d277ba2b5572182d">OHOS::UISwipeView::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p871430720084826"><a name="p871430720084826"></a><a name="p871430720084826"></a>UIViewType&nbsp;</p>
<p id="p1036653157084826"><a name="p1036653157084826"></a><a name="p1036653157084826"></a>Obtains the component type. </p>
</td>
</tr>
<tr id="row1720026402084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p909123872084826"><a name="p909123872084826"></a><a name="p909123872084826"></a><a href="Graphic.md#ga29be43640abe185baef5ead904a729cb">OHOS::UISwipeView::SetDirection</a> (uint8_t direction)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p744924144084826"><a name="p744924144084826"></a><a name="p744924144084826"></a>void&nbsp;</p>
<p id="p2128377291084826"><a name="p2128377291084826"></a><a name="p2128377291084826"></a>Sets the dragging direction. </p>
</td>
</tr>
<tr id="row1602393977084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1979262228084826"><a name="p1979262228084826"></a><a name="p1979262228084826"></a><a href="Graphic.md#gad84dab74af54c23e6e724bdebb8b7df9">OHOS::UISwipeView::GetDirection</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p686915476084826"><a name="p686915476084826"></a><a name="p686915476084826"></a>uint8_t&nbsp;</p>
<p id="p1699768066084826"><a name="p1699768066084826"></a><a name="p1699768066084826"></a>Obtains the dragging direction. </p>
</td>
</tr>
<tr id="row616019694084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p182517137084826"><a name="p182517137084826"></a><a name="p182517137084826"></a><a href="Graphic.md#ga1cdc37a33412d6134ed7214300bc1c87">OHOS::UISwipeView::Add</a> (<a href="OHOS-UIView.md">UIView</a> *view) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p406108557084826"><a name="p406108557084826"></a><a name="p406108557084826"></a>void&nbsp;</p>
<p id="p1635947075084826"><a name="p1635947075084826"></a><a name="p1635947075084826"></a>Adds a view. </p>
</td>
</tr>
<tr id="row1515436273084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p974676671084826"><a name="p974676671084826"></a><a name="p974676671084826"></a><a href="Graphic.md#ga154efaf952ba1db65e53efdd29f0027b">OHOS::UISwipeView::Insert</a> (<a href="OHOS-UIView.md">UIView</a> *prevView, <a href="OHOS-UIView.md">UIView</a> *insertView) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1808765637084826"><a name="p1808765637084826"></a><a name="p1808765637084826"></a>void&nbsp;</p>
<p id="p299215464084826"><a name="p299215464084826"></a><a name="p299215464084826"></a>Inserts a view. </p>
</td>
</tr>
<tr id="row122678692084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p58578303084826"><a name="p58578303084826"></a><a name="p58578303084826"></a><a href="Graphic.md#ga2a4f70938a7d2298a318dff6dff95e85">OHOS::UISwipeView::Remove</a> (<a href="OHOS-UIView.md">UIView</a> *view) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p292667712084826"><a name="p292667712084826"></a><a name="p292667712084826"></a>virtual void&nbsp;</p>
<p id="p1326796087084826"><a name="p1326796087084826"></a><a name="p1326796087084826"></a>Deletes a view. </p>
</td>
</tr>
<tr id="row838769651084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p298207466084826"><a name="p298207466084826"></a><a name="p298207466084826"></a><a href="Graphic.md#gaedb8649e42a712463158f42eb66efc33">OHOS::UISwipeView::SetCurrentPage</a> (uint16_t <a href="UTILS.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>, bool needAnimator=false)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1365910814084826"><a name="p1365910814084826"></a><a name="p1365910814084826"></a>void&nbsp;</p>
<p id="p670100014084826"><a name="p670100014084826"></a><a name="p670100014084826"></a>Sets the index for the current tab. </p>
</td>
</tr>
<tr id="row1595805539084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1767574992084826"><a name="p1767574992084826"></a><a name="p1767574992084826"></a><a href="Graphic.md#gaea0c52e94714dff049117227a1fd1849">OHOS::UISwipeView::GetCurrentPage</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p889153837084826"><a name="p889153837084826"></a><a name="p889153837084826"></a>uint16_t&nbsp;</p>
<p id="p1876543299084826"><a name="p1876543299084826"></a><a name="p1876543299084826"></a>Obtains the current tab index. </p>
</td>
</tr>
<tr id="row1944682918084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1185733328084826"><a name="p1185733328084826"></a><a name="p1185733328084826"></a><a href="Graphic.md#ga9b91ece1e4492afd3e4705e49bc511f3">OHOS::UISwipeView::GetCurrentView</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1120082277084826"><a name="p1120082277084826"></a><a name="p1120082277084826"></a><a href="OHOS-UIView.md">UIView</a> *&nbsp;</p>
<p id="p988233839084826"><a name="p988233839084826"></a><a name="p988233839084826"></a>Obtains the current view. </p>
</td>
</tr>
<tr id="row362870071084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1586704682084826"><a name="p1586704682084826"></a><a name="p1586704682084826"></a><a href="Graphic.md#ga834d61387b0243cd0505f6d03d32a8f8">OHOS::UISwipeView::SetBlankSize</a> (uint16_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p570642549084826"><a name="p570642549084826"></a><a name="p570642549084826"></a>void&nbsp;</p>
<p id="p1515686215084826"><a name="p1515686215084826"></a><a name="p1515686215084826"></a>Sets a blank size, as defined in <a href="Graphic.md#ga81883a607d2cb3356560fc0f8f84cf74">DEFAULT_BLANK_SIZE</a>. </p>
</td>
</tr>
<tr id="row1146921546084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1743045827084826"><a name="p1743045827084826"></a><a name="p1743045827084826"></a><a href="Graphic.md#ga888ec9a6ddaa4051e7c2e5d76832565c">OHOS::UISwipeView::OnDragEvent</a> (const <a href="OHOS-DragEvent.md">DragEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1265101286084826"><a name="p1265101286084826"></a><a name="p1265101286084826"></a>bool&nbsp;</p>
<p id="p1543936291084826"><a name="p1543936291084826"></a><a name="p1543936291084826"></a>revice drag event, Switch to specified view when drag </p>
</td>
</tr>
<tr id="row1922821491084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p416824171084826"><a name="p416824171084826"></a><a name="p416824171084826"></a><a href="Graphic.md#gab57d973cea1186dd90eec91cd27da1fb">OHOS::UISwipeView::OnDragEndEvent</a> (const <a href="OHOS-DragEvent.md">DragEvent</a> &amp;event) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1295333620084826"><a name="p1295333620084826"></a><a name="p1295333620084826"></a>bool&nbsp;</p>
<p id="p697764149084826"><a name="p697764149084826"></a><a name="p697764149084826"></a>Called when the view stops dragging. </p>
</td>
</tr>
<tr id="row2018001010084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1445962930084826"><a name="p1445962930084826"></a><a name="p1445962930084826"></a><a href="Graphic.md#gadb01e8e5702625c3a99f383eb7ae1664">OHOS::UISwipeView::SetAnimatorTime</a> (uint16_t <a href="TIME.md#gae7841e681c8c9d59818568d39553642c">time</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2141797189084826"><a name="p2141797189084826"></a><a name="p2141797189084826"></a>void&nbsp;</p>
<p id="p1442592537084826"><a name="p1442592537084826"></a><a name="p1442592537084826"></a>Sets the time for the page being animated. The page will go beyond the blank during this time. </p>
</td>
</tr>
<tr id="row164601798084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p881721049084826"><a name="p881721049084826"></a><a name="p881721049084826"></a><a href="Graphic.md#ga7f7dce8193817e29c9b82af47934d788">OHOS::UISwipeView::SetLoopState</a> (bool loop)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p652881334084826"><a name="p652881334084826"></a><a name="p652881334084826"></a>void&nbsp;</p>
<p id="p1022163038084826"><a name="p1022163038084826"></a><a name="p1022163038084826"></a>Sets whether the swipe view supports a cycle swipe. </p>
</td>
</tr>
<tr id="row1743354710084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p295202062084826"><a name="p295202062084826"></a><a name="p295202062084826"></a><a href="Graphic.md#ga3c58441c4b07cf575b96b85df5e3a3bf">OHOS::UISwipeView::GetViewByIndex</a> (uint16_t <a href="UTILS.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p44751793084826"><a name="p44751793084826"></a><a name="p44751793084826"></a><a href="OHOS-UIView.md">UIView</a> *&nbsp;</p>
<p id="p554812735084826"><a name="p554812735084826"></a><a name="p554812735084826"></a>Obtains a view based on its index. </p>
</td>
</tr>
<tr id="row1097587917084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p207076182084826"><a name="p207076182084826"></a><a name="p207076182084826"></a><a href="Graphic.md#ga4c33414b3a828d1750deed3cceb86daf">OHOS::UISwipeView::GetOnSwipeListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p728144569084826"><a name="p728144569084826"></a><a name="p728144569084826"></a><a href="OHOS-UISwipeView-OnSwipeListener.md">OnSwipeListener</a> *&amp;&nbsp;</p>
<p id="p1620633060084826"><a name="p1620633060084826"></a><a name="p1620633060084826"></a>Obtains the listener set for swipe events. </p>
</td>
</tr>
<tr id="row410773465084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2011005426084826"><a name="p2011005426084826"></a><a name="p2011005426084826"></a><a href="Graphic.md#ga7d4a3dc25f189ab19eaef4a62cd0428e">OHOS::UISwipeView::SetOnSwipeListener</a> (<a href="OHOS-UISwipeView-OnSwipeListener.md">OnSwipeListener</a> *onSwipeListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p550158657084826"><a name="p550158657084826"></a><a name="p550158657084826"></a>void&nbsp;</p>
<p id="p537280492084826"><a name="p537280492084826"></a><a name="p537280492084826"></a>Sets the listener that contains a callback to be invoked upon a swipe event. </p>
</td>
</tr>
<tr id="row1633282837084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p709701679084826"><a name="p709701679084826"></a><a name="p709701679084826"></a><a href="Graphic.md#ga4db88368bb4908ee05aa1137982b6d0e">OHOS::UISwipeView::MoveChildByOffset</a> (int16_t xOffset, int16_t yOffset) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p928843429084826"><a name="p928843429084826"></a><a name="p928843429084826"></a>void&nbsp;</p>
<p id="p1336794042084826"><a name="p1336794042084826"></a><a name="p1336794042084826"></a>Moves the position of all child views. </p>
</td>
</tr>
<tr id="row203437688084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p990676664084826"><a name="p990676664084826"></a><a name="p990676664084826"></a><a href="Graphic.md#gaff111e4883be7412bfd6a41d769d9e77">OHOS::UITextureMapper::UITextureMapper</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p516536291084826"><a name="p516536291084826"></a><a name="p516536291084826"></a>&nbsp;</p>
<p id="p971192848084826"><a name="p971192848084826"></a><a name="p971192848084826"></a>A constructor used to create a <strong id="b895559606084826"><a name="b895559606084826"></a><a name="b895559606084826"></a><a href="OHOS-UITextureMapper.md">UITextureMapper</a></strong> instance. </p>
</td>
</tr>
<tr id="row933636634084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p187565810084826"><a name="p187565810084826"></a><a name="p187565810084826"></a><a href="Graphic.md#ga6c7e34e3ecc1d300e647483aed10c4cf">OHOS::UITextureMapper::~UITextureMapper</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p176910632084826"><a name="p176910632084826"></a><a name="p176910632084826"></a>virtual&nbsp;</p>
<p id="p2025371716084826"><a name="p2025371716084826"></a><a name="p2025371716084826"></a>A destructor used to delete the <strong id="b821186681084826"><a name="b821186681084826"></a><a name="b821186681084826"></a><a href="OHOS-UITextureMapper.md">UITextureMapper</a></strong> instance. </p>
</td>
</tr>
<tr id="row1829346150084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1866658966084826"><a name="p1866658966084826"></a><a name="p1866658966084826"></a><a href="Graphic.md#ga5cb1566d1fdd815004a37349dc458203">OHOS::UITextureMapper::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2028755991084826"><a name="p2028755991084826"></a><a name="p2028755991084826"></a>UIViewType&nbsp;</p>
<p id="p180470874084826"><a name="p180470874084826"></a><a name="p180470874084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row1506562461084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p177809282084826"><a name="p177809282084826"></a><a name="p177809282084826"></a><a href="Graphic.md#ga83f0469f24917e59c3c6d7b331928014">OHOS::UITextureMapper::Start</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1871316173084826"><a name="p1871316173084826"></a><a name="p1871316173084826"></a>void&nbsp;</p>
<p id="p1649708761084826"><a name="p1649708761084826"></a><a name="p1649708761084826"></a>Starts this animator. </p>
</td>
</tr>
<tr id="row818733184084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p709786261084826"><a name="p709786261084826"></a><a name="p709786261084826"></a><a href="Graphic.md#ga98a7e074315fdf49b6a9c0663848c9aa">OHOS::UITextureMapper::SetRotateStart</a> (int16_t start)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2092898031084826"><a name="p2092898031084826"></a><a name="p2092898031084826"></a>void&nbsp;</p>
<p id="p314275820084826"><a name="p314275820084826"></a><a name="p314275820084826"></a>Sets the start angle of rotation for this image. </p>
</td>
</tr>
<tr id="row124285904084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p122131726084826"><a name="p122131726084826"></a><a name="p122131726084826"></a><a href="Graphic.md#ga9bb2570b86ef683f8a501e98f8689ed5">OHOS::UITextureMapper::SetRotateEnd</a> (int16_t end)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p684455994084826"><a name="p684455994084826"></a><a name="p684455994084826"></a>void&nbsp;</p>
<p id="p2029131266084826"><a name="p2029131266084826"></a><a name="p2029131266084826"></a>Sets the end angle of rotation for this image. </p>
</td>
</tr>
<tr id="row2043844863084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1801442546084826"><a name="p1801442546084826"></a><a name="p1801442546084826"></a><a href="Graphic.md#ga31a2295a15e2e990a1f2484f5756609b">OHOS::UITextureMapper::SetScaleStart</a> (float start)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p19357543084826"><a name="p19357543084826"></a><a name="p19357543084826"></a>void&nbsp;</p>
<p id="p1532508494084826"><a name="p1532508494084826"></a><a name="p1532508494084826"></a>Sets the start ratio for scaling this image. </p>
</td>
</tr>
<tr id="row574499623084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1081579446084826"><a name="p1081579446084826"></a><a name="p1081579446084826"></a><a href="Graphic.md#ga7c7c54ce9ab139498ba286762286c0c0">OHOS::UITextureMapper::SetScaleEnd</a> (float end)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p302008857084826"><a name="p302008857084826"></a><a name="p302008857084826"></a>void&nbsp;</p>
<p id="p825965171084826"><a name="p825965171084826"></a><a name="p825965171084826"></a>Sets the end ratio for scaling this image. </p>
</td>
</tr>
<tr id="row835082857084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p952345335084826"><a name="p952345335084826"></a><a name="p952345335084826"></a><a href="Graphic.md#gac2727b2cd7aa7abead44717cf0ce7b3c">OHOS::UITextureMapper::SetDurationTime</a> (uint16_t durationTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1605168695084826"><a name="p1605168695084826"></a><a name="p1605168695084826"></a>void&nbsp;</p>
<p id="p2118081600084826"><a name="p2118081600084826"></a><a name="p2118081600084826"></a>Sets the duration for this animator, in milliseconds. </p>
</td>
</tr>
<tr id="row1691799826084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1792183117084826"><a name="p1792183117084826"></a><a name="p1792183117084826"></a><a href="Graphic.md#gaa2d428cb1098dafb21e7dd24f6ba612f">OHOS::UITextureMapper::SetDelayTime</a> (uint16_t delayTime)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1477294462084826"><a name="p1477294462084826"></a><a name="p1477294462084826"></a>void&nbsp;</p>
<p id="p1733163660084826"><a name="p1733163660084826"></a><a name="p1733163660084826"></a>Sets the delay time for this animator, in milliseconds. </p>
</td>
</tr>
<tr id="row2087101152084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p727661665084826"><a name="p727661665084826"></a><a name="p727661665084826"></a><a href="Graphic.md#ga0f099914c2daa13dc6acf3fb28c3f45a">OHOS::UITextureMapper::SetEasingFunc</a> (EasingFunc easingFunc)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p554318631084826"><a name="p554318631084826"></a><a name="p554318631084826"></a>void&nbsp;</p>
<p id="p1431459711084826"><a name="p1431459711084826"></a><a name="p1431459711084826"></a>Sets the easing function for this animator. </p>
</td>
</tr>
<tr id="row1526744543084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1551859579084826"><a name="p1551859579084826"></a><a name="p1551859579084826"></a><a href="Graphic.md#gac838ad321786766c6d4020504b07b93b">OHOS::UITextureMapper::Cancel</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p353084724084826"><a name="p353084724084826"></a><a name="p353084724084826"></a>void&nbsp;</p>
<p id="p716996815084826"><a name="p716996815084826"></a><a name="p716996815084826"></a>Cancels this animator. </p>
</td>
</tr>
<tr id="row344307052084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1579912110084826"><a name="p1579912110084826"></a><a name="p1579912110084826"></a><a href="Graphic.md#gac18ead79047d6f63e1ceb5fc52bbff68">OHOS::UITextureMapper::Reset</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p82069233084826"><a name="p82069233084826"></a><a name="p82069233084826"></a>void&nbsp;</p>
<p id="p76319697084826"><a name="p76319697084826"></a><a name="p76319697084826"></a>Displays the original image. </p>
</td>
</tr>
<tr id="row762478444084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1439099640084826"><a name="p1439099640084826"></a><a name="p1439099640084826"></a><a href="Graphic.md#ga44fa62a21869361527a8af1a10e5276e">OHOS::UITextureMapper::SetPivot</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p213984117084826"><a name="p213984117084826"></a><a name="p213984117084826"></a>void&nbsp;</p>
<p id="p2018394745084826"><a name="p2018394745084826"></a><a name="p2018394745084826"></a>Sets the coordinates of the rotation and scaling pivots for this image. </p>
</td>
</tr>
<tr id="row1434578250084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1841530723084826"><a name="p1841530723084826"></a><a name="p1841530723084826"></a><a href="Graphic.md#ga7165af78c57699d722f5264dcdf5d6dd">OHOS::UITextureMapper::AnimatorStopListener::~AnimatorStopListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p123088685084826"><a name="p123088685084826"></a><a name="p123088685084826"></a>virtual&nbsp;</p>
<p id="p1476111644084826"><a name="p1476111644084826"></a><a name="p1476111644084826"></a>A destructor used to delete an <strong id="b2052784349084826"><a name="b2052784349084826"></a><a name="b2052784349084826"></a><a href="OHOS-UITextureMapper-AnimatorStopListener.md">AnimatorStopListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row864184810084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2011787342084826"><a name="p2011787342084826"></a><a name="p2011787342084826"></a><a href="Graphic.md#ga20fee882d590dd429742acff4357ea67">OHOS::UITextureMapper::AnimatorStopListener::OnAnimatorStop</a> (<a href="OHOS-UIView.md">UIView</a> &amp;view)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p837396789084826"><a name="p837396789084826"></a><a name="p837396789084826"></a>virtual void&nbsp;</p>
<p id="p66725263084826"><a name="p66725263084826"></a><a name="p66725263084826"></a>Called when this animator stops. This is a pure virtual function, which needs your inheritance and implementation. </p>
</td>
</tr>
<tr id="row1815234804084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p476461223084826"><a name="p476461223084826"></a><a name="p476461223084826"></a><a href="Graphic.md#gaab25406cdcb4af33cfd2cc2c31037d27">OHOS::UITextureMapper::SetAnimatorStopListener</a> (<a href="OHOS-UITextureMapper-AnimatorStopListener.md">AnimatorStopListener</a> *listener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p158835571084826"><a name="p158835571084826"></a><a name="p158835571084826"></a>void&nbsp;</p>
<p id="p69622292084826"><a name="p69622292084826"></a><a name="p69622292084826"></a>Sets the listener for the stop of this animator. </p>
</td>
</tr>
<tr id="row400852818084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p820114687084826"><a name="p820114687084826"></a><a name="p820114687084826"></a><a href="Graphic.md#ga125b46b02ee28c0ba6403ef024196b03">OHOS::UITimePicker::UITimePicker</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1541149680084826"><a name="p1541149680084826"></a><a name="p1541149680084826"></a>&nbsp;</p>
<p id="p666164906084826"><a name="p666164906084826"></a><a name="p666164906084826"></a>A constructor used to create a <strong id="b1671606925084826"><a name="b1671606925084826"></a><a name="b1671606925084826"></a><a href="OHOS-UITimePicker.md">UITimePicker</a></strong> instance. </p>
</td>
</tr>
<tr id="row1098532286084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1190775333084826"><a name="p1190775333084826"></a><a name="p1190775333084826"></a><a href="Graphic.md#gaf5906b1a1389a599c0086f25cfc02fa0">OHOS::UITimePicker::~UITimePicker</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p877691280084826"><a name="p877691280084826"></a><a name="p877691280084826"></a>virtual&nbsp;</p>
<p id="p1267649381084826"><a name="p1267649381084826"></a><a name="p1267649381084826"></a>A destructor used to delete the <strong id="b1344018213084826"><a name="b1344018213084826"></a><a name="b1344018213084826"></a><a href="OHOS-UITimePicker.md">UITimePicker</a></strong> instance. </p>
</td>
</tr>
<tr id="row78712157084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2021318605084826"><a name="p2021318605084826"></a><a name="p2021318605084826"></a><a href="Graphic.md#gaf4770cfad2f6368b22e9ea581b12aefa">OHOS::UITimePicker::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p873583677084826"><a name="p873583677084826"></a><a name="p873583677084826"></a>UIViewType&nbsp;</p>
<p id="p2072890788084826"><a name="p2072890788084826"></a><a name="p2072890788084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row736652718084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p509624583084826"><a name="p509624583084826"></a><a name="p509624583084826"></a><a href="Graphic.md#gaecddab27ffd11267d3f613a1cf7f1549">OHOS::UITimePicker::SetSelected</a> (const char *value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p321093392084826"><a name="p321093392084826"></a><a name="p321093392084826"></a>bool&nbsp;</p>
<p id="p1556968161084826"><a name="p1556968161084826"></a><a name="p1556968161084826"></a>Sets the time currently selected in the time picker. </p>
</td>
</tr>
<tr id="row2108259663084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1122095555084826"><a name="p1122095555084826"></a><a name="p1122095555084826"></a><a href="Graphic.md#gac8c1732e78fa64af294694b2bbb35366">OHOS::UITimePicker::GetSelectValue</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1230169624084826"><a name="p1230169624084826"></a><a name="p1230169624084826"></a>const char *&nbsp;</p>
<p id="p1373254653084826"><a name="p1373254653084826"></a><a name="p1373254653084826"></a>Obtains the time currently selected in the time picker. </p>
</td>
</tr>
<tr id="row515036866084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1727502835084826"><a name="p1727502835084826"></a><a name="p1727502835084826"></a><a href="Graphic.md#gac6475a538bb4e0e839dd8f9b0e3ae200">OHOS::UITimePicker::GetSelectHour</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1971348357084826"><a name="p1971348357084826"></a><a name="p1971348357084826"></a>const char *&nbsp;</p>
<p id="p1612678668084826"><a name="p1612678668084826"></a><a name="p1612678668084826"></a>Obtains the hour currently selected in the time picker. </p>
</td>
</tr>
<tr id="row627601789084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1635756411084826"><a name="p1635756411084826"></a><a name="p1635756411084826"></a><a href="Graphic.md#ga0ccecc8d45fdda042ea0667ab9cc1181">OHOS::UITimePicker::GetSelectMinute</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p199447249084826"><a name="p199447249084826"></a><a name="p199447249084826"></a>const char *&nbsp;</p>
<p id="p1234930367084826"><a name="p1234930367084826"></a><a name="p1234930367084826"></a>Obtains the minute currently selected in the time picker. </p>
</td>
</tr>
<tr id="row1090920856084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1128458785084826"><a name="p1128458785084826"></a><a name="p1128458785084826"></a><a href="Graphic.md#ga2e02f298f9b9bcf0520ebd2d0ef40677">OHOS::UITimePicker::GetSelectSecond</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p983144382084826"><a name="p983144382084826"></a><a name="p983144382084826"></a>const char *&nbsp;</p>
<p id="p5292576084826"><a name="p5292576084826"></a><a name="p5292576084826"></a>Obtains the second currently selected in the time picker. </p>
</td>
</tr>
<tr id="row84084739084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1497856444084826"><a name="p1497856444084826"></a><a name="p1497856444084826"></a><a href="Graphic.md#ga54e8588b0be58272d1fef244c5e9ba27">OHOS::UITimePicker::SetItemHeight</a> (int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p831178284084826"><a name="p831178284084826"></a><a name="p831178284084826"></a>void&nbsp;</p>
<p id="p1165475839084826"><a name="p1165475839084826"></a><a name="p1165475839084826"></a>Sets the height of each item in the time picker. </p>
</td>
</tr>
<tr id="row767728938084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2056055281084826"><a name="p2056055281084826"></a><a name="p2056055281084826"></a><a href="Graphic.md#gaa2402a0538f08fb4d6857c356be7699c">OHOS::UITimePicker::EnableSecond</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1518881608084826"><a name="p1518881608084826"></a><a name="p1518881608084826"></a>void&nbsp;</p>
<p id="p1125643819084826"><a name="p1125643819084826"></a><a name="p1125643819084826"></a>Sets whether to enable seconds in the time picker. </p>
</td>
</tr>
<tr id="row1564017076084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2004594082084826"><a name="p2004594082084826"></a><a name="p2004594082084826"></a><a href="Graphic.md#gab1847d20b4ae671aaa512f978e043ee1">OHOS::UITimePicker::SetTextStyle</a> (uint8_t backgroundFontId, uint8_t highlightFontId, <a href="OHOS-Color32.md">ColorType</a> backgroundColor, <a href="OHOS-Color32.md">ColorType</a> highlightColor)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p791421007084826"><a name="p791421007084826"></a><a name="p791421007084826"></a>void&nbsp;</p>
<p id="p1889671395084826"><a name="p1889671395084826"></a><a name="p1889671395084826"></a>Sets the text format in the time picker, including the font ID and color. </p>
</td>
</tr>
<tr id="row1743211893084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1567218348084826"><a name="p1567218348084826"></a><a name="p1567218348084826"></a><a href="Graphic.md#gad8dc3b2df7fe8aed16776a063efc8b4b">OHOS::UITimePicker::SetWidth</a> (int16_t width) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1995657969084826"><a name="p1995657969084826"></a><a name="p1995657969084826"></a>void&nbsp;</p>
<p id="p852109655084826"><a name="p852109655084826"></a><a name="p852109655084826"></a>Sets the width for the time picker. </p>
</td>
</tr>
<tr id="row171158648084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1513088569084826"><a name="p1513088569084826"></a><a name="p1513088569084826"></a><a href="Graphic.md#ga06667e791f24098f22ef096ee6af77ad">OHOS::UITimePicker::SetHeight</a> (int16_t height) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p404654326084826"><a name="p404654326084826"></a><a name="p404654326084826"></a>void&nbsp;</p>
<p id="p1725371511084826"><a name="p1725371511084826"></a><a name="p1725371511084826"></a>Sets the height for the time picker. </p>
</td>
</tr>
<tr id="row906290546084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p380178277084826"><a name="p380178277084826"></a><a name="p380178277084826"></a><a href="Graphic.md#gaf68f896c9d4e4c14a56c201d8e4b3db1">OHOS::UITimePicker::SelectedListener::SelectedListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p297404183084826"><a name="p297404183084826"></a><a name="p297404183084826"></a>&nbsp;</p>
<p id="p1163917718084826"><a name="p1163917718084826"></a><a name="p1163917718084826"></a>A constructor used to create a <strong id="b1110821504084826"><a name="b1110821504084826"></a><a name="b1110821504084826"></a><a href="OHOS-UITimePicker-SelectedListener.md">SelectedListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row1785410389084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p518537665084826"><a name="p518537665084826"></a><a name="p518537665084826"></a><a href="Graphic.md#ga59db1409429fa0c598e3cf70a8ec2738">OHOS::UITimePicker::SelectedListener::~SelectedListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p119044984084826"><a name="p119044984084826"></a><a name="p119044984084826"></a>&nbsp;</p>
<p id="p1430666341084826"><a name="p1430666341084826"></a><a name="p1430666341084826"></a>A destructor used to delete the <strong id="b368811243084826"><a name="b368811243084826"></a><a name="b368811243084826"></a><a href="OHOS-UITimePicker-SelectedListener.md">SelectedListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row1746372357084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p29861584084826"><a name="p29861584084826"></a><a name="p29861584084826"></a><a href="Graphic.md#ga525c9a0f0c5b51e0086a53dc5b0b5301">OHOS::UITimePicker::SelectedListener::OnTimePickerStoped</a> (<a href="OHOS-UITimePicker.md">UITimePicker</a> &amp;picker)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p551860492084826"><a name="p551860492084826"></a><a name="p551860492084826"></a>virtual void&nbsp;</p>
<p id="p68534505084826"><a name="p68534505084826"></a><a name="p68534505084826"></a>Called when an item is selected after sliding stops. This function is implemented by applications. </p>
</td>
</tr>
<tr id="row1785497524084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2004519178084826"><a name="p2004519178084826"></a><a name="p2004519178084826"></a><a href="Graphic.md#gaa49ecf72e74e9b835c6fc19c701bf454">OHOS::UITimePicker::RegisterSelectedListener</a> (<a href="OHOS-UITimePicker-SelectedListener.md">SelectedListener</a> *timePickerListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p180249385084826"><a name="p180249385084826"></a><a name="p180249385084826"></a>void&nbsp;</p>
<p id="p164524615084826"><a name="p164524615084826"></a><a name="p164524615084826"></a>Registers a listener for a selected event. </p>
</td>
</tr>
<tr id="row99385884084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1172156445084826"><a name="p1172156445084826"></a><a name="p1172156445084826"></a><a href="Graphic.md#ga98d6bb49e21d7748020b75a9f5f1c61d">OHOS::UIToggleButton::UIToggleButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1427305359084826"><a name="p1427305359084826"></a><a name="p1427305359084826"></a>&nbsp;</p>
<p id="p49729402084826"><a name="p49729402084826"></a><a name="p49729402084826"></a>A constructor used to create a <strong id="b1300368936084826"><a name="b1300368936084826"></a><a name="b1300368936084826"></a><a href="OHOS-UIToggleButton.md">UIToggleButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row246078868084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1994397661084826"><a name="p1994397661084826"></a><a name="p1994397661084826"></a><a href="Graphic.md#ga4946fb71fed32a4f328ecdd1da3141c5">OHOS::UIToggleButton::~UIToggleButton</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p961773010084826"><a name="p961773010084826"></a><a name="p961773010084826"></a>virtual&nbsp;</p>
<p id="p1141129321084826"><a name="p1141129321084826"></a><a name="p1141129321084826"></a>A destructor used to delete the <strong id="b35951874084826"><a name="b35951874084826"></a><a name="b35951874084826"></a><a href="OHOS-UIToggleButton.md">UIToggleButton</a></strong> instance. </p>
</td>
</tr>
<tr id="row42976341084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1825039690084826"><a name="p1825039690084826"></a><a name="p1825039690084826"></a><a href="Graphic.md#gaeb2bf2bfa7b5f229a151bec4fd046b40">OHOS::UIToggleButton::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1994942855084826"><a name="p1994942855084826"></a><a name="p1994942855084826"></a>UIViewType&nbsp;</p>
<p id="p922147941084826"><a name="p922147941084826"></a><a name="p922147941084826"></a>Obtains the component type. </p>
</td>
</tr>
<tr id="row1629302779084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p360958197084826"><a name="p360958197084826"></a><a name="p360958197084826"></a><a href="Graphic.md#ga73354e99d22f2fe8b44f1c11c8d62fd0">OHOS::UIToggleButton::SetState</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1614224395084826"><a name="p1614224395084826"></a><a name="p1614224395084826"></a>void&nbsp;</p>
<p id="p648559709084826"><a name="p648559709084826"></a><a name="p648559709084826"></a>Sets the state for this toggle button. </p>
</td>
</tr>
<tr id="row1917975874084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p203649012084826"><a name="p203649012084826"></a><a name="p203649012084826"></a><a href="Graphic.md#gad46154853ea44173988a82fa366f16db">OHOS::UIToggleButton::GetState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p63972108084826"><a name="p63972108084826"></a><a name="p63972108084826"></a>bool&nbsp;</p>
<p id="p135347107084826"><a name="p135347107084826"></a><a name="p135347107084826"></a>Obtains the state of this toggle button. </p>
</td>
</tr>
<tr id="row621777281084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p260643575084826"><a name="p260643575084826"></a><a name="p260643575084826"></a><a href="Graphic.md#gaea43f140dccee06b1e720b66c08c745b">OHOS::UIView::OnClickListener::OnClick</a> (<a href="OHOS-UIView.md">UIView</a> &amp;view, const <a href="OHOS-ClickEvent.md">ClickEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1288471231084826"><a name="p1288471231084826"></a><a name="p1288471231084826"></a>virtual bool&nbsp;</p>
<p id="p706423942084826"><a name="p706423942084826"></a><a name="p706423942084826"></a>Called when a view is clicked. </p>
</td>
</tr>
<tr id="row281489570084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2118212965084826"><a name="p2118212965084826"></a><a name="p2118212965084826"></a><a href="Graphic.md#ga53fcaf6484a178d452c76f0f1b493e99">OHOS::UIView::OnClickListener::~OnClickListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2139887654084826"><a name="p2139887654084826"></a><a name="p2139887654084826"></a>virtual&nbsp;</p>
<p id="p37454107084826"><a name="p37454107084826"></a><a name="p37454107084826"></a>A destructor used to delete the <strong id="b604551039084826"><a name="b604551039084826"></a><a name="b604551039084826"></a><a href="OHOS-UIView-OnClickListener.md">OnClickListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row1145237030084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1902010220084826"><a name="p1902010220084826"></a><a name="p1902010220084826"></a><a href="Graphic.md#gadd8ba1ff84abfc796ddeb9c6e5d46497">OHOS::UIView::OnLongPressListener::OnLongPress</a> (<a href="OHOS-UIView.md">UIView</a> &amp;view, const <a href="OHOS-LongPressEvent.md">LongPressEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p976620020084826"><a name="p976620020084826"></a><a name="p976620020084826"></a>virtual bool&nbsp;</p>
<p id="p93468850084826"><a name="p93468850084826"></a><a name="p93468850084826"></a>Called when a view is long pressed. </p>
</td>
</tr>
<tr id="row923048502084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p227136412084826"><a name="p227136412084826"></a><a name="p227136412084826"></a><a href="Graphic.md#ga80d9a933818b4ae9c3f34fe78f65a8f6">OHOS::UIView::OnLongPressListener::~OnLongPressListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p564931615084826"><a name="p564931615084826"></a><a name="p564931615084826"></a>virtual&nbsp;</p>
<p id="p377109702084826"><a name="p377109702084826"></a><a name="p377109702084826"></a>A destructor used to delete the <strong id="b77887771084826"><a name="b77887771084826"></a><a name="b77887771084826"></a><a href="OHOS-UIView-OnLongPressListener.md">OnLongPressListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row274188281084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p191238134084826"><a name="p191238134084826"></a><a name="p191238134084826"></a><a href="Graphic.md#ga876bada94186d79c03de6da64c26e636">OHOS::UIView::OnDragListener::OnDragStart</a> (<a href="OHOS-UIView.md">UIView</a> &amp;view, const <a href="OHOS-DragEvent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1112753002084826"><a name="p1112753002084826"></a><a name="p1112753002084826"></a>virtual bool&nbsp;</p>
<p id="p661907563084826"><a name="p661907563084826"></a><a name="p661907563084826"></a>Called when a view starts to drag. </p>
</td>
</tr>
<tr id="row1825817191084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p697941462084826"><a name="p697941462084826"></a><a name="p697941462084826"></a><a href="Graphic.md#gac112ce602c6939a52781d13440255b0c">OHOS::UIView::OnDragListener::OnDrag</a> (<a href="OHOS-UIView.md">UIView</a> &amp;view, const <a href="OHOS-DragEvent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1659357729084826"><a name="p1659357729084826"></a><a name="p1659357729084826"></a>virtual bool&nbsp;</p>
<p id="p1634525924084826"><a name="p1634525924084826"></a><a name="p1634525924084826"></a>Called when a view is being dragged. </p>
</td>
</tr>
<tr id="row1968699354084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p501536939084826"><a name="p501536939084826"></a><a name="p501536939084826"></a><a href="Graphic.md#gab9e57971ae7e9925eaa3ccef245cbd72">OHOS::UIView::OnDragListener::OnDragEnd</a> (<a href="OHOS-UIView.md">UIView</a> &amp;view, const <a href="OHOS-DragEvent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1191168916084826"><a name="p1191168916084826"></a><a name="p1191168916084826"></a>virtual bool&nbsp;</p>
<p id="p1669405502084826"><a name="p1669405502084826"></a><a name="p1669405502084826"></a>Called when a view stops dragging. </p>
</td>
</tr>
<tr id="row160074864084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p697645092084826"><a name="p697645092084826"></a><a name="p697645092084826"></a><a href="Graphic.md#ga34c01de74c319674fc94d1d74bb6e77e">OHOS::UIView::OnDragListener::~OnDragListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2138512617084826"><a name="p2138512617084826"></a><a name="p2138512617084826"></a>virtual&nbsp;</p>
<p id="p1643085045084826"><a name="p1643085045084826"></a><a name="p1643085045084826"></a>A destructor used to delete the <strong id="b646555427084826"><a name="b646555427084826"></a><a name="b646555427084826"></a><a href="OHOS-UIView-OnDragListener.md">OnDragListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row36064783084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p238603867084826"><a name="p238603867084826"></a><a name="p238603867084826"></a><a href="Graphic.md#ga2cfaed7013dc76bcbe9a5ea5d51caac3">OHOS::UIView::OnTouchListener::OnPress</a> (<a href="OHOS-UIView.md">UIView</a> &amp;view, const <a href="OHOS-PressEvent.md">PressEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p167133954084826"><a name="p167133954084826"></a><a name="p167133954084826"></a>virtual bool&nbsp;</p>
<p id="p547794931084826"><a name="p547794931084826"></a><a name="p547794931084826"></a>Called when a view is pressed. </p>
</td>
</tr>
<tr id="row1925930761084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p5767824084826"><a name="p5767824084826"></a><a name="p5767824084826"></a><a href="Graphic.md#ga16fa19e254ae19fe181dba0ac9dd5d1f">OHOS::UIView::OnTouchListener::OnRelease</a> (<a href="OHOS-UIView.md">UIView</a> &amp;view, const <a href="OHOS-ReleaseEvent.md">ReleaseEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1260383068084826"><a name="p1260383068084826"></a><a name="p1260383068084826"></a>virtual bool&nbsp;</p>
<p id="p1330359257084826"><a name="p1330359257084826"></a><a name="p1330359257084826"></a>Called when a view is released. </p>
</td>
</tr>
<tr id="row1146785870084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1288118166084826"><a name="p1288118166084826"></a><a name="p1288118166084826"></a><a href="Graphic.md#ga7ce030676f1222599dd6367cd4b9cf7e">OHOS::UIView::OnTouchListener::OnCancel</a> (<a href="OHOS-UIView.md">UIView</a> &amp;view, const <a href="OHOS-CancelEvent.md">CancelEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p961507803084826"><a name="p961507803084826"></a><a name="p961507803084826"></a>virtual bool&nbsp;</p>
<p id="p1815072959084826"><a name="p1815072959084826"></a><a name="p1815072959084826"></a>Called when a click event on a view is canceled. </p>
</td>
</tr>
<tr id="row529236113084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1687799986084826"><a name="p1687799986084826"></a><a name="p1687799986084826"></a><a href="Graphic.md#gacf19bb5f0c979bb6889d30a20b2737e1">OHOS::UIView::OnTouchListener::~OnTouchListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p479984076084826"><a name="p479984076084826"></a><a name="p479984076084826"></a>virtual&nbsp;</p>
<p id="p916920507084826"><a name="p916920507084826"></a><a name="p916920507084826"></a>A destructor used to delete the <strong id="b299927827084826"><a name="b299927827084826"></a><a name="b299927827084826"></a><a href="OHOS-UIView-OnTouchListener.md">OnTouchListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row1665770775084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p147185344084826"><a name="p147185344084826"></a><a name="p147185344084826"></a><a href="Graphic.md#ga7aad5b50d945efe5f9304bc978b2001c">OHOS::UIView::UIView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1686133196084826"><a name="p1686133196084826"></a><a name="p1686133196084826"></a>&nbsp;</p>
<p id="p769382188084826"><a name="p769382188084826"></a><a name="p769382188084826"></a>A default constructor used to create an <strong id="b200378675084826"><a name="b200378675084826"></a><a name="b200378675084826"></a><a href="OHOS-UIView.md">UIView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1762424512084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p343129044084826"><a name="p343129044084826"></a><a name="p343129044084826"></a><a href="Graphic.md#ga57d429bb1cd71782f3b825f1bc6b9362">OHOS::UIView::UIView</a> (const char *id)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1571194740084826"><a name="p1571194740084826"></a><a name="p1571194740084826"></a>&nbsp;</p>
<p id="p127966974084826"><a name="p127966974084826"></a><a name="p127966974084826"></a>A constructor used to create an <strong id="b2137839350084826"><a name="b2137839350084826"></a><a name="b2137839350084826"></a><a href="OHOS-UIView.md">UIView</a></strong> instance. </p>
</td>
</tr>
<tr id="row1187161659084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1685187820084826"><a name="p1685187820084826"></a><a name="p1685187820084826"></a><a href="Graphic.md#ga17f0ffc1090bdcce0f88288da5962012">OHOS::UIView::~UIView</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1836119986084826"><a name="p1836119986084826"></a><a name="p1836119986084826"></a>virtual&nbsp;</p>
<p id="p1571385036084826"><a name="p1571385036084826"></a><a name="p1571385036084826"></a>A destructor used to delete the <strong id="b228958775084826"><a name="b228958775084826"></a><a name="b228958775084826"></a><a href="OHOS-UIView.md">UIView</a></strong> instance. </p>
</td>
</tr>
<tr id="row314785388084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1242507343084826"><a name="p1242507343084826"></a><a name="p1242507343084826"></a><a href="Graphic.md#gac295fe4851eed72f48e9a63771416d71">OHOS::UIView::OnPreDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1676881037084826"><a name="p1676881037084826"></a><a name="p1676881037084826"></a>virtual bool&nbsp;</p>
<p id="p1254356413084826"><a name="p1254356413084826"></a><a name="p1254356413084826"></a>Called before a view is drawn. This function is used to check whether the parent view of this view needs to be redrawn so as to optimize the drawing process. </p>
</td>
</tr>
<tr id="row1012470808084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1926658187084826"><a name="p1926658187084826"></a><a name="p1926658187084826"></a><a href="Graphic.md#ga9a5f43bdc03cde30323b570bfb7ae425">OHOS::UIView::OnDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p202845016084826"><a name="p202845016084826"></a><a name="p202845016084826"></a>virtual void&nbsp;</p>
<p id="p2029462163084826"><a name="p2029462163084826"></a><a name="p2029462163084826"></a>Called when a view is drawn. </p>
</td>
</tr>
<tr id="row1190788791084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p83707709084826"><a name="p83707709084826"></a><a name="p83707709084826"></a><a href="Graphic.md#gab70473cd0d8fe7c9d4bb817caeee9153">OHOS::UIView::OnPostDraw</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p604869572084826"><a name="p604869572084826"></a><a name="p604869572084826"></a>virtual void&nbsp;</p>
<p id="p362635880084826"><a name="p362635880084826"></a><a name="p362635880084826"></a>Called after a view is drawn. </p>
</td>
</tr>
<tr id="row1750304344084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2013713547084826"><a name="p2013713547084826"></a><a name="p2013713547084826"></a><a href="Graphic.md#ga81726238adeda1efa989be6ed4f4fe5b">OHOS::UIView::ReMeasure</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1529903601084826"><a name="p1529903601084826"></a><a name="p1529903601084826"></a>virtual void&nbsp;</p>
<p id="p2001082979084826"><a name="p2001082979084826"></a><a name="p2001082979084826"></a>Remeasures the view size. </p>
</td>
</tr>
<tr id="row950341439084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1506155738084826"><a name="p1506155738084826"></a><a name="p1506155738084826"></a><a href="Graphic.md#ga2a9a38b8450fbb196277238a51fbbf99">OHOS::UIView::Invalidate</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p803217310084826"><a name="p803217310084826"></a><a name="p803217310084826"></a>void&nbsp;</p>
<p id="p2036022494084826"><a name="p2036022494084826"></a><a name="p2036022494084826"></a>Refreshes the invalidated area of the view. </p>
</td>
</tr>
<tr id="row314615824084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1395729927084826"><a name="p1395729927084826"></a><a name="p1395729927084826"></a><a href="Graphic.md#gaf0e6b65ced8b931642f2a80c195962d2">OHOS::UIView::InvalidateRect</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;invalidatedArea)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p495207149084826"><a name="p495207149084826"></a><a name="p495207149084826"></a>void&nbsp;</p>
<p id="p1037758018084826"><a name="p1037758018084826"></a><a name="p1037758018084826"></a>Refreshes a view in a specified invalidated area. </p>
</td>
</tr>
<tr id="row574603551084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1495242873084826"><a name="p1495242873084826"></a><a name="p1495242873084826"></a><a href="Graphic.md#gac311aa47301d727c35fc31f8630d016e">OHOS::UIView::OnLongPressEvent</a> (const <a href="OHOS-LongPressEvent.md">LongPressEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1689891858084826"><a name="p1689891858084826"></a><a name="p1689891858084826"></a>virtual bool&nbsp;</p>
<p id="p1669887415084826"><a name="p1669887415084826"></a><a name="p1669887415084826"></a>Called when the view is long pressed. </p>
</td>
</tr>
<tr id="row34545379084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1304870784084826"><a name="p1304870784084826"></a><a name="p1304870784084826"></a><a href="Graphic.md#gac0e10556ff99b8a92bfb11df6456d605">OHOS::UIView::OnDragStartEvent</a> (const <a href="OHOS-DragEvent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1965425442084826"><a name="p1965425442084826"></a><a name="p1965425442084826"></a>virtual bool&nbsp;</p>
<p id="p1072088041084826"><a name="p1072088041084826"></a><a name="p1072088041084826"></a>Called when the view starts to drag. </p>
</td>
</tr>
<tr id="row900280912084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1321681480084826"><a name="p1321681480084826"></a><a name="p1321681480084826"></a><a href="Graphic.md#ga46249c8caf06b81590d9450e30a31147">OHOS::UIView::OnDragEvent</a> (const <a href="OHOS-DragEvent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1911520182084826"><a name="p1911520182084826"></a><a name="p1911520182084826"></a>virtual bool&nbsp;</p>
<p id="p1251831271084826"><a name="p1251831271084826"></a><a name="p1251831271084826"></a>Called when the view is being dragged. </p>
</td>
</tr>
<tr id="row836728803084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1076134172084826"><a name="p1076134172084826"></a><a name="p1076134172084826"></a><a href="Graphic.md#ga1799d33be73f64ed2066f50d7e65468d">OHOS::UIView::OnDragEndEvent</a> (const <a href="OHOS-DragEvent.md">DragEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1105540786084826"><a name="p1105540786084826"></a><a name="p1105540786084826"></a>virtual bool&nbsp;</p>
<p id="p1439471738084826"><a name="p1439471738084826"></a><a name="p1439471738084826"></a>Called when the view stops dragging. </p>
</td>
</tr>
<tr id="row577251540084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p712544612084826"><a name="p712544612084826"></a><a name="p712544612084826"></a><a href="Graphic.md#gad08697a29aae4c58267f494b66b9a547">OHOS::UIView::OnClickEvent</a> (const <a href="OHOS-ClickEvent.md">ClickEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1553068416084826"><a name="p1553068416084826"></a><a name="p1553068416084826"></a>virtual void&nbsp;</p>
<p id="p803460779084826"><a name="p803460779084826"></a><a name="p803460779084826"></a>Called when the view is clicked. </p>
</td>
</tr>
<tr id="row687048973084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1955434442084826"><a name="p1955434442084826"></a><a name="p1955434442084826"></a><a href="Graphic.md#gafa544ff2d27785a9410a80689f1ad3b1">OHOS::UIView::OnPressEvent</a> (const <a href="OHOS-PressEvent.md">PressEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1699426462084826"><a name="p1699426462084826"></a><a name="p1699426462084826"></a>virtual void&nbsp;</p>
<p id="p1726614422084826"><a name="p1726614422084826"></a><a name="p1726614422084826"></a>Called when the view is pressed. </p>
</td>
</tr>
<tr id="row2134895261084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1311409725084826"><a name="p1311409725084826"></a><a name="p1311409725084826"></a><a href="Graphic.md#ga7bd1a74563b059b03fbf66f9add53ee3">OHOS::UIView::OnReleaseEvent</a> (const <a href="OHOS-ReleaseEvent.md">ReleaseEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1577862733084826"><a name="p1577862733084826"></a><a name="p1577862733084826"></a>virtual void&nbsp;</p>
<p id="p2079538552084826"><a name="p2079538552084826"></a><a name="p2079538552084826"></a>Called when the view is released. </p>
</td>
</tr>
<tr id="row771231496084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2104450186084826"><a name="p2104450186084826"></a><a name="p2104450186084826"></a><a href="Graphic.md#ga8f01ff25a33b20df0758f564148e579d">OHOS::UIView::OnCancelEvent</a> (const <a href="OHOS-CancelEvent.md">CancelEvent</a> &amp;event)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p898384207084826"><a name="p898384207084826"></a><a name="p898384207084826"></a>virtual void&nbsp;</p>
<p id="p1127670978084826"><a name="p1127670978084826"></a><a name="p1127670978084826"></a>Called when a click event on the view is canceled. </p>
</td>
</tr>
<tr id="row200724572084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1673132918084826"><a name="p1673132918084826"></a><a name="p1673132918084826"></a><a href="Graphic.md#gad8e3cf5f0dd003a6aa932ef04e7b59f2">OHOS::UIView::SetOnDragListener</a> (<a href="OHOS-UIView-OnDragListener.md">OnDragListener</a> *onDragListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1074899554084826"><a name="p1074899554084826"></a><a name="p1074899554084826"></a>void&nbsp;</p>
<p id="p722226424084826"><a name="p722226424084826"></a><a name="p722226424084826"></a>Sets a drag event listener for the view. </p>
</td>
</tr>
<tr id="row905491600084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1021221255084826"><a name="p1021221255084826"></a><a name="p1021221255084826"></a><a href="Graphic.md#ga45a02cba4887c5c0b8e243941bcdc5cb">OHOS::UIView::GetOnDragListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p585731736084826"><a name="p585731736084826"></a><a name="p585731736084826"></a><a href="OHOS-UIView-OnDragListener.md">OnDragListener</a> *&amp;&nbsp;</p>
<p id="p504071236084826"><a name="p504071236084826"></a><a name="p504071236084826"></a>Obtains the drag event listener for the view. </p>
</td>
</tr>
<tr id="row1850241455084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1850115082084826"><a name="p1850115082084826"></a><a name="p1850115082084826"></a><a href="Graphic.md#ga4564bf8d8c7184e9c02bf33c9e171fa3">OHOS::UIView::SetOnClickListener</a> (<a href="OHOS-UIView-OnClickListener.md">OnClickListener</a> *onClickListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1723147748084826"><a name="p1723147748084826"></a><a name="p1723147748084826"></a>void&nbsp;</p>
<p id="p444464126084826"><a name="p444464126084826"></a><a name="p444464126084826"></a>Sets a click event listener for the view. </p>
</td>
</tr>
<tr id="row954694338084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p445258382084826"><a name="p445258382084826"></a><a name="p445258382084826"></a><a href="Graphic.md#ga35e885cb380c37245fa4305bba10cd4a">OHOS::UIView::GetOnClickListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2129698088084826"><a name="p2129698088084826"></a><a name="p2129698088084826"></a><a href="OHOS-UIView-OnClickListener.md">OnClickListener</a> *&amp;&nbsp;</p>
<p id="p1177740881084826"><a name="p1177740881084826"></a><a name="p1177740881084826"></a>Obtains the click event listener for the view. </p>
</td>
</tr>
<tr id="row576266750084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p89780376084826"><a name="p89780376084826"></a><a name="p89780376084826"></a><a href="Graphic.md#gabcbe7a0adce600424f7f0d5a7396eb5b">OHOS::UIView::SetOnLongPressListener</a> (<a href="OHOS-UIView-OnLongPressListener.md">OnLongPressListener</a> *onLongPressListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p702230504084826"><a name="p702230504084826"></a><a name="p702230504084826"></a>void&nbsp;</p>
<p id="p593190816084826"><a name="p593190816084826"></a><a name="p593190816084826"></a>Sets a long-press event listener for the view. </p>
</td>
</tr>
<tr id="row832618905084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1323308393084826"><a name="p1323308393084826"></a><a name="p1323308393084826"></a><a href="Graphic.md#gaafd4d354f5f111e758d046109fd7f656">OHOS::UIView::GetOnLongPressListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p317634263084826"><a name="p317634263084826"></a><a name="p317634263084826"></a><a href="OHOS-UIView-OnLongPressListener.md">OnLongPressListener</a> *&amp;&nbsp;</p>
<p id="p1863171741084826"><a name="p1863171741084826"></a><a name="p1863171741084826"></a>Obtains the long-press event listener for the view. </p>
</td>
</tr>
<tr id="row1921752574084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p39180279084826"><a name="p39180279084826"></a><a name="p39180279084826"></a><a href="Graphic.md#gadd697fbf481f98d9d6ca8b67390071af">OHOS::UIView::SetOnTouchListener</a> (<a href="OHOS-UIView-OnTouchListener.md">OnTouchListener</a> *onTouchListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p158982606084826"><a name="p158982606084826"></a><a name="p158982606084826"></a>void&nbsp;</p>
<p id="p579754980084826"><a name="p579754980084826"></a><a name="p579754980084826"></a>Sets a touch event listener for the view. </p>
</td>
</tr>
<tr id="row22906247084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1792320026084826"><a name="p1792320026084826"></a><a name="p1792320026084826"></a><a href="Graphic.md#gae7c65c68653103dae85acdcef78777a6">OHOS::UIView::GetTouchListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p503815761084826"><a name="p503815761084826"></a><a name="p503815761084826"></a><a href="OHOS-UIView-OnTouchListener.md">OnTouchListener</a> *&amp;&nbsp;</p>
<p id="p1271961791084826"><a name="p1271961791084826"></a><a name="p1271961791084826"></a>Obtains the touch event listener for the view. </p>
</td>
</tr>
<tr id="row1449373170084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p99919485084826"><a name="p99919485084826"></a><a name="p99919485084826"></a><a href="Graphic.md#gaea9f334f2481e1c03a2cd8f3078d7c72">OHOS::UIView::GetTargetView</a> (const <a href="OHOS-Point.md">Point</a> &amp;point, <a href="OHOS-UIView.md">UIView</a> **last)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2079326666084826"><a name="p2079326666084826"></a><a name="p2079326666084826"></a>virtual void&nbsp;</p>
<p id="p361959038084826"><a name="p361959038084826"></a><a name="p361959038084826"></a>Obtains the top-level view based on specified coordinates. </p>
</td>
</tr>
<tr id="row1352598683084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1413526917084826"><a name="p1413526917084826"></a><a name="p1413526917084826"></a><a href="Graphic.md#gaeea67a3a84b4ffe9bfeda418b82184cc">OHOS::UIView::SetParent</a> (<a href="OHOS-UIView.md">UIView</a> *parent)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1852310658084826"><a name="p1852310658084826"></a><a name="p1852310658084826"></a>void&nbsp;</p>
<p id="p1336463576084826"><a name="p1336463576084826"></a><a name="p1336463576084826"></a>Sets the parent view for the view. </p>
</td>
</tr>
<tr id="row973745680084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p139788852084826"><a name="p139788852084826"></a><a name="p139788852084826"></a><a href="Graphic.md#ga706530e4a38108615d5e0c918685ec96">OHOS::UIView::GetParent</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p205892871084826"><a name="p205892871084826"></a><a name="p205892871084826"></a><a href="OHOS-UIView.md">UIView</a> *&nbsp;</p>
<p id="p1196046402084826"><a name="p1196046402084826"></a><a name="p1196046402084826"></a>Obtains the parent view of the view. </p>
</td>
</tr>
<tr id="row718762487084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1857892759084826"><a name="p1857892759084826"></a><a name="p1857892759084826"></a><a href="Graphic.md#ga02bec5de07d93cabc45affba79eba4ad">OHOS::UIView::SetNextSibling</a> (<a href="OHOS-UIView.md">UIView</a> *sibling)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p824268891084826"><a name="p824268891084826"></a><a name="p824268891084826"></a>void&nbsp;</p>
<p id="p1488904486084826"><a name="p1488904486084826"></a><a name="p1488904486084826"></a>Sets the next sibling view for the view. </p>
</td>
</tr>
<tr id="row1320296706084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1076598613084826"><a name="p1076598613084826"></a><a name="p1076598613084826"></a><a href="Graphic.md#gab0030977b30ddc9f2e15dbc2f58937e6">OHOS::UIView::GetNextSibling</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p416523030084826"><a name="p416523030084826"></a><a name="p416523030084826"></a><a href="OHOS-UIView.md">UIView</a> *&nbsp;</p>
<p id="p1399670337084826"><a name="p1399670337084826"></a><a name="p1399670337084826"></a>Obtains the next sibling view of the view. </p>
</td>
</tr>
<tr id="row1676963150084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p274720284084826"><a name="p274720284084826"></a><a name="p274720284084826"></a><a href="Graphic.md#ga07e7e1f268bd6ce975f4f0f8487af5d0">OHOS::UIView::SetVisible</a> (bool visible)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1482795367084826"><a name="p1482795367084826"></a><a name="p1482795367084826"></a>virtual void&nbsp;</p>
<p id="p1238606992084826"><a name="p1238606992084826"></a><a name="p1238606992084826"></a>Sets whether the view is visible. </p>
</td>
</tr>
<tr id="row976166630084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p207555418084826"><a name="p207555418084826"></a><a name="p207555418084826"></a><a href="Graphic.md#gaee178fc0a86ac03a6bdf2ade0c1914c8">OHOS::UIView::IsVisible</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p527008467084826"><a name="p527008467084826"></a><a name="p527008467084826"></a>bool&nbsp;</p>
<p id="p1208414894084826"><a name="p1208414894084826"></a><a name="p1208414894084826"></a>Checks whether the view is visible. </p>
</td>
</tr>
<tr id="row1375889787084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p184792988084826"><a name="p184792988084826"></a><a name="p184792988084826"></a><a href="Graphic.md#gaf9fb55fd9aa397f7158f1515e90bce02">OHOS::UIView::SetTouchable</a> (bool touch)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p477918888084826"><a name="p477918888084826"></a><a name="p477918888084826"></a>void&nbsp;</p>
<p id="p773963724084826"><a name="p773963724084826"></a><a name="p773963724084826"></a>Sets whether the view is touchable. </p>
</td>
</tr>
<tr id="row71208607084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1630468303084826"><a name="p1630468303084826"></a><a name="p1630468303084826"></a><a href="Graphic.md#ga502a53fb77b260fa36b5b3adf82e2340">OHOS::UIView::IsTouchable</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1551538425084826"><a name="p1551538425084826"></a><a name="p1551538425084826"></a>bool&nbsp;</p>
<p id="p296449416084826"><a name="p296449416084826"></a><a name="p296449416084826"></a>Checks whether the view is touchable. </p>
</td>
</tr>
<tr id="row647977778084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1515678568084826"><a name="p1515678568084826"></a><a name="p1515678568084826"></a><a href="Graphic.md#gab06abe0fe824c048f3b72974f9a8f0d0">OHOS::UIView::SetDraggable</a> (bool draggable)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p523074514084826"><a name="p523074514084826"></a><a name="p523074514084826"></a>void&nbsp;</p>
<p id="p1826371636084826"><a name="p1826371636084826"></a><a name="p1826371636084826"></a>Sets whether the view is draggable. </p>
</td>
</tr>
<tr id="row710298437084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2102559956084826"><a name="p2102559956084826"></a><a name="p2102559956084826"></a><a href="Graphic.md#ga25bb796ff400c767d622cbed280fc500">OHOS::UIView::IsDraggable</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p39270527084826"><a name="p39270527084826"></a><a name="p39270527084826"></a>bool&nbsp;</p>
<p id="p790966085084826"><a name="p790966085084826"></a><a name="p790966085084826"></a>Checks whether the view is draggable. </p>
</td>
</tr>
<tr id="row1004173015084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1437032883084826"><a name="p1437032883084826"></a><a name="p1437032883084826"></a><a href="Graphic.md#ga6c08e49bf7a82a7ebaef0f251e7a6f85">OHOS::UIView::SetDragParentInstead</a> (bool dragParentInstead)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1682132945084826"><a name="p1682132945084826"></a><a name="p1682132945084826"></a>void&nbsp;</p>
<p id="p1203649539084826"><a name="p1203649539084826"></a><a name="p1203649539084826"></a>Sets whether to transfer the drag event to the parent view for processing when the view is being dragged. </p>
</td>
</tr>
<tr id="row657066227084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1841726438084826"><a name="p1841726438084826"></a><a name="p1841726438084826"></a><a href="Graphic.md#gaf0c462bc31e779b1898ad4cdfdad6faf">OHOS::UIView::IsDragParentInstead</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p986670587084826"><a name="p986670587084826"></a><a name="p986670587084826"></a>bool&nbsp;</p>
<p id="p696819011084826"><a name="p696819011084826"></a><a name="p696819011084826"></a>Obtains whether the view transfers a drag event to the parent view for processing. </p>
</td>
</tr>
<tr id="row1121575860084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1899971761084826"><a name="p1899971761084826"></a><a name="p1899971761084826"></a><a href="Graphic.md#ga86cb8d364f18494d67636c55babced5c">OHOS::UIView::GetRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p871322096084826"><a name="p871322096084826"></a><a name="p871322096084826"></a><a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p632213889084826"><a name="p632213889084826"></a><a name="p632213889084826"></a>Obtains the absolute rectangle area of the view. When the view has deformation such as rotation, the rectangle area is the intersection set of the absolute rectangle area and deformation matrix. </p>
</td>
</tr>
<tr id="row1792012764084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1854374846084826"><a name="p1854374846084826"></a><a name="p1854374846084826"></a><a href="Graphic.md#ga06e79704a19f2a238982076cac3d059b">OHOS::UIView::GetVisibleRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p250320628084826"><a name="p250320628084826"></a><a name="p250320628084826"></a><a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p1337304070084826"><a name="p1337304070084826"></a><a name="p1337304070084826"></a>Obtains the visible absolute rectangle area of the view. </p>
</td>
</tr>
<tr id="row747240755084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p233660773084826"><a name="p233660773084826"></a><a name="p233660773084826"></a><a href="Graphic.md#gab3f8993b3953f27bfc61d53429916cba">OHOS::UIView::GetMaskedRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1269120108084826"><a name="p1269120108084826"></a><a name="p1269120108084826"></a><a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p1715501879084826"><a name="p1715501879084826"></a><a name="p1715501879084826"></a>Obtains the valid absolute rectangle area of the view. The valid area refers to the area where the view can be displayed. Generally, the valid area is the same as the visible view area, but they may be different in the grid layout. </p>
</td>
</tr>
<tr id="row1373590852084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p325868267084826"><a name="p325868267084826"></a><a name="p325868267084826"></a><a href="Graphic.md#ga64cf308a09999def1192f9c4e0f17f0a">OHOS::UIView::GetOrigRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1160495601084826"><a name="p1160495601084826"></a><a name="p1160495601084826"></a><a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p1218330715084826"><a name="p1218330715084826"></a><a name="p1218330715084826"></a>Obtains the absolute rectangle area of the view. </p>
</td>
</tr>
<tr id="row1501154511084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p966312412084826"><a name="p966312412084826"></a><a name="p966312412084826"></a><a href="Graphic.md#ga9db88eae712676359d02a92be14fa316">OHOS::UIView::GetContentRect</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p210836227084826"><a name="p210836227084826"></a><a name="p210836227084826"></a>virtual <a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p672217693084826"><a name="p672217693084826"></a><a name="p672217693084826"></a>Obtains the content of the absolute rectangle area of the view. This area excludes padding. </p>
</td>
</tr>
<tr id="row1129510390084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p815737755084826"><a name="p815737755084826"></a><a name="p815737755084826"></a><a href="Graphic.md#gae9b96837fa1d45648a2a6fbbfcc5eb4a">OHOS::UIView::GetRelativeRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p880542350084826"><a name="p880542350084826"></a><a name="p880542350084826"></a><a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p1833505538084826"><a name="p1833505538084826"></a><a name="p1833505538084826"></a>Obtains the rectangular area of the view relative to the parent view, that is, the rectangular area relative to the coordinates of the parent view. </p>
</td>
</tr>
<tr id="row1099242991084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1969475602084826"><a name="p1969475602084826"></a><a name="p1969475602084826"></a><a href="Graphic.md#gae6c5f3bcf99dc837bcecd60c38d3df5a">OHOS::UIView::ResizeVisibleArea</a> (int16_t x, int16_t y, int16_t width, int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p301972757084826"><a name="p301972757084826"></a><a name="p301972757084826"></a>void&nbsp;</p>
<p id="p132026726084826"><a name="p132026726084826"></a><a name="p132026726084826"></a>Adjusts the size of the visible area. This operation may affect the final display size. </p>
</td>
</tr>
<tr id="row3353367084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1349459093084826"><a name="p1349459093084826"></a><a name="p1349459093084826"></a><a href="Graphic.md#ga3375ec5ef059fd88c657af4552d2fa4f">OHOS::UIView::SetWidth</a> (int16_t width)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p678102462084826"><a name="p678102462084826"></a><a name="p678102462084826"></a>virtual void&nbsp;</p>
<p id="p1684530504084826"><a name="p1684530504084826"></a><a name="p1684530504084826"></a>Sets the width for the view. </p>
</td>
</tr>
<tr id="row1865091062084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1821328470084826"><a name="p1821328470084826"></a><a name="p1821328470084826"></a><a href="Graphic.md#ga90cf8cffb98d71c30d6fc1d118442dbd">OHOS::UIView::GetWidth</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p179056427084826"><a name="p179056427084826"></a><a name="p179056427084826"></a>virtual int16_t&nbsp;</p>
<p id="p2043604560084826"><a name="p2043604560084826"></a><a name="p2043604560084826"></a>Obtains the width for the view. </p>
</td>
</tr>
<tr id="row1219045947084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1551575522084826"><a name="p1551575522084826"></a><a name="p1551575522084826"></a><a href="Graphic.md#ga9c7110620d5dc3a7bd3efe1fc2edd125">OHOS::UIView::SetHeight</a> (int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p46293590084826"><a name="p46293590084826"></a><a name="p46293590084826"></a>virtual void&nbsp;</p>
<p id="p1541898471084826"><a name="p1541898471084826"></a><a name="p1541898471084826"></a>Sets the height for the view. </p>
</td>
</tr>
<tr id="row267041320084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1292626213084826"><a name="p1292626213084826"></a><a name="p1292626213084826"></a><a href="Graphic.md#ga9b35f4603a561c7a9a29b023a022ac97">OHOS::UIView::GetHeight</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1149427316084826"><a name="p1149427316084826"></a><a name="p1149427316084826"></a>virtual int16_t&nbsp;</p>
<p id="p493084328084826"><a name="p493084328084826"></a><a name="p493084328084826"></a>Obtains the height for the view. </p>
</td>
</tr>
<tr id="row423570161084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p874440013084826"><a name="p874440013084826"></a><a name="p874440013084826"></a><a href="Graphic.md#gae985b607d2f0701911778bf20d640ccd">OHOS::UIView::Resize</a> (int16_t width, int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p679755386084826"><a name="p679755386084826"></a><a name="p679755386084826"></a>virtual void&nbsp;</p>
<p id="p1068968533084826"><a name="p1068968533084826"></a><a name="p1068968533084826"></a>Adjusts the size of the view. </p>
</td>
</tr>
<tr id="row71391632084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p15328110084826"><a name="p15328110084826"></a><a name="p15328110084826"></a><a href="Graphic.md#gaded403626558d28e62bf5632ccbb24b5">OHOS::UIView::SetX</a> (int16_t x)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1462956159084826"><a name="p1462956159084826"></a><a name="p1462956159084826"></a>virtual void&nbsp;</p>
<p id="p1582314815084826"><a name="p1582314815084826"></a><a name="p1582314815084826"></a>Sets the x-coordinate for the view. </p>
</td>
</tr>
<tr id="row274943399084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1720818467084826"><a name="p1720818467084826"></a><a name="p1720818467084826"></a><a href="Graphic.md#ga89dc5f8fb1cb4b2259dc0439185359f1">OHOS::UIView::GetX</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1955196148084826"><a name="p1955196148084826"></a><a name="p1955196148084826"></a>int16_t&nbsp;</p>
<p id="p1475500575084826"><a name="p1475500575084826"></a><a name="p1475500575084826"></a>Obtains the x-coordinate for the view. </p>
</td>
</tr>
<tr id="row726336099084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p289323777084826"><a name="p289323777084826"></a><a name="p289323777084826"></a><a href="Graphic.md#gaaa8edc224cf1c7deb2724fb225960877">OHOS::UIView::SetY</a> (int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p337049395084826"><a name="p337049395084826"></a><a name="p337049395084826"></a>virtual void&nbsp;</p>
<p id="p1734486475084826"><a name="p1734486475084826"></a><a name="p1734486475084826"></a>Sets the y-coordinate for the view. </p>
</td>
</tr>
<tr id="row35488835084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p931129322084826"><a name="p931129322084826"></a><a name="p931129322084826"></a><a href="Graphic.md#ga193619d649204b0e9bb854d3b30275c3">OHOS::UIView::GetY</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1752557814084826"><a name="p1752557814084826"></a><a name="p1752557814084826"></a>int16_t&nbsp;</p>
<p id="p1439164024084826"><a name="p1439164024084826"></a><a name="p1439164024084826"></a>Obtains the y-coordinate for the view. </p>
</td>
</tr>
<tr id="row2099343948084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p421106339084826"><a name="p421106339084826"></a><a name="p421106339084826"></a><a href="Graphic.md#gab34233f6aeae330b025969137d03e67a">OHOS::UIView::SetPosition</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1028214752084826"><a name="p1028214752084826"></a><a name="p1028214752084826"></a>virtual void&nbsp;</p>
<p id="p573621223084826"><a name="p573621223084826"></a><a name="p573621223084826"></a>Sets the position for the view. </p>
</td>
</tr>
<tr id="row1477677145084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p401958048084826"><a name="p401958048084826"></a><a name="p401958048084826"></a><a href="Graphic.md#gaf8ce4c009f23b7175b2b34bac4a74262">OHOS::UIView::SetPosition</a> (int16_t x, int16_t y, int16_t width, int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1143266711084826"><a name="p1143266711084826"></a><a name="p1143266711084826"></a>virtual void&nbsp;</p>
<p id="p1900262338084826"><a name="p1900262338084826"></a><a name="p1900262338084826"></a>Adjusts the position and size of the view. </p>
</td>
</tr>
<tr id="row1082401947084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1426715272084826"><a name="p1426715272084826"></a><a name="p1426715272084826"></a><a href="Graphic.md#gab2ce8c11abbd55f40687f38a52511b11">OHOS::UIView::IsViewGroup</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1141583490084826"><a name="p1141583490084826"></a><a name="p1141583490084826"></a>bool&nbsp;</p>
<p id="p1707003485084826"><a name="p1707003485084826"></a><a name="p1707003485084826"></a>Checks whether the view is a container view. </p>
</td>
</tr>
<tr id="row1345315340084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1390071597084826"><a name="p1390071597084826"></a><a name="p1390071597084826"></a><a href="Graphic.md#ga980fc6824c64cfae6af8657aee17af88">OHOS::UIView::SetIntercept</a> (bool isIntercept)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2049605835084826"><a name="p2049605835084826"></a><a name="p2049605835084826"></a>void&nbsp;</p>
<p id="p632622197084826"><a name="p632622197084826"></a><a name="p632622197084826"></a>Sets whether to intercept the drag event. If intercepted, the view does not transfer the drag event to the parent view after local processing. </p>
</td>
</tr>
<tr id="row167392274084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p233267100084826"><a name="p233267100084826"></a><a name="p233267100084826"></a><a href="Graphic.md#ga8623abbbeff458c0cb2d7dc0d1f21e4a">OHOS::UIView::SetTransformMap</a> (const <a href="OHOS-TransformMap.md">TransformMap</a> &amp;transMap)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p219243718084826"><a name="p219243718084826"></a><a name="p219243718084826"></a>void&nbsp;</p>
<p id="p831326169084826"><a name="p831326169084826"></a><a name="p831326169084826"></a>Sets the affine transformation matrix. </p>
</td>
</tr>
<tr id="row513999320084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1468885933084826"><a name="p1468885933084826"></a><a name="p1468885933084826"></a><a href="Graphic.md#gab8cee5a7052a88722768c8ed1324abc1">OHOS::UIView::GetTransformMap</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2119049670084826"><a name="p2119049670084826"></a><a name="p2119049670084826"></a><a href="OHOS-TransformMap.md">TransformMap</a> &amp;&nbsp;</p>
<p id="p160874720084826"><a name="p160874720084826"></a><a name="p160874720084826"></a>Obtains an affine transformation matrix. </p>
</td>
</tr>
<tr id="row2088048948084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p566447379084826"><a name="p566447379084826"></a><a name="p566447379084826"></a><a href="Graphic.md#ga0573aa25307c22319db4629781b5cad2">OHOS::UIView::GetChildById</a> (const char *id) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2097283717084826"><a name="p2097283717084826"></a><a name="p2097283717084826"></a>virtual <a href="OHOS-UIView.md">UIView</a> *&nbsp;</p>
<p id="p777899959084826"><a name="p777899959084826"></a><a name="p777899959084826"></a>Obtains the child view of a specified ID. </p>
</td>
</tr>
<tr id="row226829774084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1445205740084826"><a name="p1445205740084826"></a><a name="p1445205740084826"></a><a href="Graphic.md#ga0caaa15c9b304673331e778a266be77f">OHOS::UIView::SetViewId</a> (const char *id)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p709862433084826"><a name="p709862433084826"></a><a name="p709862433084826"></a>void&nbsp;</p>
<p id="p1675317118084826"><a name="p1675317118084826"></a><a name="p1675317118084826"></a>Sets the view ID. </p>
</td>
</tr>
<tr id="row1629855790084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1202919395084826"><a name="p1202919395084826"></a><a name="p1202919395084826"></a><a href="Graphic.md#gad6c7644bd2abfa3c92d80776b0bd1936">OHOS::UIView::GetViewId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1945676401084826"><a name="p1945676401084826"></a><a name="p1945676401084826"></a>const char *&nbsp;</p>
<p id="p70801104084826"><a name="p70801104084826"></a><a name="p70801104084826"></a>Obtains the view ID. </p>
</td>
</tr>
<tr id="row1441386011084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1271095807084826"><a name="p1271095807084826"></a><a name="p1271095807084826"></a><a href="Graphic.md#ga77a961aa53567c5214508b4569801c16">OHOS::UIView::SetViewIndex</a> (int16_t <a href="UTILS.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p680741140084826"><a name="p680741140084826"></a><a name="p680741140084826"></a>void&nbsp;</p>
<p id="p2025699394084826"><a name="p2025699394084826"></a><a name="p2025699394084826"></a>Sets the view index. </p>
</td>
</tr>
<tr id="row1110706459084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1547156096084826"><a name="p1547156096084826"></a><a name="p1547156096084826"></a><a href="Graphic.md#ga62f51715b6d420a296ebe0296717b906">OHOS::UIView::GetViewIndex</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1158802048084826"><a name="p1158802048084826"></a><a name="p1158802048084826"></a>int16_t&nbsp;</p>
<p id="p255340607084826"><a name="p255340607084826"></a><a name="p255340607084826"></a>Obtains the view index. </p>
</td>
</tr>
<tr id="row1242371732084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p210164691084826"><a name="p210164691084826"></a><a name="p210164691084826"></a><a href="Graphic.md#ga6d23780da1faa1071197b716bca365e0">OHOS::UIView::GetViewType</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p625512139084826"><a name="p625512139084826"></a><a name="p625512139084826"></a>virtual UIViewType&nbsp;</p>
<p id="p116984212084826"><a name="p116984212084826"></a><a name="p116984212084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row2134128731084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1589279207084826"><a name="p1589279207084826"></a><a name="p1589279207084826"></a><a href="Graphic.md#gaca871fa2f8219e7ea9388e212d1f1e69">OHOS::UIView::LayoutChildren</a> (bool neeInvalidate=false)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p548625612084826"><a name="p548625612084826"></a><a name="p548625612084826"></a>virtual void&nbsp;</p>
<p id="p526990455084826"><a name="p526990455084826"></a><a name="p526990455084826"></a>Lays out all child views according to the preset arrangement mode. </p>
</td>
</tr>
<tr id="row1048663758084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p124826423084826"><a name="p124826423084826"></a><a name="p124826423084826"></a><a href="Graphic.md#ga443b86ee9275b0421b37a47bad3264dc">OHOS::UIView::LayoutCenterOfParent</a> (int16_t xOffSet=0, int16_t yOffset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p842205496084826"><a name="p842205496084826"></a><a name="p842205496084826"></a>void&nbsp;</p>
<p id="p993871671084826"><a name="p993871671084826"></a><a name="p993871671084826"></a>Lays out the view in the center of the parent view. </p>
</td>
</tr>
<tr id="row722367171084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2107533947084826"><a name="p2107533947084826"></a><a name="p2107533947084826"></a><a href="Graphic.md#ga94999b271f27cd5d6bfaf303f7d5c708">OHOS::UIView::LayoutLeftOfParent</a> (int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1539052580084826"><a name="p1539052580084826"></a><a name="p1539052580084826"></a>void&nbsp;</p>
<p id="p2057470506084826"><a name="p2057470506084826"></a><a name="p2057470506084826"></a>Lays out the view on the left of the parent view. </p>
</td>
</tr>
<tr id="row1569369263084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1980818247084826"><a name="p1980818247084826"></a><a name="p1980818247084826"></a><a href="Graphic.md#ga479528ed259b5539e423955f2b60517d">OHOS::UIView::LayoutRightOfParent</a> (int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p602885168084826"><a name="p602885168084826"></a><a name="p602885168084826"></a>void&nbsp;</p>
<p id="p1887196938084826"><a name="p1887196938084826"></a><a name="p1887196938084826"></a>Lays out the view on the right of the parent view. </p>
</td>
</tr>
<tr id="row1050914913084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1141534469084826"><a name="p1141534469084826"></a><a name="p1141534469084826"></a><a href="Graphic.md#ga859288ea61ad23ba7e381bbc07769e83">OHOS::UIView::LayoutTopOfParent</a> (int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1877183076084826"><a name="p1877183076084826"></a><a name="p1877183076084826"></a>void&nbsp;</p>
<p id="p306653565084826"><a name="p306653565084826"></a><a name="p306653565084826"></a>Lays out the view on the top of the parent view. </p>
</td>
</tr>
<tr id="row1898634994084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p120733539084826"><a name="p120733539084826"></a><a name="p120733539084826"></a><a href="Graphic.md#ga809aeee4792ae58218a0bcfcb94d5cdc">OHOS::UIView::LayoutBottomOfParent</a> (int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p388657895084826"><a name="p388657895084826"></a><a name="p388657895084826"></a>void&nbsp;</p>
<p id="p1963901680084826"><a name="p1963901680084826"></a><a name="p1963901680084826"></a>Lays out the view on the bottom of the parent view. </p>
</td>
</tr>
<tr id="row657495009084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1046741463084826"><a name="p1046741463084826"></a><a name="p1046741463084826"></a><a href="Graphic.md#gac7f5f2584c716a56fee3783f8dea6246">OHOS::UIView::AlignLeftToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1424014914084826"><a name="p1424014914084826"></a><a name="p1424014914084826"></a>void&nbsp;</p>
<p id="p1742167960084826"><a name="p1742167960084826"></a><a name="p1742167960084826"></a>Aligns the view with the left of a sibling view. </p>
</td>
</tr>
<tr id="row1333176345084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1976289947084826"><a name="p1976289947084826"></a><a name="p1976289947084826"></a><a href="Graphic.md#gabb1ac454cdf95593c1e387d5e272433c">OHOS::UIView::AlignRightToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p405519040084826"><a name="p405519040084826"></a><a name="p405519040084826"></a>void&nbsp;</p>
<p id="p1299186630084826"><a name="p1299186630084826"></a><a name="p1299186630084826"></a>Aligns the view with the right of a sibling view. </p>
</td>
</tr>
<tr id="row52081316084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2146140051084826"><a name="p2146140051084826"></a><a name="p2146140051084826"></a><a href="Graphic.md#ga903d7cbc59bac06d728b7f6435c9a504">OHOS::UIView::AlignTopToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p98620595084826"><a name="p98620595084826"></a><a name="p98620595084826"></a>void&nbsp;</p>
<p id="p596313427084826"><a name="p596313427084826"></a><a name="p596313427084826"></a>Aligns the view with the top of a sibling view. </p>
</td>
</tr>
<tr id="row155637684084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1192233773084826"><a name="p1192233773084826"></a><a name="p1192233773084826"></a><a href="Graphic.md#ga7607c3f9661932c495d080e9d92fb1a3">OHOS::UIView::AlignBottomToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p920685162084826"><a name="p920685162084826"></a><a name="p920685162084826"></a>void&nbsp;</p>
<p id="p2058672960084826"><a name="p2058672960084826"></a><a name="p2058672960084826"></a>Aligns the view with the bottom of a sibling view. </p>
</td>
</tr>
<tr id="row1099563612084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p456187683084826"><a name="p456187683084826"></a><a name="p456187683084826"></a><a href="Graphic.md#gac23776dbc2fce7ff30d57438abfa5230">OHOS::UIView::AlignHorCenterToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p593748725084826"><a name="p593748725084826"></a><a name="p593748725084826"></a>void&nbsp;</p>
<p id="p1457734481084826"><a name="p1457734481084826"></a><a name="p1457734481084826"></a>Aligns the view with the center of a sibling view in the x-axis. </p>
</td>
</tr>
<tr id="row817055835084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1388878177084826"><a name="p1388878177084826"></a><a name="p1388878177084826"></a><a href="Graphic.md#gad3caa27aa0cb73ec4656e7d23aa222de">OHOS::UIView::AlignVerCenterToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p806882306084826"><a name="p806882306084826"></a><a name="p806882306084826"></a>void&nbsp;</p>
<p id="p978558435084826"><a name="p978558435084826"></a><a name="p978558435084826"></a>Aligns the view with the center of a sibling view in the y-axis. </p>
</td>
</tr>
<tr id="row1897095232084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p275447457084826"><a name="p275447457084826"></a><a name="p275447457084826"></a><a href="Graphic.md#ga58f1a34a943c4492970f901d63bbc3d8">OHOS::UIView::LayoutLeftToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1077829267084826"><a name="p1077829267084826"></a><a name="p1077829267084826"></a>void&nbsp;</p>
<p id="p925804738084826"><a name="p925804738084826"></a><a name="p925804738084826"></a>Lays out the view on the left of a sibling view. </p>
</td>
</tr>
<tr id="row1402435427084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p551202922084826"><a name="p551202922084826"></a><a name="p551202922084826"></a><a href="Graphic.md#gac4cd64de5291759add164825a323a0d6">OHOS::UIView::LayoutRightToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1123920525084826"><a name="p1123920525084826"></a><a name="p1123920525084826"></a>void&nbsp;</p>
<p id="p995340442084826"><a name="p995340442084826"></a><a name="p995340442084826"></a>Lays out the view on the right of a sibling view. </p>
</td>
</tr>
<tr id="row862262037084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p515355691084826"><a name="p515355691084826"></a><a name="p515355691084826"></a><a href="Graphic.md#gaaa8385807e3a9bea46f8dcc326252a70">OHOS::UIView::LayoutTopToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1589843367084826"><a name="p1589843367084826"></a><a name="p1589843367084826"></a>void&nbsp;</p>
<p id="p319092817084826"><a name="p319092817084826"></a><a name="p319092817084826"></a>Lays out the view on the above of a sibling view. </p>
</td>
</tr>
<tr id="row1251528910084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1397074796084826"><a name="p1397074796084826"></a><a name="p1397074796084826"></a><a href="Graphic.md#gaa23a68e8ef0fb13b362218e71cf67ace">OHOS::UIView::LayoutBottomToSibling</a> (const char *id, int16_t offset=0)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1975186384084826"><a name="p1975186384084826"></a><a name="p1975186384084826"></a>void&nbsp;</p>
<p id="p31934592084826"><a name="p31934592084826"></a><a name="p31934592084826"></a>Lays out the view on the below of a sibling view. </p>
</td>
</tr>
<tr id="row895775600084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p425843385084826"><a name="p425843385084826"></a><a name="p425843385084826"></a><a href="Graphic.md#ga9c1a3db000fdcd200fec8d2c49f5a0a8">OHOS::UIView::SetStyle</a> (<a href="OHOS-Style.md">Style</a> &amp;style)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1949991622084826"><a name="p1949991622084826"></a><a name="p1949991622084826"></a>virtual void&nbsp;</p>
<p id="p458747992084826"><a name="p458747992084826"></a><a name="p458747992084826"></a>Sets the view style. </p>
</td>
</tr>
<tr id="row1831210966084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1718860109084826"><a name="p1718860109084826"></a><a name="p1718860109084826"></a><a href="Graphic.md#ga0945c2f05815dc2e466ef9ceaca2f700">OHOS::UIView::SetStyle</a> (uint8_t key, int64_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1966574459084826"><a name="p1966574459084826"></a><a name="p1966574459084826"></a>virtual void&nbsp;</p>
<p id="p794210533084826"><a name="p794210533084826"></a><a name="p794210533084826"></a>Sets a style. </p>
</td>
</tr>
<tr id="row1513939818084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p362232602084826"><a name="p362232602084826"></a><a name="p362232602084826"></a><a href="Graphic.md#ga4ea19bc9f4b487946c9e29e63b54a0e6">OHOS::UIView::GetStyle</a> (uint8_t key) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1832060263084826"><a name="p1832060263084826"></a><a name="p1832060263084826"></a>virtual int64_t&nbsp;</p>
<p id="p1744359273084826"><a name="p1744359273084826"></a><a name="p1744359273084826"></a>Obtains the value of a style. </p>
</td>
</tr>
<tr id="row409679677084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p922397902084826"><a name="p922397902084826"></a><a name="p922397902084826"></a><a href="Graphic.md#ga1b28213d4c2cd0f8324bce3fe56eb7bb">OHOS::UIView::GetStyleConst</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p185552377084826"><a name="p185552377084826"></a><a name="p185552377084826"></a>const <a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p843970074084826"><a name="p843970074084826"></a><a name="p843970074084826"></a>Obtains the view style. This function applies to scenarios where the style does not need to be modified, which saves memory. </p>
</td>
</tr>
<tr id="row401912069084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p555176364084826"><a name="p555176364084826"></a><a name="p555176364084826"></a><a href="Graphic.md#gadae043c6d43d5436ec0374e5d128c654">OHOS::UIViewGroup::UIViewGroup</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1438290664084826"><a name="p1438290664084826"></a><a name="p1438290664084826"></a>&nbsp;</p>
<p id="p1819399071084826"><a name="p1819399071084826"></a><a name="p1819399071084826"></a>A default constructor used to create a <strong id="b1903494466084826"><a name="b1903494466084826"></a><a name="b1903494466084826"></a><a href="OHOS-UIViewGroup.md">UIViewGroup</a></strong> instance. </p>
</td>
</tr>
<tr id="row1191497076084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1541509806084826"><a name="p1541509806084826"></a><a name="p1541509806084826"></a><a href="Graphic.md#ga19ec065bd41a01f0925a4a9ffa450d1c">OHOS::UIViewGroup::~UIViewGroup</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1338098148084826"><a name="p1338098148084826"></a><a name="p1338098148084826"></a>virtual&nbsp;</p>
<p id="p148560292084826"><a name="p148560292084826"></a><a name="p148560292084826"></a>A destructor used to delete the <strong id="b1880976151084826"><a name="b1880976151084826"></a><a name="b1880976151084826"></a><a href="OHOS-UIViewGroup.md">UIViewGroup</a></strong> instance. </p>
</td>
</tr>
<tr id="row1220700948084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1497800185084826"><a name="p1497800185084826"></a><a name="p1497800185084826"></a><a href="Graphic.md#gad5756764839a844ee9bee0c186798029">OHOS::UIViewGroup::GetViewType</a> () const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p789384915084826"><a name="p789384915084826"></a><a name="p789384915084826"></a>UIViewType&nbsp;</p>
<p id="p1980698063084826"><a name="p1980698063084826"></a><a name="p1980698063084826"></a>Obtains the view type. </p>
</td>
</tr>
<tr id="row83633914084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1890056594084826"><a name="p1890056594084826"></a><a name="p1890056594084826"></a><a href="Graphic.md#gacf5db120308ac7783c493f5437f06cee">OHOS::UIViewGroup::Add</a> (<a href="OHOS-UIView.md">UIView</a> *view)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1568847865084826"><a name="p1568847865084826"></a><a name="p1568847865084826"></a>virtual void&nbsp;</p>
<p id="p1933523430084826"><a name="p1933523430084826"></a><a name="p1933523430084826"></a>Adds a child view. </p>
</td>
</tr>
<tr id="row643198582084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p266055282084826"><a name="p266055282084826"></a><a name="p266055282084826"></a><a href="Graphic.md#ga84195a993bfe50d8302435ababb63966">OHOS::UIViewGroup::Insert</a> (<a href="OHOS-UIView.md">UIView</a> *prevView, <a href="OHOS-UIView.md">UIView</a> *insertView)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1912585581084826"><a name="p1912585581084826"></a><a name="p1912585581084826"></a>virtual void&nbsp;</p>
<p id="p870728169084826"><a name="p870728169084826"></a><a name="p870728169084826"></a>Inserts a new child view behind the current one. </p>
</td>
</tr>
<tr id="row2103239139084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p562271659084826"><a name="p562271659084826"></a><a name="p562271659084826"></a><a href="Graphic.md#ga25523928b24d6692f18aed31edb07006">OHOS::UIViewGroup::Remove</a> (<a href="OHOS-UIView.md">UIView</a> *view)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1487004389084826"><a name="p1487004389084826"></a><a name="p1487004389084826"></a>virtual void&nbsp;</p>
<p id="p971266831084826"><a name="p971266831084826"></a><a name="p971266831084826"></a>Removes a child view. </p>
</td>
</tr>
<tr id="row2101453157084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p259412123084826"><a name="p259412123084826"></a><a name="p259412123084826"></a><a href="Graphic.md#gaf3ee08173d92932687809049e3c11e9b">OHOS::UIViewGroup::RemoveAll</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p124440904084826"><a name="p124440904084826"></a><a name="p124440904084826"></a>virtual void&nbsp;</p>
<p id="p702383443084826"><a name="p702383443084826"></a><a name="p702383443084826"></a>Removes all child views. </p>
</td>
</tr>
<tr id="row1097652287084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p459486928084826"><a name="p459486928084826"></a><a name="p459486928084826"></a><a href="Graphic.md#ga7ea54fc6ef3a8b7dec1bf88ab189f7c7">OHOS::UIViewGroup::GetTargetView</a> (const <a href="OHOS-Point.md">Point</a> &amp;point, <a href="OHOS-UIView.md">UIView</a> **last) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p873796864084826"><a name="p873796864084826"></a><a name="p873796864084826"></a>virtual void&nbsp;</p>
<p id="p951694449084826"><a name="p951694449084826"></a><a name="p951694449084826"></a>Obtains the target child view that is visible and can respond to touch events based on given coordinates. </p>
</td>
</tr>
<tr id="row1238370468084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p60686502084826"><a name="p60686502084826"></a><a name="p60686502084826"></a><a href="Graphic.md#ga776c6c1640cb88b537af227fa5eb0725">OHOS::UIViewGroup::MoveChildByOffset</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2114423498084826"><a name="p2114423498084826"></a><a name="p2114423498084826"></a>virtual void&nbsp;</p>
<p id="p2019388673084826"><a name="p2019388673084826"></a><a name="p2019388673084826"></a>Moves all child views. </p>
</td>
</tr>
<tr id="row1177005423084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1060306962084826"><a name="p1060306962084826"></a><a name="p1060306962084826"></a><a href="Graphic.md#ga6fed8238b89b013552c5a247aa2471df">OHOS::UIViewGroup::GetChildrenHead</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1971172431084826"><a name="p1971172431084826"></a><a name="p1971172431084826"></a><a href="OHOS-UIView.md">UIView</a> *&nbsp;</p>
<p id="p495417852084826"><a name="p495417852084826"></a><a name="p495417852084826"></a>Obtains the first child view in this view group. </p>
</td>
</tr>
<tr id="row562971944084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p32526474084826"><a name="p32526474084826"></a><a name="p32526474084826"></a><a href="Graphic.md#ga1361baa76fbabd2fc81cc249c6868691">OHOS::UIViewGroup::GetChildrenTail</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2141800020084826"><a name="p2141800020084826"></a><a name="p2141800020084826"></a><a href="OHOS-UIView.md">UIView</a> *&nbsp;</p>
<p id="p489666754084826"><a name="p489666754084826"></a><a name="p489666754084826"></a>Obtains the last child view in this view group. </p>
</td>
</tr>
<tr id="row312563376084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1418481966084826"><a name="p1418481966084826"></a><a name="p1418481966084826"></a><a href="Graphic.md#gad53c52e619a54358a413a836ae0c1861">OHOS::UIViewGroup::SetDisallowIntercept</a> (bool flag)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p568576795084826"><a name="p568576795084826"></a><a name="p568576795084826"></a>void&nbsp;</p>
<p id="p1103117156084826"><a name="p1103117156084826"></a><a name="p1103117156084826"></a>Sets whether this view group is intercepted upon touch events. </p>
</td>
</tr>
<tr id="row57652923084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p875373212084826"><a name="p875373212084826"></a><a name="p875373212084826"></a><a href="Graphic.md#gae9f6ddb5819392546463d6371147c486">OHOS::UIViewGroup::GetChildById</a> (const char *id) const override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p971075413084826"><a name="p971075413084826"></a><a name="p971075413084826"></a><a href="OHOS-UIView.md">UIView</a> *&nbsp;</p>
<p id="p628381984084826"><a name="p628381984084826"></a><a name="p628381984084826"></a>Obtains the target child view with a specified ID. </p>
</td>
</tr>
<tr id="row717186774084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1377678682084826"><a name="p1377678682084826"></a><a name="p1377678682084826"></a><a href="Graphic.md#ga6442ba36114d739df1b17ca8943cc087">OHOS::UIViewGroup::SetAutoSize</a> (bool state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1695990155084826"><a name="p1695990155084826"></a><a name="p1695990155084826"></a>void&nbsp;</p>
<p id="p708626522084826"><a name="p708626522084826"></a><a name="p708626522084826"></a>Sets whether the size of this view group is adaptive to that of all child views. </p>
</td>
</tr>
<tr id="row1542236847084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p574762411084826"><a name="p574762411084826"></a><a name="p574762411084826"></a><a href="Graphic.md#ga34fe81b667a13b06a579600827e0531b">OHOS::UIViewGroup::GetAllChildRelativeRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2095158688084826"><a name="p2095158688084826"></a><a name="p2095158688084826"></a><a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p1176054447084826"><a name="p1176054447084826"></a><a name="p1176054447084826"></a>Obtains the rectangle area of a new view group after being adaptive to the size of all child views. </p>
</td>
</tr>
<tr id="row2005152828084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1641128744084826"><a name="p1641128744084826"></a><a name="p1641128744084826"></a><a href="Graphic.md#ga06a5bd621f6532fe5c8fd08a2c1314b2">OHOS::UIViewGroup::OnChildChanged</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p162722180084826"><a name="p162722180084826"></a><a name="p162722180084826"></a>virtual void&nbsp;</p>
<p id="p1056770530084826"><a name="p1056770530084826"></a><a name="p1056770530084826"></a>Performs operations needed after a child view is added or removed. </p>
</td>
</tr>
<tr id="row1210636761084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p219858213084826"><a name="p219858213084826"></a><a name="p219858213084826"></a><a href="Graphic.md#ga9f1bc7dc04063baeb71a3d3106be2b51">OHOS::UIDumpDomTree::GetInstance</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1116391022084826"><a name="p1116391022084826"></a><a name="p1116391022084826"></a>static <a href="OHOS-UIDumpDomTree.md">UIDumpDomTree</a> *&nbsp;</p>
<p id="p1187799850084826"><a name="p1187799850084826"></a><a name="p1187799850084826"></a>Obtains an instance in singleton pattern. </p>
</td>
</tr>
<tr id="row1138871878084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p416700575084826"><a name="p416700575084826"></a><a name="p416700575084826"></a><a href="Graphic.md#ga04fbff1f92851a2ac55c4575cbc132e9">OHOS::UIDumpDomTree::DumpDomTree</a> (const char *id, const char *path)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p46602012084826"><a name="p46602012084826"></a><a name="p46602012084826"></a>bool&nbsp;</p>
<p id="p887335010084826"><a name="p887335010084826"></a><a name="p887335010084826"></a>Exports information about a DOM tree starting from a specified DOM node and saves the information to a specified path. </p>
</td>
</tr>
<tr id="row137832992084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p304169713084826"><a name="p304169713084826"></a><a name="p304169713084826"></a><a href="Graphic.md#ga25384e441719c58d5cfdc3c67f1e8625">OHOS::UIDumpDomTree::DumpDomTree</a> (const char *id)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1411792663084826"><a name="p1411792663084826"></a><a name="p1411792663084826"></a>bool&nbsp;</p>
<p id="p1925483332084826"><a name="p1925483332084826"></a><a name="p1925483332084826"></a>Exports information about a DOM tree starting from a specified DOM node and saves the information to the default path. The default path is <strong id="b1694365971084826"><a name="b1694365971084826"></a><a name="b1694365971084826"></a>DEFAULT_DUMP_DOM_TREE_PATH</strong>. </p>
</td>
</tr>
<tr id="row888803628084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1095889581084826"><a name="p1095889581084826"></a><a name="p1095889581084826"></a><a href="Graphic.md#ga812e123f85aa3ff687908e19d23fc54f">OHOS::UIDumpDomTree::DumpDomNode</a> (const char *id)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p607414225084826"><a name="p607414225084826"></a><a name="p607414225084826"></a>char *&nbsp;</p>
<p id="p26625042084826"><a name="p26625042084826"></a><a name="p26625042084826"></a>Exports information about a specified DOM node. </p>
</td>
</tr>
<tr id="row1483899935084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1611914281084826"><a name="p1611914281084826"></a><a name="p1611914281084826"></a><a href="Graphic.md#gaf3b75ee84a33ffcbc640328b2747b0a1">OHOS::CancelEvent::CancelEvent</a> (const <a href="OHOS-Point.md">Point</a> &amp;pos)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p783294156084826"><a name="p783294156084826"></a><a name="p783294156084826"></a>&nbsp;</p>
<p id="p1115218740084826"><a name="p1115218740084826"></a><a name="p1115218740084826"></a>A constructor used to create a <strong id="b837367296084826"><a name="b837367296084826"></a><a name="b837367296084826"></a><a href="OHOS-CancelEvent.md">CancelEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row241674646084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p709912225084826"><a name="p709912225084826"></a><a name="p709912225084826"></a><a href="Graphic.md#ga5f8a22ac27c5ffc2b8801b4687a38394">OHOS::CancelEvent::~CancelEvent</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1487702731084826"><a name="p1487702731084826"></a><a name="p1487702731084826"></a>virtual&nbsp;</p>
<p id="p1576203721084826"><a name="p1576203721084826"></a><a name="p1576203721084826"></a>A destructor used to delete the <strong id="b506845713084826"><a name="b506845713084826"></a><a name="b506845713084826"></a><a href="OHOS-CancelEvent.md">CancelEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row1904317774084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p215472408084826"><a name="p215472408084826"></a><a name="p215472408084826"></a><a href="Graphic.md#gaeb51d39715cc72b383ba6059bd0d1053">OHOS::ClickEvent::ClickEvent</a> (const <a href="OHOS-Point.md">Point</a> &amp;pos)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p575865547084826"><a name="p575865547084826"></a><a name="p575865547084826"></a>&nbsp;</p>
<p id="p540637120084826"><a name="p540637120084826"></a><a name="p540637120084826"></a>A constructor used to create a <strong id="b1539446782084826"><a name="b1539446782084826"></a><a name="b1539446782084826"></a><a href="OHOS-ClickEvent.md">ClickEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row29698090084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p227024985084826"><a name="p227024985084826"></a><a name="p227024985084826"></a><a href="Graphic.md#ga75b3bef18631b1640c31dd1191f35ef7">OHOS::ClickEvent::~ClickEvent</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p398410901084826"><a name="p398410901084826"></a><a name="p398410901084826"></a>virtual&nbsp;</p>
<p id="p1088770337084826"><a name="p1088770337084826"></a><a name="p1088770337084826"></a>A destructor used to delete the <strong id="b784384849084826"><a name="b784384849084826"></a><a name="b784384849084826"></a><a href="OHOS-ClickEvent.md">ClickEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row242595342084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1438218035084826"><a name="p1438218035084826"></a><a name="p1438218035084826"></a><a href="Graphic.md#gae9af79f667fc1324739d2a07fdd5d94e">OHOS::DragEvent::DragEvent</a> (const <a href="OHOS-Point.md">Point</a> &amp;newPos, const <a href="OHOS-Point.md">Point</a> &amp;lastPos, const <a href="OHOS-Point.md">Point</a> &amp;totalLen)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p943783742084826"><a name="p943783742084826"></a><a name="p943783742084826"></a>&nbsp;</p>
<p id="p982926015084826"><a name="p982926015084826"></a><a name="p982926015084826"></a>A constructor used to create a <strong id="b1253082728084826"><a name="b1253082728084826"></a><a name="b1253082728084826"></a><a href="OHOS-DragEvent.md">DragEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row2137621190084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p780537742084826"><a name="p780537742084826"></a><a name="p780537742084826"></a><a href="Graphic.md#gabed19ea6c1b15b861653485349133468">OHOS::DragEvent::~DragEvent</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1433120327084826"><a name="p1433120327084826"></a><a name="p1433120327084826"></a>virtual&nbsp;</p>
<p id="p721066536084826"><a name="p721066536084826"></a><a name="p721066536084826"></a>A destructor used to delete the <strong id="b1931079530084826"><a name="b1931079530084826"></a><a name="b1931079530084826"></a><a href="OHOS-DragEvent.md">DragEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row1464800361084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p107577483084826"><a name="p107577483084826"></a><a name="p107577483084826"></a><a href="Graphic.md#ga2b5a66f36249b23e69cccfc2859847c1">OHOS::DragEvent::GetLastPoint</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p267150454084826"><a name="p267150454084826"></a><a name="p267150454084826"></a>const <a href="OHOS-Point.md">Point</a> &amp;&nbsp;</p>
<p id="p485482777084826"><a name="p485482777084826"></a><a name="p485482777084826"></a>Obtains the coordinates of the last position in the drag event. </p>
</td>
</tr>
<tr id="row1829334497084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1507182488084826"><a name="p1507182488084826"></a><a name="p1507182488084826"></a><a href="Graphic.md#gadeada49639b81e405b8b54e2629361ee">OHOS::DragEvent::GetStartPoint</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p888911588084826"><a name="p888911588084826"></a><a name="p888911588084826"></a>const <a href="OHOS-Point.md">Point</a> &amp;&nbsp;</p>
<p id="p358712378084826"><a name="p358712378084826"></a><a name="p358712378084826"></a>Obtains the start coordinates in the drag event. </p>
</td>
</tr>
<tr id="row1075153437084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p389615369084826"><a name="p389615369084826"></a><a name="p389615369084826"></a><a href="Graphic.md#ga8399680c67bc048745257a1b56250834">OHOS::DragEvent::SetPreLastPoint</a> (const <a href="OHOS-Point.md">Point</a> &amp;preLastPos)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1191318476084826"><a name="p1191318476084826"></a><a name="p1191318476084826"></a>void&nbsp;</p>
<p id="p1047365163084826"><a name="p1047365163084826"></a><a name="p1047365163084826"></a>Sets the coordinates of the stay position before the last position in the drag event. </p>
</td>
</tr>
<tr id="row1328394026084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p102651322084826"><a name="p102651322084826"></a><a name="p102651322084826"></a><a href="Graphic.md#ga7a7198c95326af4ad0d2e2a85fb99ef6">OHOS::DragEvent::GetPreLastPoint</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1902635432084826"><a name="p1902635432084826"></a><a name="p1902635432084826"></a>const <a href="OHOS-Point.md">Point</a> &amp;&nbsp;</p>
<p id="p1589000266084826"><a name="p1589000266084826"></a><a name="p1589000266084826"></a>Obtains the coordinates of the stay position before the last position in the drag event. </p>
</td>
</tr>
<tr id="row819713217084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p160232531084826"><a name="p160232531084826"></a><a name="p160232531084826"></a><a href="Graphic.md#gaf0ab47609e2dc46109f889847d9d7f9d">OHOS::DragEvent::GetDragDirection</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1035645801084826"><a name="p1035645801084826"></a><a name="p1035645801084826"></a>uint8_t&nbsp;</p>
<p id="p1046349146084826"><a name="p1046349146084826"></a><a name="p1046349146084826"></a>Obtains the direction in the drag event. </p>
</td>
</tr>
<tr id="row988779546084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p181551988084826"><a name="p181551988084826"></a><a name="p181551988084826"></a><a href="Graphic.md#ga4e504ef2c5ef58bb0c79bbfdb0168d0d">OHOS::DragEvent::GetDeltaX</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1253010424084826"><a name="p1253010424084826"></a><a name="p1253010424084826"></a>int16_t&nbsp;</p>
<p id="p183653526084826"><a name="p183653526084826"></a><a name="p183653526084826"></a>Obtains the difference between the current position and the last position of the view in the x-axis. </p>
</td>
</tr>
<tr id="row421510841084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p377284382084826"><a name="p377284382084826"></a><a name="p377284382084826"></a><a href="Graphic.md#ga13e3996546917d71612b34285f8b9dd7">OHOS::DragEvent::GetDeltaY</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1594742491084826"><a name="p1594742491084826"></a><a name="p1594742491084826"></a>int16_t&nbsp;</p>
<p id="p468875811084826"><a name="p468875811084826"></a><a name="p468875811084826"></a>Obtains the difference between the current position and the last position of the view in the y-axis. </p>
</td>
</tr>
<tr id="row985035011084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1002954695084826"><a name="p1002954695084826"></a><a name="p1002954695084826"></a><a href="Graphic.md#ga89cd09ced5537a3479b7901ba8abc6da">OHOS::Event::Event</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p131851900084826"><a name="p131851900084826"></a><a name="p131851900084826"></a>&nbsp;</p>
<p id="p924139321084826"><a name="p924139321084826"></a><a name="p924139321084826"></a>A default constructor used to create an <strong id="b87262909084826"><a name="b87262909084826"></a><a name="b87262909084826"></a><a href="OHOS-Event.md">Event</a></strong> instance. </p>
</td>
</tr>
<tr id="row1458914241084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1480643931084826"><a name="p1480643931084826"></a><a name="p1480643931084826"></a><a href="Graphic.md#ga57a9f07c8203c6a60f3b25c4edb526a0">OHOS::Event::Event</a> (const <a href="OHOS-Point.md">Point</a> &amp;curPos)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1918028871084826"><a name="p1918028871084826"></a><a name="p1918028871084826"></a>&nbsp;</p>
<p id="p1783355975084826"><a name="p1783355975084826"></a><a name="p1783355975084826"></a>A constructor used to create an <strong id="b851431692084826"><a name="b851431692084826"></a><a name="b851431692084826"></a><a href="OHOS-Event.md">Event</a></strong> instance. </p>
</td>
</tr>
<tr id="row1363769032084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p239203246084826"><a name="p239203246084826"></a><a name="p239203246084826"></a><a href="Graphic.md#gabafa07a6393f4757f402bf9437561fa4">OHOS::Event::~Event</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p81933215084826"><a name="p81933215084826"></a><a name="p81933215084826"></a>virtual&nbsp;</p>
<p id="p1308914288084826"><a name="p1308914288084826"></a><a name="p1308914288084826"></a>A destructor used to delete the <strong id="b1997572501084826"><a name="b1997572501084826"></a><a name="b1997572501084826"></a><a href="OHOS-Event.md">Event</a></strong> instance. </p>
</td>
</tr>
<tr id="row495401238084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p592913657084826"><a name="p592913657084826"></a><a name="p592913657084826"></a><a href="Graphic.md#gaea811c661ad416d7f70912ad6fcce269">OHOS::Event::GetCurrentPos</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p628621918084826"><a name="p628621918084826"></a><a name="p628621918084826"></a>const <a href="OHOS-Point.md">Point</a> &amp;&nbsp;</p>
<p id="p1897145850084826"><a name="p1897145850084826"></a><a name="p1897145850084826"></a>Obtains the position where an event occurs. </p>
</td>
</tr>
<tr id="row954962923084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1913430782084826"><a name="p1913430782084826"></a><a name="p1913430782084826"></a><a href="Graphic.md#ga7d56c2a99ab2c98eec9ebc03f67b7777">OHOS::Event::GetTimeStamp</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1934554674084826"><a name="p1934554674084826"></a><a name="p1934554674084826"></a>const TimeType &amp;&nbsp;</p>
<p id="p1294899663084826"><a name="p1294899663084826"></a><a name="p1294899663084826"></a>Obtains the timestamp when an event occurs. </p>
</td>
</tr>
<tr id="row542411662084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2029260591084826"><a name="p2029260591084826"></a><a name="p2029260591084826"></a><a href="Graphic.md#gabee47ba229e81c44f648cf5b3203010f">OHOS::Event::SetTimeStamp</a> (const TimeType &amp;timeStamp)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1961113201084826"><a name="p1961113201084826"></a><a name="p1961113201084826"></a>void&nbsp;</p>
<p id="p585562993084826"><a name="p585562993084826"></a><a name="p585562993084826"></a>Sets the timestamp when an event occurs. </p>
</td>
</tr>
<tr id="row1059401361084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1905765992084826"><a name="p1905765992084826"></a><a name="p1905765992084826"></a><a href="Graphic.md#ga3a52d91ac5d8fd7779baafae6ec92f9b">OHOS::KeyEvent::KeyEvent</a> (uint16_t keyId, uint16_t state)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1732617368084826"><a name="p1732617368084826"></a><a name="p1732617368084826"></a>&nbsp;</p>
<p id="p1725386936084826"><a name="p1725386936084826"></a><a name="p1725386936084826"></a>A constructor used to create a <strong id="b186189951084826"><a name="b186189951084826"></a><a name="b186189951084826"></a><a href="OHOS-KeyEvent.md">KeyEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row1525663970084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1884186612084826"><a name="p1884186612084826"></a><a name="p1884186612084826"></a><a href="Graphic.md#ga468e77700a90ef155a2428af9176551e">OHOS::KeyEvent::~KeyEvent</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1264766049084826"><a name="p1264766049084826"></a><a name="p1264766049084826"></a>&nbsp;</p>
<p id="p1512855537084826"><a name="p1512855537084826"></a><a name="p1512855537084826"></a>A destructor used to delete the <strong id="b1523418413084826"><a name="b1523418413084826"></a><a name="b1523418413084826"></a><a href="OHOS-KeyEvent.md">KeyEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row1157215327084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p647365168084826"><a name="p647365168084826"></a><a name="p647365168084826"></a><a href="Graphic.md#gae2b2b83cc3a562b3173f69c95722db99">OHOS::KeyEvent::GetKeyId</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1998936865084826"><a name="p1998936865084826"></a><a name="p1998936865084826"></a>uint16_t&nbsp;</p>
<p id="p555444685084826"><a name="p555444685084826"></a><a name="p555444685084826"></a>Obtains the key ID. </p>
</td>
</tr>
<tr id="row1119058074084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1222843213084826"><a name="p1222843213084826"></a><a name="p1222843213084826"></a><a href="Graphic.md#gaf93661e10da4b4df75c04d8fd199a5e8">OHOS::KeyEvent::GetState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p414390585084826"><a name="p414390585084826"></a><a name="p414390585084826"></a>uint16_t&nbsp;</p>
<p id="p1550055550084826"><a name="p1550055550084826"></a><a name="p1550055550084826"></a>Obtains the key state. </p>
</td>
</tr>
<tr id="row769978666084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2028524378084826"><a name="p2028524378084826"></a><a name="p2028524378084826"></a><a href="Graphic.md#ga0ccf400cdc4f55e28ef4680a4a3c5632">OHOS::LongPressEvent::LongPressEvent</a> (const <a href="OHOS-Point.md">Point</a> &amp;pos, const TimeType &amp;timeStamp)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1445651099084826"><a name="p1445651099084826"></a><a name="p1445651099084826"></a>&nbsp;</p>
<p id="p320273996084826"><a name="p320273996084826"></a><a name="p320273996084826"></a>A constructor used to create a <strong id="b1656709866084826"><a name="b1656709866084826"></a><a name="b1656709866084826"></a><a href="OHOS-LongPressEvent.md">LongPressEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row1152749188084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1671237339084826"><a name="p1671237339084826"></a><a name="p1671237339084826"></a><a href="Graphic.md#gab7cd91a47633f432b39da4f6056f72fc">OHOS::LongPressEvent::~LongPressEvent</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1791835879084826"><a name="p1791835879084826"></a><a name="p1791835879084826"></a>virtual&nbsp;</p>
<p id="p118920294084826"><a name="p118920294084826"></a><a name="p118920294084826"></a>A destructor used to delete the <strong id="b106183333084826"><a name="b106183333084826"></a><a name="b106183333084826"></a><a href="OHOS-LongPressEvent.md">LongPressEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row822682887084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p852124389084826"><a name="p852124389084826"></a><a name="p852124389084826"></a><a href="Graphic.md#ga851cee6814b500741c9eb4833ae75c19">OHOS::PressEvent::PressEvent</a> (const <a href="OHOS-Point.md">Point</a> &amp;pos)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p901413193084826"><a name="p901413193084826"></a><a name="p901413193084826"></a>&nbsp;</p>
<p id="p1142787561084826"><a name="p1142787561084826"></a><a name="p1142787561084826"></a>A constructor used to create a <strong id="b221771226084826"><a name="b221771226084826"></a><a name="b221771226084826"></a><a href="OHOS-PressEvent.md">PressEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row1107573089084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1067734961084826"><a name="p1067734961084826"></a><a name="p1067734961084826"></a><a href="Graphic.md#ga14740b5b74e00d2dfd612f2e08687884">OHOS::PressEvent::~PressEvent</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1081252527084826"><a name="p1081252527084826"></a><a name="p1081252527084826"></a>virtual&nbsp;</p>
<p id="p823596898084826"><a name="p823596898084826"></a><a name="p823596898084826"></a>A destructor used to delete the <strong id="b1138932225084826"><a name="b1138932225084826"></a><a name="b1138932225084826"></a><a href="OHOS-PressEvent.md">PressEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row1818673975084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1209488909084826"><a name="p1209488909084826"></a><a name="p1209488909084826"></a><a href="Graphic.md#gae74aa5e1b3f0af7e66d55e9be15f32d1">OHOS::ReleaseEvent::ReleaseEvent</a> (const <a href="OHOS-Point.md">Point</a> &amp;pos)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1393550802084826"><a name="p1393550802084826"></a><a name="p1393550802084826"></a>&nbsp;</p>
<p id="p258940958084826"><a name="p258940958084826"></a><a name="p258940958084826"></a>A constructor used to create a <strong id="b1554429483084826"><a name="b1554429483084826"></a><a name="b1554429483084826"></a><a href="OHOS-ReleaseEvent.md">ReleaseEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row1920556198084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1239929005084826"><a name="p1239929005084826"></a><a name="p1239929005084826"></a><a href="Graphic.md#ga4a9df65bdfd2edcb0f21be7b7e52ad56">OHOS::ReleaseEvent::~ReleaseEvent</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p59630574084826"><a name="p59630574084826"></a><a name="p59630574084826"></a>virtual&nbsp;</p>
<p id="p2147075593084826"><a name="p2147075593084826"></a><a name="p2147075593084826"></a>A destructor used to delete the <strong id="b1958615722084826"><a name="b1958615722084826"></a><a name="b1958615722084826"></a><a href="OHOS-ReleaseEvent.md">ReleaseEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row831365752084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1109786934084826"><a name="p1109786934084826"></a><a name="p1109786934084826"></a><a href="Graphic.md#ga4832bd35eeae9c4402c1cba6294fe55b">OHOS::VirtualDeviceEvent::VirtualDeviceEvent</a> (uint16_t type, uint16_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1233115262084826"><a name="p1233115262084826"></a><a name="p1233115262084826"></a>&nbsp;</p>
<p id="p935797788084826"><a name="p935797788084826"></a><a name="p935797788084826"></a>A constructor used to create a <strong id="b721487525084826"><a name="b721487525084826"></a><a name="b721487525084826"></a><a href="OHOS-VirtualDeviceEvent.md">VirtualDeviceEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row2133279932084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p940428000084826"><a name="p940428000084826"></a><a name="p940428000084826"></a><a href="Graphic.md#ga72e6afde17a0376e756b463e04a86ba1">OHOS::VirtualDeviceEvent::~VirtualDeviceEvent</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p76842708084826"><a name="p76842708084826"></a><a name="p76842708084826"></a>&nbsp;</p>
<p id="p1748594208084826"><a name="p1748594208084826"></a><a name="p1748594208084826"></a>A destructor used to delete the <strong id="b2091929768084826"><a name="b2091929768084826"></a><a name="b2091929768084826"></a><a href="OHOS-VirtualDeviceEvent.md">VirtualDeviceEvent</a></strong> instance. </p>
</td>
</tr>
<tr id="row1791785089084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p278030565084826"><a name="p278030565084826"></a><a name="p278030565084826"></a><a href="Graphic.md#ga47a12f474dd7351a303e4959a05b17d1">OHOS::VirtualDeviceEvent::GetType</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p476995892084826"><a name="p476995892084826"></a><a name="p476995892084826"></a>uint16_t&nbsp;</p>
<p id="p1943069419084826"><a name="p1943069419084826"></a><a name="p1943069419084826"></a>Obtains the type of the virtual device. </p>
</td>
</tr>
<tr id="row1219967278084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1010267482084826"><a name="p1010267482084826"></a><a name="p1010267482084826"></a><a href="Graphic.md#gae0619e7f8b3c97548f763f281bdd8261">OHOS::VirtualDeviceEvent::GetState</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1295875759084826"><a name="p1295875759084826"></a><a name="p1295875759084826"></a>uint16_t&nbsp;</p>
<p id="p120547065084826"><a name="p120547065084826"></a><a name="p120547065084826"></a>Obtains the state of the virtual event. </p>
</td>
</tr>
<tr id="row20689463084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p190602683084826"><a name="p190602683084826"></a><a name="p190602683084826"></a><a href="Graphic.md#ga3c8dd952afc5a76f8628c7f702755bd8">OHOS::Line::Line</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p891951858084826"><a name="p891951858084826"></a><a name="p891951858084826"></a>&nbsp;</p>
<p id="p9023835084826"><a name="p9023835084826"></a><a name="p9023835084826"></a>The default constructor used to create a <strong id="b653490927084826"><a name="b653490927084826"></a><a name="b653490927084826"></a><a href="OHOS-Line.md">Line</a></strong> instance. </p>
</td>
</tr>
<tr id="row743637670084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p313910249084826"><a name="p313910249084826"></a><a name="p313910249084826"></a><a href="Graphic.md#ga0bda554c3c7d5950637a50ffbbec2269">OHOS::Line::Line</a> (const <a href="OHOS-Vector2-T.md">Vector2</a>&lt; int16_t &gt; &amp;a, const <a href="OHOS-Vector2-T.md">Vector2</a>&lt; int16_t &gt; &amp;b)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p779364452084826"><a name="p779364452084826"></a><a name="p779364452084826"></a>&nbsp;</p>
<p id="p2091926926084826"><a name="p2091926926084826"></a><a name="p2091926926084826"></a>A constructor used to create a <strong id="b785211246084826"><a name="b785211246084826"></a><a name="b785211246084826"></a><a href="OHOS-Line.md">Line</a></strong> instance. </p>
</td>
</tr>
<tr id="row1777443698084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p49021782084826"><a name="p49021782084826"></a><a name="p49021782084826"></a><a href="Graphic.md#ga216de7fbcb274d28bb5a50d0e0692aa0">OHOS::Line::Line</a> (int16_t x1, int16_t <a href="MATH.md#ga369368526a105f3fba6776b11586070c">y1</a>, int16_t x2, int16_t y2)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p868667588084826"><a name="p868667588084826"></a><a name="p868667588084826"></a>&nbsp;</p>
<p id="p1070785536084826"><a name="p1070785536084826"></a><a name="p1070785536084826"></a>A constructor used to create a <strong id="b959945183084826"><a name="b959945183084826"></a><a name="b959945183084826"></a><a href="OHOS-Line.md">Line</a></strong> instance. </p>
</td>
</tr>
<tr id="row762199778084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1440099571084826"><a name="p1440099571084826"></a><a name="p1440099571084826"></a><a href="Graphic.md#ga86d5bfc47854c5e85363adce571de167">OHOS::Line::~Line</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1682118632084826"><a name="p1682118632084826"></a><a name="p1682118632084826"></a>&nbsp;</p>
<p id="p1398241614084826"><a name="p1398241614084826"></a><a name="p1398241614084826"></a>A destructor used to delete the <strong id="b1385893183084826"><a name="b1385893183084826"></a><a name="b1385893183084826"></a><a href="OHOS-Line.md">Line</a></strong> instance. </p>
</td>
</tr>
<tr id="row1586936055084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p449506795084826"><a name="p449506795084826"></a><a name="p449506795084826"></a><a href="Graphic.md#gafeae0169d5e3e92fcbc743c09cd4f6d0">OHOS::Line::operator[]</a> (uint8_t <a href="UTILS.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p330786539084826"><a name="p330786539084826"></a><a name="p330786539084826"></a><a href="OHOS-Vector2-T.md">Vector2</a>&lt; int16_t &gt; &amp;&nbsp;</p>
<p id="p1129990709084826"><a name="p1129990709084826"></a><a name="p1129990709084826"></a>Obtains the start or end point of the line based on the value of <strong id="b493801581084826"><a name="b493801581084826"></a><a name="b493801581084826"></a>index</strong>. </p>
</td>
</tr>
<tr id="row1752761064084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1408052229084826"><a name="p1408052229084826"></a><a name="p1408052229084826"></a><a href="Graphic.md#ga3f747832db7335f2198c7746140a6631">OHOS::Line::operator[]</a> (uint8_t <a href="UTILS.md#ga1d3748ca570dcb09a2fb28e8015107dd">index</a>) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1908918229084826"><a name="p1908918229084826"></a><a name="p1908918229084826"></a>const <a href="OHOS-Vector2-T.md">Vector2</a>&lt; int16_t &gt;&nbsp;</p>
<p id="p1743054802084826"><a name="p1743054802084826"></a><a name="p1743054802084826"></a>Obtains the start or end point of the line based on the value of <strong id="b385335660084826"><a name="b385335660084826"></a><a name="b385335660084826"></a>index</strong>. </p>
</td>
</tr>
<tr id="row499068647084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p713624813084826"><a name="p713624813084826"></a><a name="p713624813084826"></a><a href="Graphic.md#ga56fa89b7be39ff928c8ad488bbaddac3">OHOS::Polygon::Polygon</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p199713441084826"><a name="p199713441084826"></a><a name="p199713441084826"></a>&nbsp;</p>
<p id="p1794855121084826"><a name="p1794855121084826"></a><a name="p1794855121084826"></a>The default constructor used to create a <strong id="b2093114274084826"><a name="b2093114274084826"></a><a name="b2093114274084826"></a><a href="OHOS-Polygon.md">Polygon</a></strong> instance. </p>
</td>
</tr>
<tr id="row73718727084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1498187410084826"><a name="p1498187410084826"></a><a name="p1498187410084826"></a><a href="Graphic.md#gaa3be3f3605efe49629c024974e56da6a">OHOS::Polygon::Polygon</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;rect)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p901706247084826"><a name="p901706247084826"></a><a name="p901706247084826"></a>&nbsp;</p>
<p id="p99373963084826"><a name="p99373963084826"></a><a name="p99373963084826"></a>A constructor used to construct a <strong id="b1239356420084826"><a name="b1239356420084826"></a><a name="b1239356420084826"></a><a href="OHOS-Polygon.md">Polygon</a></strong> instance based on a rectangle. </p>
</td>
</tr>
<tr id="row1529008168084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p128727236084826"><a name="p128727236084826"></a><a name="p128727236084826"></a><a href="Graphic.md#ga54df053b5f430ed2ee7be14a898f668d">OHOS::Polygon::Polygon</a> (const <a href="OHOS-Vector2-T.md">Vector2</a>&lt; int16_t &gt; *vertexes, const uint8_t vertexNum)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1541511915084826"><a name="p1541511915084826"></a><a name="p1541511915084826"></a>&nbsp;</p>
<p id="p1410470138084826"><a name="p1410470138084826"></a><a name="p1410470138084826"></a>A constructor used to create a <strong id="b1449521782084826"><a name="b1449521782084826"></a><a name="b1449521782084826"></a><a href="OHOS-Polygon.md">Polygon</a></strong> instance based on the vertex coordinates and the number of coordinates. </p>
</td>
</tr>
<tr id="row164827576084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1206942379084826"><a name="p1206942379084826"></a><a name="p1206942379084826"></a><a href="Graphic.md#gab27ef37ff8b5462c771aed96f58dcac6">OHOS::Polygon::~Polygon</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1413734566084826"><a name="p1413734566084826"></a><a name="p1413734566084826"></a>&nbsp;</p>
<p id="p181195307084826"><a name="p181195307084826"></a><a name="p181195307084826"></a>A destructor used to delete the <strong id="b1135607795084826"><a name="b1135607795084826"></a><a name="b1135607795084826"></a><a href="OHOS-Polygon.md">Polygon</a></strong> instance. </p>
</td>
</tr>
<tr id="row972823995084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1533048935084826"><a name="p1533048935084826"></a><a name="p1533048935084826"></a><a href="Graphic.md#ga73295e4e05e9063082fb33b9847f4831">OHOS::Polygon::MakeAABB</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p883395353084826"><a name="p883395353084826"></a><a name="p883395353084826"></a><a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p2021150720084826"><a name="p2021150720084826"></a><a name="p2021150720084826"></a>Obtains the minimum rectangle that can contain the polygon. All vertices of the polygon are inside this rectangle. </p>
</td>
</tr>
<tr id="row1261356052084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2122238551084826"><a name="p2122238551084826"></a><a name="p2122238551084826"></a><a href="Graphic.md#gaca0240aa7a65b24365064f296ff38a63">OHOS::Polygon::GetVertexNum</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1118728559084826"><a name="p1118728559084826"></a><a name="p1118728559084826"></a>uint8_t&nbsp;</p>
<p id="p425813736084826"><a name="p425813736084826"></a><a name="p425813736084826"></a>Obtains the number of vertices of the polygon. </p>
</td>
</tr>
<tr id="row1519763538084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p5729523084826"><a name="p5729523084826"></a><a name="p5729523084826"></a><a href="Graphic.md#gad1990bc3055e0155d324479a2bb3baf1">OHOS::Polygon::SetVertexNum</a> (uint8_t vertexNum)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1373095084826"><a name="p1373095084826"></a><a name="p1373095084826"></a>void&nbsp;</p>
<p id="p1518646478084826"><a name="p1518646478084826"></a><a name="p1518646478084826"></a>Sets the number of vertices of a polygon. </p>
</td>
</tr>
<tr id="row160779761084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1185210161084826"><a name="p1185210161084826"></a><a name="p1185210161084826"></a><a href="Graphic.md#ga1779d4dd0671282d297f1693252ca9d9">OHOS::Intersect</a> (const <a href="OHOS-Line.md">Line</a> &amp;a, const <a href="OHOS-Line.md">Line</a> &amp;b, <a href="OHOS-Vector2-T.md">Vector2</a>&lt; int16_t &gt; &amp;out)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p751766554084826"><a name="p751766554084826"></a><a name="p751766554084826"></a>bool&nbsp;</p>
<p id="p802743420084826"><a name="p802743420084826"></a><a name="p802743420084826"></a>Checks whether line segment a and line segment b intersect, and returns the intersection point (if available). </p>
</td>
</tr>
<tr id="row205342484084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1953383647084826"><a name="p1953383647084826"></a><a name="p1953383647084826"></a><a href="Graphic.md#gace8a8524c6f91aa2f0f9be73a628da20">OHOS::IsIntersect</a> (const <a href="OHOS-Line.md">Line</a> &amp;a, const <a href="OHOS-Line.md">Line</a> &amp;b)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1147226597084826"><a name="p1147226597084826"></a><a name="p1147226597084826"></a>bool&nbsp;</p>
<p id="p1186638461084826"><a name="p1186638461084826"></a><a name="p1186638461084826"></a>Chekcs whether line segment a and line segment b intersect. </p>
</td>
</tr>
<tr id="row994679198084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p567948444084826"><a name="p567948444084826"></a><a name="p567948444084826"></a><a href="Graphic.md#ga0001387a136a87fb2c2e2b5eb3363c72">OHOS::Clip</a> (<a href="OHOS-Polygon.md">Polygon</a> &amp;poly, const <a href="OHOS-Line.md">Line</a> &amp;line)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1856685425084826"><a name="p1856685425084826"></a><a name="p1856685425084826"></a>void&nbsp;</p>
<p id="p1221596211084826"><a name="p1221596211084826"></a><a name="p1221596211084826"></a>Clips a polygon by using a line segment. </p>
</td>
</tr>
<tr id="row1627466105084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p188206829084826"><a name="p188206829084826"></a><a name="p188206829084826"></a><a href="Graphic.md#ga9fd2882e4813fbf4dbe77baa50d97b5c">OHOS::SuthHodgClip</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;clipRect, const <a href="OHOS-Polygon.md">Polygon</a> &amp;polygon)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p886933207084826"><a name="p886933207084826"></a><a name="p886933207084826"></a><a href="OHOS-Polygon.md">Polygon</a>&nbsp;</p>
<p id="p1771858139084826"><a name="p1771858139084826"></a><a name="p1771858139084826"></a>Implements Sutherland-Hodgman, an algorithm used for clipping polygons. </p>
</td>
</tr>
<tr id="row404456703084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1584436103084826"><a name="p1584436103084826"></a><a name="p1584436103084826"></a><a href="Graphic.md#ga22219a4351530d5a6914bdc5dcf406d0">OHOS::Clip</a> (const <a href="OHOS-Line.md">Line</a> &amp;line, const <a href="OHOS-Polygon.md">Polygon</a> &amp;poly, <a href="OHOS-Vector2-T.md">Vector2</a>&lt; int16_t &gt; *pOut, uint8_t *pNum)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1527736896084826"><a name="p1527736896084826"></a><a name="p1527736896084826"></a>void&nbsp;</p>
<p id="p1881562038084826"><a name="p1881562038084826"></a><a name="p1881562038084826"></a>Clips a polygon by using a line segment and obtains the intersections. </p>
</td>
</tr>
<tr id="row887479127084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1629327766084826"><a name="p1629327766084826"></a><a name="p1629327766084826"></a><a href="Graphic.md#ga7fd378c8c6c9fcf7325fa354f182865c">OHOS::Vector2&lt; T &gt;::Vector2</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p638961672084826"><a name="p638961672084826"></a><a name="p638961672084826"></a>&nbsp;</p>
<p id="p497293315084826"><a name="p497293315084826"></a><a name="p497293315084826"></a>A constructor used to create a <strong id="b483714541084826"><a name="b483714541084826"></a><a name="b483714541084826"></a><a href="OHOS-Vector2-T.md">Vector2</a></strong> instance. </p>
</td>
</tr>
<tr id="row350588526084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1646633836084826"><a name="p1646633836084826"></a><a name="p1646633836084826"></a><a href="Graphic.md#gada601fe3518d7bb489010370f1db9903">OHOS::Vector2&lt; T &gt;::Vector2</a> (T x, T y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1936295593084826"><a name="p1936295593084826"></a><a name="p1936295593084826"></a>&nbsp;</p>
<p id="p1089239363084826"><a name="p1089239363084826"></a><a name="p1089239363084826"></a>A constructor used to create a <strong id="b1661779794084826"><a name="b1661779794084826"></a><a name="b1661779794084826"></a><a href="OHOS-Vector2-T.md">Vector2</a></strong> instance based on the X and Y coordinates. </p>
</td>
</tr>
<tr id="row66246697084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p180637762084826"><a name="p180637762084826"></a><a name="p180637762084826"></a><a href="Graphic.md#ga1cc5130b89192fc1403eb29dd4504cbb">OHOS::Vector2&lt; T &gt;::~Vector2</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1069851166084826"><a name="p1069851166084826"></a><a name="p1069851166084826"></a>&nbsp;</p>
<p id="p1386880522084826"><a name="p1386880522084826"></a><a name="p1386880522084826"></a>A destructor used to delete the <strong id="b1985220076084826"><a name="b1985220076084826"></a><a name="b1985220076084826"></a><a href="OHOS-Vector2-T.md">Vector2</a></strong> instance. </p>
</td>
</tr>
<tr id="row1336713648084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p221761047084826"><a name="p221761047084826"></a><a name="p221761047084826"></a><a href="Graphic.md#gae45c198b5bcb73ecac8d654c281bc21a">OHOS::Vector2&lt; T &gt;::Dot</a> (const <a href="OHOS-Vector2-T.md">Vector2</a>&lt; T &gt; &amp;other) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1691550412084826"><a name="p1691550412084826"></a><a name="p1691550412084826"></a>T&nbsp;</p>
<p id="p583369452084826"><a name="p583369452084826"></a><a name="p583369452084826"></a>Calculates the scalar product of the two-dimensional vector and another two-dimensional vector. </p>
</td>
</tr>
<tr id="row229910856084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p198163753084826"><a name="p198163753084826"></a><a name="p198163753084826"></a><a href="Graphic.md#gac1c8e01fd488d5f8aea6bddad1dec206">OHOS::Vector2&lt; T &gt;::Cross</a> (const <a href="OHOS-Vector2-T.md">Vector2</a>&lt; T &gt; &amp;other) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p726177646084826"><a name="p726177646084826"></a><a name="p726177646084826"></a>T&nbsp;</p>
<p id="p528482072084826"><a name="p528482072084826"></a><a name="p528482072084826"></a>Calculates the cross product of the two-dimensional vector and another two-dimensional vector. </p>
</td>
</tr>
<tr id="row619841174084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1023646557084826"><a name="p1023646557084826"></a><a name="p1023646557084826"></a><a href="Graphic.md#ga0e56d35f73116fdc410e305c1d702076">OHOS::Vector3&lt; T &gt;::Vector3</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1451386867084826"><a name="p1451386867084826"></a><a name="p1451386867084826"></a>&nbsp;</p>
<p id="p266667739084826"><a name="p266667739084826"></a><a name="p266667739084826"></a>A constructor used to create a <strong id="b552701465084826"><a name="b552701465084826"></a><a name="b552701465084826"></a><a href="OHOS-Vector3-T.md">Vector3</a></strong> instance. </p>
</td>
</tr>
<tr id="row1155356610084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1126312233084826"><a name="p1126312233084826"></a><a name="p1126312233084826"></a><a href="Graphic.md#ga1b07727c686eb7a4d028d1052cc0fd3c">OHOS::Vector3&lt; T &gt;::Vector3</a> (T x, T y, T z)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p681902797084826"><a name="p681902797084826"></a><a name="p681902797084826"></a>&nbsp;</p>
<p id="p651690769084826"><a name="p651690769084826"></a><a name="p651690769084826"></a>Defines a <strong id="b1907653349084826"><a name="b1907653349084826"></a><a name="b1907653349084826"></a><a href="OHOS-Vector3-T.md">Vector3</a></strong> instance and initializes the values of <strong id="b1266657794084826"><a name="b1266657794084826"></a><a name="b1266657794084826"></a>x</strong>, <strong id="b1912981829084826"><a name="b1912981829084826"></a><a name="b1912981829084826"></a>y</strong>, and <strong id="b1433740307084826"><a name="b1433740307084826"></a><a name="b1433740307084826"></a>z</strong>. </p>
</td>
</tr>
<tr id="row250368221084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1335756982084826"><a name="p1335756982084826"></a><a name="p1335756982084826"></a><a href="Graphic.md#ga3b5bda0743cb7968e10429b627444f20">OHOS::Vector3&lt; T &gt;::~Vector3</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p566696828084826"><a name="p566696828084826"></a><a name="p566696828084826"></a>&nbsp;</p>
<p id="p101668961084826"><a name="p101668961084826"></a><a name="p101668961084826"></a>A destructor used to delete the <strong id="b1400239069084826"><a name="b1400239069084826"></a><a name="b1400239069084826"></a><a href="OHOS-Vector3-T.md">Vector3</a></strong> instance. </p>
</td>
</tr>
<tr id="row1868048302084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p399827677084826"><a name="p399827677084826"></a><a name="p399827677084826"></a><a href="Graphic.md#ga8fedd026cac422882e9c0a0d5d1f3b50">OHOS::Matrix3&lt; T &gt;::Matrix3</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p220455056084826"><a name="p220455056084826"></a><a name="p220455056084826"></a>&nbsp;</p>
<p id="p1496924582084826"><a name="p1496924582084826"></a><a name="p1496924582084826"></a>Defines a <strong id="b1321542077084826"><a name="b1321542077084826"></a><a name="b1321542077084826"></a><a href="OHOS-Matrix3-T.md">Matrix3</a></strong> instance and initializes the 3 x 3 matrix data. </p>
</td>
</tr>
<tr id="row1879576927084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1509162762084826"><a name="p1509162762084826"></a><a name="p1509162762084826"></a><a href="Graphic.md#ga068d055d130c7c46269072bf65254082">OHOS::Matrix3&lt; T &gt;::Matrix3</a> (T m00, T m01, T m02, T m10, T m11, T m12, T m20, T m21, T m22)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1742380373084826"><a name="p1742380373084826"></a><a name="p1742380373084826"></a>&nbsp;</p>
<p id="p1856520661084826"><a name="p1856520661084826"></a><a name="p1856520661084826"></a>Defines a <strong id="b68854884084826"><a name="b68854884084826"></a><a name="b68854884084826"></a><a href="OHOS-Matrix3-T.md">Matrix3</a></strong> instance and initializes the 3 x 3 matrix data. </p>
</td>
</tr>
<tr id="row564236296084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1602907596084826"><a name="p1602907596084826"></a><a name="p1602907596084826"></a><a href="Graphic.md#ga9cf7c2656623468c34003bb3c4056a72">OHOS::Matrix3&lt; T &gt;::~Matrix3</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1406104856084826"><a name="p1406104856084826"></a><a name="p1406104856084826"></a>&nbsp;</p>
<p id="p470729301084826"><a name="p470729301084826"></a><a name="p470729301084826"></a>A destructor used to delete the <strong id="b2134163425084826"><a name="b2134163425084826"></a><a name="b2134163425084826"></a><a href="OHOS-Matrix3-T.md">Matrix3</a></strong> instance. </p>
</td>
</tr>
<tr id="row2064511012084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p575987439084826"><a name="p575987439084826"></a><a name="p575987439084826"></a><a href="Graphic.md#ga8fd60ee68cc3a51d8c7ea9d3d665323c">OHOS::Matrix3&lt; T &gt;::GetData</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p150987552084826"><a name="p150987552084826"></a><a name="p150987552084826"></a>const T *&nbsp;</p>
<p id="p150561357084826"><a name="p150561357084826"></a><a name="p150561357084826"></a>Obtains the 3 x 3 matrix data. </p>
</td>
</tr>
<tr id="row479952659084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p555586368084826"><a name="p555586368084826"></a><a name="p555586368084826"></a><a href="Graphic.md#ga5464ffd57d0abbd0381b2a6cf3a7d2fb">OHOS::Matrix3&lt; T &gt;::Determinant</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1619317182084826"><a name="p1619317182084826"></a><a name="p1619317182084826"></a>T&nbsp;</p>
<p id="p1419810839084826"><a name="p1419810839084826"></a><a name="p1419810839084826"></a>Obtains the determinant of the matrix. </p>
</td>
</tr>
<tr id="row1588807250084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1138570156084826"><a name="p1138570156084826"></a><a name="p1138570156084826"></a><a href="Graphic.md#gabf1edc9a01bace13596de01615ae20a2">OHOS::Matrix3&lt; T &gt;::Inverse</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1336963809084826"><a name="p1336963809084826"></a><a name="p1336963809084826"></a><a href="OHOS-Matrix3-T.md">Matrix3</a>&nbsp;</p>
<p id="p1792006992084826"><a name="p1792006992084826"></a><a name="p1792006992084826"></a>Obtains the inverse matrix. </p>
</td>
</tr>
<tr id="row665776559084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p832172423084826"><a name="p832172423084826"></a><a name="p832172423084826"></a><a href="Graphic.md#ga8bd72462c8fdba21d3a805a415a88d06">OHOS::Matrix3&lt; T &gt;::Rotate</a> (T angle, const <a href="OHOS-Vector2-T.md">Vector2</a>&lt; T &gt; &amp;pivot)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1951670975084826"><a name="p1951670975084826"></a><a name="p1951670975084826"></a>static <a href="OHOS-Matrix3-T.md">Matrix3</a>&nbsp;</p>
<p id="p1783200891084826"><a name="p1783200891084826"></a><a name="p1783200891084826"></a>Obtains a rotation matrix. After a matrix is rotated, its data is shifted leftwards by 15 bits. Therefore, the result data needs to be shifted rightwards by 15 bits. </p>
</td>
</tr>
<tr id="row1471449770084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1648228296084826"><a name="p1648228296084826"></a><a name="p1648228296084826"></a><a href="Graphic.md#ga915aa59cac37c6584fafb06a06046087">OHOS::Matrix3&lt; T &gt;::Scale</a> (const <a href="OHOS-Vector2-T.md">Vector2</a>&lt; T &gt; &amp;scale, const <a href="OHOS-Vector2-T.md">Vector2</a>&lt; T &gt; &amp;fixed)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p295306764084826"><a name="p295306764084826"></a><a name="p295306764084826"></a>static <a href="OHOS-Matrix3-T.md">Matrix3</a>&nbsp;</p>
<p id="p1010048637084826"><a name="p1010048637084826"></a><a name="p1010048637084826"></a>Obtains the scaling matrix. After a matrix is scaled, its data is shifted leftwards by 8 bits. Therefore, the result data needs to be shifted rightwards by 8 bits. </p>
</td>
</tr>
<tr id="row734893953084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p880562726084826"><a name="p880562726084826"></a><a name="p880562726084826"></a><a href="Graphic.md#gab1cbae80ef16538294c97ba81626970e">OHOS::Matrix3&lt; T &gt;::Translate</a> (const <a href="OHOS-Vector2-T.md">Vector2</a>&lt; T &gt; &amp;trans)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1500521306084826"><a name="p1500521306084826"></a><a name="p1500521306084826"></a>static <a href="OHOS-Matrix3-T.md">Matrix3</a>&lt; T &gt;&nbsp;</p>
<p id="p1695675470084826"><a name="p1695675470084826"></a><a name="p1695675470084826"></a>Obtains a matrix translation. </p>
</td>
</tr>
<tr id="row1132854417084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1679716878084826"><a name="p1679716878084826"></a><a name="p1679716878084826"></a><a href="Graphic.md#ga4854963aa969ee20a6cd174a70f5cd23">OHOS::HeapBase::operator new</a> (size_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1846891440084826"><a name="p1846891440084826"></a><a name="p1846891440084826"></a>void *&nbsp;</p>
<p id="p1085291089084826"><a name="p1085291089084826"></a><a name="p1085291089084826"></a>Overrides the <strong id="b2100538057084826"><a name="b2100538057084826"></a><a name="b2100538057084826"></a>new</strong> function. </p>
</td>
</tr>
<tr id="row2100809052084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p723245479084826"><a name="p723245479084826"></a><a name="p723245479084826"></a><a href="Graphic.md#gadf1997a0f56ac2b220e7f0f8e8e0a6ef">OHOS::HeapBase::operator delete</a> (void *p)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p660695142084826"><a name="p660695142084826"></a><a name="p660695142084826"></a>void&nbsp;</p>
<p id="p921368276084826"><a name="p921368276084826"></a><a name="p921368276084826"></a>Overrides the <strong id="b185045455084826"><a name="b185045455084826"></a><a name="b185045455084826"></a>delete</strong> function. </p>
</td>
</tr>
<tr id="row1606683600084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1053872840084826"><a name="p1053872840084826"></a><a name="p1053872840084826"></a><a href="Graphic.md#gac06da499194705b22e31a8a78022ceab">OHOS::FlexLayout::FlexLayout</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p427129073084826"><a name="p427129073084826"></a><a name="p427129073084826"></a>&nbsp;</p>
<p id="p760106108084826"><a name="p760106108084826"></a><a name="p760106108084826"></a>A default constructor used to create a <strong id="b922242489084826"><a name="b922242489084826"></a><a name="b922242489084826"></a><a href="OHOS-FlexLayout.md">FlexLayout</a></strong> instance. </p>
</td>
</tr>
<tr id="row1808137994084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p544638360084826"><a name="p544638360084826"></a><a name="p544638360084826"></a><a href="Graphic.md#gada390db4ca762cf1dac06abfcd74e543">OHOS::FlexLayout::~FlexLayout</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p979525149084826"><a name="p979525149084826"></a><a name="p979525149084826"></a>virtual&nbsp;</p>
<p id="p504065618084826"><a name="p504065618084826"></a><a name="p504065618084826"></a>A destructor used to delete the <strong id="b53450525084826"><a name="b53450525084826"></a><a name="b53450525084826"></a><a href="OHOS-FlexLayout.md">FlexLayout</a></strong> instance. </p>
</td>
</tr>
<tr id="row1677941415084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1174111765084826"><a name="p1174111765084826"></a><a name="p1174111765084826"></a><a href="Graphic.md#gaa683d4401ecb3c19a5b5c2cea1252636">OHOS::FlexLayout::SetMajorAxisAlign</a> (const AlignType &amp;align)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1635154962084826"><a name="p1635154962084826"></a><a name="p1635154962084826"></a>void&nbsp;</p>
<p id="p1187923016084826"><a name="p1187923016084826"></a><a name="p1187923016084826"></a>Sets the alignment mode of the primary axis (the axis where the layout direction is located). The child views in the layout are placed in this mode in the direction of the primary axis. </p>
</td>
</tr>
<tr id="row851983260084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p877987626084826"><a name="p877987626084826"></a><a name="p877987626084826"></a><a href="Graphic.md#gadb57c6de7bcd0c04cde8004019e32b32">OHOS::FlexLayout::SetSecondaryAxisAlign</a> (const AlignType &amp;align)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p592635719084826"><a name="p592635719084826"></a><a name="p592635719084826"></a>void&nbsp;</p>
<p id="p1776919306084826"><a name="p1776919306084826"></a><a name="p1776919306084826"></a>Sets the alignment mode of the secondary axis (the axis perpendicular to the set layout direction). </p>
</td>
</tr>
<tr id="row1725564468084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p77884580084826"><a name="p77884580084826"></a><a name="p77884580084826"></a><a href="Graphic.md#gade436564eb29d29e32220863a6fe94e1">OHOS::FlexLayout::SetFlexWrap</a> (uint8_t wrap)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1777816890084826"><a name="p1777816890084826"></a><a name="p1777816890084826"></a>void&nbsp;</p>
<p id="p80386986084826"><a name="p80386986084826"></a><a name="p80386986084826"></a>Sets whether to support word wrap. </p>
</td>
</tr>
<tr id="row1162792732084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p735047499084826"><a name="p735047499084826"></a><a name="p735047499084826"></a><a href="Graphic.md#ga976abe5b006bef9018dd0d8ee2380526">OHOS::FlexLayout::LayoutChildren</a> (bool needInvalidate=false) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1471918176084826"><a name="p1471918176084826"></a><a name="p1471918176084826"></a>virtual void&nbsp;</p>
<p id="p1765200324084826"><a name="p1765200324084826"></a><a name="p1765200324084826"></a>Lays out all child views according to the preset arrangement mode. </p>
</td>
</tr>
<tr id="row901994717084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p894880945084826"><a name="p894880945084826"></a><a name="p894880945084826"></a><a href="Graphic.md#ga9c612ad9265b7031ed95844277608b3e">OHOS::GridLayout::GridLayout</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p77358258084826"><a name="p77358258084826"></a><a name="p77358258084826"></a>&nbsp;</p>
<p id="p1773209658084826"><a name="p1773209658084826"></a><a name="p1773209658084826"></a>A default constructor used to create a <strong id="b1405175553084826"><a name="b1405175553084826"></a><a name="b1405175553084826"></a><a href="OHOS-GridLayout.md">GridLayout</a></strong> instance. </p>
</td>
</tr>
<tr id="row2069602299084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p334117178084826"><a name="p334117178084826"></a><a name="p334117178084826"></a><a href="Graphic.md#ga1c2e62760fdb7032341272197f376358">OHOS::GridLayout::~GridLayout</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2050792458084826"><a name="p2050792458084826"></a><a name="p2050792458084826"></a>virtual&nbsp;</p>
<p id="p441313625084826"><a name="p441313625084826"></a><a name="p441313625084826"></a>A destructor used to delete the <strong id="b1390426149084826"><a name="b1390426149084826"></a><a name="b1390426149084826"></a><a href="OHOS-GridLayout.md">GridLayout</a></strong> instance. </p>
</td>
</tr>
<tr id="row813244730084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1410844725084826"><a name="p1410844725084826"></a><a name="p1410844725084826"></a><a href="Graphic.md#gac2df1f13d5ee6d2e6993c9a51eb9a716">OHOS::GridLayout::SetRows</a> (const uint16_t &amp;rows)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2016841746084826"><a name="p2016841746084826"></a><a name="p2016841746084826"></a>void&nbsp;</p>
<p id="p1438352178084826"><a name="p1438352178084826"></a><a name="p1438352178084826"></a>Sets the number of rows in a grid. </p>
</td>
</tr>
<tr id="row1129345058084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1346648744084826"><a name="p1346648744084826"></a><a name="p1346648744084826"></a><a href="Graphic.md#gab5737dec2f5c0bc812dee9c4bc7a796b">OHOS::GridLayout::SetCols</a> (const uint16_t &amp;cols)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p19671972084826"><a name="p19671972084826"></a><a name="p19671972084826"></a>void&nbsp;</p>
<p id="p1411519902084826"><a name="p1411519902084826"></a><a name="p1411519902084826"></a>Sets the number of columns in a grid. </p>
</td>
</tr>
<tr id="row598340713084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p561676914084826"><a name="p561676914084826"></a><a name="p561676914084826"></a><a href="Graphic.md#ga449c17a9fa3898aac9ac68a2c48363a3">OHOS::GridLayout::LayoutChildren</a> (bool needInvalidate=false) override</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2139656637084826"><a name="p2139656637084826"></a><a name="p2139656637084826"></a>virtual void&nbsp;</p>
<p id="p1705419582084826"><a name="p1705419582084826"></a><a name="p1705419582084826"></a>Lays out all child views according to the preset arrangement mode. </p>
</td>
</tr>
<tr id="row689820430084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p800600440084826"><a name="p800600440084826"></a><a name="p800600440084826"></a><a href="Graphic.md#gaba1ca0f86a85d3c5636ca543b0ed08d8">OHOS::Layout::Layout</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p692920596084826"><a name="p692920596084826"></a><a name="p692920596084826"></a>&nbsp;</p>
<p id="p1739813285084826"><a name="p1739813285084826"></a><a name="p1739813285084826"></a>A default constructor used to create a <strong id="b1586355377084826"><a name="b1586355377084826"></a><a name="b1586355377084826"></a><a href="OHOS-Layout.md">Layout</a></strong> instance. </p>
</td>
</tr>
<tr id="row1815086968084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p56369308084826"><a name="p56369308084826"></a><a name="p56369308084826"></a><a href="Graphic.md#ga6c7cc7a849197fe014ea57d0534728bf">OHOS::Layout::~Layout</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1633178732084826"><a name="p1633178732084826"></a><a name="p1633178732084826"></a>virtual&nbsp;</p>
<p id="p1463727359084826"><a name="p1463727359084826"></a><a name="p1463727359084826"></a>A destructor used to delete the <strong id="b2003576820084826"><a name="b2003576820084826"></a><a name="b2003576820084826"></a><a href="OHOS-Layout.md">Layout</a></strong> instance. </p>
</td>
</tr>
<tr id="row300481034084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1834235852084826"><a name="p1834235852084826"></a><a name="p1834235852084826"></a><a href="Graphic.md#gada9223ec4d664c00a9640c8b9cbcacc3">OHOS::Layout::SetLayoutDirection</a> (const <a href="Codec.md#ga8ef30fa9c08e08c8706653571f9f5b81">DirectionType</a> &amp;direction)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p449382800084826"><a name="p449382800084826"></a><a name="p449382800084826"></a>void&nbsp;</p>
<p id="p1155005153084826"><a name="p1155005153084826"></a><a name="p1155005153084826"></a>Sets the layout direction. </p>
</td>
</tr>
<tr id="row1931044540084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1292709899084826"><a name="p1292709899084826"></a><a name="p1292709899084826"></a><a href="Graphic.md#ga92532583f91e7cb84255ddbacc34b3e6">OHOS::List&lt; T &gt;::List</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1488877835084826"><a name="p1488877835084826"></a><a name="p1488877835084826"></a>&nbsp;</p>
<p id="p266185466084826"><a name="p266185466084826"></a><a name="p266185466084826"></a>A default constructor used to create a <strong id="b1538508649084826"><a name="b1538508649084826"></a><a name="b1538508649084826"></a><a href="OHOS-List-T.md">List</a></strong> instance. The initial size is <strong id="b1958625998084826"><a name="b1958625998084826"></a><a name="b1958625998084826"></a>0</strong>. </p>
</td>
</tr>
<tr id="row2053146785084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p414977446084826"><a name="p414977446084826"></a><a name="p414977446084826"></a><a href="Graphic.md#gae36a1bb98e3352c2b97423ca340a51a9">OHOS::List&lt; T &gt;::~List</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1323871822084826"><a name="p1323871822084826"></a><a name="p1323871822084826"></a>virtual&nbsp;</p>
<p id="p2015576378084826"><a name="p2015576378084826"></a><a name="p2015576378084826"></a>A destructor used to delete the <strong id="b2040758016084826"><a name="b2040758016084826"></a><a name="b2040758016084826"></a><a href="OHOS-List-T.md">List</a></strong> instance. </p>
</td>
</tr>
<tr id="row1009754273084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p465742073084826"><a name="p465742073084826"></a><a name="p465742073084826"></a><a href="Graphic.md#ga5e52d77c60c7710ca70ba3720b260c6a">OHOS::List&lt; T &gt;::Front</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p243977896084826"><a name="p243977896084826"></a><a name="p243977896084826"></a>const T&nbsp;</p>
<p id="p711395470084826"><a name="p711395470084826"></a><a name="p711395470084826"></a>Obtains the head node data of a linked list. </p>
</td>
</tr>
<tr id="row1155877944084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1940735381084826"><a name="p1940735381084826"></a><a name="p1940735381084826"></a><a href="Graphic.md#gae5c3f6272b58c45f458c475a79ebfe3d">OHOS::List&lt; T &gt;::Back</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1960379863084826"><a name="p1960379863084826"></a><a name="p1960379863084826"></a>const T&nbsp;</p>
<p id="p615116486084826"><a name="p615116486084826"></a><a name="p615116486084826"></a>Obtains the tail node data of a linked list. </p>
</td>
</tr>
<tr id="row1391279642084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1659427144084826"><a name="p1659427144084826"></a><a name="p1659427144084826"></a><a href="Graphic.md#gad26996a2802e32e89ecefa8311fe5d27">OHOS::List&lt; T &gt;::PushBack</a> (T data)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p708663683084826"><a name="p708663683084826"></a><a name="p708663683084826"></a>void&nbsp;</p>
<p id="p2015563825084826"><a name="p2015563825084826"></a><a name="p2015563825084826"></a>Inserts data at the end of a linked list. </p>
</td>
</tr>
<tr id="row530394224084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1167620461084826"><a name="p1167620461084826"></a><a name="p1167620461084826"></a><a href="Graphic.md#ga5084ab98dce9aab41b216f73a04ed8b6">OHOS::List&lt; T &gt;::PushFront</a> (T data)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p951587578084826"><a name="p951587578084826"></a><a name="p951587578084826"></a>void&nbsp;</p>
<p id="p1989502439084826"><a name="p1989502439084826"></a><a name="p1989502439084826"></a>Inserts data at the start of a linked list. </p>
</td>
</tr>
<tr id="row354717325084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p337058489084826"><a name="p337058489084826"></a><a name="p337058489084826"></a><a href="Graphic.md#ga667b81954fd60474b575b4aa9c6bc193">OHOS::List&lt; T &gt;::PopBack</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1775589388084826"><a name="p1775589388084826"></a><a name="p1775589388084826"></a>void&nbsp;</p>
<p id="p874313194084826"><a name="p874313194084826"></a><a name="p874313194084826"></a>Pops up a data record at the end of a linked list. </p>
</td>
</tr>
<tr id="row809984449084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p622230288084826"><a name="p622230288084826"></a><a name="p622230288084826"></a><a href="Graphic.md#ga0fa953b7476412923f25d079431f7189">OHOS::List&lt; T &gt;::PopFront</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p423366541084826"><a name="p423366541084826"></a><a name="p423366541084826"></a>void&nbsp;</p>
<p id="p1782144984084826"><a name="p1782144984084826"></a><a name="p1782144984084826"></a>Pops up a data record at the start of a linked list. </p>
</td>
</tr>
<tr id="row986424951084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p891765946084826"><a name="p891765946084826"></a><a name="p891765946084826"></a><a href="Graphic.md#ga3bdd5d105c9e7d7e18456dfb55ba8b45">OHOS::List&lt; T &gt;::Insert</a> (<a href="OHOS-ListNode-T.md">ListNode</a>&lt; T &gt; *node, T data)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1149682722084826"><a name="p1149682722084826"></a><a name="p1149682722084826"></a>void&nbsp;</p>
<p id="p2104813283084826"><a name="p2104813283084826"></a><a name="p2104813283084826"></a>Inserts data before a specified node, which follows the inserted data node. </p>
</td>
</tr>
<tr id="row1126465677084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p771274552084826"><a name="p771274552084826"></a><a name="p771274552084826"></a><a href="Graphic.md#gaf3806e9581846930ad5bf063ced38367">OHOS::List&lt; T &gt;::Remove</a> (<a href="OHOS-ListNode-T.md">ListNode</a>&lt; T &gt; *node)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p273718257084826"><a name="p273718257084826"></a><a name="p273718257084826"></a>void&nbsp;</p>
<p id="p1504502242084826"><a name="p1504502242084826"></a><a name="p1504502242084826"></a>Deletes a data node. </p>
</td>
</tr>
<tr id="row572126201084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p953253029084826"><a name="p953253029084826"></a><a name="p953253029084826"></a><a href="Graphic.md#ga2292866786c9f888bc722ffcebc7c831">OHOS::List&lt; T &gt;::Clear</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p959328932084826"><a name="p959328932084826"></a><a name="p959328932084826"></a>void&nbsp;</p>
<p id="p94277224084826"><a name="p94277224084826"></a><a name="p94277224084826"></a>Deletes all nodes from a linked list. </p>
</td>
</tr>
<tr id="row187729974084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1061789740084826"><a name="p1061789740084826"></a><a name="p1061789740084826"></a><a href="Graphic.md#ga74dcfe1a4b37d6fabbcdb5f8049fb578">OHOS::List&lt; T &gt;::Head</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p599681990084826"><a name="p599681990084826"></a><a name="p599681990084826"></a><a href="OHOS-ListNode-T.md">ListNode</a>&lt; T &gt; *&nbsp;</p>
<p id="p409189796084826"><a name="p409189796084826"></a><a name="p409189796084826"></a>Obtains the head node address of a linked list. </p>
</td>
</tr>
<tr id="row714217448084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p987886726084826"><a name="p987886726084826"></a><a name="p987886726084826"></a><a href="Graphic.md#gab60fda7a08504db2cf992de435ad1848">OHOS::List&lt; T &gt;::Tail</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1322470234084826"><a name="p1322470234084826"></a><a name="p1322470234084826"></a><a href="OHOS-ListNode-T.md">ListNode</a>&lt; T &gt; *&nbsp;</p>
<p id="p719219771084826"><a name="p719219771084826"></a><a name="p719219771084826"></a>Obtains the tail node address of a linked list. </p>
</td>
</tr>
<tr id="row231033996084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p349325802084826"><a name="p349325802084826"></a><a name="p349325802084826"></a><a href="Graphic.md#ga8fe8647f764773c29d3fa70c9b70eb2a">OHOS::List&lt; T &gt;::Begin</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p879183048084826"><a name="p879183048084826"></a><a name="p879183048084826"></a><a href="OHOS-ListNode-T.md">ListNode</a>&lt; T &gt; *&nbsp;</p>
<p id="p198000412084826"><a name="p198000412084826"></a><a name="p198000412084826"></a>Obtains the head node address of a linked list. </p>
</td>
</tr>
<tr id="row1834494204084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p272954877084826"><a name="p272954877084826"></a><a name="p272954877084826"></a><a href="Graphic.md#ga839de65540644c9725b31959367355c5">OHOS::List&lt; T &gt;::End</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1245774531084826"><a name="p1245774531084826"></a><a name="p1245774531084826"></a>const <a href="OHOS-ListNode-T.md">ListNode</a>&lt; T &gt; *&nbsp;</p>
<p id="p653927549084826"><a name="p653927549084826"></a><a name="p653927549084826"></a>Obtains the end node address of a linked list. </p>
</td>
</tr>
<tr id="row2117239670084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p259546346084826"><a name="p259546346084826"></a><a name="p259546346084826"></a><a href="Graphic.md#ga93ec1e9e9b778751aa53b7afb0b67258">OHOS::List&lt; T &gt;::Next</a> (const <a href="OHOS-ListNode-T.md">ListNode</a>&lt; T &gt; *node) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1621180091084826"><a name="p1621180091084826"></a><a name="p1621180091084826"></a><a href="OHOS-ListNode-T.md">ListNode</a>&lt; T &gt; *&nbsp;</p>
<p id="p910294848084826"><a name="p910294848084826"></a><a name="p910294848084826"></a>Obtains the address of the node following the specified <strong id="b107422123084826"><a name="b107422123084826"></a><a name="b107422123084826"></a>node</strong>. </p>
</td>
</tr>
<tr id="row1324992850084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1140629389084826"><a name="p1140629389084826"></a><a name="p1140629389084826"></a><a href="Graphic.md#ga48f81f9faa9f4057ae8f84e437d90442">OHOS::List&lt; T &gt;::IsEmpty</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p960404207084826"><a name="p960404207084826"></a><a name="p960404207084826"></a>bool&nbsp;</p>
<p id="p1441647873084826"><a name="p1441647873084826"></a><a name="p1441647873084826"></a>Checks whether a linked list is empty. </p>
</td>
</tr>
<tr id="row340508994084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1144469097084826"><a name="p1144469097084826"></a><a name="p1144469097084826"></a><a href="Graphic.md#gae209f40639cdee7a5b07dc6587dac170">OHOS::List&lt; T &gt;::Size</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1530137084826"><a name="p1530137084826"></a><a name="p1530137084826"></a>uint16_t&nbsp;</p>
<p id="p1373097334084826"><a name="p1373097334084826"></a><a name="p1373097334084826"></a>Obtains the size of a linked list. </p>
</td>
</tr>
<tr id="row1101874254084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2083021835084826"><a name="p2083021835084826"></a><a name="p2083021835084826"></a><a href="Graphic.md#gaabb0ea584d8faebbdcb45fcc11447b8b">OHOS::ImageCacheMalloc</a> (<a href="OHOS-ImageInfo.md">ImageInfo</a> &amp;info)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1034038530084826"><a name="p1034038530084826"></a><a name="p1034038530084826"></a>void *&nbsp;</p>
<p id="p883553289084826"><a name="p883553289084826"></a><a name="p883553289084826"></a>Applies for the image cache memory. You can customize the memory area when loading image resources. </p>
</td>
</tr>
<tr id="row779845743084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p869128547084826"><a name="p869128547084826"></a><a name="p869128547084826"></a><a href="Graphic.md#ga71fe0f3eb82083006b51fec59ad11088">OHOS::ImageCacheFree</a> (<a href="OHOS-ImageInfo.md">ImageInfo</a> &amp;info)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1143142530084826"><a name="p1143142530084826"></a><a name="p1143142530084826"></a>void&nbsp;</p>
<p id="p1872476336084826"><a name="p1872476336084826"></a><a name="p1872476336084826"></a>Releases the image cache memory. </p>
</td>
</tr>
<tr id="row548285605084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1029750846084826"><a name="p1029750846084826"></a><a name="p1029750846084826"></a><a href="Graphic.md#gafc7b2c7d0b427079d8b04b11cc4db009">OHOS::UIMalloc</a> (uint32_t size)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p595834186084826"><a name="p595834186084826"></a><a name="p595834186084826"></a>void *&nbsp;</p>
<p id="p685518453084826"><a name="p685518453084826"></a><a name="p685518453084826"></a>Applies for memory for the graphics module. You can implement this function to override the <strong id="b1205837901084826"><a name="b1205837901084826"></a><a name="b1205837901084826"></a>malloc</strong> and <strong id="b1586527408084826"><a name="b1586527408084826"></a><a name="b1586527408084826"></a>new</strong> functions. </p>
</td>
</tr>
<tr id="row470504854084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p505183698084826"><a name="p505183698084826"></a><a name="p505183698084826"></a><a href="Graphic.md#ga77914ea7bc96f6cb30f65ae2014746e8">OHOS::UIFree</a> (void *buffer)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p225794786084826"><a name="p225794786084826"></a><a name="p225794786084826"></a>void&nbsp;</p>
<p id="p1625668936084826"><a name="p1625668936084826"></a><a name="p1625668936084826"></a>Releases memory for the graphics module. You can implement this function to override the <strong id="b1164215690084826"><a name="b1164215690084826"></a><a name="b1164215690084826"></a>free</strong> and <strong id="b570639567084826"><a name="b570639567084826"></a><a name="b570639567084826"></a>delete</strong> functions. </p>
</td>
</tr>
<tr id="row421627065084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p879592388084826"><a name="p879592388084826"></a><a name="p879592388084826"></a><a href="Graphic.md#ga7d3779a5cf121ba98026ddbf36705178">OHOS::Rect::Rect</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1557261374084826"><a name="p1557261374084826"></a><a name="p1557261374084826"></a>&nbsp;</p>
<p id="p1283045010084826"><a name="p1283045010084826"></a><a name="p1283045010084826"></a>A constructor used to create a <strong id="b1774106880084826"><a name="b1774106880084826"></a><a name="b1774106880084826"></a><a href="OHOS-Rect.md">Rect</a></strong> instance. </p>
</td>
</tr>
<tr id="row1571898068084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p995363138084826"><a name="p995363138084826"></a><a name="p995363138084826"></a><a href="Graphic.md#ga3729aa7a7f052d182bd20707097f9db9">OHOS::Rect::~Rect</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p454008702084826"><a name="p454008702084826"></a><a name="p454008702084826"></a>&nbsp;</p>
<p id="p1232136368084826"><a name="p1232136368084826"></a><a name="p1232136368084826"></a>A destructor used to delete the <strong id="b2119490084084826"><a name="b2119490084084826"></a><a name="b2119490084084826"></a><a href="OHOS-Rect.md">Rect</a></strong> instance. </p>
</td>
</tr>
<tr id="row525250874084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p191207316084826"><a name="p191207316084826"></a><a name="p191207316084826"></a><a href="Graphic.md#gab37a12fb10478edcb5389fa0b347c46f">OHOS::Rect::Rect</a> (int16_t left, int16_t top, int16_t right, int16_t bottom)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1973602599084826"><a name="p1973602599084826"></a><a name="p1973602599084826"></a>&nbsp;</p>
<p id="p491520755084826"><a name="p491520755084826"></a><a name="p491520755084826"></a>A constructor used to create a <strong id="b1835929059084826"><a name="b1835929059084826"></a><a name="b1835929059084826"></a><a href="OHOS-Rect.md">Rect</a></strong> instance based on the coordinates of the four boundaries. </p>
</td>
</tr>
<tr id="row1915362010084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p971044239084826"><a name="p971044239084826"></a><a name="p971044239084826"></a><a href="Graphic.md#ga766eee89dbd7d4969fb88485893ea662">OHOS::Rect::Rect</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;other)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1144089553084826"><a name="p1144089553084826"></a><a name="p1144089553084826"></a>&nbsp;</p>
<p id="p1921638227084826"><a name="p1921638227084826"></a><a name="p1921638227084826"></a>A constructor used to create a <strong id="b155235017084826"><a name="b155235017084826"></a><a name="b155235017084826"></a><a href="OHOS-Rect.md">Rect</a></strong> instance by copying another rectangle. </p>
</td>
</tr>
<tr id="row2113496102084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p953776126084826"><a name="p953776126084826"></a><a name="p953776126084826"></a><a href="Graphic.md#gabcc74bf916f06152b4a69e1a36116e3f">OHOS::Rect::Rect</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;&amp;other)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1707057061084826"><a name="p1707057061084826"></a><a name="p1707057061084826"></a>&nbsp;</p>
<p id="p544722544084826"><a name="p544722544084826"></a><a name="p544722544084826"></a>A constructor used to create a <strong id="b1637267720084826"><a name="b1637267720084826"></a><a name="b1637267720084826"></a><a href="OHOS-Rect.md">Rect</a></strong> instance by copying another rectangle. </p>
</td>
</tr>
<tr id="row394898759084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1531008320084826"><a name="p1531008320084826"></a><a name="p1531008320084826"></a><a href="Graphic.md#ga4423fe83ed9271d1186711dff65796cb">OHOS::Rect::SetRect</a> (int16_t left, int16_t top, int16_t right, int16_t bottom)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1458426481084826"><a name="p1458426481084826"></a><a name="p1458426481084826"></a>void&nbsp;</p>
<p id="p157410773084826"><a name="p157410773084826"></a><a name="p157410773084826"></a>Sets the coordinates of the four boundaries of a rectangle. </p>
</td>
</tr>
<tr id="row79497020084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1440750915084826"><a name="p1440750915084826"></a><a name="p1440750915084826"></a><a href="Graphic.md#ga2f8315ea6e574aec99210950feef1b55">OHOS::Rect::GetWidth</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1932373060084826"><a name="p1932373060084826"></a><a name="p1932373060084826"></a>int16_t&nbsp;</p>
<p id="p319094493084826"><a name="p319094493084826"></a><a name="p319094493084826"></a>Obtains the rectangle width. </p>
</td>
</tr>
<tr id="row235254302084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1600396113084826"><a name="p1600396113084826"></a><a name="p1600396113084826"></a><a href="Graphic.md#ga9a1b7ee8eee0d5fa96739fd0a0bac638">OHOS::Rect::GetHeight</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1257476149084826"><a name="p1257476149084826"></a><a name="p1257476149084826"></a>int16_t&nbsp;</p>
<p id="p2071943598084826"><a name="p2071943598084826"></a><a name="p2071943598084826"></a>Obtains the rectangle height. </p>
</td>
</tr>
<tr id="row2031667447084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p397645058084826"><a name="p397645058084826"></a><a name="p397645058084826"></a><a href="Graphic.md#gad0410528e93dcf552129e207dfe37aba">OHOS::Rect::GetX</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1163910435084826"><a name="p1163910435084826"></a><a name="p1163910435084826"></a>int16_t&nbsp;</p>
<p id="p1900754768084826"><a name="p1900754768084826"></a><a name="p1900754768084826"></a>Obtains the left boundary coordinate of the rectangle. </p>
</td>
</tr>
<tr id="row1955962104084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p691440351084826"><a name="p691440351084826"></a><a name="p691440351084826"></a><a href="Graphic.md#gaa3b94d5228cabba6341039e8f28fda74">OHOS::Rect::GetY</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p872414892084826"><a name="p872414892084826"></a><a name="p872414892084826"></a>int16_t&nbsp;</p>
<p id="p1263663257084826"><a name="p1263663257084826"></a><a name="p1263663257084826"></a>Obtains the top boundary coordinate of the rectangle. </p>
</td>
</tr>
<tr id="row723307654084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1896610055084826"><a name="p1896610055084826"></a><a name="p1896610055084826"></a><a href="Graphic.md#ga2f4bd954929225e2f124db4c9d2c62ec">OHOS::Rect::GetLeft</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p895092283084826"><a name="p895092283084826"></a><a name="p895092283084826"></a>int16_t&nbsp;</p>
<p id="p1031111376084826"><a name="p1031111376084826"></a><a name="p1031111376084826"></a>Obtains the left boundary coordinate of the rectangle. </p>
</td>
</tr>
<tr id="row35492243084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p910419021084826"><a name="p910419021084826"></a><a name="p910419021084826"></a><a href="Graphic.md#ga9ab9c7eda50b517e55d608270360f0a0">OHOS::Rect::GetTop</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p970412280084826"><a name="p970412280084826"></a><a name="p970412280084826"></a>int16_t&nbsp;</p>
<p id="p492379154084826"><a name="p492379154084826"></a><a name="p492379154084826"></a>Obtains the top boundary coordinate of the rectangle. </p>
</td>
</tr>
<tr id="row1530658574084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1473767134084826"><a name="p1473767134084826"></a><a name="p1473767134084826"></a><a href="Graphic.md#gab7695173ebb2f4b8e9aa58947786a379">OHOS::Rect::GetRight</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p512540415084826"><a name="p512540415084826"></a><a name="p512540415084826"></a>int16_t&nbsp;</p>
<p id="p1012676215084826"><a name="p1012676215084826"></a><a name="p1012676215084826"></a>Obtains the right boundary coordinate of the rectangle. </p>
</td>
</tr>
<tr id="row484541442084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p964308282084826"><a name="p964308282084826"></a><a name="p964308282084826"></a><a href="Graphic.md#ga6c2f9cf035a36c605e20ccc76de8fbea">OHOS::Rect::GetBottom</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p19447706084826"><a name="p19447706084826"></a><a name="p19447706084826"></a>int16_t&nbsp;</p>
<p id="p1091918459084826"><a name="p1091918459084826"></a><a name="p1091918459084826"></a>Obtains the bottom boundary coordinate of the rectangle. </p>
</td>
</tr>
<tr id="row1692826835084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1348480138084826"><a name="p1348480138084826"></a><a name="p1348480138084826"></a><a href="Graphic.md#ga6d14ede131d4a9445e0890632d2e4370">OHOS::Rect::SetX</a> (int16_t x)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p473605782084826"><a name="p473605782084826"></a><a name="p473605782084826"></a>void&nbsp;</p>
<p id="p1617160049084826"><a name="p1617160049084826"></a><a name="p1617160049084826"></a>Changes the left boundary coordinate of the rectangle without changing the rectangle width. </p>
</td>
</tr>
<tr id="row1263010772084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2107475409084826"><a name="p2107475409084826"></a><a name="p2107475409084826"></a><a href="Graphic.md#ga260393d7b4c514eebc2a28187ec6f8b4">OHOS::Rect::SetY</a> (int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1257535056084826"><a name="p1257535056084826"></a><a name="p1257535056084826"></a>void&nbsp;</p>
<p id="p1467715016084826"><a name="p1467715016084826"></a><a name="p1467715016084826"></a>Changes the top boundary coordinate of the rectangle without changing the rectangle height. </p>
</td>
</tr>
<tr id="row1124573131084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2104768036084826"><a name="p2104768036084826"></a><a name="p2104768036084826"></a><a href="Graphic.md#ga723d2b5ace818a6b71e0570339689690">OHOS::Rect::SetPosition</a> (int16_t x, int16_t y)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p858185803084826"><a name="p858185803084826"></a><a name="p858185803084826"></a>void&nbsp;</p>
<p id="p1974126412084826"><a name="p1974126412084826"></a><a name="p1974126412084826"></a>Changes the coordinates of the left and top boundaries of the rectangle without changing the rectangle width and height. </p>
</td>
</tr>
<tr id="row1281445561084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1793833320084826"><a name="p1793833320084826"></a><a name="p1793833320084826"></a><a href="Graphic.md#ga8a31c03ecb4a452d79374b392537f183">OHOS::Rect::SetWidth</a> (int16_t width)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1259835645084826"><a name="p1259835645084826"></a><a name="p1259835645084826"></a>void&nbsp;</p>
<p id="p122596175084826"><a name="p122596175084826"></a><a name="p122596175084826"></a>Changes the width of the rectangle without changing the coordinate of the left boundary. </p>
</td>
</tr>
<tr id="row2096413230084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1037413801084826"><a name="p1037413801084826"></a><a name="p1037413801084826"></a><a href="Graphic.md#ga8e3fab1e0d6cd4671c6628b94c493d0f">OHOS::Rect::SetHeight</a> (int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1412062862084826"><a name="p1412062862084826"></a><a name="p1412062862084826"></a>void&nbsp;</p>
<p id="p1309234371084826"><a name="p1309234371084826"></a><a name="p1309234371084826"></a>Changes the height of the rectangle without changing the coordinate of the top boundary. </p>
</td>
</tr>
<tr id="row1536952098084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2069285838084826"><a name="p2069285838084826"></a><a name="p2069285838084826"></a><a href="Graphic.md#ga043a1c4f0aaf4eed2ddf99083ed993bb">OHOS::Rect::SetLeft</a> (int16_t left)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p707786799084826"><a name="p707786799084826"></a><a name="p707786799084826"></a>void&nbsp;</p>
<p id="p207550433084826"><a name="p207550433084826"></a><a name="p207550433084826"></a>Sets the coordinate of the left boundary of a rectangle. </p>
</td>
</tr>
<tr id="row451740550084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1826553066084826"><a name="p1826553066084826"></a><a name="p1826553066084826"></a><a href="Graphic.md#gae7c63105b7e1871f231a1a8dfad48de7">OHOS::Rect::SetTop</a> (int16_t top)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1253589702084826"><a name="p1253589702084826"></a><a name="p1253589702084826"></a>void&nbsp;</p>
<p id="p1545373058084826"><a name="p1545373058084826"></a><a name="p1545373058084826"></a>Sets the coordinate of the top boundary of a rectangle. </p>
</td>
</tr>
<tr id="row572409733084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1368578267084826"><a name="p1368578267084826"></a><a name="p1368578267084826"></a><a href="Graphic.md#ga314f4443ef95351a80e6edaaeff11674">OHOS::Rect::SetRight</a> (int16_t right)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p276405397084826"><a name="p276405397084826"></a><a name="p276405397084826"></a>void&nbsp;</p>
<p id="p370709367084826"><a name="p370709367084826"></a><a name="p370709367084826"></a>Sets the coordinate of the right boundary of a rectangle. </p>
</td>
</tr>
<tr id="row1366132086084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1583979793084826"><a name="p1583979793084826"></a><a name="p1583979793084826"></a><a href="Graphic.md#ga764001fa9f51716fd3dacac691cbca6d">OHOS::Rect::SetBottom</a> (int16_t bottom)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1904096864084826"><a name="p1904096864084826"></a><a name="p1904096864084826"></a>void&nbsp;</p>
<p id="p589632764084826"><a name="p589632764084826"></a><a name="p589632764084826"></a>Sets the coordinate of the bottom boundary of a rectangle. </p>
</td>
</tr>
<tr id="row956223470084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1640610651084826"><a name="p1640610651084826"></a><a name="p1640610651084826"></a><a href="Graphic.md#ga6d51096b1d1b1929d8ee6a0d25c153d8">OHOS::Rect::Resize</a> (int16_t width, int16_t height)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p947843206084826"><a name="p947843206084826"></a><a name="p947843206084826"></a>void&nbsp;</p>
<p id="p848708536084826"><a name="p848708536084826"></a><a name="p848708536084826"></a>Sets the width and height of a rectangle. </p>
</td>
</tr>
<tr id="row1642996374084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p510298387084826"><a name="p510298387084826"></a><a name="p510298387084826"></a><a href="Graphic.md#ga37f61dc21e0acc2ae877687f06d11e50">OHOS::Rect::GetSize</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p932536300084826"><a name="p932536300084826"></a><a name="p932536300084826"></a>uint32_t&nbsp;</p>
<p id="p60539922084826"><a name="p60539922084826"></a><a name="p60539922084826"></a>Obtains the area of a rectangle. </p>
</td>
</tr>
<tr id="row1974374788084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p162110289084826"><a name="p162110289084826"></a><a name="p162110289084826"></a><a href="Graphic.md#ga1af82c2a558d4003d5d3b19302325a73">OHOS::Rect::Intersect</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;rect1, const <a href="OHOS-Rect.md">Rect</a> &amp;rect2)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1173262087084826"><a name="p1173262087084826"></a><a name="p1173262087084826"></a>bool&nbsp;</p>
<p id="p956891129084826"><a name="p956891129084826"></a><a name="p956891129084826"></a>Checks whether two rectangles intersect. </p>
</td>
</tr>
<tr id="row41063349084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p997064732084826"><a name="p997064732084826"></a><a name="p997064732084826"></a><a href="Graphic.md#ga6269289055eab8876cc3b3c946ddd4a4">OHOS::Rect::Join</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;rect1, const <a href="OHOS-Rect.md">Rect</a> &amp;rect2)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p282603375084826"><a name="p282603375084826"></a><a name="p282603375084826"></a>void&nbsp;</p>
<p id="p1526920949084826"><a name="p1526920949084826"></a><a name="p1526920949084826"></a>Obtains the minimum rectangle that contains another two rectangles. </p>
</td>
</tr>
<tr id="row529694515084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p785103754084826"><a name="p785103754084826"></a><a name="p785103754084826"></a><a href="Graphic.md#ga1a810eb98134027556294620821c2548">OHOS::Rect::IsContains</a> (const <a href="OHOS-Vector2-T.md">Vector2</a>&lt; int16_t &gt; &amp;point) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2128184056084826"><a name="p2128184056084826"></a><a name="p2128184056084826"></a>bool&nbsp;</p>
<p id="p1531308130084826"><a name="p1531308130084826"></a><a name="p1531308130084826"></a>Checks whether the rectangle contains a coordinate point. </p>
</td>
</tr>
<tr id="row862818081084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2103328079084826"><a name="p2103328079084826"></a><a name="p2103328079084826"></a><a href="Graphic.md#ga5f3cb137429e00b2e7fe1e39f7e9faad">OHOS::Rect::IsContains</a> (const <a href="OHOS-Point.md">Point</a> &amp;point) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1729573221084826"><a name="p1729573221084826"></a><a name="p1729573221084826"></a>bool&nbsp;</p>
<p id="p223875104084826"><a name="p223875104084826"></a><a name="p223875104084826"></a>Checks whether the rectangle contains a coordinate point. </p>
</td>
</tr>
<tr id="row561379202084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p96676600084826"><a name="p96676600084826"></a><a name="p96676600084826"></a><a href="Graphic.md#ga808a2b486872f5d1dc1f3e944352bcfb">OHOS::Rect::IsExtends</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;other) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p174309703084826"><a name="p174309703084826"></a><a name="p174309703084826"></a>bool&nbsp;</p>
<p id="p805272181084826"><a name="p805272181084826"></a><a name="p805272181084826"></a>Checks whether the rectangle is adjacent to another rectangle horizontally or vertically. </p>
</td>
</tr>
<tr id="row1360264227084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p990596202084826"><a name="p990596202084826"></a><a name="p990596202084826"></a><a href="Graphic.md#gacc346d49f3a8ee42662d34140afcbc9e">OHOS::Rect::IsIntersect</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;other) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1571058156084826"><a name="p1571058156084826"></a><a name="p1571058156084826"></a>bool&nbsp;</p>
<p id="p1651501887084826"><a name="p1651501887084826"></a><a name="p1651501887084826"></a>Checks whether the rectangle intersects with another rectangle. </p>
</td>
</tr>
<tr id="row774316347084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p382694480084826"><a name="p382694480084826"></a><a name="p382694480084826"></a><a href="Graphic.md#ga3e17c74e6eaf3b01b5e009db582da498">OHOS::Rect::IsContains</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;other) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2096040400084826"><a name="p2096040400084826"></a><a name="p2096040400084826"></a>bool&nbsp;</p>
<p id="p247868252084826"><a name="p247868252084826"></a><a name="p247868252084826"></a>Checks whether the rectangle contains another rectangle. </p>
</td>
</tr>
<tr id="row1000422180084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1127868963084826"><a name="p1127868963084826"></a><a name="p1127868963084826"></a><a href="Graphic.md#ga592b31b43819c40563c52fe7b45d9358">OHOS::Style::Style</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p579908624084826"><a name="p579908624084826"></a><a name="p579908624084826"></a>&nbsp;</p>
<p id="p468470870084826"><a name="p468470870084826"></a><a name="p468470870084826"></a>A constructor used to create a <strong id="b632180562084826"><a name="b632180562084826"></a><a name="b632180562084826"></a><a href="OHOS-Style.md">Style</a></strong> instance. </p>
</td>
</tr>
<tr id="row1263048049084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p163970222084826"><a name="p163970222084826"></a><a name="p163970222084826"></a><a href="Graphic.md#ga6356d56766de8fe37d4888ef70f521ec">OHOS::Style::~Style</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p474307232084826"><a name="p474307232084826"></a><a name="p474307232084826"></a>virtual&nbsp;</p>
<p id="p2090611955084826"><a name="p2090611955084826"></a><a name="p2090611955084826"></a>A destructor used to delete the <strong id="b930125832084826"><a name="b930125832084826"></a><a name="b930125832084826"></a><a href="OHOS-Style.md">Style</a></strong> instance. </p>
</td>
</tr>
<tr id="row1218745569084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1631899798084826"><a name="p1631899798084826"></a><a name="p1631899798084826"></a><a href="Graphic.md#ga31941bb1abbb6744ee832d4b0fe6e080">OHOS::Style::SetStyle</a> (uint8_t key, int64_t value)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p606209593084826"><a name="p606209593084826"></a><a name="p606209593084826"></a>void&nbsp;</p>
<p id="p1558413651084826"><a name="p1558413651084826"></a><a name="p1558413651084826"></a>Sets a style. </p>
</td>
</tr>
<tr id="row911595908084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p860608964084826"><a name="p860608964084826"></a><a name="p860608964084826"></a><a href="Graphic.md#ga2b4b818f26822ad6a020473e6a5e5214">OHOS::Style::GetStyle</a> (uint8_t key) const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1151538616084826"><a name="p1151538616084826"></a><a name="p1151538616084826"></a>int64_t&nbsp;</p>
<p id="p1508544552084826"><a name="p1508544552084826"></a><a name="p1508544552084826"></a>Obtains the value of a style. </p>
</td>
</tr>
<tr id="row1463979875084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p447745894084826"><a name="p447745894084826"></a><a name="p447745894084826"></a><a href="Graphic.md#gae5bc682ac7e77c369ccdd32a68de4387">OHOS::StyleDefault::StyleDefault</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1803320224084826"><a name="p1803320224084826"></a><a name="p1803320224084826"></a>&nbsp;</p>
<p id="p1928192239084826"><a name="p1928192239084826"></a><a name="p1928192239084826"></a>A constructor used to create a <strong id="b1666966228084826"><a name="b1666966228084826"></a><a name="b1666966228084826"></a><a href="OHOS-StyleDefault.md">StyleDefault</a></strong> instance. </p>
</td>
</tr>
<tr id="row1932062524084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1430449400084826"><a name="p1430449400084826"></a><a name="p1430449400084826"></a><a href="Graphic.md#ga01ecc90591628698b0d657a60f567b09">OHOS::StyleDefault::~StyleDefault</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1213784872084826"><a name="p1213784872084826"></a><a name="p1213784872084826"></a>&nbsp;</p>
<p id="p2093610707084826"><a name="p2093610707084826"></a><a name="p2093610707084826"></a>A destructor used to delete the <strong id="b2129033749084826"><a name="b2129033749084826"></a><a name="b2129033749084826"></a><a href="OHOS-StyleDefault.md">StyleDefault</a></strong> instance. </p>
</td>
</tr>
<tr id="row1544683669084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p253209190084826"><a name="p253209190084826"></a><a name="p253209190084826"></a><a href="Graphic.md#gae8f75aba900bbc7119228cdc8e97e40b">OHOS::StyleDefault::GetDefaultStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1566729798084826"><a name="p1566729798084826"></a><a name="p1566729798084826"></a>static <a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p167311996084826"><a name="p167311996084826"></a><a name="p167311996084826"></a>Obtains the default style. </p>
</td>
</tr>
<tr id="row771217298084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1064281513084826"><a name="p1064281513084826"></a><a name="p1064281513084826"></a><a href="Graphic.md#ga1463772d745bb998846daad09b11df58">OHOS::StyleDefault::GetBrightStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p408451849084826"><a name="p408451849084826"></a><a name="p408451849084826"></a>static <a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p751815536084826"><a name="p751815536084826"></a><a name="p751815536084826"></a>Obtains the bright style. </p>
</td>
</tr>
<tr id="row588824574084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p338935840084826"><a name="p338935840084826"></a><a name="p338935840084826"></a><a href="Graphic.md#ga1b8645b79268358000db1cc1af2f26b9">OHOS::StyleDefault::GetBrightColorStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p882808996084826"><a name="p882808996084826"></a><a name="p882808996084826"></a>static <a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p1686190906084826"><a name="p1686190906084826"></a><a name="p1686190906084826"></a>Obtains the bright color style. </p>
</td>
</tr>
<tr id="row1571222808084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p436623707084826"><a name="p436623707084826"></a><a name="p436623707084826"></a><a href="Graphic.md#gaa2096a167e0ea9de4450ae516f88ce31">OHOS::StyleDefault::GetButtonPressedStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1528849278084826"><a name="p1528849278084826"></a><a name="p1528849278084826"></a>static <a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p2008237311084826"><a name="p2008237311084826"></a><a name="p2008237311084826"></a>Obtains the button pressed style. </p>
</td>
</tr>
<tr id="row1646824514084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1100112695084826"><a name="p1100112695084826"></a><a name="p1100112695084826"></a><a href="Graphic.md#ga694e90d027391fd114481ea91ad39011">OHOS::StyleDefault::GetButtonReleasedStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p430557171084826"><a name="p430557171084826"></a><a name="p430557171084826"></a>static <a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p854687396084826"><a name="p854687396084826"></a><a name="p854687396084826"></a>Obtains the button released style. </p>
</td>
</tr>
<tr id="row346902542084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p830069648084826"><a name="p830069648084826"></a><a name="p830069648084826"></a><a href="Graphic.md#ga42f393499cc83304a2a1cfa1cacc4003">OHOS::StyleDefault::GetButtonInactivedStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1486354668084826"><a name="p1486354668084826"></a><a name="p1486354668084826"></a>static <a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p498580856084826"><a name="p498580856084826"></a><a name="p498580856084826"></a>Obtains the button inactived style. </p>
</td>
</tr>
<tr id="row1368621211084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1460659068084826"><a name="p1460659068084826"></a><a name="p1460659068084826"></a><a href="Graphic.md#ga3f4f513b6dff5e245f2341890dae5ee1">OHOS::StyleDefault::GetLabelStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p996858226084826"><a name="p996858226084826"></a><a name="p996858226084826"></a>static <a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p267844942084826"><a name="p267844942084826"></a><a name="p267844942084826"></a>Obtains the label style. </p>
</td>
</tr>
<tr id="row813666843084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1930280159084826"><a name="p1930280159084826"></a><a name="p1930280159084826"></a><a href="Graphic.md#ga726fa9b4839e4a37712addd93bc91c9c">OHOS::StyleDefault::GetBackgroundTransparentStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1878677347084826"><a name="p1878677347084826"></a><a name="p1878677347084826"></a>static <a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p1159228862084826"><a name="p1159228862084826"></a><a name="p1159228862084826"></a>Obtains the background transparent style. </p>
</td>
</tr>
<tr id="row1419184136084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1606471361084826"><a name="p1606471361084826"></a><a name="p1606471361084826"></a><a href="Graphic.md#gaa4c13964a439e472d5a41edfa2e5dd4f">OHOS::StyleDefault::GetProgressBackgroundStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1708054368084826"><a name="p1708054368084826"></a><a name="p1708054368084826"></a>static <a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p1539471942084826"><a name="p1539471942084826"></a><a name="p1539471942084826"></a>Obtains the progress background style. </p>
</td>
</tr>
<tr id="row342813834084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1997605563084826"><a name="p1997605563084826"></a><a name="p1997605563084826"></a><a href="Graphic.md#ga6ce583a8cce5527ee812cea6fb6a6113">OHOS::StyleDefault::GetProgressForegroundStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p608621609084826"><a name="p608621609084826"></a><a name="p608621609084826"></a>static <a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p827221100084826"><a name="p827221100084826"></a><a name="p827221100084826"></a>Obtains the progress foreground style. </p>
</td>
</tr>
<tr id="row1458707211084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1519791533084826"><a name="p1519791533084826"></a><a name="p1519791533084826"></a><a href="Graphic.md#ga9102687741cde90b659ebdc3eb773895">OHOS::StyleDefault::GetSliderKnobStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1937152885084826"><a name="p1937152885084826"></a><a name="p1937152885084826"></a>static <a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p945576350084826"><a name="p945576350084826"></a><a name="p945576350084826"></a>Obtains the slider knob style. </p>
</td>
</tr>
<tr id="row1453370104084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p544275124084826"><a name="p544275124084826"></a><a name="p544275124084826"></a><a href="Graphic.md#ga39a41c86eba9feaa5a8130da6e7c8014">OHOS::StyleDefault::GetPickerBackgroundStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1229976014084826"><a name="p1229976014084826"></a><a name="p1229976014084826"></a>static <a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p1893701345084826"><a name="p1893701345084826"></a><a name="p1893701345084826"></a>Obtains the picker background style. </p>
</td>
</tr>
<tr id="row2021722747084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p875495297084826"><a name="p875495297084826"></a><a name="p875495297084826"></a><a href="Graphic.md#gace2f6b055a11b93b1fc632c4e135043d">OHOS::StyleDefault::GetPickerHighlightStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p638572444084826"><a name="p638572444084826"></a><a name="p638572444084826"></a>static <a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p1465953093084826"><a name="p1465953093084826"></a><a name="p1465953093084826"></a>Obtains the picker highlight style. </p>
</td>
</tr>
<tr id="row1626873915084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p468473300084826"><a name="p468473300084826"></a><a name="p468473300084826"></a><a href="Graphic.md#ga3e24fe52ec7c4bf9fc9f5703982b3568">OHOS::SysInfo::OnFPSChangedListener::OnFPSChangedListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1226562576084826"><a name="p1226562576084826"></a><a name="p1226562576084826"></a>&nbsp;</p>
<p id="p1023799801084826"><a name="p1023799801084826"></a><a name="p1023799801084826"></a>A constructor used to create an <strong id="b779945245084826"><a name="b779945245084826"></a><a name="b779945245084826"></a><a href="OHOS-SysInfo-OnFPSChangedListener.md">OnFPSChangedListener</a></strong> instance with the default sampling type <strong id="b1141482584084826"><a name="b1141482584084826"></a><a name="b1141482584084826"></a>FPS_CT_FIXED_TIME</strong>. </p>
</td>
</tr>
<tr id="row1095994053084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1722936703084826"><a name="p1722936703084826"></a><a name="p1722936703084826"></a><a href="Graphic.md#ga4e103243c2fd1e2e5206262280f1b80c">OHOS::SysInfo::OnFPSChangedListener::~OnFPSChangedListener</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1249595058084826"><a name="p1249595058084826"></a><a name="p1249595058084826"></a>virtual&nbsp;</p>
<p id="p1119323920084826"><a name="p1119323920084826"></a><a name="p1119323920084826"></a>A destructor used to delete the <strong id="b423904478084826"><a name="b423904478084826"></a><a name="b423904478084826"></a><a href="OHOS-SysInfo-OnFPSChangedListener.md">OnFPSChangedListener</a></strong> instance. </p>
</td>
</tr>
<tr id="row685598522084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1512968260084826"><a name="p1512968260084826"></a><a name="p1512968260084826"></a><a href="Graphic.md#ga82a8426a18e30ff3e9d4d388c53b4af5">OHOS::SysInfo::OnFPSChangedListener::OnFPSChanged</a> (float newFPS)=0</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1576582393084826"><a name="p1576582393084826"></a><a name="p1576582393084826"></a>virtual void&nbsp;</p>
<p id="p1178887806084826"><a name="p1178887806084826"></a><a name="p1178887806084826"></a>Called when the FPS data changes. </p>
</td>
</tr>
<tr id="row1735706442084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p825874057084826"><a name="p825874057084826"></a><a name="p825874057084826"></a><a href="Graphic.md#gaf7c8d9a4d44cee2001ad0cd40c827c47">OHOS::SysInfo::OnFPSChangedListener::GetFPSCalculateType</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p971394781084826"><a name="p971394781084826"></a><a name="p971394781084826"></a><a href="Graphic.md#ga75d850e3abff6c2f617b689a0cb9a3d1">FPSCalculateType</a>&nbsp;</p>
<p id="p992596707084826"><a name="p992596707084826"></a><a name="p992596707084826"></a>Obtains the FPS sampling type. </p>
</td>
</tr>
<tr id="row1475094045084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p86405704084826"><a name="p86405704084826"></a><a name="p86405704084826"></a><a href="Graphic.md#ga5eb3d62fce38f8d2fcf2a0a4560a3640">OHOS::SysInfo::OnFPSChangedListener::SetFPSCalculateType</a> (<a href="Graphic.md#ga75d850e3abff6c2f617b689a0cb9a3d1">FPSCalculateType</a> type)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2079088629084826"><a name="p2079088629084826"></a><a name="p2079088629084826"></a>void&nbsp;</p>
<p id="p1131849462084826"><a name="p1131849462084826"></a><a name="p1131849462084826"></a>Sets the FPS sampling type. </p>
</td>
</tr>
<tr id="row1244880969084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1249872018084826"><a name="p1249872018084826"></a><a name="p1249872018084826"></a><a href="Graphic.md#gaa028189de9bf2968948578c8e09a9101">OHOS::SysInfo::GetFPS</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1546928562084826"><a name="p1546928562084826"></a><a name="p1546928562084826"></a>static float&nbsp;</p>
<p id="p174611562084826"><a name="p174611562084826"></a><a name="p174611562084826"></a>Obtains the FPS data. </p>
</td>
</tr>
<tr id="row946344258084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p328401296084826"><a name="p328401296084826"></a><a name="p328401296084826"></a><a href="Graphic.md#gac885a43e87f57ae57e0d8b6d213e9fa1">OHOS::SysInfo::RegisterFPSChangedListener</a> (<a href="OHOS-SysInfo-OnFPSChangedListener.md">OnFPSChangedListener</a> *onFPSChangedListener)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p35688362084826"><a name="p35688362084826"></a><a name="p35688362084826"></a>static void&nbsp;</p>
<p id="p1413384085084826"><a name="p1413384085084826"></a><a name="p1413384085084826"></a>Registers the listener for notifying the FPS changes. </p>
</td>
</tr>
<tr id="row54536865084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p90462352084826"><a name="p90462352084826"></a><a name="p90462352084826"></a><a href="Graphic.md#ga375bdd5a61da0f2bc437a531c8958d70">OHOS::Theme::Theme</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p322390738084826"><a name="p322390738084826"></a><a name="p322390738084826"></a>&nbsp;</p>
<p id="p1688000093084826"><a name="p1688000093084826"></a><a name="p1688000093084826"></a>A constructor used to create a <strong id="b1614639393084826"><a name="b1614639393084826"></a><a name="b1614639393084826"></a><a href="OHOS-Theme.md">Theme</a></strong> instance. </p>
</td>
</tr>
<tr id="row1908207240084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p334426988084826"><a name="p334426988084826"></a><a name="p334426988084826"></a><a href="Graphic.md#ga7de1b9b039dd5aee8493f4aad889358f">OHOS::Theme::~Theme</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p799201736084826"><a name="p799201736084826"></a><a name="p799201736084826"></a>virtual&nbsp;</p>
<p id="p1872316132084826"><a name="p1872316132084826"></a><a name="p1872316132084826"></a>A destructor used to delete the <strong id="b959749263084826"><a name="b959749263084826"></a><a name="b959749263084826"></a><a href="OHOS-Theme.md">Theme</a></strong> instance. </p>
</td>
</tr>
<tr id="row1362744914084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p720330938084826"><a name="p720330938084826"></a><a name="p720330938084826"></a><a href="Graphic.md#ga141064843f4b5524b91f3f7c3cb21d11">OHOS::Theme::GetMainStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1581941764084826"><a name="p1581941764084826"></a><a name="p1581941764084826"></a><a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p868384682084826"><a name="p868384682084826"></a><a name="p868384682084826"></a>Obtains the basic style. </p>
</td>
</tr>
<tr id="row1058669023084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p754015812084826"><a name="p754015812084826"></a><a name="p754015812084826"></a><a href="Graphic.md#ga0b1ce70a05042464e32e5bbddbc8f715">OHOS::Theme::GetButtonStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1476911673084826"><a name="p1476911673084826"></a><a name="p1476911673084826"></a><a href="OHOS-ButtonStyle.md">ButtonStyle</a> &amp;&nbsp;</p>
<p id="p1452822171084826"><a name="p1452822171084826"></a><a name="p1452822171084826"></a>Obtains the style of this button. </p>
</td>
</tr>
<tr id="row945562430084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p61248084826"><a name="p61248084826"></a><a name="p61248084826"></a><a href="Graphic.md#ga1d56911596bb1b1480a412ac9c3ff0ed">OHOS::Theme::GetLabelStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p410015348084826"><a name="p410015348084826"></a><a name="p410015348084826"></a><a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p716417102084826"><a name="p716417102084826"></a><a name="p716417102084826"></a>Obtains the style of this label. </p>
</td>
</tr>
<tr id="row2032209345084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p279145408084826"><a name="p279145408084826"></a><a name="p279145408084826"></a><a href="Graphic.md#ga17e000653498ceec378b79a1f25cf490">OHOS::Theme::GetPickerBackgroundStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1165409532084826"><a name="p1165409532084826"></a><a name="p1165409532084826"></a><a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p1244494883084826"><a name="p1244494883084826"></a><a name="p1244494883084826"></a>Obtains the background style of this picker. </p>
</td>
</tr>
<tr id="row875712655084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1454248780084826"><a name="p1454248780084826"></a><a name="p1454248780084826"></a><a href="Graphic.md#ga40c28c8cf0f19f8507b34e8c3af88c6b">OHOS::Theme::GetPickerHighlightStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p579488617084826"><a name="p579488617084826"></a><a name="p579488617084826"></a><a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p182895788084826"><a name="p182895788084826"></a><a name="p182895788084826"></a>Obtains the highlight style of this picker. </p>
</td>
</tr>
<tr id="row1953150421084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p47518440084826"><a name="p47518440084826"></a><a name="p47518440084826"></a><a href="Graphic.md#gafbc7c3ae50f322fbb9c12d06eb50b9bf">OHOS::Theme::GetProgressBackgroundStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p761266537084826"><a name="p761266537084826"></a><a name="p761266537084826"></a><a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p397268327084826"><a name="p397268327084826"></a><a name="p397268327084826"></a>Obtains the background style of this progress bar. </p>
</td>
</tr>
<tr id="row192692043084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p2011834131084826"><a name="p2011834131084826"></a><a name="p2011834131084826"></a><a href="Graphic.md#ga0366f405bc2221944783a96c14f89b8a">OHOS::Theme::GetProgressForegroundStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1105713017084826"><a name="p1105713017084826"></a><a name="p1105713017084826"></a><a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p1878862880084826"><a name="p1878862880084826"></a><a name="p1878862880084826"></a>Obtains the foreground style of this progress bar. </p>
</td>
</tr>
<tr id="row170676043084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1792591884084826"><a name="p1792591884084826"></a><a name="p1792591884084826"></a><a href="Graphic.md#gad528fd10d4b9bcec9d1951c1c54674ee">OHOS::Theme::GetSliderKnobStyle</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p803161726084826"><a name="p803161726084826"></a><a name="p803161726084826"></a><a href="OHOS-Style.md">Style</a> &amp;&nbsp;</p>
<p id="p1818305488084826"><a name="p1818305488084826"></a><a name="p1818305488084826"></a>Obtains the style of this slider knob. </p>
</td>
</tr>
<tr id="row1941665981084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p642689012084826"><a name="p642689012084826"></a><a name="p642689012084826"></a><a href="Graphic.md#gaf98c321c61e63bdfdc1a0eed3735084b">OHOS::ThemeManager::GetInstance</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1779874853084826"><a name="p1779874853084826"></a><a name="p1779874853084826"></a>static <a href="OHOS-ThemeManager.md">ThemeManager</a> &amp;&nbsp;</p>
<p id="p1684394156084826"><a name="p1684394156084826"></a><a name="p1684394156084826"></a>Obtains the singleton instance of the <strong id="b1226623860084826"><a name="b1226623860084826"></a><a name="b1226623860084826"></a><a href="OHOS-ThemeManager.md">ThemeManager</a></strong> class. </p>
</td>
</tr>
<tr id="row2001945079084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1870324465084826"><a name="p1870324465084826"></a><a name="p1870324465084826"></a><a href="Graphic.md#ga6c4963d3186afc52db0d0a18bd52820f">OHOS::ThemeManager::SetCurrent</a> (<a href="OHOS-Theme.md">Theme</a> *theme)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1753150528084826"><a name="p1753150528084826"></a><a name="p1753150528084826"></a>void&nbsp;</p>
<p id="p765096191084826"><a name="p765096191084826"></a><a name="p765096191084826"></a>Sets the current screen theme for this application. </p>
</td>
</tr>
<tr id="row1482403893084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1286941061084826"><a name="p1286941061084826"></a><a name="p1286941061084826"></a><a href="Graphic.md#ga6aeed87ecd925de4262763f20cd940d5">OHOS::ThemeManager::GetCurrent</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p247379408084826"><a name="p247379408084826"></a><a name="p247379408084826"></a><a href="OHOS-Theme.md">Theme</a> *&nbsp;</p>
<p id="p720169977084826"><a name="p720169977084826"></a><a name="p720169977084826"></a>Obtains the current screen theme of this application. </p>
</td>
</tr>
<tr id="row96914728084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p661770899084826"><a name="p661770899084826"></a><a name="p661770899084826"></a><a href="Graphic.md#ga3b20453b0a161da3a1a761fd75da9975">OHOS::TransformMap::TransformMap</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p949730625084826"><a name="p949730625084826"></a><a name="p949730625084826"></a>&nbsp;</p>
<p id="p327094357084826"><a name="p327094357084826"></a><a name="p327094357084826"></a>The default constructor used to create a <strong id="b705920910084826"><a name="b705920910084826"></a><a name="b705920910084826"></a><a href="OHOS-TransformMap.md">TransformMap</a></strong> instance. </p>
</td>
</tr>
<tr id="row190907514084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1386378032084826"><a name="p1386378032084826"></a><a name="p1386378032084826"></a><a href="Graphic.md#ga84f0243719d4b43d0ee3a22e74c165bb">OHOS::TransformMap::TransformMap</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;rect)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1943816541084826"><a name="p1943816541084826"></a><a name="p1943816541084826"></a>&nbsp;</p>
<p id="p1263018336084826"><a name="p1263018336084826"></a><a name="p1263018336084826"></a>A constructor used to create a <strong id="b586571416084826"><a name="b586571416084826"></a><a name="b586571416084826"></a><a href="OHOS-TransformMap.md">TransformMap</a></strong> instance. </p>
</td>
</tr>
<tr id="row185642037084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1243829770084826"><a name="p1243829770084826"></a><a name="p1243829770084826"></a><a href="Graphic.md#gaaa46c8a5a343df76b418423a9f2344ba">OHOS::TransformMap::~TransformMap</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1072333719084826"><a name="p1072333719084826"></a><a name="p1072333719084826"></a>&nbsp;</p>
<p id="p823600753084826"><a name="p823600753084826"></a><a name="p823600753084826"></a>A destructor used to delete the <strong id="b646743975084826"><a name="b646743975084826"></a><a name="b646743975084826"></a><a href="OHOS-TransformMap.md">TransformMap</a></strong> instance. </p>
</td>
</tr>
<tr id="row1019386105084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1357211543084826"><a name="p1357211543084826"></a><a name="p1357211543084826"></a><a href="Graphic.md#ga6a50a29fe85e89c6d4445822c7a2946b">OHOS::TransformMap::GetClockWise</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1878565273084826"><a name="p1878565273084826"></a><a name="p1878565273084826"></a>bool&nbsp;</p>
<p id="p1820585100084826"><a name="p1820585100084826"></a><a name="p1820585100084826"></a>Checks whether the vertex coordinates of a polygon are clockwise. </p>
</td>
</tr>
<tr id="row870755586084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1974388215084826"><a name="p1974388215084826"></a><a name="p1974388215084826"></a><a href="Graphic.md#gaaf0b94adde30d2ee1f3c82ef5d8c60c9">OHOS::TransformMap::SetPolygon</a> (const <a href="OHOS-Polygon.md">Polygon</a> &amp;polygon)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1871723033084826"><a name="p1871723033084826"></a><a name="p1871723033084826"></a>void&nbsp;</p>
<p id="p24979489084826"><a name="p24979489084826"></a><a name="p24979489084826"></a>Sets a polygon after rectangle transformation. </p>
</td>
</tr>
<tr id="row190907699084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p944174752084826"><a name="p944174752084826"></a><a name="p944174752084826"></a><a href="Graphic.md#ga84f8d315da89e7aae7bf29478dbb51df">OHOS::TransformMap::GetPolygon</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p488802083084826"><a name="p488802083084826"></a><a name="p488802083084826"></a><a href="OHOS-Polygon.md">Polygon</a>&nbsp;</p>
<p id="p1350147450084826"><a name="p1350147450084826"></a><a name="p1350147450084826"></a>Obtains the polygon after rectangle transformation. </p>
</td>
</tr>
<tr id="row1348934428084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1301574325084826"><a name="p1301574325084826"></a><a name="p1301574325084826"></a><a href="Graphic.md#ga8a44fb7a813f5f183307191e96e18670">OHOS::TransformMap::GetPivot</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1702323845084826"><a name="p1702323845084826"></a><a name="p1702323845084826"></a><a href="OHOS-Point.md">Point</a>&nbsp;</p>
<p id="p1892707730084826"><a name="p1892707730084826"></a><a name="p1892707730084826"></a>Obtains the pivot for the rotation or scaling operation. </p>
</td>
</tr>
<tr id="row1050668139084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p150249797084826"><a name="p150249797084826"></a><a name="p150249797084826"></a><a href="Graphic.md#ga84ec8032b9c8a4121c7464e6c14c7d01">OHOS::TransformMap::IsInvalid</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p935457936084826"><a name="p935457936084826"></a><a name="p935457936084826"></a>bool&nbsp;</p>
<p id="p965693440084826"><a name="p965693440084826"></a><a name="p965693440084826"></a>Checks whether the <strong id="b1063722632084826"><a name="b1063722632084826"></a><a name="b1063722632084826"></a><a href="OHOS-TransformMap.md">TransformMap</a></strong> instance is invalid. When the vertices are all 0, the <strong id="b727111007084826"><a name="b727111007084826"></a><a name="b727111007084826"></a><a href="OHOS-TransformMap.md">TransformMap</a></strong> is invalid. </p>
</td>
</tr>
<tr id="row730753640084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p130697050084826"><a name="p130697050084826"></a><a name="p130697050084826"></a><a href="Graphic.md#gaa2d8a5d822e40757f98c2a2820efed99">OHOS::TransformMap::GetBoxRect</a> () const</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p553335521084826"><a name="p553335521084826"></a><a name="p553335521084826"></a><a href="OHOS-Rect.md">Rect</a>&nbsp;</p>
<p id="p513920387084826"><a name="p513920387084826"></a><a name="p513920387084826"></a>Obtains the minimum rectangle that can contain a polygon. All vertices of the polygon are inside this rectangle. </p>
</td>
</tr>
<tr id="row1888368638084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p555422080084826"><a name="p555422080084826"></a><a name="p555422080084826"></a><a href="Graphic.md#gaea4c507789bf4c27daef3e81176c656d">OHOS::TransformMap::Rotate</a> (int16_t angle, const <a href="OHOS-Vector2-T.md">Vector2</a>&lt; int16_t &gt; &amp;pivot)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1314015606084826"><a name="p1314015606084826"></a><a name="p1314015606084826"></a>void&nbsp;</p>
<p id="p1742281008084826"><a name="p1742281008084826"></a><a name="p1742281008084826"></a>Rotates the rectangle. </p>
</td>
</tr>
<tr id="row1521058274084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1405190942084826"><a name="p1405190942084826"></a><a name="p1405190942084826"></a><a href="Graphic.md#gae9344b31226a5a35035ccb845bf9cff2">OHOS::TransformMap::Scale</a> (const <a href="OHOS-Vector2-T.md">Vector2</a>&lt; float &gt; scale, const <a href="OHOS-Vector2-T.md">Vector2</a>&lt; int16_t &gt; &amp;pivot)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2010041300084826"><a name="p2010041300084826"></a><a name="p2010041300084826"></a>void&nbsp;</p>
<p id="p588012517084826"><a name="p588012517084826"></a><a name="p588012517084826"></a>Scales the rectangle. </p>
</td>
</tr>
<tr id="row764131941084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1432279236084826"><a name="p1432279236084826"></a><a name="p1432279236084826"></a><a href="Graphic.md#ga9bb4f3256ad01b5abdd347de1fea09ee">OHOS::Rotate</a> (const <a href="OHOS-Vector2-T.md">Vector2</a>&lt; int16_t &gt; &amp;point, int16_t angle, const <a href="OHOS-Vector2-T.md">Vector2</a>&lt; int16_t &gt; &amp;pivot, <a href="OHOS-Vector2-T.md">Vector2</a>&lt; int16_t &gt; &amp;out)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1709554754084826"><a name="p1709554754084826"></a><a name="p1709554754084826"></a>void&nbsp;</p>
<p id="p56557134084826"><a name="p56557134084826"></a><a name="p56557134084826"></a>Rotates a point around the pivot by a certain angle. </p>
</td>
</tr>
<tr id="row736578790084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p381890974084826"><a name="p381890974084826"></a><a name="p381890974084826"></a><a href="Graphic.md#gac57d591450b239f8e375f4c7b287f0d8">OHOS::Rotate</a> (const <a href="OHOS-Line.md">Line</a> &amp;origLine, int16_t angle, const <a href="OHOS-Vector2-T.md">Vector2</a>&lt; int16_t &gt; &amp;pivot, <a href="OHOS-Line.md">Line</a> &amp;out)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p85830504084826"><a name="p85830504084826"></a><a name="p85830504084826"></a>void&nbsp;</p>
<p id="p827549467084826"><a name="p827549467084826"></a><a name="p827549467084826"></a>Rotates a line around the pivot by a certain angle. </p>
</td>
</tr>
<tr id="row1932246580084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p25566439084826"><a name="p25566439084826"></a><a name="p25566439084826"></a><a href="Graphic.md#ga77d0dea6024cd2bb980f27f789db77c3">OHOS::Rotate</a> (const <a href="OHOS-Rect.md">Rect</a> &amp;origRect, int16_t angle, const <a href="OHOS-Vector2-T.md">Vector2</a>&lt; int16_t &gt; &amp;pivot, <a href="OHOS-Polygon.md">Polygon</a> &amp;out)</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2053197780084826"><a name="p2053197780084826"></a><a name="p2053197780084826"></a>void&nbsp;</p>
<p id="p1396405838084826"><a name="p1396405838084826"></a><a name="p1396405838084826"></a>Rotates a rectangle around the pivot by a certain angle. </p>
</td>
</tr>
<tr id="row612272493084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p202494802084826"><a name="p202494802084826"></a><a name="p202494802084826"></a><a href="Graphic.md#ga45704f59419f34aa75868387bf74b160">OHOS::GetVersion</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1480061298084826"><a name="p1480061298084826"></a><a name="p1480061298084826"></a>std::string&nbsp;</p>
<p id="p1225996490084826"><a name="p1225996490084826"></a><a name="p1225996490084826"></a>Obtains the version number of the graphics module. </p>
</td>
</tr>
<tr id="row1390937749084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><p id="p1736918890084826"><a name="p1736918890084826"></a><a name="p1736918890084826"></a><a href="Graphic.md#ga29d7531162c23d230c617280c5c4acf2">OHOS::GetLibDsc</a> ()</p>
</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1567732419084826"><a name="p1567732419084826"></a><a name="p1567732419084826"></a>std::string&nbsp;</p>
<p id="p1663703231084826"><a name="p1663703231084826"></a><a name="p1663703231084826"></a>Obtains the library description of the graphics module. </p>
</td>
</tr>
</tbody>
</table>

## **Details**<a name="section1120609024084826"></a>

## **Macro Definition Documentation**<a name="section496625582084826"></a>

## VERSION\_STANDARD<a name="ga2017774de578acba5afd77793c00205b"></a>

```
#define VERSION_STANDARD
```

 **Description:**

Defines three graphics library versions: lightweight, standard, and extended versions. The three versions have different requirements on the memory and hardware. The standard version is enabled by default.

The macros of the versions are defined as follows: 

## **Typedef Documentation**<a name="section777814820084826"></a>

## EasingFunc<a name="gaf04c41bb7b151a6e8be2012cc9e6475b"></a>

```
typedef int16_t(* OHOS::EasingFunc) (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime)
```

 **Description:**

Calculates the value for the current time of an animation. 

Returns the value for the current time. 

**Parameters:**

<a name="table1647933795084826"></a>
<table><thead align="left"><tr id="row144025355084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1157167745084826"><a name="p1157167745084826"></a><a name="p1157167745084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p77485272084826"><a name="p77485272084826"></a><a name="p77485272084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1612273604084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start value of this animation. </td>
</tr>
<tr id="row1822033902084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end value of this animation. </td>
</tr>
<tr id="row2087553010084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the current time of this animation. </td>
</tr>
<tr id="row1496992144084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">durationTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total duration of this animation.</td>
</tr>
</tbody>
</table>

## **Enumeration Type Documentation**<a name="section2040379265084826"></a>

## anonymous enum<a name="ga7b892afa4e88ab11bf96dbd67653f134"></a>

```
anonymous enum : uint8_t
```

 **Description:**

Enumerates the states of this animator. 

<a name="table1190345755084826"></a>
<table><thead align="left"><tr id="row880131428084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1404544655084826"><a name="p1404544655084826"></a><a name="p1404544655084826"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1925108182084826"><a name="p1925108182084826"></a><a name="p1925108182084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1029251657084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga7b892afa4e88ab11bf96dbd67653f134a6618a5c1c0e9e4be3acba1aaee15cb8d"><a name="gga7b892afa4e88ab11bf96dbd67653f134a6618a5c1c0e9e4be3acba1aaee15cb8d"></a><a name="gga7b892afa4e88ab11bf96dbd67653f134a6618a5c1c0e9e4be3acba1aaee15cb8d"></a></strong>STOP&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1986208287084826"><a name="p1986208287084826"></a><a name="p1986208287084826"></a>Stop </p>
 </td>
</tr>
<tr id="row66931528084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga7b892afa4e88ab11bf96dbd67653f134a49f9e652157f467df5de3be9e8758f91"><a name="gga7b892afa4e88ab11bf96dbd67653f134a49f9e652157f467df5de3be9e8758f91"></a><a name="gga7b892afa4e88ab11bf96dbd67653f134a49f9e652157f467df5de3be9e8758f91"></a></strong>START&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1595181113084826"><a name="p1595181113084826"></a><a name="p1595181113084826"></a>Start </p>
 </td>
</tr>
<tr id="row211494016084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga7b892afa4e88ab11bf96dbd67653f134ae5db6c9a921eec21a2990d73400ff507"><a name="gga7b892afa4e88ab11bf96dbd67653f134ae5db6c9a921eec21a2990d73400ff507"></a><a name="gga7b892afa4e88ab11bf96dbd67653f134ae5db6c9a921eec21a2990d73400ff507"></a></strong>PAUSE&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p485071715084826"><a name="p485071715084826"></a><a name="p485071715084826"></a>Pause </p>
 </td>
</tr>
<tr id="row1482773207084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga7b892afa4e88ab11bf96dbd67653f134a6ef6036766e105b2cd6bf2fb94e92e1b"><a name="gga7b892afa4e88ab11bf96dbd67653f134a6ef6036766e105b2cd6bf2fb94e92e1b"></a><a name="gga7b892afa4e88ab11bf96dbd67653f134a6ef6036766e105b2cd6bf2fb94e92e1b"></a></strong>RUNNING&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p244176059084826"><a name="p244176059084826"></a><a name="p244176059084826"></a>Running (reserved and not used currently) </p>
 </td>
</tr>
</tbody>
</table>

## anonymous enum<a name="ga2933ed17ce67e3e9c997aa2cf6bd04bf"></a>

```
anonymous enum : uint8_t
```

 **Description:**

Enumerates keys of styles. 

<a name="table1224490766084826"></a>
<table><thead align="left"><tr id="row86085337084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p195719605084826"><a name="p195719605084826"></a><a name="p195719605084826"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p395181235084826"><a name="p395181235084826"></a><a name="p395181235084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row912261485084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfa81f161546d7e1853d1c273e3810fe08b"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa81f161546d7e1853d1c273e3810fe08b"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa81f161546d7e1853d1c273e3810fe08b"></a></strong>STYLE_BACKGROUND_COLOR&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p68236014084826"><a name="p68236014084826"></a><a name="p68236014084826"></a>Background color </p>
 </td>
</tr>
<tr id="row802714138084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfa639cb87312225b97bde6e4d2be950b7f"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa639cb87312225b97bde6e4d2be950b7f"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa639cb87312225b97bde6e4d2be950b7f"></a></strong>STYLE_BACKGROUND_OPA&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p978708018084826"><a name="p978708018084826"></a><a name="p978708018084826"></a>Background opacity </p>
 </td>
</tr>
<tr id="row1222414067084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfa4e61810ea3d5f385908eb8a4139027a5"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa4e61810ea3d5f385908eb8a4139027a5"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa4e61810ea3d5f385908eb8a4139027a5"></a></strong>STYLE_BORDER_RADIUS&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1200869607084826"><a name="p1200869607084826"></a><a name="p1200869607084826"></a>Border radius </p>
 </td>
</tr>
<tr id="row1877051143084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfa8fc5a572665a64ad6d27f70480de3b9a"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa8fc5a572665a64ad6d27f70480de3b9a"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa8fc5a572665a64ad6d27f70480de3b9a"></a></strong>STYLE_BORDER_COLOR&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p519129662084826"><a name="p519129662084826"></a><a name="p519129662084826"></a>Border color </p>
 </td>
</tr>
<tr id="row90935916084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfa13df567903c15b369bf612bd97a9b886"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa13df567903c15b369bf612bd97a9b886"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa13df567903c15b369bf612bd97a9b886"></a></strong>STYLE_BORDER_OPA&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1650803312084826"><a name="p1650803312084826"></a><a name="p1650803312084826"></a>Border opacity </p>
 </td>
</tr>
<tr id="row1669652656084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfae9bd454f8703c13e8385668b3ac19e41"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfae9bd454f8703c13e8385668b3ac19e41"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfae9bd454f8703c13e8385668b3ac19e41"></a></strong>STYLE_BORDER_WIDTH&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1094181577084826"><a name="p1094181577084826"></a><a name="p1094181577084826"></a>Border width </p>
 </td>
</tr>
<tr id="row310806014084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfa3231d33e8bb12cd0cf6911076c877892"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa3231d33e8bb12cd0cf6911076c877892"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa3231d33e8bb12cd0cf6911076c877892"></a></strong>STYLE_PADDING_LEFT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1978629533084826"><a name="p1978629533084826"></a><a name="p1978629533084826"></a>Left padding </p>
 </td>
</tr>
<tr id="row1400947556084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfa8cc34b7c9774ce7dc940b7deeb64de1f"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa8cc34b7c9774ce7dc940b7deeb64de1f"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa8cc34b7c9774ce7dc940b7deeb64de1f"></a></strong>STYLE_PADDING_RIGHT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p932559259084826"><a name="p932559259084826"></a><a name="p932559259084826"></a>Right padding </p>
 </td>
</tr>
<tr id="row1145247806084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfa5225ed05b95d4a95a2c48250518c7c7f"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa5225ed05b95d4a95a2c48250518c7c7f"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa5225ed05b95d4a95a2c48250518c7c7f"></a></strong>STYLE_PADDING_TOP&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p558929550084826"><a name="p558929550084826"></a><a name="p558929550084826"></a>Top padding </p>
 </td>
</tr>
<tr id="row494691157084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfa65e4dd92a76dc374b487cd24fa37199b"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa65e4dd92a76dc374b487cd24fa37199b"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa65e4dd92a76dc374b487cd24fa37199b"></a></strong>STYLE_PADDING_BOTTOM&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p225796324084826"><a name="p225796324084826"></a><a name="p225796324084826"></a>Bottom padding </p>
 </td>
</tr>
<tr id="row152452460084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfa251e2a6ea777b9b6af8f6ccf79d060cc"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa251e2a6ea777b9b6af8f6ccf79d060cc"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa251e2a6ea777b9b6af8f6ccf79d060cc"></a></strong>STYLE_MARGIN_LEFT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p950688869084826"><a name="p950688869084826"></a><a name="p950688869084826"></a>Left margin </p>
 </td>
</tr>
<tr id="row327356416084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfa59ab9a49b6fe3f1fd42a79bf70398c70"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa59ab9a49b6fe3f1fd42a79bf70398c70"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa59ab9a49b6fe3f1fd42a79bf70398c70"></a></strong>STYLE_MARGIN_RIGHT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p819409119084826"><a name="p819409119084826"></a><a name="p819409119084826"></a>Right margin </p>
 </td>
</tr>
<tr id="row1612849239084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfad5dbc07ebf86daf81e30fcbf9051c3b6"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfad5dbc07ebf86daf81e30fcbf9051c3b6"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfad5dbc07ebf86daf81e30fcbf9051c3b6"></a></strong>STYLE_MARGIN_TOP&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1436057477084826"><a name="p1436057477084826"></a><a name="p1436057477084826"></a>Top margin </p>
 </td>
</tr>
<tr id="row2039017916084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfa05fa788c60b80429efd0e42fc5d3d4af"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa05fa788c60b80429efd0e42fc5d3d4af"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa05fa788c60b80429efd0e42fc5d3d4af"></a></strong>STYLE_MARGIN_BOTTOM&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2116694270084826"><a name="p2116694270084826"></a><a name="p2116694270084826"></a>Bottom margin </p>
 </td>
</tr>
<tr id="row794551069084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfae63c7c001e11994f2ec952559c3a0d5f"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfae63c7c001e11994f2ec952559c3a0d5f"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfae63c7c001e11994f2ec952559c3a0d5f"></a></strong>STYLE_IMAGE_OPA&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p916213216084826"><a name="p916213216084826"></a><a name="p916213216084826"></a><a href="OHOS-Image.md">Image</a> opacity </p>
 </td>
</tr>
<tr id="row284625059084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfa21142f37831ece4dc6fe12a3474029a5"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa21142f37831ece4dc6fe12a3474029a5"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa21142f37831ece4dc6fe12a3474029a5"></a></strong>STYLE_TEXT_COLOR&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1966764978084826"><a name="p1966764978084826"></a><a name="p1966764978084826"></a><a href="OHOS-Text.md">Text</a> color </p>
 </td>
</tr>
<tr id="row1303981071084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfa7288938187d2b5c74d0d1789d73784a3"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa7288938187d2b5c74d0d1789d73784a3"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa7288938187d2b5c74d0d1789d73784a3"></a></strong>STYLE_TEXT_FONT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p813637593084826"><a name="p813637593084826"></a><a name="p813637593084826"></a><a href="OHOS-Text.md">Text</a> font </p>
 </td>
</tr>
<tr id="row1359147923084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfaf705c0b077d93c8e5ee3cb4583c8ea87"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfaf705c0b077d93c8e5ee3cb4583c8ea87"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfaf705c0b077d93c8e5ee3cb4583c8ea87"></a></strong>STYLE_LETTER_SPACE&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2081809296084826"><a name="p2081809296084826"></a><a name="p2081809296084826"></a>Letter spacing </p>
 </td>
</tr>
<tr id="row1213164455084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfa06ab7c8b467da98902fe19f2b21595ba"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa06ab7c8b467da98902fe19f2b21595ba"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa06ab7c8b467da98902fe19f2b21595ba"></a></strong>STYLE_LINE_SPACE&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p304308748084826"><a name="p304308748084826"></a><a name="p304308748084826"></a><a href="OHOS-Line.md">Line</a> spacing </p>
 </td>
</tr>
<tr id="row274603178084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfa8889542f8ea0fc454895c6e245d9cfdf"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa8889542f8ea0fc454895c6e245d9cfdf"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa8889542f8ea0fc454895c6e245d9cfdf"></a></strong>STYLE_TEXT_OPA&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1568982632084826"><a name="p1568982632084826"></a><a name="p1568982632084826"></a><a href="OHOS-Text.md">Text</a> opacity </p>
 </td>
</tr>
<tr id="row239484016084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfa59ce09cf70ef205a7ff081f10d6c1380"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa59ce09cf70ef205a7ff081f10d6c1380"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa59ce09cf70ef205a7ff081f10d6c1380"></a></strong>STYLE_LINE_COLOR&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p435659509084826"><a name="p435659509084826"></a><a name="p435659509084826"></a><a href="OHOS-Line.md">Line</a> color </p>
 </td>
</tr>
<tr id="row1291064872084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfadb7984bac1deeffafc3f04169480937e"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfadb7984bac1deeffafc3f04169480937e"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfadb7984bac1deeffafc3f04169480937e"></a></strong>STYLE_LINE_WIDTH&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1397740770084826"><a name="p1397740770084826"></a><a name="p1397740770084826"></a><a href="OHOS-Line.md">Line</a> width </p>
 </td>
</tr>
<tr id="row1935818699084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfa7aa7e8dfa8b88cc3ef77c4c3b23a5ea2"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa7aa7e8dfa8b88cc3ef77c4c3b23a5ea2"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa7aa7e8dfa8b88cc3ef77c4c3b23a5ea2"></a></strong>STYLE_LINE_OPA&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1545319276084826"><a name="p1545319276084826"></a><a name="p1545319276084826"></a><a href="OHOS-Line.md">Line</a> opacity </p>
 </td>
</tr>
<tr id="row992659183084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2933ed17ce67e3e9c997aa2cf6bd04bfa420aa5184ddfd2e95632095c92dfbee5"><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa420aa5184ddfd2e95632095c92dfbee5"></a><a name="gga2933ed17ce67e3e9c997aa2cf6bd04bfa420aa5184ddfd2e95632095c92dfbee5"></a></strong>STYLE_LINE_CAP&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1592439706084826"><a name="p1592439706084826"></a><a name="p1592439706084826"></a><a href="OHOS-Line.md">Line</a> cap style </p>
 </td>
</tr>
</tbody>
</table>

## anonymous enum<a name="ga15e4f5bc0221d99ea7d46dc54328566e"></a>

```
anonymous enum
```

 **Description:**

Enumerates opacity values. 

<a name="table1052674646084826"></a>
<table><thead align="left"><tr id="row1650034799084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1293109222084826"><a name="p1293109222084826"></a><a name="p1293109222084826"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p191399907084826"><a name="p191399907084826"></a><a name="p191399907084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1442017447084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga15e4f5bc0221d99ea7d46dc54328566ead4bd10bef3f1df05fd29e023050b9cca"><a name="gga15e4f5bc0221d99ea7d46dc54328566ead4bd10bef3f1df05fd29e023050b9cca"></a><a name="gga15e4f5bc0221d99ea7d46dc54328566ead4bd10bef3f1df05fd29e023050b9cca"></a></strong>OPA_TRANSPARENT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p18910893084826"><a name="p18910893084826"></a><a name="p18910893084826"></a>The opacity is 0. </p>
 </td>
</tr>
<tr id="row1166667057084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga15e4f5bc0221d99ea7d46dc54328566eaebcfc69c18e2c29c89f800d95f32754f"><a name="gga15e4f5bc0221d99ea7d46dc54328566eaebcfc69c18e2c29c89f800d95f32754f"></a><a name="gga15e4f5bc0221d99ea7d46dc54328566eaebcfc69c18e2c29c89f800d95f32754f"></a></strong>OPA_OPAQUE&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p27828755084826"><a name="p27828755084826"></a><a name="p27828755084826"></a>The opacity is 100%. </p>
 </td>
</tr>
</tbody>
</table>

## ButtonImageSrc<a name="gaf9f6c0c373f090e79b9e8d847e186e92"></a>

```
enum [OHOS::UIButton::ButtonImageSrc](Graphic.md#gaf9f6c0c373f090e79b9e8d847e186e92) : uint8_t
```

 **Description:**

Enumerates the images for different button states. 

You can define a different image for each button state.

## ButtonState<a name="ga188dd55c17ee44be27fa80543f13f729"></a>

```
enum [OHOS::UIButton::ButtonState](Graphic.md#ga188dd55c17ee44be27fa80543f13f729) : uint8_t
```

 **Description:**

Enumerates the states of this button. 

The button has three states.

## CapType<a name="ga2db3928cdf793f4950245a6841dd43d6"></a>

```
enum [OHOS::CapType](Graphic.md#ga2db3928cdf793f4950245a6841dd43d6) : uint8_t
```

 **Description:**

Enumerates cap styles. 

<a name="table724082829084826"></a>
<table><thead align="left"><tr id="row1246692944084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p976948247084826"><a name="p976948247084826"></a><a name="p976948247084826"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p614553357084826"><a name="p614553357084826"></a><a name="p614553357084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row196635011084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2db3928cdf793f4950245a6841dd43d6a7692381654eff26893e03ac1983c8f45"><a name="gga2db3928cdf793f4950245a6841dd43d6a7692381654eff26893e03ac1983c8f45"></a><a name="gga2db3928cdf793f4950245a6841dd43d6a7692381654eff26893e03ac1983c8f45"></a></strong>CAP_NONE&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p790264288084826"><a name="p790264288084826"></a><a name="p790264288084826"></a>No cap style </p>
 </td>
</tr>
<tr id="row261986800084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga2db3928cdf793f4950245a6841dd43d6ada0a5a2f0100d929e9e1d1d31ef26cce"><a name="gga2db3928cdf793f4950245a6841dd43d6ada0a5a2f0100d929e9e1d1d31ef26cce"></a><a name="gga2db3928cdf793f4950245a6841dd43d6ada0a5a2f0100d929e9e1d1d31ef26cce"></a></strong>CAP_ROUND&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p760763102084826"><a name="p760763102084826"></a><a name="p760763102084826"></a>Round cap style </p>
 </td>
</tr>
</tbody>
</table>

## ColorMode<a name="ga3a3fb04ed2cda4017e6771c66b692141"></a>

```
enum [OHOS::ColorMode](Graphic.md#ga3a3fb04ed2cda4017e6771c66b692141) : uint8_t
```

 **Description:**

colormode of image and font. 

<a name="table775854080084826"></a>
<table><thead align="left"><tr id="row916682900084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p162451513084826"><a name="p162451513084826"></a><a name="p162451513084826"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p445492126084826"><a name="p445492126084826"></a><a name="p445492126084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row491192622084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a2f9573d43aecf2449480f8574b907683"><a name="gga3a3fb04ed2cda4017e6771c66b692141a2f9573d43aecf2449480f8574b907683"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a2f9573d43aecf2449480f8574b907683"></a></strong>ARGB8888&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p867739498084826"><a name="p867739498084826"></a><a name="p867739498084826"></a>ARGB8888 color mode </p>
 </td>
</tr>
<tr id="row2124297098084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a5a962b82aadba3263c4f0de98262e30e"><a name="gga3a3fb04ed2cda4017e6771c66b692141a5a962b82aadba3263c4f0de98262e30e"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a5a962b82aadba3263c4f0de98262e30e"></a></strong>RGB888&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1558635431084826"><a name="p1558635431084826"></a><a name="p1558635431084826"></a>RGB888 color mode </p>
 </td>
</tr>
<tr id="row1382094916084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141aecb2d8fad7e9b4cfcf53e5490c80651f"><a name="gga3a3fb04ed2cda4017e6771c66b692141aecb2d8fad7e9b4cfcf53e5490c80651f"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141aecb2d8fad7e9b4cfcf53e5490c80651f"></a></strong>RGB565&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1862382046084826"><a name="p1862382046084826"></a><a name="p1862382046084826"></a>RGB565 color mode </p>
 </td>
</tr>
<tr id="row1935953795084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141add58b331447c6b0e8963fc0f21b78033"><a name="gga3a3fb04ed2cda4017e6771c66b692141add58b331447c6b0e8963fc0f21b78033"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141add58b331447c6b0e8963fc0f21b78033"></a></strong>ARGB1555&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1667077423084826"><a name="p1667077423084826"></a><a name="p1667077423084826"></a>ARGB1555 color mode </p>
 </td>
</tr>
<tr id="row2071184872084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a21266607b0e5987609d37b52e63f5277"><a name="gga3a3fb04ed2cda4017e6771c66b692141a21266607b0e5987609d37b52e63f5277"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a21266607b0e5987609d37b52e63f5277"></a></strong>ARGB4444&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p355998563084826"><a name="p355998563084826"></a><a name="p355998563084826"></a>ARGB4444 color mode </p>
 </td>
</tr>
<tr id="row783477349084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a6fbe6b11f436174cc18a931ae9fb85d3"><a name="gga3a3fb04ed2cda4017e6771c66b692141a6fbe6b11f436174cc18a931ae9fb85d3"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a6fbe6b11f436174cc18a931ae9fb85d3"></a></strong>AL44&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1115905071084826"><a name="p1115905071084826"></a><a name="p1115905071084826"></a>AL44 color mode </p>
 </td>
</tr>
<tr id="row374769272084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a7cc06e38b82b0bda251bfc8f0fc953b6"><a name="gga3a3fb04ed2cda4017e6771c66b692141a7cc06e38b82b0bda251bfc8f0fc953b6"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a7cc06e38b82b0bda251bfc8f0fc953b6"></a></strong>AL88&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1057808471084826"><a name="p1057808471084826"></a><a name="p1057808471084826"></a>AL88 color mode </p>
 </td>
</tr>
<tr id="row1591536851084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a734f6e329eed35e1fe3f2f6d753665ac"><a name="gga3a3fb04ed2cda4017e6771c66b692141a734f6e329eed35e1fe3f2f6d753665ac"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a734f6e329eed35e1fe3f2f6d753665ac"></a></strong>L1&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1487321072084826"><a name="p1487321072084826"></a><a name="p1487321072084826"></a>L1 color mode </p>
 </td>
</tr>
<tr id="row1468430871084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141abe9263055f6c06124c0c8b513e1d87df"><a name="gga3a3fb04ed2cda4017e6771c66b692141abe9263055f6c06124c0c8b513e1d87df"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141abe9263055f6c06124c0c8b513e1d87df"></a></strong>L2&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p874619078084826"><a name="p874619078084826"></a><a name="p874619078084826"></a>L2 color mode </p>
 </td>
</tr>
<tr id="row1097149797084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a493a9a5cd759369b982ad7e6ac0de13f"><a name="gga3a3fb04ed2cda4017e6771c66b692141a493a9a5cd759369b982ad7e6ac0de13f"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a493a9a5cd759369b982ad7e6ac0de13f"></a></strong>L4&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1256695286084826"><a name="p1256695286084826"></a><a name="p1256695286084826"></a>L4 color mode </p>
 </td>
</tr>
<tr id="row234015766084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a8417494b1a72ed840b16752f32e7554c"><a name="gga3a3fb04ed2cda4017e6771c66b692141a8417494b1a72ed840b16752f32e7554c"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a8417494b1a72ed840b16752f32e7554c"></a></strong>L8&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1356609126084826"><a name="p1356609126084826"></a><a name="p1356609126084826"></a>L8 color mode </p>
 </td>
</tr>
<tr id="row60551784084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a106ce1ddec51f2cb302686252d3c9560"><a name="gga3a3fb04ed2cda4017e6771c66b692141a106ce1ddec51f2cb302686252d3c9560"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a106ce1ddec51f2cb302686252d3c9560"></a></strong>A1&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1838242077084826"><a name="p1838242077084826"></a><a name="p1838242077084826"></a>A1 color mode </p>
 </td>
</tr>
<tr id="row94341190084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a365d0df177aa6e1b73fe0cddf72e88c7"><a name="gga3a3fb04ed2cda4017e6771c66b692141a365d0df177aa6e1b73fe0cddf72e88c7"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a365d0df177aa6e1b73fe0cddf72e88c7"></a></strong>A2&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p388329072084826"><a name="p388329072084826"></a><a name="p388329072084826"></a>A2 color mode </p>
 </td>
</tr>
<tr id="row1494515911084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141ae49cb0538532ad895017e6f0d236d9da"><a name="gga3a3fb04ed2cda4017e6771c66b692141ae49cb0538532ad895017e6f0d236d9da"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141ae49cb0538532ad895017e6f0d236d9da"></a></strong>A4&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p11867451084826"><a name="p11867451084826"></a><a name="p11867451084826"></a>A4 color mode </p>
 </td>
</tr>
<tr id="row129689719084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a3b6524df7a87ae2800f8ac5b7417d5bc"><a name="gga3a3fb04ed2cda4017e6771c66b692141a3b6524df7a87ae2800f8ac5b7417d5bc"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a3b6524df7a87ae2800f8ac5b7417d5bc"></a></strong>A8&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1414981833084826"><a name="p1414981833084826"></a><a name="p1414981833084826"></a>A8 color mode </p>
 </td>
</tr>
<tr id="row1225141187084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3a3fb04ed2cda4017e6771c66b692141a892afdfffaf015240b16b563599b0244"><a name="gga3a3fb04ed2cda4017e6771c66b692141a892afdfffaf015240b16b563599b0244"></a><a name="gga3a3fb04ed2cda4017e6771c66b692141a892afdfffaf015240b16b563599b0244"></a></strong>UNKNOW&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p972072995084826"><a name="p972072995084826"></a><a name="p972072995084826"></a>unknow color mode </p>
 </td>
</tr>
</tbody>
</table>

## DeviceType<a name="gaf8133740d5a3cb2f88a7f33cb11c6dbd"></a>

```
enum [OHOS::VirtualDeviceEvent::DeviceType](Graphic.md#gaf8133740d5a3cb2f88a7f33cb11c6dbd)
```

 **Description:**

Enumerates virtual device types. 

## DialogButtonType<a name="ga1bfefa0b46fd5a79a28d0c9a75114295"></a>

```
enum [OHOS::UIDialog::DialogButtonType](Graphic.md#ga1bfefa0b46fd5a79a28d0c9a75114295)
```

 **Description:**

Enumerates buttons in a dialog box. 

<a name="table41963646084826"></a>
<table><thead align="left"><tr id="row257734138084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1148944660084826"><a name="p1148944660084826"></a><a name="p1148944660084826"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1140130770084826"><a name="p1140130770084826"></a><a name="p1140130770084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2106875035084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga1bfefa0b46fd5a79a28d0c9a75114295a39ef626649e9e14c6561411867e50f00"><a name="gga1bfefa0b46fd5a79a28d0c9a75114295a39ef626649e9e14c6561411867e50f00"></a><a name="gga1bfefa0b46fd5a79a28d0c9a75114295a39ef626649e9e14c6561411867e50f00"></a></strong>BUTTON1&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p459311908084826"><a name="p459311908084826"></a><a name="p459311908084826"></a>First button </p>
 </td>
</tr>
<tr id="row2076610404084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga1bfefa0b46fd5a79a28d0c9a75114295a752441e0500e1807164a5f758ed93a8c"><a name="gga1bfefa0b46fd5a79a28d0c9a75114295a752441e0500e1807164a5f758ed93a8c"></a><a name="gga1bfefa0b46fd5a79a28d0c9a75114295a752441e0500e1807164a5f758ed93a8c"></a></strong>BUTTON2&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1724364977084826"><a name="p1724364977084826"></a><a name="p1724364977084826"></a>Second button </p>
 </td>
</tr>
<tr id="row1746249591084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga1bfefa0b46fd5a79a28d0c9a75114295a86707c1d7552f48007cc25b77a2db21b"><a name="gga1bfefa0b46fd5a79a28d0c9a75114295a86707c1d7552f48007cc25b77a2db21b"></a><a name="gga1bfefa0b46fd5a79a28d0c9a75114295a86707c1d7552f48007cc25b77a2db21b"></a></strong>BUTTON3&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p296957307084826"><a name="p296957307084826"></a><a name="p296957307084826"></a>Third button </p>
 </td>
</tr>
</tbody>
</table>

## Direction<a name="ga4a7a2c192206c8b18379f42a5fd176eb"></a>

```
enum [OHOS::UIBoxProgress::Direction](Graphic.md#ga4a7a2c192206c8b18379f42a5fd176eb) : uint8_t
```

 **Description:**

Enumerates the directions of the progress bar. 

<a name="table1109710168084826"></a>
<table><thead align="left"><tr id="row133369048084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1891191598084826"><a name="p1891191598084826"></a><a name="p1891191598084826"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p990677362084826"><a name="p990677362084826"></a><a name="p990677362084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1285579678084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga4a7a2c192206c8b18379f42a5fd176eba43cb7d46f0e18f315d43b82024093b51"><a name="gga4a7a2c192206c8b18379f42a5fd176eba43cb7d46f0e18f315d43b82024093b51"></a><a name="gga4a7a2c192206c8b18379f42a5fd176eba43cb7d46f0e18f315d43b82024093b51"></a></strong>DIR_LEFT_TO_RIGHT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1776089361084826"><a name="p1776089361084826"></a><a name="p1776089361084826"></a>Filling from left to right </p>
 </td>
</tr>
<tr id="row845586830084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga4a7a2c192206c8b18379f42a5fd176eba49e31df5a7fc02ee8c2f85b5e15f0145"><a name="gga4a7a2c192206c8b18379f42a5fd176eba49e31df5a7fc02ee8c2f85b5e15f0145"></a><a name="gga4a7a2c192206c8b18379f42a5fd176eba49e31df5a7fc02ee8c2f85b5e15f0145"></a></strong>DIR_RIGHT_TO_LEFT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p662521660084826"><a name="p662521660084826"></a><a name="p662521660084826"></a>Filling from right to left </p>
 </td>
</tr>
<tr id="row1550047596084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga4a7a2c192206c8b18379f42a5fd176eba68baeaa89ae4576fc3d9ac732f87a116"><a name="gga4a7a2c192206c8b18379f42a5fd176eba68baeaa89ae4576fc3d9ac732f87a116"></a><a name="gga4a7a2c192206c8b18379f42a5fd176eba68baeaa89ae4576fc3d9ac732f87a116"></a></strong>DIR_TOP_TO_BOTTOM&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p313558907084826"><a name="p313558907084826"></a><a name="p313558907084826"></a>Filling from top to bottom </p>
 </td>
</tr>
<tr id="row2089663381084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga4a7a2c192206c8b18379f42a5fd176eba78b28982b481790c740bc9b2c1292baa"><a name="gga4a7a2c192206c8b18379f42a5fd176eba78b28982b481790c740bc9b2c1292baa"></a><a name="gga4a7a2c192206c8b18379f42a5fd176eba78b28982b481790c740bc9b2c1292baa"></a></strong>DIR_BOTTOM_TO_TOP&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2082161129084826"><a name="p2082161129084826"></a><a name="p2082161129084826"></a>Filling from bottom to top </p>
 </td>
</tr>
</tbody>
</table>

## DisplayMode<a name="gabe3b64b11e5bf5d7b54e1039e40f306b"></a>

```
enum [OHOS::UIDigitalClock::DisplayMode](Graphic.md#gabe3b64b11e5bf5d7b54e1039e40f306b)
```

 **Description:**

Enumerates the display modes of this digital clock. 

<a name="table1261988993084826"></a>
<table><thead align="left"><tr id="row2003216756084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p732653138084826"><a name="p732653138084826"></a><a name="p732653138084826"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1809956457084826"><a name="p1809956457084826"></a><a name="p1809956457084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row548243826084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggabe3b64b11e5bf5d7b54e1039e40f306bafc93e631e582de9e4128be8e6d41dbfe"><a name="ggabe3b64b11e5bf5d7b54e1039e40f306bafc93e631e582de9e4128be8e6d41dbfe"></a><a name="ggabe3b64b11e5bf5d7b54e1039e40f306bafc93e631e582de9e4128be8e6d41dbfe"></a></strong>DISPLAY_12_HOUR_NO_SECONDS&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p2044819951084826"><a name="p2044819951084826"></a><a name="p2044819951084826"></a>12-hour format, without seconds </p>
 </td>
</tr>
<tr id="row938033089084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggabe3b64b11e5bf5d7b54e1039e40f306ba0c5adc8c80a47a33eb7bfcbcad0b4163"><a name="ggabe3b64b11e5bf5d7b54e1039e40f306ba0c5adc8c80a47a33eb7bfcbcad0b4163"></a><a name="ggabe3b64b11e5bf5d7b54e1039e40f306ba0c5adc8c80a47a33eb7bfcbcad0b4163"></a></strong>DISPLAY_24_HOUR_NO_SECONDS&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p278956445084826"><a name="p278956445084826"></a><a name="p278956445084826"></a>24-hour format, without seconds </p>
 </td>
</tr>
<tr id="row900095224084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggabe3b64b11e5bf5d7b54e1039e40f306baa5cbeab2c7366db7f33b2e95da20615b"><a name="ggabe3b64b11e5bf5d7b54e1039e40f306baa5cbeab2c7366db7f33b2e95da20615b"></a><a name="ggabe3b64b11e5bf5d7b54e1039e40f306baa5cbeab2c7366db7f33b2e95da20615b"></a></strong>DISPLAY_12_HOUR&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1607996283084826"><a name="p1607996283084826"></a><a name="p1607996283084826"></a>12-hour format </p>
 </td>
</tr>
<tr id="row722737763084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggabe3b64b11e5bf5d7b54e1039e40f306ba833c0664bba32e6fe4a53a1c471d0eb8"><a name="ggabe3b64b11e5bf5d7b54e1039e40f306ba833c0664bba32e6fe4a53a1c471d0eb8"></a><a name="ggabe3b64b11e5bf5d7b54e1039e40f306ba833c0664bba32e6fe4a53a1c471d0eb8"></a></strong>DISPLAY_24_HOUR&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p592889293084826"><a name="p592889293084826"></a><a name="p592889293084826"></a>24-hour format </p>
 </td>
</tr>
</tbody>
</table>

## DrawType<a name="ga0a595eeb50ce4e7dfff9ede16098d2db"></a>

```
enum [OHOS::UIAnalogClock::DrawType](Graphic.md#ga0a595eeb50ce4e7dfff9ede16098d2db)
```

 **Description:**

Enumerates the drawing types of a clock hand. 

<a name="table2046518218084826"></a>
<table><thead align="left"><tr id="row313162834084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p898402121084826"><a name="p898402121084826"></a><a name="p898402121084826"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1652760120084826"><a name="p1652760120084826"></a><a name="p1652760120084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1061241532084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga0a595eeb50ce4e7dfff9ede16098d2dba6ddf16010fbdac5db23575583cb8a388"><a name="gga0a595eeb50ce4e7dfff9ede16098d2dba6ddf16010fbdac5db23575583cb8a388"></a><a name="gga0a595eeb50ce4e7dfff9ede16098d2dba6ddf16010fbdac5db23575583cb8a388"></a></strong>DRAW_LINE&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1928917357084826"><a name="p1928917357084826"></a><a name="p1928917357084826"></a>Using a line to draw a clock hand </p>
 </td>
</tr>
<tr id="row191933966084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga0a595eeb50ce4e7dfff9ede16098d2dba5cb6a362b1dec2b19422e9e9a6bbda3c"><a name="gga0a595eeb50ce4e7dfff9ede16098d2dba5cb6a362b1dec2b19422e9e9a6bbda3c"></a><a name="gga0a595eeb50ce4e7dfff9ede16098d2dba5cb6a362b1dec2b19422e9e9a6bbda3c"></a></strong>DRAW_IMAGE&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1729836722084826"><a name="p1729836722084826"></a><a name="p1729836722084826"></a>Using an image to draw a clock hand </p>
 </td>
</tr>
</tbody>
</table>

## FPSCalculateType<a name="ga75d850e3abff6c2f617b689a0cb9a3d1"></a>

```
enum [OHOS::SysInfo::FPSCalculateType](Graphic.md#ga75d850e3abff6c2f617b689a0cb9a3d1)
```

 **Description:**

Enumerates the FPS capture types. 

<a name="table972036954084826"></a>
<table><thead align="left"><tr id="row755203092084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1899417919084826"><a name="p1899417919084826"></a><a name="p1899417919084826"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1729999384084826"><a name="p1729999384084826"></a><a name="p1729999384084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1070174757084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga75d850e3abff6c2f617b689a0cb9a3d1a26a841fb9a10881591dc79dae38e2d7f"><a name="gga75d850e3abff6c2f617b689a0cb9a3d1a26a841fb9a10881591dc79dae38e2d7f"></a><a name="gga75d850e3abff6c2f617b689a0cb9a3d1a26a841fb9a10881591dc79dae38e2d7f"></a></strong>FPS_CT_FIXED_TIME&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p168781345084826"><a name="p168781345084826"></a><a name="p168781345084826"></a>Fixed time sampling: The system collects the number of page refresh times within one second. </p>
 </td>
</tr>
<tr id="row908268259084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga75d850e3abff6c2f617b689a0cb9a3d1a17fdb75ff7e9afb4165349a3d8300f3c"><a name="gga75d850e3abff6c2f617b689a0cb9a3d1a17fdb75ff7e9afb4165349a3d8300f3c"></a><a name="gga75d850e3abff6c2f617b689a0cb9a3d1a17fdb75ff7e9afb4165349a3d8300f3c"></a></strong>FPS_CT_AVERAGE_SAMPLING&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p322086243084826"><a name="p322086243084826"></a><a name="p322086243084826"></a>Average sampling: The system collects statistics on the average frame rate of 100 frames. No extra space is required to store the data of each frame. The precision is not as high as that of precise sampling. </p>
 </td>
</tr>
<tr id="row716191949084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga75d850e3abff6c2f617b689a0cb9a3d1afcc7226b2c9012f2993b7044a80cbed5"><a name="gga75d850e3abff6c2f617b689a0cb9a3d1afcc7226b2c9012f2993b7044a80cbed5"></a><a name="gga75d850e3abff6c2f617b689a0cb9a3d1afcc7226b2c9012f2993b7044a80cbed5"></a></strong>FPS_CT_PRECISE_SAMPLING&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1438877846084826"><a name="p1438877846084826"></a><a name="p1438877846084826"></a>Precise sampling: The system collects statistics on the average frame rate of the current 100 frames. Extra space is required to save the data of each frame. The result is more precise than that of average sampling. </p>
 </td>
</tr>
</tbody>
</table>

## HandType<a name="ga13cf64ea5bd39550976aaf65b1381edf"></a>

```
enum [OHOS::UIAnalogClock::HandType](Graphic.md#ga13cf64ea5bd39550976aaf65b1381edf)
```

 **Description:**

Enumerates the clock hand types. 

<a name="table1857430470084826"></a>
<table><thead align="left"><tr id="row1847573269084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1599116993084826"><a name="p1599116993084826"></a><a name="p1599116993084826"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1340110784084826"><a name="p1340110784084826"></a><a name="p1340110784084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row565332332084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga13cf64ea5bd39550976aaf65b1381edfa2b8ab55559dff5a849bf7445f6865958"><a name="gga13cf64ea5bd39550976aaf65b1381edfa2b8ab55559dff5a849bf7445f6865958"></a><a name="gga13cf64ea5bd39550976aaf65b1381edfa2b8ab55559dff5a849bf7445f6865958"></a></strong>HOUR_HAND&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p625104093084826"><a name="p625104093084826"></a><a name="p625104093084826"></a>Hour hand </p>
 </td>
</tr>
<tr id="row1172941613084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga13cf64ea5bd39550976aaf65b1381edfa50ddc7aea61ec54878c173e1423af447"><a name="gga13cf64ea5bd39550976aaf65b1381edfa50ddc7aea61ec54878c173e1423af447"></a><a name="gga13cf64ea5bd39550976aaf65b1381edfa50ddc7aea61ec54878c173e1423af447"></a></strong>MINUTE_HAND&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1117929053084826"><a name="p1117929053084826"></a><a name="p1117929053084826"></a>Minute hand </p>
 </td>
</tr>
<tr id="row386822684084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga13cf64ea5bd39550976aaf65b1381edfa620c615d18fdb1b23ed04df57842909d"><a name="gga13cf64ea5bd39550976aaf65b1381edfa620c615d18fdb1b23ed04df57842909d"></a><a name="gga13cf64ea5bd39550976aaf65b1381edfa620c615d18fdb1b23ed04df57842909d"></a></strong>SECOND_HAND&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p17328740084826"><a name="p17328740084826"></a><a name="p17328740084826"></a>Second hand </p>
 </td>
</tr>
</tbody>
</table>

## LineBreakMode<a name="gaf2ba9acac6cafffc549781ace0475cd5"></a>

```
enum [OHOS::UILabel::LineBreakMode](Graphic.md#gaf2ba9acac6cafffc549781ace0475cd5) : uint8_t
```

 **Description:**

Enumerates the display modes of a long text. 

<a name="table1336659241084826"></a>
<table><thead align="left"><tr id="row1502135260084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p83740235084826"><a name="p83740235084826"></a><a name="p83740235084826"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p185229661084826"><a name="p185229661084826"></a><a name="p185229661084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row869656387084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaf2ba9acac6cafffc549781ace0475cd5a03a7da624ae08162b5e74ad67e50467f"><a name="ggaf2ba9acac6cafffc549781ace0475cd5a03a7da624ae08162b5e74ad67e50467f"></a><a name="ggaf2ba9acac6cafffc549781ace0475cd5a03a7da624ae08162b5e74ad67e50467f"></a></strong>LINE_BREAK_ADAPT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p680638907084826"><a name="p680638907084826"></a><a name="p680638907084826"></a>The label size is adaptive to the text size. </p>
 </td>
</tr>
<tr id="row1927034853084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaf2ba9acac6cafffc549781ace0475cd5abc49de1d3936e957882efbb3259dc5be"><a name="ggaf2ba9acac6cafffc549781ace0475cd5abc49de1d3936e957882efbb3259dc5be"></a><a name="ggaf2ba9acac6cafffc549781ace0475cd5abc49de1d3936e957882efbb3259dc5be"></a></strong>LINE_BREAK_STRETCH&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p191849192084826"><a name="p191849192084826"></a><a name="p191849192084826"></a>The height of this label remains unchanged, and the width is adaptive to the text size. </p>
 </td>
</tr>
<tr id="row1365645421084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaf2ba9acac6cafffc549781ace0475cd5a2d55ab62d9cead746eb1eaaad1e4e621"><a name="ggaf2ba9acac6cafffc549781ace0475cd5a2d55ab62d9cead746eb1eaaad1e4e621"></a><a name="ggaf2ba9acac6cafffc549781ace0475cd5a2d55ab62d9cead746eb1eaaad1e4e621"></a></strong>LINE_BREAK_WRAP&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1877229498084826"><a name="p1877229498084826"></a><a name="p1877229498084826"></a>The width of this label remains unchanged, and the height is adaptive to the text size. The text switches to the next line if the text exceeds the maximum label width. </p>
 </td>
</tr>
<tr id="row648827019084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaf2ba9acac6cafffc549781ace0475cd5ac15f8bb00b735e743b621f24a864b0ed"><a name="ggaf2ba9acac6cafffc549781ace0475cd5ac15f8bb00b735e743b621f24a864b0ed"></a><a name="ggaf2ba9acac6cafffc549781ace0475cd5ac15f8bb00b735e743b621f24a864b0ed"></a></strong>LINE_BREAK_ELLIPSIS&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1558751446084826"><a name="p1558751446084826"></a><a name="p1558751446084826"></a>The width and height of this label remain unchanged. If this text is too long, ellipsis will be used at the end. </p>
 </td>
</tr>
<tr id="row1240302817084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaf2ba9acac6cafffc549781ace0475cd5a6d3e13d5e53904899020e2c44f6ca82d"><a name="ggaf2ba9acac6cafffc549781ace0475cd5a6d3e13d5e53904899020e2c44f6ca82d"></a><a name="ggaf2ba9acac6cafffc549781ace0475cd5a6d3e13d5e53904899020e2c44f6ca82d"></a></strong>LINE_BREAK_MARQUEE&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1561218751084826"><a name="p1561218751084826"></a><a name="p1561218751084826"></a>The width and height of this label remain unchanged. If this text is too long, it will be rolled to display. </p>
 </td>
</tr>
<tr id="row65320690084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaf2ba9acac6cafffc549781ace0475cd5a4111b08e919f919c314556753aa3ff46"><a name="ggaf2ba9acac6cafffc549781ace0475cd5a4111b08e919f919c314556753aa3ff46"></a><a name="ggaf2ba9acac6cafffc549781ace0475cd5a4111b08e919f919c314556753aa3ff46"></a></strong>LINE_BREAK_CLIP&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1339965570084826"><a name="p1339965570084826"></a><a name="p1339965570084826"></a>The width and height of this label remain unchanged. If this text is too long, it will be cropped to display. </p>
 </td>
</tr>
<tr id="row1070378686084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaf2ba9acac6cafffc549781ace0475cd5afb101ae817692c5bada96ba35f9a636d"><a name="ggaf2ba9acac6cafffc549781ace0475cd5afb101ae817692c5bada96ba35f9a636d"></a><a name="ggaf2ba9acac6cafffc549781ace0475cd5afb101ae817692c5bada96ba35f9a636d"></a></strong>LINE_BREAK_MAX&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1649297443084826"><a name="p1649297443084826"></a><a name="p1649297443084826"></a>Maximum value of the line break mode, which is used for validity check. </p>
 </td>
</tr>
</tbody>
</table>

## PaintStyle<a name="ga548320a469b7862fa416af062cad5d7a"></a>

```
enum [OHOS::Paint::PaintStyle](Graphic.md#ga548320a469b7862fa416af062cad5d7a)
```

 **Description:**

Enumerates paint styles of a closed graph. The styles are invalid for non-closed graphs. 

<a name="table545649296084826"></a>
<table><thead align="left"><tr id="row1740692812084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p732996758084826"><a name="p732996758084826"></a><a name="p732996758084826"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1888067346084826"><a name="p1888067346084826"></a><a name="p1888067346084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1669473698084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga548320a469b7862fa416af062cad5d7aa16a9f85a0cca54cb2e20bb58a6a41a41"><a name="gga548320a469b7862fa416af062cad5d7aa16a9f85a0cca54cb2e20bb58a6a41a41"></a><a name="gga548320a469b7862fa416af062cad5d7aa16a9f85a0cca54cb2e20bb58a6a41a41"></a></strong>STROKE_STYLE&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1330964159084826"><a name="p1330964159084826"></a><a name="p1330964159084826"></a>Stroke only </p>
 </td>
</tr>
<tr id="row2064834733084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga548320a469b7862fa416af062cad5d7aa706e9d250b4f9ef43008dcd61eb67bb6"><a name="gga548320a469b7862fa416af062cad5d7aa706e9d250b4f9ef43008dcd61eb67bb6"></a><a name="gga548320a469b7862fa416af062cad5d7aa706e9d250b4f9ef43008dcd61eb67bb6"></a></strong>FILL_STYLE&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p635833947084826"><a name="p635833947084826"></a><a name="p635833947084826"></a>Fill only </p>
 </td>
</tr>
<tr id="row1317458455084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga548320a469b7862fa416af062cad5d7aa30415cae54bf38e3275e847b5ab3ef1c"><a name="gga548320a469b7862fa416af062cad5d7aa30415cae54bf38e3275e847b5ab3ef1c"></a><a name="gga548320a469b7862fa416af062cad5d7aa30415cae54bf38e3275e847b5ab3ef1c"></a></strong>STROKE_FILL_STYLE&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1914460198084826"><a name="p1914460198084826"></a><a name="p1914460198084826"></a>Stroke and fill </p>
 </td>
</tr>
</tbody>
</table>

## TextOrientation<a name="ga0778527bee4a7ddd8d46395585a5cfb9"></a>

```
enum [OHOS::UIArcLabel::TextOrientation](Graphic.md#ga0778527bee4a7ddd8d46395585a5cfb9) : uint8_t
```

 **Description:**

Enumerates text orientations. 

<a name="table1836313432084826"></a>
<table><thead align="left"><tr id="row1859013536084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p754876404084826"><a name="p754876404084826"></a><a name="p754876404084826"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p891113324084826"><a name="p891113324084826"></a><a name="p891113324084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row138095316084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga0778527bee4a7ddd8d46395585a5cfb9a554a7418c4c0dafd902ebd377b87c80c"><a name="gga0778527bee4a7ddd8d46395585a5cfb9a554a7418c4c0dafd902ebd377b87c80c"></a><a name="gga0778527bee4a7ddd8d46395585a5cfb9a554a7418c4c0dafd902ebd377b87c80c"></a></strong>INSIDE&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1185380314084826"><a name="p1185380314084826"></a><a name="p1185380314084826"></a>Inside </p>
 </td>
</tr>
<tr id="row347162336084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga0778527bee4a7ddd8d46395585a5cfb9a93da25bafef6761717afc6b25c17ea16"><a name="gga0778527bee4a7ddd8d46395585a5cfb9a93da25bafef6761717afc6b25c17ea16"></a><a name="gga0778527bee4a7ddd8d46395585a5cfb9a93da25bafef6761717afc6b25c17ea16"></a></strong>OUTSIDE&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p935392646084826"><a name="p935392646084826"></a><a name="p935392646084826"></a>Outside </p>
 </td>
</tr>
</tbody>
</table>

## TimeElement<a name="gaa6aacc9ecbf5e20f22e50e542a69f472"></a>

```
enum [OHOS::UIDigitalClock::TimeElement](Graphic.md#gaa6aacc9ecbf5e20f22e50e542a69f472)
```

 **Description:**

Enumerates the time elements of this digital clock. 

<a name="table405345476084826"></a>
<table><thead align="left"><tr id="row1020061911084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p846770440084826"><a name="p846770440084826"></a><a name="p846770440084826"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1323648493084826"><a name="p1323648493084826"></a><a name="p1323648493084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1827215246084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa6aacc9ecbf5e20f22e50e542a69f472a8c15c8462a73ec9c9d9d3ad542ba4946"><a name="ggaa6aacc9ecbf5e20f22e50e542a69f472a8c15c8462a73ec9c9d9d3ad542ba4946"></a><a name="ggaa6aacc9ecbf5e20f22e50e542a69f472a8c15c8462a73ec9c9d9d3ad542ba4946"></a></strong>HOUR_ELEMENT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1664953944084826"><a name="p1664953944084826"></a><a name="p1664953944084826"></a>Clock </p>
 </td>
</tr>
<tr id="row1789561257084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa6aacc9ecbf5e20f22e50e542a69f472ae60c24ee0bb6908798a770cb39034de2"><a name="ggaa6aacc9ecbf5e20f22e50e542a69f472ae60c24ee0bb6908798a770cb39034de2"></a><a name="ggaa6aacc9ecbf5e20f22e50e542a69f472ae60c24ee0bb6908798a770cb39034de2"></a></strong>MINUTE_ELEMENT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p638378167084826"><a name="p638378167084826"></a><a name="p638378167084826"></a>Minute </p>
 </td>
</tr>
<tr id="row292091410084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="ggaa6aacc9ecbf5e20f22e50e542a69f472a0299da12b65446f25e530d8d20881a1a"><a name="ggaa6aacc9ecbf5e20f22e50e542a69f472a0299da12b65446f25e530d8d20881a1a"></a><a name="ggaa6aacc9ecbf5e20f22e50e542a69f472a0299da12b65446f25e530d8d20881a1a"></a></strong>SECOND_ELEMENT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1275758389084826"><a name="p1275758389084826"></a><a name="p1275758389084826"></a>Second </p>
 </td>
</tr>
</tbody>
</table>

## UICheckBoxState<a name="ga15a3f0302aded0e4d1584ddc6002335d"></a>

```
enum [OHOS::UICheckBox::UICheckBoxState](Graphic.md#ga15a3f0302aded0e4d1584ddc6002335d) : uint8_t
```

 **Description:**

Enumerates the states of a check box. 

## UITextLanguageAlignment<a name="ga3f99b58f731a37cacde72d5e0c934593"></a>

```
enum [OHOS::UITextLanguageAlignment](Graphic.md#ga3f99b58f731a37cacde72d5e0c934593) : uint8_t
```

 **Description:**

Enumerates text alignment modes. 

<a name="table936970107084826"></a>
<table><thead align="left"><tr id="row1513554798084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1695855363084826"><a name="p1695855363084826"></a><a name="p1695855363084826"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1104090975084826"><a name="p1104090975084826"></a><a name="p1104090975084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row287966031084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3f99b58f731a37cacde72d5e0c934593a37453e521c390e6157ac2efff1197a43"><a name="gga3f99b58f731a37cacde72d5e0c934593a37453e521c390e6157ac2efff1197a43"></a><a name="gga3f99b58f731a37cacde72d5e0c934593a37453e521c390e6157ac2efff1197a43"></a></strong>TEXT_ALIGNMENT_LEFT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1732328288084826"><a name="p1732328288084826"></a><a name="p1732328288084826"></a>Left-aligned </p>
 </td>
</tr>
<tr id="row1079371931084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3f99b58f731a37cacde72d5e0c934593af6fdcea7d95056a0bab016ba7bee66bd"><a name="gga3f99b58f731a37cacde72d5e0c934593af6fdcea7d95056a0bab016ba7bee66bd"></a><a name="gga3f99b58f731a37cacde72d5e0c934593af6fdcea7d95056a0bab016ba7bee66bd"></a></strong>TEXT_ALIGNMENT_RIGHT&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1467584564084826"><a name="p1467584564084826"></a><a name="p1467584564084826"></a>Right-aligned </p>
 </td>
</tr>
<tr id="row1830340460084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3f99b58f731a37cacde72d5e0c934593a1dd445f9b6987a84a7022885ea13c81c"><a name="gga3f99b58f731a37cacde72d5e0c934593a1dd445f9b6987a84a7022885ea13c81c"></a><a name="gga3f99b58f731a37cacde72d5e0c934593a1dd445f9b6987a84a7022885ea13c81c"></a></strong>TEXT_ALIGNMENT_CENTER&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p569316222084826"><a name="p569316222084826"></a><a name="p569316222084826"></a>Centered </p>
 </td>
</tr>
<tr id="row329035645084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3f99b58f731a37cacde72d5e0c934593a33dfd4e235bcc2f6f42f4efc8c8264a2"><a name="gga3f99b58f731a37cacde72d5e0c934593a33dfd4e235bcc2f6f42f4efc8c8264a2"></a><a name="gga3f99b58f731a37cacde72d5e0c934593a33dfd4e235bcc2f6f42f4efc8c8264a2"></a></strong>TEXT_ALIGNMENT_TOP&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p43157757084826"><a name="p43157757084826"></a><a name="p43157757084826"></a>Top-aligned </p>
 </td>
</tr>
<tr id="row212833906084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga3f99b58f731a37cacde72d5e0c934593aa7798629aa2199c86cb668e94115186c"><a name="gga3f99b58f731a37cacde72d5e0c934593aa7798629aa2199c86cb668e94115186c"></a><a name="gga3f99b58f731a37cacde72d5e0c934593aa7798629aa2199c86cb668e94115186c"></a></strong>TEXT_ALIGNMENT_BOTTOM&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p171386300084826"><a name="p171386300084826"></a><a name="p171386300084826"></a>Bottom-aligned </p>
 </td>
</tr>
</tbody>
</table>

## UITextLanguageDirect<a name="ga0c108f97781843f67c101b47b6c00cf0"></a>

```
enum [OHOS::UITextLanguageDirect](Graphic.md#ga0c108f97781843f67c101b47b6c00cf0) : uint8_t
```

 **Description:**

Enumerates text directions. 

<a name="table1018511942084826"></a>
<table><thead align="left"><tr id="row278514482084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1952859034084826"><a name="p1952859034084826"></a><a name="p1952859034084826"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p400173645084826"><a name="p400173645084826"></a><a name="p400173645084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2071544702084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga0c108f97781843f67c101b47b6c00cf0a387cedfce95a736f28a1c2748086b1a9"><a name="gga0c108f97781843f67c101b47b6c00cf0a387cedfce95a736f28a1c2748086b1a9"></a><a name="gga0c108f97781843f67c101b47b6c00cf0a387cedfce95a736f28a1c2748086b1a9"></a></strong>TEXT_DIRECT_LTR&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p926353254084826"><a name="p926353254084826"></a><a name="p926353254084826"></a>Left-to-right </p>
 </td>
</tr>
<tr id="row476348842084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga0c108f97781843f67c101b47b6c00cf0a76658b82f45d4136910ded0c22afe7f8"><a name="gga0c108f97781843f67c101b47b6c00cf0a76658b82f45d4136910ded0c22afe7f8"></a><a name="gga0c108f97781843f67c101b47b6c00cf0a76658b82f45d4136910ded0c22afe7f8"></a></strong>TEXT_DIRECT_RTL&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1874220645084826"><a name="p1874220645084826"></a><a name="p1874220645084826"></a>Right-to-left </p>
 </td>
</tr>
</tbody>
</table>

## WorkMode<a name="ga19db90932bc71e6bbced6ccf2935ac98"></a>

```
enum [OHOS::UIAbstractClock::WorkMode](Graphic.md#ga19db90932bc71e6bbced6ccf2935ac98)
```

 **Description:**

Enumerates the working modes of this clock. 

<a name="table1005962570084826"></a>
<table><thead align="left"><tr id="row347719236084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1953077823084826"><a name="p1953077823084826"></a><a name="p1953077823084826"></a>Enumerator</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p814103779084826"><a name="p814103779084826"></a><a name="p814103779084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1506660835084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga19db90932bc71e6bbced6ccf2935ac98a2025ac1a1f63409f0b37f444547ec859"><a name="gga19db90932bc71e6bbced6ccf2935ac98a2025ac1a1f63409f0b37f444547ec859"></a><a name="gga19db90932bc71e6bbced6ccf2935ac98a2025ac1a1f63409f0b37f444547ec859"></a></strong>ALWAYS_ON&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p1274051443084826"><a name="p1274051443084826"></a><a name="p1274051443084826"></a>Always on (drawing not updated) </p>
 </td>
</tr>
<tr id="row994883149084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 "><strong id="gga19db90932bc71e6bbced6ccf2935ac98a8d32f103a422c6675618f5e9773b2eaa"><a name="gga19db90932bc71e6bbced6ccf2935ac98a8d32f103a422c6675618f5e9773b2eaa"></a><a name="gga19db90932bc71e6bbced6ccf2935ac98a8d32f103a422c6675618f5e9773b2eaa"></a></strong>NORMAL&nbsp;</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 "><p id="p145999687084826"><a name="p145999687084826"></a><a name="p145999687084826"></a>Normal (drawing updated with the time change) </p>
 </td>
</tr>
</tbody>
</table>

## **Function Documentation**<a name="section1887010649084826"></a>

## AbstractAdapter\(\)<a name="gab60e1c77fb98352bd62e56b550d75d88"></a>

```
OHOS::AbstractAdapter::AbstractAdapter ()
```

 **Description:**

A constructor used to create an  **[AbstractAdapter](OHOS-AbstractAdapter.md)**  instance. 

## Add\(\) \[1/3\]<a name="ga8b60ed045dc2a3370498a3e6922d5400"></a>

```
void OHOS::AnimatorManager::Add ([Animator](OHOS-Animator.md) * animator)
```

 **Description:**

Adds the  **[Animator](OHOS-Animator.md)**  instance to the  **[AnimatorManager](OHOS-AnimatorManager.md)**  linked list for management, so that the  **Run**  function of the  **[Animator](OHOS-Animator.md)**  class is called once for each frame. 

**Parameters:**

<a name="table1331948372084826"></a>
<table><thead align="left"><tr id="row675391711084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1502250981084826"><a name="p1502250981084826"></a><a name="p1502250981084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p994777722084826"><a name="p994777722084826"></a><a name="p994777722084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row19078666084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">animator</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the <strong id="b654797663084826"><a name="b654797663084826"></a><a name="b654797663084826"></a><a href="OHOS-Animator.md">Animator</a></strong> instance to add. </td>
</tr>
</tbody>
</table>

**See also:**

[Remove](Graphic.md#ga493d53a9e4a47b79d30c0d37f96a69da) 

## Add\(\) \[2/3\]<a name="gacf5db120308ac7783c493f5437f06cee"></a>

```
virtual void OHOS::UIViewGroup::Add ([UIView](OHOS-UIView.md) * view)
```

 **Description:**

Adds a child view. 

Reimplemented in  [OHOS::UISwipeView](Graphic.md#ga1cdc37a33412d6134ed7214300bc1c87).

**Parameters:**

<a name="table105793320084826"></a>
<table><thead align="left"><tr id="row961454003084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1181905883084826"><a name="p1181905883084826"></a><a name="p1181905883084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p985164675084826"><a name="p985164675084826"></a><a name="p985164675084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1471513854084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">view</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the child view to add. </td>
</tr>
</tbody>
</table>

## Add\(\) \[3/3\]<a name="ga1cdc37a33412d6134ed7214300bc1c87"></a>

```
void OHOS::UISwipeView::Add ([UIView](OHOS-UIView.md) * view)
```

 **Description:**

Adds a view. 

Reimplemented from  [OHOS::UIViewGroup](Graphic.md#gacf5db120308ac7783c493f5437f06cee).

**Parameters:**

<a name="table231169661084826"></a>
<table><thead align="left"><tr id="row682608103084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1282357585084826"><a name="p1282357585084826"></a><a name="p1282357585084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p476121696084826"><a name="p476121696084826"></a><a name="p476121696084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1284057594084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">view</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the view to add. </td>
</tr>
</tbody>
</table>

## AddDataSerial\(\)<a name="gafc510047aac4e7eebd5b229e726ef762"></a>

```
virtual bool OHOS::UIChart::AddDataSerial ([UIChartDataSerial](OHOS-UIChartDataSerial.md) * dataSerial)
```

 **Description:**

Adds a data set. 

**Parameters:**

<a name="table379985020084826"></a>
<table><thead align="left"><tr id="row1282636039084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p354298126084826"><a name="p354298126084826"></a><a name="p354298126084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p487249080084826"><a name="p487249080084826"></a><a name="p487249080084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1233439844084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dataSerial</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the data set class. For details, see <a href="OHOS-UIChartDataSerial.md">UIChartDataSerial</a>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the data set is added successfully; returns  **false**  otherwise. 

**See also:**

[DeleteDataSerial](Graphic.md#ga2af81fbcd6a17ef250bf07e2d7606b8d) 

## AddPoints\(\)<a name="ga88d554725405cf9c501f145a25448238"></a>

```
bool OHOS::UIChartDataSerial::AddPoints (const [Point](OHOS-Point.md) * data, uint16_t count )
```

 **Description:**

Adds data points. 

The new data points are appended to the last added data. No more data points can be added if the maximum number is reached 

**Parameters:**

<a name="table1908641839084826"></a>
<table><thead align="left"><tr id="row1778224081084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p760629739084826"><a name="p760629739084826"></a><a name="p760629739084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p100887231084826"><a name="p100887231084826"></a><a name="p100887231084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row688125041084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">data</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the start address of the data point. </td>
</tr>
<tr id="row1833978810084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">count</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the number of data points to add. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the data points are added successfully; returns  **false**  otherwise. 



## AlignBottomToSibling\(\)<a name="ga7607c3f9661932c495d080e9d92fb1a3"></a>

```
void OHOS::UIView::AlignBottomToSibling (const char * id, int16_t offset = [/topic/body/section/screen/code
     {""}) 0 (code] )
```

 **Description:**

Aligns the view with the bottom of a sibling view. 

**Parameters:**

<a name="table279844128084826"></a>
<table><thead align="left"><tr id="row622871210084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p802816102084826"><a name="p802816102084826"></a><a name="p802816102084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p342708613084826"><a name="p342708613084826"></a><a name="p342708613084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1572869284084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the ID of the sibling view. </td>
</tr>
<tr id="row1551670404084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the offset added to the y-axis after the view is placed. A positive number indicates the offset to the top, and a negative number indicates the offset to the bottom. </td>
</tr>
</tbody>
</table>

## AlignHorCenterToSibling\(\)<a name="gac23776dbc2fce7ff30d57438abfa5230"></a>

```
void OHOS::UIView::AlignHorCenterToSibling (const char * id, int16_t offset = [/topic/body/section/screen/code
     {""}) 0 (code] )
```

 **Description:**

Aligns the view with the center of a sibling view in the x-axis. 

**Parameters:**

<a name="table464895874084826"></a>
<table><thead align="left"><tr id="row967645515084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1879072169084826"><a name="p1879072169084826"></a><a name="p1879072169084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1906048839084826"><a name="p1906048839084826"></a><a name="p1906048839084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1660991592084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the ID of the sibling view. </td>
</tr>
<tr id="row1589566294084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the offset added to the x-axis after the view is placed. A positive number indicates the offset to the right, and a negative number indicates the offset to the left. </td>
</tr>
</tbody>
</table>

## AlignLeftToSibling\(\)<a name="gac7f5f2584c716a56fee3783f8dea6246"></a>

```
void OHOS::UIView::AlignLeftToSibling (const char * id, int16_t offset = [/topic/body/section/screen/code
     {""}) 0 (code] )
```

 **Description:**

Aligns the view with the left of a sibling view. 

**Parameters:**

<a name="table898067142084826"></a>
<table><thead align="left"><tr id="row459153003084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1654990019084826"><a name="p1654990019084826"></a><a name="p1654990019084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1595703320084826"><a name="p1595703320084826"></a><a name="p1595703320084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1219620714084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the ID of the sibling view. </td>
</tr>
<tr id="row1778420747084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the offset added to the x-axis after the view is placed. A positive number indicates the offset to the right, and a negative number indicates the offset to the left. </td>
</tr>
</tbody>
</table>

## AlignRightToSibling\(\)<a name="gabb1ac454cdf95593c1e387d5e272433c"></a>

```
void OHOS::UIView::AlignRightToSibling (const char * id, int16_t offset = [/topic/body/section/screen/code
     {""}) 0 (code] )
```

 **Description:**

Aligns the view with the right of a sibling view. 

**Parameters:**

<a name="table1408723963084826"></a>
<table><thead align="left"><tr id="row1602474918084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1982042203084826"><a name="p1982042203084826"></a><a name="p1982042203084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p2046919525084826"><a name="p2046919525084826"></a><a name="p2046919525084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row772264262084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the ID of the sibling view. </td>
</tr>
<tr id="row888024605084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the offset added to the x-axis after the view is placed. A positive number indicates the offset to the left, and a negative number indicates the offset to the right. </td>
</tr>
</tbody>
</table>

## AlignTopToSibling\(\)<a name="ga903d7cbc59bac06d728b7f6435c9a504"></a>

```
void OHOS::UIView::AlignTopToSibling (const char * id, int16_t offset = [/topic/body/section/screen/code
     {""}) 0 (code] )
```

 **Description:**

Aligns the view with the top of a sibling view. 

**Parameters:**

<a name="table1325363413084826"></a>
<table><thead align="left"><tr id="row1900600362084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p222446494084826"><a name="p222446494084826"></a><a name="p222446494084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1390480539084826"><a name="p1390480539084826"></a><a name="p1390480539084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row194153268084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the ID of the sibling view. </td>
</tr>
<tr id="row1881700632084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the offset added to the y-axis after the view is placed. A positive number indicates the offset to the bottom, and a negative number indicates the offset to the top. </td>
</tr>
</tbody>
</table>

## AlignVerCenterToSibling\(\)<a name="gad3caa27aa0cb73ec4656e7d23aa222de"></a>

```
void OHOS::UIView::AlignVerCenterToSibling (const char * id, int16_t offset = [/topic/body/section/screen/code
     {""}) 0 (code] )
```

 **Description:**

Aligns the view with the center of a sibling view in the y-axis. 

**Parameters:**

<a name="table1816903150084826"></a>
<table><thead align="left"><tr id="row1432386632084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1919254702084826"><a name="p1919254702084826"></a><a name="p1919254702084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p34855831084826"><a name="p34855831084826"></a><a name="p34855831084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row795758844084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">id</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the ID of the sibling view. </td>
</tr>
<tr id="row1117121580084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">offset</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the offset added to the y-axis after the view is placed. A positive number indicates the offset to the bottom, and a negative number indicates the offset to the top. </td>
</tr>
</tbody>
</table>

## Animator\(\) \[1/2\]<a name="gabcc3afbe99010e70e3e6dbd780cb5974"></a>

```
OHOS::Animator::Animator ()
```

 **Description:**

A default constructor used to create an  **[Animator](OHOS-Animator.md)**  instance. 

## Animator\(\) \[2/2\]<a name="ga79be500c40ba8743dd58dc633a732b53"></a>

```
OHOS::Animator::Animator ([AnimatorCallback](OHOS-AnimatorCallback.md) * callback, [UIView](OHOS-UIView.md) * view, uint32_t time, bool repeat )
```

 **Description:**

A constructor used to create an  **[Animator](OHOS-Animator.md)**  instance. 

**Parameters:**

<a name="table1219903095084826"></a>
<table><thead align="left"><tr id="row523195753084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1017150605084826"><a name="p1017150605084826"></a><a name="p1017150605084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1003818742084826"><a name="p1003818742084826"></a><a name="p1003818742084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1829237258084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">callback</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the animator callback for producing animator effects. For details, see <a href="OHOS-AnimatorCallback.md">AnimatorCallback</a>. </td>
</tr>
<tr id="row931131236084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">view</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the <strong id="b409112137084826"><a name="b409112137084826"></a><a name="b409112137084826"></a><a href="OHOS-UIView.md">UIView</a></strong> instance bound to an animator, which can be used when invoking the animator callback. </td>
</tr>
<tr id="row607137265084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">time</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the duration of this animator, in milliseconds. </td>
</tr>
<tr id="row229929089084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">repeat</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Specifies whether to repeat this animator. <strong id="b1856734740084826"><a name="b1856734740084826"></a><a name="b1856734740084826"></a>true</strong> indicates the animator is repeated, and <strong id="b58487624084826"><a name="b58487624084826"></a><a name="b58487624084826"></a>false</strong> (default value) indicates the animator is played once. </td>
</tr>
</tbody>
</table>

## Aqua\(\)<a name="ga24da6b938c938b3defeb56ff79a4c4f5"></a>

```
static [ColorType](OHOS-Color32.md) OHOS::Color::Aqua ()
```

 **Description:**

Obtains the color data of aqua. 

**Returns:**

Returns the color data. 



## Back\(\)<a name="gae5c3f6272b58c45f458c475a79ebfe3d"></a>

```
const T [OHOS::List](OHOS-List-T.md)< T >::Back () const
```

 **Description:**

Obtains the tail node data of a linked list. 

**Returns:**

Returns the tail node data. 



## BackEaseIn\(\)<a name="ga4598524b16a33de497fa9321d887d3b1"></a>

```
static int16_t OHOS::EasingEquation::BackEaseIn (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime )
```

 **Description:**

Eases in with an overshoot. 

**\(s+1\)\*t^3 - s\*t^2**  is the equation for a back easing. The animation moves back slightly at the beginning and then accelerates towards the end.

**Parameters:**

<a name="table1327596990084826"></a>
<table><thead align="left"><tr id="row119096529084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p146581600084826"><a name="p146581600084826"></a><a name="p146581600084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p408572800084826"><a name="p408572800084826"></a><a name="p408572800084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row789052783084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start value of this animation. </td>
</tr>
<tr id="row1828833648084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end value of this animation. </td>
</tr>
<tr id="row1400872754084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the current time of this animation. </td>
</tr>
<tr id="row437217552084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">durationTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total duration of this animation.</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the value for the current time. 

**See also:**

[SetBackOvershoot](Graphic.md#gab7cf0e64a0d363d8b448262d719ac97a)  |  [BackEaseOut](Graphic.md#ga7399f01f7abc33413bf25aa17a99c2f2)  |  [BackEaseInOut](Graphic.md#gac7c2a9a1dfce384438a3bd9d6c0c2525) 

## BackEaseInOut\(\)<a name="gac7c2a9a1dfce384438a3bd9d6c0c2525"></a>

```
static int16_t OHOS::EasingEquation::BackEaseInOut (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime )
```

 **Description:**

Eases in and then out with an overshoot. 

**\(s+1\)\*t^3 - s\*t^2**  is the equation for a back easing. The animation slightly moves back at the beginning, goes towards the end, slightly exceeds it and finally comes back.

**Parameters:**

<a name="table2031237760084826"></a>
<table><thead align="left"><tr id="row1297260184084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p496276176084826"><a name="p496276176084826"></a><a name="p496276176084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1467072776084826"><a name="p1467072776084826"></a><a name="p1467072776084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1222288265084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start value of this animation. </td>
</tr>
<tr id="row1438207684084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end value of this animation. </td>
</tr>
<tr id="row34909998084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the current time of this animation. </td>
</tr>
<tr id="row963873994084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">durationTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total duration of this animation.</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the value for the current time. 

**See also:**

[SetBackOvershoot](Graphic.md#gab7cf0e64a0d363d8b448262d719ac97a)  |  [BackEaseIn](Graphic.md#ga4598524b16a33de497fa9321d887d3b1)  |  [BackEaseOut](Graphic.md#ga7399f01f7abc33413bf25aa17a99c2f2) 

## BackEaseOut\(\)<a name="ga7399f01f7abc33413bf25aa17a99c2f2"></a>

```
static int16_t OHOS::EasingEquation::BackEaseOut (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime )
```

 **Description:**

Eases out with an overshoot. 

**\(s+1\)\*t^3 - s\*t^2**  is the equation for a back easing. The animation moves towards the end, slightly exceeds it and finally comes back.

**Parameters:**

<a name="table901912519084826"></a>
<table><thead align="left"><tr id="row1433924937084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p683463258084826"><a name="p683463258084826"></a><a name="p683463258084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1899130521084826"><a name="p1899130521084826"></a><a name="p1899130521084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1851307679084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start value of this animation. </td>
</tr>
<tr id="row1098155692084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end value of this animation. </td>
</tr>
<tr id="row669370944084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the current time of this animation. </td>
</tr>
<tr id="row1117664923084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">durationTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total duration of this animation.</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the value for the current time. 

**See also:**

[SetBackOvershoot](Graphic.md#gab7cf0e64a0d363d8b448262d719ac97a)  |  [BackEaseIn](Graphic.md#ga4598524b16a33de497fa9321d887d3b1)  |  [BackEaseInOut](Graphic.md#gac7c2a9a1dfce384438a3bd9d6c0c2525) 

## Begin\(\)<a name="ga8fe8647f764773c29d3fa70c9b70eb2a"></a>

```
[ListNode](OHOS-ListNode-T.md)<T>* [OHOS::List](OHOS-List-T.md)< T >::Begin () const
```

 **Description:**

Obtains the head node address of a linked list. 

**Returns:**

Returns the head node address. 



## Black\(\)<a name="gac821c879969c94ec048117738e4bbef2"></a>

```
static [ColorType](OHOS-Color32.md) OHOS::Color::Black ()
```

 **Description:**

Obtains the color data of black. 

**Returns:**

Returns the color data. 



## Blue\(\)<a name="ga3b02160a068039d3801580c8e35008b4"></a>

```
static [ColorType](OHOS-Color32.md) OHOS::Color::Blue ()
```

 **Description:**

Obtains the color data of blue. 

**Returns:**

Returns the color data. 



## Callback\(\)<a name="gace3debcfa4200de1951a8eae6421e5aa"></a>

```
virtual void OHOS::AnimatorCallback::Callback ([UIView](OHOS-UIView.md) * view)
```

 **Description:**

Called when each frame starts. This is a pure virtual function, which needs your inheritance and implementation. 

**Parameters:**

<a name="table1597284808084826"></a>
<table><thead align="left"><tr id="row1550636696084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p191225148084826"><a name="p191225148084826"></a><a name="p191225148084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p274874845084826"><a name="p274874845084826"></a><a name="p274874845084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row435571074084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">view</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the <strong id="b1158474348084826"><a name="b1158474348084826"></a><a name="b1158474348084826"></a><a href="OHOS-UIView.md">UIView</a></strong> instance, which is added from the constructor of the <strong id="b1330665373084826"><a name="b1330665373084826"></a><a name="b1330665373084826"></a><a href="OHOS-Animator.md">Animator</a></strong> class. </td>
</tr>
</tbody>
</table>

## Cancel\(\)<a name="gac838ad321786766c6d4020504b07b93b"></a>

```
void OHOS::UITextureMapper::Cancel ()
```

 **Description:**

Cancels this animator. 

After being cancelled, the animator will stop in the current playback state.

## CancelEvent\(\)<a name="gaf3b75ee84a33ffcbc640328b2747b0a1"></a>

```
OHOS::CancelEvent::CancelEvent (const [Point](OHOS-Point.md) & pos)
```

 **Description:**

A constructor used to create a  **[CancelEvent](OHOS-CancelEvent.md)**  instance. 

**Parameters:**

<a name="table738646249084826"></a>
<table><thead align="left"><tr id="row800125657084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1706145739084826"><a name="p1706145739084826"></a><a name="p1706145739084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1607243977084826"><a name="p1607243977084826"></a><a name="p1607243977084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1869951348084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the position where the cancel event occurs. </td>
</tr>
</tbody>
</table>

## CircEaseIn\(\)<a name="ga446c958f14b3d6de24e2c1bab171bba2"></a>

```
static int16_t OHOS::EasingEquation::CircEaseIn (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime )
```

 **Description:**

Eases in shaping like a circular curve. 

**sqrt\(1-t^2\)**  is the equation for a circular easing. The animation starts slowly from zero velocity and accelerates fast towards the end. The acceleration change is similar to a circular curve.

**Parameters:**

<a name="table15945792084826"></a>
<table><thead align="left"><tr id="row1558600274084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1082014441084826"><a name="p1082014441084826"></a><a name="p1082014441084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1205276009084826"><a name="p1205276009084826"></a><a name="p1205276009084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1333594945084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start value of this animation. </td>
</tr>
<tr id="row395159127084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end value of this animation. </td>
</tr>
<tr id="row1756113609084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the current time of this animation. </td>
</tr>
<tr id="row1179464837084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">durationTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total duration of this animation.</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the value for the current time. 

**See also:**

[CircEaseOut](Graphic.md#gaab8fad8664d648df7e5e224b68ee54ad)  |  [CircEaseInOut](Graphic.md#ga68c392dad14e1bef192b085aeec6ca9b) 

## CircEaseInOut\(\)<a name="ga68c392dad14e1bef192b085aeec6ca9b"></a>

```
static int16_t OHOS::EasingEquation::CircEaseInOut (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime )
```

 **Description:**

Eases in and then out shaping like a circular curve. 

**sqrt\(1-t^2\)**  is the equation for a circular easing. The animation accelerates slowly until halfway and decreases slowly towards the end. The acceleration change is similar to a circular curve.

**Parameters:**

<a name="table286565521084826"></a>
<table><thead align="left"><tr id="row487127395084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2013892158084826"><a name="p2013892158084826"></a><a name="p2013892158084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1555920619084826"><a name="p1555920619084826"></a><a name="p1555920619084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2069183369084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start value of this animation. </td>
</tr>
<tr id="row182582866084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end value of this animation. </td>
</tr>
<tr id="row779029192084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the current time of this animation. </td>
</tr>
<tr id="row1594841593084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">durationTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total duration of this animation.</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the value for the current time. 

**See also:**

[CircEaseIn](Graphic.md#ga446c958f14b3d6de24e2c1bab171bba2)  |  [CircEaseOut](Graphic.md#gaab8fad8664d648df7e5e224b68ee54ad) 

## CircEaseOut\(\)<a name="gaab8fad8664d648df7e5e224b68ee54ad"></a>

```
static int16_t OHOS::EasingEquation::CircEaseOut (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime )
```

 **Description:**

Eases out shaping like a circular curve. 

**sqrt\(1-t^2\)**  is the equation for a circular easing. The animation starts fast and decelerates slowly towards the end. The acceleration change is similar to a circular curve.

**Parameters:**

<a name="table1570047520084826"></a>
<table><thead align="left"><tr id="row592029182084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p135568792084826"><a name="p135568792084826"></a><a name="p135568792084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1198562388084826"><a name="p1198562388084826"></a><a name="p1198562388084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1148536748084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start value of this animation. </td>
</tr>
<tr id="row397397130084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end value of this animation. </td>
</tr>
<tr id="row252768216084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the current time of this animation. </td>
</tr>
<tr id="row71051950084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">durationTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total duration of this animation.</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the value for the current time. 

**See also:**

[CircEaseIn](Graphic.md#ga446c958f14b3d6de24e2c1bab171bba2)  |  [CircEaseInOut](Graphic.md#ga68c392dad14e1bef192b085aeec6ca9b) 

## Clear\(\) \[1/2\]<a name="ga2292866786c9f888bc722ffcebc7c831"></a>

```
void [OHOS::List](OHOS-List-T.md)< T >::Clear ()
```

 **Description:**

Deletes all nodes from a linked list. 

## Clear\(\) \[2/2\]<a name="ga7e20822a6c448bee724f20afad1c69d4"></a>

```
void OHOS::UICanvas::Clear ()
```

 **Description:**

Clears the entire canvas. 

## ClearData\(\)<a name="ga148d9b3933a733433a96a48b95cff844"></a>

```
void OHOS::UIChartDataSerial::ClearData ()
```

 **Description:**

Clears all data points. 

## ClearDataSerial\(\)<a name="gae2752857fbcb9f1541cd811321bfc2c6"></a>

```
virtual void OHOS::UIChart::ClearDataSerial ()
```

 **Description:**

Clears all data sets. 

## ClearOnKeyActListener\(\)<a name="ga00303597af333088c06a45346f4a77f2"></a>

```
void OHOS::RootView::ClearOnKeyActListener ()
```

 **Description:**

Clears the listener for monitoring physical key events. 

## ClearOnVirtualDeviceEventListener\(\)<a name="ga0b550a305c0cda1dc510b2446c56ed82"></a>

```
void OHOS::RootView::ClearOnVirtualDeviceEventListener ()
```

 **Description:**

Clears the listener for monitoring the input events of a virtual device. 

## ClearValues\(\)<a name="ga81e69c460191bbe3606ac540433178a1"></a>

```
virtual void OHOS::UIPicker::ClearValues ()
```

 **Description:**

Clears all values in the picker. 

## ClickEvent\(\)<a name="gaeb51d39715cc72b383ba6059bd0d1053"></a>

```
OHOS::ClickEvent::ClickEvent (const [Point](OHOS-Point.md) & pos)
```

 **Description:**

A constructor used to create a  **[ClickEvent](OHOS-ClickEvent.md)**  instance. 

**Parameters:**

<a name="table1767653008084826"></a>
<table><thead align="left"><tr id="row2080139966084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p623490456084826"><a name="p623490456084826"></a><a name="p623490456084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p863075990084826"><a name="p863075990084826"></a><a name="p863075990084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1247365219084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the position where the click event occurs. </td>
</tr>
</tbody>
</table>

## Clip\(\) \[1/2\]<a name="ga22219a4351530d5a6914bdc5dcf406d0"></a>

```
void OHOS::Clip (const [Line](OHOS-Line.md) & line, const [Polygon](OHOS-Polygon.md) & poly, [Vector2](OHOS-Vector2-T.md)< int16_t > * pOut, uint8_t * pNum )
```

 **Description:**

Clips a polygon by using a line segment and obtains the intersections. 

**Parameters:**

<a name="table950615291084826"></a>
<table><thead align="left"><tr id="row955708038084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1514466082084826"><a name="p1514466082084826"></a><a name="p1514466082084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p492697700084826"><a name="p492697700084826"></a><a name="p492697700084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row35598325084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">line</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the line segment used for clipping. </td>
</tr>
<tr id="row1871738834084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">poly</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the polygon to clip. </td>
</tr>
<tr id="row309807096084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pOut</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the intersections. </td>
</tr>
<tr id="row1746097783084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">pNum</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the number of the intersections. </td>
</tr>
</tbody>
</table>

## Clip\(\) \[2/2\]<a name="ga0001387a136a87fb2c2e2b5eb3363c72"></a>

```
void OHOS::Clip ([Polygon](OHOS-Polygon.md) & poly, const [Line](OHOS-Line.md) & line )
```

 **Description:**

Clips a polygon by using a line segment. 

**Parameters:**

<a name="table1357083135084826"></a>
<table><thead align="left"><tr id="row455501776084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p115856368084826"><a name="p115856368084826"></a><a name="p115856368084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1928389790084826"><a name="p1928389790084826"></a><a name="p1928389790084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1696211405084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">poly</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the polygon to clip. </td>
</tr>
<tr id="row2038584730084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">line</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the line segment used for clipping. </td>
</tr>
</tbody>
</table>

## ColorTo16\(\)<a name="ga2a6a0bd067a05ee35793fefc8f9f4d1e"></a>

```
static uint16_t OHOS::Color::ColorTo16 ([Color32](OHOS-Color32.md) color)
```

 **Description:**

Converts color data from the RGBA8888 format into the RGB565 format. 

**Parameters:**

<a name="table1478857166084826"></a>
<table><thead align="left"><tr id="row983864552084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p122896690084826"><a name="p122896690084826"></a><a name="p122896690084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p582281840084826"><a name="p582281840084826"></a><a name="p582281840084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1339641479084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">color</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the color data with the 32-bit color depth, which is defined by <a href="OHOS-Color32.md">Color32</a>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the RGB565 color data. 



## ColorTo32\(\) \[1/2\]<a name="gaaca42d51bc5f28d5dbd5b1635be50224"></a>

```
static uint32_t OHOS::Color::ColorTo32 ([Color16](OHOS-Color16.md) color, uint8_t alpha )
```

 **Description:**

Converts color data with the 16-bit color depth into the RGBA8888 format. 

**Parameters:**

<a name="table334060284084826"></a>
<table><thead align="left"><tr id="row1773264602084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p916376434084826"><a name="p916376434084826"></a><a name="p916376434084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p644320668084826"><a name="p644320668084826"></a><a name="p644320668084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row62057223084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">color</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the color data with the 16-bit color depth, which is defined by <a href="OHOS-Color16.md">Color16</a>. </td>
</tr>
<tr id="row721128594084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">alpha</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the alpha, that is, how opaque each pixel is. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the RGBA8888 color data. 



## ColorTo32\(\) \[2/2\]<a name="ga461b46dd76842ad4b0ffdc88202223a7"></a>

```
static uint32_t OHOS::Color::ColorTo32 ([ColorType](OHOS-Color32.md) color)
```

 **Description:**

Converts color data into the RGBA8888 format. 

The color data definition varies according to the color depth.

**Parameters:**

<a name="table1383107564084826"></a>
<table><thead align="left"><tr id="row585983334084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1069824934084826"><a name="p1069824934084826"></a><a name="p1069824934084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p532044525084826"><a name="p532044525084826"></a><a name="p532044525084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row875959370084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">color</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the color data, which is defined by <strong id="b1402176296084826"><a name="b1402176296084826"></a><a name="b1402176296084826"></a>ColorType</strong>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the RGBA8888 color data. 



## Cross\(\)<a name="gac1c8e01fd488d5f8aea6bddad1dec206"></a>

```
T [OHOS::Vector2](OHOS-Vector2-T.md)< T >::Cross (const [Vector2](OHOS-Vector2-T.md)< T > & other) const
```

 **Description:**

Calculates the cross product of the two-dimensional vector and another two-dimensional vector. 

**Parameters:**

<a name="table136951740084826"></a>
<table><thead align="left"><tr id="row1367799689084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p523655536084826"><a name="p523655536084826"></a><a name="p523655536084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p360802834084826"><a name="p360802834084826"></a><a name="p360802834084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row988272824084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">other</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the two-dimensional vector to be used for calculation. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the cross product. 



## CubicEaseIn\(\)<a name="ga5c91a83cc424fb7e4e1f40cae6b3be66"></a>

```
static int16_t OHOS::EasingEquation::CubicEaseIn (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime )
```

 **Description:**

Eases in shaping like a cubic curve. 

**t^3**  is the equation for a cubic easing. The animation starts slowly from zero velocity and accelerates fast towards the end. The acceleration change is similar to a cubic curve.

**Parameters:**

<a name="table784394905084826"></a>
<table><thead align="left"><tr id="row1295920312084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1531898757084826"><a name="p1531898757084826"></a><a name="p1531898757084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1865283607084826"><a name="p1865283607084826"></a><a name="p1865283607084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1112625526084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start value of this animation. </td>
</tr>
<tr id="row160108098084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end value of this animation. </td>
</tr>
<tr id="row4867144084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the current time of this animation. </td>
</tr>
<tr id="row128574593084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">durationTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total duration of this animation.</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the value for the current time. 

**See also:**

[CubicEaseOut](Graphic.md#ga529a948d9f6711a5f2726af5f10d7a48)  |  [CubicEaseInOut](Graphic.md#gad99ea4ed828f274f111f492eea123cb4) 

## CubicEaseInOut\(\)<a name="gad99ea4ed828f274f111f492eea123cb4"></a>

```
static int16_t OHOS::EasingEquation::CubicEaseInOut (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime )
```

 **Description:**

Eases in and then out shaping like a cubic curve. 

**t^3**  is the equation for a cubic easing. The animation accelerates slowly until halfway and decelerates slowly towards the end. The acceleration change is similar to a cubic curve.

**Parameters:**

<a name="table1588838695084826"></a>
<table><thead align="left"><tr id="row583146862084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p872487635084826"><a name="p872487635084826"></a><a name="p872487635084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p617494408084826"><a name="p617494408084826"></a><a name="p617494408084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1893313108084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start value of this animation. </td>
</tr>
<tr id="row1782897171084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end value of this animation. </td>
</tr>
<tr id="row412769530084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the current time of this animation. </td>
</tr>
<tr id="row1505949069084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">durationTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total duration of this animation.</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the value for the current time. 

**See also:**

[CubicEaseIn](Graphic.md#ga5c91a83cc424fb7e4e1f40cae6b3be66)  |  [CubicEaseOut](Graphic.md#ga529a948d9f6711a5f2726af5f10d7a48) 

## CubicEaseOut\(\)<a name="ga529a948d9f6711a5f2726af5f10d7a48"></a>

```
static int16_t OHOS::EasingEquation::CubicEaseOut (int16_t startPos, int16_t endPos, uint16_t curTime, uint16_t durationTime )
```

 **Description:**

Eases out shaping like a cubic curve. 

**t^3**  is the equation for a cubic easing. The animation starts fast and decelerates slowly towards the end. The acceleration change is similar to a cubic curve.

**Parameters:**

<a name="table1862337927084826"></a>
<table><thead align="left"><tr id="row254232854084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1966773978084826"><a name="p1966773978084826"></a><a name="p1966773978084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1015898362084826"><a name="p1015898362084826"></a><a name="p1015898362084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row2088964178084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start value of this animation. </td>
</tr>
<tr id="row1959154811084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end value of this animation. </td>
</tr>
<tr id="row896641356084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">curTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the current time of this animation. </td>
</tr>
<tr id="row705150151084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">durationTime</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the total duration of this animation.</td>
</tr>
</tbody>
</table>

**Returns:**

Returns the value for the current time. 

**See also:**

[CubicEaseIn](Graphic.md#ga5c91a83cc424fb7e4e1f40cae6b3be66)  |  [CubicEaseInOut](Graphic.md#gad99ea4ed828f274f111f492eea123cb4) 

## Cyan\(\)<a name="ga9d6b730a0799da3254543613acb0a3fa"></a>

```
static [ColorType](OHOS-Color32.md) OHOS::Color::Cyan ()
```

 **Description:**

Obtains the color data of cyan. 

**Returns:**

Returns the color data. 



## DeleteDataSerial\(\)<a name="ga2af81fbcd6a17ef250bf07e2d7606b8d"></a>

```
virtual bool OHOS::UIChart::DeleteDataSerial ([UIChartDataSerial](OHOS-UIChartDataSerial.md) * dataSerial)
```

 **Description:**

Deletes a data set. 

**Parameters:**

<a name="table971589865084826"></a>
<table><thead align="left"><tr id="row1616757594084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1720475271084826"><a name="p1720475271084826"></a><a name="p1720475271084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1369368856084826"><a name="p1369368856084826"></a><a name="p1369368856084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row287071759084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">dataSerial</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the data set class. For details, see <a href="OHOS-UIChartDataSerial.md">UIChartDataSerial</a>. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns  **true**  if the data set is deleted successfully; returns  **false**  otherwise. 

**See also:**

[AddDataSerial](Graphic.md#gafc510047aac4e7eebd5b229e726ef762) 

## Determinant\(\)<a name="ga5464ffd57d0abbd0381b2a6cf3a7d2fb"></a>

```
T [OHOS::Matrix3](OHOS-Matrix3-T.md)< T >::Determinant
```

 **Description:**

Obtains the determinant of the matrix. 

**Returns:**

Returns the determinant. 



## Disable\(\)<a name="ga283131701e907e586964189818d04411"></a>

```
void OHOS::UIButton::Disable ()
```

 **Description:**

Disables this button. 

## DisplayLeadingZero\(\)<a name="gaf45e9196d307551e693807cae2f8b4d2"></a>

```
void OHOS::UIDigitalClock::DisplayLeadingZero (bool displayLeadingZero)
```

 **Description:**

Sets whether to add  **0**  before the hour of this digital clock. 

**Parameters:**

<a name="table550116625084826"></a>
<table><thead align="left"><tr id="row1110399246084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1956542147084826"><a name="p1956542147084826"></a><a name="p1956542147084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p109453993084826"><a name="p109453993084826"></a><a name="p109453993084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1194213883084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">displayLeadingZero</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Specifies whether to add <strong id="b1673222087084826"><a name="b1673222087084826"></a><a name="b1673222087084826"></a>0</strong> before the hour of this digital clock. <strong id="b841954696084826"><a name="b841954696084826"></a><a name="b841954696084826"></a>true</strong> indicates that <strong id="b796971721084826"><a name="b796971721084826"></a><a name="b796971721084826"></a>0</strong> is added, and <strong id="b1206341107084826"><a name="b1206341107084826"></a><a name="b1206341107084826"></a>false</strong> indicates the opposite case. </td>
</tr>
</tbody>
</table>

## Dot\(\)<a name="gae45c198b5bcb73ecac8d654c281bc21a"></a>

```
T [OHOS::Vector2](OHOS-Vector2-T.md)< T >::Dot (const [Vector2](OHOS-Vector2-T.md)< T > & other) const
```

 **Description:**

Calculates the scalar product of the two-dimensional vector and another two-dimensional vector. 

**Parameters:**

<a name="table1544373574084826"></a>
<table><thead align="left"><tr id="row1601194700084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1712269157084826"><a name="p1712269157084826"></a><a name="p1712269157084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1085703621084826"><a name="p1085703621084826"></a><a name="p1085703621084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1520816407084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">other</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the two-dimensional vector to be used for calculation. </td>
</tr>
</tbody>
</table>

**Returns:**

Returns the scalar product. 



## DragEvent\(\)<a name="gae9af79f667fc1324739d2a07fdd5d94e"></a>

```
OHOS::DragEvent::DragEvent (const [Point](OHOS-Point.md) & newPos, const [Point](OHOS-Point.md) & lastPos, const [Point](OHOS-Point.md) & totalLen )
```

 **Description:**

A constructor used to create a  **[DragEvent](OHOS-DragEvent.md)**  instance. 

**Parameters:**

<a name="table824927224084826"></a>
<table><thead align="left"><tr id="row1691550402084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p2035063657084826"><a name="p2035063657084826"></a><a name="p2035063657084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p210896302084826"><a name="p210896302084826"></a><a name="p210896302084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row597842069084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">newPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the new position in the drag event. </td>
</tr>
<tr id="row2007586647084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">lastPos</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the last position in the drag event. </td>
</tr>
<tr id="row1062023289084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">totalLen</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the distance that the view has been dragged, including the movement on the x-axis and y-axis. </td>
</tr>
</tbody>
</table>

## DrawArc\(\)<a name="ga620028da5c71f96416becc877331ba6c"></a>

```
void OHOS::UICanvas::DrawArc (const [Point](OHOS-Point.md) & center, uint16_t radius, int16_t startAngle, int16_t endAngle, const [Paint](OHOS-Paint.md) & paint )
```

 **Description:**

Draws an arc. 

Only stroke is supported. When the start angle is smaller than the end angle, the sector is drawn clockwise. Otherwise, the sector is drawn counterclockwise. 

**Parameters:**

<a name="table355158131084826"></a>
<table><thead align="left"><tr id="row339462204084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1007685237084826"><a name="p1007685237084826"></a><a name="p1007685237084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p913276991084826"><a name="p913276991084826"></a><a name="p913276991084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1120458315084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">center</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the arc's center. </td>
</tr>
<tr id="row1778347349084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">radius</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the radius of the arc. </td>
</tr>
<tr id="row2000872712084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startAngle</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the start angle of the arc. Value <strong id="b1457284605084826"><a name="b1457284605084826"></a><a name="b1457284605084826"></a>0</strong> indicates the 12-o'clock direction, and <strong id="b780742826084826"><a name="b780742826084826"></a><a name="b780742826084826"></a>90</strong> indicates the 3-o'clock direction. </td>
</tr>
<tr id="row1506046530084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endAngle</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end angle of the arc. Value <strong id="b638429929084826"><a name="b638429929084826"></a><a name="b638429929084826"></a>0</strong> indicates the 12-o'clock direction, and <strong id="b712797404084826"><a name="b712797404084826"></a><a name="b712797404084826"></a>90</strong> indicates the 3-o'clock direction. </td>
</tr>
<tr id="row1733276563084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">paint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the arc style. For details, see <a href="OHOS-Paint.md">Paint</a>. </td>
</tr>
</tbody>
</table>

## DrawCircle\(\)<a name="ga974544e34560d0f9d6e162c528fcd7af"></a>

```
void OHOS::UICanvas::DrawCircle (const [Point](OHOS-Point.md) & center, uint16_t radius, const [Paint](OHOS-Paint.md) & paint )
```

 **Description:**

Draws a circle. 

**Parameters:**

<a name="table2105526447084826"></a>
<table><thead align="left"><tr id="row1579787662084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p799441671084826"><a name="p799441671084826"></a><a name="p799441671084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1668535664084826"><a name="p1668535664084826"></a><a name="p1668535664084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1562152745084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">center</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the circle center. </td>
</tr>
<tr id="row1492583114084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">radius</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the radius of the circle. </td>
</tr>
<tr id="row2080418488084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">paint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the circle style. For details, see <a href="OHOS-Paint.md">Paint</a>. </td>
</tr>
</tbody>
</table>

## DrawCurve\(\) \[1/2\]<a name="gab6557ddb74b721e4eba6cdabab954a3b"></a>

```
void OHOS::UICanvas::DrawCurve (const [Point](OHOS-Point.md) & control1, const [Point](OHOS-Point.md) & control2, const [Point](OHOS-Point.md) & endPoint, const [Paint](OHOS-Paint.md) & paint )
```

 **Description:**

Draws a cubic Bezier curve. 

If  [SetStartPosition](Graphic.md#gaca35fe1a1d344eab80ecb1425a74a91a)  is not used to set the coordinates of the start point of the curve, the drawing starts from the end point of the last line. Currently, the opacity cannot be set, and the maximum line width is  **3**.

**Parameters:**

<a name="table316495826084826"></a>
<table><thead align="left"><tr id="row1860390282084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1329423829084826"><a name="p1329423829084826"></a><a name="p1329423829084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1551110862084826"><a name="p1551110862084826"></a><a name="p1551110862084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1351093847084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">control1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the first control point of the cubic Bezier curve. </td>
</tr>
<tr id="row1104526104084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">control2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the second control point of the cubic Bezier curve. </td>
</tr>
<tr id="row713124680084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPoint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the end point of the cubic Bezier curve. </td>
</tr>
<tr id="row227847900084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">paint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the curve style. For details, see <a href="OHOS-Paint.md">Paint</a>. </td>
</tr>
</tbody>
</table>

## DrawCurve\(\) \[2/2\]<a name="gad186e8eab51e97a4854d3a757a3becfb"></a>

```
void OHOS::UICanvas::DrawCurve (const [Point](OHOS-Point.md) & startPoint, const [Point](OHOS-Point.md) & control1, const [Point](OHOS-Point.md) & control2, const [Point](OHOS-Point.md) & endPoint, const [Paint](OHOS-Paint.md) & paint )
```

 **Description:**

Draws a cubic Bezier curve from the start point coordinates. 

Currently, the opacity cannot be set, and the maximum line width is  **3**.

**Parameters:**

<a name="table511079866084826"></a>
<table><thead align="left"><tr id="row2001051536084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1128214850084826"><a name="p1128214850084826"></a><a name="p1128214850084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p1895013113084826"><a name="p1895013113084826"></a><a name="p1895013113084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row81193692084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPoint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the start point of the cubic Bezier curve. </td>
</tr>
<tr id="row148546235084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">control1</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the first control point of the cubic Bezier curve. </td>
</tr>
<tr id="row930435468084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">control2</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the second control point of the cubic Bezier curve. </td>
</tr>
<tr id="row1315924249084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPoint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the end point of the cubic Bezier curve. </td>
</tr>
<tr id="row691089113084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">paint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the curve style. For details, see <a href="OHOS-Paint.md">Paint</a>. </td>
</tr>
</tbody>
</table>

## DrawImage\(\)<a name="gad5810166b3e02f41319dd4f4229c516c"></a>

```
void OHOS::UICanvas::DrawImage (const [Point](OHOS-Point.md) & startPoint, const char * image, const [Paint](OHOS-Paint.md) & paint )
```

 **Description:**

Draws an image. 

**Parameters:**

<a name="table1852730208084826"></a>
<table><thead align="left"><tr id="row1699312080084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p732412319084826"><a name="p732412319084826"></a><a name="p732412319084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p514450654084826"><a name="p514450654084826"></a><a name="p514450654084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1865403150084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPoint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the start point. </td>
</tr>
<tr id="row1298799857084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">image</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the image source. </td>
</tr>
<tr id="row1476391918084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">paint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the image style. For details, see <a href="OHOS-Paint.md">Paint</a>. </td>
</tr>
</tbody>
</table>

## DrawLabel\(\)<a name="ga32d815e5a459b4a866217a7c5c4bb425"></a>

```
void OHOS::UICanvas::DrawLabel (const [Point](OHOS-Point.md) & startPoint, const char * text, uint16_t maxWidth, const [FontStyle](OHOS-UICanvas-FontStyle.md) & fontStyle, const [Paint](OHOS-Paint.md) & paint )
```

 **Description:**

Draws text. 

Only fill is supported. If the text length exceeds the value of  **maxWidth**, the text will be truncated. 

**Parameters:**

<a name="table1933348167084826"></a>
<table><thead align="left"><tr id="row559589741084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1190468978084826"><a name="p1190468978084826"></a><a name="p1190468978084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p850756648084826"><a name="p850756648084826"></a><a name="p850756648084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row107106196084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPoint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the start point. </td>
</tr>
<tr id="row1342062883084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">text</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the pointer to the text content. </td>
</tr>
<tr id="row998384344084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">maxWidth</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the maximum width of the text that can be displayed. If the maximum width is exceeded, the text is truncated. </td>
</tr>
<tr id="row601259675084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">fontStyle</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the text layout and font style. For details, see <a href="OHOS-UICanvas-FontStyle.md">FontStyle</a>. </td>
</tr>
<tr id="row302705223084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">paint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the text style. For details, see <a href="OHOS-Paint.md">Paint</a>. </td>
</tr>
</tbody>
</table>

## DrawLine\(\) \[1/2\]<a name="gac97d9d39484e5a1e36273510ae47327e"></a>

```
void OHOS::UICanvas::DrawLine (const [Point](OHOS-Point.md) & endPoint, const [Paint](OHOS-Paint.md) & paint )
```

 **Description:**

Draws a straight line. 

If  [SetStartPosition](Graphic.md#gaca35fe1a1d344eab80ecb1425a74a91a)  is not used to set the coordinates of the start point of the line, the drawing starts from the end point of the last line.

**Parameters:**

<a name="table980567863084826"></a>
<table><thead align="left"><tr id="row175768578084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p1300933971084826"><a name="p1300933971084826"></a><a name="p1300933971084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p532237932084826"><a name="p532237932084826"></a><a name="p532237932084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1604685356084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPoint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the end point of the straight line. </td>
</tr>
<tr id="row1230302947084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">paint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the straight line style. For details, see <a href="OHOS-Paint.md">Paint</a>. </td>
</tr>
</tbody>
</table>

## DrawLine\(\) \[2/2\]<a name="ga0c5e94526dab6a62d6db0a67385104db"></a>

```
void OHOS::UICanvas::DrawLine (const [Point](OHOS-Point.md) & startPoint, const [Point](OHOS-Point.md) & endPoint, const [Paint](OHOS-Paint.md) & paint )
```

 **Description:**

Draws a straight line from the coordinates of the start point. 

**Parameters:**

<a name="table1232533313084826"></a>
<table><thead align="left"><tr id="row1497290513084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p440917061084826"><a name="p440917061084826"></a><a name="p440917061084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p723799826084826"><a name="p723799826084826"></a><a name="p723799826084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row1860889678084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPoint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the start point. </td>
</tr>
<tr id="row1772664913084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">endPoint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the end point. </td>
</tr>
<tr id="row954891145084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">paint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the straight line style. For details, see <a href="OHOS-Paint.md">Paint</a>. </td>
</tr>
</tbody>
</table>

## DrawRect\(\)<a name="ga1cc0bc88810cdd5554e2b1b14e68c279"></a>

```
void OHOS::UICanvas::DrawRect (const [Point](OHOS-Point.md) & startPoint, int16_t height, int16_t width, const [Paint](OHOS-Paint.md) & paint )
```

 **Description:**

Draws a rectangle. 

**Parameters:**

<a name="table1063671680084826"></a>
<table><thead align="left"><tr id="row718462553084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p306074333084826"><a name="p306074333084826"></a><a name="p306074333084826"></a>Name</p>
</th>
<th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.2"><p id="p543560376084826"><a name="p543560376084826"></a><a name="p543560376084826"></a>Description</p>
</th>
</tr>
</thead>
<tbody><tr id="row489382770084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">startPoint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the coordinates of the point at the upper left corner of the rectangle. </td>
</tr>
<tr id="row1335807577084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">height</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the height of the rectangle. </td>
</tr>
<tr id="row1428864069084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">width</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the width of the rectangle. </td>
</tr>
<tr id="row514865364084826"><td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.1 ">paint</td>
<td class="cellrowborder" valign="top" width="50%" headers="mcps1.1.3.1.2 ">Indicates the rectangle style. For details, see <a href="OHOS-Paint.md">Paint</a>. </td>
</tr>
</tbody>
</table>

## DrawSector\(\)<a name="gaf14bc2633c51a16097c3ad35e8bcb314"></a>

```
void OHOS::UICanvas::DrawSector (const [Point](OHOS-Point.md) & center, uint16_t radius, int16_t startAngle, int16_t endAngle, const [Paint](OHOS-Paint.md) & paint )
```

 **Description:**

Draws a sector. 

When the start angle is smaller than the end angle, the sector is drawn clockwise. Otherwise, the sector is drawn counterclockwise.

**Parameters:**

<a name="table416409128084826"></a>
<table><thead align="left"><tr id="row1595094906084826"><th class="cellrowborder" valign="top" width="50%" id="mcps1.1.3.1.1"><p id="p468651607084826"><a name="p468651607084826"></a><a name="p