/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import macromedia.asc.parser.Tokens;

public final class Token {
    private int tokenClass;
    private String lexeme;

    public Token(int tokenClass, String lexeme) {
        if (tokenClass != -118 && lexeme.indexOf("\\u") != -1) {
            StringBuffer buffer = new StringBuffer();
            int len = lexeme.length();
            for (int x = 0; x < len; ++x) {
                if (x + 2 < len && lexeme.charAt(x) == '\\' && lexeme.charAt(x + 1) == 'u') {
                    int digit;
                    int y;
                    if (x != 0 && lexeme.charAt(x - 1) == '\\') {
                        buffer.append(lexeme.charAt(x));
                        continue;
                    }
                    int thisChar = 0;
                    for (y = x + 2; y < x + 6 && y < len && (digit = Character.digit(lexeme.charAt(y), 16)) != -1; ++y) {
                        thisChar = (thisChar << 4) + digit;
                    }
                    if (y != x + 6 || !Character.isDefined((char)thisChar)) {
                        buffer.append(lexeme.charAt(++x));
                        continue;
                    }
                    char c = (char)thisChar;
                    buffer.append(c);
                    x += 5;
                    continue;
                }
                buffer.append(lexeme.charAt(x));
            }
            this.tokenClass = tokenClass;
            this.lexeme = buffer.toString();
        } else {
            this.tokenClass = tokenClass;
            this.lexeme = lexeme;
        }
    }

    public int getTokenClass() {
        return this.tokenClass;
    }

    public String getTokenText() {
        if (this.tokenClass == -118) {
            return this.lexeme.length() == 1 ? "" : this.lexeme.substring(1, this.lexeme.length() - 1);
        }
        return this.lexeme;
    }

    public String getTokenSource() {
        return this.lexeme;
    }

    public static String getTokenClassName(int token_class) {
        int temp = -1 * token_class;
        return Tokens.tokenClassNames[temp];
    }

    public boolean equals(Object obj) {
        return this.tokenClass == ((Token)obj).tokenClass && this.lexeme.equals(((Token)obj).lexeme);
    }
}

