/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.embedding;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import macromedia.asc.embedding.Compiler;
import macromedia.asc.embedding.CompilerPlug;
import macromedia.asc.embedding.IncludeInfo;
import macromedia.asc.embedding.SanityCompilerHandler;
import macromedia.asc.embedding.avmplus.Features;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.ObjectList;

public class Main {
    static boolean show_parsetrees = false;
    static boolean show_instructions = false;
    static boolean show_linenums = false;
    static boolean show_bytes = false;
    static boolean show_machinecode = false;
    static boolean show_flow = false;
    static boolean emit_debug_info = false;
    static boolean emit_doc_info = false;
    static boolean do_test = false;
    static boolean do_help = false;
    static boolean filespecFound = false;
    static boolean make_movieclip = false;
    static boolean lint_mode = false;
    static boolean use_static_semantics = false;
    static boolean sanity_mode = false;
    static boolean emit_metadata = false;
    static boolean log = false;
    static PrintStream stderr = System.err;
    static int earliest_dialect = 7;
    static int latest_dialect = 10;
    static int default_dialect;
    static int dialect;
    static boolean optimize;
    static ObjectList<String> include_filespecs;
    static ObjectList<String> import_filespecs;
    static String swf_options;
    static String language;
    static String avmplus_exe;

    public static void main(String[] args) throws Exception {
        String filename = "";
        String ext = "";
        if (args.length == 0) {
            do_help = true;
        } else {
            block22: for (int i = 0; i < args.length; ++i) {
                String flag = args[i];
                if (flag.charAt(0) == '-') {
                    switch (flag.charAt(1)) {
                        case '!': {
                            use_static_semantics = true;
                            break;
                        }
                        case 'b': {
                            show_bytes = true;
                            break;
                        }
                        case 'f': {
                            show_flow = true;
                            break;
                        }
                        case 'p': {
                            show_parsetrees = true;
                            break;
                        }
                        case 'i': {
                            if (flag.length() == 3 && flag.charAt(2) == 'n') {
                                include_filespecs.add(args[++i]);
                                break;
                            }
                            if (flag.length() == 7 && "-import".equals(flag)) {
                                import_filespecs.add(args[++i].trim());
                                break;
                            }
                            show_instructions = true;
                            break;
                        }
                        case 'm': {
                            if (flag.length() == 10 && "-movieclip".equals(flag)) {
                                make_movieclip = true;
                                break;
                            }
                            if (flag.length() == 3 && "-md".equals(flag)) {
                                emit_metadata = true;
                                break;
                            }
                            show_instructions = true;
                            show_machinecode = true;
                            break;
                        }
                        case 'a': {
                            if (flag.length() != 10 || !"-abcfuture".equals(flag)) continue block22;
                            Features.FUTURE_ABC = true;
                            break;
                        }
                        case 'c': {
                            if (flag.length() != 6 || !"-coach".equals(flag)) continue block22;
                            lint_mode = true;
                            break;
                        }
                        case 'w': {
                            if (flag.length() != 9 || !"-warnings".equals(flag)) continue block22;
                            lint_mode = true;
                            break;
                        }
                        case 's': {
                            if (flag.length() == 7) {
                                if ("-strict".equals(flag)) {
                                    use_static_semantics = true;
                                    break;
                                }
                                if (!"-sanity".equals(flag)) continue block22;
                                sanity_mode = true;
                                break;
                            }
                            if (flag.length() != 4 || !"-swf".equals(flag) || (swf_options = args[++i]).indexOf("-g") <= -1) continue block22;
                            emit_debug_info = true;
                            break;
                        }
                        case 'e': {
                            if (flag.length() != 4 || !"-exe".equals(flag)) continue block22;
                            avmplus_exe = args[++i];
                            break;
                        }
                        case 'd': {
                            if (flag.length() == 4 && "-doc".equals(flag)) {
                                emit_doc_info = true;
                                break;
                            }
                            emit_debug_info = true;
                            break;
                        }
                        case 'l': {
                            if (flag.length() == 4 && "-log".equals(flag)) {
                                log = true;
                                break;
                            }
                            if (flag.length() == 9 && "-language".equals(flag)) {
                                language = args[++i];
                                break;
                            }
                            show_linenums = true;
                            break;
                        }
                        case 't': {
                            do_test = true;
                            break;
                        }
                        case 'h': {
                            do_help = true;
                            break;
                        }
                        case 'o': {
                            optimize = true;
                            break;
                        }
                        case 'A': {
                            if (flag.length() != 4 || !"-AS3".equalsIgnoreCase(flag)) continue block22;
                            dialect = 10;
                            break;
                        }
                        case 'E': {
                            if (flag.length() != 3 || !"-ES".equalsIgnoreCase(flag)) continue block22;
                            dialect = 9;
                            break;
                        }
                        default: {
                            try {
                                if (flag.length() <= 1 || (dialect = -1 * Integer.parseInt(flag)) == 0 || dialect >= earliest_dialect && dialect <= latest_dialect) continue block22;
                                do_help = true;
                            }
                            catch (NumberFormatException nfe) {
                                do_help = true;
                            }
                            break;
                        }
                    }
                    continue;
                }
                filename = new String(args[i].trim());
                ext = filename.endsWith(".as") ? ".as" : (filename.endsWith(".es") ? ".es" : (filename.endsWith(".js") ? ".js" : ""));
                filespecFound = true;
                Main.handleFile(filename, ext);
            }
        }
        if (!do_help && !filespecFound) {
            Context cx = new Context(new ContextStatics());
            System.err.println(cx.errorString(1147));
            System.exit(1);
        } else if (do_help) {
            Main.handleFile("", "");
        }
    }

    private static void handleFile(String filename, String ext) throws IOException, FileNotFoundException, Exception {
        if (do_help) {
            System.out.println("ActionScript 3.0 for AVM+");
            System.out.println("version 1.0 build d684");
            System.out.println("Copyright (c) 2003-2004 Macromedia, Inc.");
            System.out.println("Copyright (c) 1998-2003 Mountain View Compiler Company");
            System.out.println("All rights reserved\n");
            System.out.println("Usage:");
            System.out.println("  asc {-AS3|-ES|-d|-f|-h|-i|-import <filename>|-in <filename>|-m|-p}* filespec");
            System.out.println("  -AS3 = use the AS3 class based object model for greater performance and better error reporting");
            System.out.println("  -ES = use the ECMAScript edition 3 prototype based object model to allow dynamic overriding of prototype properties");
            System.out.println("  -d = emit debug info into the bytecode");
            System.out.println("  -f = print the flow graph to standard out");
            System.out.println("  -h = print this message");
            System.out.println("  -i = write intermediate code to the .il file");
            System.out.println("  -import <filename> = make the packages in the");
            System.out.println("       specified file available for import");
            System.out.println("  -in <filename> = include the specified filename");
            System.out.println("       (multiple -in arguments allowed)");
            System.out.println("  -m = write the avm+ assembly code to the .il file");
            System.out.println("  -p = write parse tree to the .p file");
            System.out.println("  -md = emit metadata information into the bytecode");
            System.out.println("  -warnings = warn on common actionscript mistakes");
            System.out.println("  -strict = treat undeclared variable and method access as errors");
            System.out.println("  -sanity = system-independent error/warning output -- appropriate for sanity testing");
            System.out.println("  -log = redirect all error output to a logfile");
            System.out.println("  -exe <avmplus path> = emit an EXE file (projector)");
            System.out.println("  -swf classname,width,height[,fps] = emit a SWF file");
            System.out.println("  -language = set the language for output strings {EN|FR|DE|IT|ES|JP|KR|CN|TW}");
            System.out.println("  -optimize = produced an optimized abc file");
            System.out.println("");
            System.exit(1);
        }
        if (!do_test) {
            File f = new File(filename.trim());
            if (!f.exists()) {
                Context cx = new Context(new ContextStatics());
                StringBuffer error_msg = new StringBuffer();
                Context.replaceStringArg(error_msg, cx.errorString(1063), 0, filename);
                System.err.println(error_msg.toString());
                return;
            }
            String pathspec = new File(f.getCanonicalPath()).getParent();
            String scriptname = f.getName().substring(0, f.getName().length() - ext.length());
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            CompilerPlug plug = new CompilerPlug();
            plug.in = in;
            plug.pathspec = pathspec;
            plug.filename = f.getPath();
            plug.scriptname = scriptname;
            plug.emit_debug_info = emit_debug_info;
            plug.emit_doc_info = emit_doc_info;
            plug.make_movieclip = make_movieclip;
            plug.import_filespecs = import_filespecs;
            plug.lint_mode = lint_mode;
            plug.use_static_semantics = use_static_semantics;
            plug.emit_metadata = emit_metadata;
            plug.swf_options = swf_options;
            plug.avmplus_exe = avmplus_exe;
            plug.language = language;
            plug.dialect = dialect;
            plug.optimize = optimize;
            if (sanity_mode) {
                ContextStatics.useSanityStyleErrors = true;
                plug.handler = new SanityCompilerHandler();
            }
            if (log) {
                String logfile = filename.substring(0, filename.length() - ext.length()) + ".log";
                System.setErr(stderr);
                System.err.println("Logging to " + logfile);
                System.setErr(new PrintStream(new FileOutputStream(new File(logfile))));
            }
            if (include_filespecs.size() > 0) {
                plug.includes = new ObjectList();
                for (int n = 0; n < include_filespecs.size(); ++n) {
                    String filespec = (String)include_filespecs.get(n);
                    f = new File(filespec);
                    if (!f.exists()) {
                        System.err.println("File not found");
                        return;
                    }
                    filespec = f.getPath();
                    pathspec = new File(f.getCanonicalPath()).getParent();
                    filename = f.getAbsolutePath();
                    scriptname = f.getName().substring(0, f.getName().length() - ext.length());
                    in = new BufferedInputStream(new FileInputStream(f));
                    IncludeInfo iinfo = new IncludeInfo();
                    iinfo.script = in;
                    iinfo.name = make_movieclip ? "frame" + n : filespec;
                    plug.includes.push_back(iinfo);
                }
            }
            ObjectList<CompilerPlug> plugs = new ObjectList<CompilerPlug>();
            Compiler.doCompile(plug, plugs, show_instructions, show_machinecode, show_linenums, show_parsetrees, show_bytes, show_flow);
        }
    }

    static {
        dialect = default_dialect = 9;
        optimize = false;
        include_filespecs = new ObjectList();
        import_filespecs = new ObjectList();
        swf_options = "";
        language = "EN";
        avmplus_exe = null;
    }
}

