/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.io;

import flash.util.FileUtils;
import flex2.compiler.io.VirtualFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InMemoryFile
implements VirtualFile {
    private byte[] bytes;
    private String name;
    private String mimeType;
    private long lastModified;

    public InMemoryFile(InputStream stream, long size, String name, String mimeType, long lastModified) throws IOException {
        this(FileUtils.toByteArray(stream, (int)size), name, mimeType, lastModified);
    }

    public InMemoryFile(InputStream stream, String name, String mimeType, long lastModified) {
        this(FileUtils.toByteArray(stream), name, mimeType, lastModified);
    }

    public InMemoryFile(byte[] data, String name, String mimeType, long lastModified) {
        this.bytes = data;
        this.init(name, mimeType, lastModified);
    }

    private void init(String name, String mimeType, long lastModified) {
        this.name = name;
        this.mimeType = mimeType;
        this.lastModified = lastModified;
    }

    public String getName() {
        return this.name;
    }

    public String getNameForReporting() {
        return this.name;
    }

    public String getURL() {
        return "memory://" + this.name;
    }

    public String getParent() {
        return null;
    }

    public boolean isDirectory() {
        return false;
    }

    public long size() {
        return this.bytes.length;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.bytes);
    }

    public byte[] toByteArray() throws IOException {
        return this.bytes;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public VirtualFile resolve(String relative) {
        return null;
    }

    public void close() {
    }

    public boolean equals(Object obj) {
        if (obj instanceof InMemoryFile) {
            return this == obj || this.getName().equals(((InMemoryFile)obj).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isTextBased() {
        return false;
    }
}

