/*
 * Decompiled with CFR 0.152.
 */
package adobe.asc.authoring.swc;

import flex2.compiler.io.InMemoryFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.SwcException;
import flex2.compiler.swc.zip.ZipEntry;
import flex2.compiler.swc.zip.ZipMemoryFile;
import flex2.compiler.util.MimeMappings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class SwcMemoryArchive
implements SwcArchive {
    protected byte[] data;
    protected String hash;
    protected Map files = new HashMap();

    public SwcMemoryArchive(byte[] data, String hash) {
        this.data = data;
        this.hash = hash;
    }

    public String getLocation() {
        return this.hash;
    }

    public void load() {
        ZipMemoryFile zipFile = null;
        try {
            zipFile = new ZipMemoryFile(this.data);
            Enumeration e = zipFile.getEntries();
            while (e.hasMoreElements()) {
                ZipEntry ze = (ZipEntry)e.nextElement();
                InputStream inputStream = zipFile.getInputStream(ze);
                InMemoryFile f = new InMemoryFile(inputStream, ze.getSize(), this.hash + "$" + ze.getName(), MimeMappings.getMimeType(ze.getName()), ze.getTime());
                this.files.put(ze.getName(), f);
            }
        }
        catch (SwcException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SwcException.FilesNotRead(e.getMessage());
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException ioe) {}
            this.data = null;
        }
    }

    public void save() throws Exception {
    }

    public void close() {
    }

    public Map getFiles() {
        return this.files;
    }

    public VirtualFile getFile(String path) {
        return (VirtualFile)this.files.get(path);
    }

    public void putFile(VirtualFile file) {
    }

    public void putFile(String path, byte[] data, long lastModified) {
    }

    public long getLastModified() {
        return 0L;
    }
}

