/*
 * Decompiled with CFR 0.152.
 */
package adobe.asc.authoring.swc;

import adobe.asc.authoring.AuthCompilerPlug;
import adobe.asc.authoring.swc.Swc;
import adobe.asc.authoring.swc.SwcDynamicArchive;
import adobe.asc.authoring.swc.SwcScript;
import flash.swf.Frame;
import flash.swf.Movie;
import flash.swf.MovieDecoder;
import flash.swf.TagDecoder;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DoABC;
import flash.swf.types.Rect;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcDependencySet;
import flex2.compiler.swc.SwcException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SwcLibrary {
    private final Swc swc;
    private final String path;
    private List scripts;
    private Map name2script;
    private Map def2symbol;
    private boolean parsed;
    private Set externs;
    private String location = null;
    private Rect movieSize;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SwcLibrary(Swc swc, String path) {
        this.swc = swc;
        this.path = path;
        this.scripts = new LinkedList();
        this.parsed = false;
        this.name2script = new HashMap();
        this.externs = new HashSet();
    }

    public String getPath() {
        return this.path;
    }

    public String getArchivePath() {
        return ((SwcDynamicArchive)this.swc.getArchive()).getRealPath();
    }

    public String getSwcLocation() {
        if (this.location != null) {
            return this.location;
        }
        return this.swc.getLocation();
    }

    public long getSwcCreationTime() {
        return this.swc.getLastModified();
    }

    public void clear() {
        this.scripts = null;
        this.def2symbol = null;
    }

    public Set getExterns() {
        return this.externs;
    }

    public SwcScript addScript(AuthCompilerPlug plug, SwcDependencySet deps) {
        String name = plug.classname.replaceAll("(\\.|:)", "/");
        SwcScript script = new SwcScript(this, name, plug.getTopLevelDefinitions(), deps, plug.lastModified);
        this.scripts.add(script);
        this.name2script.put(script.getName(), script);
        if (!($assertionsDisabled || plug.classname != null && plug.classname.length() > 0)) {
            throw new Error();
        }
        return script;
    }

    public SwcScript addScript(String name, Set defs, SwcDependencySet deps, long modtime) {
        SwcScript script = new SwcScript(this, name, defs, deps, modtime);
        this.scripts.add(script);
        this.name2script.put(script.getName(), script);
        if (!($assertionsDisabled || name != null && name.length() > 0)) {
            throw new Error();
        }
        return script;
    }

    public Iterator getScriptIterator() {
        return this.scripts.iterator();
    }

    public DefineTag getSymbol(String name) {
        name = name.replace(':', '.');
        return (DefineTag)this.def2symbol.get(name);
    }

    public Rect getMovieSize() {
        return this.movieSize;
    }

    private SwcScript getScript(DoABC doABC) {
        if (!$assertionsDisabled && doABC.code != 82) {
            throw new Error();
        }
        return (SwcScript)this.name2script.get(doABC.name);
    }

    protected void parse() {
        if (this.parsed) {
            return;
        }
        VirtualFile swcFile = this.swc.getArchive().getFile(this.path);
        if (swcFile == null) {
            throw new SwcException.CatalogNotFound();
        }
        Movie movie = new Movie();
        MovieDecoder movieDecoder = new MovieDecoder(movie);
        try {
            TagDecoder tagDecoder = new TagDecoder(swcFile.getInputStream());
            tagDecoder.parse(movieDecoder);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.movieSize = movie.size;
        boolean c1 = false;
        this.def2symbol = new HashMap();
        Iterator frames = movie.frames.iterator();
        while (frames.hasNext()) {
            Frame frame = (Frame)frames.next();
            Iterator abcit = frame.doABCs.iterator();
            while (abcit.hasNext()) {
                DoABC doABC = (DoABC)abcit.next();
                SwcScript script = this.getScript(doABC);
                script.setDoABC(doABC);
            }
            Iterator it = frame.symbolClass.class2tag.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                String className = (String)e.getKey();
                DefineTag tag = (DefineTag)e.getValue();
                this.def2symbol.put(className, tag);
            }
        }
        this.parsed = true;
    }

    static {
        $assertionsDisabled = true;
    }
}

