/*
 * Decompiled with CFR 0.152.
 */
package adobe.asc.authoring.swc;

import adobe.asc.authoring.AuthCompilerPlug;
import adobe.asc.authoring.swc.Component;
import adobe.asc.authoring.swc.SwcLibrary;
import adobe.asc.authoring.swc.SwcMovie;
import adobe.asc.authoring.swc.VersionInfo;
import adobe.asc.authoring.swc.Versions;
import adobe.asc.authoring.swc.catalog.CatalogReader;
import adobe.asc.authoring.swc.catalog.CatalogWriter;
import flex2.compiler.io.InMemoryFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Features;
import flex2.compiler.swc.SwcArchive;
import flex2.compiler.swc.SwcDependencySet;
import flex2.compiler.swc.SwcException;
import flex2.compiler.util.MimeMappings;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Swc {
    public static String LIBRARY_SWF = "library.swf";
    public static String CATALOG_XML = "catalog.xml";
    private final SwcArchive archive;
    private long lastModified = -1L;
    private Map libraries = new HashMap();
    private Map catalogFiles;
    private Map components = new TreeMap();
    private Versions versions = new Versions();
    private Features features = new Features();
    private Map defs = new HashMap();

    public Swc(SwcArchive archive) throws Exception {
        this(archive, false);
    }

    public Swc(SwcArchive archive, boolean load) throws Exception {
        this.archive = archive;
        if (load) {
            this.read();
        }
    }

    long getLastModified() {
        return this.lastModified;
    }

    void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getLocation() {
        return this.archive.getLocation();
    }

    public Iterator getLibraryIterator() {
        return this.libraries.values().iterator();
    }

    public SwcLibrary buildLibrary(String swfPath, String libname, List plugs) throws IOException {
        SwcMovie movie = new SwcMovie(swfPath);
        byte[] swf = movie.getBytes();
        String libPath = new StringBuffer().append(libname).append(".swf").toString();
        SwcLibrary lib = new SwcLibrary(this, libPath);
        InMemoryFile swfFile = new InMemoryFile(swf, libPath, MimeMappings.getMimeType(libPath), new Date().getTime());
        this.archive.putFile(swfFile);
        this.libraries.put(libPath, lib);
        for (AuthCompilerPlug plug : plugs) {
            if (plug.isInternal) continue;
            SwcDependencySet depset = new SwcDependencySet();
            Swc.addDeps(depset, "i", plug.getInheritance());
            Swc.addDeps(depset, "s", plug.getType());
            Swc.addDeps(depset, "n", plug.getNamespaces());
            Swc.addDeps(depset, "e", plug.getExpressions());
            this.checkDefs(plug.getTopLevelDefinitions(), plug.filename);
            lib.getExterns().addAll(plug.getExterns());
            lib.addScript(plug, depset);
        }
        Iterator compIter = this.getComponentIterator();
        while (compIter.hasNext()) {
            Component comp = (Component)compIter.next();
            this.addDependentFile(comp.getIconFullPath(), comp.getIcon());
            this.addDependentFile(comp.getPreviewFullPath(), comp.getPreview());
            this.addDependentFile(comp.getCustomUIFullPath(), comp.getCustomUI());
        }
        return lib;
    }

    private void addDependentFile(String filepath, String filename) throws IOException {
        if (filepath == null || filepath.length() < 1) {
            return;
        }
        try {
            File theFile = new File(filepath);
            FileInputStream inStream = new FileInputStream(theFile);
            InMemoryFile inMemFile = new InMemoryFile(inStream, filename, MimeMappings.getMimeType(filename), theFile.lastModified());
            this.archive.putFile(inMemFile);
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    private void checkDefs(Set scriptDefs, String sourceName) {
        for (String str : scriptDefs) {
            String script = (String)this.defs.get(str);
            if (script != null) {
                throw new SwcException.DuplicateDefinition(str, script, sourceName);
            }
            this.defs.put(str, sourceName);
        }
    }

    private static void addDeps(SwcDependencySet depset, String type, Set<String> theSet) {
        Iterator<String> it = theSet.iterator();
        while (it.hasNext()) {
            depset.addDependency(type, it.next());
        }
    }

    private static void addExtraClassesDeps(SwcDependencySet depset, Set extraClasses) {
        for (String extraClass : extraClasses) {
            depset.addDependency("e", extraClass);
        }
    }

    public synchronized boolean save() throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)byteOut, "UTF-8");
        if (this.components.size() > 0) {
            this.features.setComponents(true);
        }
        if (this.archive.getFiles().size() > 0) {
            this.features.setFiles(true);
        }
        this.versions.setLibVersion(VersionInfo.getLibVersion());
        this.versions.setFlexVersion(VersionInfo.getFlexVersion());
        this.versions.setFlexBuild(VersionInfo.getBuild());
        this.versions.setPlatform(VersionInfo.getPlatform());
        for (SwcLibrary l : this.libraries.values()) {
            if (l.getExterns().size() <= 0) continue;
            this.features.setExternalDeps(true);
            break;
        }
        CatalogWriter writer = new CatalogWriter(out, this.versions, this.features, this.components.values(), this.libraries.values(), this.archive.getFiles().values());
        writer.write();
        ((Writer)out).close();
        this.archive.putFile(CATALOG_XML, byteOut.toByteArray(), new Date().getTime());
        this.archive.save();
        return true;
    }

    public Map getCatalogFiles() {
        return this.catalogFiles;
    }

    public VirtualFile getFile(String path) {
        return (VirtualFile)this.catalogFiles.get(path);
    }

    public void addFile(VirtualFile file) {
        this.archive.putFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() throws Exception {
        InputStream stream = null;
        try {
            this.archive.load();
            VirtualFile catalogFile = this.archive.getFile(CATALOG_XML);
            if (catalogFile == null) {
                throw new SwcException.CatalogNotFound();
            }
            stream = catalogFile.getInputStream();
            CatalogReader reader = new CatalogReader(new BufferedInputStream(stream), this, this.archive);
            reader.read();
            this.versions = reader.getVersions();
            this.features = reader.getFeatures();
            this.components = reader.getComponents();
            this.libraries = reader.getLibraries();
            this.catalogFiles = reader.getFiles();
            if (VersionInfo.IsNewerLibVersion(this.versions.getLibVersion())) {
                // empty if block
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void close() {
        this.archive.close();
    }

    public Iterator getComponentIterator() {
        return this.components.values().iterator();
    }

    public Versions getVersions() {
        return this.versions;
    }

    public Features getFeatures() {
        return this.features;
    }

    public void addComponent(Component c) {
        this.components.put(c.getClassName(), c);
    }

    public SwcArchive getArchive() {
        return this.archive;
    }
}

