/*
 * Decompiled with CFR 0.152.
 */
package adobe.asc.authoring;

import adobe.asc.authoring.AuthCompiler;
import adobe.asc.authoring.AuthCompilerHandler;
import adobe.asc.authoring.AuthCompilerPlug;
import adobe.asc.authoring.UIActionsEvaluator;
import adobe.asc.authoring.abc.ABCEvaluator;
import adobe.asc.authoring.abc.ClassInfo;
import adobe.asc.authoring.abc.MetadataAttributeInfo;
import adobe.asc.authoring.abc.MetadataInfo;
import adobe.asc.authoring.abc.Optimizer;
import adobe.asc.authoring.actions.UIAction;
import adobe.asc.authoring.actions.UIActionComment;
import adobe.asc.authoring.actions.UIActionList;
import adobe.asc.authoring.swc.Component;
import adobe.asc.authoring.swc.Swc;
import adobe.asc.authoring.swc.SwcCache;
import adobe.asc.authoring.swc.SwcDynamicArchive;
import adobe.asc.authoring.swc.SwcGroup;
import adobe.asc.authoring.swc.SwcLibrary;
import adobe.asc.authoring.swc.SwcScript;
import flash.swf.tags.DoABC;
import flash.swf.types.Rect;
import flex2.compiler.swc.SwcDependencySet;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import macromedia.abc.AbcParser;
import macromedia.asc.embedding.CompilerHandler;
import macromedia.asc.embedding.IncludeInfo;
import macromedia.asc.embedding.LintEvaluator;
import macromedia.asc.embedding.avmplus.ActionBlockEmitter;
import macromedia.asc.embedding.avmplus.ClassBuilder;
import macromedia.asc.embedding.avmplus.GlobalBuilder;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.CommentNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.ImportDirectiveNode;
import macromedia.asc.parser.IncludeDirectiveNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.NamespaceDefinitionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.Parser;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.parser.UseDirectiveNode;
import macromedia.asc.parser.VariableBindingNode;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.CodeGenerator;
import macromedia.asc.semantics.ConstantEvaluator;
import macromedia.asc.semantics.FlowAnalyzer;
import macromedia.asc.semantics.FlowGraphEmitter;
import macromedia.asc.semantics.NamespaceValue;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.util.Boxing;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.Names;
import macromedia.asc.util.ObjectList;
import macromedia.asc.util.StringPrintWriter;
import macromedia.asc.util.graph.Algorithms;
import macromedia.asc.util.graph.DependencyGraph;
import macromedia.asc.util.graph.Vertex;
import macromedia.asc.util.graph.Visitor;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthBatchCompiler {
    private static AuthCompilerPlug mainplug;
    private static ObjectList<AuthCompilerPlug> plugs;
    private static List<Context> cx;
    private static List<ActionBlockEmitter> emitter;
    private static List<ProgramNode> node;
    private static List<FlowAnalyzer> fa;
    private static List<ConstantEvaluator> ce;
    private static Set<Pair> inheritance;
    private static Set<Pair> type;
    private static Set<Pair> expressions;
    private static Set<Pair> namespaces;
    private static Swc swcForExport;
    private static SwcCache swcCache;
    private static SwcGroup swcGroup;
    private static SwcGroup classPathSwcGroup;
    private static Set<String> swcPackageNames;
    private static boolean linkingLivePreview;
    private static boolean showedSwcDefNotFoundError;
    private static ArrayList<ByteList> abcToParse;
    private static ArrayList<DoABC> doABCsToOptimize;
    private static ArrayList<DoABC> doABCsToOptimizeLoaderFrame;
    private static long swcLastModified;
    private static String docClassHandlerKey;
    private static ContextStatics s;

    public static ContextStatics getStatics() {
        return s;
    }

    private static boolean parseSimple(int start, int end) throws Throwable {
        for (int i = start; i < end; ++i) {
            AuthCompilerPlug cplug = (AuthCompilerPlug)plugs.get(i);
            Context ctxt = cx.get(i);
            if (!cplug.parse_only && !cplug.build_uiactions) continue;
            ctxt.setEmitter(emitter.get(i));
            ctxt.setHandler(cplug.handler);
            ctxt.setPath(cplug.pathspec);
            if (cplug.build_uiactions) {
                ctxt.scriptAssistParsing = true;
            }
            Parser p = new Parser(ctxt, cplug.in, cplug.filename, cplug.file_encoding, cplug.emit_doc_info, true);
            ProgramNode plugNode = p.parseProgram();
            if (cx.get(i).errorCount() == 0) {
                if (!cplug.build_uiactions) continue;
                String buffer = AuthBatchCompiler.uiactionEvaluate(ctxt, plugNode);
                CompilerHandler handler = cplug.handler;
                ByteList bytes = new ByteList();
                bytes.addAll(buffer.getBytes("UTF-8"));
                if (!(handler instanceof AuthCompilerHandler)) continue;
                ((AuthCompilerHandler)handler).writeBytes("", bytes, cplug.inLoaderFrame);
                continue;
            }
            return false;
        }
        return true;
    }

    public static void doParse(AuthCompilerPlug cplug, ObjectList<AuthCompilerPlug> cplugList) throws Throwable {
        long startTime = System.currentTimeMillis();
        boolean result = true;
        mainplug = cplug;
        plugs = cplugList;
        AuthBatchCompiler.init();
        int start = 0;
        int end = plugs.size();
        while (start < end) {
            if (AuthBatchCompiler.parseSimple(start, end)) {
                start = end;
                if (start >= (end = plugs.size())) continue;
                continue;
            }
            result = false;
            break;
        }
        AuthBatchCompiler.clear();
        System.err.println(new StringBuffer().append("Plugs: ").append(plugs.size()).append(" Time: ").append(System.currentTimeMillis() - startTime).append("ms").toString());
    }

    public static void doCompile(AuthCompilerPlug cplug, ObjectList<AuthCompilerPlug> cplugList) throws Throwable {
        long startTime = System.currentTimeMillis();
        mainplug = cplug;
        plugs = cplugList;
        AuthBatchCompiler.init();
        List<ProgramNode> pnodes = node;
        List<Context> loc_cx = cx;
        int start = 0;
        int end = plugs.size();
        while (start < end) {
            AuthBatchCompiler.parse(start, end);
            AuthBatchCompiler.fa_part1(start, end);
            AuthBatchCompiler.resolveInheritance(start, end);
            start = end;
            end = plugs.size();
            if (start < end) continue;
            AuthBatchCompiler.sortInheritance();
            AuthBatchCompiler.fa_part2();
            AuthBatchCompiler.resolveType();
            if (AuthBatchCompiler.mainplug.use_static_semantics) {
                AuthBatchCompiler.resolveImportStatements();
            }
            AuthBatchCompiler.resolveExpression();
            start = end;
            end = plugs.size();
            if (start < end) continue;
            AuthBatchCompiler.inheritSlots(type);
            if (AuthBatchCompiler.mainplug.use_static_semantics || AuthBatchCompiler.mainplug.lint_mode) {
                AuthBatchCompiler.inheritSlots(expressions);
            }
            AuthBatchCompiler.ce_part1();
            AuthBatchCompiler.ce_part2();
            start = end;
            end = plugs.size();
        }
        if (AuthBatchCompiler.mainplug.lint_mode) {
            AuthBatchCompiler.resolvePlayerglobal();
            AuthBatchCompiler.lintEvaluate();
        }
        AuthBatchCompiler.markLoaderFramePlugs();
        AuthBatchCompiler.codeGenerate();
        AuthBatchCompiler.checkBaseClasses();
        for (AuthCompilerPlug compplug : plugs) {
            AuthBatchCompiler.transferDefinitions(compplug);
        }
        if (abcToParse != null) {
            for (ByteList bytes : abcToParse) {
                Context context = new Context(s);
                byte[] bytesArray = bytes.toByteArray(false);
                ProgramNode pnode = new AbcParser(context, bytesArray).parseAbc();
                ABCEvaluator mde = new ABCEvaluator();
                pnode.evaluate(context, mde);
            }
        }
        if (AuthBatchCompiler.mainplug.optimize) {
            AuthBatchCompiler.writeOptimizedABC();
        }
        AuthBatchCompiler.clear();
        System.err.println(new StringBuffer().append("Plugs: ").append(plugs.size()).append(" Time: ").append(System.currentTimeMillis() - startTime).append("ms").toString());
    }

    public static void addComponentForExport(String classname, String name, String uri, String toolTip, String iconPath, String livePreviewPath, String customUIPath, int customUIDisplay) throws Exception {
        uri = null;
        if (classname.indexOf(58) < 0) {
            classname = AuthBatchCompiler.dotClassnameToColonClassname(classname);
        }
        Component comp = new Component(classname, name, uri);
        if (toolTip != null && toolTip.length() > 0) {
            comp.setToolTip(toolTip);
        }
        if (iconPath != null && iconPath.length() > 0) {
            comp.setIcon(iconPath);
        }
        if (livePreviewPath != null && livePreviewPath.length() > 0) {
            comp.setPreview(livePreviewPath);
        }
        if (customUIPath != null && customUIPath.length() > 0) {
            comp.setCustomUI(customUIPath);
            comp.setCustomUIDisplay(new Long(customUIDisplay));
        }
        swcForExport.addComponent(comp);
    }

    public static void exportSwc(String swfPath) throws Exception {
        Iterator compIter = swcForExport.getComponentIterator();
        while (compIter.hasNext()) {
            ClassInfo classInfo;
            Component comp = (Component)compIter.next();
            if (ABCEvaluator.globalClassInfoMap == null || (classInfo = ABCEvaluator.globalClassInfoMap.get(AuthBatchCompiler.colonClassnameToDotClassname(comp.getClassName()))) == null || classInfo.metadata == null) continue;
            for (MetadataInfo metaInfo : classInfo.metadata) {
                if (metaInfo.name != "IconFile" || metaInfo.attrs.size() <= 0) continue;
                MetadataAttributeInfo metaAttrInfo = metaInfo.attrs.get(0);
                if (metaAttrInfo.value.length() <= 0) continue;
                File iconFile = new File(metaAttrInfo.value);
                String iconFileName = "";
                if (!iconFile.isAbsolute()) {
                    iconFileName = new StringBuffer().append(iconFileName).append(AuthBatchCompiler.mainplug.pathspec).toString();
                    iconFileName = new StringBuffer().append(iconFileName).append(File.separator).toString();
                }
                iconFileName = new StringBuffer().append(iconFileName).append(metaAttrInfo.value).toString();
                comp.setIcon(iconFileName);
            }
        }
        swcForExport.buildLibrary(swfPath, "library", plugs);
        swcForExport.save();
    }

    public static String getFlashVersion() {
        return mainplug == null ? "" : AuthBatchCompiler.mainplug.flashVersion;
    }

    public static String getFlashBuild() {
        return mainplug == null ? "" : AuthBatchCompiler.mainplug.flashBuild;
    }

    public static String getFlashPlatform() {
        return mainplug == null ? "" : AuthBatchCompiler.mainplug.flashPlatform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String linkSwfForClassFromSwc(String hashKey, String classname, String tempFilename) throws Throwable {
        String returnValue;
        try {
            AuthBatchCompiler.init();
            swcLastModified = 0L;
            linkingLivePreview = true;
            ABCEvaluator.resetGlobals();
            String[] hashKeys = new String[]{hashKey};
            swcGroup = swcCache.getSwcGroupFromHashes(hashKeys);
            String colonClassname = AuthBatchCompiler.dotClassnameToColonClassname(classname);
            SwcScript swcScript = (SwcScript)swcGroup.getScriptMap().get(colonClassname);
            AuthBatchCompiler.parseABCBlocks();
            String abcXml = ABCEvaluator.generateClassXML(classname);
            StringBuffer xmlBuff = new StringBuffer(1024);
            xmlBuff.append("<component id=\"");
            xmlBuff.append(swcScript.getName());
            xmlBuff.append("\" class=\"");
            xmlBuff.append(classname);
            xmlBuff.append("\" modified=\"");
            xmlBuff.append(swcLastModified);
            xmlBuff.append("\">\n");
            Rect movieBounds = swcScript.getLibrary().getMovieSize();
            xmlBuff.append("<movieBounds xmin=\"");
            xmlBuff.append(movieBounds.xMin);
            xmlBuff.append("\" xmax=\"");
            xmlBuff.append(movieBounds.xMax);
            xmlBuff.append("\" ymin=\"");
            xmlBuff.append(movieBounds.yMin);
            xmlBuff.append("\" ymax=\"");
            xmlBuff.append(movieBounds.yMax);
            xmlBuff.append("\" />\n");
            xmlBuff.append(abcXml);
            xmlBuff.append("</component>\n");
            returnValue = xmlBuff.toString();
            Swc theSwc = (Swc)swcGroup.getSwcs().get(hashKey);
            byte[] swfBytes = theSwc.getArchive().getFile(Swc.LIBRARY_SWF).toByteArray();
            FileOutputStream swfFile = new FileOutputStream(tempFilename);
            swfFile.write(swfBytes);
            swfFile.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
            returnValue = "";
        }
        finally {
            AuthBatchCompiler.cleanup();
            ABCEvaluator.resetGlobals();
        }
        return returnValue;
    }

    private static void parseABCBlocks() {
        for (String qname : swcGroup.getQNames()) {
            SwcScript swcScript = (SwcScript)swcGroup.getScriptMap().get(qname);
            if (swcScript == null) {
                return;
            }
            if (swcScript.getLastModified() > swcLastModified) {
                swcLastModified = swcScript.getLastModified();
            }
            byte[] abcBytes = swcScript.getDoABC().abc;
            Context context = new Context(s);
            ProgramNode pnode = new AbcParser(context, abcBytes).parseAbc();
            pnode.evaluate(context, new ABCEvaluator());
        }
    }

    private static InputStream getInputStream(String filename) throws Throwable {
        File f = new File(filename.trim());
        InputStream in = null;
        if (f.exists()) {
            in = new BufferedInputStream(new FileInputStream(f));
        } else {
            byte[] buf = new byte[]{0};
            in = new ByteArrayInputStream(buf);
        }
        return in;
    }

    public static void addCompilerPlug(AuthCompilerPlug plug) throws Throwable {
        plugs.add(plug);
        AuthBatchCompiler.initPlug(plug, plugs.size() - 1);
        plug.lastModified = swcForExport != null ? new File(plug.filename).lastModified() : 0L;
        Context context = new Context(s);
        context.setHandler(plug.handler);
        context.setPath(plug.pathspec);
        cx.add(context);
        emitter.add(new ActionBlockEmitter(context, plug.scriptname, new StringPrintWriter(), new StringPrintWriter(), false, false, false, AuthBatchCompiler.mainplug.emit_debug_info));
    }

    public static void cleanup() throws Throwable {
        if (mainplug != null && AuthBatchCompiler.mainplug.emit_metadata) {
            abcToParse = null;
            ABCEvaluator.resetGlobals();
        }
        doABCsToOptimize = null;
        doABCsToOptimizeLoaderFrame = null;
        linkingLivePreview = false;
        showedSwcDefNotFoundError = false;
        swcGroup = null;
        classPathSwcGroup = null;
        swcPackageNames = null;
        swcForExport = null;
        swcCache = null;
        mainplug = null;
        plugs = null;
        cx = null;
        emitter = null;
        node = null;
        fa = null;
        ce = null;
        inheritance = null;
        type = null;
        expressions = null;
        namespaces = null;
        s = null;
    }

    private static void initPlug(AuthCompilerPlug plug, int index) throws Throwable {
        if (plug.in == null) {
            if (plug.isSwcPlug) {
                if (plug.includes.size() > 0) {
                    ((AuthCompilerHandler)plug.handler).authError(5002, plug.swcPlugSymbolName, plug.classname);
                }
                String colonClassname = AuthBatchCompiler.dotClassnameToColonClassname(plug.classname);
                AuthBatchCompiler.searchSwcGroup(colonClassname, false, plug, index);
            } else {
                InputStream in = AuthBatchCompiler.getInputStream(plug.filename);
                if (in != null) {
                    plug.in = in;
                }
            }
        }
        plug.lastModified = swcForExport != null ? new GregorianCalendar().getTimeInMillis() : 0L;
    }

    private static void init() throws Throwable {
        InputStream in;
        if (mainplug != null && AuthBatchCompiler.mainplug.in == null && (in = AuthBatchCompiler.getInputStream(AuthBatchCompiler.mainplug.filename)) != null) {
            AuthBatchCompiler.mainplug.in = in;
        }
        if (mainplug != null && AuthBatchCompiler.mainplug.swcFileName != null && AuthBatchCompiler.mainplug.swcFileName.length() > 0) {
            swcForExport = new Swc(new SwcDynamicArchive(AuthBatchCompiler.mainplug.swcFileName));
            AuthBatchCompiler.mainplug.optimize = false;
        } else {
            swcForExport = null;
        }
        swcCache = new SwcCache();
        if (mainplug == null || AuthBatchCompiler.mainplug.swcHashKeys == null) {
            swcGroup = null;
        } else {
            int numHashes = AuthBatchCompiler.mainplug.swcHashKeys.length() / 23;
            if (numHashes < 1) {
                swcGroup = null;
            } else {
                String[] hashKeys = new String[numHashes];
                int strPtr = 0;
                for (int i = 0; i < numHashes; ++i) {
                    hashKeys[i] = AuthBatchCompiler.mainplug.swcHashKeys.substring(strPtr, strPtr + 22);
                    strPtr += 23;
                }
                swcGroup = swcCache.getSwcGroupFromHashes(hashKeys);
            }
        }
        if (plugs != null) {
            Iterator plug_it = plugs.iterator();
            int i = 0;
            while (plug_it.hasNext()) {
                AuthCompilerPlug plug = (AuthCompilerPlug)plug_it.next();
                AuthBatchCompiler.initPlug(plug, i);
                ++i;
            }
        }
        TypeValue.init();
        ObjectValue.init();
        s = new ContextStatics();
        AuthBatchCompiler.s.handler = mainplug != null && AuthBatchCompiler.mainplug.handlerKey != null && AuthBatchCompiler.mainplug.handlerKey.length() > 0 ? new AuthCompilerHandler(AuthBatchCompiler.mainplug.handlerKey, null) : new CompilerHandler();
        ContextStatics.useVerboseErrors = false;
        ContextStatics.useSimpleLogWarnings = true;
        if (mainplug != null) {
            ContextStatics.omitTrace = AuthBatchCompiler.mainplug.omitTrace;
            AuthBatchCompiler.s.use_static_semantics = AuthBatchCompiler.mainplug.use_static_semantics;
            if (AuthBatchCompiler.mainplug.dialect > 0) {
                AuthBatchCompiler.s.dialect = AuthBatchCompiler.mainplug.dialect;
            }
            AuthBatchCompiler.s.languageID = Context.getLanguageID(AuthBatchCompiler.mainplug.language);
        }
        if (plugs != null) {
            int i;
            cx = new ArrayList<Context>(plugs.size());
            int length = plugs.size();
            for (i = 0; i < length; ++i) {
                AuthCompilerPlug plug = (AuthCompilerPlug)plugs.get(i);
                Context context = new Context(s);
                context.setHandler(plug.handler);
                context.setPath(plug.pathspec);
                cx.add(context);
            }
            emitter = new ArrayList<ActionBlockEmitter>(plugs.size());
            length = plugs.size();
            for (i = 0; i < length; ++i) {
                emitter.add(new ActionBlockEmitter(cx.get(i), ((AuthCompilerPlug)AuthBatchCompiler.plugs.get((int)i)).pathspec, new StringPrintWriter(), new StringPrintWriter(), false, false, false, AuthBatchCompiler.mainplug.emit_debug_info));
            }
            node = new ArrayList<ProgramNode>(plugs.size());
            ce = new ArrayList<ConstantEvaluator>(plugs.size());
            fa = new ArrayList<FlowAnalyzer>(plugs.size());
            inheritance = new HashSet<Pair>();
            type = new HashSet<Pair>();
            expressions = new HashSet<Pair>();
            namespaces = new HashSet<Pair>();
        }
        if (mainplug != null) {
            AuthBatchCompiler.initImports(AuthBatchCompiler.mainplug.import_filespecs);
        }
        if (mainplug != null && plugs != null) {
            AuthBatchCompiler.initClassPathSwcGroup();
        }
        swcPackageNames = new HashSet<String>();
        if (swcGroup != null) {
            AuthBatchCompiler.addPackageNames(swcGroup);
        }
        if (classPathSwcGroup != null) {
            AuthBatchCompiler.addPackageNames(classPathSwcGroup);
        }
        if (mainplug != null && AuthBatchCompiler.mainplug.emit_metadata) {
            ABCEvaluator.resetGlobals();
            abcToParse = new ArrayList();
        } else {
            abcToParse = null;
        }
        docClassHandlerKey = new String();
    }

    private static boolean isPlayerglobalSwc(String swcName) {
        int index = swcName.lastIndexOf("/");
        if (index < 0) {
            index = swcName.lastIndexOf("\\");
        }
        if (index >= 0) {
            swcName = swcName.substring(index + 1);
        }
        return swcName.equals("playerglobal.swc");
    }

    private static void initClassPathSwcGroup() {
        boolean playerGlobalLoaded = false;
        classPathSwcGroup = swcCache.getSwcGroup(AuthBatchCompiler.mainplug.packageSearchPath);
        for (Map.Entry entry : classPathSwcGroup.getSwcs().entrySet()) {
            String swcName;
            Swc swc = (Swc)entry.getValue();
            Iterator compIter = swc.getComponentIterator();
            while (compIter.hasNext()) {
                Component comp = (Component)compIter.next();
                AuthBatchCompiler.searchSwcGroup(comp.getClassName(), false, null, -1);
            }
            if (playerGlobalLoaded || !AuthBatchCompiler.isPlayerglobalSwc(swcName = ((SwcDynamicArchive)swc.getArchive()).getRealPath())) continue;
            playerGlobalLoaded = true;
        }
        if (!playerGlobalLoaded) {
            ((AuthCompilerHandler)AuthBatchCompiler.s.handler).authError(5004, "", "");
        }
    }

    private static void addPackageNames(SwcGroup group) {
        for (String qname : group.getQNames()) {
            String[] tokens = qname.split(":");
            if (tokens.length <= 1) continue;
            swcPackageNames.add(tokens[0]);
        }
    }

    private static void initImports(ObjectList<String> filespecs) throws Throwable {
        for (int i = filespecs.size() - 1; i >= 0; --i) {
            AuthCompilerPlug plug = new AuthCompilerPlug();
            plug.filename = (String)filespecs.get(i);
            plug.isInternal = true;
            plug.setHandlerKey(plug.filename);
            plugs.add(0, plug);
            Context context = new Context(s);
            cx.add(0, context);
            emitter.add(0, new ActionBlockEmitter(context, plug.scriptname, new StringPrintWriter(), new StringPrintWriter(), false, false, false, AuthBatchCompiler.mainplug.emit_debug_info));
        }
    }

    private static void parse(int start, int end) throws Throwable, IOException {
        for (int i = start; i < end; ++i) {
            AuthCompilerPlug cplug = (AuthCompilerPlug)plugs.get(i);
            Context ctxt = cx.get(i);
            if (start == 0 && cplug.inLoaderFrame && docClassHandlerKey.length() == 0) {
                docClassHandlerKey = AuthBatchCompiler.getHandlerKey(cplug);
            }
            ctxt.setEmitter(emitter.get(i));
            ctxt.setPath(cplug.pathspec);
            boolean isAbcFile = cplug.filename.endsWith(".abc");
            boolean isAsNoFrames = cplug.filename.endsWith(".as") && !cplug.make_movieclip;
            File f = null;
            if ((isAbcFile || isAsNoFrames) && cplug.abc == null) {
                f = new File(cplug.filename);
                if (f.exists() && f.isFile()) {
                    f = f.getCanonicalFile();
                }
                cplug.scriptname = f.getName();
                cplug.pathspec = f.getParent();
                cx.get(i).setScriptName(f.getName());
                cx.get(i).setPath(f.getParent());
            }
            ProgramNode pnode = null;
            if (cplug.abc != null) {
                pnode = new AbcParser(ctxt, cplug.abc).parseAbc();
                if (AuthBatchCompiler.mainplug.emit_metadata && (!cplug.isInternal || swcForExport != null)) {
                    ABCEvaluator mde = new ABCEvaluator();
                    pnode.evaluate(ctxt, mde);
                }
            } else if (isAbcFile) {
                pnode = new AbcParser(ctxt, f.getPath()).parseAbc();
            } else if (isAsNoFrames) {
                pnode = new Parser(ctxt, new FileInputStream(f), f.getPath()).parseProgram();
            } else {
                IncludeInfo iinfo;
                if (cplug.isSwcPlug && !showedSwcDefNotFoundError) {
                    showedSwcDefNotFoundError = true;
                    ((AuthCompilerHandler)cplug.handler).authError(5009, "", "");
                }
                if (cplug.in == null) {
                    cplug.in = AuthBatchCompiler.getInputStream("");
                }
                InputStream implicitImports = null;
                if (AuthBatchCompiler.mainplug.includes.size() > 0 && (iinfo = (IncludeInfo)AuthBatchCompiler.mainplug.includes.get(0)) != null && (implicitImports = iinfo.script) != null) {
                    implicitImports.reset();
                }
                pnode = AuthCompiler.compilePlug(cplug, ctxt, implicitImports);
            }
            AuthBatchCompiler.stashDefinitionNodes(pnode, cplug);
            node.add(pnode);
            ctxt.getNodeFactory().pkg_defs.clear();
            ctxt.getNodeFactory().compound_names.clear();
        }
    }

    private static void stashDefinitionNodes(ProgramNode node, AuthCompilerPlug authplug) {
        if (authplug == null || authplug.isInternal || node == null) {
            return;
        }
        int size = node.statements != null ? node.statements.items.size() : 0;
        boolean inPackage = false;
        for (int i = 0; i < size; ++i) {
            Node n = (Node)node.statements.items.get(i);
            if (n instanceof PackageDefinitionNode) {
                inPackage = !inPackage;
                continue;
            }
            if (!n.isDefinition() || !inPackage) continue;
            authplug.getDefinitionNodes().add(n);
        }
    }

    private static void transferDefinitions(AuthCompilerPlug authplug) {
        if (authplug == null || authplug.isInternal || authplug.abc != null || authplug.numErrors > 0) {
            return;
        }
        if (!authplug.class_provided && swcForExport == null) {
            return;
        }
        Set<String> topLevelDefinitions = authplug.getTopLevelDefinitions();
        List<Node> definitions = authplug.getDefinitionNodes();
        int size = definitions.size();
        for (int i = 0; i < size; ++i) {
            try {
                DefinitionNode def;
                Node n = definitions.get(i);
                if (n instanceof ClassDefinitionNode) {
                    def = (ClassDefinitionNode)n;
                    if (def.attrs != null && def.attrs.hasPrivate) continue;
                    QName qName = def.cframe.builder.classname;
                    topLevelDefinitions.add(qName.toString());
                    continue;
                }
                if (n instanceof NamespaceDefinitionNode) {
                    def = (NamespaceDefinitionNode)n;
                    if (((NamespaceDefinitionNode)def).attrs != null && ((NamespaceDefinitionNode)def).attrs.hasPrivate) continue;
                    QName qName = ((NamespaceDefinitionNode)def).qualifiedname;
                    topLevelDefinitions.add(qName.toString());
                    continue;
                }
                if (n instanceof FunctionDefinitionNode) {
                    def = (FunctionDefinitionNode)n;
                    if (((FunctionDefinitionNode)def).attrs != null && ((FunctionDefinitionNode)def).attrs.hasPrivate) continue;
                    ReferenceValue ref = ((FunctionDefinitionNode)def).ref;
                    String ns = ref.namespaces.size() == 0 ? "" : ((ObjectValue)ref.namespaces.get((int)0)).name;
                    String fullName = ns.length() > 0 ? new StringBuffer().append(ns).append(":").append(ref.name).toString() : ref.name;
                    topLevelDefinitions.add(fullName);
                    continue;
                }
                if (n instanceof VariableDefinitionNode) {
                    int length;
                    def = (VariableDefinitionNode)n;
                    if (((VariableDefinitionNode)def).attrs != null && ((VariableDefinitionNode)def).attrs.hasPrivate) continue;
                    int n2 = length = ((VariableDefinitionNode)def).list == null ? 0 : ((VariableDefinitionNode)def).list.size();
                    for (int j = 0; j < length; ++j) {
                        VariableBindingNode binding = (VariableBindingNode)((VariableDefinitionNode)def).list.items.get(j);
                        ReferenceValue ref = binding.ref;
                        String ns = ref.namespaces.size() == 0 ? "" : ((ObjectValue)ref.namespaces.get((int)0)).name;
                        String fullName = ns.length() > 0 ? new StringBuffer().append(ns).append(":").append(ref.name).toString() : ref.name;
                        topLevelDefinitions.add(fullName);
                    }
                    continue;
                }
                if (!(n instanceof ImportDirectiveNode) && !(n instanceof IncludeDirectiveNode) && !(n instanceof UseDirectiveNode)) continue;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        if (!authplug.class_provided) {
            return;
        }
        int size2 = topLevelDefinitions.size();
        if (size2 > 1) {
            Iterator<String> iter = topLevelDefinitions.iterator();
            ((AuthCompilerHandler)authplug.handler).authError(5006, AuthBatchCompiler.colonClassnameToDotClassname(iter.next()), AuthBatchCompiler.colonClassnameToDotClassname(iter.next()));
        } else if (size2 < 1) {
            if (AuthBatchCompiler.s.errCount == 0) {
                ((AuthCompilerHandler)authplug.handler).authError(5007, "", "");
            }
        } else {
            String pathName;
            String fullName = topLevelDefinitions.iterator().next();
            String[] splitNames = fullName.split(":");
            String defPackage = splitNames.length > 1 ? splitNames[0] : "";
            String defName = splitNames.length > 1 ? splitNames[1] : splitNames[0];
            int dotIndex = authplug.classname.lastIndexOf(46);
            String pathPackage = dotIndex >= 0 ? authplug.classname.substring(0, dotIndex) : "";
            String string = pathName = dotIndex >= 0 ? authplug.classname.substring(dotIndex + 1) : authplug.classname;
            if (!defPackage.equals(pathPackage)) {
                ((AuthCompilerHandler)authplug.handler).authError(5001, defPackage, authplug.filename);
            }
            if (!defName.equals(pathName)) {
                ((AuthCompilerHandler)authplug.handler).authError(5008, defName, authplug.filename);
            }
        }
    }

    private static Set<Pair> getGlobalSetForType(String depType) {
        if (depType == "i") {
            return inheritance;
        }
        if (depType == "n") {
            return namespaces;
        }
        if (depType == "s") {
            return type;
        }
        if (depType == "e") {
            return expressions;
        }
        return null;
    }

    private static Set<String> getPlugSetForType(AuthCompilerPlug plug, String depType) {
        if (depType == "i") {
            return plug.getInheritance();
        }
        if (depType == "n") {
            return plug.getNamespaces();
        }
        if (depType == "s") {
            return plug.getType();
        }
        if (depType == "e") {
            return plug.getExpressions();
        }
        return null;
    }

    private static void addDependency(int depIndex, int defIndex, String depType, String fullname) {
        AuthCompilerPlug plugDep;
        if (depIndex != defIndex) {
            Pair p = new Pair(AuthBatchCompiler.getHandlerKey(depIndex), AuthBatchCompiler.getHandlerKey(defIndex));
            Set<Pair> globSet = AuthBatchCompiler.getGlobalSetForType(depType);
            globSet.add(p);
        }
        if (swcForExport != null && fullname.length() > 0 && (plugDep = (AuthCompilerPlug)plugs.get(depIndex)) != null) {
            Set<String> plugSet = AuthBatchCompiler.getPlugSetForType(plugDep, depType);
            plugSet.add(fullname);
        }
    }

    private static void addDeps(AuthCompilerPlug plug, SwcDependencySet depset, String type) {
        Set<String> theSet = AuthBatchCompiler.getPlugSetForType(plug, type);
        Iterator iterator = depset.getDependencyIterator(type);
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            theSet.add((String)iterator.next());
        }
    }

    private static void resolveDependenciesForSwcPlug(int i, String depType) throws Throwable {
        if (cx.get(i).errorCount() > 0) {
            return;
        }
        AuthCompilerPlug plug = (AuthCompilerPlug)plugs.get(i);
        try {
            if (plug.abcDependenciesResolved.get(depType) != null) {
                return;
            }
        }
        catch (NullPointerException npe) {
            plug.abcDependenciesResolved = new HashMap(4);
        }
        plug.abcDependenciesResolved.put(depType, depType);
        boolean found = false;
        Set<String> depSet = AuthBatchCompiler.getPlugSetForType(plug, depType);
        for (String fullname : depSet) {
            int where = -1;
            if (depType == "i" || depType == "s") {
                where = AuthBatchCompiler.findClass(fullname);
            } else if (depType == "n" || depType == "e") {
                where = AuthBatchCompiler.findDefinition(fullname, false);
            }
            if (where != -1) {
                AuthBatchCompiler.addDependency(i, where, depType, fullname);
                found = true;
            }
            if (found) continue;
            System.err.println(new StringBuffer().append(fullname.replace(":", "::")).append(" in ").append(plug.scriptname).append(" not resolved").toString());
        }
    }

    private static void resolveDependenciesForNode(int i, Set<ReferenceValue> unresolvedSet, String depType) throws Throwable {
        for (ReferenceValue ref : unresolvedSet) {
            int size;
            boolean found = false;
            int n = size = ref.getImmutableNamespaces() != null ? ref.getImmutableNamespaces().size() : 0;
            for (int j = 0; j < size; ++j) {
                QName qname = new QName((ObjectValue)ref.getImmutableNamespaces().get(j), ref.name);
                int where = -1;
                if (depType == "i" || depType == "s") {
                    where = AuthBatchCompiler.findClass(qname);
                } else if (depType == "n" || depType == "e") {
                    where = AuthBatchCompiler.findDefinition(qname, false);
                }
                if (where == -1) continue;
                boolean okayToAdd = true;
                if (depType != "i" || i != where || swcForExport != null) {
                    // empty if block
                }
                if (okayToAdd) {
                    AuthBatchCompiler.addDependency(i, where, depType, qname.toString());
                }
                found = true;
                break;
            }
            if (found) continue;
            System.err.println(new StringBuffer().append(ref.toMultiName()).append(" in ").append(((AuthCompilerPlug)AuthBatchCompiler.plugs.get((int)i)).scriptname).append(" not resolved").toString());
        }
        unresolvedSet.clear();
    }

    private static void fa_part1(int start, int end) {
        for (int i = start; i < end; ++i) {
            if (cx.get(i).errorCount() == 0 && AuthBatchCompiler.node.get((int)i).state == 1) {
                cx.get(i).pushScope(new ObjectValue(cx.get(i), new GlobalBuilder(), null));
                FlowGraphEmitter fgEmitter = new FlowGraphEmitter(cx.get(i), ((AuthCompilerPlug)AuthBatchCompiler.plugs.get((int)i)).pathspec, false);
                fa.add(new FlowAnalyzer(fgEmitter));
                node.get(i).evaluate(cx.get(i), fa.get(i));
                cx.get(i).popScope();
                continue;
            }
            fa.add(null);
        }
    }

    private static void resolveInheritance(int start, int end) throws Throwable {
        for (int i = start; i < end; ++i) {
            if (((AuthCompilerPlug)AuthBatchCompiler.plugs.get((int)i)).abc == null) {
                AuthBatchCompiler.resolveDependenciesForNode(i, AuthBatchCompiler.node.get((int)i).fa_unresolved, "i");
                AuthBatchCompiler.resolveDependenciesForNode(i, AuthBatchCompiler.node.get((int)i).ns_unresolved, "n");
                continue;
            }
            AuthBatchCompiler.resolveDependenciesForSwcPlug(i, "i");
            AuthBatchCompiler.resolveDependenciesForSwcPlug(i, "n");
        }
    }

    private static String getHandlerKey(int index) {
        if (plugs.size() > index) {
            return AuthBatchCompiler.getHandlerKey((AuthCompilerPlug)plugs.get(index));
        }
        return "";
    }

    private static String getHandlerKey(AuthCompilerPlug cplug) {
        return cplug.handlerKey;
    }

    private static int handlerKeyToIndex(String key) {
        int length = plugs.size();
        for (int i = 0; i < length; ++i) {
            if (AuthBatchCompiler.getHandlerKey(i) != key) continue;
            return i;
        }
        return -1;
    }

    private static void sortInheritance() throws Throwable {
        DependencyGraph<Integer> g = new DependencyGraph<Integer>();
        int length = node.size();
        for (int i = 0; i < length; ++i) {
            AuthCompilerPlug cplug = (AuthCompilerPlug)plugs.get(i);
            String handlerKey = AuthBatchCompiler.getHandlerKey(cplug);
            if (handlerKey.length() == 0) continue;
            g.put(handlerKey, Boxing.valueOf(i));
            if (!g.containsVertex(handlerKey)) {
                g.addVertex(new Vertex<String>(handlerKey));
            }
            for (Pair p : inheritance) {
                if (p.i != handlerKey || p.where.length() <= 0) continue;
                g.addDependency(handlerKey, p.where);
            }
        }
        final ArrayList tsort = new ArrayList(node.size());
        Algorithms.topologicalSort(g, new Visitor<String>(){

            @Override
            public void visit(Vertex<String> v) {
                String name = v.getWeight();
                tsort.add(name);
            }
        });
        if (node.size() > tsort.size()) {
            int length2 = node.size();
            for (int i = 0; i < length2; ++i) {
                int j;
                for (j = 0; j < tsort.size() && tsort.get(j) != AuthBatchCompiler.getHandlerKey(i); ++j) {
                }
                if (j != tsort.size()) continue;
                String handlerKey = AuthBatchCompiler.getHandlerKey(i);
                System.out.println(new StringBuffer().append(handlerKey).append(" in circular reference").toString());
            }
        } else {
            ObjectList tempPlugs = new ObjectList(plugs.size());
            ArrayList<Context> tempCX = new ArrayList<Context>(cx.size());
            ArrayList<ActionBlockEmitter> tempEmitter = new ArrayList<ActionBlockEmitter>(emitter.size());
            ArrayList<ProgramNode> tempNode = new ArrayList<ProgramNode>(node.size());
            ArrayList<FlowAnalyzer> tempFA = new ArrayList<FlowAnalyzer>(fa.size());
            int length3 = tsort.size();
            for (int i = 0; i < length3; ++i) {
                String locStr = (String)tsort.get(i);
                int loc = (Integer)g.get(locStr);
                tempPlugs.add(plugs.get(loc));
                tempCX.add(cx.get(loc));
                tempEmitter.add(emitter.get(loc));
                tempNode.add(node.get(loc));
                tempFA.add(fa.get(loc));
            }
            plugs = tempPlugs;
            cx = tempCX;
            emitter = tempEmitter;
            node = tempNode;
            fa = tempFA;
        }
    }

    private static void fa_part2() throws Throwable {
        AuthBatchCompiler.inheritSlots(inheritance);
        AuthBatchCompiler.inheritSlots(namespaces);
        int length = plugs.size();
        for (int i = 0; i < length; ++i) {
            if (cx.get(i).errorCount() != 0 || AuthBatchCompiler.node.get((int)i).state != 2 || fa.get(i) == null) continue;
            cx.get(i).pushScope(AuthBatchCompiler.node.get((int)i).frame);
            node.get(i).evaluate(cx.get(i), fa.get(i));
            cx.get(i).popScope();
        }
    }

    private static void resolveType() throws Throwable {
        int i;
        int length = node.size();
        for (i = 0; i < length; ++i) {
            if (((AuthCompilerPlug)AuthBatchCompiler.plugs.get((int)i)).abc == null) {
                AuthBatchCompiler.resolveDependenciesForNode(i, AuthBatchCompiler.node.get((int)i).ce_unresolved, "s");
                continue;
            }
            AuthBatchCompiler.resolveDependenciesForSwcPlug(i, "s");
        }
        length = node.size();
        for (i = 0; i < length; ++i) {
            if (((AuthCompilerPlug)AuthBatchCompiler.plugs.get((int)i)).abc != null) continue;
            AuthBatchCompiler.resolveDependenciesForNode(i, AuthBatchCompiler.node.get((int)i).body_unresolved, "s");
        }
        length = node.size();
        for (i = 0; i < length; ++i) {
            if (((AuthCompilerPlug)AuthBatchCompiler.plugs.get((int)i)).abc != null) continue;
            AuthBatchCompiler.resolveDependenciesForNode(i, AuthBatchCompiler.node.get((int)i).ns_unresolved, "n");
        }
    }

    private static void ce_part1() {
        int length = plugs.size();
        for (int i = 0; i < length; ++i) {
            if (i < ce.size()) continue;
            if (cx.get(i).errorCount() == 0 && emitter.get(i) != null) {
                cx.get(i).pushScope(AuthBatchCompiler.node.get((int)i).frame);
                if (AuthBatchCompiler.mainplug.emit_metadata && !((AuthCompilerPlug)AuthBatchCompiler.plugs.get((int)i)).isInternal) {
                    MetaDataEvaluator printer = new MetaDataEvaluator(true);
                    node.get(i).evaluate(cx.get(i), printer);
                }
                ConstantEvaluator analyzer = new ConstantEvaluator(cx.get(i));
                ce.add(analyzer);
                analyzer.PreprocessDefinitionTypeInfo(cx.get(i), node.get(i));
                cx.get(i).popScope();
                continue;
            }
            ce.add(null);
        }
    }

    private static void ce_part2() {
        int length = plugs.size();
        for (int i = 0; i < length; ++i) {
            ConstantEvaluator analyzer;
            if (i >= ce.size()) {
                return;
            }
            if (cx.get(i).errorCount() != 0 || emitter.get(i) == null || (analyzer = ce.get(i)) == null) continue;
            cx.get(i).pushScope(AuthBatchCompiler.node.get((int)i).frame);
            AuthBatchCompiler.processUnresolvedNamespacesForFrames(i);
            node.get(i).evaluate(cx.get(i), analyzer);
            cx.get(i).popScope();
        }
    }

    private static void processUnresolvedNamespacesForFrames(int plugIndex) {
        AuthCompilerPlug plug = (AuthCompilerPlug)plugs.get(plugIndex);
        if (plug == null || plug.includes == null || plug.includes.size() == 0) {
            return;
        }
        for (IncludeInfo iinfo : plug.includes) {
            if (iinfo == null || iinfo.cx == null) continue;
            iinfo.cx.processUnresolvedNamespaces();
        }
    }

    private static void lintEvaluate() throws Throwable {
        int length = plugs.size();
        for (int i = 0; i < length; ++i) {
            if (((AuthCompilerPlug)AuthBatchCompiler.plugs.get((int)i)).filename.endsWith(".abc") || ((AuthCompilerPlug)AuthBatchCompiler.plugs.get((int)i)).abc != null || cx.get(i).errorCount() != 0 || emitter.get(i) == null) continue;
            cx.get(i).pushScope(AuthBatchCompiler.node.get((int)i).frame);
            LintEvaluator lintEval = new LintEvaluator(cx.get(i), AuthBatchCompiler.getHandlerKey((AuthCompilerPlug)plugs.get(i)), AuthBatchCompiler.mainplug.enabled_file);
            node.get(i).evaluate(cx.get(i), lintEval);
            lintEval.setOutputToFile(false);
            lintEval.logWarnings(cx.get(i));
            lintEval.clear();
            cx.get(i).popScope();
        }
    }

    private static String uiactionEvaluate(Context ctxt, ProgramNode nodeTree) throws Throwable {
        UIActionsEvaluator uiactionEval = new UIActionsEvaluator(ctxt);
        uiactionEval.evaluate(ctxt, nodeTree);
        ObjectList<Node> comments = ctxt.getComments();
        UIActionList actionlist = uiactionEval.getActionList();
        ListIterator it = comments.listIterator();
        block11: while (it.hasNext()) {
            int comment_pos;
            CommentNode comment = (CommentNode)it.next();
            int comment_endpos = comment_pos = comment.getPosition();
            UIActionComment commentAction = new UIActionComment();
            String tstr = comment.toString();
            if (tstr.length() == 0) {
                switch (comment.getType()) {
                    case -128: {
                        tstr = "/**/";
                        break;
                    }
                    case -129: {
                        tstr = "//";
                    }
                }
            } else if (comment_pos > -1) {
                String source = ctxt.input.source();
                int spos = 0;
                switch (comment.getType()) {
                    case -128: {
                        spos = comment_pos - 1;
                        if (spos > -1 && spos < source.length() - 2 && source.charAt(spos) == '/' && source.charAt(spos + 1) == '*') {
                            comment_pos = spos;
                        }
                        comment_endpos = source.indexOf("*/", comment_pos) + 2;
                        break;
                    }
                    case -129: {
                        spos = comment_pos - 1;
                        if (spos > -1 && spos < source.length() - 2 && source.charAt(spos) == '/' && source.charAt(spos + 1) == '/') {
                            comment_pos = spos;
                        }
                        comment_endpos = source.indexOf(13, comment_pos);
                    }
                }
                if (comment_endpos > -1) {
                    String sourcecomment = source.substring(comment_pos, comment_endpos);
                    String out = "";
                    for (int i = 0; i < sourcecomment.length(); ++i) {
                        switch (sourcecomment.charAt(i)) {
                            case '\\': {
                                int j = i + 1;
                                if (j >= sourcecomment.length() || sourcecomment.charAt(j) != '0' || ++j >= sourcecomment.length() || sourcecomment.charAt(j) != '0') break;
                                i = j;
                                out = new StringBuffer().append(out).append("/x00").toString();
                            }
                        }
                        out = new StringBuffer().append(out).append(sourcecomment.charAt(i)).toString();
                    }
                    tstr = out;
                }
            }
            commentAction.SetComment(tstr);
            if (actionlist == null) continue;
            int lastPos = -1;
            if (actionlist.size() > 0) {
                lastPos = ((UIAction)actionlist.lastElement()).GetNodeStartPosition();
            }
            if (lastPos != -1 && comment_pos > lastPos) {
                actionlist.add(commentAction);
                continue;
            }
            for (int i = 0; i < actionlist.size(); ++i) {
                UIAction action = (UIAction)actionlist.elementAt(i);
                int pos = action.GetNodeStartPosition();
                if (comment_pos >= pos) continue;
                actionlist.insertElementAt(commentAction, i);
                continue block11;
            }
        }
        String xmlstring = "<?xml version=\"1.0\"?> <UIActionList> ";
        if (actionlist != null) {
            for (int i = 0; i < actionlist.size(); ++i) {
                UIAction action = (UIAction)actionlist.elementAt(i);
                xmlstring = new StringBuffer().append(xmlstring).append(action.toXML()).toString();
            }
        }
        xmlstring = new StringBuffer().append(xmlstring).append(" </UIActionList>").toString();
        return xmlstring;
    }

    private static boolean isSubclass(QName baseClass, ClassBuilder bui) {
        String baseClassName;
        String buiName = AuthBatchCompiler.colonClassnameToDotClassname(bui.classname.toString());
        if (buiName.compareTo(baseClassName = AuthBatchCompiler.colonClassnameToDotClassname(baseClass.toString())) == 0) {
            return true;
        }
        if (bui.basebui != null && bui.basebui instanceof ClassBuilder) {
            return AuthBatchCompiler.isSubclass(baseClass, bui.basebui);
        }
        return false;
    }

    private static void checkBaseClasses() {
        int length = plugs.size();
        for (int i = 0; i < length; ++i) {
            ProgramNode pnode;
            boolean shouldCheckBase;
            AuthCompilerPlug cplug = (AuthCompilerPlug)plugs.get(i);
            if (cplug == null) continue;
            String requiredBaseClass = cplug.expectedBaseClass;
            boolean bl = shouldCheckBase = cplug.class_provided && cplug.make_movieclip || cplug.base_classname != null && !cplug.base_classname.equals(cplug.expectedBaseClass);
            if (!shouldCheckBase || requiredBaseClass == null || requiredBaseClass.length() <= 0 || (pnode = node.get(i)) == null || pnode.clsdefs == null || pnode.clsdefs.size() <= 0) continue;
            ClassDefinitionNode cdn = (ClassDefinitionNode)pnode.clsdefs.get(0);
            if (cdn.cframe == null || cdn.cframe.builder == null) continue;
            boolean foundBaseClass = AuthBatchCompiler.isSubclass(new QName(null, requiredBaseClass), (ClassBuilder)cdn.cframe.builder);
            if (!foundBaseClass && requiredBaseClass.equals("flash.display.MovieClip")) {
                foundBaseClass = AuthBatchCompiler.isSubclass(new QName(null, "flash.display.Sprite"), (ClassBuilder)cdn.cframe.builder);
            }
            if (foundBaseClass || cplug.handler == null || mainplug != null && AuthBatchCompiler.mainplug.swcFileName != null && AuthBatchCompiler.mainplug.swcFileName.equals("dummy_for_GenerateClassXML")) continue;
            String classForError = cplug.class_provided ? cplug.classname : cplug.base_classname;
            ((AuthCompilerHandler)cplug.handler).authError(5000, classForError, requiredBaseClass);
            ++AuthBatchCompiler.s.errCount;
        }
    }

    private static void markLoaderFramePlugs() throws Throwable {
        if (docClassHandlerKey.length() == 0) {
            return;
        }
        int docClassIndex = AuthBatchCompiler.handlerKeyToIndex(docClassHandlerKey);
        if (docClassIndex == -1) {
            return;
        }
        AuthCompilerPlug docClassPlug = (AuthCompilerPlug)plugs.get(docClassIndex);
        docClassPlug.inLoaderFrame = false;
        AuthBatchCompiler.markLoaderFrameDeps(docClassIndex);
    }

    private static void markLoaderFrameDeps(int plugIndex) {
        AuthCompilerPlug plug = (AuthCompilerPlug)plugs.get(plugIndex);
        if (plug.isInternal) {
            return;
        }
        if (plug.inLoaderFrame) {
            return;
        }
        plug.inLoaderFrame = true;
        AuthBatchCompiler.markLoaderFrameGlobSet("i", plugIndex);
        AuthBatchCompiler.markLoaderFrameGlobSet("n", plugIndex);
        AuthBatchCompiler.markLoaderFrameGlobSet("s", plugIndex);
        AuthBatchCompiler.markLoaderFrameGlobSet("e", plugIndex);
    }

    private static void markLoaderFrameGlobSet(String depType, int plugIndex) {
        Set<Pair> globSet = AuthBatchCompiler.getGlobalSetForType(depType);
        Iterator<Pair> iter = globSet.iterator();
        if (iter == null) {
            return;
        }
        String handlerKey = AuthBatchCompiler.getHandlerKey(plugIndex);
        while (iter.hasNext()) {
            Pair p = iter.next();
            if (p.i != handlerKey) continue;
            AuthBatchCompiler.markLoaderFrameDeps(AuthBatchCompiler.handlerKeyToIndex(p.where));
        }
    }

    private static void codeGenerate() throws Throwable {
        if (AuthBatchCompiler.s.errCount > 0) {
            return;
        }
        if (AuthBatchCompiler.mainplug.optimize) {
            doABCsToOptimize = new ArrayList(plugs.size());
            doABCsToOptimizeLoaderFrame = new ArrayList(plugs.size());
        }
        int length = plugs.size();
        for (int i = 0; i < length; ++i) {
            AuthCompilerPlug plug = (AuthCompilerPlug)plugs.get(i);
            AuthCompilerHandler handler = plug.getHandler();
            if (plug.isInternal || handler == null) continue;
            if (plug.abc != null) {
                if (AuthBatchCompiler.mainplug.optimize) {
                    DoABC doABC = new DoABC(null, 1);
                    doABC.abc = plug.abc;
                    if (plug.inLoaderFrame) {
                        doABCsToOptimizeLoaderFrame.add(doABC);
                        continue;
                    }
                    doABCsToOptimize.add(doABC);
                    continue;
                }
                String abcName = "";
                if (swcForExport != null) {
                    abcName = AuthBatchCompiler.dotClassnameToSlashClassname(plug.classname);
                }
                ByteList abcBytes = new ByteList(0);
                abcBytes.set(plug.abc, plug.abc.length);
                handler.writeBytes(abcName, abcBytes, plug.inLoaderFrame);
                continue;
            }
            if (cx.get(i).errorCount() != 0 || emitter.get(i) == null) continue;
            cx.get(i).setEmitter(emitter.get(i));
            cx.get(i).pushScope(AuthBatchCompiler.node.get((int)i).frame);
            try {
                CodeGenerator generator = new CodeGenerator(cx.get(i).getEmitter());
                String currentErrorOrigin = "";
                if (AuthBatchCompiler.mainplug.emit_debug_info) {
                    currentErrorOrigin = cx.get(i).getErrorOrigin();
                    String plugErrorOrigin = AuthBatchCompiler.getErrorOrigin(plug.classname, currentErrorOrigin);
                    cx.get(i).setOrigin(plugErrorOrigin);
                }
                node.get(i).evaluate(cx.get(i), generator);
                if (AuthBatchCompiler.mainplug.emit_debug_info) {
                    cx.get(i).setOrigin(currentErrorOrigin);
                }
                ByteList bytes = new ByteList();
                cx.get(i).getEmitter().emit(bytes);
                emitter.set(i, null);
                if (AuthBatchCompiler.mainplug.optimize) {
                    DoABC doABC = new DoABC(null, 1);
                    doABC.abc = bytes.toByteArray(false);
                    if (plug.inLoaderFrame) {
                        doABCsToOptimizeLoaderFrame.add(doABC);
                    } else {
                        doABCsToOptimize.add(doABC);
                    }
                } else {
                    String bytesName = "";
                    if (swcForExport != null) {
                        bytesName = AuthBatchCompiler.dotClassnameToSlashClassname(plug.classname);
                    }
                    handler.writeBytes(bytesName, bytes, plug.inLoaderFrame);
                }
                if (AuthBatchCompiler.mainplug.emit_metadata) {
                    abcToParse.add(bytes);
                }
            }
            catch (Throwable t) {
                ((AuthCompilerHandler)plug.handler).authError(5003, "", "");
            }
            cx.get(i).popScope();
        }
    }

    private static String getErrorOrigin(String classname, String path) {
        if (classname.length() == 0) {
            return path;
        }
        try {
            int classnameIndex;
            String errorOrigin = "";
            String lastClassname = classname;
            int dotIndex = classname.indexOf(46);
            if (dotIndex > -1) {
                String firstPackage;
                String wholePackage = firstPackage = classname.substring(0, dotIndex);
                int firstPackageIndex = path.lastIndexOf(new StringBuffer().append(File.separatorChar).append(firstPackage).append(File.separatorChar).toString());
                if (firstPackageIndex > -1) {
                    int lastDotIndex = classname.lastIndexOf(46);
                    if (lastDotIndex > dotIndex + 1) {
                        wholePackage = classname.substring(0, lastDotIndex);
                        wholePackage = wholePackage.replace('.', File.separatorChar);
                    }
                    if (lastDotIndex > -1) {
                        lastClassname = classname.substring(lastDotIndex + 1);
                    }
                    errorOrigin = path.substring(0, firstPackageIndex);
                    errorOrigin = new StringBuffer().append(errorOrigin).append(";").toString();
                    errorOrigin = new StringBuffer().append(errorOrigin).append(wholePackage).toString();
                    errorOrigin = new StringBuffer().append(errorOrigin).append(";").toString();
                }
            }
            if ((classnameIndex = path.lastIndexOf(new StringBuffer().append(File.separatorChar).append(lastClassname).append(".").toString())) > -1) {
                if (dotIndex == -1) {
                    errorOrigin = path.substring(0, classnameIndex);
                    errorOrigin = new StringBuffer().append(errorOrigin).append(";;").toString();
                }
                errorOrigin = new StringBuffer().append(errorOrigin).append(path.substring(classnameIndex + 1)).toString();
                return errorOrigin;
            }
        }
        finally {
            return path;
        }
        {
        }
    }

    private static void writeOptimizedABC() throws Throwable {
        if (AuthBatchCompiler.s.errCount > 0) {
            return;
        }
        try {
            if (doABCsToOptimize != null && !doABCsToOptimize.isEmpty()) {
                Optimizer.merge(doABCsToOptimize, AuthBatchCompiler.mainplug.emit_debug_info, true, "");
            }
            if (doABCsToOptimizeLoaderFrame != null && !doABCsToOptimizeLoaderFrame.isEmpty()) {
                Optimizer.merge(doABCsToOptimizeLoaderFrame, AuthBatchCompiler.mainplug.emit_debug_info, true, "");
            }
            int length = plugs.size();
            for (int i = 0; i < length; ++i) {
                AuthCompilerPlug plug = (AuthCompilerPlug)plugs.get(i);
                AuthCompilerHandler handler = plug.getHandler();
                if (plug.isInternal || handler == null) continue;
                byte[] abcBytes = null;
                ArrayList<DoABC> doABCs = null;
                if (plug.inLoaderFrame) {
                    doABCs = doABCsToOptimizeLoaderFrame;
                    doABCsToOptimizeLoaderFrame = null;
                } else {
                    doABCs = doABCsToOptimize;
                    doABCsToOptimize = null;
                }
                if (doABCs != null) {
                    DoABC doABC = (DoABC)doABCs.get(0);
                    abcBytes = doABC.abc;
                }
                handler.writeBytes("", abcBytes, plug.inLoaderFrame);
            }
        }
        catch (Throwable t) {
            ((AuthCompilerHandler)AuthBatchCompiler.s.handler).authError(5005, "", "");
        }
    }

    private static void resolveExpression() throws Throwable {
        int length = node.size();
        for (int i = 0; i < length; ++i) {
            if (((AuthCompilerPlug)AuthBatchCompiler.plugs.get((int)i)).abc == null) {
                AuthBatchCompiler.resolveDependenciesForNode(i, AuthBatchCompiler.node.get((int)i).rt_unresolved, "e");
                continue;
            }
            AuthBatchCompiler.resolveDependenciesForSwcPlug(i, "e");
        }
    }

    private static void inheritSlots(Set<Pair> dependencySet) {
        for (Pair p : dependencySet) {
            if (p.processed) continue;
            int iIndex = AuthBatchCompiler.handlerKeyToIndex(p.i);
            int whereIndex = AuthBatchCompiler.handlerKeyToIndex(p.where);
            if (fa.get(iIndex) != null && AuthBatchCompiler.node.get((int)whereIndex).frame != null && AuthBatchCompiler.node.get((int)iIndex).frame != null && AuthBatchCompiler.node.get((int)iIndex).frame.builder != null) {
                fa.get(iIndex).inheritContextSlots(AuthBatchCompiler.node.get((int)whereIndex).frame, AuthBatchCompiler.node.get((int)iIndex).frame, AuthBatchCompiler.node.get((int)iIndex).frame.builder, cx.get(iIndex));
            }
            p.processed = true;
        }
    }

    private static void resolveImportStatements() throws Throwable {
        int length = node.size();
        for (int i = 0; i < length; ++i) {
            Context context = cx.get(i);
            for (ReferenceValue ref : AuthBatchCompiler.node.get((int)i).package_unresolved) {
                ObjectValue ns;
                if (!AuthBatchCompiler.hasPackage(ref.name) || (ns = context.getNamespace(ref.name)) == null) continue;
                ns.setPackage(true);
            }
            for (ReferenceValue ref : AuthBatchCompiler.node.get((int)i).import_def_unresolved) {
                QName defName;
                NamespaceValue nsValue;
                byte nsKind;
                int j = 0;
                int length2 = ref.namespaces.size();
                if (j >= length2 || (nsKind = (nsValue = (NamespaceValue)ref.namespaces.get(j)).getNamespaceKind()) != 0 && nsKind != 1 || !AuthBatchCompiler.hasDefinition(defName = new QName(nsValue, ref.name))) continue;
                context.addValidImport(defName.toString());
            }
        }
    }

    private static void clear() {
        s.clear();
        ObjectValue.clear();
        TypeValue.clear();
    }

    private static boolean hasPackage(String packageName) {
        if (swcPackageNames.contains(packageName)) {
            return true;
        }
        if (AuthBatchCompiler.mainplug.handler instanceof AuthCompilerHandler) {
            return ((AuthCompilerHandler)AuthBatchCompiler.mainplug.handler).hasPackage(packageName);
        }
        return false;
    }

    private static boolean hasDefinition(QName defName) throws Throwable {
        return AuthBatchCompiler.findDefinition(defName, true) != -1;
    }

    private static boolean hasDefinition(String defName) throws Throwable {
        return AuthBatchCompiler.findDefinition(defName, true) != -1;
    }

    private static int findDefinition(QName defName, boolean searchOnly) throws Throwable {
        int swcPlugIndex = -1;
        String dotDefName = AuthBatchCompiler.colonClassnameToDotClassname(defName.toString());
        int length = node.size();
        for (int i = 0; i < length; ++i) {
            try {
                if (((AuthCompilerPlug)AuthBatchCompiler.plugs.get((int)i)).isSwcPlug) {
                    if (!((AuthCompilerPlug)plugs.get(i)).getTopLevelDefinitions().contains(dotDefName)) continue;
                    swcPlugIndex = i;
                    break;
                }
                Names names = AuthBatchCompiler.node.get((int)i).frame.builder.getNames();
                for (int j = 0; j < 4; ++j) {
                    if (!names.containsKey(defName.name, defName.ns, j)) continue;
                    return i;
                }
                continue;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        int resultIndex = -1;
        if (!linkingLivePreview) {
            resultIndex = AuthBatchCompiler.searchClasspath(defName.toString(), searchOnly);
        }
        if (resultIndex < 0 && swcPlugIndex >= 0) {
            return swcPlugIndex;
        }
        if (resultIndex < 0) {
            resultIndex = AuthBatchCompiler.searchSwcGroup(defName.toString(), searchOnly, null, -1);
        }
        return resultIndex;
    }

    private static int findDefinition(String defName, boolean searchOnly) throws Throwable {
        int swcPlugIndex = -1;
        String[] tokens = defName.split(":");
        String name = tokens.length > 1 ? tokens[1] : defName;
        name = name.intern();
        ObjectValue ns = cx.get(0).getNamespace(tokens.length > 1 ? tokens[0] : "");
        String dotDefName = AuthBatchCompiler.colonClassnameToDotClassname(defName.toString());
        int length = node.size();
        for (int i = 0; i < length; ++i) {
            try {
                if (((AuthCompilerPlug)AuthBatchCompiler.plugs.get((int)i)).isSwcPlug) {
                    if (!((AuthCompilerPlug)plugs.get(i)).getTopLevelDefinitions().contains(dotDefName)) continue;
                    swcPlugIndex = i;
                    break;
                }
                if (((AuthCompilerPlug)AuthBatchCompiler.plugs.get((int)i)).isSwcPlug) continue;
                Names names = AuthBatchCompiler.node.get((int)i).frame.builder.getNames();
                for (int j = 0; j < 4; ++j) {
                    if (!names.containsKey(name, ns, j)) continue;
                    return i;
                }
                continue;
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        int resultIndex = -1;
        if (!linkingLivePreview) {
            resultIndex = AuthBatchCompiler.searchClasspath(defName, searchOnly);
        }
        if (resultIndex < 0 && swcPlugIndex >= 0) {
            return swcPlugIndex;
        }
        if (resultIndex < 0) {
            resultIndex = AuthBatchCompiler.searchSwcGroup(defName.toString(), searchOnly, null, -1);
        }
        return resultIndex;
    }

    private static int findClass(QName className) throws Throwable {
        int swcPlugIndex = -1;
        String dotClassName = AuthBatchCompiler.colonClassnameToDotClassname(className.toString());
        int length = node.size();
        for (int i = 0; i < length; ++i) {
            int size;
            if (((AuthCompilerPlug)AuthBatchCompiler.plugs.get((int)i)).isSwcPlug) {
                if (!((AuthCompilerPlug)plugs.get(i)).getTopLevelDefinitions().contains(dotClassName)) continue;
                swcPlugIndex = i;
                break;
            }
            int n = size = AuthBatchCompiler.node.get((int)i).clsdefs != null ? AuthBatchCompiler.node.get((int)i).clsdefs.size() : 0;
            for (int j = 0; j < size; ++j) {
                ClassDefinitionNode clsdef = (ClassDefinitionNode)AuthBatchCompiler.node.get((int)i).clsdefs.get(j);
                try {
                    if (!clsdef.cframe.builder.classname.equals(className)) continue;
                    return i;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        int resultIndex = -1;
        if (!linkingLivePreview) {
            resultIndex = AuthBatchCompiler.searchClasspath(className.toString(), false);
        }
        if (resultIndex < 0 && swcPlugIndex >= 0) {
            return swcPlugIndex;
        }
        if (resultIndex < 0) {
            resultIndex = AuthBatchCompiler.searchSwcGroup(className.toString(), false, null, -1);
        }
        return resultIndex;
    }

    private static int findClass(String className) throws Throwable {
        int swcPlugIndex = -1;
        String dotClassName = AuthBatchCompiler.colonClassnameToDotClassname(className);
        int length = node.size();
        for (int i = 0; i < length; ++i) {
            int size;
            if (((AuthCompilerPlug)AuthBatchCompiler.plugs.get((int)i)).isSwcPlug) {
                if (!((AuthCompilerPlug)plugs.get(i)).getTopLevelDefinitions().contains(dotClassName)) continue;
                swcPlugIndex = i;
                break;
            }
            int n = size = AuthBatchCompiler.node.get((int)i).clsdefs != null ? AuthBatchCompiler.node.get((int)i).clsdefs.size() : 0;
            for (int j = 0; j < size; ++j) {
                ClassDefinitionNode clsdef = (ClassDefinitionNode)AuthBatchCompiler.node.get((int)i).clsdefs.get(j);
                try {
                    if (!clsdef.cframe.builder.classname.toString().equals(className)) continue;
                    return i;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
        }
        int resultIndex = -1;
        if (!linkingLivePreview) {
            resultIndex = AuthBatchCompiler.searchClasspath(className, false);
        }
        if (resultIndex < 0 && swcPlugIndex >= 0) {
            return swcPlugIndex;
        }
        if (resultIndex < 0) {
            resultIndex = AuthBatchCompiler.searchSwcGroup(className, false, null, -1);
        }
        return resultIndex;
    }

    private static void resolvePlayerglobal() {
        ArrayList<Integer> playerglobals = new ArrayList<Integer>();
        ArrayList<Integer> lintModePlugs = new ArrayList<Integer>();
        int numPlugs = plugs.size();
        for (int i = 0; i < numPlugs; ++i) {
            AuthCompilerPlug plug = (AuthCompilerPlug)plugs.get(i);
            if (plug == null) continue;
            if (plug.isPlayerglobalPlug) {
                playerglobals.add(new Integer(i));
                continue;
            }
            if (plug.isInternal) continue;
            lintModePlugs.add(new Integer(i));
        }
        int numPlayerglobals = playerglobals.size();
        int numLintModePlugs = lintModePlugs.size();
        for (int i = 0; i < numLintModePlugs; ++i) {
            int plugIndex = (Integer)lintModePlugs.get(i);
            for (int j = 0; j < numPlayerglobals; ++j) {
                AuthBatchCompiler.addDependency(plugIndex, (Integer)playerglobals.get(j), "e", "");
            }
        }
        AuthBatchCompiler.inheritSlots(expressions);
    }

    private static int searchSwcGroup(String fullname, boolean searchOnly, AuthCompilerPlug plug, int plugIndex) {
        try {
            boolean isInternal = false;
            SwcScript swcScript = null;
            if (swcGroup != null) {
                swcScript = (SwcScript)swcGroup.getScriptMap().get(fullname);
            }
            if (swcScript == null) {
                isInternal = true;
                swcScript = (SwcScript)classPathSwcGroup.getScriptMap().get(fullname);
            }
            if (swcScript.getPlugHandlerKey() != null) {
                if (!searchOnly) {
                    AuthCompilerPlug addDefPlug = (AuthCompilerPlug)plugs.get(AuthBatchCompiler.handlerKeyToIndex(swcScript.getPlugHandlerKey()));
                    addDefPlug.getTopLevelDefinitions().add(AuthBatchCompiler.colonClassnameToDotClassname(fullname));
                }
                return AuthBatchCompiler.handlerKeyToIndex(swcScript.getPlugHandlerKey());
            }
            if (searchOnly) {
                return 0;
            }
            AuthCompilerPlug abcPlug = plug != null ? plug : new AuthCompilerPlug();
            abcPlug.classname = AuthBatchCompiler.colonClassnameToDotClassname(fullname);
            abcPlug.scriptname = abcPlug.filename = new StringBuffer().append(swcScript.getLibrary().getSwcLocation()).append("(").append(swcScript.getName()).append(")").toString();
            abcPlug.lastModified = swcScript.getLastModified();
            abcPlug.isInternal = isInternal;
            abcPlug.isSwcPlug = true;
            abcPlug.setHandlerKey(abcPlug.filename);
            swcScript.setPlugHandlerKey(abcPlug.filename);
            abcPlug.abc = swcScript.getDoABC().abc;
            SwcDependencySet depSet = swcScript.getDependencySet();
            AuthBatchCompiler.addDeps(abcPlug, depSet, "i");
            AuthBatchCompiler.addDeps(abcPlug, depSet, "s");
            AuthBatchCompiler.addDeps(abcPlug, depSet, "e");
            AuthBatchCompiler.addDeps(abcPlug, depSet, "n");
            Set<String> topLevelDefs = abcPlug.getTopLevelDefinitions();
            topLevelDefs.add(AuthBatchCompiler.colonClassnameToDotClassname(fullname));
            Iterator defIter = swcScript.getDefinitionIterator();
            while (defIter.hasNext()) {
                String defStr = (String)defIter.next();
                topLevelDefs.add(defStr);
            }
            if (plug == null) {
                SwcLibrary swcLib;
                plugs.add(abcPlug);
                if (isInternal && (swcLib = swcScript.getLibrary()) != null && AuthBatchCompiler.isPlayerglobalSwc(swcLib.getArchivePath())) {
                    abcPlug.isPlayerglobalPlug = true;
                }
                Context abcContext = new Context(s);
                abcContext.setScriptName(abcPlug.filename);
                abcContext.setPath(null);
                cx.add(abcContext);
                emitter.add(new ActionBlockEmitter(abcContext, swcScript.getName(), new StringPrintWriter(), new StringPrintWriter(), false, false, false, AuthBatchCompiler.mainplug.emit_debug_info));
            }
            return AuthBatchCompiler.handlerKeyToIndex(swcScript.getPlugHandlerKey());
        }
        catch (NullPointerException npe) {
            return -1;
        }
    }

    private static int searchClasspath(String fullname, boolean searchOnly) throws Throwable {
        String defName = AuthBatchCompiler.colonClassnameToDotClassname(fullname);
        int numPlugs = plugs.size();
        for (int j = 0; j < numPlugs; ++j) {
            if (((AuthCompilerPlug)AuthBatchCompiler.plugs.get((int)j)).classname == null || !((AuthCompilerPlug)AuthBatchCompiler.plugs.get((int)j)).classname.equals(defName)) continue;
            return j;
        }
        CompilerHandler mainHandler = AuthBatchCompiler.mainplug.handler;
        if (mainHandler instanceof AuthCompilerHandler) {
            if (searchOnly) {
                return ((AuthCompilerHandler)mainHandler).hasDefinition(defName) ? 0 : -1;
            }
            int numPlugsBefore = plugs.size();
            ((AuthCompilerHandler)mainHandler).findDefinition(defName);
            int numPlugsAfter = plugs.size();
            if (numPlugsAfter > numPlugsBefore) {
                return numPlugsAfter - 1;
            }
        }
        return -1;
    }

    private static String dotClassnameToColonClassname(String classname) {
        int index = classname.lastIndexOf(46);
        if (index >= 0) {
            StringBuffer classBuff = new StringBuffer(classname);
            classBuff.setCharAt(index, ':');
            return classBuff.toString();
        }
        return classname;
    }

    private static String colonClassnameToDotClassname(String classname) {
        return classname.replace(':', '.');
    }

    private static String dotClassnameToSlashClassname(String classname) {
        return classname.replace('.', '/');
    }

    private static String slashClassnameToDotClassname(String classname) {
        return classname.replace('/', '.');
    }

    static {
        linkingLivePreview = false;
        showedSwcDefNotFoundError = false;
    }

    static class Pair {
        String i;
        String where;
        boolean processed;

        Pair(String i, String where) {
            this.i = i;
            this.where = where;
            this.processed = false;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Pair) {
                return this.i == ((Pair)obj).i && this.where == ((Pair)obj).where;
            }
            return false;
        }

        public int hashCode() {
            return (17 + this.i.hashCode()) * 17 + this.where.hashCode();
        }
    }
}

