/*
 * Decompiled with CFR 0.152.
 */
package flash.util;

import flash.util.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class URLHelper {
    public static String getQueryString(String url) {
        int queryMark;
        String queryString = null;
        if (url != null && (queryMark = url.indexOf(63)) != -1) {
            queryString = url.substring(queryMark + 1);
        }
        return queryString;
    }

    public static Map getParameterMap(String queryString) {
        HashMap<String, String> map;
        if (queryString != null) {
            StringTokenizer tokens = new StringTokenizer(queryString, "?&");
            map = new HashMap(tokens.countTokens() * 2);
            while (tokens.hasMoreElements()) {
                String nameValuePair;
                String name = nameValuePair = tokens.nextToken();
                String value = "";
                int equalsIndex = nameValuePair.indexOf(61);
                if (equalsIndex != -1 && (name = nameValuePair.substring(0, equalsIndex)).length() > 0) {
                    value = nameValuePair.substring(equalsIndex + 1);
                }
                map.put(name, value);
            }
        } else {
            map = new HashMap<String, String>();
        }
        return map;
    }

    public static String encode(Map parameterMap) {
        return URLHelper.encode(parameterMap, false);
    }

    public static String encode(Map parameterMap, boolean quoteAmpersands) {
        if (parameterMap != null && !parameterMap.isEmpty()) {
            StringBuffer queryString = new StringBuffer();
            Iterator it = parameterMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String name = (String)entry.getKey();
                String value = String.valueOf(entry.getValue());
                queryString.append(URLEncoder.encode(name));
                if (value != null && !value.equals("")) {
                    queryString.append('=');
                    queryString.append(URLEncoder.encode(value));
                }
                if (!it.hasNext()) continue;
                queryString = quoteAmpersands ? queryString.append("\"&\"") : queryString.append('&');
            }
            return queryString.toString();
        }
        return null;
    }

    public static String escapeSpace(String uri) {
        return URLHelper.escapeCharacter(uri, ' ', "%20");
    }

    public static String escapeCharacter(String uri, char c, String to) {
        int i;
        StringBuffer sb = new StringBuffer();
        int size = uri.length();
        int at = uri.indexOf(58);
        int lastAt = 0;
        if (at > -1) {
            for (i = 0; i <= at; ++i) {
                sb.append(uri.charAt(i));
            }
            lastAt = ++at;
        }
        while ((at = uri.indexOf(c, at)) > -1) {
            for (i = lastAt; i < at; ++i) {
                sb.append(uri.charAt(i));
            }
            sb.append(to);
            lastAt = ++at;
        }
        if (lastAt < size) {
            for (i = lastAt; i < size; ++i) {
                sb.append(uri.charAt(i));
            }
        }
        return sb.toString();
    }
}

