/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.authoring.debug.model;

import com.adobe.authoring.debug.AuthDebugException;
import com.adobe.authoring.debug.AuthDebugMgr;
import com.adobe.authoring.debug.model.AuthDebugElement;
import com.adobe.authoring.debug.model.AuthDebugTarget;
import com.adobe.authoring.debug.model.AuthStackFrame;
import com.adobe.authoring.debug.model.AuthValue;
import com.adobe.authoring.debug.model.DebugElementNoLongerExistsException;
import com.adobe.authoring.debug.model.IAuthValue;
import com.adobe.authoring.debug.model.IAuthVariable;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.Variable;
import flash.tools.debugger.events.FaultEvent;

public abstract class AuthVariable
extends AuthDebugElement
implements IAuthVariable {
    private final String fName;
    private AuthValue fValue;
    protected Variable fUnderlyingVariable;
    private boolean fHasValueChanged = false;
    private boolean fScopeChainMember;

    public AuthVariable(AuthDebugTarget debugTarget, Variable underlyingVariable, String name) {
        super(debugTarget);
        this.fUnderlyingVariable = underlyingVariable;
        this.fName = name.intern();
        try {
            this.createAuthValue();
        }
        catch (DebugElementNoLongerExistsException e) {
            AuthDebugMgr.log(e);
        }
    }

    public String getDisplayName() throws DebugElementNoLongerExistsException, AuthDebugException {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAuthValue getValue() throws DebugElementNoLongerExistsException {
        Object object = this.getLock();
        synchronized (object) {
            this.syncValue();
            if (this.fValue == null) {
                throw new DebugElementNoLongerExistsException(1);
            }
            return this.fValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void syncValue() {
        Object object = this.getLock();
        synchronized (object) {
            boolean suspended = this.getAuthDebugTarget().isSuspended();
            if (this.fValue == null || !this.isStateSynchronized() && suspended) {
                String newValueString;
                String oldValueString;
                AuthValue oldValue;
                block8: {
                    oldValue = this.fValue;
                    try {
                        Variable currentUnderlyingVariable = this.getFlashVariable();
                        if (this.fValue != null && currentUnderlyingVariable == this.fUnderlyingVariable) break block8;
                        this.fUnderlyingVariable = currentUnderlyingVariable;
                        this.createAuthValue();
                    }
                    catch (DebugElementNoLongerExistsException e) {
                        String newValueString2;
                        String oldValueString2;
                        this.synchronizeState();
                        this.fHasValueChanged = oldValue == null != (this.fValue == null) ? true : (oldValue == this.fValue ? false : !(oldValueString2 = oldValue.getValueString()).equals(newValueString2 = this.fValue.getValueString()));
                        catch (Throwable throwable) {
                            String newValueString3;
                            String oldValueString3;
                            this.synchronizeState();
                            this.fHasValueChanged = oldValue == null != (this.fValue == null) ? true : (oldValue == this.fValue ? false : !(oldValueString3 = oldValue.getValueString()).equals(newValueString3 = this.fValue.getValueString()));
                            throw throwable;
                        }
                    }
                }
                this.synchronizeState();
                this.fHasValueChanged = oldValue == null != (this.fValue == null) ? true : (oldValue == this.fValue ? false : !(oldValueString = oldValue.getValueString()).equals(newValueString = this.fValue.getValueString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAuthValue() throws DebugElementNoLongerExistsException {
        Object object = this.getLock();
        synchronized (object) {
            this.fValue = new AuthValue(this.getAuthDebugTarget(), this, this.fUnderlyingVariable);
        }
    }

    public IAuthVariable[] getNestedMembers() {
        return this.fValue.getVariables();
    }

    public String getName() {
        return this.fName;
    }

    public String getReferenceTypeName() {
        try {
            return ((AuthValue)this.getValue()).getReferenceTypeName();
        }
        catch (DebugElementNoLongerExistsException e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasValueChanged() throws Exception {
        Object object = this.getLock();
        synchronized (object) {
            this.syncValue();
            return this.fHasValueChanged;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String expression) throws AuthDebugException {
        Object object = this.getLock();
        synchronized (object) {
            AuthValue value = (AuthValue)this.getValue();
            int flashType = value.getFlashVariableType();
            try {
                FaultEvent faultEvent = this.getFlashVariable().setValue(this.getAuthDebugTarget().getSession(), flashType, expression);
                this.getAuthDebugTarget().stateChanged();
                if (faultEvent != null) {
                    throw new AuthDebugException(faultEvent.information, null);
                }
            }
            catch (NotSuspendedException e) {
                throw this.newAuthDebugException("Error setting value of variable", e);
            }
            catch (NoResponseException e) {
                throw this.newAuthDebugException("Error setting value of variable", e);
            }
            catch (NotConnectedException e) {
                throw this.newAuthDebugException("Error setting value of variable", e);
            }
            catch (DebugElementNoLongerExistsException e) {
                throw this.newAuthDebugException("Error setting value of variable", e);
            }
        }
    }

    public void setValue(IAuthValue value) throws AuthDebugException {
        this.setValue(value.getValueString());
    }

    public boolean supportsValueModification() {
        if (this.getParentVarId() == -1) {
            return false;
        }
        try {
            Variable var = this.getFlashVariable();
            if (var.isAttributeSet(4)) {
                return false;
            }
            AuthValue val = (AuthValue)this.getValue();
            if (!val.isScalar()) {
                return false;
            }
        }
        catch (DebugElementNoLongerExistsException e) {
            return false;
        }
        return true;
    }

    private PreliminaryCompareResult preliminaryCompare(AuthVariable other) {
        int otherParentVarId;
        if (this == other) {
            return PreliminaryCompareResult.EQUAL;
        }
        int thisParentVarId = this.getParentVarId();
        int parentDiff = thisParentVarId - (otherParentVarId = other.getParentVarId());
        if (parentDiff != 0) {
            return parentDiff < 0 ? PreliminaryCompareResult.LESS : PreliminaryCompareResult.GREATER;
        }
        if (this.getName() == other.getName()) {
            return PreliminaryCompareResult.EQUAL;
        }
        return PreliminaryCompareResult.DIFFERENT_MEMBERS_OF_SAME_PARENT;
    }

    public int compareTo(Object otherObj) {
        String otherNameWithUnderscoresAfterLetters;
        String otherNameWithoutUnderscores;
        boolean otherArray;
        AuthVariable other = (AuthVariable)otherObj;
        PreliminaryCompareResult compareResult = this.preliminaryCompare(other);
        if (compareResult == PreliminaryCompareResult.EQUAL) {
            return 0;
        }
        if (compareResult == PreliminaryCompareResult.LESS) {
            return -1;
        }
        if (compareResult == PreliminaryCompareResult.GREATER) {
            return 1;
        }
        String myName = this.getName();
        String otherName = other.getName();
        int myArrayIndex = this.asArrayIndex();
        int otherArrayIndex = other.asArrayIndex();
        boolean meArray = myArrayIndex >= 0;
        boolean bl = otherArray = otherArrayIndex >= 0;
        if (meArray != otherArray) {
            return meArray ? -1 : 1;
        }
        if (meArray && otherArray && myArrayIndex != otherArrayIndex) {
            return myArrayIndex - otherArrayIndex;
        }
        String myNameWithoutUnderscores = myName.replaceAll("_", "");
        int compare = myNameWithoutUnderscores.compareToIgnoreCase(otherNameWithoutUnderscores = otherName.replaceAll("_", ""));
        if (compare != 0) {
            return compare;
        }
        compare = myNameWithoutUnderscores.compareTo(otherNameWithoutUnderscores);
        if (compare != 0) {
            return compare;
        }
        String myNameWithUnderscoresAfterLetters = myName.replace('_', '\uffff');
        compare = myNameWithUnderscoresAfterLetters.compareToIgnoreCase(otherNameWithUnderscoresAfterLetters = otherName.replace('_', '\uffff'));
        if (compare != 0) {
            return compare;
        }
        compare = myNameWithUnderscoresAfterLetters.compareTo(otherNameWithUnderscoresAfterLetters);
        if (compare != 0) {
            return compare;
        }
        compare = myName.compareToIgnoreCase(otherName);
        if (compare != 0) {
            return compare;
        }
        return myName.compareTo(otherName);
    }

    public boolean equals(Object o) {
        if (!(o instanceof AuthVariable)) {
            return false;
        }
        AuthVariable other = (AuthVariable)o;
        PreliminaryCompareResult compareResult = this.preliminaryCompare(other);
        if (compareResult != PreliminaryCompareResult.EQUAL) {
            return false;
        }
        AuthDebugElement thisParent = this.getParent();
        AuthDebugElement otherParent = other.getParent();
        return !(thisParent == null ? otherParent != null : !thisParent.equals(otherParent));
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public int getAttributes() {
        return this.fUnderlyingVariable.getAttributes();
    }

    public String toString() {
        try {
            return this.getValue().getValueString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public int asArrayIndex() {
        return -1;
    }

    public abstract Variable getFlashVariable() throws DebugElementNoLongerExistsException;

    protected abstract int getParentVarId();

    protected abstract AuthStackFrame getParentFrame();

    public boolean hasGetter() {
        return (this.getAttributes() & 0x80000) != 0;
    }

    public boolean hasSetter() {
        return (this.getAttributes() & 0x100000) != 0;
    }

    public boolean isConst() {
        return (this.getAttributes() & 0x400000) != 0;
    }

    public boolean isLocal() {
        return (this.getAttributes() & 0x20) != 0;
    }

    public boolean isArgument() {
        return (this.getAttributes() & 0x10000) != 0;
    }

    public boolean isStatic() {
        return (this.getAttributes() & 0x200000) != 0;
    }

    public boolean isDynamic() {
        return (this.getAttributes() & 0x20000) != 0;
    }

    public int getScope() {
        try {
            return this.getFlashVariable().getScope();
        }
        catch (DebugElementNoLongerExistsException e) {
            return 0;
        }
    }

    public String getNamespace() {
        try {
            return this.getFlashVariable().getNamespace();
        }
        catch (DebugElementNoLongerExistsException e) {
            return "";
        }
    }

    public boolean isScopeChainMember() {
        return this.fScopeChainMember;
    }

    public void setScopeChainMember(boolean b) {
        this.fScopeChainMember = b;
    }

    private static class PreliminaryCompareResult {
        public static PreliminaryCompareResult EQUAL = new PreliminaryCompareResult();
        public static PreliminaryCompareResult DIFFERENT_MEMBERS_OF_SAME_PARENT = new PreliminaryCompareResult();
        public static PreliminaryCompareResult LESS = new PreliminaryCompareResult();
        public static PreliminaryCompareResult GREATER = new PreliminaryCompareResult();

        private PreliminaryCompareResult() {
        }
    }
}

